setwd("/Volumes/MyBookStudio/BD_aging_project/Heart/H3K4me3_breadth")
source('/Users/benayoun/Softwares/Breadth_compare_bundle/Compare_ECDFs_Cov.R')
# the script is in Breadth_compare_bundle subdirectory, "Figure1_General/Breadth_compare_bundle"


density.per.peak.3m1  <- read.csv('hists/3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")
density.per.peak.3m2  <- read.csv('hists/3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")
density.per.peak.12m1 <- read.csv('hists/12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")
density.per.peak.12m2 <- read.csv('hists/12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")
density.per.peak.29m1 <- read.csv('hists/29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")
density.per.peak.29m2 <- read.csv('hists/29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS_cov_regions.bed',header=F,sep="\t")

# extract only the summary histogram
my.hist.3m1 <- density.per.peak.3m1[which(density.per.peak.3m1$V1 == 'all'),]
my.hist.3m2 <- density.per.peak.3m2[which(density.per.peak.3m2$V1 == 'all'),]
my.hist.12m1 <- density.per.peak.12m1[which(density.per.peak.12m1$V1 == 'all'),]
my.hist.12m2 <- density.per.peak.12m2[which(density.per.peak.12m2$V1 == 'all'),]
my.hist.29m1 <- density.per.peak.29m1[which(density.per.peak.29m1$V1 == 'all'),]
my.hist.29m2 <- density.per.peak.29m2[which(density.per.peak.29m2$V1 == 'all'),]

# compute the cdf function
my.cdf.3m1 <- hist2cdf(my.hist.3m1)
my.cdf.3m2 <- hist2cdf(my.hist.3m2)
my.cdf.12m1 <- hist2cdf(my.hist.12m1)
my.cdf.12m2 <- hist2cdf(my.hist.12m2)
my.cdf.29m1 <- hist2cdf(my.hist.29m1)
my.cdf.29m2 <- hist2cdf(my.hist.29m2)


pdf("ECDFs_Heart_Pre_adj_on_mergedCalling.pdf")
plot(0:39,my.cdf.3m1[1:40],type='l',col="darkblue",ylim=c(0,1),xlab="Coverage (X)",ylab="ECDF of H3K4me3 reference peak coverage")
lines(0:39,my.cdf.3m2[1:40],type='l',col="cadetblue")
lines(0:39,my.cdf.12m1[1:40],type='l',col="tomato")
lines(0:39,my.cdf.12m2[1:40],type='l',col="coral1")
lines(0:39,my.cdf.29m1[1:40],type='l',col="darkgreen")
lines(0:39,my.cdf.29m2[1:40],type='l',col="green")
legend("bottomright",c("3 mths (rep 2)","3 mths (rep 3)","12 mths (rep 1)","12 mths (rep 2)","29 mths (rep 1)","29 mths (rep 2)"),
       col=c("darkblue","cadetblue","tomato","coral1","darkgreen","green"),bty='n',pch='_',cex = 0.75 ,pt.cex=1.5)
dev.off()


# Based on visual, Heart29m2 is the "lowest" curve to which other samples need to be adjusted to
Heart3m1.cdf <- calibrate_CDFs("3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "40 % downsampling, index : 8"
Heart3m2.cdf <- calibrate_CDFs("3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "65 % downsampling, index : 13"
Heart12m1.cdf <- calibrate_CDFs("12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "55 % downsampling, index : 11"
Heart12m2.cdf <- calibrate_CDFs("12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "35 % downsampling, index : 7"
Heart29m1.cdf <- calibrate_CDFs("29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "45 % downsampling, index : 9"
Heart29m2.cdf <- calibrate_CDFs("29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS",".",my.hist.29m2,"Heart29m2") # "100 % downsampling, index : 20"

# plot adjusted CDFs
pdf("ECDFs_Heart_POST_adj_on_mergedCalling.pdf")
plot(0:39,Heart3m1.cdf[[8]][1:40],type='l',col="darkblue",ylim=c(0,1),xlab="Coverage (X)",ylab="ECDF of H3K4me3 reference peak coverage")
lines(0:39,Heart3m2.cdf[[13]][1:40],type='l',col="cadetblue")
lines(0:39,Heart12m1.cdf[[11]][1:40],type='l',col="tomato")
lines(0:39,Heart12m2.cdf[[7]][1:40],type='l',col="coral1")
lines(0:39,Heart29m1.cdf[[9]][1:40],type='l',col="darkgreen")
lines(0:39,Heart29m2.cdf[[20]][1:40],type='l',col="green")
legend("bottomright",c("3 mths (rep 2) 40% DS","3 mths (rep 3) 65% DS","12 mths (rep 1) 55% DS","12 mths (rep 2) 35% DS","29 mths (rep 1) 45% DS","29 mths (rep 2) 100% DS"),
       col=c("darkblue","cadetblue","tomato","coral1","darkgreen","green"),bty='n',pch='_',cex = 0.75 ,pt.cex=1.5)
dev.off()
