setwd('/Volumes/MyBook_3/BD_aging_project/ChIP-seq/Heart/H3K27ac_height_heart')
# 2015-11-30, height changes analysis diffbind
# will be further modeled as linear of age in DEseq2

load("/Volumes/MyBook_3/BD_aging_project/ChIP-seq/Heart/H3K27ac_height/H3K27ac_height_data.RData")

library('DiffBind')
library("rtracklayer")

################################################################################
####################   Diffbind Analysis : H3K27ac height  ####################
################################################################################

heart.aging <- dba(sampleSheet="Heart_FIXSEQ_exp_K27ac_Enhancers.csv",skipLines=1,attributes=c(DBA_ID,DBA_CONDITION))
heart.aging <- dba.count(heart.aging)


pdf("Heart_aging_H3K27ac_height_clust_heatmap.pdf")
plot(heart.aging, colScheme="Reds")
dev.off()

heart.aging <- dba.contrast(heart.aging, categories=DBA_CONDITION,minMembers=2)
heart.aging <- dba.analyze(heart.aging,method=DBA_ALL_METHODS)
heart.aging
# 
# 6 Contrasts:
#   Group1 Members1 Group2 Members2 DB.edgeR DB.DESeq DB.DESeq2
# 1     3m        2    12m        2     8028     2153      2197
# 2     3m        2    29m        2     2827      712       968
# 3     3m        2    !3m        4     1297       18       182
# 4    12m        2    29m        2     5669     2259      2830
# 5    12m        2   !12m        4     2042      406      1833
# 6    29m        2   !29m        4     3439      907      2859

#############
# DESeq2 table norm needed for linear modeling
# export normalized counts

write.table(heart.aging$allvectors,file="Heart_Diffbind_matrix_H3K27ac_concentration_forS2norm.txt",quote=F,row.names=F,sep="\t")
