setwd('/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/All_tissues_analysis/H3K4me3_Height_aging_linear_modeling/')
source('height_analysis_functions_linear_v3PCA.R')

# input files are in Figure1_General/ChIP-seq_processing/All_tissues/H3K4me3_height/Annotated_peak_files (Diffbind outputs)
# and /Figure1_General/ChIP-seq_processing/All_tissues/H3K4me3_height/Height_files (annotated peak names)


####################################    Liver    #################################### 
# read in Diffbind vector matrix
my.liver.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Liver/H3K4me3_height_liver/Liver_Diffbind_matrix_concentration_forS2norm.txt",header=T,sep="\t")
my.liver <- my.liver.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.liver) <- paste(my.liver.data[,1],my.liver.data[,2],my.liver.data[,3],sep="-")
colnames(my.liver) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.liver.height.process <- process_aging_height("Liver", my.liver, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Liver/H3K4me3_height_liver/HOMER_Liver_Diffbind_peaks_coord.xls")
save(my.liver.height.process, file="H3K4me3_height_result_Liver_2018-03-09.RData")
##################################################################################### 


####################################    heart    #################################### 
# read in Diffbind vector matrix
my.heart.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Heart/H3K4me3_height_heart/Heart_Diffbind_matrix_concentration_forS2norm.txt",header=T,sep="\t")
my.heart <- my.heart.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.heart) <- paste(my.heart.data[,1],my.heart.data[,2],my.heart.data[,3],sep="-")
colnames(my.heart) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.heart.height.process <- process_aging_height("heart", my.heart, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Heart/H3K4me3_height_heart/HOMER_Heart_Diffbind_peaks_coord.xls")
save(my.heart.height.process, file="H3K4me3_height_result_heart_2018-03-09.RData")
##################################################################################### 


####################################    cerebellum    #################################### 
# read in Diffbind vector matrix
my.cerebellum.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Cerebellum/H3K4me3_height_cerebellum/Cerebellum_Diffbind_matrix_concentration_forS2norm.txt",header=T,sep="\t")
my.cerebellum <- my.cerebellum.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.cerebellum) <- paste(my.cerebellum.data[,1],my.cerebellum.data[,2],my.cerebellum.data[,3],sep="-")
colnames(my.cerebellum) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.cerebellum.height.process <- process_aging_height("cerebellum", my.cerebellum, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Cerebellum/H3K4me3_height_cerebellum/HOMER_Cerebellum_Diffbind_peaks_coord.xls")
save(my.cerebellum.height.process, file="H3K4me3_height_result_cerebellum_2018-03-09.RData")
##################################################################################### 


####################################    OB    #################################### 
# read in Diffbind vector matrix
my.OB.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Olfactory_Bulb/H3K4me3_height_OB/OB_Diffbind_matrix_concentration_forS2norm_NEW.txt",header=T,sep="\t")
my.OB <- my.OB.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.OB) <- paste(my.OB.data[,1],my.OB.data[,2],my.OB.data[,3],sep="-")
colnames(my.OB) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.OB.height.process <- process_aging_height("OB", my.OB, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Olfactory_Bulb/H3K4me3_height_OB/HOMER_OB_Diffbind_peaks_coord.xls")
#save(my.OB.height.process, file="H3K4me3_height_result_OB_2015-11-30.RData")
save(my.OB.height.process, file="H3K4me3_height_result_OB_2018-03-09.RData")
##################################################################################### 



####################################    NPCs    #################################### 
# read in Diffbind vector matrix for the COMBINED (will have to apply batch correction in model)
my.NPCs.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/NPC_cultures/New_rep_5_6/Combined_height/NPC_combined_Diffbind_matrix_concentration_forS2norm.txt",header=T,sep="\t")
my.cols <- c(4:5,10:11,6:7,12:13,8:9,14:15) # reorder by age group
my.NPCs <- my.NPCs.data[,my.cols]

# generate unique rownames based on peak coordinates
rownames(my.NPCs) <- paste(my.NPCs.data[,1],my.NPCs.data[,2],my.NPCs.data[,3],sep="-")
colnames(my.NPCs) <- c("3m1","3m2","3m5","3m6","12m1","12m2","12m5","12m6","29m1","29m2","29m5","29m6")

my.batch.per.seq <- factor(paste("experiment",rep(c(1,1,2,2),3),sep=""))

# process data and save RData NPCsject
my.NPCs.height.process.batch <- process_aging_height_batch("NPCs", my.NPCs, 
                                                     "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/NPC_cultures/New_rep_5_6/Combined_height/HOMER_NPC_combined_Diffbind_peaks_coord.xls",
                                                     my.batch.per.seq)
save(my.NPCs.height.process.batch, file="H3K4me3_height_result_NPCs-combined_2018-03-09.RData")
##################################################################################### 

