setwd('/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/All_tissues_analysis/H3K27ac_Height_aging_linear_modeling/')
source('H3K27ac_height_analysis_functions_linear_v3PCA.R')

# 2015-12-02: new analysis for H3K27ac height, will take advantage of linear models in DESeq2
# 2016-02-24: rerun for OB and NPC (resequencing for depth)
# 2018-03-09: rerun to include PCA plotting for Anne

####################################    Liver    #################################### 
# read in Diffbind vector matrix
my.liver.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Liver/H3K27ac_height_liver/Liver_Diffbind_matrix_H3K27ac_concentration_forS2norm.txt",header=T,sep="\t")
my.liver <- my.liver.data[,4:9]

# generate unique rownames based on peak coordinates
rownames(my.liver) <- paste(my.liver.data[,1],my.liver.data[,2],my.liver.data[,3],sep="-")
colnames(my.liver) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.liver.height.process <- process_aging_height("Liver", my.liver, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Liver/H3K27ac_height_liver/HOMER_Liver_Diffbind_H3K27ac_peaks_coord.xls")
save(my.liver.height.process, file="H3K27ac_height_result_Liver_2018-03-09.RData")
# All changed domains   decreased domains   increased domains 
#       4890                2859                2031 
##################################################################################### 


####################################    Heart    #################################### 
# read in Diffbind vector matrix
my.Heart.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Heart/H3K27ac_height_heart/Heart_Diffbind_matrix_H3K27ac_concentration_forS2norm.txt",header=T,sep="\t")
my.Heart <- my.Heart.data[,4:9]

# generate unique rownames based on peak coordinates
rownames(my.Heart) <- paste(my.Heart.data[,1],my.Heart.data[,2],my.Heart.data[,3],sep="-")
colnames(my.Heart) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.Heart.height.process <- process_aging_height("Heart", my.Heart, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Heart/H3K27ac_height_heart/HOMER_Heart_Diffbind_H3K27ac_peaks_coord.xls")
save(my.Heart.height.process, file="H3K27ac_height_result_Heart_2018-03-09.RData")
# All changed domains   decreased domains   increased domains 
#  447                 208                 239 
##################################################################################### 


####################################    Cerebellum    #################################### 
# read in Diffbind vector matrix
my.Cerebellum.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Cerebellum/H3K27ac_height/Cerebellum_Diffbind_matrix_H3K27ac_concentration_forS2norm.txt",header=T,sep="\t")
my.Cerebellum <- my.Cerebellum.data[,4:9]

# generate unique rownames based on peak coordinates
rownames(my.Cerebellum) <- paste(my.Cerebellum.data[,1],my.Cerebellum.data[,2],my.Cerebellum.data[,3],sep="-")
colnames(my.Cerebellum) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.Cerebellum.height.process <- process_aging_height("Cerebellum", my.Cerebellum, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Cerebellum/H3K27ac_height/HOMER_Cerebellum_Diffbind_H3K27ac_peaks_coord.xls")
save(my.Cerebellum.height.process, file="H3K27ac_height_result_Cerebellum_2018-03-09.RData")
# All changed domains   decreased domains   increased domains 
# 6135                4865                1270
##################################################################################### 


####################################    Olfactory_Bulb    #################################### 
# read in Diffbind vector matrix
my.OB.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Olfactory_Bulb/H3K27ac_height_OB/OB_Diffbind_matrix_H3K27ac_concentration_forS2norm_PooledLanes.txt",header=T,sep="\t")
my.OB <- my.OB.data[,4:9]

# generate unique rownames based on peak coordinates
rownames(my.OB) <- paste(my.OB.data[,1],my.OB.data[,2],my.OB.data[,3],sep="-")
colnames(my.OB) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData object
my.OB.height.process <- process_aging_height("OB", my.OB, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Olfactory_Bulb/H3K27ac_height_OB/HOMER_OB_Diffbind_H3K27ac_PooledLanes_peaks_coord.xls")
save(my.OB.height.process, file="H3K27ac_height_result_OB_2018-03-09.RData")
# All changed domains   decreased domains   increased domains 
#71                  64                   7 
##################################################################################### 



####################################   NPCs   #################################### 
# read in Diffbind vector matrix
my.NPCs.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/NPC_cultures/H3K27ac_height_NPCs/NPCs_Diffbind_matrix_H3K27ac_PooledLanes_concentration_forS2norm.txt",header=T,sep="\t")
my.NPCs <- my.NPCs.data[,4:9]

# generate unique rownames based on peak coordinates
rownames(my.NPCs) <- paste(my.NPCs.data[,1],my.NPCs.data[,2],my.NPCs.data[,3],sep="-")
colnames(my.NPCs) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data and save RData NPCsject
### batch effect between 1st and second wave libraries (a vs. b)
my.NPCs.height.process <- process_aging_height_batch("NPCs", my.NPCs, "/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/NPC_cultures/H3K27ac_height_NPCs/HOMER_NPCs_Diffbind_H3K27ac_PooledLanes_peaks_coord.xls",
                                                   c("a","b","a","b","a","b"))

save(my.NPCs.height.process, file="H3K27ac_height_result_NPCs_2018-03-09.RData")
# All changed domains   decreased domains   increased domains 
#           0                   0                   0 
##################################################################################### 
