setwd('/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/All_tissues_analysis/Breadth_aging_linear_modeling')
source("/Users/benayoun/Softwares/Breadth_compare_bundle/DiffBreadthFun.R")
# DiffBreadthFun.R script in in "Figure1_General/Breadth_compare_bundle"
source('breadth_analysis_functions_linear_v4PCA.R')


### Input files are found in "Figure1_General/ChIP-seq_processing/All_tissues/Breadth_modeling/Breadth_Files"


####################################    Liver    #################################### 
# read in breadth matrix
my.Liver.breadth.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Liver/H3K4me3_breadth/Merged_ALL_AGES_MERGED_Liver_H3K4me3.PARSED_INTERSECTIONS.xls",header=T,sep="\t")
my.cols <- c(10,13,16,19,22,25)
my.liver <- my.Liver.breadth.data[,my.cols]
rownames(my.liver) <- my.Liver.breadth.data[,1]
colnames(my.liver) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process Breadth data and save RData object
my.liver.breadth.process <- process_aging_breadth("Liver", my.liver, my.Liver.breadth.data)
save(my.liver.breadth.process, file="Breadth_result_Liver_2018-03-09.RData")
##################################################################################### 


####################################    Heart    #################################### 
# read in breadth matrix
my.Heart.breadth.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Heart/H3K4me3_breadth/Merged_ALL_AGES_MERGED_Heart_H3K4me3.PARSED_INTERSECTIONS.xls",header=T,sep="\t")
my.cols <- c(10,13,16,19,22,25)
my.heart <- my.Heart.breadth.data[,my.cols]
rownames(my.heart) <- my.Heart.breadth.data[,1]
colnames(my.heart) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process Breadth data and save RData object
my.heart.breadth.process <- process_aging_breadth("heart", my.heart, my.Heart.breadth.data)
save(my.heart.breadth.process, file="Breadth_result_heart_2018-03-09.RData")
##################################################################################### 


####################################    Cerebellum    #################################### 
# read in breadth matrix
my.cereb.breadth.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Cerebellum/H3K4me3_breadth/Merged_ALL_AGES_MERGED_Cerebellum_H3K4me3.PARSED_INTERSECTIONS.xls",header=T,sep="\t")
my.cols <- c(10,13,16,19,22,25)
my.cereb <- my.cereb.breadth.data[,my.cols]
rownames(my.cereb) <- my.cereb.breadth.data[,1]
colnames(my.cereb) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process Breadth data and save RData object
my.cereb.breadth.process <- process_aging_breadth("cereb", my.cereb, my.cereb.breadth.data)
save(my.cereb.breadth.process, file="Breadth_result_cereb_2018-03-09.RData")
##################################################################################### 



####################################    Olfactory Bulb    #################################### 
# read in breadth matrix
my.ob.breadth.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/Olfactory_Bulb/H3K4me3_Breadth/Merged_ALL_AGES_MERGED_OB_H3K4me3.PARSED_INTERSECTIONS.xls",header=T,sep="\t")
my.cols <- c(10,13,16,19,22,25)
my.ob <- my.ob.breadth.data[,my.cols]
rownames(my.ob) <- my.ob.breadth.data[,1]
colnames(my.ob) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process Breadth data and save RData object
my.ob.breadth.process <- process_aging_breadth("ob", my.ob, my.ob.breadth.data)
save(my.ob.breadth.process, file="Breadth_result_ob_2018-03-09.RData")
##################################################################################### 


####################################   NPCs    #################################### 
# # read in breadth matrix
# read in breadth matrix, combined
my.NPC_All.breadth.data <- read.table("/Volumes/BB_Backup_3/BD_aging_project/ChIP-seq/NPC_cultures/New_rep_5_6/Combined_breadth/Merged_ALL_AGES_MERGED_CombinedNPC_H3K4me3.PARSED_INTERSECTIONS.xls",header=T,sep="\t")
my.cols <- c(10,13,16,19,22,25,28,31,34,37,40,43)
my.npc <- my.NPC_All.breadth.data[,my.cols]
rownames(my.npc) <- my.NPC_All.breadth.data[,1]
colnames(my.npc) <- c("3m1","3m2","3m5","3m6","12m1","12m2","12m5","12m6","29m1","29m2","29m5","29m6")

my.batch.per.seq <- factor(paste("experiment",rep(c(1,1,2,2),3),sep=""))

# process Breadth data and save RData object
my.npc.breadth.process.batch <- process_aging_breadth_batch("NPC_Combined_per_lane", my.npc, my.NPC_All.breadth.data, my.batch.per.seq)
save(my.npc.breadth.process.batch, file="Breadth_result_npc.ALL.batchperlane_2018-03-09.RData")
##################################################################################### 

