#! /usr/bin/perl

use warnings;
use strict;
use Statistics::Descriptive;
use List::Util qw(sum);

###############################################
# USAGE STATEMENT
unless (scalar @ARGV >= 3) {
	die "\nIncorrect command line arguments.\n".
		"Usage : merge_coverage_files.pl <IntersectBed file 1>... <IntersectBed file  n>.\n";
}
###############################################

###############################################
# 0. Parse command line arguments
# file that contains annotation of reference peaks
my $Homerfile = shift @ARGV;
my @intersectBeds = @ARGV;

###############################################


###############################################
# 1. Parse annotated merged reference peaks
my %annot_hash = ();

open (HOMER,$Homerfile) or die "Couldn't open $Homerfile: $!\n";

my $headerline = <HOMER>;

my @headerdata = get_line_data ($headerline);
my $newheaderline = "Peak_Name\t$headerdata[1]\t$headerdata[2]\t$headerdata[3]\t$headerdata[10]\t$headerdata[11]\t$headerdata[15]";

while (my $line = <HOMER>) {
	my @linedata = get_line_data ($line);
	
	unless ($linedata[1] =~ /chrM/) {	
		$annot_hash{$linedata[0]} = "$linedata[0]\t$linedata[1]\t$linedata[2]\t$linedata[3]\t$linedata[10]\t$linedata[11]\t$linedata[15]";
	}
	#print $linedata[0]."::\n";
}

close HOMER;
###############################################



###############################################
# 2. Parse intersected Bed files

my @names = ();
my %overlap_hash = ();

my $file_idx = 0;

foreach my $file (@intersectBeds) {

	push (@names, $file);

	open (FILE,$file) or die "Couldn't open $file: $!\n";

	while (my $line = <FILE>) {
			
		my @linedata = get_line_data ($line);
		
		next if ($linedata[0] eq "chrM");
		
		#print $linedata[3]."::\n";
		
		# autovivify if this is the first loop
		push(@{ $overlap_hash{$linedata[3]} } ,$linedata[4]);
		# the array that is the $file_idx-th element of the array or arrays
		
		#print"@{ $overlap_hash{$linedata[3]} }\n";
		
	}

	close FILE;
	++$file_idx;

}

###############################################


###############################################
# 3. Output result

for (my $i = 0; $i < $file_idx; ++$i) {
	$newheaderline .= "\tCoverage_NUMBER_$names[$i]";
}

print $newheaderline."\n";

foreach my $key (sort keys %annot_hash) {
	
	my $annotation = $annot_hash{$key};
	
	#print $key."\n";
	
	my $remainingfields = "";
	#chomp $key;
	
	my @overlaps = @{ $overlap_hash{$key} };
	my $overout = join("\t",@overlaps);
		
	$remainingfields .= "\t".$overout ; # leading tab to account for joining

	
	my $outline = $annotation.$remainingfields;

	print $outline."\n";
	
}

###############################################


exit;

#####################################
######      SUBROUTINES        ######
#####################################

###########################################################
# a subroutine that separates fields from a data line and
# returns them in an array

sub get_line_data {

    my $line = $_[0];
    
    chomp $line;
    
    my @linedata = split(/\t/, $line);
       
    return @linedata;
}
