# The next 2 functions were modified from ROSE code (Rick Young lab)
# This function calculates the cutoff by sliding a diagonal line and finding where it is tangential (or as close as possible)
calculate_cutoff <- function(inputVector, samplename){
  inputVector <- sort(inputVector)
  inputVector[inputVector<0]<-0 #set those regions with more control than ranking equal to zero
  slope <- (max(inputVector)-min(inputVector))/length(inputVector) #This is the slope of the line we want to slide. This is the diagonal.
  xPt <- floor(optimize(numPts_below_line,lower=1,upper=length(inputVector),myVector= inputVector,slope=slope)$minimum) #Find the x-axis point where a line passing through that point has the minimum number of points below it. (ie. tangent)
  y_cutoff <- inputVector[xPt] #The y-value at this x point. This is our cutoff.
  
  pdfname <- paste(samplename,"_Super_Enhancer_plot.pdf",sep="")
  
  pdf(pdfname)
  plot(1:length(inputVector), inputVector, type="l")
  b <- y_cutoff-(slope* xPt)
  abline(v= xPt,h= y_cutoff,lty=2,col=8)
  points(xPt,y_cutoff,pch=16,cex=0.9,col=2)
  abline(coef=c(b,slope),col=2)
  title(paste("x=",xPt,"\ny=",signif(y_cutoff,3),"\nFold over Median=",signif(y_cutoff/median(inputVector),3),"x\nFold over Mean=",signif(y_cutoff/mean(inputVector),3),"x",sep=""))
  axis(1,sum(inputVector==0),sum(inputVector==0),col.axis="pink",col="pink") #Number of regions with zero signal
  dev.off()
  
  return(list(absolute=y_cutoff,overMedian=y_cutoff/median(inputVector),overMean=y_cutoff/mean(inputVector)))
}

numPts_below_line <- function(myVector,slope,x){
  yPt <- myVector[x]
  b <- yPt-(slope*x)
  xPts <- 1:length(myVector)
  return(sum(myVector<=(xPts*slope+b)))
}


get_sample_se <- function(my.intnorm, my.k27.mat, my.name){

	my.sort <- sort(my.intnorm,index.return=T,decreasing=T)
	my.out.name <- paste(my.name,"_H3K27ac_MACS_Se-Lite",sep="")
	
	cutoff_options.cb <- calculate_cutoff(my.intnorm[my.sort$ix], my.out.name)
	superEnhancerRows.cb <- which(my.intnorm > cutoff_options.cb$absolute)
	typicalEnhancers.cb <- setdiff(1:length(my.sort$ix),superEnhancerRows.cb)
	
	my.status <- c(rep("Super",length(superEnhancerRows.cb)), rep("Typical",length(my.sort$ix)-length(superEnhancerRows.cb)) )
	
	my.data <- cbind(my.k27.mat[my.sort$ix,c(2,3,4,1,5,6,7)],my.status)
	
	my.out.name <- paste("Annotated_",my.name,"_H3K27ac.SuperEnhancers-Lite.xls",sep="")
	write.table(my.data, file=my.out.name,sep="\t",quote=F,row.names=F,col.names=F)
	
	my.out.name <- paste("SuperEnhancers-Lite_",my.name,"_H3K27ac_broad_peaks.stitched.bed",sep="")
	write.table(my.data[1:length(superEnhancerRows.cb),1:4], file=my.out.name,sep="\t",quote=F,row.names=F,col.names=F)

	my.out.name <- paste("TypicalEnhancers-Lite_",my.name,"_H3K27ac_broad_peaks.stitched.bed",sep="")
	write.table(my.data[(1+length(superEnhancerRows.cb)):length(my.sort$ix),1:4], file=my.out.name,sep="\t",quote=F,row.names=F,col.names=F)
	
	print(length(superEnhancerRows.cb))
	superEnhancerRows.cb
	
}
