import sys
import re

#Save dictionary that will be used to map multiplexing tags to time points,
#BC sequences to plasmids
#SDS sequences to gRNA from CRISPRi
#plasmid+gRNA combo to line number
#timepoint to column number
tag_key = {"GCCGTTCGT":"37YPDR1T1",
"CTTATGCTAA":"37YPDR1T2",
"CAGCAGGGATTA":"37YPDR1T3",
"TAACG":"37YPDR2T1",
"CTTATCGT":"37YPDR2T2",
"CAGCAGTGCTAA":"37YPDR2T3",
"TAACGGGATTA":"37YPDR3T1",
"CAGCAGTCGT":"37YPDR3T2",
"TAACGTGCTAA":"37YPDR3T3",
"ACTGCTGGATTA":"48hrR1T1",
"GCCGT":"48hrR1T2",
"CTTAAG":"48hrR1T3",
"ACTGCT":"48hrR2T1",
"GCCGTAG":"48hrR2T2",
"ACTGCTAG":"48hrR2T3",
"TAACGTCGT":"48hrR3T1",
"CTTAGGATTA":"48hrR3T2",
"CAGCAG":"48hrR3T3",
"ACTGCTTCGT":"P162P161",
"ACTGCTTGCTAA":"P167P161",
"GCCGTTGCTAA":"P167P163",
"GCCGTGGATTA":"P168P163",
"CTTA":"P169P164",
"CAGCAGAG":"P170P165",
"TAACGAG":"P170P166"} #good for seqlib13 (updated with non-existent primer combos)

BC_key = {"TCTTCAATTTTTTTTGAGGTTTGTGT":"PRE7g7",
"CAAGAAAGTGTTTTCTTTTTTTGGCA":"PRE4g9",
"CCTGCAAGTCATTGACGCTAACTAAT":"PRE4g3",
"CCGGGAAACGGCTTGAGGGTTGCGCT":"RPN5g1",
"CCACCAACTACTTTTCAATTTCTTTG":"COG3g1",
"CCATCAACGTTTTTCGAGCTTCTACT":"SED5g5",
"AAATTAAACTTTTTCTAGCTTACCAC":"SEC22g1",
"TGCTAAAGTACTTTAACTGTTGCGTA":"SEC22g2",
"CCGCGAAGTGGGTTTAGGGTTTCGGG":"COG8g2",
"AAAGAAATGTTATTTAACTTTGTTAG":"GET2g2",
"CAATTAAGAGTCTTTATTGTTACTAA":"IMP4g6",
"ATTCGAATTAGTTTAATGATTTTATG":"DIP2g5",
"TGAGTAACCCTATTTTTTATTCTTTA":"PWP2g2_BC1",
"AACCAAACCTACTTGATACTTCCGTT":"PWP2g2_BC2",
"AGATAAACGTAATTTTAGGTTTCTGT":"TIF6g8",
"TAGACAACCTACTTAATGATTGAAGT":"RPF1g3",
"CAGTTAACAAAATTTTCGATTACTTG":"MAK16g1",
"GCTCAAACACGTTTAAGGGTTTGGTT":"YCR016Wg4",
"CTAAGAAAGTTTTTTTAATTTGCCCA":"YLR050Cg1",
"TCTGGAACGCATTTTATCTTTTTGAG":"SAP30g7",
"ATTGTAAGTGATTTCCCGTTTGGATT":"CC8",
"AAGCGAATATCATTGGCGTTTCTGTA":"CC16",
"AAGTGAAGTTCGTTCAAACTTGTCTT":"CC17",
"TCAGCAATGAGGTTTATGTTTAACGG":"CC8_BC2",
"ATATCAAAATAATTAAATTTTAGTCG":"CC16_BC2"} #good for seqlib13
SDS_key = {"GAAATAGCAGTTAAATGTAC":"RPL15A-NRg-4",
"ATAGCAGTTAAATGTACCGG":"RPL15A-NRg-5",
"GATGAGGTGCTGAAGATGCA":"KRE33-TRg-1",
"ATATTTAAATACGTAAATCG":"PMI40-NRg-1",
"CCGCGTCGCAGGTCAATTAC":"NOP19-NRg-3",
"GATATATTATCCTTTTGCAC":"SRP14-NRg-4",
"TAACAGAAAGCTGCAATAAA":"SEC27-TRg-2",
"AAGAGGTAAACCGAAACATG":"GPI14-TRg-3",
"CAGCGCACGGTGAGGGTAGA":"PAH1-TRg-7",
"TGAGGGTAGAAGGAAGAGCA":"PAH1-TRg-6",
"AGCAAGGACAAGTGAAGAGT":"PAH1-TRg-5",
"AGTGAAGAGTAGGCCATCGT":"PAH1-TRg-3",
"TCCATTGTTATGTAAAGTCT":"COG3-TRg-1",
"GCCATAAGTCATCTTCGAGC":"HTS1-NRg-5",
"TTCTATTTACCGGGTGATGG":"MSN5-TRg-7",
"AAATCTCATATAAGCCTGCA":"ERG26-TRg-1",
"AGCTCTTGAAGTGACTTTAT":"SMD2-TRg-5",
"GCTCTTGAAGTGACTTTATG":"SMD2-TRg-4",
"TGAAAATTATCTTACTCAAA":"SMD2-TRg-1",
"GATCGAGGAAACTCAAAGGG":"PRE7-TRg-4",
"TTTTCCAACTTAAAGGATCG":"PRE7-TRg-7",
"TCTTGCCGAGCTTTGGGGAT":"SEC6-TRg-3",
"GCTTTGTACTTACATAGCAA":"ESF2-NRg-1",
"ATAGCAATGGGTAGTTTGTC":"ESF2-NRg-3",
"TTTTCTTTCATGTAAGCAAC":"AFG2-TRg-2",
"GCCTTTCTACCGGAAAACTG":"RRP36-TRg-3",
"TTGCCTTTCTACCGGAAAAC":"RRP36-TRg-5",
"TCAGCATTAGGAAGATGAGT":"GCR1-NRg-2",
"ATGTGGGTACGTATTTAAGG":"PRE4-NRg-4",
"GATTGACGGGTAACCCTAAA":"PRE4-NRg-9",
"TGTGTGTGGTACAATAGAAG":"DSN1-NRg-2",
"GGAACTATTTACGTAACGCG":"GPI11-TRg-3",
"TTATGAGTGATATAGAGATG":"POP3-TRg-1",
"GGCAATACCGAAAAAGAAGA":"MNE1-TRg-5",
"GAGAGAATTAACTGCGACCG":"RRP12-NRg-1",
"CATTAATAGACGTTCTTACA":"RSC6-TRg-2",
"CGAAAAAGCAAGGTGGATAT":"CDC25-TRg-1",
"AAACGACTTTTAAACATCGC":"CDC25-TRg-9",
"CTCGAAAAGGATGGAAAATC":"YPP1-NRg-3",
"ATCAACTATTGCGGGTAATA":"NFS1-NRg-9",
"TATCAACTATTGCGGGTAAT":"NFS1-NRg-8",
"TTACGCTAAATCAAGATATT":"UBA2-TRg-1",
"TCCGTTTTCTTCCATTATAT":"ARP2-NRg-3",
"TGAAAAAGTGATTGGTATAG":"MAK16-TRg-1",
"TCTCTTACGCTTAGCTTACA":"CEP3-NRg-1",
"CTAATAGCAACCGTACTCAT":"GUK1-TRg-5",
"TAGCATAAATGGATACACAA":"GUK1-TRg-2",
"AAACGGCGAAGCGGGAATTT":"GPI12-NRg-6",
"TGAGCGTAGAAGTTGGCCCA":"RPS5-NRg-5",
"CAAAATATTTTAGAACTAAT":"RPS5-NRg-2",
"TTTATACCTCAGCATTAGTA":"RPC19-NRg-1",
"GCTGGAAAAAATAGTACTGA":"TIM54-TRg-1",
"ATAATGAATGCCCTTATTCT":"TEN1-TRg-2",
"CACGTTACTAAATAAGAGAT":"SAH1-NRg-4",
"AGATTGGAAAATCTAAAATA":"SAH1-NRg-5",
"AACAAATAGGAATGGAATCA":"SAH1-NRg-3",
"TTAACTAGACGAAAAAGGGG":"ATP15-NRg-5",
"TTAGAAAAAGAGTTAACATT":"SCD5-TRg-5",
"AAGAAGAAGAAAAACTACAC":"ARB1-NRg-2",
"AAAAGCCATTAATTGAGATG":"ARB1-NRg-4",
"AAAAGAGTAACCTAGGAAAT":"PUP2-TRg-1",
"ACAAGACAACTTGAACCTCA":"CCT8-TRg-2",
"CCAGAAGAGCAACTTCGCAT":"MCM4-TRg-1",
"AATGATGGAAGCGGTAAAGA":"LSM4-TRg-1",
"ATAGCATAAGTTGTAATGTA":"NOP53-NRg-1",
"CGATTAAAGAAGGCCCGGAA":"ATP3-TRg-4",
"AAAATAAAGATGGATCGAAG":"AFG2-NRg-3",
"TAGTAATAAATGGCATTCTA":"PRO3-NRg-3",
"TAACGAGGAATGGAACATGG":"NRD1-NRg-10",
"CCTGCCTTGAATTGGCGTTA":"SEC61-TRg-2",
"CTGGTGCCATTACCCGTTAA":"RHO3-TRg-4",
"CGGGGCCATCCTGAGGCGGT":"SNF2-TRg-6",
"AATATCACGATAGGACAAAT":"SMD2-NRg-3",
"AAAATCACATTTGACGAATT":"RSC4-TRg-2",
"AAACAACAAAAGCATGCTAG":"RSC4-TRg-1",
"AAGAGGCGAGGTATATCTTA":"TIF34-TRg-2",
"GTTTGTTTTCTACCATTCCT":"BET1-NRg-1",
"AGTTTAGAAGCGTACTTCTT":"CDC8-NRg-2",
"GTGTCTGACCTAAAGCCCGT":"PRP42-TRg-2",
"TGAGATGATCATTTCTTATA":"RRB1-TRg-2",
"TCTTCAAAATAACTTACGTA":"SPC24-TRg-1",
"AGCTTTTGGCTAAAGGTTGT":"ILS1-NRg-1",
"GATGCATTTTAGCGTTTCTG":"GFA1-TRg-2",
"CGGGTGATAGGATGAAAAAT":"SEC21-NRg-10",
"GGTAGAATAAGTCGATGATG":"RPC10-NRg-1",
"AATTTCTCACTCGTTGTATT":"RPB10-TRg-3",
"AACATTGAATAAAATCACAA":"RPB10-TRg-2",
"AATTTGGAAGAAGAGAGAGA":"YNL181W-TRg-1",
"ATACATCGCTTAAATGCCGT":"RAD3-NRg-1",
"ACATTATGGTAGCTATAAAG":"NOP10-TRg-1",
"TGATCGTTACCCGAATTTAT":"BFR2-TRg-3",
"TCTTCGTGAAGTATGTATGT":"MCM2-TRg-6",
"ATGTGGGAAACCCAAGATGG":"MCM2-TRg-4",
"TACTGGCCGCCGGCATGCGA":"MPP10-TRg-1",
"ATGTCTCTGTCAGTAAACCT":"RET2-TRg-4",
"TGTTGACACCTCAAGAACAA":"RET2-TRg-1",
"TGAAAAGGTATCAAGCAGTA":"RPS2-NRg-1",
"AAGGTATCAAGCAGTAAGGA":"RPS2-NRg-2",
"TCCAAAAACGAAAGGAAAAT":"ORC4-NRg-3",
"GTTATATGTAAAATACAGTA":"TIP20-TRg-7",
"TCGGAAGGTGTTCAGGAAGC":"SMT3-TRg-1",
"CAAGCGAAGAAAGGAGATTT":"MSS18-NRg-6",
"AATTTAGGGTTATGCATGGG":"YEF3-NRg-9",
"TTTCCATACGTTGATCAACC":"ASK1-NRg-1",
"GCGTAAAGTGAATAGAGTAT":"SMC1-TRg-1",
"AAAATGCGAAAAAAAAAGCT":"NIP1-NRg-1",
"TTAGGTTAAGTATTTTCTAC":"RPP1-NRg-1",
"ATGAAAAGGCAATAGAGCAT":"YDJ1-TRg-6",
"TGCCCTCTAGCTACTATATC":"SUB2-NRg-1",
"GTGATCATCAGCTACGAATT":"TIM10-NRg-8",
"AAAGACATGAGAGGGGAACG":"TIM10-NRg-4",
"GGTGATCATCAGCTACGAAT":"TIM10-NRg-7",
"GTAGGTACATTTACATCTTC":"SKI6-TRg-4",
"AATGAACAAATGCGTAATAT":"TUB4-TRg-1",
"ATGAAGTGTTGGTGCAACGG":"CDC37-NRg-2",
"GCGGCGGAGAAAAATGATTG":"ISD11-TRg-3",
"TGGGAGCCTTCTCAATAAGT":"YOS1-TRg-4",
"TCCGGTGACCGCTTACGGTG":"SSC1-TRg-6",
"GCTAGATACGGAAGATTACA":"MTR3-TRg-5",
"TGAGATGAGATCGCTAGATA":"MTR3-TRg-6",
"TAAGCGGTTCTTGCAAGATT":"TFA1-TRg-2",
"GACAAAAAATGGCAAAAAAT":"CDC3-NRg-3",
"TATATAATATATAATACAGG":"ERG25-TA-18",
"ATTACCCGGACTTAATAAAG":"RPB11-TRg-4",
"ACTGCTTTGGCACACACAAG":"RPB11-TRg-1",
"AAATTCTAGGTTCACTGCTT":"RPB11-TRg-2",
"AAAAAGTTAGTTGTGGTGAT":"DED1-TRg-3",
"TTGTGGTGATAGGTGGCAAG":"DED1-TRg-1",
"ATATAAAAGAGATGGAGGAA":"DED1-TRg-6",
"GAACGGGAAAAAGTTAGTTG":"DED1-TRg-4",
"ATTGTGCTAACTAGTTTCGG":"RPL10-NRg-5",
"ATTATTGTGCTAACTAGTTT":"RPL10-NRg-4",
"GCTGAAAGGTAGAAAGCATG":"EFB1-NRg-1",
"ACCTTAAACTATTTATTTAG":"EFB1-NRg-5",
"AAGAACCAACTAAATATAGT":"EFB1-NRg-4",
"ACTTATGAGTGAAAGGAAAT":"RPT3-NRg-1",
"CATGTGAAAAAGCACTCCTC":"SAC6-TRg-8",
"CGGAAAAATATCAAAAGTAC":"SAC6-TRg-4",
"GCGGAAAAATATCAAAAGTA":"SAC6-TRg-5",
"GGAAAAATATCAAAAGTACG":"SAC6-TRg-3",
"TGTGTATTACCCGGGTTAGA":"DIM1-TRg-5",
"TCCATCCTTGTGTATTACCC":"DIM1-TRg-7",
"ACTCAACTTCTCTTCTACTG":"RPC17-NRg-1",
"GCTTAACTTTCATAGATCGA":"RPC17-NRg-2",
"TCTATGGAGAGGATATTATA":"YDR341C-TRg-1",
"AAACTTCAACAACGAAGAAG":"RAP1-NRg-8",
"GTGTTTAGGTGCTGGATGTT":"RAP1-NRg-5",
"AACGTGTATTGATGGTGTTT":"RAP1-NRg-2",
"AAAAAAACGAAGTGATAAGC":"SEC26-NRg-3",
"GATGATGCTATAACAAATAA":"SPP41-TRg-3",
"ATTGATTGTAATTTGTCCTT":"TAP42-NRg-1",
"GAATTTGTGCAGAATTAGCG":"PGA2-TRg-6",
"GCACTTTGCGACGCCTGTAT":"BRL1-TRg-1",
"AAAAAAGACCGAACAACTGT":"FOL2-TRg-1",
"AGGGTTACACTCAATCACGT":"NAB3-NRg-5",
"CCACACGCGCGAGAACTGGG":"SNF4-TRg-4",
"ACGACCACATATATGGAACG":"HRR25-TRg-2",
"TATGCCTCCTCGGCAGGAGT":"TRS23-TRg-4",
"GGAAAAAATGAAGAATTGAT":"CTR86-TRg-4",
"TAGCAATGGCTGACCGCGGA":"RPB5-TRg-5",
"TGCTATCAAACAAAGATGCT":"SPN1-NRg-2",
"GTGCTATCAAACAAAGATGC":"SPN1-NRg-1",
"ACCACCGTAACGCCAATTCA":"SEC61-NRg-1",
"TGAAGAGAGAGAGAGATGTA":"SEC61-NRg-7",
"TTCATACTGACTCGTCGCAT":"TUS1-TRg-3",
"ATATAAACGGAAACAGAAGT":"OLE1-NRg-2",
"TCTTTCATGTAAGCAACGGG":"AFG2-TRg-1",
"TCTTCTACTTATTCCTTATT":"TOA2-NRg-1",
"ACATCACAGAGACTGAATAC":"USO1-TRg-1",
"TACATATTGAAATTATCATT":"UTP22-NRg-2",
"ATATAAAGAAGTTGCTGTGC":"RIB1-TRg-3",
"ACGATTTGTCAGAAATTAGT":"RIB1-TRg-7",
"ATTAGTCGGACGCTCTTGTG":"RIB1-TRg-4",
"CATTCGTACAACAAATCTTG":"COG1-TRg-1",
"AGGTGCGTATTACCTTCTGC":"RPL32-NRg-2",
"CAAGAGCAAGAAAAAAAATG":"GLC7-NRg-3",
"AAGAGCAAGAAAAAAAATGG":"GLC7-NRg-4",
"ACCAAATAGCAGTACTGTTC":"HSF1-TRg-2",
"ATTATTTATCGATATTGTCC":"DAM1-NRg-5",
"TAAAAAAAGGTATTTCCCAT":"SEC18-TRg-4",
"CTAAAAAAAGGTATTTCCCA":"SEC18-TRg-5",
"AATTGTCCCAGAACTTGCGA":"PAB1-NRg-3",
"TATCATATGTTACGGGAAAG":"POP8-TRg-2",
"CCCAGAACTTGCGATGGTGA":"PAB1-NRg-4",
"ACGGCCAAGAATATCAGCAG":"BIG1-TRg-4",
"ATGTAAACCTCTCTTAACTA":"BIG1-TRg-5",
"TCGATGATATCATGCAACAC":"BIG1-TRg-6",
"AACCGAAATAATGAAAAATT":"RPO41-NRg-1",
"TTTCAAACTGATCACGTGAA":"RVB2-NRg-2",
"ATCACTTAGAAGATTATGGG":"PET117-NRg-8",
"CGGACGCCCGGGAAACAAGT":"VPS45-NRg-9",
"TGATCTTCAAAGAGCTAAAA":"YCG1-NRg-1",
"ATCTCTCTTCATGGCAATAG":"NOC4-NRg-1",
"AAAAAAAATAAGTTACCCGT":"NMD3-NRg-2",
"AGTATTTACGTTGGTAACTT":"DRS1-TRg-2",
"CGTTACAAGATAACCAACCA":"HTB1-NRg-2",
"GATTCCTAATTATAAGGTGA":"IPI1-TRg-2",
"CTTATCTTTGAGAGAAACAA":"SEC18-NRg-1",
"GAAACAACGGTAGTACTTAA":"SEC18-NRg-2",
"AGTATTGGAGACATTGTCAA":"JIP5-NRg-2",
"GATTAAGTGCACCAGTTTTG":"YPT1-TRg-3",
"TAAGTGCACCAGTTTTGAGG":"YPT1-TRg-2",
"ACCCCAACTATTTGGCACCA":"CLF1-NRg-2",
"ATATCGCGAACAACGGTATT":"SNF2-NRg-7",
"ATTGTCCTACCGCCTCAGGA":"SNF2-NRg-4",
"GCATACGAACGAAGTTGCAT":"RPL25-NRg-1",
"GTTTTGGAAGGTATATTTCT":"NOP56-TRg-1",
"GTTATTAAAAGTGTTTTGGA":"NOP56-TRg-2",
"ACTTTGCAGGACAAGAGACA":"TRS31-TRg-1",
"AACGATAATAATAACGGTAA":"DBF4-TRg-2",
"AATAATAACGGTAATGGCTC":"DBF4-TRg-1",
"TGAGGTATAAAGTAACGAAT":"RPC19-TRg-4",
"AATATTCACCTGCGATGAGC":"RPC19-TRg-6",
"GAGGTATAAAGTAACGAATT":"RPC19-TRg-3",
"TTCACGAAGAAAAGTTAGTT":"ROK1-NRg-1",
"ATATTACCCGTCAAAAAGGT":"CDC33-TRg-4",
"GCTATTCGTTTACAATGATT":"DHR2-TRg-3",
"CAAAATAATAGACTAGGGCA":"RRP42-NRg-5",
"ACCTTGGTGCCAAATAGTTG":"CLF1-TRg-1",
"ACGAAAAGGGAAAAAGGAAA":"ERG11-NA-16",
"GAGAACACCAGTAGGCTGTA":"VAS1-NRg-4",
"AGTTGGGCCTAAAAAATGAA":"PIK1-NRg-2",
"ACGGAGTTGTCGGGTAATGC":"SAR1-NRg-7",
"CGCGTTGCAGACGGAGTTGT":"SAR1-NRg-4",
"AGCCTTTCTCCCATGGGCAG":"RPS3-TRg-1",
"CTCATCTCATCGCAAACCGT":"YTM1-TRg-2",
"CGGCTCTGCGGGTAATGAAA":"SUI3-NRg-5",
"TCCGTCGTTGATGAGGACTC":"SUI3-NRg-2",
"TGAGAGGATGGTAAAGCAAG":"RRP7-TRg-4",
"AAAAAGAAGAGAACATTGAG":"RRP7-TRg-6",
"TGTATTATTGAGGTAATTGA":"NIP7-TRg-2",
"ATATCAGAACGCAGGGTAAT":"MDM35-TRg-1",
"TTTACTCATCATCCATCGAG":"ALA1-NRg-1",
"CTAGGCTTTTACTAATACAA":"DOA4-NRg-2",
"ATCACGACTGTGATATATGT":"RPS13-NRg-1",
"CATTCAGAACATGTAAATAG":"YSF3-TRg-2",
"GGAAGCTGCGTGCAATACTA":"RPS2-NRg-11",
"AGTTCGAGATACTCCGCACA":"SSL1-TRg-10",
"GTAATTGACGGTTTAGTGAT":"NIP7-TRg-1",
"ATCGCTGCGCTAATAATATA":"LST8-NRg-1",
"GAACATCGATAAGTCGAATG":"TAF4-TRg-3",
"GAGATTTTATAGTGTATACA":"HAS1-TRg-2",
"TTCGTTTCAAGGAACAAGAG":"GLC7-TRg-2",
"GTTGTATAAAGTAGCCACAA":"CDC45-NRg-1",
"GTAGATATATTATATTACAT":"SEC22-NRg-8",
"ATATACTCAAACCTATTAAT":"YOS1-TRg-2",
"ATTTCGTAATAAGTGATGTG":"RBA50-TRg-3",
"TTTATTTGTTATAGCATCAT":"SPP41-NRg-2",
"ATACGGAAAAGCTACAATTT":"PRP46-TRg-2",
"AAATAATAATATGTTGACAT":"PGA2-NRg-1",
"AATGATGAGATGTTTAGCTT":"CBF5-TRg-3",
"CCACTTAGGACAAGGTCCCT":"TCP1-NRg-3",
"GTTCTTTGCCACTTAGGACA":"TCP1-NRg-2",
"GAGAACAATAAACGATCTAT":"ERG26-NRg-2",
"AAACGATCTATAGGGACTAT":"ERG26-NRg-4",
"TCACGAGGCACGAATGATTT":"MES1-TRg-5",
"ACTTATGGCCTTGATCGACC":"HTS1-TRg-2",
"TCATTACCCTCTGTGGATAT":"SSS1-TRg-3",
"TTACCCTCTGTGGATATTGG":"SSS1-TRg-2",
"TTCGTAGCTCGCGATATTCA":"SYS1-TRg-7",
"TCTTTAGGAAGGCTAAGGAA":"SYS1-TRg-2",
"ATAGAAGTGAGATAAAAAAT":"SYS1-TRg-1",
"ATATGTAGTCGCATCTTGAT":"BFR2-TRg-1",
"ACGGTTTATCACATGGACAA":"EOS1-TRg-3",
"TTCCCATTTGAGCTATTACA":"TAF4-NRg-1",
"TAGAAAATAGGAGGTGGGGG":"ARL3-NRg-8",
"TCTGATGTAGTGTCCTGTTA":"RPN5-NRg-1",
"ATCATTACGACCGAGATTCC":"TIM9-NRg-2",
"AAAATGATATAATTACACAT":"NUP57-NRg-3",
"TTAATCGTGGGTTGAGGACA":"VPS4-TRg-1",
"TACGTGTGTAATGATATGGT":"CDC3-TRg-4",
"TTCACCGAGCGACACAAAAA":"BBP1-NRg-1",
"TCACCGAGCGACACAAAAAC":"BBP1-NRg-2",
"AAAGTGGTGAAGCTTTCCTC":"USE1-NRg-3",
"AATAATGATTAATATTTAAG":"CCT7-TRg-1",
"GCCGAAATTTTCACAGGCTA":"SAH1-TRg-3",
"TGACTCAGAAGAGAAAACAG":"CHS2-TRg-1",
"CCCTCGCATGACAAATAGCG":"DPM1-TRg-2",
"ACATAAAGAGACTGAAGACG":"BBP1-TRg-1",
"TTTGCCACCGGTCGGAGCGG":"NRD1-TRg-4",
"TGCTTCCCGAAAGCCAAACT":"RPB3-NRg-1",
"TACGTGTATGGTGATTTGTA":"PHO85-NRg-6",
"GAAAATCCAAAGGAAAAGAT":"SNF6-TRg-6",
"AAACATAAAACAGTACACAT":"PRP38-NRg-2",
"GATATATAAAACAGAAAAAG":"OAR1-NRg-3",
"AGATCAGGAAAGGAATGAAG":"ROX3-NRg-1",
"TTTTCGAGATCCACCTATTG":"YPP1-TRg-6",
"AAAGTGGGGTAACGGATACC":"CBF2-NRg-8",
"ATAAAAGTGCGGGAAAATTC":"SPT6-TRg-5",
"ATATCCCTTTAATGCATGAA":"SEC10-NRg-1",
"GCCTGCTTATTGTACTGTAC":"NSL1-NRg-3",
"GGAGTCATGCTAACGAGGAA":"NRD1-NRg-8",
"GTTGGCTGTTCTGTGGAAAA":"RPB3-TRg-1",
"AAACTCGTAAAGGGAAGGAG":"NRD1-NRg-4",
"TCGTGGTGATGAAGAAGAGA":"RVB1-TRg-2",
"GTCAGCAAAGTGGGAAGGAG":"TIF5-NRg-8",
"AAACCGTGCAAAACTTAACA":"EOS1-NRg-1",
"ATATAGAAGTATGCATACAC":"ERG25-NA-26",
"ATGTTATATACAGATAATAG":"MSL5-NRg-4",
"TGTAAGGAGGATGGTACATC":"SEC24-TRg-2",
"TTTGCCATTCCGTCTCCAAT":"RPL30-NRg-5",
"TTTAGCGGGCATCATTACCA":"SNU71-NRg-3",
"AATGTAAAACTCTCTTTATC":"CDC33-NRg-1",
"TTCTCTTCTGGTTCCAAGGG":"RPN6-TRg-4",
"TCGCTTCGCTGGTGGCAAAT":"NAB2-TRg-4",
"AGTGATATTCGCTTCGCTGG":"NAB2-TRg-6",
"TATGCCTTTCACTGCTCCTA":"YTM1-NRg-1",
"GCTATGGGGATGGCACACAA":"OLE1-TRg-8",
"GCATATACATATATATATGG":"OLE1-TRg-1",
"TCATAACCCGACATTATTCC":"UTP7-TRg-4",
"CAAGAGAGATTGGGAAGGAA":"ACT1-NRg-6",
"CTTGAGGAACCAGAATCTCA":"RPL18A-NRg-3",
"GAAAGACGTGAAGCAAAATA":"BRX1-NRg-1",
"TTTTCAGGCGATGAGCTTAA":"NAF1-TRg-8",
"TTAAAGGTAAAGGAAAAAGA":"NAF1-TRg-6",
"GAAAAAGATGGTAGGATGAT":"NAF1-TRg-4",
"GTTAGGCGTGGTGCTAAAGA":"CDC8-TRg-2",
"GCGCAACGCGTTAACAGAAA":"NSE4-TRg-1",
"GAAACCTCTTTCCTTGGAAC":"PAB1-NRg-2",
"AAATTTTCAAATGCGAGATG":"PRP43-TRg-4",
"CGAACGCGAAATACAAGTTC":"SEC2-NRg-3",
"GGGTAGTCACATGGAAACAA":"SEC2-NRg-6",
"AAAAGGCGGTGAATATTTTA":"MPP10-NRg-5",
"ACATTGCCTGACCTTGGACT":"YDR355C-TRg-2",
"GACCGACAGATGGCAAGGTT":"YLR339C-TRg-9",
"ATAGAGATGAGTACTACTAG":"SNM1-TRg-2",
"TTTTGTATCTCAAAGCGGAC":"ALR1-NRg-4",
"AGAAAAAGAAAAGTGTTCAT":"ALR1-NRg-1",
"ATTATGCATAATTAGTTCGA":"ALR1-NRg-3",
"TCCGCAAGTGCTTTTGGAGT":"RPL10-TRg-1",
"TAATGCGTATTTTCCCAGAT":"RPL28-TRg-2",
"ATACAGGGAATAAACTGCAT":"UTP25-TRg-1",
"GTAGCTAGATGTTGAATCGG":"POB3-TRg-1",
"CGCGAAACGAATCGTTAAAC":"POB3-TRg-3",
"AGAGTAGCTAGATGTTGAAT":"POB3-TRg-2",
"CCAGAGGCGCGCTTATTAGA":"MED11-TRg-1",
"ACCCTTGGCCGAAACTCGGG":"ISA1-TRg-15",
"ACCTCTCGTGCTCCGTGACT":"RRP1-NRg-1",
"CCTCCACAAAGATGCATATC":"MES1-NRg-1",
"TCAATGGGGTTAAAGCTCTA":"SEC13-NRg-5",
"GATATTCACCATTTACTTTC":"MCM2-NRg-2",
"TTTAATCATGATCAACGGAT":"ALA1-TRg-4",
"ATACATACTTGTTGAGTGGG":"MTG2-TRg-5",
"TACAAGCGATGAGTATAGAT":"TIF35-NRg-3",
"AAACGCGATAATTATAGGCA":"NSE1-TRg-3",
"AAAAGAAACGCGATAATTAT":"NSE1-TRg-4",
"ACAAAAGGATATATTAAGGG":"MOB2-NRg-6",
"ATTAATCGGCAACAAGAAAT":"VRG4-NRg-3",
"AACAAAGAAGTGTTAAGTAT":"PRP9-TRg-3",
"TGCTCCAAACGCAAATAAGG":"HYM1-TRg-5",
"ATTCGATGAGATTCTCGGAA":"POP1-TRg-5",
"GACATTGCACCCGGGTAAGA":"POP1-TRg-9",
"TTCTAACATTAGAGCTTCAA":"RPL17A-TRg-1",
"ACAGGGAAATCTATCTAGTG":"SLD2-TRg-1",
"TTCACATTCGAGGGGTTGCC":"CDC48-NRg-7",
"GGTGACGGAATATATTTCAA":"FHL1-NRg-2",
"TTTCAGGTTGGCCTTACCTT":"BET3-NRg-7",
"AAGCATTATGTCGTACACAT":"MAK21-TRg-1",
"TTGTCAAGATAATATCCATA":"BRN1-TRg-4",
"AAATCCGTTAGACAACATGA":"FBA1-NRg-3",
"CGGGTAATACTGCTTCCATT":"CDC42-TRg-6",
"ACGGGTAATACTGCTTCCAT":"CDC42-TRg-7",
"ATTCAAAAAAGTGACGTAAA":"COG4-NRg-1",
"CATTTAAGCATCTCCCTTCC":"ATP3-NRg-3",
"TCATTTAAGCATCTCCCTTC":"ATP3-NRg-2",
"ATAAAGGTGCTTCTACAGTA":"SMP3-TRg-5",
"GCAGATTGTTTAAGAAAAGC":"CFT2-NRg-2",
"GTTGGGCAGTTTACAGATGT":"FAS2-TRg-5",
"TTATAAGACAAATAAACTGA":"DBP2-NRg-3",
"AGTATAAGTTATTTGAGCGT":"DBP2-NRg-2",
"GCTTTCTCTAGCAAATATCT":"MPS2-NRg-4",
"AGGGGCTAACTAGCGTTCAA":"ARC35-TRg-2",
"ACAAGAAATACTATAAGCAT":"ARC35-TRg-5",
"CTCATCTCATCTCATCTCAT":"MRD1-TRg-1",
"AGAAAGAAGAGGCTGCCACA":"RLP7-TRg-1",
"CAGCTCAGTGTATAACCTTG":"SPC34-TRg-1",
"GTAATGCCAACAATCCATTG":"CDC45-TRg-2",
"ACCAATTCAAAGATGGCAGA":"GCD6-TRg-3",
"TTAAATCACCAATTCAAAGA":"GCD6-TRg-4",
"CATAGTAACAATCTATATAT":"YPT6-NRg-2",
"GTACAGATGGAAATTTATGT":"RPS13-TRg-2",
"AAATATGCTTATTCGAAGGA":"IPI3-TRg-3",
"GCAAAGTGGGAAGGAGGGGT":"TIF5-NRg-9",
"AGTCAGCAAAGTGGGAAGGA":"TIF5-NRg-7",
"AAGTCAGCAAAGTGGGAAGG":"TIF5-NRg-6",
"TTGTTGAAGAGAAAATGAAG":"NAB3-TRg-3",
"AAAATGAGTATTCTACAACA":"GCD2-TRg-1",
"ATCAAAAAGGGCCTTTAAGT":"UBA1-TRg-2",
"GGCTATCTTGGTGTACAACA":"SLD3-TRg-6",
"TTTATAGGGGCATATTGCTG":"LCB1-TRg-5",
"TAAGTAGAAGATGCACTTAG":"TOA2-TRg-6",
"TGCACTTAGAGGTTAGGAGG":"TOA2-TRg-1",
"GATGCACTTAGAGGTTAGGA":"TOA2-TRg-3",
"TAATTATAGTACGGCATATA":"LSM2-TRg-1",
"GAATGTACGGATGTAATGCA":"YML6-TRg-13",
"GTAATGCACGGATGTTAAAC":"YML6-TRg-12",
"AAGGGACTTCTATTAGTGAT":"UTP15-NRg-1",
"ACGGGTAATGCTCATCCATT":"TIF6-NRg-8",
"ACTACACTCTTCAGAAGCAA":"SUP35-NRg-1",
"TTTCTGCTTCCCTCGCATGC":"MPP10-NRg-1",
"AGTAGGCATCACGAATAACG":"SWI3-TRg-7",
"ATAACGAAGTACAATATATT":"SSN3-NRg-2",
"CTAGGGTGGTAATTCTCTGT":"SEC13-NRg-7",
"GGAATAAATTGATTGCGGAT":"RPS15-NRg-3",
"TTTGTCTCTTTCGTGCTTCC":"RPL3-TRg-2",
"GAAATCCGTTAGACAACATG":"FBA1-NRg-2",
"AAGAACAGAAGAATAACGCA":"FBA1-NRg-1",
"TGAGGGATAAAATTTAACGT":"FBA1-NRg-5",
"TTATCGACGCATGAATCCTT":"DAM1-TRg-2",
"CATGATATAGTAGTAGTAAA":"NHP2-TRg-2",
"CGGGAAATAAAGCATTATCA":"HCA4-NRg-6",
"CCACTCGCAACGGAATCCGG":"PRE3-TRg-4",
"TAAAGGTCAACTGGTTTTAA":"DBP5-NRg-4",
"ATTGAAGACGTTATATAAAG":"SPT6-NRg-4",
"TTATTGAAGACGTTATATAA":"SPT6-NRg-2",
"CACACGCACTCTCTCTGACT":"RPL18A-TRg-4",
"GAGTGAGCAACGACAACTCA":"KSH1-TRg-1",
"GTAGTGTGGTGTACGCATGG":"KSH1-TRg-3",
"GTCCTTCGAATAAGCATATT":"IPI3-NRg-1",
"AGACGAAGAATCCGCCGAGG":"PGA2-TRg-8",
"CGTGAGATTCTGGTTCCTCA":"RPL18A-TRg-2",
"GGGAGGCAAAGGTATCATGC":"RPL33A-NRg-6",
"ATTCGCCGCGTATACTGCCC":"TAF12-NRg-2",
"CCGATACCTGTTACAGATGT":"USE1-TRg-5",
"TAAATAGCACGACTATAAAC":"YNL114C-TRg-1",
"GTAGACCGTTCAGGATGACT":"SMC5-TRg-7",
"AGGATGACTGGGCTATATTA":"SMC5-TRg-6",
"TAAAACAGCGCCATAAGGCA":"RSC58-TRg-1",
"TTCGCGTTTAACTACCTTCG":"CTF13-TRg-2",
"AGATGTTTTATGGAAGTATT":"NAB2-NRg-2",
"ATAAATGCAATTCATTAAGT":"MCM7-TRg-4",
"AAACTCGTATAAAGTGACCA":"BCP1-NRg-5",
"TTGTCTGCTTGACACTCCAT":"STU2-TRg-3",
"ATGACACAAGGGGTACATTC":"SEC21-NRg-6",
"GCGTCGTAGTGAATGACACA":"SEC21-NRg-3",
"AATGGGAAGAGTGTTGTATT":"RPL1B-TRg-3",
"TGTATATCAGGTATTTCTGT":"SEC20-NRg-2",
"TAATTGTACAAAACTATCAA":"VMA3-NRg-2",
"TCTCAACTGACAGTAAATAA":"SEC23-NRg-5",
"GAGAAAAAAAGAGAAAAATT":"CDC28-TRg-4",
"TAGCGAAAAAAGGAACTTCA":"RPN12-NRg-11",
"GAGTTTATGGCATAGTAGAA":"PUP3-TRg-3",
"CATTCCTCTATTCCTGTAGT":"SEC31-TRg-2",
"ATTATGTTGTTGTAATATCC":"SED5-TRg-6",
"TGTTGTTGTAATATCCGGGT":"SED5-TRg-5",
"TGATACCTTTGCCTCCCGTT":"RPL33A-TRg-1",
"CCCTCCCTTCTACTCTTCAC":"RPL33A-TRg-2",
"GTAAACTGAGAAAAGAAAGA":"MRPL11-TRg-2",
"TGACAAGAAGAAACATGAGG":"RTP1-NRg-2",
"ATGAGCTAATTATATCAAGA":"NUG1-TRg-2",
"AATATTTAAAATGAGAAACG":"VPH2-TRg-4",
"GATCTGTTATTTATTCAAGT":"COP1-NRg-3",
"ATTCATAATAATGCTAACGT":"CRM1-NRg-1",
"GCCTCTGAAATATACTACAT":"RPL5-NRg-4",
"AGTAGGACTTGAACACTAAG":"SNU13-NRg-4",
"TAAAGAAAGCACTGATATAC":"PFS2-TRg-3",
"GTACTGGCCGCCGGCATGCG":"MPP10-TRg-2",
"ACGATGAGATGAGGCCATTT":"TSR4-NRg-2",
"AACACAGCTGAAAAAAGTAT":"RSC2-TRg-1",
"TACTTCTTCTTAAAACAATT":"SEC65-TRg-2",
"ACACGAAAAAAAATAATTAG":"SMI1-NRg-1",
"ATGAACGCGAAATCGCATCC":"RTT105-NRg-4",
"TTAAGACTGGAAAACAATTT":"VMA5-TRg-3",
"ACGGTGTATGTTACCCGAAC":"VMA5-TRg-5",
"AATTTCCAATATCCTAGTCA":"RRP1-TRg-3",
"AAATATACGTGCTAGAAAAA":"CLC1-TRg-2",
"TTTATACTTATCCCACAAGG":"GCD6-NRg-1",
"TCCATCTGCCATCTTTGAAT":"GCD6-NRg-2",
"AGTACTCAATAGTAACATAT":"PXR1-TRg-1",
"TCGAACGAATCGGAAATATT":"CDC14-NRg-1",
"TTGGATGAGAACTTGGCCTA":"PCF11-TRg-6",
"TGAGAACTTGGCCTAAGGCA":"PCF11-TRg-5",
"GAGAACTTGGCCTAAGGCAT":"PCF11-TRg-4",
"TCAGAATGCAACCCGACTAC":"SEC31-NRg-1",
"AGTTGCTGCTAATGTATAGA":"RRP5-NRg-1",
"AAGAAAGTAAGTGGTAATAG":"PRE10-TRg-5",
"GTGGCGGTAGAGGGTTTATT":"PRE10-TRg-1",
"ACTTCTACGCTCACGTTAGT":"RPS5-TRg-2",
"TTGTAGAACTTGAGACAACC":"NSP1-TRg-4",
"TTACAACGCTATATTTTCAG":"PRP38-TRg-4",
"TCGCTACCCGGAAACGATAA":"RCF1-NRg-5",
"GTATTTCAATTGACCAACGT":"RSC3-TRg-4",
"AGTATTTCAATTGACCAACG":"RSC3-TRg-5",
"GTTACCCTATGGCCCTTTTC":"RSC3-TRg-6",
"GGCTTCGTGAACGGGGAAGG":"HTA1-NRg-12",
"TGGCTTCGTGAACGGGGAAG":"HTA1-NRg-11",
"AATTATCGTGATGAGCAAGA":"UTP23-TRg-2",
"GGTTCCGCACGAGTAATGAA":"GCD7-NRg-1",
"ATGGTCTGTTTCATTTATGA":"GCD7-NRg-2",
"AGCTTGCGGTTGGGAAGCAG":"GCD7-NRg-6",
"AATTTTCTGATCGACGCAAC":"GAL11-NRg-2",
"GCAACCGGGGCCGGGGTGGA":"GAL11-NRg-9",
"GCCGCTCGCACGGAAATATT":"PHO4-TRg-5",
"CCTACGAAGGGCGCATACAA":"SNP1-NRg-3",
"GTTACAATGAATGCAAAAGA":"RPC37-TRg-5",
"ATACAAATAATATATTATGA":"CRM1-TRg-5",
"ACCCGGAGATATATACTATT":"CRM1-TRg-2",
"CAAAATAGATATCTACAGTT":"ASK1-TRg-7",
"ATTTGGTCCCTAGGTCTGGT":"STU2-NRg-4",
"CCAACTGCCTCAAAAAGGTA":"NEO1-NRg-3",
"ATCGGGCCTTCCTTCCACCC":"GAL11-TRg-5",
"TTAGGCATTACCCTACATTG":"GAL11-TRg-7",
"GCAGCTTAGAAAATTCAGAC":"SAM50-NRg-3",
"ATTCACTGATGATGAGCTTA":"CSL4-TRg-2",
"TAATAGTGTCTTGGTGGATG":"CCT5-TRg-2",
"TTGCTGTGAGTGAAAAAGGA":"POL30-NRg-1",
"AGTGCATTACCACCTACGTA":"MED4-TRg-4",
"CATTACCACCTACGTAAGGT":"MED4-TRg-3",
"ACCACCTACGTAAGGTAGGC":"MED4-TRg-2",
"GGCCGTGGGAAGCTTCAGCG":"GDI1-TRg-4",
"GCCGTGGGAAGCTTCAGCGA":"GDI1-TRg-3",
"CATGCCGGGTGGCAAACCAA":"REB1-TRg-6",
"TATGAAGAGAATATTAGAAC":"MRPL37-NRg-2",
"TTCACCGTAGAGTAGACCAT":"NOC3-TRg-3",
"CGTTGCTATTACCCTTCCCC":"SPC97-TRg-3",
"TTTAAGGTCGCGTCGAAGTT":"IPP1-TRg-3",
"AGGTCGCGTCGAAGTTAGGA":"IPP1-TRg-2",
"CAGCGACATGTTGGAAAGGT":"PTI1-TRg-3",
"ACAAAAAAACAGCGACATGT":"PTI1-TRg-5",
"AAAGTCTATTTTATGTTCCA":"RFC5-NRg-1",
"AACAAGAATGTGGCTATGGT":"CDC24-TRg-1",
"GTAGAAACAGAACAAGAATG":"CDC24-TRg-3",
"GACGCACTGGTGGGAAGAAG":"CDC24-TRg-5",
"GCGAAGAACGACGCACTGGT":"CDC24-TRg-6",
"ATTATTTCTATCATTTACTA":"UTP23-TRg-6",
"CGGTGCGATGCGATGATCTT":"UTP23-TRg-4",
"ATTATCGTGATGAGCAAGAA":"UTP23-TRg-1",
"AAGATGCCATTAACGGGTAA":"RHO3-NRg-4",
"GCACTTTTGAACTTATGCAA":"TRS23-NRg-1",
"CCGCCCAACTCCTGCCGAGG":"TRS23-NRg-3",
"CCAAATTGCAGTGATCTTCA":"RSP5-TRg-2",
"GCAGTGATCTTCATGGTGAA":"RSP5-TRg-1",
"TCTATCTGTTAAGCGTGTTA":"SDA1-NRg-1",
"TAAACGAGTATAGAATTCTT":"KAP95-TRg-8",
"AAAGGCAAGCACAAAAAGGG":"ACO1-TRg-6",
"AGAAAATCTACAAGCTGATT":"HTA1-NRg-3",
"GATTGGAAGTAAATAGATGA":"HTA1-NRg-2",
"AGCACTTGTAAAGTATATGC":"SPN1-TRg-1",
"AATGGCGCGCAAACCGCCAA":"MOT1-NRg-7",
"GCCCATAGAGCTAGGCCGGT":"RPL17A-NRg-4",
"CCGAATGTATGGATGTTACA":"ADA2-TRg-4",
"ATTTAGTAGACAAAAAGACA":"SFH1-NRg-1",
"GTTCCGCGACTACCAGGGGA":"SPC97-NRg-5",
"TATTTTGAAGAAGCAATGTA":"PRP22-TRg-3",
"TTTTGAACAAAAAGCCGTTA":"SEN15-TRg-2",
"AAATCGTATTTTATATATCC":"RPL3-NRg-2",
"GACTGCTATTACCCGGAAAG":"ISD11-NRg-2",
"GTTTCTCGTATATACAGGAC":"HEM12-TRg-8",
"AGAACCGTTCATGCATTAAA":"SEC10-TRg-1",
"AGTAGTGGCAAATACTACCT":"HTB1-TRg-7",
"AACTATGAAGAATGAAAACG":"TTI2-TRg-1",
"TTCTGAGTAAAAGAGAAAGG":"ACP1-TRg-2",
"CTTTCTTCGCCCCTTCGAAC":"ACP1-TRg-4",
"CCGGGGCCGGGGTGGAAGGA":"GAL11-NRg-10",
"TGCCTGGGAACGTCGGCCTA":"UTP22-TRg-2",
"TCAATCTTCTGTAGGGATGG":"MST1-NRg-5",
"CCCGACATCAACTAACTGAA":"RIB7-NRg-2",
"TATGCTAAACAAATAACTCG":"MCD1-TRg-6",
"GCTAAACAAATAACTCGAGG":"MCD1-TRg-5",
"CTTATGTTTGGCGTGCTAAT":"GPI8-NRg-2",
"TGTGTCATCTGAAAGATTAC":"THS1-TRg-2",
"GGTAAAGCAAGAGGCATTTA":"RRP7-TRg-2",
"AGAAGAGAACATTGAGAGGA":"RRP7-TRg-5",
"AAAAGGGAAATGAAGAACAG":"SMX2-NRg-7",
"ATATTGTCACTACCAACGAA":"RRP45-TRg-5",
"TATTGTCACTACCAACGAAT":"RRP45-TRg-4",
"AAAAGAATATGTGTAATTTC":"CNS1-TRg-2",
"GCAAACCAAAAAAAAAGTAG":"FBP1-NRg-9",
"TTTGTACTGATGATCAGCAT":"GCD11-NRg-1",
"TTCCGCAAGTGCTTTTGGAG":"RPL10-TRg-2",
"TTTTCTGCTGGAAAATAACA":"NUP192-TRg-4",
"TTTGAACTTTCCTGCCGGCG":"NUP145-NRg-4",
"CGTATATACAGGACAGGGTT":"HEM12-TRg-6",
"ATCACGACATAAGCAGCCTC":"PLC1-TRg-3",
"TACAATAAAATAGAGCCGAA":"RPA43-TRg-1",
"ACGTTATTGGCATTTTCACT":"RPB7-NRg-2",
"TGGCATTTTCACTGGGATAT":"RPB7-NRg-3",
"CTATGGGTAAGAAAGGATTT":"NSL1-NRg-1",
"TGGGCGATGAGCTAAATATC":"UTP6-TRg-3",
"GTGAATAAACACATATCTAA":"UTP6-TRg-1",
"ATTTAAACTTGTAGAAAAGT":"YJU2-TRg-5",
"TTAGGGGGTGAGAGAGGGAG":"FRS2-NRg-5",
"TTCAATACAGCGAGTAACTA":"TIF35-NRg-2",
"TATTATGAAAGTTACATATG":"GPI15-TRg-1",
"CCGATGTAAGGAAAACTTCT":"NOP1-NRg-5",
"CATTTTCTTCAGGTGTACCG":"GPI15-TRg-4",
"AGGAATTGTGAAAAAAGTGT":"COG4-TRg-1",
"AAGCTAATTAAGTGTAAACT":"TFA1-TRg-1",
"TTTTCTGAGGCGAAGCAAAT":"RHO1-NRg-2",
"TAAAATAAATATATACGATT":"RHO1-NRg-1",
"ATCTCATTAAAGGGAAGAAA":"CDC55-NRg-2",
"TAAAGGGAAAAGAATCGGCT":"IDI1-NRg-7",
"GTCTGGAGAGTGGGCTTAGC":"RPL32-TRg-5",
"TTATTCAAAACGACGCAATT":"RPB5-TRg-4",
"GTTACCCTTCTAAGATAGAT":"DIP2-TRg-5",
"ATAGATGTAGATATTGTATA":"DIP2-TRg-1",
"CTCATATTATGTAGAAGAGC":"RPC40-TRg-2",
"GATCAGGAAATTACCCACTT":"CDC6-TRg-5",
"ACTTAGGAAATTGAGTTGGC":"CDC6-TRg-3",
"AAGTACTTACAAAAGGTTAG":"DAD2-TRg-2",
"GGGAAAACAAATTTAATAAC":"RVS161-TRg-2",
"GGCAGACGTGAGAGAAGAAA":"RVS161-TRg-1",
"ATTGATTTGACGCTTAGCAC":"SUP45-NRg-3",
"TAATTCAGTCCGGGTCACAC":"SRB6-NRg-5",
"ACTAGAGCAAGTGAACGAAC":"RPC11-TRg-4",
"TGAGGGAAAAGCGATTAACT":"RKI1-TRg-8",
"AAGTAAGCAATGTATTATTG":"NIP7-TRg-3",
"GAGGGACAGGATACGAGTTT":"RPL33A-NRg-12",
"ATAAAACAGTGATATTCTTA":"SAM50-TRg-4",
"CGTTCCATGGGTAACCCTAT":"NOP4-NRg-1",
"ATATAACCGCACAAACGTAA":"NOP4-NRg-3",
"TTGTGCTGATAGAAACAATG":"SMX2-TRg-5",
"AACTCTGGTGAGACGCGTCA":"POL12-NRg-2",
"TTTGTACGGACATTAAACTT":"BMS1-NRg-2",
"TTATTATTACCCGTTTTCTT":"RPA190-TRg-5",
"TTGTACATGAAATATTAGGA":"ALG14-NRg-4",
"ACCGCCGATTACAGTTATTG":"ALG14-NRg-1",
"CCACGTCTACCTAAATGTAG":"PRE5-NRg-1",
"ACCTCCGCTGCTGATATTCT":"BIG1-NRg-2",
"AGAAAAGCGCGAGCTTACTT":"TFA2-TRg-4",
"ACACTATTCACTTCGGGTAA":"IMP4-TRg-6",
"GTTTCGCCAATAGATCTATA":"PAN1-NRg-1",
"TAATAGCGGTATGGCATTAA":"UTP13-TRg-2",
"TCCGTATAAAGCGATATTAC":"KAE1-NRg-3",
"TAAATAGAGGAAGCAACGGC":"ERG20-TRg-1",
"AAAGAGGCAAAACGTAAATA":"CDC20-TRg-6",
"TCGCATGTGATCAAGGTTAC":"PWP2-NRg-2",
"GATGAACTGTAACAGAAAAT":"COG1-NRg-1",
"GGAAGAAAGACGCAATCAAT":"RPL1B-TRg-4",
"GACATCTTTTGGCCTCAGAT":"RPL1B-TRg-7",
"ACCGATTAAACAGGTAGTGT":"UTP20-TRg-3",
"GTAAAAACCACCGATTAAAC":"UTP20-TRg-4",
"TTCGGCTTGCCTCACTGCGT":"RPL25-TRg-4",
"CGGCTTGCCTCACTGCGTTG":"RPL25-TRg-2",
"CCTTTCTAAATGTAAGTTAT":"MCM7-NRg-1",
"TGGGACGTTCAAAGTGATCT":"MRP49-TRg-5",
"AAAAATGCGAAAAATTTCCA":"ERO1-NRg-3",
"TTTGATTGTCATTTAACACG":"UTP5-TRg-7",
"CCAATGCGAAGTTGCTCTTC":"MCM4-NRg-1",
"CCACCGGATTCCGTTGCGAG":"PRE3-NRg-1",
"ATGCACAGTAATGTTTAAAG":"FCF1-NRg-1",
"ACAATACCAATATACTGTAT":"CUS1-NRg-1",
"AAGCTGAAAAATAGATGTGA":"PSF1-TRg-2",
"TATTCCTCGCGATGAGATTG":"BCP1-TRg-2",
"ACACGTCGAGAAGCAGGAAG":"PAN1-TRg-1",
"AGAAAGCCATATAGATCTAT":"PAN1-TRg-3",
"TTAGGGGCAAAAGTTGGTAT":"PAN1-TRg-4",
"ACCGTTCCGATGGGAAAAAA":"VPS3-TRg-2",
"TTTTATTCCAACAGTATGGG":"YIL060W-NRg-1",
"ATTAAGTATATATACACTTT":"VPS53-NRg-1",
"AAAGTTCAGTAAAGACAGCT":"CYR1-TRg-4",
"TATTTTGGAAGGAAAGCAGG":"CYR1-TRg-7",
"CTATTACTCTTTGCAACCCT":"MPS1-NRg-1",
"AGAGTTGATGGGGAAGGACT":"SRP1-TRg-5",
"TTGATGGGGAAGGACTAGGA":"SRP1-TRg-4",
"AAGTCGGAGCAAATGAATAA":"TAF12-TRg-2",
"AAAATGTGTTAGACTTAAGT":"TAF12-TRg-3",
"TACTCGATGACATGAATAAG":"POP4-TRg-1",
"ATCTTAATATTGGTGAGAAG":"SPT16-TRg-1",
"ATCGACCTTCTCTCTTTTCG":"NUP82-TRg-4",
"GATGCGATGAATTAAAACCT":"DML1-TRg-3",
"GTGTATAACGATAGTCCCTT":"RPA43-NRg-3",
"TGCTATTTGGTCCCTAGGTC":"STU2-NRg-3",
"GGGTAAAAAGCGGATGAATT":"POP4-NRg-4",
"ATATATATGTACATATATAT":"MCD1-TRg-2",
"TACCACTGCCCATGGGAGAA":"RPS3-NRg-4",
"TTTATTCTAACTTTCCGATG":"PRP9-TRg-4",
"ATTTATGCGAGGTAAAATTC":"RPP1-NRg-2",
"GTGGAACAGAAAAGAAATCG":"MTR2-NRg-11",
"ATTTCATCTCGACCTGTACC":"GCD11-TRg-1",
"ACTTTACGATTGAACACCTA":"RPF1-TRg-3",
"ATATCACTGTTAACGAGTAA":"SUB2-NRg-4",
"TCAATAAATGAAGCGATGTT":"GPI15-TRg-3",
"AGCAGCGAGAACACGACCAC":"ERG9-TRg-6",
"ATTCACATTAACCTTCTTTT":"RPT2-NRg-1",
"AAACCGCCAACTTATTGAGA":"YOS1-NRg-3",
"GGCGGAAGGAGAAAGTTTCA":"SCM3-TRg-4",
"TATTTTATATAATGCGCAGG":"SCM3-TRg-6",
"TGTGGCAGCCTCTTCTTTCT":"RLP7-NRg-1",
"GGTTATATGTGAATATATGA":"TFB2-NRg-4",
"GCATGAGGTTGGACTTGAAA":"IMP4-TRg-1",
"ATATATTGATTGCATGAGGT":"IMP4-TRg-3",
"AAGTACAGCTAAGTTAAGAA":"PRE4-TRg-3",
"CAACACGCCGAATAAACAAA":"SUB2-TRg-3",
"TGATGCATTCACTCTCAGTT":"RPP0-NRg-4",
"TATTCCGCTTATGTATCTTA":"RPP0-NRg-3",
"GCGTTTGCAAAAAGTGAAAA":"TOM40-TRg-4",
"ACGGAAAGGGAAAAGTCCGC":"FUR1-NRg-12",
"GTGAAAAAGGCGTCTTTTGG":"TOM40-TRg-2",
"AAGAACACATCTAACCGAAG":"VMA11-NRg-4",
"GCAGAAAATAAAGAAGAGAG":"PGS1-NRg-4",
"GCTCATCGCAAAGAATAGTT":"URB1-TRg-4",
"TACAGAAAACCAAGGATTTT":"ARP4-TRg-3",
"CCATGAATATAGGAAGTAAT":"RPT3-TRg-3",
"GCCGGAGTCCTCATCAACGA":"SUI3-TRg-3",
"ATCGCGTTAAAATATTCAAG":"RFC5-NRg-2",
"TCATCTCCGGTAAAGAAAAG":"RRP14-TRg-2",
"ACTTCGCTTAAAAAAAACAC":"SCC2-TRg-1",
"CCAACGCCGGCTCGACGCTT":"SSC1-TRg-3",
"ACGTTGAACATGATCTGAGC":"RRP9-TRg-3",
"AACCGCCAAGGGAACGGAAT":"MOT1-NRg-9",
"GATGCATTTGGACCACTTAA":"RPL42A-NRg-2",
"GATATACGGAAAAGGTTAAT":"SEC16-TRg-7",
"TTTCATCTCATCGCATTTCC":"IMP4-NRg-2",
"AGATGAGATAATTATACTCG":"YEF3-NRg-4",
"AGAAGGGTGATCAGTTGAGG":"PUP1-TRg-1",
"GATTTAGGCAGGACCGGTGG":"UTP22-TRg-6",
"AAATTTTCTGCGATGAGCAT":"DBP2-NRg-4",
"TCCGGGTATTATGTGATATG":"PRE2-TRg-7",
"CATTATGGAGTCGTCTAGGA":"ATP16-TRg-6",
"ATCGCTCTCAGATATAATAG":"UTP13-TRg-4",
"CCGTTATAAACATAATTGGG":"DOP1-NRg-4",
"GAAGACTGGTTGAGTAGCAT":"TIM44-TRg-3",
"GTTCATGTTAAATTAGATGG":"ATP16-TRg-2",
"TTCGTCAATGTTGAAGAAGT":"ENP1-NRg-3",
"AAGATGGTAGGATGATAGGT":"NAF1-TRg-3",
"AAGGAATTGTGAAAAAAGTG":"COG4-TRg-2",
"TCAAGATCTCTAAATATAAG":"SOG2-TRg-7",
"CAATTTTCACAATGCATCTA":"YDR341C-TRg-3",
"AGGCGTAATGACAATTATAC":"YMR290W-A-TRg-10",
"GTATTGGTAAACTAGTTGAA":"NUP192-NRg-9",
"CAGGATGCACGGAGGTAAAC":"RPS31-NRg-8",
"TTCCGCGACTACCAGGGGAA":"SPC97-NRg-6",
"AGCTCATCTCATCTGTATTT":"EBP2-NRg-1",
"CAACCCCTCGAATGTGAATT":"CDC48-TRg-5",
"GGTATATACAGTATTTTCCA":"RPT1-TRg-4",
"ATTTTGAAAATAAAAAGAGG":"ULP1-NRg-2",
"CAAGAAAGAGACAAAGCAGT":"RPN3-TRg-6",
"AGCTTACTATACAAAGAACT":"RPT1-TRg-5",
"AATTAACTAACTATATAACG":"KRE5-TRg-2",
"AGTCGGAATGAGGTCTCGCC":"TBF1-NRg-8",
"AGCCGTAGGCCGACGTTCCC":"UTP22-NRg-4",
"ACCGCACCGTAAGCGGTCAC":"SSC1-NRg-4",
"TGGCAAACCAAAGGCGGCCA":"REB1-TRg-4",
"GCCGGGTAGTGCGCAAAAGG":"CDC48-NRg-9",
"ACCGAAATCTCACTAAGGCA":"FAS2-TRg-8",
"CATATAGAACTGTAGAAATT":"TAO3-TRg-8",
"GCGGGTTATAAAAATATGTC":"CKS1-TRg-5",
"GGGCAATCCGAGGTCCGAAG":"YLR379W-TRg-7",
"TGAATTATGTCCTAGAATAA":"TEN1-NRg-2",
"CTAGTACATGAGCGCGAAGG":"RPL42A-TRg-2",
"GGAACATGTCGTGTAAGATT":"SEC27-TRg-4",
"CAAGGAAGGGCAAAGCATTG":"TBF1-NRg-4",
"AGTTTTCGGGTGGCAAAATT":"RPT1-NRg-6",
"TGCTGAAGAAAAATGAAACA":"COG1-TRg-3",
"ATTATCACCAATAACGGGTC":"SUI1-TRg-6",
"CGAACTGGCTTGCTAAAGCT":"TIM23-TRg-6",
"ATTCACATTCGAGGGGTTGC":"CDC48-NRg-6",
"AAAATTTTCTCCGTCGGCCG":"EPL1-TRg-5",
"GTAGTTACCCGGCCAATATG":"RPT5-TRg-8",
"ACTCCATAATGCGCTTTGAT":"ATP16-NRg-4",
"GTTCCAAGGGTGGCAAATGT":"RPN6-TRg-3",
"AGAAAAAGGGCAAAGCAAAT":"ERG9-NRg-6",
"ATGGTAAGAGCAAGAAACAA":"SMX3-TRg-1",
"AAAACCGCTTCCATTTATAT":"NCB2-NRg-3",
"GCCACATGTACGGTCGCTTG":"SEC16-NRg-12",
"AAGCAAAGATCCGTTAAATA":"RPN6-TRg-2",
"CTTTGTGAGGGTAGGTCCCT":"REB1-NRg-4",
"AATTTGTATATTATTCACCT":"ATP16-TRg-9",
"AAAGGGCAAAGCAAATAGGA":"ERG9-NRg-7",
"GTGTGAGAGGGGCCGTGTCT":"CC5",
"GAGAAGGTCACAGCCTCTAG":"CC8",
"CACTGGGATCCACGTCCGGG":"CC16",
"ATCTTTGACGCGCCGGGCGT":"CC17",
"CGCCGGGAGCGGGGAGGCTC":"CC19",
"AGTCTGCGTCTAGATGGGGC":"CC20",
"AGGGGTGCTAGAGGTTTGCG":"CC23",
"TACGCCGTGGGTTGCAGTCG":"CC25",
"CCTGGGTACGCTGCGGCGGG":"CC27",
"TGAGTGAACTACGCGCGGTG":"CC28",
"GCTATGTACGCATGTCCAGA":"CC30",
"ATAACCGGTCGGAGCCGATA":"CC32",
"GGGGCACAGCGCTGAGTGTG":"CC34",
"GACCCATGGGTCAGGGGTGG":"CC35",
"AGGATGCGGACCGTGCTAGT":"CC36",
"CCCAGTAGCTGTCGGTAGCG":"CC11",
"GGGGTGGACTGAGGCTGCGA":"CC14",
"GGGGGCGAGTCTGTTCGTGC":"CC15",
"GTATATTCTAGCGCTGTGGC":"CC2",
"GCTCTACATTTGTTACGCTA":"CC22",
"TCAAGACAGCCAATGGCCTA":"CC26",
"ACGGAATGGTTCTGCGTGTT":"CC7",
"GTGCCTGATGCGGGTTTGGG":"CC3",
"TAAGTGGGCTACGTGTATGG":"CC33"} #good for seqlib13 (removed non-existent array guide (CDC3g8, CC40)
Row_key = {"CC8-CC5":1,
"CC8-CC8":2,
"CC8-CC16":3,
"CC8-CC17":4,
"CC8-CC19":5,
"CC8-CC20":6,
"CC8-CC23":7,
"CC8-CC25":8,
"CC8-CC27":9,
"CC8-CC28":10,
"CC8-CC30":11,
"CC8-CC32":12,
"CC8-CC34":13,
"CC8-CC35":14,
"CC8-CC36":15,
"CC8-CC11":16,
"CC8-CC14":17,
"CC8-CC15":18,
"CC8-CC2":19,
"CC8-CC22":20,
"CC8-CC26":21,
"CC8-CC7":22,
"CC16-CC5":23,
"CC16-CC8":24,
"CC16-CC16":25,
"CC16-CC17":26,
"CC16-CC19":27,
"CC16-CC20":28,
"CC16-CC23":29,
"CC16-CC25":30,
"CC16-CC27":31,
"CC16-CC28":32,
"CC16-CC30":33,
"CC16-CC32":34,
"CC16-CC34":35,
"CC16-CC35":36,
"CC16-CC36":37,
"CC16-CC11":38,
"CC16-CC14":39,
"CC16-CC15":40,
"CC16-CC2":41,
"CC16-CC22":42,
"CC16-CC26":43,
"CC16-CC7":44,
"CC17-CC5":45,
"CC17-CC8":46,
"CC17-CC16":47,
"CC17-CC17":48,
"CC17-CC19":49,
"CC17-CC20":50,
"CC17-CC23":51,
"CC17-CC25":52,
"CC17-CC27":53,
"CC17-CC28":54,
"CC17-CC30":55,
"CC17-CC32":56,
"CC17-CC34":57,
"CC17-CC35":58,
"CC17-CC36":59,
"CC17-CC11":60,
"CC17-CC14":61,
"CC17-CC15":62,
"CC17-CC2":63,
"CC17-CC22":64,
"CC17-CC26":65,
"CC17-CC7":66,
"CC8_BC2-CC5":67,
"CC8_BC2-CC8":68,
"CC8_BC2-CC16":69,
"CC8_BC2-CC17":70,
"CC8_BC2-CC19":71,
"CC8_BC2-CC20":72,
"CC8_BC2-CC23":73,
"CC8_BC2-CC25":74,
"CC8_BC2-CC27":75,
"CC8_BC2-CC28":76,
"CC8_BC2-CC30":77,
"CC8_BC2-CC32":78,
"CC8_BC2-CC34":79,
"CC8_BC2-CC35":80,
"CC8_BC2-CC36":81,
"CC8_BC2-CC11":82,
"CC8_BC2-CC14":83,
"CC8_BC2-CC15":84,
"CC8_BC2-CC2":85,
"CC8_BC2-CC22":86,
"CC8_BC2-CC26":87,
"CC8_BC2-CC7":88,
"CC16_BC2-CC5":89,
"CC16_BC2-CC8":90,
"CC16_BC2-CC16":91,
"CC16_BC2-CC17":92,
"CC16_BC2-CC19":93,
"CC16_BC2-CC20":94,
"CC16_BC2-CC23":95,
"CC16_BC2-CC25":96,
"CC16_BC2-CC27":97,
"CC16_BC2-CC28":98,
"CC16_BC2-CC30":99,
"CC16_BC2-CC32":100,
"CC16_BC2-CC34":101,
"CC16_BC2-CC35":102,
"CC16_BC2-CC36":103,
"CC16_BC2-CC11":104,
"CC16_BC2-CC14":105,
"CC16_BC2-CC15":106,
"CC16_BC2-CC2":107,
"CC16_BC2-CC22":108,
"CC16_BC2-CC26":109,
"CC16_BC2-CC7":110,
"PRE7g7-CC5":111,
"PRE7g7-CC8":112,
"PRE7g7-CC16":113,
"PRE7g7-CC17":114,
"PRE7g7-CC19":115,
"PRE7g7-CC20":116,
"PRE7g7-CC23":117,
"PRE7g7-CC25":118,
"PRE7g7-CC27":119,
"PRE7g7-CC28":120,
"PRE7g7-CC30":121,
"PRE7g7-CC32":122,
"PRE7g7-CC34":123,
"PRE7g7-CC35":124,
"PRE7g7-CC36":125,
"PRE7g7-CC11":126,
"PRE7g7-CC14":127,
"PRE7g7-CC15":128,
"PRE7g7-CC2":129,
"PRE7g7-CC22":130,
"PRE7g7-CC26":131,
"PRE7g7-CC7":132,
"PRE4g9-CC5":133,
"PRE4g9-CC8":134,
"PRE4g9-CC16":135,
"PRE4g9-CC17":136,
"PRE4g9-CC19":137,
"PRE4g9-CC20":138,
"PRE4g9-CC23":139,
"PRE4g9-CC25":140,
"PRE4g9-CC27":141,
"PRE4g9-CC28":142,
"PRE4g9-CC30":143,
"PRE4g9-CC32":144,
"PRE4g9-CC34":145,
"PRE4g9-CC35":146,
"PRE4g9-CC36":147,
"PRE4g9-CC11":148,
"PRE4g9-CC14":149,
"PRE4g9-CC15":150,
"PRE4g9-CC2":151,
"PRE4g9-CC22":152,
"PRE4g9-CC26":153,
"PRE4g9-CC7":154,
"PRE4g3-CC5":155,
"PRE4g3-CC8":156,
"PRE4g3-CC16":157,
"PRE4g3-CC17":158,
"PRE4g3-CC19":159,
"PRE4g3-CC20":160,
"PRE4g3-CC23":161,
"PRE4g3-CC25":162,
"PRE4g3-CC27":163,
"PRE4g3-CC28":164,
"PRE4g3-CC30":165,
"PRE4g3-CC32":166,
"PRE4g3-CC34":167,
"PRE4g3-CC35":168,
"PRE4g3-CC36":169,
"PRE4g3-CC11":170,
"PRE4g3-CC14":171,
"PRE4g3-CC15":172,
"PRE4g3-CC2":173,
"PRE4g3-CC22":174,
"PRE4g3-CC26":175,
"PRE4g3-CC7":176,
"RPN5g1-CC5":177,
"RPN5g1-CC8":178,
"RPN5g1-CC16":179,
"RPN5g1-CC17":180,
"RPN5g1-CC19":181,
"RPN5g1-CC20":182,
"RPN5g1-CC23":183,
"RPN5g1-CC25":184,
"RPN5g1-CC27":185,
"RPN5g1-CC28":186,
"RPN5g1-CC30":187,
"RPN5g1-CC32":188,
"RPN5g1-CC34":189,
"RPN5g1-CC35":190,
"RPN5g1-CC36":191,
"RPN5g1-CC11":192,
"RPN5g1-CC14":193,
"RPN5g1-CC15":194,
"RPN5g1-CC2":195,
"RPN5g1-CC22":196,
"RPN5g1-CC26":197,
"RPN5g1-CC7":198,
"COG3g1-CC5":199,
"COG3g1-CC8":200,
"COG3g1-CC16":201,
"COG3g1-CC17":202,
"COG3g1-CC19":203,
"COG3g1-CC20":204,
"COG3g1-CC23":205,
"COG3g1-CC25":206,
"COG3g1-CC27":207,
"COG3g1-CC28":208,
"COG3g1-CC30":209,
"COG3g1-CC32":210,
"COG3g1-CC34":211,
"COG3g1-CC35":212,
"COG3g1-CC36":213,
"COG3g1-CC11":214,
"COG3g1-CC14":215,
"COG3g1-CC15":216,
"COG3g1-CC2":217,
"COG3g1-CC22":218,
"COG3g1-CC26":219,
"COG3g1-CC7":220,
"SED5g5-CC5":221,
"SED5g5-CC8":222,
"SED5g5-CC16":223,
"SED5g5-CC17":224,
"SED5g5-CC19":225,
"SED5g5-CC20":226,
"SED5g5-CC23":227,
"SED5g5-CC25":228,
"SED5g5-CC27":229,
"SED5g5-CC28":230,
"SED5g5-CC30":231,
"SED5g5-CC32":232,
"SED5g5-CC34":233,
"SED5g5-CC35":234,
"SED5g5-CC36":235,
"SED5g5-CC11":236,
"SED5g5-CC14":237,
"SED5g5-CC15":238,
"SED5g5-CC2":239,
"SED5g5-CC22":240,
"SED5g5-CC26":241,
"SED5g5-CC7":242,
"SEC22g1-CC5":243,
"SEC22g1-CC8":244,
"SEC22g1-CC16":245,
"SEC22g1-CC17":246,
"SEC22g1-CC19":247,
"SEC22g1-CC20":248,
"SEC22g1-CC23":249,
"SEC22g1-CC25":250,
"SEC22g1-CC27":251,
"SEC22g1-CC28":252,
"SEC22g1-CC30":253,
"SEC22g1-CC32":254,
"SEC22g1-CC34":255,
"SEC22g1-CC35":256,
"SEC22g1-CC36":257,
"SEC22g1-CC11":258,
"SEC22g1-CC14":259,
"SEC22g1-CC15":260,
"SEC22g1-CC2":261,
"SEC22g1-CC22":262,
"SEC22g1-CC26":263,
"SEC22g1-CC7":264,
"SEC22g2-CC5":265,
"SEC22g2-CC8":266,
"SEC22g2-CC16":267,
"SEC22g2-CC17":268,
"SEC22g2-CC19":269,
"SEC22g2-CC20":270,
"SEC22g2-CC23":271,
"SEC22g2-CC25":272,
"SEC22g2-CC27":273,
"SEC22g2-CC28":274,
"SEC22g2-CC30":275,
"SEC22g2-CC32":276,
"SEC22g2-CC34":277,
"SEC22g2-CC35":278,
"SEC22g2-CC36":279,
"SEC22g2-CC11":280,
"SEC22g2-CC14":281,
"SEC22g2-CC15":282,
"SEC22g2-CC2":283,
"SEC22g2-CC22":284,
"SEC22g2-CC26":285,
"SEC22g2-CC7":286,
"COG8g2-CC5":287,
"COG8g2-CC8":288,
"COG8g2-CC16":289,
"COG8g2-CC17":290,
"COG8g2-CC19":291,
"COG8g2-CC20":292,
"COG8g2-CC23":293,
"COG8g2-CC25":294,
"COG8g2-CC27":295,
"COG8g2-CC28":296,
"COG8g2-CC30":297,
"COG8g2-CC32":298,
"COG8g2-CC34":299,
"COG8g2-CC35":300,
"COG8g2-CC36":301,
"COG8g2-CC11":302,
"COG8g2-CC14":303,
"COG8g2-CC15":304,
"COG8g2-CC2":305,
"COG8g2-CC22":306,
"COG8g2-CC26":307,
"COG8g2-CC7":308,
"GET2g2-CC5":309,
"GET2g2-CC8":310,
"GET2g2-CC16":311,
"GET2g2-CC17":312,
"GET2g2-CC19":313,
"GET2g2-CC20":314,
"GET2g2-CC23":315,
"GET2g2-CC25":316,
"GET2g2-CC27":317,
"GET2g2-CC28":318,
"GET2g2-CC30":319,
"GET2g2-CC32":320,
"GET2g2-CC34":321,
"GET2g2-CC35":322,
"GET2g2-CC36":323,
"GET2g2-CC11":324,
"GET2g2-CC14":325,
"GET2g2-CC15":326,
"GET2g2-CC2":327,
"GET2g2-CC22":328,
"GET2g2-CC26":329,
"GET2g2-CC7":330,
"IMP4g6-CC5":331,
"IMP4g6-CC8":332,
"IMP4g6-CC16":333,
"IMP4g6-CC17":334,
"IMP4g6-CC19":335,
"IMP4g6-CC20":336,
"IMP4g6-CC23":337,
"IMP4g6-CC25":338,
"IMP4g6-CC27":339,
"IMP4g6-CC28":340,
"IMP4g6-CC30":341,
"IMP4g6-CC32":342,
"IMP4g6-CC34":343,
"IMP4g6-CC35":344,
"IMP4g6-CC36":345,
"IMP4g6-CC11":346,
"IMP4g6-CC14":347,
"IMP4g6-CC15":348,
"IMP4g6-CC2":349,
"IMP4g6-CC22":350,
"IMP4g6-CC26":351,
"IMP4g6-CC7":352,
"DIP2g5-CC5":353,
"DIP2g5-CC8":354,
"DIP2g5-CC16":355,
"DIP2g5-CC17":356,
"DIP2g5-CC19":357,
"DIP2g5-CC20":358,
"DIP2g5-CC23":359,
"DIP2g5-CC25":360,
"DIP2g5-CC27":361,
"DIP2g5-CC28":362,
"DIP2g5-CC30":363,
"DIP2g5-CC32":364,
"DIP2g5-CC34":365,
"DIP2g5-CC35":366,
"DIP2g5-CC36":367,
"DIP2g5-CC11":368,
"DIP2g5-CC14":369,
"DIP2g5-CC15":370,
"DIP2g5-CC2":371,
"DIP2g5-CC22":372,
"DIP2g5-CC26":373,
"DIP2g5-CC7":374,
"PWP2g2_BC1-CC5":375,
"PWP2g2_BC1-CC8":376,
"PWP2g2_BC1-CC16":377,
"PWP2g2_BC1-CC17":378,
"PWP2g2_BC1-CC19":379,
"PWP2g2_BC1-CC20":380,
"PWP2g2_BC1-CC23":381,
"PWP2g2_BC1-CC25":382,
"PWP2g2_BC1-CC27":383,
"PWP2g2_BC1-CC28":384,
"PWP2g2_BC1-CC30":385,
"PWP2g2_BC1-CC32":386,
"PWP2g2_BC1-CC34":387,
"PWP2g2_BC1-CC35":388,
"PWP2g2_BC1-CC36":389,
"PWP2g2_BC1-CC11":390,
"PWP2g2_BC1-CC14":391,
"PWP2g2_BC1-CC15":392,
"PWP2g2_BC1-CC2":393,
"PWP2g2_BC1-CC22":394,
"PWP2g2_BC1-CC26":395,
"PWP2g2_BC1-CC7":396,
"PWP2g2_BC2-CC5":397,
"PWP2g2_BC2-CC8":398,
"PWP2g2_BC2-CC16":399,
"PWP2g2_BC2-CC17":400,
"PWP2g2_BC2-CC19":401,
"PWP2g2_BC2-CC20":402,
"PWP2g2_BC2-CC23":403,
"PWP2g2_BC2-CC25":404,
"PWP2g2_BC2-CC27":405,
"PWP2g2_BC2-CC28":406,
"PWP2g2_BC2-CC30":407,
"PWP2g2_BC2-CC32":408,
"PWP2g2_BC2-CC34":409,
"PWP2g2_BC2-CC35":410,
"PWP2g2_BC2-CC36":411,
"PWP2g2_BC2-CC11":412,
"PWP2g2_BC2-CC14":413,
"PWP2g2_BC2-CC15":414,
"PWP2g2_BC2-CC2":415,
"PWP2g2_BC2-CC22":416,
"PWP2g2_BC2-CC26":417,
"PWP2g2_BC2-CC7":418,
"TIF6g8-CC5":419,
"TIF6g8-CC8":420,
"TIF6g8-CC16":421,
"TIF6g8-CC17":422,
"TIF6g8-CC19":423,
"TIF6g8-CC20":424,
"TIF6g8-CC23":425,
"TIF6g8-CC25":426,
"TIF6g8-CC27":427,
"TIF6g8-CC28":428,
"TIF6g8-CC30":429,
"TIF6g8-CC32":430,
"TIF6g8-CC34":431,
"TIF6g8-CC35":432,
"TIF6g8-CC36":433,
"TIF6g8-CC11":434,
"TIF6g8-CC14":435,
"TIF6g8-CC15":436,
"TIF6g8-CC2":437,
"TIF6g8-CC22":438,
"TIF6g8-CC26":439,
"TIF6g8-CC7":440,
"RPF1g3-CC5":441,
"RPF1g3-CC8":442,
"RPF1g3-CC16":443,
"RPF1g3-CC17":444,
"RPF1g3-CC19":445,
"RPF1g3-CC20":446,
"RPF1g3-CC23":447,
"RPF1g3-CC25":448,
"RPF1g3-CC27":449,
"RPF1g3-CC28":450,
"RPF1g3-CC30":451,
"RPF1g3-CC32":452,
"RPF1g3-CC34":453,
"RPF1g3-CC35":454,
"RPF1g3-CC36":455,
"RPF1g3-CC11":456,
"RPF1g3-CC14":457,
"RPF1g3-CC15":458,
"RPF1g3-CC2":459,
"RPF1g3-CC22":460,
"RPF1g3-CC26":461,
"RPF1g3-CC7":462,
"MAK16g1-CC5":463,
"MAK16g1-CC8":464,
"MAK16g1-CC16":465,
"MAK16g1-CC17":466,
"MAK16g1-CC19":467,
"MAK16g1-CC20":468,
"MAK16g1-CC23":469,
"MAK16g1-CC25":470,
"MAK16g1-CC27":471,
"MAK16g1-CC28":472,
"MAK16g1-CC30":473,
"MAK16g1-CC32":474,
"MAK16g1-CC34":475,
"MAK16g1-CC35":476,
"MAK16g1-CC36":477,
"MAK16g1-CC11":478,
"MAK16g1-CC14":479,
"MAK16g1-CC15":480,
"MAK16g1-CC2":481,
"MAK16g1-CC22":482,
"MAK16g1-CC26":483,
"MAK16g1-CC7":484,
"YCR016Wg4-CC5":485,
"YCR016Wg4-CC8":486,
"YCR016Wg4-CC16":487,
"YCR016Wg4-CC17":488,
"YCR016Wg4-CC19":489,
"YCR016Wg4-CC20":490,
"YCR016Wg4-CC23":491,
"YCR016Wg4-CC25":492,
"YCR016Wg4-CC27":493,
"YCR016Wg4-CC28":494,
"YCR016Wg4-CC30":495,
"YCR016Wg4-CC32":496,
"YCR016Wg4-CC34":497,
"YCR016Wg4-CC35":498,
"YCR016Wg4-CC36":499,
"YCR016Wg4-CC11":500,
"YCR016Wg4-CC14":501,
"YCR016Wg4-CC15":502,
"YCR016Wg4-CC2":503,
"YCR016Wg4-CC22":504,
"YCR016Wg4-CC26":505,
"YCR016Wg4-CC7":506,
"YLR050Cg1-CC5":507,
"YLR050Cg1-CC8":508,
"YLR050Cg1-CC16":509,
"YLR050Cg1-CC17":510,
"YLR050Cg1-CC19":511,
"YLR050Cg1-CC20":512,
"YLR050Cg1-CC23":513,
"YLR050Cg1-CC25":514,
"YLR050Cg1-CC27":515,
"YLR050Cg1-CC28":516,
"YLR050Cg1-CC30":517,
"YLR050Cg1-CC32":518,
"YLR050Cg1-CC34":519,
"YLR050Cg1-CC35":520,
"YLR050Cg1-CC36":521,
"YLR050Cg1-CC11":522,
"YLR050Cg1-CC14":523,
"YLR050Cg1-CC15":524,
"YLR050Cg1-CC2":525,
"YLR050Cg1-CC22":526,
"YLR050Cg1-CC26":527,
"YLR050Cg1-CC7":528,
"SAP30g7-CC5":529,
"SAP30g7-CC8":530,
"SAP30g7-CC16":531,
"SAP30g7-CC17":532,
"SAP30g7-CC19":533,
"SAP30g7-CC20":534,
"SAP30g7-CC23":535,
"SAP30g7-CC25":536,
"SAP30g7-CC27":537,
"SAP30g7-CC28":538,
"SAP30g7-CC30":539,
"SAP30g7-CC32":540,
"SAP30g7-CC34":541,
"SAP30g7-CC35":542,
"SAP30g7-CC36":543,
"SAP30g7-CC11":544,
"SAP30g7-CC14":545,
"SAP30g7-CC15":546,
"SAP30g7-CC2":547,
"SAP30g7-CC22":548,
"SAP30g7-CC26":549,
"SAP30g7-CC7":550,
"CC8-RPL15A-NRg-4":551,
"CC8-RPL15A-NRg-5":552,
"CC8-KRE33-TRg-1":553,
"CC8-PMI40-NRg-1":554,
"CC8-NOP19-NRg-3":555,
"CC8-SRP14-NRg-4":556,
"CC8-SEC27-TRg-2":557,
"CC8-GPI14-TRg-3":558,
"CC8-PAH1-TRg-7":559,
"CC8-PAH1-TRg-6":560,
"CC8-PAH1-TRg-5":561,
"CC8-PAH1-TRg-3":562,
"CC8-COG3-TRg-1":563,
"CC8-HTS1-NRg-5":564,
"CC8-MSN5-TRg-7":565,
"CC8-ERG26-TRg-1":566,
"CC8-SMD2-TRg-5":567,
"CC8-SMD2-TRg-4":568,
"CC8-SMD2-TRg-1":569,
"CC8-PRE7-TRg-4":570,
"CC8-PRE7-TRg-7":571,
"CC8-SEC6-TRg-3":572,
"CC8-ESF2-NRg-1":573,
"CC8-ESF2-NRg-3":574,
"CC8-AFG2-TRg-2":575,
"CC8-RRP36-TRg-3":576,
"CC8-RRP36-TRg-5":577,
"CC8-GCR1-NRg-2":578,
"CC8-PRE4-NRg-4":579,
"CC8-PRE4-NRg-9":580,
"CC8-DSN1-NRg-2":581,
"CC8-GPI11-TRg-3":582,
"CC8-POP3-TRg-1":583,
"CC8-MNE1-TRg-5":584,
"CC8-RRP12-NRg-1":585,
"CC8-RSC6-TRg-2":586,
"CC8-CDC25-TRg-1":587,
"CC8-CDC25-TRg-9":588,
"CC8-YPP1-NRg-3":589,
"CC8-NFS1-NRg-9":590,
"CC8-NFS1-NRg-8":591,
"CC8-UBA2-TRg-1":592,
"CC8-ARP2-NRg-3":593,
"CC8-MAK16-TRg-1":594,
"CC8-CEP3-NRg-1":595,
"CC8-GUK1-TRg-5":596,
"CC8-GUK1-TRg-2":597,
"CC8-GPI12-NRg-6":598,
"CC8-RPS5-NRg-5":599,
"CC8-RPS5-NRg-2":600,
"CC8-RPC19-NRg-1":601,
"CC8-TIM54-TRg-1":602,
"CC8-TEN1-TRg-2":603,
"CC8-SAH1-NRg-4":604,
"CC8-SAH1-NRg-5":605,
"CC8-SAH1-NRg-3":606,
"CC8-ATP15-NRg-5":607,
"CC8-SCD5-TRg-5":608,
"CC8-ARB1-NRg-2":609,
"CC8-ARB1-NRg-4":610,
"CC8-PUP2-TRg-1":611,
"CC8-CCT8-TRg-2":612,
"CC8-MCM4-TRg-1":613,
"CC8-LSM4-TRg-1":614,
"CC8-NOP53-NRg-1":615,
"CC8-ATP3-TRg-4":616,
"CC8-AFG2-NRg-3":617,
"CC8-PRO3-NRg-3":618,
"CC8-NRD1-NRg-10":619,
"CC8-SEC61-TRg-2":620,
"CC8-RHO3-TRg-4":621,
"CC8-SNF2-TRg-6":622,
"CC8-SMD2-NRg-3":623,
"CC8-RSC4-TRg-2":624,
"CC8-RSC4-TRg-1":625,
"CC8-TIF34-TRg-2":626,
"CC8-BET1-NRg-1":627,
"CC8-CDC8-NRg-2":628,
"CC8-PRP42-TRg-2":629,
"CC8-RRB1-TRg-2":630,
"CC8-SPC24-TRg-1":631,
"CC8-ILS1-NRg-1":632,
"CC8-GFA1-TRg-2":633,
"CC8-SEC21-NRg-10":634,
"CC8-RPC10-NRg-1":635,
"CC8-RPB10-TRg-3":636,
"CC8-RPB10-TRg-2":637,
"CC8-YNL181W-TRg-1":638,
"CC8-RAD3-NRg-1":639,
"CC8-NOP10-TRg-1":640,
"CC8-BFR2-TRg-3":641,
"CC8-MCM2-TRg-6":642,
"CC8-MCM2-TRg-4":643,
"CC8-MPP10-TRg-1":644,
"CC8-RET2-TRg-4":645,
"CC8-RET2-TRg-1":646,
"CC8-RPS2-NRg-1":647,
"CC8-RPS2-NRg-2":648,
"CC8-ORC4-NRg-3":649,
"CC8-TIP20-TRg-7":650,
"CC8-SMT3-TRg-1":651,
"CC8-MSS18-NRg-6":652,
"CC8-YEF3-NRg-9":653,
"CC8-ASK1-NRg-1":654,
"CC8-SMC1-TRg-1":655,
"CC8-NIP1-NRg-1":656,
"CC8-RPP1-NRg-1":657,
"CC8-YDJ1-TRg-6":658,
"CC8-SUB2-NRg-1":659,
"CC8-TIM10-NRg-8":660,
"CC8-TIM10-NRg-4":661,
"CC8-TIM10-NRg-7":662,
"CC8-SKI6-TRg-4":663,
"CC8-TUB4-TRg-1":664,
"CC8-CDC37-NRg-2":665,
"CC8-ISD11-TRg-3":666,
"CC8-YOS1-TRg-4":667,
"CC8-SSC1-TRg-6":668,
"CC8-MTR3-TRg-5":669,
"CC8-MTR3-TRg-6":670,
"CC8-TFA1-TRg-2":671,
"CC8-CDC3-NRg-3":672,
"CC8-ERG25-TA-18":673,
"CC8-RPB11-TRg-4":674,
"CC8-RPB11-TRg-1":675,
"CC8-RPB11-TRg-2":676,
"CC8-DED1-TRg-3":677,
"CC8-DED1-TRg-1":678,
"CC8-DED1-TRg-6":679,
"CC8-DED1-TRg-4":680,
"CC8-RPL10-NRg-5":681,
"CC8-RPL10-NRg-4":682,
"CC8-EFB1-NRg-1":683,
"CC8-EFB1-NRg-5":684,
"CC8-EFB1-NRg-4":685,
"CC8-RPT3-NRg-1":686,
"CC8-SAC6-TRg-8":687,
"CC8-SAC6-TRg-4":688,
"CC8-SAC6-TRg-5":689,
"CC8-SAC6-TRg-3":690,
"CC8-DIM1-TRg-5":691,
"CC8-DIM1-TRg-7":692,
"CC8-RPC17-NRg-1":693,
"CC8-RPC17-NRg-2":694,
"CC8-YDR341C-TRg-1":695,
"CC8-RAP1-NRg-8":696,
"CC8-RAP1-NRg-5":697,
"CC8-RAP1-NRg-2":698,
"CC8-SEC26-NRg-3":699,
"CC8-SPP41-TRg-3":700,
"CC8-TAP42-NRg-1":701,
"CC8-PGA2-TRg-6":702,
"CC8-BRL1-TRg-1":703,
"CC8-FOL2-TRg-1":704,
"CC8-NAB3-NRg-5":705,
"CC8-SNF4-TRg-4":706,
"CC8-HRR25-TRg-2":707,
"CC8-TRS23-TRg-4":708,
"CC8-CTR86-TRg-4":709,
"CC8-RPB5-TRg-5":710,
"CC8-SPN1-NRg-2":711,
"CC8-SPN1-NRg-1":712,
"CC8-SEC61-NRg-1":713,
"CC8-SEC61-NRg-7":714,
"CC8-TUS1-TRg-3":715,
"CC8-OLE1-NRg-2":716,
"CC8-AFG2-TRg-1":717,
"CC8-TOA2-NRg-1":718,
"CC8-USO1-TRg-1":719,
"CC8-UTP22-NRg-2":720,
"CC8-RIB1-TRg-3":721,
"CC8-RIB1-TRg-7":722,
"CC8-RIB1-TRg-4":723,
"CC8-COG1-TRg-1":724,
"CC8-RPL32-NRg-2":725,
"CC8-GLC7-NRg-3":726,
"CC8-GLC7-NRg-4":727,
"CC8-HSF1-TRg-2":728,
"CC8-DAM1-NRg-5":729,
"CC8-SEC18-TRg-4":730,
"CC8-SEC18-TRg-5":731,
"CC8-PAB1-NRg-3":732,
"CC8-POP8-TRg-2":733,
"CC8-PAB1-NRg-4":734,
"CC8-BIG1-TRg-4":735,
"CC8-BIG1-TRg-5":736,
"CC8-BIG1-TRg-6":737,
"CC8-RPO41-NRg-1":738,
"CC8-RVB2-NRg-2":739,
"CC8-PET117-NRg-8":740,
"CC8-VPS45-NRg-9":741,
"CC8-YCG1-NRg-1":742,
"CC8-NOC4-NRg-1":743,
"CC8-NMD3-NRg-2":744,
"CC8-DRS1-TRg-2":745,
"CC8-HTB1-NRg-2":746,
"CC8-IPI1-TRg-2":747,
"CC8-SEC18-NRg-1":748,
"CC8-SEC18-NRg-2":749,
"CC8-JIP5-NRg-2":750,
"CC8-YPT1-TRg-3":751,
"CC8-YPT1-TRg-2":752,
"CC8-CLF1-NRg-2":753,
"CC8-SNF2-NRg-7":754,
"CC8-SNF2-NRg-4":755,
"CC8-RPL25-NRg-1":756,
"CC8-NOP56-TRg-1":757,
"CC8-NOP56-TRg-2":758,
"CC8-TRS31-TRg-1":759,
"CC8-DBF4-TRg-2":760,
"CC8-DBF4-TRg-1":761,
"CC8-RPC19-TRg-4":762,
"CC8-RPC19-TRg-6":763,
"CC8-RPC19-TRg-3":764,
"CC8-ROK1-NRg-1":765,
"CC8-CDC33-TRg-4":766,
"CC8-DHR2-TRg-3":767,
"CC8-RRP42-NRg-5":768,
"CC8-CLF1-TRg-1":769,
"CC8-ERG11-NA-16":770,
"CC8-VAS1-NRg-4":771,
"CC8-PIK1-NRg-2":772,
"CC8-SAR1-NRg-7":773,
"CC8-SAR1-NRg-4":774,
"CC8-RPS3-TRg-1":775,
"CC8-YTM1-TRg-2":776,
"CC8-SUI3-NRg-5":777,
"CC8-SUI3-NRg-2":778,
"CC8-RRP7-TRg-4":779,
"CC8-RRP7-TRg-6":780,
"CC8-NIP7-TRg-2":781,
"CC8-MDM35-TRg-1":782,
"CC8-ALA1-NRg-1":783,
"CC8-DOA4-NRg-2":784,
"CC8-RPS13-NRg-1":785,
"CC8-YSF3-TRg-2":786,
"CC8-RPS2-NRg-11":787,
"CC8-SSL1-TRg-10":788,
"CC8-NIP7-TRg-1":789,
"CC8-LST8-NRg-1":790,
"CC8-TAF4-TRg-3":791,
"CC8-HAS1-TRg-2":792,
"CC8-GLC7-TRg-2":793,
"CC8-CDC45-NRg-1":794,
"CC8-SEC22-NRg-8":795,
"CC8-YOS1-TRg-2":796,
"CC8-RBA50-TRg-3":797,
"CC8-SPP41-NRg-2":798,
"CC8-PRP46-TRg-2":799,
"CC8-PGA2-NRg-1":800,
"CC8-CBF5-TRg-3":801,
"CC8-TCP1-NRg-3":802,
"CC8-TCP1-NRg-2":803,
"CC8-ERG26-NRg-2":804,
"CC8-ERG26-NRg-4":805,
"CC8-MES1-TRg-5":806,
"CC8-HTS1-TRg-2":807,
"CC8-SSS1-TRg-3":808,
"CC8-SSS1-TRg-2":809,
"CC8-SYS1-TRg-7":810,
"CC8-SYS1-TRg-2":811,
"CC8-SYS1-TRg-1":812,
"CC8-BFR2-TRg-1":813,
"CC8-EOS1-TRg-3":814,
"CC8-TAF4-NRg-1":815,
"CC8-ARL3-NRg-8":816,
"CC8-RPN5-NRg-1":817,
"CC8-TIM9-NRg-2":818,
"CC8-NUP57-NRg-3":819,
"CC8-VPS4-TRg-1":820,
"CC8-CDC3-TRg-4":821,
"CC8-BBP1-NRg-1":822,
"CC8-BBP1-NRg-2":823,
"CC8-USE1-NRg-3":824,
"CC8-CCT7-TRg-1":825,
"CC8-SAH1-TRg-3":826,
"CC8-CHS2-TRg-1":827,
"CC8-DPM1-TRg-2":828,
"CC8-BBP1-TRg-1":829,
"CC8-NRD1-TRg-4":830,
"CC8-RPB3-NRg-1":831,
"CC8-PHO85-NRg-6":832,
"CC8-SNF6-TRg-6":833,
"CC8-PRP38-NRg-2":834,
"CC8-OAR1-NRg-3":835,
"CC8-ROX3-NRg-1":836,
"CC8-YPP1-TRg-6":837,
"CC8-CBF2-NRg-8":838,
"CC8-SPT6-TRg-5":839,
"CC8-SEC10-NRg-1":840,
"CC8-NSL1-NRg-3":841,
"CC8-NRD1-NRg-8":842,
"CC8-RPB3-TRg-1":843,
"CC8-NRD1-NRg-4":844,
"CC8-RVB1-TRg-2":845,
"CC8-TIF5-NRg-8":846,
"CC8-EOS1-NRg-1":847,
"CC8-ERG25-NA-26":848,
"CC8-MSL5-NRg-4":849,
"CC8-SEC24-TRg-2":850,
"CC8-RPL30-NRg-5":851,
"CC8-SNU71-NRg-3":852,
"CC8-CDC33-NRg-1":853,
"CC8-RPN6-TRg-4":854,
"CC8-NAB2-TRg-4":855,
"CC8-NAB2-TRg-6":856,
"CC8-YTM1-NRg-1":857,
"CC8-OLE1-TRg-8":858,
"CC8-OLE1-TRg-1":859,
"CC8-UTP7-TRg-4":860,
"CC8-ACT1-NRg-6":861,
"CC8-RPL18A-NRg-3":862,
"CC8-BRX1-NRg-1":863,
"CC8-NAF1-TRg-8":864,
"CC8-NAF1-TRg-6":865,
"CC8-NAF1-TRg-4":866,
"CC8-CDC8-TRg-2":867,
"CC8-NSE4-TRg-1":868,
"CC8-PAB1-NRg-2":869,
"CC8-PRP43-TRg-4":870,
"CC8-SEC2-NRg-3":871,
"CC8-SEC2-NRg-6":872,
"CC8-MPP10-NRg-5":873,
"CC8-YDR355C-TRg-2":874,
"CC8-YLR339C-TRg-9":875,
"CC8-SNM1-TRg-2":876,
"CC8-ALR1-NRg-4":877,
"CC8-ALR1-NRg-1":878,
"CC8-ALR1-NRg-3":879,
"CC8-RPL10-TRg-1":880,
"CC8-RPL28-TRg-2":881,
"CC8-UTP25-TRg-1":882,
"CC8-POB3-TRg-1":883,
"CC8-POB3-TRg-3":884,
"CC8-POB3-TRg-2":885,
"CC8-MED11-TRg-1":886,
"CC8-ISA1-TRg-15":887,
"CC8-RRP1-NRg-1":888,
"CC8-MES1-NRg-1":889,
"CC8-SEC13-NRg-5":890,
"CC8-MCM2-NRg-2":891,
"CC8-ALA1-TRg-4":892,
"CC8-MTG2-TRg-5":893,
"CC8-TIF35-NRg-3":894,
"CC8-NSE1-TRg-3":895,
"CC8-NSE1-TRg-4":896,
"CC8-MOB2-NRg-6":897,
"CC8-VRG4-NRg-3":898,
"CC8-PRP9-TRg-3":899,
"CC8-HYM1-TRg-5":900,
"CC8-POP1-TRg-5":901,
"CC8-POP1-TRg-9":902,
"CC8-RPL17A-TRg-1":903,
"CC8-SLD2-TRg-1":904,
"CC8-CDC48-NRg-7":905,
"CC8-FHL1-NRg-2":906,
"CC8-BET3-NRg-7":907,
"CC8-MAK21-TRg-1":908,
"CC8-BRN1-TRg-4":909,
"CC8-FBA1-NRg-3":910,
"CC8-CDC42-TRg-6":911,
"CC8-CDC42-TRg-7":912,
"CC8-COG4-NRg-1":913,
"CC8-ATP3-NRg-3":914,
"CC8-ATP3-NRg-2":915,
"CC8-SMP3-TRg-5":916,
"CC8-CFT2-NRg-2":917,
"CC8-FAS2-TRg-5":918,
"CC8-DBP2-NRg-3":919,
"CC8-DBP2-NRg-2":920,
"CC8-MPS2-NRg-4":921,
"CC8-ARC35-TRg-2":922,
"CC8-ARC35-TRg-5":923,
"CC8-MRD1-TRg-1":924,
"CC8-RLP7-TRg-1":925,
"CC8-SPC34-TRg-1":926,
"CC8-CDC45-TRg-2":927,
"CC8-GCD6-TRg-3":928,
"CC8-GCD6-TRg-4":929,
"CC8-YPT6-NRg-2":930,
"CC8-RPS13-TRg-2":931,
"CC8-IPI3-TRg-3":932,
"CC8-TIF5-NRg-9":933,
"CC8-TIF5-NRg-7":934,
"CC8-TIF5-NRg-6":935,
"CC8-NAB3-TRg-3":936,
"CC8-GCD2-TRg-1":937,
"CC8-UBA1-TRg-2":938,
"CC8-SLD3-TRg-6":939,
"CC8-LCB1-TRg-5":940,
"CC8-TOA2-TRg-6":941,
"CC8-TOA2-TRg-1":942,
"CC8-TOA2-TRg-3":943,
"CC8-LSM2-TRg-1":944,
"CC8-YML6-TRg-13":945,
"CC8-YML6-TRg-12":946,
"CC8-UTP15-NRg-1":947,
"CC8-TIF6-NRg-8":948,
"CC8-SUP35-NRg-1":949,
"CC8-MPP10-NRg-1":950,
"CC8-SWI3-TRg-7":951,
"CC8-SSN3-NRg-2":952,
"CC8-SEC13-NRg-7":953,
"CC8-RPS15-NRg-3":954,
"CC8-RPL3-TRg-2":955,
"CC8-FBA1-NRg-2":956,
"CC8-FBA1-NRg-1":957,
"CC8-FBA1-NRg-5":958,
"CC8-DAM1-TRg-2":959,
"CC8-NHP2-TRg-2":960,
"CC8-HCA4-NRg-6":961,
"CC8-PRE3-TRg-4":962,
"CC8-DBP5-NRg-4":963,
"CC8-SPT6-NRg-4":964,
"CC8-SPT6-NRg-2":965,
"CC8-RPL18A-TRg-4":966,
"CC8-KSH1-TRg-1":967,
"CC8-KSH1-TRg-3":968,
"CC8-IPI3-NRg-1":969,
"CC8-PGA2-TRg-8":970,
"CC8-RPL18A-TRg-2":971,
"CC8-RPL33A-NRg-6":972,
"CC8-TAF12-NRg-2":973,
"CC8-USE1-TRg-5":974,
"CC8-YNL114C-TRg-1":975,
"CC8-SMC5-TRg-7":976,
"CC8-SMC5-TRg-6":977,
"CC8-RSC58-TRg-1":978,
"CC8-CTF13-TRg-2":979,
"CC8-NAB2-NRg-2":980,
"CC8-MCM7-TRg-4":981,
"CC8-BCP1-NRg-5":982,
"CC8-STU2-TRg-3":983,
"CC8-SEC21-NRg-6":984,
"CC8-SEC21-NRg-3":985,
"CC8-RPL1B-TRg-3":986,
"CC8-SEC20-NRg-2":987,
"CC8-VMA3-NRg-2":988,
"CC8-SEC23-NRg-5":989,
"CC8-CDC28-TRg-4":990,
"CC8-RPN12-NRg-11":991,
"CC8-PUP3-TRg-3":992,
"CC8-SEC31-TRg-2":993,
"CC8-SED5-TRg-6":994,
"CC8-SED5-TRg-5":995,
"CC8-RPL33A-TRg-1":996,
"CC8-RPL33A-TRg-2":997,
"CC8-MRPL11-TRg-2":998,
"CC8-RTP1-NRg-2":999,
"CC8-NUG1-TRg-2":1000,
"CC8-VPH2-TRg-4":1001,
"CC8-COP1-NRg-3":1002,
"CC8-CRM1-NRg-1":1003,
"CC8-RPL5-NRg-4":1004,
"CC8-SNU13-NRg-4":1005,
"CC8-PFS2-TRg-3":1006,
"CC8-MPP10-TRg-2":1007,
"CC8-TSR4-NRg-2":1008,
"CC8-RSC2-TRg-1":1009,
"CC8-SEC65-TRg-2":1010,
"CC8-SMI1-NRg-1":1011,
"CC8-RTT105-NRg-4":1012,
"CC8-VMA5-TRg-3":1013,
"CC8-VMA5-TRg-5":1014,
"CC8-RRP1-TRg-3":1015,
"CC8-CLC1-TRg-2":1016,
"CC8-GCD6-NRg-1":1017,
"CC8-GCD6-NRg-2":1018,
"CC8-PXR1-TRg-1":1019,
"CC8-CDC14-NRg-1":1020,
"CC8-PCF11-TRg-6":1021,
"CC8-PCF11-TRg-5":1022,
"CC8-PCF11-TRg-4":1023,
"CC8-SEC31-NRg-1":1024,
"CC8-RRP5-NRg-1":1025,
"CC8-PRE10-TRg-5":1026,
"CC8-PRE10-TRg-1":1027,
"CC8-RPS5-TRg-2":1028,
"CC8-NSP1-TRg-4":1029,
"CC8-PRP38-TRg-4":1030,
"CC8-RCF1-NRg-5":1031,
"CC8-RSC3-TRg-4":1032,
"CC8-RSC3-TRg-5":1033,
"CC8-RSC3-TRg-6":1034,
"CC8-HTA1-NRg-12":1035,
"CC8-HTA1-NRg-11":1036,
"CC8-UTP23-TRg-2":1037,
"CC8-GCD7-NRg-1":1038,
"CC8-GCD7-NRg-2":1039,
"CC8-GCD7-NRg-6":1040,
"CC8-GAL11-NRg-2":1041,
"CC8-GAL11-NRg-9":1042,
"CC8-PHO4-TRg-5":1043,
"CC8-SNP1-NRg-3":1044,
"CC8-RPC37-TRg-5":1045,
"CC8-CRM1-TRg-5":1046,
"CC8-CRM1-TRg-2":1047,
"CC8-ASK1-TRg-7":1048,
"CC8-STU2-NRg-4":1049,
"CC8-NEO1-NRg-3":1050,
"CC8-GAL11-TRg-5":1051,
"CC8-GAL11-TRg-7":1052,
"CC8-SAM50-NRg-3":1053,
"CC8-CSL4-TRg-2":1054,
"CC8-CCT5-TRg-2":1055,
"CC8-POL30-NRg-1":1056,
"CC8-MED4-TRg-4":1057,
"CC8-MED4-TRg-3":1058,
"CC8-MED4-TRg-2":1059,
"CC8-GDI1-TRg-4":1060,
"CC8-GDI1-TRg-3":1061,
"CC8-REB1-TRg-6":1062,
"CC8-MRPL37-NRg-2":1063,
"CC8-NOC3-TRg-3":1064,
"CC8-SPC97-TRg-3":1065,
"CC8-IPP1-TRg-3":1066,
"CC8-IPP1-TRg-2":1067,
"CC8-PTI1-TRg-3":1068,
"CC8-PTI1-TRg-5":1069,
"CC8-RFC5-NRg-1":1070,
"CC8-CDC24-TRg-1":1071,
"CC8-CDC24-TRg-3":1072,
"CC8-CDC24-TRg-5":1073,
"CC8-CDC24-TRg-6":1074,
"CC8-UTP23-TRg-6":1075,
"CC8-UTP23-TRg-4":1076,
"CC8-UTP23-TRg-1":1077,
"CC8-RHO3-NRg-4":1078,
"CC8-TRS23-NRg-1":1079,
"CC8-TRS23-NRg-3":1080,
"CC8-RSP5-TRg-2":1081,
"CC8-RSP5-TRg-1":1082,
"CC8-SDA1-NRg-1":1083,
"CC8-KAP95-TRg-8":1084,
"CC8-ACO1-TRg-6":1085,
"CC8-HTA1-NRg-3":1086,
"CC8-HTA1-NRg-2":1087,
"CC8-SPN1-TRg-1":1088,
"CC8-MOT1-NRg-7":1089,
"CC8-RPL17A-NRg-4":1090,
"CC8-ADA2-TRg-4":1091,
"CC8-SFH1-NRg-1":1092,
"CC8-SPC97-NRg-5":1093,
"CC8-PRP22-TRg-3":1094,
"CC8-SEN15-TRg-2":1095,
"CC8-RPL3-NRg-2":1096,
"CC8-ISD11-NRg-2":1097,
"CC8-HEM12-TRg-8":1098,
"CC8-SEC10-TRg-1":1099,
"CC8-HTB1-TRg-7":1100,
"CC8-TTI2-TRg-1":1101,
"CC8-ACP1-TRg-2":1102,
"CC8-ACP1-TRg-4":1103,
"CC8-GAL11-NRg-10":1104,
"CC8-UTP22-TRg-2":1105,
"CC8-MST1-NRg-5":1106,
"CC8-RIB7-NRg-2":1107,
"CC8-MCD1-TRg-6":1108,
"CC8-MCD1-TRg-5":1109,
"CC8-GPI8-NRg-2":1110,
"CC8-THS1-TRg-2":1111,
"CC8-RRP7-TRg-2":1112,
"CC8-RRP7-TRg-5":1113,
"CC8-SMX2-NRg-7":1114,
"CC8-RRP45-TRg-5":1115,
"CC8-RRP45-TRg-4":1116,
"CC8-CNS1-TRg-2":1117,
"CC8-FBP1-NRg-9":1118,
"CC8-GCD11-NRg-1":1119,
"CC8-RPL10-TRg-2":1120,
"CC8-NUP192-TRg-4":1121,
"CC8-NUP145-NRg-4":1122,
"CC8-HEM12-TRg-6":1123,
"CC8-PLC1-TRg-3":1124,
"CC8-RPA43-TRg-1":1125,
"CC8-RPB7-NRg-2":1126,
"CC8-RPB7-NRg-3":1127,
"CC8-NSL1-NRg-1":1128,
"CC8-UTP6-TRg-3":1129,
"CC8-UTP6-TRg-1":1130,
"CC8-YJU2-TRg-5":1131,
"CC8-FRS2-NRg-5":1132,
"CC8-TIF35-NRg-2":1133,
"CC8-GPI15-TRg-1":1134,
"CC8-NOP1-NRg-5":1135,
"CC8-GPI15-TRg-4":1136,
"CC8-COG4-TRg-1":1137,
"CC8-TFA1-TRg-1":1138,
"CC8-RHO1-NRg-2":1139,
"CC8-RHO1-NRg-1":1140,
"CC8-CDC55-NRg-2":1141,
"CC8-IDI1-NRg-7":1142,
"CC8-RPL32-TRg-5":1143,
"CC8-RPB5-TRg-4":1144,
"CC8-DIP2-TRg-5":1145,
"CC8-DIP2-TRg-1":1146,
"CC8-RPC40-TRg-2":1147,
"CC8-CDC6-TRg-5":1148,
"CC8-CDC6-TRg-3":1149,
"CC8-DAD2-TRg-2":1150,
"CC8-RVS161-TRg-2":1151,
"CC8-RVS161-TRg-1":1152,
"CC8-SUP45-NRg-3":1153,
"CC8-SRB6-NRg-5":1154,
"CC8-RPC11-TRg-4":1155,
"CC8-RKI1-TRg-8":1156,
"CC8-NIP7-TRg-3":1157,
"CC8-RPL33A-NRg-12":1158,
"CC8-SAM50-TRg-4":1159,
"CC8-NOP4-NRg-1":1160,
"CC8-NOP4-NRg-3":1161,
"CC8-SMX2-TRg-5":1162,
"CC8-POL12-NRg-2":1163,
"CC8-BMS1-NRg-2":1164,
"CC8-RPA190-TRg-5":1165,
"CC8-ALG14-NRg-4":1166,
"CC8-ALG14-NRg-1":1167,
"CC8-PRE5-NRg-1":1168,
"CC8-BIG1-NRg-2":1169,
"CC8-TFA2-TRg-4":1170,
"CC8-IMP4-TRg-6":1171,
"CC8-PAN1-NRg-1":1172,
"CC8-UTP13-TRg-2":1173,
"CC8-KAE1-NRg-3":1174,
"CC8-ERG20-TRg-1":1175,
"CC8-CDC20-TRg-6":1176,
"CC8-PWP2-NRg-2":1177,
"CC8-COG1-NRg-1":1178,
"CC8-RPL1B-TRg-4":1179,
"CC8-RPL1B-TRg-7":1180,
"CC8-UTP20-TRg-3":1181,
"CC8-UTP20-TRg-4":1182,
"CC8-RPL25-TRg-4":1183,
"CC8-RPL25-TRg-2":1184,
"CC8-MCM7-NRg-1":1185,
"CC8-MRP49-TRg-5":1186,
"CC8-ERO1-NRg-3":1187,
"CC8-UTP5-TRg-7":1188,
"CC8-MCM4-NRg-1":1189,
"CC8-PRE3-NRg-1":1190,
"CC8-FCF1-NRg-1":1191,
"CC8-CUS1-NRg-1":1192,
"CC8-PSF1-TRg-2":1193,
"CC8-BCP1-TRg-2":1194,
"CC8-PAN1-TRg-1":1195,
"CC8-PAN1-TRg-3":1196,
"CC8-PAN1-TRg-4":1197,
"CC8-VPS3-TRg-2":1198,
"CC8-YIL060W-NRg-1":1199,
"CC8-VPS53-NRg-1":1200,
"CC8-CYR1-TRg-4":1201,
"CC8-CYR1-TRg-7":1202,
"CC8-MPS1-NRg-1":1203,
"CC8-SRP1-TRg-5":1204,
"CC8-SRP1-TRg-4":1205,
"CC8-TAF12-TRg-2":1206,
"CC8-TAF12-TRg-3":1207,
"CC8-POP4-TRg-1":1208,
"CC8-SPT16-TRg-1":1209,
"CC8-NUP82-TRg-4":1210,
"CC8-DML1-TRg-3":1211,
"CC8-RPA43-NRg-3":1212,
"CC8-STU2-NRg-3":1213,
"CC8-POP4-NRg-4":1214,
"CC8-MCD1-TRg-2":1215,
"CC8-RPS3-NRg-4":1216,
"CC8-PRP9-TRg-4":1217,
"CC8-RPP1-NRg-2":1218,
"CC8-MTR2-NRg-11":1219,
"CC8-GCD11-TRg-1":1220,
"CC8-RPF1-TRg-3":1221,
"CC8-SUB2-NRg-4":1222,
"CC8-GPI15-TRg-3":1223,
"CC8-ERG9-TRg-6":1224,
"CC8-RPT2-NRg-1":1225,
"CC8-YOS1-NRg-3":1226,
"CC8-SCM3-TRg-4":1227,
"CC8-SCM3-TRg-6":1228,
"CC8-RLP7-NRg-1":1229,
"CC8-TFB2-NRg-4":1230,
"CC8-IMP4-TRg-1":1231,
"CC8-IMP4-TRg-3":1232,
"CC8-PRE4-TRg-3":1233,
"CC8-SUB2-TRg-3":1234,
"CC8-RPP0-NRg-4":1235,
"CC8-RPP0-NRg-3":1236,
"CC8-TOM40-TRg-4":1237,
"CC8-FUR1-NRg-12":1238,
"CC8-TOM40-TRg-2":1239,
"CC8-VMA11-NRg-4":1240,
"CC8-PGS1-NRg-4":1241,
"CC8-URB1-TRg-4":1242,
"CC8-ARP4-TRg-3":1243,
"CC8-RPT3-TRg-3":1244,
"CC8-SUI3-TRg-3":1245,
"CC8-RFC5-NRg-2":1246,
"CC8-RRP14-TRg-2":1247,
"CC8-SCC2-TRg-1":1248,
"CC8-SSC1-TRg-3":1249,
"CC8-RRP9-TRg-3":1250,
"CC8-MOT1-NRg-9":1251,
"CC8-RPL42A-NRg-2":1252,
"CC8-SEC16-TRg-7":1253,
"CC8-IMP4-NRg-2":1254,
"CC8-YEF3-NRg-4":1255,
"CC8-PUP1-TRg-1":1256,
"CC8-UTP22-TRg-6":1257,
"CC8-DBP2-NRg-4":1258,
"CC8-PRE2-TRg-7":1259,
"CC8-ATP16-TRg-6":1260,
"CC8-UTP13-TRg-4":1261,
"CC8-DOP1-NRg-4":1262,
"CC8-TIM44-TRg-3":1263,
"CC8-ATP16-TRg-2":1264,
"CC8-ENP1-NRg-3":1265,
"CC8-NAF1-TRg-3":1266,
"CC8-COG4-TRg-2":1267,
"CC8-SOG2-TRg-7":1268,
"CC8-YDR341C-TRg-3":1269,
"CC8-YMR290W-A-TRg-10":1270,
"CC8-NUP192-NRg-9":1271,
"CC8-RPS31-NRg-8":1272,
"CC8-SPC97-NRg-6":1273,
"CC8-EBP2-NRg-1":1274,
"CC8-CDC48-TRg-5":1275,
"CC8-RPT1-TRg-4":1276,
"CC8-ULP1-NRg-2":1277,
"CC8-RPN3-TRg-6":1278,
"CC8-RPT1-TRg-5":1279,
"CC8-KRE5-TRg-2":1280,
"CC8-TBF1-NRg-8":1281,
"CC8-UTP22-NRg-4":1282,
"CC8-SSC1-NRg-4":1283,
"CC8-REB1-TRg-4":1284,
"CC8-CDC48-NRg-9":1285,
"CC8-FAS2-TRg-8":1286,
"CC8-TAO3-TRg-8":1287,
"CC8-CKS1-TRg-5":1288,
"CC8-YLR379W-TRg-7":1289,
"CC8-TEN1-NRg-2":1290,
"CC8-RPL42A-TRg-2":1291,
"CC8-SEC27-TRg-4":1292,
"CC8-TBF1-NRg-4":1293,
"CC8-RPT1-NRg-6":1294,
"CC8-COG1-TRg-3":1295,
"CC8-SUI1-TRg-6":1296,
"CC8-TIM23-TRg-6":1297,
"CC8-CDC48-NRg-6":1298,
"CC8-EPL1-TRg-5":1299,
"CC8-RPT5-TRg-8":1300,
"CC8-ATP16-NRg-4":1301,
"CC8-RPN6-TRg-3":1302,
"CC8-ERG9-NRg-6":1303,
"CC8-SMX3-TRg-1":1304,
"CC8-NCB2-NRg-3":1305,
"CC8-SEC16-NRg-12":1306,
"CC8-RPN6-TRg-2":1307,
"CC8-REB1-NRg-4":1308,
"CC8-ATP16-TRg-9":1309,
"CC8-ERG9-NRg-7":1310,
"CC16-RPL15A-NRg-4":1311,
"CC16-RPL15A-NRg-5":1312,
"CC16-KRE33-TRg-1":1313,
"CC16-PMI40-NRg-1":1314,
"CC16-NOP19-NRg-3":1315,
"CC16-SRP14-NRg-4":1316,
"CC16-SEC27-TRg-2":1317,
"CC16-GPI14-TRg-3":1318,
"CC16-PAH1-TRg-7":1319,
"CC16-PAH1-TRg-6":1320,
"CC16-PAH1-TRg-5":1321,
"CC16-PAH1-TRg-3":1322,
"CC16-COG3-TRg-1":1323,
"CC16-HTS1-NRg-5":1324,
"CC16-MSN5-TRg-7":1325,
"CC16-ERG26-TRg-1":1326,
"CC16-SMD2-TRg-5":1327,
"CC16-SMD2-TRg-4":1328,
"CC16-SMD2-TRg-1":1329,
"CC16-PRE7-TRg-4":1330,
"CC16-PRE7-TRg-7":1331,
"CC16-SEC6-TRg-3":1332,
"CC16-ESF2-NRg-1":1333,
"CC16-ESF2-NRg-3":1334,
"CC16-AFG2-TRg-2":1335,
"CC16-RRP36-TRg-3":1336,
"CC16-RRP36-TRg-5":1337,
"CC16-GCR1-NRg-2":1338,
"CC16-PRE4-NRg-4":1339,
"CC16-PRE4-NRg-9":1340,
"CC16-DSN1-NRg-2":1341,
"CC16-GPI11-TRg-3":1342,
"CC16-POP3-TRg-1":1343,
"CC16-MNE1-TRg-5":1344,
"CC16-RRP12-NRg-1":1345,
"CC16-RSC6-TRg-2":1346,
"CC16-CDC25-TRg-1":1347,
"CC16-CDC25-TRg-9":1348,
"CC16-YPP1-NRg-3":1349,
"CC16-NFS1-NRg-9":1350,
"CC16-NFS1-NRg-8":1351,
"CC16-UBA2-TRg-1":1352,
"CC16-ARP2-NRg-3":1353,
"CC16-MAK16-TRg-1":1354,
"CC16-CEP3-NRg-1":1355,
"CC16-GUK1-TRg-5":1356,
"CC16-GUK1-TRg-2":1357,
"CC16-GPI12-NRg-6":1358,
"CC16-RPS5-NRg-5":1359,
"CC16-RPS5-NRg-2":1360,
"CC16-RPC19-NRg-1":1361,
"CC16-TIM54-TRg-1":1362,
"CC16-TEN1-TRg-2":1363,
"CC16-SAH1-NRg-4":1364,
"CC16-SAH1-NRg-5":1365,
"CC16-SAH1-NRg-3":1366,
"CC16-ATP15-NRg-5":1367,
"CC16-SCD5-TRg-5":1368,
"CC16-ARB1-NRg-2":1369,
"CC16-ARB1-NRg-4":1370,
"CC16-PUP2-TRg-1":1371,
"CC16-CCT8-TRg-2":1372,
"CC16-MCM4-TRg-1":1373,
"CC16-LSM4-TRg-1":1374,
"CC16-NOP53-NRg-1":1375,
"CC16-ATP3-TRg-4":1376,
"CC16-AFG2-NRg-3":1377,
"CC16-PRO3-NRg-3":1378,
"CC16-NRD1-NRg-10":1379,
"CC16-SEC61-TRg-2":1380,
"CC16-RHO3-TRg-4":1381,
"CC16-SNF2-TRg-6":1382,
"CC16-SMD2-NRg-3":1383,
"CC16-RSC4-TRg-2":1384,
"CC16-RSC4-TRg-1":1385,
"CC16-TIF34-TRg-2":1386,
"CC16-BET1-NRg-1":1387,
"CC16-CDC8-NRg-2":1388,
"CC16-PRP42-TRg-2":1389,
"CC16-RRB1-TRg-2":1390,
"CC16-SPC24-TRg-1":1391,
"CC16-ILS1-NRg-1":1392,
"CC16-GFA1-TRg-2":1393,
"CC16-SEC21-NRg-10":1394,
"CC16-RPC10-NRg-1":1395,
"CC16-RPB10-TRg-3":1396,
"CC16-RPB10-TRg-2":1397,
"CC16-YNL181W-TRg-1":1398,
"CC16-RAD3-NRg-1":1399,
"CC16-NOP10-TRg-1":1400,
"CC16-BFR2-TRg-3":1401,
"CC16-MCM2-TRg-6":1402,
"CC16-MCM2-TRg-4":1403,
"CC16-MPP10-TRg-1":1404,
"CC16-RET2-TRg-4":1405,
"CC16-RET2-TRg-1":1406,
"CC16-RPS2-NRg-1":1407,
"CC16-RPS2-NRg-2":1408,
"CC16-ORC4-NRg-3":1409,
"CC16-TIP20-TRg-7":1410,
"CC16-SMT3-TRg-1":1411,
"CC16-MSS18-NRg-6":1412,
"CC16-YEF3-NRg-9":1413,
"CC16-ASK1-NRg-1":1414,
"CC16-SMC1-TRg-1":1415,
"CC16-NIP1-NRg-1":1416,
"CC16-RPP1-NRg-1":1417,
"CC16-YDJ1-TRg-6":1418,
"CC16-SUB2-NRg-1":1419,
"CC16-TIM10-NRg-8":1420,
"CC16-TIM10-NRg-4":1421,
"CC16-TIM10-NRg-7":1422,
"CC16-SKI6-TRg-4":1423,
"CC16-TUB4-TRg-1":1424,
"CC16-CDC37-NRg-2":1425,
"CC16-ISD11-TRg-3":1426,
"CC16-YOS1-TRg-4":1427,
"CC16-SSC1-TRg-6":1428,
"CC16-MTR3-TRg-5":1429,
"CC16-MTR3-TRg-6":1430,
"CC16-TFA1-TRg-2":1431,
"CC16-CDC3-NRg-3":1432,
"CC16-ERG25-TA-18":1433,
"CC16-RPB11-TRg-4":1434,
"CC16-RPB11-TRg-1":1435,
"CC16-RPB11-TRg-2":1436,
"CC16-DED1-TRg-3":1437,
"CC16-DED1-TRg-1":1438,
"CC16-DED1-TRg-6":1439,
"CC16-DED1-TRg-4":1440,
"CC16-RPL10-NRg-5":1441,
"CC16-RPL10-NRg-4":1442,
"CC16-EFB1-NRg-1":1443,
"CC16-EFB1-NRg-5":1444,
"CC16-EFB1-NRg-4":1445,
"CC16-RPT3-NRg-1":1446,
"CC16-SAC6-TRg-8":1447,
"CC16-SAC6-TRg-4":1448,
"CC16-SAC6-TRg-5":1449,
"CC16-SAC6-TRg-3":1450,
"CC16-DIM1-TRg-5":1451,
"CC16-DIM1-TRg-7":1452,
"CC16-RPC17-NRg-1":1453,
"CC16-RPC17-NRg-2":1454,
"CC16-YDR341C-TRg-1":1455,
"CC16-RAP1-NRg-8":1456,
"CC16-RAP1-NRg-5":1457,
"CC16-RAP1-NRg-2":1458,
"CC16-SEC26-NRg-3":1459,
"CC16-SPP41-TRg-3":1460,
"CC16-TAP42-NRg-1":1461,
"CC16-PGA2-TRg-6":1462,
"CC16-BRL1-TRg-1":1463,
"CC16-FOL2-TRg-1":1464,
"CC16-NAB3-NRg-5":1465,
"CC16-SNF4-TRg-4":1466,
"CC16-HRR25-TRg-2":1467,
"CC16-TRS23-TRg-4":1468,
"CC16-CTR86-TRg-4":1469,
"CC16-RPB5-TRg-5":1470,
"CC16-SPN1-NRg-2":1471,
"CC16-SPN1-NRg-1":1472,
"CC16-SEC61-NRg-1":1473,
"CC16-SEC61-NRg-7":1474,
"CC16-TUS1-TRg-3":1475,
"CC16-OLE1-NRg-2":1476,
"CC16-AFG2-TRg-1":1477,
"CC16-TOA2-NRg-1":1478,
"CC16-USO1-TRg-1":1479,
"CC16-UTP22-NRg-2":1480,
"CC16-RIB1-TRg-3":1481,
"CC16-RIB1-TRg-7":1482,
"CC16-RIB1-TRg-4":1483,
"CC16-COG1-TRg-1":1484,
"CC16-RPL32-NRg-2":1485,
"CC16-GLC7-NRg-3":1486,
"CC16-GLC7-NRg-4":1487,
"CC16-HSF1-TRg-2":1488,
"CC16-DAM1-NRg-5":1489,
"CC16-SEC18-TRg-4":1490,
"CC16-SEC18-TRg-5":1491,
"CC16-PAB1-NRg-3":1492,
"CC16-POP8-TRg-2":1493,
"CC16-PAB1-NRg-4":1494,
"CC16-BIG1-TRg-4":1495,
"CC16-BIG1-TRg-5":1496,
"CC16-BIG1-TRg-6":1497,
"CC16-RPO41-NRg-1":1498,
"CC16-RVB2-NRg-2":1499,
"CC16-PET117-NRg-8":1500,
"CC16-VPS45-NRg-9":1501,
"CC16-YCG1-NRg-1":1502,
"CC16-NOC4-NRg-1":1503,
"CC16-NMD3-NRg-2":1504,
"CC16-DRS1-TRg-2":1505,
"CC16-HTB1-NRg-2":1506,
"CC16-IPI1-TRg-2":1507,
"CC16-SEC18-NRg-1":1508,
"CC16-SEC18-NRg-2":1509,
"CC16-JIP5-NRg-2":1510,
"CC16-YPT1-TRg-3":1511,
"CC16-YPT1-TRg-2":1512,
"CC16-CLF1-NRg-2":1513,
"CC16-SNF2-NRg-7":1514,
"CC16-SNF2-NRg-4":1515,
"CC16-RPL25-NRg-1":1516,
"CC16-NOP56-TRg-1":1517,
"CC16-NOP56-TRg-2":1518,
"CC16-TRS31-TRg-1":1519,
"CC16-DBF4-TRg-2":1520,
"CC16-DBF4-TRg-1":1521,
"CC16-RPC19-TRg-4":1522,
"CC16-RPC19-TRg-6":1523,
"CC16-RPC19-TRg-3":1524,
"CC16-ROK1-NRg-1":1525,
"CC16-CDC33-TRg-4":1526,
"CC16-DHR2-TRg-3":1527,
"CC16-RRP42-NRg-5":1528,
"CC16-CLF1-TRg-1":1529,
"CC16-ERG11-NA-16":1530,
"CC16-VAS1-NRg-4":1531,
"CC16-PIK1-NRg-2":1532,
"CC16-SAR1-NRg-7":1533,
"CC16-SAR1-NRg-4":1534,
"CC16-RPS3-TRg-1":1535,
"CC16-YTM1-TRg-2":1536,
"CC16-SUI3-NRg-5":1537,
"CC16-SUI3-NRg-2":1538,
"CC16-RRP7-TRg-4":1539,
"CC16-RRP7-TRg-6":1540,
"CC16-NIP7-TRg-2":1541,
"CC16-MDM35-TRg-1":1542,
"CC16-ALA1-NRg-1":1543,
"CC16-DOA4-NRg-2":1544,
"CC16-RPS13-NRg-1":1545,
"CC16-YSF3-TRg-2":1546,
"CC16-RPS2-NRg-11":1547,
"CC16-SSL1-TRg-10":1548,
"CC16-NIP7-TRg-1":1549,
"CC16-LST8-NRg-1":1550,
"CC16-TAF4-TRg-3":1551,
"CC16-HAS1-TRg-2":1552,
"CC16-GLC7-TRg-2":1553,
"CC16-CDC45-NRg-1":1554,
"CC16-SEC22-NRg-8":1555,
"CC16-YOS1-TRg-2":1556,
"CC16-RBA50-TRg-3":1557,
"CC16-SPP41-NRg-2":1558,
"CC16-PRP46-TRg-2":1559,
"CC16-PGA2-NRg-1":1560,
"CC16-CBF5-TRg-3":1561,
"CC16-TCP1-NRg-3":1562,
"CC16-TCP1-NRg-2":1563,
"CC16-ERG26-NRg-2":1564,
"CC16-ERG26-NRg-4":1565,
"CC16-MES1-TRg-5":1566,
"CC16-HTS1-TRg-2":1567,
"CC16-SSS1-TRg-3":1568,
"CC16-SSS1-TRg-2":1569,
"CC16-SYS1-TRg-7":1570,
"CC16-SYS1-TRg-2":1571,
"CC16-SYS1-TRg-1":1572,
"CC16-BFR2-TRg-1":1573,
"CC16-EOS1-TRg-3":1574,
"CC16-TAF4-NRg-1":1575,
"CC16-ARL3-NRg-8":1576,
"CC16-RPN5-NRg-1":1577,
"CC16-TIM9-NRg-2":1578,
"CC16-NUP57-NRg-3":1579,
"CC16-VPS4-TRg-1":1580,
"CC16-CDC3-TRg-4":1581,
"CC16-BBP1-NRg-1":1582,
"CC16-BBP1-NRg-2":1583,
"CC16-USE1-NRg-3":1584,
"CC16-CCT7-TRg-1":1585,
"CC16-SAH1-TRg-3":1586,
"CC16-CHS2-TRg-1":1587,
"CC16-DPM1-TRg-2":1588,
"CC16-BBP1-TRg-1":1589,
"CC16-NRD1-TRg-4":1590,
"CC16-RPB3-NRg-1":1591,
"CC16-PHO85-NRg-6":1592,
"CC16-SNF6-TRg-6":1593,
"CC16-PRP38-NRg-2":1594,
"CC16-OAR1-NRg-3":1595,
"CC16-ROX3-NRg-1":1596,
"CC16-YPP1-TRg-6":1597,
"CC16-CBF2-NRg-8":1598,
"CC16-SPT6-TRg-5":1599,
"CC16-SEC10-NRg-1":1600,
"CC16-NSL1-NRg-3":1601,
"CC16-NRD1-NRg-8":1602,
"CC16-RPB3-TRg-1":1603,
"CC16-NRD1-NRg-4":1604,
"CC16-RVB1-TRg-2":1605,
"CC16-TIF5-NRg-8":1606,
"CC16-EOS1-NRg-1":1607,
"CC16-ERG25-NA-26":1608,
"CC16-MSL5-NRg-4":1609,
"CC16-SEC24-TRg-2":1610,
"CC16-RPL30-NRg-5":1611,
"CC16-SNU71-NRg-3":1612,
"CC16-CDC33-NRg-1":1613,
"CC16-RPN6-TRg-4":1614,
"CC16-NAB2-TRg-4":1615,
"CC16-NAB2-TRg-6":1616,
"CC16-YTM1-NRg-1":1617,
"CC16-OLE1-TRg-8":1618,
"CC16-OLE1-TRg-1":1619,
"CC16-UTP7-TRg-4":1620,
"CC16-ACT1-NRg-6":1621,
"CC16-RPL18A-NRg-3":1622,
"CC16-BRX1-NRg-1":1623,
"CC16-NAF1-TRg-8":1624,
"CC16-NAF1-TRg-6":1625,
"CC16-NAF1-TRg-4":1626,
"CC16-CDC8-TRg-2":1627,
"CC16-NSE4-TRg-1":1628,
"CC16-PAB1-NRg-2":1629,
"CC16-PRP43-TRg-4":1630,
"CC16-SEC2-NRg-3":1631,
"CC16-SEC2-NRg-6":1632,
"CC16-MPP10-NRg-5":1633,
"CC16-YDR355C-TRg-2":1634,
"CC16-YLR339C-TRg-9":1635,
"CC16-SNM1-TRg-2":1636,
"CC16-ALR1-NRg-4":1637,
"CC16-ALR1-NRg-1":1638,
"CC16-ALR1-NRg-3":1639,
"CC16-RPL10-TRg-1":1640,
"CC16-RPL28-TRg-2":1641,
"CC16-UTP25-TRg-1":1642,
"CC16-POB3-TRg-1":1643,
"CC16-POB3-TRg-3":1644,
"CC16-POB3-TRg-2":1645,
"CC16-MED11-TRg-1":1646,
"CC16-ISA1-TRg-15":1647,
"CC16-RRP1-NRg-1":1648,
"CC16-MES1-NRg-1":1649,
"CC16-SEC13-NRg-5":1650,
"CC16-MCM2-NRg-2":1651,
"CC16-ALA1-TRg-4":1652,
"CC16-MTG2-TRg-5":1653,
"CC16-TIF35-NRg-3":1654,
"CC16-NSE1-TRg-3":1655,
"CC16-NSE1-TRg-4":1656,
"CC16-MOB2-NRg-6":1657,
"CC16-VRG4-NRg-3":1658,
"CC16-PRP9-TRg-3":1659,
"CC16-HYM1-TRg-5":1660,
"CC16-POP1-TRg-5":1661,
"CC16-POP1-TRg-9":1662,
"CC16-RPL17A-TRg-1":1663,
"CC16-SLD2-TRg-1":1664,
"CC16-CDC48-NRg-7":1665,
"CC16-FHL1-NRg-2":1666,
"CC16-BET3-NRg-7":1667,
"CC16-MAK21-TRg-1":1668,
"CC16-BRN1-TRg-4":1669,
"CC16-FBA1-NRg-3":1670,
"CC16-CDC42-TRg-6":1671,
"CC16-CDC42-TRg-7":1672,
"CC16-COG4-NRg-1":1673,
"CC16-ATP3-NRg-3":1674,
"CC16-ATP3-NRg-2":1675,
"CC16-SMP3-TRg-5":1676,
"CC16-CFT2-NRg-2":1677,
"CC16-FAS2-TRg-5":1678,
"CC16-DBP2-NRg-3":1679,
"CC16-DBP2-NRg-2":1680,
"CC16-MPS2-NRg-4":1681,
"CC16-ARC35-TRg-2":1682,
"CC16-ARC35-TRg-5":1683,
"CC16-MRD1-TRg-1":1684,
"CC16-RLP7-TRg-1":1685,
"CC16-SPC34-TRg-1":1686,
"CC16-CDC45-TRg-2":1687,
"CC16-GCD6-TRg-3":1688,
"CC16-GCD6-TRg-4":1689,
"CC16-YPT6-NRg-2":1690,
"CC16-RPS13-TRg-2":1691,
"CC16-IPI3-TRg-3":1692,
"CC16-TIF5-NRg-9":1693,
"CC16-TIF5-NRg-7":1694,
"CC16-TIF5-NRg-6":1695,
"CC16-NAB3-TRg-3":1696,
"CC16-GCD2-TRg-1":1697,
"CC16-UBA1-TRg-2":1698,
"CC16-SLD3-TRg-6":1699,
"CC16-LCB1-TRg-5":1700,
"CC16-TOA2-TRg-6":1701,
"CC16-TOA2-TRg-1":1702,
"CC16-TOA2-TRg-3":1703,
"CC16-LSM2-TRg-1":1704,
"CC16-YML6-TRg-13":1705,
"CC16-YML6-TRg-12":1706,
"CC16-UTP15-NRg-1":1707,
"CC16-TIF6-NRg-8":1708,
"CC16-SUP35-NRg-1":1709,
"CC16-MPP10-NRg-1":1710,
"CC16-SWI3-TRg-7":1711,
"CC16-SSN3-NRg-2":1712,
"CC16-SEC13-NRg-7":1713,
"CC16-RPS15-NRg-3":1714,
"CC16-RPL3-TRg-2":1715,
"CC16-FBA1-NRg-2":1716,
"CC16-FBA1-NRg-1":1717,
"CC16-FBA1-NRg-5":1718,
"CC16-DAM1-TRg-2":1719,
"CC16-NHP2-TRg-2":1720,
"CC16-HCA4-NRg-6":1721,
"CC16-PRE3-TRg-4":1722,
"CC16-DBP5-NRg-4":1723,
"CC16-SPT6-NRg-4":1724,
"CC16-SPT6-NRg-2":1725,
"CC16-RPL18A-TRg-4":1726,
"CC16-KSH1-TRg-1":1727,
"CC16-KSH1-TRg-3":1728,
"CC16-IPI3-NRg-1":1729,
"CC16-PGA2-TRg-8":1730,
"CC16-RPL18A-TRg-2":1731,
"CC16-RPL33A-NRg-6":1732,
"CC16-TAF12-NRg-2":1733,
"CC16-USE1-TRg-5":1734,
"CC16-YNL114C-TRg-1":1735,
"CC16-SMC5-TRg-7":1736,
"CC16-SMC5-TRg-6":1737,
"CC16-RSC58-TRg-1":1738,
"CC16-CTF13-TRg-2":1739,
"CC16-NAB2-NRg-2":1740,
"CC16-MCM7-TRg-4":1741,
"CC16-BCP1-NRg-5":1742,
"CC16-STU2-TRg-3":1743,
"CC16-SEC21-NRg-6":1744,
"CC16-SEC21-NRg-3":1745,
"CC16-RPL1B-TRg-3":1746,
"CC16-SEC20-NRg-2":1747,
"CC16-VMA3-NRg-2":1748,
"CC16-SEC23-NRg-5":1749,
"CC16-CDC28-TRg-4":1750,
"CC16-RPN12-NRg-11":1751,
"CC16-PUP3-TRg-3":1752,
"CC16-SEC31-TRg-2":1753,
"CC16-SED5-TRg-6":1754,
"CC16-SED5-TRg-5":1755,
"CC16-RPL33A-TRg-1":1756,
"CC16-RPL33A-TRg-2":1757,
"CC16-MRPL11-TRg-2":1758,
"CC16-RTP1-NRg-2":1759,
"CC16-NUG1-TRg-2":1760,
"CC16-VPH2-TRg-4":1761,
"CC16-COP1-NRg-3":1762,
"CC16-CRM1-NRg-1":1763,
"CC16-RPL5-NRg-4":1764,
"CC16-SNU13-NRg-4":1765,
"CC16-PFS2-TRg-3":1766,
"CC16-MPP10-TRg-2":1767,
"CC16-TSR4-NRg-2":1768,
"CC16-RSC2-TRg-1":1769,
"CC16-SEC65-TRg-2":1770,
"CC16-SMI1-NRg-1":1771,
"CC16-RTT105-NRg-4":1772,
"CC16-VMA5-TRg-3":1773,
"CC16-VMA5-TRg-5":1774,
"CC16-RRP1-TRg-3":1775,
"CC16-CLC1-TRg-2":1776,
"CC16-GCD6-NRg-1":1777,
"CC16-GCD6-NRg-2":1778,
"CC16-PXR1-TRg-1":1779,
"CC16-CDC14-NRg-1":1780,
"CC16-PCF11-TRg-6":1781,
"CC16-PCF11-TRg-5":1782,
"CC16-PCF11-TRg-4":1783,
"CC16-SEC31-NRg-1":1784,
"CC16-RRP5-NRg-1":1785,
"CC16-PRE10-TRg-5":1786,
"CC16-PRE10-TRg-1":1787,
"CC16-RPS5-TRg-2":1788,
"CC16-NSP1-TRg-4":1789,
"CC16-PRP38-TRg-4":1790,
"CC16-RCF1-NRg-5":1791,
"CC16-RSC3-TRg-4":1792,
"CC16-RSC3-TRg-5":1793,
"CC16-RSC3-TRg-6":1794,
"CC16-HTA1-NRg-12":1795,
"CC16-HTA1-NRg-11":1796,
"CC16-UTP23-TRg-2":1797,
"CC16-GCD7-NRg-1":1798,
"CC16-GCD7-NRg-2":1799,
"CC16-GCD7-NRg-6":1800,
"CC16-GAL11-NRg-2":1801,
"CC16-GAL11-NRg-9":1802,
"CC16-PHO4-TRg-5":1803,
"CC16-SNP1-NRg-3":1804,
"CC16-RPC37-TRg-5":1805,
"CC16-CRM1-TRg-5":1806,
"CC16-CRM1-TRg-2":1807,
"CC16-ASK1-TRg-7":1808,
"CC16-STU2-NRg-4":1809,
"CC16-NEO1-NRg-3":1810,
"CC16-GAL11-TRg-5":1811,
"CC16-GAL11-TRg-7":1812,
"CC16-SAM50-NRg-3":1813,
"CC16-CSL4-TRg-2":1814,
"CC16-CCT5-TRg-2":1815,
"CC16-POL30-NRg-1":1816,
"CC16-MED4-TRg-4":1817,
"CC16-MED4-TRg-3":1818,
"CC16-MED4-TRg-2":1819,
"CC16-GDI1-TRg-4":1820,
"CC16-GDI1-TRg-3":1821,
"CC16-REB1-TRg-6":1822,
"CC16-MRPL37-NRg-2":1823,
"CC16-NOC3-TRg-3":1824,
"CC16-SPC97-TRg-3":1825,
"CC16-IPP1-TRg-3":1826,
"CC16-IPP1-TRg-2":1827,
"CC16-PTI1-TRg-3":1828,
"CC16-PTI1-TRg-5":1829,
"CC16-RFC5-NRg-1":1830,
"CC16-CDC24-TRg-1":1831,
"CC16-CDC24-TRg-3":1832,
"CC16-CDC24-TRg-5":1833,
"CC16-CDC24-TRg-6":1834,
"CC16-UTP23-TRg-6":1835,
"CC16-UTP23-TRg-4":1836,
"CC16-UTP23-TRg-1":1837,
"CC16-RHO3-NRg-4":1838,
"CC16-TRS23-NRg-1":1839,
"CC16-TRS23-NRg-3":1840,
"CC16-RSP5-TRg-2":1841,
"CC16-RSP5-TRg-1":1842,
"CC16-SDA1-NRg-1":1843,
"CC16-KAP95-TRg-8":1844,
"CC16-ACO1-TRg-6":1845,
"CC16-HTA1-NRg-3":1846,
"CC16-HTA1-NRg-2":1847,
"CC16-SPN1-TRg-1":1848,
"CC16-MOT1-NRg-7":1849,
"CC16-RPL17A-NRg-4":1850,
"CC16-ADA2-TRg-4":1851,
"CC16-SFH1-NRg-1":1852,
"CC16-SPC97-NRg-5":1853,
"CC16-PRP22-TRg-3":1854,
"CC16-SEN15-TRg-2":1855,
"CC16-RPL3-NRg-2":1856,
"CC16-ISD11-NRg-2":1857,
"CC16-HEM12-TRg-8":1858,
"CC16-SEC10-TRg-1":1859,
"CC16-HTB1-TRg-7":1860,
"CC16-TTI2-TRg-1":1861,
"CC16-ACP1-TRg-2":1862,
"CC16-ACP1-TRg-4":1863,
"CC16-GAL11-NRg-10":1864,
"CC16-UTP22-TRg-2":1865,
"CC16-MST1-NRg-5":1866,
"CC16-RIB7-NRg-2":1867,
"CC16-MCD1-TRg-6":1868,
"CC16-MCD1-TRg-5":1869,
"CC16-GPI8-NRg-2":1870,
"CC16-THS1-TRg-2":1871,
"CC16-RRP7-TRg-2":1872,
"CC16-RRP7-TRg-5":1873,
"CC16-SMX2-NRg-7":1874,
"CC16-RRP45-TRg-5":1875,
"CC16-RRP45-TRg-4":1876,
"CC16-CNS1-TRg-2":1877,
"CC16-FBP1-NRg-9":1878,
"CC16-GCD11-NRg-1":1879,
"CC16-RPL10-TRg-2":1880,
"CC16-NUP192-TRg-4":1881,
"CC16-NUP145-NRg-4":1882,
"CC16-HEM12-TRg-6":1883,
"CC16-PLC1-TRg-3":1884,
"CC16-RPA43-TRg-1":1885,
"CC16-RPB7-NRg-2":1886,
"CC16-RPB7-NRg-3":1887,
"CC16-NSL1-NRg-1":1888,
"CC16-UTP6-TRg-3":1889,
"CC16-UTP6-TRg-1":1890,
"CC16-YJU2-TRg-5":1891,
"CC16-FRS2-NRg-5":1892,
"CC16-TIF35-NRg-2":1893,
"CC16-GPI15-TRg-1":1894,
"CC16-NOP1-NRg-5":1895,
"CC16-GPI15-TRg-4":1896,
"CC16-COG4-TRg-1":1897,
"CC16-TFA1-TRg-1":1898,
"CC16-RHO1-NRg-2":1899,
"CC16-RHO1-NRg-1":1900,
"CC16-CDC55-NRg-2":1901,
"CC16-IDI1-NRg-7":1902,
"CC16-RPL32-TRg-5":1903,
"CC16-RPB5-TRg-4":1904,
"CC16-DIP2-TRg-5":1905,
"CC16-DIP2-TRg-1":1906,
"CC16-RPC40-TRg-2":1907,
"CC16-CDC6-TRg-5":1908,
"CC16-CDC6-TRg-3":1909,
"CC16-DAD2-TRg-2":1910,
"CC16-RVS161-TRg-2":1911,
"CC16-RVS161-TRg-1":1912,
"CC16-SUP45-NRg-3":1913,
"CC16-SRB6-NRg-5":1914,
"CC16-RPC11-TRg-4":1915,
"CC16-RKI1-TRg-8":1916,
"CC16-NIP7-TRg-3":1917,
"CC16-RPL33A-NRg-12":1918,
"CC16-SAM50-TRg-4":1919,
"CC16-NOP4-NRg-1":1920,
"CC16-NOP4-NRg-3":1921,
"CC16-SMX2-TRg-5":1922,
"CC16-POL12-NRg-2":1923,
"CC16-BMS1-NRg-2":1924,
"CC16-RPA190-TRg-5":1925,
"CC16-ALG14-NRg-4":1926,
"CC16-ALG14-NRg-1":1927,
"CC16-PRE5-NRg-1":1928,
"CC16-BIG1-NRg-2":1929,
"CC16-TFA2-TRg-4":1930,
"CC16-IMP4-TRg-6":1931,
"CC16-PAN1-NRg-1":1932,
"CC16-UTP13-TRg-2":1933,
"CC16-KAE1-NRg-3":1934,
"CC16-ERG20-TRg-1":1935,
"CC16-CDC20-TRg-6":1936,
"CC16-PWP2-NRg-2":1937,
"CC16-COG1-NRg-1":1938,
"CC16-RPL1B-TRg-4":1939,
"CC16-RPL1B-TRg-7":1940,
"CC16-UTP20-TRg-3":1941,
"CC16-UTP20-TRg-4":1942,
"CC16-RPL25-TRg-4":1943,
"CC16-RPL25-TRg-2":1944,
"CC16-MCM7-NRg-1":1945,
"CC16-MRP49-TRg-5":1946,
"CC16-ERO1-NRg-3":1947,
"CC16-UTP5-TRg-7":1948,
"CC16-MCM4-NRg-1":1949,
"CC16-PRE3-NRg-1":1950,
"CC16-FCF1-NRg-1":1951,
"CC16-CUS1-NRg-1":1952,
"CC16-PSF1-TRg-2":1953,
"CC16-BCP1-TRg-2":1954,
"CC16-PAN1-TRg-1":1955,
"CC16-PAN1-TRg-3":1956,
"CC16-PAN1-TRg-4":1957,
"CC16-VPS3-TRg-2":1958,
"CC16-YIL060W-NRg-1":1959,
"CC16-VPS53-NRg-1":1960,
"CC16-CYR1-TRg-4":1961,
"CC16-CYR1-TRg-7":1962,
"CC16-MPS1-NRg-1":1963,
"CC16-SRP1-TRg-5":1964,
"CC16-SRP1-TRg-4":1965,
"CC16-TAF12-TRg-2":1966,
"CC16-TAF12-TRg-3":1967,
"CC16-POP4-TRg-1":1968,
"CC16-SPT16-TRg-1":1969,
"CC16-NUP82-TRg-4":1970,
"CC16-DML1-TRg-3":1971,
"CC16-RPA43-NRg-3":1972,
"CC16-STU2-NRg-3":1973,
"CC16-POP4-NRg-4":1974,
"CC16-MCD1-TRg-2":1975,
"CC16-RPS3-NRg-4":1976,
"CC16-PRP9-TRg-4":1977,
"CC16-RPP1-NRg-2":1978,
"CC16-MTR2-NRg-11":1979,
"CC16-GCD11-TRg-1":1980,
"CC16-RPF1-TRg-3":1981,
"CC16-SUB2-NRg-4":1982,
"CC16-GPI15-TRg-3":1983,
"CC16-ERG9-TRg-6":1984,
"CC16-RPT2-NRg-1":1985,
"CC16-YOS1-NRg-3":1986,
"CC16-SCM3-TRg-4":1987,
"CC16-SCM3-TRg-6":1988,
"CC16-RLP7-NRg-1":1989,
"CC16-TFB2-NRg-4":1990,
"CC16-IMP4-TRg-1":1991,
"CC16-IMP4-TRg-3":1992,
"CC16-PRE4-TRg-3":1993,
"CC16-SUB2-TRg-3":1994,
"CC16-RPP0-NRg-4":1995,
"CC16-RPP0-NRg-3":1996,
"CC16-TOM40-TRg-4":1997,
"CC16-FUR1-NRg-12":1998,
"CC16-TOM40-TRg-2":1999,
"CC16-VMA11-NRg-4":2000,
"CC16-PGS1-NRg-4":2001,
"CC16-URB1-TRg-4":2002,
"CC16-ARP4-TRg-3":2003,
"CC16-RPT3-TRg-3":2004,
"CC16-SUI3-TRg-3":2005,
"CC16-RFC5-NRg-2":2006,
"CC16-RRP14-TRg-2":2007,
"CC16-SCC2-TRg-1":2008,
"CC16-SSC1-TRg-3":2009,
"CC16-RRP9-TRg-3":2010,
"CC16-MOT1-NRg-9":2011,
"CC16-RPL42A-NRg-2":2012,
"CC16-SEC16-TRg-7":2013,
"CC16-IMP4-NRg-2":2014,
"CC16-YEF3-NRg-4":2015,
"CC16-PUP1-TRg-1":2016,
"CC16-UTP22-TRg-6":2017,
"CC16-DBP2-NRg-4":2018,
"CC16-PRE2-TRg-7":2019,
"CC16-ATP16-TRg-6":2020,
"CC16-UTP13-TRg-4":2021,
"CC16-DOP1-NRg-4":2022,
"CC16-TIM44-TRg-3":2023,
"CC16-ATP16-TRg-2":2024,
"CC16-ENP1-NRg-3":2025,
"CC16-NAF1-TRg-3":2026,
"CC16-COG4-TRg-2":2027,
"CC16-SOG2-TRg-7":2028,
"CC16-YDR341C-TRg-3":2029,
"CC16-YMR290W-A-TRg-10":2030,
"CC16-NUP192-NRg-9":2031,
"CC16-RPS31-NRg-8":2032,
"CC16-SPC97-NRg-6":2033,
"CC16-EBP2-NRg-1":2034,
"CC16-CDC48-TRg-5":2035,
"CC16-RPT1-TRg-4":2036,
"CC16-ULP1-NRg-2":2037,
"CC16-RPN3-TRg-6":2038,
"CC16-RPT1-TRg-5":2039,
"CC16-KRE5-TRg-2":2040,
"CC16-TBF1-NRg-8":2041,
"CC16-UTP22-NRg-4":2042,
"CC16-SSC1-NRg-4":2043,
"CC16-REB1-TRg-4":2044,
"CC16-CDC48-NRg-9":2045,
"CC16-FAS2-TRg-8":2046,
"CC16-TAO3-TRg-8":2047,
"CC16-CKS1-TRg-5":2048,
"CC16-YLR379W-TRg-7":2049,
"CC16-TEN1-NRg-2":2050,
"CC16-RPL42A-TRg-2":2051,
"CC16-SEC27-TRg-4":2052,
"CC16-TBF1-NRg-4":2053,
"CC16-RPT1-NRg-6":2054,
"CC16-COG1-TRg-3":2055,
"CC16-SUI1-TRg-6":2056,
"CC16-TIM23-TRg-6":2057,
"CC16-CDC48-NRg-6":2058,
"CC16-EPL1-TRg-5":2059,
"CC16-RPT5-TRg-8":2060,
"CC16-ATP16-NRg-4":2061,
"CC16-RPN6-TRg-3":2062,
"CC16-ERG9-NRg-6":2063,
"CC16-SMX3-TRg-1":2064,
"CC16-NCB2-NRg-3":2065,
"CC16-SEC16-NRg-12":2066,
"CC16-RPN6-TRg-2":2067,
"CC16-REB1-NRg-4":2068,
"CC16-ATP16-TRg-9":2069,
"CC16-ERG9-NRg-7":2070,
"CC17-RPL15A-NRg-4":2071,
"CC17-RPL15A-NRg-5":2072,
"CC17-KRE33-TRg-1":2073,
"CC17-PMI40-NRg-1":2074,
"CC17-NOP19-NRg-3":2075,
"CC17-SRP14-NRg-4":2076,
"CC17-SEC27-TRg-2":2077,
"CC17-GPI14-TRg-3":2078,
"CC17-PAH1-TRg-7":2079,
"CC17-PAH1-TRg-6":2080,
"CC17-PAH1-TRg-5":2081,
"CC17-PAH1-TRg-3":2082,
"CC17-COG3-TRg-1":2083,
"CC17-HTS1-NRg-5":2084,
"CC17-MSN5-TRg-7":2085,
"CC17-ERG26-TRg-1":2086,
"CC17-SMD2-TRg-5":2087,
"CC17-SMD2-TRg-4":2088,
"CC17-SMD2-TRg-1":2089,
"CC17-PRE7-TRg-4":2090,
"CC17-PRE7-TRg-7":2091,
"CC17-SEC6-TRg-3":2092,
"CC17-ESF2-NRg-1":2093,
"CC17-ESF2-NRg-3":2094,
"CC17-AFG2-TRg-2":2095,
"CC17-RRP36-TRg-3":2096,
"CC17-RRP36-TRg-5":2097,
"CC17-GCR1-NRg-2":2098,
"CC17-PRE4-NRg-4":2099,
"CC17-PRE4-NRg-9":2100,
"CC17-DSN1-NRg-2":2101,
"CC17-GPI11-TRg-3":2102,
"CC17-POP3-TRg-1":2103,
"CC17-MNE1-TRg-5":2104,
"CC17-RRP12-NRg-1":2105,
"CC17-RSC6-TRg-2":2106,
"CC17-CDC25-TRg-1":2107,
"CC17-CDC25-TRg-9":2108,
"CC17-YPP1-NRg-3":2109,
"CC17-NFS1-NRg-9":2110,
"CC17-NFS1-NRg-8":2111,
"CC17-UBA2-TRg-1":2112,
"CC17-ARP2-NRg-3":2113,
"CC17-MAK16-TRg-1":2114,
"CC17-CEP3-NRg-1":2115,
"CC17-GUK1-TRg-5":2116,
"CC17-GUK1-TRg-2":2117,
"CC17-GPI12-NRg-6":2118,
"CC17-RPS5-NRg-5":2119,
"CC17-RPS5-NRg-2":2120,
"CC17-RPC19-NRg-1":2121,
"CC17-TIM54-TRg-1":2122,
"CC17-TEN1-TRg-2":2123,
"CC17-SAH1-NRg-4":2124,
"CC17-SAH1-NRg-5":2125,
"CC17-SAH1-NRg-3":2126,
"CC17-ATP15-NRg-5":2127,
"CC17-SCD5-TRg-5":2128,
"CC17-ARB1-NRg-2":2129,
"CC17-ARB1-NRg-4":2130,
"CC17-PUP2-TRg-1":2131,
"CC17-CCT8-TRg-2":2132,
"CC17-MCM4-TRg-1":2133,
"CC17-LSM4-TRg-1":2134,
"CC17-NOP53-NRg-1":2135,
"CC17-ATP3-TRg-4":2136,
"CC17-AFG2-NRg-3":2137,
"CC17-PRO3-NRg-3":2138,
"CC17-NRD1-NRg-10":2139,
"CC17-SEC61-TRg-2":2140,
"CC17-RHO3-TRg-4":2141,
"CC17-SNF2-TRg-6":2142,
"CC17-SMD2-NRg-3":2143,
"CC17-RSC4-TRg-2":2144,
"CC17-RSC4-TRg-1":2145,
"CC17-TIF34-TRg-2":2146,
"CC17-BET1-NRg-1":2147,
"CC17-CDC8-NRg-2":2148,
"CC17-PRP42-TRg-2":2149,
"CC17-RRB1-TRg-2":2150,
"CC17-SPC24-TRg-1":2151,
"CC17-ILS1-NRg-1":2152,
"CC17-GFA1-TRg-2":2153,
"CC17-SEC21-NRg-10":2154,
"CC17-RPC10-NRg-1":2155,
"CC17-RPB10-TRg-3":2156,
"CC17-RPB10-TRg-2":2157,
"CC17-YNL181W-TRg-1":2158,
"CC17-RAD3-NRg-1":2159,
"CC17-NOP10-TRg-1":2160,
"CC17-BFR2-TRg-3":2161,
"CC17-MCM2-TRg-6":2162,
"CC17-MCM2-TRg-4":2163,
"CC17-MPP10-TRg-1":2164,
"CC17-RET2-TRg-4":2165,
"CC17-RET2-TRg-1":2166,
"CC17-RPS2-NRg-1":2167,
"CC17-RPS2-NRg-2":2168,
"CC17-ORC4-NRg-3":2169,
"CC17-TIP20-TRg-7":2170,
"CC17-SMT3-TRg-1":2171,
"CC17-MSS18-NRg-6":2172,
"CC17-YEF3-NRg-9":2173,
"CC17-ASK1-NRg-1":2174,
"CC17-SMC1-TRg-1":2175,
"CC17-NIP1-NRg-1":2176,
"CC17-RPP1-NRg-1":2177,
"CC17-YDJ1-TRg-6":2178,
"CC17-SUB2-NRg-1":2179,
"CC17-TIM10-NRg-8":2180,
"CC17-TIM10-NRg-4":2181,
"CC17-TIM10-NRg-7":2182,
"CC17-SKI6-TRg-4":2183,
"CC17-TUB4-TRg-1":2184,
"CC17-CDC37-NRg-2":2185,
"CC17-ISD11-TRg-3":2186,
"CC17-YOS1-TRg-4":2187,
"CC17-SSC1-TRg-6":2188,
"CC17-MTR3-TRg-5":2189,
"CC17-MTR3-TRg-6":2190,
"CC17-TFA1-TRg-2":2191,
"CC17-CDC3-NRg-3":2192,
"CC17-ERG25-TA-18":2193,
"CC17-RPB11-TRg-4":2194,
"CC17-RPB11-TRg-1":2195,
"CC17-RPB11-TRg-2":2196,
"CC17-DED1-TRg-3":2197,
"CC17-DED1-TRg-1":2198,
"CC17-DED1-TRg-6":2199,
"CC17-DED1-TRg-4":2200,
"CC17-RPL10-NRg-5":2201,
"CC17-RPL10-NRg-4":2202,
"CC17-EFB1-NRg-1":2203,
"CC17-EFB1-NRg-5":2204,
"CC17-EFB1-NRg-4":2205,
"CC17-RPT3-NRg-1":2206,
"CC17-SAC6-TRg-8":2207,
"CC17-SAC6-TRg-4":2208,
"CC17-SAC6-TRg-5":2209,
"CC17-SAC6-TRg-3":2210,
"CC17-DIM1-TRg-5":2211,
"CC17-DIM1-TRg-7":2212,
"CC17-RPC17-NRg-1":2213,
"CC17-RPC17-NRg-2":2214,
"CC17-YDR341C-TRg-1":2215,
"CC17-RAP1-NRg-8":2216,
"CC17-RAP1-NRg-5":2217,
"CC17-RAP1-NRg-2":2218,
"CC17-SEC26-NRg-3":2219,
"CC17-SPP41-TRg-3":2220,
"CC17-TAP42-NRg-1":2221,
"CC17-PGA2-TRg-6":2222,
"CC17-BRL1-TRg-1":2223,
"CC17-FOL2-TRg-1":2224,
"CC17-NAB3-NRg-5":2225,
"CC17-SNF4-TRg-4":2226,
"CC17-HRR25-TRg-2":2227,
"CC17-TRS23-TRg-4":2228,
"CC17-CTR86-TRg-4":2229,
"CC17-RPB5-TRg-5":2230,
"CC17-SPN1-NRg-2":2231,
"CC17-SPN1-NRg-1":2232,
"CC17-SEC61-NRg-1":2233,
"CC17-SEC61-NRg-7":2234,
"CC17-TUS1-TRg-3":2235,
"CC17-OLE1-NRg-2":2236,
"CC17-AFG2-TRg-1":2237,
"CC17-TOA2-NRg-1":2238,
"CC17-USO1-TRg-1":2239,
"CC17-UTP22-NRg-2":2240,
"CC17-RIB1-TRg-3":2241,
"CC17-RIB1-TRg-7":2242,
"CC17-RIB1-TRg-4":2243,
"CC17-COG1-TRg-1":2244,
"CC17-RPL32-NRg-2":2245,
"CC17-GLC7-NRg-3":2246,
"CC17-GLC7-NRg-4":2247,
"CC17-HSF1-TRg-2":2248,
"CC17-DAM1-NRg-5":2249,
"CC17-SEC18-TRg-4":2250,
"CC17-SEC18-TRg-5":2251,
"CC17-PAB1-NRg-3":2252,
"CC17-POP8-TRg-2":2253,
"CC17-PAB1-NRg-4":2254,
"CC17-BIG1-TRg-4":2255,
"CC17-BIG1-TRg-5":2256,
"CC17-BIG1-TRg-6":2257,
"CC17-RPO41-NRg-1":2258,
"CC17-RVB2-NRg-2":2259,
"CC17-PET117-NRg-8":2260,
"CC17-VPS45-NRg-9":2261,
"CC17-YCG1-NRg-1":2262,
"CC17-NOC4-NRg-1":2263,
"CC17-NMD3-NRg-2":2264,
"CC17-DRS1-TRg-2":2265,
"CC17-HTB1-NRg-2":2266,
"CC17-IPI1-TRg-2":2267,
"CC17-SEC18-NRg-1":2268,
"CC17-SEC18-NRg-2":2269,
"CC17-JIP5-NRg-2":2270,
"CC17-YPT1-TRg-3":2271,
"CC17-YPT1-TRg-2":2272,
"CC17-CLF1-NRg-2":2273,
"CC17-SNF2-NRg-7":2274,
"CC17-SNF2-NRg-4":2275,
"CC17-RPL25-NRg-1":2276,
"CC17-NOP56-TRg-1":2277,
"CC17-NOP56-TRg-2":2278,
"CC17-TRS31-TRg-1":2279,
"CC17-DBF4-TRg-2":2280,
"CC17-DBF4-TRg-1":2281,
"CC17-RPC19-TRg-4":2282,
"CC17-RPC19-TRg-6":2283,
"CC17-RPC19-TRg-3":2284,
"CC17-ROK1-NRg-1":2285,
"CC17-CDC33-TRg-4":2286,
"CC17-DHR2-TRg-3":2287,
"CC17-RRP42-NRg-5":2288,
"CC17-CLF1-TRg-1":2289,
"CC17-ERG11-NA-16":2290,
"CC17-VAS1-NRg-4":2291,
"CC17-PIK1-NRg-2":2292,
"CC17-SAR1-NRg-7":2293,
"CC17-SAR1-NRg-4":2294,
"CC17-RPS3-TRg-1":2295,
"CC17-YTM1-TRg-2":2296,
"CC17-SUI3-NRg-5":2297,
"CC17-SUI3-NRg-2":2298,
"CC17-RRP7-TRg-4":2299,
"CC17-RRP7-TRg-6":2300,
"CC17-NIP7-TRg-2":2301,
"CC17-MDM35-TRg-1":2302,
"CC17-ALA1-NRg-1":2303,
"CC17-DOA4-NRg-2":2304,
"CC17-RPS13-NRg-1":2305,
"CC17-YSF3-TRg-2":2306,
"CC17-RPS2-NRg-11":2307,
"CC17-SSL1-TRg-10":2308,
"CC17-NIP7-TRg-1":2309,
"CC17-LST8-NRg-1":2310,
"CC17-TAF4-TRg-3":2311,
"CC17-HAS1-TRg-2":2312,
"CC17-GLC7-TRg-2":2313,
"CC17-CDC45-NRg-1":2314,
"CC17-SEC22-NRg-8":2315,
"CC17-YOS1-TRg-2":2316,
"CC17-RBA50-TRg-3":2317,
"CC17-SPP41-NRg-2":2318,
"CC17-PRP46-TRg-2":2319,
"CC17-PGA2-NRg-1":2320,
"CC17-CBF5-TRg-3":2321,
"CC17-TCP1-NRg-3":2322,
"CC17-TCP1-NRg-2":2323,
"CC17-ERG26-NRg-2":2324,
"CC17-ERG26-NRg-4":2325,
"CC17-MES1-TRg-5":2326,
"CC17-HTS1-TRg-2":2327,
"CC17-SSS1-TRg-3":2328,
"CC17-SSS1-TRg-2":2329,
"CC17-SYS1-TRg-7":2330,
"CC17-SYS1-TRg-2":2331,
"CC17-SYS1-TRg-1":2332,
"CC17-BFR2-TRg-1":2333,
"CC17-EOS1-TRg-3":2334,
"CC17-TAF4-NRg-1":2335,
"CC17-ARL3-NRg-8":2336,
"CC17-RPN5-NRg-1":2337,
"CC17-TIM9-NRg-2":2338,
"CC17-NUP57-NRg-3":2339,
"CC17-VPS4-TRg-1":2340,
"CC17-CDC3-TRg-4":2341,
"CC17-BBP1-NRg-1":2342,
"CC17-BBP1-NRg-2":2343,
"CC17-USE1-NRg-3":2344,
"CC17-CCT7-TRg-1":2345,
"CC17-SAH1-TRg-3":2346,
"CC17-CHS2-TRg-1":2347,
"CC17-DPM1-TRg-2":2348,
"CC17-BBP1-TRg-1":2349,
"CC17-NRD1-TRg-4":2350,
"CC17-RPB3-NRg-1":2351,
"CC17-PHO85-NRg-6":2352,
"CC17-SNF6-TRg-6":2353,
"CC17-PRP38-NRg-2":2354,
"CC17-OAR1-NRg-3":2355,
"CC17-ROX3-NRg-1":2356,
"CC17-YPP1-TRg-6":2357,
"CC17-CBF2-NRg-8":2358,
"CC17-SPT6-TRg-5":2359,
"CC17-SEC10-NRg-1":2360,
"CC17-NSL1-NRg-3":2361,
"CC17-NRD1-NRg-8":2362,
"CC17-RPB3-TRg-1":2363,
"CC17-NRD1-NRg-4":2364,
"CC17-RVB1-TRg-2":2365,
"CC17-TIF5-NRg-8":2366,
"CC17-EOS1-NRg-1":2367,
"CC17-ERG25-NA-26":2368,
"CC17-MSL5-NRg-4":2369,
"CC17-SEC24-TRg-2":2370,
"CC17-RPL30-NRg-5":2371,
"CC17-SNU71-NRg-3":2372,
"CC17-CDC33-NRg-1":2373,
"CC17-RPN6-TRg-4":2374,
"CC17-NAB2-TRg-4":2375,
"CC17-NAB2-TRg-6":2376,
"CC17-YTM1-NRg-1":2377,
"CC17-OLE1-TRg-8":2378,
"CC17-OLE1-TRg-1":2379,
"CC17-UTP7-TRg-4":2380,
"CC17-ACT1-NRg-6":2381,
"CC17-RPL18A-NRg-3":2382,
"CC17-BRX1-NRg-1":2383,
"CC17-NAF1-TRg-8":2384,
"CC17-NAF1-TRg-6":2385,
"CC17-NAF1-TRg-4":2386,
"CC17-CDC8-TRg-2":2387,
"CC17-NSE4-TRg-1":2388,
"CC17-PAB1-NRg-2":2389,
"CC17-PRP43-TRg-4":2390,
"CC17-SEC2-NRg-3":2391,
"CC17-SEC2-NRg-6":2392,
"CC17-MPP10-NRg-5":2393,
"CC17-YDR355C-TRg-2":2394,
"CC17-YLR339C-TRg-9":2395,
"CC17-SNM1-TRg-2":2396,
"CC17-ALR1-NRg-4":2397,
"CC17-ALR1-NRg-1":2398,
"CC17-ALR1-NRg-3":2399,
"CC17-RPL10-TRg-1":2400,
"CC17-RPL28-TRg-2":2401,
"CC17-UTP25-TRg-1":2402,
"CC17-POB3-TRg-1":2403,
"CC17-POB3-TRg-3":2404,
"CC17-POB3-TRg-2":2405,
"CC17-MED11-TRg-1":2406,
"CC17-ISA1-TRg-15":2407,
"CC17-RRP1-NRg-1":2408,
"CC17-MES1-NRg-1":2409,
"CC17-SEC13-NRg-5":2410,
"CC17-MCM2-NRg-2":2411,
"CC17-ALA1-TRg-4":2412,
"CC17-MTG2-TRg-5":2413,
"CC17-TIF35-NRg-3":2414,
"CC17-NSE1-TRg-3":2415,
"CC17-NSE1-TRg-4":2416,
"CC17-MOB2-NRg-6":2417,
"CC17-VRG4-NRg-3":2418,
"CC17-PRP9-TRg-3":2419,
"CC17-HYM1-TRg-5":2420,
"CC17-POP1-TRg-5":2421,
"CC17-POP1-TRg-9":2422,
"CC17-RPL17A-TRg-1":2423,
"CC17-SLD2-TRg-1":2424,
"CC17-CDC48-NRg-7":2425,
"CC17-FHL1-NRg-2":2426,
"CC17-BET3-NRg-7":2427,
"CC17-MAK21-TRg-1":2428,
"CC17-BRN1-TRg-4":2429,
"CC17-FBA1-NRg-3":2430,
"CC17-CDC42-TRg-6":2431,
"CC17-CDC42-TRg-7":2432,
"CC17-COG4-NRg-1":2433,
"CC17-ATP3-NRg-3":2434,
"CC17-ATP3-NRg-2":2435,
"CC17-SMP3-TRg-5":2436,
"CC17-CFT2-NRg-2":2437,
"CC17-FAS2-TRg-5":2438,
"CC17-DBP2-NRg-3":2439,
"CC17-DBP2-NRg-2":2440,
"CC17-MPS2-NRg-4":2441,
"CC17-ARC35-TRg-2":2442,
"CC17-ARC35-TRg-5":2443,
"CC17-MRD1-TRg-1":2444,
"CC17-RLP7-TRg-1":2445,
"CC17-SPC34-TRg-1":2446,
"CC17-CDC45-TRg-2":2447,
"CC17-GCD6-TRg-3":2448,
"CC17-GCD6-TRg-4":2449,
"CC17-YPT6-NRg-2":2450,
"CC17-RPS13-TRg-2":2451,
"CC17-IPI3-TRg-3":2452,
"CC17-TIF5-NRg-9":2453,
"CC17-TIF5-NRg-7":2454,
"CC17-TIF5-NRg-6":2455,
"CC17-NAB3-TRg-3":2456,
"CC17-GCD2-TRg-1":2457,
"CC17-UBA1-TRg-2":2458,
"CC17-SLD3-TRg-6":2459,
"CC17-LCB1-TRg-5":2460,
"CC17-TOA2-TRg-6":2461,
"CC17-TOA2-TRg-1":2462,
"CC17-TOA2-TRg-3":2463,
"CC17-LSM2-TRg-1":2464,
"CC17-YML6-TRg-13":2465,
"CC17-YML6-TRg-12":2466,
"CC17-UTP15-NRg-1":2467,
"CC17-TIF6-NRg-8":2468,
"CC17-SUP35-NRg-1":2469,
"CC17-MPP10-NRg-1":2470,
"CC17-SWI3-TRg-7":2471,
"CC17-SSN3-NRg-2":2472,
"CC17-SEC13-NRg-7":2473,
"CC17-RPS15-NRg-3":2474,
"CC17-RPL3-TRg-2":2475,
"CC17-FBA1-NRg-2":2476,
"CC17-FBA1-NRg-1":2477,
"CC17-FBA1-NRg-5":2478,
"CC17-DAM1-TRg-2":2479,
"CC17-NHP2-TRg-2":2480,
"CC17-HCA4-NRg-6":2481,
"CC17-PRE3-TRg-4":2482,
"CC17-DBP5-NRg-4":2483,
"CC17-SPT6-NRg-4":2484,
"CC17-SPT6-NRg-2":2485,
"CC17-RPL18A-TRg-4":2486,
"CC17-KSH1-TRg-1":2487,
"CC17-KSH1-TRg-3":2488,
"CC17-IPI3-NRg-1":2489,
"CC17-PGA2-TRg-8":2490,
"CC17-RPL18A-TRg-2":2491,
"CC17-RPL33A-NRg-6":2492,
"CC17-TAF12-NRg-2":2493,
"CC17-USE1-TRg-5":2494,
"CC17-YNL114C-TRg-1":2495,
"CC17-SMC5-TRg-7":2496,
"CC17-SMC5-TRg-6":2497,
"CC17-RSC58-TRg-1":2498,
"CC17-CTF13-TRg-2":2499,
"CC17-NAB2-NRg-2":2500,
"CC17-MCM7-TRg-4":2501,
"CC17-BCP1-NRg-5":2502,
"CC17-STU2-TRg-3":2503,
"CC17-SEC21-NRg-6":2504,
"CC17-SEC21-NRg-3":2505,
"CC17-RPL1B-TRg-3":2506,
"CC17-SEC20-NRg-2":2507,
"CC17-VMA3-NRg-2":2508,
"CC17-SEC23-NRg-5":2509,
"CC17-CDC28-TRg-4":2510,
"CC17-RPN12-NRg-11":2511,
"CC17-PUP3-TRg-3":2512,
"CC17-SEC31-TRg-2":2513,
"CC17-SED5-TRg-6":2514,
"CC17-SED5-TRg-5":2515,
"CC17-RPL33A-TRg-1":2516,
"CC17-RPL33A-TRg-2":2517,
"CC17-MRPL11-TRg-2":2518,
"CC17-RTP1-NRg-2":2519,
"CC17-NUG1-TRg-2":2520,
"CC17-VPH2-TRg-4":2521,
"CC17-COP1-NRg-3":2522,
"CC17-CRM1-NRg-1":2523,
"CC17-RPL5-NRg-4":2524,
"CC17-SNU13-NRg-4":2525,
"CC17-PFS2-TRg-3":2526,
"CC17-MPP10-TRg-2":2527,
"CC17-TSR4-NRg-2":2528,
"CC17-RSC2-TRg-1":2529,
"CC17-SEC65-TRg-2":2530,
"CC17-SMI1-NRg-1":2531,
"CC17-RTT105-NRg-4":2532,
"CC17-VMA5-TRg-3":2533,
"CC17-VMA5-TRg-5":2534,
"CC17-RRP1-TRg-3":2535,
"CC17-CLC1-TRg-2":2536,
"CC17-GCD6-NRg-1":2537,
"CC17-GCD6-NRg-2":2538,
"CC17-PXR1-TRg-1":2539,
"CC17-CDC14-NRg-1":2540,
"CC17-PCF11-TRg-6":2541,
"CC17-PCF11-TRg-5":2542,
"CC17-PCF11-TRg-4":2543,
"CC17-SEC31-NRg-1":2544,
"CC17-RRP5-NRg-1":2545,
"CC17-PRE10-TRg-5":2546,
"CC17-PRE10-TRg-1":2547,
"CC17-RPS5-TRg-2":2548,
"CC17-NSP1-TRg-4":2549,
"CC17-PRP38-TRg-4":2550,
"CC17-RCF1-NRg-5":2551,
"CC17-RSC3-TRg-4":2552,
"CC17-RSC3-TRg-5":2553,
"CC17-RSC3-TRg-6":2554,
"CC17-HTA1-NRg-12":2555,
"CC17-HTA1-NRg-11":2556,
"CC17-UTP23-TRg-2":2557,
"CC17-GCD7-NRg-1":2558,
"CC17-GCD7-NRg-2":2559,
"CC17-GCD7-NRg-6":2560,
"CC17-GAL11-NRg-2":2561,
"CC17-GAL11-NRg-9":2562,
"CC17-PHO4-TRg-5":2563,
"CC17-SNP1-NRg-3":2564,
"CC17-RPC37-TRg-5":2565,
"CC17-CRM1-TRg-5":2566,
"CC17-CRM1-TRg-2":2567,
"CC17-ASK1-TRg-7":2568,
"CC17-STU2-NRg-4":2569,
"CC17-NEO1-NRg-3":2570,
"CC17-GAL11-TRg-5":2571,
"CC17-GAL11-TRg-7":2572,
"CC17-SAM50-NRg-3":2573,
"CC17-CSL4-TRg-2":2574,
"CC17-CCT5-TRg-2":2575,
"CC17-POL30-NRg-1":2576,
"CC17-MED4-TRg-4":2577,
"CC17-MED4-TRg-3":2578,
"CC17-MED4-TRg-2":2579,
"CC17-GDI1-TRg-4":2580,
"CC17-GDI1-TRg-3":2581,
"CC17-REB1-TRg-6":2582,
"CC17-MRPL37-NRg-2":2583,
"CC17-NOC3-TRg-3":2584,
"CC17-SPC97-TRg-3":2585,
"CC17-IPP1-TRg-3":2586,
"CC17-IPP1-TRg-2":2587,
"CC17-PTI1-TRg-3":2588,
"CC17-PTI1-TRg-5":2589,
"CC17-RFC5-NRg-1":2590,
"CC17-CDC24-TRg-1":2591,
"CC17-CDC24-TRg-3":2592,
"CC17-CDC24-TRg-5":2593,
"CC17-CDC24-TRg-6":2594,
"CC17-UTP23-TRg-6":2595,
"CC17-UTP23-TRg-4":2596,
"CC17-UTP23-TRg-1":2597,
"CC17-RHO3-NRg-4":2598,
"CC17-TRS23-NRg-1":2599,
"CC17-TRS23-NRg-3":2600,
"CC17-RSP5-TRg-2":2601,
"CC17-RSP5-TRg-1":2602,
"CC17-SDA1-NRg-1":2603,
"CC17-KAP95-TRg-8":2604,
"CC17-ACO1-TRg-6":2605,
"CC17-HTA1-NRg-3":2606,
"CC17-HTA1-NRg-2":2607,
"CC17-SPN1-TRg-1":2608,
"CC17-MOT1-NRg-7":2609,
"CC17-RPL17A-NRg-4":2610,
"CC17-ADA2-TRg-4":2611,
"CC17-SFH1-NRg-1":2612,
"CC17-SPC97-NRg-5":2613,
"CC17-PRP22-TRg-3":2614,
"CC17-SEN15-TRg-2":2615,
"CC17-RPL3-NRg-2":2616,
"CC17-ISD11-NRg-2":2617,
"CC17-HEM12-TRg-8":2618,
"CC17-SEC10-TRg-1":2619,
"CC17-HTB1-TRg-7":2620,
"CC17-TTI2-TRg-1":2621,
"CC17-ACP1-TRg-2":2622,
"CC17-ACP1-TRg-4":2623,
"CC17-GAL11-NRg-10":2624,
"CC17-UTP22-TRg-2":2625,
"CC17-MST1-NRg-5":2626,
"CC17-RIB7-NRg-2":2627,
"CC17-MCD1-TRg-6":2628,
"CC17-MCD1-TRg-5":2629,
"CC17-GPI8-NRg-2":2630,
"CC17-THS1-TRg-2":2631,
"CC17-RRP7-TRg-2":2632,
"CC17-RRP7-TRg-5":2633,
"CC17-SMX2-NRg-7":2634,
"CC17-RRP45-TRg-5":2635,
"CC17-RRP45-TRg-4":2636,
"CC17-CNS1-TRg-2":2637,
"CC17-FBP1-NRg-9":2638,
"CC17-GCD11-NRg-1":2639,
"CC17-RPL10-TRg-2":2640,
"CC17-NUP192-TRg-4":2641,
"CC17-NUP145-NRg-4":2642,
"CC17-HEM12-TRg-6":2643,
"CC17-PLC1-TRg-3":2644,
"CC17-RPA43-TRg-1":2645,
"CC17-RPB7-NRg-2":2646,
"CC17-RPB7-NRg-3":2647,
"CC17-NSL1-NRg-1":2648,
"CC17-UTP6-TRg-3":2649,
"CC17-UTP6-TRg-1":2650,
"CC17-YJU2-TRg-5":2651,
"CC17-FRS2-NRg-5":2652,
"CC17-TIF35-NRg-2":2653,
"CC17-GPI15-TRg-1":2654,
"CC17-NOP1-NRg-5":2655,
"CC17-GPI15-TRg-4":2656,
"CC17-COG4-TRg-1":2657,
"CC17-TFA1-TRg-1":2658,
"CC17-RHO1-NRg-2":2659,
"CC17-RHO1-NRg-1":2660,
"CC17-CDC55-NRg-2":2661,
"CC17-IDI1-NRg-7":2662,
"CC17-RPL32-TRg-5":2663,
"CC17-RPB5-TRg-4":2664,
"CC17-DIP2-TRg-5":2665,
"CC17-DIP2-TRg-1":2666,
"CC17-RPC40-TRg-2":2667,
"CC17-CDC6-TRg-5":2668,
"CC17-CDC6-TRg-3":2669,
"CC17-DAD2-TRg-2":2670,
"CC17-RVS161-TRg-2":2671,
"CC17-RVS161-TRg-1":2672,
"CC17-SUP45-NRg-3":2673,
"CC17-SRB6-NRg-5":2674,
"CC17-RPC11-TRg-4":2675,
"CC17-RKI1-TRg-8":2676,
"CC17-NIP7-TRg-3":2677,
"CC17-RPL33A-NRg-12":2678,
"CC17-SAM50-TRg-4":2679,
"CC17-NOP4-NRg-1":2680,
"CC17-NOP4-NRg-3":2681,
"CC17-SMX2-TRg-5":2682,
"CC17-POL12-NRg-2":2683,
"CC17-BMS1-NRg-2":2684,
"CC17-RPA190-TRg-5":2685,
"CC17-ALG14-NRg-4":2686,
"CC17-ALG14-NRg-1":2687,
"CC17-PRE5-NRg-1":2688,
"CC17-BIG1-NRg-2":2689,
"CC17-TFA2-TRg-4":2690,
"CC17-IMP4-TRg-6":2691,
"CC17-PAN1-NRg-1":2692,
"CC17-UTP13-TRg-2":2693,
"CC17-KAE1-NRg-3":2694,
"CC17-ERG20-TRg-1":2695,
"CC17-CDC20-TRg-6":2696,
"CC17-PWP2-NRg-2":2697,
"CC17-COG1-NRg-1":2698,
"CC17-RPL1B-TRg-4":2699,
"CC17-RPL1B-TRg-7":2700,
"CC17-UTP20-TRg-3":2701,
"CC17-UTP20-TRg-4":2702,
"CC17-RPL25-TRg-4":2703,
"CC17-RPL25-TRg-2":2704,
"CC17-MCM7-NRg-1":2705,
"CC17-MRP49-TRg-5":2706,
"CC17-ERO1-NRg-3":2707,
"CC17-UTP5-TRg-7":2708,
"CC17-MCM4-NRg-1":2709,
"CC17-PRE3-NRg-1":2710,
"CC17-FCF1-NRg-1":2711,
"CC17-CUS1-NRg-1":2712,
"CC17-PSF1-TRg-2":2713,
"CC17-BCP1-TRg-2":2714,
"CC17-PAN1-TRg-1":2715,
"CC17-PAN1-TRg-3":2716,
"CC17-PAN1-TRg-4":2717,
"CC17-VPS3-TRg-2":2718,
"CC17-YIL060W-NRg-1":2719,
"CC17-VPS53-NRg-1":2720,
"CC17-CYR1-TRg-4":2721,
"CC17-CYR1-TRg-7":2722,
"CC17-MPS1-NRg-1":2723,
"CC17-SRP1-TRg-5":2724,
"CC17-SRP1-TRg-4":2725,
"CC17-TAF12-TRg-2":2726,
"CC17-TAF12-TRg-3":2727,
"CC17-POP4-TRg-1":2728,
"CC17-SPT16-TRg-1":2729,
"CC17-NUP82-TRg-4":2730,
"CC17-DML1-TRg-3":2731,
"CC17-RPA43-NRg-3":2732,
"CC17-STU2-NRg-3":2733,
"CC17-POP4-NRg-4":2734,
"CC17-MCD1-TRg-2":2735,
"CC17-RPS3-NRg-4":2736,
"CC17-PRP9-TRg-4":2737,
"CC17-RPP1-NRg-2":2738,
"CC17-MTR2-NRg-11":2739,
"CC17-GCD11-TRg-1":2740,
"CC17-RPF1-TRg-3":2741,
"CC17-SUB2-NRg-4":2742,
"CC17-GPI15-TRg-3":2743,
"CC17-ERG9-TRg-6":2744,
"CC17-RPT2-NRg-1":2745,
"CC17-YOS1-NRg-3":2746,
"CC17-SCM3-TRg-4":2747,
"CC17-SCM3-TRg-6":2748,
"CC17-RLP7-NRg-1":2749,
"CC17-TFB2-NRg-4":2750,
"CC17-IMP4-TRg-1":2751,
"CC17-IMP4-TRg-3":2752,
"CC17-PRE4-TRg-3":2753,
"CC17-SUB2-TRg-3":2754,
"CC17-RPP0-NRg-4":2755,
"CC17-RPP0-NRg-3":2756,
"CC17-TOM40-TRg-4":2757,
"CC17-FUR1-NRg-12":2758,
"CC17-TOM40-TRg-2":2759,
"CC17-VMA11-NRg-4":2760,
"CC17-PGS1-NRg-4":2761,
"CC17-URB1-TRg-4":2762,
"CC17-ARP4-TRg-3":2763,
"CC17-RPT3-TRg-3":2764,
"CC17-SUI3-TRg-3":2765,
"CC17-RFC5-NRg-2":2766,
"CC17-RRP14-TRg-2":2767,
"CC17-SCC2-TRg-1":2768,
"CC17-SSC1-TRg-3":2769,
"CC17-RRP9-TRg-3":2770,
"CC17-MOT1-NRg-9":2771,
"CC17-RPL42A-NRg-2":2772,
"CC17-SEC16-TRg-7":2773,
"CC17-IMP4-NRg-2":2774,
"CC17-YEF3-NRg-4":2775,
"CC17-PUP1-TRg-1":2776,
"CC17-UTP22-TRg-6":2777,
"CC17-DBP2-NRg-4":2778,
"CC17-PRE2-TRg-7":2779,
"CC17-ATP16-TRg-6":2780,
"CC17-UTP13-TRg-4":2781,
"CC17-DOP1-NRg-4":2782,
"CC17-TIM44-TRg-3":2783,
"CC17-ATP16-TRg-2":2784,
"CC17-ENP1-NRg-3":2785,
"CC17-NAF1-TRg-3":2786,
"CC17-COG4-TRg-2":2787,
"CC17-SOG2-TRg-7":2788,
"CC17-YDR341C-TRg-3":2789,
"CC17-YMR290W-A-TRg-10":2790,
"CC17-NUP192-NRg-9":2791,
"CC17-RPS31-NRg-8":2792,
"CC17-SPC97-NRg-6":2793,
"CC17-EBP2-NRg-1":2794,
"CC17-CDC48-TRg-5":2795,
"CC17-RPT1-TRg-4":2796,
"CC17-ULP1-NRg-2":2797,
"CC17-RPN3-TRg-6":2798,
"CC17-RPT1-TRg-5":2799,
"CC17-KRE5-TRg-2":2800,
"CC17-TBF1-NRg-8":2801,
"CC17-UTP22-NRg-4":2802,
"CC17-SSC1-NRg-4":2803,
"CC17-REB1-TRg-4":2804,
"CC17-CDC48-NRg-9":2805,
"CC17-FAS2-TRg-8":2806,
"CC17-TAO3-TRg-8":2807,
"CC17-CKS1-TRg-5":2808,
"CC17-YLR379W-TRg-7":2809,
"CC17-TEN1-NRg-2":2810,
"CC17-RPL42A-TRg-2":2811,
"CC17-SEC27-TRg-4":2812,
"CC17-TBF1-NRg-4":2813,
"CC17-RPT1-NRg-6":2814,
"CC17-COG1-TRg-3":2815,
"CC17-SUI1-TRg-6":2816,
"CC17-TIM23-TRg-6":2817,
"CC17-CDC48-NRg-6":2818,
"CC17-EPL1-TRg-5":2819,
"CC17-RPT5-TRg-8":2820,
"CC17-ATP16-NRg-4":2821,
"CC17-RPN6-TRg-3":2822,
"CC17-ERG9-NRg-6":2823,
"CC17-SMX3-TRg-1":2824,
"CC17-NCB2-NRg-3":2825,
"CC17-SEC16-NRg-12":2826,
"CC17-RPN6-TRg-2":2827,
"CC17-REB1-NRg-4":2828,
"CC17-ATP16-TRg-9":2829,
"CC17-ERG9-NRg-7":2830,
"CC8_BC2-RPL15A-NRg-4":2831,
"CC8_BC2-RPL15A-NRg-5":2832,
"CC8_BC2-KRE33-TRg-1":2833,
"CC8_BC2-PMI40-NRg-1":2834,
"CC8_BC2-NOP19-NRg-3":2835,
"CC8_BC2-SRP14-NRg-4":2836,
"CC8_BC2-SEC27-TRg-2":2837,
"CC8_BC2-GPI14-TRg-3":2838,
"CC8_BC2-PAH1-TRg-7":2839,
"CC8_BC2-PAH1-TRg-6":2840,
"CC8_BC2-PAH1-TRg-5":2841,
"CC8_BC2-PAH1-TRg-3":2842,
"CC8_BC2-COG3-TRg-1":2843,
"CC8_BC2-HTS1-NRg-5":2844,
"CC8_BC2-MSN5-TRg-7":2845,
"CC8_BC2-ERG26-TRg-1":2846,
"CC8_BC2-SMD2-TRg-5":2847,
"CC8_BC2-SMD2-TRg-4":2848,
"CC8_BC2-SMD2-TRg-1":2849,
"CC8_BC2-PRE7-TRg-4":2850,
"CC8_BC2-PRE7-TRg-7":2851,
"CC8_BC2-SEC6-TRg-3":2852,
"CC8_BC2-ESF2-NRg-1":2853,
"CC8_BC2-ESF2-NRg-3":2854,
"CC8_BC2-AFG2-TRg-2":2855,
"CC8_BC2-RRP36-TRg-3":2856,
"CC8_BC2-RRP36-TRg-5":2857,
"CC8_BC2-GCR1-NRg-2":2858,
"CC8_BC2-PRE4-NRg-4":2859,
"CC8_BC2-PRE4-NRg-9":2860,
"CC8_BC2-DSN1-NRg-2":2861,
"CC8_BC2-GPI11-TRg-3":2862,
"CC8_BC2-POP3-TRg-1":2863,
"CC8_BC2-MNE1-TRg-5":2864,
"CC8_BC2-RRP12-NRg-1":2865,
"CC8_BC2-RSC6-TRg-2":2866,
"CC8_BC2-CDC25-TRg-1":2867,
"CC8_BC2-CDC25-TRg-9":2868,
"CC8_BC2-YPP1-NRg-3":2869,
"CC8_BC2-NFS1-NRg-9":2870,
"CC8_BC2-NFS1-NRg-8":2871,
"CC8_BC2-UBA2-TRg-1":2872,
"CC8_BC2-ARP2-NRg-3":2873,
"CC8_BC2-MAK16-TRg-1":2874,
"CC8_BC2-CEP3-NRg-1":2875,
"CC8_BC2-GUK1-TRg-5":2876,
"CC8_BC2-GUK1-TRg-2":2877,
"CC8_BC2-GPI12-NRg-6":2878,
"CC8_BC2-RPS5-NRg-5":2879,
"CC8_BC2-RPS5-NRg-2":2880,
"CC8_BC2-RPC19-NRg-1":2881,
"CC8_BC2-TIM54-TRg-1":2882,
"CC8_BC2-TEN1-TRg-2":2883,
"CC8_BC2-SAH1-NRg-4":2884,
"CC8_BC2-SAH1-NRg-5":2885,
"CC8_BC2-SAH1-NRg-3":2886,
"CC8_BC2-ATP15-NRg-5":2887,
"CC8_BC2-SCD5-TRg-5":2888,
"CC8_BC2-ARB1-NRg-2":2889,
"CC8_BC2-ARB1-NRg-4":2890,
"CC8_BC2-PUP2-TRg-1":2891,
"CC8_BC2-CCT8-TRg-2":2892,
"CC8_BC2-MCM4-TRg-1":2893,
"CC8_BC2-LSM4-TRg-1":2894,
"CC8_BC2-NOP53-NRg-1":2895,
"CC8_BC2-ATP3-TRg-4":2896,
"CC8_BC2-AFG2-NRg-3":2897,
"CC8_BC2-PRO3-NRg-3":2898,
"CC8_BC2-NRD1-NRg-10":2899,
"CC8_BC2-SEC61-TRg-2":2900,
"CC8_BC2-RHO3-TRg-4":2901,
"CC8_BC2-SNF2-TRg-6":2902,
"CC8_BC2-SMD2-NRg-3":2903,
"CC8_BC2-RSC4-TRg-2":2904,
"CC8_BC2-RSC4-TRg-1":2905,
"CC8_BC2-TIF34-TRg-2":2906,
"CC8_BC2-BET1-NRg-1":2907,
"CC8_BC2-CDC8-NRg-2":2908,
"CC8_BC2-PRP42-TRg-2":2909,
"CC8_BC2-RRB1-TRg-2":2910,
"CC8_BC2-SPC24-TRg-1":2911,
"CC8_BC2-ILS1-NRg-1":2912,
"CC8_BC2-GFA1-TRg-2":2913,
"CC8_BC2-SEC21-NRg-10":2914,
"CC8_BC2-RPC10-NRg-1":2915,
"CC8_BC2-RPB10-TRg-3":2916,
"CC8_BC2-RPB10-TRg-2":2917,
"CC8_BC2-YNL181W-TRg-1":2918,
"CC8_BC2-RAD3-NRg-1":2919,
"CC8_BC2-NOP10-TRg-1":2920,
"CC8_BC2-BFR2-TRg-3":2921,
"CC8_BC2-MCM2-TRg-6":2922,
"CC8_BC2-MCM2-TRg-4":2923,
"CC8_BC2-MPP10-TRg-1":2924,
"CC8_BC2-RET2-TRg-4":2925,
"CC8_BC2-RET2-TRg-1":2926,
"CC8_BC2-RPS2-NRg-1":2927,
"CC8_BC2-RPS2-NRg-2":2928,
"CC8_BC2-ORC4-NRg-3":2929,
"CC8_BC2-TIP20-TRg-7":2930,
"CC8_BC2-SMT3-TRg-1":2931,
"CC8_BC2-MSS18-NRg-6":2932,
"CC8_BC2-YEF3-NRg-9":2933,
"CC8_BC2-ASK1-NRg-1":2934,
"CC8_BC2-SMC1-TRg-1":2935,
"CC8_BC2-NIP1-NRg-1":2936,
"CC8_BC2-RPP1-NRg-1":2937,
"CC8_BC2-YDJ1-TRg-6":2938,
"CC8_BC2-SUB2-NRg-1":2939,
"CC8_BC2-TIM10-NRg-8":2940,
"CC8_BC2-TIM10-NRg-4":2941,
"CC8_BC2-TIM10-NRg-7":2942,
"CC8_BC2-SKI6-TRg-4":2943,
"CC8_BC2-TUB4-TRg-1":2944,
"CC8_BC2-CDC37-NRg-2":2945,
"CC8_BC2-ISD11-TRg-3":2946,
"CC8_BC2-YOS1-TRg-4":2947,
"CC8_BC2-SSC1-TRg-6":2948,
"CC8_BC2-MTR3-TRg-5":2949,
"CC8_BC2-MTR3-TRg-6":2950,
"CC8_BC2-TFA1-TRg-2":2951,
"CC8_BC2-CDC3-NRg-3":2952,
"CC8_BC2-ERG25-TA-18":2953,
"CC8_BC2-RPB11-TRg-4":2954,
"CC8_BC2-RPB11-TRg-1":2955,
"CC8_BC2-RPB11-TRg-2":2956,
"CC8_BC2-DED1-TRg-3":2957,
"CC8_BC2-DED1-TRg-1":2958,
"CC8_BC2-DED1-TRg-6":2959,
"CC8_BC2-DED1-TRg-4":2960,
"CC8_BC2-RPL10-NRg-5":2961,
"CC8_BC2-RPL10-NRg-4":2962,
"CC8_BC2-EFB1-NRg-1":2963,
"CC8_BC2-EFB1-NRg-5":2964,
"CC8_BC2-EFB1-NRg-4":2965,
"CC8_BC2-RPT3-NRg-1":2966,
"CC8_BC2-SAC6-TRg-8":2967,
"CC8_BC2-SAC6-TRg-4":2968,
"CC8_BC2-SAC6-TRg-5":2969,
"CC8_BC2-SAC6-TRg-3":2970,
"CC8_BC2-DIM1-TRg-5":2971,
"CC8_BC2-DIM1-TRg-7":2972,
"CC8_BC2-RPC17-NRg-1":2973,
"CC8_BC2-RPC17-NRg-2":2974,
"CC8_BC2-YDR341C-TRg-1":2975,
"CC8_BC2-RAP1-NRg-8":2976,
"CC8_BC2-RAP1-NRg-5":2977,
"CC8_BC2-RAP1-NRg-2":2978,
"CC8_BC2-SEC26-NRg-3":2979,
"CC8_BC2-SPP41-TRg-3":2980,
"CC8_BC2-TAP42-NRg-1":2981,
"CC8_BC2-PGA2-TRg-6":2982,
"CC8_BC2-BRL1-TRg-1":2983,
"CC8_BC2-FOL2-TRg-1":2984,
"CC8_BC2-NAB3-NRg-5":2985,
"CC8_BC2-SNF4-TRg-4":2986,
"CC8_BC2-HRR25-TRg-2":2987,
"CC8_BC2-TRS23-TRg-4":2988,
"CC8_BC2-CTR86-TRg-4":2989,
"CC8_BC2-RPB5-TRg-5":2990,
"CC8_BC2-SPN1-NRg-2":2991,
"CC8_BC2-SPN1-NRg-1":2992,
"CC8_BC2-SEC61-NRg-1":2993,
"CC8_BC2-SEC61-NRg-7":2994,
"CC8_BC2-TUS1-TRg-3":2995,
"CC8_BC2-OLE1-NRg-2":2996,
"CC8_BC2-AFG2-TRg-1":2997,
"CC8_BC2-TOA2-NRg-1":2998,
"CC8_BC2-USO1-TRg-1":2999,
"CC8_BC2-UTP22-NRg-2":3000,
"CC8_BC2-RIB1-TRg-3":3001,
"CC8_BC2-RIB1-TRg-7":3002,
"CC8_BC2-RIB1-TRg-4":3003,
"CC8_BC2-COG1-TRg-1":3004,
"CC8_BC2-RPL32-NRg-2":3005,
"CC8_BC2-GLC7-NRg-3":3006,
"CC8_BC2-GLC7-NRg-4":3007,
"CC8_BC2-HSF1-TRg-2":3008,
"CC8_BC2-DAM1-NRg-5":3009,
"CC8_BC2-SEC18-TRg-4":3010,
"CC8_BC2-SEC18-TRg-5":3011,
"CC8_BC2-PAB1-NRg-3":3012,
"CC8_BC2-POP8-TRg-2":3013,
"CC8_BC2-PAB1-NRg-4":3014,
"CC8_BC2-BIG1-TRg-4":3015,
"CC8_BC2-BIG1-TRg-5":3016,
"CC8_BC2-BIG1-TRg-6":3017,
"CC8_BC2-RPO41-NRg-1":3018,
"CC8_BC2-RVB2-NRg-2":3019,
"CC8_BC2-PET117-NRg-8":3020,
"CC8_BC2-VPS45-NRg-9":3021,
"CC8_BC2-YCG1-NRg-1":3022,
"CC8_BC2-NOC4-NRg-1":3023,
"CC8_BC2-NMD3-NRg-2":3024,
"CC8_BC2-DRS1-TRg-2":3025,
"CC8_BC2-HTB1-NRg-2":3026,
"CC8_BC2-IPI1-TRg-2":3027,
"CC8_BC2-SEC18-NRg-1":3028,
"CC8_BC2-SEC18-NRg-2":3029,
"CC8_BC2-JIP5-NRg-2":3030,
"CC8_BC2-YPT1-TRg-3":3031,
"CC8_BC2-YPT1-TRg-2":3032,
"CC8_BC2-CLF1-NRg-2":3033,
"CC8_BC2-SNF2-NRg-7":3034,
"CC8_BC2-SNF2-NRg-4":3035,
"CC8_BC2-RPL25-NRg-1":3036,
"CC8_BC2-NOP56-TRg-1":3037,
"CC8_BC2-NOP56-TRg-2":3038,
"CC8_BC2-TRS31-TRg-1":3039,
"CC8_BC2-DBF4-TRg-2":3040,
"CC8_BC2-DBF4-TRg-1":3041,
"CC8_BC2-RPC19-TRg-4":3042,
"CC8_BC2-RPC19-TRg-6":3043,
"CC8_BC2-RPC19-TRg-3":3044,
"CC8_BC2-ROK1-NRg-1":3045,
"CC8_BC2-CDC33-TRg-4":3046,
"CC8_BC2-DHR2-TRg-3":3047,
"CC8_BC2-RRP42-NRg-5":3048,
"CC8_BC2-CLF1-TRg-1":3049,
"CC8_BC2-ERG11-NA-16":3050,
"CC8_BC2-VAS1-NRg-4":3051,
"CC8_BC2-PIK1-NRg-2":3052,
"CC8_BC2-SAR1-NRg-7":3053,
"CC8_BC2-SAR1-NRg-4":3054,
"CC8_BC2-RPS3-TRg-1":3055,
"CC8_BC2-YTM1-TRg-2":3056,
"CC8_BC2-SUI3-NRg-5":3057,
"CC8_BC2-SUI3-NRg-2":3058,
"CC8_BC2-RRP7-TRg-4":3059,
"CC8_BC2-RRP7-TRg-6":3060,
"CC8_BC2-NIP7-TRg-2":3061,
"CC8_BC2-MDM35-TRg-1":3062,
"CC8_BC2-ALA1-NRg-1":3063,
"CC8_BC2-DOA4-NRg-2":3064,
"CC8_BC2-RPS13-NRg-1":3065,
"CC8_BC2-YSF3-TRg-2":3066,
"CC8_BC2-RPS2-NRg-11":3067,
"CC8_BC2-SSL1-TRg-10":3068,
"CC8_BC2-NIP7-TRg-1":3069,
"CC8_BC2-LST8-NRg-1":3070,
"CC8_BC2-TAF4-TRg-3":3071,
"CC8_BC2-HAS1-TRg-2":3072,
"CC8_BC2-GLC7-TRg-2":3073,
"CC8_BC2-CDC45-NRg-1":3074,
"CC8_BC2-SEC22-NRg-8":3075,
"CC8_BC2-YOS1-TRg-2":3076,
"CC8_BC2-RBA50-TRg-3":3077,
"CC8_BC2-SPP41-NRg-2":3078,
"CC8_BC2-PRP46-TRg-2":3079,
"CC8_BC2-PGA2-NRg-1":3080,
"CC8_BC2-CBF5-TRg-3":3081,
"CC8_BC2-TCP1-NRg-3":3082,
"CC8_BC2-TCP1-NRg-2":3083,
"CC8_BC2-ERG26-NRg-2":3084,
"CC8_BC2-ERG26-NRg-4":3085,
"CC8_BC2-MES1-TRg-5":3086,
"CC8_BC2-HTS1-TRg-2":3087,
"CC8_BC2-SSS1-TRg-3":3088,
"CC8_BC2-SSS1-TRg-2":3089,
"CC8_BC2-SYS1-TRg-7":3090,
"CC8_BC2-SYS1-TRg-2":3091,
"CC8_BC2-SYS1-TRg-1":3092,
"CC8_BC2-BFR2-TRg-1":3093,
"CC8_BC2-EOS1-TRg-3":3094,
"CC8_BC2-TAF4-NRg-1":3095,
"CC8_BC2-ARL3-NRg-8":3096,
"CC8_BC2-RPN5-NRg-1":3097,
"CC8_BC2-TIM9-NRg-2":3098,
"CC8_BC2-NUP57-NRg-3":3099,
"CC8_BC2-VPS4-TRg-1":3100,
"CC8_BC2-CDC3-TRg-4":3101,
"CC8_BC2-BBP1-NRg-1":3102,
"CC8_BC2-BBP1-NRg-2":3103,
"CC8_BC2-USE1-NRg-3":3104,
"CC8_BC2-CCT7-TRg-1":3105,
"CC8_BC2-SAH1-TRg-3":3106,
"CC8_BC2-CHS2-TRg-1":3107,
"CC8_BC2-DPM1-TRg-2":3108,
"CC8_BC2-BBP1-TRg-1":3109,
"CC8_BC2-NRD1-TRg-4":3110,
"CC8_BC2-RPB3-NRg-1":3111,
"CC8_BC2-PHO85-NRg-6":3112,
"CC8_BC2-SNF6-TRg-6":3113,
"CC8_BC2-PRP38-NRg-2":3114,
"CC8_BC2-OAR1-NRg-3":3115,
"CC8_BC2-ROX3-NRg-1":3116,
"CC8_BC2-YPP1-TRg-6":3117,
"CC8_BC2-CBF2-NRg-8":3118,
"CC8_BC2-SPT6-TRg-5":3119,
"CC8_BC2-SEC10-NRg-1":3120,
"CC8_BC2-NSL1-NRg-3":3121,
"CC8_BC2-NRD1-NRg-8":3122,
"CC8_BC2-RPB3-TRg-1":3123,
"CC8_BC2-NRD1-NRg-4":3124,
"CC8_BC2-RVB1-TRg-2":3125,
"CC8_BC2-TIF5-NRg-8":3126,
"CC8_BC2-EOS1-NRg-1":3127,
"CC8_BC2-ERG25-NA-26":3128,
"CC8_BC2-MSL5-NRg-4":3129,
"CC8_BC2-SEC24-TRg-2":3130,
"CC8_BC2-RPL30-NRg-5":3131,
"CC8_BC2-SNU71-NRg-3":3132,
"CC8_BC2-CDC33-NRg-1":3133,
"CC8_BC2-RPN6-TRg-4":3134,
"CC8_BC2-NAB2-TRg-4":3135,
"CC8_BC2-NAB2-TRg-6":3136,
"CC8_BC2-YTM1-NRg-1":3137,
"CC8_BC2-OLE1-TRg-8":3138,
"CC8_BC2-OLE1-TRg-1":3139,
"CC8_BC2-UTP7-TRg-4":3140,
"CC8_BC2-ACT1-NRg-6":3141,
"CC8_BC2-RPL18A-NRg-3":3142,
"CC8_BC2-BRX1-NRg-1":3143,
"CC8_BC2-NAF1-TRg-8":3144,
"CC8_BC2-NAF1-TRg-6":3145,
"CC8_BC2-NAF1-TRg-4":3146,
"CC8_BC2-CDC8-TRg-2":3147,
"CC8_BC2-NSE4-TRg-1":3148,
"CC8_BC2-PAB1-NRg-2":3149,
"CC8_BC2-PRP43-TRg-4":3150,
"CC8_BC2-SEC2-NRg-3":3151,
"CC8_BC2-SEC2-NRg-6":3152,
"CC8_BC2-MPP10-NRg-5":3153,
"CC8_BC2-YDR355C-TRg-2":3154,
"CC8_BC2-YLR339C-TRg-9":3155,
"CC8_BC2-SNM1-TRg-2":3156,
"CC8_BC2-ALR1-NRg-4":3157,
"CC8_BC2-ALR1-NRg-1":3158,
"CC8_BC2-ALR1-NRg-3":3159,
"CC8_BC2-RPL10-TRg-1":3160,
"CC8_BC2-RPL28-TRg-2":3161,
"CC8_BC2-UTP25-TRg-1":3162,
"CC8_BC2-POB3-TRg-1":3163,
"CC8_BC2-POB3-TRg-3":3164,
"CC8_BC2-POB3-TRg-2":3165,
"CC8_BC2-MED11-TRg-1":3166,
"CC8_BC2-ISA1-TRg-15":3167,
"CC8_BC2-RRP1-NRg-1":3168,
"CC8_BC2-MES1-NRg-1":3169,
"CC8_BC2-SEC13-NRg-5":3170,
"CC8_BC2-MCM2-NRg-2":3171,
"CC8_BC2-ALA1-TRg-4":3172,
"CC8_BC2-MTG2-TRg-5":3173,
"CC8_BC2-TIF35-NRg-3":3174,
"CC8_BC2-NSE1-TRg-3":3175,
"CC8_BC2-NSE1-TRg-4":3176,
"CC8_BC2-MOB2-NRg-6":3177,
"CC8_BC2-VRG4-NRg-3":3178,
"CC8_BC2-PRP9-TRg-3":3179,
"CC8_BC2-HYM1-TRg-5":3180,
"CC8_BC2-POP1-TRg-5":3181,
"CC8_BC2-POP1-TRg-9":3182,
"CC8_BC2-RPL17A-TRg-1":3183,
"CC8_BC2-SLD2-TRg-1":3184,
"CC8_BC2-CDC48-NRg-7":3185,
"CC8_BC2-FHL1-NRg-2":3186,
"CC8_BC2-BET3-NRg-7":3187,
"CC8_BC2-MAK21-TRg-1":3188,
"CC8_BC2-BRN1-TRg-4":3189,
"CC8_BC2-FBA1-NRg-3":3190,
"CC8_BC2-CDC42-TRg-6":3191,
"CC8_BC2-CDC42-TRg-7":3192,
"CC8_BC2-COG4-NRg-1":3193,
"CC8_BC2-ATP3-NRg-3":3194,
"CC8_BC2-ATP3-NRg-2":3195,
"CC8_BC2-SMP3-TRg-5":3196,
"CC8_BC2-CFT2-NRg-2":3197,
"CC8_BC2-FAS2-TRg-5":3198,
"CC8_BC2-DBP2-NRg-3":3199,
"CC8_BC2-DBP2-NRg-2":3200,
"CC8_BC2-MPS2-NRg-4":3201,
"CC8_BC2-ARC35-TRg-2":3202,
"CC8_BC2-ARC35-TRg-5":3203,
"CC8_BC2-MRD1-TRg-1":3204,
"CC8_BC2-RLP7-TRg-1":3205,
"CC8_BC2-SPC34-TRg-1":3206,
"CC8_BC2-CDC45-TRg-2":3207,
"CC8_BC2-GCD6-TRg-3":3208,
"CC8_BC2-GCD6-TRg-4":3209,
"CC8_BC2-YPT6-NRg-2":3210,
"CC8_BC2-RPS13-TRg-2":3211,
"CC8_BC2-IPI3-TRg-3":3212,
"CC8_BC2-TIF5-NRg-9":3213,
"CC8_BC2-TIF5-NRg-7":3214,
"CC8_BC2-TIF5-NRg-6":3215,
"CC8_BC2-NAB3-TRg-3":3216,
"CC8_BC2-GCD2-TRg-1":3217,
"CC8_BC2-UBA1-TRg-2":3218,
"CC8_BC2-SLD3-TRg-6":3219,
"CC8_BC2-LCB1-TRg-5":3220,
"CC8_BC2-TOA2-TRg-6":3221,
"CC8_BC2-TOA2-TRg-1":3222,
"CC8_BC2-TOA2-TRg-3":3223,
"CC8_BC2-LSM2-TRg-1":3224,
"CC8_BC2-YML6-TRg-13":3225,
"CC8_BC2-YML6-TRg-12":3226,
"CC8_BC2-UTP15-NRg-1":3227,
"CC8_BC2-TIF6-NRg-8":3228,
"CC8_BC2-SUP35-NRg-1":3229,
"CC8_BC2-MPP10-NRg-1":3230,
"CC8_BC2-SWI3-TRg-7":3231,
"CC8_BC2-SSN3-NRg-2":3232,
"CC8_BC2-SEC13-NRg-7":3233,
"CC8_BC2-RPS15-NRg-3":3234,
"CC8_BC2-RPL3-TRg-2":3235,
"CC8_BC2-FBA1-NRg-2":3236,
"CC8_BC2-FBA1-NRg-1":3237,
"CC8_BC2-FBA1-NRg-5":3238,
"CC8_BC2-DAM1-TRg-2":3239,
"CC8_BC2-NHP2-TRg-2":3240,
"CC8_BC2-HCA4-NRg-6":3241,
"CC8_BC2-PRE3-TRg-4":3242,
"CC8_BC2-DBP5-NRg-4":3243,
"CC8_BC2-SPT6-NRg-4":3244,
"CC8_BC2-SPT6-NRg-2":3245,
"CC8_BC2-RPL18A-TRg-4":3246,
"CC8_BC2-KSH1-TRg-1":3247,
"CC8_BC2-KSH1-TRg-3":3248,
"CC8_BC2-IPI3-NRg-1":3249,
"CC8_BC2-PGA2-TRg-8":3250,
"CC8_BC2-RPL18A-TRg-2":3251,
"CC8_BC2-RPL33A-NRg-6":3252,
"CC8_BC2-TAF12-NRg-2":3253,
"CC8_BC2-USE1-TRg-5":3254,
"CC8_BC2-YNL114C-TRg-1":3255,
"CC8_BC2-SMC5-TRg-7":3256,
"CC8_BC2-SMC5-TRg-6":3257,
"CC8_BC2-RSC58-TRg-1":3258,
"CC8_BC2-CTF13-TRg-2":3259,
"CC8_BC2-NAB2-NRg-2":3260,
"CC8_BC2-MCM7-TRg-4":3261,
"CC8_BC2-BCP1-NRg-5":3262,
"CC8_BC2-STU2-TRg-3":3263,
"CC8_BC2-SEC21-NRg-6":3264,
"CC8_BC2-SEC21-NRg-3":3265,
"CC8_BC2-RPL1B-TRg-3":3266,
"CC8_BC2-SEC20-NRg-2":3267,
"CC8_BC2-VMA3-NRg-2":3268,
"CC8_BC2-SEC23-NRg-5":3269,
"CC8_BC2-CDC28-TRg-4":3270,
"CC8_BC2-RPN12-NRg-11":3271,
"CC8_BC2-PUP3-TRg-3":3272,
"CC8_BC2-SEC31-TRg-2":3273,
"CC8_BC2-SED5-TRg-6":3274,
"CC8_BC2-SED5-TRg-5":3275,
"CC8_BC2-RPL33A-TRg-1":3276,
"CC8_BC2-RPL33A-TRg-2":3277,
"CC8_BC2-MRPL11-TRg-2":3278,
"CC8_BC2-RTP1-NRg-2":3279,
"CC8_BC2-NUG1-TRg-2":3280,
"CC8_BC2-VPH2-TRg-4":3281,
"CC8_BC2-COP1-NRg-3":3282,
"CC8_BC2-CRM1-NRg-1":3283,
"CC8_BC2-RPL5-NRg-4":3284,
"CC8_BC2-SNU13-NRg-4":3285,
"CC8_BC2-PFS2-TRg-3":3286,
"CC8_BC2-MPP10-TRg-2":3287,
"CC8_BC2-TSR4-NRg-2":3288,
"CC8_BC2-RSC2-TRg-1":3289,
"CC8_BC2-SEC65-TRg-2":3290,
"CC8_BC2-SMI1-NRg-1":3291,
"CC8_BC2-RTT105-NRg-4":3292,
"CC8_BC2-VMA5-TRg-3":3293,
"CC8_BC2-VMA5-TRg-5":3294,
"CC8_BC2-RRP1-TRg-3":3295,
"CC8_BC2-CLC1-TRg-2":3296,
"CC8_BC2-GCD6-NRg-1":3297,
"CC8_BC2-GCD6-NRg-2":3298,
"CC8_BC2-PXR1-TRg-1":3299,
"CC8_BC2-CDC14-NRg-1":3300,
"CC8_BC2-PCF11-TRg-6":3301,
"CC8_BC2-PCF11-TRg-5":3302,
"CC8_BC2-PCF11-TRg-4":3303,
"CC8_BC2-SEC31-NRg-1":3304,
"CC8_BC2-RRP5-NRg-1":3305,
"CC8_BC2-PRE10-TRg-5":3306,
"CC8_BC2-PRE10-TRg-1":3307,
"CC8_BC2-RPS5-TRg-2":3308,
"CC8_BC2-NSP1-TRg-4":3309,
"CC8_BC2-PRP38-TRg-4":3310,
"CC8_BC2-RCF1-NRg-5":3311,
"CC8_BC2-RSC3-TRg-4":3312,
"CC8_BC2-RSC3-TRg-5":3313,
"CC8_BC2-RSC3-TRg-6":3314,
"CC8_BC2-HTA1-NRg-12":3315,
"CC8_BC2-HTA1-NRg-11":3316,
"CC8_BC2-UTP23-TRg-2":3317,
"CC8_BC2-GCD7-NRg-1":3318,
"CC8_BC2-GCD7-NRg-2":3319,
"CC8_BC2-GCD7-NRg-6":3320,
"CC8_BC2-GAL11-NRg-2":3321,
"CC8_BC2-GAL11-NRg-9":3322,
"CC8_BC2-PHO4-TRg-5":3323,
"CC8_BC2-SNP1-NRg-3":3324,
"CC8_BC2-RPC37-TRg-5":3325,
"CC8_BC2-CRM1-TRg-5":3326,
"CC8_BC2-CRM1-TRg-2":3327,
"CC8_BC2-ASK1-TRg-7":3328,
"CC8_BC2-STU2-NRg-4":3329,
"CC8_BC2-NEO1-NRg-3":3330,
"CC8_BC2-GAL11-TRg-5":3331,
"CC8_BC2-GAL11-TRg-7":3332,
"CC8_BC2-SAM50-NRg-3":3333,
"CC8_BC2-CSL4-TRg-2":3334,
"CC8_BC2-CCT5-TRg-2":3335,
"CC8_BC2-POL30-NRg-1":3336,
"CC8_BC2-MED4-TRg-4":3337,
"CC8_BC2-MED4-TRg-3":3338,
"CC8_BC2-MED4-TRg-2":3339,
"CC8_BC2-GDI1-TRg-4":3340,
"CC8_BC2-GDI1-TRg-3":3341,
"CC8_BC2-REB1-TRg-6":3342,
"CC8_BC2-MRPL37-NRg-2":3343,
"CC8_BC2-NOC3-TRg-3":3344,
"CC8_BC2-SPC97-TRg-3":3345,
"CC8_BC2-IPP1-TRg-3":3346,
"CC8_BC2-IPP1-TRg-2":3347,
"CC8_BC2-PTI1-TRg-3":3348,
"CC8_BC2-PTI1-TRg-5":3349,
"CC8_BC2-RFC5-NRg-1":3350,
"CC8_BC2-CDC24-TRg-1":3351,
"CC8_BC2-CDC24-TRg-3":3352,
"CC8_BC2-CDC24-TRg-5":3353,
"CC8_BC2-CDC24-TRg-6":3354,
"CC8_BC2-UTP23-TRg-6":3355,
"CC8_BC2-UTP23-TRg-4":3356,
"CC8_BC2-UTP23-TRg-1":3357,
"CC8_BC2-RHO3-NRg-4":3358,
"CC8_BC2-TRS23-NRg-1":3359,
"CC8_BC2-TRS23-NRg-3":3360,
"CC8_BC2-RSP5-TRg-2":3361,
"CC8_BC2-RSP5-TRg-1":3362,
"CC8_BC2-SDA1-NRg-1":3363,
"CC8_BC2-KAP95-TRg-8":3364,
"CC8_BC2-ACO1-TRg-6":3365,
"CC8_BC2-HTA1-NRg-3":3366,
"CC8_BC2-HTA1-NRg-2":3367,
"CC8_BC2-SPN1-TRg-1":3368,
"CC8_BC2-MOT1-NRg-7":3369,
"CC8_BC2-RPL17A-NRg-4":3370,
"CC8_BC2-ADA2-TRg-4":3371,
"CC8_BC2-SFH1-NRg-1":3372,
"CC8_BC2-SPC97-NRg-5":3373,
"CC8_BC2-PRP22-TRg-3":3374,
"CC8_BC2-SEN15-TRg-2":3375,
"CC8_BC2-RPL3-NRg-2":3376,
"CC8_BC2-ISD11-NRg-2":3377,
"CC8_BC2-HEM12-TRg-8":3378,
"CC8_BC2-SEC10-TRg-1":3379,
"CC8_BC2-HTB1-TRg-7":3380,
"CC8_BC2-TTI2-TRg-1":3381,
"CC8_BC2-ACP1-TRg-2":3382,
"CC8_BC2-ACP1-TRg-4":3383,
"CC8_BC2-GAL11-NRg-10":3384,
"CC8_BC2-UTP22-TRg-2":3385,
"CC8_BC2-MST1-NRg-5":3386,
"CC8_BC2-RIB7-NRg-2":3387,
"CC8_BC2-MCD1-TRg-6":3388,
"CC8_BC2-MCD1-TRg-5":3389,
"CC8_BC2-GPI8-NRg-2":3390,
"CC8_BC2-THS1-TRg-2":3391,
"CC8_BC2-RRP7-TRg-2":3392,
"CC8_BC2-RRP7-TRg-5":3393,
"CC8_BC2-SMX2-NRg-7":3394,
"CC8_BC2-RRP45-TRg-5":3395,
"CC8_BC2-RRP45-TRg-4":3396,
"CC8_BC2-CNS1-TRg-2":3397,
"CC8_BC2-FBP1-NRg-9":3398,
"CC8_BC2-GCD11-NRg-1":3399,
"CC8_BC2-RPL10-TRg-2":3400,
"CC8_BC2-NUP192-TRg-4":3401,
"CC8_BC2-NUP145-NRg-4":3402,
"CC8_BC2-HEM12-TRg-6":3403,
"CC8_BC2-PLC1-TRg-3":3404,
"CC8_BC2-RPA43-TRg-1":3405,
"CC8_BC2-RPB7-NRg-2":3406,
"CC8_BC2-RPB7-NRg-3":3407,
"CC8_BC2-NSL1-NRg-1":3408,
"CC8_BC2-UTP6-TRg-3":3409,
"CC8_BC2-UTP6-TRg-1":3410,
"CC8_BC2-YJU2-TRg-5":3411,
"CC8_BC2-FRS2-NRg-5":3412,
"CC8_BC2-TIF35-NRg-2":3413,
"CC8_BC2-GPI15-TRg-1":3414,
"CC8_BC2-NOP1-NRg-5":3415,
"CC8_BC2-GPI15-TRg-4":3416,
"CC8_BC2-COG4-TRg-1":3417,
"CC8_BC2-TFA1-TRg-1":3418,
"CC8_BC2-RHO1-NRg-2":3419,
"CC8_BC2-RHO1-NRg-1":3420,
"CC8_BC2-CDC55-NRg-2":3421,
"CC8_BC2-IDI1-NRg-7":3422,
"CC8_BC2-RPL32-TRg-5":3423,
"CC8_BC2-RPB5-TRg-4":3424,
"CC8_BC2-DIP2-TRg-5":3425,
"CC8_BC2-DIP2-TRg-1":3426,
"CC8_BC2-RPC40-TRg-2":3427,
"CC8_BC2-CDC6-TRg-5":3428,
"CC8_BC2-CDC6-TRg-3":3429,
"CC8_BC2-DAD2-TRg-2":3430,
"CC8_BC2-RVS161-TRg-2":3431,
"CC8_BC2-RVS161-TRg-1":3432,
"CC8_BC2-SUP45-NRg-3":3433,
"CC8_BC2-SRB6-NRg-5":3434,
"CC8_BC2-RPC11-TRg-4":3435,
"CC8_BC2-RKI1-TRg-8":3436,
"CC8_BC2-NIP7-TRg-3":3437,
"CC8_BC2-RPL33A-NRg-12":3438,
"CC8_BC2-SAM50-TRg-4":3439,
"CC8_BC2-NOP4-NRg-1":3440,
"CC8_BC2-NOP4-NRg-3":3441,
"CC8_BC2-SMX2-TRg-5":3442,
"CC8_BC2-POL12-NRg-2":3443,
"CC8_BC2-BMS1-NRg-2":3444,
"CC8_BC2-RPA190-TRg-5":3445,
"CC8_BC2-ALG14-NRg-4":3446,
"CC8_BC2-ALG14-NRg-1":3447,
"CC8_BC2-PRE5-NRg-1":3448,
"CC8_BC2-BIG1-NRg-2":3449,
"CC8_BC2-TFA2-TRg-4":3450,
"CC8_BC2-IMP4-TRg-6":3451,
"CC8_BC2-PAN1-NRg-1":3452,
"CC8_BC2-UTP13-TRg-2":3453,
"CC8_BC2-KAE1-NRg-3":3454,
"CC8_BC2-ERG20-TRg-1":3455,
"CC8_BC2-CDC20-TRg-6":3456,
"CC8_BC2-PWP2-NRg-2":3457,
"CC8_BC2-COG1-NRg-1":3458,
"CC8_BC2-RPL1B-TRg-4":3459,
"CC8_BC2-RPL1B-TRg-7":3460,
"CC8_BC2-UTP20-TRg-3":3461,
"CC8_BC2-UTP20-TRg-4":3462,
"CC8_BC2-RPL25-TRg-4":3463,
"CC8_BC2-RPL25-TRg-2":3464,
"CC8_BC2-MCM7-NRg-1":3465,
"CC8_BC2-MRP49-TRg-5":3466,
"CC8_BC2-ERO1-NRg-3":3467,
"CC8_BC2-UTP5-TRg-7":3468,
"CC8_BC2-MCM4-NRg-1":3469,
"CC8_BC2-PRE3-NRg-1":3470,
"CC8_BC2-FCF1-NRg-1":3471,
"CC8_BC2-CUS1-NRg-1":3472,
"CC8_BC2-PSF1-TRg-2":3473,
"CC8_BC2-BCP1-TRg-2":3474,
"CC8_BC2-PAN1-TRg-1":3475,
"CC8_BC2-PAN1-TRg-3":3476,
"CC8_BC2-PAN1-TRg-4":3477,
"CC8_BC2-VPS3-TRg-2":3478,
"CC8_BC2-YIL060W-NRg-1":3479,
"CC8_BC2-VPS53-NRg-1":3480,
"CC8_BC2-CYR1-TRg-4":3481,
"CC8_BC2-CYR1-TRg-7":3482,
"CC8_BC2-MPS1-NRg-1":3483,
"CC8_BC2-SRP1-TRg-5":3484,
"CC8_BC2-SRP1-TRg-4":3485,
"CC8_BC2-TAF12-TRg-2":3486,
"CC8_BC2-TAF12-TRg-3":3487,
"CC8_BC2-POP4-TRg-1":3488,
"CC8_BC2-SPT16-TRg-1":3489,
"CC8_BC2-NUP82-TRg-4":3490,
"CC8_BC2-DML1-TRg-3":3491,
"CC8_BC2-RPA43-NRg-3":3492,
"CC8_BC2-STU2-NRg-3":3493,
"CC8_BC2-POP4-NRg-4":3494,
"CC8_BC2-MCD1-TRg-2":3495,
"CC8_BC2-RPS3-NRg-4":3496,
"CC8_BC2-PRP9-TRg-4":3497,
"CC8_BC2-RPP1-NRg-2":3498,
"CC8_BC2-MTR2-NRg-11":3499,
"CC8_BC2-GCD11-TRg-1":3500,
"CC8_BC2-RPF1-TRg-3":3501,
"CC8_BC2-SUB2-NRg-4":3502,
"CC8_BC2-GPI15-TRg-3":3503,
"CC8_BC2-ERG9-TRg-6":3504,
"CC8_BC2-RPT2-NRg-1":3505,
"CC8_BC2-YOS1-NRg-3":3506,
"CC8_BC2-SCM3-TRg-4":3507,
"CC8_BC2-SCM3-TRg-6":3508,
"CC8_BC2-RLP7-NRg-1":3509,
"CC8_BC2-TFB2-NRg-4":3510,
"CC8_BC2-IMP4-TRg-1":3511,
"CC8_BC2-IMP4-TRg-3":3512,
"CC8_BC2-PRE4-TRg-3":3513,
"CC8_BC2-SUB2-TRg-3":3514,
"CC8_BC2-RPP0-NRg-4":3515,
"CC8_BC2-RPP0-NRg-3":3516,
"CC8_BC2-TOM40-TRg-4":3517,
"CC8_BC2-FUR1-NRg-12":3518,
"CC8_BC2-TOM40-TRg-2":3519,
"CC8_BC2-VMA11-NRg-4":3520,
"CC8_BC2-PGS1-NRg-4":3521,
"CC8_BC2-URB1-TRg-4":3522,
"CC8_BC2-ARP4-TRg-3":3523,
"CC8_BC2-RPT3-TRg-3":3524,
"CC8_BC2-SUI3-TRg-3":3525,
"CC8_BC2-RFC5-NRg-2":3526,
"CC8_BC2-RRP14-TRg-2":3527,
"CC8_BC2-SCC2-TRg-1":3528,
"CC8_BC2-SSC1-TRg-3":3529,
"CC8_BC2-RRP9-TRg-3":3530,
"CC8_BC2-MOT1-NRg-9":3531,
"CC8_BC2-RPL42A-NRg-2":3532,
"CC8_BC2-SEC16-TRg-7":3533,
"CC8_BC2-IMP4-NRg-2":3534,
"CC8_BC2-YEF3-NRg-4":3535,
"CC8_BC2-PUP1-TRg-1":3536,
"CC8_BC2-UTP22-TRg-6":3537,
"CC8_BC2-DBP2-NRg-4":3538,
"CC8_BC2-PRE2-TRg-7":3539,
"CC8_BC2-ATP16-TRg-6":3540,
"CC8_BC2-UTP13-TRg-4":3541,
"CC8_BC2-DOP1-NRg-4":3542,
"CC8_BC2-TIM44-TRg-3":3543,
"CC8_BC2-ATP16-TRg-2":3544,
"CC8_BC2-ENP1-NRg-3":3545,
"CC8_BC2-NAF1-TRg-3":3546,
"CC8_BC2-COG4-TRg-2":3547,
"CC8_BC2-SOG2-TRg-7":3548,
"CC8_BC2-YDR341C-TRg-3":3549,
"CC8_BC2-YMR290W-A-TRg-10":3550,
"CC8_BC2-NUP192-NRg-9":3551,
"CC8_BC2-RPS31-NRg-8":3552,
"CC8_BC2-SPC97-NRg-6":3553,
"CC8_BC2-EBP2-NRg-1":3554,
"CC8_BC2-CDC48-TRg-5":3555,
"CC8_BC2-RPT1-TRg-4":3556,
"CC8_BC2-ULP1-NRg-2":3557,
"CC8_BC2-RPN3-TRg-6":3558,
"CC8_BC2-RPT1-TRg-5":3559,
"CC8_BC2-KRE5-TRg-2":3560,
"CC8_BC2-TBF1-NRg-8":3561,
"CC8_BC2-UTP22-NRg-4":3562,
"CC8_BC2-SSC1-NRg-4":3563,
"CC8_BC2-REB1-TRg-4":3564,
"CC8_BC2-CDC48-NRg-9":3565,
"CC8_BC2-FAS2-TRg-8":3566,
"CC8_BC2-TAO3-TRg-8":3567,
"CC8_BC2-CKS1-TRg-5":3568,
"CC8_BC2-YLR379W-TRg-7":3569,
"CC8_BC2-TEN1-NRg-2":3570,
"CC8_BC2-RPL42A-TRg-2":3571,
"CC8_BC2-SEC27-TRg-4":3572,
"CC8_BC2-TBF1-NRg-4":3573,
"CC8_BC2-RPT1-NRg-6":3574,
"CC8_BC2-COG1-TRg-3":3575,
"CC8_BC2-SUI1-TRg-6":3576,
"CC8_BC2-TIM23-TRg-6":3577,
"CC8_BC2-CDC48-NRg-6":3578,
"CC8_BC2-EPL1-TRg-5":3579,
"CC8_BC2-RPT5-TRg-8":3580,
"CC8_BC2-ATP16-NRg-4":3581,
"CC8_BC2-RPN6-TRg-3":3582,
"CC8_BC2-ERG9-NRg-6":3583,
"CC8_BC2-SMX3-TRg-1":3584,
"CC8_BC2-NCB2-NRg-3":3585,
"CC8_BC2-SEC16-NRg-12":3586,
"CC8_BC2-RPN6-TRg-2":3587,
"CC8_BC2-REB1-NRg-4":3588,
"CC8_BC2-ATP16-TRg-9":3589,
"CC8_BC2-ERG9-NRg-7":3590,
"CC16_BC2-RPL15A-NRg-4":3591,
"CC16_BC2-RPL15A-NRg-5":3592,
"CC16_BC2-KRE33-TRg-1":3593,
"CC16_BC2-PMI40-NRg-1":3594,
"CC16_BC2-NOP19-NRg-3":3595,
"CC16_BC2-SRP14-NRg-4":3596,
"CC16_BC2-SEC27-TRg-2":3597,
"CC16_BC2-GPI14-TRg-3":3598,
"CC16_BC2-PAH1-TRg-7":3599,
"CC16_BC2-PAH1-TRg-6":3600,
"CC16_BC2-PAH1-TRg-5":3601,
"CC16_BC2-PAH1-TRg-3":3602,
"CC16_BC2-COG3-TRg-1":3603,
"CC16_BC2-HTS1-NRg-5":3604,
"CC16_BC2-MSN5-TRg-7":3605,
"CC16_BC2-ERG26-TRg-1":3606,
"CC16_BC2-SMD2-TRg-5":3607,
"CC16_BC2-SMD2-TRg-4":3608,
"CC16_BC2-SMD2-TRg-1":3609,
"CC16_BC2-PRE7-TRg-4":3610,
"CC16_BC2-PRE7-TRg-7":3611,
"CC16_BC2-SEC6-TRg-3":3612,
"CC16_BC2-ESF2-NRg-1":3613,
"CC16_BC2-ESF2-NRg-3":3614,
"CC16_BC2-AFG2-TRg-2":3615,
"CC16_BC2-RRP36-TRg-3":3616,
"CC16_BC2-RRP36-TRg-5":3617,
"CC16_BC2-GCR1-NRg-2":3618,
"CC16_BC2-PRE4-NRg-4":3619,
"CC16_BC2-PRE4-NRg-9":3620,
"CC16_BC2-DSN1-NRg-2":3621,
"CC16_BC2-GPI11-TRg-3":3622,
"CC16_BC2-POP3-TRg-1":3623,
"CC16_BC2-MNE1-TRg-5":3624,
"CC16_BC2-RRP12-NRg-1":3625,
"CC16_BC2-RSC6-TRg-2":3626,
"CC16_BC2-CDC25-TRg-1":3627,
"CC16_BC2-CDC25-TRg-9":3628,
"CC16_BC2-YPP1-NRg-3":3629,
"CC16_BC2-NFS1-NRg-9":3630,
"CC16_BC2-NFS1-NRg-8":3631,
"CC16_BC2-UBA2-TRg-1":3632,
"CC16_BC2-ARP2-NRg-3":3633,
"CC16_BC2-MAK16-TRg-1":3634,
"CC16_BC2-CEP3-NRg-1":3635,
"CC16_BC2-GUK1-TRg-5":3636,
"CC16_BC2-GUK1-TRg-2":3637,
"CC16_BC2-GPI12-NRg-6":3638,
"CC16_BC2-RPS5-NRg-5":3639,
"CC16_BC2-RPS5-NRg-2":3640,
"CC16_BC2-RPC19-NRg-1":3641,
"CC16_BC2-TIM54-TRg-1":3642,
"CC16_BC2-TEN1-TRg-2":3643,
"CC16_BC2-SAH1-NRg-4":3644,
"CC16_BC2-SAH1-NRg-5":3645,
"CC16_BC2-SAH1-NRg-3":3646,
"CC16_BC2-ATP15-NRg-5":3647,
"CC16_BC2-SCD5-TRg-5":3648,
"CC16_BC2-ARB1-NRg-2":3649,
"CC16_BC2-ARB1-NRg-4":3650,
"CC16_BC2-PUP2-TRg-1":3651,
"CC16_BC2-CCT8-TRg-2":3652,
"CC16_BC2-MCM4-TRg-1":3653,
"CC16_BC2-LSM4-TRg-1":3654,
"CC16_BC2-NOP53-NRg-1":3655,
"CC16_BC2-ATP3-TRg-4":3656,
"CC16_BC2-AFG2-NRg-3":3657,
"CC16_BC2-PRO3-NRg-3":3658,
"CC16_BC2-NRD1-NRg-10":3659,
"CC16_BC2-SEC61-TRg-2":3660,
"CC16_BC2-RHO3-TRg-4":3661,
"CC16_BC2-SNF2-TRg-6":3662,
"CC16_BC2-SMD2-NRg-3":3663,
"CC16_BC2-RSC4-TRg-2":3664,
"CC16_BC2-RSC4-TRg-1":3665,
"CC16_BC2-TIF34-TRg-2":3666,
"CC16_BC2-BET1-NRg-1":3667,
"CC16_BC2-CDC8-NRg-2":3668,
"CC16_BC2-PRP42-TRg-2":3669,
"CC16_BC2-RRB1-TRg-2":3670,
"CC16_BC2-SPC24-TRg-1":3671,
"CC16_BC2-ILS1-NRg-1":3672,
"CC16_BC2-GFA1-TRg-2":3673,
"CC16_BC2-SEC21-NRg-10":3674,
"CC16_BC2-RPC10-NRg-1":3675,
"CC16_BC2-RPB10-TRg-3":3676,
"CC16_BC2-RPB10-TRg-2":3677,
"CC16_BC2-YNL181W-TRg-1":3678,
"CC16_BC2-RAD3-NRg-1":3679,
"CC16_BC2-NOP10-TRg-1":3680,
"CC16_BC2-BFR2-TRg-3":3681,
"CC16_BC2-MCM2-TRg-6":3682,
"CC16_BC2-MCM2-TRg-4":3683,
"CC16_BC2-MPP10-TRg-1":3684,
"CC16_BC2-RET2-TRg-4":3685,
"CC16_BC2-RET2-TRg-1":3686,
"CC16_BC2-RPS2-NRg-1":3687,
"CC16_BC2-RPS2-NRg-2":3688,
"CC16_BC2-ORC4-NRg-3":3689,
"CC16_BC2-TIP20-TRg-7":3690,
"CC16_BC2-SMT3-TRg-1":3691,
"CC16_BC2-MSS18-NRg-6":3692,
"CC16_BC2-YEF3-NRg-9":3693,
"CC16_BC2-ASK1-NRg-1":3694,
"CC16_BC2-SMC1-TRg-1":3695,
"CC16_BC2-NIP1-NRg-1":3696,
"CC16_BC2-RPP1-NRg-1":3697,
"CC16_BC2-YDJ1-TRg-6":3698,
"CC16_BC2-SUB2-NRg-1":3699,
"CC16_BC2-TIM10-NRg-8":3700,
"CC16_BC2-TIM10-NRg-4":3701,
"CC16_BC2-TIM10-NRg-7":3702,
"CC16_BC2-SKI6-TRg-4":3703,
"CC16_BC2-TUB4-TRg-1":3704,
"CC16_BC2-CDC37-NRg-2":3705,
"CC16_BC2-ISD11-TRg-3":3706,
"CC16_BC2-YOS1-TRg-4":3707,
"CC16_BC2-SSC1-TRg-6":3708,
"CC16_BC2-MTR3-TRg-5":3709,
"CC16_BC2-MTR3-TRg-6":3710,
"CC16_BC2-TFA1-TRg-2":3711,
"CC16_BC2-CDC3-NRg-3":3712,
"CC16_BC2-ERG25-TA-18":3713,
"CC16_BC2-RPB11-TRg-4":3714,
"CC16_BC2-RPB11-TRg-1":3715,
"CC16_BC2-RPB11-TRg-2":3716,
"CC16_BC2-DED1-TRg-3":3717,
"CC16_BC2-DED1-TRg-1":3718,
"CC16_BC2-DED1-TRg-6":3719,
"CC16_BC2-DED1-TRg-4":3720,
"CC16_BC2-RPL10-NRg-5":3721,
"CC16_BC2-RPL10-NRg-4":3722,
"CC16_BC2-EFB1-NRg-1":3723,
"CC16_BC2-EFB1-NRg-5":3724,
"CC16_BC2-EFB1-NRg-4":3725,
"CC16_BC2-RPT3-NRg-1":3726,
"CC16_BC2-SAC6-TRg-8":3727,
"CC16_BC2-SAC6-TRg-4":3728,
"CC16_BC2-SAC6-TRg-5":3729,
"CC16_BC2-SAC6-TRg-3":3730,
"CC16_BC2-DIM1-TRg-5":3731,
"CC16_BC2-DIM1-TRg-7":3732,
"CC16_BC2-RPC17-NRg-1":3733,
"CC16_BC2-RPC17-NRg-2":3734,
"CC16_BC2-YDR341C-TRg-1":3735,
"CC16_BC2-RAP1-NRg-8":3736,
"CC16_BC2-RAP1-NRg-5":3737,
"CC16_BC2-RAP1-NRg-2":3738,
"CC16_BC2-SEC26-NRg-3":3739,
"CC16_BC2-SPP41-TRg-3":3740,
"CC16_BC2-TAP42-NRg-1":3741,
"CC16_BC2-PGA2-TRg-6":3742,
"CC16_BC2-BRL1-TRg-1":3743,
"CC16_BC2-FOL2-TRg-1":3744,
"CC16_BC2-NAB3-NRg-5":3745,
"CC16_BC2-SNF4-TRg-4":3746,
"CC16_BC2-HRR25-TRg-2":3747,
"CC16_BC2-TRS23-TRg-4":3748,
"CC16_BC2-CTR86-TRg-4":3749,
"CC16_BC2-RPB5-TRg-5":3750,
"CC16_BC2-SPN1-NRg-2":3751,
"CC16_BC2-SPN1-NRg-1":3752,
"CC16_BC2-SEC61-NRg-1":3753,
"CC16_BC2-SEC61-NRg-7":3754,
"CC16_BC2-TUS1-TRg-3":3755,
"CC16_BC2-OLE1-NRg-2":3756,
"CC16_BC2-AFG2-TRg-1":3757,
"CC16_BC2-TOA2-NRg-1":3758,
"CC16_BC2-USO1-TRg-1":3759,
"CC16_BC2-UTP22-NRg-2":3760,
"CC16_BC2-RIB1-TRg-3":3761,
"CC16_BC2-RIB1-TRg-7":3762,
"CC16_BC2-RIB1-TRg-4":3763,
"CC16_BC2-COG1-TRg-1":3764,
"CC16_BC2-RPL32-NRg-2":3765,
"CC16_BC2-GLC7-NRg-3":3766,
"CC16_BC2-GLC7-NRg-4":3767,
"CC16_BC2-HSF1-TRg-2":3768,
"CC16_BC2-DAM1-NRg-5":3769,
"CC16_BC2-SEC18-TRg-4":3770,
"CC16_BC2-SEC18-TRg-5":3771,
"CC16_BC2-PAB1-NRg-3":3772,
"CC16_BC2-POP8-TRg-2":3773,
"CC16_BC2-PAB1-NRg-4":3774,
"CC16_BC2-BIG1-TRg-4":3775,
"CC16_BC2-BIG1-TRg-5":3776,
"CC16_BC2-BIG1-TRg-6":3777,
"CC16_BC2-RPO41-NRg-1":3778,
"CC16_BC2-RVB2-NRg-2":3779,
"CC16_BC2-PET117-NRg-8":3780,
"CC16_BC2-VPS45-NRg-9":3781,
"CC16_BC2-YCG1-NRg-1":3782,
"CC16_BC2-NOC4-NRg-1":3783,
"CC16_BC2-NMD3-NRg-2":3784,
"CC16_BC2-DRS1-TRg-2":3785,
"CC16_BC2-HTB1-NRg-2":3786,
"CC16_BC2-IPI1-TRg-2":3787,
"CC16_BC2-SEC18-NRg-1":3788,
"CC16_BC2-SEC18-NRg-2":3789,
"CC16_BC2-JIP5-NRg-2":3790,
"CC16_BC2-YPT1-TRg-3":3791,
"CC16_BC2-YPT1-TRg-2":3792,
"CC16_BC2-CLF1-NRg-2":3793,
"CC16_BC2-SNF2-NRg-7":3794,
"CC16_BC2-SNF2-NRg-4":3795,
"CC16_BC2-RPL25-NRg-1":3796,
"CC16_BC2-NOP56-TRg-1":3797,
"CC16_BC2-NOP56-TRg-2":3798,
"CC16_BC2-TRS31-TRg-1":3799,
"CC16_BC2-DBF4-TRg-2":3800,
"CC16_BC2-DBF4-TRg-1":3801,
"CC16_BC2-RPC19-TRg-4":3802,
"CC16_BC2-RPC19-TRg-6":3803,
"CC16_BC2-RPC19-TRg-3":3804,
"CC16_BC2-ROK1-NRg-1":3805,
"CC16_BC2-CDC33-TRg-4":3806,
"CC16_BC2-DHR2-TRg-3":3807,
"CC16_BC2-RRP42-NRg-5":3808,
"CC16_BC2-CLF1-TRg-1":3809,
"CC16_BC2-ERG11-NA-16":3810,
"CC16_BC2-VAS1-NRg-4":3811,
"CC16_BC2-PIK1-NRg-2":3812,
"CC16_BC2-SAR1-NRg-7":3813,
"CC16_BC2-SAR1-NRg-4":3814,
"CC16_BC2-RPS3-TRg-1":3815,
"CC16_BC2-YTM1-TRg-2":3816,
"CC16_BC2-SUI3-NRg-5":3817,
"CC16_BC2-SUI3-NRg-2":3818,
"CC16_BC2-RRP7-TRg-4":3819,
"CC16_BC2-RRP7-TRg-6":3820,
"CC16_BC2-NIP7-TRg-2":3821,
"CC16_BC2-MDM35-TRg-1":3822,
"CC16_BC2-ALA1-NRg-1":3823,
"CC16_BC2-DOA4-NRg-2":3824,
"CC16_BC2-RPS13-NRg-1":3825,
"CC16_BC2-YSF3-TRg-2":3826,
"CC16_BC2-RPS2-NRg-11":3827,
"CC16_BC2-SSL1-TRg-10":3828,
"CC16_BC2-NIP7-TRg-1":3829,
"CC16_BC2-LST8-NRg-1":3830,
"CC16_BC2-TAF4-TRg-3":3831,
"CC16_BC2-HAS1-TRg-2":3832,
"CC16_BC2-GLC7-TRg-2":3833,
"CC16_BC2-CDC45-NRg-1":3834,
"CC16_BC2-SEC22-NRg-8":3835,
"CC16_BC2-YOS1-TRg-2":3836,
"CC16_BC2-RBA50-TRg-3":3837,
"CC16_BC2-SPP41-NRg-2":3838,
"CC16_BC2-PRP46-TRg-2":3839,
"CC16_BC2-PGA2-NRg-1":3840,
"CC16_BC2-CBF5-TRg-3":3841,
"CC16_BC2-TCP1-NRg-3":3842,
"CC16_BC2-TCP1-NRg-2":3843,
"CC16_BC2-ERG26-NRg-2":3844,
"CC16_BC2-ERG26-NRg-4":3845,
"CC16_BC2-MES1-TRg-5":3846,
"CC16_BC2-HTS1-TRg-2":3847,
"CC16_BC2-SSS1-TRg-3":3848,
"CC16_BC2-SSS1-TRg-2":3849,
"CC16_BC2-SYS1-TRg-7":3850,
"CC16_BC2-SYS1-TRg-2":3851,
"CC16_BC2-SYS1-TRg-1":3852,
"CC16_BC2-BFR2-TRg-1":3853,
"CC16_BC2-EOS1-TRg-3":3854,
"CC16_BC2-TAF4-NRg-1":3855,
"CC16_BC2-ARL3-NRg-8":3856,
"CC16_BC2-RPN5-NRg-1":3857,
"CC16_BC2-TIM9-NRg-2":3858,
"CC16_BC2-NUP57-NRg-3":3859,
"CC16_BC2-VPS4-TRg-1":3860,
"CC16_BC2-CDC3-TRg-4":3861,
"CC16_BC2-BBP1-NRg-1":3862,
"CC16_BC2-BBP1-NRg-2":3863,
"CC16_BC2-USE1-NRg-3":3864,
"CC16_BC2-CCT7-TRg-1":3865,
"CC16_BC2-SAH1-TRg-3":3866,
"CC16_BC2-CHS2-TRg-1":3867,
"CC16_BC2-DPM1-TRg-2":3868,
"CC16_BC2-BBP1-TRg-1":3869,
"CC16_BC2-NRD1-TRg-4":3870,
"CC16_BC2-RPB3-NRg-1":3871,
"CC16_BC2-PHO85-NRg-6":3872,
"CC16_BC2-SNF6-TRg-6":3873,
"CC16_BC2-PRP38-NRg-2":3874,
"CC16_BC2-OAR1-NRg-3":3875,
"CC16_BC2-ROX3-NRg-1":3876,
"CC16_BC2-YPP1-TRg-6":3877,
"CC16_BC2-CBF2-NRg-8":3878,
"CC16_BC2-SPT6-TRg-5":3879,
"CC16_BC2-SEC10-NRg-1":3880,
"CC16_BC2-NSL1-NRg-3":3881,
"CC16_BC2-NRD1-NRg-8":3882,
"CC16_BC2-RPB3-TRg-1":3883,
"CC16_BC2-NRD1-NRg-4":3884,
"CC16_BC2-RVB1-TRg-2":3885,
"CC16_BC2-TIF5-NRg-8":3886,
"CC16_BC2-EOS1-NRg-1":3887,
"CC16_BC2-ERG25-NA-26":3888,
"CC16_BC2-MSL5-NRg-4":3889,
"CC16_BC2-SEC24-TRg-2":3890,
"CC16_BC2-RPL30-NRg-5":3891,
"CC16_BC2-SNU71-NRg-3":3892,
"CC16_BC2-CDC33-NRg-1":3893,
"CC16_BC2-RPN6-TRg-4":3894,
"CC16_BC2-NAB2-TRg-4":3895,
"CC16_BC2-NAB2-TRg-6":3896,
"CC16_BC2-YTM1-NRg-1":3897,
"CC16_BC2-OLE1-TRg-8":3898,
"CC16_BC2-OLE1-TRg-1":3899,
"CC16_BC2-UTP7-TRg-4":3900,
"CC16_BC2-ACT1-NRg-6":3901,
"CC16_BC2-RPL18A-NRg-3":3902,
"CC16_BC2-BRX1-NRg-1":3903,
"CC16_BC2-NAF1-TRg-8":3904,
"CC16_BC2-NAF1-TRg-6":3905,
"CC16_BC2-NAF1-TRg-4":3906,
"CC16_BC2-CDC8-TRg-2":3907,
"CC16_BC2-NSE4-TRg-1":3908,
"CC16_BC2-PAB1-NRg-2":3909,
"CC16_BC2-PRP43-TRg-4":3910,
"CC16_BC2-SEC2-NRg-3":3911,
"CC16_BC2-SEC2-NRg-6":3912,
"CC16_BC2-MPP10-NRg-5":3913,
"CC16_BC2-YDR355C-TRg-2":3914,
"CC16_BC2-YLR339C-TRg-9":3915,
"CC16_BC2-SNM1-TRg-2":3916,
"CC16_BC2-ALR1-NRg-4":3917,
"CC16_BC2-ALR1-NRg-1":3918,
"CC16_BC2-ALR1-NRg-3":3919,
"CC16_BC2-RPL10-TRg-1":3920,
"CC16_BC2-RPL28-TRg-2":3921,
"CC16_BC2-UTP25-TRg-1":3922,
"CC16_BC2-POB3-TRg-1":3923,
"CC16_BC2-POB3-TRg-3":3924,
"CC16_BC2-POB3-TRg-2":3925,
"CC16_BC2-MED11-TRg-1":3926,
"CC16_BC2-ISA1-TRg-15":3927,
"CC16_BC2-RRP1-NRg-1":3928,
"CC16_BC2-MES1-NRg-1":3929,
"CC16_BC2-SEC13-NRg-5":3930,
"CC16_BC2-MCM2-NRg-2":3931,
"CC16_BC2-ALA1-TRg-4":3932,
"CC16_BC2-MTG2-TRg-5":3933,
"CC16_BC2-TIF35-NRg-3":3934,
"CC16_BC2-NSE1-TRg-3":3935,
"CC16_BC2-NSE1-TRg-4":3936,
"CC16_BC2-MOB2-NRg-6":3937,
"CC16_BC2-VRG4-NRg-3":3938,
"CC16_BC2-PRP9-TRg-3":3939,
"CC16_BC2-HYM1-TRg-5":3940,
"CC16_BC2-POP1-TRg-5":3941,
"CC16_BC2-POP1-TRg-9":3942,
"CC16_BC2-RPL17A-TRg-1":3943,
"CC16_BC2-SLD2-TRg-1":3944,
"CC16_BC2-CDC48-NRg-7":3945,
"CC16_BC2-FHL1-NRg-2":3946,
"CC16_BC2-BET3-NRg-7":3947,
"CC16_BC2-MAK21-TRg-1":3948,
"CC16_BC2-BRN1-TRg-4":3949,
"CC16_BC2-FBA1-NRg-3":3950,
"CC16_BC2-CDC42-TRg-6":3951,
"CC16_BC2-CDC42-TRg-7":3952,
"CC16_BC2-COG4-NRg-1":3953,
"CC16_BC2-ATP3-NRg-3":3954,
"CC16_BC2-ATP3-NRg-2":3955,
"CC16_BC2-SMP3-TRg-5":3956,
"CC16_BC2-CFT2-NRg-2":3957,
"CC16_BC2-FAS2-TRg-5":3958,
"CC16_BC2-DBP2-NRg-3":3959,
"CC16_BC2-DBP2-NRg-2":3960,
"CC16_BC2-MPS2-NRg-4":3961,
"CC16_BC2-ARC35-TRg-2":3962,
"CC16_BC2-ARC35-TRg-5":3963,
"CC16_BC2-MRD1-TRg-1":3964,
"CC16_BC2-RLP7-TRg-1":3965,
"CC16_BC2-SPC34-TRg-1":3966,
"CC16_BC2-CDC45-TRg-2":3967,
"CC16_BC2-GCD6-TRg-3":3968,
"CC16_BC2-GCD6-TRg-4":3969,
"CC16_BC2-YPT6-NRg-2":3970,
"CC16_BC2-RPS13-TRg-2":3971,
"CC16_BC2-IPI3-TRg-3":3972,
"CC16_BC2-TIF5-NRg-9":3973,
"CC16_BC2-TIF5-NRg-7":3974,
"CC16_BC2-TIF5-NRg-6":3975,
"CC16_BC2-NAB3-TRg-3":3976,
"CC16_BC2-GCD2-TRg-1":3977,
"CC16_BC2-UBA1-TRg-2":3978,
"CC16_BC2-SLD3-TRg-6":3979,
"CC16_BC2-LCB1-TRg-5":3980,
"CC16_BC2-TOA2-TRg-6":3981,
"CC16_BC2-TOA2-TRg-1":3982,
"CC16_BC2-TOA2-TRg-3":3983,
"CC16_BC2-LSM2-TRg-1":3984,
"CC16_BC2-YML6-TRg-13":3985,
"CC16_BC2-YML6-TRg-12":3986,
"CC16_BC2-UTP15-NRg-1":3987,
"CC16_BC2-TIF6-NRg-8":3988,
"CC16_BC2-SUP35-NRg-1":3989,
"CC16_BC2-MPP10-NRg-1":3990,
"CC16_BC2-SWI3-TRg-7":3991,
"CC16_BC2-SSN3-NRg-2":3992,
"CC16_BC2-SEC13-NRg-7":3993,
"CC16_BC2-RPS15-NRg-3":3994,
"CC16_BC2-RPL3-TRg-2":3995,
"CC16_BC2-FBA1-NRg-2":3996,
"CC16_BC2-FBA1-NRg-1":3997,
"CC16_BC2-FBA1-NRg-5":3998,
"CC16_BC2-DAM1-TRg-2":3999,
"CC16_BC2-NHP2-TRg-2":4000,
"CC16_BC2-HCA4-NRg-6":4001,
"CC16_BC2-PRE3-TRg-4":4002,
"CC16_BC2-DBP5-NRg-4":4003,
"CC16_BC2-SPT6-NRg-4":4004,
"CC16_BC2-SPT6-NRg-2":4005,
"CC16_BC2-RPL18A-TRg-4":4006,
"CC16_BC2-KSH1-TRg-1":4007,
"CC16_BC2-KSH1-TRg-3":4008,
"CC16_BC2-IPI3-NRg-1":4009,
"CC16_BC2-PGA2-TRg-8":4010,
"CC16_BC2-RPL18A-TRg-2":4011,
"CC16_BC2-RPL33A-NRg-6":4012,
"CC16_BC2-TAF12-NRg-2":4013,
"CC16_BC2-USE1-TRg-5":4014,
"CC16_BC2-YNL114C-TRg-1":4015,
"CC16_BC2-SMC5-TRg-7":4016,
"CC16_BC2-SMC5-TRg-6":4017,
"CC16_BC2-RSC58-TRg-1":4018,
"CC16_BC2-CTF13-TRg-2":4019,
"CC16_BC2-NAB2-NRg-2":4020,
"CC16_BC2-MCM7-TRg-4":4021,
"CC16_BC2-BCP1-NRg-5":4022,
"CC16_BC2-STU2-TRg-3":4023,
"CC16_BC2-SEC21-NRg-6":4024,
"CC16_BC2-SEC21-NRg-3":4025,
"CC16_BC2-RPL1B-TRg-3":4026,
"CC16_BC2-SEC20-NRg-2":4027,
"CC16_BC2-VMA3-NRg-2":4028,
"CC16_BC2-SEC23-NRg-5":4029,
"CC16_BC2-CDC28-TRg-4":4030,
"CC16_BC2-RPN12-NRg-11":4031,
"CC16_BC2-PUP3-TRg-3":4032,
"CC16_BC2-SEC31-TRg-2":4033,
"CC16_BC2-SED5-TRg-6":4034,
"CC16_BC2-SED5-TRg-5":4035,
"CC16_BC2-RPL33A-TRg-1":4036,
"CC16_BC2-RPL33A-TRg-2":4037,
"CC16_BC2-MRPL11-TRg-2":4038,
"CC16_BC2-RTP1-NRg-2":4039,
"CC16_BC2-NUG1-TRg-2":4040,
"CC16_BC2-VPH2-TRg-4":4041,
"CC16_BC2-COP1-NRg-3":4042,
"CC16_BC2-CRM1-NRg-1":4043,
"CC16_BC2-RPL5-NRg-4":4044,
"CC16_BC2-SNU13-NRg-4":4045,
"CC16_BC2-PFS2-TRg-3":4046,
"CC16_BC2-MPP10-TRg-2":4047,
"CC16_BC2-TSR4-NRg-2":4048,
"CC16_BC2-RSC2-TRg-1":4049,
"CC16_BC2-SEC65-TRg-2":4050,
"CC16_BC2-SMI1-NRg-1":4051,
"CC16_BC2-RTT105-NRg-4":4052,
"CC16_BC2-VMA5-TRg-3":4053,
"CC16_BC2-VMA5-TRg-5":4054,
"CC16_BC2-RRP1-TRg-3":4055,
"CC16_BC2-CLC1-TRg-2":4056,
"CC16_BC2-GCD6-NRg-1":4057,
"CC16_BC2-GCD6-NRg-2":4058,
"CC16_BC2-PXR1-TRg-1":4059,
"CC16_BC2-CDC14-NRg-1":4060,
"CC16_BC2-PCF11-TRg-6":4061,
"CC16_BC2-PCF11-TRg-5":4062,
"CC16_BC2-PCF11-TRg-4":4063,
"CC16_BC2-SEC31-NRg-1":4064,
"CC16_BC2-RRP5-NRg-1":4065,
"CC16_BC2-PRE10-TRg-5":4066,
"CC16_BC2-PRE10-TRg-1":4067,
"CC16_BC2-RPS5-TRg-2":4068,
"CC16_BC2-NSP1-TRg-4":4069,
"CC16_BC2-PRP38-TRg-4":4070,
"CC16_BC2-RCF1-NRg-5":4071,
"CC16_BC2-RSC3-TRg-4":4072,
"CC16_BC2-RSC3-TRg-5":4073,
"CC16_BC2-RSC3-TRg-6":4074,
"CC16_BC2-HTA1-NRg-12":4075,
"CC16_BC2-HTA1-NRg-11":4076,
"CC16_BC2-UTP23-TRg-2":4077,
"CC16_BC2-GCD7-NRg-1":4078,
"CC16_BC2-GCD7-NRg-2":4079,
"CC16_BC2-GCD7-NRg-6":4080,
"CC16_BC2-GAL11-NRg-2":4081,
"CC16_BC2-GAL11-NRg-9":4082,
"CC16_BC2-PHO4-TRg-5":4083,
"CC16_BC2-SNP1-NRg-3":4084,
"CC16_BC2-RPC37-TRg-5":4085,
"CC16_BC2-CRM1-TRg-5":4086,
"CC16_BC2-CRM1-TRg-2":4087,
"CC16_BC2-ASK1-TRg-7":4088,
"CC16_BC2-STU2-NRg-4":4089,
"CC16_BC2-NEO1-NRg-3":4090,
"CC16_BC2-GAL11-TRg-5":4091,
"CC16_BC2-GAL11-TRg-7":4092,
"CC16_BC2-SAM50-NRg-3":4093,
"CC16_BC2-CSL4-TRg-2":4094,
"CC16_BC2-CCT5-TRg-2":4095,
"CC16_BC2-POL30-NRg-1":4096,
"CC16_BC2-MED4-TRg-4":4097,
"CC16_BC2-MED4-TRg-3":4098,
"CC16_BC2-MED4-TRg-2":4099,
"CC16_BC2-GDI1-TRg-4":4100,
"CC16_BC2-GDI1-TRg-3":4101,
"CC16_BC2-REB1-TRg-6":4102,
"CC16_BC2-MRPL37-NRg-2":4103,
"CC16_BC2-NOC3-TRg-3":4104,
"CC16_BC2-SPC97-TRg-3":4105,
"CC16_BC2-IPP1-TRg-3":4106,
"CC16_BC2-IPP1-TRg-2":4107,
"CC16_BC2-PTI1-TRg-3":4108,
"CC16_BC2-PTI1-TRg-5":4109,
"CC16_BC2-RFC5-NRg-1":4110,
"CC16_BC2-CDC24-TRg-1":4111,
"CC16_BC2-CDC24-TRg-3":4112,
"CC16_BC2-CDC24-TRg-5":4113,
"CC16_BC2-CDC24-TRg-6":4114,
"CC16_BC2-UTP23-TRg-6":4115,
"CC16_BC2-UTP23-TRg-4":4116,
"CC16_BC2-UTP23-TRg-1":4117,
"CC16_BC2-RHO3-NRg-4":4118,
"CC16_BC2-TRS23-NRg-1":4119,
"CC16_BC2-TRS23-NRg-3":4120,
"CC16_BC2-RSP5-TRg-2":4121,
"CC16_BC2-RSP5-TRg-1":4122,
"CC16_BC2-SDA1-NRg-1":4123,
"CC16_BC2-KAP95-TRg-8":4124,
"CC16_BC2-ACO1-TRg-6":4125,
"CC16_BC2-HTA1-NRg-3":4126,
"CC16_BC2-HTA1-NRg-2":4127,
"CC16_BC2-SPN1-TRg-1":4128,
"CC16_BC2-MOT1-NRg-7":4129,
"CC16_BC2-RPL17A-NRg-4":4130,
"CC16_BC2-ADA2-TRg-4":4131,
"CC16_BC2-SFH1-NRg-1":4132,
"CC16_BC2-SPC97-NRg-5":4133,
"CC16_BC2-PRP22-TRg-3":4134,
"CC16_BC2-SEN15-TRg-2":4135,
"CC16_BC2-RPL3-NRg-2":4136,
"CC16_BC2-ISD11-NRg-2":4137,
"CC16_BC2-HEM12-TRg-8":4138,
"CC16_BC2-SEC10-TRg-1":4139,
"CC16_BC2-HTB1-TRg-7":4140,
"CC16_BC2-TTI2-TRg-1":4141,
"CC16_BC2-ACP1-TRg-2":4142,
"CC16_BC2-ACP1-TRg-4":4143,
"CC16_BC2-GAL11-NRg-10":4144,
"CC16_BC2-UTP22-TRg-2":4145,
"CC16_BC2-MST1-NRg-5":4146,
"CC16_BC2-RIB7-NRg-2":4147,
"CC16_BC2-MCD1-TRg-6":4148,
"CC16_BC2-MCD1-TRg-5":4149,
"CC16_BC2-GPI8-NRg-2":4150,
"CC16_BC2-THS1-TRg-2":4151,
"CC16_BC2-RRP7-TRg-2":4152,
"CC16_BC2-RRP7-TRg-5":4153,
"CC16_BC2-SMX2-NRg-7":4154,
"CC16_BC2-RRP45-TRg-5":4155,
"CC16_BC2-RRP45-TRg-4":4156,
"CC16_BC2-CNS1-TRg-2":4157,
"CC16_BC2-FBP1-NRg-9":4158,
"CC16_BC2-GCD11-NRg-1":4159,
"CC16_BC2-RPL10-TRg-2":4160,
"CC16_BC2-NUP192-TRg-4":4161,
"CC16_BC2-NUP145-NRg-4":4162,
"CC16_BC2-HEM12-TRg-6":4163,
"CC16_BC2-PLC1-TRg-3":4164,
"CC16_BC2-RPA43-TRg-1":4165,
"CC16_BC2-RPB7-NRg-2":4166,
"CC16_BC2-RPB7-NRg-3":4167,
"CC16_BC2-NSL1-NRg-1":4168,
"CC16_BC2-UTP6-TRg-3":4169,
"CC16_BC2-UTP6-TRg-1":4170,
"CC16_BC2-YJU2-TRg-5":4171,
"CC16_BC2-FRS2-NRg-5":4172,
"CC16_BC2-TIF35-NRg-2":4173,
"CC16_BC2-GPI15-TRg-1":4174,
"CC16_BC2-NOP1-NRg-5":4175,
"CC16_BC2-GPI15-TRg-4":4176,
"CC16_BC2-COG4-TRg-1":4177,
"CC16_BC2-TFA1-TRg-1":4178,
"CC16_BC2-RHO1-NRg-2":4179,
"CC16_BC2-RHO1-NRg-1":4180,
"CC16_BC2-CDC55-NRg-2":4181,
"CC16_BC2-IDI1-NRg-7":4182,
"CC16_BC2-RPL32-TRg-5":4183,
"CC16_BC2-RPB5-TRg-4":4184,
"CC16_BC2-DIP2-TRg-5":4185,
"CC16_BC2-DIP2-TRg-1":4186,
"CC16_BC2-RPC40-TRg-2":4187,
"CC16_BC2-CDC6-TRg-5":4188,
"CC16_BC2-CDC6-TRg-3":4189,
"CC16_BC2-DAD2-TRg-2":4190,
"CC16_BC2-RVS161-TRg-2":4191,
"CC16_BC2-RVS161-TRg-1":4192,
"CC16_BC2-SUP45-NRg-3":4193,
"CC16_BC2-SRB6-NRg-5":4194,
"CC16_BC2-RPC11-TRg-4":4195,
"CC16_BC2-RKI1-TRg-8":4196,
"CC16_BC2-NIP7-TRg-3":4197,
"CC16_BC2-RPL33A-NRg-12":4198,
"CC16_BC2-SAM50-TRg-4":4199,
"CC16_BC2-NOP4-NRg-1":4200,
"CC16_BC2-NOP4-NRg-3":4201,
"CC16_BC2-SMX2-TRg-5":4202,
"CC16_BC2-POL12-NRg-2":4203,
"CC16_BC2-BMS1-NRg-2":4204,
"CC16_BC2-RPA190-TRg-5":4205,
"CC16_BC2-ALG14-NRg-4":4206,
"CC16_BC2-ALG14-NRg-1":4207,
"CC16_BC2-PRE5-NRg-1":4208,
"CC16_BC2-BIG1-NRg-2":4209,
"CC16_BC2-TFA2-TRg-4":4210,
"CC16_BC2-IMP4-TRg-6":4211,
"CC16_BC2-PAN1-NRg-1":4212,
"CC16_BC2-UTP13-TRg-2":4213,
"CC16_BC2-KAE1-NRg-3":4214,
"CC16_BC2-ERG20-TRg-1":4215,
"CC16_BC2-CDC20-TRg-6":4216,
"CC16_BC2-PWP2-NRg-2":4217,
"CC16_BC2-COG1-NRg-1":4218,
"CC16_BC2-RPL1B-TRg-4":4219,
"CC16_BC2-RPL1B-TRg-7":4220,
"CC16_BC2-UTP20-TRg-3":4221,
"CC16_BC2-UTP20-TRg-4":4222,
"CC16_BC2-RPL25-TRg-4":4223,
"CC16_BC2-RPL25-TRg-2":4224,
"CC16_BC2-MCM7-NRg-1":4225,
"CC16_BC2-MRP49-TRg-5":4226,
"CC16_BC2-ERO1-NRg-3":4227,
"CC16_BC2-UTP5-TRg-7":4228,
"CC16_BC2-MCM4-NRg-1":4229,
"CC16_BC2-PRE3-NRg-1":4230,
"CC16_BC2-FCF1-NRg-1":4231,
"CC16_BC2-CUS1-NRg-1":4232,
"CC16_BC2-PSF1-TRg-2":4233,
"CC16_BC2-BCP1-TRg-2":4234,
"CC16_BC2-PAN1-TRg-1":4235,
"CC16_BC2-PAN1-TRg-3":4236,
"CC16_BC2-PAN1-TRg-4":4237,
"CC16_BC2-VPS3-TRg-2":4238,
"CC16_BC2-YIL060W-NRg-1":4239,
"CC16_BC2-VPS53-NRg-1":4240,
"CC16_BC2-CYR1-TRg-4":4241,
"CC16_BC2-CYR1-TRg-7":4242,
"CC16_BC2-MPS1-NRg-1":4243,
"CC16_BC2-SRP1-TRg-5":4244,
"CC16_BC2-SRP1-TRg-4":4245,
"CC16_BC2-TAF12-TRg-2":4246,
"CC16_BC2-TAF12-TRg-3":4247,
"CC16_BC2-POP4-TRg-1":4248,
"CC16_BC2-SPT16-TRg-1":4249,
"CC16_BC2-NUP82-TRg-4":4250,
"CC16_BC2-DML1-TRg-3":4251,
"CC16_BC2-RPA43-NRg-3":4252,
"CC16_BC2-STU2-NRg-3":4253,
"CC16_BC2-POP4-NRg-4":4254,
"CC16_BC2-MCD1-TRg-2":4255,
"CC16_BC2-RPS3-NRg-4":4256,
"CC16_BC2-PRP9-TRg-4":4257,
"CC16_BC2-RPP1-NRg-2":4258,
"CC16_BC2-MTR2-NRg-11":4259,
"CC16_BC2-GCD11-TRg-1":4260,
"CC16_BC2-RPF1-TRg-3":4261,
"CC16_BC2-SUB2-NRg-4":4262,
"CC16_BC2-GPI15-TRg-3":4263,
"CC16_BC2-ERG9-TRg-6":4264,
"CC16_BC2-RPT2-NRg-1":4265,
"CC16_BC2-YOS1-NRg-3":4266,
"CC16_BC2-SCM3-TRg-4":4267,
"CC16_BC2-SCM3-TRg-6":4268,
"CC16_BC2-RLP7-NRg-1":4269,
"CC16_BC2-TFB2-NRg-4":4270,
"CC16_BC2-IMP4-TRg-1":4271,
"CC16_BC2-IMP4-TRg-3":4272,
"CC16_BC2-PRE4-TRg-3":4273,
"CC16_BC2-SUB2-TRg-3":4274,
"CC16_BC2-RPP0-NRg-4":4275,
"CC16_BC2-RPP0-NRg-3":4276,
"CC16_BC2-TOM40-TRg-4":4277,
"CC16_BC2-FUR1-NRg-12":4278,
"CC16_BC2-TOM40-TRg-2":4279,
"CC16_BC2-VMA11-NRg-4":4280,
"CC16_BC2-PGS1-NRg-4":4281,
"CC16_BC2-URB1-TRg-4":4282,
"CC16_BC2-ARP4-TRg-3":4283,
"CC16_BC2-RPT3-TRg-3":4284,
"CC16_BC2-SUI3-TRg-3":4285,
"CC16_BC2-RFC5-NRg-2":4286,
"CC16_BC2-RRP14-TRg-2":4287,
"CC16_BC2-SCC2-TRg-1":4288,
"CC16_BC2-SSC1-TRg-3":4289,
"CC16_BC2-RRP9-TRg-3":4290,
"CC16_BC2-MOT1-NRg-9":4291,
"CC16_BC2-RPL42A-NRg-2":4292,
"CC16_BC2-SEC16-TRg-7":4293,
"CC16_BC2-IMP4-NRg-2":4294,
"CC16_BC2-YEF3-NRg-4":4295,
"CC16_BC2-PUP1-TRg-1":4296,
"CC16_BC2-UTP22-TRg-6":4297,
"CC16_BC2-DBP2-NRg-4":4298,
"CC16_BC2-PRE2-TRg-7":4299,
"CC16_BC2-ATP16-TRg-6":4300,
"CC16_BC2-UTP13-TRg-4":4301,
"CC16_BC2-DOP1-NRg-4":4302,
"CC16_BC2-TIM44-TRg-3":4303,
"CC16_BC2-ATP16-TRg-2":4304,
"CC16_BC2-ENP1-NRg-3":4305,
"CC16_BC2-NAF1-TRg-3":4306,
"CC16_BC2-COG4-TRg-2":4307,
"CC16_BC2-SOG2-TRg-7":4308,
"CC16_BC2-YDR341C-TRg-3":4309,
"CC16_BC2-YMR290W-A-TRg-10":4310,
"CC16_BC2-NUP192-NRg-9":4311,
"CC16_BC2-RPS31-NRg-8":4312,
"CC16_BC2-SPC97-NRg-6":4313,
"CC16_BC2-EBP2-NRg-1":4314,
"CC16_BC2-CDC48-TRg-5":4315,
"CC16_BC2-RPT1-TRg-4":4316,
"CC16_BC2-ULP1-NRg-2":4317,
"CC16_BC2-RPN3-TRg-6":4318,
"CC16_BC2-RPT1-TRg-5":4319,
"CC16_BC2-KRE5-TRg-2":4320,
"CC16_BC2-TBF1-NRg-8":4321,
"CC16_BC2-UTP22-NRg-4":4322,
"CC16_BC2-SSC1-NRg-4":4323,
"CC16_BC2-REB1-TRg-4":4324,
"CC16_BC2-CDC48-NRg-9":4325,
"CC16_BC2-FAS2-TRg-8":4326,
"CC16_BC2-TAO3-TRg-8":4327,
"CC16_BC2-CKS1-TRg-5":4328,
"CC16_BC2-YLR379W-TRg-7":4329,
"CC16_BC2-TEN1-NRg-2":4330,
"CC16_BC2-RPL42A-TRg-2":4331,
"CC16_BC2-SEC27-TRg-4":4332,
"CC16_BC2-TBF1-NRg-4":4333,
"CC16_BC2-RPT1-NRg-6":4334,
"CC16_BC2-COG1-TRg-3":4335,
"CC16_BC2-SUI1-TRg-6":4336,
"CC16_BC2-TIM23-TRg-6":4337,
"CC16_BC2-CDC48-NRg-6":4338,
"CC16_BC2-EPL1-TRg-5":4339,
"CC16_BC2-RPT5-TRg-8":4340,
"CC16_BC2-ATP16-NRg-4":4341,
"CC16_BC2-RPN6-TRg-3":4342,
"CC16_BC2-ERG9-NRg-6":4343,
"CC16_BC2-SMX3-TRg-1":4344,
"CC16_BC2-NCB2-NRg-3":4345,
"CC16_BC2-SEC16-NRg-12":4346,
"CC16_BC2-RPN6-TRg-2":4347,
"CC16_BC2-REB1-NRg-4":4348,
"CC16_BC2-ATP16-TRg-9":4349,
"CC16_BC2-ERG9-NRg-7":4350,
"PRE7g7-RPL15A-NRg-4":4351,
"PRE7g7-RPL15A-NRg-5":4352,
"PRE7g7-KRE33-TRg-1":4353,
"PRE7g7-PMI40-NRg-1":4354,
"PRE7g7-NOP19-NRg-3":4355,
"PRE7g7-SRP14-NRg-4":4356,
"PRE7g7-SEC27-TRg-2":4357,
"PRE7g7-GPI14-TRg-3":4358,
"PRE7g7-PAH1-TRg-7":4359,
"PRE7g7-PAH1-TRg-6":4360,
"PRE7g7-PAH1-TRg-5":4361,
"PRE7g7-PAH1-TRg-3":4362,
"PRE7g7-COG3-TRg-1":4363,
"PRE7g7-HTS1-NRg-5":4364,
"PRE7g7-MSN5-TRg-7":4365,
"PRE7g7-ERG26-TRg-1":4366,
"PRE7g7-SMD2-TRg-5":4367,
"PRE7g7-SMD2-TRg-4":4368,
"PRE7g7-SMD2-TRg-1":4369,
"PRE7g7-PRE7-TRg-4":4370,
"PRE7g7-PRE7-TRg-7":4371,
"PRE7g7-SEC6-TRg-3":4372,
"PRE7g7-ESF2-NRg-1":4373,
"PRE7g7-ESF2-NRg-3":4374,
"PRE7g7-AFG2-TRg-2":4375,
"PRE7g7-RRP36-TRg-3":4376,
"PRE7g7-RRP36-TRg-5":4377,
"PRE7g7-GCR1-NRg-2":4378,
"PRE7g7-PRE4-NRg-4":4379,
"PRE7g7-PRE4-NRg-9":4380,
"PRE7g7-DSN1-NRg-2":4381,
"PRE7g7-GPI11-TRg-3":4382,
"PRE7g7-POP3-TRg-1":4383,
"PRE7g7-MNE1-TRg-5":4384,
"PRE7g7-RRP12-NRg-1":4385,
"PRE7g7-RSC6-TRg-2":4386,
"PRE7g7-CDC25-TRg-1":4387,
"PRE7g7-CDC25-TRg-9":4388,
"PRE7g7-YPP1-NRg-3":4389,
"PRE7g7-NFS1-NRg-9":4390,
"PRE7g7-NFS1-NRg-8":4391,
"PRE7g7-UBA2-TRg-1":4392,
"PRE7g7-ARP2-NRg-3":4393,
"PRE7g7-MAK16-TRg-1":4394,
"PRE7g7-CEP3-NRg-1":4395,
"PRE7g7-GUK1-TRg-5":4396,
"PRE7g7-GUK1-TRg-2":4397,
"PRE7g7-GPI12-NRg-6":4398,
"PRE7g7-RPS5-NRg-5":4399,
"PRE7g7-RPS5-NRg-2":4400,
"PRE7g7-RPC19-NRg-1":4401,
"PRE7g7-TIM54-TRg-1":4402,
"PRE7g7-TEN1-TRg-2":4403,
"PRE7g7-SAH1-NRg-4":4404,
"PRE7g7-SAH1-NRg-5":4405,
"PRE7g7-SAH1-NRg-3":4406,
"PRE7g7-ATP15-NRg-5":4407,
"PRE7g7-SCD5-TRg-5":4408,
"PRE7g7-ARB1-NRg-2":4409,
"PRE7g7-ARB1-NRg-4":4410,
"PRE7g7-PUP2-TRg-1":4411,
"PRE7g7-CCT8-TRg-2":4412,
"PRE7g7-MCM4-TRg-1":4413,
"PRE7g7-LSM4-TRg-1":4414,
"PRE7g7-NOP53-NRg-1":4415,
"PRE7g7-ATP3-TRg-4":4416,
"PRE7g7-AFG2-NRg-3":4417,
"PRE7g7-PRO3-NRg-3":4418,
"PRE7g7-NRD1-NRg-10":4419,
"PRE7g7-SEC61-TRg-2":4420,
"PRE7g7-RHO3-TRg-4":4421,
"PRE7g7-SNF2-TRg-6":4422,
"PRE7g7-SMD2-NRg-3":4423,
"PRE7g7-RSC4-TRg-2":4424,
"PRE7g7-RSC4-TRg-1":4425,
"PRE7g7-TIF34-TRg-2":4426,
"PRE7g7-BET1-NRg-1":4427,
"PRE7g7-CDC8-NRg-2":4428,
"PRE7g7-PRP42-TRg-2":4429,
"PRE7g7-RRB1-TRg-2":4430,
"PRE7g7-SPC24-TRg-1":4431,
"PRE7g7-ILS1-NRg-1":4432,
"PRE7g7-GFA1-TRg-2":4433,
"PRE7g7-SEC21-NRg-10":4434,
"PRE7g7-RPC10-NRg-1":4435,
"PRE7g7-RPB10-TRg-3":4436,
"PRE7g7-RPB10-TRg-2":4437,
"PRE7g7-YNL181W-TRg-1":4438,
"PRE7g7-RAD3-NRg-1":4439,
"PRE7g7-NOP10-TRg-1":4440,
"PRE7g7-BFR2-TRg-3":4441,
"PRE7g7-MCM2-TRg-6":4442,
"PRE7g7-MCM2-TRg-4":4443,
"PRE7g7-MPP10-TRg-1":4444,
"PRE7g7-RET2-TRg-4":4445,
"PRE7g7-RET2-TRg-1":4446,
"PRE7g7-RPS2-NRg-1":4447,
"PRE7g7-RPS2-NRg-2":4448,
"PRE7g7-ORC4-NRg-3":4449,
"PRE7g7-TIP20-TRg-7":4450,
"PRE7g7-SMT3-TRg-1":4451,
"PRE7g7-MSS18-NRg-6":4452,
"PRE7g7-YEF3-NRg-9":4453,
"PRE7g7-ASK1-NRg-1":4454,
"PRE7g7-SMC1-TRg-1":4455,
"PRE7g7-NIP1-NRg-1":4456,
"PRE7g7-RPP1-NRg-1":4457,
"PRE7g7-YDJ1-TRg-6":4458,
"PRE7g7-SUB2-NRg-1":4459,
"PRE7g7-TIM10-NRg-8":4460,
"PRE7g7-TIM10-NRg-4":4461,
"PRE7g7-TIM10-NRg-7":4462,
"PRE7g7-SKI6-TRg-4":4463,
"PRE7g7-TUB4-TRg-1":4464,
"PRE7g7-CDC37-NRg-2":4465,
"PRE7g7-ISD11-TRg-3":4466,
"PRE7g7-YOS1-TRg-4":4467,
"PRE7g7-SSC1-TRg-6":4468,
"PRE7g7-MTR3-TRg-5":4469,
"PRE7g7-MTR3-TRg-6":4470,
"PRE7g7-TFA1-TRg-2":4471,
"PRE7g7-CDC3-NRg-3":4472,
"PRE7g7-ERG25-TA-18":4473,
"PRE7g7-RPB11-TRg-4":4474,
"PRE7g7-RPB11-TRg-1":4475,
"PRE7g7-RPB11-TRg-2":4476,
"PRE7g7-DED1-TRg-3":4477,
"PRE7g7-DED1-TRg-1":4478,
"PRE7g7-DED1-TRg-6":4479,
"PRE7g7-DED1-TRg-4":4480,
"PRE7g7-RPL10-NRg-5":4481,
"PRE7g7-RPL10-NRg-4":4482,
"PRE7g7-EFB1-NRg-1":4483,
"PRE7g7-EFB1-NRg-5":4484,
"PRE7g7-EFB1-NRg-4":4485,
"PRE7g7-RPT3-NRg-1":4486,
"PRE7g7-SAC6-TRg-8":4487,
"PRE7g7-SAC6-TRg-4":4488,
"PRE7g7-SAC6-TRg-5":4489,
"PRE7g7-SAC6-TRg-3":4490,
"PRE7g7-DIM1-TRg-5":4491,
"PRE7g7-DIM1-TRg-7":4492,
"PRE7g7-RPC17-NRg-1":4493,
"PRE7g7-RPC17-NRg-2":4494,
"PRE7g7-YDR341C-TRg-1":4495,
"PRE7g7-RAP1-NRg-8":4496,
"PRE7g7-RAP1-NRg-5":4497,
"PRE7g7-RAP1-NRg-2":4498,
"PRE7g7-SEC26-NRg-3":4499,
"PRE7g7-SPP41-TRg-3":4500,
"PRE7g7-TAP42-NRg-1":4501,
"PRE7g7-PGA2-TRg-6":4502,
"PRE7g7-BRL1-TRg-1":4503,
"PRE7g7-FOL2-TRg-1":4504,
"PRE7g7-NAB3-NRg-5":4505,
"PRE7g7-SNF4-TRg-4":4506,
"PRE7g7-HRR25-TRg-2":4507,
"PRE7g7-TRS23-TRg-4":4508,
"PRE7g7-CTR86-TRg-4":4509,
"PRE7g7-RPB5-TRg-5":4510,
"PRE7g7-SPN1-NRg-2":4511,
"PRE7g7-SPN1-NRg-1":4512,
"PRE7g7-SEC61-NRg-1":4513,
"PRE7g7-SEC61-NRg-7":4514,
"PRE7g7-TUS1-TRg-3":4515,
"PRE7g7-OLE1-NRg-2":4516,
"PRE7g7-AFG2-TRg-1":4517,
"PRE7g7-TOA2-NRg-1":4518,
"PRE7g7-USO1-TRg-1":4519,
"PRE7g7-UTP22-NRg-2":4520,
"PRE7g7-RIB1-TRg-3":4521,
"PRE7g7-RIB1-TRg-7":4522,
"PRE7g7-RIB1-TRg-4":4523,
"PRE7g7-COG1-TRg-1":4524,
"PRE7g7-RPL32-NRg-2":4525,
"PRE7g7-GLC7-NRg-3":4526,
"PRE7g7-GLC7-NRg-4":4527,
"PRE7g7-HSF1-TRg-2":4528,
"PRE7g7-DAM1-NRg-5":4529,
"PRE7g7-SEC18-TRg-4":4530,
"PRE7g7-SEC18-TRg-5":4531,
"PRE7g7-PAB1-NRg-3":4532,
"PRE7g7-POP8-TRg-2":4533,
"PRE7g7-PAB1-NRg-4":4534,
"PRE7g7-BIG1-TRg-4":4535,
"PRE7g7-BIG1-TRg-5":4536,
"PRE7g7-BIG1-TRg-6":4537,
"PRE7g7-RPO41-NRg-1":4538,
"PRE7g7-RVB2-NRg-2":4539,
"PRE7g7-PET117-NRg-8":4540,
"PRE7g7-VPS45-NRg-9":4541,
"PRE7g7-YCG1-NRg-1":4542,
"PRE7g7-NOC4-NRg-1":4543,
"PRE7g7-NMD3-NRg-2":4544,
"PRE7g7-DRS1-TRg-2":4545,
"PRE7g7-HTB1-NRg-2":4546,
"PRE7g7-IPI1-TRg-2":4547,
"PRE7g7-SEC18-NRg-1":4548,
"PRE7g7-SEC18-NRg-2":4549,
"PRE7g7-JIP5-NRg-2":4550,
"PRE7g7-YPT1-TRg-3":4551,
"PRE7g7-YPT1-TRg-2":4552,
"PRE7g7-CLF1-NRg-2":4553,
"PRE7g7-SNF2-NRg-7":4554,
"PRE7g7-SNF2-NRg-4":4555,
"PRE7g7-RPL25-NRg-1":4556,
"PRE7g7-NOP56-TRg-1":4557,
"PRE7g7-NOP56-TRg-2":4558,
"PRE7g7-TRS31-TRg-1":4559,
"PRE7g7-DBF4-TRg-2":4560,
"PRE7g7-DBF4-TRg-1":4561,
"PRE7g7-RPC19-TRg-4":4562,
"PRE7g7-RPC19-TRg-6":4563,
"PRE7g7-RPC19-TRg-3":4564,
"PRE7g7-ROK1-NRg-1":4565,
"PRE7g7-CDC33-TRg-4":4566,
"PRE7g7-DHR2-TRg-3":4567,
"PRE7g7-RRP42-NRg-5":4568,
"PRE7g7-CLF1-TRg-1":4569,
"PRE7g7-ERG11-NA-16":4570,
"PRE7g7-VAS1-NRg-4":4571,
"PRE7g7-PIK1-NRg-2":4572,
"PRE7g7-SAR1-NRg-7":4573,
"PRE7g7-SAR1-NRg-4":4574,
"PRE7g7-RPS3-TRg-1":4575,
"PRE7g7-YTM1-TRg-2":4576,
"PRE7g7-SUI3-NRg-5":4577,
"PRE7g7-SUI3-NRg-2":4578,
"PRE7g7-RRP7-TRg-4":4579,
"PRE7g7-RRP7-TRg-6":4580,
"PRE7g7-NIP7-TRg-2":4581,
"PRE7g7-MDM35-TRg-1":4582,
"PRE7g7-ALA1-NRg-1":4583,
"PRE7g7-DOA4-NRg-2":4584,
"PRE7g7-RPS13-NRg-1":4585,
"PRE7g7-YSF3-TRg-2":4586,
"PRE7g7-RPS2-NRg-11":4587,
"PRE7g7-SSL1-TRg-10":4588,
"PRE7g7-NIP7-TRg-1":4589,
"PRE7g7-LST8-NRg-1":4590,
"PRE7g7-TAF4-TRg-3":4591,
"PRE7g7-HAS1-TRg-2":4592,
"PRE7g7-GLC7-TRg-2":4593,
"PRE7g7-CDC45-NRg-1":4594,
"PRE7g7-SEC22-NRg-8":4595,
"PRE7g7-YOS1-TRg-2":4596,
"PRE7g7-RBA50-TRg-3":4597,
"PRE7g7-SPP41-NRg-2":4598,
"PRE7g7-PRP46-TRg-2":4599,
"PRE7g7-PGA2-NRg-1":4600,
"PRE7g7-CBF5-TRg-3":4601,
"PRE7g7-TCP1-NRg-3":4602,
"PRE7g7-TCP1-NRg-2":4603,
"PRE7g7-ERG26-NRg-2":4604,
"PRE7g7-ERG26-NRg-4":4605,
"PRE7g7-MES1-TRg-5":4606,
"PRE7g7-HTS1-TRg-2":4607,
"PRE7g7-SSS1-TRg-3":4608,
"PRE7g7-SSS1-TRg-2":4609,
"PRE7g7-SYS1-TRg-7":4610,
"PRE7g7-SYS1-TRg-2":4611,
"PRE7g7-SYS1-TRg-1":4612,
"PRE7g7-BFR2-TRg-1":4613,
"PRE7g7-EOS1-TRg-3":4614,
"PRE7g7-TAF4-NRg-1":4615,
"PRE7g7-ARL3-NRg-8":4616,
"PRE7g7-RPN5-NRg-1":4617,
"PRE7g7-TIM9-NRg-2":4618,
"PRE7g7-NUP57-NRg-3":4619,
"PRE7g7-VPS4-TRg-1":4620,
"PRE7g7-CDC3-TRg-4":4621,
"PRE7g7-BBP1-NRg-1":4622,
"PRE7g7-BBP1-NRg-2":4623,
"PRE7g7-USE1-NRg-3":4624,
"PRE7g7-CCT7-TRg-1":4625,
"PRE7g7-SAH1-TRg-3":4626,
"PRE7g7-CHS2-TRg-1":4627,
"PRE7g7-DPM1-TRg-2":4628,
"PRE7g7-BBP1-TRg-1":4629,
"PRE7g7-NRD1-TRg-4":4630,
"PRE7g7-RPB3-NRg-1":4631,
"PRE7g7-PHO85-NRg-6":4632,
"PRE7g7-SNF6-TRg-6":4633,
"PRE7g7-PRP38-NRg-2":4634,
"PRE7g7-OAR1-NRg-3":4635,
"PRE7g7-ROX3-NRg-1":4636,
"PRE7g7-YPP1-TRg-6":4637,
"PRE7g7-CBF2-NRg-8":4638,
"PRE7g7-SPT6-TRg-5":4639,
"PRE7g7-SEC10-NRg-1":4640,
"PRE7g7-NSL1-NRg-3":4641,
"PRE7g7-NRD1-NRg-8":4642,
"PRE7g7-RPB3-TRg-1":4643,
"PRE7g7-NRD1-NRg-4":4644,
"PRE7g7-RVB1-TRg-2":4645,
"PRE7g7-TIF5-NRg-8":4646,
"PRE7g7-EOS1-NRg-1":4647,
"PRE7g7-ERG25-NA-26":4648,
"PRE7g7-MSL5-NRg-4":4649,
"PRE7g7-SEC24-TRg-2":4650,
"PRE7g7-RPL30-NRg-5":4651,
"PRE7g7-SNU71-NRg-3":4652,
"PRE7g7-CDC33-NRg-1":4653,
"PRE7g7-RPN6-TRg-4":4654,
"PRE7g7-NAB2-TRg-4":4655,
"PRE7g7-NAB2-TRg-6":4656,
"PRE7g7-YTM1-NRg-1":4657,
"PRE7g7-OLE1-TRg-8":4658,
"PRE7g7-OLE1-TRg-1":4659,
"PRE7g7-UTP7-TRg-4":4660,
"PRE7g7-ACT1-NRg-6":4661,
"PRE7g7-RPL18A-NRg-3":4662,
"PRE7g7-BRX1-NRg-1":4663,
"PRE7g7-NAF1-TRg-8":4664,
"PRE7g7-NAF1-TRg-6":4665,
"PRE7g7-NAF1-TRg-4":4666,
"PRE7g7-CDC8-TRg-2":4667,
"PRE7g7-NSE4-TRg-1":4668,
"PRE7g7-PAB1-NRg-2":4669,
"PRE7g7-PRP43-TRg-4":4670,
"PRE7g7-SEC2-NRg-3":4671,
"PRE7g7-SEC2-NRg-6":4672,
"PRE7g7-MPP10-NRg-5":4673,
"PRE7g7-YDR355C-TRg-2":4674,
"PRE7g7-YLR339C-TRg-9":4675,
"PRE7g7-SNM1-TRg-2":4676,
"PRE7g7-ALR1-NRg-4":4677,
"PRE7g7-ALR1-NRg-1":4678,
"PRE7g7-ALR1-NRg-3":4679,
"PRE7g7-RPL10-TRg-1":4680,
"PRE7g7-RPL28-TRg-2":4681,
"PRE7g7-UTP25-TRg-1":4682,
"PRE7g7-POB3-TRg-1":4683,
"PRE7g7-POB3-TRg-3":4684,
"PRE7g7-POB3-TRg-2":4685,
"PRE7g7-MED11-TRg-1":4686,
"PRE7g7-ISA1-TRg-15":4687,
"PRE7g7-RRP1-NRg-1":4688,
"PRE7g7-MES1-NRg-1":4689,
"PRE7g7-SEC13-NRg-5":4690,
"PRE7g7-MCM2-NRg-2":4691,
"PRE7g7-ALA1-TRg-4":4692,
"PRE7g7-MTG2-TRg-5":4693,
"PRE7g7-TIF35-NRg-3":4694,
"PRE7g7-NSE1-TRg-3":4695,
"PRE7g7-NSE1-TRg-4":4696,
"PRE7g7-MOB2-NRg-6":4697,
"PRE7g7-VRG4-NRg-3":4698,
"PRE7g7-PRP9-TRg-3":4699,
"PRE7g7-HYM1-TRg-5":4700,
"PRE7g7-POP1-TRg-5":4701,
"PRE7g7-POP1-TRg-9":4702,
"PRE7g7-RPL17A-TRg-1":4703,
"PRE7g7-SLD2-TRg-1":4704,
"PRE7g7-CDC48-NRg-7":4705,
"PRE7g7-FHL1-NRg-2":4706,
"PRE7g7-BET3-NRg-7":4707,
"PRE7g7-MAK21-TRg-1":4708,
"PRE7g7-BRN1-TRg-4":4709,
"PRE7g7-FBA1-NRg-3":4710,
"PRE7g7-CDC42-TRg-6":4711,
"PRE7g7-CDC42-TRg-7":4712,
"PRE7g7-COG4-NRg-1":4713,
"PRE7g7-ATP3-NRg-3":4714,
"PRE7g7-ATP3-NRg-2":4715,
"PRE7g7-SMP3-TRg-5":4716,
"PRE7g7-CFT2-NRg-2":4717,
"PRE7g7-FAS2-TRg-5":4718,
"PRE7g7-DBP2-NRg-3":4719,
"PRE7g7-DBP2-NRg-2":4720,
"PRE7g7-MPS2-NRg-4":4721,
"PRE7g7-ARC35-TRg-2":4722,
"PRE7g7-ARC35-TRg-5":4723,
"PRE7g7-MRD1-TRg-1":4724,
"PRE7g7-RLP7-TRg-1":4725,
"PRE7g7-SPC34-TRg-1":4726,
"PRE7g7-CDC45-TRg-2":4727,
"PRE7g7-GCD6-TRg-3":4728,
"PRE7g7-GCD6-TRg-4":4729,
"PRE7g7-YPT6-NRg-2":4730,
"PRE7g7-RPS13-TRg-2":4731,
"PRE7g7-IPI3-TRg-3":4732,
"PRE7g7-TIF5-NRg-9":4733,
"PRE7g7-TIF5-NRg-7":4734,
"PRE7g7-TIF5-NRg-6":4735,
"PRE7g7-NAB3-TRg-3":4736,
"PRE7g7-GCD2-TRg-1":4737,
"PRE7g7-UBA1-TRg-2":4738,
"PRE7g7-SLD3-TRg-6":4739,
"PRE7g7-LCB1-TRg-5":4740,
"PRE7g7-TOA2-TRg-6":4741,
"PRE7g7-TOA2-TRg-1":4742,
"PRE7g7-TOA2-TRg-3":4743,
"PRE7g7-LSM2-TRg-1":4744,
"PRE7g7-YML6-TRg-13":4745,
"PRE7g7-YML6-TRg-12":4746,
"PRE7g7-UTP15-NRg-1":4747,
"PRE7g7-TIF6-NRg-8":4748,
"PRE7g7-SUP35-NRg-1":4749,
"PRE7g7-MPP10-NRg-1":4750,
"PRE7g7-SWI3-TRg-7":4751,
"PRE7g7-SSN3-NRg-2":4752,
"PRE7g7-SEC13-NRg-7":4753,
"PRE7g7-RPS15-NRg-3":4754,
"PRE7g7-RPL3-TRg-2":4755,
"PRE7g7-FBA1-NRg-2":4756,
"PRE7g7-FBA1-NRg-1":4757,
"PRE7g7-FBA1-NRg-5":4758,
"PRE7g7-DAM1-TRg-2":4759,
"PRE7g7-NHP2-TRg-2":4760,
"PRE7g7-HCA4-NRg-6":4761,
"PRE7g7-PRE3-TRg-4":4762,
"PRE7g7-DBP5-NRg-4":4763,
"PRE7g7-SPT6-NRg-4":4764,
"PRE7g7-SPT6-NRg-2":4765,
"PRE7g7-RPL18A-TRg-4":4766,
"PRE7g7-KSH1-TRg-1":4767,
"PRE7g7-KSH1-TRg-3":4768,
"PRE7g7-IPI3-NRg-1":4769,
"PRE7g7-PGA2-TRg-8":4770,
"PRE7g7-RPL18A-TRg-2":4771,
"PRE7g7-RPL33A-NRg-6":4772,
"PRE7g7-TAF12-NRg-2":4773,
"PRE7g7-USE1-TRg-5":4774,
"PRE7g7-YNL114C-TRg-1":4775,
"PRE7g7-SMC5-TRg-7":4776,
"PRE7g7-SMC5-TRg-6":4777,
"PRE7g7-RSC58-TRg-1":4778,
"PRE7g7-CTF13-TRg-2":4779,
"PRE7g7-NAB2-NRg-2":4780,
"PRE7g7-MCM7-TRg-4":4781,
"PRE7g7-BCP1-NRg-5":4782,
"PRE7g7-STU2-TRg-3":4783,
"PRE7g7-SEC21-NRg-6":4784,
"PRE7g7-SEC21-NRg-3":4785,
"PRE7g7-RPL1B-TRg-3":4786,
"PRE7g7-SEC20-NRg-2":4787,
"PRE7g7-VMA3-NRg-2":4788,
"PRE7g7-SEC23-NRg-5":4789,
"PRE7g7-CDC28-TRg-4":4790,
"PRE7g7-RPN12-NRg-11":4791,
"PRE7g7-PUP3-TRg-3":4792,
"PRE7g7-SEC31-TRg-2":4793,
"PRE7g7-SED5-TRg-6":4794,
"PRE7g7-SED5-TRg-5":4795,
"PRE7g7-RPL33A-TRg-1":4796,
"PRE7g7-RPL33A-TRg-2":4797,
"PRE7g7-MRPL11-TRg-2":4798,
"PRE7g7-RTP1-NRg-2":4799,
"PRE7g7-NUG1-TRg-2":4800,
"PRE7g7-VPH2-TRg-4":4801,
"PRE7g7-COP1-NRg-3":4802,
"PRE7g7-CRM1-NRg-1":4803,
"PRE7g7-RPL5-NRg-4":4804,
"PRE7g7-SNU13-NRg-4":4805,
"PRE7g7-PFS2-TRg-3":4806,
"PRE7g7-MPP10-TRg-2":4807,
"PRE7g7-TSR4-NRg-2":4808,
"PRE7g7-RSC2-TRg-1":4809,
"PRE7g7-SEC65-TRg-2":4810,
"PRE7g7-SMI1-NRg-1":4811,
"PRE7g7-RTT105-NRg-4":4812,
"PRE7g7-VMA5-TRg-3":4813,
"PRE7g7-VMA5-TRg-5":4814,
"PRE7g7-RRP1-TRg-3":4815,
"PRE7g7-CLC1-TRg-2":4816,
"PRE7g7-GCD6-NRg-1":4817,
"PRE7g7-GCD6-NRg-2":4818,
"PRE7g7-PXR1-TRg-1":4819,
"PRE7g7-CDC14-NRg-1":4820,
"PRE7g7-PCF11-TRg-6":4821,
"PRE7g7-PCF11-TRg-5":4822,
"PRE7g7-PCF11-TRg-4":4823,
"PRE7g7-SEC31-NRg-1":4824,
"PRE7g7-RRP5-NRg-1":4825,
"PRE7g7-PRE10-TRg-5":4826,
"PRE7g7-PRE10-TRg-1":4827,
"PRE7g7-RPS5-TRg-2":4828,
"PRE7g7-NSP1-TRg-4":4829,
"PRE7g7-PRP38-TRg-4":4830,
"PRE7g7-RCF1-NRg-5":4831,
"PRE7g7-RSC3-TRg-4":4832,
"PRE7g7-RSC3-TRg-5":4833,
"PRE7g7-RSC3-TRg-6":4834,
"PRE7g7-HTA1-NRg-12":4835,
"PRE7g7-HTA1-NRg-11":4836,
"PRE7g7-UTP23-TRg-2":4837,
"PRE7g7-GCD7-NRg-1":4838,
"PRE7g7-GCD7-NRg-2":4839,
"PRE7g7-GCD7-NRg-6":4840,
"PRE7g7-GAL11-NRg-2":4841,
"PRE7g7-GAL11-NRg-9":4842,
"PRE7g7-PHO4-TRg-5":4843,
"PRE7g7-SNP1-NRg-3":4844,
"PRE7g7-RPC37-TRg-5":4845,
"PRE7g7-CRM1-TRg-5":4846,
"PRE7g7-CRM1-TRg-2":4847,
"PRE7g7-ASK1-TRg-7":4848,
"PRE7g7-STU2-NRg-4":4849,
"PRE7g7-NEO1-NRg-3":4850,
"PRE7g7-GAL11-TRg-5":4851,
"PRE7g7-GAL11-TRg-7":4852,
"PRE7g7-SAM50-NRg-3":4853,
"PRE7g7-CSL4-TRg-2":4854,
"PRE7g7-CCT5-TRg-2":4855,
"PRE7g7-POL30-NRg-1":4856,
"PRE7g7-MED4-TRg-4":4857,
"PRE7g7-MED4-TRg-3":4858,
"PRE7g7-MED4-TRg-2":4859,
"PRE7g7-GDI1-TRg-4":4860,
"PRE7g7-GDI1-TRg-3":4861,
"PRE7g7-REB1-TRg-6":4862,
"PRE7g7-MRPL37-NRg-2":4863,
"PRE7g7-NOC3-TRg-3":4864,
"PRE7g7-SPC97-TRg-3":4865,
"PRE7g7-IPP1-TRg-3":4866,
"PRE7g7-IPP1-TRg-2":4867,
"PRE7g7-PTI1-TRg-3":4868,
"PRE7g7-PTI1-TRg-5":4869,
"PRE7g7-RFC5-NRg-1":4870,
"PRE7g7-CDC24-TRg-1":4871,
"PRE7g7-CDC24-TRg-3":4872,
"PRE7g7-CDC24-TRg-5":4873,
"PRE7g7-CDC24-TRg-6":4874,
"PRE7g7-UTP23-TRg-6":4875,
"PRE7g7-UTP23-TRg-4":4876,
"PRE7g7-UTP23-TRg-1":4877,
"PRE7g7-RHO3-NRg-4":4878,
"PRE7g7-TRS23-NRg-1":4879,
"PRE7g7-TRS23-NRg-3":4880,
"PRE7g7-RSP5-TRg-2":4881,
"PRE7g7-RSP5-TRg-1":4882,
"PRE7g7-SDA1-NRg-1":4883,
"PRE7g7-KAP95-TRg-8":4884,
"PRE7g7-ACO1-TRg-6":4885,
"PRE7g7-HTA1-NRg-3":4886,
"PRE7g7-HTA1-NRg-2":4887,
"PRE7g7-SPN1-TRg-1":4888,
"PRE7g7-MOT1-NRg-7":4889,
"PRE7g7-RPL17A-NRg-4":4890,
"PRE7g7-ADA2-TRg-4":4891,
"PRE7g7-SFH1-NRg-1":4892,
"PRE7g7-SPC97-NRg-5":4893,
"PRE7g7-PRP22-TRg-3":4894,
"PRE7g7-SEN15-TRg-2":4895,
"PRE7g7-RPL3-NRg-2":4896,
"PRE7g7-ISD11-NRg-2":4897,
"PRE7g7-HEM12-TRg-8":4898,
"PRE7g7-SEC10-TRg-1":4899,
"PRE7g7-HTB1-TRg-7":4900,
"PRE7g7-TTI2-TRg-1":4901,
"PRE7g7-ACP1-TRg-2":4902,
"PRE7g7-ACP1-TRg-4":4903,
"PRE7g7-GAL11-NRg-10":4904,
"PRE7g7-UTP22-TRg-2":4905,
"PRE7g7-MST1-NRg-5":4906,
"PRE7g7-RIB7-NRg-2":4907,
"PRE7g7-MCD1-TRg-6":4908,
"PRE7g7-MCD1-TRg-5":4909,
"PRE7g7-GPI8-NRg-2":4910,
"PRE7g7-THS1-TRg-2":4911,
"PRE7g7-RRP7-TRg-2":4912,
"PRE7g7-RRP7-TRg-5":4913,
"PRE7g7-SMX2-NRg-7":4914,
"PRE7g7-RRP45-TRg-5":4915,
"PRE7g7-RRP45-TRg-4":4916,
"PRE7g7-CNS1-TRg-2":4917,
"PRE7g7-FBP1-NRg-9":4918,
"PRE7g7-GCD11-NRg-1":4919,
"PRE7g7-RPL10-TRg-2":4920,
"PRE7g7-NUP192-TRg-4":4921,
"PRE7g7-NUP145-NRg-4":4922,
"PRE7g7-HEM12-TRg-6":4923,
"PRE7g7-PLC1-TRg-3":4924,
"PRE7g7-RPA43-TRg-1":4925,
"PRE7g7-RPB7-NRg-2":4926,
"PRE7g7-RPB7-NRg-3":4927,
"PRE7g7-NSL1-NRg-1":4928,
"PRE7g7-UTP6-TRg-3":4929,
"PRE7g7-UTP6-TRg-1":4930,
"PRE7g7-YJU2-TRg-5":4931,
"PRE7g7-FRS2-NRg-5":4932,
"PRE7g7-TIF35-NRg-2":4933,
"PRE7g7-GPI15-TRg-1":4934,
"PRE7g7-NOP1-NRg-5":4935,
"PRE7g7-GPI15-TRg-4":4936,
"PRE7g7-COG4-TRg-1":4937,
"PRE7g7-TFA1-TRg-1":4938,
"PRE7g7-RHO1-NRg-2":4939,
"PRE7g7-RHO1-NRg-1":4940,
"PRE7g7-CDC55-NRg-2":4941,
"PRE7g7-IDI1-NRg-7":4942,
"PRE7g7-RPL32-TRg-5":4943,
"PRE7g7-RPB5-TRg-4":4944,
"PRE7g7-DIP2-TRg-5":4945,
"PRE7g7-DIP2-TRg-1":4946,
"PRE7g7-RPC40-TRg-2":4947,
"PRE7g7-CDC6-TRg-5":4948,
"PRE7g7-CDC6-TRg-3":4949,
"PRE7g7-DAD2-TRg-2":4950,
"PRE7g7-RVS161-TRg-2":4951,
"PRE7g7-RVS161-TRg-1":4952,
"PRE7g7-SUP45-NRg-3":4953,
"PRE7g7-SRB6-NRg-5":4954,
"PRE7g7-RPC11-TRg-4":4955,
"PRE7g7-RKI1-TRg-8":4956,
"PRE7g7-NIP7-TRg-3":4957,
"PRE7g7-RPL33A-NRg-12":4958,
"PRE7g7-SAM50-TRg-4":4959,
"PRE7g7-NOP4-NRg-1":4960,
"PRE7g7-NOP4-NRg-3":4961,
"PRE7g7-SMX2-TRg-5":4962,
"PRE7g7-POL12-NRg-2":4963,
"PRE7g7-BMS1-NRg-2":4964,
"PRE7g7-RPA190-TRg-5":4965,
"PRE7g7-ALG14-NRg-4":4966,
"PRE7g7-ALG14-NRg-1":4967,
"PRE7g7-PRE5-NRg-1":4968,
"PRE7g7-BIG1-NRg-2":4969,
"PRE7g7-TFA2-TRg-4":4970,
"PRE7g7-IMP4-TRg-6":4971,
"PRE7g7-PAN1-NRg-1":4972,
"PRE7g7-UTP13-TRg-2":4973,
"PRE7g7-KAE1-NRg-3":4974,
"PRE7g7-ERG20-TRg-1":4975,
"PRE7g7-CDC20-TRg-6":4976,
"PRE7g7-PWP2-NRg-2":4977,
"PRE7g7-COG1-NRg-1":4978,
"PRE7g7-RPL1B-TRg-4":4979,
"PRE7g7-RPL1B-TRg-7":4980,
"PRE7g7-UTP20-TRg-3":4981,
"PRE7g7-UTP20-TRg-4":4982,
"PRE7g7-RPL25-TRg-4":4983,
"PRE7g7-RPL25-TRg-2":4984,
"PRE7g7-MCM7-NRg-1":4985,
"PRE7g7-MRP49-TRg-5":4986,
"PRE7g7-ERO1-NRg-3":4987,
"PRE7g7-UTP5-TRg-7":4988,
"PRE7g7-MCM4-NRg-1":4989,
"PRE7g7-PRE3-NRg-1":4990,
"PRE7g7-FCF1-NRg-1":4991,
"PRE7g7-CUS1-NRg-1":4992,
"PRE7g7-PSF1-TRg-2":4993,
"PRE7g7-BCP1-TRg-2":4994,
"PRE7g7-PAN1-TRg-1":4995,
"PRE7g7-PAN1-TRg-3":4996,
"PRE7g7-PAN1-TRg-4":4997,
"PRE7g7-VPS3-TRg-2":4998,
"PRE7g7-YIL060W-NRg-1":4999,
"PRE7g7-VPS53-NRg-1":5000,
"PRE7g7-CYR1-TRg-4":5001,
"PRE7g7-CYR1-TRg-7":5002,
"PRE7g7-MPS1-NRg-1":5003,
"PRE7g7-SRP1-TRg-5":5004,
"PRE7g7-SRP1-TRg-4":5005,
"PRE7g7-TAF12-TRg-2":5006,
"PRE7g7-TAF12-TRg-3":5007,
"PRE7g7-POP4-TRg-1":5008,
"PRE7g7-SPT16-TRg-1":5009,
"PRE7g7-NUP82-TRg-4":5010,
"PRE7g7-DML1-TRg-3":5011,
"PRE7g7-RPA43-NRg-3":5012,
"PRE7g7-STU2-NRg-3":5013,
"PRE7g7-POP4-NRg-4":5014,
"PRE7g7-MCD1-TRg-2":5015,
"PRE7g7-RPS3-NRg-4":5016,
"PRE7g7-PRP9-TRg-4":5017,
"PRE7g7-RPP1-NRg-2":5018,
"PRE7g7-MTR2-NRg-11":5019,
"PRE7g7-GCD11-TRg-1":5020,
"PRE7g7-RPF1-TRg-3":5021,
"PRE7g7-SUB2-NRg-4":5022,
"PRE7g7-GPI15-TRg-3":5023,
"PRE7g7-ERG9-TRg-6":5024,
"PRE7g7-RPT2-NRg-1":5025,
"PRE7g7-YOS1-NRg-3":5026,
"PRE7g7-SCM3-TRg-4":5027,
"PRE7g7-SCM3-TRg-6":5028,
"PRE7g7-RLP7-NRg-1":5029,
"PRE7g7-TFB2-NRg-4":5030,
"PRE7g7-IMP4-TRg-1":5031,
"PRE7g7-IMP4-TRg-3":5032,
"PRE7g7-PRE4-TRg-3":5033,
"PRE7g7-SUB2-TRg-3":5034,
"PRE7g7-RPP0-NRg-4":5035,
"PRE7g7-RPP0-NRg-3":5036,
"PRE7g7-TOM40-TRg-4":5037,
"PRE7g7-FUR1-NRg-12":5038,
"PRE7g7-TOM40-TRg-2":5039,
"PRE7g7-VMA11-NRg-4":5040,
"PRE7g7-PGS1-NRg-4":5041,
"PRE7g7-URB1-TRg-4":5042,
"PRE7g7-ARP4-TRg-3":5043,
"PRE7g7-RPT3-TRg-3":5044,
"PRE7g7-SUI3-TRg-3":5045,
"PRE7g7-RFC5-NRg-2":5046,
"PRE7g7-RRP14-TRg-2":5047,
"PRE7g7-SCC2-TRg-1":5048,
"PRE7g7-SSC1-TRg-3":5049,
"PRE7g7-RRP9-TRg-3":5050,
"PRE7g7-MOT1-NRg-9":5051,
"PRE7g7-RPL42A-NRg-2":5052,
"PRE7g7-SEC16-TRg-7":5053,
"PRE7g7-IMP4-NRg-2":5054,
"PRE7g7-YEF3-NRg-4":5055,
"PRE7g7-PUP1-TRg-1":5056,
"PRE7g7-UTP22-TRg-6":5057,
"PRE7g7-DBP2-NRg-4":5058,
"PRE7g7-PRE2-TRg-7":5059,
"PRE7g7-ATP16-TRg-6":5060,
"PRE7g7-UTP13-TRg-4":5061,
"PRE7g7-DOP1-NRg-4":5062,
"PRE7g7-TIM44-TRg-3":5063,
"PRE7g7-ATP16-TRg-2":5064,
"PRE7g7-ENP1-NRg-3":5065,
"PRE7g7-NAF1-TRg-3":5066,
"PRE7g7-COG4-TRg-2":5067,
"PRE7g7-SOG2-TRg-7":5068,
"PRE7g7-YDR341C-TRg-3":5069,
"PRE7g7-YMR290W-A-TRg-10":5070,
"PRE7g7-NUP192-NRg-9":5071,
"PRE7g7-RPS31-NRg-8":5072,
"PRE7g7-SPC97-NRg-6":5073,
"PRE7g7-EBP2-NRg-1":5074,
"PRE7g7-CDC48-TRg-5":5075,
"PRE7g7-RPT1-TRg-4":5076,
"PRE7g7-ULP1-NRg-2":5077,
"PRE7g7-RPN3-TRg-6":5078,
"PRE7g7-RPT1-TRg-5":5079,
"PRE7g7-KRE5-TRg-2":5080,
"PRE7g7-TBF1-NRg-8":5081,
"PRE7g7-UTP22-NRg-4":5082,
"PRE7g7-SSC1-NRg-4":5083,
"PRE7g7-REB1-TRg-4":5084,
"PRE7g7-CDC48-NRg-9":5085,
"PRE7g7-FAS2-TRg-8":5086,
"PRE7g7-TAO3-TRg-8":5087,
"PRE7g7-CKS1-TRg-5":5088,
"PRE7g7-YLR379W-TRg-7":5089,
"PRE7g7-TEN1-NRg-2":5090,
"PRE7g7-RPL42A-TRg-2":5091,
"PRE7g7-SEC27-TRg-4":5092,
"PRE7g7-TBF1-NRg-4":5093,
"PRE7g7-RPT1-NRg-6":5094,
"PRE7g7-COG1-TRg-3":5095,
"PRE7g7-SUI1-TRg-6":5096,
"PRE7g7-TIM23-TRg-6":5097,
"PRE7g7-CDC48-NRg-6":5098,
"PRE7g7-EPL1-TRg-5":5099,
"PRE7g7-RPT5-TRg-8":5100,
"PRE7g7-ATP16-NRg-4":5101,
"PRE7g7-RPN6-TRg-3":5102,
"PRE7g7-ERG9-NRg-6":5103,
"PRE7g7-SMX3-TRg-1":5104,
"PRE7g7-NCB2-NRg-3":5105,
"PRE7g7-SEC16-NRg-12":5106,
"PRE7g7-RPN6-TRg-2":5107,
"PRE7g7-REB1-NRg-4":5108,
"PRE7g7-ATP16-TRg-9":5109,
"PRE7g7-ERG9-NRg-7":5110,
"PRE4g9-RPL15A-NRg-4":5111,
"PRE4g9-RPL15A-NRg-5":5112,
"PRE4g9-KRE33-TRg-1":5113,
"PRE4g9-PMI40-NRg-1":5114,
"PRE4g9-NOP19-NRg-3":5115,
"PRE4g9-SRP14-NRg-4":5116,
"PRE4g9-SEC27-TRg-2":5117,
"PRE4g9-GPI14-TRg-3":5118,
"PRE4g9-PAH1-TRg-7":5119,
"PRE4g9-PAH1-TRg-6":5120,
"PRE4g9-PAH1-TRg-5":5121,
"PRE4g9-PAH1-TRg-3":5122,
"PRE4g9-COG3-TRg-1":5123,
"PRE4g9-HTS1-NRg-5":5124,
"PRE4g9-MSN5-TRg-7":5125,
"PRE4g9-ERG26-TRg-1":5126,
"PRE4g9-SMD2-TRg-5":5127,
"PRE4g9-SMD2-TRg-4":5128,
"PRE4g9-SMD2-TRg-1":5129,
"PRE4g9-PRE7-TRg-4":5130,
"PRE4g9-PRE7-TRg-7":5131,
"PRE4g9-SEC6-TRg-3":5132,
"PRE4g9-ESF2-NRg-1":5133,
"PRE4g9-ESF2-NRg-3":5134,
"PRE4g9-AFG2-TRg-2":5135,
"PRE4g9-RRP36-TRg-3":5136,
"PRE4g9-RRP36-TRg-5":5137,
"PRE4g9-GCR1-NRg-2":5138,
"PRE4g9-PRE4-NRg-4":5139,
"PRE4g9-PRE4-NRg-9":5140,
"PRE4g9-DSN1-NRg-2":5141,
"PRE4g9-GPI11-TRg-3":5142,
"PRE4g9-POP3-TRg-1":5143,
"PRE4g9-MNE1-TRg-5":5144,
"PRE4g9-RRP12-NRg-1":5145,
"PRE4g9-RSC6-TRg-2":5146,
"PRE4g9-CDC25-TRg-1":5147,
"PRE4g9-CDC25-TRg-9":5148,
"PRE4g9-YPP1-NRg-3":5149,
"PRE4g9-NFS1-NRg-9":5150,
"PRE4g9-NFS1-NRg-8":5151,
"PRE4g9-UBA2-TRg-1":5152,
"PRE4g9-ARP2-NRg-3":5153,
"PRE4g9-MAK16-TRg-1":5154,
"PRE4g9-CEP3-NRg-1":5155,
"PRE4g9-GUK1-TRg-5":5156,
"PRE4g9-GUK1-TRg-2":5157,
"PRE4g9-GPI12-NRg-6":5158,
"PRE4g9-RPS5-NRg-5":5159,
"PRE4g9-RPS5-NRg-2":5160,
"PRE4g9-RPC19-NRg-1":5161,
"PRE4g9-TIM54-TRg-1":5162,
"PRE4g9-TEN1-TRg-2":5163,
"PRE4g9-SAH1-NRg-4":5164,
"PRE4g9-SAH1-NRg-5":5165,
"PRE4g9-SAH1-NRg-3":5166,
"PRE4g9-ATP15-NRg-5":5167,
"PRE4g9-SCD5-TRg-5":5168,
"PRE4g9-ARB1-NRg-2":5169,
"PRE4g9-ARB1-NRg-4":5170,
"PRE4g9-PUP2-TRg-1":5171,
"PRE4g9-CCT8-TRg-2":5172,
"PRE4g9-MCM4-TRg-1":5173,
"PRE4g9-LSM4-TRg-1":5174,
"PRE4g9-NOP53-NRg-1":5175,
"PRE4g9-ATP3-TRg-4":5176,
"PRE4g9-AFG2-NRg-3":5177,
"PRE4g9-PRO3-NRg-3":5178,
"PRE4g9-NRD1-NRg-10":5179,
"PRE4g9-SEC61-TRg-2":5180,
"PRE4g9-RHO3-TRg-4":5181,
"PRE4g9-SNF2-TRg-6":5182,
"PRE4g9-SMD2-NRg-3":5183,
"PRE4g9-RSC4-TRg-2":5184,
"PRE4g9-RSC4-TRg-1":5185,
"PRE4g9-TIF34-TRg-2":5186,
"PRE4g9-BET1-NRg-1":5187,
"PRE4g9-CDC8-NRg-2":5188,
"PRE4g9-PRP42-TRg-2":5189,
"PRE4g9-RRB1-TRg-2":5190,
"PRE4g9-SPC24-TRg-1":5191,
"PRE4g9-ILS1-NRg-1":5192,
"PRE4g9-GFA1-TRg-2":5193,
"PRE4g9-SEC21-NRg-10":5194,
"PRE4g9-RPC10-NRg-1":5195,
"PRE4g9-RPB10-TRg-3":5196,
"PRE4g9-RPB10-TRg-2":5197,
"PRE4g9-YNL181W-TRg-1":5198,
"PRE4g9-RAD3-NRg-1":5199,
"PRE4g9-NOP10-TRg-1":5200,
"PRE4g9-BFR2-TRg-3":5201,
"PRE4g9-MCM2-TRg-6":5202,
"PRE4g9-MCM2-TRg-4":5203,
"PRE4g9-MPP10-TRg-1":5204,
"PRE4g9-RET2-TRg-4":5205,
"PRE4g9-RET2-TRg-1":5206,
"PRE4g9-RPS2-NRg-1":5207,
"PRE4g9-RPS2-NRg-2":5208,
"PRE4g9-ORC4-NRg-3":5209,
"PRE4g9-TIP20-TRg-7":5210,
"PRE4g9-SMT3-TRg-1":5211,
"PRE4g9-MSS18-NRg-6":5212,
"PRE4g9-YEF3-NRg-9":5213,
"PRE4g9-ASK1-NRg-1":5214,
"PRE4g9-SMC1-TRg-1":5215,
"PRE4g9-NIP1-NRg-1":5216,
"PRE4g9-RPP1-NRg-1":5217,
"PRE4g9-YDJ1-TRg-6":5218,
"PRE4g9-SUB2-NRg-1":5219,
"PRE4g9-TIM10-NRg-8":5220,
"PRE4g9-TIM10-NRg-4":5221,
"PRE4g9-TIM10-NRg-7":5222,
"PRE4g9-SKI6-TRg-4":5223,
"PRE4g9-TUB4-TRg-1":5224,
"PRE4g9-CDC37-NRg-2":5225,
"PRE4g9-ISD11-TRg-3":5226,
"PRE4g9-YOS1-TRg-4":5227,
"PRE4g9-SSC1-TRg-6":5228,
"PRE4g9-MTR3-TRg-5":5229,
"PRE4g9-MTR3-TRg-6":5230,
"PRE4g9-TFA1-TRg-2":5231,
"PRE4g9-CDC3-NRg-3":5232,
"PRE4g9-ERG25-TA-18":5233,
"PRE4g9-RPB11-TRg-4":5234,
"PRE4g9-RPB11-TRg-1":5235,
"PRE4g9-RPB11-TRg-2":5236,
"PRE4g9-DED1-TRg-3":5237,
"PRE4g9-DED1-TRg-1":5238,
"PRE4g9-DED1-TRg-6":5239,
"PRE4g9-DED1-TRg-4":5240,
"PRE4g9-RPL10-NRg-5":5241,
"PRE4g9-RPL10-NRg-4":5242,
"PRE4g9-EFB1-NRg-1":5243,
"PRE4g9-EFB1-NRg-5":5244,
"PRE4g9-EFB1-NRg-4":5245,
"PRE4g9-RPT3-NRg-1":5246,
"PRE4g9-SAC6-TRg-8":5247,
"PRE4g9-SAC6-TRg-4":5248,
"PRE4g9-SAC6-TRg-5":5249,
"PRE4g9-SAC6-TRg-3":5250,
"PRE4g9-DIM1-TRg-5":5251,
"PRE4g9-DIM1-TRg-7":5252,
"PRE4g9-RPC17-NRg-1":5253,
"PRE4g9-RPC17-NRg-2":5254,
"PRE4g9-YDR341C-TRg-1":5255,
"PRE4g9-RAP1-NRg-8":5256,
"PRE4g9-RAP1-NRg-5":5257,
"PRE4g9-RAP1-NRg-2":5258,
"PRE4g9-SEC26-NRg-3":5259,
"PRE4g9-SPP41-TRg-3":5260,
"PRE4g9-TAP42-NRg-1":5261,
"PRE4g9-PGA2-TRg-6":5262,
"PRE4g9-BRL1-TRg-1":5263,
"PRE4g9-FOL2-TRg-1":5264,
"PRE4g9-NAB3-NRg-5":5265,
"PRE4g9-SNF4-TRg-4":5266,
"PRE4g9-HRR25-TRg-2":5267,
"PRE4g9-TRS23-TRg-4":5268,
"PRE4g9-CTR86-TRg-4":5269,
"PRE4g9-RPB5-TRg-5":5270,
"PRE4g9-SPN1-NRg-2":5271,
"PRE4g9-SPN1-NRg-1":5272,
"PRE4g9-SEC61-NRg-1":5273,
"PRE4g9-SEC61-NRg-7":5274,
"PRE4g9-TUS1-TRg-3":5275,
"PRE4g9-OLE1-NRg-2":5276,
"PRE4g9-AFG2-TRg-1":5277,
"PRE4g9-TOA2-NRg-1":5278,
"PRE4g9-USO1-TRg-1":5279,
"PRE4g9-UTP22-NRg-2":5280,
"PRE4g9-RIB1-TRg-3":5281,
"PRE4g9-RIB1-TRg-7":5282,
"PRE4g9-RIB1-TRg-4":5283,
"PRE4g9-COG1-TRg-1":5284,
"PRE4g9-RPL32-NRg-2":5285,
"PRE4g9-GLC7-NRg-3":5286,
"PRE4g9-GLC7-NRg-4":5287,
"PRE4g9-HSF1-TRg-2":5288,
"PRE4g9-DAM1-NRg-5":5289,
"PRE4g9-SEC18-TRg-4":5290,
"PRE4g9-SEC18-TRg-5":5291,
"PRE4g9-PAB1-NRg-3":5292,
"PRE4g9-POP8-TRg-2":5293,
"PRE4g9-PAB1-NRg-4":5294,
"PRE4g9-BIG1-TRg-4":5295,
"PRE4g9-BIG1-TRg-5":5296,
"PRE4g9-BIG1-TRg-6":5297,
"PRE4g9-RPO41-NRg-1":5298,
"PRE4g9-RVB2-NRg-2":5299,
"PRE4g9-PET117-NRg-8":5300,
"PRE4g9-VPS45-NRg-9":5301,
"PRE4g9-YCG1-NRg-1":5302,
"PRE4g9-NOC4-NRg-1":5303,
"PRE4g9-NMD3-NRg-2":5304,
"PRE4g9-DRS1-TRg-2":5305,
"PRE4g9-HTB1-NRg-2":5306,
"PRE4g9-IPI1-TRg-2":5307,
"PRE4g9-SEC18-NRg-1":5308,
"PRE4g9-SEC18-NRg-2":5309,
"PRE4g9-JIP5-NRg-2":5310,
"PRE4g9-YPT1-TRg-3":5311,
"PRE4g9-YPT1-TRg-2":5312,
"PRE4g9-CLF1-NRg-2":5313,
"PRE4g9-SNF2-NRg-7":5314,
"PRE4g9-SNF2-NRg-4":5315,
"PRE4g9-RPL25-NRg-1":5316,
"PRE4g9-NOP56-TRg-1":5317,
"PRE4g9-NOP56-TRg-2":5318,
"PRE4g9-TRS31-TRg-1":5319,
"PRE4g9-DBF4-TRg-2":5320,
"PRE4g9-DBF4-TRg-1":5321,
"PRE4g9-RPC19-TRg-4":5322,
"PRE4g9-RPC19-TRg-6":5323,
"PRE4g9-RPC19-TRg-3":5324,
"PRE4g9-ROK1-NRg-1":5325,
"PRE4g9-CDC33-TRg-4":5326,
"PRE4g9-DHR2-TRg-3":5327,
"PRE4g9-RRP42-NRg-5":5328,
"PRE4g9-CLF1-TRg-1":5329,
"PRE4g9-ERG11-NA-16":5330,
"PRE4g9-VAS1-NRg-4":5331,
"PRE4g9-PIK1-NRg-2":5332,
"PRE4g9-SAR1-NRg-7":5333,
"PRE4g9-SAR1-NRg-4":5334,
"PRE4g9-RPS3-TRg-1":5335,
"PRE4g9-YTM1-TRg-2":5336,
"PRE4g9-SUI3-NRg-5":5337,
"PRE4g9-SUI3-NRg-2":5338,
"PRE4g9-RRP7-TRg-4":5339,
"PRE4g9-RRP7-TRg-6":5340,
"PRE4g9-NIP7-TRg-2":5341,
"PRE4g9-MDM35-TRg-1":5342,
"PRE4g9-ALA1-NRg-1":5343,
"PRE4g9-DOA4-NRg-2":5344,
"PRE4g9-RPS13-NRg-1":5345,
"PRE4g9-YSF3-TRg-2":5346,
"PRE4g9-RPS2-NRg-11":5347,
"PRE4g9-SSL1-TRg-10":5348,
"PRE4g9-NIP7-TRg-1":5349,
"PRE4g9-LST8-NRg-1":5350,
"PRE4g9-TAF4-TRg-3":5351,
"PRE4g9-HAS1-TRg-2":5352,
"PRE4g9-GLC7-TRg-2":5353,
"PRE4g9-CDC45-NRg-1":5354,
"PRE4g9-SEC22-NRg-8":5355,
"PRE4g9-YOS1-TRg-2":5356,
"PRE4g9-RBA50-TRg-3":5357,
"PRE4g9-SPP41-NRg-2":5358,
"PRE4g9-PRP46-TRg-2":5359,
"PRE4g9-PGA2-NRg-1":5360,
"PRE4g9-CBF5-TRg-3":5361,
"PRE4g9-TCP1-NRg-3":5362,
"PRE4g9-TCP1-NRg-2":5363,
"PRE4g9-ERG26-NRg-2":5364,
"PRE4g9-ERG26-NRg-4":5365,
"PRE4g9-MES1-TRg-5":5366,
"PRE4g9-HTS1-TRg-2":5367,
"PRE4g9-SSS1-TRg-3":5368,
"PRE4g9-SSS1-TRg-2":5369,
"PRE4g9-SYS1-TRg-7":5370,
"PRE4g9-SYS1-TRg-2":5371,
"PRE4g9-SYS1-TRg-1":5372,
"PRE4g9-BFR2-TRg-1":5373,
"PRE4g9-EOS1-TRg-3":5374,
"PRE4g9-TAF4-NRg-1":5375,
"PRE4g9-ARL3-NRg-8":5376,
"PRE4g9-RPN5-NRg-1":5377,
"PRE4g9-TIM9-NRg-2":5378,
"PRE4g9-NUP57-NRg-3":5379,
"PRE4g9-VPS4-TRg-1":5380,
"PRE4g9-CDC3-TRg-4":5381,
"PRE4g9-BBP1-NRg-1":5382,
"PRE4g9-BBP1-NRg-2":5383,
"PRE4g9-USE1-NRg-3":5384,
"PRE4g9-CCT7-TRg-1":5385,
"PRE4g9-SAH1-TRg-3":5386,
"PRE4g9-CHS2-TRg-1":5387,
"PRE4g9-DPM1-TRg-2":5388,
"PRE4g9-BBP1-TRg-1":5389,
"PRE4g9-NRD1-TRg-4":5390,
"PRE4g9-RPB3-NRg-1":5391,
"PRE4g9-PHO85-NRg-6":5392,
"PRE4g9-SNF6-TRg-6":5393,
"PRE4g9-PRP38-NRg-2":5394,
"PRE4g9-OAR1-NRg-3":5395,
"PRE4g9-ROX3-NRg-1":5396,
"PRE4g9-YPP1-TRg-6":5397,
"PRE4g9-CBF2-NRg-8":5398,
"PRE4g9-SPT6-TRg-5":5399,
"PRE4g9-SEC10-NRg-1":5400,
"PRE4g9-NSL1-NRg-3":5401,
"PRE4g9-NRD1-NRg-8":5402,
"PRE4g9-RPB3-TRg-1":5403,
"PRE4g9-NRD1-NRg-4":5404,
"PRE4g9-RVB1-TRg-2":5405,
"PRE4g9-TIF5-NRg-8":5406,
"PRE4g9-EOS1-NRg-1":5407,
"PRE4g9-ERG25-NA-26":5408,
"PRE4g9-MSL5-NRg-4":5409,
"PRE4g9-SEC24-TRg-2":5410,
"PRE4g9-RPL30-NRg-5":5411,
"PRE4g9-SNU71-NRg-3":5412,
"PRE4g9-CDC33-NRg-1":5413,
"PRE4g9-RPN6-TRg-4":5414,
"PRE4g9-NAB2-TRg-4":5415,
"PRE4g9-NAB2-TRg-6":5416,
"PRE4g9-YTM1-NRg-1":5417,
"PRE4g9-OLE1-TRg-8":5418,
"PRE4g9-OLE1-TRg-1":5419,
"PRE4g9-UTP7-TRg-4":5420,
"PRE4g9-ACT1-NRg-6":5421,
"PRE4g9-RPL18A-NRg-3":5422,
"PRE4g9-BRX1-NRg-1":5423,
"PRE4g9-NAF1-TRg-8":5424,
"PRE4g9-NAF1-TRg-6":5425,
"PRE4g9-NAF1-TRg-4":5426,
"PRE4g9-CDC8-TRg-2":5427,
"PRE4g9-NSE4-TRg-1":5428,
"PRE4g9-PAB1-NRg-2":5429,
"PRE4g9-PRP43-TRg-4":5430,
"PRE4g9-SEC2-NRg-3":5431,
"PRE4g9-SEC2-NRg-6":5432,
"PRE4g9-MPP10-NRg-5":5433,
"PRE4g9-YDR355C-TRg-2":5434,
"PRE4g9-YLR339C-TRg-9":5435,
"PRE4g9-SNM1-TRg-2":5436,
"PRE4g9-ALR1-NRg-4":5437,
"PRE4g9-ALR1-NRg-1":5438,
"PRE4g9-ALR1-NRg-3":5439,
"PRE4g9-RPL10-TRg-1":5440,
"PRE4g9-RPL28-TRg-2":5441,
"PRE4g9-UTP25-TRg-1":5442,
"PRE4g9-POB3-TRg-1":5443,
"PRE4g9-POB3-TRg-3":5444,
"PRE4g9-POB3-TRg-2":5445,
"PRE4g9-MED11-TRg-1":5446,
"PRE4g9-ISA1-TRg-15":5447,
"PRE4g9-RRP1-NRg-1":5448,
"PRE4g9-MES1-NRg-1":5449,
"PRE4g9-SEC13-NRg-5":5450,
"PRE4g9-MCM2-NRg-2":5451,
"PRE4g9-ALA1-TRg-4":5452,
"PRE4g9-MTG2-TRg-5":5453,
"PRE4g9-TIF35-NRg-3":5454,
"PRE4g9-NSE1-TRg-3":5455,
"PRE4g9-NSE1-TRg-4":5456,
"PRE4g9-MOB2-NRg-6":5457,
"PRE4g9-VRG4-NRg-3":5458,
"PRE4g9-PRP9-TRg-3":5459,
"PRE4g9-HYM1-TRg-5":5460,
"PRE4g9-POP1-TRg-5":5461,
"PRE4g9-POP1-TRg-9":5462,
"PRE4g9-RPL17A-TRg-1":5463,
"PRE4g9-SLD2-TRg-1":5464,
"PRE4g9-CDC48-NRg-7":5465,
"PRE4g9-FHL1-NRg-2":5466,
"PRE4g9-BET3-NRg-7":5467,
"PRE4g9-MAK21-TRg-1":5468,
"PRE4g9-BRN1-TRg-4":5469,
"PRE4g9-FBA1-NRg-3":5470,
"PRE4g9-CDC42-TRg-6":5471,
"PRE4g9-CDC42-TRg-7":5472,
"PRE4g9-COG4-NRg-1":5473,
"PRE4g9-ATP3-NRg-3":5474,
"PRE4g9-ATP3-NRg-2":5475,
"PRE4g9-SMP3-TRg-5":5476,
"PRE4g9-CFT2-NRg-2":5477,
"PRE4g9-FAS2-TRg-5":5478,
"PRE4g9-DBP2-NRg-3":5479,
"PRE4g9-DBP2-NRg-2":5480,
"PRE4g9-MPS2-NRg-4":5481,
"PRE4g9-ARC35-TRg-2":5482,
"PRE4g9-ARC35-TRg-5":5483,
"PRE4g9-MRD1-TRg-1":5484,
"PRE4g9-RLP7-TRg-1":5485,
"PRE4g9-SPC34-TRg-1":5486,
"PRE4g9-CDC45-TRg-2":5487,
"PRE4g9-GCD6-TRg-3":5488,
"PRE4g9-GCD6-TRg-4":5489,
"PRE4g9-YPT6-NRg-2":5490,
"PRE4g9-RPS13-TRg-2":5491,
"PRE4g9-IPI3-TRg-3":5492,
"PRE4g9-TIF5-NRg-9":5493,
"PRE4g9-TIF5-NRg-7":5494,
"PRE4g9-TIF5-NRg-6":5495,
"PRE4g9-NAB3-TRg-3":5496,
"PRE4g9-GCD2-TRg-1":5497,
"PRE4g9-UBA1-TRg-2":5498,
"PRE4g9-SLD3-TRg-6":5499,
"PRE4g9-LCB1-TRg-5":5500,
"PRE4g9-TOA2-TRg-6":5501,
"PRE4g9-TOA2-TRg-1":5502,
"PRE4g9-TOA2-TRg-3":5503,
"PRE4g9-LSM2-TRg-1":5504,
"PRE4g9-YML6-TRg-13":5505,
"PRE4g9-YML6-TRg-12":5506,
"PRE4g9-UTP15-NRg-1":5507,
"PRE4g9-TIF6-NRg-8":5508,
"PRE4g9-SUP35-NRg-1":5509,
"PRE4g9-MPP10-NRg-1":5510,
"PRE4g9-SWI3-TRg-7":5511,
"PRE4g9-SSN3-NRg-2":5512,
"PRE4g9-SEC13-NRg-7":5513,
"PRE4g9-RPS15-NRg-3":5514,
"PRE4g9-RPL3-TRg-2":5515,
"PRE4g9-FBA1-NRg-2":5516,
"PRE4g9-FBA1-NRg-1":5517,
"PRE4g9-FBA1-NRg-5":5518,
"PRE4g9-DAM1-TRg-2":5519,
"PRE4g9-NHP2-TRg-2":5520,
"PRE4g9-HCA4-NRg-6":5521,
"PRE4g9-PRE3-TRg-4":5522,
"PRE4g9-DBP5-NRg-4":5523,
"PRE4g9-SPT6-NRg-4":5524,
"PRE4g9-SPT6-NRg-2":5525,
"PRE4g9-RPL18A-TRg-4":5526,
"PRE4g9-KSH1-TRg-1":5527,
"PRE4g9-KSH1-TRg-3":5528,
"PRE4g9-IPI3-NRg-1":5529,
"PRE4g9-PGA2-TRg-8":5530,
"PRE4g9-RPL18A-TRg-2":5531,
"PRE4g9-RPL33A-NRg-6":5532,
"PRE4g9-TAF12-NRg-2":5533,
"PRE4g9-USE1-TRg-5":5534,
"PRE4g9-YNL114C-TRg-1":5535,
"PRE4g9-SMC5-TRg-7":5536,
"PRE4g9-SMC5-TRg-6":5537,
"PRE4g9-RSC58-TRg-1":5538,
"PRE4g9-CTF13-TRg-2":5539,
"PRE4g9-NAB2-NRg-2":5540,
"PRE4g9-MCM7-TRg-4":5541,
"PRE4g9-BCP1-NRg-5":5542,
"PRE4g9-STU2-TRg-3":5543,
"PRE4g9-SEC21-NRg-6":5544,
"PRE4g9-SEC21-NRg-3":5545,
"PRE4g9-RPL1B-TRg-3":5546,
"PRE4g9-SEC20-NRg-2":5547,
"PRE4g9-VMA3-NRg-2":5548,
"PRE4g9-SEC23-NRg-5":5549,
"PRE4g9-CDC28-TRg-4":5550,
"PRE4g9-RPN12-NRg-11":5551,
"PRE4g9-PUP3-TRg-3":5552,
"PRE4g9-SEC31-TRg-2":5553,
"PRE4g9-SED5-TRg-6":5554,
"PRE4g9-SED5-TRg-5":5555,
"PRE4g9-RPL33A-TRg-1":5556,
"PRE4g9-RPL33A-TRg-2":5557,
"PRE4g9-MRPL11-TRg-2":5558,
"PRE4g9-RTP1-NRg-2":5559,
"PRE4g9-NUG1-TRg-2":5560,
"PRE4g9-VPH2-TRg-4":5561,
"PRE4g9-COP1-NRg-3":5562,
"PRE4g9-CRM1-NRg-1":5563,
"PRE4g9-RPL5-NRg-4":5564,
"PRE4g9-SNU13-NRg-4":5565,
"PRE4g9-PFS2-TRg-3":5566,
"PRE4g9-MPP10-TRg-2":5567,
"PRE4g9-TSR4-NRg-2":5568,
"PRE4g9-RSC2-TRg-1":5569,
"PRE4g9-SEC65-TRg-2":5570,
"PRE4g9-SMI1-NRg-1":5571,
"PRE4g9-RTT105-NRg-4":5572,
"PRE4g9-VMA5-TRg-3":5573,
"PRE4g9-VMA5-TRg-5":5574,
"PRE4g9-RRP1-TRg-3":5575,
"PRE4g9-CLC1-TRg-2":5576,
"PRE4g9-GCD6-NRg-1":5577,
"PRE4g9-GCD6-NRg-2":5578,
"PRE4g9-PXR1-TRg-1":5579,
"PRE4g9-CDC14-NRg-1":5580,
"PRE4g9-PCF11-TRg-6":5581,
"PRE4g9-PCF11-TRg-5":5582,
"PRE4g9-PCF11-TRg-4":5583,
"PRE4g9-SEC31-NRg-1":5584,
"PRE4g9-RRP5-NRg-1":5585,
"PRE4g9-PRE10-TRg-5":5586,
"PRE4g9-PRE10-TRg-1":5587,
"PRE4g9-RPS5-TRg-2":5588,
"PRE4g9-NSP1-TRg-4":5589,
"PRE4g9-PRP38-TRg-4":5590,
"PRE4g9-RCF1-NRg-5":5591,
"PRE4g9-RSC3-TRg-4":5592,
"PRE4g9-RSC3-TRg-5":5593,
"PRE4g9-RSC3-TRg-6":5594,
"PRE4g9-HTA1-NRg-12":5595,
"PRE4g9-HTA1-NRg-11":5596,
"PRE4g9-UTP23-TRg-2":5597,
"PRE4g9-GCD7-NRg-1":5598,
"PRE4g9-GCD7-NRg-2":5599,
"PRE4g9-GCD7-NRg-6":5600,
"PRE4g9-GAL11-NRg-2":5601,
"PRE4g9-GAL11-NRg-9":5602,
"PRE4g9-PHO4-TRg-5":5603,
"PRE4g9-SNP1-NRg-3":5604,
"PRE4g9-RPC37-TRg-5":5605,
"PRE4g9-CRM1-TRg-5":5606,
"PRE4g9-CRM1-TRg-2":5607,
"PRE4g9-ASK1-TRg-7":5608,
"PRE4g9-STU2-NRg-4":5609,
"PRE4g9-NEO1-NRg-3":5610,
"PRE4g9-GAL11-TRg-5":5611,
"PRE4g9-GAL11-TRg-7":5612,
"PRE4g9-SAM50-NRg-3":5613,
"PRE4g9-CSL4-TRg-2":5614,
"PRE4g9-CCT5-TRg-2":5615,
"PRE4g9-POL30-NRg-1":5616,
"PRE4g9-MED4-TRg-4":5617,
"PRE4g9-MED4-TRg-3":5618,
"PRE4g9-MED4-TRg-2":5619,
"PRE4g9-GDI1-TRg-4":5620,
"PRE4g9-GDI1-TRg-3":5621,
"PRE4g9-REB1-TRg-6":5622,
"PRE4g9-MRPL37-NRg-2":5623,
"PRE4g9-NOC3-TRg-3":5624,
"PRE4g9-SPC97-TRg-3":5625,
"PRE4g9-IPP1-TRg-3":5626,
"PRE4g9-IPP1-TRg-2":5627,
"PRE4g9-PTI1-TRg-3":5628,
"PRE4g9-PTI1-TRg-5":5629,
"PRE4g9-RFC5-NRg-1":5630,
"PRE4g9-CDC24-TRg-1":5631,
"PRE4g9-CDC24-TRg-3":5632,
"PRE4g9-CDC24-TRg-5":5633,
"PRE4g9-CDC24-TRg-6":5634,
"PRE4g9-UTP23-TRg-6":5635,
"PRE4g9-UTP23-TRg-4":5636,
"PRE4g9-UTP23-TRg-1":5637,
"PRE4g9-RHO3-NRg-4":5638,
"PRE4g9-TRS23-NRg-1":5639,
"PRE4g9-TRS23-NRg-3":5640,
"PRE4g9-RSP5-TRg-2":5641,
"PRE4g9-RSP5-TRg-1":5642,
"PRE4g9-SDA1-NRg-1":5643,
"PRE4g9-KAP95-TRg-8":5644,
"PRE4g9-ACO1-TRg-6":5645,
"PRE4g9-HTA1-NRg-3":5646,
"PRE4g9-HTA1-NRg-2":5647,
"PRE4g9-SPN1-TRg-1":5648,
"PRE4g9-MOT1-NRg-7":5649,
"PRE4g9-RPL17A-NRg-4":5650,
"PRE4g9-ADA2-TRg-4":5651,
"PRE4g9-SFH1-NRg-1":5652,
"PRE4g9-SPC97-NRg-5":5653,
"PRE4g9-PRP22-TRg-3":5654,
"PRE4g9-SEN15-TRg-2":5655,
"PRE4g9-RPL3-NRg-2":5656,
"PRE4g9-ISD11-NRg-2":5657,
"PRE4g9-HEM12-TRg-8":5658,
"PRE4g9-SEC10-TRg-1":5659,
"PRE4g9-HTB1-TRg-7":5660,
"PRE4g9-TTI2-TRg-1":5661,
"PRE4g9-ACP1-TRg-2":5662,
"PRE4g9-ACP1-TRg-4":5663,
"PRE4g9-GAL11-NRg-10":5664,
"PRE4g9-UTP22-TRg-2":5665,
"PRE4g9-MST1-NRg-5":5666,
"PRE4g9-RIB7-NRg-2":5667,
"PRE4g9-MCD1-TRg-6":5668,
"PRE4g9-MCD1-TRg-5":5669,
"PRE4g9-GPI8-NRg-2":5670,
"PRE4g9-THS1-TRg-2":5671,
"PRE4g9-RRP7-TRg-2":5672,
"PRE4g9-RRP7-TRg-5":5673,
"PRE4g9-SMX2-NRg-7":5674,
"PRE4g9-RRP45-TRg-5":5675,
"PRE4g9-RRP45-TRg-4":5676,
"PRE4g9-CNS1-TRg-2":5677,
"PRE4g9-FBP1-NRg-9":5678,
"PRE4g9-GCD11-NRg-1":5679,
"PRE4g9-RPL10-TRg-2":5680,
"PRE4g9-NUP192-TRg-4":5681,
"PRE4g9-NUP145-NRg-4":5682,
"PRE4g9-HEM12-TRg-6":5683,
"PRE4g9-PLC1-TRg-3":5684,
"PRE4g9-RPA43-TRg-1":5685,
"PRE4g9-RPB7-NRg-2":5686,
"PRE4g9-RPB7-NRg-3":5687,
"PRE4g9-NSL1-NRg-1":5688,
"PRE4g9-UTP6-TRg-3":5689,
"PRE4g9-UTP6-TRg-1":5690,
"PRE4g9-YJU2-TRg-5":5691,
"PRE4g9-FRS2-NRg-5":5692,
"PRE4g9-TIF35-NRg-2":5693,
"PRE4g9-GPI15-TRg-1":5694,
"PRE4g9-NOP1-NRg-5":5695,
"PRE4g9-GPI15-TRg-4":5696,
"PRE4g9-COG4-TRg-1":5697,
"PRE4g9-TFA1-TRg-1":5698,
"PRE4g9-RHO1-NRg-2":5699,
"PRE4g9-RHO1-NRg-1":5700,
"PRE4g9-CDC55-NRg-2":5701,
"PRE4g9-IDI1-NRg-7":5702,
"PRE4g9-RPL32-TRg-5":5703,
"PRE4g9-RPB5-TRg-4":5704,
"PRE4g9-DIP2-TRg-5":5705,
"PRE4g9-DIP2-TRg-1":5706,
"PRE4g9-RPC40-TRg-2":5707,
"PRE4g9-CDC6-TRg-5":5708,
"PRE4g9-CDC6-TRg-3":5709,
"PRE4g9-DAD2-TRg-2":5710,
"PRE4g9-RVS161-TRg-2":5711,
"PRE4g9-RVS161-TRg-1":5712,
"PRE4g9-SUP45-NRg-3":5713,
"PRE4g9-SRB6-NRg-5":5714,
"PRE4g9-RPC11-TRg-4":5715,
"PRE4g9-RKI1-TRg-8":5716,
"PRE4g9-NIP7-TRg-3":5717,
"PRE4g9-RPL33A-NRg-12":5718,
"PRE4g9-SAM50-TRg-4":5719,
"PRE4g9-NOP4-NRg-1":5720,
"PRE4g9-NOP4-NRg-3":5721,
"PRE4g9-SMX2-TRg-5":5722,
"PRE4g9-POL12-NRg-2":5723,
"PRE4g9-BMS1-NRg-2":5724,
"PRE4g9-RPA190-TRg-5":5725,
"PRE4g9-ALG14-NRg-4":5726,
"PRE4g9-ALG14-NRg-1":5727,
"PRE4g9-PRE5-NRg-1":5728,
"PRE4g9-BIG1-NRg-2":5729,
"PRE4g9-TFA2-TRg-4":5730,
"PRE4g9-IMP4-TRg-6":5731,
"PRE4g9-PAN1-NRg-1":5732,
"PRE4g9-UTP13-TRg-2":5733,
"PRE4g9-KAE1-NRg-3":5734,
"PRE4g9-ERG20-TRg-1":5735,
"PRE4g9-CDC20-TRg-6":5736,
"PRE4g9-PWP2-NRg-2":5737,
"PRE4g9-COG1-NRg-1":5738,
"PRE4g9-RPL1B-TRg-4":5739,
"PRE4g9-RPL1B-TRg-7":5740,
"PRE4g9-UTP20-TRg-3":5741,
"PRE4g9-UTP20-TRg-4":5742,
"PRE4g9-RPL25-TRg-4":5743,
"PRE4g9-RPL25-TRg-2":5744,
"PRE4g9-MCM7-NRg-1":5745,
"PRE4g9-MRP49-TRg-5":5746,
"PRE4g9-ERO1-NRg-3":5747,
"PRE4g9-UTP5-TRg-7":5748,
"PRE4g9-MCM4-NRg-1":5749,
"PRE4g9-PRE3-NRg-1":5750,
"PRE4g9-FCF1-NRg-1":5751,
"PRE4g9-CUS1-NRg-1":5752,
"PRE4g9-PSF1-TRg-2":5753,
"PRE4g9-BCP1-TRg-2":5754,
"PRE4g9-PAN1-TRg-1":5755,
"PRE4g9-PAN1-TRg-3":5756,
"PRE4g9-PAN1-TRg-4":5757,
"PRE4g9-VPS3-TRg-2":5758,
"PRE4g9-YIL060W-NRg-1":5759,
"PRE4g9-VPS53-NRg-1":5760,
"PRE4g9-CYR1-TRg-4":5761,
"PRE4g9-CYR1-TRg-7":5762,
"PRE4g9-MPS1-NRg-1":5763,
"PRE4g9-SRP1-TRg-5":5764,
"PRE4g9-SRP1-TRg-4":5765,
"PRE4g9-TAF12-TRg-2":5766,
"PRE4g9-TAF12-TRg-3":5767,
"PRE4g9-POP4-TRg-1":5768,
"PRE4g9-SPT16-TRg-1":5769,
"PRE4g9-NUP82-TRg-4":5770,
"PRE4g9-DML1-TRg-3":5771,
"PRE4g9-RPA43-NRg-3":5772,
"PRE4g9-STU2-NRg-3":5773,
"PRE4g9-POP4-NRg-4":5774,
"PRE4g9-MCD1-TRg-2":5775,
"PRE4g9-RPS3-NRg-4":5776,
"PRE4g9-PRP9-TRg-4":5777,
"PRE4g9-RPP1-NRg-2":5778,
"PRE4g9-MTR2-NRg-11":5779,
"PRE4g9-GCD11-TRg-1":5780,
"PRE4g9-RPF1-TRg-3":5781,
"PRE4g9-SUB2-NRg-4":5782,
"PRE4g9-GPI15-TRg-3":5783,
"PRE4g9-ERG9-TRg-6":5784,
"PRE4g9-RPT2-NRg-1":5785,
"PRE4g9-YOS1-NRg-3":5786,
"PRE4g9-SCM3-TRg-4":5787,
"PRE4g9-SCM3-TRg-6":5788,
"PRE4g9-RLP7-NRg-1":5789,
"PRE4g9-TFB2-NRg-4":5790,
"PRE4g9-IMP4-TRg-1":5791,
"PRE4g9-IMP4-TRg-3":5792,
"PRE4g9-PRE4-TRg-3":5793,
"PRE4g9-SUB2-TRg-3":5794,
"PRE4g9-RPP0-NRg-4":5795,
"PRE4g9-RPP0-NRg-3":5796,
"PRE4g9-TOM40-TRg-4":5797,
"PRE4g9-FUR1-NRg-12":5798,
"PRE4g9-TOM40-TRg-2":5799,
"PRE4g9-VMA11-NRg-4":5800,
"PRE4g9-PGS1-NRg-4":5801,
"PRE4g9-URB1-TRg-4":5802,
"PRE4g9-ARP4-TRg-3":5803,
"PRE4g9-RPT3-TRg-3":5804,
"PRE4g9-SUI3-TRg-3":5805,
"PRE4g9-RFC5-NRg-2":5806,
"PRE4g9-RRP14-TRg-2":5807,
"PRE4g9-SCC2-TRg-1":5808,
"PRE4g9-SSC1-TRg-3":5809,
"PRE4g9-RRP9-TRg-3":5810,
"PRE4g9-MOT1-NRg-9":5811,
"PRE4g9-RPL42A-NRg-2":5812,
"PRE4g9-SEC16-TRg-7":5813,
"PRE4g9-IMP4-NRg-2":5814,
"PRE4g9-YEF3-NRg-4":5815,
"PRE4g9-PUP1-TRg-1":5816,
"PRE4g9-UTP22-TRg-6":5817,
"PRE4g9-DBP2-NRg-4":5818,
"PRE4g9-PRE2-TRg-7":5819,
"PRE4g9-ATP16-TRg-6":5820,
"PRE4g9-UTP13-TRg-4":5821,
"PRE4g9-DOP1-NRg-4":5822,
"PRE4g9-TIM44-TRg-3":5823,
"PRE4g9-ATP16-TRg-2":5824,
"PRE4g9-ENP1-NRg-3":5825,
"PRE4g9-NAF1-TRg-3":5826,
"PRE4g9-COG4-TRg-2":5827,
"PRE4g9-SOG2-TRg-7":5828,
"PRE4g9-YDR341C-TRg-3":5829,
"PRE4g9-YMR290W-A-TRg-10":5830,
"PRE4g9-NUP192-NRg-9":5831,
"PRE4g9-RPS31-NRg-8":5832,
"PRE4g9-SPC97-NRg-6":5833,
"PRE4g9-EBP2-NRg-1":5834,
"PRE4g9-CDC48-TRg-5":5835,
"PRE4g9-RPT1-TRg-4":5836,
"PRE4g9-ULP1-NRg-2":5837,
"PRE4g9-RPN3-TRg-6":5838,
"PRE4g9-RPT1-TRg-5":5839,
"PRE4g9-KRE5-TRg-2":5840,
"PRE4g9-TBF1-NRg-8":5841,
"PRE4g9-UTP22-NRg-4":5842,
"PRE4g9-SSC1-NRg-4":5843,
"PRE4g9-REB1-TRg-4":5844,
"PRE4g9-CDC48-NRg-9":5845,
"PRE4g9-FAS2-TRg-8":5846,
"PRE4g9-TAO3-TRg-8":5847,
"PRE4g9-CKS1-TRg-5":5848,
"PRE4g9-YLR379W-TRg-7":5849,
"PRE4g9-TEN1-NRg-2":5850,
"PRE4g9-RPL42A-TRg-2":5851,
"PRE4g9-SEC27-TRg-4":5852,
"PRE4g9-TBF1-NRg-4":5853,
"PRE4g9-RPT1-NRg-6":5854,
"PRE4g9-COG1-TRg-3":5855,
"PRE4g9-SUI1-TRg-6":5856,
"PRE4g9-TIM23-TRg-6":5857,
"PRE4g9-CDC48-NRg-6":5858,
"PRE4g9-EPL1-TRg-5":5859,
"PRE4g9-RPT5-TRg-8":5860,
"PRE4g9-ATP16-NRg-4":5861,
"PRE4g9-RPN6-TRg-3":5862,
"PRE4g9-ERG9-NRg-6":5863,
"PRE4g9-SMX3-TRg-1":5864,
"PRE4g9-NCB2-NRg-3":5865,
"PRE4g9-SEC16-NRg-12":5866,
"PRE4g9-RPN6-TRg-2":5867,
"PRE4g9-REB1-NRg-4":5868,
"PRE4g9-ATP16-TRg-9":5869,
"PRE4g9-ERG9-NRg-7":5870,
"PRE4g3-RPL15A-NRg-4":5871,
"PRE4g3-RPL15A-NRg-5":5872,
"PRE4g3-KRE33-TRg-1":5873,
"PRE4g3-PMI40-NRg-1":5874,
"PRE4g3-NOP19-NRg-3":5875,
"PRE4g3-SRP14-NRg-4":5876,
"PRE4g3-SEC27-TRg-2":5877,
"PRE4g3-GPI14-TRg-3":5878,
"PRE4g3-PAH1-TRg-7":5879,
"PRE4g3-PAH1-TRg-6":5880,
"PRE4g3-PAH1-TRg-5":5881,
"PRE4g3-PAH1-TRg-3":5882,
"PRE4g3-COG3-TRg-1":5883,
"PRE4g3-HTS1-NRg-5":5884,
"PRE4g3-MSN5-TRg-7":5885,
"PRE4g3-ERG26-TRg-1":5886,
"PRE4g3-SMD2-TRg-5":5887,
"PRE4g3-SMD2-TRg-4":5888,
"PRE4g3-SMD2-TRg-1":5889,
"PRE4g3-PRE7-TRg-4":5890,
"PRE4g3-PRE7-TRg-7":5891,
"PRE4g3-SEC6-TRg-3":5892,
"PRE4g3-ESF2-NRg-1":5893,
"PRE4g3-ESF2-NRg-3":5894,
"PRE4g3-AFG2-TRg-2":5895,
"PRE4g3-RRP36-TRg-3":5896,
"PRE4g3-RRP36-TRg-5":5897,
"PRE4g3-GCR1-NRg-2":5898,
"PRE4g3-PRE4-NRg-4":5899,
"PRE4g3-PRE4-NRg-9":5900,
"PRE4g3-DSN1-NRg-2":5901,
"PRE4g3-GPI11-TRg-3":5902,
"PRE4g3-POP3-TRg-1":5903,
"PRE4g3-MNE1-TRg-5":5904,
"PRE4g3-RRP12-NRg-1":5905,
"PRE4g3-RSC6-TRg-2":5906,
"PRE4g3-CDC25-TRg-1":5907,
"PRE4g3-CDC25-TRg-9":5908,
"PRE4g3-YPP1-NRg-3":5909,
"PRE4g3-NFS1-NRg-9":5910,
"PRE4g3-NFS1-NRg-8":5911,
"PRE4g3-UBA2-TRg-1":5912,
"PRE4g3-ARP2-NRg-3":5913,
"PRE4g3-MAK16-TRg-1":5914,
"PRE4g3-CEP3-NRg-1":5915,
"PRE4g3-GUK1-TRg-5":5916,
"PRE4g3-GUK1-TRg-2":5917,
"PRE4g3-GPI12-NRg-6":5918,
"PRE4g3-RPS5-NRg-5":5919,
"PRE4g3-RPS5-NRg-2":5920,
"PRE4g3-RPC19-NRg-1":5921,
"PRE4g3-TIM54-TRg-1":5922,
"PRE4g3-TEN1-TRg-2":5923,
"PRE4g3-SAH1-NRg-4":5924,
"PRE4g3-SAH1-NRg-5":5925,
"PRE4g3-SAH1-NRg-3":5926,
"PRE4g3-ATP15-NRg-5":5927,
"PRE4g3-SCD5-TRg-5":5928,
"PRE4g3-ARB1-NRg-2":5929,
"PRE4g3-ARB1-NRg-4":5930,
"PRE4g3-PUP2-TRg-1":5931,
"PRE4g3-CCT8-TRg-2":5932,
"PRE4g3-MCM4-TRg-1":5933,
"PRE4g3-LSM4-TRg-1":5934,
"PRE4g3-NOP53-NRg-1":5935,
"PRE4g3-ATP3-TRg-4":5936,
"PRE4g3-AFG2-NRg-3":5937,
"PRE4g3-PRO3-NRg-3":5938,
"PRE4g3-NRD1-NRg-10":5939,
"PRE4g3-SEC61-TRg-2":5940,
"PRE4g3-RHO3-TRg-4":5941,
"PRE4g3-SNF2-TRg-6":5942,
"PRE4g3-SMD2-NRg-3":5943,
"PRE4g3-RSC4-TRg-2":5944,
"PRE4g3-RSC4-TRg-1":5945,
"PRE4g3-TIF34-TRg-2":5946,
"PRE4g3-BET1-NRg-1":5947,
"PRE4g3-CDC8-NRg-2":5948,
"PRE4g3-PRP42-TRg-2":5949,
"PRE4g3-RRB1-TRg-2":5950,
"PRE4g3-SPC24-TRg-1":5951,
"PRE4g3-ILS1-NRg-1":5952,
"PRE4g3-GFA1-TRg-2":5953,
"PRE4g3-SEC21-NRg-10":5954,
"PRE4g3-RPC10-NRg-1":5955,
"PRE4g3-RPB10-TRg-3":5956,
"PRE4g3-RPB10-TRg-2":5957,
"PRE4g3-YNL181W-TRg-1":5958,
"PRE4g3-RAD3-NRg-1":5959,
"PRE4g3-NOP10-TRg-1":5960,
"PRE4g3-BFR2-TRg-3":5961,
"PRE4g3-MCM2-TRg-6":5962,
"PRE4g3-MCM2-TRg-4":5963,
"PRE4g3-MPP10-TRg-1":5964,
"PRE4g3-RET2-TRg-4":5965,
"PRE4g3-RET2-TRg-1":5966,
"PRE4g3-RPS2-NRg-1":5967,
"PRE4g3-RPS2-NRg-2":5968,
"PRE4g3-ORC4-NRg-3":5969,
"PRE4g3-TIP20-TRg-7":5970,
"PRE4g3-SMT3-TRg-1":5971,
"PRE4g3-MSS18-NRg-6":5972,
"PRE4g3-YEF3-NRg-9":5973,
"PRE4g3-ASK1-NRg-1":5974,
"PRE4g3-SMC1-TRg-1":5975,
"PRE4g3-NIP1-NRg-1":5976,
"PRE4g3-RPP1-NRg-1":5977,
"PRE4g3-YDJ1-TRg-6":5978,
"PRE4g3-SUB2-NRg-1":5979,
"PRE4g3-TIM10-NRg-8":5980,
"PRE4g3-TIM10-NRg-4":5981,
"PRE4g3-TIM10-NRg-7":5982,
"PRE4g3-SKI6-TRg-4":5983,
"PRE4g3-TUB4-TRg-1":5984,
"PRE4g3-CDC37-NRg-2":5985,
"PRE4g3-ISD11-TRg-3":5986,
"PRE4g3-YOS1-TRg-4":5987,
"PRE4g3-SSC1-TRg-6":5988,
"PRE4g3-MTR3-TRg-5":5989,
"PRE4g3-MTR3-TRg-6":5990,
"PRE4g3-TFA1-TRg-2":5991,
"PRE4g3-CDC3-NRg-3":5992,
"PRE4g3-ERG25-TA-18":5993,
"PRE4g3-RPB11-TRg-4":5994,
"PRE4g3-RPB11-TRg-1":5995,
"PRE4g3-RPB11-TRg-2":5996,
"PRE4g3-DED1-TRg-3":5997,
"PRE4g3-DED1-TRg-1":5998,
"PRE4g3-DED1-TRg-6":5999,
"PRE4g3-DED1-TRg-4":6000,
"PRE4g3-RPL10-NRg-5":6001,
"PRE4g3-RPL10-NRg-4":6002,
"PRE4g3-EFB1-NRg-1":6003,
"PRE4g3-EFB1-NRg-5":6004,
"PRE4g3-EFB1-NRg-4":6005,
"PRE4g3-RPT3-NRg-1":6006,
"PRE4g3-SAC6-TRg-8":6007,
"PRE4g3-SAC6-TRg-4":6008,
"PRE4g3-SAC6-TRg-5":6009,
"PRE4g3-SAC6-TRg-3":6010,
"PRE4g3-DIM1-TRg-5":6011,
"PRE4g3-DIM1-TRg-7":6012,
"PRE4g3-RPC17-NRg-1":6013,
"PRE4g3-RPC17-NRg-2":6014,
"PRE4g3-YDR341C-TRg-1":6015,
"PRE4g3-RAP1-NRg-8":6016,
"PRE4g3-RAP1-NRg-5":6017,
"PRE4g3-RAP1-NRg-2":6018,
"PRE4g3-SEC26-NRg-3":6019,
"PRE4g3-SPP41-TRg-3":6020,
"PRE4g3-TAP42-NRg-1":6021,
"PRE4g3-PGA2-TRg-6":6022,
"PRE4g3-BRL1-TRg-1":6023,
"PRE4g3-FOL2-TRg-1":6024,
"PRE4g3-NAB3-NRg-5":6025,
"PRE4g3-SNF4-TRg-4":6026,
"PRE4g3-HRR25-TRg-2":6027,
"PRE4g3-TRS23-TRg-4":6028,
"PRE4g3-CTR86-TRg-4":6029,
"PRE4g3-RPB5-TRg-5":6030,
"PRE4g3-SPN1-NRg-2":6031,
"PRE4g3-SPN1-NRg-1":6032,
"PRE4g3-SEC61-NRg-1":6033,
"PRE4g3-SEC61-NRg-7":6034,
"PRE4g3-TUS1-TRg-3":6035,
"PRE4g3-OLE1-NRg-2":6036,
"PRE4g3-AFG2-TRg-1":6037,
"PRE4g3-TOA2-NRg-1":6038,
"PRE4g3-USO1-TRg-1":6039,
"PRE4g3-UTP22-NRg-2":6040,
"PRE4g3-RIB1-TRg-3":6041,
"PRE4g3-RIB1-TRg-7":6042,
"PRE4g3-RIB1-TRg-4":6043,
"PRE4g3-COG1-TRg-1":6044,
"PRE4g3-RPL32-NRg-2":6045,
"PRE4g3-GLC7-NRg-3":6046,
"PRE4g3-GLC7-NRg-4":6047,
"PRE4g3-HSF1-TRg-2":6048,
"PRE4g3-DAM1-NRg-5":6049,
"PRE4g3-SEC18-TRg-4":6050,
"PRE4g3-SEC18-TRg-5":6051,
"PRE4g3-PAB1-NRg-3":6052,
"PRE4g3-POP8-TRg-2":6053,
"PRE4g3-PAB1-NRg-4":6054,
"PRE4g3-BIG1-TRg-4":6055,
"PRE4g3-BIG1-TRg-5":6056,
"PRE4g3-BIG1-TRg-6":6057,
"PRE4g3-RPO41-NRg-1":6058,
"PRE4g3-RVB2-NRg-2":6059,
"PRE4g3-PET117-NRg-8":6060,
"PRE4g3-VPS45-NRg-9":6061,
"PRE4g3-YCG1-NRg-1":6062,
"PRE4g3-NOC4-NRg-1":6063,
"PRE4g3-NMD3-NRg-2":6064,
"PRE4g3-DRS1-TRg-2":6065,
"PRE4g3-HTB1-NRg-2":6066,
"PRE4g3-IPI1-TRg-2":6067,
"PRE4g3-SEC18-NRg-1":6068,
"PRE4g3-SEC18-NRg-2":6069,
"PRE4g3-JIP5-NRg-2":6070,
"PRE4g3-YPT1-TRg-3":6071,
"PRE4g3-YPT1-TRg-2":6072,
"PRE4g3-CLF1-NRg-2":6073,
"PRE4g3-SNF2-NRg-7":6074,
"PRE4g3-SNF2-NRg-4":6075,
"PRE4g3-RPL25-NRg-1":6076,
"PRE4g3-NOP56-TRg-1":6077,
"PRE4g3-NOP56-TRg-2":6078,
"PRE4g3-TRS31-TRg-1":6079,
"PRE4g3-DBF4-TRg-2":6080,
"PRE4g3-DBF4-TRg-1":6081,
"PRE4g3-RPC19-TRg-4":6082,
"PRE4g3-RPC19-TRg-6":6083,
"PRE4g3-RPC19-TRg-3":6084,
"PRE4g3-ROK1-NRg-1":6085,
"PRE4g3-CDC33-TRg-4":6086,
"PRE4g3-DHR2-TRg-3":6087,
"PRE4g3-RRP42-NRg-5":6088,
"PRE4g3-CLF1-TRg-1":6089,
"PRE4g3-ERG11-NA-16":6090,
"PRE4g3-VAS1-NRg-4":6091,
"PRE4g3-PIK1-NRg-2":6092,
"PRE4g3-SAR1-NRg-7":6093,
"PRE4g3-SAR1-NRg-4":6094,
"PRE4g3-RPS3-TRg-1":6095,
"PRE4g3-YTM1-TRg-2":6096,
"PRE4g3-SUI3-NRg-5":6097,
"PRE4g3-SUI3-NRg-2":6098,
"PRE4g3-RRP7-TRg-4":6099,
"PRE4g3-RRP7-TRg-6":6100,
"PRE4g3-NIP7-TRg-2":6101,
"PRE4g3-MDM35-TRg-1":6102,
"PRE4g3-ALA1-NRg-1":6103,
"PRE4g3-DOA4-NRg-2":6104,
"PRE4g3-RPS13-NRg-1":6105,
"PRE4g3-YSF3-TRg-2":6106,
"PRE4g3-RPS2-NRg-11":6107,
"PRE4g3-SSL1-TRg-10":6108,
"PRE4g3-NIP7-TRg-1":6109,
"PRE4g3-LST8-NRg-1":6110,
"PRE4g3-TAF4-TRg-3":6111,
"PRE4g3-HAS1-TRg-2":6112,
"PRE4g3-GLC7-TRg-2":6113,
"PRE4g3-CDC45-NRg-1":6114,
"PRE4g3-SEC22-NRg-8":6115,
"PRE4g3-YOS1-TRg-2":6116,
"PRE4g3-RBA50-TRg-3":6117,
"PRE4g3-SPP41-NRg-2":6118,
"PRE4g3-PRP46-TRg-2":6119,
"PRE4g3-PGA2-NRg-1":6120,
"PRE4g3-CBF5-TRg-3":6121,
"PRE4g3-TCP1-NRg-3":6122,
"PRE4g3-TCP1-NRg-2":6123,
"PRE4g3-ERG26-NRg-2":6124,
"PRE4g3-ERG26-NRg-4":6125,
"PRE4g3-MES1-TRg-5":6126,
"PRE4g3-HTS1-TRg-2":6127,
"PRE4g3-SSS1-TRg-3":6128,
"PRE4g3-SSS1-TRg-2":6129,
"PRE4g3-SYS1-TRg-7":6130,
"PRE4g3-SYS1-TRg-2":6131,
"PRE4g3-SYS1-TRg-1":6132,
"PRE4g3-BFR2-TRg-1":6133,
"PRE4g3-EOS1-TRg-3":6134,
"PRE4g3-TAF4-NRg-1":6135,
"PRE4g3-ARL3-NRg-8":6136,
"PRE4g3-RPN5-NRg-1":6137,
"PRE4g3-TIM9-NRg-2":6138,
"PRE4g3-NUP57-NRg-3":6139,
"PRE4g3-VPS4-TRg-1":6140,
"PRE4g3-CDC3-TRg-4":6141,
"PRE4g3-BBP1-NRg-1":6142,
"PRE4g3-BBP1-NRg-2":6143,
"PRE4g3-USE1-NRg-3":6144,
"PRE4g3-CCT7-TRg-1":6145,
"PRE4g3-SAH1-TRg-3":6146,
"PRE4g3-CHS2-TRg-1":6147,
"PRE4g3-DPM1-TRg-2":6148,
"PRE4g3-BBP1-TRg-1":6149,
"PRE4g3-NRD1-TRg-4":6150,
"PRE4g3-RPB3-NRg-1":6151,
"PRE4g3-PHO85-NRg-6":6152,
"PRE4g3-SNF6-TRg-6":6153,
"PRE4g3-PRP38-NRg-2":6154,
"PRE4g3-OAR1-NRg-3":6155,
"PRE4g3-ROX3-NRg-1":6156,
"PRE4g3-YPP1-TRg-6":6157,
"PRE4g3-CBF2-NRg-8":6158,
"PRE4g3-SPT6-TRg-5":6159,
"PRE4g3-SEC10-NRg-1":6160,
"PRE4g3-NSL1-NRg-3":6161,
"PRE4g3-NRD1-NRg-8":6162,
"PRE4g3-RPB3-TRg-1":6163,
"PRE4g3-NRD1-NRg-4":6164,
"PRE4g3-RVB1-TRg-2":6165,
"PRE4g3-TIF5-NRg-8":6166,
"PRE4g3-EOS1-NRg-1":6167,
"PRE4g3-ERG25-NA-26":6168,
"PRE4g3-MSL5-NRg-4":6169,
"PRE4g3-SEC24-TRg-2":6170,
"PRE4g3-RPL30-NRg-5":6171,
"PRE4g3-SNU71-NRg-3":6172,
"PRE4g3-CDC33-NRg-1":6173,
"PRE4g3-RPN6-TRg-4":6174,
"PRE4g3-NAB2-TRg-4":6175,
"PRE4g3-NAB2-TRg-6":6176,
"PRE4g3-YTM1-NRg-1":6177,
"PRE4g3-OLE1-TRg-8":6178,
"PRE4g3-OLE1-TRg-1":6179,
"PRE4g3-UTP7-TRg-4":6180,
"PRE4g3-ACT1-NRg-6":6181,
"PRE4g3-RPL18A-NRg-3":6182,
"PRE4g3-BRX1-NRg-1":6183,
"PRE4g3-NAF1-TRg-8":6184,
"PRE4g3-NAF1-TRg-6":6185,
"PRE4g3-NAF1-TRg-4":6186,
"PRE4g3-CDC8-TRg-2":6187,
"PRE4g3-NSE4-TRg-1":6188,
"PRE4g3-PAB1-NRg-2":6189,
"PRE4g3-PRP43-TRg-4":6190,
"PRE4g3-SEC2-NRg-3":6191,
"PRE4g3-SEC2-NRg-6":6192,
"PRE4g3-MPP10-NRg-5":6193,
"PRE4g3-YDR355C-TRg-2":6194,
"PRE4g3-YLR339C-TRg-9":6195,
"PRE4g3-SNM1-TRg-2":6196,
"PRE4g3-ALR1-NRg-4":6197,
"PRE4g3-ALR1-NRg-1":6198,
"PRE4g3-ALR1-NRg-3":6199,
"PRE4g3-RPL10-TRg-1":6200,
"PRE4g3-RPL28-TRg-2":6201,
"PRE4g3-UTP25-TRg-1":6202,
"PRE4g3-POB3-TRg-1":6203,
"PRE4g3-POB3-TRg-3":6204,
"PRE4g3-POB3-TRg-2":6205,
"PRE4g3-MED11-TRg-1":6206,
"PRE4g3-ISA1-TRg-15":6207,
"PRE4g3-RRP1-NRg-1":6208,
"PRE4g3-MES1-NRg-1":6209,
"PRE4g3-SEC13-NRg-5":6210,
"PRE4g3-MCM2-NRg-2":6211,
"PRE4g3-ALA1-TRg-4":6212,
"PRE4g3-MTG2-TRg-5":6213,
"PRE4g3-TIF35-NRg-3":6214,
"PRE4g3-NSE1-TRg-3":6215,
"PRE4g3-NSE1-TRg-4":6216,
"PRE4g3-MOB2-NRg-6":6217,
"PRE4g3-VRG4-NRg-3":6218,
"PRE4g3-PRP9-TRg-3":6219,
"PRE4g3-HYM1-TRg-5":6220,
"PRE4g3-POP1-TRg-5":6221,
"PRE4g3-POP1-TRg-9":6222,
"PRE4g3-RPL17A-TRg-1":6223,
"PRE4g3-SLD2-TRg-1":6224,
"PRE4g3-CDC48-NRg-7":6225,
"PRE4g3-FHL1-NRg-2":6226,
"PRE4g3-BET3-NRg-7":6227,
"PRE4g3-MAK21-TRg-1":6228,
"PRE4g3-BRN1-TRg-4":6229,
"PRE4g3-FBA1-NRg-3":6230,
"PRE4g3-CDC42-TRg-6":6231,
"PRE4g3-CDC42-TRg-7":6232,
"PRE4g3-COG4-NRg-1":6233,
"PRE4g3-ATP3-NRg-3":6234,
"PRE4g3-ATP3-NRg-2":6235,
"PRE4g3-SMP3-TRg-5":6236,
"PRE4g3-CFT2-NRg-2":6237,
"PRE4g3-FAS2-TRg-5":6238,
"PRE4g3-DBP2-NRg-3":6239,
"PRE4g3-DBP2-NRg-2":6240,
"PRE4g3-MPS2-NRg-4":6241,
"PRE4g3-ARC35-TRg-2":6242,
"PRE4g3-ARC35-TRg-5":6243,
"PRE4g3-MRD1-TRg-1":6244,
"PRE4g3-RLP7-TRg-1":6245,
"PRE4g3-SPC34-TRg-1":6246,
"PRE4g3-CDC45-TRg-2":6247,
"PRE4g3-GCD6-TRg-3":6248,
"PRE4g3-GCD6-TRg-4":6249,
"PRE4g3-YPT6-NRg-2":6250,
"PRE4g3-RPS13-TRg-2":6251,
"PRE4g3-IPI3-TRg-3":6252,
"PRE4g3-TIF5-NRg-9":6253,
"PRE4g3-TIF5-NRg-7":6254,
"PRE4g3-TIF5-NRg-6":6255,
"PRE4g3-NAB3-TRg-3":6256,
"PRE4g3-GCD2-TRg-1":6257,
"PRE4g3-UBA1-TRg-2":6258,
"PRE4g3-SLD3-TRg-6":6259,
"PRE4g3-LCB1-TRg-5":6260,
"PRE4g3-TOA2-TRg-6":6261,
"PRE4g3-TOA2-TRg-1":6262,
"PRE4g3-TOA2-TRg-3":6263,
"PRE4g3-LSM2-TRg-1":6264,
"PRE4g3-YML6-TRg-13":6265,
"PRE4g3-YML6-TRg-12":6266,
"PRE4g3-UTP15-NRg-1":6267,
"PRE4g3-TIF6-NRg-8":6268,
"PRE4g3-SUP35-NRg-1":6269,
"PRE4g3-MPP10-NRg-1":6270,
"PRE4g3-SWI3-TRg-7":6271,
"PRE4g3-SSN3-NRg-2":6272,
"PRE4g3-SEC13-NRg-7":6273,
"PRE4g3-RPS15-NRg-3":6274,
"PRE4g3-RPL3-TRg-2":6275,
"PRE4g3-FBA1-NRg-2":6276,
"PRE4g3-FBA1-NRg-1":6277,
"PRE4g3-FBA1-NRg-5":6278,
"PRE4g3-DAM1-TRg-2":6279,
"PRE4g3-NHP2-TRg-2":6280,
"PRE4g3-HCA4-NRg-6":6281,
"PRE4g3-PRE3-TRg-4":6282,
"PRE4g3-DBP5-NRg-4":6283,
"PRE4g3-SPT6-NRg-4":6284,
"PRE4g3-SPT6-NRg-2":6285,
"PRE4g3-RPL18A-TRg-4":6286,
"PRE4g3-KSH1-TRg-1":6287,
"PRE4g3-KSH1-TRg-3":6288,
"PRE4g3-IPI3-NRg-1":6289,
"PRE4g3-PGA2-TRg-8":6290,
"PRE4g3-RPL18A-TRg-2":6291,
"PRE4g3-RPL33A-NRg-6":6292,
"PRE4g3-TAF12-NRg-2":6293,
"PRE4g3-USE1-TRg-5":6294,
"PRE4g3-YNL114C-TRg-1":6295,
"PRE4g3-SMC5-TRg-7":6296,
"PRE4g3-SMC5-TRg-6":6297,
"PRE4g3-RSC58-TRg-1":6298,
"PRE4g3-CTF13-TRg-2":6299,
"PRE4g3-NAB2-NRg-2":6300,
"PRE4g3-MCM7-TRg-4":6301,
"PRE4g3-BCP1-NRg-5":6302,
"PRE4g3-STU2-TRg-3":6303,
"PRE4g3-SEC21-NRg-6":6304,
"PRE4g3-SEC21-NRg-3":6305,
"PRE4g3-RPL1B-TRg-3":6306,
"PRE4g3-SEC20-NRg-2":6307,
"PRE4g3-VMA3-NRg-2":6308,
"PRE4g3-SEC23-NRg-5":6309,
"PRE4g3-CDC28-TRg-4":6310,
"PRE4g3-RPN12-NRg-11":6311,
"PRE4g3-PUP3-TRg-3":6312,
"PRE4g3-SEC31-TRg-2":6313,
"PRE4g3-SED5-TRg-6":6314,
"PRE4g3-SED5-TRg-5":6315,
"PRE4g3-RPL33A-TRg-1":6316,
"PRE4g3-RPL33A-TRg-2":6317,
"PRE4g3-MRPL11-TRg-2":6318,
"PRE4g3-RTP1-NRg-2":6319,
"PRE4g3-NUG1-TRg-2":6320,
"PRE4g3-VPH2-TRg-4":6321,
"PRE4g3-COP1-NRg-3":6322,
"PRE4g3-CRM1-NRg-1":6323,
"PRE4g3-RPL5-NRg-4":6324,
"PRE4g3-SNU13-NRg-4":6325,
"PRE4g3-PFS2-TRg-3":6326,
"PRE4g3-MPP10-TRg-2":6327,
"PRE4g3-TSR4-NRg-2":6328,
"PRE4g3-RSC2-TRg-1":6329,
"PRE4g3-SEC65-TRg-2":6330,
"PRE4g3-SMI1-NRg-1":6331,
"PRE4g3-RTT105-NRg-4":6332,
"PRE4g3-VMA5-TRg-3":6333,
"PRE4g3-VMA5-TRg-5":6334,
"PRE4g3-RRP1-TRg-3":6335,
"PRE4g3-CLC1-TRg-2":6336,
"PRE4g3-GCD6-NRg-1":6337,
"PRE4g3-GCD6-NRg-2":6338,
"PRE4g3-PXR1-TRg-1":6339,
"PRE4g3-CDC14-NRg-1":6340,
"PRE4g3-PCF11-TRg-6":6341,
"PRE4g3-PCF11-TRg-5":6342,
"PRE4g3-PCF11-TRg-4":6343,
"PRE4g3-SEC31-NRg-1":6344,
"PRE4g3-RRP5-NRg-1":6345,
"PRE4g3-PRE10-TRg-5":6346,
"PRE4g3-PRE10-TRg-1":6347,
"PRE4g3-RPS5-TRg-2":6348,
"PRE4g3-NSP1-TRg-4":6349,
"PRE4g3-PRP38-TRg-4":6350,
"PRE4g3-RCF1-NRg-5":6351,
"PRE4g3-RSC3-TRg-4":6352,
"PRE4g3-RSC3-TRg-5":6353,
"PRE4g3-RSC3-TRg-6":6354,
"PRE4g3-HTA1-NRg-12":6355,
"PRE4g3-HTA1-NRg-11":6356,
"PRE4g3-UTP23-TRg-2":6357,
"PRE4g3-GCD7-NRg-1":6358,
"PRE4g3-GCD7-NRg-2":6359,
"PRE4g3-GCD7-NRg-6":6360,
"PRE4g3-GAL11-NRg-2":6361,
"PRE4g3-GAL11-NRg-9":6362,
"PRE4g3-PHO4-TRg-5":6363,
"PRE4g3-SNP1-NRg-3":6364,
"PRE4g3-RPC37-TRg-5":6365,
"PRE4g3-CRM1-TRg-5":6366,
"PRE4g3-CRM1-TRg-2":6367,
"PRE4g3-ASK1-TRg-7":6368,
"PRE4g3-STU2-NRg-4":6369,
"PRE4g3-NEO1-NRg-3":6370,
"PRE4g3-GAL11-TRg-5":6371,
"PRE4g3-GAL11-TRg-7":6372,
"PRE4g3-SAM50-NRg-3":6373,
"PRE4g3-CSL4-TRg-2":6374,
"PRE4g3-CCT5-TRg-2":6375,
"PRE4g3-POL30-NRg-1":6376,
"PRE4g3-MED4-TRg-4":6377,
"PRE4g3-MED4-TRg-3":6378,
"PRE4g3-MED4-TRg-2":6379,
"PRE4g3-GDI1-TRg-4":6380,
"PRE4g3-GDI1-TRg-3":6381,
"PRE4g3-REB1-TRg-6":6382,
"PRE4g3-MRPL37-NRg-2":6383,
"PRE4g3-NOC3-TRg-3":6384,
"PRE4g3-SPC97-TRg-3":6385,
"PRE4g3-IPP1-TRg-3":6386,
"PRE4g3-IPP1-TRg-2":6387,
"PRE4g3-PTI1-TRg-3":6388,
"PRE4g3-PTI1-TRg-5":6389,
"PRE4g3-RFC5-NRg-1":6390,
"PRE4g3-CDC24-TRg-1":6391,
"PRE4g3-CDC24-TRg-3":6392,
"PRE4g3-CDC24-TRg-5":6393,
"PRE4g3-CDC24-TRg-6":6394,
"PRE4g3-UTP23-TRg-6":6395,
"PRE4g3-UTP23-TRg-4":6396,
"PRE4g3-UTP23-TRg-1":6397,
"PRE4g3-RHO3-NRg-4":6398,
"PRE4g3-TRS23-NRg-1":6399,
"PRE4g3-TRS23-NRg-3":6400,
"PRE4g3-RSP5-TRg-2":6401,
"PRE4g3-RSP5-TRg-1":6402,
"PRE4g3-SDA1-NRg-1":6403,
"PRE4g3-KAP95-TRg-8":6404,
"PRE4g3-ACO1-TRg-6":6405,
"PRE4g3-HTA1-NRg-3":6406,
"PRE4g3-HTA1-NRg-2":6407,
"PRE4g3-SPN1-TRg-1":6408,
"PRE4g3-MOT1-NRg-7":6409,
"PRE4g3-RPL17A-NRg-4":6410,
"PRE4g3-ADA2-TRg-4":6411,
"PRE4g3-SFH1-NRg-1":6412,
"PRE4g3-SPC97-NRg-5":6413,
"PRE4g3-PRP22-TRg-3":6414,
"PRE4g3-SEN15-TRg-2":6415,
"PRE4g3-RPL3-NRg-2":6416,
"PRE4g3-ISD11-NRg-2":6417,
"PRE4g3-HEM12-TRg-8":6418,
"PRE4g3-SEC10-TRg-1":6419,
"PRE4g3-HTB1-TRg-7":6420,
"PRE4g3-TTI2-TRg-1":6421,
"PRE4g3-ACP1-TRg-2":6422,
"PRE4g3-ACP1-TRg-4":6423,
"PRE4g3-GAL11-NRg-10":6424,
"PRE4g3-UTP22-TRg-2":6425,
"PRE4g3-MST1-NRg-5":6426,
"PRE4g3-RIB7-NRg-2":6427,
"PRE4g3-MCD1-TRg-6":6428,
"PRE4g3-MCD1-TRg-5":6429,
"PRE4g3-GPI8-NRg-2":6430,
"PRE4g3-THS1-TRg-2":6431,
"PRE4g3-RRP7-TRg-2":6432,
"PRE4g3-RRP7-TRg-5":6433,
"PRE4g3-SMX2-NRg-7":6434,
"PRE4g3-RRP45-TRg-5":6435,
"PRE4g3-RRP45-TRg-4":6436,
"PRE4g3-CNS1-TRg-2":6437,
"PRE4g3-FBP1-NRg-9":6438,
"PRE4g3-GCD11-NRg-1":6439,
"PRE4g3-RPL10-TRg-2":6440,
"PRE4g3-NUP192-TRg-4":6441,
"PRE4g3-NUP145-NRg-4":6442,
"PRE4g3-HEM12-TRg-6":6443,
"PRE4g3-PLC1-TRg-3":6444,
"PRE4g3-RPA43-TRg-1":6445,
"PRE4g3-RPB7-NRg-2":6446,
"PRE4g3-RPB7-NRg-3":6447,
"PRE4g3-NSL1-NRg-1":6448,
"PRE4g3-UTP6-TRg-3":6449,
"PRE4g3-UTP6-TRg-1":6450,
"PRE4g3-YJU2-TRg-5":6451,
"PRE4g3-FRS2-NRg-5":6452,
"PRE4g3-TIF35-NRg-2":6453,
"PRE4g3-GPI15-TRg-1":6454,
"PRE4g3-NOP1-NRg-5":6455,
"PRE4g3-GPI15-TRg-4":6456,
"PRE4g3-COG4-TRg-1":6457,
"PRE4g3-TFA1-TRg-1":6458,
"PRE4g3-RHO1-NRg-2":6459,
"PRE4g3-RHO1-NRg-1":6460,
"PRE4g3-CDC55-NRg-2":6461,
"PRE4g3-IDI1-NRg-7":6462,
"PRE4g3-RPL32-TRg-5":6463,
"PRE4g3-RPB5-TRg-4":6464,
"PRE4g3-DIP2-TRg-5":6465,
"PRE4g3-DIP2-TRg-1":6466,
"PRE4g3-RPC40-TRg-2":6467,
"PRE4g3-CDC6-TRg-5":6468,
"PRE4g3-CDC6-TRg-3":6469,
"PRE4g3-DAD2-TRg-2":6470,
"PRE4g3-RVS161-TRg-2":6471,
"PRE4g3-RVS161-TRg-1":6472,
"PRE4g3-SUP45-NRg-3":6473,
"PRE4g3-SRB6-NRg-5":6474,
"PRE4g3-RPC11-TRg-4":6475,
"PRE4g3-RKI1-TRg-8":6476,
"PRE4g3-NIP7-TRg-3":6477,
"PRE4g3-RPL33A-NRg-12":6478,
"PRE4g3-SAM50-TRg-4":6479,
"PRE4g3-NOP4-NRg-1":6480,
"PRE4g3-NOP4-NRg-3":6481,
"PRE4g3-SMX2-TRg-5":6482,
"PRE4g3-POL12-NRg-2":6483,
"PRE4g3-BMS1-NRg-2":6484,
"PRE4g3-RPA190-TRg-5":6485,
"PRE4g3-ALG14-NRg-4":6486,
"PRE4g3-ALG14-NRg-1":6487,
"PRE4g3-PRE5-NRg-1":6488,
"PRE4g3-BIG1-NRg-2":6489,
"PRE4g3-TFA2-TRg-4":6490,
"PRE4g3-IMP4-TRg-6":6491,
"PRE4g3-PAN1-NRg-1":6492,
"PRE4g3-UTP13-TRg-2":6493,
"PRE4g3-KAE1-NRg-3":6494,
"PRE4g3-ERG20-TRg-1":6495,
"PRE4g3-CDC20-TRg-6":6496,
"PRE4g3-PWP2-NRg-2":6497,
"PRE4g3-COG1-NRg-1":6498,
"PRE4g3-RPL1B-TRg-4":6499,
"PRE4g3-RPL1B-TRg-7":6500,
"PRE4g3-UTP20-TRg-3":6501,
"PRE4g3-UTP20-TRg-4":6502,
"PRE4g3-RPL25-TRg-4":6503,
"PRE4g3-RPL25-TRg-2":6504,
"PRE4g3-MCM7-NRg-1":6505,
"PRE4g3-MRP49-TRg-5":6506,
"PRE4g3-ERO1-NRg-3":6507,
"PRE4g3-UTP5-TRg-7":6508,
"PRE4g3-MCM4-NRg-1":6509,
"PRE4g3-PRE3-NRg-1":6510,
"PRE4g3-FCF1-NRg-1":6511,
"PRE4g3-CUS1-NRg-1":6512,
"PRE4g3-PSF1-TRg-2":6513,
"PRE4g3-BCP1-TRg-2":6514,
"PRE4g3-PAN1-TRg-1":6515,
"PRE4g3-PAN1-TRg-3":6516,
"PRE4g3-PAN1-TRg-4":6517,
"PRE4g3-VPS3-TRg-2":6518,
"PRE4g3-YIL060W-NRg-1":6519,
"PRE4g3-VPS53-NRg-1":6520,
"PRE4g3-CYR1-TRg-4":6521,
"PRE4g3-CYR1-TRg-7":6522,
"PRE4g3-MPS1-NRg-1":6523,
"PRE4g3-SRP1-TRg-5":6524,
"PRE4g3-SRP1-TRg-4":6525,
"PRE4g3-TAF12-TRg-2":6526,
"PRE4g3-TAF12-TRg-3":6527,
"PRE4g3-POP4-TRg-1":6528,
"PRE4g3-SPT16-TRg-1":6529,
"PRE4g3-NUP82-TRg-4":6530,
"PRE4g3-DML1-TRg-3":6531,
"PRE4g3-RPA43-NRg-3":6532,
"PRE4g3-STU2-NRg-3":6533,
"PRE4g3-POP4-NRg-4":6534,
"PRE4g3-MCD1-TRg-2":6535,
"PRE4g3-RPS3-NRg-4":6536,
"PRE4g3-PRP9-TRg-4":6537,
"PRE4g3-RPP1-NRg-2":6538,
"PRE4g3-MTR2-NRg-11":6539,
"PRE4g3-GCD11-TRg-1":6540,
"PRE4g3-RPF1-TRg-3":6541,
"PRE4g3-SUB2-NRg-4":6542,
"PRE4g3-GPI15-TRg-3":6543,
"PRE4g3-ERG9-TRg-6":6544,
"PRE4g3-RPT2-NRg-1":6545,
"PRE4g3-YOS1-NRg-3":6546,
"PRE4g3-SCM3-TRg-4":6547,
"PRE4g3-SCM3-TRg-6":6548,
"PRE4g3-RLP7-NRg-1":6549,
"PRE4g3-TFB2-NRg-4":6550,
"PRE4g3-IMP4-TRg-1":6551,
"PRE4g3-IMP4-TRg-3":6552,
"PRE4g3-PRE4-TRg-3":6553,
"PRE4g3-SUB2-TRg-3":6554,
"PRE4g3-RPP0-NRg-4":6555,
"PRE4g3-RPP0-NRg-3":6556,
"PRE4g3-TOM40-TRg-4":6557,
"PRE4g3-FUR1-NRg-12":6558,
"PRE4g3-TOM40-TRg-2":6559,
"PRE4g3-VMA11-NRg-4":6560,
"PRE4g3-PGS1-NRg-4":6561,
"PRE4g3-URB1-TRg-4":6562,
"PRE4g3-ARP4-TRg-3":6563,
"PRE4g3-RPT3-TRg-3":6564,
"PRE4g3-SUI3-TRg-3":6565,
"PRE4g3-RFC5-NRg-2":6566,
"PRE4g3-RRP14-TRg-2":6567,
"PRE4g3-SCC2-TRg-1":6568,
"PRE4g3-SSC1-TRg-3":6569,
"PRE4g3-RRP9-TRg-3":6570,
"PRE4g3-MOT1-NRg-9":6571,
"PRE4g3-RPL42A-NRg-2":6572,
"PRE4g3-SEC16-TRg-7":6573,
"PRE4g3-IMP4-NRg-2":6574,
"PRE4g3-YEF3-NRg-4":6575,
"PRE4g3-PUP1-TRg-1":6576,
"PRE4g3-UTP22-TRg-6":6577,
"PRE4g3-DBP2-NRg-4":6578,
"PRE4g3-PRE2-TRg-7":6579,
"PRE4g3-ATP16-TRg-6":6580,
"PRE4g3-UTP13-TRg-4":6581,
"PRE4g3-DOP1-NRg-4":6582,
"PRE4g3-TIM44-TRg-3":6583,
"PRE4g3-ATP16-TRg-2":6584,
"PRE4g3-ENP1-NRg-3":6585,
"PRE4g3-NAF1-TRg-3":6586,
"PRE4g3-COG4-TRg-2":6587,
"PRE4g3-SOG2-TRg-7":6588,
"PRE4g3-YDR341C-TRg-3":6589,
"PRE4g3-YMR290W-A-TRg-10":6590,
"PRE4g3-NUP192-NRg-9":6591,
"PRE4g3-RPS31-NRg-8":6592,
"PRE4g3-SPC97-NRg-6":6593,
"PRE4g3-EBP2-NRg-1":6594,
"PRE4g3-CDC48-TRg-5":6595,
"PRE4g3-RPT1-TRg-4":6596,
"PRE4g3-ULP1-NRg-2":6597,
"PRE4g3-RPN3-TRg-6":6598,
"PRE4g3-RPT1-TRg-5":6599,
"PRE4g3-KRE5-TRg-2":6600,
"PRE4g3-TBF1-NRg-8":6601,
"PRE4g3-UTP22-NRg-4":6602,
"PRE4g3-SSC1-NRg-4":6603,
"PRE4g3-REB1-TRg-4":6604,
"PRE4g3-CDC48-NRg-9":6605,
"PRE4g3-FAS2-TRg-8":6606,
"PRE4g3-TAO3-TRg-8":6607,
"PRE4g3-CKS1-TRg-5":6608,
"PRE4g3-YLR379W-TRg-7":6609,
"PRE4g3-TEN1-NRg-2":6610,
"PRE4g3-RPL42A-TRg-2":6611,
"PRE4g3-SEC27-TRg-4":6612,
"PRE4g3-TBF1-NRg-4":6613,
"PRE4g3-RPT1-NRg-6":6614,
"PRE4g3-COG1-TRg-3":6615,
"PRE4g3-SUI1-TRg-6":6616,
"PRE4g3-TIM23-TRg-6":6617,
"PRE4g3-CDC48-NRg-6":6618,
"PRE4g3-EPL1-TRg-5":6619,
"PRE4g3-RPT5-TRg-8":6620,
"PRE4g3-ATP16-NRg-4":6621,
"PRE4g3-RPN6-TRg-3":6622,
"PRE4g3-ERG9-NRg-6":6623,
"PRE4g3-SMX3-TRg-1":6624,
"PRE4g3-NCB2-NRg-3":6625,
"PRE4g3-SEC16-NRg-12":6626,
"PRE4g3-RPN6-TRg-2":6627,
"PRE4g3-REB1-NRg-4":6628,
"PRE4g3-ATP16-TRg-9":6629,
"PRE4g3-ERG9-NRg-7":6630,
"RPN5g1-RPL15A-NRg-4":6631,
"RPN5g1-RPL15A-NRg-5":6632,
"RPN5g1-KRE33-TRg-1":6633,
"RPN5g1-PMI40-NRg-1":6634,
"RPN5g1-NOP19-NRg-3":6635,
"RPN5g1-SRP14-NRg-4":6636,
"RPN5g1-SEC27-TRg-2":6637,
"RPN5g1-GPI14-TRg-3":6638,
"RPN5g1-PAH1-TRg-7":6639,
"RPN5g1-PAH1-TRg-6":6640,
"RPN5g1-PAH1-TRg-5":6641,
"RPN5g1-PAH1-TRg-3":6642,
"RPN5g1-COG3-TRg-1":6643,
"RPN5g1-HTS1-NRg-5":6644,
"RPN5g1-MSN5-TRg-7":6645,
"RPN5g1-ERG26-TRg-1":6646,
"RPN5g1-SMD2-TRg-5":6647,
"RPN5g1-SMD2-TRg-4":6648,
"RPN5g1-SMD2-TRg-1":6649,
"RPN5g1-PRE7-TRg-4":6650,
"RPN5g1-PRE7-TRg-7":6651,
"RPN5g1-SEC6-TRg-3":6652,
"RPN5g1-ESF2-NRg-1":6653,
"RPN5g1-ESF2-NRg-3":6654,
"RPN5g1-AFG2-TRg-2":6655,
"RPN5g1-RRP36-TRg-3":6656,
"RPN5g1-RRP36-TRg-5":6657,
"RPN5g1-GCR1-NRg-2":6658,
"RPN5g1-PRE4-NRg-4":6659,
"RPN5g1-PRE4-NRg-9":6660,
"RPN5g1-DSN1-NRg-2":6661,
"RPN5g1-GPI11-TRg-3":6662,
"RPN5g1-POP3-TRg-1":6663,
"RPN5g1-MNE1-TRg-5":6664,
"RPN5g1-RRP12-NRg-1":6665,
"RPN5g1-RSC6-TRg-2":6666,
"RPN5g1-CDC25-TRg-1":6667,
"RPN5g1-CDC25-TRg-9":6668,
"RPN5g1-YPP1-NRg-3":6669,
"RPN5g1-NFS1-NRg-9":6670,
"RPN5g1-NFS1-NRg-8":6671,
"RPN5g1-UBA2-TRg-1":6672,
"RPN5g1-ARP2-NRg-3":6673,
"RPN5g1-MAK16-TRg-1":6674,
"RPN5g1-CEP3-NRg-1":6675,
"RPN5g1-GUK1-TRg-5":6676,
"RPN5g1-GUK1-TRg-2":6677,
"RPN5g1-GPI12-NRg-6":6678,
"RPN5g1-RPS5-NRg-5":6679,
"RPN5g1-RPS5-NRg-2":6680,
"RPN5g1-RPC19-NRg-1":6681,
"RPN5g1-TIM54-TRg-1":6682,
"RPN5g1-TEN1-TRg-2":6683,
"RPN5g1-SAH1-NRg-4":6684,
"RPN5g1-SAH1-NRg-5":6685,
"RPN5g1-SAH1-NRg-3":6686,
"RPN5g1-ATP15-NRg-5":6687,
"RPN5g1-SCD5-TRg-5":6688,
"RPN5g1-ARB1-NRg-2":6689,
"RPN5g1-ARB1-NRg-4":6690,
"RPN5g1-PUP2-TRg-1":6691,
"RPN5g1-CCT8-TRg-2":6692,
"RPN5g1-MCM4-TRg-1":6693,
"RPN5g1-LSM4-TRg-1":6694,
"RPN5g1-NOP53-NRg-1":6695,
"RPN5g1-ATP3-TRg-4":6696,
"RPN5g1-AFG2-NRg-3":6697,
"RPN5g1-PRO3-NRg-3":6698,
"RPN5g1-NRD1-NRg-10":6699,
"RPN5g1-SEC61-TRg-2":6700,
"RPN5g1-RHO3-TRg-4":6701,
"RPN5g1-SNF2-TRg-6":6702,
"RPN5g1-SMD2-NRg-3":6703,
"RPN5g1-RSC4-TRg-2":6704,
"RPN5g1-RSC4-TRg-1":6705,
"RPN5g1-TIF34-TRg-2":6706,
"RPN5g1-BET1-NRg-1":6707,
"RPN5g1-CDC8-NRg-2":6708,
"RPN5g1-PRP42-TRg-2":6709,
"RPN5g1-RRB1-TRg-2":6710,
"RPN5g1-SPC24-TRg-1":6711,
"RPN5g1-ILS1-NRg-1":6712,
"RPN5g1-GFA1-TRg-2":6713,
"RPN5g1-SEC21-NRg-10":6714,
"RPN5g1-RPC10-NRg-1":6715,
"RPN5g1-RPB10-TRg-3":6716,
"RPN5g1-RPB10-TRg-2":6717,
"RPN5g1-YNL181W-TRg-1":6718,
"RPN5g1-RAD3-NRg-1":6719,
"RPN5g1-NOP10-TRg-1":6720,
"RPN5g1-BFR2-TRg-3":6721,
"RPN5g1-MCM2-TRg-6":6722,
"RPN5g1-MCM2-TRg-4":6723,
"RPN5g1-MPP10-TRg-1":6724,
"RPN5g1-RET2-TRg-4":6725,
"RPN5g1-RET2-TRg-1":6726,
"RPN5g1-RPS2-NRg-1":6727,
"RPN5g1-RPS2-NRg-2":6728,
"RPN5g1-ORC4-NRg-3":6729,
"RPN5g1-TIP20-TRg-7":6730,
"RPN5g1-SMT3-TRg-1":6731,
"RPN5g1-MSS18-NRg-6":6732,
"RPN5g1-YEF3-NRg-9":6733,
"RPN5g1-ASK1-NRg-1":6734,
"RPN5g1-SMC1-TRg-1":6735,
"RPN5g1-NIP1-NRg-1":6736,
"RPN5g1-RPP1-NRg-1":6737,
"RPN5g1-YDJ1-TRg-6":6738,
"RPN5g1-SUB2-NRg-1":6739,
"RPN5g1-TIM10-NRg-8":6740,
"RPN5g1-TIM10-NRg-4":6741,
"RPN5g1-TIM10-NRg-7":6742,
"RPN5g1-SKI6-TRg-4":6743,
"RPN5g1-TUB4-TRg-1":6744,
"RPN5g1-CDC37-NRg-2":6745,
"RPN5g1-ISD11-TRg-3":6746,
"RPN5g1-YOS1-TRg-4":6747,
"RPN5g1-SSC1-TRg-6":6748,
"RPN5g1-MTR3-TRg-5":6749,
"RPN5g1-MTR3-TRg-6":6750,
"RPN5g1-TFA1-TRg-2":6751,
"RPN5g1-CDC3-NRg-3":6752,
"RPN5g1-ERG25-TA-18":6753,
"RPN5g1-RPB11-TRg-4":6754,
"RPN5g1-RPB11-TRg-1":6755,
"RPN5g1-RPB11-TRg-2":6756,
"RPN5g1-DED1-TRg-3":6757,
"RPN5g1-DED1-TRg-1":6758,
"RPN5g1-DED1-TRg-6":6759,
"RPN5g1-DED1-TRg-4":6760,
"RPN5g1-RPL10-NRg-5":6761,
"RPN5g1-RPL10-NRg-4":6762,
"RPN5g1-EFB1-NRg-1":6763,
"RPN5g1-EFB1-NRg-5":6764,
"RPN5g1-EFB1-NRg-4":6765,
"RPN5g1-RPT3-NRg-1":6766,
"RPN5g1-SAC6-TRg-8":6767,
"RPN5g1-SAC6-TRg-4":6768,
"RPN5g1-SAC6-TRg-5":6769,
"RPN5g1-SAC6-TRg-3":6770,
"RPN5g1-DIM1-TRg-5":6771,
"RPN5g1-DIM1-TRg-7":6772,
"RPN5g1-RPC17-NRg-1":6773,
"RPN5g1-RPC17-NRg-2":6774,
"RPN5g1-YDR341C-TRg-1":6775,
"RPN5g1-RAP1-NRg-8":6776,
"RPN5g1-RAP1-NRg-5":6777,
"RPN5g1-RAP1-NRg-2":6778,
"RPN5g1-SEC26-NRg-3":6779,
"RPN5g1-SPP41-TRg-3":6780,
"RPN5g1-TAP42-NRg-1":6781,
"RPN5g1-PGA2-TRg-6":6782,
"RPN5g1-BRL1-TRg-1":6783,
"RPN5g1-FOL2-TRg-1":6784,
"RPN5g1-NAB3-NRg-5":6785,
"RPN5g1-SNF4-TRg-4":6786,
"RPN5g1-HRR25-TRg-2":6787,
"RPN5g1-TRS23-TRg-4":6788,
"RPN5g1-CTR86-TRg-4":6789,
"RPN5g1-RPB5-TRg-5":6790,
"RPN5g1-SPN1-NRg-2":6791,
"RPN5g1-SPN1-NRg-1":6792,
"RPN5g1-SEC61-NRg-1":6793,
"RPN5g1-SEC61-NRg-7":6794,
"RPN5g1-TUS1-TRg-3":6795,
"RPN5g1-OLE1-NRg-2":6796,
"RPN5g1-AFG2-TRg-1":6797,
"RPN5g1-TOA2-NRg-1":6798,
"RPN5g1-USO1-TRg-1":6799,
"RPN5g1-UTP22-NRg-2":6800,
"RPN5g1-RIB1-TRg-3":6801,
"RPN5g1-RIB1-TRg-7":6802,
"RPN5g1-RIB1-TRg-4":6803,
"RPN5g1-COG1-TRg-1":6804,
"RPN5g1-RPL32-NRg-2":6805,
"RPN5g1-GLC7-NRg-3":6806,
"RPN5g1-GLC7-NRg-4":6807,
"RPN5g1-HSF1-TRg-2":6808,
"RPN5g1-DAM1-NRg-5":6809,
"RPN5g1-SEC18-TRg-4":6810,
"RPN5g1-SEC18-TRg-5":6811,
"RPN5g1-PAB1-NRg-3":6812,
"RPN5g1-POP8-TRg-2":6813,
"RPN5g1-PAB1-NRg-4":6814,
"RPN5g1-BIG1-TRg-4":6815,
"RPN5g1-BIG1-TRg-5":6816,
"RPN5g1-BIG1-TRg-6":6817,
"RPN5g1-RPO41-NRg-1":6818,
"RPN5g1-RVB2-NRg-2":6819,
"RPN5g1-PET117-NRg-8":6820,
"RPN5g1-VPS45-NRg-9":6821,
"RPN5g1-YCG1-NRg-1":6822,
"RPN5g1-NOC4-NRg-1":6823,
"RPN5g1-NMD3-NRg-2":6824,
"RPN5g1-DRS1-TRg-2":6825,
"RPN5g1-HTB1-NRg-2":6826,
"RPN5g1-IPI1-TRg-2":6827,
"RPN5g1-SEC18-NRg-1":6828,
"RPN5g1-SEC18-NRg-2":6829,
"RPN5g1-JIP5-NRg-2":6830,
"RPN5g1-YPT1-TRg-3":6831,
"RPN5g1-YPT1-TRg-2":6832,
"RPN5g1-CLF1-NRg-2":6833,
"RPN5g1-SNF2-NRg-7":6834,
"RPN5g1-SNF2-NRg-4":6835,
"RPN5g1-RPL25-NRg-1":6836,
"RPN5g1-NOP56-TRg-1":6837,
"RPN5g1-NOP56-TRg-2":6838,
"RPN5g1-TRS31-TRg-1":6839,
"RPN5g1-DBF4-TRg-2":6840,
"RPN5g1-DBF4-TRg-1":6841,
"RPN5g1-RPC19-TRg-4":6842,
"RPN5g1-RPC19-TRg-6":6843,
"RPN5g1-RPC19-TRg-3":6844,
"RPN5g1-ROK1-NRg-1":6845,
"RPN5g1-CDC33-TRg-4":6846,
"RPN5g1-DHR2-TRg-3":6847,
"RPN5g1-RRP42-NRg-5":6848,
"RPN5g1-CLF1-TRg-1":6849,
"RPN5g1-ERG11-NA-16":6850,
"RPN5g1-VAS1-NRg-4":6851,
"RPN5g1-PIK1-NRg-2":6852,
"RPN5g1-SAR1-NRg-7":6853,
"RPN5g1-SAR1-NRg-4":6854,
"RPN5g1-RPS3-TRg-1":6855,
"RPN5g1-YTM1-TRg-2":6856,
"RPN5g1-SUI3-NRg-5":6857,
"RPN5g1-SUI3-NRg-2":6858,
"RPN5g1-RRP7-TRg-4":6859,
"RPN5g1-RRP7-TRg-6":6860,
"RPN5g1-NIP7-TRg-2":6861,
"RPN5g1-MDM35-TRg-1":6862,
"RPN5g1-ALA1-NRg-1":6863,
"RPN5g1-DOA4-NRg-2":6864,
"RPN5g1-RPS13-NRg-1":6865,
"RPN5g1-YSF3-TRg-2":6866,
"RPN5g1-RPS2-NRg-11":6867,
"RPN5g1-SSL1-TRg-10":6868,
"RPN5g1-NIP7-TRg-1":6869,
"RPN5g1-LST8-NRg-1":6870,
"RPN5g1-TAF4-TRg-3":6871,
"RPN5g1-HAS1-TRg-2":6872,
"RPN5g1-GLC7-TRg-2":6873,
"RPN5g1-CDC45-NRg-1":6874,
"RPN5g1-SEC22-NRg-8":6875,
"RPN5g1-YOS1-TRg-2":6876,
"RPN5g1-RBA50-TRg-3":6877,
"RPN5g1-SPP41-NRg-2":6878,
"RPN5g1-PRP46-TRg-2":6879,
"RPN5g1-PGA2-NRg-1":6880,
"RPN5g1-CBF5-TRg-3":6881,
"RPN5g1-TCP1-NRg-3":6882,
"RPN5g1-TCP1-NRg-2":6883,
"RPN5g1-ERG26-NRg-2":6884,
"RPN5g1-ERG26-NRg-4":6885,
"RPN5g1-MES1-TRg-5":6886,
"RPN5g1-HTS1-TRg-2":6887,
"RPN5g1-SSS1-TRg-3":6888,
"RPN5g1-SSS1-TRg-2":6889,
"RPN5g1-SYS1-TRg-7":6890,
"RPN5g1-SYS1-TRg-2":6891,
"RPN5g1-SYS1-TRg-1":6892,
"RPN5g1-BFR2-TRg-1":6893,
"RPN5g1-EOS1-TRg-3":6894,
"RPN5g1-TAF4-NRg-1":6895,
"RPN5g1-ARL3-NRg-8":6896,
"RPN5g1-RPN5-NRg-1":6897,
"RPN5g1-TIM9-NRg-2":6898,
"RPN5g1-NUP57-NRg-3":6899,
"RPN5g1-VPS4-TRg-1":6900,
"RPN5g1-CDC3-TRg-4":6901,
"RPN5g1-BBP1-NRg-1":6902,
"RPN5g1-BBP1-NRg-2":6903,
"RPN5g1-USE1-NRg-3":6904,
"RPN5g1-CCT7-TRg-1":6905,
"RPN5g1-SAH1-TRg-3":6906,
"RPN5g1-CHS2-TRg-1":6907,
"RPN5g1-DPM1-TRg-2":6908,
"RPN5g1-BBP1-TRg-1":6909,
"RPN5g1-NRD1-TRg-4":6910,
"RPN5g1-RPB3-NRg-1":6911,
"RPN5g1-PHO85-NRg-6":6912,
"RPN5g1-SNF6-TRg-6":6913,
"RPN5g1-PRP38-NRg-2":6914,
"RPN5g1-OAR1-NRg-3":6915,
"RPN5g1-ROX3-NRg-1":6916,
"RPN5g1-YPP1-TRg-6":6917,
"RPN5g1-CBF2-NRg-8":6918,
"RPN5g1-SPT6-TRg-5":6919,
"RPN5g1-SEC10-NRg-1":6920,
"RPN5g1-NSL1-NRg-3":6921,
"RPN5g1-NRD1-NRg-8":6922,
"RPN5g1-RPB3-TRg-1":6923,
"RPN5g1-NRD1-NRg-4":6924,
"RPN5g1-RVB1-TRg-2":6925,
"RPN5g1-TIF5-NRg-8":6926,
"RPN5g1-EOS1-NRg-1":6927,
"RPN5g1-ERG25-NA-26":6928,
"RPN5g1-MSL5-NRg-4":6929,
"RPN5g1-SEC24-TRg-2":6930,
"RPN5g1-RPL30-NRg-5":6931,
"RPN5g1-SNU71-NRg-3":6932,
"RPN5g1-CDC33-NRg-1":6933,
"RPN5g1-RPN6-TRg-4":6934,
"RPN5g1-NAB2-TRg-4":6935,
"RPN5g1-NAB2-TRg-6":6936,
"RPN5g1-YTM1-NRg-1":6937,
"RPN5g1-OLE1-TRg-8":6938,
"RPN5g1-OLE1-TRg-1":6939,
"RPN5g1-UTP7-TRg-4":6940,
"RPN5g1-ACT1-NRg-6":6941,
"RPN5g1-RPL18A-NRg-3":6942,
"RPN5g1-BRX1-NRg-1":6943,
"RPN5g1-NAF1-TRg-8":6944,
"RPN5g1-NAF1-TRg-6":6945,
"RPN5g1-NAF1-TRg-4":6946,
"RPN5g1-CDC8-TRg-2":6947,
"RPN5g1-NSE4-TRg-1":6948,
"RPN5g1-PAB1-NRg-2":6949,
"RPN5g1-PRP43-TRg-4":6950,
"RPN5g1-SEC2-NRg-3":6951,
"RPN5g1-SEC2-NRg-6":6952,
"RPN5g1-MPP10-NRg-5":6953,
"RPN5g1-YDR355C-TRg-2":6954,
"RPN5g1-YLR339C-TRg-9":6955,
"RPN5g1-SNM1-TRg-2":6956,
"RPN5g1-ALR1-NRg-4":6957,
"RPN5g1-ALR1-NRg-1":6958,
"RPN5g1-ALR1-NRg-3":6959,
"RPN5g1-RPL10-TRg-1":6960,
"RPN5g1-RPL28-TRg-2":6961,
"RPN5g1-UTP25-TRg-1":6962,
"RPN5g1-POB3-TRg-1":6963,
"RPN5g1-POB3-TRg-3":6964,
"RPN5g1-POB3-TRg-2":6965,
"RPN5g1-MED11-TRg-1":6966,
"RPN5g1-ISA1-TRg-15":6967,
"RPN5g1-RRP1-NRg-1":6968,
"RPN5g1-MES1-NRg-1":6969,
"RPN5g1-SEC13-NRg-5":6970,
"RPN5g1-MCM2-NRg-2":6971,
"RPN5g1-ALA1-TRg-4":6972,
"RPN5g1-MTG2-TRg-5":6973,
"RPN5g1-TIF35-NRg-3":6974,
"RPN5g1-NSE1-TRg-3":6975,
"RPN5g1-NSE1-TRg-4":6976,
"RPN5g1-MOB2-NRg-6":6977,
"RPN5g1-VRG4-NRg-3":6978,
"RPN5g1-PRP9-TRg-3":6979,
"RPN5g1-HYM1-TRg-5":6980,
"RPN5g1-POP1-TRg-5":6981,
"RPN5g1-POP1-TRg-9":6982,
"RPN5g1-RPL17A-TRg-1":6983,
"RPN5g1-SLD2-TRg-1":6984,
"RPN5g1-CDC48-NRg-7":6985,
"RPN5g1-FHL1-NRg-2":6986,
"RPN5g1-BET3-NRg-7":6987,
"RPN5g1-MAK21-TRg-1":6988,
"RPN5g1-BRN1-TRg-4":6989,
"RPN5g1-FBA1-NRg-3":6990,
"RPN5g1-CDC42-TRg-6":6991,
"RPN5g1-CDC42-TRg-7":6992,
"RPN5g1-COG4-NRg-1":6993,
"RPN5g1-ATP3-NRg-3":6994,
"RPN5g1-ATP3-NRg-2":6995,
"RPN5g1-SMP3-TRg-5":6996,
"RPN5g1-CFT2-NRg-2":6997,
"RPN5g1-FAS2-TRg-5":6998,
"RPN5g1-DBP2-NRg-3":6999,
"RPN5g1-DBP2-NRg-2":7000,
"RPN5g1-MPS2-NRg-4":7001,
"RPN5g1-ARC35-TRg-2":7002,
"RPN5g1-ARC35-TRg-5":7003,
"RPN5g1-MRD1-TRg-1":7004,
"RPN5g1-RLP7-TRg-1":7005,
"RPN5g1-SPC34-TRg-1":7006,
"RPN5g1-CDC45-TRg-2":7007,
"RPN5g1-GCD6-TRg-3":7008,
"RPN5g1-GCD6-TRg-4":7009,
"RPN5g1-YPT6-NRg-2":7010,
"RPN5g1-RPS13-TRg-2":7011,
"RPN5g1-IPI3-TRg-3":7012,
"RPN5g1-TIF5-NRg-9":7013,
"RPN5g1-TIF5-NRg-7":7014,
"RPN5g1-TIF5-NRg-6":7015,
"RPN5g1-NAB3-TRg-3":7016,
"RPN5g1-GCD2-TRg-1":7017,
"RPN5g1-UBA1-TRg-2":7018,
"RPN5g1-SLD3-TRg-6":7019,
"RPN5g1-LCB1-TRg-5":7020,
"RPN5g1-TOA2-TRg-6":7021,
"RPN5g1-TOA2-TRg-1":7022,
"RPN5g1-TOA2-TRg-3":7023,
"RPN5g1-LSM2-TRg-1":7024,
"RPN5g1-YML6-TRg-13":7025,
"RPN5g1-YML6-TRg-12":7026,
"RPN5g1-UTP15-NRg-1":7027,
"RPN5g1-TIF6-NRg-8":7028,
"RPN5g1-SUP35-NRg-1":7029,
"RPN5g1-MPP10-NRg-1":7030,
"RPN5g1-SWI3-TRg-7":7031,
"RPN5g1-SSN3-NRg-2":7032,
"RPN5g1-SEC13-NRg-7":7033,
"RPN5g1-RPS15-NRg-3":7034,
"RPN5g1-RPL3-TRg-2":7035,
"RPN5g1-FBA1-NRg-2":7036,
"RPN5g1-FBA1-NRg-1":7037,
"RPN5g1-FBA1-NRg-5":7038,
"RPN5g1-DAM1-TRg-2":7039,
"RPN5g1-NHP2-TRg-2":7040,
"RPN5g1-HCA4-NRg-6":7041,
"RPN5g1-PRE3-TRg-4":7042,
"RPN5g1-DBP5-NRg-4":7043,
"RPN5g1-SPT6-NRg-4":7044,
"RPN5g1-SPT6-NRg-2":7045,
"RPN5g1-RPL18A-TRg-4":7046,
"RPN5g1-KSH1-TRg-1":7047,
"RPN5g1-KSH1-TRg-3":7048,
"RPN5g1-IPI3-NRg-1":7049,
"RPN5g1-PGA2-TRg-8":7050,
"RPN5g1-RPL18A-TRg-2":7051,
"RPN5g1-RPL33A-NRg-6":7052,
"RPN5g1-TAF12-NRg-2":7053,
"RPN5g1-USE1-TRg-5":7054,
"RPN5g1-YNL114C-TRg-1":7055,
"RPN5g1-SMC5-TRg-7":7056,
"RPN5g1-SMC5-TRg-6":7057,
"RPN5g1-RSC58-TRg-1":7058,
"RPN5g1-CTF13-TRg-2":7059,
"RPN5g1-NAB2-NRg-2":7060,
"RPN5g1-MCM7-TRg-4":7061,
"RPN5g1-BCP1-NRg-5":7062,
"RPN5g1-STU2-TRg-3":7063,
"RPN5g1-SEC21-NRg-6":7064,
"RPN5g1-SEC21-NRg-3":7065,
"RPN5g1-RPL1B-TRg-3":7066,
"RPN5g1-SEC20-NRg-2":7067,
"RPN5g1-VMA3-NRg-2":7068,
"RPN5g1-SEC23-NRg-5":7069,
"RPN5g1-CDC28-TRg-4":7070,
"RPN5g1-RPN12-NRg-11":7071,
"RPN5g1-PUP3-TRg-3":7072,
"RPN5g1-SEC31-TRg-2":7073,
"RPN5g1-SED5-TRg-6":7074,
"RPN5g1-SED5-TRg-5":7075,
"RPN5g1-RPL33A-TRg-1":7076,
"RPN5g1-RPL33A-TRg-2":7077,
"RPN5g1-MRPL11-TRg-2":7078,
"RPN5g1-RTP1-NRg-2":7079,
"RPN5g1-NUG1-TRg-2":7080,
"RPN5g1-VPH2-TRg-4":7081,
"RPN5g1-COP1-NRg-3":7082,
"RPN5g1-CRM1-NRg-1":7083,
"RPN5g1-RPL5-NRg-4":7084,
"RPN5g1-SNU13-NRg-4":7085,
"RPN5g1-PFS2-TRg-3":7086,
"RPN5g1-MPP10-TRg-2":7087,
"RPN5g1-TSR4-NRg-2":7088,
"RPN5g1-RSC2-TRg-1":7089,
"RPN5g1-SEC65-TRg-2":7090,
"RPN5g1-SMI1-NRg-1":7091,
"RPN5g1-RTT105-NRg-4":7092,
"RPN5g1-VMA5-TRg-3":7093,
"RPN5g1-VMA5-TRg-5":7094,
"RPN5g1-RRP1-TRg-3":7095,
"RPN5g1-CLC1-TRg-2":7096,
"RPN5g1-GCD6-NRg-1":7097,
"RPN5g1-GCD6-NRg-2":7098,
"RPN5g1-PXR1-TRg-1":7099,
"RPN5g1-CDC14-NRg-1":7100,
"RPN5g1-PCF11-TRg-6":7101,
"RPN5g1-PCF11-TRg-5":7102,
"RPN5g1-PCF11-TRg-4":7103,
"RPN5g1-SEC31-NRg-1":7104,
"RPN5g1-RRP5-NRg-1":7105,
"RPN5g1-PRE10-TRg-5":7106,
"RPN5g1-PRE10-TRg-1":7107,
"RPN5g1-RPS5-TRg-2":7108,
"RPN5g1-NSP1-TRg-4":7109,
"RPN5g1-PRP38-TRg-4":7110,
"RPN5g1-RCF1-NRg-5":7111,
"RPN5g1-RSC3-TRg-4":7112,
"RPN5g1-RSC3-TRg-5":7113,
"RPN5g1-RSC3-TRg-6":7114,
"RPN5g1-HTA1-NRg-12":7115,
"RPN5g1-HTA1-NRg-11":7116,
"RPN5g1-UTP23-TRg-2":7117,
"RPN5g1-GCD7-NRg-1":7118,
"RPN5g1-GCD7-NRg-2":7119,
"RPN5g1-GCD7-NRg-6":7120,
"RPN5g1-GAL11-NRg-2":7121,
"RPN5g1-GAL11-NRg-9":7122,
"RPN5g1-PHO4-TRg-5":7123,
"RPN5g1-SNP1-NRg-3":7124,
"RPN5g1-RPC37-TRg-5":7125,
"RPN5g1-CRM1-TRg-5":7126,
"RPN5g1-CRM1-TRg-2":7127,
"RPN5g1-ASK1-TRg-7":7128,
"RPN5g1-STU2-NRg-4":7129,
"RPN5g1-NEO1-NRg-3":7130,
"RPN5g1-GAL11-TRg-5":7131,
"RPN5g1-GAL11-TRg-7":7132,
"RPN5g1-SAM50-NRg-3":7133,
"RPN5g1-CSL4-TRg-2":7134,
"RPN5g1-CCT5-TRg-2":7135,
"RPN5g1-POL30-NRg-1":7136,
"RPN5g1-MED4-TRg-4":7137,
"RPN5g1-MED4-TRg-3":7138,
"RPN5g1-MED4-TRg-2":7139,
"RPN5g1-GDI1-TRg-4":7140,
"RPN5g1-GDI1-TRg-3":7141,
"RPN5g1-REB1-TRg-6":7142,
"RPN5g1-MRPL37-NRg-2":7143,
"RPN5g1-NOC3-TRg-3":7144,
"RPN5g1-SPC97-TRg-3":7145,
"RPN5g1-IPP1-TRg-3":7146,
"RPN5g1-IPP1-TRg-2":7147,
"RPN5g1-PTI1-TRg-3":7148,
"RPN5g1-PTI1-TRg-5":7149,
"RPN5g1-RFC5-NRg-1":7150,
"RPN5g1-CDC24-TRg-1":7151,
"RPN5g1-CDC24-TRg-3":7152,
"RPN5g1-CDC24-TRg-5":7153,
"RPN5g1-CDC24-TRg-6":7154,
"RPN5g1-UTP23-TRg-6":7155,
"RPN5g1-UTP23-TRg-4":7156,
"RPN5g1-UTP23-TRg-1":7157,
"RPN5g1-RHO3-NRg-4":7158,
"RPN5g1-TRS23-NRg-1":7159,
"RPN5g1-TRS23-NRg-3":7160,
"RPN5g1-RSP5-TRg-2":7161,
"RPN5g1-RSP5-TRg-1":7162,
"RPN5g1-SDA1-NRg-1":7163,
"RPN5g1-KAP95-TRg-8":7164,
"RPN5g1-ACO1-TRg-6":7165,
"RPN5g1-HTA1-NRg-3":7166,
"RPN5g1-HTA1-NRg-2":7167,
"RPN5g1-SPN1-TRg-1":7168,
"RPN5g1-MOT1-NRg-7":7169,
"RPN5g1-RPL17A-NRg-4":7170,
"RPN5g1-ADA2-TRg-4":7171,
"RPN5g1-SFH1-NRg-1":7172,
"RPN5g1-SPC97-NRg-5":7173,
"RPN5g1-PRP22-TRg-3":7174,
"RPN5g1-SEN15-TRg-2":7175,
"RPN5g1-RPL3-NRg-2":7176,
"RPN5g1-ISD11-NRg-2":7177,
"RPN5g1-HEM12-TRg-8":7178,
"RPN5g1-SEC10-TRg-1":7179,
"RPN5g1-HTB1-TRg-7":7180,
"RPN5g1-TTI2-TRg-1":7181,
"RPN5g1-ACP1-TRg-2":7182,
"RPN5g1-ACP1-TRg-4":7183,
"RPN5g1-GAL11-NRg-10":7184,
"RPN5g1-UTP22-TRg-2":7185,
"RPN5g1-MST1-NRg-5":7186,
"RPN5g1-RIB7-NRg-2":7187,
"RPN5g1-MCD1-TRg-6":7188,
"RPN5g1-MCD1-TRg-5":7189,
"RPN5g1-GPI8-NRg-2":7190,
"RPN5g1-THS1-TRg-2":7191,
"RPN5g1-RRP7-TRg-2":7192,
"RPN5g1-RRP7-TRg-5":7193,
"RPN5g1-SMX2-NRg-7":7194,
"RPN5g1-RRP45-TRg-5":7195,
"RPN5g1-RRP45-TRg-4":7196,
"RPN5g1-CNS1-TRg-2":7197,
"RPN5g1-FBP1-NRg-9":7198,
"RPN5g1-GCD11-NRg-1":7199,
"RPN5g1-RPL10-TRg-2":7200,
"RPN5g1-NUP192-TRg-4":7201,
"RPN5g1-NUP145-NRg-4":7202,
"RPN5g1-HEM12-TRg-6":7203,
"RPN5g1-PLC1-TRg-3":7204,
"RPN5g1-RPA43-TRg-1":7205,
"RPN5g1-RPB7-NRg-2":7206,
"RPN5g1-RPB7-NRg-3":7207,
"RPN5g1-NSL1-NRg-1":7208,
"RPN5g1-UTP6-TRg-3":7209,
"RPN5g1-UTP6-TRg-1":7210,
"RPN5g1-YJU2-TRg-5":7211,
"RPN5g1-FRS2-NRg-5":7212,
"RPN5g1-TIF35-NRg-2":7213,
"RPN5g1-GPI15-TRg-1":7214,
"RPN5g1-NOP1-NRg-5":7215,
"RPN5g1-GPI15-TRg-4":7216,
"RPN5g1-COG4-TRg-1":7217,
"RPN5g1-TFA1-TRg-1":7218,
"RPN5g1-RHO1-NRg-2":7219,
"RPN5g1-RHO1-NRg-1":7220,
"RPN5g1-CDC55-NRg-2":7221,
"RPN5g1-IDI1-NRg-7":7222,
"RPN5g1-RPL32-TRg-5":7223,
"RPN5g1-RPB5-TRg-4":7224,
"RPN5g1-DIP2-TRg-5":7225,
"RPN5g1-DIP2-TRg-1":7226,
"RPN5g1-RPC40-TRg-2":7227,
"RPN5g1-CDC6-TRg-5":7228,
"RPN5g1-CDC6-TRg-3":7229,
"RPN5g1-DAD2-TRg-2":7230,
"RPN5g1-RVS161-TRg-2":7231,
"RPN5g1-RVS161-TRg-1":7232,
"RPN5g1-SUP45-NRg-3":7233,
"RPN5g1-SRB6-NRg-5":7234,
"RPN5g1-RPC11-TRg-4":7235,
"RPN5g1-RKI1-TRg-8":7236,
"RPN5g1-NIP7-TRg-3":7237,
"RPN5g1-RPL33A-NRg-12":7238,
"RPN5g1-SAM50-TRg-4":7239,
"RPN5g1-NOP4-NRg-1":7240,
"RPN5g1-NOP4-NRg-3":7241,
"RPN5g1-SMX2-TRg-5":7242,
"RPN5g1-POL12-NRg-2":7243,
"RPN5g1-BMS1-NRg-2":7244,
"RPN5g1-RPA190-TRg-5":7245,
"RPN5g1-ALG14-NRg-4":7246,
"RPN5g1-ALG14-NRg-1":7247,
"RPN5g1-PRE5-NRg-1":7248,
"RPN5g1-BIG1-NRg-2":7249,
"RPN5g1-TFA2-TRg-4":7250,
"RPN5g1-IMP4-TRg-6":7251,
"RPN5g1-PAN1-NRg-1":7252,
"RPN5g1-UTP13-TRg-2":7253,
"RPN5g1-KAE1-NRg-3":7254,
"RPN5g1-ERG20-TRg-1":7255,
"RPN5g1-CDC20-TRg-6":7256,
"RPN5g1-PWP2-NRg-2":7257,
"RPN5g1-COG1-NRg-1":7258,
"RPN5g1-RPL1B-TRg-4":7259,
"RPN5g1-RPL1B-TRg-7":7260,
"RPN5g1-UTP20-TRg-3":7261,
"RPN5g1-UTP20-TRg-4":7262,
"RPN5g1-RPL25-TRg-4":7263,
"RPN5g1-RPL25-TRg-2":7264,
"RPN5g1-MCM7-NRg-1":7265,
"RPN5g1-MRP49-TRg-5":7266,
"RPN5g1-ERO1-NRg-3":7267,
"RPN5g1-UTP5-TRg-7":7268,
"RPN5g1-MCM4-NRg-1":7269,
"RPN5g1-PRE3-NRg-1":7270,
"RPN5g1-FCF1-NRg-1":7271,
"RPN5g1-CUS1-NRg-1":7272,
"RPN5g1-PSF1-TRg-2":7273,
"RPN5g1-BCP1-TRg-2":7274,
"RPN5g1-PAN1-TRg-1":7275,
"RPN5g1-PAN1-TRg-3":7276,
"RPN5g1-PAN1-TRg-4":7277,
"RPN5g1-VPS3-TRg-2":7278,
"RPN5g1-YIL060W-NRg-1":7279,
"RPN5g1-VPS53-NRg-1":7280,
"RPN5g1-CYR1-TRg-4":7281,
"RPN5g1-CYR1-TRg-7":7282,
"RPN5g1-MPS1-NRg-1":7283,
"RPN5g1-SRP1-TRg-5":7284,
"RPN5g1-SRP1-TRg-4":7285,
"RPN5g1-TAF12-TRg-2":7286,
"RPN5g1-TAF12-TRg-3":7287,
"RPN5g1-POP4-TRg-1":7288,
"RPN5g1-SPT16-TRg-1":7289,
"RPN5g1-NUP82-TRg-4":7290,
"RPN5g1-DML1-TRg-3":7291,
"RPN5g1-RPA43-NRg-3":7292,
"RPN5g1-STU2-NRg-3":7293,
"RPN5g1-POP4-NRg-4":7294,
"RPN5g1-MCD1-TRg-2":7295,
"RPN5g1-RPS3-NRg-4":7296,
"RPN5g1-PRP9-TRg-4":7297,
"RPN5g1-RPP1-NRg-2":7298,
"RPN5g1-MTR2-NRg-11":7299,
"RPN5g1-GCD11-TRg-1":7300,
"RPN5g1-RPF1-TRg-3":7301,
"RPN5g1-SUB2-NRg-4":7302,
"RPN5g1-GPI15-TRg-3":7303,
"RPN5g1-ERG9-TRg-6":7304,
"RPN5g1-RPT2-NRg-1":7305,
"RPN5g1-YOS1-NRg-3":7306,
"RPN5g1-SCM3-TRg-4":7307,
"RPN5g1-SCM3-TRg-6":7308,
"RPN5g1-RLP7-NRg-1":7309,
"RPN5g1-TFB2-NRg-4":7310,
"RPN5g1-IMP4-TRg-1":7311,
"RPN5g1-IMP4-TRg-3":7312,
"RPN5g1-PRE4-TRg-3":7313,
"RPN5g1-SUB2-TRg-3":7314,
"RPN5g1-RPP0-NRg-4":7315,
"RPN5g1-RPP0-NRg-3":7316,
"RPN5g1-TOM40-TRg-4":7317,
"RPN5g1-FUR1-NRg-12":7318,
"RPN5g1-TOM40-TRg-2":7319,
"RPN5g1-VMA11-NRg-4":7320,
"RPN5g1-PGS1-NRg-4":7321,
"RPN5g1-URB1-TRg-4":7322,
"RPN5g1-ARP4-TRg-3":7323,
"RPN5g1-RPT3-TRg-3":7324,
"RPN5g1-SUI3-TRg-3":7325,
"RPN5g1-RFC5-NRg-2":7326,
"RPN5g1-RRP14-TRg-2":7327,
"RPN5g1-SCC2-TRg-1":7328,
"RPN5g1-SSC1-TRg-3":7329,
"RPN5g1-RRP9-TRg-3":7330,
"RPN5g1-MOT1-NRg-9":7331,
"RPN5g1-RPL42A-NRg-2":7332,
"RPN5g1-SEC16-TRg-7":7333,
"RPN5g1-IMP4-NRg-2":7334,
"RPN5g1-YEF3-NRg-4":7335,
"RPN5g1-PUP1-TRg-1":7336,
"RPN5g1-UTP22-TRg-6":7337,
"RPN5g1-DBP2-NRg-4":7338,
"RPN5g1-PRE2-TRg-7":7339,
"RPN5g1-ATP16-TRg-6":7340,
"RPN5g1-UTP13-TRg-4":7341,
"RPN5g1-DOP1-NRg-4":7342,
"RPN5g1-TIM44-TRg-3":7343,
"RPN5g1-ATP16-TRg-2":7344,
"RPN5g1-ENP1-NRg-3":7345,
"RPN5g1-NAF1-TRg-3":7346,
"RPN5g1-COG4-TRg-2":7347,
"RPN5g1-SOG2-TRg-7":7348,
"RPN5g1-YDR341C-TRg-3":7349,
"RPN5g1-YMR290W-A-TRg-10":7350,
"RPN5g1-NUP192-NRg-9":7351,
"RPN5g1-RPS31-NRg-8":7352,
"RPN5g1-SPC97-NRg-6":7353,
"RPN5g1-EBP2-NRg-1":7354,
"RPN5g1-CDC48-TRg-5":7355,
"RPN5g1-RPT1-TRg-4":7356,
"RPN5g1-ULP1-NRg-2":7357,
"RPN5g1-RPN3-TRg-6":7358,
"RPN5g1-RPT1-TRg-5":7359,
"RPN5g1-KRE5-TRg-2":7360,
"RPN5g1-TBF1-NRg-8":7361,
"RPN5g1-UTP22-NRg-4":7362,
"RPN5g1-SSC1-NRg-4":7363,
"RPN5g1-REB1-TRg-4":7364,
"RPN5g1-CDC48-NRg-9":7365,
"RPN5g1-FAS2-TRg-8":7366,
"RPN5g1-TAO3-TRg-8":7367,
"RPN5g1-CKS1-TRg-5":7368,
"RPN5g1-YLR379W-TRg-7":7369,
"RPN5g1-TEN1-NRg-2":7370,
"RPN5g1-RPL42A-TRg-2":7371,
"RPN5g1-SEC27-TRg-4":7372,
"RPN5g1-TBF1-NRg-4":7373,
"RPN5g1-RPT1-NRg-6":7374,
"RPN5g1-COG1-TRg-3":7375,
"RPN5g1-SUI1-TRg-6":7376,
"RPN5g1-TIM23-TRg-6":7377,
"RPN5g1-CDC48-NRg-6":7378,
"RPN5g1-EPL1-TRg-5":7379,
"RPN5g1-RPT5-TRg-8":7380,
"RPN5g1-ATP16-NRg-4":7381,
"RPN5g1-RPN6-TRg-3":7382,
"RPN5g1-ERG9-NRg-6":7383,
"RPN5g1-SMX3-TRg-1":7384,
"RPN5g1-NCB2-NRg-3":7385,
"RPN5g1-SEC16-NRg-12":7386,
"RPN5g1-RPN6-TRg-2":7387,
"RPN5g1-REB1-NRg-4":7388,
"RPN5g1-ATP16-TRg-9":7389,
"RPN5g1-ERG9-NRg-7":7390,
"COG3g1-RPL15A-NRg-4":7391,
"COG3g1-RPL15A-NRg-5":7392,
"COG3g1-KRE33-TRg-1":7393,
"COG3g1-PMI40-NRg-1":7394,
"COG3g1-NOP19-NRg-3":7395,
"COG3g1-SRP14-NRg-4":7396,
"COG3g1-SEC27-TRg-2":7397,
"COG3g1-GPI14-TRg-3":7398,
"COG3g1-PAH1-TRg-7":7399,
"COG3g1-PAH1-TRg-6":7400,
"COG3g1-PAH1-TRg-5":7401,
"COG3g1-PAH1-TRg-3":7402,
"COG3g1-COG3-TRg-1":7403,
"COG3g1-HTS1-NRg-5":7404,
"COG3g1-MSN5-TRg-7":7405,
"COG3g1-ERG26-TRg-1":7406,
"COG3g1-SMD2-TRg-5":7407,
"COG3g1-SMD2-TRg-4":7408,
"COG3g1-SMD2-TRg-1":7409,
"COG3g1-PRE7-TRg-4":7410,
"COG3g1-PRE7-TRg-7":7411,
"COG3g1-SEC6-TRg-3":7412,
"COG3g1-ESF2-NRg-1":7413,
"COG3g1-ESF2-NRg-3":7414,
"COG3g1-AFG2-TRg-2":7415,
"COG3g1-RRP36-TRg-3":7416,
"COG3g1-RRP36-TRg-5":7417,
"COG3g1-GCR1-NRg-2":7418,
"COG3g1-PRE4-NRg-4":7419,
"COG3g1-PRE4-NRg-9":7420,
"COG3g1-DSN1-NRg-2":7421,
"COG3g1-GPI11-TRg-3":7422,
"COG3g1-POP3-TRg-1":7423,
"COG3g1-MNE1-TRg-5":7424,
"COG3g1-RRP12-NRg-1":7425,
"COG3g1-RSC6-TRg-2":7426,
"COG3g1-CDC25-TRg-1":7427,
"COG3g1-CDC25-TRg-9":7428,
"COG3g1-YPP1-NRg-3":7429,
"COG3g1-NFS1-NRg-9":7430,
"COG3g1-NFS1-NRg-8":7431,
"COG3g1-UBA2-TRg-1":7432,
"COG3g1-ARP2-NRg-3":7433,
"COG3g1-MAK16-TRg-1":7434,
"COG3g1-CEP3-NRg-1":7435,
"COG3g1-GUK1-TRg-5":7436,
"COG3g1-GUK1-TRg-2":7437,
"COG3g1-GPI12-NRg-6":7438,
"COG3g1-RPS5-NRg-5":7439,
"COG3g1-RPS5-NRg-2":7440,
"COG3g1-RPC19-NRg-1":7441,
"COG3g1-TIM54-TRg-1":7442,
"COG3g1-TEN1-TRg-2":7443,
"COG3g1-SAH1-NRg-4":7444,
"COG3g1-SAH1-NRg-5":7445,
"COG3g1-SAH1-NRg-3":7446,
"COG3g1-ATP15-NRg-5":7447,
"COG3g1-SCD5-TRg-5":7448,
"COG3g1-ARB1-NRg-2":7449,
"COG3g1-ARB1-NRg-4":7450,
"COG3g1-PUP2-TRg-1":7451,
"COG3g1-CCT8-TRg-2":7452,
"COG3g1-MCM4-TRg-1":7453,
"COG3g1-LSM4-TRg-1":7454,
"COG3g1-NOP53-NRg-1":7455,
"COG3g1-ATP3-TRg-4":7456,
"COG3g1-AFG2-NRg-3":7457,
"COG3g1-PRO3-NRg-3":7458,
"COG3g1-NRD1-NRg-10":7459,
"COG3g1-SEC61-TRg-2":7460,
"COG3g1-RHO3-TRg-4":7461,
"COG3g1-SNF2-TRg-6":7462,
"COG3g1-SMD2-NRg-3":7463,
"COG3g1-RSC4-TRg-2":7464,
"COG3g1-RSC4-TRg-1":7465,
"COG3g1-TIF34-TRg-2":7466,
"COG3g1-BET1-NRg-1":7467,
"COG3g1-CDC8-NRg-2":7468,
"COG3g1-PRP42-TRg-2":7469,
"COG3g1-RRB1-TRg-2":7470,
"COG3g1-SPC24-TRg-1":7471,
"COG3g1-ILS1-NRg-1":7472,
"COG3g1-GFA1-TRg-2":7473,
"COG3g1-SEC21-NRg-10":7474,
"COG3g1-RPC10-NRg-1":7475,
"COG3g1-RPB10-TRg-3":7476,
"COG3g1-RPB10-TRg-2":7477,
"COG3g1-YNL181W-TRg-1":7478,
"COG3g1-RAD3-NRg-1":7479,
"COG3g1-NOP10-TRg-1":7480,
"COG3g1-BFR2-TRg-3":7481,
"COG3g1-MCM2-TRg-6":7482,
"COG3g1-MCM2-TRg-4":7483,
"COG3g1-MPP10-TRg-1":7484,
"COG3g1-RET2-TRg-4":7485,
"COG3g1-RET2-TRg-1":7486,
"COG3g1-RPS2-NRg-1":7487,
"COG3g1-RPS2-NRg-2":7488,
"COG3g1-ORC4-NRg-3":7489,
"COG3g1-TIP20-TRg-7":7490,
"COG3g1-SMT3-TRg-1":7491,
"COG3g1-MSS18-NRg-6":7492,
"COG3g1-YEF3-NRg-9":7493,
"COG3g1-ASK1-NRg-1":7494,
"COG3g1-SMC1-TRg-1":7495,
"COG3g1-NIP1-NRg-1":7496,
"COG3g1-RPP1-NRg-1":7497,
"COG3g1-YDJ1-TRg-6":7498,
"COG3g1-SUB2-NRg-1":7499,
"COG3g1-TIM10-NRg-8":7500,
"COG3g1-TIM10-NRg-4":7501,
"COG3g1-TIM10-NRg-7":7502,
"COG3g1-SKI6-TRg-4":7503,
"COG3g1-TUB4-TRg-1":7504,
"COG3g1-CDC37-NRg-2":7505,
"COG3g1-ISD11-TRg-3":7506,
"COG3g1-YOS1-TRg-4":7507,
"COG3g1-SSC1-TRg-6":7508,
"COG3g1-MTR3-TRg-5":7509,
"COG3g1-MTR3-TRg-6":7510,
"COG3g1-TFA1-TRg-2":7511,
"COG3g1-CDC3-NRg-3":7512,
"COG3g1-ERG25-TA-18":7513,
"COG3g1-RPB11-TRg-4":7514,
"COG3g1-RPB11-TRg-1":7515,
"COG3g1-RPB11-TRg-2":7516,
"COG3g1-DED1-TRg-3":7517,
"COG3g1-DED1-TRg-1":7518,
"COG3g1-DED1-TRg-6":7519,
"COG3g1-DED1-TRg-4":7520,
"COG3g1-RPL10-NRg-5":7521,
"COG3g1-RPL10-NRg-4":7522,
"COG3g1-EFB1-NRg-1":7523,
"COG3g1-EFB1-NRg-5":7524,
"COG3g1-EFB1-NRg-4":7525,
"COG3g1-RPT3-NRg-1":7526,
"COG3g1-SAC6-TRg-8":7527,
"COG3g1-SAC6-TRg-4":7528,
"COG3g1-SAC6-TRg-5":7529,
"COG3g1-SAC6-TRg-3":7530,
"COG3g1-DIM1-TRg-5":7531,
"COG3g1-DIM1-TRg-7":7532,
"COG3g1-RPC17-NRg-1":7533,
"COG3g1-RPC17-NRg-2":7534,
"COG3g1-YDR341C-TRg-1":7535,
"COG3g1-RAP1-NRg-8":7536,
"COG3g1-RAP1-NRg-5":7537,
"COG3g1-RAP1-NRg-2":7538,
"COG3g1-SEC26-NRg-3":7539,
"COG3g1-SPP41-TRg-3":7540,
"COG3g1-TAP42-NRg-1":7541,
"COG3g1-PGA2-TRg-6":7542,
"COG3g1-BRL1-TRg-1":7543,
"COG3g1-FOL2-TRg-1":7544,
"COG3g1-NAB3-NRg-5":7545,
"COG3g1-SNF4-TRg-4":7546,
"COG3g1-HRR25-TRg-2":7547,
"COG3g1-TRS23-TRg-4":7548,
"COG3g1-CTR86-TRg-4":7549,
"COG3g1-RPB5-TRg-5":7550,
"COG3g1-SPN1-NRg-2":7551,
"COG3g1-SPN1-NRg-1":7552,
"COG3g1-SEC61-NRg-1":7553,
"COG3g1-SEC61-NRg-7":7554,
"COG3g1-TUS1-TRg-3":7555,
"COG3g1-OLE1-NRg-2":7556,
"COG3g1-AFG2-TRg-1":7557,
"COG3g1-TOA2-NRg-1":7558,
"COG3g1-USO1-TRg-1":7559,
"COG3g1-UTP22-NRg-2":7560,
"COG3g1-RIB1-TRg-3":7561,
"COG3g1-RIB1-TRg-7":7562,
"COG3g1-RIB1-TRg-4":7563,
"COG3g1-COG1-TRg-1":7564,
"COG3g1-RPL32-NRg-2":7565,
"COG3g1-GLC7-NRg-3":7566,
"COG3g1-GLC7-NRg-4":7567,
"COG3g1-HSF1-TRg-2":7568,
"COG3g1-DAM1-NRg-5":7569,
"COG3g1-SEC18-TRg-4":7570,
"COG3g1-SEC18-TRg-5":7571,
"COG3g1-PAB1-NRg-3":7572,
"COG3g1-POP8-TRg-2":7573,
"COG3g1-PAB1-NRg-4":7574,
"COG3g1-BIG1-TRg-4":7575,
"COG3g1-BIG1-TRg-5":7576,
"COG3g1-BIG1-TRg-6":7577,
"COG3g1-RPO41-NRg-1":7578,
"COG3g1-RVB2-NRg-2":7579,
"COG3g1-PET117-NRg-8":7580,
"COG3g1-VPS45-NRg-9":7581,
"COG3g1-YCG1-NRg-1":7582,
"COG3g1-NOC4-NRg-1":7583,
"COG3g1-NMD3-NRg-2":7584,
"COG3g1-DRS1-TRg-2":7585,
"COG3g1-HTB1-NRg-2":7586,
"COG3g1-IPI1-TRg-2":7587,
"COG3g1-SEC18-NRg-1":7588,
"COG3g1-SEC18-NRg-2":7589,
"COG3g1-JIP5-NRg-2":7590,
"COG3g1-YPT1-TRg-3":7591,
"COG3g1-YPT1-TRg-2":7592,
"COG3g1-CLF1-NRg-2":7593,
"COG3g1-SNF2-NRg-7":7594,
"COG3g1-SNF2-NRg-4":7595,
"COG3g1-RPL25-NRg-1":7596,
"COG3g1-NOP56-TRg-1":7597,
"COG3g1-NOP56-TRg-2":7598,
"COG3g1-TRS31-TRg-1":7599,
"COG3g1-DBF4-TRg-2":7600,
"COG3g1-DBF4-TRg-1":7601,
"COG3g1-RPC19-TRg-4":7602,
"COG3g1-RPC19-TRg-6":7603,
"COG3g1-RPC19-TRg-3":7604,
"COG3g1-ROK1-NRg-1":7605,
"COG3g1-CDC33-TRg-4":7606,
"COG3g1-DHR2-TRg-3":7607,
"COG3g1-RRP42-NRg-5":7608,
"COG3g1-CLF1-TRg-1":7609,
"COG3g1-ERG11-NA-16":7610,
"COG3g1-VAS1-NRg-4":7611,
"COG3g1-PIK1-NRg-2":7612,
"COG3g1-SAR1-NRg-7":7613,
"COG3g1-SAR1-NRg-4":7614,
"COG3g1-RPS3-TRg-1":7615,
"COG3g1-YTM1-TRg-2":7616,
"COG3g1-SUI3-NRg-5":7617,
"COG3g1-SUI3-NRg-2":7618,
"COG3g1-RRP7-TRg-4":7619,
"COG3g1-RRP7-TRg-6":7620,
"COG3g1-NIP7-TRg-2":7621,
"COG3g1-MDM35-TRg-1":7622,
"COG3g1-ALA1-NRg-1":7623,
"COG3g1-DOA4-NRg-2":7624,
"COG3g1-RPS13-NRg-1":7625,
"COG3g1-YSF3-TRg-2":7626,
"COG3g1-RPS2-NRg-11":7627,
"COG3g1-SSL1-TRg-10":7628,
"COG3g1-NIP7-TRg-1":7629,
"COG3g1-LST8-NRg-1":7630,
"COG3g1-TAF4-TRg-3":7631,
"COG3g1-HAS1-TRg-2":7632,
"COG3g1-GLC7-TRg-2":7633,
"COG3g1-CDC45-NRg-1":7634,
"COG3g1-SEC22-NRg-8":7635,
"COG3g1-YOS1-TRg-2":7636,
"COG3g1-RBA50-TRg-3":7637,
"COG3g1-SPP41-NRg-2":7638,
"COG3g1-PRP46-TRg-2":7639,
"COG3g1-PGA2-NRg-1":7640,
"COG3g1-CBF5-TRg-3":7641,
"COG3g1-TCP1-NRg-3":7642,
"COG3g1-TCP1-NRg-2":7643,
"COG3g1-ERG26-NRg-2":7644,
"COG3g1-ERG26-NRg-4":7645,
"COG3g1-MES1-TRg-5":7646,
"COG3g1-HTS1-TRg-2":7647,
"COG3g1-SSS1-TRg-3":7648,
"COG3g1-SSS1-TRg-2":7649,
"COG3g1-SYS1-TRg-7":7650,
"COG3g1-SYS1-TRg-2":7651,
"COG3g1-SYS1-TRg-1":7652,
"COG3g1-BFR2-TRg-1":7653,
"COG3g1-EOS1-TRg-3":7654,
"COG3g1-TAF4-NRg-1":7655,
"COG3g1-ARL3-NRg-8":7656,
"COG3g1-RPN5-NRg-1":7657,
"COG3g1-TIM9-NRg-2":7658,
"COG3g1-NUP57-NRg-3":7659,
"COG3g1-VPS4-TRg-1":7660,
"COG3g1-CDC3-TRg-4":7661,
"COG3g1-BBP1-NRg-1":7662,
"COG3g1-BBP1-NRg-2":7663,
"COG3g1-USE1-NRg-3":7664,
"COG3g1-CCT7-TRg-1":7665,
"COG3g1-SAH1-TRg-3":7666,
"COG3g1-CHS2-TRg-1":7667,
"COG3g1-DPM1-TRg-2":7668,
"COG3g1-BBP1-TRg-1":7669,
"COG3g1-NRD1-TRg-4":7670,
"COG3g1-RPB3-NRg-1":7671,
"COG3g1-PHO85-NRg-6":7672,
"COG3g1-SNF6-TRg-6":7673,
"COG3g1-PRP38-NRg-2":7674,
"COG3g1-OAR1-NRg-3":7675,
"COG3g1-ROX3-NRg-1":7676,
"COG3g1-YPP1-TRg-6":7677,
"COG3g1-CBF2-NRg-8":7678,
"COG3g1-SPT6-TRg-5":7679,
"COG3g1-SEC10-NRg-1":7680,
"COG3g1-NSL1-NRg-3":7681,
"COG3g1-NRD1-NRg-8":7682,
"COG3g1-RPB3-TRg-1":7683,
"COG3g1-NRD1-NRg-4":7684,
"COG3g1-RVB1-TRg-2":7685,
"COG3g1-TIF5-NRg-8":7686,
"COG3g1-EOS1-NRg-1":7687,
"COG3g1-ERG25-NA-26":7688,
"COG3g1-MSL5-NRg-4":7689,
"COG3g1-SEC24-TRg-2":7690,
"COG3g1-RPL30-NRg-5":7691,
"COG3g1-SNU71-NRg-3":7692,
"COG3g1-CDC33-NRg-1":7693,
"COG3g1-RPN6-TRg-4":7694,
"COG3g1-NAB2-TRg-4":7695,
"COG3g1-NAB2-TRg-6":7696,
"COG3g1-YTM1-NRg-1":7697,
"COG3g1-OLE1-TRg-8":7698,
"COG3g1-OLE1-TRg-1":7699,
"COG3g1-UTP7-TRg-4":7700,
"COG3g1-ACT1-NRg-6":7701,
"COG3g1-RPL18A-NRg-3":7702,
"COG3g1-BRX1-NRg-1":7703,
"COG3g1-NAF1-TRg-8":7704,
"COG3g1-NAF1-TRg-6":7705,
"COG3g1-NAF1-TRg-4":7706,
"COG3g1-CDC8-TRg-2":7707,
"COG3g1-NSE4-TRg-1":7708,
"COG3g1-PAB1-NRg-2":7709,
"COG3g1-PRP43-TRg-4":7710,
"COG3g1-SEC2-NRg-3":7711,
"COG3g1-SEC2-NRg-6":7712,
"COG3g1-MPP10-NRg-5":7713,
"COG3g1-YDR355C-TRg-2":7714,
"COG3g1-YLR339C-TRg-9":7715,
"COG3g1-SNM1-TRg-2":7716,
"COG3g1-ALR1-NRg-4":7717,
"COG3g1-ALR1-NRg-1":7718,
"COG3g1-ALR1-NRg-3":7719,
"COG3g1-RPL10-TRg-1":7720,
"COG3g1-RPL28-TRg-2":7721,
"COG3g1-UTP25-TRg-1":7722,
"COG3g1-POB3-TRg-1":7723,
"COG3g1-POB3-TRg-3":7724,
"COG3g1-POB3-TRg-2":7725,
"COG3g1-MED11-TRg-1":7726,
"COG3g1-ISA1-TRg-15":7727,
"COG3g1-RRP1-NRg-1":7728,
"COG3g1-MES1-NRg-1":7729,
"COG3g1-SEC13-NRg-5":7730,
"COG3g1-MCM2-NRg-2":7731,
"COG3g1-ALA1-TRg-4":7732,
"COG3g1-MTG2-TRg-5":7733,
"COG3g1-TIF35-NRg-3":7734,
"COG3g1-NSE1-TRg-3":7735,
"COG3g1-NSE1-TRg-4":7736,
"COG3g1-MOB2-NRg-6":7737,
"COG3g1-VRG4-NRg-3":7738,
"COG3g1-PRP9-TRg-3":7739,
"COG3g1-HYM1-TRg-5":7740,
"COG3g1-POP1-TRg-5":7741,
"COG3g1-POP1-TRg-9":7742,
"COG3g1-RPL17A-TRg-1":7743,
"COG3g1-SLD2-TRg-1":7744,
"COG3g1-CDC48-NRg-7":7745,
"COG3g1-FHL1-NRg-2":7746,
"COG3g1-BET3-NRg-7":7747,
"COG3g1-MAK21-TRg-1":7748,
"COG3g1-BRN1-TRg-4":7749,
"COG3g1-FBA1-NRg-3":7750,
"COG3g1-CDC42-TRg-6":7751,
"COG3g1-CDC42-TRg-7":7752,
"COG3g1-COG4-NRg-1":7753,
"COG3g1-ATP3-NRg-3":7754,
"COG3g1-ATP3-NRg-2":7755,
"COG3g1-SMP3-TRg-5":7756,
"COG3g1-CFT2-NRg-2":7757,
"COG3g1-FAS2-TRg-5":7758,
"COG3g1-DBP2-NRg-3":7759,
"COG3g1-DBP2-NRg-2":7760,
"COG3g1-MPS2-NRg-4":7761,
"COG3g1-ARC35-TRg-2":7762,
"COG3g1-ARC35-TRg-5":7763,
"COG3g1-MRD1-TRg-1":7764,
"COG3g1-RLP7-TRg-1":7765,
"COG3g1-SPC34-TRg-1":7766,
"COG3g1-CDC45-TRg-2":7767,
"COG3g1-GCD6-TRg-3":7768,
"COG3g1-GCD6-TRg-4":7769,
"COG3g1-YPT6-NRg-2":7770,
"COG3g1-RPS13-TRg-2":7771,
"COG3g1-IPI3-TRg-3":7772,
"COG3g1-TIF5-NRg-9":7773,
"COG3g1-TIF5-NRg-7":7774,
"COG3g1-TIF5-NRg-6":7775,
"COG3g1-NAB3-TRg-3":7776,
"COG3g1-GCD2-TRg-1":7777,
"COG3g1-UBA1-TRg-2":7778,
"COG3g1-SLD3-TRg-6":7779,
"COG3g1-LCB1-TRg-5":7780,
"COG3g1-TOA2-TRg-6":7781,
"COG3g1-TOA2-TRg-1":7782,
"COG3g1-TOA2-TRg-3":7783,
"COG3g1-LSM2-TRg-1":7784,
"COG3g1-YML6-TRg-13":7785,
"COG3g1-YML6-TRg-12":7786,
"COG3g1-UTP15-NRg-1":7787,
"COG3g1-TIF6-NRg-8":7788,
"COG3g1-SUP35-NRg-1":7789,
"COG3g1-MPP10-NRg-1":7790,
"COG3g1-SWI3-TRg-7":7791,
"COG3g1-SSN3-NRg-2":7792,
"COG3g1-SEC13-NRg-7":7793,
"COG3g1-RPS15-NRg-3":7794,
"COG3g1-RPL3-TRg-2":7795,
"COG3g1-FBA1-NRg-2":7796,
"COG3g1-FBA1-NRg-1":7797,
"COG3g1-FBA1-NRg-5":7798,
"COG3g1-DAM1-TRg-2":7799,
"COG3g1-NHP2-TRg-2":7800,
"COG3g1-HCA4-NRg-6":7801,
"COG3g1-PRE3-TRg-4":7802,
"COG3g1-DBP5-NRg-4":7803,
"COG3g1-SPT6-NRg-4":7804,
"COG3g1-SPT6-NRg-2":7805,
"COG3g1-RPL18A-TRg-4":7806,
"COG3g1-KSH1-TRg-1":7807,
"COG3g1-KSH1-TRg-3":7808,
"COG3g1-IPI3-NRg-1":7809,
"COG3g1-PGA2-TRg-8":7810,
"COG3g1-RPL18A-TRg-2":7811,
"COG3g1-RPL33A-NRg-6":7812,
"COG3g1-TAF12-NRg-2":7813,
"COG3g1-USE1-TRg-5":7814,
"COG3g1-YNL114C-TRg-1":7815,
"COG3g1-SMC5-TRg-7":7816,
"COG3g1-SMC5-TRg-6":7817,
"COG3g1-RSC58-TRg-1":7818,
"COG3g1-CTF13-TRg-2":7819,
"COG3g1-NAB2-NRg-2":7820,
"COG3g1-MCM7-TRg-4":7821,
"COG3g1-BCP1-NRg-5":7822,
"COG3g1-STU2-TRg-3":7823,
"COG3g1-SEC21-NRg-6":7824,
"COG3g1-SEC21-NRg-3":7825,
"COG3g1-RPL1B-TRg-3":7826,
"COG3g1-SEC20-NRg-2":7827,
"COG3g1-VMA3-NRg-2":7828,
"COG3g1-SEC23-NRg-5":7829,
"COG3g1-CDC28-TRg-4":7830,
"COG3g1-RPN12-NRg-11":7831,
"COG3g1-PUP3-TRg-3":7832,
"COG3g1-SEC31-TRg-2":7833,
"COG3g1-SED5-TRg-6":7834,
"COG3g1-SED5-TRg-5":7835,
"COG3g1-RPL33A-TRg-1":7836,
"COG3g1-RPL33A-TRg-2":7837,
"COG3g1-MRPL11-TRg-2":7838,
"COG3g1-RTP1-NRg-2":7839,
"COG3g1-NUG1-TRg-2":7840,
"COG3g1-VPH2-TRg-4":7841,
"COG3g1-COP1-NRg-3":7842,
"COG3g1-CRM1-NRg-1":7843,
"COG3g1-RPL5-NRg-4":7844,
"COG3g1-SNU13-NRg-4":7845,
"COG3g1-PFS2-TRg-3":7846,
"COG3g1-MPP10-TRg-2":7847,
"COG3g1-TSR4-NRg-2":7848,
"COG3g1-RSC2-TRg-1":7849,
"COG3g1-SEC65-TRg-2":7850,
"COG3g1-SMI1-NRg-1":7851,
"COG3g1-RTT105-NRg-4":7852,
"COG3g1-VMA5-TRg-3":7853,
"COG3g1-VMA5-TRg-5":7854,
"COG3g1-RRP1-TRg-3":7855,
"COG3g1-CLC1-TRg-2":7856,
"COG3g1-GCD6-NRg-1":7857,
"COG3g1-GCD6-NRg-2":7858,
"COG3g1-PXR1-TRg-1":7859,
"COG3g1-CDC14-NRg-1":7860,
"COG3g1-PCF11-TRg-6":7861,
"COG3g1-PCF11-TRg-5":7862,
"COG3g1-PCF11-TRg-4":7863,
"COG3g1-SEC31-NRg-1":7864,
"COG3g1-RRP5-NRg-1":7865,
"COG3g1-PRE10-TRg-5":7866,
"COG3g1-PRE10-TRg-1":7867,
"COG3g1-RPS5-TRg-2":7868,
"COG3g1-NSP1-TRg-4":7869,
"COG3g1-PRP38-TRg-4":7870,
"COG3g1-RCF1-NRg-5":7871,
"COG3g1-RSC3-TRg-4":7872,
"COG3g1-RSC3-TRg-5":7873,
"COG3g1-RSC3-TRg-6":7874,
"COG3g1-HTA1-NRg-12":7875,
"COG3g1-HTA1-NRg-11":7876,
"COG3g1-UTP23-TRg-2":7877,
"COG3g1-GCD7-NRg-1":7878,
"COG3g1-GCD7-NRg-2":7879,
"COG3g1-GCD7-NRg-6":7880,
"COG3g1-GAL11-NRg-2":7881,
"COG3g1-GAL11-NRg-9":7882,
"COG3g1-PHO4-TRg-5":7883,
"COG3g1-SNP1-NRg-3":7884,
"COG3g1-RPC37-TRg-5":7885,
"COG3g1-CRM1-TRg-5":7886,
"COG3g1-CRM1-TRg-2":7887,
"COG3g1-ASK1-TRg-7":7888,
"COG3g1-STU2-NRg-4":7889,
"COG3g1-NEO1-NRg-3":7890,
"COG3g1-GAL11-TRg-5":7891,
"COG3g1-GAL11-TRg-7":7892,
"COG3g1-SAM50-NRg-3":7893,
"COG3g1-CSL4-TRg-2":7894,
"COG3g1-CCT5-TRg-2":7895,
"COG3g1-POL30-NRg-1":7896,
"COG3g1-MED4-TRg-4":7897,
"COG3g1-MED4-TRg-3":7898,
"COG3g1-MED4-TRg-2":7899,
"COG3g1-GDI1-TRg-4":7900,
"COG3g1-GDI1-TRg-3":7901,
"COG3g1-REB1-TRg-6":7902,
"COG3g1-MRPL37-NRg-2":7903,
"COG3g1-NOC3-TRg-3":7904,
"COG3g1-SPC97-TRg-3":7905,
"COG3g1-IPP1-TRg-3":7906,
"COG3g1-IPP1-TRg-2":7907,
"COG3g1-PTI1-TRg-3":7908,
"COG3g1-PTI1-TRg-5":7909,
"COG3g1-RFC5-NRg-1":7910,
"COG3g1-CDC24-TRg-1":7911,
"COG3g1-CDC24-TRg-3":7912,
"COG3g1-CDC24-TRg-5":7913,
"COG3g1-CDC24-TRg-6":7914,
"COG3g1-UTP23-TRg-6":7915,
"COG3g1-UTP23-TRg-4":7916,
"COG3g1-UTP23-TRg-1":7917,
"COG3g1-RHO3-NRg-4":7918,
"COG3g1-TRS23-NRg-1":7919,
"COG3g1-TRS23-NRg-3":7920,
"COG3g1-RSP5-TRg-2":7921,
"COG3g1-RSP5-TRg-1":7922,
"COG3g1-SDA1-NRg-1":7923,
"COG3g1-KAP95-TRg-8":7924,
"COG3g1-ACO1-TRg-6":7925,
"COG3g1-HTA1-NRg-3":7926,
"COG3g1-HTA1-NRg-2":7927,
"COG3g1-SPN1-TRg-1":7928,
"COG3g1-MOT1-NRg-7":7929,
"COG3g1-RPL17A-NRg-4":7930,
"COG3g1-ADA2-TRg-4":7931,
"COG3g1-SFH1-NRg-1":7932,
"COG3g1-SPC97-NRg-5":7933,
"COG3g1-PRP22-TRg-3":7934,
"COG3g1-SEN15-TRg-2":7935,
"COG3g1-RPL3-NRg-2":7936,
"COG3g1-ISD11-NRg-2":7937,
"COG3g1-HEM12-TRg-8":7938,
"COG3g1-SEC10-TRg-1":7939,
"COG3g1-HTB1-TRg-7":7940,
"COG3g1-TTI2-TRg-1":7941,
"COG3g1-ACP1-TRg-2":7942,
"COG3g1-ACP1-TRg-4":7943,
"COG3g1-GAL11-NRg-10":7944,
"COG3g1-UTP22-TRg-2":7945,
"COG3g1-MST1-NRg-5":7946,
"COG3g1-RIB7-NRg-2":7947,
"COG3g1-MCD1-TRg-6":7948,
"COG3g1-MCD1-TRg-5":7949,
"COG3g1-GPI8-NRg-2":7950,
"COG3g1-THS1-TRg-2":7951,
"COG3g1-RRP7-TRg-2":7952,
"COG3g1-RRP7-TRg-5":7953,
"COG3g1-SMX2-NRg-7":7954,
"COG3g1-RRP45-TRg-5":7955,
"COG3g1-RRP45-TRg-4":7956,
"COG3g1-CNS1-TRg-2":7957,
"COG3g1-FBP1-NRg-9":7958,
"COG3g1-GCD11-NRg-1":7959,
"COG3g1-RPL10-TRg-2":7960,
"COG3g1-NUP192-TRg-4":7961,
"COG3g1-NUP145-NRg-4":7962,
"COG3g1-HEM12-TRg-6":7963,
"COG3g1-PLC1-TRg-3":7964,
"COG3g1-RPA43-TRg-1":7965,
"COG3g1-RPB7-NRg-2":7966,
"COG3g1-RPB7-NRg-3":7967,
"COG3g1-NSL1-NRg-1":7968,
"COG3g1-UTP6-TRg-3":7969,
"COG3g1-UTP6-TRg-1":7970,
"COG3g1-YJU2-TRg-5":7971,
"COG3g1-FRS2-NRg-5":7972,
"COG3g1-TIF35-NRg-2":7973,
"COG3g1-GPI15-TRg-1":7974,
"COG3g1-NOP1-NRg-5":7975,
"COG3g1-GPI15-TRg-4":7976,
"COG3g1-COG4-TRg-1":7977,
"COG3g1-TFA1-TRg-1":7978,
"COG3g1-RHO1-NRg-2":7979,
"COG3g1-RHO1-NRg-1":7980,
"COG3g1-CDC55-NRg-2":7981,
"COG3g1-IDI1-NRg-7":7982,
"COG3g1-RPL32-TRg-5":7983,
"COG3g1-RPB5-TRg-4":7984,
"COG3g1-DIP2-TRg-5":7985,
"COG3g1-DIP2-TRg-1":7986,
"COG3g1-RPC40-TRg-2":7987,
"COG3g1-CDC6-TRg-5":7988,
"COG3g1-CDC6-TRg-3":7989,
"COG3g1-DAD2-TRg-2":7990,
"COG3g1-RVS161-TRg-2":7991,
"COG3g1-RVS161-TRg-1":7992,
"COG3g1-SUP45-NRg-3":7993,
"COG3g1-SRB6-NRg-5":7994,
"COG3g1-RPC11-TRg-4":7995,
"COG3g1-RKI1-TRg-8":7996,
"COG3g1-NIP7-TRg-3":7997,
"COG3g1-RPL33A-NRg-12":7998,
"COG3g1-SAM50-TRg-4":7999,
"COG3g1-NOP4-NRg-1":8000,
"COG3g1-NOP4-NRg-3":8001,
"COG3g1-SMX2-TRg-5":8002,
"COG3g1-POL12-NRg-2":8003,
"COG3g1-BMS1-NRg-2":8004,
"COG3g1-RPA190-TRg-5":8005,
"COG3g1-ALG14-NRg-4":8006,
"COG3g1-ALG14-NRg-1":8007,
"COG3g1-PRE5-NRg-1":8008,
"COG3g1-BIG1-NRg-2":8009,
"COG3g1-TFA2-TRg-4":8010,
"COG3g1-IMP4-TRg-6":8011,
"COG3g1-PAN1-NRg-1":8012,
"COG3g1-UTP13-TRg-2":8013,
"COG3g1-KAE1-NRg-3":8014,
"COG3g1-ERG20-TRg-1":8015,
"COG3g1-CDC20-TRg-6":8016,
"COG3g1-PWP2-NRg-2":8017,
"COG3g1-COG1-NRg-1":8018,
"COG3g1-RPL1B-TRg-4":8019,
"COG3g1-RPL1B-TRg-7":8020,
"COG3g1-UTP20-TRg-3":8021,
"COG3g1-UTP20-TRg-4":8022,
"COG3g1-RPL25-TRg-4":8023,
"COG3g1-RPL25-TRg-2":8024,
"COG3g1-MCM7-NRg-1":8025,
"COG3g1-MRP49-TRg-5":8026,
"COG3g1-ERO1-NRg-3":8027,
"COG3g1-UTP5-TRg-7":8028,
"COG3g1-MCM4-NRg-1":8029,
"COG3g1-PRE3-NRg-1":8030,
"COG3g1-FCF1-NRg-1":8031,
"COG3g1-CUS1-NRg-1":8032,
"COG3g1-PSF1-TRg-2":8033,
"COG3g1-BCP1-TRg-2":8034,
"COG3g1-PAN1-TRg-1":8035,
"COG3g1-PAN1-TRg-3":8036,
"COG3g1-PAN1-TRg-4":8037,
"COG3g1-VPS3-TRg-2":8038,
"COG3g1-YIL060W-NRg-1":8039,
"COG3g1-VPS53-NRg-1":8040,
"COG3g1-CYR1-TRg-4":8041,
"COG3g1-CYR1-TRg-7":8042,
"COG3g1-MPS1-NRg-1":8043,
"COG3g1-SRP1-TRg-5":8044,
"COG3g1-SRP1-TRg-4":8045,
"COG3g1-TAF12-TRg-2":8046,
"COG3g1-TAF12-TRg-3":8047,
"COG3g1-POP4-TRg-1":8048,
"COG3g1-SPT16-TRg-1":8049,
"COG3g1-NUP82-TRg-4":8050,
"COG3g1-DML1-TRg-3":8051,
"COG3g1-RPA43-NRg-3":8052,
"COG3g1-STU2-NRg-3":8053,
"COG3g1-POP4-NRg-4":8054,
"COG3g1-MCD1-TRg-2":8055,
"COG3g1-RPS3-NRg-4":8056,
"COG3g1-PRP9-TRg-4":8057,
"COG3g1-RPP1-NRg-2":8058,
"COG3g1-MTR2-NRg-11":8059,
"COG3g1-GCD11-TRg-1":8060,
"COG3g1-RPF1-TRg-3":8061,
"COG3g1-SUB2-NRg-4":8062,
"COG3g1-GPI15-TRg-3":8063,
"COG3g1-ERG9-TRg-6":8064,
"COG3g1-RPT2-NRg-1":8065,
"COG3g1-YOS1-NRg-3":8066,
"COG3g1-SCM3-TRg-4":8067,
"COG3g1-SCM3-TRg-6":8068,
"COG3g1-RLP7-NRg-1":8069,
"COG3g1-TFB2-NRg-4":8070,
"COG3g1-IMP4-TRg-1":8071,
"COG3g1-IMP4-TRg-3":8072,
"COG3g1-PRE4-TRg-3":8073,
"COG3g1-SUB2-TRg-3":8074,
"COG3g1-RPP0-NRg-4":8075,
"COG3g1-RPP0-NRg-3":8076,
"COG3g1-TOM40-TRg-4":8077,
"COG3g1-FUR1-NRg-12":8078,
"COG3g1-TOM40-TRg-2":8079,
"COG3g1-VMA11-NRg-4":8080,
"COG3g1-PGS1-NRg-4":8081,
"COG3g1-URB1-TRg-4":8082,
"COG3g1-ARP4-TRg-3":8083,
"COG3g1-RPT3-TRg-3":8084,
"COG3g1-SUI3-TRg-3":8085,
"COG3g1-RFC5-NRg-2":8086,
"COG3g1-RRP14-TRg-2":8087,
"COG3g1-SCC2-TRg-1":8088,
"COG3g1-SSC1-TRg-3":8089,
"COG3g1-RRP9-TRg-3":8090,
"COG3g1-MOT1-NRg-9":8091,
"COG3g1-RPL42A-NRg-2":8092,
"COG3g1-SEC16-TRg-7":8093,
"COG3g1-IMP4-NRg-2":8094,
"COG3g1-YEF3-NRg-4":8095,
"COG3g1-PUP1-TRg-1":8096,
"COG3g1-UTP22-TRg-6":8097,
"COG3g1-DBP2-NRg-4":8098,
"COG3g1-PRE2-TRg-7":8099,
"COG3g1-ATP16-TRg-6":8100,
"COG3g1-UTP13-TRg-4":8101,
"COG3g1-DOP1-NRg-4":8102,
"COG3g1-TIM44-TRg-3":8103,
"COG3g1-ATP16-TRg-2":8104,
"COG3g1-ENP1-NRg-3":8105,
"COG3g1-NAF1-TRg-3":8106,
"COG3g1-COG4-TRg-2":8107,
"COG3g1-SOG2-TRg-7":8108,
"COG3g1-YDR341C-TRg-3":8109,
"COG3g1-YMR290W-A-TRg-10":8110,
"COG3g1-NUP192-NRg-9":8111,
"COG3g1-RPS31-NRg-8":8112,
"COG3g1-SPC97-NRg-6":8113,
"COG3g1-EBP2-NRg-1":8114,
"COG3g1-CDC48-TRg-5":8115,
"COG3g1-RPT1-TRg-4":8116,
"COG3g1-ULP1-NRg-2":8117,
"COG3g1-RPN3-TRg-6":8118,
"COG3g1-RPT1-TRg-5":8119,
"COG3g1-KRE5-TRg-2":8120,
"COG3g1-TBF1-NRg-8":8121,
"COG3g1-UTP22-NRg-4":8122,
"COG3g1-SSC1-NRg-4":8123,
"COG3g1-REB1-TRg-4":8124,
"COG3g1-CDC48-NRg-9":8125,
"COG3g1-FAS2-TRg-8":8126,
"COG3g1-TAO3-TRg-8":8127,
"COG3g1-CKS1-TRg-5":8128,
"COG3g1-YLR379W-TRg-7":8129,
"COG3g1-TEN1-NRg-2":8130,
"COG3g1-RPL42A-TRg-2":8131,
"COG3g1-SEC27-TRg-4":8132,
"COG3g1-TBF1-NRg-4":8133,
"COG3g1-RPT1-NRg-6":8134,
"COG3g1-COG1-TRg-3":8135,
"COG3g1-SUI1-TRg-6":8136,
"COG3g1-TIM23-TRg-6":8137,
"COG3g1-CDC48-NRg-6":8138,
"COG3g1-EPL1-TRg-5":8139,
"COG3g1-RPT5-TRg-8":8140,
"COG3g1-ATP16-NRg-4":8141,
"COG3g1-RPN6-TRg-3":8142,
"COG3g1-ERG9-NRg-6":8143,
"COG3g1-SMX3-TRg-1":8144,
"COG3g1-NCB2-NRg-3":8145,
"COG3g1-SEC16-NRg-12":8146,
"COG3g1-RPN6-TRg-2":8147,
"COG3g1-REB1-NRg-4":8148,
"COG3g1-ATP16-TRg-9":8149,
"COG3g1-ERG9-NRg-7":8150,
"SED5g5-RPL15A-NRg-4":8151,
"SED5g5-RPL15A-NRg-5":8152,
"SED5g5-KRE33-TRg-1":8153,
"SED5g5-PMI40-NRg-1":8154,
"SED5g5-NOP19-NRg-3":8155,
"SED5g5-SRP14-NRg-4":8156,
"SED5g5-SEC27-TRg-2":8157,
"SED5g5-GPI14-TRg-3":8158,
"SED5g5-PAH1-TRg-7":8159,
"SED5g5-PAH1-TRg-6":8160,
"SED5g5-PAH1-TRg-5":8161,
"SED5g5-PAH1-TRg-3":8162,
"SED5g5-COG3-TRg-1":8163,
"SED5g5-HTS1-NRg-5":8164,
"SED5g5-MSN5-TRg-7":8165,
"SED5g5-ERG26-TRg-1":8166,
"SED5g5-SMD2-TRg-5":8167,
"SED5g5-SMD2-TRg-4":8168,
"SED5g5-SMD2-TRg-1":8169,
"SED5g5-PRE7-TRg-4":8170,
"SED5g5-PRE7-TRg-7":8171,
"SED5g5-SEC6-TRg-3":8172,
"SED5g5-ESF2-NRg-1":8173,
"SED5g5-ESF2-NRg-3":8174,
"SED5g5-AFG2-TRg-2":8175,
"SED5g5-RRP36-TRg-3":8176,
"SED5g5-RRP36-TRg-5":8177,
"SED5g5-GCR1-NRg-2":8178,
"SED5g5-PRE4-NRg-4":8179,
"SED5g5-PRE4-NRg-9":8180,
"SED5g5-DSN1-NRg-2":8181,
"SED5g5-GPI11-TRg-3":8182,
"SED5g5-POP3-TRg-1":8183,
"SED5g5-MNE1-TRg-5":8184,
"SED5g5-RRP12-NRg-1":8185,
"SED5g5-RSC6-TRg-2":8186,
"SED5g5-CDC25-TRg-1":8187,
"SED5g5-CDC25-TRg-9":8188,
"SED5g5-YPP1-NRg-3":8189,
"SED5g5-NFS1-NRg-9":8190,
"SED5g5-NFS1-NRg-8":8191,
"SED5g5-UBA2-TRg-1":8192,
"SED5g5-ARP2-NRg-3":8193,
"SED5g5-MAK16-TRg-1":8194,
"SED5g5-CEP3-NRg-1":8195,
"SED5g5-GUK1-TRg-5":8196,
"SED5g5-GUK1-TRg-2":8197,
"SED5g5-GPI12-NRg-6":8198,
"SED5g5-RPS5-NRg-5":8199,
"SED5g5-RPS5-NRg-2":8200,
"SED5g5-RPC19-NRg-1":8201,
"SED5g5-TIM54-TRg-1":8202,
"SED5g5-TEN1-TRg-2":8203,
"SED5g5-SAH1-NRg-4":8204,
"SED5g5-SAH1-NRg-5":8205,
"SED5g5-SAH1-NRg-3":8206,
"SED5g5-ATP15-NRg-5":8207,
"SED5g5-SCD5-TRg-5":8208,
"SED5g5-ARB1-NRg-2":8209,
"SED5g5-ARB1-NRg-4":8210,
"SED5g5-PUP2-TRg-1":8211,
"SED5g5-CCT8-TRg-2":8212,
"SED5g5-MCM4-TRg-1":8213,
"SED5g5-LSM4-TRg-1":8214,
"SED5g5-NOP53-NRg-1":8215,
"SED5g5-ATP3-TRg-4":8216,
"SED5g5-AFG2-NRg-3":8217,
"SED5g5-PRO3-NRg-3":8218,
"SED5g5-NRD1-NRg-10":8219,
"SED5g5-SEC61-TRg-2":8220,
"SED5g5-RHO3-TRg-4":8221,
"SED5g5-SNF2-TRg-6":8222,
"SED5g5-SMD2-NRg-3":8223,
"SED5g5-RSC4-TRg-2":8224,
"SED5g5-RSC4-TRg-1":8225,
"SED5g5-TIF34-TRg-2":8226,
"SED5g5-BET1-NRg-1":8227,
"SED5g5-CDC8-NRg-2":8228,
"SED5g5-PRP42-TRg-2":8229,
"SED5g5-RRB1-TRg-2":8230,
"SED5g5-SPC24-TRg-1":8231,
"SED5g5-ILS1-NRg-1":8232,
"SED5g5-GFA1-TRg-2":8233,
"SED5g5-SEC21-NRg-10":8234,
"SED5g5-RPC10-NRg-1":8235,
"SED5g5-RPB10-TRg-3":8236,
"SED5g5-RPB10-TRg-2":8237,
"SED5g5-YNL181W-TRg-1":8238,
"SED5g5-RAD3-NRg-1":8239,
"SED5g5-NOP10-TRg-1":8240,
"SED5g5-BFR2-TRg-3":8241,
"SED5g5-MCM2-TRg-6":8242,
"SED5g5-MCM2-TRg-4":8243,
"SED5g5-MPP10-TRg-1":8244,
"SED5g5-RET2-TRg-4":8245,
"SED5g5-RET2-TRg-1":8246,
"SED5g5-RPS2-NRg-1":8247,
"SED5g5-RPS2-NRg-2":8248,
"SED5g5-ORC4-NRg-3":8249,
"SED5g5-TIP20-TRg-7":8250,
"SED5g5-SMT3-TRg-1":8251,
"SED5g5-MSS18-NRg-6":8252,
"SED5g5-YEF3-NRg-9":8253,
"SED5g5-ASK1-NRg-1":8254,
"SED5g5-SMC1-TRg-1":8255,
"SED5g5-NIP1-NRg-1":8256,
"SED5g5-RPP1-NRg-1":8257,
"SED5g5-YDJ1-TRg-6":8258,
"SED5g5-SUB2-NRg-1":8259,
"SED5g5-TIM10-NRg-8":8260,
"SED5g5-TIM10-NRg-4":8261,
"SED5g5-TIM10-NRg-7":8262,
"SED5g5-SKI6-TRg-4":8263,
"SED5g5-TUB4-TRg-1":8264,
"SED5g5-CDC37-NRg-2":8265,
"SED5g5-ISD11-TRg-3":8266,
"SED5g5-YOS1-TRg-4":8267,
"SED5g5-SSC1-TRg-6":8268,
"SED5g5-MTR3-TRg-5":8269,
"SED5g5-MTR3-TRg-6":8270,
"SED5g5-TFA1-TRg-2":8271,
"SED5g5-CDC3-NRg-3":8272,
"SED5g5-ERG25-TA-18":8273,
"SED5g5-RPB11-TRg-4":8274,
"SED5g5-RPB11-TRg-1":8275,
"SED5g5-RPB11-TRg-2":8276,
"SED5g5-DED1-TRg-3":8277,
"SED5g5-DED1-TRg-1":8278,
"SED5g5-DED1-TRg-6":8279,
"SED5g5-DED1-TRg-4":8280,
"SED5g5-RPL10-NRg-5":8281,
"SED5g5-RPL10-NRg-4":8282,
"SED5g5-EFB1-NRg-1":8283,
"SED5g5-EFB1-NRg-5":8284,
"SED5g5-EFB1-NRg-4":8285,
"SED5g5-RPT3-NRg-1":8286,
"SED5g5-SAC6-TRg-8":8287,
"SED5g5-SAC6-TRg-4":8288,
"SED5g5-SAC6-TRg-5":8289,
"SED5g5-SAC6-TRg-3":8290,
"SED5g5-DIM1-TRg-5":8291,
"SED5g5-DIM1-TRg-7":8292,
"SED5g5-RPC17-NRg-1":8293,
"SED5g5-RPC17-NRg-2":8294,
"SED5g5-YDR341C-TRg-1":8295,
"SED5g5-RAP1-NRg-8":8296,
"SED5g5-RAP1-NRg-5":8297,
"SED5g5-RAP1-NRg-2":8298,
"SED5g5-SEC26-NRg-3":8299,
"SED5g5-SPP41-TRg-3":8300,
"SED5g5-TAP42-NRg-1":8301,
"SED5g5-PGA2-TRg-6":8302,
"SED5g5-BRL1-TRg-1":8303,
"SED5g5-FOL2-TRg-1":8304,
"SED5g5-NAB3-NRg-5":8305,
"SED5g5-SNF4-TRg-4":8306,
"SED5g5-HRR25-TRg-2":8307,
"SED5g5-TRS23-TRg-4":8308,
"SED5g5-CTR86-TRg-4":8309,
"SED5g5-RPB5-TRg-5":8310,
"SED5g5-SPN1-NRg-2":8311,
"SED5g5-SPN1-NRg-1":8312,
"SED5g5-SEC61-NRg-1":8313,
"SED5g5-SEC61-NRg-7":8314,
"SED5g5-TUS1-TRg-3":8315,
"SED5g5-OLE1-NRg-2":8316,
"SED5g5-AFG2-TRg-1":8317,
"SED5g5-TOA2-NRg-1":8318,
"SED5g5-USO1-TRg-1":8319,
"SED5g5-UTP22-NRg-2":8320,
"SED5g5-RIB1-TRg-3":8321,
"SED5g5-RIB1-TRg-7":8322,
"SED5g5-RIB1-TRg-4":8323,
"SED5g5-COG1-TRg-1":8324,
"SED5g5-RPL32-NRg-2":8325,
"SED5g5-GLC7-NRg-3":8326,
"SED5g5-GLC7-NRg-4":8327,
"SED5g5-HSF1-TRg-2":8328,
"SED5g5-DAM1-NRg-5":8329,
"SED5g5-SEC18-TRg-4":8330,
"SED5g5-SEC18-TRg-5":8331,
"SED5g5-PAB1-NRg-3":8332,
"SED5g5-POP8-TRg-2":8333,
"SED5g5-PAB1-NRg-4":8334,
"SED5g5-BIG1-TRg-4":8335,
"SED5g5-BIG1-TRg-5":8336,
"SED5g5-BIG1-TRg-6":8337,
"SED5g5-RPO41-NRg-1":8338,
"SED5g5-RVB2-NRg-2":8339,
"SED5g5-PET117-NRg-8":8340,
"SED5g5-VPS45-NRg-9":8341,
"SED5g5-YCG1-NRg-1":8342,
"SED5g5-NOC4-NRg-1":8343,
"SED5g5-NMD3-NRg-2":8344,
"SED5g5-DRS1-TRg-2":8345,
"SED5g5-HTB1-NRg-2":8346,
"SED5g5-IPI1-TRg-2":8347,
"SED5g5-SEC18-NRg-1":8348,
"SED5g5-SEC18-NRg-2":8349,
"SED5g5-JIP5-NRg-2":8350,
"SED5g5-YPT1-TRg-3":8351,
"SED5g5-YPT1-TRg-2":8352,
"SED5g5-CLF1-NRg-2":8353,
"SED5g5-SNF2-NRg-7":8354,
"SED5g5-SNF2-NRg-4":8355,
"SED5g5-RPL25-NRg-1":8356,
"SED5g5-NOP56-TRg-1":8357,
"SED5g5-NOP56-TRg-2":8358,
"SED5g5-TRS31-TRg-1":8359,
"SED5g5-DBF4-TRg-2":8360,
"SED5g5-DBF4-TRg-1":8361,
"SED5g5-RPC19-TRg-4":8362,
"SED5g5-RPC19-TRg-6":8363,
"SED5g5-RPC19-TRg-3":8364,
"SED5g5-ROK1-NRg-1":8365,
"SED5g5-CDC33-TRg-4":8366,
"SED5g5-DHR2-TRg-3":8367,
"SED5g5-RRP42-NRg-5":8368,
"SED5g5-CLF1-TRg-1":8369,
"SED5g5-ERG11-NA-16":8370,
"SED5g5-VAS1-NRg-4":8371,
"SED5g5-PIK1-NRg-2":8372,
"SED5g5-SAR1-NRg-7":8373,
"SED5g5-SAR1-NRg-4":8374,
"SED5g5-RPS3-TRg-1":8375,
"SED5g5-YTM1-TRg-2":8376,
"SED5g5-SUI3-NRg-5":8377,
"SED5g5-SUI3-NRg-2":8378,
"SED5g5-RRP7-TRg-4":8379,
"SED5g5-RRP7-TRg-6":8380,
"SED5g5-NIP7-TRg-2":8381,
"SED5g5-MDM35-TRg-1":8382,
"SED5g5-ALA1-NRg-1":8383,
"SED5g5-DOA4-NRg-2":8384,
"SED5g5-RPS13-NRg-1":8385,
"SED5g5-YSF3-TRg-2":8386,
"SED5g5-RPS2-NRg-11":8387,
"SED5g5-SSL1-TRg-10":8388,
"SED5g5-NIP7-TRg-1":8389,
"SED5g5-LST8-NRg-1":8390,
"SED5g5-TAF4-TRg-3":8391,
"SED5g5-HAS1-TRg-2":8392,
"SED5g5-GLC7-TRg-2":8393,
"SED5g5-CDC45-NRg-1":8394,
"SED5g5-SEC22-NRg-8":8395,
"SED5g5-YOS1-TRg-2":8396,
"SED5g5-RBA50-TRg-3":8397,
"SED5g5-SPP41-NRg-2":8398,
"SED5g5-PRP46-TRg-2":8399,
"SED5g5-PGA2-NRg-1":8400,
"SED5g5-CBF5-TRg-3":8401,
"SED5g5-TCP1-NRg-3":8402,
"SED5g5-TCP1-NRg-2":8403,
"SED5g5-ERG26-NRg-2":8404,
"SED5g5-ERG26-NRg-4":8405,
"SED5g5-MES1-TRg-5":8406,
"SED5g5-HTS1-TRg-2":8407,
"SED5g5-SSS1-TRg-3":8408,
"SED5g5-SSS1-TRg-2":8409,
"SED5g5-SYS1-TRg-7":8410,
"SED5g5-SYS1-TRg-2":8411,
"SED5g5-SYS1-TRg-1":8412,
"SED5g5-BFR2-TRg-1":8413,
"SED5g5-EOS1-TRg-3":8414,
"SED5g5-TAF4-NRg-1":8415,
"SED5g5-ARL3-NRg-8":8416,
"SED5g5-RPN5-NRg-1":8417,
"SED5g5-TIM9-NRg-2":8418,
"SED5g5-NUP57-NRg-3":8419,
"SED5g5-VPS4-TRg-1":8420,
"SED5g5-CDC3-TRg-4":8421,
"SED5g5-BBP1-NRg-1":8422,
"SED5g5-BBP1-NRg-2":8423,
"SED5g5-USE1-NRg-3":8424,
"SED5g5-CCT7-TRg-1":8425,
"SED5g5-SAH1-TRg-3":8426,
"SED5g5-CHS2-TRg-1":8427,
"SED5g5-DPM1-TRg-2":8428,
"SED5g5-BBP1-TRg-1":8429,
"SED5g5-NRD1-TRg-4":8430,
"SED5g5-RPB3-NRg-1":8431,
"SED5g5-PHO85-NRg-6":8432,
"SED5g5-SNF6-TRg-6":8433,
"SED5g5-PRP38-NRg-2":8434,
"SED5g5-OAR1-NRg-3":8435,
"SED5g5-ROX3-NRg-1":8436,
"SED5g5-YPP1-TRg-6":8437,
"SED5g5-CBF2-NRg-8":8438,
"SED5g5-SPT6-TRg-5":8439,
"SED5g5-SEC10-NRg-1":8440,
"SED5g5-NSL1-NRg-3":8441,
"SED5g5-NRD1-NRg-8":8442,
"SED5g5-RPB3-TRg-1":8443,
"SED5g5-NRD1-NRg-4":8444,
"SED5g5-RVB1-TRg-2":8445,
"SED5g5-TIF5-NRg-8":8446,
"SED5g5-EOS1-NRg-1":8447,
"SED5g5-ERG25-NA-26":8448,
"SED5g5-MSL5-NRg-4":8449,
"SED5g5-SEC24-TRg-2":8450,
"SED5g5-RPL30-NRg-5":8451,
"SED5g5-SNU71-NRg-3":8452,
"SED5g5-CDC33-NRg-1":8453,
"SED5g5-RPN6-TRg-4":8454,
"SED5g5-NAB2-TRg-4":8455,
"SED5g5-NAB2-TRg-6":8456,
"SED5g5-YTM1-NRg-1":8457,
"SED5g5-OLE1-TRg-8":8458,
"SED5g5-OLE1-TRg-1":8459,
"SED5g5-UTP7-TRg-4":8460,
"SED5g5-ACT1-NRg-6":8461,
"SED5g5-RPL18A-NRg-3":8462,
"SED5g5-BRX1-NRg-1":8463,
"SED5g5-NAF1-TRg-8":8464,
"SED5g5-NAF1-TRg-6":8465,
"SED5g5-NAF1-TRg-4":8466,
"SED5g5-CDC8-TRg-2":8467,
"SED5g5-NSE4-TRg-1":8468,
"SED5g5-PAB1-NRg-2":8469,
"SED5g5-PRP43-TRg-4":8470,
"SED5g5-SEC2-NRg-3":8471,
"SED5g5-SEC2-NRg-6":8472,
"SED5g5-MPP10-NRg-5":8473,
"SED5g5-YDR355C-TRg-2":8474,
"SED5g5-YLR339C-TRg-9":8475,
"SED5g5-SNM1-TRg-2":8476,
"SED5g5-ALR1-NRg-4":8477,
"SED5g5-ALR1-NRg-1":8478,
"SED5g5-ALR1-NRg-3":8479,
"SED5g5-RPL10-TRg-1":8480,
"SED5g5-RPL28-TRg-2":8481,
"SED5g5-UTP25-TRg-1":8482,
"SED5g5-POB3-TRg-1":8483,
"SED5g5-POB3-TRg-3":8484,
"SED5g5-POB3-TRg-2":8485,
"SED5g5-MED11-TRg-1":8486,
"SED5g5-ISA1-TRg-15":8487,
"SED5g5-RRP1-NRg-1":8488,
"SED5g5-MES1-NRg-1":8489,
"SED5g5-SEC13-NRg-5":8490,
"SED5g5-MCM2-NRg-2":8491,
"SED5g5-ALA1-TRg-4":8492,
"SED5g5-MTG2-TRg-5":8493,
"SED5g5-TIF35-NRg-3":8494,
"SED5g5-NSE1-TRg-3":8495,
"SED5g5-NSE1-TRg-4":8496,
"SED5g5-MOB2-NRg-6":8497,
"SED5g5-VRG4-NRg-3":8498,
"SED5g5-PRP9-TRg-3":8499,
"SED5g5-HYM1-TRg-5":8500,
"SED5g5-POP1-TRg-5":8501,
"SED5g5-POP1-TRg-9":8502,
"SED5g5-RPL17A-TRg-1":8503,
"SED5g5-SLD2-TRg-1":8504,
"SED5g5-CDC48-NRg-7":8505,
"SED5g5-FHL1-NRg-2":8506,
"SED5g5-BET3-NRg-7":8507,
"SED5g5-MAK21-TRg-1":8508,
"SED5g5-BRN1-TRg-4":8509,
"SED5g5-FBA1-NRg-3":8510,
"SED5g5-CDC42-TRg-6":8511,
"SED5g5-CDC42-TRg-7":8512,
"SED5g5-COG4-NRg-1":8513,
"SED5g5-ATP3-NRg-3":8514,
"SED5g5-ATP3-NRg-2":8515,
"SED5g5-SMP3-TRg-5":8516,
"SED5g5-CFT2-NRg-2":8517,
"SED5g5-FAS2-TRg-5":8518,
"SED5g5-DBP2-NRg-3":8519,
"SED5g5-DBP2-NRg-2":8520,
"SED5g5-MPS2-NRg-4":8521,
"SED5g5-ARC35-TRg-2":8522,
"SED5g5-ARC35-TRg-5":8523,
"SED5g5-MRD1-TRg-1":8524,
"SED5g5-RLP7-TRg-1":8525,
"SED5g5-SPC34-TRg-1":8526,
"SED5g5-CDC45-TRg-2":8527,
"SED5g5-GCD6-TRg-3":8528,
"SED5g5-GCD6-TRg-4":8529,
"SED5g5-YPT6-NRg-2":8530,
"SED5g5-RPS13-TRg-2":8531,
"SED5g5-IPI3-TRg-3":8532,
"SED5g5-TIF5-NRg-9":8533,
"SED5g5-TIF5-NRg-7":8534,
"SED5g5-TIF5-NRg-6":8535,
"SED5g5-NAB3-TRg-3":8536,
"SED5g5-GCD2-TRg-1":8537,
"SED5g5-UBA1-TRg-2":8538,
"SED5g5-SLD3-TRg-6":8539,
"SED5g5-LCB1-TRg-5":8540,
"SED5g5-TOA2-TRg-6":8541,
"SED5g5-TOA2-TRg-1":8542,
"SED5g5-TOA2-TRg-3":8543,
"SED5g5-LSM2-TRg-1":8544,
"SED5g5-YML6-TRg-13":8545,
"SED5g5-YML6-TRg-12":8546,
"SED5g5-UTP15-NRg-1":8547,
"SED5g5-TIF6-NRg-8":8548,
"SED5g5-SUP35-NRg-1":8549,
"SED5g5-MPP10-NRg-1":8550,
"SED5g5-SWI3-TRg-7":8551,
"SED5g5-SSN3-NRg-2":8552,
"SED5g5-SEC13-NRg-7":8553,
"SED5g5-RPS15-NRg-3":8554,
"SED5g5-RPL3-TRg-2":8555,
"SED5g5-FBA1-NRg-2":8556,
"SED5g5-FBA1-NRg-1":8557,
"SED5g5-FBA1-NRg-5":8558,
"SED5g5-DAM1-TRg-2":8559,
"SED5g5-NHP2-TRg-2":8560,
"SED5g5-HCA4-NRg-6":8561,
"SED5g5-PRE3-TRg-4":8562,
"SED5g5-DBP5-NRg-4":8563,
"SED5g5-SPT6-NRg-4":8564,
"SED5g5-SPT6-NRg-2":8565,
"SED5g5-RPL18A-TRg-4":8566,
"SED5g5-KSH1-TRg-1":8567,
"SED5g5-KSH1-TRg-3":8568,
"SED5g5-IPI3-NRg-1":8569,
"SED5g5-PGA2-TRg-8":8570,
"SED5g5-RPL18A-TRg-2":8571,
"SED5g5-RPL33A-NRg-6":8572,
"SED5g5-TAF12-NRg-2":8573,
"SED5g5-USE1-TRg-5":8574,
"SED5g5-YNL114C-TRg-1":8575,
"SED5g5-SMC5-TRg-7":8576,
"SED5g5-SMC5-TRg-6":8577,
"SED5g5-RSC58-TRg-1":8578,
"SED5g5-CTF13-TRg-2":8579,
"SED5g5-NAB2-NRg-2":8580,
"SED5g5-MCM7-TRg-4":8581,
"SED5g5-BCP1-NRg-5":8582,
"SED5g5-STU2-TRg-3":8583,
"SED5g5-SEC21-NRg-6":8584,
"SED5g5-SEC21-NRg-3":8585,
"SED5g5-RPL1B-TRg-3":8586,
"SED5g5-SEC20-NRg-2":8587,
"SED5g5-VMA3-NRg-2":8588,
"SED5g5-SEC23-NRg-5":8589,
"SED5g5-CDC28-TRg-4":8590,
"SED5g5-RPN12-NRg-11":8591,
"SED5g5-PUP3-TRg-3":8592,
"SED5g5-SEC31-TRg-2":8593,
"SED5g5-SED5-TRg-6":8594,
"SED5g5-SED5-TRg-5":8595,
"SED5g5-RPL33A-TRg-1":8596,
"SED5g5-RPL33A-TRg-2":8597,
"SED5g5-MRPL11-TRg-2":8598,
"SED5g5-RTP1-NRg-2":8599,
"SED5g5-NUG1-TRg-2":8600,
"SED5g5-VPH2-TRg-4":8601,
"SED5g5-COP1-NRg-3":8602,
"SED5g5-CRM1-NRg-1":8603,
"SED5g5-RPL5-NRg-4":8604,
"SED5g5-SNU13-NRg-4":8605,
"SED5g5-PFS2-TRg-3":8606,
"SED5g5-MPP10-TRg-2":8607,
"SED5g5-TSR4-NRg-2":8608,
"SED5g5-RSC2-TRg-1":8609,
"SED5g5-SEC65-TRg-2":8610,
"SED5g5-SMI1-NRg-1":8611,
"SED5g5-RTT105-NRg-4":8612,
"SED5g5-VMA5-TRg-3":8613,
"SED5g5-VMA5-TRg-5":8614,
"SED5g5-RRP1-TRg-3":8615,
"SED5g5-CLC1-TRg-2":8616,
"SED5g5-GCD6-NRg-1":8617,
"SED5g5-GCD6-NRg-2":8618,
"SED5g5-PXR1-TRg-1":8619,
"SED5g5-CDC14-NRg-1":8620,
"SED5g5-PCF11-TRg-6":8621,
"SED5g5-PCF11-TRg-5":8622,
"SED5g5-PCF11-TRg-4":8623,
"SED5g5-SEC31-NRg-1":8624,
"SED5g5-RRP5-NRg-1":8625,
"SED5g5-PRE10-TRg-5":8626,
"SED5g5-PRE10-TRg-1":8627,
"SED5g5-RPS5-TRg-2":8628,
"SED5g5-NSP1-TRg-4":8629,
"SED5g5-PRP38-TRg-4":8630,
"SED5g5-RCF1-NRg-5":8631,
"SED5g5-RSC3-TRg-4":8632,
"SED5g5-RSC3-TRg-5":8633,
"SED5g5-RSC3-TRg-6":8634,
"SED5g5-HTA1-NRg-12":8635,
"SED5g5-HTA1-NRg-11":8636,
"SED5g5-UTP23-TRg-2":8637,
"SED5g5-GCD7-NRg-1":8638,
"SED5g5-GCD7-NRg-2":8639,
"SED5g5-GCD7-NRg-6":8640,
"SED5g5-GAL11-NRg-2":8641,
"SED5g5-GAL11-NRg-9":8642,
"SED5g5-PHO4-TRg-5":8643,
"SED5g5-SNP1-NRg-3":8644,
"SED5g5-RPC37-TRg-5":8645,
"SED5g5-CRM1-TRg-5":8646,
"SED5g5-CRM1-TRg-2":8647,
"SED5g5-ASK1-TRg-7":8648,
"SED5g5-STU2-NRg-4":8649,
"SED5g5-NEO1-NRg-3":8650,
"SED5g5-GAL11-TRg-5":8651,
"SED5g5-GAL11-TRg-7":8652,
"SED5g5-SAM50-NRg-3":8653,
"SED5g5-CSL4-TRg-2":8654,
"SED5g5-CCT5-TRg-2":8655,
"SED5g5-POL30-NRg-1":8656,
"SED5g5-MED4-TRg-4":8657,
"SED5g5-MED4-TRg-3":8658,
"SED5g5-MED4-TRg-2":8659,
"SED5g5-GDI1-TRg-4":8660,
"SED5g5-GDI1-TRg-3":8661,
"SED5g5-REB1-TRg-6":8662,
"SED5g5-MRPL37-NRg-2":8663,
"SED5g5-NOC3-TRg-3":8664,
"SED5g5-SPC97-TRg-3":8665,
"SED5g5-IPP1-TRg-3":8666,
"SED5g5-IPP1-TRg-2":8667,
"SED5g5-PTI1-TRg-3":8668,
"SED5g5-PTI1-TRg-5":8669,
"SED5g5-RFC5-NRg-1":8670,
"SED5g5-CDC24-TRg-1":8671,
"SED5g5-CDC24-TRg-3":8672,
"SED5g5-CDC24-TRg-5":8673,
"SED5g5-CDC24-TRg-6":8674,
"SED5g5-UTP23-TRg-6":8675,
"SED5g5-UTP23-TRg-4":8676,
"SED5g5-UTP23-TRg-1":8677,
"SED5g5-RHO3-NRg-4":8678,
"SED5g5-TRS23-NRg-1":8679,
"SED5g5-TRS23-NRg-3":8680,
"SED5g5-RSP5-TRg-2":8681,
"SED5g5-RSP5-TRg-1":8682,
"SED5g5-SDA1-NRg-1":8683,
"SED5g5-KAP95-TRg-8":8684,
"SED5g5-ACO1-TRg-6":8685,
"SED5g5-HTA1-NRg-3":8686,
"SED5g5-HTA1-NRg-2":8687,
"SED5g5-SPN1-TRg-1":8688,
"SED5g5-MOT1-NRg-7":8689,
"SED5g5-RPL17A-NRg-4":8690,
"SED5g5-ADA2-TRg-4":8691,
"SED5g5-SFH1-NRg-1":8692,
"SED5g5-SPC97-NRg-5":8693,
"SED5g5-PRP22-TRg-3":8694,
"SED5g5-SEN15-TRg-2":8695,
"SED5g5-RPL3-NRg-2":8696,
"SED5g5-ISD11-NRg-2":8697,
"SED5g5-HEM12-TRg-8":8698,
"SED5g5-SEC10-TRg-1":8699,
"SED5g5-HTB1-TRg-7":8700,
"SED5g5-TTI2-TRg-1":8701,
"SED5g5-ACP1-TRg-2":8702,
"SED5g5-ACP1-TRg-4":8703,
"SED5g5-GAL11-NRg-10":8704,
"SED5g5-UTP22-TRg-2":8705,
"SED5g5-MST1-NRg-5":8706,
"SED5g5-RIB7-NRg-2":8707,
"SED5g5-MCD1-TRg-6":8708,
"SED5g5-MCD1-TRg-5":8709,
"SED5g5-GPI8-NRg-2":8710,
"SED5g5-THS1-TRg-2":8711,
"SED5g5-RRP7-TRg-2":8712,
"SED5g5-RRP7-TRg-5":8713,
"SED5g5-SMX2-NRg-7":8714,
"SED5g5-RRP45-TRg-5":8715,
"SED5g5-RRP45-TRg-4":8716,
"SED5g5-CNS1-TRg-2":8717,
"SED5g5-FBP1-NRg-9":8718,
"SED5g5-GCD11-NRg-1":8719,
"SED5g5-RPL10-TRg-2":8720,
"SED5g5-NUP192-TRg-4":8721,
"SED5g5-NUP145-NRg-4":8722,
"SED5g5-HEM12-TRg-6":8723,
"SED5g5-PLC1-TRg-3":8724,
"SED5g5-RPA43-TRg-1":8725,
"SED5g5-RPB7-NRg-2":8726,
"SED5g5-RPB7-NRg-3":8727,
"SED5g5-NSL1-NRg-1":8728,
"SED5g5-UTP6-TRg-3":8729,
"SED5g5-UTP6-TRg-1":8730,
"SED5g5-YJU2-TRg-5":8731,
"SED5g5-FRS2-NRg-5":8732,
"SED5g5-TIF35-NRg-2":8733,
"SED5g5-GPI15-TRg-1":8734,
"SED5g5-NOP1-NRg-5":8735,
"SED5g5-GPI15-TRg-4":8736,
"SED5g5-COG4-TRg-1":8737,
"SED5g5-TFA1-TRg-1":8738,
"SED5g5-RHO1-NRg-2":8739,
"SED5g5-RHO1-NRg-1":8740,
"SED5g5-CDC55-NRg-2":8741,
"SED5g5-IDI1-NRg-7":8742,
"SED5g5-RPL32-TRg-5":8743,
"SED5g5-RPB5-TRg-4":8744,
"SED5g5-DIP2-TRg-5":8745,
"SED5g5-DIP2-TRg-1":8746,
"SED5g5-RPC40-TRg-2":8747,
"SED5g5-CDC6-TRg-5":8748,
"SED5g5-CDC6-TRg-3":8749,
"SED5g5-DAD2-TRg-2":8750,
"SED5g5-RVS161-TRg-2":8751,
"SED5g5-RVS161-TRg-1":8752,
"SED5g5-SUP45-NRg-3":8753,
"SED5g5-SRB6-NRg-5":8754,
"SED5g5-RPC11-TRg-4":8755,
"SED5g5-RKI1-TRg-8":8756,
"SED5g5-NIP7-TRg-3":8757,
"SED5g5-RPL33A-NRg-12":8758,
"SED5g5-SAM50-TRg-4":8759,
"SED5g5-NOP4-NRg-1":8760,
"SED5g5-NOP4-NRg-3":8761,
"SED5g5-SMX2-TRg-5":8762,
"SED5g5-POL12-NRg-2":8763,
"SED5g5-BMS1-NRg-2":8764,
"SED5g5-RPA190-TRg-5":8765,
"SED5g5-ALG14-NRg-4":8766,
"SED5g5-ALG14-NRg-1":8767,
"SED5g5-PRE5-NRg-1":8768,
"SED5g5-BIG1-NRg-2":8769,
"SED5g5-TFA2-TRg-4":8770,
"SED5g5-IMP4-TRg-6":8771,
"SED5g5-PAN1-NRg-1":8772,
"SED5g5-UTP13-TRg-2":8773,
"SED5g5-KAE1-NRg-3":8774,
"SED5g5-ERG20-TRg-1":8775,
"SED5g5-CDC20-TRg-6":8776,
"SED5g5-PWP2-NRg-2":8777,
"SED5g5-COG1-NRg-1":8778,
"SED5g5-RPL1B-TRg-4":8779,
"SED5g5-RPL1B-TRg-7":8780,
"SED5g5-UTP20-TRg-3":8781,
"SED5g5-UTP20-TRg-4":8782,
"SED5g5-RPL25-TRg-4":8783,
"SED5g5-RPL25-TRg-2":8784,
"SED5g5-MCM7-NRg-1":8785,
"SED5g5-MRP49-TRg-5":8786,
"SED5g5-ERO1-NRg-3":8787,
"SED5g5-UTP5-TRg-7":8788,
"SED5g5-MCM4-NRg-1":8789,
"SED5g5-PRE3-NRg-1":8790,
"SED5g5-FCF1-NRg-1":8791,
"SED5g5-CUS1-NRg-1":8792,
"SED5g5-PSF1-TRg-2":8793,
"SED5g5-BCP1-TRg-2":8794,
"SED5g5-PAN1-TRg-1":8795,
"SED5g5-PAN1-TRg-3":8796,
"SED5g5-PAN1-TRg-4":8797,
"SED5g5-VPS3-TRg-2":8798,
"SED5g5-YIL060W-NRg-1":8799,
"SED5g5-VPS53-NRg-1":8800,
"SED5g5-CYR1-TRg-4":8801,
"SED5g5-CYR1-TRg-7":8802,
"SED5g5-MPS1-NRg-1":8803,
"SED5g5-SRP1-TRg-5":8804,
"SED5g5-SRP1-TRg-4":8805,
"SED5g5-TAF12-TRg-2":8806,
"SED5g5-TAF12-TRg-3":8807,
"SED5g5-POP4-TRg-1":8808,
"SED5g5-SPT16-TRg-1":8809,
"SED5g5-NUP82-TRg-4":8810,
"SED5g5-DML1-TRg-3":8811,
"SED5g5-RPA43-NRg-3":8812,
"SED5g5-STU2-NRg-3":8813,
"SED5g5-POP4-NRg-4":8814,
"SED5g5-MCD1-TRg-2":8815,
"SED5g5-RPS3-NRg-4":8816,
"SED5g5-PRP9-TRg-4":8817,
"SED5g5-RPP1-NRg-2":8818,
"SED5g5-MTR2-NRg-11":8819,
"SED5g5-GCD11-TRg-1":8820,
"SED5g5-RPF1-TRg-3":8821,
"SED5g5-SUB2-NRg-4":8822,
"SED5g5-GPI15-TRg-3":8823,
"SED5g5-ERG9-TRg-6":8824,
"SED5g5-RPT2-NRg-1":8825,
"SED5g5-YOS1-NRg-3":8826,
"SED5g5-SCM3-TRg-4":8827,
"SED5g5-SCM3-TRg-6":8828,
"SED5g5-RLP7-NRg-1":8829,
"SED5g5-TFB2-NRg-4":8830,
"SED5g5-IMP4-TRg-1":8831,
"SED5g5-IMP4-TRg-3":8832,
"SED5g5-PRE4-TRg-3":8833,
"SED5g5-SUB2-TRg-3":8834,
"SED5g5-RPP0-NRg-4":8835,
"SED5g5-RPP0-NRg-3":8836,
"SED5g5-TOM40-TRg-4":8837,
"SED5g5-FUR1-NRg-12":8838,
"SED5g5-TOM40-TRg-2":8839,
"SED5g5-VMA11-NRg-4":8840,
"SED5g5-PGS1-NRg-4":8841,
"SED5g5-URB1-TRg-4":8842,
"SED5g5-ARP4-TRg-3":8843,
"SED5g5-RPT3-TRg-3":8844,
"SED5g5-SUI3-TRg-3":8845,
"SED5g5-RFC5-NRg-2":8846,
"SED5g5-RRP14-TRg-2":8847,
"SED5g5-SCC2-TRg-1":8848,
"SED5g5-SSC1-TRg-3":8849,
"SED5g5-RRP9-TRg-3":8850,
"SED5g5-MOT1-NRg-9":8851,
"SED5g5-RPL42A-NRg-2":8852,
"SED5g5-SEC16-TRg-7":8853,
"SED5g5-IMP4-NRg-2":8854,
"SED5g5-YEF3-NRg-4":8855,
"SED5g5-PUP1-TRg-1":8856,
"SED5g5-UTP22-TRg-6":8857,
"SED5g5-DBP2-NRg-4":8858,
"SED5g5-PRE2-TRg-7":8859,
"SED5g5-ATP16-TRg-6":8860,
"SED5g5-UTP13-TRg-4":8861,
"SED5g5-DOP1-NRg-4":8862,
"SED5g5-TIM44-TRg-3":8863,
"SED5g5-ATP16-TRg-2":8864,
"SED5g5-ENP1-NRg-3":8865,
"SED5g5-NAF1-TRg-3":8866,
"SED5g5-COG4-TRg-2":8867,
"SED5g5-SOG2-TRg-7":8868,
"SED5g5-YDR341C-TRg-3":8869,
"SED5g5-YMR290W-A-TRg-10":8870,
"SED5g5-NUP192-NRg-9":8871,
"SED5g5-RPS31-NRg-8":8872,
"SED5g5-SPC97-NRg-6":8873,
"SED5g5-EBP2-NRg-1":8874,
"SED5g5-CDC48-TRg-5":8875,
"SED5g5-RPT1-TRg-4":8876,
"SED5g5-ULP1-NRg-2":8877,
"SED5g5-RPN3-TRg-6":8878,
"SED5g5-RPT1-TRg-5":8879,
"SED5g5-KRE5-TRg-2":8880,
"SED5g5-TBF1-NRg-8":8881,
"SED5g5-UTP22-NRg-4":8882,
"SED5g5-SSC1-NRg-4":8883,
"SED5g5-REB1-TRg-4":8884,
"SED5g5-CDC48-NRg-9":8885,
"SED5g5-FAS2-TRg-8":8886,
"SED5g5-TAO3-TRg-8":8887,
"SED5g5-CKS1-TRg-5":8888,
"SED5g5-YLR379W-TRg-7":8889,
"SED5g5-TEN1-NRg-2":8890,
"SED5g5-RPL42A-TRg-2":8891,
"SED5g5-SEC27-TRg-4":8892,
"SED5g5-TBF1-NRg-4":8893,
"SED5g5-RPT1-NRg-6":8894,
"SED5g5-COG1-TRg-3":8895,
"SED5g5-SUI1-TRg-6":8896,
"SED5g5-TIM23-TRg-6":8897,
"SED5g5-CDC48-NRg-6":8898,
"SED5g5-EPL1-TRg-5":8899,
"SED5g5-RPT5-TRg-8":8900,
"SED5g5-ATP16-NRg-4":8901,
"SED5g5-RPN6-TRg-3":8902,
"SED5g5-ERG9-NRg-6":8903,
"SED5g5-SMX3-TRg-1":8904,
"SED5g5-NCB2-NRg-3":8905,
"SED5g5-SEC16-NRg-12":8906,
"SED5g5-RPN6-TRg-2":8907,
"SED5g5-REB1-NRg-4":8908,
"SED5g5-ATP16-TRg-9":8909,
"SED5g5-ERG9-NRg-7":8910,
"SEC22g1-RPL15A-NRg-4":8911,
"SEC22g1-RPL15A-NRg-5":8912,
"SEC22g1-KRE33-TRg-1":8913,
"SEC22g1-PMI40-NRg-1":8914,
"SEC22g1-NOP19-NRg-3":8915,
"SEC22g1-SRP14-NRg-4":8916,
"SEC22g1-SEC27-TRg-2":8917,
"SEC22g1-GPI14-TRg-3":8918,
"SEC22g1-PAH1-TRg-7":8919,
"SEC22g1-PAH1-TRg-6":8920,
"SEC22g1-PAH1-TRg-5":8921,
"SEC22g1-PAH1-TRg-3":8922,
"SEC22g1-COG3-TRg-1":8923,
"SEC22g1-HTS1-NRg-5":8924,
"SEC22g1-MSN5-TRg-7":8925,
"SEC22g1-ERG26-TRg-1":8926,
"SEC22g1-SMD2-TRg-5":8927,
"SEC22g1-SMD2-TRg-4":8928,
"SEC22g1-SMD2-TRg-1":8929,
"SEC22g1-PRE7-TRg-4":8930,
"SEC22g1-PRE7-TRg-7":8931,
"SEC22g1-SEC6-TRg-3":8932,
"SEC22g1-ESF2-NRg-1":8933,
"SEC22g1-ESF2-NRg-3":8934,
"SEC22g1-AFG2-TRg-2":8935,
"SEC22g1-RRP36-TRg-3":8936,
"SEC22g1-RRP36-TRg-5":8937,
"SEC22g1-GCR1-NRg-2":8938,
"SEC22g1-PRE4-NRg-4":8939,
"SEC22g1-PRE4-NRg-9":8940,
"SEC22g1-DSN1-NRg-2":8941,
"SEC22g1-GPI11-TRg-3":8942,
"SEC22g1-POP3-TRg-1":8943,
"SEC22g1-MNE1-TRg-5":8944,
"SEC22g1-RRP12-NRg-1":8945,
"SEC22g1-RSC6-TRg-2":8946,
"SEC22g1-CDC25-TRg-1":8947,
"SEC22g1-CDC25-TRg-9":8948,
"SEC22g1-YPP1-NRg-3":8949,
"SEC22g1-NFS1-NRg-9":8950,
"SEC22g1-NFS1-NRg-8":8951,
"SEC22g1-UBA2-TRg-1":8952,
"SEC22g1-ARP2-NRg-3":8953,
"SEC22g1-MAK16-TRg-1":8954,
"SEC22g1-CEP3-NRg-1":8955,
"SEC22g1-GUK1-TRg-5":8956,
"SEC22g1-GUK1-TRg-2":8957,
"SEC22g1-GPI12-NRg-6":8958,
"SEC22g1-RPS5-NRg-5":8959,
"SEC22g1-RPS5-NRg-2":8960,
"SEC22g1-RPC19-NRg-1":8961,
"SEC22g1-TIM54-TRg-1":8962,
"SEC22g1-TEN1-TRg-2":8963,
"SEC22g1-SAH1-NRg-4":8964,
"SEC22g1-SAH1-NRg-5":8965,
"SEC22g1-SAH1-NRg-3":8966,
"SEC22g1-ATP15-NRg-5":8967,
"SEC22g1-SCD5-TRg-5":8968,
"SEC22g1-ARB1-NRg-2":8969,
"SEC22g1-ARB1-NRg-4":8970,
"SEC22g1-PUP2-TRg-1":8971,
"SEC22g1-CCT8-TRg-2":8972,
"SEC22g1-MCM4-TRg-1":8973,
"SEC22g1-LSM4-TRg-1":8974,
"SEC22g1-NOP53-NRg-1":8975,
"SEC22g1-ATP3-TRg-4":8976,
"SEC22g1-AFG2-NRg-3":8977,
"SEC22g1-PRO3-NRg-3":8978,
"SEC22g1-NRD1-NRg-10":8979,
"SEC22g1-SEC61-TRg-2":8980,
"SEC22g1-RHO3-TRg-4":8981,
"SEC22g1-SNF2-TRg-6":8982,
"SEC22g1-SMD2-NRg-3":8983,
"SEC22g1-RSC4-TRg-2":8984,
"SEC22g1-RSC4-TRg-1":8985,
"SEC22g1-TIF34-TRg-2":8986,
"SEC22g1-BET1-NRg-1":8987,
"SEC22g1-CDC8-NRg-2":8988,
"SEC22g1-PRP42-TRg-2":8989,
"SEC22g1-RRB1-TRg-2":8990,
"SEC22g1-SPC24-TRg-1":8991,
"SEC22g1-ILS1-NRg-1":8992,
"SEC22g1-GFA1-TRg-2":8993,
"SEC22g1-SEC21-NRg-10":8994,
"SEC22g1-RPC10-NRg-1":8995,
"SEC22g1-RPB10-TRg-3":8996,
"SEC22g1-RPB10-TRg-2":8997,
"SEC22g1-YNL181W-TRg-1":8998,
"SEC22g1-RAD3-NRg-1":8999,
"SEC22g1-NOP10-TRg-1":9000,
"SEC22g1-BFR2-TRg-3":9001,
"SEC22g1-MCM2-TRg-6":9002,
"SEC22g1-MCM2-TRg-4":9003,
"SEC22g1-MPP10-TRg-1":9004,
"SEC22g1-RET2-TRg-4":9005,
"SEC22g1-RET2-TRg-1":9006,
"SEC22g1-RPS2-NRg-1":9007,
"SEC22g1-RPS2-NRg-2":9008,
"SEC22g1-ORC4-NRg-3":9009,
"SEC22g1-TIP20-TRg-7":9010,
"SEC22g1-SMT3-TRg-1":9011,
"SEC22g1-MSS18-NRg-6":9012,
"SEC22g1-YEF3-NRg-9":9013,
"SEC22g1-ASK1-NRg-1":9014,
"SEC22g1-SMC1-TRg-1":9015,
"SEC22g1-NIP1-NRg-1":9016,
"SEC22g1-RPP1-NRg-1":9017,
"SEC22g1-YDJ1-TRg-6":9018,
"SEC22g1-SUB2-NRg-1":9019,
"SEC22g1-TIM10-NRg-8":9020,
"SEC22g1-TIM10-NRg-4":9021,
"SEC22g1-TIM10-NRg-7":9022,
"SEC22g1-SKI6-TRg-4":9023,
"SEC22g1-TUB4-TRg-1":9024,
"SEC22g1-CDC37-NRg-2":9025,
"SEC22g1-ISD11-TRg-3":9026,
"SEC22g1-YOS1-TRg-4":9027,
"SEC22g1-SSC1-TRg-6":9028,
"SEC22g1-MTR3-TRg-5":9029,
"SEC22g1-MTR3-TRg-6":9030,
"SEC22g1-TFA1-TRg-2":9031,
"SEC22g1-CDC3-NRg-3":9032,
"SEC22g1-ERG25-TA-18":9033,
"SEC22g1-RPB11-TRg-4":9034,
"SEC22g1-RPB11-TRg-1":9035,
"SEC22g1-RPB11-TRg-2":9036,
"SEC22g1-DED1-TRg-3":9037,
"SEC22g1-DED1-TRg-1":9038,
"SEC22g1-DED1-TRg-6":9039,
"SEC22g1-DED1-TRg-4":9040,
"SEC22g1-RPL10-NRg-5":9041,
"SEC22g1-RPL10-NRg-4":9042,
"SEC22g1-EFB1-NRg-1":9043,
"SEC22g1-EFB1-NRg-5":9044,
"SEC22g1-EFB1-NRg-4":9045,
"SEC22g1-RPT3-NRg-1":9046,
"SEC22g1-SAC6-TRg-8":9047,
"SEC22g1-SAC6-TRg-4":9048,
"SEC22g1-SAC6-TRg-5":9049,
"SEC22g1-SAC6-TRg-3":9050,
"SEC22g1-DIM1-TRg-5":9051,
"SEC22g1-DIM1-TRg-7":9052,
"SEC22g1-RPC17-NRg-1":9053,
"SEC22g1-RPC17-NRg-2":9054,
"SEC22g1-YDR341C-TRg-1":9055,
"SEC22g1-RAP1-NRg-8":9056,
"SEC22g1-RAP1-NRg-5":9057,
"SEC22g1-RAP1-NRg-2":9058,
"SEC22g1-SEC26-NRg-3":9059,
"SEC22g1-SPP41-TRg-3":9060,
"SEC22g1-TAP42-NRg-1":9061,
"SEC22g1-PGA2-TRg-6":9062,
"SEC22g1-BRL1-TRg-1":9063,
"SEC22g1-FOL2-TRg-1":9064,
"SEC22g1-NAB3-NRg-5":9065,
"SEC22g1-SNF4-TRg-4":9066,
"SEC22g1-HRR25-TRg-2":9067,
"SEC22g1-TRS23-TRg-4":9068,
"SEC22g1-CTR86-TRg-4":9069,
"SEC22g1-RPB5-TRg-5":9070,
"SEC22g1-SPN1-NRg-2":9071,
"SEC22g1-SPN1-NRg-1":9072,
"SEC22g1-SEC61-NRg-1":9073,
"SEC22g1-SEC61-NRg-7":9074,
"SEC22g1-TUS1-TRg-3":9075,
"SEC22g1-OLE1-NRg-2":9076,
"SEC22g1-AFG2-TRg-1":9077,
"SEC22g1-TOA2-NRg-1":9078,
"SEC22g1-USO1-TRg-1":9079,
"SEC22g1-UTP22-NRg-2":9080,
"SEC22g1-RIB1-TRg-3":9081,
"SEC22g1-RIB1-TRg-7":9082,
"SEC22g1-RIB1-TRg-4":9083,
"SEC22g1-COG1-TRg-1":9084,
"SEC22g1-RPL32-NRg-2":9085,
"SEC22g1-GLC7-NRg-3":9086,
"SEC22g1-GLC7-NRg-4":9087,
"SEC22g1-HSF1-TRg-2":9088,
"SEC22g1-DAM1-NRg-5":9089,
"SEC22g1-SEC18-TRg-4":9090,
"SEC22g1-SEC18-TRg-5":9091,
"SEC22g1-PAB1-NRg-3":9092,
"SEC22g1-POP8-TRg-2":9093,
"SEC22g1-PAB1-NRg-4":9094,
"SEC22g1-BIG1-TRg-4":9095,
"SEC22g1-BIG1-TRg-5":9096,
"SEC22g1-BIG1-TRg-6":9097,
"SEC22g1-RPO41-NRg-1":9098,
"SEC22g1-RVB2-NRg-2":9099,
"SEC22g1-PET117-NRg-8":9100,
"SEC22g1-VPS45-NRg-9":9101,
"SEC22g1-YCG1-NRg-1":9102,
"SEC22g1-NOC4-NRg-1":9103,
"SEC22g1-NMD3-NRg-2":9104,
"SEC22g1-DRS1-TRg-2":9105,
"SEC22g1-HTB1-NRg-2":9106,
"SEC22g1-IPI1-TRg-2":9107,
"SEC22g1-SEC18-NRg-1":9108,
"SEC22g1-SEC18-NRg-2":9109,
"SEC22g1-JIP5-NRg-2":9110,
"SEC22g1-YPT1-TRg-3":9111,
"SEC22g1-YPT1-TRg-2":9112,
"SEC22g1-CLF1-NRg-2":9113,
"SEC22g1-SNF2-NRg-7":9114,
"SEC22g1-SNF2-NRg-4":9115,
"SEC22g1-RPL25-NRg-1":9116,
"SEC22g1-NOP56-TRg-1":9117,
"SEC22g1-NOP56-TRg-2":9118,
"SEC22g1-TRS31-TRg-1":9119,
"SEC22g1-DBF4-TRg-2":9120,
"SEC22g1-DBF4-TRg-1":9121,
"SEC22g1-RPC19-TRg-4":9122,
"SEC22g1-RPC19-TRg-6":9123,
"SEC22g1-RPC19-TRg-3":9124,
"SEC22g1-ROK1-NRg-1":9125,
"SEC22g1-CDC33-TRg-4":9126,
"SEC22g1-DHR2-TRg-3":9127,
"SEC22g1-RRP42-NRg-5":9128,
"SEC22g1-CLF1-TRg-1":9129,
"SEC22g1-ERG11-NA-16":9130,
"SEC22g1-VAS1-NRg-4":9131,
"SEC22g1-PIK1-NRg-2":9132,
"SEC22g1-SAR1-NRg-7":9133,
"SEC22g1-SAR1-NRg-4":9134,
"SEC22g1-RPS3-TRg-1":9135,
"SEC22g1-YTM1-TRg-2":9136,
"SEC22g1-SUI3-NRg-5":9137,
"SEC22g1-SUI3-NRg-2":9138,
"SEC22g1-RRP7-TRg-4":9139,
"SEC22g1-RRP7-TRg-6":9140,
"SEC22g1-NIP7-TRg-2":9141,
"SEC22g1-MDM35-TRg-1":9142,
"SEC22g1-ALA1-NRg-1":9143,
"SEC22g1-DOA4-NRg-2":9144,
"SEC22g1-RPS13-NRg-1":9145,
"SEC22g1-YSF3-TRg-2":9146,
"SEC22g1-RPS2-NRg-11":9147,
"SEC22g1-SSL1-TRg-10":9148,
"SEC22g1-NIP7-TRg-1":9149,
"SEC22g1-LST8-NRg-1":9150,
"SEC22g1-TAF4-TRg-3":9151,
"SEC22g1-HAS1-TRg-2":9152,
"SEC22g1-GLC7-TRg-2":9153,
"SEC22g1-CDC45-NRg-1":9154,
"SEC22g1-SEC22-NRg-8":9155,
"SEC22g1-YOS1-TRg-2":9156,
"SEC22g1-RBA50-TRg-3":9157,
"SEC22g1-SPP41-NRg-2":9158,
"SEC22g1-PRP46-TRg-2":9159,
"SEC22g1-PGA2-NRg-1":9160,
"SEC22g1-CBF5-TRg-3":9161,
"SEC22g1-TCP1-NRg-3":9162,
"SEC22g1-TCP1-NRg-2":9163,
"SEC22g1-ERG26-NRg-2":9164,
"SEC22g1-ERG26-NRg-4":9165,
"SEC22g1-MES1-TRg-5":9166,
"SEC22g1-HTS1-TRg-2":9167,
"SEC22g1-SSS1-TRg-3":9168,
"SEC22g1-SSS1-TRg-2":9169,
"SEC22g1-SYS1-TRg-7":9170,
"SEC22g1-SYS1-TRg-2":9171,
"SEC22g1-SYS1-TRg-1":9172,
"SEC22g1-BFR2-TRg-1":9173,
"SEC22g1-EOS1-TRg-3":9174,
"SEC22g1-TAF4-NRg-1":9175,
"SEC22g1-ARL3-NRg-8":9176,
"SEC22g1-RPN5-NRg-1":9177,
"SEC22g1-TIM9-NRg-2":9178,
"SEC22g1-NUP57-NRg-3":9179,
"SEC22g1-VPS4-TRg-1":9180,
"SEC22g1-CDC3-TRg-4":9181,
"SEC22g1-BBP1-NRg-1":9182,
"SEC22g1-BBP1-NRg-2":9183,
"SEC22g1-USE1-NRg-3":9184,
"SEC22g1-CCT7-TRg-1":9185,
"SEC22g1-SAH1-TRg-3":9186,
"SEC22g1-CHS2-TRg-1":9187,
"SEC22g1-DPM1-TRg-2":9188,
"SEC22g1-BBP1-TRg-1":9189,
"SEC22g1-NRD1-TRg-4":9190,
"SEC22g1-RPB3-NRg-1":9191,
"SEC22g1-PHO85-NRg-6":9192,
"SEC22g1-SNF6-TRg-6":9193,
"SEC22g1-PRP38-NRg-2":9194,
"SEC22g1-OAR1-NRg-3":9195,
"SEC22g1-ROX3-NRg-1":9196,
"SEC22g1-YPP1-TRg-6":9197,
"SEC22g1-CBF2-NRg-8":9198,
"SEC22g1-SPT6-TRg-5":9199,
"SEC22g1-SEC10-NRg-1":9200,
"SEC22g1-NSL1-NRg-3":9201,
"SEC22g1-NRD1-NRg-8":9202,
"SEC22g1-RPB3-TRg-1":9203,
"SEC22g1-NRD1-NRg-4":9204,
"SEC22g1-RVB1-TRg-2":9205,
"SEC22g1-TIF5-NRg-8":9206,
"SEC22g1-EOS1-NRg-1":9207,
"SEC22g1-ERG25-NA-26":9208,
"SEC22g1-MSL5-NRg-4":9209,
"SEC22g1-SEC24-TRg-2":9210,
"SEC22g1-RPL30-NRg-5":9211,
"SEC22g1-SNU71-NRg-3":9212,
"SEC22g1-CDC33-NRg-1":9213,
"SEC22g1-RPN6-TRg-4":9214,
"SEC22g1-NAB2-TRg-4":9215,
"SEC22g1-NAB2-TRg-6":9216,
"SEC22g1-YTM1-NRg-1":9217,
"SEC22g1-OLE1-TRg-8":9218,
"SEC22g1-OLE1-TRg-1":9219,
"SEC22g1-UTP7-TRg-4":9220,
"SEC22g1-ACT1-NRg-6":9221,
"SEC22g1-RPL18A-NRg-3":9222,
"SEC22g1-BRX1-NRg-1":9223,
"SEC22g1-NAF1-TRg-8":9224,
"SEC22g1-NAF1-TRg-6":9225,
"SEC22g1-NAF1-TRg-4":9226,
"SEC22g1-CDC8-TRg-2":9227,
"SEC22g1-NSE4-TRg-1":9228,
"SEC22g1-PAB1-NRg-2":9229,
"SEC22g1-PRP43-TRg-4":9230,
"SEC22g1-SEC2-NRg-3":9231,
"SEC22g1-SEC2-NRg-6":9232,
"SEC22g1-MPP10-NRg-5":9233,
"SEC22g1-YDR355C-TRg-2":9234,
"SEC22g1-YLR339C-TRg-9":9235,
"SEC22g1-SNM1-TRg-2":9236,
"SEC22g1-ALR1-NRg-4":9237,
"SEC22g1-ALR1-NRg-1":9238,
"SEC22g1-ALR1-NRg-3":9239,
"SEC22g1-RPL10-TRg-1":9240,
"SEC22g1-RPL28-TRg-2":9241,
"SEC22g1-UTP25-TRg-1":9242,
"SEC22g1-POB3-TRg-1":9243,
"SEC22g1-POB3-TRg-3":9244,
"SEC22g1-POB3-TRg-2":9245,
"SEC22g1-MED11-TRg-1":9246,
"SEC22g1-ISA1-TRg-15":9247,
"SEC22g1-RRP1-NRg-1":9248,
"SEC22g1-MES1-NRg-1":9249,
"SEC22g1-SEC13-NRg-5":9250,
"SEC22g1-MCM2-NRg-2":9251,
"SEC22g1-ALA1-TRg-4":9252,
"SEC22g1-MTG2-TRg-5":9253,
"SEC22g1-TIF35-NRg-3":9254,
"SEC22g1-NSE1-TRg-3":9255,
"SEC22g1-NSE1-TRg-4":9256,
"SEC22g1-MOB2-NRg-6":9257,
"SEC22g1-VRG4-NRg-3":9258,
"SEC22g1-PRP9-TRg-3":9259,
"SEC22g1-HYM1-TRg-5":9260,
"SEC22g1-POP1-TRg-5":9261,
"SEC22g1-POP1-TRg-9":9262,
"SEC22g1-RPL17A-TRg-1":9263,
"SEC22g1-SLD2-TRg-1":9264,
"SEC22g1-CDC48-NRg-7":9265,
"SEC22g1-FHL1-NRg-2":9266,
"SEC22g1-BET3-NRg-7":9267,
"SEC22g1-MAK21-TRg-1":9268,
"SEC22g1-BRN1-TRg-4":9269,
"SEC22g1-FBA1-NRg-3":9270,
"SEC22g1-CDC42-TRg-6":9271,
"SEC22g1-CDC42-TRg-7":9272,
"SEC22g1-COG4-NRg-1":9273,
"SEC22g1-ATP3-NRg-3":9274,
"SEC22g1-ATP3-NRg-2":9275,
"SEC22g1-SMP3-TRg-5":9276,
"SEC22g1-CFT2-NRg-2":9277,
"SEC22g1-FAS2-TRg-5":9278,
"SEC22g1-DBP2-NRg-3":9279,
"SEC22g1-DBP2-NRg-2":9280,
"SEC22g1-MPS2-NRg-4":9281,
"SEC22g1-ARC35-TRg-2":9282,
"SEC22g1-ARC35-TRg-5":9283,
"SEC22g1-MRD1-TRg-1":9284,
"SEC22g1-RLP7-TRg-1":9285,
"SEC22g1-SPC34-TRg-1":9286,
"SEC22g1-CDC45-TRg-2":9287,
"SEC22g1-GCD6-TRg-3":9288,
"SEC22g1-GCD6-TRg-4":9289,
"SEC22g1-YPT6-NRg-2":9290,
"SEC22g1-RPS13-TRg-2":9291,
"SEC22g1-IPI3-TRg-3":9292,
"SEC22g1-TIF5-NRg-9":9293,
"SEC22g1-TIF5-NRg-7":9294,
"SEC22g1-TIF5-NRg-6":9295,
"SEC22g1-NAB3-TRg-3":9296,
"SEC22g1-GCD2-TRg-1":9297,
"SEC22g1-UBA1-TRg-2":9298,
"SEC22g1-SLD3-TRg-6":9299,
"SEC22g1-LCB1-TRg-5":9300,
"SEC22g1-TOA2-TRg-6":9301,
"SEC22g1-TOA2-TRg-1":9302,
"SEC22g1-TOA2-TRg-3":9303,
"SEC22g1-LSM2-TRg-1":9304,
"SEC22g1-YML6-TRg-13":9305,
"SEC22g1-YML6-TRg-12":9306,
"SEC22g1-UTP15-NRg-1":9307,
"SEC22g1-TIF6-NRg-8":9308,
"SEC22g1-SUP35-NRg-1":9309,
"SEC22g1-MPP10-NRg-1":9310,
"SEC22g1-SWI3-TRg-7":9311,
"SEC22g1-SSN3-NRg-2":9312,
"SEC22g1-SEC13-NRg-7":9313,
"SEC22g1-RPS15-NRg-3":9314,
"SEC22g1-RPL3-TRg-2":9315,
"SEC22g1-FBA1-NRg-2":9316,
"SEC22g1-FBA1-NRg-1":9317,
"SEC22g1-FBA1-NRg-5":9318,
"SEC22g1-DAM1-TRg-2":9319,
"SEC22g1-NHP2-TRg-2":9320,
"SEC22g1-HCA4-NRg-6":9321,
"SEC22g1-PRE3-TRg-4":9322,
"SEC22g1-DBP5-NRg-4":9323,
"SEC22g1-SPT6-NRg-4":9324,
"SEC22g1-SPT6-NRg-2":9325,
"SEC22g1-RPL18A-TRg-4":9326,
"SEC22g1-KSH1-TRg-1":9327,
"SEC22g1-KSH1-TRg-3":9328,
"SEC22g1-IPI3-NRg-1":9329,
"SEC22g1-PGA2-TRg-8":9330,
"SEC22g1-RPL18A-TRg-2":9331,
"SEC22g1-RPL33A-NRg-6":9332,
"SEC22g1-TAF12-NRg-2":9333,
"SEC22g1-USE1-TRg-5":9334,
"SEC22g1-YNL114C-TRg-1":9335,
"SEC22g1-SMC5-TRg-7":9336,
"SEC22g1-SMC5-TRg-6":9337,
"SEC22g1-RSC58-TRg-1":9338,
"SEC22g1-CTF13-TRg-2":9339,
"SEC22g1-NAB2-NRg-2":9340,
"SEC22g1-MCM7-TRg-4":9341,
"SEC22g1-BCP1-NRg-5":9342,
"SEC22g1-STU2-TRg-3":9343,
"SEC22g1-SEC21-NRg-6":9344,
"SEC22g1-SEC21-NRg-3":9345,
"SEC22g1-RPL1B-TRg-3":9346,
"SEC22g1-SEC20-NRg-2":9347,
"SEC22g1-VMA3-NRg-2":9348,
"SEC22g1-SEC23-NRg-5":9349,
"SEC22g1-CDC28-TRg-4":9350,
"SEC22g1-RPN12-NRg-11":9351,
"SEC22g1-PUP3-TRg-3":9352,
"SEC22g1-SEC31-TRg-2":9353,
"SEC22g1-SED5-TRg-6":9354,
"SEC22g1-SED5-TRg-5":9355,
"SEC22g1-RPL33A-TRg-1":9356,
"SEC22g1-RPL33A-TRg-2":9357,
"SEC22g1-MRPL11-TRg-2":9358,
"SEC22g1-RTP1-NRg-2":9359,
"SEC22g1-NUG1-TRg-2":9360,
"SEC22g1-VPH2-TRg-4":9361,
"SEC22g1-COP1-NRg-3":9362,
"SEC22g1-CRM1-NRg-1":9363,
"SEC22g1-RPL5-NRg-4":9364,
"SEC22g1-SNU13-NRg-4":9365,
"SEC22g1-PFS2-TRg-3":9366,
"SEC22g1-MPP10-TRg-2":9367,
"SEC22g1-TSR4-NRg-2":9368,
"SEC22g1-RSC2-TRg-1":9369,
"SEC22g1-SEC65-TRg-2":9370,
"SEC22g1-SMI1-NRg-1":9371,
"SEC22g1-RTT105-NRg-4":9372,
"SEC22g1-VMA5-TRg-3":9373,
"SEC22g1-VMA5-TRg-5":9374,
"SEC22g1-RRP1-TRg-3":9375,
"SEC22g1-CLC1-TRg-2":9376,
"SEC22g1-GCD6-NRg-1":9377,
"SEC22g1-GCD6-NRg-2":9378,
"SEC22g1-PXR1-TRg-1":9379,
"SEC22g1-CDC14-NRg-1":9380,
"SEC22g1-PCF11-TRg-6":9381,
"SEC22g1-PCF11-TRg-5":9382,
"SEC22g1-PCF11-TRg-4":9383,
"SEC22g1-SEC31-NRg-1":9384,
"SEC22g1-RRP5-NRg-1":9385,
"SEC22g1-PRE10-TRg-5":9386,
"SEC22g1-PRE10-TRg-1":9387,
"SEC22g1-RPS5-TRg-2":9388,
"SEC22g1-NSP1-TRg-4":9389,
"SEC22g1-PRP38-TRg-4":9390,
"SEC22g1-RCF1-NRg-5":9391,
"SEC22g1-RSC3-TRg-4":9392,
"SEC22g1-RSC3-TRg-5":9393,
"SEC22g1-RSC3-TRg-6":9394,
"SEC22g1-HTA1-NRg-12":9395,
"SEC22g1-HTA1-NRg-11":9396,
"SEC22g1-UTP23-TRg-2":9397,
"SEC22g1-GCD7-NRg-1":9398,
"SEC22g1-GCD7-NRg-2":9399,
"SEC22g1-GCD7-NRg-6":9400,
"SEC22g1-GAL11-NRg-2":9401,
"SEC22g1-GAL11-NRg-9":9402,
"SEC22g1-PHO4-TRg-5":9403,
"SEC22g1-SNP1-NRg-3":9404,
"SEC22g1-RPC37-TRg-5":9405,
"SEC22g1-CRM1-TRg-5":9406,
"SEC22g1-CRM1-TRg-2":9407,
"SEC22g1-ASK1-TRg-7":9408,
"SEC22g1-STU2-NRg-4":9409,
"SEC22g1-NEO1-NRg-3":9410,
"SEC22g1-GAL11-TRg-5":9411,
"SEC22g1-GAL11-TRg-7":9412,
"SEC22g1-SAM50-NRg-3":9413,
"SEC22g1-CSL4-TRg-2":9414,
"SEC22g1-CCT5-TRg-2":9415,
"SEC22g1-POL30-NRg-1":9416,
"SEC22g1-MED4-TRg-4":9417,
"SEC22g1-MED4-TRg-3":9418,
"SEC22g1-MED4-TRg-2":9419,
"SEC22g1-GDI1-TRg-4":9420,
"SEC22g1-GDI1-TRg-3":9421,
"SEC22g1-REB1-TRg-6":9422,
"SEC22g1-MRPL37-NRg-2":9423,
"SEC22g1-NOC3-TRg-3":9424,
"SEC22g1-SPC97-TRg-3":9425,
"SEC22g1-IPP1-TRg-3":9426,
"SEC22g1-IPP1-TRg-2":9427,
"SEC22g1-PTI1-TRg-3":9428,
"SEC22g1-PTI1-TRg-5":9429,
"SEC22g1-RFC5-NRg-1":9430,
"SEC22g1-CDC24-TRg-1":9431,
"SEC22g1-CDC24-TRg-3":9432,
"SEC22g1-CDC24-TRg-5":9433,
"SEC22g1-CDC24-TRg-6":9434,
"SEC22g1-UTP23-TRg-6":9435,
"SEC22g1-UTP23-TRg-4":9436,
"SEC22g1-UTP23-TRg-1":9437,
"SEC22g1-RHO3-NRg-4":9438,
"SEC22g1-TRS23-NRg-1":9439,
"SEC22g1-TRS23-NRg-3":9440,
"SEC22g1-RSP5-TRg-2":9441,
"SEC22g1-RSP5-TRg-1":9442,
"SEC22g1-SDA1-NRg-1":9443,
"SEC22g1-KAP95-TRg-8":9444,
"SEC22g1-ACO1-TRg-6":9445,
"SEC22g1-HTA1-NRg-3":9446,
"SEC22g1-HTA1-NRg-2":9447,
"SEC22g1-SPN1-TRg-1":9448,
"SEC22g1-MOT1-NRg-7":9449,
"SEC22g1-RPL17A-NRg-4":9450,
"SEC22g1-ADA2-TRg-4":9451,
"SEC22g1-SFH1-NRg-1":9452,
"SEC22g1-SPC97-NRg-5":9453,
"SEC22g1-PRP22-TRg-3":9454,
"SEC22g1-SEN15-TRg-2":9455,
"SEC22g1-RPL3-NRg-2":9456,
"SEC22g1-ISD11-NRg-2":9457,
"SEC22g1-HEM12-TRg-8":9458,
"SEC22g1-SEC10-TRg-1":9459,
"SEC22g1-HTB1-TRg-7":9460,
"SEC22g1-TTI2-TRg-1":9461,
"SEC22g1-ACP1-TRg-2":9462,
"SEC22g1-ACP1-TRg-4":9463,
"SEC22g1-GAL11-NRg-10":9464,
"SEC22g1-UTP22-TRg-2":9465,
"SEC22g1-MST1-NRg-5":9466,
"SEC22g1-RIB7-NRg-2":9467,
"SEC22g1-MCD1-TRg-6":9468,
"SEC22g1-MCD1-TRg-5":9469,
"SEC22g1-GPI8-NRg-2":9470,
"SEC22g1-THS1-TRg-2":9471,
"SEC22g1-RRP7-TRg-2":9472,
"SEC22g1-RRP7-TRg-5":9473,
"SEC22g1-SMX2-NRg-7":9474,
"SEC22g1-RRP45-TRg-5":9475,
"SEC22g1-RRP45-TRg-4":9476,
"SEC22g1-CNS1-TRg-2":9477,
"SEC22g1-FBP1-NRg-9":9478,
"SEC22g1-GCD11-NRg-1":9479,
"SEC22g1-RPL10-TRg-2":9480,
"SEC22g1-NUP192-TRg-4":9481,
"SEC22g1-NUP145-NRg-4":9482,
"SEC22g1-HEM12-TRg-6":9483,
"SEC22g1-PLC1-TRg-3":9484,
"SEC22g1-RPA43-TRg-1":9485,
"SEC22g1-RPB7-NRg-2":9486,
"SEC22g1-RPB7-NRg-3":9487,
"SEC22g1-NSL1-NRg-1":9488,
"SEC22g1-UTP6-TRg-3":9489,
"SEC22g1-UTP6-TRg-1":9490,
"SEC22g1-YJU2-TRg-5":9491,
"SEC22g1-FRS2-NRg-5":9492,
"SEC22g1-TIF35-NRg-2":9493,
"SEC22g1-GPI15-TRg-1":9494,
"SEC22g1-NOP1-NRg-5":9495,
"SEC22g1-GPI15-TRg-4":9496,
"SEC22g1-COG4-TRg-1":9497,
"SEC22g1-TFA1-TRg-1":9498,
"SEC22g1-RHO1-NRg-2":9499,
"SEC22g1-RHO1-NRg-1":9500,
"SEC22g1-CDC55-NRg-2":9501,
"SEC22g1-IDI1-NRg-7":9502,
"SEC22g1-RPL32-TRg-5":9503,
"SEC22g1-RPB5-TRg-4":9504,
"SEC22g1-DIP2-TRg-5":9505,
"SEC22g1-DIP2-TRg-1":9506,
"SEC22g1-RPC40-TRg-2":9507,
"SEC22g1-CDC6-TRg-5":9508,
"SEC22g1-CDC6-TRg-3":9509,
"SEC22g1-DAD2-TRg-2":9510,
"SEC22g1-RVS161-TRg-2":9511,
"SEC22g1-RVS161-TRg-1":9512,
"SEC22g1-SUP45-NRg-3":9513,
"SEC22g1-SRB6-NRg-5":9514,
"SEC22g1-RPC11-TRg-4":9515,
"SEC22g1-RKI1-TRg-8":9516,
"SEC22g1-NIP7-TRg-3":9517,
"SEC22g1-RPL33A-NRg-12":9518,
"SEC22g1-SAM50-TRg-4":9519,
"SEC22g1-NOP4-NRg-1":9520,
"SEC22g1-NOP4-NRg-3":9521,
"SEC22g1-SMX2-TRg-5":9522,
"SEC22g1-POL12-NRg-2":9523,
"SEC22g1-BMS1-NRg-2":9524,
"SEC22g1-RPA190-TRg-5":9525,
"SEC22g1-ALG14-NRg-4":9526,
"SEC22g1-ALG14-NRg-1":9527,
"SEC22g1-PRE5-NRg-1":9528,
"SEC22g1-BIG1-NRg-2":9529,
"SEC22g1-TFA2-TRg-4":9530,
"SEC22g1-IMP4-TRg-6":9531,
"SEC22g1-PAN1-NRg-1":9532,
"SEC22g1-UTP13-TRg-2":9533,
"SEC22g1-KAE1-NRg-3":9534,
"SEC22g1-ERG20-TRg-1":9535,
"SEC22g1-CDC20-TRg-6":9536,
"SEC22g1-PWP2-NRg-2":9537,
"SEC22g1-COG1-NRg-1":9538,
"SEC22g1-RPL1B-TRg-4":9539,
"SEC22g1-RPL1B-TRg-7":9540,
"SEC22g1-UTP20-TRg-3":9541,
"SEC22g1-UTP20-TRg-4":9542,
"SEC22g1-RPL25-TRg-4":9543,
"SEC22g1-RPL25-TRg-2":9544,
"SEC22g1-MCM7-NRg-1":9545,
"SEC22g1-MRP49-TRg-5":9546,
"SEC22g1-ERO1-NRg-3":9547,
"SEC22g1-UTP5-TRg-7":9548,
"SEC22g1-MCM4-NRg-1":9549,
"SEC22g1-PRE3-NRg-1":9550,
"SEC22g1-FCF1-NRg-1":9551,
"SEC22g1-CUS1-NRg-1":9552,
"SEC22g1-PSF1-TRg-2":9553,
"SEC22g1-BCP1-TRg-2":9554,
"SEC22g1-PAN1-TRg-1":9555,
"SEC22g1-PAN1-TRg-3":9556,
"SEC22g1-PAN1-TRg-4":9557,
"SEC22g1-VPS3-TRg-2":9558,
"SEC22g1-YIL060W-NRg-1":9559,
"SEC22g1-VPS53-NRg-1":9560,
"SEC22g1-CYR1-TRg-4":9561,
"SEC22g1-CYR1-TRg-7":9562,
"SEC22g1-MPS1-NRg-1":9563,
"SEC22g1-SRP1-TRg-5":9564,
"SEC22g1-SRP1-TRg-4":9565,
"SEC22g1-TAF12-TRg-2":9566,
"SEC22g1-TAF12-TRg-3":9567,
"SEC22g1-POP4-TRg-1":9568,
"SEC22g1-SPT16-TRg-1":9569,
"SEC22g1-NUP82-TRg-4":9570,
"SEC22g1-DML1-TRg-3":9571,
"SEC22g1-RPA43-NRg-3":9572,
"SEC22g1-STU2-NRg-3":9573,
"SEC22g1-POP4-NRg-4":9574,
"SEC22g1-MCD1-TRg-2":9575,
"SEC22g1-RPS3-NRg-4":9576,
"SEC22g1-PRP9-TRg-4":9577,
"SEC22g1-RPP1-NRg-2":9578,
"SEC22g1-MTR2-NRg-11":9579,
"SEC22g1-GCD11-TRg-1":9580,
"SEC22g1-RPF1-TRg-3":9581,
"SEC22g1-SUB2-NRg-4":9582,
"SEC22g1-GPI15-TRg-3":9583,
"SEC22g1-ERG9-TRg-6":9584,
"SEC22g1-RPT2-NRg-1":9585,
"SEC22g1-YOS1-NRg-3":9586,
"SEC22g1-SCM3-TRg-4":9587,
"SEC22g1-SCM3-TRg-6":9588,
"SEC22g1-RLP7-NRg-1":9589,
"SEC22g1-TFB2-NRg-4":9590,
"SEC22g1-IMP4-TRg-1":9591,
"SEC22g1-IMP4-TRg-3":9592,
"SEC22g1-PRE4-TRg-3":9593,
"SEC22g1-SUB2-TRg-3":9594,
"SEC22g1-RPP0-NRg-4":9595,
"SEC22g1-RPP0-NRg-3":9596,
"SEC22g1-TOM40-TRg-4":9597,
"SEC22g1-FUR1-NRg-12":9598,
"SEC22g1-TOM40-TRg-2":9599,
"SEC22g1-VMA11-NRg-4":9600,
"SEC22g1-PGS1-NRg-4":9601,
"SEC22g1-URB1-TRg-4":9602,
"SEC22g1-ARP4-TRg-3":9603,
"SEC22g1-RPT3-TRg-3":9604,
"SEC22g1-SUI3-TRg-3":9605,
"SEC22g1-RFC5-NRg-2":9606,
"SEC22g1-RRP14-TRg-2":9607,
"SEC22g1-SCC2-TRg-1":9608,
"SEC22g1-SSC1-TRg-3":9609,
"SEC22g1-RRP9-TRg-3":9610,
"SEC22g1-MOT1-NRg-9":9611,
"SEC22g1-RPL42A-NRg-2":9612,
"SEC22g1-SEC16-TRg-7":9613,
"SEC22g1-IMP4-NRg-2":9614,
"SEC22g1-YEF3-NRg-4":9615,
"SEC22g1-PUP1-TRg-1":9616,
"SEC22g1-UTP22-TRg-6":9617,
"SEC22g1-DBP2-NRg-4":9618,
"SEC22g1-PRE2-TRg-7":9619,
"SEC22g1-ATP16-TRg-6":9620,
"SEC22g1-UTP13-TRg-4":9621,
"SEC22g1-DOP1-NRg-4":9622,
"SEC22g1-TIM44-TRg-3":9623,
"SEC22g1-ATP16-TRg-2":9624,
"SEC22g1-ENP1-NRg-3":9625,
"SEC22g1-NAF1-TRg-3":9626,
"SEC22g1-COG4-TRg-2":9627,
"SEC22g1-SOG2-TRg-7":9628,
"SEC22g1-YDR341C-TRg-3":9629,
"SEC22g1-YMR290W-A-TRg-10":9630,
"SEC22g1-NUP192-NRg-9":9631,
"SEC22g1-RPS31-NRg-8":9632,
"SEC22g1-SPC97-NRg-6":9633,
"SEC22g1-EBP2-NRg-1":9634,
"SEC22g1-CDC48-TRg-5":9635,
"SEC22g1-RPT1-TRg-4":9636,
"SEC22g1-ULP1-NRg-2":9637,
"SEC22g1-RPN3-TRg-6":9638,
"SEC22g1-RPT1-TRg-5":9639,
"SEC22g1-KRE5-TRg-2":9640,
"SEC22g1-TBF1-NRg-8":9641,
"SEC22g1-UTP22-NRg-4":9642,
"SEC22g1-SSC1-NRg-4":9643,
"SEC22g1-REB1-TRg-4":9644,
"SEC22g1-CDC48-NRg-9":9645,
"SEC22g1-FAS2-TRg-8":9646,
"SEC22g1-TAO3-TRg-8":9647,
"SEC22g1-CKS1-TRg-5":9648,
"SEC22g1-YLR379W-TRg-7":9649,
"SEC22g1-TEN1-NRg-2":9650,
"SEC22g1-RPL42A-TRg-2":9651,
"SEC22g1-SEC27-TRg-4":9652,
"SEC22g1-TBF1-NRg-4":9653,
"SEC22g1-RPT1-NRg-6":9654,
"SEC22g1-COG1-TRg-3":9655,
"SEC22g1-SUI1-TRg-6":9656,
"SEC22g1-TIM23-TRg-6":9657,
"SEC22g1-CDC48-NRg-6":9658,
"SEC22g1-EPL1-TRg-5":9659,
"SEC22g1-RPT5-TRg-8":9660,
"SEC22g1-ATP16-NRg-4":9661,
"SEC22g1-RPN6-TRg-3":9662,
"SEC22g1-ERG9-NRg-6":9663,
"SEC22g1-SMX3-TRg-1":9664,
"SEC22g1-NCB2-NRg-3":9665,
"SEC22g1-SEC16-NRg-12":9666,
"SEC22g1-RPN6-TRg-2":9667,
"SEC22g1-REB1-NRg-4":9668,
"SEC22g1-ATP16-TRg-9":9669,
"SEC22g1-ERG9-NRg-7":9670,
"SEC22g2-RPL15A-NRg-4":9671,
"SEC22g2-RPL15A-NRg-5":9672,
"SEC22g2-KRE33-TRg-1":9673,
"SEC22g2-PMI40-NRg-1":9674,
"SEC22g2-NOP19-NRg-3":9675,
"SEC22g2-SRP14-NRg-4":9676,
"SEC22g2-SEC27-TRg-2":9677,
"SEC22g2-GPI14-TRg-3":9678,
"SEC22g2-PAH1-TRg-7":9679,
"SEC22g2-PAH1-TRg-6":9680,
"SEC22g2-PAH1-TRg-5":9681,
"SEC22g2-PAH1-TRg-3":9682,
"SEC22g2-COG3-TRg-1":9683,
"SEC22g2-HTS1-NRg-5":9684,
"SEC22g2-MSN5-TRg-7":9685,
"SEC22g2-ERG26-TRg-1":9686,
"SEC22g2-SMD2-TRg-5":9687,
"SEC22g2-SMD2-TRg-4":9688,
"SEC22g2-SMD2-TRg-1":9689,
"SEC22g2-PRE7-TRg-4":9690,
"SEC22g2-PRE7-TRg-7":9691,
"SEC22g2-SEC6-TRg-3":9692,
"SEC22g2-ESF2-NRg-1":9693,
"SEC22g2-ESF2-NRg-3":9694,
"SEC22g2-AFG2-TRg-2":9695,
"SEC22g2-RRP36-TRg-3":9696,
"SEC22g2-RRP36-TRg-5":9697,
"SEC22g2-GCR1-NRg-2":9698,
"SEC22g2-PRE4-NRg-4":9699,
"SEC22g2-PRE4-NRg-9":9700,
"SEC22g2-DSN1-NRg-2":9701,
"SEC22g2-GPI11-TRg-3":9702,
"SEC22g2-POP3-TRg-1":9703,
"SEC22g2-MNE1-TRg-5":9704,
"SEC22g2-RRP12-NRg-1":9705,
"SEC22g2-RSC6-TRg-2":9706,
"SEC22g2-CDC25-TRg-1":9707,
"SEC22g2-CDC25-TRg-9":9708,
"SEC22g2-YPP1-NRg-3":9709,
"SEC22g2-NFS1-NRg-9":9710,
"SEC22g2-NFS1-NRg-8":9711,
"SEC22g2-UBA2-TRg-1":9712,
"SEC22g2-ARP2-NRg-3":9713,
"SEC22g2-MAK16-TRg-1":9714,
"SEC22g2-CEP3-NRg-1":9715,
"SEC22g2-GUK1-TRg-5":9716,
"SEC22g2-GUK1-TRg-2":9717,
"SEC22g2-GPI12-NRg-6":9718,
"SEC22g2-RPS5-NRg-5":9719,
"SEC22g2-RPS5-NRg-2":9720,
"SEC22g2-RPC19-NRg-1":9721,
"SEC22g2-TIM54-TRg-1":9722,
"SEC22g2-TEN1-TRg-2":9723,
"SEC22g2-SAH1-NRg-4":9724,
"SEC22g2-SAH1-NRg-5":9725,
"SEC22g2-SAH1-NRg-3":9726,
"SEC22g2-ATP15-NRg-5":9727,
"SEC22g2-SCD5-TRg-5":9728,
"SEC22g2-ARB1-NRg-2":9729,
"SEC22g2-ARB1-NRg-4":9730,
"SEC22g2-PUP2-TRg-1":9731,
"SEC22g2-CCT8-TRg-2":9732,
"SEC22g2-MCM4-TRg-1":9733,
"SEC22g2-LSM4-TRg-1":9734,
"SEC22g2-NOP53-NRg-1":9735,
"SEC22g2-ATP3-TRg-4":9736,
"SEC22g2-AFG2-NRg-3":9737,
"SEC22g2-PRO3-NRg-3":9738,
"SEC22g2-NRD1-NRg-10":9739,
"SEC22g2-SEC61-TRg-2":9740,
"SEC22g2-RHO3-TRg-4":9741,
"SEC22g2-SNF2-TRg-6":9742,
"SEC22g2-SMD2-NRg-3":9743,
"SEC22g2-RSC4-TRg-2":9744,
"SEC22g2-RSC4-TRg-1":9745,
"SEC22g2-TIF34-TRg-2":9746,
"SEC22g2-BET1-NRg-1":9747,
"SEC22g2-CDC8-NRg-2":9748,
"SEC22g2-PRP42-TRg-2":9749,
"SEC22g2-RRB1-TRg-2":9750,
"SEC22g2-SPC24-TRg-1":9751,
"SEC22g2-ILS1-NRg-1":9752,
"SEC22g2-GFA1-TRg-2":9753,
"SEC22g2-SEC21-NRg-10":9754,
"SEC22g2-RPC10-NRg-1":9755,
"SEC22g2-RPB10-TRg-3":9756,
"SEC22g2-RPB10-TRg-2":9757,
"SEC22g2-YNL181W-TRg-1":9758,
"SEC22g2-RAD3-NRg-1":9759,
"SEC22g2-NOP10-TRg-1":9760,
"SEC22g2-BFR2-TRg-3":9761,
"SEC22g2-MCM2-TRg-6":9762,
"SEC22g2-MCM2-TRg-4":9763,
"SEC22g2-MPP10-TRg-1":9764,
"SEC22g2-RET2-TRg-4":9765,
"SEC22g2-RET2-TRg-1":9766,
"SEC22g2-RPS2-NRg-1":9767,
"SEC22g2-RPS2-NRg-2":9768,
"SEC22g2-ORC4-NRg-3":9769,
"SEC22g2-TIP20-TRg-7":9770,
"SEC22g2-SMT3-TRg-1":9771,
"SEC22g2-MSS18-NRg-6":9772,
"SEC22g2-YEF3-NRg-9":9773,
"SEC22g2-ASK1-NRg-1":9774,
"SEC22g2-SMC1-TRg-1":9775,
"SEC22g2-NIP1-NRg-1":9776,
"SEC22g2-RPP1-NRg-1":9777,
"SEC22g2-YDJ1-TRg-6":9778,
"SEC22g2-SUB2-NRg-1":9779,
"SEC22g2-TIM10-NRg-8":9780,
"SEC22g2-TIM10-NRg-4":9781,
"SEC22g2-TIM10-NRg-7":9782,
"SEC22g2-SKI6-TRg-4":9783,
"SEC22g2-TUB4-TRg-1":9784,
"SEC22g2-CDC37-NRg-2":9785,
"SEC22g2-ISD11-TRg-3":9786,
"SEC22g2-YOS1-TRg-4":9787,
"SEC22g2-SSC1-TRg-6":9788,
"SEC22g2-MTR3-TRg-5":9789,
"SEC22g2-MTR3-TRg-6":9790,
"SEC22g2-TFA1-TRg-2":9791,
"SEC22g2-CDC3-NRg-3":9792,
"SEC22g2-ERG25-TA-18":9793,
"SEC22g2-RPB11-TRg-4":9794,
"SEC22g2-RPB11-TRg-1":9795,
"SEC22g2-RPB11-TRg-2":9796,
"SEC22g2-DED1-TRg-3":9797,
"SEC22g2-DED1-TRg-1":9798,
"SEC22g2-DED1-TRg-6":9799,
"SEC22g2-DED1-TRg-4":9800,
"SEC22g2-RPL10-NRg-5":9801,
"SEC22g2-RPL10-NRg-4":9802,
"SEC22g2-EFB1-NRg-1":9803,
"SEC22g2-EFB1-NRg-5":9804,
"SEC22g2-EFB1-NRg-4":9805,
"SEC22g2-RPT3-NRg-1":9806,
"SEC22g2-SAC6-TRg-8":9807,
"SEC22g2-SAC6-TRg-4":9808,
"SEC22g2-SAC6-TRg-5":9809,
"SEC22g2-SAC6-TRg-3":9810,
"SEC22g2-DIM1-TRg-5":9811,
"SEC22g2-DIM1-TRg-7":9812,
"SEC22g2-RPC17-NRg-1":9813,
"SEC22g2-RPC17-NRg-2":9814,
"SEC22g2-YDR341C-TRg-1":9815,
"SEC22g2-RAP1-NRg-8":9816,
"SEC22g2-RAP1-NRg-5":9817,
"SEC22g2-RAP1-NRg-2":9818,
"SEC22g2-SEC26-NRg-3":9819,
"SEC22g2-SPP41-TRg-3":9820,
"SEC22g2-TAP42-NRg-1":9821,
"SEC22g2-PGA2-TRg-6":9822,
"SEC22g2-BRL1-TRg-1":9823,
"SEC22g2-FOL2-TRg-1":9824,
"SEC22g2-NAB3-NRg-5":9825,
"SEC22g2-SNF4-TRg-4":9826,
"SEC22g2-HRR25-TRg-2":9827,
"SEC22g2-TRS23-TRg-4":9828,
"SEC22g2-CTR86-TRg-4":9829,
"SEC22g2-RPB5-TRg-5":9830,
"SEC22g2-SPN1-NRg-2":9831,
"SEC22g2-SPN1-NRg-1":9832,
"SEC22g2-SEC61-NRg-1":9833,
"SEC22g2-SEC61-NRg-7":9834,
"SEC22g2-TUS1-TRg-3":9835,
"SEC22g2-OLE1-NRg-2":9836,
"SEC22g2-AFG2-TRg-1":9837,
"SEC22g2-TOA2-NRg-1":9838,
"SEC22g2-USO1-TRg-1":9839,
"SEC22g2-UTP22-NRg-2":9840,
"SEC22g2-RIB1-TRg-3":9841,
"SEC22g2-RIB1-TRg-7":9842,
"SEC22g2-RIB1-TRg-4":9843,
"SEC22g2-COG1-TRg-1":9844,
"SEC22g2-RPL32-NRg-2":9845,
"SEC22g2-GLC7-NRg-3":9846,
"SEC22g2-GLC7-NRg-4":9847,
"SEC22g2-HSF1-TRg-2":9848,
"SEC22g2-DAM1-NRg-5":9849,
"SEC22g2-SEC18-TRg-4":9850,
"SEC22g2-SEC18-TRg-5":9851,
"SEC22g2-PAB1-NRg-3":9852,
"SEC22g2-POP8-TRg-2":9853,
"SEC22g2-PAB1-NRg-4":9854,
"SEC22g2-BIG1-TRg-4":9855,
"SEC22g2-BIG1-TRg-5":9856,
"SEC22g2-BIG1-TRg-6":9857,
"SEC22g2-RPO41-NRg-1":9858,
"SEC22g2-RVB2-NRg-2":9859,
"SEC22g2-PET117-NRg-8":9860,
"SEC22g2-VPS45-NRg-9":9861,
"SEC22g2-YCG1-NRg-1":9862,
"SEC22g2-NOC4-NRg-1":9863,
"SEC22g2-NMD3-NRg-2":9864,
"SEC22g2-DRS1-TRg-2":9865,
"SEC22g2-HTB1-NRg-2":9866,
"SEC22g2-IPI1-TRg-2":9867,
"SEC22g2-SEC18-NRg-1":9868,
"SEC22g2-SEC18-NRg-2":9869,
"SEC22g2-JIP5-NRg-2":9870,
"SEC22g2-YPT1-TRg-3":9871,
"SEC22g2-YPT1-TRg-2":9872,
"SEC22g2-CLF1-NRg-2":9873,
"SEC22g2-SNF2-NRg-7":9874,
"SEC22g2-SNF2-NRg-4":9875,
"SEC22g2-RPL25-NRg-1":9876,
"SEC22g2-NOP56-TRg-1":9877,
"SEC22g2-NOP56-TRg-2":9878,
"SEC22g2-TRS31-TRg-1":9879,
"SEC22g2-DBF4-TRg-2":9880,
"SEC22g2-DBF4-TRg-1":9881,
"SEC22g2-RPC19-TRg-4":9882,
"SEC22g2-RPC19-TRg-6":9883,
"SEC22g2-RPC19-TRg-3":9884,
"SEC22g2-ROK1-NRg-1":9885,
"SEC22g2-CDC33-TRg-4":9886,
"SEC22g2-DHR2-TRg-3":9887,
"SEC22g2-RRP42-NRg-5":9888,
"SEC22g2-CLF1-TRg-1":9889,
"SEC22g2-ERG11-NA-16":9890,
"SEC22g2-VAS1-NRg-4":9891,
"SEC22g2-PIK1-NRg-2":9892,
"SEC22g2-SAR1-NRg-7":9893,
"SEC22g2-SAR1-NRg-4":9894,
"SEC22g2-RPS3-TRg-1":9895,
"SEC22g2-YTM1-TRg-2":9896,
"SEC22g2-SUI3-NRg-5":9897,
"SEC22g2-SUI3-NRg-2":9898,
"SEC22g2-RRP7-TRg-4":9899,
"SEC22g2-RRP7-TRg-6":9900,
"SEC22g2-NIP7-TRg-2":9901,
"SEC22g2-MDM35-TRg-1":9902,
"SEC22g2-ALA1-NRg-1":9903,
"SEC22g2-DOA4-NRg-2":9904,
"SEC22g2-RPS13-NRg-1":9905,
"SEC22g2-YSF3-TRg-2":9906,
"SEC22g2-RPS2-NRg-11":9907,
"SEC22g2-SSL1-TRg-10":9908,
"SEC22g2-NIP7-TRg-1":9909,
"SEC22g2-LST8-NRg-1":9910,
"SEC22g2-TAF4-TRg-3":9911,
"SEC22g2-HAS1-TRg-2":9912,
"SEC22g2-GLC7-TRg-2":9913,
"SEC22g2-CDC45-NRg-1":9914,
"SEC22g2-SEC22-NRg-8":9915,
"SEC22g2-YOS1-TRg-2":9916,
"SEC22g2-RBA50-TRg-3":9917,
"SEC22g2-SPP41-NRg-2":9918,
"SEC22g2-PRP46-TRg-2":9919,
"SEC22g2-PGA2-NRg-1":9920,
"SEC22g2-CBF5-TRg-3":9921,
"SEC22g2-TCP1-NRg-3":9922,
"SEC22g2-TCP1-NRg-2":9923,
"SEC22g2-ERG26-NRg-2":9924,
"SEC22g2-ERG26-NRg-4":9925,
"SEC22g2-MES1-TRg-5":9926,
"SEC22g2-HTS1-TRg-2":9927,
"SEC22g2-SSS1-TRg-3":9928,
"SEC22g2-SSS1-TRg-2":9929,
"SEC22g2-SYS1-TRg-7":9930,
"SEC22g2-SYS1-TRg-2":9931,
"SEC22g2-SYS1-TRg-1":9932,
"SEC22g2-BFR2-TRg-1":9933,
"SEC22g2-EOS1-TRg-3":9934,
"SEC22g2-TAF4-NRg-1":9935,
"SEC22g2-ARL3-NRg-8":9936,
"SEC22g2-RPN5-NRg-1":9937,
"SEC22g2-TIM9-NRg-2":9938,
"SEC22g2-NUP57-NRg-3":9939,
"SEC22g2-VPS4-TRg-1":9940,
"SEC22g2-CDC3-TRg-4":9941,
"SEC22g2-BBP1-NRg-1":9942,
"SEC22g2-BBP1-NRg-2":9943,
"SEC22g2-USE1-NRg-3":9944,
"SEC22g2-CCT7-TRg-1":9945,
"SEC22g2-SAH1-TRg-3":9946,
"SEC22g2-CHS2-TRg-1":9947,
"SEC22g2-DPM1-TRg-2":9948,
"SEC22g2-BBP1-TRg-1":9949,
"SEC22g2-NRD1-TRg-4":9950,
"SEC22g2-RPB3-NRg-1":9951,
"SEC22g2-PHO85-NRg-6":9952,
"SEC22g2-SNF6-TRg-6":9953,
"SEC22g2-PRP38-NRg-2":9954,
"SEC22g2-OAR1-NRg-3":9955,
"SEC22g2-ROX3-NRg-1":9956,
"SEC22g2-YPP1-TRg-6":9957,
"SEC22g2-CBF2-NRg-8":9958,
"SEC22g2-SPT6-TRg-5":9959,
"SEC22g2-SEC10-NRg-1":9960,
"SEC22g2-NSL1-NRg-3":9961,
"SEC22g2-NRD1-NRg-8":9962,
"SEC22g2-RPB3-TRg-1":9963,
"SEC22g2-NRD1-NRg-4":9964,
"SEC22g2-RVB1-TRg-2":9965,
"SEC22g2-TIF5-NRg-8":9966,
"SEC22g2-EOS1-NRg-1":9967,
"SEC22g2-ERG25-NA-26":9968,
"SEC22g2-MSL5-NRg-4":9969,
"SEC22g2-SEC24-TRg-2":9970,
"SEC22g2-RPL30-NRg-5":9971,
"SEC22g2-SNU71-NRg-3":9972,
"SEC22g2-CDC33-NRg-1":9973,
"SEC22g2-RPN6-TRg-4":9974,
"SEC22g2-NAB2-TRg-4":9975,
"SEC22g2-NAB2-TRg-6":9976,
"SEC22g2-YTM1-NRg-1":9977,
"SEC22g2-OLE1-TRg-8":9978,
"SEC22g2-OLE1-TRg-1":9979,
"SEC22g2-UTP7-TRg-4":9980,
"SEC22g2-ACT1-NRg-6":9981,
"SEC22g2-RPL18A-NRg-3":9982,
"SEC22g2-BRX1-NRg-1":9983,
"SEC22g2-NAF1-TRg-8":9984,
"SEC22g2-NAF1-TRg-6":9985,
"SEC22g2-NAF1-TRg-4":9986,
"SEC22g2-CDC8-TRg-2":9987,
"SEC22g2-NSE4-TRg-1":9988,
"SEC22g2-PAB1-NRg-2":9989,
"SEC22g2-PRP43-TRg-4":9990,
"SEC22g2-SEC2-NRg-3":9991,
"SEC22g2-SEC2-NRg-6":9992,
"SEC22g2-MPP10-NRg-5":9993,
"SEC22g2-YDR355C-TRg-2":9994,
"SEC22g2-YLR339C-TRg-9":9995,
"SEC22g2-SNM1-TRg-2":9996,
"SEC22g2-ALR1-NRg-4":9997,
"SEC22g2-ALR1-NRg-1":9998,
"SEC22g2-ALR1-NRg-3":9999,
"SEC22g2-RPL10-TRg-1":10000,
"SEC22g2-RPL28-TRg-2":10001,
"SEC22g2-UTP25-TRg-1":10002,
"SEC22g2-POB3-TRg-1":10003,
"SEC22g2-POB3-TRg-3":10004,
"SEC22g2-POB3-TRg-2":10005,
"SEC22g2-MED11-TRg-1":10006,
"SEC22g2-ISA1-TRg-15":10007,
"SEC22g2-RRP1-NRg-1":10008,
"SEC22g2-MES1-NRg-1":10009,
"SEC22g2-SEC13-NRg-5":10010,
"SEC22g2-MCM2-NRg-2":10011,
"SEC22g2-ALA1-TRg-4":10012,
"SEC22g2-MTG2-TRg-5":10013,
"SEC22g2-TIF35-NRg-3":10014,
"SEC22g2-NSE1-TRg-3":10015,
"SEC22g2-NSE1-TRg-4":10016,
"SEC22g2-MOB2-NRg-6":10017,
"SEC22g2-VRG4-NRg-3":10018,
"SEC22g2-PRP9-TRg-3":10019,
"SEC22g2-HYM1-TRg-5":10020,
"SEC22g2-POP1-TRg-5":10021,
"SEC22g2-POP1-TRg-9":10022,
"SEC22g2-RPL17A-TRg-1":10023,
"SEC22g2-SLD2-TRg-1":10024,
"SEC22g2-CDC48-NRg-7":10025,
"SEC22g2-FHL1-NRg-2":10026,
"SEC22g2-BET3-NRg-7":10027,
"SEC22g2-MAK21-TRg-1":10028,
"SEC22g2-BRN1-TRg-4":10029,
"SEC22g2-FBA1-NRg-3":10030,
"SEC22g2-CDC42-TRg-6":10031,
"SEC22g2-CDC42-TRg-7":10032,
"SEC22g2-COG4-NRg-1":10033,
"SEC22g2-ATP3-NRg-3":10034,
"SEC22g2-ATP3-NRg-2":10035,
"SEC22g2-SMP3-TRg-5":10036,
"SEC22g2-CFT2-NRg-2":10037,
"SEC22g2-FAS2-TRg-5":10038,
"SEC22g2-DBP2-NRg-3":10039,
"SEC22g2-DBP2-NRg-2":10040,
"SEC22g2-MPS2-NRg-4":10041,
"SEC22g2-ARC35-TRg-2":10042,
"SEC22g2-ARC35-TRg-5":10043,
"SEC22g2-MRD1-TRg-1":10044,
"SEC22g2-RLP7-TRg-1":10045,
"SEC22g2-SPC34-TRg-1":10046,
"SEC22g2-CDC45-TRg-2":10047,
"SEC22g2-GCD6-TRg-3":10048,
"SEC22g2-GCD6-TRg-4":10049,
"SEC22g2-YPT6-NRg-2":10050,
"SEC22g2-RPS13-TRg-2":10051,
"SEC22g2-IPI3-TRg-3":10052,
"SEC22g2-TIF5-NRg-9":10053,
"SEC22g2-TIF5-NRg-7":10054,
"SEC22g2-TIF5-NRg-6":10055,
"SEC22g2-NAB3-TRg-3":10056,
"SEC22g2-GCD2-TRg-1":10057,
"SEC22g2-UBA1-TRg-2":10058,
"SEC22g2-SLD3-TRg-6":10059,
"SEC22g2-LCB1-TRg-5":10060,
"SEC22g2-TOA2-TRg-6":10061,
"SEC22g2-TOA2-TRg-1":10062,
"SEC22g2-TOA2-TRg-3":10063,
"SEC22g2-LSM2-TRg-1":10064,
"SEC22g2-YML6-TRg-13":10065,
"SEC22g2-YML6-TRg-12":10066,
"SEC22g2-UTP15-NRg-1":10067,
"SEC22g2-TIF6-NRg-8":10068,
"SEC22g2-SUP35-NRg-1":10069,
"SEC22g2-MPP10-NRg-1":10070,
"SEC22g2-SWI3-TRg-7":10071,
"SEC22g2-SSN3-NRg-2":10072,
"SEC22g2-SEC13-NRg-7":10073,
"SEC22g2-RPS15-NRg-3":10074,
"SEC22g2-RPL3-TRg-2":10075,
"SEC22g2-FBA1-NRg-2":10076,
"SEC22g2-FBA1-NRg-1":10077,
"SEC22g2-FBA1-NRg-5":10078,
"SEC22g2-DAM1-TRg-2":10079,
"SEC22g2-NHP2-TRg-2":10080,
"SEC22g2-HCA4-NRg-6":10081,
"SEC22g2-PRE3-TRg-4":10082,
"SEC22g2-DBP5-NRg-4":10083,
"SEC22g2-SPT6-NRg-4":10084,
"SEC22g2-SPT6-NRg-2":10085,
"SEC22g2-RPL18A-TRg-4":10086,
"SEC22g2-KSH1-TRg-1":10087,
"SEC22g2-KSH1-TRg-3":10088,
"SEC22g2-IPI3-NRg-1":10089,
"SEC22g2-PGA2-TRg-8":10090,
"SEC22g2-RPL18A-TRg-2":10091,
"SEC22g2-RPL33A-NRg-6":10092,
"SEC22g2-TAF12-NRg-2":10093,
"SEC22g2-USE1-TRg-5":10094,
"SEC22g2-YNL114C-TRg-1":10095,
"SEC22g2-SMC5-TRg-7":10096,
"SEC22g2-SMC5-TRg-6":10097,
"SEC22g2-RSC58-TRg-1":10098,
"SEC22g2-CTF13-TRg-2":10099,
"SEC22g2-NAB2-NRg-2":10100,
"SEC22g2-MCM7-TRg-4":10101,
"SEC22g2-BCP1-NRg-5":10102,
"SEC22g2-STU2-TRg-3":10103,
"SEC22g2-SEC21-NRg-6":10104,
"SEC22g2-SEC21-NRg-3":10105,
"SEC22g2-RPL1B-TRg-3":10106,
"SEC22g2-SEC20-NRg-2":10107,
"SEC22g2-VMA3-NRg-2":10108,
"SEC22g2-SEC23-NRg-5":10109,
"SEC22g2-CDC28-TRg-4":10110,
"SEC22g2-RPN12-NRg-11":10111,
"SEC22g2-PUP3-TRg-3":10112,
"SEC22g2-SEC31-TRg-2":10113,
"SEC22g2-SED5-TRg-6":10114,
"SEC22g2-SED5-TRg-5":10115,
"SEC22g2-RPL33A-TRg-1":10116,
"SEC22g2-RPL33A-TRg-2":10117,
"SEC22g2-MRPL11-TRg-2":10118,
"SEC22g2-RTP1-NRg-2":10119,
"SEC22g2-NUG1-TRg-2":10120,
"SEC22g2-VPH2-TRg-4":10121,
"SEC22g2-COP1-NRg-3":10122,
"SEC22g2-CRM1-NRg-1":10123,
"SEC22g2-RPL5-NRg-4":10124,
"SEC22g2-SNU13-NRg-4":10125,
"SEC22g2-PFS2-TRg-3":10126,
"SEC22g2-MPP10-TRg-2":10127,
"SEC22g2-TSR4-NRg-2":10128,
"SEC22g2-RSC2-TRg-1":10129,
"SEC22g2-SEC65-TRg-2":10130,
"SEC22g2-SMI1-NRg-1":10131,
"SEC22g2-RTT105-NRg-4":10132,
"SEC22g2-VMA5-TRg-3":10133,
"SEC22g2-VMA5-TRg-5":10134,
"SEC22g2-RRP1-TRg-3":10135,
"SEC22g2-CLC1-TRg-2":10136,
"SEC22g2-GCD6-NRg-1":10137,
"SEC22g2-GCD6-NRg-2":10138,
"SEC22g2-PXR1-TRg-1":10139,
"SEC22g2-CDC14-NRg-1":10140,
"SEC22g2-PCF11-TRg-6":10141,
"SEC22g2-PCF11-TRg-5":10142,
"SEC22g2-PCF11-TRg-4":10143,
"SEC22g2-SEC31-NRg-1":10144,
"SEC22g2-RRP5-NRg-1":10145,
"SEC22g2-PRE10-TRg-5":10146,
"SEC22g2-PRE10-TRg-1":10147,
"SEC22g2-RPS5-TRg-2":10148,
"SEC22g2-NSP1-TRg-4":10149,
"SEC22g2-PRP38-TRg-4":10150,
"SEC22g2-RCF1-NRg-5":10151,
"SEC22g2-RSC3-TRg-4":10152,
"SEC22g2-RSC3-TRg-5":10153,
"SEC22g2-RSC3-TRg-6":10154,
"SEC22g2-HTA1-NRg-12":10155,
"SEC22g2-HTA1-NRg-11":10156,
"SEC22g2-UTP23-TRg-2":10157,
"SEC22g2-GCD7-NRg-1":10158,
"SEC22g2-GCD7-NRg-2":10159,
"SEC22g2-GCD7-NRg-6":10160,
"SEC22g2-GAL11-NRg-2":10161,
"SEC22g2-GAL11-NRg-9":10162,
"SEC22g2-PHO4-TRg-5":10163,
"SEC22g2-SNP1-NRg-3":10164,
"SEC22g2-RPC37-TRg-5":10165,
"SEC22g2-CRM1-TRg-5":10166,
"SEC22g2-CRM1-TRg-2":10167,
"SEC22g2-ASK1-TRg-7":10168,
"SEC22g2-STU2-NRg-4":10169,
"SEC22g2-NEO1-NRg-3":10170,
"SEC22g2-GAL11-TRg-5":10171,
"SEC22g2-GAL11-TRg-7":10172,
"SEC22g2-SAM50-NRg-3":10173,
"SEC22g2-CSL4-TRg-2":10174,
"SEC22g2-CCT5-TRg-2":10175,
"SEC22g2-POL30-NRg-1":10176,
"SEC22g2-MED4-TRg-4":10177,
"SEC22g2-MED4-TRg-3":10178,
"SEC22g2-MED4-TRg-2":10179,
"SEC22g2-GDI1-TRg-4":10180,
"SEC22g2-GDI1-TRg-3":10181,
"SEC22g2-REB1-TRg-6":10182,
"SEC22g2-MRPL37-NRg-2":10183,
"SEC22g2-NOC3-TRg-3":10184,
"SEC22g2-SPC97-TRg-3":10185,
"SEC22g2-IPP1-TRg-3":10186,
"SEC22g2-IPP1-TRg-2":10187,
"SEC22g2-PTI1-TRg-3":10188,
"SEC22g2-PTI1-TRg-5":10189,
"SEC22g2-RFC5-NRg-1":10190,
"SEC22g2-CDC24-TRg-1":10191,
"SEC22g2-CDC24-TRg-3":10192,
"SEC22g2-CDC24-TRg-5":10193,
"SEC22g2-CDC24-TRg-6":10194,
"SEC22g2-UTP23-TRg-6":10195,
"SEC22g2-UTP23-TRg-4":10196,
"SEC22g2-UTP23-TRg-1":10197,
"SEC22g2-RHO3-NRg-4":10198,
"SEC22g2-TRS23-NRg-1":10199,
"SEC22g2-TRS23-NRg-3":10200,
"SEC22g2-RSP5-TRg-2":10201,
"SEC22g2-RSP5-TRg-1":10202,
"SEC22g2-SDA1-NRg-1":10203,
"SEC22g2-KAP95-TRg-8":10204,
"SEC22g2-ACO1-TRg-6":10205,
"SEC22g2-HTA1-NRg-3":10206,
"SEC22g2-HTA1-NRg-2":10207,
"SEC22g2-SPN1-TRg-1":10208,
"SEC22g2-MOT1-NRg-7":10209,
"SEC22g2-RPL17A-NRg-4":10210,
"SEC22g2-ADA2-TRg-4":10211,
"SEC22g2-SFH1-NRg-1":10212,
"SEC22g2-SPC97-NRg-5":10213,
"SEC22g2-PRP22-TRg-3":10214,
"SEC22g2-SEN15-TRg-2":10215,
"SEC22g2-RPL3-NRg-2":10216,
"SEC22g2-ISD11-NRg-2":10217,
"SEC22g2-HEM12-TRg-8":10218,
"SEC22g2-SEC10-TRg-1":10219,
"SEC22g2-HTB1-TRg-7":10220,
"SEC22g2-TTI2-TRg-1":10221,
"SEC22g2-ACP1-TRg-2":10222,
"SEC22g2-ACP1-TRg-4":10223,
"SEC22g2-GAL11-NRg-10":10224,
"SEC22g2-UTP22-TRg-2":10225,
"SEC22g2-MST1-NRg-5":10226,
"SEC22g2-RIB7-NRg-2":10227,
"SEC22g2-MCD1-TRg-6":10228,
"SEC22g2-MCD1-TRg-5":10229,
"SEC22g2-GPI8-NRg-2":10230,
"SEC22g2-THS1-TRg-2":10231,
"SEC22g2-RRP7-TRg-2":10232,
"SEC22g2-RRP7-TRg-5":10233,
"SEC22g2-SMX2-NRg-7":10234,
"SEC22g2-RRP45-TRg-5":10235,
"SEC22g2-RRP45-TRg-4":10236,
"SEC22g2-CNS1-TRg-2":10237,
"SEC22g2-FBP1-NRg-9":10238,
"SEC22g2-GCD11-NRg-1":10239,
"SEC22g2-RPL10-TRg-2":10240,
"SEC22g2-NUP192-TRg-4":10241,
"SEC22g2-NUP145-NRg-4":10242,
"SEC22g2-HEM12-TRg-6":10243,
"SEC22g2-PLC1-TRg-3":10244,
"SEC22g2-RPA43-TRg-1":10245,
"SEC22g2-RPB7-NRg-2":10246,
"SEC22g2-RPB7-NRg-3":10247,
"SEC22g2-NSL1-NRg-1":10248,
"SEC22g2-UTP6-TRg-3":10249,
"SEC22g2-UTP6-TRg-1":10250,
"SEC22g2-YJU2-TRg-5":10251,
"SEC22g2-FRS2-NRg-5":10252,
"SEC22g2-TIF35-NRg-2":10253,
"SEC22g2-GPI15-TRg-1":10254,
"SEC22g2-NOP1-NRg-5":10255,
"SEC22g2-GPI15-TRg-4":10256,
"SEC22g2-COG4-TRg-1":10257,
"SEC22g2-TFA1-TRg-1":10258,
"SEC22g2-RHO1-NRg-2":10259,
"SEC22g2-RHO1-NRg-1":10260,
"SEC22g2-CDC55-NRg-2":10261,
"SEC22g2-IDI1-NRg-7":10262,
"SEC22g2-RPL32-TRg-5":10263,
"SEC22g2-RPB5-TRg-4":10264,
"SEC22g2-DIP2-TRg-5":10265,
"SEC22g2-DIP2-TRg-1":10266,
"SEC22g2-RPC40-TRg-2":10267,
"SEC22g2-CDC6-TRg-5":10268,
"SEC22g2-CDC6-TRg-3":10269,
"SEC22g2-DAD2-TRg-2":10270,
"SEC22g2-RVS161-TRg-2":10271,
"SEC22g2-RVS161-TRg-1":10272,
"SEC22g2-SUP45-NRg-3":10273,
"SEC22g2-SRB6-NRg-5":10274,
"SEC22g2-RPC11-TRg-4":10275,
"SEC22g2-RKI1-TRg-8":10276,
"SEC22g2-NIP7-TRg-3":10277,
"SEC22g2-RPL33A-NRg-12":10278,
"SEC22g2-SAM50-TRg-4":10279,
"SEC22g2-NOP4-NRg-1":10280,
"SEC22g2-NOP4-NRg-3":10281,
"SEC22g2-SMX2-TRg-5":10282,
"SEC22g2-POL12-NRg-2":10283,
"SEC22g2-BMS1-NRg-2":10284,
"SEC22g2-RPA190-TRg-5":10285,
"SEC22g2-ALG14-NRg-4":10286,
"SEC22g2-ALG14-NRg-1":10287,
"SEC22g2-PRE5-NRg-1":10288,
"SEC22g2-BIG1-NRg-2":10289,
"SEC22g2-TFA2-TRg-4":10290,
"SEC22g2-IMP4-TRg-6":10291,
"SEC22g2-PAN1-NRg-1":10292,
"SEC22g2-UTP13-TRg-2":10293,
"SEC22g2-KAE1-NRg-3":10294,
"SEC22g2-ERG20-TRg-1":10295,
"SEC22g2-CDC20-TRg-6":10296,
"SEC22g2-PWP2-NRg-2":10297,
"SEC22g2-COG1-NRg-1":10298,
"SEC22g2-RPL1B-TRg-4":10299,
"SEC22g2-RPL1B-TRg-7":10300,
"SEC22g2-UTP20-TRg-3":10301,
"SEC22g2-UTP20-TRg-4":10302,
"SEC22g2-RPL25-TRg-4":10303,
"SEC22g2-RPL25-TRg-2":10304,
"SEC22g2-MCM7-NRg-1":10305,
"SEC22g2-MRP49-TRg-5":10306,
"SEC22g2-ERO1-NRg-3":10307,
"SEC22g2-UTP5-TRg-7":10308,
"SEC22g2-MCM4-NRg-1":10309,
"SEC22g2-PRE3-NRg-1":10310,
"SEC22g2-FCF1-NRg-1":10311,
"SEC22g2-CUS1-NRg-1":10312,
"SEC22g2-PSF1-TRg-2":10313,
"SEC22g2-BCP1-TRg-2":10314,
"SEC22g2-PAN1-TRg-1":10315,
"SEC22g2-PAN1-TRg-3":10316,
"SEC22g2-PAN1-TRg-4":10317,
"SEC22g2-VPS3-TRg-2":10318,
"SEC22g2-YIL060W-NRg-1":10319,
"SEC22g2-VPS53-NRg-1":10320,
"SEC22g2-CYR1-TRg-4":10321,
"SEC22g2-CYR1-TRg-7":10322,
"SEC22g2-MPS1-NRg-1":10323,
"SEC22g2-SRP1-TRg-5":10324,
"SEC22g2-SRP1-TRg-4":10325,
"SEC22g2-TAF12-TRg-2":10326,
"SEC22g2-TAF12-TRg-3":10327,
"SEC22g2-POP4-TRg-1":10328,
"SEC22g2-SPT16-TRg-1":10329,
"SEC22g2-NUP82-TRg-4":10330,
"SEC22g2-DML1-TRg-3":10331,
"SEC22g2-RPA43-NRg-3":10332,
"SEC22g2-STU2-NRg-3":10333,
"SEC22g2-POP4-NRg-4":10334,
"SEC22g2-MCD1-TRg-2":10335,
"SEC22g2-RPS3-NRg-4":10336,
"SEC22g2-PRP9-TRg-4":10337,
"SEC22g2-RPP1-NRg-2":10338,
"SEC22g2-MTR2-NRg-11":10339,
"SEC22g2-GCD11-TRg-1":10340,
"SEC22g2-RPF1-TRg-3":10341,
"SEC22g2-SUB2-NRg-4":10342,
"SEC22g2-GPI15-TRg-3":10343,
"SEC22g2-ERG9-TRg-6":10344,
"SEC22g2-RPT2-NRg-1":10345,
"SEC22g2-YOS1-NRg-3":10346,
"SEC22g2-SCM3-TRg-4":10347,
"SEC22g2-SCM3-TRg-6":10348,
"SEC22g2-RLP7-NRg-1":10349,
"SEC22g2-TFB2-NRg-4":10350,
"SEC22g2-IMP4-TRg-1":10351,
"SEC22g2-IMP4-TRg-3":10352,
"SEC22g2-PRE4-TRg-3":10353,
"SEC22g2-SUB2-TRg-3":10354,
"SEC22g2-RPP0-NRg-4":10355,
"SEC22g2-RPP0-NRg-3":10356,
"SEC22g2-TOM40-TRg-4":10357,
"SEC22g2-FUR1-NRg-12":10358,
"SEC22g2-TOM40-TRg-2":10359,
"SEC22g2-VMA11-NRg-4":10360,
"SEC22g2-PGS1-NRg-4":10361,
"SEC22g2-URB1-TRg-4":10362,
"SEC22g2-ARP4-TRg-3":10363,
"SEC22g2-RPT3-TRg-3":10364,
"SEC22g2-SUI3-TRg-3":10365,
"SEC22g2-RFC5-NRg-2":10366,
"SEC22g2-RRP14-TRg-2":10367,
"SEC22g2-SCC2-TRg-1":10368,
"SEC22g2-SSC1-TRg-3":10369,
"SEC22g2-RRP9-TRg-3":10370,
"SEC22g2-MOT1-NRg-9":10371,
"SEC22g2-RPL42A-NRg-2":10372,
"SEC22g2-SEC16-TRg-7":10373,
"SEC22g2-IMP4-NRg-2":10374,
"SEC22g2-YEF3-NRg-4":10375,
"SEC22g2-PUP1-TRg-1":10376,
"SEC22g2-UTP22-TRg-6":10377,
"SEC22g2-DBP2-NRg-4":10378,
"SEC22g2-PRE2-TRg-7":10379,
"SEC22g2-ATP16-TRg-6":10380,
"SEC22g2-UTP13-TRg-4":10381,
"SEC22g2-DOP1-NRg-4":10382,
"SEC22g2-TIM44-TRg-3":10383,
"SEC22g2-ATP16-TRg-2":10384,
"SEC22g2-ENP1-NRg-3":10385,
"SEC22g2-NAF1-TRg-3":10386,
"SEC22g2-COG4-TRg-2":10387,
"SEC22g2-SOG2-TRg-7":10388,
"SEC22g2-YDR341C-TRg-3":10389,
"SEC22g2-YMR290W-A-TRg-10":10390,
"SEC22g2-NUP192-NRg-9":10391,
"SEC22g2-RPS31-NRg-8":10392,
"SEC22g2-SPC97-NRg-6":10393,
"SEC22g2-EBP2-NRg-1":10394,
"SEC22g2-CDC48-TRg-5":10395,
"SEC22g2-RPT1-TRg-4":10396,
"SEC22g2-ULP1-NRg-2":10397,
"SEC22g2-RPN3-TRg-6":10398,
"SEC22g2-RPT1-TRg-5":10399,
"SEC22g2-KRE5-TRg-2":10400,
"SEC22g2-TBF1-NRg-8":10401,
"SEC22g2-UTP22-NRg-4":10402,
"SEC22g2-SSC1-NRg-4":10403,
"SEC22g2-REB1-TRg-4":10404,
"SEC22g2-CDC48-NRg-9":10405,
"SEC22g2-FAS2-TRg-8":10406,
"SEC22g2-TAO3-TRg-8":10407,
"SEC22g2-CKS1-TRg-5":10408,
"SEC22g2-YLR379W-TRg-7":10409,
"SEC22g2-TEN1-NRg-2":10410,
"SEC22g2-RPL42A-TRg-2":10411,
"SEC22g2-SEC27-TRg-4":10412,
"SEC22g2-TBF1-NRg-4":10413,
"SEC22g2-RPT1-NRg-6":10414,
"SEC22g2-COG1-TRg-3":10415,
"SEC22g2-SUI1-TRg-6":10416,
"SEC22g2-TIM23-TRg-6":10417,
"SEC22g2-CDC48-NRg-6":10418,
"SEC22g2-EPL1-TRg-5":10419,
"SEC22g2-RPT5-TRg-8":10420,
"SEC22g2-ATP16-NRg-4":10421,
"SEC22g2-RPN6-TRg-3":10422,
"SEC22g2-ERG9-NRg-6":10423,
"SEC22g2-SMX3-TRg-1":10424,
"SEC22g2-NCB2-NRg-3":10425,
"SEC22g2-SEC16-NRg-12":10426,
"SEC22g2-RPN6-TRg-2":10427,
"SEC22g2-REB1-NRg-4":10428,
"SEC22g2-ATP16-TRg-9":10429,
"SEC22g2-ERG9-NRg-7":10430,
"COG8g2-RPL15A-NRg-4":10431,
"COG8g2-RPL15A-NRg-5":10432,
"COG8g2-KRE33-TRg-1":10433,
"COG8g2-PMI40-NRg-1":10434,
"COG8g2-NOP19-NRg-3":10435,
"COG8g2-SRP14-NRg-4":10436,
"COG8g2-SEC27-TRg-2":10437,
"COG8g2-GPI14-TRg-3":10438,
"COG8g2-PAH1-TRg-7":10439,
"COG8g2-PAH1-TRg-6":10440,
"COG8g2-PAH1-TRg-5":10441,
"COG8g2-PAH1-TRg-3":10442,
"COG8g2-COG3-TRg-1":10443,
"COG8g2-HTS1-NRg-5":10444,
"COG8g2-MSN5-TRg-7":10445,
"COG8g2-ERG26-TRg-1":10446,
"COG8g2-SMD2-TRg-5":10447,
"COG8g2-SMD2-TRg-4":10448,
"COG8g2-SMD2-TRg-1":10449,
"COG8g2-PRE7-TRg-4":10450,
"COG8g2-PRE7-TRg-7":10451,
"COG8g2-SEC6-TRg-3":10452,
"COG8g2-ESF2-NRg-1":10453,
"COG8g2-ESF2-NRg-3":10454,
"COG8g2-AFG2-TRg-2":10455,
"COG8g2-RRP36-TRg-3":10456,
"COG8g2-RRP36-TRg-5":10457,
"COG8g2-GCR1-NRg-2":10458,
"COG8g2-PRE4-NRg-4":10459,
"COG8g2-PRE4-NRg-9":10460,
"COG8g2-DSN1-NRg-2":10461,
"COG8g2-GPI11-TRg-3":10462,
"COG8g2-POP3-TRg-1":10463,
"COG8g2-MNE1-TRg-5":10464,
"COG8g2-RRP12-NRg-1":10465,
"COG8g2-RSC6-TRg-2":10466,
"COG8g2-CDC25-TRg-1":10467,
"COG8g2-CDC25-TRg-9":10468,
"COG8g2-YPP1-NRg-3":10469,
"COG8g2-NFS1-NRg-9":10470,
"COG8g2-NFS1-NRg-8":10471,
"COG8g2-UBA2-TRg-1":10472,
"COG8g2-ARP2-NRg-3":10473,
"COG8g2-MAK16-TRg-1":10474,
"COG8g2-CEP3-NRg-1":10475,
"COG8g2-GUK1-TRg-5":10476,
"COG8g2-GUK1-TRg-2":10477,
"COG8g2-GPI12-NRg-6":10478,
"COG8g2-RPS5-NRg-5":10479,
"COG8g2-RPS5-NRg-2":10480,
"COG8g2-RPC19-NRg-1":10481,
"COG8g2-TIM54-TRg-1":10482,
"COG8g2-TEN1-TRg-2":10483,
"COG8g2-SAH1-NRg-4":10484,
"COG8g2-SAH1-NRg-5":10485,
"COG8g2-SAH1-NRg-3":10486,
"COG8g2-ATP15-NRg-5":10487,
"COG8g2-SCD5-TRg-5":10488,
"COG8g2-ARB1-NRg-2":10489,
"COG8g2-ARB1-NRg-4":10490,
"COG8g2-PUP2-TRg-1":10491,
"COG8g2-CCT8-TRg-2":10492,
"COG8g2-MCM4-TRg-1":10493,
"COG8g2-LSM4-TRg-1":10494,
"COG8g2-NOP53-NRg-1":10495,
"COG8g2-ATP3-TRg-4":10496,
"COG8g2-AFG2-NRg-3":10497,
"COG8g2-PRO3-NRg-3":10498,
"COG8g2-NRD1-NRg-10":10499,
"COG8g2-SEC61-TRg-2":10500,
"COG8g2-RHO3-TRg-4":10501,
"COG8g2-SNF2-TRg-6":10502,
"COG8g2-SMD2-NRg-3":10503,
"COG8g2-RSC4-TRg-2":10504,
"COG8g2-RSC4-TRg-1":10505,
"COG8g2-TIF34-TRg-2":10506,
"COG8g2-BET1-NRg-1":10507,
"COG8g2-CDC8-NRg-2":10508,
"COG8g2-PRP42-TRg-2":10509,
"COG8g2-RRB1-TRg-2":10510,
"COG8g2-SPC24-TRg-1":10511,
"COG8g2-ILS1-NRg-1":10512,
"COG8g2-GFA1-TRg-2":10513,
"COG8g2-SEC21-NRg-10":10514,
"COG8g2-RPC10-NRg-1":10515,
"COG8g2-RPB10-TRg-3":10516,
"COG8g2-RPB10-TRg-2":10517,
"COG8g2-YNL181W-TRg-1":10518,
"COG8g2-RAD3-NRg-1":10519,
"COG8g2-NOP10-TRg-1":10520,
"COG8g2-BFR2-TRg-3":10521,
"COG8g2-MCM2-TRg-6":10522,
"COG8g2-MCM2-TRg-4":10523,
"COG8g2-MPP10-TRg-1":10524,
"COG8g2-RET2-TRg-4":10525,
"COG8g2-RET2-TRg-1":10526,
"COG8g2-RPS2-NRg-1":10527,
"COG8g2-RPS2-NRg-2":10528,
"COG8g2-ORC4-NRg-3":10529,
"COG8g2-TIP20-TRg-7":10530,
"COG8g2-SMT3-TRg-1":10531,
"COG8g2-MSS18-NRg-6":10532,
"COG8g2-YEF3-NRg-9":10533,
"COG8g2-ASK1-NRg-1":10534,
"COG8g2-SMC1-TRg-1":10535,
"COG8g2-NIP1-NRg-1":10536,
"COG8g2-RPP1-NRg-1":10537,
"COG8g2-YDJ1-TRg-6":10538,
"COG8g2-SUB2-NRg-1":10539,
"COG8g2-TIM10-NRg-8":10540,
"COG8g2-TIM10-NRg-4":10541,
"COG8g2-TIM10-NRg-7":10542,
"COG8g2-SKI6-TRg-4":10543,
"COG8g2-TUB4-TRg-1":10544,
"COG8g2-CDC37-NRg-2":10545,
"COG8g2-ISD11-TRg-3":10546,
"COG8g2-YOS1-TRg-4":10547,
"COG8g2-SSC1-TRg-6":10548,
"COG8g2-MTR3-TRg-5":10549,
"COG8g2-MTR3-TRg-6":10550,
"COG8g2-TFA1-TRg-2":10551,
"COG8g2-CDC3-NRg-3":10552,
"COG8g2-ERG25-TA-18":10553,
"COG8g2-RPB11-TRg-4":10554,
"COG8g2-RPB11-TRg-1":10555,
"COG8g2-RPB11-TRg-2":10556,
"COG8g2-DED1-TRg-3":10557,
"COG8g2-DED1-TRg-1":10558,
"COG8g2-DED1-TRg-6":10559,
"COG8g2-DED1-TRg-4":10560,
"COG8g2-RPL10-NRg-5":10561,
"COG8g2-RPL10-NRg-4":10562,
"COG8g2-EFB1-NRg-1":10563,
"COG8g2-EFB1-NRg-5":10564,
"COG8g2-EFB1-NRg-4":10565,
"COG8g2-RPT3-NRg-1":10566,
"COG8g2-SAC6-TRg-8":10567,
"COG8g2-SAC6-TRg-4":10568,
"COG8g2-SAC6-TRg-5":10569,
"COG8g2-SAC6-TRg-3":10570,
"COG8g2-DIM1-TRg-5":10571,
"COG8g2-DIM1-TRg-7":10572,
"COG8g2-RPC17-NRg-1":10573,
"COG8g2-RPC17-NRg-2":10574,
"COG8g2-YDR341C-TRg-1":10575,
"COG8g2-RAP1-NRg-8":10576,
"COG8g2-RAP1-NRg-5":10577,
"COG8g2-RAP1-NRg-2":10578,
"COG8g2-SEC26-NRg-3":10579,
"COG8g2-SPP41-TRg-3":10580,
"COG8g2-TAP42-NRg-1":10581,
"COG8g2-PGA2-TRg-6":10582,
"COG8g2-BRL1-TRg-1":10583,
"COG8g2-FOL2-TRg-1":10584,
"COG8g2-NAB3-NRg-5":10585,
"COG8g2-SNF4-TRg-4":10586,
"COG8g2-HRR25-TRg-2":10587,
"COG8g2-TRS23-TRg-4":10588,
"COG8g2-CTR86-TRg-4":10589,
"COG8g2-RPB5-TRg-5":10590,
"COG8g2-SPN1-NRg-2":10591,
"COG8g2-SPN1-NRg-1":10592,
"COG8g2-SEC61-NRg-1":10593,
"COG8g2-SEC61-NRg-7":10594,
"COG8g2-TUS1-TRg-3":10595,
"COG8g2-OLE1-NRg-2":10596,
"COG8g2-AFG2-TRg-1":10597,
"COG8g2-TOA2-NRg-1":10598,
"COG8g2-USO1-TRg-1":10599,
"COG8g2-UTP22-NRg-2":10600,
"COG8g2-RIB1-TRg-3":10601,
"COG8g2-RIB1-TRg-7":10602,
"COG8g2-RIB1-TRg-4":10603,
"COG8g2-COG1-TRg-1":10604,
"COG8g2-RPL32-NRg-2":10605,
"COG8g2-GLC7-NRg-3":10606,
"COG8g2-GLC7-NRg-4":10607,
"COG8g2-HSF1-TRg-2":10608,
"COG8g2-DAM1-NRg-5":10609,
"COG8g2-SEC18-TRg-4":10610,
"COG8g2-SEC18-TRg-5":10611,
"COG8g2-PAB1-NRg-3":10612,
"COG8g2-POP8-TRg-2":10613,
"COG8g2-PAB1-NRg-4":10614,
"COG8g2-BIG1-TRg-4":10615,
"COG8g2-BIG1-TRg-5":10616,
"COG8g2-BIG1-TRg-6":10617,
"COG8g2-RPO41-NRg-1":10618,
"COG8g2-RVB2-NRg-2":10619,
"COG8g2-PET117-NRg-8":10620,
"COG8g2-VPS45-NRg-9":10621,
"COG8g2-YCG1-NRg-1":10622,
"COG8g2-NOC4-NRg-1":10623,
"COG8g2-NMD3-NRg-2":10624,
"COG8g2-DRS1-TRg-2":10625,
"COG8g2-HTB1-NRg-2":10626,
"COG8g2-IPI1-TRg-2":10627,
"COG8g2-SEC18-NRg-1":10628,
"COG8g2-SEC18-NRg-2":10629,
"COG8g2-JIP5-NRg-2":10630,
"COG8g2-YPT1-TRg-3":10631,
"COG8g2-YPT1-TRg-2":10632,
"COG8g2-CLF1-NRg-2":10633,
"COG8g2-SNF2-NRg-7":10634,
"COG8g2-SNF2-NRg-4":10635,
"COG8g2-RPL25-NRg-1":10636,
"COG8g2-NOP56-TRg-1":10637,
"COG8g2-NOP56-TRg-2":10638,
"COG8g2-TRS31-TRg-1":10639,
"COG8g2-DBF4-TRg-2":10640,
"COG8g2-DBF4-TRg-1":10641,
"COG8g2-RPC19-TRg-4":10642,
"COG8g2-RPC19-TRg-6":10643,
"COG8g2-RPC19-TRg-3":10644,
"COG8g2-ROK1-NRg-1":10645,
"COG8g2-CDC33-TRg-4":10646,
"COG8g2-DHR2-TRg-3":10647,
"COG8g2-RRP42-NRg-5":10648,
"COG8g2-CLF1-TRg-1":10649,
"COG8g2-ERG11-NA-16":10650,
"COG8g2-VAS1-NRg-4":10651,
"COG8g2-PIK1-NRg-2":10652,
"COG8g2-SAR1-NRg-7":10653,
"COG8g2-SAR1-NRg-4":10654,
"COG8g2-RPS3-TRg-1":10655,
"COG8g2-YTM1-TRg-2":10656,
"COG8g2-SUI3-NRg-5":10657,
"COG8g2-SUI3-NRg-2":10658,
"COG8g2-RRP7-TRg-4":10659,
"COG8g2-RRP7-TRg-6":10660,
"COG8g2-NIP7-TRg-2":10661,
"COG8g2-MDM35-TRg-1":10662,
"COG8g2-ALA1-NRg-1":10663,
"COG8g2-DOA4-NRg-2":10664,
"COG8g2-RPS13-NRg-1":10665,
"COG8g2-YSF3-TRg-2":10666,
"COG8g2-RPS2-NRg-11":10667,
"COG8g2-SSL1-TRg-10":10668,
"COG8g2-NIP7-TRg-1":10669,
"COG8g2-LST8-NRg-1":10670,
"COG8g2-TAF4-TRg-3":10671,
"COG8g2-HAS1-TRg-2":10672,
"COG8g2-GLC7-TRg-2":10673,
"COG8g2-CDC45-NRg-1":10674,
"COG8g2-SEC22-NRg-8":10675,
"COG8g2-YOS1-TRg-2":10676,
"COG8g2-RBA50-TRg-3":10677,
"COG8g2-SPP41-NRg-2":10678,
"COG8g2-PRP46-TRg-2":10679,
"COG8g2-PGA2-NRg-1":10680,
"COG8g2-CBF5-TRg-3":10681,
"COG8g2-TCP1-NRg-3":10682,
"COG8g2-TCP1-NRg-2":10683,
"COG8g2-ERG26-NRg-2":10684,
"COG8g2-ERG26-NRg-4":10685,
"COG8g2-MES1-TRg-5":10686,
"COG8g2-HTS1-TRg-2":10687,
"COG8g2-SSS1-TRg-3":10688,
"COG8g2-SSS1-TRg-2":10689,
"COG8g2-SYS1-TRg-7":10690,
"COG8g2-SYS1-TRg-2":10691,
"COG8g2-SYS1-TRg-1":10692,
"COG8g2-BFR2-TRg-1":10693,
"COG8g2-EOS1-TRg-3":10694,
"COG8g2-TAF4-NRg-1":10695,
"COG8g2-ARL3-NRg-8":10696,
"COG8g2-RPN5-NRg-1":10697,
"COG8g2-TIM9-NRg-2":10698,
"COG8g2-NUP57-NRg-3":10699,
"COG8g2-VPS4-TRg-1":10700,
"COG8g2-CDC3-TRg-4":10701,
"COG8g2-BBP1-NRg-1":10702,
"COG8g2-BBP1-NRg-2":10703,
"COG8g2-USE1-NRg-3":10704,
"COG8g2-CCT7-TRg-1":10705,
"COG8g2-SAH1-TRg-3":10706,
"COG8g2-CHS2-TRg-1":10707,
"COG8g2-DPM1-TRg-2":10708,
"COG8g2-BBP1-TRg-1":10709,
"COG8g2-NRD1-TRg-4":10710,
"COG8g2-RPB3-NRg-1":10711,
"COG8g2-PHO85-NRg-6":10712,
"COG8g2-SNF6-TRg-6":10713,
"COG8g2-PRP38-NRg-2":10714,
"COG8g2-OAR1-NRg-3":10715,
"COG8g2-ROX3-NRg-1":10716,
"COG8g2-YPP1-TRg-6":10717,
"COG8g2-CBF2-NRg-8":10718,
"COG8g2-SPT6-TRg-5":10719,
"COG8g2-SEC10-NRg-1":10720,
"COG8g2-NSL1-NRg-3":10721,
"COG8g2-NRD1-NRg-8":10722,
"COG8g2-RPB3-TRg-1":10723,
"COG8g2-NRD1-NRg-4":10724,
"COG8g2-RVB1-TRg-2":10725,
"COG8g2-TIF5-NRg-8":10726,
"COG8g2-EOS1-NRg-1":10727,
"COG8g2-ERG25-NA-26":10728,
"COG8g2-MSL5-NRg-4":10729,
"COG8g2-SEC24-TRg-2":10730,
"COG8g2-RPL30-NRg-5":10731,
"COG8g2-SNU71-NRg-3":10732,
"COG8g2-CDC33-NRg-1":10733,
"COG8g2-RPN6-TRg-4":10734,
"COG8g2-NAB2-TRg-4":10735,
"COG8g2-NAB2-TRg-6":10736,
"COG8g2-YTM1-NRg-1":10737,
"COG8g2-OLE1-TRg-8":10738,
"COG8g2-OLE1-TRg-1":10739,
"COG8g2-UTP7-TRg-4":10740,
"COG8g2-ACT1-NRg-6":10741,
"COG8g2-RPL18A-NRg-3":10742,
"COG8g2-BRX1-NRg-1":10743,
"COG8g2-NAF1-TRg-8":10744,
"COG8g2-NAF1-TRg-6":10745,
"COG8g2-NAF1-TRg-4":10746,
"COG8g2-CDC8-TRg-2":10747,
"COG8g2-NSE4-TRg-1":10748,
"COG8g2-PAB1-NRg-2":10749,
"COG8g2-PRP43-TRg-4":10750,
"COG8g2-SEC2-NRg-3":10751,
"COG8g2-SEC2-NRg-6":10752,
"COG8g2-MPP10-NRg-5":10753,
"COG8g2-YDR355C-TRg-2":10754,
"COG8g2-YLR339C-TRg-9":10755,
"COG8g2-SNM1-TRg-2":10756,
"COG8g2-ALR1-NRg-4":10757,
"COG8g2-ALR1-NRg-1":10758,
"COG8g2-ALR1-NRg-3":10759,
"COG8g2-RPL10-TRg-1":10760,
"COG8g2-RPL28-TRg-2":10761,
"COG8g2-UTP25-TRg-1":10762,
"COG8g2-POB3-TRg-1":10763,
"COG8g2-POB3-TRg-3":10764,
"COG8g2-POB3-TRg-2":10765,
"COG8g2-MED11-TRg-1":10766,
"COG8g2-ISA1-TRg-15":10767,
"COG8g2-RRP1-NRg-1":10768,
"COG8g2-MES1-NRg-1":10769,
"COG8g2-SEC13-NRg-5":10770,
"COG8g2-MCM2-NRg-2":10771,
"COG8g2-ALA1-TRg-4":10772,
"COG8g2-MTG2-TRg-5":10773,
"COG8g2-TIF35-NRg-3":10774,
"COG8g2-NSE1-TRg-3":10775,
"COG8g2-NSE1-TRg-4":10776,
"COG8g2-MOB2-NRg-6":10777,
"COG8g2-VRG4-NRg-3":10778,
"COG8g2-PRP9-TRg-3":10779,
"COG8g2-HYM1-TRg-5":10780,
"COG8g2-POP1-TRg-5":10781,
"COG8g2-POP1-TRg-9":10782,
"COG8g2-RPL17A-TRg-1":10783,
"COG8g2-SLD2-TRg-1":10784,
"COG8g2-CDC48-NRg-7":10785,
"COG8g2-FHL1-NRg-2":10786,
"COG8g2-BET3-NRg-7":10787,
"COG8g2-MAK21-TRg-1":10788,
"COG8g2-BRN1-TRg-4":10789,
"COG8g2-FBA1-NRg-3":10790,
"COG8g2-CDC42-TRg-6":10791,
"COG8g2-CDC42-TRg-7":10792,
"COG8g2-COG4-NRg-1":10793,
"COG8g2-ATP3-NRg-3":10794,
"COG8g2-ATP3-NRg-2":10795,
"COG8g2-SMP3-TRg-5":10796,
"COG8g2-CFT2-NRg-2":10797,
"COG8g2-FAS2-TRg-5":10798,
"COG8g2-DBP2-NRg-3":10799,
"COG8g2-DBP2-NRg-2":10800,
"COG8g2-MPS2-NRg-4":10801,
"COG8g2-ARC35-TRg-2":10802,
"COG8g2-ARC35-TRg-5":10803,
"COG8g2-MRD1-TRg-1":10804,
"COG8g2-RLP7-TRg-1":10805,
"COG8g2-SPC34-TRg-1":10806,
"COG8g2-CDC45-TRg-2":10807,
"COG8g2-GCD6-TRg-3":10808,
"COG8g2-GCD6-TRg-4":10809,
"COG8g2-YPT6-NRg-2":10810,
"COG8g2-RPS13-TRg-2":10811,
"COG8g2-IPI3-TRg-3":10812,
"COG8g2-TIF5-NRg-9":10813,
"COG8g2-TIF5-NRg-7":10814,
"COG8g2-TIF5-NRg-6":10815,
"COG8g2-NAB3-TRg-3":10816,
"COG8g2-GCD2-TRg-1":10817,
"COG8g2-UBA1-TRg-2":10818,
"COG8g2-SLD3-TRg-6":10819,
"COG8g2-LCB1-TRg-5":10820,
"COG8g2-TOA2-TRg-6":10821,
"COG8g2-TOA2-TRg-1":10822,
"COG8g2-TOA2-TRg-3":10823,
"COG8g2-LSM2-TRg-1":10824,
"COG8g2-YML6-TRg-13":10825,
"COG8g2-YML6-TRg-12":10826,
"COG8g2-UTP15-NRg-1":10827,
"COG8g2-TIF6-NRg-8":10828,
"COG8g2-SUP35-NRg-1":10829,
"COG8g2-MPP10-NRg-1":10830,
"COG8g2-SWI3-TRg-7":10831,
"COG8g2-SSN3-NRg-2":10832,
"COG8g2-SEC13-NRg-7":10833,
"COG8g2-RPS15-NRg-3":10834,
"COG8g2-RPL3-TRg-2":10835,
"COG8g2-FBA1-NRg-2":10836,
"COG8g2-FBA1-NRg-1":10837,
"COG8g2-FBA1-NRg-5":10838,
"COG8g2-DAM1-TRg-2":10839,
"COG8g2-NHP2-TRg-2":10840,
"COG8g2-HCA4-NRg-6":10841,
"COG8g2-PRE3-TRg-4":10842,
"COG8g2-DBP5-NRg-4":10843,
"COG8g2-SPT6-NRg-4":10844,
"COG8g2-SPT6-NRg-2":10845,
"COG8g2-RPL18A-TRg-4":10846,
"COG8g2-KSH1-TRg-1":10847,
"COG8g2-KSH1-TRg-3":10848,
"COG8g2-IPI3-NRg-1":10849,
"COG8g2-PGA2-TRg-8":10850,
"COG8g2-RPL18A-TRg-2":10851,
"COG8g2-RPL33A-NRg-6":10852,
"COG8g2-TAF12-NRg-2":10853,
"COG8g2-USE1-TRg-5":10854,
"COG8g2-YNL114C-TRg-1":10855,
"COG8g2-SMC5-TRg-7":10856,
"COG8g2-SMC5-TRg-6":10857,
"COG8g2-RSC58-TRg-1":10858,
"COG8g2-CTF13-TRg-2":10859,
"COG8g2-NAB2-NRg-2":10860,
"COG8g2-MCM7-TRg-4":10861,
"COG8g2-BCP1-NRg-5":10862,
"COG8g2-STU2-TRg-3":10863,
"COG8g2-SEC21-NRg-6":10864,
"COG8g2-SEC21-NRg-3":10865,
"COG8g2-RPL1B-TRg-3":10866,
"COG8g2-SEC20-NRg-2":10867,
"COG8g2-VMA3-NRg-2":10868,
"COG8g2-SEC23-NRg-5":10869,
"COG8g2-CDC28-TRg-4":10870,
"COG8g2-RPN12-NRg-11":10871,
"COG8g2-PUP3-TRg-3":10872,
"COG8g2-SEC31-TRg-2":10873,
"COG8g2-SED5-TRg-6":10874,
"COG8g2-SED5-TRg-5":10875,
"COG8g2-RPL33A-TRg-1":10876,
"COG8g2-RPL33A-TRg-2":10877,
"COG8g2-MRPL11-TRg-2":10878,
"COG8g2-RTP1-NRg-2":10879,
"COG8g2-NUG1-TRg-2":10880,
"COG8g2-VPH2-TRg-4":10881,
"COG8g2-COP1-NRg-3":10882,
"COG8g2-CRM1-NRg-1":10883,
"COG8g2-RPL5-NRg-4":10884,
"COG8g2-SNU13-NRg-4":10885,
"COG8g2-PFS2-TRg-3":10886,
"COG8g2-MPP10-TRg-2":10887,
"COG8g2-TSR4-NRg-2":10888,
"COG8g2-RSC2-TRg-1":10889,
"COG8g2-SEC65-TRg-2":10890,
"COG8g2-SMI1-NRg-1":10891,
"COG8g2-RTT105-NRg-4":10892,
"COG8g2-VMA5-TRg-3":10893,
"COG8g2-VMA5-TRg-5":10894,
"COG8g2-RRP1-TRg-3":10895,
"COG8g2-CLC1-TRg-2":10896,
"COG8g2-GCD6-NRg-1":10897,
"COG8g2-GCD6-NRg-2":10898,
"COG8g2-PXR1-TRg-1":10899,
"COG8g2-CDC14-NRg-1":10900,
"COG8g2-PCF11-TRg-6":10901,
"COG8g2-PCF11-TRg-5":10902,
"COG8g2-PCF11-TRg-4":10903,
"COG8g2-SEC31-NRg-1":10904,
"COG8g2-RRP5-NRg-1":10905,
"COG8g2-PRE10-TRg-5":10906,
"COG8g2-PRE10-TRg-1":10907,
"COG8g2-RPS5-TRg-2":10908,
"COG8g2-NSP1-TRg-4":10909,
"COG8g2-PRP38-TRg-4":10910,
"COG8g2-RCF1-NRg-5":10911,
"COG8g2-RSC3-TRg-4":10912,
"COG8g2-RSC3-TRg-5":10913,
"COG8g2-RSC3-TRg-6":10914,
"COG8g2-HTA1-NRg-12":10915,
"COG8g2-HTA1-NRg-11":10916,
"COG8g2-UTP23-TRg-2":10917,
"COG8g2-GCD7-NRg-1":10918,
"COG8g2-GCD7-NRg-2":10919,
"COG8g2-GCD7-NRg-6":10920,
"COG8g2-GAL11-NRg-2":10921,
"COG8g2-GAL11-NRg-9":10922,
"COG8g2-PHO4-TRg-5":10923,
"COG8g2-SNP1-NRg-3":10924,
"COG8g2-RPC37-TRg-5":10925,
"COG8g2-CRM1-TRg-5":10926,
"COG8g2-CRM1-TRg-2":10927,
"COG8g2-ASK1-TRg-7":10928,
"COG8g2-STU2-NRg-4":10929,
"COG8g2-NEO1-NRg-3":10930,
"COG8g2-GAL11-TRg-5":10931,
"COG8g2-GAL11-TRg-7":10932,
"COG8g2-SAM50-NRg-3":10933,
"COG8g2-CSL4-TRg-2":10934,
"COG8g2-CCT5-TRg-2":10935,
"COG8g2-POL30-NRg-1":10936,
"COG8g2-MED4-TRg-4":10937,
"COG8g2-MED4-TRg-3":10938,
"COG8g2-MED4-TRg-2":10939,
"COG8g2-GDI1-TRg-4":10940,
"COG8g2-GDI1-TRg-3":10941,
"COG8g2-REB1-TRg-6":10942,
"COG8g2-MRPL37-NRg-2":10943,
"COG8g2-NOC3-TRg-3":10944,
"COG8g2-SPC97-TRg-3":10945,
"COG8g2-IPP1-TRg-3":10946,
"COG8g2-IPP1-TRg-2":10947,
"COG8g2-PTI1-TRg-3":10948,
"COG8g2-PTI1-TRg-5":10949,
"COG8g2-RFC5-NRg-1":10950,
"COG8g2-CDC24-TRg-1":10951,
"COG8g2-CDC24-TRg-3":10952,
"COG8g2-CDC24-TRg-5":10953,
"COG8g2-CDC24-TRg-6":10954,
"COG8g2-UTP23-TRg-6":10955,
"COG8g2-UTP23-TRg-4":10956,
"COG8g2-UTP23-TRg-1":10957,
"COG8g2-RHO3-NRg-4":10958,
"COG8g2-TRS23-NRg-1":10959,
"COG8g2-TRS23-NRg-3":10960,
"COG8g2-RSP5-TRg-2":10961,
"COG8g2-RSP5-TRg-1":10962,
"COG8g2-SDA1-NRg-1":10963,
"COG8g2-KAP95-TRg-8":10964,
"COG8g2-ACO1-TRg-6":10965,
"COG8g2-HTA1-NRg-3":10966,
"COG8g2-HTA1-NRg-2":10967,
"COG8g2-SPN1-TRg-1":10968,
"COG8g2-MOT1-NRg-7":10969,
"COG8g2-RPL17A-NRg-4":10970,
"COG8g2-ADA2-TRg-4":10971,
"COG8g2-SFH1-NRg-1":10972,
"COG8g2-SPC97-NRg-5":10973,
"COG8g2-PRP22-TRg-3":10974,
"COG8g2-SEN15-TRg-2":10975,
"COG8g2-RPL3-NRg-2":10976,
"COG8g2-ISD11-NRg-2":10977,
"COG8g2-HEM12-TRg-8":10978,
"COG8g2-SEC10-TRg-1":10979,
"COG8g2-HTB1-TRg-7":10980,
"COG8g2-TTI2-TRg-1":10981,
"COG8g2-ACP1-TRg-2":10982,
"COG8g2-ACP1-TRg-4":10983,
"COG8g2-GAL11-NRg-10":10984,
"COG8g2-UTP22-TRg-2":10985,
"COG8g2-MST1-NRg-5":10986,
"COG8g2-RIB7-NRg-2":10987,
"COG8g2-MCD1-TRg-6":10988,
"COG8g2-MCD1-TRg-5":10989,
"COG8g2-GPI8-NRg-2":10990,
"COG8g2-THS1-TRg-2":10991,
"COG8g2-RRP7-TRg-2":10992,
"COG8g2-RRP7-TRg-5":10993,
"COG8g2-SMX2-NRg-7":10994,
"COG8g2-RRP45-TRg-5":10995,
"COG8g2-RRP45-TRg-4":10996,
"COG8g2-CNS1-TRg-2":10997,
"COG8g2-FBP1-NRg-9":10998,
"COG8g2-GCD11-NRg-1":10999,
"COG8g2-RPL10-TRg-2":11000,
"COG8g2-NUP192-TRg-4":11001,
"COG8g2-NUP145-NRg-4":11002,
"COG8g2-HEM12-TRg-6":11003,
"COG8g2-PLC1-TRg-3":11004,
"COG8g2-RPA43-TRg-1":11005,
"COG8g2-RPB7-NRg-2":11006,
"COG8g2-RPB7-NRg-3":11007,
"COG8g2-NSL1-NRg-1":11008,
"COG8g2-UTP6-TRg-3":11009,
"COG8g2-UTP6-TRg-1":11010,
"COG8g2-YJU2-TRg-5":11011,
"COG8g2-FRS2-NRg-5":11012,
"COG8g2-TIF35-NRg-2":11013,
"COG8g2-GPI15-TRg-1":11014,
"COG8g2-NOP1-NRg-5":11015,
"COG8g2-GPI15-TRg-4":11016,
"COG8g2-COG4-TRg-1":11017,
"COG8g2-TFA1-TRg-1":11018,
"COG8g2-RHO1-NRg-2":11019,
"COG8g2-RHO1-NRg-1":11020,
"COG8g2-CDC55-NRg-2":11021,
"COG8g2-IDI1-NRg-7":11022,
"COG8g2-RPL32-TRg-5":11023,
"COG8g2-RPB5-TRg-4":11024,
"COG8g2-DIP2-TRg-5":11025,
"COG8g2-DIP2-TRg-1":11026,
"COG8g2-RPC40-TRg-2":11027,
"COG8g2-CDC6-TRg-5":11028,
"COG8g2-CDC6-TRg-3":11029,
"COG8g2-DAD2-TRg-2":11030,
"COG8g2-RVS161-TRg-2":11031,
"COG8g2-RVS161-TRg-1":11032,
"COG8g2-SUP45-NRg-3":11033,
"COG8g2-SRB6-NRg-5":11034,
"COG8g2-RPC11-TRg-4":11035,
"COG8g2-RKI1-TRg-8":11036,
"COG8g2-NIP7-TRg-3":11037,
"COG8g2-RPL33A-NRg-12":11038,
"COG8g2-SAM50-TRg-4":11039,
"COG8g2-NOP4-NRg-1":11040,
"COG8g2-NOP4-NRg-3":11041,
"COG8g2-SMX2-TRg-5":11042,
"COG8g2-POL12-NRg-2":11043,
"COG8g2-BMS1-NRg-2":11044,
"COG8g2-RPA190-TRg-5":11045,
"COG8g2-ALG14-NRg-4":11046,
"COG8g2-ALG14-NRg-1":11047,
"COG8g2-PRE5-NRg-1":11048,
"COG8g2-BIG1-NRg-2":11049,
"COG8g2-TFA2-TRg-4":11050,
"COG8g2-IMP4-TRg-6":11051,
"COG8g2-PAN1-NRg-1":11052,
"COG8g2-UTP13-TRg-2":11053,
"COG8g2-KAE1-NRg-3":11054,
"COG8g2-ERG20-TRg-1":11055,
"COG8g2-CDC20-TRg-6":11056,
"COG8g2-PWP2-NRg-2":11057,
"COG8g2-COG1-NRg-1":11058,
"COG8g2-RPL1B-TRg-4":11059,
"COG8g2-RPL1B-TRg-7":11060,
"COG8g2-UTP20-TRg-3":11061,
"COG8g2-UTP20-TRg-4":11062,
"COG8g2-RPL25-TRg-4":11063,
"COG8g2-RPL25-TRg-2":11064,
"COG8g2-MCM7-NRg-1":11065,
"COG8g2-MRP49-TRg-5":11066,
"COG8g2-ERO1-NRg-3":11067,
"COG8g2-UTP5-TRg-7":11068,
"COG8g2-MCM4-NRg-1":11069,
"COG8g2-PRE3-NRg-1":11070,
"COG8g2-FCF1-NRg-1":11071,
"COG8g2-CUS1-NRg-1":11072,
"COG8g2-PSF1-TRg-2":11073,
"COG8g2-BCP1-TRg-2":11074,
"COG8g2-PAN1-TRg-1":11075,
"COG8g2-PAN1-TRg-3":11076,
"COG8g2-PAN1-TRg-4":11077,
"COG8g2-VPS3-TRg-2":11078,
"COG8g2-YIL060W-NRg-1":11079,
"COG8g2-VPS53-NRg-1":11080,
"COG8g2-CYR1-TRg-4":11081,
"COG8g2-CYR1-TRg-7":11082,
"COG8g2-MPS1-NRg-1":11083,
"COG8g2-SRP1-TRg-5":11084,
"COG8g2-SRP1-TRg-4":11085,
"COG8g2-TAF12-TRg-2":11086,
"COG8g2-TAF12-TRg-3":11087,
"COG8g2-POP4-TRg-1":11088,
"COG8g2-SPT16-TRg-1":11089,
"COG8g2-NUP82-TRg-4":11090,
"COG8g2-DML1-TRg-3":11091,
"COG8g2-RPA43-NRg-3":11092,
"COG8g2-STU2-NRg-3":11093,
"COG8g2-POP4-NRg-4":11094,
"COG8g2-MCD1-TRg-2":11095,
"COG8g2-RPS3-NRg-4":11096,
"COG8g2-PRP9-TRg-4":11097,
"COG8g2-RPP1-NRg-2":11098,
"COG8g2-MTR2-NRg-11":11099,
"COG8g2-GCD11-TRg-1":11100,
"COG8g2-RPF1-TRg-3":11101,
"COG8g2-SUB2-NRg-4":11102,
"COG8g2-GPI15-TRg-3":11103,
"COG8g2-ERG9-TRg-6":11104,
"COG8g2-RPT2-NRg-1":11105,
"COG8g2-YOS1-NRg-3":11106,
"COG8g2-SCM3-TRg-4":11107,
"COG8g2-SCM3-TRg-6":11108,
"COG8g2-RLP7-NRg-1":11109,
"COG8g2-TFB2-NRg-4":11110,
"COG8g2-IMP4-TRg-1":11111,
"COG8g2-IMP4-TRg-3":11112,
"COG8g2-PRE4-TRg-3":11113,
"COG8g2-SUB2-TRg-3":11114,
"COG8g2-RPP0-NRg-4":11115,
"COG8g2-RPP0-NRg-3":11116,
"COG8g2-TOM40-TRg-4":11117,
"COG8g2-FUR1-NRg-12":11118,
"COG8g2-TOM40-TRg-2":11119,
"COG8g2-VMA11-NRg-4":11120,
"COG8g2-PGS1-NRg-4":11121,
"COG8g2-URB1-TRg-4":11122,
"COG8g2-ARP4-TRg-3":11123,
"COG8g2-RPT3-TRg-3":11124,
"COG8g2-SUI3-TRg-3":11125,
"COG8g2-RFC5-NRg-2":11126,
"COG8g2-RRP14-TRg-2":11127,
"COG8g2-SCC2-TRg-1":11128,
"COG8g2-SSC1-TRg-3":11129,
"COG8g2-RRP9-TRg-3":11130,
"COG8g2-MOT1-NRg-9":11131,
"COG8g2-RPL42A-NRg-2":11132,
"COG8g2-SEC16-TRg-7":11133,
"COG8g2-IMP4-NRg-2":11134,
"COG8g2-YEF3-NRg-4":11135,
"COG8g2-PUP1-TRg-1":11136,
"COG8g2-UTP22-TRg-6":11137,
"COG8g2-DBP2-NRg-4":11138,
"COG8g2-PRE2-TRg-7":11139,
"COG8g2-ATP16-TRg-6":11140,
"COG8g2-UTP13-TRg-4":11141,
"COG8g2-DOP1-NRg-4":11142,
"COG8g2-TIM44-TRg-3":11143,
"COG8g2-ATP16-TRg-2":11144,
"COG8g2-ENP1-NRg-3":11145,
"COG8g2-NAF1-TRg-3":11146,
"COG8g2-COG4-TRg-2":11147,
"COG8g2-SOG2-TRg-7":11148,
"COG8g2-YDR341C-TRg-3":11149,
"COG8g2-YMR290W-A-TRg-10":11150,
"COG8g2-NUP192-NRg-9":11151,
"COG8g2-RPS31-NRg-8":11152,
"COG8g2-SPC97-NRg-6":11153,
"COG8g2-EBP2-NRg-1":11154,
"COG8g2-CDC48-TRg-5":11155,
"COG8g2-RPT1-TRg-4":11156,
"COG8g2-ULP1-NRg-2":11157,
"COG8g2-RPN3-TRg-6":11158,
"COG8g2-RPT1-TRg-5":11159,
"COG8g2-KRE5-TRg-2":11160,
"COG8g2-TBF1-NRg-8":11161,
"COG8g2-UTP22-NRg-4":11162,
"COG8g2-SSC1-NRg-4":11163,
"COG8g2-REB1-TRg-4":11164,
"COG8g2-CDC48-NRg-9":11165,
"COG8g2-FAS2-TRg-8":11166,
"COG8g2-TAO3-TRg-8":11167,
"COG8g2-CKS1-TRg-5":11168,
"COG8g2-YLR379W-TRg-7":11169,
"COG8g2-TEN1-NRg-2":11170,
"COG8g2-RPL42A-TRg-2":11171,
"COG8g2-SEC27-TRg-4":11172,
"COG8g2-TBF1-NRg-4":11173,
"COG8g2-RPT1-NRg-6":11174,
"COG8g2-COG1-TRg-3":11175,
"COG8g2-SUI1-TRg-6":11176,
"COG8g2-TIM23-TRg-6":11177,
"COG8g2-CDC48-NRg-6":11178,
"COG8g2-EPL1-TRg-5":11179,
"COG8g2-RPT5-TRg-8":11180,
"COG8g2-ATP16-NRg-4":11181,
"COG8g2-RPN6-TRg-3":11182,
"COG8g2-ERG9-NRg-6":11183,
"COG8g2-SMX3-TRg-1":11184,
"COG8g2-NCB2-NRg-3":11185,
"COG8g2-SEC16-NRg-12":11186,
"COG8g2-RPN6-TRg-2":11187,
"COG8g2-REB1-NRg-4":11188,
"COG8g2-ATP16-TRg-9":11189,
"COG8g2-ERG9-NRg-7":11190,
"GET2g2-RPL15A-NRg-4":11191,
"GET2g2-RPL15A-NRg-5":11192,
"GET2g2-KRE33-TRg-1":11193,
"GET2g2-PMI40-NRg-1":11194,
"GET2g2-NOP19-NRg-3":11195,
"GET2g2-SRP14-NRg-4":11196,
"GET2g2-SEC27-TRg-2":11197,
"GET2g2-GPI14-TRg-3":11198,
"GET2g2-PAH1-TRg-7":11199,
"GET2g2-PAH1-TRg-6":11200,
"GET2g2-PAH1-TRg-5":11201,
"GET2g2-PAH1-TRg-3":11202,
"GET2g2-COG3-TRg-1":11203,
"GET2g2-HTS1-NRg-5":11204,
"GET2g2-MSN5-TRg-7":11205,
"GET2g2-ERG26-TRg-1":11206,
"GET2g2-SMD2-TRg-5":11207,
"GET2g2-SMD2-TRg-4":11208,
"GET2g2-SMD2-TRg-1":11209,
"GET2g2-PRE7-TRg-4":11210,
"GET2g2-PRE7-TRg-7":11211,
"GET2g2-SEC6-TRg-3":11212,
"GET2g2-ESF2-NRg-1":11213,
"GET2g2-ESF2-NRg-3":11214,
"GET2g2-AFG2-TRg-2":11215,
"GET2g2-RRP36-TRg-3":11216,
"GET2g2-RRP36-TRg-5":11217,
"GET2g2-GCR1-NRg-2":11218,
"GET2g2-PRE4-NRg-4":11219,
"GET2g2-PRE4-NRg-9":11220,
"GET2g2-DSN1-NRg-2":11221,
"GET2g2-GPI11-TRg-3":11222,
"GET2g2-POP3-TRg-1":11223,
"GET2g2-MNE1-TRg-5":11224,
"GET2g2-RRP12-NRg-1":11225,
"GET2g2-RSC6-TRg-2":11226,
"GET2g2-CDC25-TRg-1":11227,
"GET2g2-CDC25-TRg-9":11228,
"GET2g2-YPP1-NRg-3":11229,
"GET2g2-NFS1-NRg-9":11230,
"GET2g2-NFS1-NRg-8":11231,
"GET2g2-UBA2-TRg-1":11232,
"GET2g2-ARP2-NRg-3":11233,
"GET2g2-MAK16-TRg-1":11234,
"GET2g2-CEP3-NRg-1":11235,
"GET2g2-GUK1-TRg-5":11236,
"GET2g2-GUK1-TRg-2":11237,
"GET2g2-GPI12-NRg-6":11238,
"GET2g2-RPS5-NRg-5":11239,
"GET2g2-RPS5-NRg-2":11240,
"GET2g2-RPC19-NRg-1":11241,
"GET2g2-TIM54-TRg-1":11242,
"GET2g2-TEN1-TRg-2":11243,
"GET2g2-SAH1-NRg-4":11244,
"GET2g2-SAH1-NRg-5":11245,
"GET2g2-SAH1-NRg-3":11246,
"GET2g2-ATP15-NRg-5":11247,
"GET2g2-SCD5-TRg-5":11248,
"GET2g2-ARB1-NRg-2":11249,
"GET2g2-ARB1-NRg-4":11250,
"GET2g2-PUP2-TRg-1":11251,
"GET2g2-CCT8-TRg-2":11252,
"GET2g2-MCM4-TRg-1":11253,
"GET2g2-LSM4-TRg-1":11254,
"GET2g2-NOP53-NRg-1":11255,
"GET2g2-ATP3-TRg-4":11256,
"GET2g2-AFG2-NRg-3":11257,
"GET2g2-PRO3-NRg-3":11258,
"GET2g2-NRD1-NRg-10":11259,
"GET2g2-SEC61-TRg-2":11260,
"GET2g2-RHO3-TRg-4":11261,
"GET2g2-SNF2-TRg-6":11262,
"GET2g2-SMD2-NRg-3":11263,
"GET2g2-RSC4-TRg-2":11264,
"GET2g2-RSC4-TRg-1":11265,
"GET2g2-TIF34-TRg-2":11266,
"GET2g2-BET1-NRg-1":11267,
"GET2g2-CDC8-NRg-2":11268,
"GET2g2-PRP42-TRg-2":11269,
"GET2g2-RRB1-TRg-2":11270,
"GET2g2-SPC24-TRg-1":11271,
"GET2g2-ILS1-NRg-1":11272,
"GET2g2-GFA1-TRg-2":11273,
"GET2g2-SEC21-NRg-10":11274,
"GET2g2-RPC10-NRg-1":11275,
"GET2g2-RPB10-TRg-3":11276,
"GET2g2-RPB10-TRg-2":11277,
"GET2g2-YNL181W-TRg-1":11278,
"GET2g2-RAD3-NRg-1":11279,
"GET2g2-NOP10-TRg-1":11280,
"GET2g2-BFR2-TRg-3":11281,
"GET2g2-MCM2-TRg-6":11282,
"GET2g2-MCM2-TRg-4":11283,
"GET2g2-MPP10-TRg-1":11284,
"GET2g2-RET2-TRg-4":11285,
"GET2g2-RET2-TRg-1":11286,
"GET2g2-RPS2-NRg-1":11287,
"GET2g2-RPS2-NRg-2":11288,
"GET2g2-ORC4-NRg-3":11289,
"GET2g2-TIP20-TRg-7":11290,
"GET2g2-SMT3-TRg-1":11291,
"GET2g2-MSS18-NRg-6":11292,
"GET2g2-YEF3-NRg-9":11293,
"GET2g2-ASK1-NRg-1":11294,
"GET2g2-SMC1-TRg-1":11295,
"GET2g2-NIP1-NRg-1":11296,
"GET2g2-RPP1-NRg-1":11297,
"GET2g2-YDJ1-TRg-6":11298,
"GET2g2-SUB2-NRg-1":11299,
"GET2g2-TIM10-NRg-8":11300,
"GET2g2-TIM10-NRg-4":11301,
"GET2g2-TIM10-NRg-7":11302,
"GET2g2-SKI6-TRg-4":11303,
"GET2g2-TUB4-TRg-1":11304,
"GET2g2-CDC37-NRg-2":11305,
"GET2g2-ISD11-TRg-3":11306,
"GET2g2-YOS1-TRg-4":11307,
"GET2g2-SSC1-TRg-6":11308,
"GET2g2-MTR3-TRg-5":11309,
"GET2g2-MTR3-TRg-6":11310,
"GET2g2-TFA1-TRg-2":11311,
"GET2g2-CDC3-NRg-3":11312,
"GET2g2-ERG25-TA-18":11313,
"GET2g2-RPB11-TRg-4":11314,
"GET2g2-RPB11-TRg-1":11315,
"GET2g2-RPB11-TRg-2":11316,
"GET2g2-DED1-TRg-3":11317,
"GET2g2-DED1-TRg-1":11318,
"GET2g2-DED1-TRg-6":11319,
"GET2g2-DED1-TRg-4":11320,
"GET2g2-RPL10-NRg-5":11321,
"GET2g2-RPL10-NRg-4":11322,
"GET2g2-EFB1-NRg-1":11323,
"GET2g2-EFB1-NRg-5":11324,
"GET2g2-EFB1-NRg-4":11325,
"GET2g2-RPT3-NRg-1":11326,
"GET2g2-SAC6-TRg-8":11327,
"GET2g2-SAC6-TRg-4":11328,
"GET2g2-SAC6-TRg-5":11329,
"GET2g2-SAC6-TRg-3":11330,
"GET2g2-DIM1-TRg-5":11331,
"GET2g2-DIM1-TRg-7":11332,
"GET2g2-RPC17-NRg-1":11333,
"GET2g2-RPC17-NRg-2":11334,
"GET2g2-YDR341C-TRg-1":11335,
"GET2g2-RAP1-NRg-8":11336,
"GET2g2-RAP1-NRg-5":11337,
"GET2g2-RAP1-NRg-2":11338,
"GET2g2-SEC26-NRg-3":11339,
"GET2g2-SPP41-TRg-3":11340,
"GET2g2-TAP42-NRg-1":11341,
"GET2g2-PGA2-TRg-6":11342,
"GET2g2-BRL1-TRg-1":11343,
"GET2g2-FOL2-TRg-1":11344,
"GET2g2-NAB3-NRg-5":11345,
"GET2g2-SNF4-TRg-4":11346,
"GET2g2-HRR25-TRg-2":11347,
"GET2g2-TRS23-TRg-4":11348,
"GET2g2-CTR86-TRg-4":11349,
"GET2g2-RPB5-TRg-5":11350,
"GET2g2-SPN1-NRg-2":11351,
"GET2g2-SPN1-NRg-1":11352,
"GET2g2-SEC61-NRg-1":11353,
"GET2g2-SEC61-NRg-7":11354,
"GET2g2-TUS1-TRg-3":11355,
"GET2g2-OLE1-NRg-2":11356,
"GET2g2-AFG2-TRg-1":11357,
"GET2g2-TOA2-NRg-1":11358,
"GET2g2-USO1-TRg-1":11359,
"GET2g2-UTP22-NRg-2":11360,
"GET2g2-RIB1-TRg-3":11361,
"GET2g2-RIB1-TRg-7":11362,
"GET2g2-RIB1-TRg-4":11363,
"GET2g2-COG1-TRg-1":11364,
"GET2g2-RPL32-NRg-2":11365,
"GET2g2-GLC7-NRg-3":11366,
"GET2g2-GLC7-NRg-4":11367,
"GET2g2-HSF1-TRg-2":11368,
"GET2g2-DAM1-NRg-5":11369,
"GET2g2-SEC18-TRg-4":11370,
"GET2g2-SEC18-TRg-5":11371,
"GET2g2-PAB1-NRg-3":11372,
"GET2g2-POP8-TRg-2":11373,
"GET2g2-PAB1-NRg-4":11374,
"GET2g2-BIG1-TRg-4":11375,
"GET2g2-BIG1-TRg-5":11376,
"GET2g2-BIG1-TRg-6":11377,
"GET2g2-RPO41-NRg-1":11378,
"GET2g2-RVB2-NRg-2":11379,
"GET2g2-PET117-NRg-8":11380,
"GET2g2-VPS45-NRg-9":11381,
"GET2g2-YCG1-NRg-1":11382,
"GET2g2-NOC4-NRg-1":11383,
"GET2g2-NMD3-NRg-2":11384,
"GET2g2-DRS1-TRg-2":11385,
"GET2g2-HTB1-NRg-2":11386,
"GET2g2-IPI1-TRg-2":11387,
"GET2g2-SEC18-NRg-1":11388,
"GET2g2-SEC18-NRg-2":11389,
"GET2g2-JIP5-NRg-2":11390,
"GET2g2-YPT1-TRg-3":11391,
"GET2g2-YPT1-TRg-2":11392,
"GET2g2-CLF1-NRg-2":11393,
"GET2g2-SNF2-NRg-7":11394,
"GET2g2-SNF2-NRg-4":11395,
"GET2g2-RPL25-NRg-1":11396,
"GET2g2-NOP56-TRg-1":11397,
"GET2g2-NOP56-TRg-2":11398,
"GET2g2-TRS31-TRg-1":11399,
"GET2g2-DBF4-TRg-2":11400,
"GET2g2-DBF4-TRg-1":11401,
"GET2g2-RPC19-TRg-4":11402,
"GET2g2-RPC19-TRg-6":11403,
"GET2g2-RPC19-TRg-3":11404,
"GET2g2-ROK1-NRg-1":11405,
"GET2g2-CDC33-TRg-4":11406,
"GET2g2-DHR2-TRg-3":11407,
"GET2g2-RRP42-NRg-5":11408,
"GET2g2-CLF1-TRg-1":11409,
"GET2g2-ERG11-NA-16":11410,
"GET2g2-VAS1-NRg-4":11411,
"GET2g2-PIK1-NRg-2":11412,
"GET2g2-SAR1-NRg-7":11413,
"GET2g2-SAR1-NRg-4":11414,
"GET2g2-RPS3-TRg-1":11415,
"GET2g2-YTM1-TRg-2":11416,
"GET2g2-SUI3-NRg-5":11417,
"GET2g2-SUI3-NRg-2":11418,
"GET2g2-RRP7-TRg-4":11419,
"GET2g2-RRP7-TRg-6":11420,
"GET2g2-NIP7-TRg-2":11421,
"GET2g2-MDM35-TRg-1":11422,
"GET2g2-ALA1-NRg-1":11423,
"GET2g2-DOA4-NRg-2":11424,
"GET2g2-RPS13-NRg-1":11425,
"GET2g2-YSF3-TRg-2":11426,
"GET2g2-RPS2-NRg-11":11427,
"GET2g2-SSL1-TRg-10":11428,
"GET2g2-NIP7-TRg-1":11429,
"GET2g2-LST8-NRg-1":11430,
"GET2g2-TAF4-TRg-3":11431,
"GET2g2-HAS1-TRg-2":11432,
"GET2g2-GLC7-TRg-2":11433,
"GET2g2-CDC45-NRg-1":11434,
"GET2g2-SEC22-NRg-8":11435,
"GET2g2-YOS1-TRg-2":11436,
"GET2g2-RBA50-TRg-3":11437,
"GET2g2-SPP41-NRg-2":11438,
"GET2g2-PRP46-TRg-2":11439,
"GET2g2-PGA2-NRg-1":11440,
"GET2g2-CBF5-TRg-3":11441,
"GET2g2-TCP1-NRg-3":11442,
"GET2g2-TCP1-NRg-2":11443,
"GET2g2-ERG26-NRg-2":11444,
"GET2g2-ERG26-NRg-4":11445,
"GET2g2-MES1-TRg-5":11446,
"GET2g2-HTS1-TRg-2":11447,
"GET2g2-SSS1-TRg-3":11448,
"GET2g2-SSS1-TRg-2":11449,
"GET2g2-SYS1-TRg-7":11450,
"GET2g2-SYS1-TRg-2":11451,
"GET2g2-SYS1-TRg-1":11452,
"GET2g2-BFR2-TRg-1":11453,
"GET2g2-EOS1-TRg-3":11454,
"GET2g2-TAF4-NRg-1":11455,
"GET2g2-ARL3-NRg-8":11456,
"GET2g2-RPN5-NRg-1":11457,
"GET2g2-TIM9-NRg-2":11458,
"GET2g2-NUP57-NRg-3":11459,
"GET2g2-VPS4-TRg-1":11460,
"GET2g2-CDC3-TRg-4":11461,
"GET2g2-BBP1-NRg-1":11462,
"GET2g2-BBP1-NRg-2":11463,
"GET2g2-USE1-NRg-3":11464,
"GET2g2-CCT7-TRg-1":11465,
"GET2g2-SAH1-TRg-3":11466,
"GET2g2-CHS2-TRg-1":11467,
"GET2g2-DPM1-TRg-2":11468,
"GET2g2-BBP1-TRg-1":11469,
"GET2g2-NRD1-TRg-4":11470,
"GET2g2-RPB3-NRg-1":11471,
"GET2g2-PHO85-NRg-6":11472,
"GET2g2-SNF6-TRg-6":11473,
"GET2g2-PRP38-NRg-2":11474,
"GET2g2-OAR1-NRg-3":11475,
"GET2g2-ROX3-NRg-1":11476,
"GET2g2-YPP1-TRg-6":11477,
"GET2g2-CBF2-NRg-8":11478,
"GET2g2-SPT6-TRg-5":11479,
"GET2g2-SEC10-NRg-1":11480,
"GET2g2-NSL1-NRg-3":11481,
"GET2g2-NRD1-NRg-8":11482,
"GET2g2-RPB3-TRg-1":11483,
"GET2g2-NRD1-NRg-4":11484,
"GET2g2-RVB1-TRg-2":11485,
"GET2g2-TIF5-NRg-8":11486,
"GET2g2-EOS1-NRg-1":11487,
"GET2g2-ERG25-NA-26":11488,
"GET2g2-MSL5-NRg-4":11489,
"GET2g2-SEC24-TRg-2":11490,
"GET2g2-RPL30-NRg-5":11491,
"GET2g2-SNU71-NRg-3":11492,
"GET2g2-CDC33-NRg-1":11493,
"GET2g2-RPN6-TRg-4":11494,
"GET2g2-NAB2-TRg-4":11495,
"GET2g2-NAB2-TRg-6":11496,
"GET2g2-YTM1-NRg-1":11497,
"GET2g2-OLE1-TRg-8":11498,
"GET2g2-OLE1-TRg-1":11499,
"GET2g2-UTP7-TRg-4":11500,
"GET2g2-ACT1-NRg-6":11501,
"GET2g2-RPL18A-NRg-3":11502,
"GET2g2-BRX1-NRg-1":11503,
"GET2g2-NAF1-TRg-8":11504,
"GET2g2-NAF1-TRg-6":11505,
"GET2g2-NAF1-TRg-4":11506,
"GET2g2-CDC8-TRg-2":11507,
"GET2g2-NSE4-TRg-1":11508,
"GET2g2-PAB1-NRg-2":11509,
"GET2g2-PRP43-TRg-4":11510,
"GET2g2-SEC2-NRg-3":11511,
"GET2g2-SEC2-NRg-6":11512,
"GET2g2-MPP10-NRg-5":11513,
"GET2g2-YDR355C-TRg-2":11514,
"GET2g2-YLR339C-TRg-9":11515,
"GET2g2-SNM1-TRg-2":11516,
"GET2g2-ALR1-NRg-4":11517,
"GET2g2-ALR1-NRg-1":11518,
"GET2g2-ALR1-NRg-3":11519,
"GET2g2-RPL10-TRg-1":11520,
"GET2g2-RPL28-TRg-2":11521,
"GET2g2-UTP25-TRg-1":11522,
"GET2g2-POB3-TRg-1":11523,
"GET2g2-POB3-TRg-3":11524,
"GET2g2-POB3-TRg-2":11525,
"GET2g2-MED11-TRg-1":11526,
"GET2g2-ISA1-TRg-15":11527,
"GET2g2-RRP1-NRg-1":11528,
"GET2g2-MES1-NRg-1":11529,
"GET2g2-SEC13-NRg-5":11530,
"GET2g2-MCM2-NRg-2":11531,
"GET2g2-ALA1-TRg-4":11532,
"GET2g2-MTG2-TRg-5":11533,
"GET2g2-TIF35-NRg-3":11534,
"GET2g2-NSE1-TRg-3":11535,
"GET2g2-NSE1-TRg-4":11536,
"GET2g2-MOB2-NRg-6":11537,
"GET2g2-VRG4-NRg-3":11538,
"GET2g2-PRP9-TRg-3":11539,
"GET2g2-HYM1-TRg-5":11540,
"GET2g2-POP1-TRg-5":11541,
"GET2g2-POP1-TRg-9":11542,
"GET2g2-RPL17A-TRg-1":11543,
"GET2g2-SLD2-TRg-1":11544,
"GET2g2-CDC48-NRg-7":11545,
"GET2g2-FHL1-NRg-2":11546,
"GET2g2-BET3-NRg-7":11547,
"GET2g2-MAK21-TRg-1":11548,
"GET2g2-BRN1-TRg-4":11549,
"GET2g2-FBA1-NRg-3":11550,
"GET2g2-CDC42-TRg-6":11551,
"GET2g2-CDC42-TRg-7":11552,
"GET2g2-COG4-NRg-1":11553,
"GET2g2-ATP3-NRg-3":11554,
"GET2g2-ATP3-NRg-2":11555,
"GET2g2-SMP3-TRg-5":11556,
"GET2g2-CFT2-NRg-2":11557,
"GET2g2-FAS2-TRg-5":11558,
"GET2g2-DBP2-NRg-3":11559,
"GET2g2-DBP2-NRg-2":11560,
"GET2g2-MPS2-NRg-4":11561,
"GET2g2-ARC35-TRg-2":11562,
"GET2g2-ARC35-TRg-5":11563,
"GET2g2-MRD1-TRg-1":11564,
"GET2g2-RLP7-TRg-1":11565,
"GET2g2-SPC34-TRg-1":11566,
"GET2g2-CDC45-TRg-2":11567,
"GET2g2-GCD6-TRg-3":11568,
"GET2g2-GCD6-TRg-4":11569,
"GET2g2-YPT6-NRg-2":11570,
"GET2g2-RPS13-TRg-2":11571,
"GET2g2-IPI3-TRg-3":11572,
"GET2g2-TIF5-NRg-9":11573,
"GET2g2-TIF5-NRg-7":11574,
"GET2g2-TIF5-NRg-6":11575,
"GET2g2-NAB3-TRg-3":11576,
"GET2g2-GCD2-TRg-1":11577,
"GET2g2-UBA1-TRg-2":11578,
"GET2g2-SLD3-TRg-6":11579,
"GET2g2-LCB1-TRg-5":11580,
"GET2g2-TOA2-TRg-6":11581,
"GET2g2-TOA2-TRg-1":11582,
"GET2g2-TOA2-TRg-3":11583,
"GET2g2-LSM2-TRg-1":11584,
"GET2g2-YML6-TRg-13":11585,
"GET2g2-YML6-TRg-12":11586,
"GET2g2-UTP15-NRg-1":11587,
"GET2g2-TIF6-NRg-8":11588,
"GET2g2-SUP35-NRg-1":11589,
"GET2g2-MPP10-NRg-1":11590,
"GET2g2-SWI3-TRg-7":11591,
"GET2g2-SSN3-NRg-2":11592,
"GET2g2-SEC13-NRg-7":11593,
"GET2g2-RPS15-NRg-3":11594,
"GET2g2-RPL3-TRg-2":11595,
"GET2g2-FBA1-NRg-2":11596,
"GET2g2-FBA1-NRg-1":11597,
"GET2g2-FBA1-NRg-5":11598,
"GET2g2-DAM1-TRg-2":11599,
"GET2g2-NHP2-TRg-2":11600,
"GET2g2-HCA4-NRg-6":11601,
"GET2g2-PRE3-TRg-4":11602,
"GET2g2-DBP5-NRg-4":11603,
"GET2g2-SPT6-NRg-4":11604,
"GET2g2-SPT6-NRg-2":11605,
"GET2g2-RPL18A-TRg-4":11606,
"GET2g2-KSH1-TRg-1":11607,
"GET2g2-KSH1-TRg-3":11608,
"GET2g2-IPI3-NRg-1":11609,
"GET2g2-PGA2-TRg-8":11610,
"GET2g2-RPL18A-TRg-2":11611,
"GET2g2-RPL33A-NRg-6":11612,
"GET2g2-TAF12-NRg-2":11613,
"GET2g2-USE1-TRg-5":11614,
"GET2g2-YNL114C-TRg-1":11615,
"GET2g2-SMC5-TRg-7":11616,
"GET2g2-SMC5-TRg-6":11617,
"GET2g2-RSC58-TRg-1":11618,
"GET2g2-CTF13-TRg-2":11619,
"GET2g2-NAB2-NRg-2":11620,
"GET2g2-MCM7-TRg-4":11621,
"GET2g2-BCP1-NRg-5":11622,
"GET2g2-STU2-TRg-3":11623,
"GET2g2-SEC21-NRg-6":11624,
"GET2g2-SEC21-NRg-3":11625,
"GET2g2-RPL1B-TRg-3":11626,
"GET2g2-SEC20-NRg-2":11627,
"GET2g2-VMA3-NRg-2":11628,
"GET2g2-SEC23-NRg-5":11629,
"GET2g2-CDC28-TRg-4":11630,
"GET2g2-RPN12-NRg-11":11631,
"GET2g2-PUP3-TRg-3":11632,
"GET2g2-SEC31-TRg-2":11633,
"GET2g2-SED5-TRg-6":11634,
"GET2g2-SED5-TRg-5":11635,
"GET2g2-RPL33A-TRg-1":11636,
"GET2g2-RPL33A-TRg-2":11637,
"GET2g2-MRPL11-TRg-2":11638,
"GET2g2-RTP1-NRg-2":11639,
"GET2g2-NUG1-TRg-2":11640,
"GET2g2-VPH2-TRg-4":11641,
"GET2g2-COP1-NRg-3":11642,
"GET2g2-CRM1-NRg-1":11643,
"GET2g2-RPL5-NRg-4":11644,
"GET2g2-SNU13-NRg-4":11645,
"GET2g2-PFS2-TRg-3":11646,
"GET2g2-MPP10-TRg-2":11647,
"GET2g2-TSR4-NRg-2":11648,
"GET2g2-RSC2-TRg-1":11649,
"GET2g2-SEC65-TRg-2":11650,
"GET2g2-SMI1-NRg-1":11651,
"GET2g2-RTT105-NRg-4":11652,
"GET2g2-VMA5-TRg-3":11653,
"GET2g2-VMA5-TRg-5":11654,
"GET2g2-RRP1-TRg-3":11655,
"GET2g2-CLC1-TRg-2":11656,
"GET2g2-GCD6-NRg-1":11657,
"GET2g2-GCD6-NRg-2":11658,
"GET2g2-PXR1-TRg-1":11659,
"GET2g2-CDC14-NRg-1":11660,
"GET2g2-PCF11-TRg-6":11661,
"GET2g2-PCF11-TRg-5":11662,
"GET2g2-PCF11-TRg-4":11663,
"GET2g2-SEC31-NRg-1":11664,
"GET2g2-RRP5-NRg-1":11665,
"GET2g2-PRE10-TRg-5":11666,
"GET2g2-PRE10-TRg-1":11667,
"GET2g2-RPS5-TRg-2":11668,
"GET2g2-NSP1-TRg-4":11669,
"GET2g2-PRP38-TRg-4":11670,
"GET2g2-RCF1-NRg-5":11671,
"GET2g2-RSC3-TRg-4":11672,
"GET2g2-RSC3-TRg-5":11673,
"GET2g2-RSC3-TRg-6":11674,
"GET2g2-HTA1-NRg-12":11675,
"GET2g2-HTA1-NRg-11":11676,
"GET2g2-UTP23-TRg-2":11677,
"GET2g2-GCD7-NRg-1":11678,
"GET2g2-GCD7-NRg-2":11679,
"GET2g2-GCD7-NRg-6":11680,
"GET2g2-GAL11-NRg-2":11681,
"GET2g2-GAL11-NRg-9":11682,
"GET2g2-PHO4-TRg-5":11683,
"GET2g2-SNP1-NRg-3":11684,
"GET2g2-RPC37-TRg-5":11685,
"GET2g2-CRM1-TRg-5":11686,
"GET2g2-CRM1-TRg-2":11687,
"GET2g2-ASK1-TRg-7":11688,
"GET2g2-STU2-NRg-4":11689,
"GET2g2-NEO1-NRg-3":11690,
"GET2g2-GAL11-TRg-5":11691,
"GET2g2-GAL11-TRg-7":11692,
"GET2g2-SAM50-NRg-3":11693,
"GET2g2-CSL4-TRg-2":11694,
"GET2g2-CCT5-TRg-2":11695,
"GET2g2-POL30-NRg-1":11696,
"GET2g2-MED4-TRg-4":11697,
"GET2g2-MED4-TRg-3":11698,
"GET2g2-MED4-TRg-2":11699,
"GET2g2-GDI1-TRg-4":11700,
"GET2g2-GDI1-TRg-3":11701,
"GET2g2-REB1-TRg-6":11702,
"GET2g2-MRPL37-NRg-2":11703,
"GET2g2-NOC3-TRg-3":11704,
"GET2g2-SPC97-TRg-3":11705,
"GET2g2-IPP1-TRg-3":11706,
"GET2g2-IPP1-TRg-2":11707,
"GET2g2-PTI1-TRg-3":11708,
"GET2g2-PTI1-TRg-5":11709,
"GET2g2-RFC5-NRg-1":11710,
"GET2g2-CDC24-TRg-1":11711,
"GET2g2-CDC24-TRg-3":11712,
"GET2g2-CDC24-TRg-5":11713,
"GET2g2-CDC24-TRg-6":11714,
"GET2g2-UTP23-TRg-6":11715,
"GET2g2-UTP23-TRg-4":11716,
"GET2g2-UTP23-TRg-1":11717,
"GET2g2-RHO3-NRg-4":11718,
"GET2g2-TRS23-NRg-1":11719,
"GET2g2-TRS23-NRg-3":11720,
"GET2g2-RSP5-TRg-2":11721,
"GET2g2-RSP5-TRg-1":11722,
"GET2g2-SDA1-NRg-1":11723,
"GET2g2-KAP95-TRg-8":11724,
"GET2g2-ACO1-TRg-6":11725,
"GET2g2-HTA1-NRg-3":11726,
"GET2g2-HTA1-NRg-2":11727,
"GET2g2-SPN1-TRg-1":11728,
"GET2g2-MOT1-NRg-7":11729,
"GET2g2-RPL17A-NRg-4":11730,
"GET2g2-ADA2-TRg-4":11731,
"GET2g2-SFH1-NRg-1":11732,
"GET2g2-SPC97-NRg-5":11733,
"GET2g2-PRP22-TRg-3":11734,
"GET2g2-SEN15-TRg-2":11735,
"GET2g2-RPL3-NRg-2":11736,
"GET2g2-ISD11-NRg-2":11737,
"GET2g2-HEM12-TRg-8":11738,
"GET2g2-SEC10-TRg-1":11739,
"GET2g2-HTB1-TRg-7":11740,
"GET2g2-TTI2-TRg-1":11741,
"GET2g2-ACP1-TRg-2":11742,
"GET2g2-ACP1-TRg-4":11743,
"GET2g2-GAL11-NRg-10":11744,
"GET2g2-UTP22-TRg-2":11745,
"GET2g2-MST1-NRg-5":11746,
"GET2g2-RIB7-NRg-2":11747,
"GET2g2-MCD1-TRg-6":11748,
"GET2g2-MCD1-TRg-5":11749,
"GET2g2-GPI8-NRg-2":11750,
"GET2g2-THS1-TRg-2":11751,
"GET2g2-RRP7-TRg-2":11752,
"GET2g2-RRP7-TRg-5":11753,
"GET2g2-SMX2-NRg-7":11754,
"GET2g2-RRP45-TRg-5":11755,
"GET2g2-RRP45-TRg-4":11756,
"GET2g2-CNS1-TRg-2":11757,
"GET2g2-FBP1-NRg-9":11758,
"GET2g2-GCD11-NRg-1":11759,
"GET2g2-RPL10-TRg-2":11760,
"GET2g2-NUP192-TRg-4":11761,
"GET2g2-NUP145-NRg-4":11762,
"GET2g2-HEM12-TRg-6":11763,
"GET2g2-PLC1-TRg-3":11764,
"GET2g2-RPA43-TRg-1":11765,
"GET2g2-RPB7-NRg-2":11766,
"GET2g2-RPB7-NRg-3":11767,
"GET2g2-NSL1-NRg-1":11768,
"GET2g2-UTP6-TRg-3":11769,
"GET2g2-UTP6-TRg-1":11770,
"GET2g2-YJU2-TRg-5":11771,
"GET2g2-FRS2-NRg-5":11772,
"GET2g2-TIF35-NRg-2":11773,
"GET2g2-GPI15-TRg-1":11774,
"GET2g2-NOP1-NRg-5":11775,
"GET2g2-GPI15-TRg-4":11776,
"GET2g2-COG4-TRg-1":11777,
"GET2g2-TFA1-TRg-1":11778,
"GET2g2-RHO1-NRg-2":11779,
"GET2g2-RHO1-NRg-1":11780,
"GET2g2-CDC55-NRg-2":11781,
"GET2g2-IDI1-NRg-7":11782,
"GET2g2-RPL32-TRg-5":11783,
"GET2g2-RPB5-TRg-4":11784,
"GET2g2-DIP2-TRg-5":11785,
"GET2g2-DIP2-TRg-1":11786,
"GET2g2-RPC40-TRg-2":11787,
"GET2g2-CDC6-TRg-5":11788,
"GET2g2-CDC6-TRg-3":11789,
"GET2g2-DAD2-TRg-2":11790,
"GET2g2-RVS161-TRg-2":11791,
"GET2g2-RVS161-TRg-1":11792,
"GET2g2-SUP45-NRg-3":11793,
"GET2g2-SRB6-NRg-5":11794,
"GET2g2-RPC11-TRg-4":11795,
"GET2g2-RKI1-TRg-8":11796,
"GET2g2-NIP7-TRg-3":11797,
"GET2g2-RPL33A-NRg-12":11798,
"GET2g2-SAM50-TRg-4":11799,
"GET2g2-NOP4-NRg-1":11800,
"GET2g2-NOP4-NRg-3":11801,
"GET2g2-SMX2-TRg-5":11802,
"GET2g2-POL12-NRg-2":11803,
"GET2g2-BMS1-NRg-2":11804,
"GET2g2-RPA190-TRg-5":11805,
"GET2g2-ALG14-NRg-4":11806,
"GET2g2-ALG14-NRg-1":11807,
"GET2g2-PRE5-NRg-1":11808,
"GET2g2-BIG1-NRg-2":11809,
"GET2g2-TFA2-TRg-4":11810,
"GET2g2-IMP4-TRg-6":11811,
"GET2g2-PAN1-NRg-1":11812,
"GET2g2-UTP13-TRg-2":11813,
"GET2g2-KAE1-NRg-3":11814,
"GET2g2-ERG20-TRg-1":11815,
"GET2g2-CDC20-TRg-6":11816,
"GET2g2-PWP2-NRg-2":11817,
"GET2g2-COG1-NRg-1":11818,
"GET2g2-RPL1B-TRg-4":11819,
"GET2g2-RPL1B-TRg-7":11820,
"GET2g2-UTP20-TRg-3":11821,
"GET2g2-UTP20-TRg-4":11822,
"GET2g2-RPL25-TRg-4":11823,
"GET2g2-RPL25-TRg-2":11824,
"GET2g2-MCM7-NRg-1":11825,
"GET2g2-MRP49-TRg-5":11826,
"GET2g2-ERO1-NRg-3":11827,
"GET2g2-UTP5-TRg-7":11828,
"GET2g2-MCM4-NRg-1":11829,
"GET2g2-PRE3-NRg-1":11830,
"GET2g2-FCF1-NRg-1":11831,
"GET2g2-CUS1-NRg-1":11832,
"GET2g2-PSF1-TRg-2":11833,
"GET2g2-BCP1-TRg-2":11834,
"GET2g2-PAN1-TRg-1":11835,
"GET2g2-PAN1-TRg-3":11836,
"GET2g2-PAN1-TRg-4":11837,
"GET2g2-VPS3-TRg-2":11838,
"GET2g2-YIL060W-NRg-1":11839,
"GET2g2-VPS53-NRg-1":11840,
"GET2g2-CYR1-TRg-4":11841,
"GET2g2-CYR1-TRg-7":11842,
"GET2g2-MPS1-NRg-1":11843,
"GET2g2-SRP1-TRg-5":11844,
"GET2g2-SRP1-TRg-4":11845,
"GET2g2-TAF12-TRg-2":11846,
"GET2g2-TAF12-TRg-3":11847,
"GET2g2-POP4-TRg-1":11848,
"GET2g2-SPT16-TRg-1":11849,
"GET2g2-NUP82-TRg-4":11850,
"GET2g2-DML1-TRg-3":11851,
"GET2g2-RPA43-NRg-3":11852,
"GET2g2-STU2-NRg-3":11853,
"GET2g2-POP4-NRg-4":11854,
"GET2g2-MCD1-TRg-2":11855,
"GET2g2-RPS3-NRg-4":11856,
"GET2g2-PRP9-TRg-4":11857,
"GET2g2-RPP1-NRg-2":11858,
"GET2g2-MTR2-NRg-11":11859,
"GET2g2-GCD11-TRg-1":11860,
"GET2g2-RPF1-TRg-3":11861,
"GET2g2-SUB2-NRg-4":11862,
"GET2g2-GPI15-TRg-3":11863,
"GET2g2-ERG9-TRg-6":11864,
"GET2g2-RPT2-NRg-1":11865,
"GET2g2-YOS1-NRg-3":11866,
"GET2g2-SCM3-TRg-4":11867,
"GET2g2-SCM3-TRg-6":11868,
"GET2g2-RLP7-NRg-1":11869,
"GET2g2-TFB2-NRg-4":11870,
"GET2g2-IMP4-TRg-1":11871,
"GET2g2-IMP4-TRg-3":11872,
"GET2g2-PRE4-TRg-3":11873,
"GET2g2-SUB2-TRg-3":11874,
"GET2g2-RPP0-NRg-4":11875,
"GET2g2-RPP0-NRg-3":11876,
"GET2g2-TOM40-TRg-4":11877,
"GET2g2-FUR1-NRg-12":11878,
"GET2g2-TOM40-TRg-2":11879,
"GET2g2-VMA11-NRg-4":11880,
"GET2g2-PGS1-NRg-4":11881,
"GET2g2-URB1-TRg-4":11882,
"GET2g2-ARP4-TRg-3":11883,
"GET2g2-RPT3-TRg-3":11884,
"GET2g2-SUI3-TRg-3":11885,
"GET2g2-RFC5-NRg-2":11886,
"GET2g2-RRP14-TRg-2":11887,
"GET2g2-SCC2-TRg-1":11888,
"GET2g2-SSC1-TRg-3":11889,
"GET2g2-RRP9-TRg-3":11890,
"GET2g2-MOT1-NRg-9":11891,
"GET2g2-RPL42A-NRg-2":11892,
"GET2g2-SEC16-TRg-7":11893,
"GET2g2-IMP4-NRg-2":11894,
"GET2g2-YEF3-NRg-4":11895,
"GET2g2-PUP1-TRg-1":11896,
"GET2g2-UTP22-TRg-6":11897,
"GET2g2-DBP2-NRg-4":11898,
"GET2g2-PRE2-TRg-7":11899,
"GET2g2-ATP16-TRg-6":11900,
"GET2g2-UTP13-TRg-4":11901,
"GET2g2-DOP1-NRg-4":11902,
"GET2g2-TIM44-TRg-3":11903,
"GET2g2-ATP16-TRg-2":11904,
"GET2g2-ENP1-NRg-3":11905,
"GET2g2-NAF1-TRg-3":11906,
"GET2g2-COG4-TRg-2":11907,
"GET2g2-SOG2-TRg-7":11908,
"GET2g2-YDR341C-TRg-3":11909,
"GET2g2-YMR290W-A-TRg-10":11910,
"GET2g2-NUP192-NRg-9":11911,
"GET2g2-RPS31-NRg-8":11912,
"GET2g2-SPC97-NRg-6":11913,
"GET2g2-EBP2-NRg-1":11914,
"GET2g2-CDC48-TRg-5":11915,
"GET2g2-RPT1-TRg-4":11916,
"GET2g2-ULP1-NRg-2":11917,
"GET2g2-RPN3-TRg-6":11918,
"GET2g2-RPT1-TRg-5":11919,
"GET2g2-KRE5-TRg-2":11920,
"GET2g2-TBF1-NRg-8":11921,
"GET2g2-UTP22-NRg-4":11922,
"GET2g2-SSC1-NRg-4":11923,
"GET2g2-REB1-TRg-4":11924,
"GET2g2-CDC48-NRg-9":11925,
"GET2g2-FAS2-TRg-8":11926,
"GET2g2-TAO3-TRg-8":11927,
"GET2g2-CKS1-TRg-5":11928,
"GET2g2-YLR379W-TRg-7":11929,
"GET2g2-TEN1-NRg-2":11930,
"GET2g2-RPL42A-TRg-2":11931,
"GET2g2-SEC27-TRg-4":11932,
"GET2g2-TBF1-NRg-4":11933,
"GET2g2-RPT1-NRg-6":11934,
"GET2g2-COG1-TRg-3":11935,
"GET2g2-SUI1-TRg-6":11936,
"GET2g2-TIM23-TRg-6":11937,
"GET2g2-CDC48-NRg-6":11938,
"GET2g2-EPL1-TRg-5":11939,
"GET2g2-RPT5-TRg-8":11940,
"GET2g2-ATP16-NRg-4":11941,
"GET2g2-RPN6-TRg-3":11942,
"GET2g2-ERG9-NRg-6":11943,
"GET2g2-SMX3-TRg-1":11944,
"GET2g2-NCB2-NRg-3":11945,
"GET2g2-SEC16-NRg-12":11946,
"GET2g2-RPN6-TRg-2":11947,
"GET2g2-REB1-NRg-4":11948,
"GET2g2-ATP16-TRg-9":11949,
"GET2g2-ERG9-NRg-7":11950,
"IMP4g6-RPL15A-NRg-4":11951,
"IMP4g6-RPL15A-NRg-5":11952,
"IMP4g6-KRE33-TRg-1":11953,
"IMP4g6-PMI40-NRg-1":11954,
"IMP4g6-NOP19-NRg-3":11955,
"IMP4g6-SRP14-NRg-4":11956,
"IMP4g6-SEC27-TRg-2":11957,
"IMP4g6-GPI14-TRg-3":11958,
"IMP4g6-PAH1-TRg-7":11959,
"IMP4g6-PAH1-TRg-6":11960,
"IMP4g6-PAH1-TRg-5":11961,
"IMP4g6-PAH1-TRg-3":11962,
"IMP4g6-COG3-TRg-1":11963,
"IMP4g6-HTS1-NRg-5":11964,
"IMP4g6-MSN5-TRg-7":11965,
"IMP4g6-ERG26-TRg-1":11966,
"IMP4g6-SMD2-TRg-5":11967,
"IMP4g6-SMD2-TRg-4":11968,
"IMP4g6-SMD2-TRg-1":11969,
"IMP4g6-PRE7-TRg-4":11970,
"IMP4g6-PRE7-TRg-7":11971,
"IMP4g6-SEC6-TRg-3":11972,
"IMP4g6-ESF2-NRg-1":11973,
"IMP4g6-ESF2-NRg-3":11974,
"IMP4g6-AFG2-TRg-2":11975,
"IMP4g6-RRP36-TRg-3":11976,
"IMP4g6-RRP36-TRg-5":11977,
"IMP4g6-GCR1-NRg-2":11978,
"IMP4g6-PRE4-NRg-4":11979,
"IMP4g6-PRE4-NRg-9":11980,
"IMP4g6-DSN1-NRg-2":11981,
"IMP4g6-GPI11-TRg-3":11982,
"IMP4g6-POP3-TRg-1":11983,
"IMP4g6-MNE1-TRg-5":11984,
"IMP4g6-RRP12-NRg-1":11985,
"IMP4g6-RSC6-TRg-2":11986,
"IMP4g6-CDC25-TRg-1":11987,
"IMP4g6-CDC25-TRg-9":11988,
"IMP4g6-YPP1-NRg-3":11989,
"IMP4g6-NFS1-NRg-9":11990,
"IMP4g6-NFS1-NRg-8":11991,
"IMP4g6-UBA2-TRg-1":11992,
"IMP4g6-ARP2-NRg-3":11993,
"IMP4g6-MAK16-TRg-1":11994,
"IMP4g6-CEP3-NRg-1":11995,
"IMP4g6-GUK1-TRg-5":11996,
"IMP4g6-GUK1-TRg-2":11997,
"IMP4g6-GPI12-NRg-6":11998,
"IMP4g6-RPS5-NRg-5":11999,
"IMP4g6-RPS5-NRg-2":12000,
"IMP4g6-RPC19-NRg-1":12001,
"IMP4g6-TIM54-TRg-1":12002,
"IMP4g6-TEN1-TRg-2":12003,
"IMP4g6-SAH1-NRg-4":12004,
"IMP4g6-SAH1-NRg-5":12005,
"IMP4g6-SAH1-NRg-3":12006,
"IMP4g6-ATP15-NRg-5":12007,
"IMP4g6-SCD5-TRg-5":12008,
"IMP4g6-ARB1-NRg-2":12009,
"IMP4g6-ARB1-NRg-4":12010,
"IMP4g6-PUP2-TRg-1":12011,
"IMP4g6-CCT8-TRg-2":12012,
"IMP4g6-MCM4-TRg-1":12013,
"IMP4g6-LSM4-TRg-1":12014,
"IMP4g6-NOP53-NRg-1":12015,
"IMP4g6-ATP3-TRg-4":12016,
"IMP4g6-AFG2-NRg-3":12017,
"IMP4g6-PRO3-NRg-3":12018,
"IMP4g6-NRD1-NRg-10":12019,
"IMP4g6-SEC61-TRg-2":12020,
"IMP4g6-RHO3-TRg-4":12021,
"IMP4g6-SNF2-TRg-6":12022,
"IMP4g6-SMD2-NRg-3":12023,
"IMP4g6-RSC4-TRg-2":12024,
"IMP4g6-RSC4-TRg-1":12025,
"IMP4g6-TIF34-TRg-2":12026,
"IMP4g6-BET1-NRg-1":12027,
"IMP4g6-CDC8-NRg-2":12028,
"IMP4g6-PRP42-TRg-2":12029,
"IMP4g6-RRB1-TRg-2":12030,
"IMP4g6-SPC24-TRg-1":12031,
"IMP4g6-ILS1-NRg-1":12032,
"IMP4g6-GFA1-TRg-2":12033,
"IMP4g6-SEC21-NRg-10":12034,
"IMP4g6-RPC10-NRg-1":12035,
"IMP4g6-RPB10-TRg-3":12036,
"IMP4g6-RPB10-TRg-2":12037,
"IMP4g6-YNL181W-TRg-1":12038,
"IMP4g6-RAD3-NRg-1":12039,
"IMP4g6-NOP10-TRg-1":12040,
"IMP4g6-BFR2-TRg-3":12041,
"IMP4g6-MCM2-TRg-6":12042,
"IMP4g6-MCM2-TRg-4":12043,
"IMP4g6-MPP10-TRg-1":12044,
"IMP4g6-RET2-TRg-4":12045,
"IMP4g6-RET2-TRg-1":12046,
"IMP4g6-RPS2-NRg-1":12047,
"IMP4g6-RPS2-NRg-2":12048,
"IMP4g6-ORC4-NRg-3":12049,
"IMP4g6-TIP20-TRg-7":12050,
"IMP4g6-SMT3-TRg-1":12051,
"IMP4g6-MSS18-NRg-6":12052,
"IMP4g6-YEF3-NRg-9":12053,
"IMP4g6-ASK1-NRg-1":12054,
"IMP4g6-SMC1-TRg-1":12055,
"IMP4g6-NIP1-NRg-1":12056,
"IMP4g6-RPP1-NRg-1":12057,
"IMP4g6-YDJ1-TRg-6":12058,
"IMP4g6-SUB2-NRg-1":12059,
"IMP4g6-TIM10-NRg-8":12060,
"IMP4g6-TIM10-NRg-4":12061,
"IMP4g6-TIM10-NRg-7":12062,
"IMP4g6-SKI6-TRg-4":12063,
"IMP4g6-TUB4-TRg-1":12064,
"IMP4g6-CDC37-NRg-2":12065,
"IMP4g6-ISD11-TRg-3":12066,
"IMP4g6-YOS1-TRg-4":12067,
"IMP4g6-SSC1-TRg-6":12068,
"IMP4g6-MTR3-TRg-5":12069,
"IMP4g6-MTR3-TRg-6":12070,
"IMP4g6-TFA1-TRg-2":12071,
"IMP4g6-CDC3-NRg-3":12072,
"IMP4g6-ERG25-TA-18":12073,
"IMP4g6-RPB11-TRg-4":12074,
"IMP4g6-RPB11-TRg-1":12075,
"IMP4g6-RPB11-TRg-2":12076,
"IMP4g6-DED1-TRg-3":12077,
"IMP4g6-DED1-TRg-1":12078,
"IMP4g6-DED1-TRg-6":12079,
"IMP4g6-DED1-TRg-4":12080,
"IMP4g6-RPL10-NRg-5":12081,
"IMP4g6-RPL10-NRg-4":12082,
"IMP4g6-EFB1-NRg-1":12083,
"IMP4g6-EFB1-NRg-5":12084,
"IMP4g6-EFB1-NRg-4":12085,
"IMP4g6-RPT3-NRg-1":12086,
"IMP4g6-SAC6-TRg-8":12087,
"IMP4g6-SAC6-TRg-4":12088,
"IMP4g6-SAC6-TRg-5":12089,
"IMP4g6-SAC6-TRg-3":12090,
"IMP4g6-DIM1-TRg-5":12091,
"IMP4g6-DIM1-TRg-7":12092,
"IMP4g6-RPC17-NRg-1":12093,
"IMP4g6-RPC17-NRg-2":12094,
"IMP4g6-YDR341C-TRg-1":12095,
"IMP4g6-RAP1-NRg-8":12096,
"IMP4g6-RAP1-NRg-5":12097,
"IMP4g6-RAP1-NRg-2":12098,
"IMP4g6-SEC26-NRg-3":12099,
"IMP4g6-SPP41-TRg-3":12100,
"IMP4g6-TAP42-NRg-1":12101,
"IMP4g6-PGA2-TRg-6":12102,
"IMP4g6-BRL1-TRg-1":12103,
"IMP4g6-FOL2-TRg-1":12104,
"IMP4g6-NAB3-NRg-5":12105,
"IMP4g6-SNF4-TRg-4":12106,
"IMP4g6-HRR25-TRg-2":12107,
"IMP4g6-TRS23-TRg-4":12108,
"IMP4g6-CTR86-TRg-4":12109,
"IMP4g6-RPB5-TRg-5":12110,
"IMP4g6-SPN1-NRg-2":12111,
"IMP4g6-SPN1-NRg-1":12112,
"IMP4g6-SEC61-NRg-1":12113,
"IMP4g6-SEC61-NRg-7":12114,
"IMP4g6-TUS1-TRg-3":12115,
"IMP4g6-OLE1-NRg-2":12116,
"IMP4g6-AFG2-TRg-1":12117,
"IMP4g6-TOA2-NRg-1":12118,
"IMP4g6-USO1-TRg-1":12119,
"IMP4g6-UTP22-NRg-2":12120,
"IMP4g6-RIB1-TRg-3":12121,
"IMP4g6-RIB1-TRg-7":12122,
"IMP4g6-RIB1-TRg-4":12123,
"IMP4g6-COG1-TRg-1":12124,
"IMP4g6-RPL32-NRg-2":12125,
"IMP4g6-GLC7-NRg-3":12126,
"IMP4g6-GLC7-NRg-4":12127,
"IMP4g6-HSF1-TRg-2":12128,
"IMP4g6-DAM1-NRg-5":12129,
"IMP4g6-SEC18-TRg-4":12130,
"IMP4g6-SEC18-TRg-5":12131,
"IMP4g6-PAB1-NRg-3":12132,
"IMP4g6-POP8-TRg-2":12133,
"IMP4g6-PAB1-NRg-4":12134,
"IMP4g6-BIG1-TRg-4":12135,
"IMP4g6-BIG1-TRg-5":12136,
"IMP4g6-BIG1-TRg-6":12137,
"IMP4g6-RPO41-NRg-1":12138,
"IMP4g6-RVB2-NRg-2":12139,
"IMP4g6-PET117-NRg-8":12140,
"IMP4g6-VPS45-NRg-9":12141,
"IMP4g6-YCG1-NRg-1":12142,
"IMP4g6-NOC4-NRg-1":12143,
"IMP4g6-NMD3-NRg-2":12144,
"IMP4g6-DRS1-TRg-2":12145,
"IMP4g6-HTB1-NRg-2":12146,
"IMP4g6-IPI1-TRg-2":12147,
"IMP4g6-SEC18-NRg-1":12148,
"IMP4g6-SEC18-NRg-2":12149,
"IMP4g6-JIP5-NRg-2":12150,
"IMP4g6-YPT1-TRg-3":12151,
"IMP4g6-YPT1-TRg-2":12152,
"IMP4g6-CLF1-NRg-2":12153,
"IMP4g6-SNF2-NRg-7":12154,
"IMP4g6-SNF2-NRg-4":12155,
"IMP4g6-RPL25-NRg-1":12156,
"IMP4g6-NOP56-TRg-1":12157,
"IMP4g6-NOP56-TRg-2":12158,
"IMP4g6-TRS31-TRg-1":12159,
"IMP4g6-DBF4-TRg-2":12160,
"IMP4g6-DBF4-TRg-1":12161,
"IMP4g6-RPC19-TRg-4":12162,
"IMP4g6-RPC19-TRg-6":12163,
"IMP4g6-RPC19-TRg-3":12164,
"IMP4g6-ROK1-NRg-1":12165,
"IMP4g6-CDC33-TRg-4":12166,
"IMP4g6-DHR2-TRg-3":12167,
"IMP4g6-RRP42-NRg-5":12168,
"IMP4g6-CLF1-TRg-1":12169,
"IMP4g6-ERG11-NA-16":12170,
"IMP4g6-VAS1-NRg-4":12171,
"IMP4g6-PIK1-NRg-2":12172,
"IMP4g6-SAR1-NRg-7":12173,
"IMP4g6-SAR1-NRg-4":12174,
"IMP4g6-RPS3-TRg-1":12175,
"IMP4g6-YTM1-TRg-2":12176,
"IMP4g6-SUI3-NRg-5":12177,
"IMP4g6-SUI3-NRg-2":12178,
"IMP4g6-RRP7-TRg-4":12179,
"IMP4g6-RRP7-TRg-6":12180,
"IMP4g6-NIP7-TRg-2":12181,
"IMP4g6-MDM35-TRg-1":12182,
"IMP4g6-ALA1-NRg-1":12183,
"IMP4g6-DOA4-NRg-2":12184,
"IMP4g6-RPS13-NRg-1":12185,
"IMP4g6-YSF3-TRg-2":12186,
"IMP4g6-RPS2-NRg-11":12187,
"IMP4g6-SSL1-TRg-10":12188,
"IMP4g6-NIP7-TRg-1":12189,
"IMP4g6-LST8-NRg-1":12190,
"IMP4g6-TAF4-TRg-3":12191,
"IMP4g6-HAS1-TRg-2":12192,
"IMP4g6-GLC7-TRg-2":12193,
"IMP4g6-CDC45-NRg-1":12194,
"IMP4g6-SEC22-NRg-8":12195,
"IMP4g6-YOS1-TRg-2":12196,
"IMP4g6-RBA50-TRg-3":12197,
"IMP4g6-SPP41-NRg-2":12198,
"IMP4g6-PRP46-TRg-2":12199,
"IMP4g6-PGA2-NRg-1":12200,
"IMP4g6-CBF5-TRg-3":12201,
"IMP4g6-TCP1-NRg-3":12202,
"IMP4g6-TCP1-NRg-2":12203,
"IMP4g6-ERG26-NRg-2":12204,
"IMP4g6-ERG26-NRg-4":12205,
"IMP4g6-MES1-TRg-5":12206,
"IMP4g6-HTS1-TRg-2":12207,
"IMP4g6-SSS1-TRg-3":12208,
"IMP4g6-SSS1-TRg-2":12209,
"IMP4g6-SYS1-TRg-7":12210,
"IMP4g6-SYS1-TRg-2":12211,
"IMP4g6-SYS1-TRg-1":12212,
"IMP4g6-BFR2-TRg-1":12213,
"IMP4g6-EOS1-TRg-3":12214,
"IMP4g6-TAF4-NRg-1":12215,
"IMP4g6-ARL3-NRg-8":12216,
"IMP4g6-RPN5-NRg-1":12217,
"IMP4g6-TIM9-NRg-2":12218,
"IMP4g6-NUP57-NRg-3":12219,
"IMP4g6-VPS4-TRg-1":12220,
"IMP4g6-CDC3-TRg-4":12221,
"IMP4g6-BBP1-NRg-1":12222,
"IMP4g6-BBP1-NRg-2":12223,
"IMP4g6-USE1-NRg-3":12224,
"IMP4g6-CCT7-TRg-1":12225,
"IMP4g6-SAH1-TRg-3":12226,
"IMP4g6-CHS2-TRg-1":12227,
"IMP4g6-DPM1-TRg-2":12228,
"IMP4g6-BBP1-TRg-1":12229,
"IMP4g6-NRD1-TRg-4":12230,
"IMP4g6-RPB3-NRg-1":12231,
"IMP4g6-PHO85-NRg-6":12232,
"IMP4g6-SNF6-TRg-6":12233,
"IMP4g6-PRP38-NRg-2":12234,
"IMP4g6-OAR1-NRg-3":12235,
"IMP4g6-ROX3-NRg-1":12236,
"IMP4g6-YPP1-TRg-6":12237,
"IMP4g6-CBF2-NRg-8":12238,
"IMP4g6-SPT6-TRg-5":12239,
"IMP4g6-SEC10-NRg-1":12240,
"IMP4g6-NSL1-NRg-3":12241,
"IMP4g6-NRD1-NRg-8":12242,
"IMP4g6-RPB3-TRg-1":12243,
"IMP4g6-NRD1-NRg-4":12244,
"IMP4g6-RVB1-TRg-2":12245,
"IMP4g6-TIF5-NRg-8":12246,
"IMP4g6-EOS1-NRg-1":12247,
"IMP4g6-ERG25-NA-26":12248,
"IMP4g6-MSL5-NRg-4":12249,
"IMP4g6-SEC24-TRg-2":12250,
"IMP4g6-RPL30-NRg-5":12251,
"IMP4g6-SNU71-NRg-3":12252,
"IMP4g6-CDC33-NRg-1":12253,
"IMP4g6-RPN6-TRg-4":12254,
"IMP4g6-NAB2-TRg-4":12255,
"IMP4g6-NAB2-TRg-6":12256,
"IMP4g6-YTM1-NRg-1":12257,
"IMP4g6-OLE1-TRg-8":12258,
"IMP4g6-OLE1-TRg-1":12259,
"IMP4g6-UTP7-TRg-4":12260,
"IMP4g6-ACT1-NRg-6":12261,
"IMP4g6-RPL18A-NRg-3":12262,
"IMP4g6-BRX1-NRg-1":12263,
"IMP4g6-NAF1-TRg-8":12264,
"IMP4g6-NAF1-TRg-6":12265,
"IMP4g6-NAF1-TRg-4":12266,
"IMP4g6-CDC8-TRg-2":12267,
"IMP4g6-NSE4-TRg-1":12268,
"IMP4g6-PAB1-NRg-2":12269,
"IMP4g6-PRP43-TRg-4":12270,
"IMP4g6-SEC2-NRg-3":12271,
"IMP4g6-SEC2-NRg-6":12272,
"IMP4g6-MPP10-NRg-5":12273,
"IMP4g6-YDR355C-TRg-2":12274,
"IMP4g6-YLR339C-TRg-9":12275,
"IMP4g6-SNM1-TRg-2":12276,
"IMP4g6-ALR1-NRg-4":12277,
"IMP4g6-ALR1-NRg-1":12278,
"IMP4g6-ALR1-NRg-3":12279,
"IMP4g6-RPL10-TRg-1":12280,
"IMP4g6-RPL28-TRg-2":12281,
"IMP4g6-UTP25-TRg-1":12282,
"IMP4g6-POB3-TRg-1":12283,
"IMP4g6-POB3-TRg-3":12284,
"IMP4g6-POB3-TRg-2":12285,
"IMP4g6-MED11-TRg-1":12286,
"IMP4g6-ISA1-TRg-15":12287,
"IMP4g6-RRP1-NRg-1":12288,
"IMP4g6-MES1-NRg-1":12289,
"IMP4g6-SEC13-NRg-5":12290,
"IMP4g6-MCM2-NRg-2":12291,
"IMP4g6-ALA1-TRg-4":12292,
"IMP4g6-MTG2-TRg-5":12293,
"IMP4g6-TIF35-NRg-3":12294,
"IMP4g6-NSE1-TRg-3":12295,
"IMP4g6-NSE1-TRg-4":12296,
"IMP4g6-MOB2-NRg-6":12297,
"IMP4g6-VRG4-NRg-3":12298,
"IMP4g6-PRP9-TRg-3":12299,
"IMP4g6-HYM1-TRg-5":12300,
"IMP4g6-POP1-TRg-5":12301,
"IMP4g6-POP1-TRg-9":12302,
"IMP4g6-RPL17A-TRg-1":12303,
"IMP4g6-SLD2-TRg-1":12304,
"IMP4g6-CDC48-NRg-7":12305,
"IMP4g6-FHL1-NRg-2":12306,
"IMP4g6-BET3-NRg-7":12307,
"IMP4g6-MAK21-TRg-1":12308,
"IMP4g6-BRN1-TRg-4":12309,
"IMP4g6-FBA1-NRg-3":12310,
"IMP4g6-CDC42-TRg-6":12311,
"IMP4g6-CDC42-TRg-7":12312,
"IMP4g6-COG4-NRg-1":12313,
"IMP4g6-ATP3-NRg-3":12314,
"IMP4g6-ATP3-NRg-2":12315,
"IMP4g6-SMP3-TRg-5":12316,
"IMP4g6-CFT2-NRg-2":12317,
"IMP4g6-FAS2-TRg-5":12318,
"IMP4g6-DBP2-NRg-3":12319,
"IMP4g6-DBP2-NRg-2":12320,
"IMP4g6-MPS2-NRg-4":12321,
"IMP4g6-ARC35-TRg-2":12322,
"IMP4g6-ARC35-TRg-5":12323,
"IMP4g6-MRD1-TRg-1":12324,
"IMP4g6-RLP7-TRg-1":12325,
"IMP4g6-SPC34-TRg-1":12326,
"IMP4g6-CDC45-TRg-2":12327,
"IMP4g6-GCD6-TRg-3":12328,
"IMP4g6-GCD6-TRg-4":12329,
"IMP4g6-YPT6-NRg-2":12330,
"IMP4g6-RPS13-TRg-2":12331,
"IMP4g6-IPI3-TRg-3":12332,
"IMP4g6-TIF5-NRg-9":12333,
"IMP4g6-TIF5-NRg-7":12334,
"IMP4g6-TIF5-NRg-6":12335,
"IMP4g6-NAB3-TRg-3":12336,
"IMP4g6-GCD2-TRg-1":12337,
"IMP4g6-UBA1-TRg-2":12338,
"IMP4g6-SLD3-TRg-6":12339,
"IMP4g6-LCB1-TRg-5":12340,
"IMP4g6-TOA2-TRg-6":12341,
"IMP4g6-TOA2-TRg-1":12342,
"IMP4g6-TOA2-TRg-3":12343,
"IMP4g6-LSM2-TRg-1":12344,
"IMP4g6-YML6-TRg-13":12345,
"IMP4g6-YML6-TRg-12":12346,
"IMP4g6-UTP15-NRg-1":12347,
"IMP4g6-TIF6-NRg-8":12348,
"IMP4g6-SUP35-NRg-1":12349,
"IMP4g6-MPP10-NRg-1":12350,
"IMP4g6-SWI3-TRg-7":12351,
"IMP4g6-SSN3-NRg-2":12352,
"IMP4g6-SEC13-NRg-7":12353,
"IMP4g6-RPS15-NRg-3":12354,
"IMP4g6-RPL3-TRg-2":12355,
"IMP4g6-FBA1-NRg-2":12356,
"IMP4g6-FBA1-NRg-1":12357,
"IMP4g6-FBA1-NRg-5":12358,
"IMP4g6-DAM1-TRg-2":12359,
"IMP4g6-NHP2-TRg-2":12360,
"IMP4g6-HCA4-NRg-6":12361,
"IMP4g6-PRE3-TRg-4":12362,
"IMP4g6-DBP5-NRg-4":12363,
"IMP4g6-SPT6-NRg-4":12364,
"IMP4g6-SPT6-NRg-2":12365,
"IMP4g6-RPL18A-TRg-4":12366,
"IMP4g6-KSH1-TRg-1":12367,
"IMP4g6-KSH1-TRg-3":12368,
"IMP4g6-IPI3-NRg-1":12369,
"IMP4g6-PGA2-TRg-8":12370,
"IMP4g6-RPL18A-TRg-2":12371,
"IMP4g6-RPL33A-NRg-6":12372,
"IMP4g6-TAF12-NRg-2":12373,
"IMP4g6-USE1-TRg-5":12374,
"IMP4g6-YNL114C-TRg-1":12375,
"IMP4g6-SMC5-TRg-7":12376,
"IMP4g6-SMC5-TRg-6":12377,
"IMP4g6-RSC58-TRg-1":12378,
"IMP4g6-CTF13-TRg-2":12379,
"IMP4g6-NAB2-NRg-2":12380,
"IMP4g6-MCM7-TRg-4":12381,
"IMP4g6-BCP1-NRg-5":12382,
"IMP4g6-STU2-TRg-3":12383,
"IMP4g6-SEC21-NRg-6":12384,
"IMP4g6-SEC21-NRg-3":12385,
"IMP4g6-RPL1B-TRg-3":12386,
"IMP4g6-SEC20-NRg-2":12387,
"IMP4g6-VMA3-NRg-2":12388,
"IMP4g6-SEC23-NRg-5":12389,
"IMP4g6-CDC28-TRg-4":12390,
"IMP4g6-RPN12-NRg-11":12391,
"IMP4g6-PUP3-TRg-3":12392,
"IMP4g6-SEC31-TRg-2":12393,
"IMP4g6-SED5-TRg-6":12394,
"IMP4g6-SED5-TRg-5":12395,
"IMP4g6-RPL33A-TRg-1":12396,
"IMP4g6-RPL33A-TRg-2":12397,
"IMP4g6-MRPL11-TRg-2":12398,
"IMP4g6-RTP1-NRg-2":12399,
"IMP4g6-NUG1-TRg-2":12400,
"IMP4g6-VPH2-TRg-4":12401,
"IMP4g6-COP1-NRg-3":12402,
"IMP4g6-CRM1-NRg-1":12403,
"IMP4g6-RPL5-NRg-4":12404,
"IMP4g6-SNU13-NRg-4":12405,
"IMP4g6-PFS2-TRg-3":12406,
"IMP4g6-MPP10-TRg-2":12407,
"IMP4g6-TSR4-NRg-2":12408,
"IMP4g6-RSC2-TRg-1":12409,
"IMP4g6-SEC65-TRg-2":12410,
"IMP4g6-SMI1-NRg-1":12411,
"IMP4g6-RTT105-NRg-4":12412,
"IMP4g6-VMA5-TRg-3":12413,
"IMP4g6-VMA5-TRg-5":12414,
"IMP4g6-RRP1-TRg-3":12415,
"IMP4g6-CLC1-TRg-2":12416,
"IMP4g6-GCD6-NRg-1":12417,
"IMP4g6-GCD6-NRg-2":12418,
"IMP4g6-PXR1-TRg-1":12419,
"IMP4g6-CDC14-NRg-1":12420,
"IMP4g6-PCF11-TRg-6":12421,
"IMP4g6-PCF11-TRg-5":12422,
"IMP4g6-PCF11-TRg-4":12423,
"IMP4g6-SEC31-NRg-1":12424,
"IMP4g6-RRP5-NRg-1":12425,
"IMP4g6-PRE10-TRg-5":12426,
"IMP4g6-PRE10-TRg-1":12427,
"IMP4g6-RPS5-TRg-2":12428,
"IMP4g6-NSP1-TRg-4":12429,
"IMP4g6-PRP38-TRg-4":12430,
"IMP4g6-RCF1-NRg-5":12431,
"IMP4g6-RSC3-TRg-4":12432,
"IMP4g6-RSC3-TRg-5":12433,
"IMP4g6-RSC3-TRg-6":12434,
"IMP4g6-HTA1-NRg-12":12435,
"IMP4g6-HTA1-NRg-11":12436,
"IMP4g6-UTP23-TRg-2":12437,
"IMP4g6-GCD7-NRg-1":12438,
"IMP4g6-GCD7-NRg-2":12439,
"IMP4g6-GCD7-NRg-6":12440,
"IMP4g6-GAL11-NRg-2":12441,
"IMP4g6-GAL11-NRg-9":12442,
"IMP4g6-PHO4-TRg-5":12443,
"IMP4g6-SNP1-NRg-3":12444,
"IMP4g6-RPC37-TRg-5":12445,
"IMP4g6-CRM1-TRg-5":12446,
"IMP4g6-CRM1-TRg-2":12447,
"IMP4g6-ASK1-TRg-7":12448,
"IMP4g6-STU2-NRg-4":12449,
"IMP4g6-NEO1-NRg-3":12450,
"IMP4g6-GAL11-TRg-5":12451,
"IMP4g6-GAL11-TRg-7":12452,
"IMP4g6-SAM50-NRg-3":12453,
"IMP4g6-CSL4-TRg-2":12454,
"IMP4g6-CCT5-TRg-2":12455,
"IMP4g6-POL30-NRg-1":12456,
"IMP4g6-MED4-TRg-4":12457,
"IMP4g6-MED4-TRg-3":12458,
"IMP4g6-MED4-TRg-2":12459,
"IMP4g6-GDI1-TRg-4":12460,
"IMP4g6-GDI1-TRg-3":12461,
"IMP4g6-REB1-TRg-6":12462,
"IMP4g6-MRPL37-NRg-2":12463,
"IMP4g6-NOC3-TRg-3":12464,
"IMP4g6-SPC97-TRg-3":12465,
"IMP4g6-IPP1-TRg-3":12466,
"IMP4g6-IPP1-TRg-2":12467,
"IMP4g6-PTI1-TRg-3":12468,
"IMP4g6-PTI1-TRg-5":12469,
"IMP4g6-RFC5-NRg-1":12470,
"IMP4g6-CDC24-TRg-1":12471,
"IMP4g6-CDC24-TRg-3":12472,
"IMP4g6-CDC24-TRg-5":12473,
"IMP4g6-CDC24-TRg-6":12474,
"IMP4g6-UTP23-TRg-6":12475,
"IMP4g6-UTP23-TRg-4":12476,
"IMP4g6-UTP23-TRg-1":12477,
"IMP4g6-RHO3-NRg-4":12478,
"IMP4g6-TRS23-NRg-1":12479,
"IMP4g6-TRS23-NRg-3":12480,
"IMP4g6-RSP5-TRg-2":12481,
"IMP4g6-RSP5-TRg-1":12482,
"IMP4g6-SDA1-NRg-1":12483,
"IMP4g6-KAP95-TRg-8":12484,
"IMP4g6-ACO1-TRg-6":12485,
"IMP4g6-HTA1-NRg-3":12486,
"IMP4g6-HTA1-NRg-2":12487,
"IMP4g6-SPN1-TRg-1":12488,
"IMP4g6-MOT1-NRg-7":12489,
"IMP4g6-RPL17A-NRg-4":12490,
"IMP4g6-ADA2-TRg-4":12491,
"IMP4g6-SFH1-NRg-1":12492,
"IMP4g6-SPC97-NRg-5":12493,
"IMP4g6-PRP22-TRg-3":12494,
"IMP4g6-SEN15-TRg-2":12495,
"IMP4g6-RPL3-NRg-2":12496,
"IMP4g6-ISD11-NRg-2":12497,
"IMP4g6-HEM12-TRg-8":12498,
"IMP4g6-SEC10-TRg-1":12499,
"IMP4g6-HTB1-TRg-7":12500,
"IMP4g6-TTI2-TRg-1":12501,
"IMP4g6-ACP1-TRg-2":12502,
"IMP4g6-ACP1-TRg-4":12503,
"IMP4g6-GAL11-NRg-10":12504,
"IMP4g6-UTP22-TRg-2":12505,
"IMP4g6-MST1-NRg-5":12506,
"IMP4g6-RIB7-NRg-2":12507,
"IMP4g6-MCD1-TRg-6":12508,
"IMP4g6-MCD1-TRg-5":12509,
"IMP4g6-GPI8-NRg-2":12510,
"IMP4g6-THS1-TRg-2":12511,
"IMP4g6-RRP7-TRg-2":12512,
"IMP4g6-RRP7-TRg-5":12513,
"IMP4g6-SMX2-NRg-7":12514,
"IMP4g6-RRP45-TRg-5":12515,
"IMP4g6-RRP45-TRg-4":12516,
"IMP4g6-CNS1-TRg-2":12517,
"IMP4g6-FBP1-NRg-9":12518,
"IMP4g6-GCD11-NRg-1":12519,
"IMP4g6-RPL10-TRg-2":12520,
"IMP4g6-NUP192-TRg-4":12521,
"IMP4g6-NUP145-NRg-4":12522,
"IMP4g6-HEM12-TRg-6":12523,
"IMP4g6-PLC1-TRg-3":12524,
"IMP4g6-RPA43-TRg-1":12525,
"IMP4g6-RPB7-NRg-2":12526,
"IMP4g6-RPB7-NRg-3":12527,
"IMP4g6-NSL1-NRg-1":12528,
"IMP4g6-UTP6-TRg-3":12529,
"IMP4g6-UTP6-TRg-1":12530,
"IMP4g6-YJU2-TRg-5":12531,
"IMP4g6-FRS2-NRg-5":12532,
"IMP4g6-TIF35-NRg-2":12533,
"IMP4g6-GPI15-TRg-1":12534,
"IMP4g6-NOP1-NRg-5":12535,
"IMP4g6-GPI15-TRg-4":12536,
"IMP4g6-COG4-TRg-1":12537,
"IMP4g6-TFA1-TRg-1":12538,
"IMP4g6-RHO1-NRg-2":12539,
"IMP4g6-RHO1-NRg-1":12540,
"IMP4g6-CDC55-NRg-2":12541,
"IMP4g6-IDI1-NRg-7":12542,
"IMP4g6-RPL32-TRg-5":12543,
"IMP4g6-RPB5-TRg-4":12544,
"IMP4g6-DIP2-TRg-5":12545,
"IMP4g6-DIP2-TRg-1":12546,
"IMP4g6-RPC40-TRg-2":12547,
"IMP4g6-CDC6-TRg-5":12548,
"IMP4g6-CDC6-TRg-3":12549,
"IMP4g6-DAD2-TRg-2":12550,
"IMP4g6-RVS161-TRg-2":12551,
"IMP4g6-RVS161-TRg-1":12552,
"IMP4g6-SUP45-NRg-3":12553,
"IMP4g6-SRB6-NRg-5":12554,
"IMP4g6-RPC11-TRg-4":12555,
"IMP4g6-RKI1-TRg-8":12556,
"IMP4g6-NIP7-TRg-3":12557,
"IMP4g6-RPL33A-NRg-12":12558,
"IMP4g6-SAM50-TRg-4":12559,
"IMP4g6-NOP4-NRg-1":12560,
"IMP4g6-NOP4-NRg-3":12561,
"IMP4g6-SMX2-TRg-5":12562,
"IMP4g6-POL12-NRg-2":12563,
"IMP4g6-BMS1-NRg-2":12564,
"IMP4g6-RPA190-TRg-5":12565,
"IMP4g6-ALG14-NRg-4":12566,
"IMP4g6-ALG14-NRg-1":12567,
"IMP4g6-PRE5-NRg-1":12568,
"IMP4g6-BIG1-NRg-2":12569,
"IMP4g6-TFA2-TRg-4":12570,
"IMP4g6-IMP4-TRg-6":12571,
"IMP4g6-PAN1-NRg-1":12572,
"IMP4g6-UTP13-TRg-2":12573,
"IMP4g6-KAE1-NRg-3":12574,
"IMP4g6-ERG20-TRg-1":12575,
"IMP4g6-CDC20-TRg-6":12576,
"IMP4g6-PWP2-NRg-2":12577,
"IMP4g6-COG1-NRg-1":12578,
"IMP4g6-RPL1B-TRg-4":12579,
"IMP4g6-RPL1B-TRg-7":12580,
"IMP4g6-UTP20-TRg-3":12581,
"IMP4g6-UTP20-TRg-4":12582,
"IMP4g6-RPL25-TRg-4":12583,
"IMP4g6-RPL25-TRg-2":12584,
"IMP4g6-MCM7-NRg-1":12585,
"IMP4g6-MRP49-TRg-5":12586,
"IMP4g6-ERO1-NRg-3":12587,
"IMP4g6-UTP5-TRg-7":12588,
"IMP4g6-MCM4-NRg-1":12589,
"IMP4g6-PRE3-NRg-1":12590,
"IMP4g6-FCF1-NRg-1":12591,
"IMP4g6-CUS1-NRg-1":12592,
"IMP4g6-PSF1-TRg-2":12593,
"IMP4g6-BCP1-TRg-2":12594,
"IMP4g6-PAN1-TRg-1":12595,
"IMP4g6-PAN1-TRg-3":12596,
"IMP4g6-PAN1-TRg-4":12597,
"IMP4g6-VPS3-TRg-2":12598,
"IMP4g6-YIL060W-NRg-1":12599,
"IMP4g6-VPS53-NRg-1":12600,
"IMP4g6-CYR1-TRg-4":12601,
"IMP4g6-CYR1-TRg-7":12602,
"IMP4g6-MPS1-NRg-1":12603,
"IMP4g6-SRP1-TRg-5":12604,
"IMP4g6-SRP1-TRg-4":12605,
"IMP4g6-TAF12-TRg-2":12606,
"IMP4g6-TAF12-TRg-3":12607,
"IMP4g6-POP4-TRg-1":12608,
"IMP4g6-SPT16-TRg-1":12609,
"IMP4g6-NUP82-TRg-4":12610,
"IMP4g6-DML1-TRg-3":12611,
"IMP4g6-RPA43-NRg-3":12612,
"IMP4g6-STU2-NRg-3":12613,
"IMP4g6-POP4-NRg-4":12614,
"IMP4g6-MCD1-TRg-2":12615,
"IMP4g6-RPS3-NRg-4":12616,
"IMP4g6-PRP9-TRg-4":12617,
"IMP4g6-RPP1-NRg-2":12618,
"IMP4g6-MTR2-NRg-11":12619,
"IMP4g6-GCD11-TRg-1":12620,
"IMP4g6-RPF1-TRg-3":12621,
"IMP4g6-SUB2-NRg-4":12622,
"IMP4g6-GPI15-TRg-3":12623,
"IMP4g6-ERG9-TRg-6":12624,
"IMP4g6-RPT2-NRg-1":12625,
"IMP4g6-YOS1-NRg-3":12626,
"IMP4g6-SCM3-TRg-4":12627,
"IMP4g6-SCM3-TRg-6":12628,
"IMP4g6-RLP7-NRg-1":12629,
"IMP4g6-TFB2-NRg-4":12630,
"IMP4g6-IMP4-TRg-1":12631,
"IMP4g6-IMP4-TRg-3":12632,
"IMP4g6-PRE4-TRg-3":12633,
"IMP4g6-SUB2-TRg-3":12634,
"IMP4g6-RPP0-NRg-4":12635,
"IMP4g6-RPP0-NRg-3":12636,
"IMP4g6-TOM40-TRg-4":12637,
"IMP4g6-FUR1-NRg-12":12638,
"IMP4g6-TOM40-TRg-2":12639,
"IMP4g6-VMA11-NRg-4":12640,
"IMP4g6-PGS1-NRg-4":12641,
"IMP4g6-URB1-TRg-4":12642,
"IMP4g6-ARP4-TRg-3":12643,
"IMP4g6-RPT3-TRg-3":12644,
"IMP4g6-SUI3-TRg-3":12645,
"IMP4g6-RFC5-NRg-2":12646,
"IMP4g6-RRP14-TRg-2":12647,
"IMP4g6-SCC2-TRg-1":12648,
"IMP4g6-SSC1-TRg-3":12649,
"IMP4g6-RRP9-TRg-3":12650,
"IMP4g6-MOT1-NRg-9":12651,
"IMP4g6-RPL42A-NRg-2":12652,
"IMP4g6-SEC16-TRg-7":12653,
"IMP4g6-IMP4-NRg-2":12654,
"IMP4g6-YEF3-NRg-4":12655,
"IMP4g6-PUP1-TRg-1":12656,
"IMP4g6-UTP22-TRg-6":12657,
"IMP4g6-DBP2-NRg-4":12658,
"IMP4g6-PRE2-TRg-7":12659,
"IMP4g6-ATP16-TRg-6":12660,
"IMP4g6-UTP13-TRg-4":12661,
"IMP4g6-DOP1-NRg-4":12662,
"IMP4g6-TIM44-TRg-3":12663,
"IMP4g6-ATP16-TRg-2":12664,
"IMP4g6-ENP1-NRg-3":12665,
"IMP4g6-NAF1-TRg-3":12666,
"IMP4g6-COG4-TRg-2":12667,
"IMP4g6-SOG2-TRg-7":12668,
"IMP4g6-YDR341C-TRg-3":12669,
"IMP4g6-YMR290W-A-TRg-10":12670,
"IMP4g6-NUP192-NRg-9":12671,
"IMP4g6-RPS31-NRg-8":12672,
"IMP4g6-SPC97-NRg-6":12673,
"IMP4g6-EBP2-NRg-1":12674,
"IMP4g6-CDC48-TRg-5":12675,
"IMP4g6-RPT1-TRg-4":12676,
"IMP4g6-ULP1-NRg-2":12677,
"IMP4g6-RPN3-TRg-6":12678,
"IMP4g6-RPT1-TRg-5":12679,
"IMP4g6-KRE5-TRg-2":12680,
"IMP4g6-TBF1-NRg-8":12681,
"IMP4g6-UTP22-NRg-4":12682,
"IMP4g6-SSC1-NRg-4":12683,
"IMP4g6-REB1-TRg-4":12684,
"IMP4g6-CDC48-NRg-9":12685,
"IMP4g6-FAS2-TRg-8":12686,
"IMP4g6-TAO3-TRg-8":12687,
"IMP4g6-CKS1-TRg-5":12688,
"IMP4g6-YLR379W-TRg-7":12689,
"IMP4g6-TEN1-NRg-2":12690,
"IMP4g6-RPL42A-TRg-2":12691,
"IMP4g6-SEC27-TRg-4":12692,
"IMP4g6-TBF1-NRg-4":12693,
"IMP4g6-RPT1-NRg-6":12694,
"IMP4g6-COG1-TRg-3":12695,
"IMP4g6-SUI1-TRg-6":12696,
"IMP4g6-TIM23-TRg-6":12697,
"IMP4g6-CDC48-NRg-6":12698,
"IMP4g6-EPL1-TRg-5":12699,
"IMP4g6-RPT5-TRg-8":12700,
"IMP4g6-ATP16-NRg-4":12701,
"IMP4g6-RPN6-TRg-3":12702,
"IMP4g6-ERG9-NRg-6":12703,
"IMP4g6-SMX3-TRg-1":12704,
"IMP4g6-NCB2-NRg-3":12705,
"IMP4g6-SEC16-NRg-12":12706,
"IMP4g6-RPN6-TRg-2":12707,
"IMP4g6-REB1-NRg-4":12708,
"IMP4g6-ATP16-TRg-9":12709,
"IMP4g6-ERG9-NRg-7":12710,
"DIP2g5-RPL15A-NRg-4":12711,
"DIP2g5-RPL15A-NRg-5":12712,
"DIP2g5-KRE33-TRg-1":12713,
"DIP2g5-PMI40-NRg-1":12714,
"DIP2g5-NOP19-NRg-3":12715,
"DIP2g5-SRP14-NRg-4":12716,
"DIP2g5-SEC27-TRg-2":12717,
"DIP2g5-GPI14-TRg-3":12718,
"DIP2g5-PAH1-TRg-7":12719,
"DIP2g5-PAH1-TRg-6":12720,
"DIP2g5-PAH1-TRg-5":12721,
"DIP2g5-PAH1-TRg-3":12722,
"DIP2g5-COG3-TRg-1":12723,
"DIP2g5-HTS1-NRg-5":12724,
"DIP2g5-MSN5-TRg-7":12725,
"DIP2g5-ERG26-TRg-1":12726,
"DIP2g5-SMD2-TRg-5":12727,
"DIP2g5-SMD2-TRg-4":12728,
"DIP2g5-SMD2-TRg-1":12729,
"DIP2g5-PRE7-TRg-4":12730,
"DIP2g5-PRE7-TRg-7":12731,
"DIP2g5-SEC6-TRg-3":12732,
"DIP2g5-ESF2-NRg-1":12733,
"DIP2g5-ESF2-NRg-3":12734,
"DIP2g5-AFG2-TRg-2":12735,
"DIP2g5-RRP36-TRg-3":12736,
"DIP2g5-RRP36-TRg-5":12737,
"DIP2g5-GCR1-NRg-2":12738,
"DIP2g5-PRE4-NRg-4":12739,
"DIP2g5-PRE4-NRg-9":12740,
"DIP2g5-DSN1-NRg-2":12741,
"DIP2g5-GPI11-TRg-3":12742,
"DIP2g5-POP3-TRg-1":12743,
"DIP2g5-MNE1-TRg-5":12744,
"DIP2g5-RRP12-NRg-1":12745,
"DIP2g5-RSC6-TRg-2":12746,
"DIP2g5-CDC25-TRg-1":12747,
"DIP2g5-CDC25-TRg-9":12748,
"DIP2g5-YPP1-NRg-3":12749,
"DIP2g5-NFS1-NRg-9":12750,
"DIP2g5-NFS1-NRg-8":12751,
"DIP2g5-UBA2-TRg-1":12752,
"DIP2g5-ARP2-NRg-3":12753,
"DIP2g5-MAK16-TRg-1":12754,
"DIP2g5-CEP3-NRg-1":12755,
"DIP2g5-GUK1-TRg-5":12756,
"DIP2g5-GUK1-TRg-2":12757,
"DIP2g5-GPI12-NRg-6":12758,
"DIP2g5-RPS5-NRg-5":12759,
"DIP2g5-RPS5-NRg-2":12760,
"DIP2g5-RPC19-NRg-1":12761,
"DIP2g5-TIM54-TRg-1":12762,
"DIP2g5-TEN1-TRg-2":12763,
"DIP2g5-SAH1-NRg-4":12764,
"DIP2g5-SAH1-NRg-5":12765,
"DIP2g5-SAH1-NRg-3":12766,
"DIP2g5-ATP15-NRg-5":12767,
"DIP2g5-SCD5-TRg-5":12768,
"DIP2g5-ARB1-NRg-2":12769,
"DIP2g5-ARB1-NRg-4":12770,
"DIP2g5-PUP2-TRg-1":12771,
"DIP2g5-CCT8-TRg-2":12772,
"DIP2g5-MCM4-TRg-1":12773,
"DIP2g5-LSM4-TRg-1":12774,
"DIP2g5-NOP53-NRg-1":12775,
"DIP2g5-ATP3-TRg-4":12776,
"DIP2g5-AFG2-NRg-3":12777,
"DIP2g5-PRO3-NRg-3":12778,
"DIP2g5-NRD1-NRg-10":12779,
"DIP2g5-SEC61-TRg-2":12780,
"DIP2g5-RHO3-TRg-4":12781,
"DIP2g5-SNF2-TRg-6":12782,
"DIP2g5-SMD2-NRg-3":12783,
"DIP2g5-RSC4-TRg-2":12784,
"DIP2g5-RSC4-TRg-1":12785,
"DIP2g5-TIF34-TRg-2":12786,
"DIP2g5-BET1-NRg-1":12787,
"DIP2g5-CDC8-NRg-2":12788,
"DIP2g5-PRP42-TRg-2":12789,
"DIP2g5-RRB1-TRg-2":12790,
"DIP2g5-SPC24-TRg-1":12791,
"DIP2g5-ILS1-NRg-1":12792,
"DIP2g5-GFA1-TRg-2":12793,
"DIP2g5-SEC21-NRg-10":12794,
"DIP2g5-RPC10-NRg-1":12795,
"DIP2g5-RPB10-TRg-3":12796,
"DIP2g5-RPB10-TRg-2":12797,
"DIP2g5-YNL181W-TRg-1":12798,
"DIP2g5-RAD3-NRg-1":12799,
"DIP2g5-NOP10-TRg-1":12800,
"DIP2g5-BFR2-TRg-3":12801,
"DIP2g5-MCM2-TRg-6":12802,
"DIP2g5-MCM2-TRg-4":12803,
"DIP2g5-MPP10-TRg-1":12804,
"DIP2g5-RET2-TRg-4":12805,
"DIP2g5-RET2-TRg-1":12806,
"DIP2g5-RPS2-NRg-1":12807,
"DIP2g5-RPS2-NRg-2":12808,
"DIP2g5-ORC4-NRg-3":12809,
"DIP2g5-TIP20-TRg-7":12810,
"DIP2g5-SMT3-TRg-1":12811,
"DIP2g5-MSS18-NRg-6":12812,
"DIP2g5-YEF3-NRg-9":12813,
"DIP2g5-ASK1-NRg-1":12814,
"DIP2g5-SMC1-TRg-1":12815,
"DIP2g5-NIP1-NRg-1":12816,
"DIP2g5-RPP1-NRg-1":12817,
"DIP2g5-YDJ1-TRg-6":12818,
"DIP2g5-SUB2-NRg-1":12819,
"DIP2g5-TIM10-NRg-8":12820,
"DIP2g5-TIM10-NRg-4":12821,
"DIP2g5-TIM10-NRg-7":12822,
"DIP2g5-SKI6-TRg-4":12823,
"DIP2g5-TUB4-TRg-1":12824,
"DIP2g5-CDC37-NRg-2":12825,
"DIP2g5-ISD11-TRg-3":12826,
"DIP2g5-YOS1-TRg-4":12827,
"DIP2g5-SSC1-TRg-6":12828,
"DIP2g5-MTR3-TRg-5":12829,
"DIP2g5-MTR3-TRg-6":12830,
"DIP2g5-TFA1-TRg-2":12831,
"DIP2g5-CDC3-NRg-3":12832,
"DIP2g5-ERG25-TA-18":12833,
"DIP2g5-RPB11-TRg-4":12834,
"DIP2g5-RPB11-TRg-1":12835,
"DIP2g5-RPB11-TRg-2":12836,
"DIP2g5-DED1-TRg-3":12837,
"DIP2g5-DED1-TRg-1":12838,
"DIP2g5-DED1-TRg-6":12839,
"DIP2g5-DED1-TRg-4":12840,
"DIP2g5-RPL10-NRg-5":12841,
"DIP2g5-RPL10-NRg-4":12842,
"DIP2g5-EFB1-NRg-1":12843,
"DIP2g5-EFB1-NRg-5":12844,
"DIP2g5-EFB1-NRg-4":12845,
"DIP2g5-RPT3-NRg-1":12846,
"DIP2g5-SAC6-TRg-8":12847,
"DIP2g5-SAC6-TRg-4":12848,
"DIP2g5-SAC6-TRg-5":12849,
"DIP2g5-SAC6-TRg-3":12850,
"DIP2g5-DIM1-TRg-5":12851,
"DIP2g5-DIM1-TRg-7":12852,
"DIP2g5-RPC17-NRg-1":12853,
"DIP2g5-RPC17-NRg-2":12854,
"DIP2g5-YDR341C-TRg-1":12855,
"DIP2g5-RAP1-NRg-8":12856,
"DIP2g5-RAP1-NRg-5":12857,
"DIP2g5-RAP1-NRg-2":12858,
"DIP2g5-SEC26-NRg-3":12859,
"DIP2g5-SPP41-TRg-3":12860,
"DIP2g5-TAP42-NRg-1":12861,
"DIP2g5-PGA2-TRg-6":12862,
"DIP2g5-BRL1-TRg-1":12863,
"DIP2g5-FOL2-TRg-1":12864,
"DIP2g5-NAB3-NRg-5":12865,
"DIP2g5-SNF4-TRg-4":12866,
"DIP2g5-HRR25-TRg-2":12867,
"DIP2g5-TRS23-TRg-4":12868,
"DIP2g5-CTR86-TRg-4":12869,
"DIP2g5-RPB5-TRg-5":12870,
"DIP2g5-SPN1-NRg-2":12871,
"DIP2g5-SPN1-NRg-1":12872,
"DIP2g5-SEC61-NRg-1":12873,
"DIP2g5-SEC61-NRg-7":12874,
"DIP2g5-TUS1-TRg-3":12875,
"DIP2g5-OLE1-NRg-2":12876,
"DIP2g5-AFG2-TRg-1":12877,
"DIP2g5-TOA2-NRg-1":12878,
"DIP2g5-USO1-TRg-1":12879,
"DIP2g5-UTP22-NRg-2":12880,
"DIP2g5-RIB1-TRg-3":12881,
"DIP2g5-RIB1-TRg-7":12882,
"DIP2g5-RIB1-TRg-4":12883,
"DIP2g5-COG1-TRg-1":12884,
"DIP2g5-RPL32-NRg-2":12885,
"DIP2g5-GLC7-NRg-3":12886,
"DIP2g5-GLC7-NRg-4":12887,
"DIP2g5-HSF1-TRg-2":12888,
"DIP2g5-DAM1-NRg-5":12889,
"DIP2g5-SEC18-TRg-4":12890,
"DIP2g5-SEC18-TRg-5":12891,
"DIP2g5-PAB1-NRg-3":12892,
"DIP2g5-POP8-TRg-2":12893,
"DIP2g5-PAB1-NRg-4":12894,
"DIP2g5-BIG1-TRg-4":12895,
"DIP2g5-BIG1-TRg-5":12896,
"DIP2g5-BIG1-TRg-6":12897,
"DIP2g5-RPO41-NRg-1":12898,
"DIP2g5-RVB2-NRg-2":12899,
"DIP2g5-PET117-NRg-8":12900,
"DIP2g5-VPS45-NRg-9":12901,
"DIP2g5-YCG1-NRg-1":12902,
"DIP2g5-NOC4-NRg-1":12903,
"DIP2g5-NMD3-NRg-2":12904,
"DIP2g5-DRS1-TRg-2":12905,
"DIP2g5-HTB1-NRg-2":12906,
"DIP2g5-IPI1-TRg-2":12907,
"DIP2g5-SEC18-NRg-1":12908,
"DIP2g5-SEC18-NRg-2":12909,
"DIP2g5-JIP5-NRg-2":12910,
"DIP2g5-YPT1-TRg-3":12911,
"DIP2g5-YPT1-TRg-2":12912,
"DIP2g5-CLF1-NRg-2":12913,
"DIP2g5-SNF2-NRg-7":12914,
"DIP2g5-SNF2-NRg-4":12915,
"DIP2g5-RPL25-NRg-1":12916,
"DIP2g5-NOP56-TRg-1":12917,
"DIP2g5-NOP56-TRg-2":12918,
"DIP2g5-TRS31-TRg-1":12919,
"DIP2g5-DBF4-TRg-2":12920,
"DIP2g5-DBF4-TRg-1":12921,
"DIP2g5-RPC19-TRg-4":12922,
"DIP2g5-RPC19-TRg-6":12923,
"DIP2g5-RPC19-TRg-3":12924,
"DIP2g5-ROK1-NRg-1":12925,
"DIP2g5-CDC33-TRg-4":12926,
"DIP2g5-DHR2-TRg-3":12927,
"DIP2g5-RRP42-NRg-5":12928,
"DIP2g5-CLF1-TRg-1":12929,
"DIP2g5-ERG11-NA-16":12930,
"DIP2g5-VAS1-NRg-4":12931,
"DIP2g5-PIK1-NRg-2":12932,
"DIP2g5-SAR1-NRg-7":12933,
"DIP2g5-SAR1-NRg-4":12934,
"DIP2g5-RPS3-TRg-1":12935,
"DIP2g5-YTM1-TRg-2":12936,
"DIP2g5-SUI3-NRg-5":12937,
"DIP2g5-SUI3-NRg-2":12938,
"DIP2g5-RRP7-TRg-4":12939,
"DIP2g5-RRP7-TRg-6":12940,
"DIP2g5-NIP7-TRg-2":12941,
"DIP2g5-MDM35-TRg-1":12942,
"DIP2g5-ALA1-NRg-1":12943,
"DIP2g5-DOA4-NRg-2":12944,
"DIP2g5-RPS13-NRg-1":12945,
"DIP2g5-YSF3-TRg-2":12946,
"DIP2g5-RPS2-NRg-11":12947,
"DIP2g5-SSL1-TRg-10":12948,
"DIP2g5-NIP7-TRg-1":12949,
"DIP2g5-LST8-NRg-1":12950,
"DIP2g5-TAF4-TRg-3":12951,
"DIP2g5-HAS1-TRg-2":12952,
"DIP2g5-GLC7-TRg-2":12953,
"DIP2g5-CDC45-NRg-1":12954,
"DIP2g5-SEC22-NRg-8":12955,
"DIP2g5-YOS1-TRg-2":12956,
"DIP2g5-RBA50-TRg-3":12957,
"DIP2g5-SPP41-NRg-2":12958,
"DIP2g5-PRP46-TRg-2":12959,
"DIP2g5-PGA2-NRg-1":12960,
"DIP2g5-CBF5-TRg-3":12961,
"DIP2g5-TCP1-NRg-3":12962,
"DIP2g5-TCP1-NRg-2":12963,
"DIP2g5-ERG26-NRg-2":12964,
"DIP2g5-ERG26-NRg-4":12965,
"DIP2g5-MES1-TRg-5":12966,
"DIP2g5-HTS1-TRg-2":12967,
"DIP2g5-SSS1-TRg-3":12968,
"DIP2g5-SSS1-TRg-2":12969,
"DIP2g5-SYS1-TRg-7":12970,
"DIP2g5-SYS1-TRg-2":12971,
"DIP2g5-SYS1-TRg-1":12972,
"DIP2g5-BFR2-TRg-1":12973,
"DIP2g5-EOS1-TRg-3":12974,
"DIP2g5-TAF4-NRg-1":12975,
"DIP2g5-ARL3-NRg-8":12976,
"DIP2g5-RPN5-NRg-1":12977,
"DIP2g5-TIM9-NRg-2":12978,
"DIP2g5-NUP57-NRg-3":12979,
"DIP2g5-VPS4-TRg-1":12980,
"DIP2g5-CDC3-TRg-4":12981,
"DIP2g5-BBP1-NRg-1":12982,
"DIP2g5-BBP1-NRg-2":12983,
"DIP2g5-USE1-NRg-3":12984,
"DIP2g5-CCT7-TRg-1":12985,
"DIP2g5-SAH1-TRg-3":12986,
"DIP2g5-CHS2-TRg-1":12987,
"DIP2g5-DPM1-TRg-2":12988,
"DIP2g5-BBP1-TRg-1":12989,
"DIP2g5-NRD1-TRg-4":12990,
"DIP2g5-RPB3-NRg-1":12991,
"DIP2g5-PHO85-NRg-6":12992,
"DIP2g5-SNF6-TRg-6":12993,
"DIP2g5-PRP38-NRg-2":12994,
"DIP2g5-OAR1-NRg-3":12995,
"DIP2g5-ROX3-NRg-1":12996,
"DIP2g5-YPP1-TRg-6":12997,
"DIP2g5-CBF2-NRg-8":12998,
"DIP2g5-SPT6-TRg-5":12999,
"DIP2g5-SEC10-NRg-1":13000,
"DIP2g5-NSL1-NRg-3":13001,
"DIP2g5-NRD1-NRg-8":13002,
"DIP2g5-RPB3-TRg-1":13003,
"DIP2g5-NRD1-NRg-4":13004,
"DIP2g5-RVB1-TRg-2":13005,
"DIP2g5-TIF5-NRg-8":13006,
"DIP2g5-EOS1-NRg-1":13007,
"DIP2g5-ERG25-NA-26":13008,
"DIP2g5-MSL5-NRg-4":13009,
"DIP2g5-SEC24-TRg-2":13010,
"DIP2g5-RPL30-NRg-5":13011,
"DIP2g5-SNU71-NRg-3":13012,
"DIP2g5-CDC33-NRg-1":13013,
"DIP2g5-RPN6-TRg-4":13014,
"DIP2g5-NAB2-TRg-4":13015,
"DIP2g5-NAB2-TRg-6":13016,
"DIP2g5-YTM1-NRg-1":13017,
"DIP2g5-OLE1-TRg-8":13018,
"DIP2g5-OLE1-TRg-1":13019,
"DIP2g5-UTP7-TRg-4":13020,
"DIP2g5-ACT1-NRg-6":13021,
"DIP2g5-RPL18A-NRg-3":13022,
"DIP2g5-BRX1-NRg-1":13023,
"DIP2g5-NAF1-TRg-8":13024,
"DIP2g5-NAF1-TRg-6":13025,
"DIP2g5-NAF1-TRg-4":13026,
"DIP2g5-CDC8-TRg-2":13027,
"DIP2g5-NSE4-TRg-1":13028,
"DIP2g5-PAB1-NRg-2":13029,
"DIP2g5-PRP43-TRg-4":13030,
"DIP2g5-SEC2-NRg-3":13031,
"DIP2g5-SEC2-NRg-6":13032,
"DIP2g5-MPP10-NRg-5":13033,
"DIP2g5-YDR355C-TRg-2":13034,
"DIP2g5-YLR339C-TRg-9":13035,
"DIP2g5-SNM1-TRg-2":13036,
"DIP2g5-ALR1-NRg-4":13037,
"DIP2g5-ALR1-NRg-1":13038,
"DIP2g5-ALR1-NRg-3":13039,
"DIP2g5-RPL10-TRg-1":13040,
"DIP2g5-RPL28-TRg-2":13041,
"DIP2g5-UTP25-TRg-1":13042,
"DIP2g5-POB3-TRg-1":13043,
"DIP2g5-POB3-TRg-3":13044,
"DIP2g5-POB3-TRg-2":13045,
"DIP2g5-MED11-TRg-1":13046,
"DIP2g5-ISA1-TRg-15":13047,
"DIP2g5-RRP1-NRg-1":13048,
"DIP2g5-MES1-NRg-1":13049,
"DIP2g5-SEC13-NRg-5":13050,
"DIP2g5-MCM2-NRg-2":13051,
"DIP2g5-ALA1-TRg-4":13052,
"DIP2g5-MTG2-TRg-5":13053,
"DIP2g5-TIF35-NRg-3":13054,
"DIP2g5-NSE1-TRg-3":13055,
"DIP2g5-NSE1-TRg-4":13056,
"DIP2g5-MOB2-NRg-6":13057,
"DIP2g5-VRG4-NRg-3":13058,
"DIP2g5-PRP9-TRg-3":13059,
"DIP2g5-HYM1-TRg-5":13060,
"DIP2g5-POP1-TRg-5":13061,
"DIP2g5-POP1-TRg-9":13062,
"DIP2g5-RPL17A-TRg-1":13063,
"DIP2g5-SLD2-TRg-1":13064,
"DIP2g5-CDC48-NRg-7":13065,
"DIP2g5-FHL1-NRg-2":13066,
"DIP2g5-BET3-NRg-7":13067,
"DIP2g5-MAK21-TRg-1":13068,
"DIP2g5-BRN1-TRg-4":13069,
"DIP2g5-FBA1-NRg-3":13070,
"DIP2g5-CDC42-TRg-6":13071,
"DIP2g5-CDC42-TRg-7":13072,
"DIP2g5-COG4-NRg-1":13073,
"DIP2g5-ATP3-NRg-3":13074,
"DIP2g5-ATP3-NRg-2":13075,
"DIP2g5-SMP3-TRg-5":13076,
"DIP2g5-CFT2-NRg-2":13077,
"DIP2g5-FAS2-TRg-5":13078,
"DIP2g5-DBP2-NRg-3":13079,
"DIP2g5-DBP2-NRg-2":13080,
"DIP2g5-MPS2-NRg-4":13081,
"DIP2g5-ARC35-TRg-2":13082,
"DIP2g5-ARC35-TRg-5":13083,
"DIP2g5-MRD1-TRg-1":13084,
"DIP2g5-RLP7-TRg-1":13085,
"DIP2g5-SPC34-TRg-1":13086,
"DIP2g5-CDC45-TRg-2":13087,
"DIP2g5-GCD6-TRg-3":13088,
"DIP2g5-GCD6-TRg-4":13089,
"DIP2g5-YPT6-NRg-2":13090,
"DIP2g5-RPS13-TRg-2":13091,
"DIP2g5-IPI3-TRg-3":13092,
"DIP2g5-TIF5-NRg-9":13093,
"DIP2g5-TIF5-NRg-7":13094,
"DIP2g5-TIF5-NRg-6":13095,
"DIP2g5-NAB3-TRg-3":13096,
"DIP2g5-GCD2-TRg-1":13097,
"DIP2g5-UBA1-TRg-2":13098,
"DIP2g5-SLD3-TRg-6":13099,
"DIP2g5-LCB1-TRg-5":13100,
"DIP2g5-TOA2-TRg-6":13101,
"DIP2g5-TOA2-TRg-1":13102,
"DIP2g5-TOA2-TRg-3":13103,
"DIP2g5-LSM2-TRg-1":13104,
"DIP2g5-YML6-TRg-13":13105,
"DIP2g5-YML6-TRg-12":13106,
"DIP2g5-UTP15-NRg-1":13107,
"DIP2g5-TIF6-NRg-8":13108,
"DIP2g5-SUP35-NRg-1":13109,
"DIP2g5-MPP10-NRg-1":13110,
"DIP2g5-SWI3-TRg-7":13111,
"DIP2g5-SSN3-NRg-2":13112,
"DIP2g5-SEC13-NRg-7":13113,
"DIP2g5-RPS15-NRg-3":13114,
"DIP2g5-RPL3-TRg-2":13115,
"DIP2g5-FBA1-NRg-2":13116,
"DIP2g5-FBA1-NRg-1":13117,
"DIP2g5-FBA1-NRg-5":13118,
"DIP2g5-DAM1-TRg-2":13119,
"DIP2g5-NHP2-TRg-2":13120,
"DIP2g5-HCA4-NRg-6":13121,
"DIP2g5-PRE3-TRg-4":13122,
"DIP2g5-DBP5-NRg-4":13123,
"DIP2g5-SPT6-NRg-4":13124,
"DIP2g5-SPT6-NRg-2":13125,
"DIP2g5-RPL18A-TRg-4":13126,
"DIP2g5-KSH1-TRg-1":13127,
"DIP2g5-KSH1-TRg-3":13128,
"DIP2g5-IPI3-NRg-1":13129,
"DIP2g5-PGA2-TRg-8":13130,
"DIP2g5-RPL18A-TRg-2":13131,
"DIP2g5-RPL33A-NRg-6":13132,
"DIP2g5-TAF12-NRg-2":13133,
"DIP2g5-USE1-TRg-5":13134,
"DIP2g5-YNL114C-TRg-1":13135,
"DIP2g5-SMC5-TRg-7":13136,
"DIP2g5-SMC5-TRg-6":13137,
"DIP2g5-RSC58-TRg-1":13138,
"DIP2g5-CTF13-TRg-2":13139,
"DIP2g5-NAB2-NRg-2":13140,
"DIP2g5-MCM7-TRg-4":13141,
"DIP2g5-BCP1-NRg-5":13142,
"DIP2g5-STU2-TRg-3":13143,
"DIP2g5-SEC21-NRg-6":13144,
"DIP2g5-SEC21-NRg-3":13145,
"DIP2g5-RPL1B-TRg-3":13146,
"DIP2g5-SEC20-NRg-2":13147,
"DIP2g5-VMA3-NRg-2":13148,
"DIP2g5-SEC23-NRg-5":13149,
"DIP2g5-CDC28-TRg-4":13150,
"DIP2g5-RPN12-NRg-11":13151,
"DIP2g5-PUP3-TRg-3":13152,
"DIP2g5-SEC31-TRg-2":13153,
"DIP2g5-SED5-TRg-6":13154,
"DIP2g5-SED5-TRg-5":13155,
"DIP2g5-RPL33A-TRg-1":13156,
"DIP2g5-RPL33A-TRg-2":13157,
"DIP2g5-MRPL11-TRg-2":13158,
"DIP2g5-RTP1-NRg-2":13159,
"DIP2g5-NUG1-TRg-2":13160,
"DIP2g5-VPH2-TRg-4":13161,
"DIP2g5-COP1-NRg-3":13162,
"DIP2g5-CRM1-NRg-1":13163,
"DIP2g5-RPL5-NRg-4":13164,
"DIP2g5-SNU13-NRg-4":13165,
"DIP2g5-PFS2-TRg-3":13166,
"DIP2g5-MPP10-TRg-2":13167,
"DIP2g5-TSR4-NRg-2":13168,
"DIP2g5-RSC2-TRg-1":13169,
"DIP2g5-SEC65-TRg-2":13170,
"DIP2g5-SMI1-NRg-1":13171,
"DIP2g5-RTT105-NRg-4":13172,
"DIP2g5-VMA5-TRg-3":13173,
"DIP2g5-VMA5-TRg-5":13174,
"DIP2g5-RRP1-TRg-3":13175,
"DIP2g5-CLC1-TRg-2":13176,
"DIP2g5-GCD6-NRg-1":13177,
"DIP2g5-GCD6-NRg-2":13178,
"DIP2g5-PXR1-TRg-1":13179,
"DIP2g5-CDC14-NRg-1":13180,
"DIP2g5-PCF11-TRg-6":13181,
"DIP2g5-PCF11-TRg-5":13182,
"DIP2g5-PCF11-TRg-4":13183,
"DIP2g5-SEC31-NRg-1":13184,
"DIP2g5-RRP5-NRg-1":13185,
"DIP2g5-PRE10-TRg-5":13186,
"DIP2g5-PRE10-TRg-1":13187,
"DIP2g5-RPS5-TRg-2":13188,
"DIP2g5-NSP1-TRg-4":13189,
"DIP2g5-PRP38-TRg-4":13190,
"DIP2g5-RCF1-NRg-5":13191,
"DIP2g5-RSC3-TRg-4":13192,
"DIP2g5-RSC3-TRg-5":13193,
"DIP2g5-RSC3-TRg-6":13194,
"DIP2g5-HTA1-NRg-12":13195,
"DIP2g5-HTA1-NRg-11":13196,
"DIP2g5-UTP23-TRg-2":13197,
"DIP2g5-GCD7-NRg-1":13198,
"DIP2g5-GCD7-NRg-2":13199,
"DIP2g5-GCD7-NRg-6":13200,
"DIP2g5-GAL11-NRg-2":13201,
"DIP2g5-GAL11-NRg-9":13202,
"DIP2g5-PHO4-TRg-5":13203,
"DIP2g5-SNP1-NRg-3":13204,
"DIP2g5-RPC37-TRg-5":13205,
"DIP2g5-CRM1-TRg-5":13206,
"DIP2g5-CRM1-TRg-2":13207,
"DIP2g5-ASK1-TRg-7":13208,
"DIP2g5-STU2-NRg-4":13209,
"DIP2g5-NEO1-NRg-3":13210,
"DIP2g5-GAL11-TRg-5":13211,
"DIP2g5-GAL11-TRg-7":13212,
"DIP2g5-SAM50-NRg-3":13213,
"DIP2g5-CSL4-TRg-2":13214,
"DIP2g5-CCT5-TRg-2":13215,
"DIP2g5-POL30-NRg-1":13216,
"DIP2g5-MED4-TRg-4":13217,
"DIP2g5-MED4-TRg-3":13218,
"DIP2g5-MED4-TRg-2":13219,
"DIP2g5-GDI1-TRg-4":13220,
"DIP2g5-GDI1-TRg-3":13221,
"DIP2g5-REB1-TRg-6":13222,
"DIP2g5-MRPL37-NRg-2":13223,
"DIP2g5-NOC3-TRg-3":13224,
"DIP2g5-SPC97-TRg-3":13225,
"DIP2g5-IPP1-TRg-3":13226,
"DIP2g5-IPP1-TRg-2":13227,
"DIP2g5-PTI1-TRg-3":13228,
"DIP2g5-PTI1-TRg-5":13229,
"DIP2g5-RFC5-NRg-1":13230,
"DIP2g5-CDC24-TRg-1":13231,
"DIP2g5-CDC24-TRg-3":13232,
"DIP2g5-CDC24-TRg-5":13233,
"DIP2g5-CDC24-TRg-6":13234,
"DIP2g5-UTP23-TRg-6":13235,
"DIP2g5-UTP23-TRg-4":13236,
"DIP2g5-UTP23-TRg-1":13237,
"DIP2g5-RHO3-NRg-4":13238,
"DIP2g5-TRS23-NRg-1":13239,
"DIP2g5-TRS23-NRg-3":13240,
"DIP2g5-RSP5-TRg-2":13241,
"DIP2g5-RSP5-TRg-1":13242,
"DIP2g5-SDA1-NRg-1":13243,
"DIP2g5-KAP95-TRg-8":13244,
"DIP2g5-ACO1-TRg-6":13245,
"DIP2g5-HTA1-NRg-3":13246,
"DIP2g5-HTA1-NRg-2":13247,
"DIP2g5-SPN1-TRg-1":13248,
"DIP2g5-MOT1-NRg-7":13249,
"DIP2g5-RPL17A-NRg-4":13250,
"DIP2g5-ADA2-TRg-4":13251,
"DIP2g5-SFH1-NRg-1":13252,
"DIP2g5-SPC97-NRg-5":13253,
"DIP2g5-PRP22-TRg-3":13254,
"DIP2g5-SEN15-TRg-2":13255,
"DIP2g5-RPL3-NRg-2":13256,
"DIP2g5-ISD11-NRg-2":13257,
"DIP2g5-HEM12-TRg-8":13258,
"DIP2g5-SEC10-TRg-1":13259,
"DIP2g5-HTB1-TRg-7":13260,
"DIP2g5-TTI2-TRg-1":13261,
"DIP2g5-ACP1-TRg-2":13262,
"DIP2g5-ACP1-TRg-4":13263,
"DIP2g5-GAL11-NRg-10":13264,
"DIP2g5-UTP22-TRg-2":13265,
"DIP2g5-MST1-NRg-5":13266,
"DIP2g5-RIB7-NRg-2":13267,
"DIP2g5-MCD1-TRg-6":13268,
"DIP2g5-MCD1-TRg-5":13269,
"DIP2g5-GPI8-NRg-2":13270,
"DIP2g5-THS1-TRg-2":13271,
"DIP2g5-RRP7-TRg-2":13272,
"DIP2g5-RRP7-TRg-5":13273,
"DIP2g5-SMX2-NRg-7":13274,
"DIP2g5-RRP45-TRg-5":13275,
"DIP2g5-RRP45-TRg-4":13276,
"DIP2g5-CNS1-TRg-2":13277,
"DIP2g5-FBP1-NRg-9":13278,
"DIP2g5-GCD11-NRg-1":13279,
"DIP2g5-RPL10-TRg-2":13280,
"DIP2g5-NUP192-TRg-4":13281,
"DIP2g5-NUP145-NRg-4":13282,
"DIP2g5-HEM12-TRg-6":13283,
"DIP2g5-PLC1-TRg-3":13284,
"DIP2g5-RPA43-TRg-1":13285,
"DIP2g5-RPB7-NRg-2":13286,
"DIP2g5-RPB7-NRg-3":13287,
"DIP2g5-NSL1-NRg-1":13288,
"DIP2g5-UTP6-TRg-3":13289,
"DIP2g5-UTP6-TRg-1":13290,
"DIP2g5-YJU2-TRg-5":13291,
"DIP2g5-FRS2-NRg-5":13292,
"DIP2g5-TIF35-NRg-2":13293,
"DIP2g5-GPI15-TRg-1":13294,
"DIP2g5-NOP1-NRg-5":13295,
"DIP2g5-GPI15-TRg-4":13296,
"DIP2g5-COG4-TRg-1":13297,
"DIP2g5-TFA1-TRg-1":13298,
"DIP2g5-RHO1-NRg-2":13299,
"DIP2g5-RHO1-NRg-1":13300,
"DIP2g5-CDC55-NRg-2":13301,
"DIP2g5-IDI1-NRg-7":13302,
"DIP2g5-RPL32-TRg-5":13303,
"DIP2g5-RPB5-TRg-4":13304,
"DIP2g5-DIP2-TRg-5":13305,
"DIP2g5-DIP2-TRg-1":13306,
"DIP2g5-RPC40-TRg-2":13307,
"DIP2g5-CDC6-TRg-5":13308,
"DIP2g5-CDC6-TRg-3":13309,
"DIP2g5-DAD2-TRg-2":13310,
"DIP2g5-RVS161-TRg-2":13311,
"DIP2g5-RVS161-TRg-1":13312,
"DIP2g5-SUP45-NRg-3":13313,
"DIP2g5-SRB6-NRg-5":13314,
"DIP2g5-RPC11-TRg-4":13315,
"DIP2g5-RKI1-TRg-8":13316,
"DIP2g5-NIP7-TRg-3":13317,
"DIP2g5-RPL33A-NRg-12":13318,
"DIP2g5-SAM50-TRg-4":13319,
"DIP2g5-NOP4-NRg-1":13320,
"DIP2g5-NOP4-NRg-3":13321,
"DIP2g5-SMX2-TRg-5":13322,
"DIP2g5-POL12-NRg-2":13323,
"DIP2g5-BMS1-NRg-2":13324,
"DIP2g5-RPA190-TRg-5":13325,
"DIP2g5-ALG14-NRg-4":13326,
"DIP2g5-ALG14-NRg-1":13327,
"DIP2g5-PRE5-NRg-1":13328,
"DIP2g5-BIG1-NRg-2":13329,
"DIP2g5-TFA2-TRg-4":13330,
"DIP2g5-IMP4-TRg-6":13331,
"DIP2g5-PAN1-NRg-1":13332,
"DIP2g5-UTP13-TRg-2":13333,
"DIP2g5-KAE1-NRg-3":13334,
"DIP2g5-ERG20-TRg-1":13335,
"DIP2g5-CDC20-TRg-6":13336,
"DIP2g5-PWP2-NRg-2":13337,
"DIP2g5-COG1-NRg-1":13338,
"DIP2g5-RPL1B-TRg-4":13339,
"DIP2g5-RPL1B-TRg-7":13340,
"DIP2g5-UTP20-TRg-3":13341,
"DIP2g5-UTP20-TRg-4":13342,
"DIP2g5-RPL25-TRg-4":13343,
"DIP2g5-RPL25-TRg-2":13344,
"DIP2g5-MCM7-NRg-1":13345,
"DIP2g5-MRP49-TRg-5":13346,
"DIP2g5-ERO1-NRg-3":13347,
"DIP2g5-UTP5-TRg-7":13348,
"DIP2g5-MCM4-NRg-1":13349,
"DIP2g5-PRE3-NRg-1":13350,
"DIP2g5-FCF1-NRg-1":13351,
"DIP2g5-CUS1-NRg-1":13352,
"DIP2g5-PSF1-TRg-2":13353,
"DIP2g5-BCP1-TRg-2":13354,
"DIP2g5-PAN1-TRg-1":13355,
"DIP2g5-PAN1-TRg-3":13356,
"DIP2g5-PAN1-TRg-4":13357,
"DIP2g5-VPS3-TRg-2":13358,
"DIP2g5-YIL060W-NRg-1":13359,
"DIP2g5-VPS53-NRg-1":13360,
"DIP2g5-CYR1-TRg-4":13361,
"DIP2g5-CYR1-TRg-7":13362,
"DIP2g5-MPS1-NRg-1":13363,
"DIP2g5-SRP1-TRg-5":13364,
"DIP2g5-SRP1-TRg-4":13365,
"DIP2g5-TAF12-TRg-2":13366,
"DIP2g5-TAF12-TRg-3":13367,
"DIP2g5-POP4-TRg-1":13368,
"DIP2g5-SPT16-TRg-1":13369,
"DIP2g5-NUP82-TRg-4":13370,
"DIP2g5-DML1-TRg-3":13371,
"DIP2g5-RPA43-NRg-3":13372,
"DIP2g5-STU2-NRg-3":13373,
"DIP2g5-POP4-NRg-4":13374,
"DIP2g5-MCD1-TRg-2":13375,
"DIP2g5-RPS3-NRg-4":13376,
"DIP2g5-PRP9-TRg-4":13377,
"DIP2g5-RPP1-NRg-2":13378,
"DIP2g5-MTR2-NRg-11":13379,
"DIP2g5-GCD11-TRg-1":13380,
"DIP2g5-RPF1-TRg-3":13381,
"DIP2g5-SUB2-NRg-4":13382,
"DIP2g5-GPI15-TRg-3":13383,
"DIP2g5-ERG9-TRg-6":13384,
"DIP2g5-RPT2-NRg-1":13385,
"DIP2g5-YOS1-NRg-3":13386,
"DIP2g5-SCM3-TRg-4":13387,
"DIP2g5-SCM3-TRg-6":13388,
"DIP2g5-RLP7-NRg-1":13389,
"DIP2g5-TFB2-NRg-4":13390,
"DIP2g5-IMP4-TRg-1":13391,
"DIP2g5-IMP4-TRg-3":13392,
"DIP2g5-PRE4-TRg-3":13393,
"DIP2g5-SUB2-TRg-3":13394,
"DIP2g5-RPP0-NRg-4":13395,
"DIP2g5-RPP0-NRg-3":13396,
"DIP2g5-TOM40-TRg-4":13397,
"DIP2g5-FUR1-NRg-12":13398,
"DIP2g5-TOM40-TRg-2":13399,
"DIP2g5-VMA11-NRg-4":13400,
"DIP2g5-PGS1-NRg-4":13401,
"DIP2g5-URB1-TRg-4":13402,
"DIP2g5-ARP4-TRg-3":13403,
"DIP2g5-RPT3-TRg-3":13404,
"DIP2g5-SUI3-TRg-3":13405,
"DIP2g5-RFC5-NRg-2":13406,
"DIP2g5-RRP14-TRg-2":13407,
"DIP2g5-SCC2-TRg-1":13408,
"DIP2g5-SSC1-TRg-3":13409,
"DIP2g5-RRP9-TRg-3":13410,
"DIP2g5-MOT1-NRg-9":13411,
"DIP2g5-RPL42A-NRg-2":13412,
"DIP2g5-SEC16-TRg-7":13413,
"DIP2g5-IMP4-NRg-2":13414,
"DIP2g5-YEF3-NRg-4":13415,
"DIP2g5-PUP1-TRg-1":13416,
"DIP2g5-UTP22-TRg-6":13417,
"DIP2g5-DBP2-NRg-4":13418,
"DIP2g5-PRE2-TRg-7":13419,
"DIP2g5-ATP16-TRg-6":13420,
"DIP2g5-UTP13-TRg-4":13421,
"DIP2g5-DOP1-NRg-4":13422,
"DIP2g5-TIM44-TRg-3":13423,
"DIP2g5-ATP16-TRg-2":13424,
"DIP2g5-ENP1-NRg-3":13425,
"DIP2g5-NAF1-TRg-3":13426,
"DIP2g5-COG4-TRg-2":13427,
"DIP2g5-SOG2-TRg-7":13428,
"DIP2g5-YDR341C-TRg-3":13429,
"DIP2g5-YMR290W-A-TRg-10":13430,
"DIP2g5-NUP192-NRg-9":13431,
"DIP2g5-RPS31-NRg-8":13432,
"DIP2g5-SPC97-NRg-6":13433,
"DIP2g5-EBP2-NRg-1":13434,
"DIP2g5-CDC48-TRg-5":13435,
"DIP2g5-RPT1-TRg-4":13436,
"DIP2g5-ULP1-NRg-2":13437,
"DIP2g5-RPN3-TRg-6":13438,
"DIP2g5-RPT1-TRg-5":13439,
"DIP2g5-KRE5-TRg-2":13440,
"DIP2g5-TBF1-NRg-8":13441,
"DIP2g5-UTP22-NRg-4":13442,
"DIP2g5-SSC1-NRg-4":13443,
"DIP2g5-REB1-TRg-4":13444,
"DIP2g5-CDC48-NRg-9":13445,
"DIP2g5-FAS2-TRg-8":13446,
"DIP2g5-TAO3-TRg-8":13447,
"DIP2g5-CKS1-TRg-5":13448,
"DIP2g5-YLR379W-TRg-7":13449,
"DIP2g5-TEN1-NRg-2":13450,
"DIP2g5-RPL42A-TRg-2":13451,
"DIP2g5-SEC27-TRg-4":13452,
"DIP2g5-TBF1-NRg-4":13453,
"DIP2g5-RPT1-NRg-6":13454,
"DIP2g5-COG1-TRg-3":13455,
"DIP2g5-SUI1-TRg-6":13456,
"DIP2g5-TIM23-TRg-6":13457,
"DIP2g5-CDC48-NRg-6":13458,
"DIP2g5-EPL1-TRg-5":13459,
"DIP2g5-RPT5-TRg-8":13460,
"DIP2g5-ATP16-NRg-4":13461,
"DIP2g5-RPN6-TRg-3":13462,
"DIP2g5-ERG9-NRg-6":13463,
"DIP2g5-SMX3-TRg-1":13464,
"DIP2g5-NCB2-NRg-3":13465,
"DIP2g5-SEC16-NRg-12":13466,
"DIP2g5-RPN6-TRg-2":13467,
"DIP2g5-REB1-NRg-4":13468,
"DIP2g5-ATP16-TRg-9":13469,
"DIP2g5-ERG9-NRg-7":13470,
"PWP2g2_BC1-RPL15A-NRg-4":13471,
"PWP2g2_BC1-RPL15A-NRg-5":13472,
"PWP2g2_BC1-KRE33-TRg-1":13473,
"PWP2g2_BC1-PMI40-NRg-1":13474,
"PWP2g2_BC1-NOP19-NRg-3":13475,
"PWP2g2_BC1-SRP14-NRg-4":13476,
"PWP2g2_BC1-SEC27-TRg-2":13477,
"PWP2g2_BC1-GPI14-TRg-3":13478,
"PWP2g2_BC1-PAH1-TRg-7":13479,
"PWP2g2_BC1-PAH1-TRg-6":13480,
"PWP2g2_BC1-PAH1-TRg-5":13481,
"PWP2g2_BC1-PAH1-TRg-3":13482,
"PWP2g2_BC1-COG3-TRg-1":13483,
"PWP2g2_BC1-HTS1-NRg-5":13484,
"PWP2g2_BC1-MSN5-TRg-7":13485,
"PWP2g2_BC1-ERG26-TRg-1":13486,
"PWP2g2_BC1-SMD2-TRg-5":13487,
"PWP2g2_BC1-SMD2-TRg-4":13488,
"PWP2g2_BC1-SMD2-TRg-1":13489,
"PWP2g2_BC1-PRE7-TRg-4":13490,
"PWP2g2_BC1-PRE7-TRg-7":13491,
"PWP2g2_BC1-SEC6-TRg-3":13492,
"PWP2g2_BC1-ESF2-NRg-1":13493,
"PWP2g2_BC1-ESF2-NRg-3":13494,
"PWP2g2_BC1-AFG2-TRg-2":13495,
"PWP2g2_BC1-RRP36-TRg-3":13496,
"PWP2g2_BC1-RRP36-TRg-5":13497,
"PWP2g2_BC1-GCR1-NRg-2":13498,
"PWP2g2_BC1-PRE4-NRg-4":13499,
"PWP2g2_BC1-PRE4-NRg-9":13500,
"PWP2g2_BC1-DSN1-NRg-2":13501,
"PWP2g2_BC1-GPI11-TRg-3":13502,
"PWP2g2_BC1-POP3-TRg-1":13503,
"PWP2g2_BC1-MNE1-TRg-5":13504,
"PWP2g2_BC1-RRP12-NRg-1":13505,
"PWP2g2_BC1-RSC6-TRg-2":13506,
"PWP2g2_BC1-CDC25-TRg-1":13507,
"PWP2g2_BC1-CDC25-TRg-9":13508,
"PWP2g2_BC1-YPP1-NRg-3":13509,
"PWP2g2_BC1-NFS1-NRg-9":13510,
"PWP2g2_BC1-NFS1-NRg-8":13511,
"PWP2g2_BC1-UBA2-TRg-1":13512,
"PWP2g2_BC1-ARP2-NRg-3":13513,
"PWP2g2_BC1-MAK16-TRg-1":13514,
"PWP2g2_BC1-CEP3-NRg-1":13515,
"PWP2g2_BC1-GUK1-TRg-5":13516,
"PWP2g2_BC1-GUK1-TRg-2":13517,
"PWP2g2_BC1-GPI12-NRg-6":13518,
"PWP2g2_BC1-RPS5-NRg-5":13519,
"PWP2g2_BC1-RPS5-NRg-2":13520,
"PWP2g2_BC1-RPC19-NRg-1":13521,
"PWP2g2_BC1-TIM54-TRg-1":13522,
"PWP2g2_BC1-TEN1-TRg-2":13523,
"PWP2g2_BC1-SAH1-NRg-4":13524,
"PWP2g2_BC1-SAH1-NRg-5":13525,
"PWP2g2_BC1-SAH1-NRg-3":13526,
"PWP2g2_BC1-ATP15-NRg-5":13527,
"PWP2g2_BC1-SCD5-TRg-5":13528,
"PWP2g2_BC1-ARB1-NRg-2":13529,
"PWP2g2_BC1-ARB1-NRg-4":13530,
"PWP2g2_BC1-PUP2-TRg-1":13531,
"PWP2g2_BC1-CCT8-TRg-2":13532,
"PWP2g2_BC1-MCM4-TRg-1":13533,
"PWP2g2_BC1-LSM4-TRg-1":13534,
"PWP2g2_BC1-NOP53-NRg-1":13535,
"PWP2g2_BC1-ATP3-TRg-4":13536,
"PWP2g2_BC1-AFG2-NRg-3":13537,
"PWP2g2_BC1-PRO3-NRg-3":13538,
"PWP2g2_BC1-NRD1-NRg-10":13539,
"PWP2g2_BC1-SEC61-TRg-2":13540,
"PWP2g2_BC1-RHO3-TRg-4":13541,
"PWP2g2_BC1-SNF2-TRg-6":13542,
"PWP2g2_BC1-SMD2-NRg-3":13543,
"PWP2g2_BC1-RSC4-TRg-2":13544,
"PWP2g2_BC1-RSC4-TRg-1":13545,
"PWP2g2_BC1-TIF34-TRg-2":13546,
"PWP2g2_BC1-BET1-NRg-1":13547,
"PWP2g2_BC1-CDC8-NRg-2":13548,
"PWP2g2_BC1-PRP42-TRg-2":13549,
"PWP2g2_BC1-RRB1-TRg-2":13550,
"PWP2g2_BC1-SPC24-TRg-1":13551,
"PWP2g2_BC1-ILS1-NRg-1":13552,
"PWP2g2_BC1-GFA1-TRg-2":13553,
"PWP2g2_BC1-SEC21-NRg-10":13554,
"PWP2g2_BC1-RPC10-NRg-1":13555,
"PWP2g2_BC1-RPB10-TRg-3":13556,
"PWP2g2_BC1-RPB10-TRg-2":13557,
"PWP2g2_BC1-YNL181W-TRg-1":13558,
"PWP2g2_BC1-RAD3-NRg-1":13559,
"PWP2g2_BC1-NOP10-TRg-1":13560,
"PWP2g2_BC1-BFR2-TRg-3":13561,
"PWP2g2_BC1-MCM2-TRg-6":13562,
"PWP2g2_BC1-MCM2-TRg-4":13563,
"PWP2g2_BC1-MPP10-TRg-1":13564,
"PWP2g2_BC1-RET2-TRg-4":13565,
"PWP2g2_BC1-RET2-TRg-1":13566,
"PWP2g2_BC1-RPS2-NRg-1":13567,
"PWP2g2_BC1-RPS2-NRg-2":13568,
"PWP2g2_BC1-ORC4-NRg-3":13569,
"PWP2g2_BC1-TIP20-TRg-7":13570,
"PWP2g2_BC1-SMT3-TRg-1":13571,
"PWP2g2_BC1-MSS18-NRg-6":13572,
"PWP2g2_BC1-YEF3-NRg-9":13573,
"PWP2g2_BC1-ASK1-NRg-1":13574,
"PWP2g2_BC1-SMC1-TRg-1":13575,
"PWP2g2_BC1-NIP1-NRg-1":13576,
"PWP2g2_BC1-RPP1-NRg-1":13577,
"PWP2g2_BC1-YDJ1-TRg-6":13578,
"PWP2g2_BC1-SUB2-NRg-1":13579,
"PWP2g2_BC1-TIM10-NRg-8":13580,
"PWP2g2_BC1-TIM10-NRg-4":13581,
"PWP2g2_BC1-TIM10-NRg-7":13582,
"PWP2g2_BC1-SKI6-TRg-4":13583,
"PWP2g2_BC1-TUB4-TRg-1":13584,
"PWP2g2_BC1-CDC37-NRg-2":13585,
"PWP2g2_BC1-ISD11-TRg-3":13586,
"PWP2g2_BC1-YOS1-TRg-4":13587,
"PWP2g2_BC1-SSC1-TRg-6":13588,
"PWP2g2_BC1-MTR3-TRg-5":13589,
"PWP2g2_BC1-MTR3-TRg-6":13590,
"PWP2g2_BC1-TFA1-TRg-2":13591,
"PWP2g2_BC1-CDC3-NRg-3":13592,
"PWP2g2_BC1-ERG25-TA-18":13593,
"PWP2g2_BC1-RPB11-TRg-4":13594,
"PWP2g2_BC1-RPB11-TRg-1":13595,
"PWP2g2_BC1-RPB11-TRg-2":13596,
"PWP2g2_BC1-DED1-TRg-3":13597,
"PWP2g2_BC1-DED1-TRg-1":13598,
"PWP2g2_BC1-DED1-TRg-6":13599,
"PWP2g2_BC1-DED1-TRg-4":13600,
"PWP2g2_BC1-RPL10-NRg-5":13601,
"PWP2g2_BC1-RPL10-NRg-4":13602,
"PWP2g2_BC1-EFB1-NRg-1":13603,
"PWP2g2_BC1-EFB1-NRg-5":13604,
"PWP2g2_BC1-EFB1-NRg-4":13605,
"PWP2g2_BC1-RPT3-NRg-1":13606,
"PWP2g2_BC1-SAC6-TRg-8":13607,
"PWP2g2_BC1-SAC6-TRg-4":13608,
"PWP2g2_BC1-SAC6-TRg-5":13609,
"PWP2g2_BC1-SAC6-TRg-3":13610,
"PWP2g2_BC1-DIM1-TRg-5":13611,
"PWP2g2_BC1-DIM1-TRg-7":13612,
"PWP2g2_BC1-RPC17-NRg-1":13613,
"PWP2g2_BC1-RPC17-NRg-2":13614,
"PWP2g2_BC1-YDR341C-TRg-1":13615,
"PWP2g2_BC1-RAP1-NRg-8":13616,
"PWP2g2_BC1-RAP1-NRg-5":13617,
"PWP2g2_BC1-RAP1-NRg-2":13618,
"PWP2g2_BC1-SEC26-NRg-3":13619,
"PWP2g2_BC1-SPP41-TRg-3":13620,
"PWP2g2_BC1-TAP42-NRg-1":13621,
"PWP2g2_BC1-PGA2-TRg-6":13622,
"PWP2g2_BC1-BRL1-TRg-1":13623,
"PWP2g2_BC1-FOL2-TRg-1":13624,
"PWP2g2_BC1-NAB3-NRg-5":13625,
"PWP2g2_BC1-SNF4-TRg-4":13626,
"PWP2g2_BC1-HRR25-TRg-2":13627,
"PWP2g2_BC1-TRS23-TRg-4":13628,
"PWP2g2_BC1-CTR86-TRg-4":13629,
"PWP2g2_BC1-RPB5-TRg-5":13630,
"PWP2g2_BC1-SPN1-NRg-2":13631,
"PWP2g2_BC1-SPN1-NRg-1":13632,
"PWP2g2_BC1-SEC61-NRg-1":13633,
"PWP2g2_BC1-SEC61-NRg-7":13634,
"PWP2g2_BC1-TUS1-TRg-3":13635,
"PWP2g2_BC1-OLE1-NRg-2":13636,
"PWP2g2_BC1-AFG2-TRg-1":13637,
"PWP2g2_BC1-TOA2-NRg-1":13638,
"PWP2g2_BC1-USO1-TRg-1":13639,
"PWP2g2_BC1-UTP22-NRg-2":13640,
"PWP2g2_BC1-RIB1-TRg-3":13641,
"PWP2g2_BC1-RIB1-TRg-7":13642,
"PWP2g2_BC1-RIB1-TRg-4":13643,
"PWP2g2_BC1-COG1-TRg-1":13644,
"PWP2g2_BC1-RPL32-NRg-2":13645,
"PWP2g2_BC1-GLC7-NRg-3":13646,
"PWP2g2_BC1-GLC7-NRg-4":13647,
"PWP2g2_BC1-HSF1-TRg-2":13648,
"PWP2g2_BC1-DAM1-NRg-5":13649,
"PWP2g2_BC1-SEC18-TRg-4":13650,
"PWP2g2_BC1-SEC18-TRg-5":13651,
"PWP2g2_BC1-PAB1-NRg-3":13652,
"PWP2g2_BC1-POP8-TRg-2":13653,
"PWP2g2_BC1-PAB1-NRg-4":13654,
"PWP2g2_BC1-BIG1-TRg-4":13655,
"PWP2g2_BC1-BIG1-TRg-5":13656,
"PWP2g2_BC1-BIG1-TRg-6":13657,
"PWP2g2_BC1-RPO41-NRg-1":13658,
"PWP2g2_BC1-RVB2-NRg-2":13659,
"PWP2g2_BC1-PET117-NRg-8":13660,
"PWP2g2_BC1-VPS45-NRg-9":13661,
"PWP2g2_BC1-YCG1-NRg-1":13662,
"PWP2g2_BC1-NOC4-NRg-1":13663,
"PWP2g2_BC1-NMD3-NRg-2":13664,
"PWP2g2_BC1-DRS1-TRg-2":13665,
"PWP2g2_BC1-HTB1-NRg-2":13666,
"PWP2g2_BC1-IPI1-TRg-2":13667,
"PWP2g2_BC1-SEC18-NRg-1":13668,
"PWP2g2_BC1-SEC18-NRg-2":13669,
"PWP2g2_BC1-JIP5-NRg-2":13670,
"PWP2g2_BC1-YPT1-TRg-3":13671,
"PWP2g2_BC1-YPT1-TRg-2":13672,
"PWP2g2_BC1-CLF1-NRg-2":13673,
"PWP2g2_BC1-SNF2-NRg-7":13674,
"PWP2g2_BC1-SNF2-NRg-4":13675,
"PWP2g2_BC1-RPL25-NRg-1":13676,
"PWP2g2_BC1-NOP56-TRg-1":13677,
"PWP2g2_BC1-NOP56-TRg-2":13678,
"PWP2g2_BC1-TRS31-TRg-1":13679,
"PWP2g2_BC1-DBF4-TRg-2":13680,
"PWP2g2_BC1-DBF4-TRg-1":13681,
"PWP2g2_BC1-RPC19-TRg-4":13682,
"PWP2g2_BC1-RPC19-TRg-6":13683,
"PWP2g2_BC1-RPC19-TRg-3":13684,
"PWP2g2_BC1-ROK1-NRg-1":13685,
"PWP2g2_BC1-CDC33-TRg-4":13686,
"PWP2g2_BC1-DHR2-TRg-3":13687,
"PWP2g2_BC1-RRP42-NRg-5":13688,
"PWP2g2_BC1-CLF1-TRg-1":13689,
"PWP2g2_BC1-ERG11-NA-16":13690,
"PWP2g2_BC1-VAS1-NRg-4":13691,
"PWP2g2_BC1-PIK1-NRg-2":13692,
"PWP2g2_BC1-SAR1-NRg-7":13693,
"PWP2g2_BC1-SAR1-NRg-4":13694,
"PWP2g2_BC1-RPS3-TRg-1":13695,
"PWP2g2_BC1-YTM1-TRg-2":13696,
"PWP2g2_BC1-SUI3-NRg-5":13697,
"PWP2g2_BC1-SUI3-NRg-2":13698,
"PWP2g2_BC1-RRP7-TRg-4":13699,
"PWP2g2_BC1-RRP7-TRg-6":13700,
"PWP2g2_BC1-NIP7-TRg-2":13701,
"PWP2g2_BC1-MDM35-TRg-1":13702,
"PWP2g2_BC1-ALA1-NRg-1":13703,
"PWP2g2_BC1-DOA4-NRg-2":13704,
"PWP2g2_BC1-RPS13-NRg-1":13705,
"PWP2g2_BC1-YSF3-TRg-2":13706,
"PWP2g2_BC1-RPS2-NRg-11":13707,
"PWP2g2_BC1-SSL1-TRg-10":13708,
"PWP2g2_BC1-NIP7-TRg-1":13709,
"PWP2g2_BC1-LST8-NRg-1":13710,
"PWP2g2_BC1-TAF4-TRg-3":13711,
"PWP2g2_BC1-HAS1-TRg-2":13712,
"PWP2g2_BC1-GLC7-TRg-2":13713,
"PWP2g2_BC1-CDC45-NRg-1":13714,
"PWP2g2_BC1-SEC22-NRg-8":13715,
"PWP2g2_BC1-YOS1-TRg-2":13716,
"PWP2g2_BC1-RBA50-TRg-3":13717,
"PWP2g2_BC1-SPP41-NRg-2":13718,
"PWP2g2_BC1-PRP46-TRg-2":13719,
"PWP2g2_BC1-PGA2-NRg-1":13720,
"PWP2g2_BC1-CBF5-TRg-3":13721,
"PWP2g2_BC1-TCP1-NRg-3":13722,
"PWP2g2_BC1-TCP1-NRg-2":13723,
"PWP2g2_BC1-ERG26-NRg-2":13724,
"PWP2g2_BC1-ERG26-NRg-4":13725,
"PWP2g2_BC1-MES1-TRg-5":13726,
"PWP2g2_BC1-HTS1-TRg-2":13727,
"PWP2g2_BC1-SSS1-TRg-3":13728,
"PWP2g2_BC1-SSS1-TRg-2":13729,
"PWP2g2_BC1-SYS1-TRg-7":13730,
"PWP2g2_BC1-SYS1-TRg-2":13731,
"PWP2g2_BC1-SYS1-TRg-1":13732,
"PWP2g2_BC1-BFR2-TRg-1":13733,
"PWP2g2_BC1-EOS1-TRg-3":13734,
"PWP2g2_BC1-TAF4-NRg-1":13735,
"PWP2g2_BC1-ARL3-NRg-8":13736,
"PWP2g2_BC1-RPN5-NRg-1":13737,
"PWP2g2_BC1-TIM9-NRg-2":13738,
"PWP2g2_BC1-NUP57-NRg-3":13739,
"PWP2g2_BC1-VPS4-TRg-1":13740,
"PWP2g2_BC1-CDC3-TRg-4":13741,
"PWP2g2_BC1-BBP1-NRg-1":13742,
"PWP2g2_BC1-BBP1-NRg-2":13743,
"PWP2g2_BC1-USE1-NRg-3":13744,
"PWP2g2_BC1-CCT7-TRg-1":13745,
"PWP2g2_BC1-SAH1-TRg-3":13746,
"PWP2g2_BC1-CHS2-TRg-1":13747,
"PWP2g2_BC1-DPM1-TRg-2":13748,
"PWP2g2_BC1-BBP1-TRg-1":13749,
"PWP2g2_BC1-NRD1-TRg-4":13750,
"PWP2g2_BC1-RPB3-NRg-1":13751,
"PWP2g2_BC1-PHO85-NRg-6":13752,
"PWP2g2_BC1-SNF6-TRg-6":13753,
"PWP2g2_BC1-PRP38-NRg-2":13754,
"PWP2g2_BC1-OAR1-NRg-3":13755,
"PWP2g2_BC1-ROX3-NRg-1":13756,
"PWP2g2_BC1-YPP1-TRg-6":13757,
"PWP2g2_BC1-CBF2-NRg-8":13758,
"PWP2g2_BC1-SPT6-TRg-5":13759,
"PWP2g2_BC1-SEC10-NRg-1":13760,
"PWP2g2_BC1-NSL1-NRg-3":13761,
"PWP2g2_BC1-NRD1-NRg-8":13762,
"PWP2g2_BC1-RPB3-TRg-1":13763,
"PWP2g2_BC1-NRD1-NRg-4":13764,
"PWP2g2_BC1-RVB1-TRg-2":13765,
"PWP2g2_BC1-TIF5-NRg-8":13766,
"PWP2g2_BC1-EOS1-NRg-1":13767,
"PWP2g2_BC1-ERG25-NA-26":13768,
"PWP2g2_BC1-MSL5-NRg-4":13769,
"PWP2g2_BC1-SEC24-TRg-2":13770,
"PWP2g2_BC1-RPL30-NRg-5":13771,
"PWP2g2_BC1-SNU71-NRg-3":13772,
"PWP2g2_BC1-CDC33-NRg-1":13773,
"PWP2g2_BC1-RPN6-TRg-4":13774,
"PWP2g2_BC1-NAB2-TRg-4":13775,
"PWP2g2_BC1-NAB2-TRg-6":13776,
"PWP2g2_BC1-YTM1-NRg-1":13777,
"PWP2g2_BC1-OLE1-TRg-8":13778,
"PWP2g2_BC1-OLE1-TRg-1":13779,
"PWP2g2_BC1-UTP7-TRg-4":13780,
"PWP2g2_BC1-ACT1-NRg-6":13781,
"PWP2g2_BC1-RPL18A-NRg-3":13782,
"PWP2g2_BC1-BRX1-NRg-1":13783,
"PWP2g2_BC1-NAF1-TRg-8":13784,
"PWP2g2_BC1-NAF1-TRg-6":13785,
"PWP2g2_BC1-NAF1-TRg-4":13786,
"PWP2g2_BC1-CDC8-TRg-2":13787,
"PWP2g2_BC1-NSE4-TRg-1":13788,
"PWP2g2_BC1-PAB1-NRg-2":13789,
"PWP2g2_BC1-PRP43-TRg-4":13790,
"PWP2g2_BC1-SEC2-NRg-3":13791,
"PWP2g2_BC1-SEC2-NRg-6":13792,
"PWP2g2_BC1-MPP10-NRg-5":13793,
"PWP2g2_BC1-YDR355C-TRg-2":13794,
"PWP2g2_BC1-YLR339C-TRg-9":13795,
"PWP2g2_BC1-SNM1-TRg-2":13796,
"PWP2g2_BC1-ALR1-NRg-4":13797,
"PWP2g2_BC1-ALR1-NRg-1":13798,
"PWP2g2_BC1-ALR1-NRg-3":13799,
"PWP2g2_BC1-RPL10-TRg-1":13800,
"PWP2g2_BC1-RPL28-TRg-2":13801,
"PWP2g2_BC1-UTP25-TRg-1":13802,
"PWP2g2_BC1-POB3-TRg-1":13803,
"PWP2g2_BC1-POB3-TRg-3":13804,
"PWP2g2_BC1-POB3-TRg-2":13805,
"PWP2g2_BC1-MED11-TRg-1":13806,
"PWP2g2_BC1-ISA1-TRg-15":13807,
"PWP2g2_BC1-RRP1-NRg-1":13808,
"PWP2g2_BC1-MES1-NRg-1":13809,
"PWP2g2_BC1-SEC13-NRg-5":13810,
"PWP2g2_BC1-MCM2-NRg-2":13811,
"PWP2g2_BC1-ALA1-TRg-4":13812,
"PWP2g2_BC1-MTG2-TRg-5":13813,
"PWP2g2_BC1-TIF35-NRg-3":13814,
"PWP2g2_BC1-NSE1-TRg-3":13815,
"PWP2g2_BC1-NSE1-TRg-4":13816,
"PWP2g2_BC1-MOB2-NRg-6":13817,
"PWP2g2_BC1-VRG4-NRg-3":13818,
"PWP2g2_BC1-PRP9-TRg-3":13819,
"PWP2g2_BC1-HYM1-TRg-5":13820,
"PWP2g2_BC1-POP1-TRg-5":13821,
"PWP2g2_BC1-POP1-TRg-9":13822,
"PWP2g2_BC1-RPL17A-TRg-1":13823,
"PWP2g2_BC1-SLD2-TRg-1":13824,
"PWP2g2_BC1-CDC48-NRg-7":13825,
"PWP2g2_BC1-FHL1-NRg-2":13826,
"PWP2g2_BC1-BET3-NRg-7":13827,
"PWP2g2_BC1-MAK21-TRg-1":13828,
"PWP2g2_BC1-BRN1-TRg-4":13829,
"PWP2g2_BC1-FBA1-NRg-3":13830,
"PWP2g2_BC1-CDC42-TRg-6":13831,
"PWP2g2_BC1-CDC42-TRg-7":13832,
"PWP2g2_BC1-COG4-NRg-1":13833,
"PWP2g2_BC1-ATP3-NRg-3":13834,
"PWP2g2_BC1-ATP3-NRg-2":13835,
"PWP2g2_BC1-SMP3-TRg-5":13836,
"PWP2g2_BC1-CFT2-NRg-2":13837,
"PWP2g2_BC1-FAS2-TRg-5":13838,
"PWP2g2_BC1-DBP2-NRg-3":13839,
"PWP2g2_BC1-DBP2-NRg-2":13840,
"PWP2g2_BC1-MPS2-NRg-4":13841,
"PWP2g2_BC1-ARC35-TRg-2":13842,
"PWP2g2_BC1-ARC35-TRg-5":13843,
"PWP2g2_BC1-MRD1-TRg-1":13844,
"PWP2g2_BC1-RLP7-TRg-1":13845,
"PWP2g2_BC1-SPC34-TRg-1":13846,
"PWP2g2_BC1-CDC45-TRg-2":13847,
"PWP2g2_BC1-GCD6-TRg-3":13848,
"PWP2g2_BC1-GCD6-TRg-4":13849,
"PWP2g2_BC1-YPT6-NRg-2":13850,
"PWP2g2_BC1-RPS13-TRg-2":13851,
"PWP2g2_BC1-IPI3-TRg-3":13852,
"PWP2g2_BC1-TIF5-NRg-9":13853,
"PWP2g2_BC1-TIF5-NRg-7":13854,
"PWP2g2_BC1-TIF5-NRg-6":13855,
"PWP2g2_BC1-NAB3-TRg-3":13856,
"PWP2g2_BC1-GCD2-TRg-1":13857,
"PWP2g2_BC1-UBA1-TRg-2":13858,
"PWP2g2_BC1-SLD3-TRg-6":13859,
"PWP2g2_BC1-LCB1-TRg-5":13860,
"PWP2g2_BC1-TOA2-TRg-6":13861,
"PWP2g2_BC1-TOA2-TRg-1":13862,
"PWP2g2_BC1-TOA2-TRg-3":13863,
"PWP2g2_BC1-LSM2-TRg-1":13864,
"PWP2g2_BC1-YML6-TRg-13":13865,
"PWP2g2_BC1-YML6-TRg-12":13866,
"PWP2g2_BC1-UTP15-NRg-1":13867,
"PWP2g2_BC1-TIF6-NRg-8":13868,
"PWP2g2_BC1-SUP35-NRg-1":13869,
"PWP2g2_BC1-MPP10-NRg-1":13870,
"PWP2g2_BC1-SWI3-TRg-7":13871,
"PWP2g2_BC1-SSN3-NRg-2":13872,
"PWP2g2_BC1-SEC13-NRg-7":13873,
"PWP2g2_BC1-RPS15-NRg-3":13874,
"PWP2g2_BC1-RPL3-TRg-2":13875,
"PWP2g2_BC1-FBA1-NRg-2":13876,
"PWP2g2_BC1-FBA1-NRg-1":13877,
"PWP2g2_BC1-FBA1-NRg-5":13878,
"PWP2g2_BC1-DAM1-TRg-2":13879,
"PWP2g2_BC1-NHP2-TRg-2":13880,
"PWP2g2_BC1-HCA4-NRg-6":13881,
"PWP2g2_BC1-PRE3-TRg-4":13882,
"PWP2g2_BC1-DBP5-NRg-4":13883,
"PWP2g2_BC1-SPT6-NRg-4":13884,
"PWP2g2_BC1-SPT6-NRg-2":13885,
"PWP2g2_BC1-RPL18A-TRg-4":13886,
"PWP2g2_BC1-KSH1-TRg-1":13887,
"PWP2g2_BC1-KSH1-TRg-3":13888,
"PWP2g2_BC1-IPI3-NRg-1":13889,
"PWP2g2_BC1-PGA2-TRg-8":13890,
"PWP2g2_BC1-RPL18A-TRg-2":13891,
"PWP2g2_BC1-RPL33A-NRg-6":13892,
"PWP2g2_BC1-TAF12-NRg-2":13893,
"PWP2g2_BC1-USE1-TRg-5":13894,
"PWP2g2_BC1-YNL114C-TRg-1":13895,
"PWP2g2_BC1-SMC5-TRg-7":13896,
"PWP2g2_BC1-SMC5-TRg-6":13897,
"PWP2g2_BC1-RSC58-TRg-1":13898,
"PWP2g2_BC1-CTF13-TRg-2":13899,
"PWP2g2_BC1-NAB2-NRg-2":13900,
"PWP2g2_BC1-MCM7-TRg-4":13901,
"PWP2g2_BC1-BCP1-NRg-5":13902,
"PWP2g2_BC1-STU2-TRg-3":13903,
"PWP2g2_BC1-SEC21-NRg-6":13904,
"PWP2g2_BC1-SEC21-NRg-3":13905,
"PWP2g2_BC1-RPL1B-TRg-3":13906,
"PWP2g2_BC1-SEC20-NRg-2":13907,
"PWP2g2_BC1-VMA3-NRg-2":13908,
"PWP2g2_BC1-SEC23-NRg-5":13909,
"PWP2g2_BC1-CDC28-TRg-4":13910,
"PWP2g2_BC1-RPN12-NRg-11":13911,
"PWP2g2_BC1-PUP3-TRg-3":13912,
"PWP2g2_BC1-SEC31-TRg-2":13913,
"PWP2g2_BC1-SED5-TRg-6":13914,
"PWP2g2_BC1-SED5-TRg-5":13915,
"PWP2g2_BC1-RPL33A-TRg-1":13916,
"PWP2g2_BC1-RPL33A-TRg-2":13917,
"PWP2g2_BC1-MRPL11-TRg-2":13918,
"PWP2g2_BC1-RTP1-NRg-2":13919,
"PWP2g2_BC1-NUG1-TRg-2":13920,
"PWP2g2_BC1-VPH2-TRg-4":13921,
"PWP2g2_BC1-COP1-NRg-3":13922,
"PWP2g2_BC1-CRM1-NRg-1":13923,
"PWP2g2_BC1-RPL5-NRg-4":13924,
"PWP2g2_BC1-SNU13-NRg-4":13925,
"PWP2g2_BC1-PFS2-TRg-3":13926,
"PWP2g2_BC1-MPP10-TRg-2":13927,
"PWP2g2_BC1-TSR4-NRg-2":13928,
"PWP2g2_BC1-RSC2-TRg-1":13929,
"PWP2g2_BC1-SEC65-TRg-2":13930,
"PWP2g2_BC1-SMI1-NRg-1":13931,
"PWP2g2_BC1-RTT105-NRg-4":13932,
"PWP2g2_BC1-VMA5-TRg-3":13933,
"PWP2g2_BC1-VMA5-TRg-5":13934,
"PWP2g2_BC1-RRP1-TRg-3":13935,
"PWP2g2_BC1-CLC1-TRg-2":13936,
"PWP2g2_BC1-GCD6-NRg-1":13937,
"PWP2g2_BC1-GCD6-NRg-2":13938,
"PWP2g2_BC1-PXR1-TRg-1":13939,
"PWP2g2_BC1-CDC14-NRg-1":13940,
"PWP2g2_BC1-PCF11-TRg-6":13941,
"PWP2g2_BC1-PCF11-TRg-5":13942,
"PWP2g2_BC1-PCF11-TRg-4":13943,
"PWP2g2_BC1-SEC31-NRg-1":13944,
"PWP2g2_BC1-RRP5-NRg-1":13945,
"PWP2g2_BC1-PRE10-TRg-5":13946,
"PWP2g2_BC1-PRE10-TRg-1":13947,
"PWP2g2_BC1-RPS5-TRg-2":13948,
"PWP2g2_BC1-NSP1-TRg-4":13949,
"PWP2g2_BC1-PRP38-TRg-4":13950,
"PWP2g2_BC1-RCF1-NRg-5":13951,
"PWP2g2_BC1-RSC3-TRg-4":13952,
"PWP2g2_BC1-RSC3-TRg-5":13953,
"PWP2g2_BC1-RSC3-TRg-6":13954,
"PWP2g2_BC1-HTA1-NRg-12":13955,
"PWP2g2_BC1-HTA1-NRg-11":13956,
"PWP2g2_BC1-UTP23-TRg-2":13957,
"PWP2g2_BC1-GCD7-NRg-1":13958,
"PWP2g2_BC1-GCD7-NRg-2":13959,
"PWP2g2_BC1-GCD7-NRg-6":13960,
"PWP2g2_BC1-GAL11-NRg-2":13961,
"PWP2g2_BC1-GAL11-NRg-9":13962,
"PWP2g2_BC1-PHO4-TRg-5":13963,
"PWP2g2_BC1-SNP1-NRg-3":13964,
"PWP2g2_BC1-RPC37-TRg-5":13965,
"PWP2g2_BC1-CRM1-TRg-5":13966,
"PWP2g2_BC1-CRM1-TRg-2":13967,
"PWP2g2_BC1-ASK1-TRg-7":13968,
"PWP2g2_BC1-STU2-NRg-4":13969,
"PWP2g2_BC1-NEO1-NRg-3":13970,
"PWP2g2_BC1-GAL11-TRg-5":13971,
"PWP2g2_BC1-GAL11-TRg-7":13972,
"PWP2g2_BC1-SAM50-NRg-3":13973,
"PWP2g2_BC1-CSL4-TRg-2":13974,
"PWP2g2_BC1-CCT5-TRg-2":13975,
"PWP2g2_BC1-POL30-NRg-1":13976,
"PWP2g2_BC1-MED4-TRg-4":13977,
"PWP2g2_BC1-MED4-TRg-3":13978,
"PWP2g2_BC1-MED4-TRg-2":13979,
"PWP2g2_BC1-GDI1-TRg-4":13980,
"PWP2g2_BC1-GDI1-TRg-3":13981,
"PWP2g2_BC1-REB1-TRg-6":13982,
"PWP2g2_BC1-MRPL37-NRg-2":13983,
"PWP2g2_BC1-NOC3-TRg-3":13984,
"PWP2g2_BC1-SPC97-TRg-3":13985,
"PWP2g2_BC1-IPP1-TRg-3":13986,
"PWP2g2_BC1-IPP1-TRg-2":13987,
"PWP2g2_BC1-PTI1-TRg-3":13988,
"PWP2g2_BC1-PTI1-TRg-5":13989,
"PWP2g2_BC1-RFC5-NRg-1":13990,
"PWP2g2_BC1-CDC24-TRg-1":13991,
"PWP2g2_BC1-CDC24-TRg-3":13992,
"PWP2g2_BC1-CDC24-TRg-5":13993,
"PWP2g2_BC1-CDC24-TRg-6":13994,
"PWP2g2_BC1-UTP23-TRg-6":13995,
"PWP2g2_BC1-UTP23-TRg-4":13996,
"PWP2g2_BC1-UTP23-TRg-1":13997,
"PWP2g2_BC1-RHO3-NRg-4":13998,
"PWP2g2_BC1-TRS23-NRg-1":13999,
"PWP2g2_BC1-TRS23-NRg-3":14000,
"PWP2g2_BC1-RSP5-TRg-2":14001,
"PWP2g2_BC1-RSP5-TRg-1":14002,
"PWP2g2_BC1-SDA1-NRg-1":14003,
"PWP2g2_BC1-KAP95-TRg-8":14004,
"PWP2g2_BC1-ACO1-TRg-6":14005,
"PWP2g2_BC1-HTA1-NRg-3":14006,
"PWP2g2_BC1-HTA1-NRg-2":14007,
"PWP2g2_BC1-SPN1-TRg-1":14008,
"PWP2g2_BC1-MOT1-NRg-7":14009,
"PWP2g2_BC1-RPL17A-NRg-4":14010,
"PWP2g2_BC1-ADA2-TRg-4":14011,
"PWP2g2_BC1-SFH1-NRg-1":14012,
"PWP2g2_BC1-SPC97-NRg-5":14013,
"PWP2g2_BC1-PRP22-TRg-3":14014,
"PWP2g2_BC1-SEN15-TRg-2":14015,
"PWP2g2_BC1-RPL3-NRg-2":14016,
"PWP2g2_BC1-ISD11-NRg-2":14017,
"PWP2g2_BC1-HEM12-TRg-8":14018,
"PWP2g2_BC1-SEC10-TRg-1":14019,
"PWP2g2_BC1-HTB1-TRg-7":14020,
"PWP2g2_BC1-TTI2-TRg-1":14021,
"PWP2g2_BC1-ACP1-TRg-2":14022,
"PWP2g2_BC1-ACP1-TRg-4":14023,
"PWP2g2_BC1-GAL11-NRg-10":14024,
"PWP2g2_BC1-UTP22-TRg-2":14025,
"PWP2g2_BC1-MST1-NRg-5":14026,
"PWP2g2_BC1-RIB7-NRg-2":14027,
"PWP2g2_BC1-MCD1-TRg-6":14028,
"PWP2g2_BC1-MCD1-TRg-5":14029,
"PWP2g2_BC1-GPI8-NRg-2":14030,
"PWP2g2_BC1-THS1-TRg-2":14031,
"PWP2g2_BC1-RRP7-TRg-2":14032,
"PWP2g2_BC1-RRP7-TRg-5":14033,
"PWP2g2_BC1-SMX2-NRg-7":14034,
"PWP2g2_BC1-RRP45-TRg-5":14035,
"PWP2g2_BC1-RRP45-TRg-4":14036,
"PWP2g2_BC1-CNS1-TRg-2":14037,
"PWP2g2_BC1-FBP1-NRg-9":14038,
"PWP2g2_BC1-GCD11-NRg-1":14039,
"PWP2g2_BC1-RPL10-TRg-2":14040,
"PWP2g2_BC1-NUP192-TRg-4":14041,
"PWP2g2_BC1-NUP145-NRg-4":14042,
"PWP2g2_BC1-HEM12-TRg-6":14043,
"PWP2g2_BC1-PLC1-TRg-3":14044,
"PWP2g2_BC1-RPA43-TRg-1":14045,
"PWP2g2_BC1-RPB7-NRg-2":14046,
"PWP2g2_BC1-RPB7-NRg-3":14047,
"PWP2g2_BC1-NSL1-NRg-1":14048,
"PWP2g2_BC1-UTP6-TRg-3":14049,
"PWP2g2_BC1-UTP6-TRg-1":14050,
"PWP2g2_BC1-YJU2-TRg-5":14051,
"PWP2g2_BC1-FRS2-NRg-5":14052,
"PWP2g2_BC1-TIF35-NRg-2":14053,
"PWP2g2_BC1-GPI15-TRg-1":14054,
"PWP2g2_BC1-NOP1-NRg-5":14055,
"PWP2g2_BC1-GPI15-TRg-4":14056,
"PWP2g2_BC1-COG4-TRg-1":14057,
"PWP2g2_BC1-TFA1-TRg-1":14058,
"PWP2g2_BC1-RHO1-NRg-2":14059,
"PWP2g2_BC1-RHO1-NRg-1":14060,
"PWP2g2_BC1-CDC55-NRg-2":14061,
"PWP2g2_BC1-IDI1-NRg-7":14062,
"PWP2g2_BC1-RPL32-TRg-5":14063,
"PWP2g2_BC1-RPB5-TRg-4":14064,
"PWP2g2_BC1-DIP2-TRg-5":14065,
"PWP2g2_BC1-DIP2-TRg-1":14066,
"PWP2g2_BC1-RPC40-TRg-2":14067,
"PWP2g2_BC1-CDC6-TRg-5":14068,
"PWP2g2_BC1-CDC6-TRg-3":14069,
"PWP2g2_BC1-DAD2-TRg-2":14070,
"PWP2g2_BC1-RVS161-TRg-2":14071,
"PWP2g2_BC1-RVS161-TRg-1":14072,
"PWP2g2_BC1-SUP45-NRg-3":14073,
"PWP2g2_BC1-SRB6-NRg-5":14074,
"PWP2g2_BC1-RPC11-TRg-4":14075,
"PWP2g2_BC1-RKI1-TRg-8":14076,
"PWP2g2_BC1-NIP7-TRg-3":14077,
"PWP2g2_BC1-RPL33A-NRg-12":14078,
"PWP2g2_BC1-SAM50-TRg-4":14079,
"PWP2g2_BC1-NOP4-NRg-1":14080,
"PWP2g2_BC1-NOP4-NRg-3":14081,
"PWP2g2_BC1-SMX2-TRg-5":14082,
"PWP2g2_BC1-POL12-NRg-2":14083,
"PWP2g2_BC1-BMS1-NRg-2":14084,
"PWP2g2_BC1-RPA190-TRg-5":14085,
"PWP2g2_BC1-ALG14-NRg-4":14086,
"PWP2g2_BC1-ALG14-NRg-1":14087,
"PWP2g2_BC1-PRE5-NRg-1":14088,
"PWP2g2_BC1-BIG1-NRg-2":14089,
"PWP2g2_BC1-TFA2-TRg-4":14090,
"PWP2g2_BC1-IMP4-TRg-6":14091,
"PWP2g2_BC1-PAN1-NRg-1":14092,
"PWP2g2_BC1-UTP13-TRg-2":14093,
"PWP2g2_BC1-KAE1-NRg-3":14094,
"PWP2g2_BC1-ERG20-TRg-1":14095,
"PWP2g2_BC1-CDC20-TRg-6":14096,
"PWP2g2_BC1-PWP2-NRg-2":14097,
"PWP2g2_BC1-COG1-NRg-1":14098,
"PWP2g2_BC1-RPL1B-TRg-4":14099,
"PWP2g2_BC1-RPL1B-TRg-7":14100,
"PWP2g2_BC1-UTP20-TRg-3":14101,
"PWP2g2_BC1-UTP20-TRg-4":14102,
"PWP2g2_BC1-RPL25-TRg-4":14103,
"PWP2g2_BC1-RPL25-TRg-2":14104,
"PWP2g2_BC1-MCM7-NRg-1":14105,
"PWP2g2_BC1-MRP49-TRg-5":14106,
"PWP2g2_BC1-ERO1-NRg-3":14107,
"PWP2g2_BC1-UTP5-TRg-7":14108,
"PWP2g2_BC1-MCM4-NRg-1":14109,
"PWP2g2_BC1-PRE3-NRg-1":14110,
"PWP2g2_BC1-FCF1-NRg-1":14111,
"PWP2g2_BC1-CUS1-NRg-1":14112,
"PWP2g2_BC1-PSF1-TRg-2":14113,
"PWP2g2_BC1-BCP1-TRg-2":14114,
"PWP2g2_BC1-PAN1-TRg-1":14115,
"PWP2g2_BC1-PAN1-TRg-3":14116,
"PWP2g2_BC1-PAN1-TRg-4":14117,
"PWP2g2_BC1-VPS3-TRg-2":14118,
"PWP2g2_BC1-YIL060W-NRg-1":14119,
"PWP2g2_BC1-VPS53-NRg-1":14120,
"PWP2g2_BC1-CYR1-TRg-4":14121,
"PWP2g2_BC1-CYR1-TRg-7":14122,
"PWP2g2_BC1-MPS1-NRg-1":14123,
"PWP2g2_BC1-SRP1-TRg-5":14124,
"PWP2g2_BC1-SRP1-TRg-4":14125,
"PWP2g2_BC1-TAF12-TRg-2":14126,
"PWP2g2_BC1-TAF12-TRg-3":14127,
"PWP2g2_BC1-POP4-TRg-1":14128,
"PWP2g2_BC1-SPT16-TRg-1":14129,
"PWP2g2_BC1-NUP82-TRg-4":14130,
"PWP2g2_BC1-DML1-TRg-3":14131,
"PWP2g2_BC1-RPA43-NRg-3":14132,
"PWP2g2_BC1-STU2-NRg-3":14133,
"PWP2g2_BC1-POP4-NRg-4":14134,
"PWP2g2_BC1-MCD1-TRg-2":14135,
"PWP2g2_BC1-RPS3-NRg-4":14136,
"PWP2g2_BC1-PRP9-TRg-4":14137,
"PWP2g2_BC1-RPP1-NRg-2":14138,
"PWP2g2_BC1-MTR2-NRg-11":14139,
"PWP2g2_BC1-GCD11-TRg-1":14140,
"PWP2g2_BC1-RPF1-TRg-3":14141,
"PWP2g2_BC1-SUB2-NRg-4":14142,
"PWP2g2_BC1-GPI15-TRg-3":14143,
"PWP2g2_BC1-ERG9-TRg-6":14144,
"PWP2g2_BC1-RPT2-NRg-1":14145,
"PWP2g2_BC1-YOS1-NRg-3":14146,
"PWP2g2_BC1-SCM3-TRg-4":14147,
"PWP2g2_BC1-SCM3-TRg-6":14148,
"PWP2g2_BC1-RLP7-NRg-1":14149,
"PWP2g2_BC1-TFB2-NRg-4":14150,
"PWP2g2_BC1-IMP4-TRg-1":14151,
"PWP2g2_BC1-IMP4-TRg-3":14152,
"PWP2g2_BC1-PRE4-TRg-3":14153,
"PWP2g2_BC1-SUB2-TRg-3":14154,
"PWP2g2_BC1-RPP0-NRg-4":14155,
"PWP2g2_BC1-RPP0-NRg-3":14156,
"PWP2g2_BC1-TOM40-TRg-4":14157,
"PWP2g2_BC1-FUR1-NRg-12":14158,
"PWP2g2_BC1-TOM40-TRg-2":14159,
"PWP2g2_BC1-VMA11-NRg-4":14160,
"PWP2g2_BC1-PGS1-NRg-4":14161,
"PWP2g2_BC1-URB1-TRg-4":14162,
"PWP2g2_BC1-ARP4-TRg-3":14163,
"PWP2g2_BC1-RPT3-TRg-3":14164,
"PWP2g2_BC1-SUI3-TRg-3":14165,
"PWP2g2_BC1-RFC5-NRg-2":14166,
"PWP2g2_BC1-RRP14-TRg-2":14167,
"PWP2g2_BC1-SCC2-TRg-1":14168,
"PWP2g2_BC1-SSC1-TRg-3":14169,
"PWP2g2_BC1-RRP9-TRg-3":14170,
"PWP2g2_BC1-MOT1-NRg-9":14171,
"PWP2g2_BC1-RPL42A-NRg-2":14172,
"PWP2g2_BC1-SEC16-TRg-7":14173,
"PWP2g2_BC1-IMP4-NRg-2":14174,
"PWP2g2_BC1-YEF3-NRg-4":14175,
"PWP2g2_BC1-PUP1-TRg-1":14176,
"PWP2g2_BC1-UTP22-TRg-6":14177,
"PWP2g2_BC1-DBP2-NRg-4":14178,
"PWP2g2_BC1-PRE2-TRg-7":14179,
"PWP2g2_BC1-ATP16-TRg-6":14180,
"PWP2g2_BC1-UTP13-TRg-4":14181,
"PWP2g2_BC1-DOP1-NRg-4":14182,
"PWP2g2_BC1-TIM44-TRg-3":14183,
"PWP2g2_BC1-ATP16-TRg-2":14184,
"PWP2g2_BC1-ENP1-NRg-3":14185,
"PWP2g2_BC1-NAF1-TRg-3":14186,
"PWP2g2_BC1-COG4-TRg-2":14187,
"PWP2g2_BC1-SOG2-TRg-7":14188,
"PWP2g2_BC1-YDR341C-TRg-3":14189,
"PWP2g2_BC1-YMR290W-A-TRg-10":14190,
"PWP2g2_BC1-NUP192-NRg-9":14191,
"PWP2g2_BC1-RPS31-NRg-8":14192,
"PWP2g2_BC1-SPC97-NRg-6":14193,
"PWP2g2_BC1-EBP2-NRg-1":14194,
"PWP2g2_BC1-CDC48-TRg-5":14195,
"PWP2g2_BC1-RPT1-TRg-4":14196,
"PWP2g2_BC1-ULP1-NRg-2":14197,
"PWP2g2_BC1-RPN3-TRg-6":14198,
"PWP2g2_BC1-RPT1-TRg-5":14199,
"PWP2g2_BC1-KRE5-TRg-2":14200,
"PWP2g2_BC1-TBF1-NRg-8":14201,
"PWP2g2_BC1-UTP22-NRg-4":14202,
"PWP2g2_BC1-SSC1-NRg-4":14203,
"PWP2g2_BC1-REB1-TRg-4":14204,
"PWP2g2_BC1-CDC48-NRg-9":14205,
"PWP2g2_BC1-FAS2-TRg-8":14206,
"PWP2g2_BC1-TAO3-TRg-8":14207,
"PWP2g2_BC1-CKS1-TRg-5":14208,
"PWP2g2_BC1-YLR379W-TRg-7":14209,
"PWP2g2_BC1-TEN1-NRg-2":14210,
"PWP2g2_BC1-RPL42A-TRg-2":14211,
"PWP2g2_BC1-SEC27-TRg-4":14212,
"PWP2g2_BC1-TBF1-NRg-4":14213,
"PWP2g2_BC1-RPT1-NRg-6":14214,
"PWP2g2_BC1-COG1-TRg-3":14215,
"PWP2g2_BC1-SUI1-TRg-6":14216,
"PWP2g2_BC1-TIM23-TRg-6":14217,
"PWP2g2_BC1-CDC48-NRg-6":14218,
"PWP2g2_BC1-EPL1-TRg-5":14219,
"PWP2g2_BC1-RPT5-TRg-8":14220,
"PWP2g2_BC1-ATP16-NRg-4":14221,
"PWP2g2_BC1-RPN6-TRg-3":14222,
"PWP2g2_BC1-ERG9-NRg-6":14223,
"PWP2g2_BC1-SMX3-TRg-1":14224,
"PWP2g2_BC1-NCB2-NRg-3":14225,
"PWP2g2_BC1-SEC16-NRg-12":14226,
"PWP2g2_BC1-RPN6-TRg-2":14227,
"PWP2g2_BC1-REB1-NRg-4":14228,
"PWP2g2_BC1-ATP16-TRg-9":14229,
"PWP2g2_BC1-ERG9-NRg-7":14230,
"PWP2g2_BC2-RPL15A-NRg-4":14231,
"PWP2g2_BC2-RPL15A-NRg-5":14232,
"PWP2g2_BC2-KRE33-TRg-1":14233,
"PWP2g2_BC2-PMI40-NRg-1":14234,
"PWP2g2_BC2-NOP19-NRg-3":14235,
"PWP2g2_BC2-SRP14-NRg-4":14236,
"PWP2g2_BC2-SEC27-TRg-2":14237,
"PWP2g2_BC2-GPI14-TRg-3":14238,
"PWP2g2_BC2-PAH1-TRg-7":14239,
"PWP2g2_BC2-PAH1-TRg-6":14240,
"PWP2g2_BC2-PAH1-TRg-5":14241,
"PWP2g2_BC2-PAH1-TRg-3":14242,
"PWP2g2_BC2-COG3-TRg-1":14243,
"PWP2g2_BC2-HTS1-NRg-5":14244,
"PWP2g2_BC2-MSN5-TRg-7":14245,
"PWP2g2_BC2-ERG26-TRg-1":14246,
"PWP2g2_BC2-SMD2-TRg-5":14247,
"PWP2g2_BC2-SMD2-TRg-4":14248,
"PWP2g2_BC2-SMD2-TRg-1":14249,
"PWP2g2_BC2-PRE7-TRg-4":14250,
"PWP2g2_BC2-PRE7-TRg-7":14251,
"PWP2g2_BC2-SEC6-TRg-3":14252,
"PWP2g2_BC2-ESF2-NRg-1":14253,
"PWP2g2_BC2-ESF2-NRg-3":14254,
"PWP2g2_BC2-AFG2-TRg-2":14255,
"PWP2g2_BC2-RRP36-TRg-3":14256,
"PWP2g2_BC2-RRP36-TRg-5":14257,
"PWP2g2_BC2-GCR1-NRg-2":14258,
"PWP2g2_BC2-PRE4-NRg-4":14259,
"PWP2g2_BC2-PRE4-NRg-9":14260,
"PWP2g2_BC2-DSN1-NRg-2":14261,
"PWP2g2_BC2-GPI11-TRg-3":14262,
"PWP2g2_BC2-POP3-TRg-1":14263,
"PWP2g2_BC2-MNE1-TRg-5":14264,
"PWP2g2_BC2-RRP12-NRg-1":14265,
"PWP2g2_BC2-RSC6-TRg-2":14266,
"PWP2g2_BC2-CDC25-TRg-1":14267,
"PWP2g2_BC2-CDC25-TRg-9":14268,
"PWP2g2_BC2-YPP1-NRg-3":14269,
"PWP2g2_BC2-NFS1-NRg-9":14270,
"PWP2g2_BC2-NFS1-NRg-8":14271,
"PWP2g2_BC2-UBA2-TRg-1":14272,
"PWP2g2_BC2-ARP2-NRg-3":14273,
"PWP2g2_BC2-MAK16-TRg-1":14274,
"PWP2g2_BC2-CEP3-NRg-1":14275,
"PWP2g2_BC2-GUK1-TRg-5":14276,
"PWP2g2_BC2-GUK1-TRg-2":14277,
"PWP2g2_BC2-GPI12-NRg-6":14278,
"PWP2g2_BC2-RPS5-NRg-5":14279,
"PWP2g2_BC2-RPS5-NRg-2":14280,
"PWP2g2_BC2-RPC19-NRg-1":14281,
"PWP2g2_BC2-TIM54-TRg-1":14282,
"PWP2g2_BC2-TEN1-TRg-2":14283,
"PWP2g2_BC2-SAH1-NRg-4":14284,
"PWP2g2_BC2-SAH1-NRg-5":14285,
"PWP2g2_BC2-SAH1-NRg-3":14286,
"PWP2g2_BC2-ATP15-NRg-5":14287,
"PWP2g2_BC2-SCD5-TRg-5":14288,
"PWP2g2_BC2-ARB1-NRg-2":14289,
"PWP2g2_BC2-ARB1-NRg-4":14290,
"PWP2g2_BC2-PUP2-TRg-1":14291,
"PWP2g2_BC2-CCT8-TRg-2":14292,
"PWP2g2_BC2-MCM4-TRg-1":14293,
"PWP2g2_BC2-LSM4-TRg-1":14294,
"PWP2g2_BC2-NOP53-NRg-1":14295,
"PWP2g2_BC2-ATP3-TRg-4":14296,
"PWP2g2_BC2-AFG2-NRg-3":14297,
"PWP2g2_BC2-PRO3-NRg-3":14298,
"PWP2g2_BC2-NRD1-NRg-10":14299,
"PWP2g2_BC2-SEC61-TRg-2":14300,
"PWP2g2_BC2-RHO3-TRg-4":14301,
"PWP2g2_BC2-SNF2-TRg-6":14302,
"PWP2g2_BC2-SMD2-NRg-3":14303,
"PWP2g2_BC2-RSC4-TRg-2":14304,
"PWP2g2_BC2-RSC4-TRg-1":14305,
"PWP2g2_BC2-TIF34-TRg-2":14306,
"PWP2g2_BC2-BET1-NRg-1":14307,
"PWP2g2_BC2-CDC8-NRg-2":14308,
"PWP2g2_BC2-PRP42-TRg-2":14309,
"PWP2g2_BC2-RRB1-TRg-2":14310,
"PWP2g2_BC2-SPC24-TRg-1":14311,
"PWP2g2_BC2-ILS1-NRg-1":14312,
"PWP2g2_BC2-GFA1-TRg-2":14313,
"PWP2g2_BC2-SEC21-NRg-10":14314,
"PWP2g2_BC2-RPC10-NRg-1":14315,
"PWP2g2_BC2-RPB10-TRg-3":14316,
"PWP2g2_BC2-RPB10-TRg-2":14317,
"PWP2g2_BC2-YNL181W-TRg-1":14318,
"PWP2g2_BC2-RAD3-NRg-1":14319,
"PWP2g2_BC2-NOP10-TRg-1":14320,
"PWP2g2_BC2-BFR2-TRg-3":14321,
"PWP2g2_BC2-MCM2-TRg-6":14322,
"PWP2g2_BC2-MCM2-TRg-4":14323,
"PWP2g2_BC2-MPP10-TRg-1":14324,
"PWP2g2_BC2-RET2-TRg-4":14325,
"PWP2g2_BC2-RET2-TRg-1":14326,
"PWP2g2_BC2-RPS2-NRg-1":14327,
"PWP2g2_BC2-RPS2-NRg-2":14328,
"PWP2g2_BC2-ORC4-NRg-3":14329,
"PWP2g2_BC2-TIP20-TRg-7":14330,
"PWP2g2_BC2-SMT3-TRg-1":14331,
"PWP2g2_BC2-MSS18-NRg-6":14332,
"PWP2g2_BC2-YEF3-NRg-9":14333,
"PWP2g2_BC2-ASK1-NRg-1":14334,
"PWP2g2_BC2-SMC1-TRg-1":14335,
"PWP2g2_BC2-NIP1-NRg-1":14336,
"PWP2g2_BC2-RPP1-NRg-1":14337,
"PWP2g2_BC2-YDJ1-TRg-6":14338,
"PWP2g2_BC2-SUB2-NRg-1":14339,
"PWP2g2_BC2-TIM10-NRg-8":14340,
"PWP2g2_BC2-TIM10-NRg-4":14341,
"PWP2g2_BC2-TIM10-NRg-7":14342,
"PWP2g2_BC2-SKI6-TRg-4":14343,
"PWP2g2_BC2-TUB4-TRg-1":14344,
"PWP2g2_BC2-CDC37-NRg-2":14345,
"PWP2g2_BC2-ISD11-TRg-3":14346,
"PWP2g2_BC2-YOS1-TRg-4":14347,
"PWP2g2_BC2-SSC1-TRg-6":14348,
"PWP2g2_BC2-MTR3-TRg-5":14349,
"PWP2g2_BC2-MTR3-TRg-6":14350,
"PWP2g2_BC2-TFA1-TRg-2":14351,
"PWP2g2_BC2-CDC3-NRg-3":14352,
"PWP2g2_BC2-ERG25-TA-18":14353,
"PWP2g2_BC2-RPB11-TRg-4":14354,
"PWP2g2_BC2-RPB11-TRg-1":14355,
"PWP2g2_BC2-RPB11-TRg-2":14356,
"PWP2g2_BC2-DED1-TRg-3":14357,
"PWP2g2_BC2-DED1-TRg-1":14358,
"PWP2g2_BC2-DED1-TRg-6":14359,
"PWP2g2_BC2-DED1-TRg-4":14360,
"PWP2g2_BC2-RPL10-NRg-5":14361,
"PWP2g2_BC2-RPL10-NRg-4":14362,
"PWP2g2_BC2-EFB1-NRg-1":14363,
"PWP2g2_BC2-EFB1-NRg-5":14364,
"PWP2g2_BC2-EFB1-NRg-4":14365,
"PWP2g2_BC2-RPT3-NRg-1":14366,
"PWP2g2_BC2-SAC6-TRg-8":14367,
"PWP2g2_BC2-SAC6-TRg-4":14368,
"PWP2g2_BC2-SAC6-TRg-5":14369,
"PWP2g2_BC2-SAC6-TRg-3":14370,
"PWP2g2_BC2-DIM1-TRg-5":14371,
"PWP2g2_BC2-DIM1-TRg-7":14372,
"PWP2g2_BC2-RPC17-NRg-1":14373,
"PWP2g2_BC2-RPC17-NRg-2":14374,
"PWP2g2_BC2-YDR341C-TRg-1":14375,
"PWP2g2_BC2-RAP1-NRg-8":14376,
"PWP2g2_BC2-RAP1-NRg-5":14377,
"PWP2g2_BC2-RAP1-NRg-2":14378,
"PWP2g2_BC2-SEC26-NRg-3":14379,
"PWP2g2_BC2-SPP41-TRg-3":14380,
"PWP2g2_BC2-TAP42-NRg-1":14381,
"PWP2g2_BC2-PGA2-TRg-6":14382,
"PWP2g2_BC2-BRL1-TRg-1":14383,
"PWP2g2_BC2-FOL2-TRg-1":14384,
"PWP2g2_BC2-NAB3-NRg-5":14385,
"PWP2g2_BC2-SNF4-TRg-4":14386,
"PWP2g2_BC2-HRR25-TRg-2":14387,
"PWP2g2_BC2-TRS23-TRg-4":14388,
"PWP2g2_BC2-CTR86-TRg-4":14389,
"PWP2g2_BC2-RPB5-TRg-5":14390,
"PWP2g2_BC2-SPN1-NRg-2":14391,
"PWP2g2_BC2-SPN1-NRg-1":14392,
"PWP2g2_BC2-SEC61-NRg-1":14393,
"PWP2g2_BC2-SEC61-NRg-7":14394,
"PWP2g2_BC2-TUS1-TRg-3":14395,
"PWP2g2_BC2-OLE1-NRg-2":14396,
"PWP2g2_BC2-AFG2-TRg-1":14397,
"PWP2g2_BC2-TOA2-NRg-1":14398,
"PWP2g2_BC2-USO1-TRg-1":14399,
"PWP2g2_BC2-UTP22-NRg-2":14400,
"PWP2g2_BC2-RIB1-TRg-3":14401,
"PWP2g2_BC2-RIB1-TRg-7":14402,
"PWP2g2_BC2-RIB1-TRg-4":14403,
"PWP2g2_BC2-COG1-TRg-1":14404,
"PWP2g2_BC2-RPL32-NRg-2":14405,
"PWP2g2_BC2-GLC7-NRg-3":14406,
"PWP2g2_BC2-GLC7-NRg-4":14407,
"PWP2g2_BC2-HSF1-TRg-2":14408,
"PWP2g2_BC2-DAM1-NRg-5":14409,
"PWP2g2_BC2-SEC18-TRg-4":14410,
"PWP2g2_BC2-SEC18-TRg-5":14411,
"PWP2g2_BC2-PAB1-NRg-3":14412,
"PWP2g2_BC2-POP8-TRg-2":14413,
"PWP2g2_BC2-PAB1-NRg-4":14414,
"PWP2g2_BC2-BIG1-TRg-4":14415,
"PWP2g2_BC2-BIG1-TRg-5":14416,
"PWP2g2_BC2-BIG1-TRg-6":14417,
"PWP2g2_BC2-RPO41-NRg-1":14418,
"PWP2g2_BC2-RVB2-NRg-2":14419,
"PWP2g2_BC2-PET117-NRg-8":14420,
"PWP2g2_BC2-VPS45-NRg-9":14421,
"PWP2g2_BC2-YCG1-NRg-1":14422,
"PWP2g2_BC2-NOC4-NRg-1":14423,
"PWP2g2_BC2-NMD3-NRg-2":14424,
"PWP2g2_BC2-DRS1-TRg-2":14425,
"PWP2g2_BC2-HTB1-NRg-2":14426,
"PWP2g2_BC2-IPI1-TRg-2":14427,
"PWP2g2_BC2-SEC18-NRg-1":14428,
"PWP2g2_BC2-SEC18-NRg-2":14429,
"PWP2g2_BC2-JIP5-NRg-2":14430,
"PWP2g2_BC2-YPT1-TRg-3":14431,
"PWP2g2_BC2-YPT1-TRg-2":14432,
"PWP2g2_BC2-CLF1-NRg-2":14433,
"PWP2g2_BC2-SNF2-NRg-7":14434,
"PWP2g2_BC2-SNF2-NRg-4":14435,
"PWP2g2_BC2-RPL25-NRg-1":14436,
"PWP2g2_BC2-NOP56-TRg-1":14437,
"PWP2g2_BC2-NOP56-TRg-2":14438,
"PWP2g2_BC2-TRS31-TRg-1":14439,
"PWP2g2_BC2-DBF4-TRg-2":14440,
"PWP2g2_BC2-DBF4-TRg-1":14441,
"PWP2g2_BC2-RPC19-TRg-4":14442,
"PWP2g2_BC2-RPC19-TRg-6":14443,
"PWP2g2_BC2-RPC19-TRg-3":14444,
"PWP2g2_BC2-ROK1-NRg-1":14445,
"PWP2g2_BC2-CDC33-TRg-4":14446,
"PWP2g2_BC2-DHR2-TRg-3":14447,
"PWP2g2_BC2-RRP42-NRg-5":14448,
"PWP2g2_BC2-CLF1-TRg-1":14449,
"PWP2g2_BC2-ERG11-NA-16":14450,
"PWP2g2_BC2-VAS1-NRg-4":14451,
"PWP2g2_BC2-PIK1-NRg-2":14452,
"PWP2g2_BC2-SAR1-NRg-7":14453,
"PWP2g2_BC2-SAR1-NRg-4":14454,
"PWP2g2_BC2-RPS3-TRg-1":14455,
"PWP2g2_BC2-YTM1-TRg-2":14456,
"PWP2g2_BC2-SUI3-NRg-5":14457,
"PWP2g2_BC2-SUI3-NRg-2":14458,
"PWP2g2_BC2-RRP7-TRg-4":14459,
"PWP2g2_BC2-RRP7-TRg-6":14460,
"PWP2g2_BC2-NIP7-TRg-2":14461,
"PWP2g2_BC2-MDM35-TRg-1":14462,
"PWP2g2_BC2-ALA1-NRg-1":14463,
"PWP2g2_BC2-DOA4-NRg-2":14464,
"PWP2g2_BC2-RPS13-NRg-1":14465,
"PWP2g2_BC2-YSF3-TRg-2":14466,
"PWP2g2_BC2-RPS2-NRg-11":14467,
"PWP2g2_BC2-SSL1-TRg-10":14468,
"PWP2g2_BC2-NIP7-TRg-1":14469,
"PWP2g2_BC2-LST8-NRg-1":14470,
"PWP2g2_BC2-TAF4-TRg-3":14471,
"PWP2g2_BC2-HAS1-TRg-2":14472,
"PWP2g2_BC2-GLC7-TRg-2":14473,
"PWP2g2_BC2-CDC45-NRg-1":14474,
"PWP2g2_BC2-SEC22-NRg-8":14475,
"PWP2g2_BC2-YOS1-TRg-2":14476,
"PWP2g2_BC2-RBA50-TRg-3":14477,
"PWP2g2_BC2-SPP41-NRg-2":14478,
"PWP2g2_BC2-PRP46-TRg-2":14479,
"PWP2g2_BC2-PGA2-NRg-1":14480,
"PWP2g2_BC2-CBF5-TRg-3":14481,
"PWP2g2_BC2-TCP1-NRg-3":14482,
"PWP2g2_BC2-TCP1-NRg-2":14483,
"PWP2g2_BC2-ERG26-NRg-2":14484,
"PWP2g2_BC2-ERG26-NRg-4":14485,
"PWP2g2_BC2-MES1-TRg-5":14486,
"PWP2g2_BC2-HTS1-TRg-2":14487,
"PWP2g2_BC2-SSS1-TRg-3":14488,
"PWP2g2_BC2-SSS1-TRg-2":14489,
"PWP2g2_BC2-SYS1-TRg-7":14490,
"PWP2g2_BC2-SYS1-TRg-2":14491,
"PWP2g2_BC2-SYS1-TRg-1":14492,
"PWP2g2_BC2-BFR2-TRg-1":14493,
"PWP2g2_BC2-EOS1-TRg-3":14494,
"PWP2g2_BC2-TAF4-NRg-1":14495,
"PWP2g2_BC2-ARL3-NRg-8":14496,
"PWP2g2_BC2-RPN5-NRg-1":14497,
"PWP2g2_BC2-TIM9-NRg-2":14498,
"PWP2g2_BC2-NUP57-NRg-3":14499,
"PWP2g2_BC2-VPS4-TRg-1":14500,
"PWP2g2_BC2-CDC3-TRg-4":14501,
"PWP2g2_BC2-BBP1-NRg-1":14502,
"PWP2g2_BC2-BBP1-NRg-2":14503,
"PWP2g2_BC2-USE1-NRg-3":14504,
"PWP2g2_BC2-CCT7-TRg-1":14505,
"PWP2g2_BC2-SAH1-TRg-3":14506,
"PWP2g2_BC2-CHS2-TRg-1":14507,
"PWP2g2_BC2-DPM1-TRg-2":14508,
"PWP2g2_BC2-BBP1-TRg-1":14509,
"PWP2g2_BC2-NRD1-TRg-4":14510,
"PWP2g2_BC2-RPB3-NRg-1":14511,
"PWP2g2_BC2-PHO85-NRg-6":14512,
"PWP2g2_BC2-SNF6-TRg-6":14513,
"PWP2g2_BC2-PRP38-NRg-2":14514,
"PWP2g2_BC2-OAR1-NRg-3":14515,
"PWP2g2_BC2-ROX3-NRg-1":14516,
"PWP2g2_BC2-YPP1-TRg-6":14517,
"PWP2g2_BC2-CBF2-NRg-8":14518,
"PWP2g2_BC2-SPT6-TRg-5":14519,
"PWP2g2_BC2-SEC10-NRg-1":14520,
"PWP2g2_BC2-NSL1-NRg-3":14521,
"PWP2g2_BC2-NRD1-NRg-8":14522,
"PWP2g2_BC2-RPB3-TRg-1":14523,
"PWP2g2_BC2-NRD1-NRg-4":14524,
"PWP2g2_BC2-RVB1-TRg-2":14525,
"PWP2g2_BC2-TIF5-NRg-8":14526,
"PWP2g2_BC2-EOS1-NRg-1":14527,
"PWP2g2_BC2-ERG25-NA-26":14528,
"PWP2g2_BC2-MSL5-NRg-4":14529,
"PWP2g2_BC2-SEC24-TRg-2":14530,
"PWP2g2_BC2-RPL30-NRg-5":14531,
"PWP2g2_BC2-SNU71-NRg-3":14532,
"PWP2g2_BC2-CDC33-NRg-1":14533,
"PWP2g2_BC2-RPN6-TRg-4":14534,
"PWP2g2_BC2-NAB2-TRg-4":14535,
"PWP2g2_BC2-NAB2-TRg-6":14536,
"PWP2g2_BC2-YTM1-NRg-1":14537,
"PWP2g2_BC2-OLE1-TRg-8":14538,
"PWP2g2_BC2-OLE1-TRg-1":14539,
"PWP2g2_BC2-UTP7-TRg-4":14540,
"PWP2g2_BC2-ACT1-NRg-6":14541,
"PWP2g2_BC2-RPL18A-NRg-3":14542,
"PWP2g2_BC2-BRX1-NRg-1":14543,
"PWP2g2_BC2-NAF1-TRg-8":14544,
"PWP2g2_BC2-NAF1-TRg-6":14545,
"PWP2g2_BC2-NAF1-TRg-4":14546,
"PWP2g2_BC2-CDC8-TRg-2":14547,
"PWP2g2_BC2-NSE4-TRg-1":14548,
"PWP2g2_BC2-PAB1-NRg-2":14549,
"PWP2g2_BC2-PRP43-TRg-4":14550,
"PWP2g2_BC2-SEC2-NRg-3":14551,
"PWP2g2_BC2-SEC2-NRg-6":14552,
"PWP2g2_BC2-MPP10-NRg-5":14553,
"PWP2g2_BC2-YDR355C-TRg-2":14554,
"PWP2g2_BC2-YLR339C-TRg-9":14555,
"PWP2g2_BC2-SNM1-TRg-2":14556,
"PWP2g2_BC2-ALR1-NRg-4":14557,
"PWP2g2_BC2-ALR1-NRg-1":14558,
"PWP2g2_BC2-ALR1-NRg-3":14559,
"PWP2g2_BC2-RPL10-TRg-1":14560,
"PWP2g2_BC2-RPL28-TRg-2":14561,
"PWP2g2_BC2-UTP25-TRg-1":14562,
"PWP2g2_BC2-POB3-TRg-1":14563,
"PWP2g2_BC2-POB3-TRg-3":14564,
"PWP2g2_BC2-POB3-TRg-2":14565,
"PWP2g2_BC2-MED11-TRg-1":14566,
"PWP2g2_BC2-ISA1-TRg-15":14567,
"PWP2g2_BC2-RRP1-NRg-1":14568,
"PWP2g2_BC2-MES1-NRg-1":14569,
"PWP2g2_BC2-SEC13-NRg-5":14570,
"PWP2g2_BC2-MCM2-NRg-2":14571,
"PWP2g2_BC2-ALA1-TRg-4":14572,
"PWP2g2_BC2-MTG2-TRg-5":14573,
"PWP2g2_BC2-TIF35-NRg-3":14574,
"PWP2g2_BC2-NSE1-TRg-3":14575,
"PWP2g2_BC2-NSE1-TRg-4":14576,
"PWP2g2_BC2-MOB2-NRg-6":14577,
"PWP2g2_BC2-VRG4-NRg-3":14578,
"PWP2g2_BC2-PRP9-TRg-3":14579,
"PWP2g2_BC2-HYM1-TRg-5":14580,
"PWP2g2_BC2-POP1-TRg-5":14581,
"PWP2g2_BC2-POP1-TRg-9":14582,
"PWP2g2_BC2-RPL17A-TRg-1":14583,
"PWP2g2_BC2-SLD2-TRg-1":14584,
"PWP2g2_BC2-CDC48-NRg-7":14585,
"PWP2g2_BC2-FHL1-NRg-2":14586,
"PWP2g2_BC2-BET3-NRg-7":14587,
"PWP2g2_BC2-MAK21-TRg-1":14588,
"PWP2g2_BC2-BRN1-TRg-4":14589,
"PWP2g2_BC2-FBA1-NRg-3":14590,
"PWP2g2_BC2-CDC42-TRg-6":14591,
"PWP2g2_BC2-CDC42-TRg-7":14592,
"PWP2g2_BC2-COG4-NRg-1":14593,
"PWP2g2_BC2-ATP3-NRg-3":14594,
"PWP2g2_BC2-ATP3-NRg-2":14595,
"PWP2g2_BC2-SMP3-TRg-5":14596,
"PWP2g2_BC2-CFT2-NRg-2":14597,
"PWP2g2_BC2-FAS2-TRg-5":14598,
"PWP2g2_BC2-DBP2-NRg-3":14599,
"PWP2g2_BC2-DBP2-NRg-2":14600,
"PWP2g2_BC2-MPS2-NRg-4":14601,
"PWP2g2_BC2-ARC35-TRg-2":14602,
"PWP2g2_BC2-ARC35-TRg-5":14603,
"PWP2g2_BC2-MRD1-TRg-1":14604,
"PWP2g2_BC2-RLP7-TRg-1":14605,
"PWP2g2_BC2-SPC34-TRg-1":14606,
"PWP2g2_BC2-CDC45-TRg-2":14607,
"PWP2g2_BC2-GCD6-TRg-3":14608,
"PWP2g2_BC2-GCD6-TRg-4":14609,
"PWP2g2_BC2-YPT6-NRg-2":14610,
"PWP2g2_BC2-RPS13-TRg-2":14611,
"PWP2g2_BC2-IPI3-TRg-3":14612,
"PWP2g2_BC2-TIF5-NRg-9":14613,
"PWP2g2_BC2-TIF5-NRg-7":14614,
"PWP2g2_BC2-TIF5-NRg-6":14615,
"PWP2g2_BC2-NAB3-TRg-3":14616,
"PWP2g2_BC2-GCD2-TRg-1":14617,
"PWP2g2_BC2-UBA1-TRg-2":14618,
"PWP2g2_BC2-SLD3-TRg-6":14619,
"PWP2g2_BC2-LCB1-TRg-5":14620,
"PWP2g2_BC2-TOA2-TRg-6":14621,
"PWP2g2_BC2-TOA2-TRg-1":14622,
"PWP2g2_BC2-TOA2-TRg-3":14623,
"PWP2g2_BC2-LSM2-TRg-1":14624,
"PWP2g2_BC2-YML6-TRg-13":14625,
"PWP2g2_BC2-YML6-TRg-12":14626,
"PWP2g2_BC2-UTP15-NRg-1":14627,
"PWP2g2_BC2-TIF6-NRg-8":14628,
"PWP2g2_BC2-SUP35-NRg-1":14629,
"PWP2g2_BC2-MPP10-NRg-1":14630,
"PWP2g2_BC2-SWI3-TRg-7":14631,
"PWP2g2_BC2-SSN3-NRg-2":14632,
"PWP2g2_BC2-SEC13-NRg-7":14633,
"PWP2g2_BC2-RPS15-NRg-3":14634,
"PWP2g2_BC2-RPL3-TRg-2":14635,
"PWP2g2_BC2-FBA1-NRg-2":14636,
"PWP2g2_BC2-FBA1-NRg-1":14637,
"PWP2g2_BC2-FBA1-NRg-5":14638,
"PWP2g2_BC2-DAM1-TRg-2":14639,
"PWP2g2_BC2-NHP2-TRg-2":14640,
"PWP2g2_BC2-HCA4-NRg-6":14641,
"PWP2g2_BC2-PRE3-TRg-4":14642,
"PWP2g2_BC2-DBP5-NRg-4":14643,
"PWP2g2_BC2-SPT6-NRg-4":14644,
"PWP2g2_BC2-SPT6-NRg-2":14645,
"PWP2g2_BC2-RPL18A-TRg-4":14646,
"PWP2g2_BC2-KSH1-TRg-1":14647,
"PWP2g2_BC2-KSH1-TRg-3":14648,
"PWP2g2_BC2-IPI3-NRg-1":14649,
"PWP2g2_BC2-PGA2-TRg-8":14650,
"PWP2g2_BC2-RPL18A-TRg-2":14651,
"PWP2g2_BC2-RPL33A-NRg-6":14652,
"PWP2g2_BC2-TAF12-NRg-2":14653,
"PWP2g2_BC2-USE1-TRg-5":14654,
"PWP2g2_BC2-YNL114C-TRg-1":14655,
"PWP2g2_BC2-SMC5-TRg-7":14656,
"PWP2g2_BC2-SMC5-TRg-6":14657,
"PWP2g2_BC2-RSC58-TRg-1":14658,
"PWP2g2_BC2-CTF13-TRg-2":14659,
"PWP2g2_BC2-NAB2-NRg-2":14660,
"PWP2g2_BC2-MCM7-TRg-4":14661,
"PWP2g2_BC2-BCP1-NRg-5":14662,
"PWP2g2_BC2-STU2-TRg-3":14663,
"PWP2g2_BC2-SEC21-NRg-6":14664,
"PWP2g2_BC2-SEC21-NRg-3":14665,
"PWP2g2_BC2-RPL1B-TRg-3":14666,
"PWP2g2_BC2-SEC20-NRg-2":14667,
"PWP2g2_BC2-VMA3-NRg-2":14668,
"PWP2g2_BC2-SEC23-NRg-5":14669,
"PWP2g2_BC2-CDC28-TRg-4":14670,
"PWP2g2_BC2-RPN12-NRg-11":14671,
"PWP2g2_BC2-PUP3-TRg-3":14672,
"PWP2g2_BC2-SEC31-TRg-2":14673,
"PWP2g2_BC2-SED5-TRg-6":14674,
"PWP2g2_BC2-SED5-TRg-5":14675,
"PWP2g2_BC2-RPL33A-TRg-1":14676,
"PWP2g2_BC2-RPL33A-TRg-2":14677,
"PWP2g2_BC2-MRPL11-TRg-2":14678,
"PWP2g2_BC2-RTP1-NRg-2":14679,
"PWP2g2_BC2-NUG1-TRg-2":14680,
"PWP2g2_BC2-VPH2-TRg-4":14681,
"PWP2g2_BC2-COP1-NRg-3":14682,
"PWP2g2_BC2-CRM1-NRg-1":14683,
"PWP2g2_BC2-RPL5-NRg-4":14684,
"PWP2g2_BC2-SNU13-NRg-4":14685,
"PWP2g2_BC2-PFS2-TRg-3":14686,
"PWP2g2_BC2-MPP10-TRg-2":14687,
"PWP2g2_BC2-TSR4-NRg-2":14688,
"PWP2g2_BC2-RSC2-TRg-1":14689,
"PWP2g2_BC2-SEC65-TRg-2":14690,
"PWP2g2_BC2-SMI1-NRg-1":14691,
"PWP2g2_BC2-RTT105-NRg-4":14692,
"PWP2g2_BC2-VMA5-TRg-3":14693,
"PWP2g2_BC2-VMA5-TRg-5":14694,
"PWP2g2_BC2-RRP1-TRg-3":14695,
"PWP2g2_BC2-CLC1-TRg-2":14696,
"PWP2g2_BC2-GCD6-NRg-1":14697,
"PWP2g2_BC2-GCD6-NRg-2":14698,
"PWP2g2_BC2-PXR1-TRg-1":14699,
"PWP2g2_BC2-CDC14-NRg-1":14700,
"PWP2g2_BC2-PCF11-TRg-6":14701,
"PWP2g2_BC2-PCF11-TRg-5":14702,
"PWP2g2_BC2-PCF11-TRg-4":14703,
"PWP2g2_BC2-SEC31-NRg-1":14704,
"PWP2g2_BC2-RRP5-NRg-1":14705,
"PWP2g2_BC2-PRE10-TRg-5":14706,
"PWP2g2_BC2-PRE10-TRg-1":14707,
"PWP2g2_BC2-RPS5-TRg-2":14708,
"PWP2g2_BC2-NSP1-TRg-4":14709,
"PWP2g2_BC2-PRP38-TRg-4":14710,
"PWP2g2_BC2-RCF1-NRg-5":14711,
"PWP2g2_BC2-RSC3-TRg-4":14712,
"PWP2g2_BC2-RSC3-TRg-5":14713,
"PWP2g2_BC2-RSC3-TRg-6":14714,
"PWP2g2_BC2-HTA1-NRg-12":14715,
"PWP2g2_BC2-HTA1-NRg-11":14716,
"PWP2g2_BC2-UTP23-TRg-2":14717,
"PWP2g2_BC2-GCD7-NRg-1":14718,
"PWP2g2_BC2-GCD7-NRg-2":14719,
"PWP2g2_BC2-GCD7-NRg-6":14720,
"PWP2g2_BC2-GAL11-NRg-2":14721,
"PWP2g2_BC2-GAL11-NRg-9":14722,
"PWP2g2_BC2-PHO4-TRg-5":14723,
"PWP2g2_BC2-SNP1-NRg-3":14724,
"PWP2g2_BC2-RPC37-TRg-5":14725,
"PWP2g2_BC2-CRM1-TRg-5":14726,
"PWP2g2_BC2-CRM1-TRg-2":14727,
"PWP2g2_BC2-ASK1-TRg-7":14728,
"PWP2g2_BC2-STU2-NRg-4":14729,
"PWP2g2_BC2-NEO1-NRg-3":14730,
"PWP2g2_BC2-GAL11-TRg-5":14731,
"PWP2g2_BC2-GAL11-TRg-7":14732,
"PWP2g2_BC2-SAM50-NRg-3":14733,
"PWP2g2_BC2-CSL4-TRg-2":14734,
"PWP2g2_BC2-CCT5-TRg-2":14735,
"PWP2g2_BC2-POL30-NRg-1":14736,
"PWP2g2_BC2-MED4-TRg-4":14737,
"PWP2g2_BC2-MED4-TRg-3":14738,
"PWP2g2_BC2-MED4-TRg-2":14739,
"PWP2g2_BC2-GDI1-TRg-4":14740,
"PWP2g2_BC2-GDI1-TRg-3":14741,
"PWP2g2_BC2-REB1-TRg-6":14742,
"PWP2g2_BC2-MRPL37-NRg-2":14743,
"PWP2g2_BC2-NOC3-TRg-3":14744,
"PWP2g2_BC2-SPC97-TRg-3":14745,
"PWP2g2_BC2-IPP1-TRg-3":14746,
"PWP2g2_BC2-IPP1-TRg-2":14747,
"PWP2g2_BC2-PTI1-TRg-3":14748,
"PWP2g2_BC2-PTI1-TRg-5":14749,
"PWP2g2_BC2-RFC5-NRg-1":14750,
"PWP2g2_BC2-CDC24-TRg-1":14751,
"PWP2g2_BC2-CDC24-TRg-3":14752,
"PWP2g2_BC2-CDC24-TRg-5":14753,
"PWP2g2_BC2-CDC24-TRg-6":14754,
"PWP2g2_BC2-UTP23-TRg-6":14755,
"PWP2g2_BC2-UTP23-TRg-4":14756,
"PWP2g2_BC2-UTP23-TRg-1":14757,
"PWP2g2_BC2-RHO3-NRg-4":14758,
"PWP2g2_BC2-TRS23-NRg-1":14759,
"PWP2g2_BC2-TRS23-NRg-3":14760,
"PWP2g2_BC2-RSP5-TRg-2":14761,
"PWP2g2_BC2-RSP5-TRg-1":14762,
"PWP2g2_BC2-SDA1-NRg-1":14763,
"PWP2g2_BC2-KAP95-TRg-8":14764,
"PWP2g2_BC2-ACO1-TRg-6":14765,
"PWP2g2_BC2-HTA1-NRg-3":14766,
"PWP2g2_BC2-HTA1-NRg-2":14767,
"PWP2g2_BC2-SPN1-TRg-1":14768,
"PWP2g2_BC2-MOT1-NRg-7":14769,
"PWP2g2_BC2-RPL17A-NRg-4":14770,
"PWP2g2_BC2-ADA2-TRg-4":14771,
"PWP2g2_BC2-SFH1-NRg-1":14772,
"PWP2g2_BC2-SPC97-NRg-5":14773,
"PWP2g2_BC2-PRP22-TRg-3":14774,
"PWP2g2_BC2-SEN15-TRg-2":14775,
"PWP2g2_BC2-RPL3-NRg-2":14776,
"PWP2g2_BC2-ISD11-NRg-2":14777,
"PWP2g2_BC2-HEM12-TRg-8":14778,
"PWP2g2_BC2-SEC10-TRg-1":14779,
"PWP2g2_BC2-HTB1-TRg-7":14780,
"PWP2g2_BC2-TTI2-TRg-1":14781,
"PWP2g2_BC2-ACP1-TRg-2":14782,
"PWP2g2_BC2-ACP1-TRg-4":14783,
"PWP2g2_BC2-GAL11-NRg-10":14784,
"PWP2g2_BC2-UTP22-TRg-2":14785,
"PWP2g2_BC2-MST1-NRg-5":14786,
"PWP2g2_BC2-RIB7-NRg-2":14787,
"PWP2g2_BC2-MCD1-TRg-6":14788,
"PWP2g2_BC2-MCD1-TRg-5":14789,
"PWP2g2_BC2-GPI8-NRg-2":14790,
"PWP2g2_BC2-THS1-TRg-2":14791,
"PWP2g2_BC2-RRP7-TRg-2":14792,
"PWP2g2_BC2-RRP7-TRg-5":14793,
"PWP2g2_BC2-SMX2-NRg-7":14794,
"PWP2g2_BC2-RRP45-TRg-5":14795,
"PWP2g2_BC2-RRP45-TRg-4":14796,
"PWP2g2_BC2-CNS1-TRg-2":14797,
"PWP2g2_BC2-FBP1-NRg-9":14798,
"PWP2g2_BC2-GCD11-NRg-1":14799,
"PWP2g2_BC2-RPL10-TRg-2":14800,
"PWP2g2_BC2-NUP192-TRg-4":14801,
"PWP2g2_BC2-NUP145-NRg-4":14802,
"PWP2g2_BC2-HEM12-TRg-6":14803,
"PWP2g2_BC2-PLC1-TRg-3":14804,
"PWP2g2_BC2-RPA43-TRg-1":14805,
"PWP2g2_BC2-RPB7-NRg-2":14806,
"PWP2g2_BC2-RPB7-NRg-3":14807,
"PWP2g2_BC2-NSL1-NRg-1":14808,
"PWP2g2_BC2-UTP6-TRg-3":14809,
"PWP2g2_BC2-UTP6-TRg-1":14810,
"PWP2g2_BC2-YJU2-TRg-5":14811,
"PWP2g2_BC2-FRS2-NRg-5":14812,
"PWP2g2_BC2-TIF35-NRg-2":14813,
"PWP2g2_BC2-GPI15-TRg-1":14814,
"PWP2g2_BC2-NOP1-NRg-5":14815,
"PWP2g2_BC2-GPI15-TRg-4":14816,
"PWP2g2_BC2-COG4-TRg-1":14817,
"PWP2g2_BC2-TFA1-TRg-1":14818,
"PWP2g2_BC2-RHO1-NRg-2":14819,
"PWP2g2_BC2-RHO1-NRg-1":14820,
"PWP2g2_BC2-CDC55-NRg-2":14821,
"PWP2g2_BC2-IDI1-NRg-7":14822,
"PWP2g2_BC2-RPL32-TRg-5":14823,
"PWP2g2_BC2-RPB5-TRg-4":14824,
"PWP2g2_BC2-DIP2-TRg-5":14825,
"PWP2g2_BC2-DIP2-TRg-1":14826,
"PWP2g2_BC2-RPC40-TRg-2":14827,
"PWP2g2_BC2-CDC6-TRg-5":14828,
"PWP2g2_BC2-CDC6-TRg-3":14829,
"PWP2g2_BC2-DAD2-TRg-2":14830,
"PWP2g2_BC2-RVS161-TRg-2":14831,
"PWP2g2_BC2-RVS161-TRg-1":14832,
"PWP2g2_BC2-SUP45-NRg-3":14833,
"PWP2g2_BC2-SRB6-NRg-5":14834,
"PWP2g2_BC2-RPC11-TRg-4":14835,
"PWP2g2_BC2-RKI1-TRg-8":14836,
"PWP2g2_BC2-NIP7-TRg-3":14837,
"PWP2g2_BC2-RPL33A-NRg-12":14838,
"PWP2g2_BC2-SAM50-TRg-4":14839,
"PWP2g2_BC2-NOP4-NRg-1":14840,
"PWP2g2_BC2-NOP4-NRg-3":14841,
"PWP2g2_BC2-SMX2-TRg-5":14842,
"PWP2g2_BC2-POL12-NRg-2":14843,
"PWP2g2_BC2-BMS1-NRg-2":14844,
"PWP2g2_BC2-RPA190-TRg-5":14845,
"PWP2g2_BC2-ALG14-NRg-4":14846,
"PWP2g2_BC2-ALG14-NRg-1":14847,
"PWP2g2_BC2-PRE5-NRg-1":14848,
"PWP2g2_BC2-BIG1-NRg-2":14849,
"PWP2g2_BC2-TFA2-TRg-4":14850,
"PWP2g2_BC2-IMP4-TRg-6":14851,
"PWP2g2_BC2-PAN1-NRg-1":14852,
"PWP2g2_BC2-UTP13-TRg-2":14853,
"PWP2g2_BC2-KAE1-NRg-3":14854,
"PWP2g2_BC2-ERG20-TRg-1":14855,
"PWP2g2_BC2-CDC20-TRg-6":14856,
"PWP2g2_BC2-PWP2-NRg-2":14857,
"PWP2g2_BC2-COG1-NRg-1":14858,
"PWP2g2_BC2-RPL1B-TRg-4":14859,
"PWP2g2_BC2-RPL1B-TRg-7":14860,
"PWP2g2_BC2-UTP20-TRg-3":14861,
"PWP2g2_BC2-UTP20-TRg-4":14862,
"PWP2g2_BC2-RPL25-TRg-4":14863,
"PWP2g2_BC2-RPL25-TRg-2":14864,
"PWP2g2_BC2-MCM7-NRg-1":14865,
"PWP2g2_BC2-MRP49-TRg-5":14866,
"PWP2g2_BC2-ERO1-NRg-3":14867,
"PWP2g2_BC2-UTP5-TRg-7":14868,
"PWP2g2_BC2-MCM4-NRg-1":14869,
"PWP2g2_BC2-PRE3-NRg-1":14870,
"PWP2g2_BC2-FCF1-NRg-1":14871,
"PWP2g2_BC2-CUS1-NRg-1":14872,
"PWP2g2_BC2-PSF1-TRg-2":14873,
"PWP2g2_BC2-BCP1-TRg-2":14874,
"PWP2g2_BC2-PAN1-TRg-1":14875,
"PWP2g2_BC2-PAN1-TRg-3":14876,
"PWP2g2_BC2-PAN1-TRg-4":14877,
"PWP2g2_BC2-VPS3-TRg-2":14878,
"PWP2g2_BC2-YIL060W-NRg-1":14879,
"PWP2g2_BC2-VPS53-NRg-1":14880,
"PWP2g2_BC2-CYR1-TRg-4":14881,
"PWP2g2_BC2-CYR1-TRg-7":14882,
"PWP2g2_BC2-MPS1-NRg-1":14883,
"PWP2g2_BC2-SRP1-TRg-5":14884,
"PWP2g2_BC2-SRP1-TRg-4":14885,
"PWP2g2_BC2-TAF12-TRg-2":14886,
"PWP2g2_BC2-TAF12-TRg-3":14887,
"PWP2g2_BC2-POP4-TRg-1":14888,
"PWP2g2_BC2-SPT16-TRg-1":14889,
"PWP2g2_BC2-NUP82-TRg-4":14890,
"PWP2g2_BC2-DML1-TRg-3":14891,
"PWP2g2_BC2-RPA43-NRg-3":14892,
"PWP2g2_BC2-STU2-NRg-3":14893,
"PWP2g2_BC2-POP4-NRg-4":14894,
"PWP2g2_BC2-MCD1-TRg-2":14895,
"PWP2g2_BC2-RPS3-NRg-4":14896,
"PWP2g2_BC2-PRP9-TRg-4":14897,
"PWP2g2_BC2-RPP1-NRg-2":14898,
"PWP2g2_BC2-MTR2-NRg-11":14899,
"PWP2g2_BC2-GCD11-TRg-1":14900,
"PWP2g2_BC2-RPF1-TRg-3":14901,
"PWP2g2_BC2-SUB2-NRg-4":14902,
"PWP2g2_BC2-GPI15-TRg-3":14903,
"PWP2g2_BC2-ERG9-TRg-6":14904,
"PWP2g2_BC2-RPT2-NRg-1":14905,
"PWP2g2_BC2-YOS1-NRg-3":14906,
"PWP2g2_BC2-SCM3-TRg-4":14907,
"PWP2g2_BC2-SCM3-TRg-6":14908,
"PWP2g2_BC2-RLP7-NRg-1":14909,
"PWP2g2_BC2-TFB2-NRg-4":14910,
"PWP2g2_BC2-IMP4-TRg-1":14911,
"PWP2g2_BC2-IMP4-TRg-3":14912,
"PWP2g2_BC2-PRE4-TRg-3":14913,
"PWP2g2_BC2-SUB2-TRg-3":14914,
"PWP2g2_BC2-RPP0-NRg-4":14915,
"PWP2g2_BC2-RPP0-NRg-3":14916,
"PWP2g2_BC2-TOM40-TRg-4":14917,
"PWP2g2_BC2-FUR1-NRg-12":14918,
"PWP2g2_BC2-TOM40-TRg-2":14919,
"PWP2g2_BC2-VMA11-NRg-4":14920,
"PWP2g2_BC2-PGS1-NRg-4":14921,
"PWP2g2_BC2-URB1-TRg-4":14922,
"PWP2g2_BC2-ARP4-TRg-3":14923,
"PWP2g2_BC2-RPT3-TRg-3":14924,
"PWP2g2_BC2-SUI3-TRg-3":14925,
"PWP2g2_BC2-RFC5-NRg-2":14926,
"PWP2g2_BC2-RRP14-TRg-2":14927,
"PWP2g2_BC2-SCC2-TRg-1":14928,
"PWP2g2_BC2-SSC1-TRg-3":14929,
"PWP2g2_BC2-RRP9-TRg-3":14930,
"PWP2g2_BC2-MOT1-NRg-9":14931,
"PWP2g2_BC2-RPL42A-NRg-2":14932,
"PWP2g2_BC2-SEC16-TRg-7":14933,
"PWP2g2_BC2-IMP4-NRg-2":14934,
"PWP2g2_BC2-YEF3-NRg-4":14935,
"PWP2g2_BC2-PUP1-TRg-1":14936,
"PWP2g2_BC2-UTP22-TRg-6":14937,
"PWP2g2_BC2-DBP2-NRg-4":14938,
"PWP2g2_BC2-PRE2-TRg-7":14939,
"PWP2g2_BC2-ATP16-TRg-6":14940,
"PWP2g2_BC2-UTP13-TRg-4":14941,
"PWP2g2_BC2-DOP1-NRg-4":14942,
"PWP2g2_BC2-TIM44-TRg-3":14943,
"PWP2g2_BC2-ATP16-TRg-2":14944,
"PWP2g2_BC2-ENP1-NRg-3":14945,
"PWP2g2_BC2-NAF1-TRg-3":14946,
"PWP2g2_BC2-COG4-TRg-2":14947,
"PWP2g2_BC2-SOG2-TRg-7":14948,
"PWP2g2_BC2-YDR341C-TRg-3":14949,
"PWP2g2_BC2-YMR290W-A-TRg-10":14950,
"PWP2g2_BC2-NUP192-NRg-9":14951,
"PWP2g2_BC2-RPS31-NRg-8":14952,
"PWP2g2_BC2-SPC97-NRg-6":14953,
"PWP2g2_BC2-EBP2-NRg-1":14954,
"PWP2g2_BC2-CDC48-TRg-5":14955,
"PWP2g2_BC2-RPT1-TRg-4":14956,
"PWP2g2_BC2-ULP1-NRg-2":14957,
"PWP2g2_BC2-RPN3-TRg-6":14958,
"PWP2g2_BC2-RPT1-TRg-5":14959,
"PWP2g2_BC2-KRE5-TRg-2":14960,
"PWP2g2_BC2-TBF1-NRg-8":14961,
"PWP2g2_BC2-UTP22-NRg-4":14962,
"PWP2g2_BC2-SSC1-NRg-4":14963,
"PWP2g2_BC2-REB1-TRg-4":14964,
"PWP2g2_BC2-CDC48-NRg-9":14965,
"PWP2g2_BC2-FAS2-TRg-8":14966,
"PWP2g2_BC2-TAO3-TRg-8":14967,
"PWP2g2_BC2-CKS1-TRg-5":14968,
"PWP2g2_BC2-YLR379W-TRg-7":14969,
"PWP2g2_BC2-TEN1-NRg-2":14970,
"PWP2g2_BC2-RPL42A-TRg-2":14971,
"PWP2g2_BC2-SEC27-TRg-4":14972,
"PWP2g2_BC2-TBF1-NRg-4":14973,
"PWP2g2_BC2-RPT1-NRg-6":14974,
"PWP2g2_BC2-COG1-TRg-3":14975,
"PWP2g2_BC2-SUI1-TRg-6":14976,
"PWP2g2_BC2-TIM23-TRg-6":14977,
"PWP2g2_BC2-CDC48-NRg-6":14978,
"PWP2g2_BC2-EPL1-TRg-5":14979,
"PWP2g2_BC2-RPT5-TRg-8":14980,
"PWP2g2_BC2-ATP16-NRg-4":14981,
"PWP2g2_BC2-RPN6-TRg-3":14982,
"PWP2g2_BC2-ERG9-NRg-6":14983,
"PWP2g2_BC2-SMX3-TRg-1":14984,
"PWP2g2_BC2-NCB2-NRg-3":14985,
"PWP2g2_BC2-SEC16-NRg-12":14986,
"PWP2g2_BC2-RPN6-TRg-2":14987,
"PWP2g2_BC2-REB1-NRg-4":14988,
"PWP2g2_BC2-ATP16-TRg-9":14989,
"PWP2g2_BC2-ERG9-NRg-7":14990,
"TIF6g8-RPL15A-NRg-4":14991,
"TIF6g8-RPL15A-NRg-5":14992,
"TIF6g8-KRE33-TRg-1":14993,
"TIF6g8-PMI40-NRg-1":14994,
"TIF6g8-NOP19-NRg-3":14995,
"TIF6g8-SRP14-NRg-4":14996,
"TIF6g8-SEC27-TRg-2":14997,
"TIF6g8-GPI14-TRg-3":14998,
"TIF6g8-PAH1-TRg-7":14999,
"TIF6g8-PAH1-TRg-6":15000,
"TIF6g8-PAH1-TRg-5":15001,
"TIF6g8-PAH1-TRg-3":15002,
"TIF6g8-COG3-TRg-1":15003,
"TIF6g8-HTS1-NRg-5":15004,
"TIF6g8-MSN5-TRg-7":15005,
"TIF6g8-ERG26-TRg-1":15006,
"TIF6g8-SMD2-TRg-5":15007,
"TIF6g8-SMD2-TRg-4":15008,
"TIF6g8-SMD2-TRg-1":15009,
"TIF6g8-PRE7-TRg-4":15010,
"TIF6g8-PRE7-TRg-7":15011,
"TIF6g8-SEC6-TRg-3":15012,
"TIF6g8-ESF2-NRg-1":15013,
"TIF6g8-ESF2-NRg-3":15014,
"TIF6g8-AFG2-TRg-2":15015,
"TIF6g8-RRP36-TRg-3":15016,
"TIF6g8-RRP36-TRg-5":15017,
"TIF6g8-GCR1-NRg-2":15018,
"TIF6g8-PRE4-NRg-4":15019,
"TIF6g8-PRE4-NRg-9":15020,
"TIF6g8-DSN1-NRg-2":15021,
"TIF6g8-GPI11-TRg-3":15022,
"TIF6g8-POP3-TRg-1":15023,
"TIF6g8-MNE1-TRg-5":15024,
"TIF6g8-RRP12-NRg-1":15025,
"TIF6g8-RSC6-TRg-2":15026,
"TIF6g8-CDC25-TRg-1":15027,
"TIF6g8-CDC25-TRg-9":15028,
"TIF6g8-YPP1-NRg-3":15029,
"TIF6g8-NFS1-NRg-9":15030,
"TIF6g8-NFS1-NRg-8":15031,
"TIF6g8-UBA2-TRg-1":15032,
"TIF6g8-ARP2-NRg-3":15033,
"TIF6g8-MAK16-TRg-1":15034,
"TIF6g8-CEP3-NRg-1":15035,
"TIF6g8-GUK1-TRg-5":15036,
"TIF6g8-GUK1-TRg-2":15037,
"TIF6g8-GPI12-NRg-6":15038,
"TIF6g8-RPS5-NRg-5":15039,
"TIF6g8-RPS5-NRg-2":15040,
"TIF6g8-RPC19-NRg-1":15041,
"TIF6g8-TIM54-TRg-1":15042,
"TIF6g8-TEN1-TRg-2":15043,
"TIF6g8-SAH1-NRg-4":15044,
"TIF6g8-SAH1-NRg-5":15045,
"TIF6g8-SAH1-NRg-3":15046,
"TIF6g8-ATP15-NRg-5":15047,
"TIF6g8-SCD5-TRg-5":15048,
"TIF6g8-ARB1-NRg-2":15049,
"TIF6g8-ARB1-NRg-4":15050,
"TIF6g8-PUP2-TRg-1":15051,
"TIF6g8-CCT8-TRg-2":15052,
"TIF6g8-MCM4-TRg-1":15053,
"TIF6g8-LSM4-TRg-1":15054,
"TIF6g8-NOP53-NRg-1":15055,
"TIF6g8-ATP3-TRg-4":15056,
"TIF6g8-AFG2-NRg-3":15057,
"TIF6g8-PRO3-NRg-3":15058,
"TIF6g8-NRD1-NRg-10":15059,
"TIF6g8-SEC61-TRg-2":15060,
"TIF6g8-RHO3-TRg-4":15061,
"TIF6g8-SNF2-TRg-6":15062,
"TIF6g8-SMD2-NRg-3":15063,
"TIF6g8-RSC4-TRg-2":15064,
"TIF6g8-RSC4-TRg-1":15065,
"TIF6g8-TIF34-TRg-2":15066,
"TIF6g8-BET1-NRg-1":15067,
"TIF6g8-CDC8-NRg-2":15068,
"TIF6g8-PRP42-TRg-2":15069,
"TIF6g8-RRB1-TRg-2":15070,
"TIF6g8-SPC24-TRg-1":15071,
"TIF6g8-ILS1-NRg-1":15072,
"TIF6g8-GFA1-TRg-2":15073,
"TIF6g8-SEC21-NRg-10":15074,
"TIF6g8-RPC10-NRg-1":15075,
"TIF6g8-RPB10-TRg-3":15076,
"TIF6g8-RPB10-TRg-2":15077,
"TIF6g8-YNL181W-TRg-1":15078,
"TIF6g8-RAD3-NRg-1":15079,
"TIF6g8-NOP10-TRg-1":15080,
"TIF6g8-BFR2-TRg-3":15081,
"TIF6g8-MCM2-TRg-6":15082,
"TIF6g8-MCM2-TRg-4":15083,
"TIF6g8-MPP10-TRg-1":15084,
"TIF6g8-RET2-TRg-4":15085,
"TIF6g8-RET2-TRg-1":15086,
"TIF6g8-RPS2-NRg-1":15087,
"TIF6g8-RPS2-NRg-2":15088,
"TIF6g8-ORC4-NRg-3":15089,
"TIF6g8-TIP20-TRg-7":15090,
"TIF6g8-SMT3-TRg-1":15091,
"TIF6g8-MSS18-NRg-6":15092,
"TIF6g8-YEF3-NRg-9":15093,
"TIF6g8-ASK1-NRg-1":15094,
"TIF6g8-SMC1-TRg-1":15095,
"TIF6g8-NIP1-NRg-1":15096,
"TIF6g8-RPP1-NRg-1":15097,
"TIF6g8-YDJ1-TRg-6":15098,
"TIF6g8-SUB2-NRg-1":15099,
"TIF6g8-TIM10-NRg-8":15100,
"TIF6g8-TIM10-NRg-4":15101,
"TIF6g8-TIM10-NRg-7":15102,
"TIF6g8-SKI6-TRg-4":15103,
"TIF6g8-TUB4-TRg-1":15104,
"TIF6g8-CDC37-NRg-2":15105,
"TIF6g8-ISD11-TRg-3":15106,
"TIF6g8-YOS1-TRg-4":15107,
"TIF6g8-SSC1-TRg-6":15108,
"TIF6g8-MTR3-TRg-5":15109,
"TIF6g8-MTR3-TRg-6":15110,
"TIF6g8-TFA1-TRg-2":15111,
"TIF6g8-CDC3-NRg-3":15112,
"TIF6g8-ERG25-TA-18":15113,
"TIF6g8-RPB11-TRg-4":15114,
"TIF6g8-RPB11-TRg-1":15115,
"TIF6g8-RPB11-TRg-2":15116,
"TIF6g8-DED1-TRg-3":15117,
"TIF6g8-DED1-TRg-1":15118,
"TIF6g8-DED1-TRg-6":15119,
"TIF6g8-DED1-TRg-4":15120,
"TIF6g8-RPL10-NRg-5":15121,
"TIF6g8-RPL10-NRg-4":15122,
"TIF6g8-EFB1-NRg-1":15123,
"TIF6g8-EFB1-NRg-5":15124,
"TIF6g8-EFB1-NRg-4":15125,
"TIF6g8-RPT3-NRg-1":15126,
"TIF6g8-SAC6-TRg-8":15127,
"TIF6g8-SAC6-TRg-4":15128,
"TIF6g8-SAC6-TRg-5":15129,
"TIF6g8-SAC6-TRg-3":15130,
"TIF6g8-DIM1-TRg-5":15131,
"TIF6g8-DIM1-TRg-7":15132,
"TIF6g8-RPC17-NRg-1":15133,
"TIF6g8-RPC17-NRg-2":15134,
"TIF6g8-YDR341C-TRg-1":15135,
"TIF6g8-RAP1-NRg-8":15136,
"TIF6g8-RAP1-NRg-5":15137,
"TIF6g8-RAP1-NRg-2":15138,
"TIF6g8-SEC26-NRg-3":15139,
"TIF6g8-SPP41-TRg-3":15140,
"TIF6g8-TAP42-NRg-1":15141,
"TIF6g8-PGA2-TRg-6":15142,
"TIF6g8-BRL1-TRg-1":15143,
"TIF6g8-FOL2-TRg-1":15144,
"TIF6g8-NAB3-NRg-5":15145,
"TIF6g8-SNF4-TRg-4":15146,
"TIF6g8-HRR25-TRg-2":15147,
"TIF6g8-TRS23-TRg-4":15148,
"TIF6g8-CTR86-TRg-4":15149,
"TIF6g8-RPB5-TRg-5":15150,
"TIF6g8-SPN1-NRg-2":15151,
"TIF6g8-SPN1-NRg-1":15152,
"TIF6g8-SEC61-NRg-1":15153,
"TIF6g8-SEC61-NRg-7":15154,
"TIF6g8-TUS1-TRg-3":15155,
"TIF6g8-OLE1-NRg-2":15156,
"TIF6g8-AFG2-TRg-1":15157,
"TIF6g8-TOA2-NRg-1":15158,
"TIF6g8-USO1-TRg-1":15159,
"TIF6g8-UTP22-NRg-2":15160,
"TIF6g8-RIB1-TRg-3":15161,
"TIF6g8-RIB1-TRg-7":15162,
"TIF6g8-RIB1-TRg-4":15163,
"TIF6g8-COG1-TRg-1":15164,
"TIF6g8-RPL32-NRg-2":15165,
"TIF6g8-GLC7-NRg-3":15166,
"TIF6g8-GLC7-NRg-4":15167,
"TIF6g8-HSF1-TRg-2":15168,
"TIF6g8-DAM1-NRg-5":15169,
"TIF6g8-SEC18-TRg-4":15170,
"TIF6g8-SEC18-TRg-5":15171,
"TIF6g8-PAB1-NRg-3":15172,
"TIF6g8-POP8-TRg-2":15173,
"TIF6g8-PAB1-NRg-4":15174,
"TIF6g8-BIG1-TRg-4":15175,
"TIF6g8-BIG1-TRg-5":15176,
"TIF6g8-BIG1-TRg-6":15177,
"TIF6g8-RPO41-NRg-1":15178,
"TIF6g8-RVB2-NRg-2":15179,
"TIF6g8-PET117-NRg-8":15180,
"TIF6g8-VPS45-NRg-9":15181,
"TIF6g8-YCG1-NRg-1":15182,
"TIF6g8-NOC4-NRg-1":15183,
"TIF6g8-NMD3-NRg-2":15184,
"TIF6g8-DRS1-TRg-2":15185,
"TIF6g8-HTB1-NRg-2":15186,
"TIF6g8-IPI1-TRg-2":15187,
"TIF6g8-SEC18-NRg-1":15188,
"TIF6g8-SEC18-NRg-2":15189,
"TIF6g8-JIP5-NRg-2":15190,
"TIF6g8-YPT1-TRg-3":15191,
"TIF6g8-YPT1-TRg-2":15192,
"TIF6g8-CLF1-NRg-2":15193,
"TIF6g8-SNF2-NRg-7":15194,
"TIF6g8-SNF2-NRg-4":15195,
"TIF6g8-RPL25-NRg-1":15196,
"TIF6g8-NOP56-TRg-1":15197,
"TIF6g8-NOP56-TRg-2":15198,
"TIF6g8-TRS31-TRg-1":15199,
"TIF6g8-DBF4-TRg-2":15200,
"TIF6g8-DBF4-TRg-1":15201,
"TIF6g8-RPC19-TRg-4":15202,
"TIF6g8-RPC19-TRg-6":15203,
"TIF6g8-RPC19-TRg-3":15204,
"TIF6g8-ROK1-NRg-1":15205,
"TIF6g8-CDC33-TRg-4":15206,
"TIF6g8-DHR2-TRg-3":15207,
"TIF6g8-RRP42-NRg-5":15208,
"TIF6g8-CLF1-TRg-1":15209,
"TIF6g8-ERG11-NA-16":15210,
"TIF6g8-VAS1-NRg-4":15211,
"TIF6g8-PIK1-NRg-2":15212,
"TIF6g8-SAR1-NRg-7":15213,
"TIF6g8-SAR1-NRg-4":15214,
"TIF6g8-RPS3-TRg-1":15215,
"TIF6g8-YTM1-TRg-2":15216,
"TIF6g8-SUI3-NRg-5":15217,
"TIF6g8-SUI3-NRg-2":15218,
"TIF6g8-RRP7-TRg-4":15219,
"TIF6g8-RRP7-TRg-6":15220,
"TIF6g8-NIP7-TRg-2":15221,
"TIF6g8-MDM35-TRg-1":15222,
"TIF6g8-ALA1-NRg-1":15223,
"TIF6g8-DOA4-NRg-2":15224,
"TIF6g8-RPS13-NRg-1":15225,
"TIF6g8-YSF3-TRg-2":15226,
"TIF6g8-RPS2-NRg-11":15227,
"TIF6g8-SSL1-TRg-10":15228,
"TIF6g8-NIP7-TRg-1":15229,
"TIF6g8-LST8-NRg-1":15230,
"TIF6g8-TAF4-TRg-3":15231,
"TIF6g8-HAS1-TRg-2":15232,
"TIF6g8-GLC7-TRg-2":15233,
"TIF6g8-CDC45-NRg-1":15234,
"TIF6g8-SEC22-NRg-8":15235,
"TIF6g8-YOS1-TRg-2":15236,
"TIF6g8-RBA50-TRg-3":15237,
"TIF6g8-SPP41-NRg-2":15238,
"TIF6g8-PRP46-TRg-2":15239,
"TIF6g8-PGA2-NRg-1":15240,
"TIF6g8-CBF5-TRg-3":15241,
"TIF6g8-TCP1-NRg-3":15242,
"TIF6g8-TCP1-NRg-2":15243,
"TIF6g8-ERG26-NRg-2":15244,
"TIF6g8-ERG26-NRg-4":15245,
"TIF6g8-MES1-TRg-5":15246,
"TIF6g8-HTS1-TRg-2":15247,
"TIF6g8-SSS1-TRg-3":15248,
"TIF6g8-SSS1-TRg-2":15249,
"TIF6g8-SYS1-TRg-7":15250,
"TIF6g8-SYS1-TRg-2":15251,
"TIF6g8-SYS1-TRg-1":15252,
"TIF6g8-BFR2-TRg-1":15253,
"TIF6g8-EOS1-TRg-3":15254,
"TIF6g8-TAF4-NRg-1":15255,
"TIF6g8-ARL3-NRg-8":15256,
"TIF6g8-RPN5-NRg-1":15257,
"TIF6g8-TIM9-NRg-2":15258,
"TIF6g8-NUP57-NRg-3":15259,
"TIF6g8-VPS4-TRg-1":15260,
"TIF6g8-CDC3-TRg-4":15261,
"TIF6g8-BBP1-NRg-1":15262,
"TIF6g8-BBP1-NRg-2":15263,
"TIF6g8-USE1-NRg-3":15264,
"TIF6g8-CCT7-TRg-1":15265,
"TIF6g8-SAH1-TRg-3":15266,
"TIF6g8-CHS2-TRg-1":15267,
"TIF6g8-DPM1-TRg-2":15268,
"TIF6g8-BBP1-TRg-1":15269,
"TIF6g8-NRD1-TRg-4":15270,
"TIF6g8-RPB3-NRg-1":15271,
"TIF6g8-PHO85-NRg-6":15272,
"TIF6g8-SNF6-TRg-6":15273,
"TIF6g8-PRP38-NRg-2":15274,
"TIF6g8-OAR1-NRg-3":15275,
"TIF6g8-ROX3-NRg-1":15276,
"TIF6g8-YPP1-TRg-6":15277,
"TIF6g8-CBF2-NRg-8":15278,
"TIF6g8-SPT6-TRg-5":15279,
"TIF6g8-SEC10-NRg-1":15280,
"TIF6g8-NSL1-NRg-3":15281,
"TIF6g8-NRD1-NRg-8":15282,
"TIF6g8-RPB3-TRg-1":15283,
"TIF6g8-NRD1-NRg-4":15284,
"TIF6g8-RVB1-TRg-2":15285,
"TIF6g8-TIF5-NRg-8":15286,
"TIF6g8-EOS1-NRg-1":15287,
"TIF6g8-ERG25-NA-26":15288,
"TIF6g8-MSL5-NRg-4":15289,
"TIF6g8-SEC24-TRg-2":15290,
"TIF6g8-RPL30-NRg-5":15291,
"TIF6g8-SNU71-NRg-3":15292,
"TIF6g8-CDC33-NRg-1":15293,
"TIF6g8-RPN6-TRg-4":15294,
"TIF6g8-NAB2-TRg-4":15295,
"TIF6g8-NAB2-TRg-6":15296,
"TIF6g8-YTM1-NRg-1":15297,
"TIF6g8-OLE1-TRg-8":15298,
"TIF6g8-OLE1-TRg-1":15299,
"TIF6g8-UTP7-TRg-4":15300,
"TIF6g8-ACT1-NRg-6":15301,
"TIF6g8-RPL18A-NRg-3":15302,
"TIF6g8-BRX1-NRg-1":15303,
"TIF6g8-NAF1-TRg-8":15304,
"TIF6g8-NAF1-TRg-6":15305,
"TIF6g8-NAF1-TRg-4":15306,
"TIF6g8-CDC8-TRg-2":15307,
"TIF6g8-NSE4-TRg-1":15308,
"TIF6g8-PAB1-NRg-2":15309,
"TIF6g8-PRP43-TRg-4":15310,
"TIF6g8-SEC2-NRg-3":15311,
"TIF6g8-SEC2-NRg-6":15312,
"TIF6g8-MPP10-NRg-5":15313,
"TIF6g8-YDR355C-TRg-2":15314,
"TIF6g8-YLR339C-TRg-9":15315,
"TIF6g8-SNM1-TRg-2":15316,
"TIF6g8-ALR1-NRg-4":15317,
"TIF6g8-ALR1-NRg-1":15318,
"TIF6g8-ALR1-NRg-3":15319,
"TIF6g8-RPL10-TRg-1":15320,
"TIF6g8-RPL28-TRg-2":15321,
"TIF6g8-UTP25-TRg-1":15322,
"TIF6g8-POB3-TRg-1":15323,
"TIF6g8-POB3-TRg-3":15324,
"TIF6g8-POB3-TRg-2":15325,
"TIF6g8-MED11-TRg-1":15326,
"TIF6g8-ISA1-TRg-15":15327,
"TIF6g8-RRP1-NRg-1":15328,
"TIF6g8-MES1-NRg-1":15329,
"TIF6g8-SEC13-NRg-5":15330,
"TIF6g8-MCM2-NRg-2":15331,
"TIF6g8-ALA1-TRg-4":15332,
"TIF6g8-MTG2-TRg-5":15333,
"TIF6g8-TIF35-NRg-3":15334,
"TIF6g8-NSE1-TRg-3":15335,
"TIF6g8-NSE1-TRg-4":15336,
"TIF6g8-MOB2-NRg-6":15337,
"TIF6g8-VRG4-NRg-3":15338,
"TIF6g8-PRP9-TRg-3":15339,
"TIF6g8-HYM1-TRg-5":15340,
"TIF6g8-POP1-TRg-5":15341,
"TIF6g8-POP1-TRg-9":15342,
"TIF6g8-RPL17A-TRg-1":15343,
"TIF6g8-SLD2-TRg-1":15344,
"TIF6g8-CDC48-NRg-7":15345,
"TIF6g8-FHL1-NRg-2":15346,
"TIF6g8-BET3-NRg-7":15347,
"TIF6g8-MAK21-TRg-1":15348,
"TIF6g8-BRN1-TRg-4":15349,
"TIF6g8-FBA1-NRg-3":15350,
"TIF6g8-CDC42-TRg-6":15351,
"TIF6g8-CDC42-TRg-7":15352,
"TIF6g8-COG4-NRg-1":15353,
"TIF6g8-ATP3-NRg-3":15354,
"TIF6g8-ATP3-NRg-2":15355,
"TIF6g8-SMP3-TRg-5":15356,
"TIF6g8-CFT2-NRg-2":15357,
"TIF6g8-FAS2-TRg-5":15358,
"TIF6g8-DBP2-NRg-3":15359,
"TIF6g8-DBP2-NRg-2":15360,
"TIF6g8-MPS2-NRg-4":15361,
"TIF6g8-ARC35-TRg-2":15362,
"TIF6g8-ARC35-TRg-5":15363,
"TIF6g8-MRD1-TRg-1":15364,
"TIF6g8-RLP7-TRg-1":15365,
"TIF6g8-SPC34-TRg-1":15366,
"TIF6g8-CDC45-TRg-2":15367,
"TIF6g8-GCD6-TRg-3":15368,
"TIF6g8-GCD6-TRg-4":15369,
"TIF6g8-YPT6-NRg-2":15370,
"TIF6g8-RPS13-TRg-2":15371,
"TIF6g8-IPI3-TRg-3":15372,
"TIF6g8-TIF5-NRg-9":15373,
"TIF6g8-TIF5-NRg-7":15374,
"TIF6g8-TIF5-NRg-6":15375,
"TIF6g8-NAB3-TRg-3":15376,
"TIF6g8-GCD2-TRg-1":15377,
"TIF6g8-UBA1-TRg-2":15378,
"TIF6g8-SLD3-TRg-6":15379,
"TIF6g8-LCB1-TRg-5":15380,
"TIF6g8-TOA2-TRg-6":15381,
"TIF6g8-TOA2-TRg-1":15382,
"TIF6g8-TOA2-TRg-3":15383,
"TIF6g8-LSM2-TRg-1":15384,
"TIF6g8-YML6-TRg-13":15385,
"TIF6g8-YML6-TRg-12":15386,
"TIF6g8-UTP15-NRg-1":15387,
"TIF6g8-TIF6-NRg-8":15388,
"TIF6g8-SUP35-NRg-1":15389,
"TIF6g8-MPP10-NRg-1":15390,
"TIF6g8-SWI3-TRg-7":15391,
"TIF6g8-SSN3-NRg-2":15392,
"TIF6g8-SEC13-NRg-7":15393,
"TIF6g8-RPS15-NRg-3":15394,
"TIF6g8-RPL3-TRg-2":15395,
"TIF6g8-FBA1-NRg-2":15396,
"TIF6g8-FBA1-NRg-1":15397,
"TIF6g8-FBA1-NRg-5":15398,
"TIF6g8-DAM1-TRg-2":15399,
"TIF6g8-NHP2-TRg-2":15400,
"TIF6g8-HCA4-NRg-6":15401,
"TIF6g8-PRE3-TRg-4":15402,
"TIF6g8-DBP5-NRg-4":15403,
"TIF6g8-SPT6-NRg-4":15404,
"TIF6g8-SPT6-NRg-2":15405,
"TIF6g8-RPL18A-TRg-4":15406,
"TIF6g8-KSH1-TRg-1":15407,
"TIF6g8-KSH1-TRg-3":15408,
"TIF6g8-IPI3-NRg-1":15409,
"TIF6g8-PGA2-TRg-8":15410,
"TIF6g8-RPL18A-TRg-2":15411,
"TIF6g8-RPL33A-NRg-6":15412,
"TIF6g8-TAF12-NRg-2":15413,
"TIF6g8-USE1-TRg-5":15414,
"TIF6g8-YNL114C-TRg-1":15415,
"TIF6g8-SMC5-TRg-7":15416,
"TIF6g8-SMC5-TRg-6":15417,
"TIF6g8-RSC58-TRg-1":15418,
"TIF6g8-CTF13-TRg-2":15419,
"TIF6g8-NAB2-NRg-2":15420,
"TIF6g8-MCM7-TRg-4":15421,
"TIF6g8-BCP1-NRg-5":15422,
"TIF6g8-STU2-TRg-3":15423,
"TIF6g8-SEC21-NRg-6":15424,
"TIF6g8-SEC21-NRg-3":15425,
"TIF6g8-RPL1B-TRg-3":15426,
"TIF6g8-SEC20-NRg-2":15427,
"TIF6g8-VMA3-NRg-2":15428,
"TIF6g8-SEC23-NRg-5":15429,
"TIF6g8-CDC28-TRg-4":15430,
"TIF6g8-RPN12-NRg-11":15431,
"TIF6g8-PUP3-TRg-3":15432,
"TIF6g8-SEC31-TRg-2":15433,
"TIF6g8-SED5-TRg-6":15434,
"TIF6g8-SED5-TRg-5":15435,
"TIF6g8-RPL33A-TRg-1":15436,
"TIF6g8-RPL33A-TRg-2":15437,
"TIF6g8-MRPL11-TRg-2":15438,
"TIF6g8-RTP1-NRg-2":15439,
"TIF6g8-NUG1-TRg-2":15440,
"TIF6g8-VPH2-TRg-4":15441,
"TIF6g8-COP1-NRg-3":15442,
"TIF6g8-CRM1-NRg-1":15443,
"TIF6g8-RPL5-NRg-4":15444,
"TIF6g8-SNU13-NRg-4":15445,
"TIF6g8-PFS2-TRg-3":15446,
"TIF6g8-MPP10-TRg-2":15447,
"TIF6g8-TSR4-NRg-2":15448,
"TIF6g8-RSC2-TRg-1":15449,
"TIF6g8-SEC65-TRg-2":15450,
"TIF6g8-SMI1-NRg-1":15451,
"TIF6g8-RTT105-NRg-4":15452,
"TIF6g8-VMA5-TRg-3":15453,
"TIF6g8-VMA5-TRg-5":15454,
"TIF6g8-RRP1-TRg-3":15455,
"TIF6g8-CLC1-TRg-2":15456,
"TIF6g8-GCD6-NRg-1":15457,
"TIF6g8-GCD6-NRg-2":15458,
"TIF6g8-PXR1-TRg-1":15459,
"TIF6g8-CDC14-NRg-1":15460,
"TIF6g8-PCF11-TRg-6":15461,
"TIF6g8-PCF11-TRg-5":15462,
"TIF6g8-PCF11-TRg-4":15463,
"TIF6g8-SEC31-NRg-1":15464,
"TIF6g8-RRP5-NRg-1":15465,
"TIF6g8-PRE10-TRg-5":15466,
"TIF6g8-PRE10-TRg-1":15467,
"TIF6g8-RPS5-TRg-2":15468,
"TIF6g8-NSP1-TRg-4":15469,
"TIF6g8-PRP38-TRg-4":15470,
"TIF6g8-RCF1-NRg-5":15471,
"TIF6g8-RSC3-TRg-4":15472,
"TIF6g8-RSC3-TRg-5":15473,
"TIF6g8-RSC3-TRg-6":15474,
"TIF6g8-HTA1-NRg-12":15475,
"TIF6g8-HTA1-NRg-11":15476,
"TIF6g8-UTP23-TRg-2":15477,
"TIF6g8-GCD7-NRg-1":15478,
"TIF6g8-GCD7-NRg-2":15479,
"TIF6g8-GCD7-NRg-6":15480,
"TIF6g8-GAL11-NRg-2":15481,
"TIF6g8-GAL11-NRg-9":15482,
"TIF6g8-PHO4-TRg-5":15483,
"TIF6g8-SNP1-NRg-3":15484,
"TIF6g8-RPC37-TRg-5":15485,
"TIF6g8-CRM1-TRg-5":15486,
"TIF6g8-CRM1-TRg-2":15487,
"TIF6g8-ASK1-TRg-7":15488,
"TIF6g8-STU2-NRg-4":15489,
"TIF6g8-NEO1-NRg-3":15490,
"TIF6g8-GAL11-TRg-5":15491,
"TIF6g8-GAL11-TRg-7":15492,
"TIF6g8-SAM50-NRg-3":15493,
"TIF6g8-CSL4-TRg-2":15494,
"TIF6g8-CCT5-TRg-2":15495,
"TIF6g8-POL30-NRg-1":15496,
"TIF6g8-MED4-TRg-4":15497,
"TIF6g8-MED4-TRg-3":15498,
"TIF6g8-MED4-TRg-2":15499,
"TIF6g8-GDI1-TRg-4":15500,
"TIF6g8-GDI1-TRg-3":15501,
"TIF6g8-REB1-TRg-6":15502,
"TIF6g8-MRPL37-NRg-2":15503,
"TIF6g8-NOC3-TRg-3":15504,
"TIF6g8-SPC97-TRg-3":15505,
"TIF6g8-IPP1-TRg-3":15506,
"TIF6g8-IPP1-TRg-2":15507,
"TIF6g8-PTI1-TRg-3":15508,
"TIF6g8-PTI1-TRg-5":15509,
"TIF6g8-RFC5-NRg-1":15510,
"TIF6g8-CDC24-TRg-1":15511,
"TIF6g8-CDC24-TRg-3":15512,
"TIF6g8-CDC24-TRg-5":15513,
"TIF6g8-CDC24-TRg-6":15514,
"TIF6g8-UTP23-TRg-6":15515,
"TIF6g8-UTP23-TRg-4":15516,
"TIF6g8-UTP23-TRg-1":15517,
"TIF6g8-RHO3-NRg-4":15518,
"TIF6g8-TRS23-NRg-1":15519,
"TIF6g8-TRS23-NRg-3":15520,
"TIF6g8-RSP5-TRg-2":15521,
"TIF6g8-RSP5-TRg-1":15522,
"TIF6g8-SDA1-NRg-1":15523,
"TIF6g8-KAP95-TRg-8":15524,
"TIF6g8-ACO1-TRg-6":15525,
"TIF6g8-HTA1-NRg-3":15526,
"TIF6g8-HTA1-NRg-2":15527,
"TIF6g8-SPN1-TRg-1":15528,
"TIF6g8-MOT1-NRg-7":15529,
"TIF6g8-RPL17A-NRg-4":15530,
"TIF6g8-ADA2-TRg-4":15531,
"TIF6g8-SFH1-NRg-1":15532,
"TIF6g8-SPC97-NRg-5":15533,
"TIF6g8-PRP22-TRg-3":15534,
"TIF6g8-SEN15-TRg-2":15535,
"TIF6g8-RPL3-NRg-2":15536,
"TIF6g8-ISD11-NRg-2":15537,
"TIF6g8-HEM12-TRg-8":15538,
"TIF6g8-SEC10-TRg-1":15539,
"TIF6g8-HTB1-TRg-7":15540,
"TIF6g8-TTI2-TRg-1":15541,
"TIF6g8-ACP1-TRg-2":15542,
"TIF6g8-ACP1-TRg-4":15543,
"TIF6g8-GAL11-NRg-10":15544,
"TIF6g8-UTP22-TRg-2":15545,
"TIF6g8-MST1-NRg-5":15546,
"TIF6g8-RIB7-NRg-2":15547,
"TIF6g8-MCD1-TRg-6":15548,
"TIF6g8-MCD1-TRg-5":15549,
"TIF6g8-GPI8-NRg-2":15550,
"TIF6g8-THS1-TRg-2":15551,
"TIF6g8-RRP7-TRg-2":15552,
"TIF6g8-RRP7-TRg-5":15553,
"TIF6g8-SMX2-NRg-7":15554,
"TIF6g8-RRP45-TRg-5":15555,
"TIF6g8-RRP45-TRg-4":15556,
"TIF6g8-CNS1-TRg-2":15557,
"TIF6g8-FBP1-NRg-9":15558,
"TIF6g8-GCD11-NRg-1":15559,
"TIF6g8-RPL10-TRg-2":15560,
"TIF6g8-NUP192-TRg-4":15561,
"TIF6g8-NUP145-NRg-4":15562,
"TIF6g8-HEM12-TRg-6":15563,
"TIF6g8-PLC1-TRg-3":15564,
"TIF6g8-RPA43-TRg-1":15565,
"TIF6g8-RPB7-NRg-2":15566,
"TIF6g8-RPB7-NRg-3":15567,
"TIF6g8-NSL1-NRg-1":15568,
"TIF6g8-UTP6-TRg-3":15569,
"TIF6g8-UTP6-TRg-1":15570,
"TIF6g8-YJU2-TRg-5":15571,
"TIF6g8-FRS2-NRg-5":15572,
"TIF6g8-TIF35-NRg-2":15573,
"TIF6g8-GPI15-TRg-1":15574,
"TIF6g8-NOP1-NRg-5":15575,
"TIF6g8-GPI15-TRg-4":15576,
"TIF6g8-COG4-TRg-1":15577,
"TIF6g8-TFA1-TRg-1":15578,
"TIF6g8-RHO1-NRg-2":15579,
"TIF6g8-RHO1-NRg-1":15580,
"TIF6g8-CDC55-NRg-2":15581,
"TIF6g8-IDI1-NRg-7":15582,
"TIF6g8-RPL32-TRg-5":15583,
"TIF6g8-RPB5-TRg-4":15584,
"TIF6g8-DIP2-TRg-5":15585,
"TIF6g8-DIP2-TRg-1":15586,
"TIF6g8-RPC40-TRg-2":15587,
"TIF6g8-CDC6-TRg-5":15588,
"TIF6g8-CDC6-TRg-3":15589,
"TIF6g8-DAD2-TRg-2":15590,
"TIF6g8-RVS161-TRg-2":15591,
"TIF6g8-RVS161-TRg-1":15592,
"TIF6g8-SUP45-NRg-3":15593,
"TIF6g8-SRB6-NRg-5":15594,
"TIF6g8-RPC11-TRg-4":15595,
"TIF6g8-RKI1-TRg-8":15596,
"TIF6g8-NIP7-TRg-3":15597,
"TIF6g8-RPL33A-NRg-12":15598,
"TIF6g8-SAM50-TRg-4":15599,
"TIF6g8-NOP4-NRg-1":15600,
"TIF6g8-NOP4-NRg-3":15601,
"TIF6g8-SMX2-TRg-5":15602,
"TIF6g8-POL12-NRg-2":15603,
"TIF6g8-BMS1-NRg-2":15604,
"TIF6g8-RPA190-TRg-5":15605,
"TIF6g8-ALG14-NRg-4":15606,
"TIF6g8-ALG14-NRg-1":15607,
"TIF6g8-PRE5-NRg-1":15608,
"TIF6g8-BIG1-NRg-2":15609,
"TIF6g8-TFA2-TRg-4":15610,
"TIF6g8-IMP4-TRg-6":15611,
"TIF6g8-PAN1-NRg-1":15612,
"TIF6g8-UTP13-TRg-2":15613,
"TIF6g8-KAE1-NRg-3":15614,
"TIF6g8-ERG20-TRg-1":15615,
"TIF6g8-CDC20-TRg-6":15616,
"TIF6g8-PWP2-NRg-2":15617,
"TIF6g8-COG1-NRg-1":15618,
"TIF6g8-RPL1B-TRg-4":15619,
"TIF6g8-RPL1B-TRg-7":15620,
"TIF6g8-UTP20-TRg-3":15621,
"TIF6g8-UTP20-TRg-4":15622,
"TIF6g8-RPL25-TRg-4":15623,
"TIF6g8-RPL25-TRg-2":15624,
"TIF6g8-MCM7-NRg-1":15625,
"TIF6g8-MRP49-TRg-5":15626,
"TIF6g8-ERO1-NRg-3":15627,
"TIF6g8-UTP5-TRg-7":15628,
"TIF6g8-MCM4-NRg-1":15629,
"TIF6g8-PRE3-NRg-1":15630,
"TIF6g8-FCF1-NRg-1":15631,
"TIF6g8-CUS1-NRg-1":15632,
"TIF6g8-PSF1-TRg-2":15633,
"TIF6g8-BCP1-TRg-2":15634,
"TIF6g8-PAN1-TRg-1":15635,
"TIF6g8-PAN1-TRg-3":15636,
"TIF6g8-PAN1-TRg-4":15637,
"TIF6g8-VPS3-TRg-2":15638,
"TIF6g8-YIL060W-NRg-1":15639,
"TIF6g8-VPS53-NRg-1":15640,
"TIF6g8-CYR1-TRg-4":15641,
"TIF6g8-CYR1-TRg-7":15642,
"TIF6g8-MPS1-NRg-1":15643,
"TIF6g8-SRP1-TRg-5":15644,
"TIF6g8-SRP1-TRg-4":15645,
"TIF6g8-TAF12-TRg-2":15646,
"TIF6g8-TAF12-TRg-3":15647,
"TIF6g8-POP4-TRg-1":15648,
"TIF6g8-SPT16-TRg-1":15649,
"TIF6g8-NUP82-TRg-4":15650,
"TIF6g8-DML1-TRg-3":15651,
"TIF6g8-RPA43-NRg-3":15652,
"TIF6g8-STU2-NRg-3":15653,
"TIF6g8-POP4-NRg-4":15654,
"TIF6g8-MCD1-TRg-2":15655,
"TIF6g8-RPS3-NRg-4":15656,
"TIF6g8-PRP9-TRg-4":15657,
"TIF6g8-RPP1-NRg-2":15658,
"TIF6g8-MTR2-NRg-11":15659,
"TIF6g8-GCD11-TRg-1":15660,
"TIF6g8-RPF1-TRg-3":15661,
"TIF6g8-SUB2-NRg-4":15662,
"TIF6g8-GPI15-TRg-3":15663,
"TIF6g8-ERG9-TRg-6":15664,
"TIF6g8-RPT2-NRg-1":15665,
"TIF6g8-YOS1-NRg-3":15666,
"TIF6g8-SCM3-TRg-4":15667,
"TIF6g8-SCM3-TRg-6":15668,
"TIF6g8-RLP7-NRg-1":15669,
"TIF6g8-TFB2-NRg-4":15670,
"TIF6g8-IMP4-TRg-1":15671,
"TIF6g8-IMP4-TRg-3":15672,
"TIF6g8-PRE4-TRg-3":15673,
"TIF6g8-SUB2-TRg-3":15674,
"TIF6g8-RPP0-NRg-4":15675,
"TIF6g8-RPP0-NRg-3":15676,
"TIF6g8-TOM40-TRg-4":15677,
"TIF6g8-FUR1-NRg-12":15678,
"TIF6g8-TOM40-TRg-2":15679,
"TIF6g8-VMA11-NRg-4":15680,
"TIF6g8-PGS1-NRg-4":15681,
"TIF6g8-URB1-TRg-4":15682,
"TIF6g8-ARP4-TRg-3":15683,
"TIF6g8-RPT3-TRg-3":15684,
"TIF6g8-SUI3-TRg-3":15685,
"TIF6g8-RFC5-NRg-2":15686,
"TIF6g8-RRP14-TRg-2":15687,
"TIF6g8-SCC2-TRg-1":15688,
"TIF6g8-SSC1-TRg-3":15689,
"TIF6g8-RRP9-TRg-3":15690,
"TIF6g8-MOT1-NRg-9":15691,
"TIF6g8-RPL42A-NRg-2":15692,
"TIF6g8-SEC16-TRg-7":15693,
"TIF6g8-IMP4-NRg-2":15694,
"TIF6g8-YEF3-NRg-4":15695,
"TIF6g8-PUP1-TRg-1":15696,
"TIF6g8-UTP22-TRg-6":15697,
"TIF6g8-DBP2-NRg-4":15698,
"TIF6g8-PRE2-TRg-7":15699,
"TIF6g8-ATP16-TRg-6":15700,
"TIF6g8-UTP13-TRg-4":15701,
"TIF6g8-DOP1-NRg-4":15702,
"TIF6g8-TIM44-TRg-3":15703,
"TIF6g8-ATP16-TRg-2":15704,
"TIF6g8-ENP1-NRg-3":15705,
"TIF6g8-NAF1-TRg-3":15706,
"TIF6g8-COG4-TRg-2":15707,
"TIF6g8-SOG2-TRg-7":15708,
"TIF6g8-YDR341C-TRg-3":15709,
"TIF6g8-YMR290W-A-TRg-10":15710,
"TIF6g8-NUP192-NRg-9":15711,
"TIF6g8-RPS31-NRg-8":15712,
"TIF6g8-SPC97-NRg-6":15713,
"TIF6g8-EBP2-NRg-1":15714,
"TIF6g8-CDC48-TRg-5":15715,
"TIF6g8-RPT1-TRg-4":15716,
"TIF6g8-ULP1-NRg-2":15717,
"TIF6g8-RPN3-TRg-6":15718,
"TIF6g8-RPT1-TRg-5":15719,
"TIF6g8-KRE5-TRg-2":15720,
"TIF6g8-TBF1-NRg-8":15721,
"TIF6g8-UTP22-NRg-4":15722,
"TIF6g8-SSC1-NRg-4":15723,
"TIF6g8-REB1-TRg-4":15724,
"TIF6g8-CDC48-NRg-9":15725,
"TIF6g8-FAS2-TRg-8":15726,
"TIF6g8-TAO3-TRg-8":15727,
"TIF6g8-CKS1-TRg-5":15728,
"TIF6g8-YLR379W-TRg-7":15729,
"TIF6g8-TEN1-NRg-2":15730,
"TIF6g8-RPL42A-TRg-2":15731,
"TIF6g8-SEC27-TRg-4":15732,
"TIF6g8-TBF1-NRg-4":15733,
"TIF6g8-RPT1-NRg-6":15734,
"TIF6g8-COG1-TRg-3":15735,
"TIF6g8-SUI1-TRg-6":15736,
"TIF6g8-TIM23-TRg-6":15737,
"TIF6g8-CDC48-NRg-6":15738,
"TIF6g8-EPL1-TRg-5":15739,
"TIF6g8-RPT5-TRg-8":15740,
"TIF6g8-ATP16-NRg-4":15741,
"TIF6g8-RPN6-TRg-3":15742,
"TIF6g8-ERG9-NRg-6":15743,
"TIF6g8-SMX3-TRg-1":15744,
"TIF6g8-NCB2-NRg-3":15745,
"TIF6g8-SEC16-NRg-12":15746,
"TIF6g8-RPN6-TRg-2":15747,
"TIF6g8-REB1-NRg-4":15748,
"TIF6g8-ATP16-TRg-9":15749,
"TIF6g8-ERG9-NRg-7":15750,
"RPF1g3-RPL15A-NRg-4":15751,
"RPF1g3-RPL15A-NRg-5":15752,
"RPF1g3-KRE33-TRg-1":15753,
"RPF1g3-PMI40-NRg-1":15754,
"RPF1g3-NOP19-NRg-3":15755,
"RPF1g3-SRP14-NRg-4":15756,
"RPF1g3-SEC27-TRg-2":15757,
"RPF1g3-GPI14-TRg-3":15758,
"RPF1g3-PAH1-TRg-7":15759,
"RPF1g3-PAH1-TRg-6":15760,
"RPF1g3-PAH1-TRg-5":15761,
"RPF1g3-PAH1-TRg-3":15762,
"RPF1g3-COG3-TRg-1":15763,
"RPF1g3-HTS1-NRg-5":15764,
"RPF1g3-MSN5-TRg-7":15765,
"RPF1g3-ERG26-TRg-1":15766,
"RPF1g3-SMD2-TRg-5":15767,
"RPF1g3-SMD2-TRg-4":15768,
"RPF1g3-SMD2-TRg-1":15769,
"RPF1g3-PRE7-TRg-4":15770,
"RPF1g3-PRE7-TRg-7":15771,
"RPF1g3-SEC6-TRg-3":15772,
"RPF1g3-ESF2-NRg-1":15773,
"RPF1g3-ESF2-NRg-3":15774,
"RPF1g3-AFG2-TRg-2":15775,
"RPF1g3-RRP36-TRg-3":15776,
"RPF1g3-RRP36-TRg-5":15777,
"RPF1g3-GCR1-NRg-2":15778,
"RPF1g3-PRE4-NRg-4":15779,
"RPF1g3-PRE4-NRg-9":15780,
"RPF1g3-DSN1-NRg-2":15781,
"RPF1g3-GPI11-TRg-3":15782,
"RPF1g3-POP3-TRg-1":15783,
"RPF1g3-MNE1-TRg-5":15784,
"RPF1g3-RRP12-NRg-1":15785,
"RPF1g3-RSC6-TRg-2":15786,
"RPF1g3-CDC25-TRg-1":15787,
"RPF1g3-CDC25-TRg-9":15788,
"RPF1g3-YPP1-NRg-3":15789,
"RPF1g3-NFS1-NRg-9":15790,
"RPF1g3-NFS1-NRg-8":15791,
"RPF1g3-UBA2-TRg-1":15792,
"RPF1g3-ARP2-NRg-3":15793,
"RPF1g3-MAK16-TRg-1":15794,
"RPF1g3-CEP3-NRg-1":15795,
"RPF1g3-GUK1-TRg-5":15796,
"RPF1g3-GUK1-TRg-2":15797,
"RPF1g3-GPI12-NRg-6":15798,
"RPF1g3-RPS5-NRg-5":15799,
"RPF1g3-RPS5-NRg-2":15800,
"RPF1g3-RPC19-NRg-1":15801,
"RPF1g3-TIM54-TRg-1":15802,
"RPF1g3-TEN1-TRg-2":15803,
"RPF1g3-SAH1-NRg-4":15804,
"RPF1g3-SAH1-NRg-5":15805,
"RPF1g3-SAH1-NRg-3":15806,
"RPF1g3-ATP15-NRg-5":15807,
"RPF1g3-SCD5-TRg-5":15808,
"RPF1g3-ARB1-NRg-2":15809,
"RPF1g3-ARB1-NRg-4":15810,
"RPF1g3-PUP2-TRg-1":15811,
"RPF1g3-CCT8-TRg-2":15812,
"RPF1g3-MCM4-TRg-1":15813,
"RPF1g3-LSM4-TRg-1":15814,
"RPF1g3-NOP53-NRg-1":15815,
"RPF1g3-ATP3-TRg-4":15816,
"RPF1g3-AFG2-NRg-3":15817,
"RPF1g3-PRO3-NRg-3":15818,
"RPF1g3-NRD1-NRg-10":15819,
"RPF1g3-SEC61-TRg-2":15820,
"RPF1g3-RHO3-TRg-4":15821,
"RPF1g3-SNF2-TRg-6":15822,
"RPF1g3-SMD2-NRg-3":15823,
"RPF1g3-RSC4-TRg-2":15824,
"RPF1g3-RSC4-TRg-1":15825,
"RPF1g3-TIF34-TRg-2":15826,
"RPF1g3-BET1-NRg-1":15827,
"RPF1g3-CDC8-NRg-2":15828,
"RPF1g3-PRP42-TRg-2":15829,
"RPF1g3-RRB1-TRg-2":15830,
"RPF1g3-SPC24-TRg-1":15831,
"RPF1g3-ILS1-NRg-1":15832,
"RPF1g3-GFA1-TRg-2":15833,
"RPF1g3-SEC21-NRg-10":15834,
"RPF1g3-RPC10-NRg-1":15835,
"RPF1g3-RPB10-TRg-3":15836,
"RPF1g3-RPB10-TRg-2":15837,
"RPF1g3-YNL181W-TRg-1":15838,
"RPF1g3-RAD3-NRg-1":15839,
"RPF1g3-NOP10-TRg-1":15840,
"RPF1g3-BFR2-TRg-3":15841,
"RPF1g3-MCM2-TRg-6":15842,
"RPF1g3-MCM2-TRg-4":15843,
"RPF1g3-MPP10-TRg-1":15844,
"RPF1g3-RET2-TRg-4":15845,
"RPF1g3-RET2-TRg-1":15846,
"RPF1g3-RPS2-NRg-1":15847,
"RPF1g3-RPS2-NRg-2":15848,
"RPF1g3-ORC4-NRg-3":15849,
"RPF1g3-TIP20-TRg-7":15850,
"RPF1g3-SMT3-TRg-1":15851,
"RPF1g3-MSS18-NRg-6":15852,
"RPF1g3-YEF3-NRg-9":15853,
"RPF1g3-ASK1-NRg-1":15854,
"RPF1g3-SMC1-TRg-1":15855,
"RPF1g3-NIP1-NRg-1":15856,
"RPF1g3-RPP1-NRg-1":15857,
"RPF1g3-YDJ1-TRg-6":15858,
"RPF1g3-SUB2-NRg-1":15859,
"RPF1g3-TIM10-NRg-8":15860,
"RPF1g3-TIM10-NRg-4":15861,
"RPF1g3-TIM10-NRg-7":15862,
"RPF1g3-SKI6-TRg-4":15863,
"RPF1g3-TUB4-TRg-1":15864,
"RPF1g3-CDC37-NRg-2":15865,
"RPF1g3-ISD11-TRg-3":15866,
"RPF1g3-YOS1-TRg-4":15867,
"RPF1g3-SSC1-TRg-6":15868,
"RPF1g3-MTR3-TRg-5":15869,
"RPF1g3-MTR3-TRg-6":15870,
"RPF1g3-TFA1-TRg-2":15871,
"RPF1g3-CDC3-NRg-3":15872,
"RPF1g3-ERG25-TA-18":15873,
"RPF1g3-RPB11-TRg-4":15874,
"RPF1g3-RPB11-TRg-1":15875,
"RPF1g3-RPB11-TRg-2":15876,
"RPF1g3-DED1-TRg-3":15877,
"RPF1g3-DED1-TRg-1":15878,
"RPF1g3-DED1-TRg-6":15879,
"RPF1g3-DED1-TRg-4":15880,
"RPF1g3-RPL10-NRg-5":15881,
"RPF1g3-RPL10-NRg-4":15882,
"RPF1g3-EFB1-NRg-1":15883,
"RPF1g3-EFB1-NRg-5":15884,
"RPF1g3-EFB1-NRg-4":15885,
"RPF1g3-RPT3-NRg-1":15886,
"RPF1g3-SAC6-TRg-8":15887,
"RPF1g3-SAC6-TRg-4":15888,
"RPF1g3-SAC6-TRg-5":15889,
"RPF1g3-SAC6-TRg-3":15890,
"RPF1g3-DIM1-TRg-5":15891,
"RPF1g3-DIM1-TRg-7":15892,
"RPF1g3-RPC17-NRg-1":15893,
"RPF1g3-RPC17-NRg-2":15894,
"RPF1g3-YDR341C-TRg-1":15895,
"RPF1g3-RAP1-NRg-8":15896,
"RPF1g3-RAP1-NRg-5":15897,
"RPF1g3-RAP1-NRg-2":15898,
"RPF1g3-SEC26-NRg-3":15899,
"RPF1g3-SPP41-TRg-3":15900,
"RPF1g3-TAP42-NRg-1":15901,
"RPF1g3-PGA2-TRg-6":15902,
"RPF1g3-BRL1-TRg-1":15903,
"RPF1g3-FOL2-TRg-1":15904,
"RPF1g3-NAB3-NRg-5":15905,
"RPF1g3-SNF4-TRg-4":15906,
"RPF1g3-HRR25-TRg-2":15907,
"RPF1g3-TRS23-TRg-4":15908,
"RPF1g3-CTR86-TRg-4":15909,
"RPF1g3-RPB5-TRg-5":15910,
"RPF1g3-SPN1-NRg-2":15911,
"RPF1g3-SPN1-NRg-1":15912,
"RPF1g3-SEC61-NRg-1":15913,
"RPF1g3-SEC61-NRg-7":15914,
"RPF1g3-TUS1-TRg-3":15915,
"RPF1g3-OLE1-NRg-2":15916,
"RPF1g3-AFG2-TRg-1":15917,
"RPF1g3-TOA2-NRg-1":15918,
"RPF1g3-USO1-TRg-1":15919,
"RPF1g3-UTP22-NRg-2":15920,
"RPF1g3-RIB1-TRg-3":15921,
"RPF1g3-RIB1-TRg-7":15922,
"RPF1g3-RIB1-TRg-4":15923,
"RPF1g3-COG1-TRg-1":15924,
"RPF1g3-RPL32-NRg-2":15925,
"RPF1g3-GLC7-NRg-3":15926,
"RPF1g3-GLC7-NRg-4":15927,
"RPF1g3-HSF1-TRg-2":15928,
"RPF1g3-DAM1-NRg-5":15929,
"RPF1g3-SEC18-TRg-4":15930,
"RPF1g3-SEC18-TRg-5":15931,
"RPF1g3-PAB1-NRg-3":15932,
"RPF1g3-POP8-TRg-2":15933,
"RPF1g3-PAB1-NRg-4":15934,
"RPF1g3-BIG1-TRg-4":15935,
"RPF1g3-BIG1-TRg-5":15936,
"RPF1g3-BIG1-TRg-6":15937,
"RPF1g3-RPO41-NRg-1":15938,
"RPF1g3-RVB2-NRg-2":15939,
"RPF1g3-PET117-NRg-8":15940,
"RPF1g3-VPS45-NRg-9":15941,
"RPF1g3-YCG1-NRg-1":15942,
"RPF1g3-NOC4-NRg-1":15943,
"RPF1g3-NMD3-NRg-2":15944,
"RPF1g3-DRS1-TRg-2":15945,
"RPF1g3-HTB1-NRg-2":15946,
"RPF1g3-IPI1-TRg-2":15947,
"RPF1g3-SEC18-NRg-1":15948,
"RPF1g3-SEC18-NRg-2":15949,
"RPF1g3-JIP5-NRg-2":15950,
"RPF1g3-YPT1-TRg-3":15951,
"RPF1g3-YPT1-TRg-2":15952,
"RPF1g3-CLF1-NRg-2":15953,
"RPF1g3-SNF2-NRg-7":15954,
"RPF1g3-SNF2-NRg-4":15955,
"RPF1g3-RPL25-NRg-1":15956,
"RPF1g3-NOP56-TRg-1":15957,
"RPF1g3-NOP56-TRg-2":15958,
"RPF1g3-TRS31-TRg-1":15959,
"RPF1g3-DBF4-TRg-2":15960,
"RPF1g3-DBF4-TRg-1":15961,
"RPF1g3-RPC19-TRg-4":15962,
"RPF1g3-RPC19-TRg-6":15963,
"RPF1g3-RPC19-TRg-3":15964,
"RPF1g3-ROK1-NRg-1":15965,
"RPF1g3-CDC33-TRg-4":15966,
"RPF1g3-DHR2-TRg-3":15967,
"RPF1g3-RRP42-NRg-5":15968,
"RPF1g3-CLF1-TRg-1":15969,
"RPF1g3-ERG11-NA-16":15970,
"RPF1g3-VAS1-NRg-4":15971,
"RPF1g3-PIK1-NRg-2":15972,
"RPF1g3-SAR1-NRg-7":15973,
"RPF1g3-SAR1-NRg-4":15974,
"RPF1g3-RPS3-TRg-1":15975,
"RPF1g3-YTM1-TRg-2":15976,
"RPF1g3-SUI3-NRg-5":15977,
"RPF1g3-SUI3-NRg-2":15978,
"RPF1g3-RRP7-TRg-4":15979,
"RPF1g3-RRP7-TRg-6":15980,
"RPF1g3-NIP7-TRg-2":15981,
"RPF1g3-MDM35-TRg-1":15982,
"RPF1g3-ALA1-NRg-1":15983,
"RPF1g3-DOA4-NRg-2":15984,
"RPF1g3-RPS13-NRg-1":15985,
"RPF1g3-YSF3-TRg-2":15986,
"RPF1g3-RPS2-NRg-11":15987,
"RPF1g3-SSL1-TRg-10":15988,
"RPF1g3-NIP7-TRg-1":15989,
"RPF1g3-LST8-NRg-1":15990,
"RPF1g3-TAF4-TRg-3":15991,
"RPF1g3-HAS1-TRg-2":15992,
"RPF1g3-GLC7-TRg-2":15993,
"RPF1g3-CDC45-NRg-1":15994,
"RPF1g3-SEC22-NRg-8":15995,
"RPF1g3-YOS1-TRg-2":15996,
"RPF1g3-RBA50-TRg-3":15997,
"RPF1g3-SPP41-NRg-2":15998,
"RPF1g3-PRP46-TRg-2":15999,
"RPF1g3-PGA2-NRg-1":16000,
"RPF1g3-CBF5-TRg-3":16001,
"RPF1g3-TCP1-NRg-3":16002,
"RPF1g3-TCP1-NRg-2":16003,
"RPF1g3-ERG26-NRg-2":16004,
"RPF1g3-ERG26-NRg-4":16005,
"RPF1g3-MES1-TRg-5":16006,
"RPF1g3-HTS1-TRg-2":16007,
"RPF1g3-SSS1-TRg-3":16008,
"RPF1g3-SSS1-TRg-2":16009,
"RPF1g3-SYS1-TRg-7":16010,
"RPF1g3-SYS1-TRg-2":16011,
"RPF1g3-SYS1-TRg-1":16012,
"RPF1g3-BFR2-TRg-1":16013,
"RPF1g3-EOS1-TRg-3":16014,
"RPF1g3-TAF4-NRg-1":16015,
"RPF1g3-ARL3-NRg-8":16016,
"RPF1g3-RPN5-NRg-1":16017,
"RPF1g3-TIM9-NRg-2":16018,
"RPF1g3-NUP57-NRg-3":16019,
"RPF1g3-VPS4-TRg-1":16020,
"RPF1g3-CDC3-TRg-4":16021,
"RPF1g3-BBP1-NRg-1":16022,
"RPF1g3-BBP1-NRg-2":16023,
"RPF1g3-USE1-NRg-3":16024,
"RPF1g3-CCT7-TRg-1":16025,
"RPF1g3-SAH1-TRg-3":16026,
"RPF1g3-CHS2-TRg-1":16027,
"RPF1g3-DPM1-TRg-2":16028,
"RPF1g3-BBP1-TRg-1":16029,
"RPF1g3-NRD1-TRg-4":16030,
"RPF1g3-RPB3-NRg-1":16031,
"RPF1g3-PHO85-NRg-6":16032,
"RPF1g3-SNF6-TRg-6":16033,
"RPF1g3-PRP38-NRg-2":16034,
"RPF1g3-OAR1-NRg-3":16035,
"RPF1g3-ROX3-NRg-1":16036,
"RPF1g3-YPP1-TRg-6":16037,
"RPF1g3-CBF2-NRg-8":16038,
"RPF1g3-SPT6-TRg-5":16039,
"RPF1g3-SEC10-NRg-1":16040,
"RPF1g3-NSL1-NRg-3":16041,
"RPF1g3-NRD1-NRg-8":16042,
"RPF1g3-RPB3-TRg-1":16043,
"RPF1g3-NRD1-NRg-4":16044,
"RPF1g3-RVB1-TRg-2":16045,
"RPF1g3-TIF5-NRg-8":16046,
"RPF1g3-EOS1-NRg-1":16047,
"RPF1g3-ERG25-NA-26":16048,
"RPF1g3-MSL5-NRg-4":16049,
"RPF1g3-SEC24-TRg-2":16050,
"RPF1g3-RPL30-NRg-5":16051,
"RPF1g3-SNU71-NRg-3":16052,
"RPF1g3-CDC33-NRg-1":16053,
"RPF1g3-RPN6-TRg-4":16054,
"RPF1g3-NAB2-TRg-4":16055,
"RPF1g3-NAB2-TRg-6":16056,
"RPF1g3-YTM1-NRg-1":16057,
"RPF1g3-OLE1-TRg-8":16058,
"RPF1g3-OLE1-TRg-1":16059,
"RPF1g3-UTP7-TRg-4":16060,
"RPF1g3-ACT1-NRg-6":16061,
"RPF1g3-RPL18A-NRg-3":16062,
"RPF1g3-BRX1-NRg-1":16063,
"RPF1g3-NAF1-TRg-8":16064,
"RPF1g3-NAF1-TRg-6":16065,
"RPF1g3-NAF1-TRg-4":16066,
"RPF1g3-CDC8-TRg-2":16067,
"RPF1g3-NSE4-TRg-1":16068,
"RPF1g3-PAB1-NRg-2":16069,
"RPF1g3-PRP43-TRg-4":16070,
"RPF1g3-SEC2-NRg-3":16071,
"RPF1g3-SEC2-NRg-6":16072,
"RPF1g3-MPP10-NRg-5":16073,
"RPF1g3-YDR355C-TRg-2":16074,
"RPF1g3-YLR339C-TRg-9":16075,
"RPF1g3-SNM1-TRg-2":16076,
"RPF1g3-ALR1-NRg-4":16077,
"RPF1g3-ALR1-NRg-1":16078,
"RPF1g3-ALR1-NRg-3":16079,
"RPF1g3-RPL10-TRg-1":16080,
"RPF1g3-RPL28-TRg-2":16081,
"RPF1g3-UTP25-TRg-1":16082,
"RPF1g3-POB3-TRg-1":16083,
"RPF1g3-POB3-TRg-3":16084,
"RPF1g3-POB3-TRg-2":16085,
"RPF1g3-MED11-TRg-1":16086,
"RPF1g3-ISA1-TRg-15":16087,
"RPF1g3-RRP1-NRg-1":16088,
"RPF1g3-MES1-NRg-1":16089,
"RPF1g3-SEC13-NRg-5":16090,
"RPF1g3-MCM2-NRg-2":16091,
"RPF1g3-ALA1-TRg-4":16092,
"RPF1g3-MTG2-TRg-5":16093,
"RPF1g3-TIF35-NRg-3":16094,
"RPF1g3-NSE1-TRg-3":16095,
"RPF1g3-NSE1-TRg-4":16096,
"RPF1g3-MOB2-NRg-6":16097,
"RPF1g3-VRG4-NRg-3":16098,
"RPF1g3-PRP9-TRg-3":16099,
"RPF1g3-HYM1-TRg-5":16100,
"RPF1g3-POP1-TRg-5":16101,
"RPF1g3-POP1-TRg-9":16102,
"RPF1g3-RPL17A-TRg-1":16103,
"RPF1g3-SLD2-TRg-1":16104,
"RPF1g3-CDC48-NRg-7":16105,
"RPF1g3-FHL1-NRg-2":16106,
"RPF1g3-BET3-NRg-7":16107,
"RPF1g3-MAK21-TRg-1":16108,
"RPF1g3-BRN1-TRg-4":16109,
"RPF1g3-FBA1-NRg-3":16110,
"RPF1g3-CDC42-TRg-6":16111,
"RPF1g3-CDC42-TRg-7":16112,
"RPF1g3-COG4-NRg-1":16113,
"RPF1g3-ATP3-NRg-3":16114,
"RPF1g3-ATP3-NRg-2":16115,
"RPF1g3-SMP3-TRg-5":16116,
"RPF1g3-CFT2-NRg-2":16117,
"RPF1g3-FAS2-TRg-5":16118,
"RPF1g3-DBP2-NRg-3":16119,
"RPF1g3-DBP2-NRg-2":16120,
"RPF1g3-MPS2-NRg-4":16121,
"RPF1g3-ARC35-TRg-2":16122,
"RPF1g3-ARC35-TRg-5":16123,
"RPF1g3-MRD1-TRg-1":16124,
"RPF1g3-RLP7-TRg-1":16125,
"RPF1g3-SPC34-TRg-1":16126,
"RPF1g3-CDC45-TRg-2":16127,
"RPF1g3-GCD6-TRg-3":16128,
"RPF1g3-GCD6-TRg-4":16129,
"RPF1g3-YPT6-NRg-2":16130,
"RPF1g3-RPS13-TRg-2":16131,
"RPF1g3-IPI3-TRg-3":16132,
"RPF1g3-TIF5-NRg-9":16133,
"RPF1g3-TIF5-NRg-7":16134,
"RPF1g3-TIF5-NRg-6":16135,
"RPF1g3-NAB3-TRg-3":16136,
"RPF1g3-GCD2-TRg-1":16137,
"RPF1g3-UBA1-TRg-2":16138,
"RPF1g3-SLD3-TRg-6":16139,
"RPF1g3-LCB1-TRg-5":16140,
"RPF1g3-TOA2-TRg-6":16141,
"RPF1g3-TOA2-TRg-1":16142,
"RPF1g3-TOA2-TRg-3":16143,
"RPF1g3-LSM2-TRg-1":16144,
"RPF1g3-YML6-TRg-13":16145,
"RPF1g3-YML6-TRg-12":16146,
"RPF1g3-UTP15-NRg-1":16147,
"RPF1g3-TIF6-NRg-8":16148,
"RPF1g3-SUP35-NRg-1":16149,
"RPF1g3-MPP10-NRg-1":16150,
"RPF1g3-SWI3-TRg-7":16151,
"RPF1g3-SSN3-NRg-2":16152,
"RPF1g3-SEC13-NRg-7":16153,
"RPF1g3-RPS15-NRg-3":16154,
"RPF1g3-RPL3-TRg-2":16155,
"RPF1g3-FBA1-NRg-2":16156,
"RPF1g3-FBA1-NRg-1":16157,
"RPF1g3-FBA1-NRg-5":16158,
"RPF1g3-DAM1-TRg-2":16159,
"RPF1g3-NHP2-TRg-2":16160,
"RPF1g3-HCA4-NRg-6":16161,
"RPF1g3-PRE3-TRg-4":16162,
"RPF1g3-DBP5-NRg-4":16163,
"RPF1g3-SPT6-NRg-4":16164,
"RPF1g3-SPT6-NRg-2":16165,
"RPF1g3-RPL18A-TRg-4":16166,
"RPF1g3-KSH1-TRg-1":16167,
"RPF1g3-KSH1-TRg-3":16168,
"RPF1g3-IPI3-NRg-1":16169,
"RPF1g3-PGA2-TRg-8":16170,
"RPF1g3-RPL18A-TRg-2":16171,
"RPF1g3-RPL33A-NRg-6":16172,
"RPF1g3-TAF12-NRg-2":16173,
"RPF1g3-USE1-TRg-5":16174,
"RPF1g3-YNL114C-TRg-1":16175,
"RPF1g3-SMC5-TRg-7":16176,
"RPF1g3-SMC5-TRg-6":16177,
"RPF1g3-RSC58-TRg-1":16178,
"RPF1g3-CTF13-TRg-2":16179,
"RPF1g3-NAB2-NRg-2":16180,
"RPF1g3-MCM7-TRg-4":16181,
"RPF1g3-BCP1-NRg-5":16182,
"RPF1g3-STU2-TRg-3":16183,
"RPF1g3-SEC21-NRg-6":16184,
"RPF1g3-SEC21-NRg-3":16185,
"RPF1g3-RPL1B-TRg-3":16186,
"RPF1g3-SEC20-NRg-2":16187,
"RPF1g3-VMA3-NRg-2":16188,
"RPF1g3-SEC23-NRg-5":16189,
"RPF1g3-CDC28-TRg-4":16190,
"RPF1g3-RPN12-NRg-11":16191,
"RPF1g3-PUP3-TRg-3":16192,
"RPF1g3-SEC31-TRg-2":16193,
"RPF1g3-SED5-TRg-6":16194,
"RPF1g3-SED5-TRg-5":16195,
"RPF1g3-RPL33A-TRg-1":16196,
"RPF1g3-RPL33A-TRg-2":16197,
"RPF1g3-MRPL11-TRg-2":16198,
"RPF1g3-RTP1-NRg-2":16199,
"RPF1g3-NUG1-TRg-2":16200,
"RPF1g3-VPH2-TRg-4":16201,
"RPF1g3-COP1-NRg-3":16202,
"RPF1g3-CRM1-NRg-1":16203,
"RPF1g3-RPL5-NRg-4":16204,
"RPF1g3-SNU13-NRg-4":16205,
"RPF1g3-PFS2-TRg-3":16206,
"RPF1g3-MPP10-TRg-2":16207,
"RPF1g3-TSR4-NRg-2":16208,
"RPF1g3-RSC2-TRg-1":16209,
"RPF1g3-SEC65-TRg-2":16210,
"RPF1g3-SMI1-NRg-1":16211,
"RPF1g3-RTT105-NRg-4":16212,
"RPF1g3-VMA5-TRg-3":16213,
"RPF1g3-VMA5-TRg-5":16214,
"RPF1g3-RRP1-TRg-3":16215,
"RPF1g3-CLC1-TRg-2":16216,
"RPF1g3-GCD6-NRg-1":16217,
"RPF1g3-GCD6-NRg-2":16218,
"RPF1g3-PXR1-TRg-1":16219,
"RPF1g3-CDC14-NRg-1":16220,
"RPF1g3-PCF11-TRg-6":16221,
"RPF1g3-PCF11-TRg-5":16222,
"RPF1g3-PCF11-TRg-4":16223,
"RPF1g3-SEC31-NRg-1":16224,
"RPF1g3-RRP5-NRg-1":16225,
"RPF1g3-PRE10-TRg-5":16226,
"RPF1g3-PRE10-TRg-1":16227,
"RPF1g3-RPS5-TRg-2":16228,
"RPF1g3-NSP1-TRg-4":16229,
"RPF1g3-PRP38-TRg-4":16230,
"RPF1g3-RCF1-NRg-5":16231,
"RPF1g3-RSC3-TRg-4":16232,
"RPF1g3-RSC3-TRg-5":16233,
"RPF1g3-RSC3-TRg-6":16234,
"RPF1g3-HTA1-NRg-12":16235,
"RPF1g3-HTA1-NRg-11":16236,
"RPF1g3-UTP23-TRg-2":16237,
"RPF1g3-GCD7-NRg-1":16238,
"RPF1g3-GCD7-NRg-2":16239,
"RPF1g3-GCD7-NRg-6":16240,
"RPF1g3-GAL11-NRg-2":16241,
"RPF1g3-GAL11-NRg-9":16242,
"RPF1g3-PHO4-TRg-5":16243,
"RPF1g3-SNP1-NRg-3":16244,
"RPF1g3-RPC37-TRg-5":16245,
"RPF1g3-CRM1-TRg-5":16246,
"RPF1g3-CRM1-TRg-2":16247,
"RPF1g3-ASK1-TRg-7":16248,
"RPF1g3-STU2-NRg-4":16249,
"RPF1g3-NEO1-NRg-3":16250,
"RPF1g3-GAL11-TRg-5":16251,
"RPF1g3-GAL11-TRg-7":16252,
"RPF1g3-SAM50-NRg-3":16253,
"RPF1g3-CSL4-TRg-2":16254,
"RPF1g3-CCT5-TRg-2":16255,
"RPF1g3-POL30-NRg-1":16256,
"RPF1g3-MED4-TRg-4":16257,
"RPF1g3-MED4-TRg-3":16258,
"RPF1g3-MED4-TRg-2":16259,
"RPF1g3-GDI1-TRg-4":16260,
"RPF1g3-GDI1-TRg-3":16261,
"RPF1g3-REB1-TRg-6":16262,
"RPF1g3-MRPL37-NRg-2":16263,
"RPF1g3-NOC3-TRg-3":16264,
"RPF1g3-SPC97-TRg-3":16265,
"RPF1g3-IPP1-TRg-3":16266,
"RPF1g3-IPP1-TRg-2":16267,
"RPF1g3-PTI1-TRg-3":16268,
"RPF1g3-PTI1-TRg-5":16269,
"RPF1g3-RFC5-NRg-1":16270,
"RPF1g3-CDC24-TRg-1":16271,
"RPF1g3-CDC24-TRg-3":16272,
"RPF1g3-CDC24-TRg-5":16273,
"RPF1g3-CDC24-TRg-6":16274,
"RPF1g3-UTP23-TRg-6":16275,
"RPF1g3-UTP23-TRg-4":16276,
"RPF1g3-UTP23-TRg-1":16277,
"RPF1g3-RHO3-NRg-4":16278,
"RPF1g3-TRS23-NRg-1":16279,
"RPF1g3-TRS23-NRg-3":16280,
"RPF1g3-RSP5-TRg-2":16281,
"RPF1g3-RSP5-TRg-1":16282,
"RPF1g3-SDA1-NRg-1":16283,
"RPF1g3-KAP95-TRg-8":16284,
"RPF1g3-ACO1-TRg-6":16285,
"RPF1g3-HTA1-NRg-3":16286,
"RPF1g3-HTA1-NRg-2":16287,
"RPF1g3-SPN1-TRg-1":16288,
"RPF1g3-MOT1-NRg-7":16289,
"RPF1g3-RPL17A-NRg-4":16290,
"RPF1g3-ADA2-TRg-4":16291,
"RPF1g3-SFH1-NRg-1":16292,
"RPF1g3-SPC97-NRg-5":16293,
"RPF1g3-PRP22-TRg-3":16294,
"RPF1g3-SEN15-TRg-2":16295,
"RPF1g3-RPL3-NRg-2":16296,
"RPF1g3-ISD11-NRg-2":16297,
"RPF1g3-HEM12-TRg-8":16298,
"RPF1g3-SEC10-TRg-1":16299,
"RPF1g3-HTB1-TRg-7":16300,
"RPF1g3-TTI2-TRg-1":16301,
"RPF1g3-ACP1-TRg-2":16302,
"RPF1g3-ACP1-TRg-4":16303,
"RPF1g3-GAL11-NRg-10":16304,
"RPF1g3-UTP22-TRg-2":16305,
"RPF1g3-MST1-NRg-5":16306,
"RPF1g3-RIB7-NRg-2":16307,
"RPF1g3-MCD1-TRg-6":16308,
"RPF1g3-MCD1-TRg-5":16309,
"RPF1g3-GPI8-NRg-2":16310,
"RPF1g3-THS1-TRg-2":16311,
"RPF1g3-RRP7-TRg-2":16312,
"RPF1g3-RRP7-TRg-5":16313,
"RPF1g3-SMX2-NRg-7":16314,
"RPF1g3-RRP45-TRg-5":16315,
"RPF1g3-RRP45-TRg-4":16316,
"RPF1g3-CNS1-TRg-2":16317,
"RPF1g3-FBP1-NRg-9":16318,
"RPF1g3-GCD11-NRg-1":16319,
"RPF1g3-RPL10-TRg-2":16320,
"RPF1g3-NUP192-TRg-4":16321,
"RPF1g3-NUP145-NRg-4":16322,
"RPF1g3-HEM12-TRg-6":16323,
"RPF1g3-PLC1-TRg-3":16324,
"RPF1g3-RPA43-TRg-1":16325,
"RPF1g3-RPB7-NRg-2":16326,
"RPF1g3-RPB7-NRg-3":16327,
"RPF1g3-NSL1-NRg-1":16328,
"RPF1g3-UTP6-TRg-3":16329,
"RPF1g3-UTP6-TRg-1":16330,
"RPF1g3-YJU2-TRg-5":16331,
"RPF1g3-FRS2-NRg-5":16332,
"RPF1g3-TIF35-NRg-2":16333,
"RPF1g3-GPI15-TRg-1":16334,
"RPF1g3-NOP1-NRg-5":16335,
"RPF1g3-GPI15-TRg-4":16336,
"RPF1g3-COG4-TRg-1":16337,
"RPF1g3-TFA1-TRg-1":16338,
"RPF1g3-RHO1-NRg-2":16339,
"RPF1g3-RHO1-NRg-1":16340,
"RPF1g3-CDC55-NRg-2":16341,
"RPF1g3-IDI1-NRg-7":16342,
"RPF1g3-RPL32-TRg-5":16343,
"RPF1g3-RPB5-TRg-4":16344,
"RPF1g3-DIP2-TRg-5":16345,
"RPF1g3-DIP2-TRg-1":16346,
"RPF1g3-RPC40-TRg-2":16347,
"RPF1g3-CDC6-TRg-5":16348,
"RPF1g3-CDC6-TRg-3":16349,
"RPF1g3-DAD2-TRg-2":16350,
"RPF1g3-RVS161-TRg-2":16351,
"RPF1g3-RVS161-TRg-1":16352,
"RPF1g3-SUP45-NRg-3":16353,
"RPF1g3-SRB6-NRg-5":16354,
"RPF1g3-RPC11-TRg-4":16355,
"RPF1g3-RKI1-TRg-8":16356,
"RPF1g3-NIP7-TRg-3":16357,
"RPF1g3-RPL33A-NRg-12":16358,
"RPF1g3-SAM50-TRg-4":16359,
"RPF1g3-NOP4-NRg-1":16360,
"RPF1g3-NOP4-NRg-3":16361,
"RPF1g3-SMX2-TRg-5":16362,
"RPF1g3-POL12-NRg-2":16363,
"RPF1g3-BMS1-NRg-2":16364,
"RPF1g3-RPA190-TRg-5":16365,
"RPF1g3-ALG14-NRg-4":16366,
"RPF1g3-ALG14-NRg-1":16367,
"RPF1g3-PRE5-NRg-1":16368,
"RPF1g3-BIG1-NRg-2":16369,
"RPF1g3-TFA2-TRg-4":16370,
"RPF1g3-IMP4-TRg-6":16371,
"RPF1g3-PAN1-NRg-1":16372,
"RPF1g3-UTP13-TRg-2":16373,
"RPF1g3-KAE1-NRg-3":16374,
"RPF1g3-ERG20-TRg-1":16375,
"RPF1g3-CDC20-TRg-6":16376,
"RPF1g3-PWP2-NRg-2":16377,
"RPF1g3-COG1-NRg-1":16378,
"RPF1g3-RPL1B-TRg-4":16379,
"RPF1g3-RPL1B-TRg-7":16380,
"RPF1g3-UTP20-TRg-3":16381,
"RPF1g3-UTP20-TRg-4":16382,
"RPF1g3-RPL25-TRg-4":16383,
"RPF1g3-RPL25-TRg-2":16384,
"RPF1g3-MCM7-NRg-1":16385,
"RPF1g3-MRP49-TRg-5":16386,
"RPF1g3-ERO1-NRg-3":16387,
"RPF1g3-UTP5-TRg-7":16388,
"RPF1g3-MCM4-NRg-1":16389,
"RPF1g3-PRE3-NRg-1":16390,
"RPF1g3-FCF1-NRg-1":16391,
"RPF1g3-CUS1-NRg-1":16392,
"RPF1g3-PSF1-TRg-2":16393,
"RPF1g3-BCP1-TRg-2":16394,
"RPF1g3-PAN1-TRg-1":16395,
"RPF1g3-PAN1-TRg-3":16396,
"RPF1g3-PAN1-TRg-4":16397,
"RPF1g3-VPS3-TRg-2":16398,
"RPF1g3-YIL060W-NRg-1":16399,
"RPF1g3-VPS53-NRg-1":16400,
"RPF1g3-CYR1-TRg-4":16401,
"RPF1g3-CYR1-TRg-7":16402,
"RPF1g3-MPS1-NRg-1":16403,
"RPF1g3-SRP1-TRg-5":16404,
"RPF1g3-SRP1-TRg-4":16405,
"RPF1g3-TAF12-TRg-2":16406,
"RPF1g3-TAF12-TRg-3":16407,
"RPF1g3-POP4-TRg-1":16408,
"RPF1g3-SPT16-TRg-1":16409,
"RPF1g3-NUP82-TRg-4":16410,
"RPF1g3-DML1-TRg-3":16411,
"RPF1g3-RPA43-NRg-3":16412,
"RPF1g3-STU2-NRg-3":16413,
"RPF1g3-POP4-NRg-4":16414,
"RPF1g3-MCD1-TRg-2":16415,
"RPF1g3-RPS3-NRg-4":16416,
"RPF1g3-PRP9-TRg-4":16417,
"RPF1g3-RPP1-NRg-2":16418,
"RPF1g3-MTR2-NRg-11":16419,
"RPF1g3-GCD11-TRg-1":16420,
"RPF1g3-RPF1-TRg-3":16421,
"RPF1g3-SUB2-NRg-4":16422,
"RPF1g3-GPI15-TRg-3":16423,
"RPF1g3-ERG9-TRg-6":16424,
"RPF1g3-RPT2-NRg-1":16425,
"RPF1g3-YOS1-NRg-3":16426,
"RPF1g3-SCM3-TRg-4":16427,
"RPF1g3-SCM3-TRg-6":16428,
"RPF1g3-RLP7-NRg-1":16429,
"RPF1g3-TFB2-NRg-4":16430,
"RPF1g3-IMP4-TRg-1":16431,
"RPF1g3-IMP4-TRg-3":16432,
"RPF1g3-PRE4-TRg-3":16433,
"RPF1g3-SUB2-TRg-3":16434,
"RPF1g3-RPP0-NRg-4":16435,
"RPF1g3-RPP0-NRg-3":16436,
"RPF1g3-TOM40-TRg-4":16437,
"RPF1g3-FUR1-NRg-12":16438,
"RPF1g3-TOM40-TRg-2":16439,
"RPF1g3-VMA11-NRg-4":16440,
"RPF1g3-PGS1-NRg-4":16441,
"RPF1g3-URB1-TRg-4":16442,
"RPF1g3-ARP4-TRg-3":16443,
"RPF1g3-RPT3-TRg-3":16444,
"RPF1g3-SUI3-TRg-3":16445,
"RPF1g3-RFC5-NRg-2":16446,
"RPF1g3-RRP14-TRg-2":16447,
"RPF1g3-SCC2-TRg-1":16448,
"RPF1g3-SSC1-TRg-3":16449,
"RPF1g3-RRP9-TRg-3":16450,
"RPF1g3-MOT1-NRg-9":16451,
"RPF1g3-RPL42A-NRg-2":16452,
"RPF1g3-SEC16-TRg-7":16453,
"RPF1g3-IMP4-NRg-2":16454,
"RPF1g3-YEF3-NRg-4":16455,
"RPF1g3-PUP1-TRg-1":16456,
"RPF1g3-UTP22-TRg-6":16457,
"RPF1g3-DBP2-NRg-4":16458,
"RPF1g3-PRE2-TRg-7":16459,
"RPF1g3-ATP16-TRg-6":16460,
"RPF1g3-UTP13-TRg-4":16461,
"RPF1g3-DOP1-NRg-4":16462,
"RPF1g3-TIM44-TRg-3":16463,
"RPF1g3-ATP16-TRg-2":16464,
"RPF1g3-ENP1-NRg-3":16465,
"RPF1g3-NAF1-TRg-3":16466,
"RPF1g3-COG4-TRg-2":16467,
"RPF1g3-SOG2-TRg-7":16468,
"RPF1g3-YDR341C-TRg-3":16469,
"RPF1g3-YMR290W-A-TRg-10":16470,
"RPF1g3-NUP192-NRg-9":16471,
"RPF1g3-RPS31-NRg-8":16472,
"RPF1g3-SPC97-NRg-6":16473,
"RPF1g3-EBP2-NRg-1":16474,
"RPF1g3-CDC48-TRg-5":16475,
"RPF1g3-RPT1-TRg-4":16476,
"RPF1g3-ULP1-NRg-2":16477,
"RPF1g3-RPN3-TRg-6":16478,
"RPF1g3-RPT1-TRg-5":16479,
"RPF1g3-KRE5-TRg-2":16480,
"RPF1g3-TBF1-NRg-8":16481,
"RPF1g3-UTP22-NRg-4":16482,
"RPF1g3-SSC1-NRg-4":16483,
"RPF1g3-REB1-TRg-4":16484,
"RPF1g3-CDC48-NRg-9":16485,
"RPF1g3-FAS2-TRg-8":16486,
"RPF1g3-TAO3-TRg-8":16487,
"RPF1g3-CKS1-TRg-5":16488,
"RPF1g3-YLR379W-TRg-7":16489,
"RPF1g3-TEN1-NRg-2":16490,
"RPF1g3-RPL42A-TRg-2":16491,
"RPF1g3-SEC27-TRg-4":16492,
"RPF1g3-TBF1-NRg-4":16493,
"RPF1g3-RPT1-NRg-6":16494,
"RPF1g3-COG1-TRg-3":16495,
"RPF1g3-SUI1-TRg-6":16496,
"RPF1g3-TIM23-TRg-6":16497,
"RPF1g3-CDC48-NRg-6":16498,
"RPF1g3-EPL1-TRg-5":16499,
"RPF1g3-RPT5-TRg-8":16500,
"RPF1g3-ATP16-NRg-4":16501,
"RPF1g3-RPN6-TRg-3":16502,
"RPF1g3-ERG9-NRg-6":16503,
"RPF1g3-SMX3-TRg-1":16504,
"RPF1g3-NCB2-NRg-3":16505,
"RPF1g3-SEC16-NRg-12":16506,
"RPF1g3-RPN6-TRg-2":16507,
"RPF1g3-REB1-NRg-4":16508,
"RPF1g3-ATP16-TRg-9":16509,
"RPF1g3-ERG9-NRg-7":16510,
"MAK16g1-RPL15A-NRg-4":16511,
"MAK16g1-RPL15A-NRg-5":16512,
"MAK16g1-KRE33-TRg-1":16513,
"MAK16g1-PMI40-NRg-1":16514,
"MAK16g1-NOP19-NRg-3":16515,
"MAK16g1-SRP14-NRg-4":16516,
"MAK16g1-SEC27-TRg-2":16517,
"MAK16g1-GPI14-TRg-3":16518,
"MAK16g1-PAH1-TRg-7":16519,
"MAK16g1-PAH1-TRg-6":16520,
"MAK16g1-PAH1-TRg-5":16521,
"MAK16g1-PAH1-TRg-3":16522,
"MAK16g1-COG3-TRg-1":16523,
"MAK16g1-HTS1-NRg-5":16524,
"MAK16g1-MSN5-TRg-7":16525,
"MAK16g1-ERG26-TRg-1":16526,
"MAK16g1-SMD2-TRg-5":16527,
"MAK16g1-SMD2-TRg-4":16528,
"MAK16g1-SMD2-TRg-1":16529,
"MAK16g1-PRE7-TRg-4":16530,
"MAK16g1-PRE7-TRg-7":16531,
"MAK16g1-SEC6-TRg-3":16532,
"MAK16g1-ESF2-NRg-1":16533,
"MAK16g1-ESF2-NRg-3":16534,
"MAK16g1-AFG2-TRg-2":16535,
"MAK16g1-RRP36-TRg-3":16536,
"MAK16g1-RRP36-TRg-5":16537,
"MAK16g1-GCR1-NRg-2":16538,
"MAK16g1-PRE4-NRg-4":16539,
"MAK16g1-PRE4-NRg-9":16540,
"MAK16g1-DSN1-NRg-2":16541,
"MAK16g1-GPI11-TRg-3":16542,
"MAK16g1-POP3-TRg-1":16543,
"MAK16g1-MNE1-TRg-5":16544,
"MAK16g1-RRP12-NRg-1":16545,
"MAK16g1-RSC6-TRg-2":16546,
"MAK16g1-CDC25-TRg-1":16547,
"MAK16g1-CDC25-TRg-9":16548,
"MAK16g1-YPP1-NRg-3":16549,
"MAK16g1-NFS1-NRg-9":16550,
"MAK16g1-NFS1-NRg-8":16551,
"MAK16g1-UBA2-TRg-1":16552,
"MAK16g1-ARP2-NRg-3":16553,
"MAK16g1-MAK16-TRg-1":16554,
"MAK16g1-CEP3-NRg-1":16555,
"MAK16g1-GUK1-TRg-5":16556,
"MAK16g1-GUK1-TRg-2":16557,
"MAK16g1-GPI12-NRg-6":16558,
"MAK16g1-RPS5-NRg-5":16559,
"MAK16g1-RPS5-NRg-2":16560,
"MAK16g1-RPC19-NRg-1":16561,
"MAK16g1-TIM54-TRg-1":16562,
"MAK16g1-TEN1-TRg-2":16563,
"MAK16g1-SAH1-NRg-4":16564,
"MAK16g1-SAH1-NRg-5":16565,
"MAK16g1-SAH1-NRg-3":16566,
"MAK16g1-ATP15-NRg-5":16567,
"MAK16g1-SCD5-TRg-5":16568,
"MAK16g1-ARB1-NRg-2":16569,
"MAK16g1-ARB1-NRg-4":16570,
"MAK16g1-PUP2-TRg-1":16571,
"MAK16g1-CCT8-TRg-2":16572,
"MAK16g1-MCM4-TRg-1":16573,
"MAK16g1-LSM4-TRg-1":16574,
"MAK16g1-NOP53-NRg-1":16575,
"MAK16g1-ATP3-TRg-4":16576,
"MAK16g1-AFG2-NRg-3":16577,
"MAK16g1-PRO3-NRg-3":16578,
"MAK16g1-NRD1-NRg-10":16579,
"MAK16g1-SEC61-TRg-2":16580,
"MAK16g1-RHO3-TRg-4":16581,
"MAK16g1-SNF2-TRg-6":16582,
"MAK16g1-SMD2-NRg-3":16583,
"MAK16g1-RSC4-TRg-2":16584,
"MAK16g1-RSC4-TRg-1":16585,
"MAK16g1-TIF34-TRg-2":16586,
"MAK16g1-BET1-NRg-1":16587,
"MAK16g1-CDC8-NRg-2":16588,
"MAK16g1-PRP42-TRg-2":16589,
"MAK16g1-RRB1-TRg-2":16590,
"MAK16g1-SPC24-TRg-1":16591,
"MAK16g1-ILS1-NRg-1":16592,
"MAK16g1-GFA1-TRg-2":16593,
"MAK16g1-SEC21-NRg-10":16594,
"MAK16g1-RPC10-NRg-1":16595,
"MAK16g1-RPB10-TRg-3":16596,
"MAK16g1-RPB10-TRg-2":16597,
"MAK16g1-YNL181W-TRg-1":16598,
"MAK16g1-RAD3-NRg-1":16599,
"MAK16g1-NOP10-TRg-1":16600,
"MAK16g1-BFR2-TRg-3":16601,
"MAK16g1-MCM2-TRg-6":16602,
"MAK16g1-MCM2-TRg-4":16603,
"MAK16g1-MPP10-TRg-1":16604,
"MAK16g1-RET2-TRg-4":16605,
"MAK16g1-RET2-TRg-1":16606,
"MAK16g1-RPS2-NRg-1":16607,
"MAK16g1-RPS2-NRg-2":16608,
"MAK16g1-ORC4-NRg-3":16609,
"MAK16g1-TIP20-TRg-7":16610,
"MAK16g1-SMT3-TRg-1":16611,
"MAK16g1-MSS18-NRg-6":16612,
"MAK16g1-YEF3-NRg-9":16613,
"MAK16g1-ASK1-NRg-1":16614,
"MAK16g1-SMC1-TRg-1":16615,
"MAK16g1-NIP1-NRg-1":16616,
"MAK16g1-RPP1-NRg-1":16617,
"MAK16g1-YDJ1-TRg-6":16618,
"MAK16g1-SUB2-NRg-1":16619,
"MAK16g1-TIM10-NRg-8":16620,
"MAK16g1-TIM10-NRg-4":16621,
"MAK16g1-TIM10-NRg-7":16622,
"MAK16g1-SKI6-TRg-4":16623,
"MAK16g1-TUB4-TRg-1":16624,
"MAK16g1-CDC37-NRg-2":16625,
"MAK16g1-ISD11-TRg-3":16626,
"MAK16g1-YOS1-TRg-4":16627,
"MAK16g1-SSC1-TRg-6":16628,
"MAK16g1-MTR3-TRg-5":16629,
"MAK16g1-MTR3-TRg-6":16630,
"MAK16g1-TFA1-TRg-2":16631,
"MAK16g1-CDC3-NRg-3":16632,
"MAK16g1-ERG25-TA-18":16633,
"MAK16g1-RPB11-TRg-4":16634,
"MAK16g1-RPB11-TRg-1":16635,
"MAK16g1-RPB11-TRg-2":16636,
"MAK16g1-DED1-TRg-3":16637,
"MAK16g1-DED1-TRg-1":16638,
"MAK16g1-DED1-TRg-6":16639,
"MAK16g1-DED1-TRg-4":16640,
"MAK16g1-RPL10-NRg-5":16641,
"MAK16g1-RPL10-NRg-4":16642,
"MAK16g1-EFB1-NRg-1":16643,
"MAK16g1-EFB1-NRg-5":16644,
"MAK16g1-EFB1-NRg-4":16645,
"MAK16g1-RPT3-NRg-1":16646,
"MAK16g1-SAC6-TRg-8":16647,
"MAK16g1-SAC6-TRg-4":16648,
"MAK16g1-SAC6-TRg-5":16649,
"MAK16g1-SAC6-TRg-3":16650,
"MAK16g1-DIM1-TRg-5":16651,
"MAK16g1-DIM1-TRg-7":16652,
"MAK16g1-RPC17-NRg-1":16653,
"MAK16g1-RPC17-NRg-2":16654,
"MAK16g1-YDR341C-TRg-1":16655,
"MAK16g1-RAP1-NRg-8":16656,
"MAK16g1-RAP1-NRg-5":16657,
"MAK16g1-RAP1-NRg-2":16658,
"MAK16g1-SEC26-NRg-3":16659,
"MAK16g1-SPP41-TRg-3":16660,
"MAK16g1-TAP42-NRg-1":16661,
"MAK16g1-PGA2-TRg-6":16662,
"MAK16g1-BRL1-TRg-1":16663,
"MAK16g1-FOL2-TRg-1":16664,
"MAK16g1-NAB3-NRg-5":16665,
"MAK16g1-SNF4-TRg-4":16666,
"MAK16g1-HRR25-TRg-2":16667,
"MAK16g1-TRS23-TRg-4":16668,
"MAK16g1-CTR86-TRg-4":16669,
"MAK16g1-RPB5-TRg-5":16670,
"MAK16g1-SPN1-NRg-2":16671,
"MAK16g1-SPN1-NRg-1":16672,
"MAK16g1-SEC61-NRg-1":16673,
"MAK16g1-SEC61-NRg-7":16674,
"MAK16g1-TUS1-TRg-3":16675,
"MAK16g1-OLE1-NRg-2":16676,
"MAK16g1-AFG2-TRg-1":16677,
"MAK16g1-TOA2-NRg-1":16678,
"MAK16g1-USO1-TRg-1":16679,
"MAK16g1-UTP22-NRg-2":16680,
"MAK16g1-RIB1-TRg-3":16681,
"MAK16g1-RIB1-TRg-7":16682,
"MAK16g1-RIB1-TRg-4":16683,
"MAK16g1-COG1-TRg-1":16684,
"MAK16g1-RPL32-NRg-2":16685,
"MAK16g1-GLC7-NRg-3":16686,
"MAK16g1-GLC7-NRg-4":16687,
"MAK16g1-HSF1-TRg-2":16688,
"MAK16g1-DAM1-NRg-5":16689,
"MAK16g1-SEC18-TRg-4":16690,
"MAK16g1-SEC18-TRg-5":16691,
"MAK16g1-PAB1-NRg-3":16692,
"MAK16g1-POP8-TRg-2":16693,
"MAK16g1-PAB1-NRg-4":16694,
"MAK16g1-BIG1-TRg-4":16695,
"MAK16g1-BIG1-TRg-5":16696,
"MAK16g1-BIG1-TRg-6":16697,
"MAK16g1-RPO41-NRg-1":16698,
"MAK16g1-RVB2-NRg-2":16699,
"MAK16g1-PET117-NRg-8":16700,
"MAK16g1-VPS45-NRg-9":16701,
"MAK16g1-YCG1-NRg-1":16702,
"MAK16g1-NOC4-NRg-1":16703,
"MAK16g1-NMD3-NRg-2":16704,
"MAK16g1-DRS1-TRg-2":16705,
"MAK16g1-HTB1-NRg-2":16706,
"MAK16g1-IPI1-TRg-2":16707,
"MAK16g1-SEC18-NRg-1":16708,
"MAK16g1-SEC18-NRg-2":16709,
"MAK16g1-JIP5-NRg-2":16710,
"MAK16g1-YPT1-TRg-3":16711,
"MAK16g1-YPT1-TRg-2":16712,
"MAK16g1-CLF1-NRg-2":16713,
"MAK16g1-SNF2-NRg-7":16714,
"MAK16g1-SNF2-NRg-4":16715,
"MAK16g1-RPL25-NRg-1":16716,
"MAK16g1-NOP56-TRg-1":16717,
"MAK16g1-NOP56-TRg-2":16718,
"MAK16g1-TRS31-TRg-1":16719,
"MAK16g1-DBF4-TRg-2":16720,
"MAK16g1-DBF4-TRg-1":16721,
"MAK16g1-RPC19-TRg-4":16722,
"MAK16g1-RPC19-TRg-6":16723,
"MAK16g1-RPC19-TRg-3":16724,
"MAK16g1-ROK1-NRg-1":16725,
"MAK16g1-CDC33-TRg-4":16726,
"MAK16g1-DHR2-TRg-3":16727,
"MAK16g1-RRP42-NRg-5":16728,
"MAK16g1-CLF1-TRg-1":16729,
"MAK16g1-ERG11-NA-16":16730,
"MAK16g1-VAS1-NRg-4":16731,
"MAK16g1-PIK1-NRg-2":16732,
"MAK16g1-SAR1-NRg-7":16733,
"MAK16g1-SAR1-NRg-4":16734,
"MAK16g1-RPS3-TRg-1":16735,
"MAK16g1-YTM1-TRg-2":16736,
"MAK16g1-SUI3-NRg-5":16737,
"MAK16g1-SUI3-NRg-2":16738,
"MAK16g1-RRP7-TRg-4":16739,
"MAK16g1-RRP7-TRg-6":16740,
"MAK16g1-NIP7-TRg-2":16741,
"MAK16g1-MDM35-TRg-1":16742,
"MAK16g1-ALA1-NRg-1":16743,
"MAK16g1-DOA4-NRg-2":16744,
"MAK16g1-RPS13-NRg-1":16745,
"MAK16g1-YSF3-TRg-2":16746,
"MAK16g1-RPS2-NRg-11":16747,
"MAK16g1-SSL1-TRg-10":16748,
"MAK16g1-NIP7-TRg-1":16749,
"MAK16g1-LST8-NRg-1":16750,
"MAK16g1-TAF4-TRg-3":16751,
"MAK16g1-HAS1-TRg-2":16752,
"MAK16g1-GLC7-TRg-2":16753,
"MAK16g1-CDC45-NRg-1":16754,
"MAK16g1-SEC22-NRg-8":16755,
"MAK16g1-YOS1-TRg-2":16756,
"MAK16g1-RBA50-TRg-3":16757,
"MAK16g1-SPP41-NRg-2":16758,
"MAK16g1-PRP46-TRg-2":16759,
"MAK16g1-PGA2-NRg-1":16760,
"MAK16g1-CBF5-TRg-3":16761,
"MAK16g1-TCP1-NRg-3":16762,
"MAK16g1-TCP1-NRg-2":16763,
"MAK16g1-ERG26-NRg-2":16764,
"MAK16g1-ERG26-NRg-4":16765,
"MAK16g1-MES1-TRg-5":16766,
"MAK16g1-HTS1-TRg-2":16767,
"MAK16g1-SSS1-TRg-3":16768,
"MAK16g1-SSS1-TRg-2":16769,
"MAK16g1-SYS1-TRg-7":16770,
"MAK16g1-SYS1-TRg-2":16771,
"MAK16g1-SYS1-TRg-1":16772,
"MAK16g1-BFR2-TRg-1":16773,
"MAK16g1-EOS1-TRg-3":16774,
"MAK16g1-TAF4-NRg-1":16775,
"MAK16g1-ARL3-NRg-8":16776,
"MAK16g1-RPN5-NRg-1":16777,
"MAK16g1-TIM9-NRg-2":16778,
"MAK16g1-NUP57-NRg-3":16779,
"MAK16g1-VPS4-TRg-1":16780,
"MAK16g1-CDC3-TRg-4":16781,
"MAK16g1-BBP1-NRg-1":16782,
"MAK16g1-BBP1-NRg-2":16783,
"MAK16g1-USE1-NRg-3":16784,
"MAK16g1-CCT7-TRg-1":16785,
"MAK16g1-SAH1-TRg-3":16786,
"MAK16g1-CHS2-TRg-1":16787,
"MAK16g1-DPM1-TRg-2":16788,
"MAK16g1-BBP1-TRg-1":16789,
"MAK16g1-NRD1-TRg-4":16790,
"MAK16g1-RPB3-NRg-1":16791,
"MAK16g1-PHO85-NRg-6":16792,
"MAK16g1-SNF6-TRg-6":16793,
"MAK16g1-PRP38-NRg-2":16794,
"MAK16g1-OAR1-NRg-3":16795,
"MAK16g1-ROX3-NRg-1":16796,
"MAK16g1-YPP1-TRg-6":16797,
"MAK16g1-CBF2-NRg-8":16798,
"MAK16g1-SPT6-TRg-5":16799,
"MAK16g1-SEC10-NRg-1":16800,
"MAK16g1-NSL1-NRg-3":16801,
"MAK16g1-NRD1-NRg-8":16802,
"MAK16g1-RPB3-TRg-1":16803,
"MAK16g1-NRD1-NRg-4":16804,
"MAK16g1-RVB1-TRg-2":16805,
"MAK16g1-TIF5-NRg-8":16806,
"MAK16g1-EOS1-NRg-1":16807,
"MAK16g1-ERG25-NA-26":16808,
"MAK16g1-MSL5-NRg-4":16809,
"MAK16g1-SEC24-TRg-2":16810,
"MAK16g1-RPL30-NRg-5":16811,
"MAK16g1-SNU71-NRg-3":16812,
"MAK16g1-CDC33-NRg-1":16813,
"MAK16g1-RPN6-TRg-4":16814,
"MAK16g1-NAB2-TRg-4":16815,
"MAK16g1-NAB2-TRg-6":16816,
"MAK16g1-YTM1-NRg-1":16817,
"MAK16g1-OLE1-TRg-8":16818,
"MAK16g1-OLE1-TRg-1":16819,
"MAK16g1-UTP7-TRg-4":16820,
"MAK16g1-ACT1-NRg-6":16821,
"MAK16g1-RPL18A-NRg-3":16822,
"MAK16g1-BRX1-NRg-1":16823,
"MAK16g1-NAF1-TRg-8":16824,
"MAK16g1-NAF1-TRg-6":16825,
"MAK16g1-NAF1-TRg-4":16826,
"MAK16g1-CDC8-TRg-2":16827,
"MAK16g1-NSE4-TRg-1":16828,
"MAK16g1-PAB1-NRg-2":16829,
"MAK16g1-PRP43-TRg-4":16830,
"MAK16g1-SEC2-NRg-3":16831,
"MAK16g1-SEC2-NRg-6":16832,
"MAK16g1-MPP10-NRg-5":16833,
"MAK16g1-YDR355C-TRg-2":16834,
"MAK16g1-YLR339C-TRg-9":16835,
"MAK16g1-SNM1-TRg-2":16836,
"MAK16g1-ALR1-NRg-4":16837,
"MAK16g1-ALR1-NRg-1":16838,
"MAK16g1-ALR1-NRg-3":16839,
"MAK16g1-RPL10-TRg-1":16840,
"MAK16g1-RPL28-TRg-2":16841,
"MAK16g1-UTP25-TRg-1":16842,
"MAK16g1-POB3-TRg-1":16843,
"MAK16g1-POB3-TRg-3":16844,
"MAK16g1-POB3-TRg-2":16845,
"MAK16g1-MED11-TRg-1":16846,
"MAK16g1-ISA1-TRg-15":16847,
"MAK16g1-RRP1-NRg-1":16848,
"MAK16g1-MES1-NRg-1":16849,
"MAK16g1-SEC13-NRg-5":16850,
"MAK16g1-MCM2-NRg-2":16851,
"MAK16g1-ALA1-TRg-4":16852,
"MAK16g1-MTG2-TRg-5":16853,
"MAK16g1-TIF35-NRg-3":16854,
"MAK16g1-NSE1-TRg-3":16855,
"MAK16g1-NSE1-TRg-4":16856,
"MAK16g1-MOB2-NRg-6":16857,
"MAK16g1-VRG4-NRg-3":16858,
"MAK16g1-PRP9-TRg-3":16859,
"MAK16g1-HYM1-TRg-5":16860,
"MAK16g1-POP1-TRg-5":16861,
"MAK16g1-POP1-TRg-9":16862,
"MAK16g1-RPL17A-TRg-1":16863,
"MAK16g1-SLD2-TRg-1":16864,
"MAK16g1-CDC48-NRg-7":16865,
"MAK16g1-FHL1-NRg-2":16866,
"MAK16g1-BET3-NRg-7":16867,
"MAK16g1-MAK21-TRg-1":16868,
"MAK16g1-BRN1-TRg-4":16869,
"MAK16g1-FBA1-NRg-3":16870,
"MAK16g1-CDC42-TRg-6":16871,
"MAK16g1-CDC42-TRg-7":16872,
"MAK16g1-COG4-NRg-1":16873,
"MAK16g1-ATP3-NRg-3":16874,
"MAK16g1-ATP3-NRg-2":16875,
"MAK16g1-SMP3-TRg-5":16876,
"MAK16g1-CFT2-NRg-2":16877,
"MAK16g1-FAS2-TRg-5":16878,
"MAK16g1-DBP2-NRg-3":16879,
"MAK16g1-DBP2-NRg-2":16880,
"MAK16g1-MPS2-NRg-4":16881,
"MAK16g1-ARC35-TRg-2":16882,
"MAK16g1-ARC35-TRg-5":16883,
"MAK16g1-MRD1-TRg-1":16884,
"MAK16g1-RLP7-TRg-1":16885,
"MAK16g1-SPC34-TRg-1":16886,
"MAK16g1-CDC45-TRg-2":16887,
"MAK16g1-GCD6-TRg-3":16888,
"MAK16g1-GCD6-TRg-4":16889,
"MAK16g1-YPT6-NRg-2":16890,
"MAK16g1-RPS13-TRg-2":16891,
"MAK16g1-IPI3-TRg-3":16892,
"MAK16g1-TIF5-NRg-9":16893,
"MAK16g1-TIF5-NRg-7":16894,
"MAK16g1-TIF5-NRg-6":16895,
"MAK16g1-NAB3-TRg-3":16896,
"MAK16g1-GCD2-TRg-1":16897,
"MAK16g1-UBA1-TRg-2":16898,
"MAK16g1-SLD3-TRg-6":16899,
"MAK16g1-LCB1-TRg-5":16900,
"MAK16g1-TOA2-TRg-6":16901,
"MAK16g1-TOA2-TRg-1":16902,
"MAK16g1-TOA2-TRg-3":16903,
"MAK16g1-LSM2-TRg-1":16904,
"MAK16g1-YML6-TRg-13":16905,
"MAK16g1-YML6-TRg-12":16906,
"MAK16g1-UTP15-NRg-1":16907,
"MAK16g1-TIF6-NRg-8":16908,
"MAK16g1-SUP35-NRg-1":16909,
"MAK16g1-MPP10-NRg-1":16910,
"MAK16g1-SWI3-TRg-7":16911,
"MAK16g1-SSN3-NRg-2":16912,
"MAK16g1-SEC13-NRg-7":16913,
"MAK16g1-RPS15-NRg-3":16914,
"MAK16g1-RPL3-TRg-2":16915,
"MAK16g1-FBA1-NRg-2":16916,
"MAK16g1-FBA1-NRg-1":16917,
"MAK16g1-FBA1-NRg-5":16918,
"MAK16g1-DAM1-TRg-2":16919,
"MAK16g1-NHP2-TRg-2":16920,
"MAK16g1-HCA4-NRg-6":16921,
"MAK16g1-PRE3-TRg-4":16922,
"MAK16g1-DBP5-NRg-4":16923,
"MAK16g1-SPT6-NRg-4":16924,
"MAK16g1-SPT6-NRg-2":16925,
"MAK16g1-RPL18A-TRg-4":16926,
"MAK16g1-KSH1-TRg-1":16927,
"MAK16g1-KSH1-TRg-3":16928,
"MAK16g1-IPI3-NRg-1":16929,
"MAK16g1-PGA2-TRg-8":16930,
"MAK16g1-RPL18A-TRg-2":16931,
"MAK16g1-RPL33A-NRg-6":16932,
"MAK16g1-TAF12-NRg-2":16933,
"MAK16g1-USE1-TRg-5":16934,
"MAK16g1-YNL114C-TRg-1":16935,
"MAK16g1-SMC5-TRg-7":16936,
"MAK16g1-SMC5-TRg-6":16937,
"MAK16g1-RSC58-TRg-1":16938,
"MAK16g1-CTF13-TRg-2":16939,
"MAK16g1-NAB2-NRg-2":16940,
"MAK16g1-MCM7-TRg-4":16941,
"MAK16g1-BCP1-NRg-5":16942,
"MAK16g1-STU2-TRg-3":16943,
"MAK16g1-SEC21-NRg-6":16944,
"MAK16g1-SEC21-NRg-3":16945,
"MAK16g1-RPL1B-TRg-3":16946,
"MAK16g1-SEC20-NRg-2":16947,
"MAK16g1-VMA3-NRg-2":16948,
"MAK16g1-SEC23-NRg-5":16949,
"MAK16g1-CDC28-TRg-4":16950,
"MAK16g1-RPN12-NRg-11":16951,
"MAK16g1-PUP3-TRg-3":16952,
"MAK16g1-SEC31-TRg-2":16953,
"MAK16g1-SED5-TRg-6":16954,
"MAK16g1-SED5-TRg-5":16955,
"MAK16g1-RPL33A-TRg-1":16956,
"MAK16g1-RPL33A-TRg-2":16957,
"MAK16g1-MRPL11-TRg-2":16958,
"MAK16g1-RTP1-NRg-2":16959,
"MAK16g1-NUG1-TRg-2":16960,
"MAK16g1-VPH2-TRg-4":16961,
"MAK16g1-COP1-NRg-3":16962,
"MAK16g1-CRM1-NRg-1":16963,
"MAK16g1-RPL5-NRg-4":16964,
"MAK16g1-SNU13-NRg-4":16965,
"MAK16g1-PFS2-TRg-3":16966,
"MAK16g1-MPP10-TRg-2":16967,
"MAK16g1-TSR4-NRg-2":16968,
"MAK16g1-RSC2-TRg-1":16969,
"MAK16g1-SEC65-TRg-2":16970,
"MAK16g1-SMI1-NRg-1":16971,
"MAK16g1-RTT105-NRg-4":16972,
"MAK16g1-VMA5-TRg-3":16973,
"MAK16g1-VMA5-TRg-5":16974,
"MAK16g1-RRP1-TRg-3":16975,
"MAK16g1-CLC1-TRg-2":16976,
"MAK16g1-GCD6-NRg-1":16977,
"MAK16g1-GCD6-NRg-2":16978,
"MAK16g1-PXR1-TRg-1":16979,
"MAK16g1-CDC14-NRg-1":16980,
"MAK16g1-PCF11-TRg-6":16981,
"MAK16g1-PCF11-TRg-5":16982,
"MAK16g1-PCF11-TRg-4":16983,
"MAK16g1-SEC31-NRg-1":16984,
"MAK16g1-RRP5-NRg-1":16985,
"MAK16g1-PRE10-TRg-5":16986,
"MAK16g1-PRE10-TRg-1":16987,
"MAK16g1-RPS5-TRg-2":16988,
"MAK16g1-NSP1-TRg-4":16989,
"MAK16g1-PRP38-TRg-4":16990,
"MAK16g1-RCF1-NRg-5":16991,
"MAK16g1-RSC3-TRg-4":16992,
"MAK16g1-RSC3-TRg-5":16993,
"MAK16g1-RSC3-TRg-6":16994,
"MAK16g1-HTA1-NRg-12":16995,
"MAK16g1-HTA1-NRg-11":16996,
"MAK16g1-UTP23-TRg-2":16997,
"MAK16g1-GCD7-NRg-1":16998,
"MAK16g1-GCD7-NRg-2":16999,
"MAK16g1-GCD7-NRg-6":17000,
"MAK16g1-GAL11-NRg-2":17001,
"MAK16g1-GAL11-NRg-9":17002,
"MAK16g1-PHO4-TRg-5":17003,
"MAK16g1-SNP1-NRg-3":17004,
"MAK16g1-RPC37-TRg-5":17005,
"MAK16g1-CRM1-TRg-5":17006,
"MAK16g1-CRM1-TRg-2":17007,
"MAK16g1-ASK1-TRg-7":17008,
"MAK16g1-STU2-NRg-4":17009,
"MAK16g1-NEO1-NRg-3":17010,
"MAK16g1-GAL11-TRg-5":17011,
"MAK16g1-GAL11-TRg-7":17012,
"MAK16g1-SAM50-NRg-3":17013,
"MAK16g1-CSL4-TRg-2":17014,
"MAK16g1-CCT5-TRg-2":17015,
"MAK16g1-POL30-NRg-1":17016,
"MAK16g1-MED4-TRg-4":17017,
"MAK16g1-MED4-TRg-3":17018,
"MAK16g1-MED4-TRg-2":17019,
"MAK16g1-GDI1-TRg-4":17020,
"MAK16g1-GDI1-TRg-3":17021,
"MAK16g1-REB1-TRg-6":17022,
"MAK16g1-MRPL37-NRg-2":17023,
"MAK16g1-NOC3-TRg-3":17024,
"MAK16g1-SPC97-TRg-3":17025,
"MAK16g1-IPP1-TRg-3":17026,
"MAK16g1-IPP1-TRg-2":17027,
"MAK16g1-PTI1-TRg-3":17028,
"MAK16g1-PTI1-TRg-5":17029,
"MAK16g1-RFC5-NRg-1":17030,
"MAK16g1-CDC24-TRg-1":17031,
"MAK16g1-CDC24-TRg-3":17032,
"MAK16g1-CDC24-TRg-5":17033,
"MAK16g1-CDC24-TRg-6":17034,
"MAK16g1-UTP23-TRg-6":17035,
"MAK16g1-UTP23-TRg-4":17036,
"MAK16g1-UTP23-TRg-1":17037,
"MAK16g1-RHO3-NRg-4":17038,
"MAK16g1-TRS23-NRg-1":17039,
"MAK16g1-TRS23-NRg-3":17040,
"MAK16g1-RSP5-TRg-2":17041,
"MAK16g1-RSP5-TRg-1":17042,
"MAK16g1-SDA1-NRg-1":17043,
"MAK16g1-KAP95-TRg-8":17044,
"MAK16g1-ACO1-TRg-6":17045,
"MAK16g1-HTA1-NRg-3":17046,
"MAK16g1-HTA1-NRg-2":17047,
"MAK16g1-SPN1-TRg-1":17048,
"MAK16g1-MOT1-NRg-7":17049,
"MAK16g1-RPL17A-NRg-4":17050,
"MAK16g1-ADA2-TRg-4":17051,
"MAK16g1-SFH1-NRg-1":17052,
"MAK16g1-SPC97-NRg-5":17053,
"MAK16g1-PRP22-TRg-3":17054,
"MAK16g1-SEN15-TRg-2":17055,
"MAK16g1-RPL3-NRg-2":17056,
"MAK16g1-ISD11-NRg-2":17057,
"MAK16g1-HEM12-TRg-8":17058,
"MAK16g1-SEC10-TRg-1":17059,
"MAK16g1-HTB1-TRg-7":17060,
"MAK16g1-TTI2-TRg-1":17061,
"MAK16g1-ACP1-TRg-2":17062,
"MAK16g1-ACP1-TRg-4":17063,
"MAK16g1-GAL11-NRg-10":17064,
"MAK16g1-UTP22-TRg-2":17065,
"MAK16g1-MST1-NRg-5":17066,
"MAK16g1-RIB7-NRg-2":17067,
"MAK16g1-MCD1-TRg-6":17068,
"MAK16g1-MCD1-TRg-5":17069,
"MAK16g1-GPI8-NRg-2":17070,
"MAK16g1-THS1-TRg-2":17071,
"MAK16g1-RRP7-TRg-2":17072,
"MAK16g1-RRP7-TRg-5":17073,
"MAK16g1-SMX2-NRg-7":17074,
"MAK16g1-RRP45-TRg-5":17075,
"MAK16g1-RRP45-TRg-4":17076,
"MAK16g1-CNS1-TRg-2":17077,
"MAK16g1-FBP1-NRg-9":17078,
"MAK16g1-GCD11-NRg-1":17079,
"MAK16g1-RPL10-TRg-2":17080,
"MAK16g1-NUP192-TRg-4":17081,
"MAK16g1-NUP145-NRg-4":17082,
"MAK16g1-HEM12-TRg-6":17083,
"MAK16g1-PLC1-TRg-3":17084,
"MAK16g1-RPA43-TRg-1":17085,
"MAK16g1-RPB7-NRg-2":17086,
"MAK16g1-RPB7-NRg-3":17087,
"MAK16g1-NSL1-NRg-1":17088,
"MAK16g1-UTP6-TRg-3":17089,
"MAK16g1-UTP6-TRg-1":17090,
"MAK16g1-YJU2-TRg-5":17091,
"MAK16g1-FRS2-NRg-5":17092,
"MAK16g1-TIF35-NRg-2":17093,
"MAK16g1-GPI15-TRg-1":17094,
"MAK16g1-NOP1-NRg-5":17095,
"MAK16g1-GPI15-TRg-4":17096,
"MAK16g1-COG4-TRg-1":17097,
"MAK16g1-TFA1-TRg-1":17098,
"MAK16g1-RHO1-NRg-2":17099,
"MAK16g1-RHO1-NRg-1":17100,
"MAK16g1-CDC55-NRg-2":17101,
"MAK16g1-IDI1-NRg-7":17102,
"MAK16g1-RPL32-TRg-5":17103,
"MAK16g1-RPB5-TRg-4":17104,
"MAK16g1-DIP2-TRg-5":17105,
"MAK16g1-DIP2-TRg-1":17106,
"MAK16g1-RPC40-TRg-2":17107,
"MAK16g1-CDC6-TRg-5":17108,
"MAK16g1-CDC6-TRg-3":17109,
"MAK16g1-DAD2-TRg-2":17110,
"MAK16g1-RVS161-TRg-2":17111,
"MAK16g1-RVS161-TRg-1":17112,
"MAK16g1-SUP45-NRg-3":17113,
"MAK16g1-SRB6-NRg-5":17114,
"MAK16g1-RPC11-TRg-4":17115,
"MAK16g1-RKI1-TRg-8":17116,
"MAK16g1-NIP7-TRg-3":17117,
"MAK16g1-RPL33A-NRg-12":17118,
"MAK16g1-SAM50-TRg-4":17119,
"MAK16g1-NOP4-NRg-1":17120,
"MAK16g1-NOP4-NRg-3":17121,
"MAK16g1-SMX2-TRg-5":17122,
"MAK16g1-POL12-NRg-2":17123,
"MAK16g1-BMS1-NRg-2":17124,
"MAK16g1-RPA190-TRg-5":17125,
"MAK16g1-ALG14-NRg-4":17126,
"MAK16g1-ALG14-NRg-1":17127,
"MAK16g1-PRE5-NRg-1":17128,
"MAK16g1-BIG1-NRg-2":17129,
"MAK16g1-TFA2-TRg-4":17130,
"MAK16g1-IMP4-TRg-6":17131,
"MAK16g1-PAN1-NRg-1":17132,
"MAK16g1-UTP13-TRg-2":17133,
"MAK16g1-KAE1-NRg-3":17134,
"MAK16g1-ERG20-TRg-1":17135,
"MAK16g1-CDC20-TRg-6":17136,
"MAK16g1-PWP2-NRg-2":17137,
"MAK16g1-COG1-NRg-1":17138,
"MAK16g1-RPL1B-TRg-4":17139,
"MAK16g1-RPL1B-TRg-7":17140,
"MAK16g1-UTP20-TRg-3":17141,
"MAK16g1-UTP20-TRg-4":17142,
"MAK16g1-RPL25-TRg-4":17143,
"MAK16g1-RPL25-TRg-2":17144,
"MAK16g1-MCM7-NRg-1":17145,
"MAK16g1-MRP49-TRg-5":17146,
"MAK16g1-ERO1-NRg-3":17147,
"MAK16g1-UTP5-TRg-7":17148,
"MAK16g1-MCM4-NRg-1":17149,
"MAK16g1-PRE3-NRg-1":17150,
"MAK16g1-FCF1-NRg-1":17151,
"MAK16g1-CUS1-NRg-1":17152,
"MAK16g1-PSF1-TRg-2":17153,
"MAK16g1-BCP1-TRg-2":17154,
"MAK16g1-PAN1-TRg-1":17155,
"MAK16g1-PAN1-TRg-3":17156,
"MAK16g1-PAN1-TRg-4":17157,
"MAK16g1-VPS3-TRg-2":17158,
"MAK16g1-YIL060W-NRg-1":17159,
"MAK16g1-VPS53-NRg-1":17160,
"MAK16g1-CYR1-TRg-4":17161,
"MAK16g1-CYR1-TRg-7":17162,
"MAK16g1-MPS1-NRg-1":17163,
"MAK16g1-SRP1-TRg-5":17164,
"MAK16g1-SRP1-TRg-4":17165,
"MAK16g1-TAF12-TRg-2":17166,
"MAK16g1-TAF12-TRg-3":17167,
"MAK16g1-POP4-TRg-1":17168,
"MAK16g1-SPT16-TRg-1":17169,
"MAK16g1-NUP82-TRg-4":17170,
"MAK16g1-DML1-TRg-3":17171,
"MAK16g1-RPA43-NRg-3":17172,
"MAK16g1-STU2-NRg-3":17173,
"MAK16g1-POP4-NRg-4":17174,
"MAK16g1-MCD1-TRg-2":17175,
"MAK16g1-RPS3-NRg-4":17176,
"MAK16g1-PRP9-TRg-4":17177,
"MAK16g1-RPP1-NRg-2":17178,
"MAK16g1-MTR2-NRg-11":17179,
"MAK16g1-GCD11-TRg-1":17180,
"MAK16g1-RPF1-TRg-3":17181,
"MAK16g1-SUB2-NRg-4":17182,
"MAK16g1-GPI15-TRg-3":17183,
"MAK16g1-ERG9-TRg-6":17184,
"MAK16g1-RPT2-NRg-1":17185,
"MAK16g1-YOS1-NRg-3":17186,
"MAK16g1-SCM3-TRg-4":17187,
"MAK16g1-SCM3-TRg-6":17188,
"MAK16g1-RLP7-NRg-1":17189,
"MAK16g1-TFB2-NRg-4":17190,
"MAK16g1-IMP4-TRg-1":17191,
"MAK16g1-IMP4-TRg-3":17192,
"MAK16g1-PRE4-TRg-3":17193,
"MAK16g1-SUB2-TRg-3":17194,
"MAK16g1-RPP0-NRg-4":17195,
"MAK16g1-RPP0-NRg-3":17196,
"MAK16g1-TOM40-TRg-4":17197,
"MAK16g1-FUR1-NRg-12":17198,
"MAK16g1-TOM40-TRg-2":17199,
"MAK16g1-VMA11-NRg-4":17200,
"MAK16g1-PGS1-NRg-4":17201,
"MAK16g1-URB1-TRg-4":17202,
"MAK16g1-ARP4-TRg-3":17203,
"MAK16g1-RPT3-TRg-3":17204,
"MAK16g1-SUI3-TRg-3":17205,
"MAK16g1-RFC5-NRg-2":17206,
"MAK16g1-RRP14-TRg-2":17207,
"MAK16g1-SCC2-TRg-1":17208,
"MAK16g1-SSC1-TRg-3":17209,
"MAK16g1-RRP9-TRg-3":17210,
"MAK16g1-MOT1-NRg-9":17211,
"MAK16g1-RPL42A-NRg-2":17212,
"MAK16g1-SEC16-TRg-7":17213,
"MAK16g1-IMP4-NRg-2":17214,
"MAK16g1-YEF3-NRg-4":17215,
"MAK16g1-PUP1-TRg-1":17216,
"MAK16g1-UTP22-TRg-6":17217,
"MAK16g1-DBP2-NRg-4":17218,
"MAK16g1-PRE2-TRg-7":17219,
"MAK16g1-ATP16-TRg-6":17220,
"MAK16g1-UTP13-TRg-4":17221,
"MAK16g1-DOP1-NRg-4":17222,
"MAK16g1-TIM44-TRg-3":17223,
"MAK16g1-ATP16-TRg-2":17224,
"MAK16g1-ENP1-NRg-3":17225,
"MAK16g1-NAF1-TRg-3":17226,
"MAK16g1-COG4-TRg-2":17227,
"MAK16g1-SOG2-TRg-7":17228,
"MAK16g1-YDR341C-TRg-3":17229,
"MAK16g1-YMR290W-A-TRg-10":17230,
"MAK16g1-NUP192-NRg-9":17231,
"MAK16g1-RPS31-NRg-8":17232,
"MAK16g1-SPC97-NRg-6":17233,
"MAK16g1-EBP2-NRg-1":17234,
"MAK16g1-CDC48-TRg-5":17235,
"MAK16g1-RPT1-TRg-4":17236,
"MAK16g1-ULP1-NRg-2":17237,
"MAK16g1-RPN3-TRg-6":17238,
"MAK16g1-RPT1-TRg-5":17239,
"MAK16g1-KRE5-TRg-2":17240,
"MAK16g1-TBF1-NRg-8":17241,
"MAK16g1-UTP22-NRg-4":17242,
"MAK16g1-SSC1-NRg-4":17243,
"MAK16g1-REB1-TRg-4":17244,
"MAK16g1-CDC48-NRg-9":17245,
"MAK16g1-FAS2-TRg-8":17246,
"MAK16g1-TAO3-TRg-8":17247,
"MAK16g1-CKS1-TRg-5":17248,
"MAK16g1-YLR379W-TRg-7":17249,
"MAK16g1-TEN1-NRg-2":17250,
"MAK16g1-RPL42A-TRg-2":17251,
"MAK16g1-SEC27-TRg-4":17252,
"MAK16g1-TBF1-NRg-4":17253,
"MAK16g1-RPT1-NRg-6":17254,
"MAK16g1-COG1-TRg-3":17255,
"MAK16g1-SUI1-TRg-6":17256,
"MAK16g1-TIM23-TRg-6":17257,
"MAK16g1-CDC48-NRg-6":17258,
"MAK16g1-EPL1-TRg-5":17259,
"MAK16g1-RPT5-TRg-8":17260,
"MAK16g1-ATP16-NRg-4":17261,
"MAK16g1-RPN6-TRg-3":17262,
"MAK16g1-ERG9-NRg-6":17263,
"MAK16g1-SMX3-TRg-1":17264,
"MAK16g1-NCB2-NRg-3":17265,
"MAK16g1-SEC16-NRg-12":17266,
"MAK16g1-RPN6-TRg-2":17267,
"MAK16g1-REB1-NRg-4":17268,
"MAK16g1-ATP16-TRg-9":17269,
"MAK16g1-ERG9-NRg-7":17270,
"YCR016Wg4-RPL15A-NRg-4":17271,
"YCR016Wg4-RPL15A-NRg-5":17272,
"YCR016Wg4-KRE33-TRg-1":17273,
"YCR016Wg4-PMI40-NRg-1":17274,
"YCR016Wg4-NOP19-NRg-3":17275,
"YCR016Wg4-SRP14-NRg-4":17276,
"YCR016Wg4-SEC27-TRg-2":17277,
"YCR016Wg4-GPI14-TRg-3":17278,
"YCR016Wg4-PAH1-TRg-7":17279,
"YCR016Wg4-PAH1-TRg-6":17280,
"YCR016Wg4-PAH1-TRg-5":17281,
"YCR016Wg4-PAH1-TRg-3":17282,
"YCR016Wg4-COG3-TRg-1":17283,
"YCR016Wg4-HTS1-NRg-5":17284,
"YCR016Wg4-MSN5-TRg-7":17285,
"YCR016Wg4-ERG26-TRg-1":17286,
"YCR016Wg4-SMD2-TRg-5":17287,
"YCR016Wg4-SMD2-TRg-4":17288,
"YCR016Wg4-SMD2-TRg-1":17289,
"YCR016Wg4-PRE7-TRg-4":17290,
"YCR016Wg4-PRE7-TRg-7":17291,
"YCR016Wg4-SEC6-TRg-3":17292,
"YCR016Wg4-ESF2-NRg-1":17293,
"YCR016Wg4-ESF2-NRg-3":17294,
"YCR016Wg4-AFG2-TRg-2":17295,
"YCR016Wg4-RRP36-TRg-3":17296,
"YCR016Wg4-RRP36-TRg-5":17297,
"YCR016Wg4-GCR1-NRg-2":17298,
"YCR016Wg4-PRE4-NRg-4":17299,
"YCR016Wg4-PRE4-NRg-9":17300,
"YCR016Wg4-DSN1-NRg-2":17301,
"YCR016Wg4-GPI11-TRg-3":17302,
"YCR016Wg4-POP3-TRg-1":17303,
"YCR016Wg4-MNE1-TRg-5":17304,
"YCR016Wg4-RRP12-NRg-1":17305,
"YCR016Wg4-RSC6-TRg-2":17306,
"YCR016Wg4-CDC25-TRg-1":17307,
"YCR016Wg4-CDC25-TRg-9":17308,
"YCR016Wg4-YPP1-NRg-3":17309,
"YCR016Wg4-NFS1-NRg-9":17310,
"YCR016Wg4-NFS1-NRg-8":17311,
"YCR016Wg4-UBA2-TRg-1":17312,
"YCR016Wg4-ARP2-NRg-3":17313,
"YCR016Wg4-MAK16-TRg-1":17314,
"YCR016Wg4-CEP3-NRg-1":17315,
"YCR016Wg4-GUK1-TRg-5":17316,
"YCR016Wg4-GUK1-TRg-2":17317,
"YCR016Wg4-GPI12-NRg-6":17318,
"YCR016Wg4-RPS5-NRg-5":17319,
"YCR016Wg4-RPS5-NRg-2":17320,
"YCR016Wg4-RPC19-NRg-1":17321,
"YCR016Wg4-TIM54-TRg-1":17322,
"YCR016Wg4-TEN1-TRg-2":17323,
"YCR016Wg4-SAH1-NRg-4":17324,
"YCR016Wg4-SAH1-NRg-5":17325,
"YCR016Wg4-SAH1-NRg-3":17326,
"YCR016Wg4-ATP15-NRg-5":17327,
"YCR016Wg4-SCD5-TRg-5":17328,
"YCR016Wg4-ARB1-NRg-2":17329,
"YCR016Wg4-ARB1-NRg-4":17330,
"YCR016Wg4-PUP2-TRg-1":17331,
"YCR016Wg4-CCT8-TRg-2":17332,
"YCR016Wg4-MCM4-TRg-1":17333,
"YCR016Wg4-LSM4-TRg-1":17334,
"YCR016Wg4-NOP53-NRg-1":17335,
"YCR016Wg4-ATP3-TRg-4":17336,
"YCR016Wg4-AFG2-NRg-3":17337,
"YCR016Wg4-PRO3-NRg-3":17338,
"YCR016Wg4-NRD1-NRg-10":17339,
"YCR016Wg4-SEC61-TRg-2":17340,
"YCR016Wg4-RHO3-TRg-4":17341,
"YCR016Wg4-SNF2-TRg-6":17342,
"YCR016Wg4-SMD2-NRg-3":17343,
"YCR016Wg4-RSC4-TRg-2":17344,
"YCR016Wg4-RSC4-TRg-1":17345,
"YCR016Wg4-TIF34-TRg-2":17346,
"YCR016Wg4-BET1-NRg-1":17347,
"YCR016Wg4-CDC8-NRg-2":17348,
"YCR016Wg4-PRP42-TRg-2":17349,
"YCR016Wg4-RRB1-TRg-2":17350,
"YCR016Wg4-SPC24-TRg-1":17351,
"YCR016Wg4-ILS1-NRg-1":17352,
"YCR016Wg4-GFA1-TRg-2":17353,
"YCR016Wg4-SEC21-NRg-10":17354,
"YCR016Wg4-RPC10-NRg-1":17355,
"YCR016Wg4-RPB10-TRg-3":17356,
"YCR016Wg4-RPB10-TRg-2":17357,
"YCR016Wg4-YNL181W-TRg-1":17358,
"YCR016Wg4-RAD3-NRg-1":17359,
"YCR016Wg4-NOP10-TRg-1":17360,
"YCR016Wg4-BFR2-TRg-3":17361,
"YCR016Wg4-MCM2-TRg-6":17362,
"YCR016Wg4-MCM2-TRg-4":17363,
"YCR016Wg4-MPP10-TRg-1":17364,
"YCR016Wg4-RET2-TRg-4":17365,
"YCR016Wg4-RET2-TRg-1":17366,
"YCR016Wg4-RPS2-NRg-1":17367,
"YCR016Wg4-RPS2-NRg-2":17368,
"YCR016Wg4-ORC4-NRg-3":17369,
"YCR016Wg4-TIP20-TRg-7":17370,
"YCR016Wg4-SMT3-TRg-1":17371,
"YCR016Wg4-MSS18-NRg-6":17372,
"YCR016Wg4-YEF3-NRg-9":17373,
"YCR016Wg4-ASK1-NRg-1":17374,
"YCR016Wg4-SMC1-TRg-1":17375,
"YCR016Wg4-NIP1-NRg-1":17376,
"YCR016Wg4-RPP1-NRg-1":17377,
"YCR016Wg4-YDJ1-TRg-6":17378,
"YCR016Wg4-SUB2-NRg-1":17379,
"YCR016Wg4-TIM10-NRg-8":17380,
"YCR016Wg4-TIM10-NRg-4":17381,
"YCR016Wg4-TIM10-NRg-7":17382,
"YCR016Wg4-SKI6-TRg-4":17383,
"YCR016Wg4-TUB4-TRg-1":17384,
"YCR016Wg4-CDC37-NRg-2":17385,
"YCR016Wg4-ISD11-TRg-3":17386,
"YCR016Wg4-YOS1-TRg-4":17387,
"YCR016Wg4-SSC1-TRg-6":17388,
"YCR016Wg4-MTR3-TRg-5":17389,
"YCR016Wg4-MTR3-TRg-6":17390,
"YCR016Wg4-TFA1-TRg-2":17391,
"YCR016Wg4-CDC3-NRg-3":17392,
"YCR016Wg4-ERG25-TA-18":17393,
"YCR016Wg4-RPB11-TRg-4":17394,
"YCR016Wg4-RPB11-TRg-1":17395,
"YCR016Wg4-RPB11-TRg-2":17396,
"YCR016Wg4-DED1-TRg-3":17397,
"YCR016Wg4-DED1-TRg-1":17398,
"YCR016Wg4-DED1-TRg-6":17399,
"YCR016Wg4-DED1-TRg-4":17400,
"YCR016Wg4-RPL10-NRg-5":17401,
"YCR016Wg4-RPL10-NRg-4":17402,
"YCR016Wg4-EFB1-NRg-1":17403,
"YCR016Wg4-EFB1-NRg-5":17404,
"YCR016Wg4-EFB1-NRg-4":17405,
"YCR016Wg4-RPT3-NRg-1":17406,
"YCR016Wg4-SAC6-TRg-8":17407,
"YCR016Wg4-SAC6-TRg-4":17408,
"YCR016Wg4-SAC6-TRg-5":17409,
"YCR016Wg4-SAC6-TRg-3":17410,
"YCR016Wg4-DIM1-TRg-5":17411,
"YCR016Wg4-DIM1-TRg-7":17412,
"YCR016Wg4-RPC17-NRg-1":17413,
"YCR016Wg4-RPC17-NRg-2":17414,
"YCR016Wg4-YDR341C-TRg-1":17415,
"YCR016Wg4-RAP1-NRg-8":17416,
"YCR016Wg4-RAP1-NRg-5":17417,
"YCR016Wg4-RAP1-NRg-2":17418,
"YCR016Wg4-SEC26-NRg-3":17419,
"YCR016Wg4-SPP41-TRg-3":17420,
"YCR016Wg4-TAP42-NRg-1":17421,
"YCR016Wg4-PGA2-TRg-6":17422,
"YCR016Wg4-BRL1-TRg-1":17423,
"YCR016Wg4-FOL2-TRg-1":17424,
"YCR016Wg4-NAB3-NRg-5":17425,
"YCR016Wg4-SNF4-TRg-4":17426,
"YCR016Wg4-HRR25-TRg-2":17427,
"YCR016Wg4-TRS23-TRg-4":17428,
"YCR016Wg4-CTR86-TRg-4":17429,
"YCR016Wg4-RPB5-TRg-5":17430,
"YCR016Wg4-SPN1-NRg-2":17431,
"YCR016Wg4-SPN1-NRg-1":17432,
"YCR016Wg4-SEC61-NRg-1":17433,
"YCR016Wg4-SEC61-NRg-7":17434,
"YCR016Wg4-TUS1-TRg-3":17435,
"YCR016Wg4-OLE1-NRg-2":17436,
"YCR016Wg4-AFG2-TRg-1":17437,
"YCR016Wg4-TOA2-NRg-1":17438,
"YCR016Wg4-USO1-TRg-1":17439,
"YCR016Wg4-UTP22-NRg-2":17440,
"YCR016Wg4-RIB1-TRg-3":17441,
"YCR016Wg4-RIB1-TRg-7":17442,
"YCR016Wg4-RIB1-TRg-4":17443,
"YCR016Wg4-COG1-TRg-1":17444,
"YCR016Wg4-RPL32-NRg-2":17445,
"YCR016Wg4-GLC7-NRg-3":17446,
"YCR016Wg4-GLC7-NRg-4":17447,
"YCR016Wg4-HSF1-TRg-2":17448,
"YCR016Wg4-DAM1-NRg-5":17449,
"YCR016Wg4-SEC18-TRg-4":17450,
"YCR016Wg4-SEC18-TRg-5":17451,
"YCR016Wg4-PAB1-NRg-3":17452,
"YCR016Wg4-POP8-TRg-2":17453,
"YCR016Wg4-PAB1-NRg-4":17454,
"YCR016Wg4-BIG1-TRg-4":17455,
"YCR016Wg4-BIG1-TRg-5":17456,
"YCR016Wg4-BIG1-TRg-6":17457,
"YCR016Wg4-RPO41-NRg-1":17458,
"YCR016Wg4-RVB2-NRg-2":17459,
"YCR016Wg4-PET117-NRg-8":17460,
"YCR016Wg4-VPS45-NRg-9":17461,
"YCR016Wg4-YCG1-NRg-1":17462,
"YCR016Wg4-NOC4-NRg-1":17463,
"YCR016Wg4-NMD3-NRg-2":17464,
"YCR016Wg4-DRS1-TRg-2":17465,
"YCR016Wg4-HTB1-NRg-2":17466,
"YCR016Wg4-IPI1-TRg-2":17467,
"YCR016Wg4-SEC18-NRg-1":17468,
"YCR016Wg4-SEC18-NRg-2":17469,
"YCR016Wg4-JIP5-NRg-2":17470,
"YCR016Wg4-YPT1-TRg-3":17471,
"YCR016Wg4-YPT1-TRg-2":17472,
"YCR016Wg4-CLF1-NRg-2":17473,
"YCR016Wg4-SNF2-NRg-7":17474,
"YCR016Wg4-SNF2-NRg-4":17475,
"YCR016Wg4-RPL25-NRg-1":17476,
"YCR016Wg4-NOP56-TRg-1":17477,
"YCR016Wg4-NOP56-TRg-2":17478,
"YCR016Wg4-TRS31-TRg-1":17479,
"YCR016Wg4-DBF4-TRg-2":17480,
"YCR016Wg4-DBF4-TRg-1":17481,
"YCR016Wg4-RPC19-TRg-4":17482,
"YCR016Wg4-RPC19-TRg-6":17483,
"YCR016Wg4-RPC19-TRg-3":17484,
"YCR016Wg4-ROK1-NRg-1":17485,
"YCR016Wg4-CDC33-TRg-4":17486,
"YCR016Wg4-DHR2-TRg-3":17487,
"YCR016Wg4-RRP42-NRg-5":17488,
"YCR016Wg4-CLF1-TRg-1":17489,
"YCR016Wg4-ERG11-NA-16":17490,
"YCR016Wg4-VAS1-NRg-4":17491,
"YCR016Wg4-PIK1-NRg-2":17492,
"YCR016Wg4-SAR1-NRg-7":17493,
"YCR016Wg4-SAR1-NRg-4":17494,
"YCR016Wg4-RPS3-TRg-1":17495,
"YCR016Wg4-YTM1-TRg-2":17496,
"YCR016Wg4-SUI3-NRg-5":17497,
"YCR016Wg4-SUI3-NRg-2":17498,
"YCR016Wg4-RRP7-TRg-4":17499,
"YCR016Wg4-RRP7-TRg-6":17500,
"YCR016Wg4-NIP7-TRg-2":17501,
"YCR016Wg4-MDM35-TRg-1":17502,
"YCR016Wg4-ALA1-NRg-1":17503,
"YCR016Wg4-DOA4-NRg-2":17504,
"YCR016Wg4-RPS13-NRg-1":17505,
"YCR016Wg4-YSF3-TRg-2":17506,
"YCR016Wg4-RPS2-NRg-11":17507,
"YCR016Wg4-SSL1-TRg-10":17508,
"YCR016Wg4-NIP7-TRg-1":17509,
"YCR016Wg4-LST8-NRg-1":17510,
"YCR016Wg4-TAF4-TRg-3":17511,
"YCR016Wg4-HAS1-TRg-2":17512,
"YCR016Wg4-GLC7-TRg-2":17513,
"YCR016Wg4-CDC45-NRg-1":17514,
"YCR016Wg4-SEC22-NRg-8":17515,
"YCR016Wg4-YOS1-TRg-2":17516,
"YCR016Wg4-RBA50-TRg-3":17517,
"YCR016Wg4-SPP41-NRg-2":17518,
"YCR016Wg4-PRP46-TRg-2":17519,
"YCR016Wg4-PGA2-NRg-1":17520,
"YCR016Wg4-CBF5-TRg-3":17521,
"YCR016Wg4-TCP1-NRg-3":17522,
"YCR016Wg4-TCP1-NRg-2":17523,
"YCR016Wg4-ERG26-NRg-2":17524,
"YCR016Wg4-ERG26-NRg-4":17525,
"YCR016Wg4-MES1-TRg-5":17526,
"YCR016Wg4-HTS1-TRg-2":17527,
"YCR016Wg4-SSS1-TRg-3":17528,
"YCR016Wg4-SSS1-TRg-2":17529,
"YCR016Wg4-SYS1-TRg-7":17530,
"YCR016Wg4-SYS1-TRg-2":17531,
"YCR016Wg4-SYS1-TRg-1":17532,
"YCR016Wg4-BFR2-TRg-1":17533,
"YCR016Wg4-EOS1-TRg-3":17534,
"YCR016Wg4-TAF4-NRg-1":17535,
"YCR016Wg4-ARL3-NRg-8":17536,
"YCR016Wg4-RPN5-NRg-1":17537,
"YCR016Wg4-TIM9-NRg-2":17538,
"YCR016Wg4-NUP57-NRg-3":17539,
"YCR016Wg4-VPS4-TRg-1":17540,
"YCR016Wg4-CDC3-TRg-4":17541,
"YCR016Wg4-BBP1-NRg-1":17542,
"YCR016Wg4-BBP1-NRg-2":17543,
"YCR016Wg4-USE1-NRg-3":17544,
"YCR016Wg4-CCT7-TRg-1":17545,
"YCR016Wg4-SAH1-TRg-3":17546,
"YCR016Wg4-CHS2-TRg-1":17547,
"YCR016Wg4-DPM1-TRg-2":17548,
"YCR016Wg4-BBP1-TRg-1":17549,
"YCR016Wg4-NRD1-TRg-4":17550,
"YCR016Wg4-RPB3-NRg-1":17551,
"YCR016Wg4-PHO85-NRg-6":17552,
"YCR016Wg4-SNF6-TRg-6":17553,
"YCR016Wg4-PRP38-NRg-2":17554,
"YCR016Wg4-OAR1-NRg-3":17555,
"YCR016Wg4-ROX3-NRg-1":17556,
"YCR016Wg4-YPP1-TRg-6":17557,
"YCR016Wg4-CBF2-NRg-8":17558,
"YCR016Wg4-SPT6-TRg-5":17559,
"YCR016Wg4-SEC10-NRg-1":17560,
"YCR016Wg4-NSL1-NRg-3":17561,
"YCR016Wg4-NRD1-NRg-8":17562,
"YCR016Wg4-RPB3-TRg-1":17563,
"YCR016Wg4-NRD1-NRg-4":17564,
"YCR016Wg4-RVB1-TRg-2":17565,
"YCR016Wg4-TIF5-NRg-8":17566,
"YCR016Wg4-EOS1-NRg-1":17567,
"YCR016Wg4-ERG25-NA-26":17568,
"YCR016Wg4-MSL5-NRg-4":17569,
"YCR016Wg4-SEC24-TRg-2":17570,
"YCR016Wg4-RPL30-NRg-5":17571,
"YCR016Wg4-SNU71-NRg-3":17572,
"YCR016Wg4-CDC33-NRg-1":17573,
"YCR016Wg4-RPN6-TRg-4":17574,
"YCR016Wg4-NAB2-TRg-4":17575,
"YCR016Wg4-NAB2-TRg-6":17576,
"YCR016Wg4-YTM1-NRg-1":17577,
"YCR016Wg4-OLE1-TRg-8":17578,
"YCR016Wg4-OLE1-TRg-1":17579,
"YCR016Wg4-UTP7-TRg-4":17580,
"YCR016Wg4-ACT1-NRg-6":17581,
"YCR016Wg4-RPL18A-NRg-3":17582,
"YCR016Wg4-BRX1-NRg-1":17583,
"YCR016Wg4-NAF1-TRg-8":17584,
"YCR016Wg4-NAF1-TRg-6":17585,
"YCR016Wg4-NAF1-TRg-4":17586,
"YCR016Wg4-CDC8-TRg-2":17587,
"YCR016Wg4-NSE4-TRg-1":17588,
"YCR016Wg4-PAB1-NRg-2":17589,
"YCR016Wg4-PRP43-TRg-4":17590,
"YCR016Wg4-SEC2-NRg-3":17591,
"YCR016Wg4-SEC2-NRg-6":17592,
"YCR016Wg4-MPP10-NRg-5":17593,
"YCR016Wg4-YDR355C-TRg-2":17594,
"YCR016Wg4-YLR339C-TRg-9":17595,
"YCR016Wg4-SNM1-TRg-2":17596,
"YCR016Wg4-ALR1-NRg-4":17597,
"YCR016Wg4-ALR1-NRg-1":17598,
"YCR016Wg4-ALR1-NRg-3":17599,
"YCR016Wg4-RPL10-TRg-1":17600,
"YCR016Wg4-RPL28-TRg-2":17601,
"YCR016Wg4-UTP25-TRg-1":17602,
"YCR016Wg4-POB3-TRg-1":17603,
"YCR016Wg4-POB3-TRg-3":17604,
"YCR016Wg4-POB3-TRg-2":17605,
"YCR016Wg4-MED11-TRg-1":17606,
"YCR016Wg4-ISA1-TRg-15":17607,
"YCR016Wg4-RRP1-NRg-1":17608,
"YCR016Wg4-MES1-NRg-1":17609,
"YCR016Wg4-SEC13-NRg-5":17610,
"YCR016Wg4-MCM2-NRg-2":17611,
"YCR016Wg4-ALA1-TRg-4":17612,
"YCR016Wg4-MTG2-TRg-5":17613,
"YCR016Wg4-TIF35-NRg-3":17614,
"YCR016Wg4-NSE1-TRg-3":17615,
"YCR016Wg4-NSE1-TRg-4":17616,
"YCR016Wg4-MOB2-NRg-6":17617,
"YCR016Wg4-VRG4-NRg-3":17618,
"YCR016Wg4-PRP9-TRg-3":17619,
"YCR016Wg4-HYM1-TRg-5":17620,
"YCR016Wg4-POP1-TRg-5":17621,
"YCR016Wg4-POP1-TRg-9":17622,
"YCR016Wg4-RPL17A-TRg-1":17623,
"YCR016Wg4-SLD2-TRg-1":17624,
"YCR016Wg4-CDC48-NRg-7":17625,
"YCR016Wg4-FHL1-NRg-2":17626,
"YCR016Wg4-BET3-NRg-7":17627,
"YCR016Wg4-MAK21-TRg-1":17628,
"YCR016Wg4-BRN1-TRg-4":17629,
"YCR016Wg4-FBA1-NRg-3":17630,
"YCR016Wg4-CDC42-TRg-6":17631,
"YCR016Wg4-CDC42-TRg-7":17632,
"YCR016Wg4-COG4-NRg-1":17633,
"YCR016Wg4-ATP3-NRg-3":17634,
"YCR016Wg4-ATP3-NRg-2":17635,
"YCR016Wg4-SMP3-TRg-5":17636,
"YCR016Wg4-CFT2-NRg-2":17637,
"YCR016Wg4-FAS2-TRg-5":17638,
"YCR016Wg4-DBP2-NRg-3":17639,
"YCR016Wg4-DBP2-NRg-2":17640,
"YCR016Wg4-MPS2-NRg-4":17641,
"YCR016Wg4-ARC35-TRg-2":17642,
"YCR016Wg4-ARC35-TRg-5":17643,
"YCR016Wg4-MRD1-TRg-1":17644,
"YCR016Wg4-RLP7-TRg-1":17645,
"YCR016Wg4-SPC34-TRg-1":17646,
"YCR016Wg4-CDC45-TRg-2":17647,
"YCR016Wg4-GCD6-TRg-3":17648,
"YCR016Wg4-GCD6-TRg-4":17649,
"YCR016Wg4-YPT6-NRg-2":17650,
"YCR016Wg4-RPS13-TRg-2":17651,
"YCR016Wg4-IPI3-TRg-3":17652,
"YCR016Wg4-TIF5-NRg-9":17653,
"YCR016Wg4-TIF5-NRg-7":17654,
"YCR016Wg4-TIF5-NRg-6":17655,
"YCR016Wg4-NAB3-TRg-3":17656,
"YCR016Wg4-GCD2-TRg-1":17657,
"YCR016Wg4-UBA1-TRg-2":17658,
"YCR016Wg4-SLD3-TRg-6":17659,
"YCR016Wg4-LCB1-TRg-5":17660,
"YCR016Wg4-TOA2-TRg-6":17661,
"YCR016Wg4-TOA2-TRg-1":17662,
"YCR016Wg4-TOA2-TRg-3":17663,
"YCR016Wg4-LSM2-TRg-1":17664,
"YCR016Wg4-YML6-TRg-13":17665,
"YCR016Wg4-YML6-TRg-12":17666,
"YCR016Wg4-UTP15-NRg-1":17667,
"YCR016Wg4-TIF6-NRg-8":17668,
"YCR016Wg4-SUP35-NRg-1":17669,
"YCR016Wg4-MPP10-NRg-1":17670,
"YCR016Wg4-SWI3-TRg-7":17671,
"YCR016Wg4-SSN3-NRg-2":17672,
"YCR016Wg4-SEC13-NRg-7":17673,
"YCR016Wg4-RPS15-NRg-3":17674,
"YCR016Wg4-RPL3-TRg-2":17675,
"YCR016Wg4-FBA1-NRg-2":17676,
"YCR016Wg4-FBA1-NRg-1":17677,
"YCR016Wg4-FBA1-NRg-5":17678,
"YCR016Wg4-DAM1-TRg-2":17679,
"YCR016Wg4-NHP2-TRg-2":17680,
"YCR016Wg4-HCA4-NRg-6":17681,
"YCR016Wg4-PRE3-TRg-4":17682,
"YCR016Wg4-DBP5-NRg-4":17683,
"YCR016Wg4-SPT6-NRg-4":17684,
"YCR016Wg4-SPT6-NRg-2":17685,
"YCR016Wg4-RPL18A-TRg-4":17686,
"YCR016Wg4-KSH1-TRg-1":17687,
"YCR016Wg4-KSH1-TRg-3":17688,
"YCR016Wg4-IPI3-NRg-1":17689,
"YCR016Wg4-PGA2-TRg-8":17690,
"YCR016Wg4-RPL18A-TRg-2":17691,
"YCR016Wg4-RPL33A-NRg-6":17692,
"YCR016Wg4-TAF12-NRg-2":17693,
"YCR016Wg4-USE1-TRg-5":17694,
"YCR016Wg4-YNL114C-TRg-1":17695,
"YCR016Wg4-SMC5-TRg-7":17696,
"YCR016Wg4-SMC5-TRg-6":17697,
"YCR016Wg4-RSC58-TRg-1":17698,
"YCR016Wg4-CTF13-TRg-2":17699,
"YCR016Wg4-NAB2-NRg-2":17700,
"YCR016Wg4-MCM7-TRg-4":17701,
"YCR016Wg4-BCP1-NRg-5":17702,
"YCR016Wg4-STU2-TRg-3":17703,
"YCR016Wg4-SEC21-NRg-6":17704,
"YCR016Wg4-SEC21-NRg-3":17705,
"YCR016Wg4-RPL1B-TRg-3":17706,
"YCR016Wg4-SEC20-NRg-2":17707,
"YCR016Wg4-VMA3-NRg-2":17708,
"YCR016Wg4-SEC23-NRg-5":17709,
"YCR016Wg4-CDC28-TRg-4":17710,
"YCR016Wg4-RPN12-NRg-11":17711,
"YCR016Wg4-PUP3-TRg-3":17712,
"YCR016Wg4-SEC31-TRg-2":17713,
"YCR016Wg4-SED5-TRg-6":17714,
"YCR016Wg4-SED5-TRg-5":17715,
"YCR016Wg4-RPL33A-TRg-1":17716,
"YCR016Wg4-RPL33A-TRg-2":17717,
"YCR016Wg4-MRPL11-TRg-2":17718,
"YCR016Wg4-RTP1-NRg-2":17719,
"YCR016Wg4-NUG1-TRg-2":17720,
"YCR016Wg4-VPH2-TRg-4":17721,
"YCR016Wg4-COP1-NRg-3":17722,
"YCR016Wg4-CRM1-NRg-1":17723,
"YCR016Wg4-RPL5-NRg-4":17724,
"YCR016Wg4-SNU13-NRg-4":17725,
"YCR016Wg4-PFS2-TRg-3":17726,
"YCR016Wg4-MPP10-TRg-2":17727,
"YCR016Wg4-TSR4-NRg-2":17728,
"YCR016Wg4-RSC2-TRg-1":17729,
"YCR016Wg4-SEC65-TRg-2":17730,
"YCR016Wg4-SMI1-NRg-1":17731,
"YCR016Wg4-RTT105-NRg-4":17732,
"YCR016Wg4-VMA5-TRg-3":17733,
"YCR016Wg4-VMA5-TRg-5":17734,
"YCR016Wg4-RRP1-TRg-3":17735,
"YCR016Wg4-CLC1-TRg-2":17736,
"YCR016Wg4-GCD6-NRg-1":17737,
"YCR016Wg4-GCD6-NRg-2":17738,
"YCR016Wg4-PXR1-TRg-1":17739,
"YCR016Wg4-CDC14-NRg-1":17740,
"YCR016Wg4-PCF11-TRg-6":17741,
"YCR016Wg4-PCF11-TRg-5":17742,
"YCR016Wg4-PCF11-TRg-4":17743,
"YCR016Wg4-SEC31-NRg-1":17744,
"YCR016Wg4-RRP5-NRg-1":17745,
"YCR016Wg4-PRE10-TRg-5":17746,
"YCR016Wg4-PRE10-TRg-1":17747,
"YCR016Wg4-RPS5-TRg-2":17748,
"YCR016Wg4-NSP1-TRg-4":17749,
"YCR016Wg4-PRP38-TRg-4":17750,
"YCR016Wg4-RCF1-NRg-5":17751,
"YCR016Wg4-RSC3-TRg-4":17752,
"YCR016Wg4-RSC3-TRg-5":17753,
"YCR016Wg4-RSC3-TRg-6":17754,
"YCR016Wg4-HTA1-NRg-12":17755,
"YCR016Wg4-HTA1-NRg-11":17756,
"YCR016Wg4-UTP23-TRg-2":17757,
"YCR016Wg4-GCD7-NRg-1":17758,
"YCR016Wg4-GCD7-NRg-2":17759,
"YCR016Wg4-GCD7-NRg-6":17760,
"YCR016Wg4-GAL11-NRg-2":17761,
"YCR016Wg4-GAL11-NRg-9":17762,
"YCR016Wg4-PHO4-TRg-5":17763,
"YCR016Wg4-SNP1-NRg-3":17764,
"YCR016Wg4-RPC37-TRg-5":17765,
"YCR016Wg4-CRM1-TRg-5":17766,
"YCR016Wg4-CRM1-TRg-2":17767,
"YCR016Wg4-ASK1-TRg-7":17768,
"YCR016Wg4-STU2-NRg-4":17769,
"YCR016Wg4-NEO1-NRg-3":17770,
"YCR016Wg4-GAL11-TRg-5":17771,
"YCR016Wg4-GAL11-TRg-7":17772,
"YCR016Wg4-SAM50-NRg-3":17773,
"YCR016Wg4-CSL4-TRg-2":17774,
"YCR016Wg4-CCT5-TRg-2":17775,
"YCR016Wg4-POL30-NRg-1":17776,
"YCR016Wg4-MED4-TRg-4":17777,
"YCR016Wg4-MED4-TRg-3":17778,
"YCR016Wg4-MED4-TRg-2":17779,
"YCR016Wg4-GDI1-TRg-4":17780,
"YCR016Wg4-GDI1-TRg-3":17781,
"YCR016Wg4-REB1-TRg-6":17782,
"YCR016Wg4-MRPL37-NRg-2":17783,
"YCR016Wg4-NOC3-TRg-3":17784,
"YCR016Wg4-SPC97-TRg-3":17785,
"YCR016Wg4-IPP1-TRg-3":17786,
"YCR016Wg4-IPP1-TRg-2":17787,
"YCR016Wg4-PTI1-TRg-3":17788,
"YCR016Wg4-PTI1-TRg-5":17789,
"YCR016Wg4-RFC5-NRg-1":17790,
"YCR016Wg4-CDC24-TRg-1":17791,
"YCR016Wg4-CDC24-TRg-3":17792,
"YCR016Wg4-CDC24-TRg-5":17793,
"YCR016Wg4-CDC24-TRg-6":17794,
"YCR016Wg4-UTP23-TRg-6":17795,
"YCR016Wg4-UTP23-TRg-4":17796,
"YCR016Wg4-UTP23-TRg-1":17797,
"YCR016Wg4-RHO3-NRg-4":17798,
"YCR016Wg4-TRS23-NRg-1":17799,
"YCR016Wg4-TRS23-NRg-3":17800,
"YCR016Wg4-RSP5-TRg-2":17801,
"YCR016Wg4-RSP5-TRg-1":17802,
"YCR016Wg4-SDA1-NRg-1":17803,
"YCR016Wg4-KAP95-TRg-8":17804,
"YCR016Wg4-ACO1-TRg-6":17805,
"YCR016Wg4-HTA1-NRg-3":17806,
"YCR016Wg4-HTA1-NRg-2":17807,
"YCR016Wg4-SPN1-TRg-1":17808,
"YCR016Wg4-MOT1-NRg-7":17809,
"YCR016Wg4-RPL17A-NRg-4":17810,
"YCR016Wg4-ADA2-TRg-4":17811,
"YCR016Wg4-SFH1-NRg-1":17812,
"YCR016Wg4-SPC97-NRg-5":17813,
"YCR016Wg4-PRP22-TRg-3":17814,
"YCR016Wg4-SEN15-TRg-2":17815,
"YCR016Wg4-RPL3-NRg-2":17816,
"YCR016Wg4-ISD11-NRg-2":17817,
"YCR016Wg4-HEM12-TRg-8":17818,
"YCR016Wg4-SEC10-TRg-1":17819,
"YCR016Wg4-HTB1-TRg-7":17820,
"YCR016Wg4-TTI2-TRg-1":17821,
"YCR016Wg4-ACP1-TRg-2":17822,
"YCR016Wg4-ACP1-TRg-4":17823,
"YCR016Wg4-GAL11-NRg-10":17824,
"YCR016Wg4-UTP22-TRg-2":17825,
"YCR016Wg4-MST1-NRg-5":17826,
"YCR016Wg4-RIB7-NRg-2":17827,
"YCR016Wg4-MCD1-TRg-6":17828,
"YCR016Wg4-MCD1-TRg-5":17829,
"YCR016Wg4-GPI8-NRg-2":17830,
"YCR016Wg4-THS1-TRg-2":17831,
"YCR016Wg4-RRP7-TRg-2":17832,
"YCR016Wg4-RRP7-TRg-5":17833,
"YCR016Wg4-SMX2-NRg-7":17834,
"YCR016Wg4-RRP45-TRg-5":17835,
"YCR016Wg4-RRP45-TRg-4":17836,
"YCR016Wg4-CNS1-TRg-2":17837,
"YCR016Wg4-FBP1-NRg-9":17838,
"YCR016Wg4-GCD11-NRg-1":17839,
"YCR016Wg4-RPL10-TRg-2":17840,
"YCR016Wg4-NUP192-TRg-4":17841,
"YCR016Wg4-NUP145-NRg-4":17842,
"YCR016Wg4-HEM12-TRg-6":17843,
"YCR016Wg4-PLC1-TRg-3":17844,
"YCR016Wg4-RPA43-TRg-1":17845,
"YCR016Wg4-RPB7-NRg-2":17846,
"YCR016Wg4-RPB7-NRg-3":17847,
"YCR016Wg4-NSL1-NRg-1":17848,
"YCR016Wg4-UTP6-TRg-3":17849,
"YCR016Wg4-UTP6-TRg-1":17850,
"YCR016Wg4-YJU2-TRg-5":17851,
"YCR016Wg4-FRS2-NRg-5":17852,
"YCR016Wg4-TIF35-NRg-2":17853,
"YCR016Wg4-GPI15-TRg-1":17854,
"YCR016Wg4-NOP1-NRg-5":17855,
"YCR016Wg4-GPI15-TRg-4":17856,
"YCR016Wg4-COG4-TRg-1":17857,
"YCR016Wg4-TFA1-TRg-1":17858,
"YCR016Wg4-RHO1-NRg-2":17859,
"YCR016Wg4-RHO1-NRg-1":17860,
"YCR016Wg4-CDC55-NRg-2":17861,
"YCR016Wg4-IDI1-NRg-7":17862,
"YCR016Wg4-RPL32-TRg-5":17863,
"YCR016Wg4-RPB5-TRg-4":17864,
"YCR016Wg4-DIP2-TRg-5":17865,
"YCR016Wg4-DIP2-TRg-1":17866,
"YCR016Wg4-RPC40-TRg-2":17867,
"YCR016Wg4-CDC6-TRg-5":17868,
"YCR016Wg4-CDC6-TRg-3":17869,
"YCR016Wg4-DAD2-TRg-2":17870,
"YCR016Wg4-RVS161-TRg-2":17871,
"YCR016Wg4-RVS161-TRg-1":17872,
"YCR016Wg4-SUP45-NRg-3":17873,
"YCR016Wg4-SRB6-NRg-5":17874,
"YCR016Wg4-RPC11-TRg-4":17875,
"YCR016Wg4-RKI1-TRg-8":17876,
"YCR016Wg4-NIP7-TRg-3":17877,
"YCR016Wg4-RPL33A-NRg-12":17878,
"YCR016Wg4-SAM50-TRg-4":17879,
"YCR016Wg4-NOP4-NRg-1":17880,
"YCR016Wg4-NOP4-NRg-3":17881,
"YCR016Wg4-SMX2-TRg-5":17882,
"YCR016Wg4-POL12-NRg-2":17883,
"YCR016Wg4-BMS1-NRg-2":17884,
"YCR016Wg4-RPA190-TRg-5":17885,
"YCR016Wg4-ALG14-NRg-4":17886,
"YCR016Wg4-ALG14-NRg-1":17887,
"YCR016Wg4-PRE5-NRg-1":17888,
"YCR016Wg4-BIG1-NRg-2":17889,
"YCR016Wg4-TFA2-TRg-4":17890,
"YCR016Wg4-IMP4-TRg-6":17891,
"YCR016Wg4-PAN1-NRg-1":17892,
"YCR016Wg4-UTP13-TRg-2":17893,
"YCR016Wg4-KAE1-NRg-3":17894,
"YCR016Wg4-ERG20-TRg-1":17895,
"YCR016Wg4-CDC20-TRg-6":17896,
"YCR016Wg4-PWP2-NRg-2":17897,
"YCR016Wg4-COG1-NRg-1":17898,
"YCR016Wg4-RPL1B-TRg-4":17899,
"YCR016Wg4-RPL1B-TRg-7":17900,
"YCR016Wg4-UTP20-TRg-3":17901,
"YCR016Wg4-UTP20-TRg-4":17902,
"YCR016Wg4-RPL25-TRg-4":17903,
"YCR016Wg4-RPL25-TRg-2":17904,
"YCR016Wg4-MCM7-NRg-1":17905,
"YCR016Wg4-MRP49-TRg-5":17906,
"YCR016Wg4-ERO1-NRg-3":17907,
"YCR016Wg4-UTP5-TRg-7":17908,
"YCR016Wg4-MCM4-NRg-1":17909,
"YCR016Wg4-PRE3-NRg-1":17910,
"YCR016Wg4-FCF1-NRg-1":17911,
"YCR016Wg4-CUS1-NRg-1":17912,
"YCR016Wg4-PSF1-TRg-2":17913,
"YCR016Wg4-BCP1-TRg-2":17914,
"YCR016Wg4-PAN1-TRg-1":17915,
"YCR016Wg4-PAN1-TRg-3":17916,
"YCR016Wg4-PAN1-TRg-4":17917,
"YCR016Wg4-VPS3-TRg-2":17918,
"YCR016Wg4-YIL060W-NRg-1":17919,
"YCR016Wg4-VPS53-NRg-1":17920,
"YCR016Wg4-CYR1-TRg-4":17921,
"YCR016Wg4-CYR1-TRg-7":17922,
"YCR016Wg4-MPS1-NRg-1":17923,
"YCR016Wg4-SRP1-TRg-5":17924,
"YCR016Wg4-SRP1-TRg-4":17925,
"YCR016Wg4-TAF12-TRg-2":17926,
"YCR016Wg4-TAF12-TRg-3":17927,
"YCR016Wg4-POP4-TRg-1":17928,
"YCR016Wg4-SPT16-TRg-1":17929,
"YCR016Wg4-NUP82-TRg-4":17930,
"YCR016Wg4-DML1-TRg-3":17931,
"YCR016Wg4-RPA43-NRg-3":17932,
"YCR016Wg4-STU2-NRg-3":17933,
"YCR016Wg4-POP4-NRg-4":17934,
"YCR016Wg4-MCD1-TRg-2":17935,
"YCR016Wg4-RPS3-NRg-4":17936,
"YCR016Wg4-PRP9-TRg-4":17937,
"YCR016Wg4-RPP1-NRg-2":17938,
"YCR016Wg4-MTR2-NRg-11":17939,
"YCR016Wg4-GCD11-TRg-1":17940,
"YCR016Wg4-RPF1-TRg-3":17941,
"YCR016Wg4-SUB2-NRg-4":17942,
"YCR016Wg4-GPI15-TRg-3":17943,
"YCR016Wg4-ERG9-TRg-6":17944,
"YCR016Wg4-RPT2-NRg-1":17945,
"YCR016Wg4-YOS1-NRg-3":17946,
"YCR016Wg4-SCM3-TRg-4":17947,
"YCR016Wg4-SCM3-TRg-6":17948,
"YCR016Wg4-RLP7-NRg-1":17949,
"YCR016Wg4-TFB2-NRg-4":17950,
"YCR016Wg4-IMP4-TRg-1":17951,
"YCR016Wg4-IMP4-TRg-3":17952,
"YCR016Wg4-PRE4-TRg-3":17953,
"YCR016Wg4-SUB2-TRg-3":17954,
"YCR016Wg4-RPP0-NRg-4":17955,
"YCR016Wg4-RPP0-NRg-3":17956,
"YCR016Wg4-TOM40-TRg-4":17957,
"YCR016Wg4-FUR1-NRg-12":17958,
"YCR016Wg4-TOM40-TRg-2":17959,
"YCR016Wg4-VMA11-NRg-4":17960,
"YCR016Wg4-PGS1-NRg-4":17961,
"YCR016Wg4-URB1-TRg-4":17962,
"YCR016Wg4-ARP4-TRg-3":17963,
"YCR016Wg4-RPT3-TRg-3":17964,
"YCR016Wg4-SUI3-TRg-3":17965,
"YCR016Wg4-RFC5-NRg-2":17966,
"YCR016Wg4-RRP14-TRg-2":17967,
"YCR016Wg4-SCC2-TRg-1":17968,
"YCR016Wg4-SSC1-TRg-3":17969,
"YCR016Wg4-RRP9-TRg-3":17970,
"YCR016Wg4-MOT1-NRg-9":17971,
"YCR016Wg4-RPL42A-NRg-2":17972,
"YCR016Wg4-SEC16-TRg-7":17973,
"YCR016Wg4-IMP4-NRg-2":17974,
"YCR016Wg4-YEF3-NRg-4":17975,
"YCR016Wg4-PUP1-TRg-1":17976,
"YCR016Wg4-UTP22-TRg-6":17977,
"YCR016Wg4-DBP2-NRg-4":17978,
"YCR016Wg4-PRE2-TRg-7":17979,
"YCR016Wg4-ATP16-TRg-6":17980,
"YCR016Wg4-UTP13-TRg-4":17981,
"YCR016Wg4-DOP1-NRg-4":17982,
"YCR016Wg4-TIM44-TRg-3":17983,
"YCR016Wg4-ATP16-TRg-2":17984,
"YCR016Wg4-ENP1-NRg-3":17985,
"YCR016Wg4-NAF1-TRg-3":17986,
"YCR016Wg4-COG4-TRg-2":17987,
"YCR016Wg4-SOG2-TRg-7":17988,
"YCR016Wg4-YDR341C-TRg-3":17989,
"YCR016Wg4-YMR290W-A-TRg-10":17990,
"YCR016Wg4-NUP192-NRg-9":17991,
"YCR016Wg4-RPS31-NRg-8":17992,
"YCR016Wg4-SPC97-NRg-6":17993,
"YCR016Wg4-EBP2-NRg-1":17994,
"YCR016Wg4-CDC48-TRg-5":17995,
"YCR016Wg4-RPT1-TRg-4":17996,
"YCR016Wg4-ULP1-NRg-2":17997,
"YCR016Wg4-RPN3-TRg-6":17998,
"YCR016Wg4-RPT1-TRg-5":17999,
"YCR016Wg4-KRE5-TRg-2":18000,
"YCR016Wg4-TBF1-NRg-8":18001,
"YCR016Wg4-UTP22-NRg-4":18002,
"YCR016Wg4-SSC1-NRg-4":18003,
"YCR016Wg4-REB1-TRg-4":18004,
"YCR016Wg4-CDC48-NRg-9":18005,
"YCR016Wg4-FAS2-TRg-8":18006,
"YCR016Wg4-TAO3-TRg-8":18007,
"YCR016Wg4-CKS1-TRg-5":18008,
"YCR016Wg4-YLR379W-TRg-7":18009,
"YCR016Wg4-TEN1-NRg-2":18010,
"YCR016Wg4-RPL42A-TRg-2":18011,
"YCR016Wg4-SEC27-TRg-4":18012,
"YCR016Wg4-TBF1-NRg-4":18013,
"YCR016Wg4-RPT1-NRg-6":18014,
"YCR016Wg4-COG1-TRg-3":18015,
"YCR016Wg4-SUI1-TRg-6":18016,
"YCR016Wg4-TIM23-TRg-6":18017,
"YCR016Wg4-CDC48-NRg-6":18018,
"YCR016Wg4-EPL1-TRg-5":18019,
"YCR016Wg4-RPT5-TRg-8":18020,
"YCR016Wg4-ATP16-NRg-4":18021,
"YCR016Wg4-RPN6-TRg-3":18022,
"YCR016Wg4-ERG9-NRg-6":18023,
"YCR016Wg4-SMX3-TRg-1":18024,
"YCR016Wg4-NCB2-NRg-3":18025,
"YCR016Wg4-SEC16-NRg-12":18026,
"YCR016Wg4-RPN6-TRg-2":18027,
"YCR016Wg4-REB1-NRg-4":18028,
"YCR016Wg4-ATP16-TRg-9":18029,
"YCR016Wg4-ERG9-NRg-7":18030,
"YLR050Cg1-RPL15A-NRg-4":18031,
"YLR050Cg1-RPL15A-NRg-5":18032,
"YLR050Cg1-KRE33-TRg-1":18033,
"YLR050Cg1-PMI40-NRg-1":18034,
"YLR050Cg1-NOP19-NRg-3":18035,
"YLR050Cg1-SRP14-NRg-4":18036,
"YLR050Cg1-SEC27-TRg-2":18037,
"YLR050Cg1-GPI14-TRg-3":18038,
"YLR050Cg1-PAH1-TRg-7":18039,
"YLR050Cg1-PAH1-TRg-6":18040,
"YLR050Cg1-PAH1-TRg-5":18041,
"YLR050Cg1-PAH1-TRg-3":18042,
"YLR050Cg1-COG3-TRg-1":18043,
"YLR050Cg1-HTS1-NRg-5":18044,
"YLR050Cg1-MSN5-TRg-7":18045,
"YLR050Cg1-ERG26-TRg-1":18046,
"YLR050Cg1-SMD2-TRg-5":18047,
"YLR050Cg1-SMD2-TRg-4":18048,
"YLR050Cg1-SMD2-TRg-1":18049,
"YLR050Cg1-PRE7-TRg-4":18050,
"YLR050Cg1-PRE7-TRg-7":18051,
"YLR050Cg1-SEC6-TRg-3":18052,
"YLR050Cg1-ESF2-NRg-1":18053,
"YLR050Cg1-ESF2-NRg-3":18054,
"YLR050Cg1-AFG2-TRg-2":18055,
"YLR050Cg1-RRP36-TRg-3":18056,
"YLR050Cg1-RRP36-TRg-5":18057,
"YLR050Cg1-GCR1-NRg-2":18058,
"YLR050Cg1-PRE4-NRg-4":18059,
"YLR050Cg1-PRE4-NRg-9":18060,
"YLR050Cg1-DSN1-NRg-2":18061,
"YLR050Cg1-GPI11-TRg-3":18062,
"YLR050Cg1-POP3-TRg-1":18063,
"YLR050Cg1-MNE1-TRg-5":18064,
"YLR050Cg1-RRP12-NRg-1":18065,
"YLR050Cg1-RSC6-TRg-2":18066,
"YLR050Cg1-CDC25-TRg-1":18067,
"YLR050Cg1-CDC25-TRg-9":18068,
"YLR050Cg1-YPP1-NRg-3":18069,
"YLR050Cg1-NFS1-NRg-9":18070,
"YLR050Cg1-NFS1-NRg-8":18071,
"YLR050Cg1-UBA2-TRg-1":18072,
"YLR050Cg1-ARP2-NRg-3":18073,
"YLR050Cg1-MAK16-TRg-1":18074,
"YLR050Cg1-CEP3-NRg-1":18075,
"YLR050Cg1-GUK1-TRg-5":18076,
"YLR050Cg1-GUK1-TRg-2":18077,
"YLR050Cg1-GPI12-NRg-6":18078,
"YLR050Cg1-RPS5-NRg-5":18079,
"YLR050Cg1-RPS5-NRg-2":18080,
"YLR050Cg1-RPC19-NRg-1":18081,
"YLR050Cg1-TIM54-TRg-1":18082,
"YLR050Cg1-TEN1-TRg-2":18083,
"YLR050Cg1-SAH1-NRg-4":18084,
"YLR050Cg1-SAH1-NRg-5":18085,
"YLR050Cg1-SAH1-NRg-3":18086,
"YLR050Cg1-ATP15-NRg-5":18087,
"YLR050Cg1-SCD5-TRg-5":18088,
"YLR050Cg1-ARB1-NRg-2":18089,
"YLR050Cg1-ARB1-NRg-4":18090,
"YLR050Cg1-PUP2-TRg-1":18091,
"YLR050Cg1-CCT8-TRg-2":18092,
"YLR050Cg1-MCM4-TRg-1":18093,
"YLR050Cg1-LSM4-TRg-1":18094,
"YLR050Cg1-NOP53-NRg-1":18095,
"YLR050Cg1-ATP3-TRg-4":18096,
"YLR050Cg1-AFG2-NRg-3":18097,
"YLR050Cg1-PRO3-NRg-3":18098,
"YLR050Cg1-NRD1-NRg-10":18099,
"YLR050Cg1-SEC61-TRg-2":18100,
"YLR050Cg1-RHO3-TRg-4":18101,
"YLR050Cg1-SNF2-TRg-6":18102,
"YLR050Cg1-SMD2-NRg-3":18103,
"YLR050Cg1-RSC4-TRg-2":18104,
"YLR050Cg1-RSC4-TRg-1":18105,
"YLR050Cg1-TIF34-TRg-2":18106,
"YLR050Cg1-BET1-NRg-1":18107,
"YLR050Cg1-CDC8-NRg-2":18108,
"YLR050Cg1-PRP42-TRg-2":18109,
"YLR050Cg1-RRB1-TRg-2":18110,
"YLR050Cg1-SPC24-TRg-1":18111,
"YLR050Cg1-ILS1-NRg-1":18112,
"YLR050Cg1-GFA1-TRg-2":18113,
"YLR050Cg1-SEC21-NRg-10":18114,
"YLR050Cg1-RPC10-NRg-1":18115,
"YLR050Cg1-RPB10-TRg-3":18116,
"YLR050Cg1-RPB10-TRg-2":18117,
"YLR050Cg1-YNL181W-TRg-1":18118,
"YLR050Cg1-RAD3-NRg-1":18119,
"YLR050Cg1-NOP10-TRg-1":18120,
"YLR050Cg1-BFR2-TRg-3":18121,
"YLR050Cg1-MCM2-TRg-6":18122,
"YLR050Cg1-MCM2-TRg-4":18123,
"YLR050Cg1-MPP10-TRg-1":18124,
"YLR050Cg1-RET2-TRg-4":18125,
"YLR050Cg1-RET2-TRg-1":18126,
"YLR050Cg1-RPS2-NRg-1":18127,
"YLR050Cg1-RPS2-NRg-2":18128,
"YLR050Cg1-ORC4-NRg-3":18129,
"YLR050Cg1-TIP20-TRg-7":18130,
"YLR050Cg1-SMT3-TRg-1":18131,
"YLR050Cg1-MSS18-NRg-6":18132,
"YLR050Cg1-YEF3-NRg-9":18133,
"YLR050Cg1-ASK1-NRg-1":18134,
"YLR050Cg1-SMC1-TRg-1":18135,
"YLR050Cg1-NIP1-NRg-1":18136,
"YLR050Cg1-RPP1-NRg-1":18137,
"YLR050Cg1-YDJ1-TRg-6":18138,
"YLR050Cg1-SUB2-NRg-1":18139,
"YLR050Cg1-TIM10-NRg-8":18140,
"YLR050Cg1-TIM10-NRg-4":18141,
"YLR050Cg1-TIM10-NRg-7":18142,
"YLR050Cg1-SKI6-TRg-4":18143,
"YLR050Cg1-TUB4-TRg-1":18144,
"YLR050Cg1-CDC37-NRg-2":18145,
"YLR050Cg1-ISD11-TRg-3":18146,
"YLR050Cg1-YOS1-TRg-4":18147,
"YLR050Cg1-SSC1-TRg-6":18148,
"YLR050Cg1-MTR3-TRg-5":18149,
"YLR050Cg1-MTR3-TRg-6":18150,
"YLR050Cg1-TFA1-TRg-2":18151,
"YLR050Cg1-CDC3-NRg-3":18152,
"YLR050Cg1-ERG25-TA-18":18153,
"YLR050Cg1-RPB11-TRg-4":18154,
"YLR050Cg1-RPB11-TRg-1":18155,
"YLR050Cg1-RPB11-TRg-2":18156,
"YLR050Cg1-DED1-TRg-3":18157,
"YLR050Cg1-DED1-TRg-1":18158,
"YLR050Cg1-DED1-TRg-6":18159,
"YLR050Cg1-DED1-TRg-4":18160,
"YLR050Cg1-RPL10-NRg-5":18161,
"YLR050Cg1-RPL10-NRg-4":18162,
"YLR050Cg1-EFB1-NRg-1":18163,
"YLR050Cg1-EFB1-NRg-5":18164,
"YLR050Cg1-EFB1-NRg-4":18165,
"YLR050Cg1-RPT3-NRg-1":18166,
"YLR050Cg1-SAC6-TRg-8":18167,
"YLR050Cg1-SAC6-TRg-4":18168,
"YLR050Cg1-SAC6-TRg-5":18169,
"YLR050Cg1-SAC6-TRg-3":18170,
"YLR050Cg1-DIM1-TRg-5":18171,
"YLR050Cg1-DIM1-TRg-7":18172,
"YLR050Cg1-RPC17-NRg-1":18173,
"YLR050Cg1-RPC17-NRg-2":18174,
"YLR050Cg1-YDR341C-TRg-1":18175,
"YLR050Cg1-RAP1-NRg-8":18176,
"YLR050Cg1-RAP1-NRg-5":18177,
"YLR050Cg1-RAP1-NRg-2":18178,
"YLR050Cg1-SEC26-NRg-3":18179,
"YLR050Cg1-SPP41-TRg-3":18180,
"YLR050Cg1-TAP42-NRg-1":18181,
"YLR050Cg1-PGA2-TRg-6":18182,
"YLR050Cg1-BRL1-TRg-1":18183,
"YLR050Cg1-FOL2-TRg-1":18184,
"YLR050Cg1-NAB3-NRg-5":18185,
"YLR050Cg1-SNF4-TRg-4":18186,
"YLR050Cg1-HRR25-TRg-2":18187,
"YLR050Cg1-TRS23-TRg-4":18188,
"YLR050Cg1-CTR86-TRg-4":18189,
"YLR050Cg1-RPB5-TRg-5":18190,
"YLR050Cg1-SPN1-NRg-2":18191,
"YLR050Cg1-SPN1-NRg-1":18192,
"YLR050Cg1-SEC61-NRg-1":18193,
"YLR050Cg1-SEC61-NRg-7":18194,
"YLR050Cg1-TUS1-TRg-3":18195,
"YLR050Cg1-OLE1-NRg-2":18196,
"YLR050Cg1-AFG2-TRg-1":18197,
"YLR050Cg1-TOA2-NRg-1":18198,
"YLR050Cg1-USO1-TRg-1":18199,
"YLR050Cg1-UTP22-NRg-2":18200,
"YLR050Cg1-RIB1-TRg-3":18201,
"YLR050Cg1-RIB1-TRg-7":18202,
"YLR050Cg1-RIB1-TRg-4":18203,
"YLR050Cg1-COG1-TRg-1":18204,
"YLR050Cg1-RPL32-NRg-2":18205,
"YLR050Cg1-GLC7-NRg-3":18206,
"YLR050Cg1-GLC7-NRg-4":18207,
"YLR050Cg1-HSF1-TRg-2":18208,
"YLR050Cg1-DAM1-NRg-5":18209,
"YLR050Cg1-SEC18-TRg-4":18210,
"YLR050Cg1-SEC18-TRg-5":18211,
"YLR050Cg1-PAB1-NRg-3":18212,
"YLR050Cg1-POP8-TRg-2":18213,
"YLR050Cg1-PAB1-NRg-4":18214,
"YLR050Cg1-BIG1-TRg-4":18215,
"YLR050Cg1-BIG1-TRg-5":18216,
"YLR050Cg1-BIG1-TRg-6":18217,
"YLR050Cg1-RPO41-NRg-1":18218,
"YLR050Cg1-RVB2-NRg-2":18219,
"YLR050Cg1-PET117-NRg-8":18220,
"YLR050Cg1-VPS45-NRg-9":18221,
"YLR050Cg1-YCG1-NRg-1":18222,
"YLR050Cg1-NOC4-NRg-1":18223,
"YLR050Cg1-NMD3-NRg-2":18224,
"YLR050Cg1-DRS1-TRg-2":18225,
"YLR050Cg1-HTB1-NRg-2":18226,
"YLR050Cg1-IPI1-TRg-2":18227,
"YLR050Cg1-SEC18-NRg-1":18228,
"YLR050Cg1-SEC18-NRg-2":18229,
"YLR050Cg1-JIP5-NRg-2":18230,
"YLR050Cg1-YPT1-TRg-3":18231,
"YLR050Cg1-YPT1-TRg-2":18232,
"YLR050Cg1-CLF1-NRg-2":18233,
"YLR050Cg1-SNF2-NRg-7":18234,
"YLR050Cg1-SNF2-NRg-4":18235,
"YLR050Cg1-RPL25-NRg-1":18236,
"YLR050Cg1-NOP56-TRg-1":18237,
"YLR050Cg1-NOP56-TRg-2":18238,
"YLR050Cg1-TRS31-TRg-1":18239,
"YLR050Cg1-DBF4-TRg-2":18240,
"YLR050Cg1-DBF4-TRg-1":18241,
"YLR050Cg1-RPC19-TRg-4":18242,
"YLR050Cg1-RPC19-TRg-6":18243,
"YLR050Cg1-RPC19-TRg-3":18244,
"YLR050Cg1-ROK1-NRg-1":18245,
"YLR050Cg1-CDC33-TRg-4":18246,
"YLR050Cg1-DHR2-TRg-3":18247,
"YLR050Cg1-RRP42-NRg-5":18248,
"YLR050Cg1-CLF1-TRg-1":18249,
"YLR050Cg1-ERG11-NA-16":18250,
"YLR050Cg1-VAS1-NRg-4":18251,
"YLR050Cg1-PIK1-NRg-2":18252,
"YLR050Cg1-SAR1-NRg-7":18253,
"YLR050Cg1-SAR1-NRg-4":18254,
"YLR050Cg1-RPS3-TRg-1":18255,
"YLR050Cg1-YTM1-TRg-2":18256,
"YLR050Cg1-SUI3-NRg-5":18257,
"YLR050Cg1-SUI3-NRg-2":18258,
"YLR050Cg1-RRP7-TRg-4":18259,
"YLR050Cg1-RRP7-TRg-6":18260,
"YLR050Cg1-NIP7-TRg-2":18261,
"YLR050Cg1-MDM35-TRg-1":18262,
"YLR050Cg1-ALA1-NRg-1":18263,
"YLR050Cg1-DOA4-NRg-2":18264,
"YLR050Cg1-RPS13-NRg-1":18265,
"YLR050Cg1-YSF3-TRg-2":18266,
"YLR050Cg1-RPS2-NRg-11":18267,
"YLR050Cg1-SSL1-TRg-10":18268,
"YLR050Cg1-NIP7-TRg-1":18269,
"YLR050Cg1-LST8-NRg-1":18270,
"YLR050Cg1-TAF4-TRg-3":18271,
"YLR050Cg1-HAS1-TRg-2":18272,
"YLR050Cg1-GLC7-TRg-2":18273,
"YLR050Cg1-CDC45-NRg-1":18274,
"YLR050Cg1-SEC22-NRg-8":18275,
"YLR050Cg1-YOS1-TRg-2":18276,
"YLR050Cg1-RBA50-TRg-3":18277,
"YLR050Cg1-SPP41-NRg-2":18278,
"YLR050Cg1-PRP46-TRg-2":18279,
"YLR050Cg1-PGA2-NRg-1":18280,
"YLR050Cg1-CBF5-TRg-3":18281,
"YLR050Cg1-TCP1-NRg-3":18282,
"YLR050Cg1-TCP1-NRg-2":18283,
"YLR050Cg1-ERG26-NRg-2":18284,
"YLR050Cg1-ERG26-NRg-4":18285,
"YLR050Cg1-MES1-TRg-5":18286,
"YLR050Cg1-HTS1-TRg-2":18287,
"YLR050Cg1-SSS1-TRg-3":18288,
"YLR050Cg1-SSS1-TRg-2":18289,
"YLR050Cg1-SYS1-TRg-7":18290,
"YLR050Cg1-SYS1-TRg-2":18291,
"YLR050Cg1-SYS1-TRg-1":18292,
"YLR050Cg1-BFR2-TRg-1":18293,
"YLR050Cg1-EOS1-TRg-3":18294,
"YLR050Cg1-TAF4-NRg-1":18295,
"YLR050Cg1-ARL3-NRg-8":18296,
"YLR050Cg1-RPN5-NRg-1":18297,
"YLR050Cg1-TIM9-NRg-2":18298,
"YLR050Cg1-NUP57-NRg-3":18299,
"YLR050Cg1-VPS4-TRg-1":18300,
"YLR050Cg1-CDC3-TRg-4":18301,
"YLR050Cg1-BBP1-NRg-1":18302,
"YLR050Cg1-BBP1-NRg-2":18303,
"YLR050Cg1-USE1-NRg-3":18304,
"YLR050Cg1-CCT7-TRg-1":18305,
"YLR050Cg1-SAH1-TRg-3":18306,
"YLR050Cg1-CHS2-TRg-1":18307,
"YLR050Cg1-DPM1-TRg-2":18308,
"YLR050Cg1-BBP1-TRg-1":18309,
"YLR050Cg1-NRD1-TRg-4":18310,
"YLR050Cg1-RPB3-NRg-1":18311,
"YLR050Cg1-PHO85-NRg-6":18312,
"YLR050Cg1-SNF6-TRg-6":18313,
"YLR050Cg1-PRP38-NRg-2":18314,
"YLR050Cg1-OAR1-NRg-3":18315,
"YLR050Cg1-ROX3-NRg-1":18316,
"YLR050Cg1-YPP1-TRg-6":18317,
"YLR050Cg1-CBF2-NRg-8":18318,
"YLR050Cg1-SPT6-TRg-5":18319,
"YLR050Cg1-SEC10-NRg-1":18320,
"YLR050Cg1-NSL1-NRg-3":18321,
"YLR050Cg1-NRD1-NRg-8":18322,
"YLR050Cg1-RPB3-TRg-1":18323,
"YLR050Cg1-NRD1-NRg-4":18324,
"YLR050Cg1-RVB1-TRg-2":18325,
"YLR050Cg1-TIF5-NRg-8":18326,
"YLR050Cg1-EOS1-NRg-1":18327,
"YLR050Cg1-ERG25-NA-26":18328,
"YLR050Cg1-MSL5-NRg-4":18329,
"YLR050Cg1-SEC24-TRg-2":18330,
"YLR050Cg1-RPL30-NRg-5":18331,
"YLR050Cg1-SNU71-NRg-3":18332,
"YLR050Cg1-CDC33-NRg-1":18333,
"YLR050Cg1-RPN6-TRg-4":18334,
"YLR050Cg1-NAB2-TRg-4":18335,
"YLR050Cg1-NAB2-TRg-6":18336,
"YLR050Cg1-YTM1-NRg-1":18337,
"YLR050Cg1-OLE1-TRg-8":18338,
"YLR050Cg1-OLE1-TRg-1":18339,
"YLR050Cg1-UTP7-TRg-4":18340,
"YLR050Cg1-ACT1-NRg-6":18341,
"YLR050Cg1-RPL18A-NRg-3":18342,
"YLR050Cg1-BRX1-NRg-1":18343,
"YLR050Cg1-NAF1-TRg-8":18344,
"YLR050Cg1-NAF1-TRg-6":18345,
"YLR050Cg1-NAF1-TRg-4":18346,
"YLR050Cg1-CDC8-TRg-2":18347,
"YLR050Cg1-NSE4-TRg-1":18348,
"YLR050Cg1-PAB1-NRg-2":18349,
"YLR050Cg1-PRP43-TRg-4":18350,
"YLR050Cg1-SEC2-NRg-3":18351,
"YLR050Cg1-SEC2-NRg-6":18352,
"YLR050Cg1-MPP10-NRg-5":18353,
"YLR050Cg1-YDR355C-TRg-2":18354,
"YLR050Cg1-YLR339C-TRg-9":18355,
"YLR050Cg1-SNM1-TRg-2":18356,
"YLR050Cg1-ALR1-NRg-4":18357,
"YLR050Cg1-ALR1-NRg-1":18358,
"YLR050Cg1-ALR1-NRg-3":18359,
"YLR050Cg1-RPL10-TRg-1":18360,
"YLR050Cg1-RPL28-TRg-2":18361,
"YLR050Cg1-UTP25-TRg-1":18362,
"YLR050Cg1-POB3-TRg-1":18363,
"YLR050Cg1-POB3-TRg-3":18364,
"YLR050Cg1-POB3-TRg-2":18365,
"YLR050Cg1-MED11-TRg-1":18366,
"YLR050Cg1-ISA1-TRg-15":18367,
"YLR050Cg1-RRP1-NRg-1":18368,
"YLR050Cg1-MES1-NRg-1":18369,
"YLR050Cg1-SEC13-NRg-5":18370,
"YLR050Cg1-MCM2-NRg-2":18371,
"YLR050Cg1-ALA1-TRg-4":18372,
"YLR050Cg1-MTG2-TRg-5":18373,
"YLR050Cg1-TIF35-NRg-3":18374,
"YLR050Cg1-NSE1-TRg-3":18375,
"YLR050Cg1-NSE1-TRg-4":18376,
"YLR050Cg1-MOB2-NRg-6":18377,
"YLR050Cg1-VRG4-NRg-3":18378,
"YLR050Cg1-PRP9-TRg-3":18379,
"YLR050Cg1-HYM1-TRg-5":18380,
"YLR050Cg1-POP1-TRg-5":18381,
"YLR050Cg1-POP1-TRg-9":18382,
"YLR050Cg1-RPL17A-TRg-1":18383,
"YLR050Cg1-SLD2-TRg-1":18384,
"YLR050Cg1-CDC48-NRg-7":18385,
"YLR050Cg1-FHL1-NRg-2":18386,
"YLR050Cg1-BET3-NRg-7":18387,
"YLR050Cg1-MAK21-TRg-1":18388,
"YLR050Cg1-BRN1-TRg-4":18389,
"YLR050Cg1-FBA1-NRg-3":18390,
"YLR050Cg1-CDC42-TRg-6":18391,
"YLR050Cg1-CDC42-TRg-7":18392,
"YLR050Cg1-COG4-NRg-1":18393,
"YLR050Cg1-ATP3-NRg-3":18394,
"YLR050Cg1-ATP3-NRg-2":18395,
"YLR050Cg1-SMP3-TRg-5":18396,
"YLR050Cg1-CFT2-NRg-2":18397,
"YLR050Cg1-FAS2-TRg-5":18398,
"YLR050Cg1-DBP2-NRg-3":18399,
"YLR050Cg1-DBP2-NRg-2":18400,
"YLR050Cg1-MPS2-NRg-4":18401,
"YLR050Cg1-ARC35-TRg-2":18402,
"YLR050Cg1-ARC35-TRg-5":18403,
"YLR050Cg1-MRD1-TRg-1":18404,
"YLR050Cg1-RLP7-TRg-1":18405,
"YLR050Cg1-SPC34-TRg-1":18406,
"YLR050Cg1-CDC45-TRg-2":18407,
"YLR050Cg1-GCD6-TRg-3":18408,
"YLR050Cg1-GCD6-TRg-4":18409,
"YLR050Cg1-YPT6-NRg-2":18410,
"YLR050Cg1-RPS13-TRg-2":18411,
"YLR050Cg1-IPI3-TRg-3":18412,
"YLR050Cg1-TIF5-NRg-9":18413,
"YLR050Cg1-TIF5-NRg-7":18414,
"YLR050Cg1-TIF5-NRg-6":18415,
"YLR050Cg1-NAB3-TRg-3":18416,
"YLR050Cg1-GCD2-TRg-1":18417,
"YLR050Cg1-UBA1-TRg-2":18418,
"YLR050Cg1-SLD3-TRg-6":18419,
"YLR050Cg1-LCB1-TRg-5":18420,
"YLR050Cg1-TOA2-TRg-6":18421,
"YLR050Cg1-TOA2-TRg-1":18422,
"YLR050Cg1-TOA2-TRg-3":18423,
"YLR050Cg1-LSM2-TRg-1":18424,
"YLR050Cg1-YML6-TRg-13":18425,
"YLR050Cg1-YML6-TRg-12":18426,
"YLR050Cg1-UTP15-NRg-1":18427,
"YLR050Cg1-TIF6-NRg-8":18428,
"YLR050Cg1-SUP35-NRg-1":18429,
"YLR050Cg1-MPP10-NRg-1":18430,
"YLR050Cg1-SWI3-TRg-7":18431,
"YLR050Cg1-SSN3-NRg-2":18432,
"YLR050Cg1-SEC13-NRg-7":18433,
"YLR050Cg1-RPS15-NRg-3":18434,
"YLR050Cg1-RPL3-TRg-2":18435,
"YLR050Cg1-FBA1-NRg-2":18436,
"YLR050Cg1-FBA1-NRg-1":18437,
"YLR050Cg1-FBA1-NRg-5":18438,
"YLR050Cg1-DAM1-TRg-2":18439,
"YLR050Cg1-NHP2-TRg-2":18440,
"YLR050Cg1-HCA4-NRg-6":18441,
"YLR050Cg1-PRE3-TRg-4":18442,
"YLR050Cg1-DBP5-NRg-4":18443,
"YLR050Cg1-SPT6-NRg-4":18444,
"YLR050Cg1-SPT6-NRg-2":18445,
"YLR050Cg1-RPL18A-TRg-4":18446,
"YLR050Cg1-KSH1-TRg-1":18447,
"YLR050Cg1-KSH1-TRg-3":18448,
"YLR050Cg1-IPI3-NRg-1":18449,
"YLR050Cg1-PGA2-TRg-8":18450,
"YLR050Cg1-RPL18A-TRg-2":18451,
"YLR050Cg1-RPL33A-NRg-6":18452,
"YLR050Cg1-TAF12-NRg-2":18453,
"YLR050Cg1-USE1-TRg-5":18454,
"YLR050Cg1-YNL114C-TRg-1":18455,
"YLR050Cg1-SMC5-TRg-7":18456,
"YLR050Cg1-SMC5-TRg-6":18457,
"YLR050Cg1-RSC58-TRg-1":18458,
"YLR050Cg1-CTF13-TRg-2":18459,
"YLR050Cg1-NAB2-NRg-2":18460,
"YLR050Cg1-MCM7-TRg-4":18461,
"YLR050Cg1-BCP1-NRg-5":18462,
"YLR050Cg1-STU2-TRg-3":18463,
"YLR050Cg1-SEC21-NRg-6":18464,
"YLR050Cg1-SEC21-NRg-3":18465,
"YLR050Cg1-RPL1B-TRg-3":18466,
"YLR050Cg1-SEC20-NRg-2":18467,
"YLR050Cg1-VMA3-NRg-2":18468,
"YLR050Cg1-SEC23-NRg-5":18469,
"YLR050Cg1-CDC28-TRg-4":18470,
"YLR050Cg1-RPN12-NRg-11":18471,
"YLR050Cg1-PUP3-TRg-3":18472,
"YLR050Cg1-SEC31-TRg-2":18473,
"YLR050Cg1-SED5-TRg-6":18474,
"YLR050Cg1-SED5-TRg-5":18475,
"YLR050Cg1-RPL33A-TRg-1":18476,
"YLR050Cg1-RPL33A-TRg-2":18477,
"YLR050Cg1-MRPL11-TRg-2":18478,
"YLR050Cg1-RTP1-NRg-2":18479,
"YLR050Cg1-NUG1-TRg-2":18480,
"YLR050Cg1-VPH2-TRg-4":18481,
"YLR050Cg1-COP1-NRg-3":18482,
"YLR050Cg1-CRM1-NRg-1":18483,
"YLR050Cg1-RPL5-NRg-4":18484,
"YLR050Cg1-SNU13-NRg-4":18485,
"YLR050Cg1-PFS2-TRg-3":18486,
"YLR050Cg1-MPP10-TRg-2":18487,
"YLR050Cg1-TSR4-NRg-2":18488,
"YLR050Cg1-RSC2-TRg-1":18489,
"YLR050Cg1-SEC65-TRg-2":18490,
"YLR050Cg1-SMI1-NRg-1":18491,
"YLR050Cg1-RTT105-NRg-4":18492,
"YLR050Cg1-VMA5-TRg-3":18493,
"YLR050Cg1-VMA5-TRg-5":18494,
"YLR050Cg1-RRP1-TRg-3":18495,
"YLR050Cg1-CLC1-TRg-2":18496,
"YLR050Cg1-GCD6-NRg-1":18497,
"YLR050Cg1-GCD6-NRg-2":18498,
"YLR050Cg1-PXR1-TRg-1":18499,
"YLR050Cg1-CDC14-NRg-1":18500,
"YLR050Cg1-PCF11-TRg-6":18501,
"YLR050Cg1-PCF11-TRg-5":18502,
"YLR050Cg1-PCF11-TRg-4":18503,
"YLR050Cg1-SEC31-NRg-1":18504,
"YLR050Cg1-RRP5-NRg-1":18505,
"YLR050Cg1-PRE10-TRg-5":18506,
"YLR050Cg1-PRE10-TRg-1":18507,
"YLR050Cg1-RPS5-TRg-2":18508,
"YLR050Cg1-NSP1-TRg-4":18509,
"YLR050Cg1-PRP38-TRg-4":18510,
"YLR050Cg1-RCF1-NRg-5":18511,
"YLR050Cg1-RSC3-TRg-4":18512,
"YLR050Cg1-RSC3-TRg-5":18513,
"YLR050Cg1-RSC3-TRg-6":18514,
"YLR050Cg1-HTA1-NRg-12":18515,
"YLR050Cg1-HTA1-NRg-11":18516,
"YLR050Cg1-UTP23-TRg-2":18517,
"YLR050Cg1-GCD7-NRg-1":18518,
"YLR050Cg1-GCD7-NRg-2":18519,
"YLR050Cg1-GCD7-NRg-6":18520,
"YLR050Cg1-GAL11-NRg-2":18521,
"YLR050Cg1-GAL11-NRg-9":18522,
"YLR050Cg1-PHO4-TRg-5":18523,
"YLR050Cg1-SNP1-NRg-3":18524,
"YLR050Cg1-RPC37-TRg-5":18525,
"YLR050Cg1-CRM1-TRg-5":18526,
"YLR050Cg1-CRM1-TRg-2":18527,
"YLR050Cg1-ASK1-TRg-7":18528,
"YLR050Cg1-STU2-NRg-4":18529,
"YLR050Cg1-NEO1-NRg-3":18530,
"YLR050Cg1-GAL11-TRg-5":18531,
"YLR050Cg1-GAL11-TRg-7":18532,
"YLR050Cg1-SAM50-NRg-3":18533,
"YLR050Cg1-CSL4-TRg-2":18534,
"YLR050Cg1-CCT5-TRg-2":18535,
"YLR050Cg1-POL30-NRg-1":18536,
"YLR050Cg1-MED4-TRg-4":18537,
"YLR050Cg1-MED4-TRg-3":18538,
"YLR050Cg1-MED4-TRg-2":18539,
"YLR050Cg1-GDI1-TRg-4":18540,
"YLR050Cg1-GDI1-TRg-3":18541,
"YLR050Cg1-REB1-TRg-6":18542,
"YLR050Cg1-MRPL37-NRg-2":18543,
"YLR050Cg1-NOC3-TRg-3":18544,
"YLR050Cg1-SPC97-TRg-3":18545,
"YLR050Cg1-IPP1-TRg-3":18546,
"YLR050Cg1-IPP1-TRg-2":18547,
"YLR050Cg1-PTI1-TRg-3":18548,
"YLR050Cg1-PTI1-TRg-5":18549,
"YLR050Cg1-RFC5-NRg-1":18550,
"YLR050Cg1-CDC24-TRg-1":18551,
"YLR050Cg1-CDC24-TRg-3":18552,
"YLR050Cg1-CDC24-TRg-5":18553,
"YLR050Cg1-CDC24-TRg-6":18554,
"YLR050Cg1-UTP23-TRg-6":18555,
"YLR050Cg1-UTP23-TRg-4":18556,
"YLR050Cg1-UTP23-TRg-1":18557,
"YLR050Cg1-RHO3-NRg-4":18558,
"YLR050Cg1-TRS23-NRg-1":18559,
"YLR050Cg1-TRS23-NRg-3":18560,
"YLR050Cg1-RSP5-TRg-2":18561,
"YLR050Cg1-RSP5-TRg-1":18562,
"YLR050Cg1-SDA1-NRg-1":18563,
"YLR050Cg1-KAP95-TRg-8":18564,
"YLR050Cg1-ACO1-TRg-6":18565,
"YLR050Cg1-HTA1-NRg-3":18566,
"YLR050Cg1-HTA1-NRg-2":18567,
"YLR050Cg1-SPN1-TRg-1":18568,
"YLR050Cg1-MOT1-NRg-7":18569,
"YLR050Cg1-RPL17A-NRg-4":18570,
"YLR050Cg1-ADA2-TRg-4":18571,
"YLR050Cg1-SFH1-NRg-1":18572,
"YLR050Cg1-SPC97-NRg-5":18573,
"YLR050Cg1-PRP22-TRg-3":18574,
"YLR050Cg1-SEN15-TRg-2":18575,
"YLR050Cg1-RPL3-NRg-2":18576,
"YLR050Cg1-ISD11-NRg-2":18577,
"YLR050Cg1-HEM12-TRg-8":18578,
"YLR050Cg1-SEC10-TRg-1":18579,
"YLR050Cg1-HTB1-TRg-7":18580,
"YLR050Cg1-TTI2-TRg-1":18581,
"YLR050Cg1-ACP1-TRg-2":18582,
"YLR050Cg1-ACP1-TRg-4":18583,
"YLR050Cg1-GAL11-NRg-10":18584,
"YLR050Cg1-UTP22-TRg-2":18585,
"YLR050Cg1-MST1-NRg-5":18586,
"YLR050Cg1-RIB7-NRg-2":18587,
"YLR050Cg1-MCD1-TRg-6":18588,
"YLR050Cg1-MCD1-TRg-5":18589,
"YLR050Cg1-GPI8-NRg-2":18590,
"YLR050Cg1-THS1-TRg-2":18591,
"YLR050Cg1-RRP7-TRg-2":18592,
"YLR050Cg1-RRP7-TRg-5":18593,
"YLR050Cg1-SMX2-NRg-7":18594,
"YLR050Cg1-RRP45-TRg-5":18595,
"YLR050Cg1-RRP45-TRg-4":18596,
"YLR050Cg1-CNS1-TRg-2":18597,
"YLR050Cg1-FBP1-NRg-9":18598,
"YLR050Cg1-GCD11-NRg-1":18599,
"YLR050Cg1-RPL10-TRg-2":18600,
"YLR050Cg1-NUP192-TRg-4":18601,
"YLR050Cg1-NUP145-NRg-4":18602,
"YLR050Cg1-HEM12-TRg-6":18603,
"YLR050Cg1-PLC1-TRg-3":18604,
"YLR050Cg1-RPA43-TRg-1":18605,
"YLR050Cg1-RPB7-NRg-2":18606,
"YLR050Cg1-RPB7-NRg-3":18607,
"YLR050Cg1-NSL1-NRg-1":18608,
"YLR050Cg1-UTP6-TRg-3":18609,
"YLR050Cg1-UTP6-TRg-1":18610,
"YLR050Cg1-YJU2-TRg-5":18611,
"YLR050Cg1-FRS2-NRg-5":18612,
"YLR050Cg1-TIF35-NRg-2":18613,
"YLR050Cg1-GPI15-TRg-1":18614,
"YLR050Cg1-NOP1-NRg-5":18615,
"YLR050Cg1-GPI15-TRg-4":18616,
"YLR050Cg1-COG4-TRg-1":18617,
"YLR050Cg1-TFA1-TRg-1":18618,
"YLR050Cg1-RHO1-NRg-2":18619,
"YLR050Cg1-RHO1-NRg-1":18620,
"YLR050Cg1-CDC55-NRg-2":18621,
"YLR050Cg1-IDI1-NRg-7":18622,
"YLR050Cg1-RPL32-TRg-5":18623,
"YLR050Cg1-RPB5-TRg-4":18624,
"YLR050Cg1-DIP2-TRg-5":18625,
"YLR050Cg1-DIP2-TRg-1":18626,
"YLR050Cg1-RPC40-TRg-2":18627,
"YLR050Cg1-CDC6-TRg-5":18628,
"YLR050Cg1-CDC6-TRg-3":18629,
"YLR050Cg1-DAD2-TRg-2":18630,
"YLR050Cg1-RVS161-TRg-2":18631,
"YLR050Cg1-RVS161-TRg-1":18632,
"YLR050Cg1-SUP45-NRg-3":18633,
"YLR050Cg1-SRB6-NRg-5":18634,
"YLR050Cg1-RPC11-TRg-4":18635,
"YLR050Cg1-RKI1-TRg-8":18636,
"YLR050Cg1-NIP7-TRg-3":18637,
"YLR050Cg1-RPL33A-NRg-12":18638,
"YLR050Cg1-SAM50-TRg-4":18639,
"YLR050Cg1-NOP4-NRg-1":18640,
"YLR050Cg1-NOP4-NRg-3":18641,
"YLR050Cg1-SMX2-TRg-5":18642,
"YLR050Cg1-POL12-NRg-2":18643,
"YLR050Cg1-BMS1-NRg-2":18644,
"YLR050Cg1-RPA190-TRg-5":18645,
"YLR050Cg1-ALG14-NRg-4":18646,
"YLR050Cg1-ALG14-NRg-1":18647,
"YLR050Cg1-PRE5-NRg-1":18648,
"YLR050Cg1-BIG1-NRg-2":18649,
"YLR050Cg1-TFA2-TRg-4":18650,
"YLR050Cg1-IMP4-TRg-6":18651,
"YLR050Cg1-PAN1-NRg-1":18652,
"YLR050Cg1-UTP13-TRg-2":18653,
"YLR050Cg1-KAE1-NRg-3":18654,
"YLR050Cg1-ERG20-TRg-1":18655,
"YLR050Cg1-CDC20-TRg-6":18656,
"YLR050Cg1-PWP2-NRg-2":18657,
"YLR050Cg1-COG1-NRg-1":18658,
"YLR050Cg1-RPL1B-TRg-4":18659,
"YLR050Cg1-RPL1B-TRg-7":18660,
"YLR050Cg1-UTP20-TRg-3":18661,
"YLR050Cg1-UTP20-TRg-4":18662,
"YLR050Cg1-RPL25-TRg-4":18663,
"YLR050Cg1-RPL25-TRg-2":18664,
"YLR050Cg1-MCM7-NRg-1":18665,
"YLR050Cg1-MRP49-TRg-5":18666,
"YLR050Cg1-ERO1-NRg-3":18667,
"YLR050Cg1-UTP5-TRg-7":18668,
"YLR050Cg1-MCM4-NRg-1":18669,
"YLR050Cg1-PRE3-NRg-1":18670,
"YLR050Cg1-FCF1-NRg-1":18671,
"YLR050Cg1-CUS1-NRg-1":18672,
"YLR050Cg1-PSF1-TRg-2":18673,
"YLR050Cg1-BCP1-TRg-2":18674,
"YLR050Cg1-PAN1-TRg-1":18675,
"YLR050Cg1-PAN1-TRg-3":18676,
"YLR050Cg1-PAN1-TRg-4":18677,
"YLR050Cg1-VPS3-TRg-2":18678,
"YLR050Cg1-YIL060W-NRg-1":18679,
"YLR050Cg1-VPS53-NRg-1":18680,
"YLR050Cg1-CYR1-TRg-4":18681,
"YLR050Cg1-CYR1-TRg-7":18682,
"YLR050Cg1-MPS1-NRg-1":18683,
"YLR050Cg1-SRP1-TRg-5":18684,
"YLR050Cg1-SRP1-TRg-4":18685,
"YLR050Cg1-TAF12-TRg-2":18686,
"YLR050Cg1-TAF12-TRg-3":18687,
"YLR050Cg1-POP4-TRg-1":18688,
"YLR050Cg1-SPT16-TRg-1":18689,
"YLR050Cg1-NUP82-TRg-4":18690,
"YLR050Cg1-DML1-TRg-3":18691,
"YLR050Cg1-RPA43-NRg-3":18692,
"YLR050Cg1-STU2-NRg-3":18693,
"YLR050Cg1-POP4-NRg-4":18694,
"YLR050Cg1-MCD1-TRg-2":18695,
"YLR050Cg1-RPS3-NRg-4":18696,
"YLR050Cg1-PRP9-TRg-4":18697,
"YLR050Cg1-RPP1-NRg-2":18698,
"YLR050Cg1-MTR2-NRg-11":18699,
"YLR050Cg1-GCD11-TRg-1":18700,
"YLR050Cg1-RPF1-TRg-3":18701,
"YLR050Cg1-SUB2-NRg-4":18702,
"YLR050Cg1-GPI15-TRg-3":18703,
"YLR050Cg1-ERG9-TRg-6":18704,
"YLR050Cg1-RPT2-NRg-1":18705,
"YLR050Cg1-YOS1-NRg-3":18706,
"YLR050Cg1-SCM3-TRg-4":18707,
"YLR050Cg1-SCM3-TRg-6":18708,
"YLR050Cg1-RLP7-NRg-1":18709,
"YLR050Cg1-TFB2-NRg-4":18710,
"YLR050Cg1-IMP4-TRg-1":18711,
"YLR050Cg1-IMP4-TRg-3":18712,
"YLR050Cg1-PRE4-TRg-3":18713,
"YLR050Cg1-SUB2-TRg-3":18714,
"YLR050Cg1-RPP0-NRg-4":18715,
"YLR050Cg1-RPP0-NRg-3":18716,
"YLR050Cg1-TOM40-TRg-4":18717,
"YLR050Cg1-FUR1-NRg-12":18718,
"YLR050Cg1-TOM40-TRg-2":18719,
"YLR050Cg1-VMA11-NRg-4":18720,
"YLR050Cg1-PGS1-NRg-4":18721,
"YLR050Cg1-URB1-TRg-4":18722,
"YLR050Cg1-ARP4-TRg-3":18723,
"YLR050Cg1-RPT3-TRg-3":18724,
"YLR050Cg1-SUI3-TRg-3":18725,
"YLR050Cg1-RFC5-NRg-2":18726,
"YLR050Cg1-RRP14-TRg-2":18727,
"YLR050Cg1-SCC2-TRg-1":18728,
"YLR050Cg1-SSC1-TRg-3":18729,
"YLR050Cg1-RRP9-TRg-3":18730,
"YLR050Cg1-MOT1-NRg-9":18731,
"YLR050Cg1-RPL42A-NRg-2":18732,
"YLR050Cg1-SEC16-TRg-7":18733,
"YLR050Cg1-IMP4-NRg-2":18734,
"YLR050Cg1-YEF3-NRg-4":18735,
"YLR050Cg1-PUP1-TRg-1":18736,
"YLR050Cg1-UTP22-TRg-6":18737,
"YLR050Cg1-DBP2-NRg-4":18738,
"YLR050Cg1-PRE2-TRg-7":18739,
"YLR050Cg1-ATP16-TRg-6":18740,
"YLR050Cg1-UTP13-TRg-4":18741,
"YLR050Cg1-DOP1-NRg-4":18742,
"YLR050Cg1-TIM44-TRg-3":18743,
"YLR050Cg1-ATP16-TRg-2":18744,
"YLR050Cg1-ENP1-NRg-3":18745,
"YLR050Cg1-NAF1-TRg-3":18746,
"YLR050Cg1-COG4-TRg-2":18747,
"YLR050Cg1-SOG2-TRg-7":18748,
"YLR050Cg1-YDR341C-TRg-3":18749,
"YLR050Cg1-YMR290W-A-TRg-10":18750,
"YLR050Cg1-NUP192-NRg-9":18751,
"YLR050Cg1-RPS31-NRg-8":18752,
"YLR050Cg1-SPC97-NRg-6":18753,
"YLR050Cg1-EBP2-NRg-1":18754,
"YLR050Cg1-CDC48-TRg-5":18755,
"YLR050Cg1-RPT1-TRg-4":18756,
"YLR050Cg1-ULP1-NRg-2":18757,
"YLR050Cg1-RPN3-TRg-6":18758,
"YLR050Cg1-RPT1-TRg-5":18759,
"YLR050Cg1-KRE5-TRg-2":18760,
"YLR050Cg1-TBF1-NRg-8":18761,
"YLR050Cg1-UTP22-NRg-4":18762,
"YLR050Cg1-SSC1-NRg-4":18763,
"YLR050Cg1-REB1-TRg-4":18764,
"YLR050Cg1-CDC48-NRg-9":18765,
"YLR050Cg1-FAS2-TRg-8":18766,
"YLR050Cg1-TAO3-TRg-8":18767,
"YLR050Cg1-CKS1-TRg-5":18768,
"YLR050Cg1-YLR379W-TRg-7":18769,
"YLR050Cg1-TEN1-NRg-2":18770,
"YLR050Cg1-RPL42A-TRg-2":18771,
"YLR050Cg1-SEC27-TRg-4":18772,
"YLR050Cg1-TBF1-NRg-4":18773,
"YLR050Cg1-RPT1-NRg-6":18774,
"YLR050Cg1-COG1-TRg-3":18775,
"YLR050Cg1-SUI1-TRg-6":18776,
"YLR050Cg1-TIM23-TRg-6":18777,
"YLR050Cg1-CDC48-NRg-6":18778,
"YLR050Cg1-EPL1-TRg-5":18779,
"YLR050Cg1-RPT5-TRg-8":18780,
"YLR050Cg1-ATP16-NRg-4":18781,
"YLR050Cg1-RPN6-TRg-3":18782,
"YLR050Cg1-ERG9-NRg-6":18783,
"YLR050Cg1-SMX3-TRg-1":18784,
"YLR050Cg1-NCB2-NRg-3":18785,
"YLR050Cg1-SEC16-NRg-12":18786,
"YLR050Cg1-RPN6-TRg-2":18787,
"YLR050Cg1-REB1-NRg-4":18788,
"YLR050Cg1-ATP16-TRg-9":18789,
"YLR050Cg1-ERG9-NRg-7":18790,
"SAP30g7-RPL15A-NRg-4":18791,
"SAP30g7-RPL15A-NRg-5":18792,
"SAP30g7-KRE33-TRg-1":18793,
"SAP30g7-PMI40-NRg-1":18794,
"SAP30g7-NOP19-NRg-3":18795,
"SAP30g7-SRP14-NRg-4":18796,
"SAP30g7-SEC27-TRg-2":18797,
"SAP30g7-GPI14-TRg-3":18798,
"SAP30g7-PAH1-TRg-7":18799,
"SAP30g7-PAH1-TRg-6":18800,
"SAP30g7-PAH1-TRg-5":18801,
"SAP30g7-PAH1-TRg-3":18802,
"SAP30g7-COG3-TRg-1":18803,
"SAP30g7-HTS1-NRg-5":18804,
"SAP30g7-MSN5-TRg-7":18805,
"SAP30g7-ERG26-TRg-1":18806,
"SAP30g7-SMD2-TRg-5":18807,
"SAP30g7-SMD2-TRg-4":18808,
"SAP30g7-SMD2-TRg-1":18809,
"SAP30g7-PRE7-TRg-4":18810,
"SAP30g7-PRE7-TRg-7":18811,
"SAP30g7-SEC6-TRg-3":18812,
"SAP30g7-ESF2-NRg-1":18813,
"SAP30g7-ESF2-NRg-3":18814,
"SAP30g7-AFG2-TRg-2":18815,
"SAP30g7-RRP36-TRg-3":18816,
"SAP30g7-RRP36-TRg-5":18817,
"SAP30g7-GCR1-NRg-2":18818,
"SAP30g7-PRE4-NRg-4":18819,
"SAP30g7-PRE4-NRg-9":18820,
"SAP30g7-DSN1-NRg-2":18821,
"SAP30g7-GPI11-TRg-3":18822,
"SAP30g7-POP3-TRg-1":18823,
"SAP30g7-MNE1-TRg-5":18824,
"SAP30g7-RRP12-NRg-1":18825,
"SAP30g7-RSC6-TRg-2":18826,
"SAP30g7-CDC25-TRg-1":18827,
"SAP30g7-CDC25-TRg-9":18828,
"SAP30g7-YPP1-NRg-3":18829,
"SAP30g7-NFS1-NRg-9":18830,
"SAP30g7-NFS1-NRg-8":18831,
"SAP30g7-UBA2-TRg-1":18832,
"SAP30g7-ARP2-NRg-3":18833,
"SAP30g7-MAK16-TRg-1":18834,
"SAP30g7-CEP3-NRg-1":18835,
"SAP30g7-GUK1-TRg-5":18836,
"SAP30g7-GUK1-TRg-2":18837,
"SAP30g7-GPI12-NRg-6":18838,
"SAP30g7-RPS5-NRg-5":18839,
"SAP30g7-RPS5-NRg-2":18840,
"SAP30g7-RPC19-NRg-1":18841,
"SAP30g7-TIM54-TRg-1":18842,
"SAP30g7-TEN1-TRg-2":18843,
"SAP30g7-SAH1-NRg-4":18844,
"SAP30g7-SAH1-NRg-5":18845,
"SAP30g7-SAH1-NRg-3":18846,
"SAP30g7-ATP15-NRg-5":18847,
"SAP30g7-SCD5-TRg-5":18848,
"SAP30g7-ARB1-NRg-2":18849,
"SAP30g7-ARB1-NRg-4":18850,
"SAP30g7-PUP2-TRg-1":18851,
"SAP30g7-CCT8-TRg-2":18852,
"SAP30g7-MCM4-TRg-1":18853,
"SAP30g7-LSM4-TRg-1":18854,
"SAP30g7-NOP53-NRg-1":18855,
"SAP30g7-ATP3-TRg-4":18856,
"SAP30g7-AFG2-NRg-3":18857,
"SAP30g7-PRO3-NRg-3":18858,
"SAP30g7-NRD1-NRg-10":18859,
"SAP30g7-SEC61-TRg-2":18860,
"SAP30g7-RHO3-TRg-4":18861,
"SAP30g7-SNF2-TRg-6":18862,
"SAP30g7-SMD2-NRg-3":18863,
"SAP30g7-RSC4-TRg-2":18864,
"SAP30g7-RSC4-TRg-1":18865,
"SAP30g7-TIF34-TRg-2":18866,
"SAP30g7-BET1-NRg-1":18867,
"SAP30g7-CDC8-NRg-2":18868,
"SAP30g7-PRP42-TRg-2":18869,
"SAP30g7-RRB1-TRg-2":18870,
"SAP30g7-SPC24-TRg-1":18871,
"SAP30g7-ILS1-NRg-1":18872,
"SAP30g7-GFA1-TRg-2":18873,
"SAP30g7-SEC21-NRg-10":18874,
"SAP30g7-RPC10-NRg-1":18875,
"SAP30g7-RPB10-TRg-3":18876,
"SAP30g7-RPB10-TRg-2":18877,
"SAP30g7-YNL181W-TRg-1":18878,
"SAP30g7-RAD3-NRg-1":18879,
"SAP30g7-NOP10-TRg-1":18880,
"SAP30g7-BFR2-TRg-3":18881,
"SAP30g7-MCM2-TRg-6":18882,
"SAP30g7-MCM2-TRg-4":18883,
"SAP30g7-MPP10-TRg-1":18884,
"SAP30g7-RET2-TRg-4":18885,
"SAP30g7-RET2-TRg-1":18886,
"SAP30g7-RPS2-NRg-1":18887,
"SAP30g7-RPS2-NRg-2":18888,
"SAP30g7-ORC4-NRg-3":18889,
"SAP30g7-TIP20-TRg-7":18890,
"SAP30g7-SMT3-TRg-1":18891,
"SAP30g7-MSS18-NRg-6":18892,
"SAP30g7-YEF3-NRg-9":18893,
"SAP30g7-ASK1-NRg-1":18894,
"SAP30g7-SMC1-TRg-1":18895,
"SAP30g7-NIP1-NRg-1":18896,
"SAP30g7-RPP1-NRg-1":18897,
"SAP30g7-YDJ1-TRg-6":18898,
"SAP30g7-SUB2-NRg-1":18899,
"SAP30g7-TIM10-NRg-8":18900,
"SAP30g7-TIM10-NRg-4":18901,
"SAP30g7-TIM10-NRg-7":18902,
"SAP30g7-SKI6-TRg-4":18903,
"SAP30g7-TUB4-TRg-1":18904,
"SAP30g7-CDC37-NRg-2":18905,
"SAP30g7-ISD11-TRg-3":18906,
"SAP30g7-YOS1-TRg-4":18907,
"SAP30g7-SSC1-TRg-6":18908,
"SAP30g7-MTR3-TRg-5":18909,
"SAP30g7-MTR3-TRg-6":18910,
"SAP30g7-TFA1-TRg-2":18911,
"SAP30g7-CDC3-NRg-3":18912,
"SAP30g7-ERG25-TA-18":18913,
"SAP30g7-RPB11-TRg-4":18914,
"SAP30g7-RPB11-TRg-1":18915,
"SAP30g7-RPB11-TRg-2":18916,
"SAP30g7-DED1-TRg-3":18917,
"SAP30g7-DED1-TRg-1":18918,
"SAP30g7-DED1-TRg-6":18919,
"SAP30g7-DED1-TRg-4":18920,
"SAP30g7-RPL10-NRg-5":18921,
"SAP30g7-RPL10-NRg-4":18922,
"SAP30g7-EFB1-NRg-1":18923,
"SAP30g7-EFB1-NRg-5":18924,
"SAP30g7-EFB1-NRg-4":18925,
"SAP30g7-RPT3-NRg-1":18926,
"SAP30g7-SAC6-TRg-8":18927,
"SAP30g7-SAC6-TRg-4":18928,
"SAP30g7-SAC6-TRg-5":18929,
"SAP30g7-SAC6-TRg-3":18930,
"SAP30g7-DIM1-TRg-5":18931,
"SAP30g7-DIM1-TRg-7":18932,
"SAP30g7-RPC17-NRg-1":18933,
"SAP30g7-RPC17-NRg-2":18934,
"SAP30g7-YDR341C-TRg-1":18935,
"SAP30g7-RAP1-NRg-8":18936,
"SAP30g7-RAP1-NRg-5":18937,
"SAP30g7-RAP1-NRg-2":18938,
"SAP30g7-SEC26-NRg-3":18939,
"SAP30g7-SPP41-TRg-3":18940,
"SAP30g7-TAP42-NRg-1":18941,
"SAP30g7-PGA2-TRg-6":18942,
"SAP30g7-BRL1-TRg-1":18943,
"SAP30g7-FOL2-TRg-1":18944,
"SAP30g7-NAB3-NRg-5":18945,
"SAP30g7-SNF4-TRg-4":18946,
"SAP30g7-HRR25-TRg-2":18947,
"SAP30g7-TRS23-TRg-4":18948,
"SAP30g7-CTR86-TRg-4":18949,
"SAP30g7-RPB5-TRg-5":18950,
"SAP30g7-SPN1-NRg-2":18951,
"SAP30g7-SPN1-NRg-1":18952,
"SAP30g7-SEC61-NRg-1":18953,
"SAP30g7-SEC61-NRg-7":18954,
"SAP30g7-TUS1-TRg-3":18955,
"SAP30g7-OLE1-NRg-2":18956,
"SAP30g7-AFG2-TRg-1":18957,
"SAP30g7-TOA2-NRg-1":18958,
"SAP30g7-USO1-TRg-1":18959,
"SAP30g7-UTP22-NRg-2":18960,
"SAP30g7-RIB1-TRg-3":18961,
"SAP30g7-RIB1-TRg-7":18962,
"SAP30g7-RIB1-TRg-4":18963,
"SAP30g7-COG1-TRg-1":18964,
"SAP30g7-RPL32-NRg-2":18965,
"SAP30g7-GLC7-NRg-3":18966,
"SAP30g7-GLC7-NRg-4":18967,
"SAP30g7-HSF1-TRg-2":18968,
"SAP30g7-DAM1-NRg-5":18969,
"SAP30g7-SEC18-TRg-4":18970,
"SAP30g7-SEC18-TRg-5":18971,
"SAP30g7-PAB1-NRg-3":18972,
"SAP30g7-POP8-TRg-2":18973,
"SAP30g7-PAB1-NRg-4":18974,
"SAP30g7-BIG1-TRg-4":18975,
"SAP30g7-BIG1-TRg-5":18976,
"SAP30g7-BIG1-TRg-6":18977,
"SAP30g7-RPO41-NRg-1":18978,
"SAP30g7-RVB2-NRg-2":18979,
"SAP30g7-PET117-NRg-8":18980,
"SAP30g7-VPS45-NRg-9":18981,
"SAP30g7-YCG1-NRg-1":18982,
"SAP30g7-NOC4-NRg-1":18983,
"SAP30g7-NMD3-NRg-2":18984,
"SAP30g7-DRS1-TRg-2":18985,
"SAP30g7-HTB1-NRg-2":18986,
"SAP30g7-IPI1-TRg-2":18987,
"SAP30g7-SEC18-NRg-1":18988,
"SAP30g7-SEC18-NRg-2":18989,
"SAP30g7-JIP5-NRg-2":18990,
"SAP30g7-YPT1-TRg-3":18991,
"SAP30g7-YPT1-TRg-2":18992,
"SAP30g7-CLF1-NRg-2":18993,
"SAP30g7-SNF2-NRg-7":18994,
"SAP30g7-SNF2-NRg-4":18995,
"SAP30g7-RPL25-NRg-1":18996,
"SAP30g7-NOP56-TRg-1":18997,
"SAP30g7-NOP56-TRg-2":18998,
"SAP30g7-TRS31-TRg-1":18999,
"SAP30g7-DBF4-TRg-2":19000,
"SAP30g7-DBF4-TRg-1":19001,
"SAP30g7-RPC19-TRg-4":19002,
"SAP30g7-RPC19-TRg-6":19003,
"SAP30g7-RPC19-TRg-3":19004,
"SAP30g7-ROK1-NRg-1":19005,
"SAP30g7-CDC33-TRg-4":19006,
"SAP30g7-DHR2-TRg-3":19007,
"SAP30g7-RRP42-NRg-5":19008,
"SAP30g7-CLF1-TRg-1":19009,
"SAP30g7-ERG11-NA-16":19010,
"SAP30g7-VAS1-NRg-4":19011,
"SAP30g7-PIK1-NRg-2":19012,
"SAP30g7-SAR1-NRg-7":19013,
"SAP30g7-SAR1-NRg-4":19014,
"SAP30g7-RPS3-TRg-1":19015,
"SAP30g7-YTM1-TRg-2":19016,
"SAP30g7-SUI3-NRg-5":19017,
"SAP30g7-SUI3-NRg-2":19018,
"SAP30g7-RRP7-TRg-4":19019,
"SAP30g7-RRP7-TRg-6":19020,
"SAP30g7-NIP7-TRg-2":19021,
"SAP30g7-MDM35-TRg-1":19022,
"SAP30g7-ALA1-NRg-1":19023,
"SAP30g7-DOA4-NRg-2":19024,
"SAP30g7-RPS13-NRg-1":19025,
"SAP30g7-YSF3-TRg-2":19026,
"SAP30g7-RPS2-NRg-11":19027,
"SAP30g7-SSL1-TRg-10":19028,
"SAP30g7-NIP7-TRg-1":19029,
"SAP30g7-LST8-NRg-1":19030,
"SAP30g7-TAF4-TRg-3":19031,
"SAP30g7-HAS1-TRg-2":19032,
"SAP30g7-GLC7-TRg-2":19033,
"SAP30g7-CDC45-NRg-1":19034,
"SAP30g7-SEC22-NRg-8":19035,
"SAP30g7-YOS1-TRg-2":19036,
"SAP30g7-RBA50-TRg-3":19037,
"SAP30g7-SPP41-NRg-2":19038,
"SAP30g7-PRP46-TRg-2":19039,
"SAP30g7-PGA2-NRg-1":19040,
"SAP30g7-CBF5-TRg-3":19041,
"SAP30g7-TCP1-NRg-3":19042,
"SAP30g7-TCP1-NRg-2":19043,
"SAP30g7-ERG26-NRg-2":19044,
"SAP30g7-ERG26-NRg-4":19045,
"SAP30g7-MES1-TRg-5":19046,
"SAP30g7-HTS1-TRg-2":19047,
"SAP30g7-SSS1-TRg-3":19048,
"SAP30g7-SSS1-TRg-2":19049,
"SAP30g7-SYS1-TRg-7":19050,
"SAP30g7-SYS1-TRg-2":19051,
"SAP30g7-SYS1-TRg-1":19052,
"SAP30g7-BFR2-TRg-1":19053,
"SAP30g7-EOS1-TRg-3":19054,
"SAP30g7-TAF4-NRg-1":19055,
"SAP30g7-ARL3-NRg-8":19056,
"SAP30g7-RPN5-NRg-1":19057,
"SAP30g7-TIM9-NRg-2":19058,
"SAP30g7-NUP57-NRg-3":19059,
"SAP30g7-VPS4-TRg-1":19060,
"SAP30g7-CDC3-TRg-4":19061,
"SAP30g7-BBP1-NRg-1":19062,
"SAP30g7-BBP1-NRg-2":19063,
"SAP30g7-USE1-NRg-3":19064,
"SAP30g7-CCT7-TRg-1":19065,
"SAP30g7-SAH1-TRg-3":19066,
"SAP30g7-CHS2-TRg-1":19067,
"SAP30g7-DPM1-TRg-2":19068,
"SAP30g7-BBP1-TRg-1":19069,
"SAP30g7-NRD1-TRg-4":19070,
"SAP30g7-RPB3-NRg-1":19071,
"SAP30g7-PHO85-NRg-6":19072,
"SAP30g7-SNF6-TRg-6":19073,
"SAP30g7-PRP38-NRg-2":19074,
"SAP30g7-OAR1-NRg-3":19075,
"SAP30g7-ROX3-NRg-1":19076,
"SAP30g7-YPP1-TRg-6":19077,
"SAP30g7-CBF2-NRg-8":19078,
"SAP30g7-SPT6-TRg-5":19079,
"SAP30g7-SEC10-NRg-1":19080,
"SAP30g7-NSL1-NRg-3":19081,
"SAP30g7-NRD1-NRg-8":19082,
"SAP30g7-RPB3-TRg-1":19083,
"SAP30g7-NRD1-NRg-4":19084,
"SAP30g7-RVB1-TRg-2":19085,
"SAP30g7-TIF5-NRg-8":19086,
"SAP30g7-EOS1-NRg-1":19087,
"SAP30g7-ERG25-NA-26":19088,
"SAP30g7-MSL5-NRg-4":19089,
"SAP30g7-SEC24-TRg-2":19090,
"SAP30g7-RPL30-NRg-5":19091,
"SAP30g7-SNU71-NRg-3":19092,
"SAP30g7-CDC33-NRg-1":19093,
"SAP30g7-RPN6-TRg-4":19094,
"SAP30g7-NAB2-TRg-4":19095,
"SAP30g7-NAB2-TRg-6":19096,
"SAP30g7-YTM1-NRg-1":19097,
"SAP30g7-OLE1-TRg-8":19098,
"SAP30g7-OLE1-TRg-1":19099,
"SAP30g7-UTP7-TRg-4":19100,
"SAP30g7-ACT1-NRg-6":19101,
"SAP30g7-RPL18A-NRg-3":19102,
"SAP30g7-BRX1-NRg-1":19103,
"SAP30g7-NAF1-TRg-8":19104,
"SAP30g7-NAF1-TRg-6":19105,
"SAP30g7-NAF1-TRg-4":19106,
"SAP30g7-CDC8-TRg-2":19107,
"SAP30g7-NSE4-TRg-1":19108,
"SAP30g7-PAB1-NRg-2":19109,
"SAP30g7-PRP43-TRg-4":19110,
"SAP30g7-SEC2-NRg-3":19111,
"SAP30g7-SEC2-NRg-6":19112,
"SAP30g7-MPP10-NRg-5":19113,
"SAP30g7-YDR355C-TRg-2":19114,
"SAP30g7-YLR339C-TRg-9":19115,
"SAP30g7-SNM1-TRg-2":19116,
"SAP30g7-ALR1-NRg-4":19117,
"SAP30g7-ALR1-NRg-1":19118,
"SAP30g7-ALR1-NRg-3":19119,
"SAP30g7-RPL10-TRg-1":19120,
"SAP30g7-RPL28-TRg-2":19121,
"SAP30g7-UTP25-TRg-1":19122,
"SAP30g7-POB3-TRg-1":19123,
"SAP30g7-POB3-TRg-3":19124,
"SAP30g7-POB3-TRg-2":19125,
"SAP30g7-MED11-TRg-1":19126,
"SAP30g7-ISA1-TRg-15":19127,
"SAP30g7-RRP1-NRg-1":19128,
"SAP30g7-MES1-NRg-1":19129,
"SAP30g7-SEC13-NRg-5":19130,
"SAP30g7-MCM2-NRg-2":19131,
"SAP30g7-ALA1-TRg-4":19132,
"SAP30g7-MTG2-TRg-5":19133,
"SAP30g7-TIF35-NRg-3":19134,
"SAP30g7-NSE1-TRg-3":19135,
"SAP30g7-NSE1-TRg-4":19136,
"SAP30g7-MOB2-NRg-6":19137,
"SAP30g7-VRG4-NRg-3":19138,
"SAP30g7-PRP9-TRg-3":19139,
"SAP30g7-HYM1-TRg-5":19140,
"SAP30g7-POP1-TRg-5":19141,
"SAP30g7-POP1-TRg-9":19142,
"SAP30g7-RPL17A-TRg-1":19143,
"SAP30g7-SLD2-TRg-1":19144,
"SAP30g7-CDC48-NRg-7":19145,
"SAP30g7-FHL1-NRg-2":19146,
"SAP30g7-BET3-NRg-7":19147,
"SAP30g7-MAK21-TRg-1":19148,
"SAP30g7-BRN1-TRg-4":19149,
"SAP30g7-FBA1-NRg-3":19150,
"SAP30g7-CDC42-TRg-6":19151,
"SAP30g7-CDC42-TRg-7":19152,
"SAP30g7-COG4-NRg-1":19153,
"SAP30g7-ATP3-NRg-3":19154,
"SAP30g7-ATP3-NRg-2":19155,
"SAP30g7-SMP3-TRg-5":19156,
"SAP30g7-CFT2-NRg-2":19157,
"SAP30g7-FAS2-TRg-5":19158,
"SAP30g7-DBP2-NRg-3":19159,
"SAP30g7-DBP2-NRg-2":19160,
"SAP30g7-MPS2-NRg-4":19161,
"SAP30g7-ARC35-TRg-2":19162,
"SAP30g7-ARC35-TRg-5":19163,
"SAP30g7-MRD1-TRg-1":19164,
"SAP30g7-RLP7-TRg-1":19165,
"SAP30g7-SPC34-TRg-1":19166,
"SAP30g7-CDC45-TRg-2":19167,
"SAP30g7-GCD6-TRg-3":19168,
"SAP30g7-GCD6-TRg-4":19169,
"SAP30g7-YPT6-NRg-2":19170,
"SAP30g7-RPS13-TRg-2":19171,
"SAP30g7-IPI3-TRg-3":19172,
"SAP30g7-TIF5-NRg-9":19173,
"SAP30g7-TIF5-NRg-7":19174,
"SAP30g7-TIF5-NRg-6":19175,
"SAP30g7-NAB3-TRg-3":19176,
"SAP30g7-GCD2-TRg-1":19177,
"SAP30g7-UBA1-TRg-2":19178,
"SAP30g7-SLD3-TRg-6":19179,
"SAP30g7-LCB1-TRg-5":19180,
"SAP30g7-TOA2-TRg-6":19181,
"SAP30g7-TOA2-TRg-1":19182,
"SAP30g7-TOA2-TRg-3":19183,
"SAP30g7-LSM2-TRg-1":19184,
"SAP30g7-YML6-TRg-13":19185,
"SAP30g7-YML6-TRg-12":19186,
"SAP30g7-UTP15-NRg-1":19187,
"SAP30g7-TIF6-NRg-8":19188,
"SAP30g7-SUP35-NRg-1":19189,
"SAP30g7-MPP10-NRg-1":19190,
"SAP30g7-SWI3-TRg-7":19191,
"SAP30g7-SSN3-NRg-2":19192,
"SAP30g7-SEC13-NRg-7":19193,
"SAP30g7-RPS15-NRg-3":19194,
"SAP30g7-RPL3-TRg-2":19195,
"SAP30g7-FBA1-NRg-2":19196,
"SAP30g7-FBA1-NRg-1":19197,
"SAP30g7-FBA1-NRg-5":19198,
"SAP30g7-DAM1-TRg-2":19199,
"SAP30g7-NHP2-TRg-2":19200,
"SAP30g7-HCA4-NRg-6":19201,
"SAP30g7-PRE3-TRg-4":19202,
"SAP30g7-DBP5-NRg-4":19203,
"SAP30g7-SPT6-NRg-4":19204,
"SAP30g7-SPT6-NRg-2":19205,
"SAP30g7-RPL18A-TRg-4":19206,
"SAP30g7-KSH1-TRg-1":19207,
"SAP30g7-KSH1-TRg-3":19208,
"SAP30g7-IPI3-NRg-1":19209,
"SAP30g7-PGA2-TRg-8":19210,
"SAP30g7-RPL18A-TRg-2":19211,
"SAP30g7-RPL33A-NRg-6":19212,
"SAP30g7-TAF12-NRg-2":19213,
"SAP30g7-USE1-TRg-5":19214,
"SAP30g7-YNL114C-TRg-1":19215,
"SAP30g7-SMC5-TRg-7":19216,
"SAP30g7-SMC5-TRg-6":19217,
"SAP30g7-RSC58-TRg-1":19218,
"SAP30g7-CTF13-TRg-2":19219,
"SAP30g7-NAB2-NRg-2":19220,
"SAP30g7-MCM7-TRg-4":19221,
"SAP30g7-BCP1-NRg-5":19222,
"SAP30g7-STU2-TRg-3":19223,
"SAP30g7-SEC21-NRg-6":19224,
"SAP30g7-SEC21-NRg-3":19225,
"SAP30g7-RPL1B-TRg-3":19226,
"SAP30g7-SEC20-NRg-2":19227,
"SAP30g7-VMA3-NRg-2":19228,
"SAP30g7-SEC23-NRg-5":19229,
"SAP30g7-CDC28-TRg-4":19230,
"SAP30g7-RPN12-NRg-11":19231,
"SAP30g7-PUP3-TRg-3":19232,
"SAP30g7-SEC31-TRg-2":19233,
"SAP30g7-SED5-TRg-6":19234,
"SAP30g7-SED5-TRg-5":19235,
"SAP30g7-RPL33A-TRg-1":19236,
"SAP30g7-RPL33A-TRg-2":19237,
"SAP30g7-MRPL11-TRg-2":19238,
"SAP30g7-RTP1-NRg-2":19239,
"SAP30g7-NUG1-TRg-2":19240,
"SAP30g7-VPH2-TRg-4":19241,
"SAP30g7-COP1-NRg-3":19242,
"SAP30g7-CRM1-NRg-1":19243,
"SAP30g7-RPL5-NRg-4":19244,
"SAP30g7-SNU13-NRg-4":19245,
"SAP30g7-PFS2-TRg-3":19246,
"SAP30g7-MPP10-TRg-2":19247,
"SAP30g7-TSR4-NRg-2":19248,
"SAP30g7-RSC2-TRg-1":19249,
"SAP30g7-SEC65-TRg-2":19250,
"SAP30g7-SMI1-NRg-1":19251,
"SAP30g7-RTT105-NRg-4":19252,
"SAP30g7-VMA5-TRg-3":19253,
"SAP30g7-VMA5-TRg-5":19254,
"SAP30g7-RRP1-TRg-3":19255,
"SAP30g7-CLC1-TRg-2":19256,
"SAP30g7-GCD6-NRg-1":19257,
"SAP30g7-GCD6-NRg-2":19258,
"SAP30g7-PXR1-TRg-1":19259,
"SAP30g7-CDC14-NRg-1":19260,
"SAP30g7-PCF11-TRg-6":19261,
"SAP30g7-PCF11-TRg-5":19262,
"SAP30g7-PCF11-TRg-4":19263,
"SAP30g7-SEC31-NRg-1":19264,
"SAP30g7-RRP5-NRg-1":19265,
"SAP30g7-PRE10-TRg-5":19266,
"SAP30g7-PRE10-TRg-1":19267,
"SAP30g7-RPS5-TRg-2":19268,
"SAP30g7-NSP1-TRg-4":19269,
"SAP30g7-PRP38-TRg-4":19270,
"SAP30g7-RCF1-NRg-5":19271,
"SAP30g7-RSC3-TRg-4":19272,
"SAP30g7-RSC3-TRg-5":19273,
"SAP30g7-RSC3-TRg-6":19274,
"SAP30g7-HTA1-NRg-12":19275,
"SAP30g7-HTA1-NRg-11":19276,
"SAP30g7-UTP23-TRg-2":19277,
"SAP30g7-GCD7-NRg-1":19278,
"SAP30g7-GCD7-NRg-2":19279,
"SAP30g7-GCD7-NRg-6":19280,
"SAP30g7-GAL11-NRg-2":19281,
"SAP30g7-GAL11-NRg-9":19282,
"SAP30g7-PHO4-TRg-5":19283,
"SAP30g7-SNP1-NRg-3":19284,
"SAP30g7-RPC37-TRg-5":19285,
"SAP30g7-CRM1-TRg-5":19286,
"SAP30g7-CRM1-TRg-2":19287,
"SAP30g7-ASK1-TRg-7":19288,
"SAP30g7-STU2-NRg-4":19289,
"SAP30g7-NEO1-NRg-3":19290,
"SAP30g7-GAL11-TRg-5":19291,
"SAP30g7-GAL11-TRg-7":19292,
"SAP30g7-SAM50-NRg-3":19293,
"SAP30g7-CSL4-TRg-2":19294,
"SAP30g7-CCT5-TRg-2":19295,
"SAP30g7-POL30-NRg-1":19296,
"SAP30g7-MED4-TRg-4":19297,
"SAP30g7-MED4-TRg-3":19298,
"SAP30g7-MED4-TRg-2":19299,
"SAP30g7-GDI1-TRg-4":19300,
"SAP30g7-GDI1-TRg-3":19301,
"SAP30g7-REB1-TRg-6":19302,
"SAP30g7-MRPL37-NRg-2":19303,
"SAP30g7-NOC3-TRg-3":19304,
"SAP30g7-SPC97-TRg-3":19305,
"SAP30g7-IPP1-TRg-3":19306,
"SAP30g7-IPP1-TRg-2":19307,
"SAP30g7-PTI1-TRg-3":19308,
"SAP30g7-PTI1-TRg-5":19309,
"SAP30g7-RFC5-NRg-1":19310,
"SAP30g7-CDC24-TRg-1":19311,
"SAP30g7-CDC24-TRg-3":19312,
"SAP30g7-CDC24-TRg-5":19313,
"SAP30g7-CDC24-TRg-6":19314,
"SAP30g7-UTP23-TRg-6":19315,
"SAP30g7-UTP23-TRg-4":19316,
"SAP30g7-UTP23-TRg-1":19317,
"SAP30g7-RHO3-NRg-4":19318,
"SAP30g7-TRS23-NRg-1":19319,
"SAP30g7-TRS23-NRg-3":19320,
"SAP30g7-RSP5-TRg-2":19321,
"SAP30g7-RSP5-TRg-1":19322,
"SAP30g7-SDA1-NRg-1":19323,
"SAP30g7-KAP95-TRg-8":19324,
"SAP30g7-ACO1-TRg-6":19325,
"SAP30g7-HTA1-NRg-3":19326,
"SAP30g7-HTA1-NRg-2":19327,
"SAP30g7-SPN1-TRg-1":19328,
"SAP30g7-MOT1-NRg-7":19329,
"SAP30g7-RPL17A-NRg-4":19330,
"SAP30g7-ADA2-TRg-4":19331,
"SAP30g7-SFH1-NRg-1":19332,
"SAP30g7-SPC97-NRg-5":19333,
"SAP30g7-PRP22-TRg-3":19334,
"SAP30g7-SEN15-TRg-2":19335,
"SAP30g7-RPL3-NRg-2":19336,
"SAP30g7-ISD11-NRg-2":19337,
"SAP30g7-HEM12-TRg-8":19338,
"SAP30g7-SEC10-TRg-1":19339,
"SAP30g7-HTB1-TRg-7":19340,
"SAP30g7-TTI2-TRg-1":19341,
"SAP30g7-ACP1-TRg-2":19342,
"SAP30g7-ACP1-TRg-4":19343,
"SAP30g7-GAL11-NRg-10":19344,
"SAP30g7-UTP22-TRg-2":19345,
"SAP30g7-MST1-NRg-5":19346,
"SAP30g7-RIB7-NRg-2":19347,
"SAP30g7-MCD1-TRg-6":19348,
"SAP30g7-MCD1-TRg-5":19349,
"SAP30g7-GPI8-NRg-2":19350,
"SAP30g7-THS1-TRg-2":19351,
"SAP30g7-RRP7-TRg-2":19352,
"SAP30g7-RRP7-TRg-5":19353,
"SAP30g7-SMX2-NRg-7":19354,
"SAP30g7-RRP45-TRg-5":19355,
"SAP30g7-RRP45-TRg-4":19356,
"SAP30g7-CNS1-TRg-2":19357,
"SAP30g7-FBP1-NRg-9":19358,
"SAP30g7-GCD11-NRg-1":19359,
"SAP30g7-RPL10-TRg-2":19360,
"SAP30g7-NUP192-TRg-4":19361,
"SAP30g7-NUP145-NRg-4":19362,
"SAP30g7-HEM12-TRg-6":19363,
"SAP30g7-PLC1-TRg-3":19364,
"SAP30g7-RPA43-TRg-1":19365,
"SAP30g7-RPB7-NRg-2":19366,
"SAP30g7-RPB7-NRg-3":19367,
"SAP30g7-NSL1-NRg-1":19368,
"SAP30g7-UTP6-TRg-3":19369,
"SAP30g7-UTP6-TRg-1":19370,
"SAP30g7-YJU2-TRg-5":19371,
"SAP30g7-FRS2-NRg-5":19372,
"SAP30g7-TIF35-NRg-2":19373,
"SAP30g7-GPI15-TRg-1":19374,
"SAP30g7-NOP1-NRg-5":19375,
"SAP30g7-GPI15-TRg-4":19376,
"SAP30g7-COG4-TRg-1":19377,
"SAP30g7-TFA1-TRg-1":19378,
"SAP30g7-RHO1-NRg-2":19379,
"SAP30g7-RHO1-NRg-1":19380,
"SAP30g7-CDC55-NRg-2":19381,
"SAP30g7-IDI1-NRg-7":19382,
"SAP30g7-RPL32-TRg-5":19383,
"SAP30g7-RPB5-TRg-4":19384,
"SAP30g7-DIP2-TRg-5":19385,
"SAP30g7-DIP2-TRg-1":19386,
"SAP30g7-RPC40-TRg-2":19387,
"SAP30g7-CDC6-TRg-5":19388,
"SAP30g7-CDC6-TRg-3":19389,
"SAP30g7-DAD2-TRg-2":19390,
"SAP30g7-RVS161-TRg-2":19391,
"SAP30g7-RVS161-TRg-1":19392,
"SAP30g7-SUP45-NRg-3":19393,
"SAP30g7-SRB6-NRg-5":19394,
"SAP30g7-RPC11-TRg-4":19395,
"SAP30g7-RKI1-TRg-8":19396,
"SAP30g7-NIP7-TRg-3":19397,
"SAP30g7-RPL33A-NRg-12":19398,
"SAP30g7-SAM50-TRg-4":19399,
"SAP30g7-NOP4-NRg-1":19400,
"SAP30g7-NOP4-NRg-3":19401,
"SAP30g7-SMX2-TRg-5":19402,
"SAP30g7-POL12-NRg-2":19403,
"SAP30g7-BMS1-NRg-2":19404,
"SAP30g7-RPA190-TRg-5":19405,
"SAP30g7-ALG14-NRg-4":19406,
"SAP30g7-ALG14-NRg-1":19407,
"SAP30g7-PRE5-NRg-1":19408,
"SAP30g7-BIG1-NRg-2":19409,
"SAP30g7-TFA2-TRg-4":19410,
"SAP30g7-IMP4-TRg-6":19411,
"SAP30g7-PAN1-NRg-1":19412,
"SAP30g7-UTP13-TRg-2":19413,
"SAP30g7-KAE1-NRg-3":19414,
"SAP30g7-ERG20-TRg-1":19415,
"SAP30g7-CDC20-TRg-6":19416,
"SAP30g7-PWP2-NRg-2":19417,
"SAP30g7-COG1-NRg-1":19418,
"SAP30g7-RPL1B-TRg-4":19419,
"SAP30g7-RPL1B-TRg-7":19420,
"SAP30g7-UTP20-TRg-3":19421,
"SAP30g7-UTP20-TRg-4":19422,
"SAP30g7-RPL25-TRg-4":19423,
"SAP30g7-RPL25-TRg-2":19424,
"SAP30g7-MCM7-NRg-1":19425,
"SAP30g7-MRP49-TRg-5":19426,
"SAP30g7-ERO1-NRg-3":19427,
"SAP30g7-UTP5-TRg-7":19428,
"SAP30g7-MCM4-NRg-1":19429,
"SAP30g7-PRE3-NRg-1":19430,
"SAP30g7-FCF1-NRg-1":19431,
"SAP30g7-CUS1-NRg-1":19432,
"SAP30g7-PSF1-TRg-2":19433,
"SAP30g7-BCP1-TRg-2":19434,
"SAP30g7-PAN1-TRg-1":19435,
"SAP30g7-PAN1-TRg-3":19436,
"SAP30g7-PAN1-TRg-4":19437,
"SAP30g7-VPS3-TRg-2":19438,
"SAP30g7-YIL060W-NRg-1":19439,
"SAP30g7-VPS53-NRg-1":19440,
"SAP30g7-CYR1-TRg-4":19441,
"SAP30g7-CYR1-TRg-7":19442,
"SAP30g7-MPS1-NRg-1":19443,
"SAP30g7-SRP1-TRg-5":19444,
"SAP30g7-SRP1-TRg-4":19445,
"SAP30g7-TAF12-TRg-2":19446,
"SAP30g7-TAF12-TRg-3":19447,
"SAP30g7-POP4-TRg-1":19448,
"SAP30g7-SPT16-TRg-1":19449,
"SAP30g7-NUP82-TRg-4":19450,
"SAP30g7-DML1-TRg-3":19451,
"SAP30g7-RPA43-NRg-3":19452,
"SAP30g7-STU2-NRg-3":19453,
"SAP30g7-POP4-NRg-4":19454,
"SAP30g7-MCD1-TRg-2":19455,
"SAP30g7-RPS3-NRg-4":19456,
"SAP30g7-PRP9-TRg-4":19457,
"SAP30g7-RPP1-NRg-2":19458,
"SAP30g7-MTR2-NRg-11":19459,
"SAP30g7-GCD11-TRg-1":19460,
"SAP30g7-RPF1-TRg-3":19461,
"SAP30g7-SUB2-NRg-4":19462,
"SAP30g7-GPI15-TRg-3":19463,
"SAP30g7-ERG9-TRg-6":19464,
"SAP30g7-RPT2-NRg-1":19465,
"SAP30g7-YOS1-NRg-3":19466,
"SAP30g7-SCM3-TRg-4":19467,
"SAP30g7-SCM3-TRg-6":19468,
"SAP30g7-RLP7-NRg-1":19469,
"SAP30g7-TFB2-NRg-4":19470,
"SAP30g7-IMP4-TRg-1":19471,
"SAP30g7-IMP4-TRg-3":19472,
"SAP30g7-PRE4-TRg-3":19473,
"SAP30g7-SUB2-TRg-3":19474,
"SAP30g7-RPP0-NRg-4":19475,
"SAP30g7-RPP0-NRg-3":19476,
"SAP30g7-TOM40-TRg-4":19477,
"SAP30g7-FUR1-NRg-12":19478,
"SAP30g7-TOM40-TRg-2":19479,
"SAP30g7-VMA11-NRg-4":19480,
"SAP30g7-PGS1-NRg-4":19481,
"SAP30g7-URB1-TRg-4":19482,
"SAP30g7-ARP4-TRg-3":19483,
"SAP30g7-RPT3-TRg-3":19484,
"SAP30g7-SUI3-TRg-3":19485,
"SAP30g7-RFC5-NRg-2":19486,
"SAP30g7-RRP14-TRg-2":19487,
"SAP30g7-SCC2-TRg-1":19488,
"SAP30g7-SSC1-TRg-3":19489,
"SAP30g7-RRP9-TRg-3":19490,
"SAP30g7-MOT1-NRg-9":19491,
"SAP30g7-RPL42A-NRg-2":19492,
"SAP30g7-SEC16-TRg-7":19493,
"SAP30g7-IMP4-NRg-2":19494,
"SAP30g7-YEF3-NRg-4":19495,
"SAP30g7-PUP1-TRg-1":19496,
"SAP30g7-UTP22-TRg-6":19497,
"SAP30g7-DBP2-NRg-4":19498,
"SAP30g7-PRE2-TRg-7":19499,
"SAP30g7-ATP16-TRg-6":19500,
"SAP30g7-UTP13-TRg-4":19501,
"SAP30g7-DOP1-NRg-4":19502,
"SAP30g7-TIM44-TRg-3":19503,
"SAP30g7-ATP16-TRg-2":19504,
"SAP30g7-ENP1-NRg-3":19505,
"SAP30g7-NAF1-TRg-3":19506,
"SAP30g7-COG4-TRg-2":19507,
"SAP30g7-SOG2-TRg-7":19508,
"SAP30g7-YDR341C-TRg-3":19509,
"SAP30g7-YMR290W-A-TRg-10":19510,
"SAP30g7-NUP192-NRg-9":19511,
"SAP30g7-RPS31-NRg-8":19512,
"SAP30g7-SPC97-NRg-6":19513,
"SAP30g7-EBP2-NRg-1":19514,
"SAP30g7-CDC48-TRg-5":19515,
"SAP30g7-RPT1-TRg-4":19516,
"SAP30g7-ULP1-NRg-2":19517,
"SAP30g7-RPN3-TRg-6":19518,
"SAP30g7-RPT1-TRg-5":19519,
"SAP30g7-KRE5-TRg-2":19520,
"SAP30g7-TBF1-NRg-8":19521,
"SAP30g7-UTP22-NRg-4":19522,
"SAP30g7-SSC1-NRg-4":19523,
"SAP30g7-REB1-TRg-4":19524,
"SAP30g7-CDC48-NRg-9":19525,
"SAP30g7-FAS2-TRg-8":19526,
"SAP30g7-TAO3-TRg-8":19527,
"SAP30g7-CKS1-TRg-5":19528,
"SAP30g7-YLR379W-TRg-7":19529,
"SAP30g7-TEN1-NRg-2":19530,
"SAP30g7-RPL42A-TRg-2":19531,
"SAP30g7-SEC27-TRg-4":19532,
"SAP30g7-TBF1-NRg-4":19533,
"SAP30g7-RPT1-NRg-6":19534,
"SAP30g7-COG1-TRg-3":19535,
"SAP30g7-SUI1-TRg-6":19536,
"SAP30g7-TIM23-TRg-6":19537,
"SAP30g7-CDC48-NRg-6":19538,
"SAP30g7-EPL1-TRg-5":19539,
"SAP30g7-RPT5-TRg-8":19540,
"SAP30g7-ATP16-NRg-4":19541,
"SAP30g7-RPN6-TRg-3":19542,
"SAP30g7-ERG9-NRg-6":19543,
"SAP30g7-SMX3-TRg-1":19544,
"SAP30g7-NCB2-NRg-3":19545,
"SAP30g7-SEC16-NRg-12":19546,
"SAP30g7-RPN6-TRg-2":19547,
"SAP30g7-REB1-NRg-4":19548,
"SAP30g7-ATP16-TRg-9":19549,
"SAP30g7-ERG9-NRg-7":19550,
"PRE7g7-CC3":19551,
"PRE4g9-CC3":19552,
"PRE4g3-CC3":19553,
"RPN5g1-CC3":19554,
"COG3g1-CC3":19555,
"SED5g5-CC3":19556,
"SEC22g1-CC3":19557,
"SEC22g2-CC3":19558,
"COG8g2-CC3":19559,
"GET2g2-CC3":19560,
"IMP4g6-CC3":19561,
"DIP2g5-CC3":19562,
"PWP2g2_BC1-CC3":19563,
"PWP2g2_BC2-CC3":19564,
"TIF6g8-CC3":19565,
"RPF1g3-CC3":19566,
"MAK16g1-CC3":19567,
"YCR016Wg4-CC3":19568,
"YLR050Cg1-CC3":19569,
"SAP30g7-CC3":19570,
"CC8-CC3":19571,
"CC16-CC3":19572,
"CC17-CC3":19573,
"CC8_BC2-CC3":19574,
"CC16_BC2-CC3":19575,
"PRE7g7-CC33":19576,
"PRE4g9-CC33":19577,
"PRE4g3-CC33":19578,
"RPN5g1-CC33":19579,
"COG3g1-CC33":19580,
"SED5g5-CC33":19581,
"SEC22g1-CC33":19582,
"SEC22g2-CC33":19583,
"COG8g2-CC33":19584,
"GET2g2-CC33":19585,
"IMP4g6-CC33":19586,
"DIP2g5-CC33":19587,
"PWP2g2_BC1-CC33":19588,
"PWP2g2_BC2-CC33":19589,
"TIF6g8-CC33":19590,
"RPF1g3-CC33":19591,
"MAK16g1-CC33":19592,
"YCR016Wg4-CC33":19593,
"YLR050Cg1-CC33":19594,
"SAP30g7-CC33":19595,
"CC8-CC33":19596,
"CC16-CC33":19597,
"CC17-CC33":19598,
"CC8_BC2-CC33":19599,
"CC16_BC2-CC33":19600} #good for seqlib13
Col_key = {"37YPDR1T1":1,
"37YPDR1T2":2,
"37YPDR1T3":3,
"37YPDR2T1":4,
"37YPDR2T2":5,
"37YPDR2T3":6,
"37YPDR3T1":7,
"37YPDR3T2":8,
"37YPDR3T3":9,
"48hrR1T1":10,
"48hrR1T2":11,
"48hrR1T3":12,
"48hrR2T1":13,
"48hrR2T2":14,
"48hrR2T3":15,
"48hrR3T1":16,
"48hrR3T2":17,
"48hrR3T3":18,
"P162P161":19,
"P167P161":20,
"P167P163":21,
"P168P163":22,
"P169P164":23,
"P170P165":24,
"P170P166":25} #good for seqlib 13 (updated with non-existent primer combos)
#Save lists to store names of rows and names of columns in matrix that will be used to 
#store count data
col_names = ["37YPDR1T1",
"37YPDR1T2",
"37YPDR1T3",
"37YPDR2T1",
"37YPDR2T2",
"37YPDR2T3",
"37YPDR3T1",
"37YPDR3T2",
"37YPDR3T3",
"48hrR1T1",
"48hrR1T2",
"48hrR1T3",
"48hrR2T1",
"48hrR2T2",
"48hrR2T3",
"48hrR3T1",
"48hrR3T2",
"48hrR3T3",
"P162P161",
"P167P161",
"P167P163",
"P168P163",
"P169P164",
"P170P165",
"P170P166"] #good for seqlib13 (updated with non-existent primer combos)
row_names = ["CC8-CC5",
"CC8-CC8",
"CC8-CC16",
"CC8-CC17",
"CC8-CC19",
"CC8-CC20",
"CC8-CC23",
"CC8-CC25",
"CC8-CC27",
"CC8-CC28",
"CC8-CC30",
"CC8-CC32",
"CC8-CC34",
"CC8-CC35",
"CC8-CC36",
"CC8-CC11",
"CC8-CC14",
"CC8-CC15",
"CC8-CC2",
"CC8-CC22",
"CC8-CC26",
"CC8-CC7",
"CC16-CC5",
"CC16-CC8",
"CC16-CC16",
"CC16-CC17",
"CC16-CC19",
"CC16-CC20",
"CC16-CC23",
"CC16-CC25",
"CC16-CC27",
"CC16-CC28",
"CC16-CC30",
"CC16-CC32",
"CC16-CC34",
"CC16-CC35",
"CC16-CC36",
"CC16-CC11",
"CC16-CC14",
"CC16-CC15",
"CC16-CC2",
"CC16-CC22",
"CC16-CC26",
"CC16-CC7",
"CC17-CC5",
"CC17-CC8",
"CC17-CC16",
"CC17-CC17",
"CC17-CC19",
"CC17-CC20",
"CC17-CC23",
"CC17-CC25",
"CC17-CC27",
"CC17-CC28",
"CC17-CC30",
"CC17-CC32",
"CC17-CC34",
"CC17-CC35",
"CC17-CC36",
"CC17-CC11",
"CC17-CC14",
"CC17-CC15",
"CC17-CC2",
"CC17-CC22",
"CC17-CC26",
"CC17-CC7",
"CC8_BC2-CC5",
"CC8_BC2-CC8",
"CC8_BC2-CC16",
"CC8_BC2-CC17",
"CC8_BC2-CC19",
"CC8_BC2-CC20",
"CC8_BC2-CC23",
"CC8_BC2-CC25",
"CC8_BC2-CC27",
"CC8_BC2-CC28",
"CC8_BC2-CC30",
"CC8_BC2-CC32",
"CC8_BC2-CC34",
"CC8_BC2-CC35",
"CC8_BC2-CC36",
"CC8_BC2-CC11",
"CC8_BC2-CC14",
"CC8_BC2-CC15",
"CC8_BC2-CC2",
"CC8_BC2-CC22",
"CC8_BC2-CC26",
"CC8_BC2-CC7",
"CC16_BC2-CC5",
"CC16_BC2-CC8",
"CC16_BC2-CC16",
"CC16_BC2-CC17",
"CC16_BC2-CC19",
"CC16_BC2-CC20",
"CC16_BC2-CC23",
"CC16_BC2-CC25",
"CC16_BC2-CC27",
"CC16_BC2-CC28",
"CC16_BC2-CC30",
"CC16_BC2-CC32",
"CC16_BC2-CC34",
"CC16_BC2-CC35",
"CC16_BC2-CC36",
"CC16_BC2-CC11",
"CC16_BC2-CC14",
"CC16_BC2-CC15",
"CC16_BC2-CC2",
"CC16_BC2-CC22",
"CC16_BC2-CC26",
"CC16_BC2-CC7",
"PRE7g7-CC5",
"PRE7g7-CC8",
"PRE7g7-CC16",
"PRE7g7-CC17",
"PRE7g7-CC19",
"PRE7g7-CC20",
"PRE7g7-CC23",
"PRE7g7-CC25",
"PRE7g7-CC27",
"PRE7g7-CC28",
"PRE7g7-CC30",
"PRE7g7-CC32",
"PRE7g7-CC34",
"PRE7g7-CC35",
"PRE7g7-CC36",
"PRE7g7-CC11",
"PRE7g7-CC14",
"PRE7g7-CC15",
"PRE7g7-CC2",
"PRE7g7-CC22",
"PRE7g7-CC26",
"PRE7g7-CC7",
"PRE4g9-CC5",
"PRE4g9-CC8",
"PRE4g9-CC16",
"PRE4g9-CC17",
"PRE4g9-CC19",
"PRE4g9-CC20",
"PRE4g9-CC23",
"PRE4g9-CC25",
"PRE4g9-CC27",
"PRE4g9-CC28",
"PRE4g9-CC30",
"PRE4g9-CC32",
"PRE4g9-CC34",
"PRE4g9-CC35",
"PRE4g9-CC36",
"PRE4g9-CC11",
"PRE4g9-CC14",
"PRE4g9-CC15",
"PRE4g9-CC2",
"PRE4g9-CC22",
"PRE4g9-CC26",
"PRE4g9-CC7",
"PRE4g3-CC5",
"PRE4g3-CC8",
"PRE4g3-CC16",
"PRE4g3-CC17",
"PRE4g3-CC19",
"PRE4g3-CC20",
"PRE4g3-CC23",
"PRE4g3-CC25",
"PRE4g3-CC27",
"PRE4g3-CC28",
"PRE4g3-CC30",
"PRE4g3-CC32",
"PRE4g3-CC34",
"PRE4g3-CC35",
"PRE4g3-CC36",
"PRE4g3-CC11",
"PRE4g3-CC14",
"PRE4g3-CC15",
"PRE4g3-CC2",
"PRE4g3-CC22",
"PRE4g3-CC26",
"PRE4g3-CC7",
"RPN5g1-CC5",
"RPN5g1-CC8",
"RPN5g1-CC16",
"RPN5g1-CC17",
"RPN5g1-CC19",
"RPN5g1-CC20",
"RPN5g1-CC23",
"RPN5g1-CC25",
"RPN5g1-CC27",
"RPN5g1-CC28",
"RPN5g1-CC30",
"RPN5g1-CC32",
"RPN5g1-CC34",
"RPN5g1-CC35",
"RPN5g1-CC36",
"RPN5g1-CC11",
"RPN5g1-CC14",
"RPN5g1-CC15",
"RPN5g1-CC2",
"RPN5g1-CC22",
"RPN5g1-CC26",
"RPN5g1-CC7",
"COG3g1-CC5",
"COG3g1-CC8",
"COG3g1-CC16",
"COG3g1-CC17",
"COG3g1-CC19",
"COG3g1-CC20",
"COG3g1-CC23",
"COG3g1-CC25",
"COG3g1-CC27",
"COG3g1-CC28",
"COG3g1-CC30",
"COG3g1-CC32",
"COG3g1-CC34",
"COG3g1-CC35",
"COG3g1-CC36",
"COG3g1-CC11",
"COG3g1-CC14",
"COG3g1-CC15",
"COG3g1-CC2",
"COG3g1-CC22",
"COG3g1-CC26",
"COG3g1-CC7",
"SED5g5-CC5",
"SED5g5-CC8",
"SED5g5-CC16",
"SED5g5-CC17",
"SED5g5-CC19",
"SED5g5-CC20",
"SED5g5-CC23",
"SED5g5-CC25",
"SED5g5-CC27",
"SED5g5-CC28",
"SED5g5-CC30",
"SED5g5-CC32",
"SED5g5-CC34",
"SED5g5-CC35",
"SED5g5-CC36",
"SED5g5-CC11",
"SED5g5-CC14",
"SED5g5-CC15",
"SED5g5-CC2",
"SED5g5-CC22",
"SED5g5-CC26",
"SED5g5-CC7",
"SEC22g1-CC5",
"SEC22g1-CC8",
"SEC22g1-CC16",
"SEC22g1-CC17",
"SEC22g1-CC19",
"SEC22g1-CC20",
"SEC22g1-CC23",
"SEC22g1-CC25",
"SEC22g1-CC27",
"SEC22g1-CC28",
"SEC22g1-CC30",
"SEC22g1-CC32",
"SEC22g1-CC34",
"SEC22g1-CC35",
"SEC22g1-CC36",
"SEC22g1-CC11",
"SEC22g1-CC14",
"SEC22g1-CC15",
"SEC22g1-CC2",
"SEC22g1-CC22",
"SEC22g1-CC26",
"SEC22g1-CC7",
"SEC22g2-CC5",
"SEC22g2-CC8",
"SEC22g2-CC16",
"SEC22g2-CC17",
"SEC22g2-CC19",
"SEC22g2-CC20",
"SEC22g2-CC23",
"SEC22g2-CC25",
"SEC22g2-CC27",
"SEC22g2-CC28",
"SEC22g2-CC30",
"SEC22g2-CC32",
"SEC22g2-CC34",
"SEC22g2-CC35",
"SEC22g2-CC36",
"SEC22g2-CC11",
"SEC22g2-CC14",
"SEC22g2-CC15",
"SEC22g2-CC2",
"SEC22g2-CC22",
"SEC22g2-CC26",
"SEC22g2-CC7",
"COG8g2-CC5",
"COG8g2-CC8",
"COG8g2-CC16",
"COG8g2-CC17",
"COG8g2-CC19",
"COG8g2-CC20",
"COG8g2-CC23",
"COG8g2-CC25",
"COG8g2-CC27",
"COG8g2-CC28",
"COG8g2-CC30",
"COG8g2-CC32",
"COG8g2-CC34",
"COG8g2-CC35",
"COG8g2-CC36",
"COG8g2-CC11",
"COG8g2-CC14",
"COG8g2-CC15",
"COG8g2-CC2",
"COG8g2-CC22",
"COG8g2-CC26",
"COG8g2-CC7",
"GET2g2-CC5",
"GET2g2-CC8",
"GET2g2-CC16",
"GET2g2-CC17",
"GET2g2-CC19",
"GET2g2-CC20",
"GET2g2-CC23",
"GET2g2-CC25",
"GET2g2-CC27",
"GET2g2-CC28",
"GET2g2-CC30",
"GET2g2-CC32",
"GET2g2-CC34",
"GET2g2-CC35",
"GET2g2-CC36",
"GET2g2-CC11",
"GET2g2-CC14",
"GET2g2-CC15",
"GET2g2-CC2",
"GET2g2-CC22",
"GET2g2-CC26",
"GET2g2-CC7",
"IMP4g6-CC5",
"IMP4g6-CC8",
"IMP4g6-CC16",
"IMP4g6-CC17",
"IMP4g6-CC19",
"IMP4g6-CC20",
"IMP4g6-CC23",
"IMP4g6-CC25",
"IMP4g6-CC27",
"IMP4g6-CC28",
"IMP4g6-CC30",
"IMP4g6-CC32",
"IMP4g6-CC34",
"IMP4g6-CC35",
"IMP4g6-CC36",
"IMP4g6-CC11",
"IMP4g6-CC14",
"IMP4g6-CC15",
"IMP4g6-CC2",
"IMP4g6-CC22",
"IMP4g6-CC26",
"IMP4g6-CC7",
"DIP2g5-CC5",
"DIP2g5-CC8",
"DIP2g5-CC16",
"DIP2g5-CC17",
"DIP2g5-CC19",
"DIP2g5-CC20",
"DIP2g5-CC23",
"DIP2g5-CC25",
"DIP2g5-CC27",
"DIP2g5-CC28",
"DIP2g5-CC30",
"DIP2g5-CC32",
"DIP2g5-CC34",
"DIP2g5-CC35",
"DIP2g5-CC36",
"DIP2g5-CC11",
"DIP2g5-CC14",
"DIP2g5-CC15",
"DIP2g5-CC2",
"DIP2g5-CC22",
"DIP2g5-CC26",
"DIP2g5-CC7",
"PWP2g2_BC1-CC5",
"PWP2g2_BC1-CC8",
"PWP2g2_BC1-CC16",
"PWP2g2_BC1-CC17",
"PWP2g2_BC1-CC19",
"PWP2g2_BC1-CC20",
"PWP2g2_BC1-CC23",
"PWP2g2_BC1-CC25",
"PWP2g2_BC1-CC27",
"PWP2g2_BC1-CC28",
"PWP2g2_BC1-CC30",
"PWP2g2_BC1-CC32",
"PWP2g2_BC1-CC34",
"PWP2g2_BC1-CC35",
"PWP2g2_BC1-CC36",
"PWP2g2_BC1-CC11",
"PWP2g2_BC1-CC14",
"PWP2g2_BC1-CC15",
"PWP2g2_BC1-CC2",
"PWP2g2_BC1-CC22",
"PWP2g2_BC1-CC26",
"PWP2g2_BC1-CC7",
"PWP2g2_BC2-CC5",
"PWP2g2_BC2-CC8",
"PWP2g2_BC2-CC16",
"PWP2g2_BC2-CC17",
"PWP2g2_BC2-CC19",
"PWP2g2_BC2-CC20",
"PWP2g2_BC2-CC23",
"PWP2g2_BC2-CC25",
"PWP2g2_BC2-CC27",
"PWP2g2_BC2-CC28",
"PWP2g2_BC2-CC30",
"PWP2g2_BC2-CC32",
"PWP2g2_BC2-CC34",
"PWP2g2_BC2-CC35",
"PWP2g2_BC2-CC36",
"PWP2g2_BC2-CC11",
"PWP2g2_BC2-CC14",
"PWP2g2_BC2-CC15",
"PWP2g2_BC2-CC2",
"PWP2g2_BC2-CC22",
"PWP2g2_BC2-CC26",
"PWP2g2_BC2-CC7",
"TIF6g8-CC5",
"TIF6g8-CC8",
"TIF6g8-CC16",
"TIF6g8-CC17",
"TIF6g8-CC19",
"TIF6g8-CC20",
"TIF6g8-CC23",
"TIF6g8-CC25",
"TIF6g8-CC27",
"TIF6g8-CC28",
"TIF6g8-CC30",
"TIF6g8-CC32",
"TIF6g8-CC34",
"TIF6g8-CC35",
"TIF6g8-CC36",
"TIF6g8-CC11",
"TIF6g8-CC14",
"TIF6g8-CC15",
"TIF6g8-CC2",
"TIF6g8-CC22",
"TIF6g8-CC26",
"TIF6g8-CC7",
"RPF1g3-CC5",
"RPF1g3-CC8",
"RPF1g3-CC16",
"RPF1g3-CC17",
"RPF1g3-CC19",
"RPF1g3-CC20",
"RPF1g3-CC23",
"RPF1g3-CC25",
"RPF1g3-CC27",
"RPF1g3-CC28",
"RPF1g3-CC30",
"RPF1g3-CC32",
"RPF1g3-CC34",
"RPF1g3-CC35",
"RPF1g3-CC36",
"RPF1g3-CC11",
"RPF1g3-CC14",
"RPF1g3-CC15",
"RPF1g3-CC2",
"RPF1g3-CC22",
"RPF1g3-CC26",
"RPF1g3-CC7",
"MAK16g1-CC5",
"MAK16g1-CC8",
"MAK16g1-CC16",
"MAK16g1-CC17",
"MAK16g1-CC19",
"MAK16g1-CC20",
"MAK16g1-CC23",
"MAK16g1-CC25",
"MAK16g1-CC27",
"MAK16g1-CC28",
"MAK16g1-CC30",
"MAK16g1-CC32",
"MAK16g1-CC34",
"MAK16g1-CC35",
"MAK16g1-CC36",
"MAK16g1-CC11",
"MAK16g1-CC14",
"MAK16g1-CC15",
"MAK16g1-CC2",
"MAK16g1-CC22",
"MAK16g1-CC26",
"MAK16g1-CC7",
"YCR016Wg4-CC5",
"YCR016Wg4-CC8",
"YCR016Wg4-CC16",
"YCR016Wg4-CC17",
"YCR016Wg4-CC19",
"YCR016Wg4-CC20",
"YCR016Wg4-CC23",
"YCR016Wg4-CC25",
"YCR016Wg4-CC27",
"YCR016Wg4-CC28",
"YCR016Wg4-CC30",
"YCR016Wg4-CC32",
"YCR016Wg4-CC34",
"YCR016Wg4-CC35",
"YCR016Wg4-CC36",
"YCR016Wg4-CC11",
"YCR016Wg4-CC14",
"YCR016Wg4-CC15",
"YCR016Wg4-CC2",
"YCR016Wg4-CC22",
"YCR016Wg4-CC26",
"YCR016Wg4-CC7",
"YLR050Cg1-CC5",
"YLR050Cg1-CC8",
"YLR050Cg1-CC16",
"YLR050Cg1-CC17",
"YLR050Cg1-CC19",
"YLR050Cg1-CC20",
"YLR050Cg1-CC23",
"YLR050Cg1-CC25",
"YLR050Cg1-CC27",
"YLR050Cg1-CC28",
"YLR050Cg1-CC30",
"YLR050Cg1-CC32",
"YLR050Cg1-CC34",
"YLR050Cg1-CC35",
"YLR050Cg1-CC36",
"YLR050Cg1-CC11",
"YLR050Cg1-CC14",
"YLR050Cg1-CC15",
"YLR050Cg1-CC2",
"YLR050Cg1-CC22",
"YLR050Cg1-CC26",
"YLR050Cg1-CC7",
"SAP30g7-CC5",
"SAP30g7-CC8",
"SAP30g7-CC16",
"SAP30g7-CC17",
"SAP30g7-CC19",
"SAP30g7-CC20",
"SAP30g7-CC23",
"SAP30g7-CC25",
"SAP30g7-CC27",
"SAP30g7-CC28",
"SAP30g7-CC30",
"SAP30g7-CC32",
"SAP30g7-CC34",
"SAP30g7-CC35",
"SAP30g7-CC36",
"SAP30g7-CC11",
"SAP30g7-CC14",
"SAP30g7-CC15",
"SAP30g7-CC2",
"SAP30g7-CC22",
"SAP30g7-CC26",
"SAP30g7-CC7",
"CC8-RPL15A-NRg-4",
"CC8-RPL15A-NRg-5",
"CC8-KRE33-TRg-1",
"CC8-PMI40-NRg-1",
"CC8-NOP19-NRg-3",
"CC8-SRP14-NRg-4",
"CC8-SEC27-TRg-2",
"CC8-GPI14-TRg-3",
"CC8-PAH1-TRg-7",
"CC8-PAH1-TRg-6",
"CC8-PAH1-TRg-5",
"CC8-PAH1-TRg-3",
"CC8-COG3-TRg-1",
"CC8-HTS1-NRg-5",
"CC8-MSN5-TRg-7",
"CC8-ERG26-TRg-1",
"CC8-SMD2-TRg-5",
"CC8-SMD2-TRg-4",
"CC8-SMD2-TRg-1",
"CC8-PRE7-TRg-4",
"CC8-PRE7-TRg-7",
"CC8-SEC6-TRg-3",
"CC8-ESF2-NRg-1",
"CC8-ESF2-NRg-3",
"CC8-AFG2-TRg-2",
"CC8-RRP36-TRg-3",
"CC8-RRP36-TRg-5",
"CC8-GCR1-NRg-2",
"CC8-PRE4-NRg-4",
"CC8-PRE4-NRg-9",
"CC8-DSN1-NRg-2",
"CC8-GPI11-TRg-3",
"CC8-POP3-TRg-1",
"CC8-MNE1-TRg-5",
"CC8-RRP12-NRg-1",
"CC8-RSC6-TRg-2",
"CC8-CDC25-TRg-1",
"CC8-CDC25-TRg-9",
"CC8-YPP1-NRg-3",
"CC8-NFS1-NRg-9",
"CC8-NFS1-NRg-8",
"CC8-UBA2-TRg-1",
"CC8-ARP2-NRg-3",
"CC8-MAK16-TRg-1",
"CC8-CEP3-NRg-1",
"CC8-GUK1-TRg-5",
"CC8-GUK1-TRg-2",
"CC8-GPI12-NRg-6",
"CC8-RPS5-NRg-5",
"CC8-RPS5-NRg-2",
"CC8-RPC19-NRg-1",
"CC8-TIM54-TRg-1",
"CC8-TEN1-TRg-2",
"CC8-SAH1-NRg-4",
"CC8-SAH1-NRg-5",
"CC8-SAH1-NRg-3",
"CC8-ATP15-NRg-5",
"CC8-SCD5-TRg-5",
"CC8-ARB1-NRg-2",
"CC8-ARB1-NRg-4",
"CC8-PUP2-TRg-1",
"CC8-CCT8-TRg-2",
"CC8-MCM4-TRg-1",
"CC8-LSM4-TRg-1",
"CC8-NOP53-NRg-1",
"CC8-ATP3-TRg-4",
"CC8-AFG2-NRg-3",
"CC8-PRO3-NRg-3",
"CC8-NRD1-NRg-10",
"CC8-SEC61-TRg-2",
"CC8-RHO3-TRg-4",
"CC8-SNF2-TRg-6",
"CC8-SMD2-NRg-3",
"CC8-RSC4-TRg-2",
"CC8-RSC4-TRg-1",
"CC8-TIF34-TRg-2",
"CC8-BET1-NRg-1",
"CC8-CDC8-NRg-2",
"CC8-PRP42-TRg-2",
"CC8-RRB1-TRg-2",
"CC8-SPC24-TRg-1",
"CC8-ILS1-NRg-1",
"CC8-GFA1-TRg-2",
"CC8-SEC21-NRg-10",
"CC8-RPC10-NRg-1",
"CC8-RPB10-TRg-3",
"CC8-RPB10-TRg-2",
"CC8-YNL181W-TRg-1",
"CC8-RAD3-NRg-1",
"CC8-NOP10-TRg-1",
"CC8-BFR2-TRg-3",
"CC8-MCM2-TRg-6",
"CC8-MCM2-TRg-4",
"CC8-MPP10-TRg-1",
"CC8-RET2-TRg-4",
"CC8-RET2-TRg-1",
"CC8-RPS2-NRg-1",
"CC8-RPS2-NRg-2",
"CC8-ORC4-NRg-3",
"CC8-TIP20-TRg-7",
"CC8-SMT3-TRg-1",
"CC8-MSS18-NRg-6",
"CC8-YEF3-NRg-9",
"CC8-ASK1-NRg-1",
"CC8-SMC1-TRg-1",
"CC8-NIP1-NRg-1",
"CC8-RPP1-NRg-1",
"CC8-YDJ1-TRg-6",
"CC8-SUB2-NRg-1",
"CC8-TIM10-NRg-8",
"CC8-TIM10-NRg-4",
"CC8-TIM10-NRg-7",
"CC8-SKI6-TRg-4",
"CC8-TUB4-TRg-1",
"CC8-CDC37-NRg-2",
"CC8-ISD11-TRg-3",
"CC8-YOS1-TRg-4",
"CC8-SSC1-TRg-6",
"CC8-MTR3-TRg-5",
"CC8-MTR3-TRg-6",
"CC8-TFA1-TRg-2",
"CC8-CDC3-NRg-3",
"CC8-ERG25-TA-18",
"CC8-RPB11-TRg-4",
"CC8-RPB11-TRg-1",
"CC8-RPB11-TRg-2",
"CC8-DED1-TRg-3",
"CC8-DED1-TRg-1",
"CC8-DED1-TRg-6",
"CC8-DED1-TRg-4",
"CC8-RPL10-NRg-5",
"CC8-RPL10-NRg-4",
"CC8-EFB1-NRg-1",
"CC8-EFB1-NRg-5",
"CC8-EFB1-NRg-4",
"CC8-RPT3-NRg-1",
"CC8-SAC6-TRg-8",
"CC8-SAC6-TRg-4",
"CC8-SAC6-TRg-5",
"CC8-SAC6-TRg-3",
"CC8-DIM1-TRg-5",
"CC8-DIM1-TRg-7",
"CC8-RPC17-NRg-1",
"CC8-RPC17-NRg-2",
"CC8-YDR341C-TRg-1",
"CC8-RAP1-NRg-8",
"CC8-RAP1-NRg-5",
"CC8-RAP1-NRg-2",
"CC8-SEC26-NRg-3",
"CC8-SPP41-TRg-3",
"CC8-TAP42-NRg-1",
"CC8-PGA2-TRg-6",
"CC8-BRL1-TRg-1",
"CC8-FOL2-TRg-1",
"CC8-NAB3-NRg-5",
"CC8-SNF4-TRg-4",
"CC8-HRR25-TRg-2",
"CC8-TRS23-TRg-4",
"CC8-CTR86-TRg-4",
"CC8-RPB5-TRg-5",
"CC8-SPN1-NRg-2",
"CC8-SPN1-NRg-1",
"CC8-SEC61-NRg-1",
"CC8-SEC61-NRg-7",
"CC8-TUS1-TRg-3",
"CC8-OLE1-NRg-2",
"CC8-AFG2-TRg-1",
"CC8-TOA2-NRg-1",
"CC8-USO1-TRg-1",
"CC8-UTP22-NRg-2",
"CC8-RIB1-TRg-3",
"CC8-RIB1-TRg-7",
"CC8-RIB1-TRg-4",
"CC8-COG1-TRg-1",
"CC8-RPL32-NRg-2",
"CC8-GLC7-NRg-3",
"CC8-GLC7-NRg-4",
"CC8-HSF1-TRg-2",
"CC8-DAM1-NRg-5",
"CC8-SEC18-TRg-4",
"CC8-SEC18-TRg-5",
"CC8-PAB1-NRg-3",
"CC8-POP8-TRg-2",
"CC8-PAB1-NRg-4",
"CC8-BIG1-TRg-4",
"CC8-BIG1-TRg-5",
"CC8-BIG1-TRg-6",
"CC8-RPO41-NRg-1",
"CC8-RVB2-NRg-2",
"CC8-PET117-NRg-8",
"CC8-VPS45-NRg-9",
"CC8-YCG1-NRg-1",
"CC8-NOC4-NRg-1",
"CC8-NMD3-NRg-2",
"CC8-DRS1-TRg-2",
"CC8-HTB1-NRg-2",
"CC8-IPI1-TRg-2",
"CC8-SEC18-NRg-1",
"CC8-SEC18-NRg-2",
"CC8-JIP5-NRg-2",
"CC8-YPT1-TRg-3",
"CC8-YPT1-TRg-2",
"CC8-CLF1-NRg-2",
"CC8-SNF2-NRg-7",
"CC8-SNF2-NRg-4",
"CC8-RPL25-NRg-1",
"CC8-NOP56-TRg-1",
"CC8-NOP56-TRg-2",
"CC8-TRS31-TRg-1",
"CC8-DBF4-TRg-2",
"CC8-DBF4-TRg-1",
"CC8-RPC19-TRg-4",
"CC8-RPC19-TRg-6",
"CC8-RPC19-TRg-3",
"CC8-ROK1-NRg-1",
"CC8-CDC33-TRg-4",
"CC8-DHR2-TRg-3",
"CC8-RRP42-NRg-5",
"CC8-CLF1-TRg-1",
"CC8-ERG11-NA-16",
"CC8-VAS1-NRg-4",
"CC8-PIK1-NRg-2",
"CC8-SAR1-NRg-7",
"CC8-SAR1-NRg-4",
"CC8-RPS3-TRg-1",
"CC8-YTM1-TRg-2",
"CC8-SUI3-NRg-5",
"CC8-SUI3-NRg-2",
"CC8-RRP7-TRg-4",
"CC8-RRP7-TRg-6",
"CC8-NIP7-TRg-2",
"CC8-MDM35-TRg-1",
"CC8-ALA1-NRg-1",
"CC8-DOA4-NRg-2",
"CC8-RPS13-NRg-1",
"CC8-YSF3-TRg-2",
"CC8-RPS2-NRg-11",
"CC8-SSL1-TRg-10",
"CC8-NIP7-TRg-1",
"CC8-LST8-NRg-1",
"CC8-TAF4-TRg-3",
"CC8-HAS1-TRg-2",
"CC8-GLC7-TRg-2",
"CC8-CDC45-NRg-1",
"CC8-SEC22-NRg-8",
"CC8-YOS1-TRg-2",
"CC8-RBA50-TRg-3",
"CC8-SPP41-NRg-2",
"CC8-PRP46-TRg-2",
"CC8-PGA2-NRg-1",
"CC8-CBF5-TRg-3",
"CC8-TCP1-NRg-3",
"CC8-TCP1-NRg-2",
"CC8-ERG26-NRg-2",
"CC8-ERG26-NRg-4",
"CC8-MES1-TRg-5",
"CC8-HTS1-TRg-2",
"CC8-SSS1-TRg-3",
"CC8-SSS1-TRg-2",
"CC8-SYS1-TRg-7",
"CC8-SYS1-TRg-2",
"CC8-SYS1-TRg-1",
"CC8-BFR2-TRg-1",
"CC8-EOS1-TRg-3",
"CC8-TAF4-NRg-1",
"CC8-ARL3-NRg-8",
"CC8-RPN5-NRg-1",
"CC8-TIM9-NRg-2",
"CC8-NUP57-NRg-3",
"CC8-VPS4-TRg-1",
"CC8-CDC3-TRg-4",
"CC8-BBP1-NRg-1",
"CC8-BBP1-NRg-2",
"CC8-USE1-NRg-3",
"CC8-CCT7-TRg-1",
"CC8-SAH1-TRg-3",
"CC8-CHS2-TRg-1",
"CC8-DPM1-TRg-2",
"CC8-BBP1-TRg-1",
"CC8-NRD1-TRg-4",
"CC8-RPB3-NRg-1",
"CC8-PHO85-NRg-6",
"CC8-SNF6-TRg-6",
"CC8-PRP38-NRg-2",
"CC8-OAR1-NRg-3",
"CC8-ROX3-NRg-1",
"CC8-YPP1-TRg-6",
"CC8-CBF2-NRg-8",
"CC8-SPT6-TRg-5",
"CC8-SEC10-NRg-1",
"CC8-NSL1-NRg-3",
"CC8-NRD1-NRg-8",
"CC8-RPB3-TRg-1",
"CC8-NRD1-NRg-4",
"CC8-RVB1-TRg-2",
"CC8-TIF5-NRg-8",
"CC8-EOS1-NRg-1",
"CC8-ERG25-NA-26",
"CC8-MSL5-NRg-4",
"CC8-SEC24-TRg-2",
"CC8-RPL30-NRg-5",
"CC8-SNU71-NRg-3",
"CC8-CDC33-NRg-1",
"CC8-RPN6-TRg-4",
"CC8-NAB2-TRg-4",
"CC8-NAB2-TRg-6",
"CC8-YTM1-NRg-1",
"CC8-OLE1-TRg-8",
"CC8-OLE1-TRg-1",
"CC8-UTP7-TRg-4",
"CC8-ACT1-NRg-6",
"CC8-RPL18A-NRg-3",
"CC8-BRX1-NRg-1",
"CC8-NAF1-TRg-8",
"CC8-NAF1-TRg-6",
"CC8-NAF1-TRg-4",
"CC8-CDC8-TRg-2",
"CC8-NSE4-TRg-1",
"CC8-PAB1-NRg-2",
"CC8-PRP43-TRg-4",
"CC8-SEC2-NRg-3",
"CC8-SEC2-NRg-6",
"CC8-MPP10-NRg-5",
"CC8-YDR355C-TRg-2",
"CC8-YLR339C-TRg-9",
"CC8-SNM1-TRg-2",
"CC8-ALR1-NRg-4",
"CC8-ALR1-NRg-1",
"CC8-ALR1-NRg-3",
"CC8-RPL10-TRg-1",
"CC8-RPL28-TRg-2",
"CC8-UTP25-TRg-1",
"CC8-POB3-TRg-1",
"CC8-POB3-TRg-3",
"CC8-POB3-TRg-2",
"CC8-MED11-TRg-1",
"CC8-ISA1-TRg-15",
"CC8-RRP1-NRg-1",
"CC8-MES1-NRg-1",
"CC8-SEC13-NRg-5",
"CC8-MCM2-NRg-2",
"CC8-ALA1-TRg-4",
"CC8-MTG2-TRg-5",
"CC8-TIF35-NRg-3",
"CC8-NSE1-TRg-3",
"CC8-NSE1-TRg-4",
"CC8-MOB2-NRg-6",
"CC8-VRG4-NRg-3",
"CC8-PRP9-TRg-3",
"CC8-HYM1-TRg-5",
"CC8-POP1-TRg-5",
"CC8-POP1-TRg-9",
"CC8-RPL17A-TRg-1",
"CC8-SLD2-TRg-1",
"CC8-CDC48-NRg-7",
"CC8-FHL1-NRg-2",
"CC8-BET3-NRg-7",
"CC8-MAK21-TRg-1",
"CC8-BRN1-TRg-4",
"CC8-FBA1-NRg-3",
"CC8-CDC42-TRg-6",
"CC8-CDC42-TRg-7",
"CC8-COG4-NRg-1",
"CC8-ATP3-NRg-3",
"CC8-ATP3-NRg-2",
"CC8-SMP3-TRg-5",
"CC8-CFT2-NRg-2",
"CC8-FAS2-TRg-5",
"CC8-DBP2-NRg-3",
"CC8-DBP2-NRg-2",
"CC8-MPS2-NRg-4",
"CC8-ARC35-TRg-2",
"CC8-ARC35-TRg-5",
"CC8-MRD1-TRg-1",
"CC8-RLP7-TRg-1",
"CC8-SPC34-TRg-1",
"CC8-CDC45-TRg-2",
"CC8-GCD6-TRg-3",
"CC8-GCD6-TRg-4",
"CC8-YPT6-NRg-2",
"CC8-RPS13-TRg-2",
"CC8-IPI3-TRg-3",
"CC8-TIF5-NRg-9",
"CC8-TIF5-NRg-7",
"CC8-TIF5-NRg-6",
"CC8-NAB3-TRg-3",
"CC8-GCD2-TRg-1",
"CC8-UBA1-TRg-2",
"CC8-SLD3-TRg-6",
"CC8-LCB1-TRg-5",
"CC8-TOA2-TRg-6",
"CC8-TOA2-TRg-1",
"CC8-TOA2-TRg-3",
"CC8-LSM2-TRg-1",
"CC8-YML6-TRg-13",
"CC8-YML6-TRg-12",
"CC8-UTP15-NRg-1",
"CC8-TIF6-NRg-8",
"CC8-SUP35-NRg-1",
"CC8-MPP10-NRg-1",
"CC8-SWI3-TRg-7",
"CC8-SSN3-NRg-2",
"CC8-SEC13-NRg-7",
"CC8-RPS15-NRg-3",
"CC8-RPL3-TRg-2",
"CC8-FBA1-NRg-2",
"CC8-FBA1-NRg-1",
"CC8-FBA1-NRg-5",
"CC8-DAM1-TRg-2",
"CC8-NHP2-TRg-2",
"CC8-HCA4-NRg-6",
"CC8-PRE3-TRg-4",
"CC8-DBP5-NRg-4",
"CC8-SPT6-NRg-4",
"CC8-SPT6-NRg-2",
"CC8-RPL18A-TRg-4",
"CC8-KSH1-TRg-1",
"CC8-KSH1-TRg-3",
"CC8-IPI3-NRg-1",
"CC8-PGA2-TRg-8",
"CC8-RPL18A-TRg-2",
"CC8-RPL33A-NRg-6",
"CC8-TAF12-NRg-2",
"CC8-USE1-TRg-5",
"CC8-YNL114C-TRg-1",
"CC8-SMC5-TRg-7",
"CC8-SMC5-TRg-6",
"CC8-RSC58-TRg-1",
"CC8-CTF13-TRg-2",
"CC8-NAB2-NRg-2",
"CC8-MCM7-TRg-4",
"CC8-BCP1-NRg-5",
"CC8-STU2-TRg-3",
"CC8-SEC21-NRg-6",
"CC8-SEC21-NRg-3",
"CC8-RPL1B-TRg-3",
"CC8-SEC20-NRg-2",
"CC8-VMA3-NRg-2",
"CC8-SEC23-NRg-5",
"CC8-CDC28-TRg-4",
"CC8-RPN12-NRg-11",
"CC8-PUP3-TRg-3",
"CC8-SEC31-TRg-2",
"CC8-SED5-TRg-6",
"CC8-SED5-TRg-5",
"CC8-RPL33A-TRg-1",
"CC8-RPL33A-TRg-2",
"CC8-MRPL11-TRg-2",
"CC8-RTP1-NRg-2",
"CC8-NUG1-TRg-2",
"CC8-VPH2-TRg-4",
"CC8-COP1-NRg-3",
"CC8-CRM1-NRg-1",
"CC8-RPL5-NRg-4",
"CC8-SNU13-NRg-4",
"CC8-PFS2-TRg-3",
"CC8-MPP10-TRg-2",
"CC8-TSR4-NRg-2",
"CC8-RSC2-TRg-1",
"CC8-SEC65-TRg-2",
"CC8-SMI1-NRg-1",
"CC8-RTT105-NRg-4",
"CC8-VMA5-TRg-3",
"CC8-VMA5-TRg-5",
"CC8-RRP1-TRg-3",
"CC8-CLC1-TRg-2",
"CC8-GCD6-NRg-1",
"CC8-GCD6-NRg-2",
"CC8-PXR1-TRg-1",
"CC8-CDC14-NRg-1",
"CC8-PCF11-TRg-6",
"CC8-PCF11-TRg-5",
"CC8-PCF11-TRg-4",
"CC8-SEC31-NRg-1",
"CC8-RRP5-NRg-1",
"CC8-PRE10-TRg-5",
"CC8-PRE10-TRg-1",
"CC8-RPS5-TRg-2",
"CC8-NSP1-TRg-4",
"CC8-PRP38-TRg-4",
"CC8-RCF1-NRg-5",
"CC8-RSC3-TRg-4",
"CC8-RSC3-TRg-5",
"CC8-RSC3-TRg-6",
"CC8-HTA1-NRg-12",
"CC8-HTA1-NRg-11",
"CC8-UTP23-TRg-2",
"CC8-GCD7-NRg-1",
"CC8-GCD7-NRg-2",
"CC8-GCD7-NRg-6",
"CC8-GAL11-NRg-2",
"CC8-GAL11-NRg-9",
"CC8-PHO4-TRg-5",
"CC8-SNP1-NRg-3",
"CC8-RPC37-TRg-5",
"CC8-CRM1-TRg-5",
"CC8-CRM1-TRg-2",
"CC8-ASK1-TRg-7",
"CC8-STU2-NRg-4",
"CC8-NEO1-NRg-3",
"CC8-GAL11-TRg-5",
"CC8-GAL11-TRg-7",
"CC8-SAM50-NRg-3",
"CC8-CSL4-TRg-2",
"CC8-CCT5-TRg-2",
"CC8-POL30-NRg-1",
"CC8-MED4-TRg-4",
"CC8-MED4-TRg-3",
"CC8-MED4-TRg-2",
"CC8-GDI1-TRg-4",
"CC8-GDI1-TRg-3",
"CC8-REB1-TRg-6",
"CC8-MRPL37-NRg-2",
"CC8-NOC3-TRg-3",
"CC8-SPC97-TRg-3",
"CC8-IPP1-TRg-3",
"CC8-IPP1-TRg-2",
"CC8-PTI1-TRg-3",
"CC8-PTI1-TRg-5",
"CC8-RFC5-NRg-1",
"CC8-CDC24-TRg-1",
"CC8-CDC24-TRg-3",
"CC8-CDC24-TRg-5",
"CC8-CDC24-TRg-6",
"CC8-UTP23-TRg-6",
"CC8-UTP23-TRg-4",
"CC8-UTP23-TRg-1",
"CC8-RHO3-NRg-4",
"CC8-TRS23-NRg-1",
"CC8-TRS23-NRg-3",
"CC8-RSP5-TRg-2",
"CC8-RSP5-TRg-1",
"CC8-SDA1-NRg-1",
"CC8-KAP95-TRg-8",
"CC8-ACO1-TRg-6",
"CC8-HTA1-NRg-3",
"CC8-HTA1-NRg-2",
"CC8-SPN1-TRg-1",
"CC8-MOT1-NRg-7",
"CC8-RPL17A-NRg-4",
"CC8-ADA2-TRg-4",
"CC8-SFH1-NRg-1",
"CC8-SPC97-NRg-5",
"CC8-PRP22-TRg-3",
"CC8-SEN15-TRg-2",
"CC8-RPL3-NRg-2",
"CC8-ISD11-NRg-2",
"CC8-HEM12-TRg-8",
"CC8-SEC10-TRg-1",
"CC8-HTB1-TRg-7",
"CC8-TTI2-TRg-1",
"CC8-ACP1-TRg-2",
"CC8-ACP1-TRg-4",
"CC8-GAL11-NRg-10",
"CC8-UTP22-TRg-2",
"CC8-MST1-NRg-5",
"CC8-RIB7-NRg-2",
"CC8-MCD1-TRg-6",
"CC8-MCD1-TRg-5",
"CC8-GPI8-NRg-2",
"CC8-THS1-TRg-2",
"CC8-RRP7-TRg-2",
"CC8-RRP7-TRg-5",
"CC8-SMX2-NRg-7",
"CC8-RRP45-TRg-5",
"CC8-RRP45-TRg-4",
"CC8-CNS1-TRg-2",
"CC8-FBP1-NRg-9",
"CC8-GCD11-NRg-1",
"CC8-RPL10-TRg-2",
"CC8-NUP192-TRg-4",
"CC8-NUP145-NRg-4",
"CC8-HEM12-TRg-6",
"CC8-PLC1-TRg-3",
"CC8-RPA43-TRg-1",
"CC8-RPB7-NRg-2",
"CC8-RPB7-NRg-3",
"CC8-NSL1-NRg-1",
"CC8-UTP6-TRg-3",
"CC8-UTP6-TRg-1",
"CC8-YJU2-TRg-5",
"CC8-FRS2-NRg-5",
"CC8-TIF35-NRg-2",
"CC8-GPI15-TRg-1",
"CC8-NOP1-NRg-5",
"CC8-GPI15-TRg-4",
"CC8-COG4-TRg-1",
"CC8-TFA1-TRg-1",
"CC8-RHO1-NRg-2",
"CC8-RHO1-NRg-1",
"CC8-CDC55-NRg-2",
"CC8-IDI1-NRg-7",
"CC8-RPL32-TRg-5",
"CC8-RPB5-TRg-4",
"CC8-DIP2-TRg-5",
"CC8-DIP2-TRg-1",
"CC8-RPC40-TRg-2",
"CC8-CDC6-TRg-5",
"CC8-CDC6-TRg-3",
"CC8-DAD2-TRg-2",
"CC8-RVS161-TRg-2",
"CC8-RVS161-TRg-1",
"CC8-SUP45-NRg-3",
"CC8-SRB6-NRg-5",
"CC8-RPC11-TRg-4",
"CC8-RKI1-TRg-8",
"CC8-NIP7-TRg-3",
"CC8-RPL33A-NRg-12",
"CC8-SAM50-TRg-4",
"CC8-NOP4-NRg-1",
"CC8-NOP4-NRg-3",
"CC8-SMX2-TRg-5",
"CC8-POL12-NRg-2",
"CC8-BMS1-NRg-2",
"CC8-RPA190-TRg-5",
"CC8-ALG14-NRg-4",
"CC8-ALG14-NRg-1",
"CC8-PRE5-NRg-1",
"CC8-BIG1-NRg-2",
"CC8-TFA2-TRg-4",
"CC8-IMP4-TRg-6",
"CC8-PAN1-NRg-1",
"CC8-UTP13-TRg-2",
"CC8-KAE1-NRg-3",
"CC8-ERG20-TRg-1",
"CC8-CDC20-TRg-6",
"CC8-PWP2-NRg-2",
"CC8-COG1-NRg-1",
"CC8-RPL1B-TRg-4",
"CC8-RPL1B-TRg-7",
"CC8-UTP20-TRg-3",
"CC8-UTP20-TRg-4",
"CC8-RPL25-TRg-4",
"CC8-RPL25-TRg-2",
"CC8-MCM7-NRg-1",
"CC8-MRP49-TRg-5",
"CC8-ERO1-NRg-3",
"CC8-UTP5-TRg-7",
"CC8-MCM4-NRg-1",
"CC8-PRE3-NRg-1",
"CC8-FCF1-NRg-1",
"CC8-CUS1-NRg-1",
"CC8-PSF1-TRg-2",
"CC8-BCP1-TRg-2",
"CC8-PAN1-TRg-1",
"CC8-PAN1-TRg-3",
"CC8-PAN1-TRg-4",
"CC8-VPS3-TRg-2",
"CC8-YIL060W-NRg-1",
"CC8-VPS53-NRg-1",
"CC8-CYR1-TRg-4",
"CC8-CYR1-TRg-7",
"CC8-MPS1-NRg-1",
"CC8-SRP1-TRg-5",
"CC8-SRP1-TRg-4",
"CC8-TAF12-TRg-2",
"CC8-TAF12-TRg-3",
"CC8-POP4-TRg-1",
"CC8-SPT16-TRg-1",
"CC8-NUP82-TRg-4",
"CC8-DML1-TRg-3",
"CC8-RPA43-NRg-3",
"CC8-STU2-NRg-3",
"CC8-POP4-NRg-4",
"CC8-MCD1-TRg-2",
"CC8-RPS3-NRg-4",
"CC8-PRP9-TRg-4",
"CC8-RPP1-NRg-2",
"CC8-MTR2-NRg-11",
"CC8-GCD11-TRg-1",
"CC8-RPF1-TRg-3",
"CC8-SUB2-NRg-4",
"CC8-GPI15-TRg-3",
"CC8-ERG9-TRg-6",
"CC8-RPT2-NRg-1",
"CC8-YOS1-NRg-3",
"CC8-SCM3-TRg-4",
"CC8-SCM3-TRg-6",
"CC8-RLP7-NRg-1",
"CC8-TFB2-NRg-4",
"CC8-IMP4-TRg-1",
"CC8-IMP4-TRg-3",
"CC8-PRE4-TRg-3",
"CC8-SUB2-TRg-3",
"CC8-RPP0-NRg-4",
"CC8-RPP0-NRg-3",
"CC8-TOM40-TRg-4",
"CC8-FUR1-NRg-12",
"CC8-TOM40-TRg-2",
"CC8-VMA11-NRg-4",
"CC8-PGS1-NRg-4",
"CC8-URB1-TRg-4",
"CC8-ARP4-TRg-3",
"CC8-RPT3-TRg-3",
"CC8-SUI3-TRg-3",
"CC8-RFC5-NRg-2",
"CC8-RRP14-TRg-2",
"CC8-SCC2-TRg-1",
"CC8-SSC1-TRg-3",
"CC8-RRP9-TRg-3",
"CC8-MOT1-NRg-9",
"CC8-RPL42A-NRg-2",
"CC8-SEC16-TRg-7",
"CC8-IMP4-NRg-2",
"CC8-YEF3-NRg-4",
"CC8-PUP1-TRg-1",
"CC8-UTP22-TRg-6",
"CC8-DBP2-NRg-4",
"CC8-PRE2-TRg-7",
"CC8-ATP16-TRg-6",
"CC8-UTP13-TRg-4",
"CC8-DOP1-NRg-4",
"CC8-TIM44-TRg-3",
"CC8-ATP16-TRg-2",
"CC8-ENP1-NRg-3",
"CC8-NAF1-TRg-3",
"CC8-COG4-TRg-2",
"CC8-SOG2-TRg-7",
"CC8-YDR341C-TRg-3",
"CC8-YMR290W-A-TRg-10",
"CC8-NUP192-NRg-9",
"CC8-RPS31-NRg-8",
"CC8-SPC97-NRg-6",
"CC8-EBP2-NRg-1",
"CC8-CDC48-TRg-5",
"CC8-RPT1-TRg-4",
"CC8-ULP1-NRg-2",
"CC8-RPN3-TRg-6",
"CC8-RPT1-TRg-5",
"CC8-KRE5-TRg-2",
"CC8-TBF1-NRg-8",
"CC8-UTP22-NRg-4",
"CC8-SSC1-NRg-4",
"CC8-REB1-TRg-4",
"CC8-CDC48-NRg-9",
"CC8-FAS2-TRg-8",
"CC8-TAO3-TRg-8",
"CC8-CKS1-TRg-5",
"CC8-YLR379W-TRg-7",
"CC8-TEN1-NRg-2",
"CC8-RPL42A-TRg-2",
"CC8-SEC27-TRg-4",
"CC8-TBF1-NRg-4",
"CC8-RPT1-NRg-6",
"CC8-COG1-TRg-3",
"CC8-SUI1-TRg-6",
"CC8-TIM23-TRg-6",
"CC8-CDC48-NRg-6",
"CC8-EPL1-TRg-5",
"CC8-RPT5-TRg-8",
"CC8-ATP16-NRg-4",
"CC8-RPN6-TRg-3",
"CC8-ERG9-NRg-6",
"CC8-SMX3-TRg-1",
"CC8-NCB2-NRg-3",
"CC8-SEC16-NRg-12",
"CC8-RPN6-TRg-2",
"CC8-REB1-NRg-4",
"CC8-ATP16-TRg-9",
"CC8-ERG9-NRg-7",
"CC16-RPL15A-NRg-4",
"CC16-RPL15A-NRg-5",
"CC16-KRE33-TRg-1",
"CC16-PMI40-NRg-1",
"CC16-NOP19-NRg-3",
"CC16-SRP14-NRg-4",
"CC16-SEC27-TRg-2",
"CC16-GPI14-TRg-3",
"CC16-PAH1-TRg-7",
"CC16-PAH1-TRg-6",
"CC16-PAH1-TRg-5",
"CC16-PAH1-TRg-3",
"CC16-COG3-TRg-1",
"CC16-HTS1-NRg-5",
"CC16-MSN5-TRg-7",
"CC16-ERG26-TRg-1",
"CC16-SMD2-TRg-5",
"CC16-SMD2-TRg-4",
"CC16-SMD2-TRg-1",
"CC16-PRE7-TRg-4",
"CC16-PRE7-TRg-7",
"CC16-SEC6-TRg-3",
"CC16-ESF2-NRg-1",
"CC16-ESF2-NRg-3",
"CC16-AFG2-TRg-2",
"CC16-RRP36-TRg-3",
"CC16-RRP36-TRg-5",
"CC16-GCR1-NRg-2",
"CC16-PRE4-NRg-4",
"CC16-PRE4-NRg-9",
"CC16-DSN1-NRg-2",
"CC16-GPI11-TRg-3",
"CC16-POP3-TRg-1",
"CC16-MNE1-TRg-5",
"CC16-RRP12-NRg-1",
"CC16-RSC6-TRg-2",
"CC16-CDC25-TRg-1",
"CC16-CDC25-TRg-9",
"CC16-YPP1-NRg-3",
"CC16-NFS1-NRg-9",
"CC16-NFS1-NRg-8",
"CC16-UBA2-TRg-1",
"CC16-ARP2-NRg-3",
"CC16-MAK16-TRg-1",
"CC16-CEP3-NRg-1",
"CC16-GUK1-TRg-5",
"CC16-GUK1-TRg-2",
"CC16-GPI12-NRg-6",
"CC16-RPS5-NRg-5",
"CC16-RPS5-NRg-2",
"CC16-RPC19-NRg-1",
"CC16-TIM54-TRg-1",
"CC16-TEN1-TRg-2",
"CC16-SAH1-NRg-4",
"CC16-SAH1-NRg-5",
"CC16-SAH1-NRg-3",
"CC16-ATP15-NRg-5",
"CC16-SCD5-TRg-5",
"CC16-ARB1-NRg-2",
"CC16-ARB1-NRg-4",
"CC16-PUP2-TRg-1",
"CC16-CCT8-TRg-2",
"CC16-MCM4-TRg-1",
"CC16-LSM4-TRg-1",
"CC16-NOP53-NRg-1",
"CC16-ATP3-TRg-4",
"CC16-AFG2-NRg-3",
"CC16-PRO3-NRg-3",
"CC16-NRD1-NRg-10",
"CC16-SEC61-TRg-2",
"CC16-RHO3-TRg-4",
"CC16-SNF2-TRg-6",
"CC16-SMD2-NRg-3",
"CC16-RSC4-TRg-2",
"CC16-RSC4-TRg-1",
"CC16-TIF34-TRg-2",
"CC16-BET1-NRg-1",
"CC16-CDC8-NRg-2",
"CC16-PRP42-TRg-2",
"CC16-RRB1-TRg-2",
"CC16-SPC24-TRg-1",
"CC16-ILS1-NRg-1",
"CC16-GFA1-TRg-2",
"CC16-SEC21-NRg-10",
"CC16-RPC10-NRg-1",
"CC16-RPB10-TRg-3",
"CC16-RPB10-TRg-2",
"CC16-YNL181W-TRg-1",
"CC16-RAD3-NRg-1",
"CC16-NOP10-TRg-1",
"CC16-BFR2-TRg-3",
"CC16-MCM2-TRg-6",
"CC16-MCM2-TRg-4",
"CC16-MPP10-TRg-1",
"CC16-RET2-TRg-4",
"CC16-RET2-TRg-1",
"CC16-RPS2-NRg-1",
"CC16-RPS2-NRg-2",
"CC16-ORC4-NRg-3",
"CC16-TIP20-TRg-7",
"CC16-SMT3-TRg-1",
"CC16-MSS18-NRg-6",
"CC16-YEF3-NRg-9",
"CC16-ASK1-NRg-1",
"CC16-SMC1-TRg-1",
"CC16-NIP1-NRg-1",
"CC16-RPP1-NRg-1",
"CC16-YDJ1-TRg-6",
"CC16-SUB2-NRg-1",
"CC16-TIM10-NRg-8",
"CC16-TIM10-NRg-4",
"CC16-TIM10-NRg-7",
"CC16-SKI6-TRg-4",
"CC16-TUB4-TRg-1",
"CC16-CDC37-NRg-2",
"CC16-ISD11-TRg-3",
"CC16-YOS1-TRg-4",
"CC16-SSC1-TRg-6",
"CC16-MTR3-TRg-5",
"CC16-MTR3-TRg-6",
"CC16-TFA1-TRg-2",
"CC16-CDC3-NRg-3",
"CC16-ERG25-TA-18",
"CC16-RPB11-TRg-4",
"CC16-RPB11-TRg-1",
"CC16-RPB11-TRg-2",
"CC16-DED1-TRg-3",
"CC16-DED1-TRg-1",
"CC16-DED1-TRg-6",
"CC16-DED1-TRg-4",
"CC16-RPL10-NRg-5",
"CC16-RPL10-NRg-4",
"CC16-EFB1-NRg-1",
"CC16-EFB1-NRg-5",
"CC16-EFB1-NRg-4",
"CC16-RPT3-NRg-1",
"CC16-SAC6-TRg-8",
"CC16-SAC6-TRg-4",
"CC16-SAC6-TRg-5",
"CC16-SAC6-TRg-3",
"CC16-DIM1-TRg-5",
"CC16-DIM1-TRg-7",
"CC16-RPC17-NRg-1",
"CC16-RPC17-NRg-2",
"CC16-YDR341C-TRg-1",
"CC16-RAP1-NRg-8",
"CC16-RAP1-NRg-5",
"CC16-RAP1-NRg-2",
"CC16-SEC26-NRg-3",
"CC16-SPP41-TRg-3",
"CC16-TAP42-NRg-1",
"CC16-PGA2-TRg-6",
"CC16-BRL1-TRg-1",
"CC16-FOL2-TRg-1",
"CC16-NAB3-NRg-5",
"CC16-SNF4-TRg-4",
"CC16-HRR25-TRg-2",
"CC16-TRS23-TRg-4",
"CC16-CTR86-TRg-4",
"CC16-RPB5-TRg-5",
"CC16-SPN1-NRg-2",
"CC16-SPN1-NRg-1",
"CC16-SEC61-NRg-1",
"CC16-SEC61-NRg-7",
"CC16-TUS1-TRg-3",
"CC16-OLE1-NRg-2",
"CC16-AFG2-TRg-1",
"CC16-TOA2-NRg-1",
"CC16-USO1-TRg-1",
"CC16-UTP22-NRg-2",
"CC16-RIB1-TRg-3",
"CC16-RIB1-TRg-7",
"CC16-RIB1-TRg-4",
"CC16-COG1-TRg-1",
"CC16-RPL32-NRg-2",
"CC16-GLC7-NRg-3",
"CC16-GLC7-NRg-4",
"CC16-HSF1-TRg-2",
"CC16-DAM1-NRg-5",
"CC16-SEC18-TRg-4",
"CC16-SEC18-TRg-5",
"CC16-PAB1-NRg-3",
"CC16-POP8-TRg-2",
"CC16-PAB1-NRg-4",
"CC16-BIG1-TRg-4",
"CC16-BIG1-TRg-5",
"CC16-BIG1-TRg-6",
"CC16-RPO41-NRg-1",
"CC16-RVB2-NRg-2",
"CC16-PET117-NRg-8",
"CC16-VPS45-NRg-9",
"CC16-YCG1-NRg-1",
"CC16-NOC4-NRg-1",
"CC16-NMD3-NRg-2",
"CC16-DRS1-TRg-2",
"CC16-HTB1-NRg-2",
"CC16-IPI1-TRg-2",
"CC16-SEC18-NRg-1",
"CC16-SEC18-NRg-2",
"CC16-JIP5-NRg-2",
"CC16-YPT1-TRg-3",
"CC16-YPT1-TRg-2",
"CC16-CLF1-NRg-2",
"CC16-SNF2-NRg-7",
"CC16-SNF2-NRg-4",
"CC16-RPL25-NRg-1",
"CC16-NOP56-TRg-1",
"CC16-NOP56-TRg-2",
"CC16-TRS31-TRg-1",
"CC16-DBF4-TRg-2",
"CC16-DBF4-TRg-1",
"CC16-RPC19-TRg-4",
"CC16-RPC19-TRg-6",
"CC16-RPC19-TRg-3",
"CC16-ROK1-NRg-1",
"CC16-CDC33-TRg-4",
"CC16-DHR2-TRg-3",
"CC16-RRP42-NRg-5",
"CC16-CLF1-TRg-1",
"CC16-ERG11-NA-16",
"CC16-VAS1-NRg-4",
"CC16-PIK1-NRg-2",
"CC16-SAR1-NRg-7",
"CC16-SAR1-NRg-4",
"CC16-RPS3-TRg-1",
"CC16-YTM1-TRg-2",
"CC16-SUI3-NRg-5",
"CC16-SUI3-NRg-2",
"CC16-RRP7-TRg-4",
"CC16-RRP7-TRg-6",
"CC16-NIP7-TRg-2",
"CC16-MDM35-TRg-1",
"CC16-ALA1-NRg-1",
"CC16-DOA4-NRg-2",
"CC16-RPS13-NRg-1",
"CC16-YSF3-TRg-2",
"CC16-RPS2-NRg-11",
"CC16-SSL1-TRg-10",
"CC16-NIP7-TRg-1",
"CC16-LST8-NRg-1",
"CC16-TAF4-TRg-3",
"CC16-HAS1-TRg-2",
"CC16-GLC7-TRg-2",
"CC16-CDC45-NRg-1",
"CC16-SEC22-NRg-8",
"CC16-YOS1-TRg-2",
"CC16-RBA50-TRg-3",
"CC16-SPP41-NRg-2",
"CC16-PRP46-TRg-2",
"CC16-PGA2-NRg-1",
"CC16-CBF5-TRg-3",
"CC16-TCP1-NRg-3",
"CC16-TCP1-NRg-2",
"CC16-ERG26-NRg-2",
"CC16-ERG26-NRg-4",
"CC16-MES1-TRg-5",
"CC16-HTS1-TRg-2",
"CC16-SSS1-TRg-3",
"CC16-SSS1-TRg-2",
"CC16-SYS1-TRg-7",
"CC16-SYS1-TRg-2",
"CC16-SYS1-TRg-1",
"CC16-BFR2-TRg-1",
"CC16-EOS1-TRg-3",
"CC16-TAF4-NRg-1",
"CC16-ARL3-NRg-8",
"CC16-RPN5-NRg-1",
"CC16-TIM9-NRg-2",
"CC16-NUP57-NRg-3",
"CC16-VPS4-TRg-1",
"CC16-CDC3-TRg-4",
"CC16-BBP1-NRg-1",
"CC16-BBP1-NRg-2",
"CC16-USE1-NRg-3",
"CC16-CCT7-TRg-1",
"CC16-SAH1-TRg-3",
"CC16-CHS2-TRg-1",
"CC16-DPM1-TRg-2",
"CC16-BBP1-TRg-1",
"CC16-NRD1-TRg-4",
"CC16-RPB3-NRg-1",
"CC16-PHO85-NRg-6",
"CC16-SNF6-TRg-6",
"CC16-PRP38-NRg-2",
"CC16-OAR1-NRg-3",
"CC16-ROX3-NRg-1",
"CC16-YPP1-TRg-6",
"CC16-CBF2-NRg-8",
"CC16-SPT6-TRg-5",
"CC16-SEC10-NRg-1",
"CC16-NSL1-NRg-3",
"CC16-NRD1-NRg-8",
"CC16-RPB3-TRg-1",
"CC16-NRD1-NRg-4",
"CC16-RVB1-TRg-2",
"CC16-TIF5-NRg-8",
"CC16-EOS1-NRg-1",
"CC16-ERG25-NA-26",
"CC16-MSL5-NRg-4",
"CC16-SEC24-TRg-2",
"CC16-RPL30-NRg-5",
"CC16-SNU71-NRg-3",
"CC16-CDC33-NRg-1",
"CC16-RPN6-TRg-4",
"CC16-NAB2-TRg-4",
"CC16-NAB2-TRg-6",
"CC16-YTM1-NRg-1",
"CC16-OLE1-TRg-8",
"CC16-OLE1-TRg-1",
"CC16-UTP7-TRg-4",
"CC16-ACT1-NRg-6",
"CC16-RPL18A-NRg-3",
"CC16-BRX1-NRg-1",
"CC16-NAF1-TRg-8",
"CC16-NAF1-TRg-6",
"CC16-NAF1-TRg-4",
"CC16-CDC8-TRg-2",
"CC16-NSE4-TRg-1",
"CC16-PAB1-NRg-2",
"CC16-PRP43-TRg-4",
"CC16-SEC2-NRg-3",
"CC16-SEC2-NRg-6",
"CC16-MPP10-NRg-5",
"CC16-YDR355C-TRg-2",
"CC16-YLR339C-TRg-9",
"CC16-SNM1-TRg-2",
"CC16-ALR1-NRg-4",
"CC16-ALR1-NRg-1",
"CC16-ALR1-NRg-3",
"CC16-RPL10-TRg-1",
"CC16-RPL28-TRg-2",
"CC16-UTP25-TRg-1",
"CC16-POB3-TRg-1",
"CC16-POB3-TRg-3",
"CC16-POB3-TRg-2",
"CC16-MED11-TRg-1",
"CC16-ISA1-TRg-15",
"CC16-RRP1-NRg-1",
"CC16-MES1-NRg-1",
"CC16-SEC13-NRg-5",
"CC16-MCM2-NRg-2",
"CC16-ALA1-TRg-4",
"CC16-MTG2-TRg-5",
"CC16-TIF35-NRg-3",
"CC16-NSE1-TRg-3",
"CC16-NSE1-TRg-4",
"CC16-MOB2-NRg-6",
"CC16-VRG4-NRg-3",
"CC16-PRP9-TRg-3",
"CC16-HYM1-TRg-5",
"CC16-POP1-TRg-5",
"CC16-POP1-TRg-9",
"CC16-RPL17A-TRg-1",
"CC16-SLD2-TRg-1",
"CC16-CDC48-NRg-7",
"CC16-FHL1-NRg-2",
"CC16-BET3-NRg-7",
"CC16-MAK21-TRg-1",
"CC16-BRN1-TRg-4",
"CC16-FBA1-NRg-3",
"CC16-CDC42-TRg-6",
"CC16-CDC42-TRg-7",
"CC16-COG4-NRg-1",
"CC16-ATP3-NRg-3",
"CC16-ATP3-NRg-2",
"CC16-SMP3-TRg-5",
"CC16-CFT2-NRg-2",
"CC16-FAS2-TRg-5",
"CC16-DBP2-NRg-3",
"CC16-DBP2-NRg-2",
"CC16-MPS2-NRg-4",
"CC16-ARC35-TRg-2",
"CC16-ARC35-TRg-5",
"CC16-MRD1-TRg-1",
"CC16-RLP7-TRg-1",
"CC16-SPC34-TRg-1",
"CC16-CDC45-TRg-2",
"CC16-GCD6-TRg-3",
"CC16-GCD6-TRg-4",
"CC16-YPT6-NRg-2",
"CC16-RPS13-TRg-2",
"CC16-IPI3-TRg-3",
"CC16-TIF5-NRg-9",
"CC16-TIF5-NRg-7",
"CC16-TIF5-NRg-6",
"CC16-NAB3-TRg-3",
"CC16-GCD2-TRg-1",
"CC16-UBA1-TRg-2",
"CC16-SLD3-TRg-6",
"CC16-LCB1-TRg-5",
"CC16-TOA2-TRg-6",
"CC16-TOA2-TRg-1",
"CC16-TOA2-TRg-3",
"CC16-LSM2-TRg-1",
"CC16-YML6-TRg-13",
"CC16-YML6-TRg-12",
"CC16-UTP15-NRg-1",
"CC16-TIF6-NRg-8",
"CC16-SUP35-NRg-1",
"CC16-MPP10-NRg-1",
"CC16-SWI3-TRg-7",
"CC16-SSN3-NRg-2",
"CC16-SEC13-NRg-7",
"CC16-RPS15-NRg-3",
"CC16-RPL3-TRg-2",
"CC16-FBA1-NRg-2",
"CC16-FBA1-NRg-1",
"CC16-FBA1-NRg-5",
"CC16-DAM1-TRg-2",
"CC16-NHP2-TRg-2",
"CC16-HCA4-NRg-6",
"CC16-PRE3-TRg-4",
"CC16-DBP5-NRg-4",
"CC16-SPT6-NRg-4",
"CC16-SPT6-NRg-2",
"CC16-RPL18A-TRg-4",
"CC16-KSH1-TRg-1",
"CC16-KSH1-TRg-3",
"CC16-IPI3-NRg-1",
"CC16-PGA2-TRg-8",
"CC16-RPL18A-TRg-2",
"CC16-RPL33A-NRg-6",
"CC16-TAF12-NRg-2",
"CC16-USE1-TRg-5",
"CC16-YNL114C-TRg-1",
"CC16-SMC5-TRg-7",
"CC16-SMC5-TRg-6",
"CC16-RSC58-TRg-1",
"CC16-CTF13-TRg-2",
"CC16-NAB2-NRg-2",
"CC16-MCM7-TRg-4",
"CC16-BCP1-NRg-5",
"CC16-STU2-TRg-3",
"CC16-SEC21-NRg-6",
"CC16-SEC21-NRg-3",
"CC16-RPL1B-TRg-3",
"CC16-SEC20-NRg-2",
"CC16-VMA3-NRg-2",
"CC16-SEC23-NRg-5",
"CC16-CDC28-TRg-4",
"CC16-RPN12-NRg-11",
"CC16-PUP3-TRg-3",
"CC16-SEC31-TRg-2",
"CC16-SED5-TRg-6",
"CC16-SED5-TRg-5",
"CC16-RPL33A-TRg-1",
"CC16-RPL33A-TRg-2",
"CC16-MRPL11-TRg-2",
"CC16-RTP1-NRg-2",
"CC16-NUG1-TRg-2",
"CC16-VPH2-TRg-4",
"CC16-COP1-NRg-3",
"CC16-CRM1-NRg-1",
"CC16-RPL5-NRg-4",
"CC16-SNU13-NRg-4",
"CC16-PFS2-TRg-3",
"CC16-MPP10-TRg-2",
"CC16-TSR4-NRg-2",
"CC16-RSC2-TRg-1",
"CC16-SEC65-TRg-2",
"CC16-SMI1-NRg-1",
"CC16-RTT105-NRg-4",
"CC16-VMA5-TRg-3",
"CC16-VMA5-TRg-5",
"CC16-RRP1-TRg-3",
"CC16-CLC1-TRg-2",
"CC16-GCD6-NRg-1",
"CC16-GCD6-NRg-2",
"CC16-PXR1-TRg-1",
"CC16-CDC14-NRg-1",
"CC16-PCF11-TRg-6",
"CC16-PCF11-TRg-5",
"CC16-PCF11-TRg-4",
"CC16-SEC31-NRg-1",
"CC16-RRP5-NRg-1",
"CC16-PRE10-TRg-5",
"CC16-PRE10-TRg-1",
"CC16-RPS5-TRg-2",
"CC16-NSP1-TRg-4",
"CC16-PRP38-TRg-4",
"CC16-RCF1-NRg-5",
"CC16-RSC3-TRg-4",
"CC16-RSC3-TRg-5",
"CC16-RSC3-TRg-6",
"CC16-HTA1-NRg-12",
"CC16-HTA1-NRg-11",
"CC16-UTP23-TRg-2",
"CC16-GCD7-NRg-1",
"CC16-GCD7-NRg-2",
"CC16-GCD7-NRg-6",
"CC16-GAL11-NRg-2",
"CC16-GAL11-NRg-9",
"CC16-PHO4-TRg-5",
"CC16-SNP1-NRg-3",
"CC16-RPC37-TRg-5",
"CC16-CRM1-TRg-5",
"CC16-CRM1-TRg-2",
"CC16-ASK1-TRg-7",
"CC16-STU2-NRg-4",
"CC16-NEO1-NRg-3",
"CC16-GAL11-TRg-5",
"CC16-GAL11-TRg-7",
"CC16-SAM50-NRg-3",
"CC16-CSL4-TRg-2",
"CC16-CCT5-TRg-2",
"CC16-POL30-NRg-1",
"CC16-MED4-TRg-4",
"CC16-MED4-TRg-3",
"CC16-MED4-TRg-2",
"CC16-GDI1-TRg-4",
"CC16-GDI1-TRg-3",
"CC16-REB1-TRg-6",
"CC16-MRPL37-NRg-2",
"CC16-NOC3-TRg-3",
"CC16-SPC97-TRg-3",
"CC16-IPP1-TRg-3",
"CC16-IPP1-TRg-2",
"CC16-PTI1-TRg-3",
"CC16-PTI1-TRg-5",
"CC16-RFC5-NRg-1",
"CC16-CDC24-TRg-1",
"CC16-CDC24-TRg-3",
"CC16-CDC24-TRg-5",
"CC16-CDC24-TRg-6",
"CC16-UTP23-TRg-6",
"CC16-UTP23-TRg-4",
"CC16-UTP23-TRg-1",
"CC16-RHO3-NRg-4",
"CC16-TRS23-NRg-1",
"CC16-TRS23-NRg-3",
"CC16-RSP5-TRg-2",
"CC16-RSP5-TRg-1",
"CC16-SDA1-NRg-1",
"CC16-KAP95-TRg-8",
"CC16-ACO1-TRg-6",
"CC16-HTA1-NRg-3",
"CC16-HTA1-NRg-2",
"CC16-SPN1-TRg-1",
"CC16-MOT1-NRg-7",
"CC16-RPL17A-NRg-4",
"CC16-ADA2-TRg-4",
"CC16-SFH1-NRg-1",
"CC16-SPC97-NRg-5",
"CC16-PRP22-TRg-3",
"CC16-SEN15-TRg-2",
"CC16-RPL3-NRg-2",
"CC16-ISD11-NRg-2",
"CC16-HEM12-TRg-8",
"CC16-SEC10-TRg-1",
"CC16-HTB1-TRg-7",
"CC16-TTI2-TRg-1",
"CC16-ACP1-TRg-2",
"CC16-ACP1-TRg-4",
"CC16-GAL11-NRg-10",
"CC16-UTP22-TRg-2",
"CC16-MST1-NRg-5",
"CC16-RIB7-NRg-2",
"CC16-MCD1-TRg-6",
"CC16-MCD1-TRg-5",
"CC16-GPI8-NRg-2",
"CC16-THS1-TRg-2",
"CC16-RRP7-TRg-2",
"CC16-RRP7-TRg-5",
"CC16-SMX2-NRg-7",
"CC16-RRP45-TRg-5",
"CC16-RRP45-TRg-4",
"CC16-CNS1-TRg-2",
"CC16-FBP1-NRg-9",
"CC16-GCD11-NRg-1",
"CC16-RPL10-TRg-2",
"CC16-NUP192-TRg-4",
"CC16-NUP145-NRg-4",
"CC16-HEM12-TRg-6",
"CC16-PLC1-TRg-3",
"CC16-RPA43-TRg-1",
"CC16-RPB7-NRg-2",
"CC16-RPB7-NRg-3",
"CC16-NSL1-NRg-1",
"CC16-UTP6-TRg-3",
"CC16-UTP6-TRg-1",
"CC16-YJU2-TRg-5",
"CC16-FRS2-NRg-5",
"CC16-TIF35-NRg-2",
"CC16-GPI15-TRg-1",
"CC16-NOP1-NRg-5",
"CC16-GPI15-TRg-4",
"CC16-COG4-TRg-1",
"CC16-TFA1-TRg-1",
"CC16-RHO1-NRg-2",
"CC16-RHO1-NRg-1",
"CC16-CDC55-NRg-2",
"CC16-IDI1-NRg-7",
"CC16-RPL32-TRg-5",
"CC16-RPB5-TRg-4",
"CC16-DIP2-TRg-5",
"CC16-DIP2-TRg-1",
"CC16-RPC40-TRg-2",
"CC16-CDC6-TRg-5",
"CC16-CDC6-TRg-3",
"CC16-DAD2-TRg-2",
"CC16-RVS161-TRg-2",
"CC16-RVS161-TRg-1",
"CC16-SUP45-NRg-3",
"CC16-SRB6-NRg-5",
"CC16-RPC11-TRg-4",
"CC16-RKI1-TRg-8",
"CC16-NIP7-TRg-3",
"CC16-RPL33A-NRg-12",
"CC16-SAM50-TRg-4",
"CC16-NOP4-NRg-1",
"CC16-NOP4-NRg-3",
"CC16-SMX2-TRg-5",
"CC16-POL12-NRg-2",
"CC16-BMS1-NRg-2",
"CC16-RPA190-TRg-5",
"CC16-ALG14-NRg-4",
"CC16-ALG14-NRg-1",
"CC16-PRE5-NRg-1",
"CC16-BIG1-NRg-2",
"CC16-TFA2-TRg-4",
"CC16-IMP4-TRg-6",
"CC16-PAN1-NRg-1",
"CC16-UTP13-TRg-2",
"CC16-KAE1-NRg-3",
"CC16-ERG20-TRg-1",
"CC16-CDC20-TRg-6",
"CC16-PWP2-NRg-2",
"CC16-COG1-NRg-1",
"CC16-RPL1B-TRg-4",
"CC16-RPL1B-TRg-7",
"CC16-UTP20-TRg-3",
"CC16-UTP20-TRg-4",
"CC16-RPL25-TRg-4",
"CC16-RPL25-TRg-2",
"CC16-MCM7-NRg-1",
"CC16-MRP49-TRg-5",
"CC16-ERO1-NRg-3",
"CC16-UTP5-TRg-7",
"CC16-MCM4-NRg-1",
"CC16-PRE3-NRg-1",
"CC16-FCF1-NRg-1",
"CC16-CUS1-NRg-1",
"CC16-PSF1-TRg-2",
"CC16-BCP1-TRg-2",
"CC16-PAN1-TRg-1",
"CC16-PAN1-TRg-3",
"CC16-PAN1-TRg-4",
"CC16-VPS3-TRg-2",
"CC16-YIL060W-NRg-1",
"CC16-VPS53-NRg-1",
"CC16-CYR1-TRg-4",
"CC16-CYR1-TRg-7",
"CC16-MPS1-NRg-1",
"CC16-SRP1-TRg-5",
"CC16-SRP1-TRg-4",
"CC16-TAF12-TRg-2",
"CC16-TAF12-TRg-3",
"CC16-POP4-TRg-1",
"CC16-SPT16-TRg-1",
"CC16-NUP82-TRg-4",
"CC16-DML1-TRg-3",
"CC16-RPA43-NRg-3",
"CC16-STU2-NRg-3",
"CC16-POP4-NRg-4",
"CC16-MCD1-TRg-2",
"CC16-RPS3-NRg-4",
"CC16-PRP9-TRg-4",
"CC16-RPP1-NRg-2",
"CC16-MTR2-NRg-11",
"CC16-GCD11-TRg-1",
"CC16-RPF1-TRg-3",
"CC16-SUB2-NRg-4",
"CC16-GPI15-TRg-3",
"CC16-ERG9-TRg-6",
"CC16-RPT2-NRg-1",
"CC16-YOS1-NRg-3",
"CC16-SCM3-TRg-4",
"CC16-SCM3-TRg-6",
"CC16-RLP7-NRg-1",
"CC16-TFB2-NRg-4",
"CC16-IMP4-TRg-1",
"CC16-IMP4-TRg-3",
"CC16-PRE4-TRg-3",
"CC16-SUB2-TRg-3",
"CC16-RPP0-NRg-4",
"CC16-RPP0-NRg-3",
"CC16-TOM40-TRg-4",
"CC16-FUR1-NRg-12",
"CC16-TOM40-TRg-2",
"CC16-VMA11-NRg-4",
"CC16-PGS1-NRg-4",
"CC16-URB1-TRg-4",
"CC16-ARP4-TRg-3",
"CC16-RPT3-TRg-3",
"CC16-SUI3-TRg-3",
"CC16-RFC5-NRg-2",
"CC16-RRP14-TRg-2",
"CC16-SCC2-TRg-1",
"CC16-SSC1-TRg-3",
"CC16-RRP9-TRg-3",
"CC16-MOT1-NRg-9",
"CC16-RPL42A-NRg-2",
"CC16-SEC16-TRg-7",
"CC16-IMP4-NRg-2",
"CC16-YEF3-NRg-4",
"CC16-PUP1-TRg-1",
"CC16-UTP22-TRg-6",
"CC16-DBP2-NRg-4",
"CC16-PRE2-TRg-7",
"CC16-ATP16-TRg-6",
"CC16-UTP13-TRg-4",
"CC16-DOP1-NRg-4",
"CC16-TIM44-TRg-3",
"CC16-ATP16-TRg-2",
"CC16-ENP1-NRg-3",
"CC16-NAF1-TRg-3",
"CC16-COG4-TRg-2",
"CC16-SOG2-TRg-7",
"CC16-YDR341C-TRg-3",
"CC16-YMR290W-A-TRg-10",
"CC16-NUP192-NRg-9",
"CC16-RPS31-NRg-8",
"CC16-SPC97-NRg-6",
"CC16-EBP2-NRg-1",
"CC16-CDC48-TRg-5",
"CC16-RPT1-TRg-4",
"CC16-ULP1-NRg-2",
"CC16-RPN3-TRg-6",
"CC16-RPT1-TRg-5",
"CC16-KRE5-TRg-2",
"CC16-TBF1-NRg-8",
"CC16-UTP22-NRg-4",
"CC16-SSC1-NRg-4",
"CC16-REB1-TRg-4",
"CC16-CDC48-NRg-9",
"CC16-FAS2-TRg-8",
"CC16-TAO3-TRg-8",
"CC16-CKS1-TRg-5",
"CC16-YLR379W-TRg-7",
"CC16-TEN1-NRg-2",
"CC16-RPL42A-TRg-2",
"CC16-SEC27-TRg-4",
"CC16-TBF1-NRg-4",
"CC16-RPT1-NRg-6",
"CC16-COG1-TRg-3",
"CC16-SUI1-TRg-6",
"CC16-TIM23-TRg-6",
"CC16-CDC48-NRg-6",
"CC16-EPL1-TRg-5",
"CC16-RPT5-TRg-8",
"CC16-ATP16-NRg-4",
"CC16-RPN6-TRg-3",
"CC16-ERG9-NRg-6",
"CC16-SMX3-TRg-1",
"CC16-NCB2-NRg-3",
"CC16-SEC16-NRg-12",
"CC16-RPN6-TRg-2",
"CC16-REB1-NRg-4",
"CC16-ATP16-TRg-9",
"CC16-ERG9-NRg-7",
"CC17-RPL15A-NRg-4",
"CC17-RPL15A-NRg-5",
"CC17-KRE33-TRg-1",
"CC17-PMI40-NRg-1",
"CC17-NOP19-NRg-3",
"CC17-SRP14-NRg-4",
"CC17-SEC27-TRg-2",
"CC17-GPI14-TRg-3",
"CC17-PAH1-TRg-7",
"CC17-PAH1-TRg-6",
"CC17-PAH1-TRg-5",
"CC17-PAH1-TRg-3",
"CC17-COG3-TRg-1",
"CC17-HTS1-NRg-5",
"CC17-MSN5-TRg-7",
"CC17-ERG26-TRg-1",
"CC17-SMD2-TRg-5",
"CC17-SMD2-TRg-4",
"CC17-SMD2-TRg-1",
"CC17-PRE7-TRg-4",
"CC17-PRE7-TRg-7",
"CC17-SEC6-TRg-3",
"CC17-ESF2-NRg-1",
"CC17-ESF2-NRg-3",
"CC17-AFG2-TRg-2",
"CC17-RRP36-TRg-3",
"CC17-RRP36-TRg-5",
"CC17-GCR1-NRg-2",
"CC17-PRE4-NRg-4",
"CC17-PRE4-NRg-9",
"CC17-DSN1-NRg-2",
"CC17-GPI11-TRg-3",
"CC17-POP3-TRg-1",
"CC17-MNE1-TRg-5",
"CC17-RRP12-NRg-1",
"CC17-RSC6-TRg-2",
"CC17-CDC25-TRg-1",
"CC17-CDC25-TRg-9",
"CC17-YPP1-NRg-3",
"CC17-NFS1-NRg-9",
"CC17-NFS1-NRg-8",
"CC17-UBA2-TRg-1",
"CC17-ARP2-NRg-3",
"CC17-MAK16-TRg-1",
"CC17-CEP3-NRg-1",
"CC17-GUK1-TRg-5",
"CC17-GUK1-TRg-2",
"CC17-GPI12-NRg-6",
"CC17-RPS5-NRg-5",
"CC17-RPS5-NRg-2",
"CC17-RPC19-NRg-1",
"CC17-TIM54-TRg-1",
"CC17-TEN1-TRg-2",
"CC17-SAH1-NRg-4",
"CC17-SAH1-NRg-5",
"CC17-SAH1-NRg-3",
"CC17-ATP15-NRg-5",
"CC17-SCD5-TRg-5",
"CC17-ARB1-NRg-2",
"CC17-ARB1-NRg-4",
"CC17-PUP2-TRg-1",
"CC17-CCT8-TRg-2",
"CC17-MCM4-TRg-1",
"CC17-LSM4-TRg-1",
"CC17-NOP53-NRg-1",
"CC17-ATP3-TRg-4",
"CC17-AFG2-NRg-3",
"CC17-PRO3-NRg-3",
"CC17-NRD1-NRg-10",
"CC17-SEC61-TRg-2",
"CC17-RHO3-TRg-4",
"CC17-SNF2-TRg-6",
"CC17-SMD2-NRg-3",
"CC17-RSC4-TRg-2",
"CC17-RSC4-TRg-1",
"CC17-TIF34-TRg-2",
"CC17-BET1-NRg-1",
"CC17-CDC8-NRg-2",
"CC17-PRP42-TRg-2",
"CC17-RRB1-TRg-2",
"CC17-SPC24-TRg-1",
"CC17-ILS1-NRg-1",
"CC17-GFA1-TRg-2",
"CC17-SEC21-NRg-10",
"CC17-RPC10-NRg-1",
"CC17-RPB10-TRg-3",
"CC17-RPB10-TRg-2",
"CC17-YNL181W-TRg-1",
"CC17-RAD3-NRg-1",
"CC17-NOP10-TRg-1",
"CC17-BFR2-TRg-3",
"CC17-MCM2-TRg-6",
"CC17-MCM2-TRg-4",
"CC17-MPP10-TRg-1",
"CC17-RET2-TRg-4",
"CC17-RET2-TRg-1",
"CC17-RPS2-NRg-1",
"CC17-RPS2-NRg-2",
"CC17-ORC4-NRg-3",
"CC17-TIP20-TRg-7",
"CC17-SMT3-TRg-1",
"CC17-MSS18-NRg-6",
"CC17-YEF3-NRg-9",
"CC17-ASK1-NRg-1",
"CC17-SMC1-TRg-1",
"CC17-NIP1-NRg-1",
"CC17-RPP1-NRg-1",
"CC17-YDJ1-TRg-6",
"CC17-SUB2-NRg-1",
"CC17-TIM10-NRg-8",
"CC17-TIM10-NRg-4",
"CC17-TIM10-NRg-7",
"CC17-SKI6-TRg-4",
"CC17-TUB4-TRg-1",
"CC17-CDC37-NRg-2",
"CC17-ISD11-TRg-3",
"CC17-YOS1-TRg-4",
"CC17-SSC1-TRg-6",
"CC17-MTR3-TRg-5",
"CC17-MTR3-TRg-6",
"CC17-TFA1-TRg-2",
"CC17-CDC3-NRg-3",
"CC17-ERG25-TA-18",
"CC17-RPB11-TRg-4",
"CC17-RPB11-TRg-1",
"CC17-RPB11-TRg-2",
"CC17-DED1-TRg-3",
"CC17-DED1-TRg-1",
"CC17-DED1-TRg-6",
"CC17-DED1-TRg-4",
"CC17-RPL10-NRg-5",
"CC17-RPL10-NRg-4",
"CC17-EFB1-NRg-1",
"CC17-EFB1-NRg-5",
"CC17-EFB1-NRg-4",
"CC17-RPT3-NRg-1",
"CC17-SAC6-TRg-8",
"CC17-SAC6-TRg-4",
"CC17-SAC6-TRg-5",
"CC17-SAC6-TRg-3",
"CC17-DIM1-TRg-5",
"CC17-DIM1-TRg-7",
"CC17-RPC17-NRg-1",
"CC17-RPC17-NRg-2",
"CC17-YDR341C-TRg-1",
"CC17-RAP1-NRg-8",
"CC17-RAP1-NRg-5",
"CC17-RAP1-NRg-2",
"CC17-SEC26-NRg-3",
"CC17-SPP41-TRg-3",
"CC17-TAP42-NRg-1",
"CC17-PGA2-TRg-6",
"CC17-BRL1-TRg-1",
"CC17-FOL2-TRg-1",
"CC17-NAB3-NRg-5",
"CC17-SNF4-TRg-4",
"CC17-HRR25-TRg-2",
"CC17-TRS23-TRg-4",
"CC17-CTR86-TRg-4",
"CC17-RPB5-TRg-5",
"CC17-SPN1-NRg-2",
"CC17-SPN1-NRg-1",
"CC17-SEC61-NRg-1",
"CC17-SEC61-NRg-7",
"CC17-TUS1-TRg-3",
"CC17-OLE1-NRg-2",
"CC17-AFG2-TRg-1",
"CC17-TOA2-NRg-1",
"CC17-USO1-TRg-1",
"CC17-UTP22-NRg-2",
"CC17-RIB1-TRg-3",
"CC17-RIB1-TRg-7",
"CC17-RIB1-TRg-4",
"CC17-COG1-TRg-1",
"CC17-RPL32-NRg-2",
"CC17-GLC7-NRg-3",
"CC17-GLC7-NRg-4",
"CC17-HSF1-TRg-2",
"CC17-DAM1-NRg-5",
"CC17-SEC18-TRg-4",
"CC17-SEC18-TRg-5",
"CC17-PAB1-NRg-3",
"CC17-POP8-TRg-2",
"CC17-PAB1-NRg-4",
"CC17-BIG1-TRg-4",
"CC17-BIG1-TRg-5",
"CC17-BIG1-TRg-6",
"CC17-RPO41-NRg-1",
"CC17-RVB2-NRg-2",
"CC17-PET117-NRg-8",
"CC17-VPS45-NRg-9",
"CC17-YCG1-NRg-1",
"CC17-NOC4-NRg-1",
"CC17-NMD3-NRg-2",
"CC17-DRS1-TRg-2",
"CC17-HTB1-NRg-2",
"CC17-IPI1-TRg-2",
"CC17-SEC18-NRg-1",
"CC17-SEC18-NRg-2",
"CC17-JIP5-NRg-2",
"CC17-YPT1-TRg-3",
"CC17-YPT1-TRg-2",
"CC17-CLF1-NRg-2",
"CC17-SNF2-NRg-7",
"CC17-SNF2-NRg-4",
"CC17-RPL25-NRg-1",
"CC17-NOP56-TRg-1",
"CC17-NOP56-TRg-2",
"CC17-TRS31-TRg-1",
"CC17-DBF4-TRg-2",
"CC17-DBF4-TRg-1",
"CC17-RPC19-TRg-4",
"CC17-RPC19-TRg-6",
"CC17-RPC19-TRg-3",
"CC17-ROK1-NRg-1",
"CC17-CDC33-TRg-4",
"CC17-DHR2-TRg-3",
"CC17-RRP42-NRg-5",
"CC17-CLF1-TRg-1",
"CC17-ERG11-NA-16",
"CC17-VAS1-NRg-4",
"CC17-PIK1-NRg-2",
"CC17-SAR1-NRg-7",
"CC17-SAR1-NRg-4",
"CC17-RPS3-TRg-1",
"CC17-YTM1-TRg-2",
"CC17-SUI3-NRg-5",
"CC17-SUI3-NRg-2",
"CC17-RRP7-TRg-4",
"CC17-RRP7-TRg-6",
"CC17-NIP7-TRg-2",
"CC17-MDM35-TRg-1",
"CC17-ALA1-NRg-1",
"CC17-DOA4-NRg-2",
"CC17-RPS13-NRg-1",
"CC17-YSF3-TRg-2",
"CC17-RPS2-NRg-11",
"CC17-SSL1-TRg-10",
"CC17-NIP7-TRg-1",
"CC17-LST8-NRg-1",
"CC17-TAF4-TRg-3",
"CC17-HAS1-TRg-2",
"CC17-GLC7-TRg-2",
"CC17-CDC45-NRg-1",
"CC17-SEC22-NRg-8",
"CC17-YOS1-TRg-2",
"CC17-RBA50-TRg-3",
"CC17-SPP41-NRg-2",
"CC17-PRP46-TRg-2",
"CC17-PGA2-NRg-1",
"CC17-CBF5-TRg-3",
"CC17-TCP1-NRg-3",
"CC17-TCP1-NRg-2",
"CC17-ERG26-NRg-2",
"CC17-ERG26-NRg-4",
"CC17-MES1-TRg-5",
"CC17-HTS1-TRg-2",
"CC17-SSS1-TRg-3",
"CC17-SSS1-TRg-2",
"CC17-SYS1-TRg-7",
"CC17-SYS1-TRg-2",
"CC17-SYS1-TRg-1",
"CC17-BFR2-TRg-1",
"CC17-EOS1-TRg-3",
"CC17-TAF4-NRg-1",
"CC17-ARL3-NRg-8",
"CC17-RPN5-NRg-1",
"CC17-TIM9-NRg-2",
"CC17-NUP57-NRg-3",
"CC17-VPS4-TRg-1",
"CC17-CDC3-TRg-4",
"CC17-BBP1-NRg-1",
"CC17-BBP1-NRg-2",
"CC17-USE1-NRg-3",
"CC17-CCT7-TRg-1",
"CC17-SAH1-TRg-3",
"CC17-CHS2-TRg-1",
"CC17-DPM1-TRg-2",
"CC17-BBP1-TRg-1",
"CC17-NRD1-TRg-4",
"CC17-RPB3-NRg-1",
"CC17-PHO85-NRg-6",
"CC17-SNF6-TRg-6",
"CC17-PRP38-NRg-2",
"CC17-OAR1-NRg-3",
"CC17-ROX3-NRg-1",
"CC17-YPP1-TRg-6",
"CC17-CBF2-NRg-8",
"CC17-SPT6-TRg-5",
"CC17-SEC10-NRg-1",
"CC17-NSL1-NRg-3",
"CC17-NRD1-NRg-8",
"CC17-RPB3-TRg-1",
"CC17-NRD1-NRg-4",
"CC17-RVB1-TRg-2",
"CC17-TIF5-NRg-8",
"CC17-EOS1-NRg-1",
"CC17-ERG25-NA-26",
"CC17-MSL5-NRg-4",
"CC17-SEC24-TRg-2",
"CC17-RPL30-NRg-5",
"CC17-SNU71-NRg-3",
"CC17-CDC33-NRg-1",
"CC17-RPN6-TRg-4",
"CC17-NAB2-TRg-4",
"CC17-NAB2-TRg-6",
"CC17-YTM1-NRg-1",
"CC17-OLE1-TRg-8",
"CC17-OLE1-TRg-1",
"CC17-UTP7-TRg-4",
"CC17-ACT1-NRg-6",
"CC17-RPL18A-NRg-3",
"CC17-BRX1-NRg-1",
"CC17-NAF1-TRg-8",
"CC17-NAF1-TRg-6",
"CC17-NAF1-TRg-4",
"CC17-CDC8-TRg-2",
"CC17-NSE4-TRg-1",
"CC17-PAB1-NRg-2",
"CC17-PRP43-TRg-4",
"CC17-SEC2-NRg-3",
"CC17-SEC2-NRg-6",
"CC17-MPP10-NRg-5",
"CC17-YDR355C-TRg-2",
"CC17-YLR339C-TRg-9",
"CC17-SNM1-TRg-2",
"CC17-ALR1-NRg-4",
"CC17-ALR1-NRg-1",
"CC17-ALR1-NRg-3",
"CC17-RPL10-TRg-1",
"CC17-RPL28-TRg-2",
"CC17-UTP25-TRg-1",
"CC17-POB3-TRg-1",
"CC17-POB3-TRg-3",
"CC17-POB3-TRg-2",
"CC17-MED11-TRg-1",
"CC17-ISA1-TRg-15",
"CC17-RRP1-NRg-1",
"CC17-MES1-NRg-1",
"CC17-SEC13-NRg-5",
"CC17-MCM2-NRg-2",
"CC17-ALA1-TRg-4",
"CC17-MTG2-TRg-5",
"CC17-TIF35-NRg-3",
"CC17-NSE1-TRg-3",
"CC17-NSE1-TRg-4",
"CC17-MOB2-NRg-6",
"CC17-VRG4-NRg-3",
"CC17-PRP9-TRg-3",
"CC17-HYM1-TRg-5",
"CC17-POP1-TRg-5",
"CC17-POP1-TRg-9",
"CC17-RPL17A-TRg-1",
"CC17-SLD2-TRg-1",
"CC17-CDC48-NRg-7",
"CC17-FHL1-NRg-2",
"CC17-BET3-NRg-7",
"CC17-MAK21-TRg-1",
"CC17-BRN1-TRg-4",
"CC17-FBA1-NRg-3",
"CC17-CDC42-TRg-6",
"CC17-CDC42-TRg-7",
"CC17-COG4-NRg-1",
"CC17-ATP3-NRg-3",
"CC17-ATP3-NRg-2",
"CC17-SMP3-TRg-5",
"CC17-CFT2-NRg-2",
"CC17-FAS2-TRg-5",
"CC17-DBP2-NRg-3",
"CC17-DBP2-NRg-2",
"CC17-MPS2-NRg-4",
"CC17-ARC35-TRg-2",
"CC17-ARC35-TRg-5",
"CC17-MRD1-TRg-1",
"CC17-RLP7-TRg-1",
"CC17-SPC34-TRg-1",
"CC17-CDC45-TRg-2",
"CC17-GCD6-TRg-3",
"CC17-GCD6-TRg-4",
"CC17-YPT6-NRg-2",
"CC17-RPS13-TRg-2",
"CC17-IPI3-TRg-3",
"CC17-TIF5-NRg-9",
"CC17-TIF5-NRg-7",
"CC17-TIF5-NRg-6",
"CC17-NAB3-TRg-3",
"CC17-GCD2-TRg-1",
"CC17-UBA1-TRg-2",
"CC17-SLD3-TRg-6",
"CC17-LCB1-TRg-5",
"CC17-TOA2-TRg-6",
"CC17-TOA2-TRg-1",
"CC17-TOA2-TRg-3",
"CC17-LSM2-TRg-1",
"CC17-YML6-TRg-13",
"CC17-YML6-TRg-12",
"CC17-UTP15-NRg-1",
"CC17-TIF6-NRg-8",
"CC17-SUP35-NRg-1",
"CC17-MPP10-NRg-1",
"CC17-SWI3-TRg-7",
"CC17-SSN3-NRg-2",
"CC17-SEC13-NRg-7",
"CC17-RPS15-NRg-3",
"CC17-RPL3-TRg-2",
"CC17-FBA1-NRg-2",
"CC17-FBA1-NRg-1",
"CC17-FBA1-NRg-5",
"CC17-DAM1-TRg-2",
"CC17-NHP2-TRg-2",
"CC17-HCA4-NRg-6",
"CC17-PRE3-TRg-4",
"CC17-DBP5-NRg-4",
"CC17-SPT6-NRg-4",
"CC17-SPT6-NRg-2",
"CC17-RPL18A-TRg-4",
"CC17-KSH1-TRg-1",
"CC17-KSH1-TRg-3",
"CC17-IPI3-NRg-1",
"CC17-PGA2-TRg-8",
"CC17-RPL18A-TRg-2",
"CC17-RPL33A-NRg-6",
"CC17-TAF12-NRg-2",
"CC17-USE1-TRg-5",
"CC17-YNL114C-TRg-1",
"CC17-SMC5-TRg-7",
"CC17-SMC5-TRg-6",
"CC17-RSC58-TRg-1",
"CC17-CTF13-TRg-2",
"CC17-NAB2-NRg-2",
"CC17-MCM7-TRg-4",
"CC17-BCP1-NRg-5",
"CC17-STU2-TRg-3",
"CC17-SEC21-NRg-6",
"CC17-SEC21-NRg-3",
"CC17-RPL1B-TRg-3",
"CC17-SEC20-NRg-2",
"CC17-VMA3-NRg-2",
"CC17-SEC23-NRg-5",
"CC17-CDC28-TRg-4",
"CC17-RPN12-NRg-11",
"CC17-PUP3-TRg-3",
"CC17-SEC31-TRg-2",
"CC17-SED5-TRg-6",
"CC17-SED5-TRg-5",
"CC17-RPL33A-TRg-1",
"CC17-RPL33A-TRg-2",
"CC17-MRPL11-TRg-2",
"CC17-RTP1-NRg-2",
"CC17-NUG1-TRg-2",
"CC17-VPH2-TRg-4",
"CC17-COP1-NRg-3",
"CC17-CRM1-NRg-1",
"CC17-RPL5-NRg-4",
"CC17-SNU13-NRg-4",
"CC17-PFS2-TRg-3",
"CC17-MPP10-TRg-2",
"CC17-TSR4-NRg-2",
"CC17-RSC2-TRg-1",
"CC17-SEC65-TRg-2",
"CC17-SMI1-NRg-1",
"CC17-RTT105-NRg-4",
"CC17-VMA5-TRg-3",
"CC17-VMA5-TRg-5",
"CC17-RRP1-TRg-3",
"CC17-CLC1-TRg-2",
"CC17-GCD6-NRg-1",
"CC17-GCD6-NRg-2",
"CC17-PXR1-TRg-1",
"CC17-CDC14-NRg-1",
"CC17-PCF11-TRg-6",
"CC17-PCF11-TRg-5",
"CC17-PCF11-TRg-4",
"CC17-SEC31-NRg-1",
"CC17-RRP5-NRg-1",
"CC17-PRE10-TRg-5",
"CC17-PRE10-TRg-1",
"CC17-RPS5-TRg-2",
"CC17-NSP1-TRg-4",
"CC17-PRP38-TRg-4",
"CC17-RCF1-NRg-5",
"CC17-RSC3-TRg-4",
"CC17-RSC3-TRg-5",
"CC17-RSC3-TRg-6",
"CC17-HTA1-NRg-12",
"CC17-HTA1-NRg-11",
"CC17-UTP23-TRg-2",
"CC17-GCD7-NRg-1",
"CC17-GCD7-NRg-2",
"CC17-GCD7-NRg-6",
"CC17-GAL11-NRg-2",
"CC17-GAL11-NRg-9",
"CC17-PHO4-TRg-5",
"CC17-SNP1-NRg-3",
"CC17-RPC37-TRg-5",
"CC17-CRM1-TRg-5",
"CC17-CRM1-TRg-2",
"CC17-ASK1-TRg-7",
"CC17-STU2-NRg-4",
"CC17-NEO1-NRg-3",
"CC17-GAL11-TRg-5",
"CC17-GAL11-TRg-7",
"CC17-SAM50-NRg-3",
"CC17-CSL4-TRg-2",
"CC17-CCT5-TRg-2",
"CC17-POL30-NRg-1",
"CC17-MED4-TRg-4",
"CC17-MED4-TRg-3",
"CC17-MED4-TRg-2",
"CC17-GDI1-TRg-4",
"CC17-GDI1-TRg-3",
"CC17-REB1-TRg-6",
"CC17-MRPL37-NRg-2",
"CC17-NOC3-TRg-3",
"CC17-SPC97-TRg-3",
"CC17-IPP1-TRg-3",
"CC17-IPP1-TRg-2",
"CC17-PTI1-TRg-3",
"CC17-PTI1-TRg-5",
"CC17-RFC5-NRg-1",
"CC17-CDC24-TRg-1",
"CC17-CDC24-TRg-3",
"CC17-CDC24-TRg-5",
"CC17-CDC24-TRg-6",
"CC17-UTP23-TRg-6",
"CC17-UTP23-TRg-4",
"CC17-UTP23-TRg-1",
"CC17-RHO3-NRg-4",
"CC17-TRS23-NRg-1",
"CC17-TRS23-NRg-3",
"CC17-RSP5-TRg-2",
"CC17-RSP5-TRg-1",
"CC17-SDA1-NRg-1",
"CC17-KAP95-TRg-8",
"CC17-ACO1-TRg-6",
"CC17-HTA1-NRg-3",
"CC17-HTA1-NRg-2",
"CC17-SPN1-TRg-1",
"CC17-MOT1-NRg-7",
"CC17-RPL17A-NRg-4",
"CC17-ADA2-TRg-4",
"CC17-SFH1-NRg-1",
"CC17-SPC97-NRg-5",
"CC17-PRP22-TRg-3",
"CC17-SEN15-TRg-2",
"CC17-RPL3-NRg-2",
"CC17-ISD11-NRg-2",
"CC17-HEM12-TRg-8",
"CC17-SEC10-TRg-1",
"CC17-HTB1-TRg-7",
"CC17-TTI2-TRg-1",
"CC17-ACP1-TRg-2",
"CC17-ACP1-TRg-4",
"CC17-GAL11-NRg-10",
"CC17-UTP22-TRg-2",
"CC17-MST1-NRg-5",
"CC17-RIB7-NRg-2",
"CC17-MCD1-TRg-6",
"CC17-MCD1-TRg-5",
"CC17-GPI8-NRg-2",
"CC17-THS1-TRg-2",
"CC17-RRP7-TRg-2",
"CC17-RRP7-TRg-5",
"CC17-SMX2-NRg-7",
"CC17-RRP45-TRg-5",
"CC17-RRP45-TRg-4",
"CC17-CNS1-TRg-2",
"CC17-FBP1-NRg-9",
"CC17-GCD11-NRg-1",
"CC17-RPL10-TRg-2",
"CC17-NUP192-TRg-4",
"CC17-NUP145-NRg-4",
"CC17-HEM12-TRg-6",
"CC17-PLC1-TRg-3",
"CC17-RPA43-TRg-1",
"CC17-RPB7-NRg-2",
"CC17-RPB7-NRg-3",
"CC17-NSL1-NRg-1",
"CC17-UTP6-TRg-3",
"CC17-UTP6-TRg-1",
"CC17-YJU2-TRg-5",
"CC17-FRS2-NRg-5",
"CC17-TIF35-NRg-2",
"CC17-GPI15-TRg-1",
"CC17-NOP1-NRg-5",
"CC17-GPI15-TRg-4",
"CC17-COG4-TRg-1",
"CC17-TFA1-TRg-1",
"CC17-RHO1-NRg-2",
"CC17-RHO1-NRg-1",
"CC17-CDC55-NRg-2",
"CC17-IDI1-NRg-7",
"CC17-RPL32-TRg-5",
"CC17-RPB5-TRg-4",
"CC17-DIP2-TRg-5",
"CC17-DIP2-TRg-1",
"CC17-RPC40-TRg-2",
"CC17-CDC6-TRg-5",
"CC17-CDC6-TRg-3",
"CC17-DAD2-TRg-2",
"CC17-RVS161-TRg-2",
"CC17-RVS161-TRg-1",
"CC17-SUP45-NRg-3",
"CC17-SRB6-NRg-5",
"CC17-RPC11-TRg-4",
"CC17-RKI1-TRg-8",
"CC17-NIP7-TRg-3",
"CC17-RPL33A-NRg-12",
"CC17-SAM50-TRg-4",
"CC17-NOP4-NRg-1",
"CC17-NOP4-NRg-3",
"CC17-SMX2-TRg-5",
"CC17-POL12-NRg-2",
"CC17-BMS1-NRg-2",
"CC17-RPA190-TRg-5",
"CC17-ALG14-NRg-4",
"CC17-ALG14-NRg-1",
"CC17-PRE5-NRg-1",
"CC17-BIG1-NRg-2",
"CC17-TFA2-TRg-4",
"CC17-IMP4-TRg-6",
"CC17-PAN1-NRg-1",
"CC17-UTP13-TRg-2",
"CC17-KAE1-NRg-3",
"CC17-ERG20-TRg-1",
"CC17-CDC20-TRg-6",
"CC17-PWP2-NRg-2",
"CC17-COG1-NRg-1",
"CC17-RPL1B-TRg-4",
"CC17-RPL1B-TRg-7",
"CC17-UTP20-TRg-3",
"CC17-UTP20-TRg-4",
"CC17-RPL25-TRg-4",
"CC17-RPL25-TRg-2",
"CC17-MCM7-NRg-1",
"CC17-MRP49-TRg-5",
"CC17-ERO1-NRg-3",
"CC17-UTP5-TRg-7",
"CC17-MCM4-NRg-1",
"CC17-PRE3-NRg-1",
"CC17-FCF1-NRg-1",
"CC17-CUS1-NRg-1",
"CC17-PSF1-TRg-2",
"CC17-BCP1-TRg-2",
"CC17-PAN1-TRg-1",
"CC17-PAN1-TRg-3",
"CC17-PAN1-TRg-4",
"CC17-VPS3-TRg-2",
"CC17-YIL060W-NRg-1",
"CC17-VPS53-NRg-1",
"CC17-CYR1-TRg-4",
"CC17-CYR1-TRg-7",
"CC17-MPS1-NRg-1",
"CC17-SRP1-TRg-5",
"CC17-SRP1-TRg-4",
"CC17-TAF12-TRg-2",
"CC17-TAF12-TRg-3",
"CC17-POP4-TRg-1",
"CC17-SPT16-TRg-1",
"CC17-NUP82-TRg-4",
"CC17-DML1-TRg-3",
"CC17-RPA43-NRg-3",
"CC17-STU2-NRg-3",
"CC17-POP4-NRg-4",
"CC17-MCD1-TRg-2",
"CC17-RPS3-NRg-4",
"CC17-PRP9-TRg-4",
"CC17-RPP1-NRg-2",
"CC17-MTR2-NRg-11",
"CC17-GCD11-TRg-1",
"CC17-RPF1-TRg-3",
"CC17-SUB2-NRg-4",
"CC17-GPI15-TRg-3",
"CC17-ERG9-TRg-6",
"CC17-RPT2-NRg-1",
"CC17-YOS1-NRg-3",
"CC17-SCM3-TRg-4",
"CC17-SCM3-TRg-6",
"CC17-RLP7-NRg-1",
"CC17-TFB2-NRg-4",
"CC17-IMP4-TRg-1",
"CC17-IMP4-TRg-3",
"CC17-PRE4-TRg-3",
"CC17-SUB2-TRg-3",
"CC17-RPP0-NRg-4",
"CC17-RPP0-NRg-3",
"CC17-TOM40-TRg-4",
"CC17-FUR1-NRg-12",
"CC17-TOM40-TRg-2",
"CC17-VMA11-NRg-4",
"CC17-PGS1-NRg-4",
"CC17-URB1-TRg-4",
"CC17-ARP4-TRg-3",
"CC17-RPT3-TRg-3",
"CC17-SUI3-TRg-3",
"CC17-RFC5-NRg-2",
"CC17-RRP14-TRg-2",
"CC17-SCC2-TRg-1",
"CC17-SSC1-TRg-3",
"CC17-RRP9-TRg-3",
"CC17-MOT1-NRg-9",
"CC17-RPL42A-NRg-2",
"CC17-SEC16-TRg-7",
"CC17-IMP4-NRg-2",
"CC17-YEF3-NRg-4",
"CC17-PUP1-TRg-1",
"CC17-UTP22-TRg-6",
"CC17-DBP2-NRg-4",
"CC17-PRE2-TRg-7",
"CC17-ATP16-TRg-6",
"CC17-UTP13-TRg-4",
"CC17-DOP1-NRg-4",
"CC17-TIM44-TRg-3",
"CC17-ATP16-TRg-2",
"CC17-ENP1-NRg-3",
"CC17-NAF1-TRg-3",
"CC17-COG4-TRg-2",
"CC17-SOG2-TRg-7",
"CC17-YDR341C-TRg-3",
"CC17-YMR290W-A-TRg-10",
"CC17-NUP192-NRg-9",
"CC17-RPS31-NRg-8",
"CC17-SPC97-NRg-6",
"CC17-EBP2-NRg-1",
"CC17-CDC48-TRg-5",
"CC17-RPT1-TRg-4",
"CC17-ULP1-NRg-2",
"CC17-RPN3-TRg-6",
"CC17-RPT1-TRg-5",
"CC17-KRE5-TRg-2",
"CC17-TBF1-NRg-8",
"CC17-UTP22-NRg-4",
"CC17-SSC1-NRg-4",
"CC17-REB1-TRg-4",
"CC17-CDC48-NRg-9",
"CC17-FAS2-TRg-8",
"CC17-TAO3-TRg-8",
"CC17-CKS1-TRg-5",
"CC17-YLR379W-TRg-7",
"CC17-TEN1-NRg-2",
"CC17-RPL42A-TRg-2",
"CC17-SEC27-TRg-4",
"CC17-TBF1-NRg-4",
"CC17-RPT1-NRg-6",
"CC17-COG1-TRg-3",
"CC17-SUI1-TRg-6",
"CC17-TIM23-TRg-6",
"CC17-CDC48-NRg-6",
"CC17-EPL1-TRg-5",
"CC17-RPT5-TRg-8",
"CC17-ATP16-NRg-4",
"CC17-RPN6-TRg-3",
"CC17-ERG9-NRg-6",
"CC17-SMX3-TRg-1",
"CC17-NCB2-NRg-3",
"CC17-SEC16-NRg-12",
"CC17-RPN6-TRg-2",
"CC17-REB1-NRg-4",
"CC17-ATP16-TRg-9",
"CC17-ERG9-NRg-7",
"CC8_BC2-RPL15A-NRg-4",
"CC8_BC2-RPL15A-NRg-5",
"CC8_BC2-KRE33-TRg-1",
"CC8_BC2-PMI40-NRg-1",
"CC8_BC2-NOP19-NRg-3",
"CC8_BC2-SRP14-NRg-4",
"CC8_BC2-SEC27-TRg-2",
"CC8_BC2-GPI14-TRg-3",
"CC8_BC2-PAH1-TRg-7",
"CC8_BC2-PAH1-TRg-6",
"CC8_BC2-PAH1-TRg-5",
"CC8_BC2-PAH1-TRg-3",
"CC8_BC2-COG3-TRg-1",
"CC8_BC2-HTS1-NRg-5",
"CC8_BC2-MSN5-TRg-7",
"CC8_BC2-ERG26-TRg-1",
"CC8_BC2-SMD2-TRg-5",
"CC8_BC2-SMD2-TRg-4",
"CC8_BC2-SMD2-TRg-1",
"CC8_BC2-PRE7-TRg-4",
"CC8_BC2-PRE7-TRg-7",
"CC8_BC2-SEC6-TRg-3",
"CC8_BC2-ESF2-NRg-1",
"CC8_BC2-ESF2-NRg-3",
"CC8_BC2-AFG2-TRg-2",
"CC8_BC2-RRP36-TRg-3",
"CC8_BC2-RRP36-TRg-5",
"CC8_BC2-GCR1-NRg-2",
"CC8_BC2-PRE4-NRg-4",
"CC8_BC2-PRE4-NRg-9",
"CC8_BC2-DSN1-NRg-2",
"CC8_BC2-GPI11-TRg-3",
"CC8_BC2-POP3-TRg-1",
"CC8_BC2-MNE1-TRg-5",
"CC8_BC2-RRP12-NRg-1",
"CC8_BC2-RSC6-TRg-2",
"CC8_BC2-CDC25-TRg-1",
"CC8_BC2-CDC25-TRg-9",
"CC8_BC2-YPP1-NRg-3",
"CC8_BC2-NFS1-NRg-9",
"CC8_BC2-NFS1-NRg-8",
"CC8_BC2-UBA2-TRg-1",
"CC8_BC2-ARP2-NRg-3",
"CC8_BC2-MAK16-TRg-1",
"CC8_BC2-CEP3-NRg-1",
"CC8_BC2-GUK1-TRg-5",
"CC8_BC2-GUK1-TRg-2",
"CC8_BC2-GPI12-NRg-6",
"CC8_BC2-RPS5-NRg-5",
"CC8_BC2-RPS5-NRg-2",
"CC8_BC2-RPC19-NRg-1",
"CC8_BC2-TIM54-TRg-1",
"CC8_BC2-TEN1-TRg-2",
"CC8_BC2-SAH1-NRg-4",
"CC8_BC2-SAH1-NRg-5",
"CC8_BC2-SAH1-NRg-3",
"CC8_BC2-ATP15-NRg-5",
"CC8_BC2-SCD5-TRg-5",
"CC8_BC2-ARB1-NRg-2",
"CC8_BC2-ARB1-NRg-4",
"CC8_BC2-PUP2-TRg-1",
"CC8_BC2-CCT8-TRg-2",
"CC8_BC2-MCM4-TRg-1",
"CC8_BC2-LSM4-TRg-1",
"CC8_BC2-NOP53-NRg-1",
"CC8_BC2-ATP3-TRg-4",
"CC8_BC2-AFG2-NRg-3",
"CC8_BC2-PRO3-NRg-3",
"CC8_BC2-NRD1-NRg-10",
"CC8_BC2-SEC61-TRg-2",
"CC8_BC2-RHO3-TRg-4",
"CC8_BC2-SNF2-TRg-6",
"CC8_BC2-SMD2-NRg-3",
"CC8_BC2-RSC4-TRg-2",
"CC8_BC2-RSC4-TRg-1",
"CC8_BC2-TIF34-TRg-2",
"CC8_BC2-BET1-NRg-1",
"CC8_BC2-CDC8-NRg-2",
"CC8_BC2-PRP42-TRg-2",
"CC8_BC2-RRB1-TRg-2",
"CC8_BC2-SPC24-TRg-1",
"CC8_BC2-ILS1-NRg-1",
"CC8_BC2-GFA1-TRg-2",
"CC8_BC2-SEC21-NRg-10",
"CC8_BC2-RPC10-NRg-1",
"CC8_BC2-RPB10-TRg-3",
"CC8_BC2-RPB10-TRg-2",
"CC8_BC2-YNL181W-TRg-1",
"CC8_BC2-RAD3-NRg-1",
"CC8_BC2-NOP10-TRg-1",
"CC8_BC2-BFR2-TRg-3",
"CC8_BC2-MCM2-TRg-6",
"CC8_BC2-MCM2-TRg-4",
"CC8_BC2-MPP10-TRg-1",
"CC8_BC2-RET2-TRg-4",
"CC8_BC2-RET2-TRg-1",
"CC8_BC2-RPS2-NRg-1",
"CC8_BC2-RPS2-NRg-2",
"CC8_BC2-ORC4-NRg-3",
"CC8_BC2-TIP20-TRg-7",
"CC8_BC2-SMT3-TRg-1",
"CC8_BC2-MSS18-NRg-6",
"CC8_BC2-YEF3-NRg-9",
"CC8_BC2-ASK1-NRg-1",
"CC8_BC2-SMC1-TRg-1",
"CC8_BC2-NIP1-NRg-1",
"CC8_BC2-RPP1-NRg-1",
"CC8_BC2-YDJ1-TRg-6",
"CC8_BC2-SUB2-NRg-1",
"CC8_BC2-TIM10-NRg-8",
"CC8_BC2-TIM10-NRg-4",
"CC8_BC2-TIM10-NRg-7",
"CC8_BC2-SKI6-TRg-4",
"CC8_BC2-TUB4-TRg-1",
"CC8_BC2-CDC37-NRg-2",
"CC8_BC2-ISD11-TRg-3",
"CC8_BC2-YOS1-TRg-4",
"CC8_BC2-SSC1-TRg-6",
"CC8_BC2-MTR3-TRg-5",
"CC8_BC2-MTR3-TRg-6",
"CC8_BC2-TFA1-TRg-2",
"CC8_BC2-CDC3-NRg-3",
"CC8_BC2-ERG25-TA-18",
"CC8_BC2-RPB11-TRg-4",
"CC8_BC2-RPB11-TRg-1",
"CC8_BC2-RPB11-TRg-2",
"CC8_BC2-DED1-TRg-3",
"CC8_BC2-DED1-TRg-1",
"CC8_BC2-DED1-TRg-6",
"CC8_BC2-DED1-TRg-4",
"CC8_BC2-RPL10-NRg-5",
"CC8_BC2-RPL10-NRg-4",
"CC8_BC2-EFB1-NRg-1",
"CC8_BC2-EFB1-NRg-5",
"CC8_BC2-EFB1-NRg-4",
"CC8_BC2-RPT3-NRg-1",
"CC8_BC2-SAC6-TRg-8",
"CC8_BC2-SAC6-TRg-4",
"CC8_BC2-SAC6-TRg-5",
"CC8_BC2-SAC6-TRg-3",
"CC8_BC2-DIM1-TRg-5",
"CC8_BC2-DIM1-TRg-7",
"CC8_BC2-RPC17-NRg-1",
"CC8_BC2-RPC17-NRg-2",
"CC8_BC2-YDR341C-TRg-1",
"CC8_BC2-RAP1-NRg-8",
"CC8_BC2-RAP1-NRg-5",
"CC8_BC2-RAP1-NRg-2",
"CC8_BC2-SEC26-NRg-3",
"CC8_BC2-SPP41-TRg-3",
"CC8_BC2-TAP42-NRg-1",
"CC8_BC2-PGA2-TRg-6",
"CC8_BC2-BRL1-TRg-1",
"CC8_BC2-FOL2-TRg-1",
"CC8_BC2-NAB3-NRg-5",
"CC8_BC2-SNF4-TRg-4",
"CC8_BC2-HRR25-TRg-2",
"CC8_BC2-TRS23-TRg-4",
"CC8_BC2-CTR86-TRg-4",
"CC8_BC2-RPB5-TRg-5",
"CC8_BC2-SPN1-NRg-2",
"CC8_BC2-SPN1-NRg-1",
"CC8_BC2-SEC61-NRg-1",
"CC8_BC2-SEC61-NRg-7",
"CC8_BC2-TUS1-TRg-3",
"CC8_BC2-OLE1-NRg-2",
"CC8_BC2-AFG2-TRg-1",
"CC8_BC2-TOA2-NRg-1",
"CC8_BC2-USO1-TRg-1",
"CC8_BC2-UTP22-NRg-2",
"CC8_BC2-RIB1-TRg-3",
"CC8_BC2-RIB1-TRg-7",
"CC8_BC2-RIB1-TRg-4",
"CC8_BC2-COG1-TRg-1",
"CC8_BC2-RPL32-NRg-2",
"CC8_BC2-GLC7-NRg-3",
"CC8_BC2-GLC7-NRg-4",
"CC8_BC2-HSF1-TRg-2",
"CC8_BC2-DAM1-NRg-5",
"CC8_BC2-SEC18-TRg-4",
"CC8_BC2-SEC18-TRg-5",
"CC8_BC2-PAB1-NRg-3",
"CC8_BC2-POP8-TRg-2",
"CC8_BC2-PAB1-NRg-4",
"CC8_BC2-BIG1-TRg-4",
"CC8_BC2-BIG1-TRg-5",
"CC8_BC2-BIG1-TRg-6",
"CC8_BC2-RPO41-NRg-1",
"CC8_BC2-RVB2-NRg-2",
"CC8_BC2-PET117-NRg-8",
"CC8_BC2-VPS45-NRg-9",
"CC8_BC2-YCG1-NRg-1",
"CC8_BC2-NOC4-NRg-1",
"CC8_BC2-NMD3-NRg-2",
"CC8_BC2-DRS1-TRg-2",
"CC8_BC2-HTB1-NRg-2",
"CC8_BC2-IPI1-TRg-2",
"CC8_BC2-SEC18-NRg-1",
"CC8_BC2-SEC18-NRg-2",
"CC8_BC2-JIP5-NRg-2",
"CC8_BC2-YPT1-TRg-3",
"CC8_BC2-YPT1-TRg-2",
"CC8_BC2-CLF1-NRg-2",
"CC8_BC2-SNF2-NRg-7",
"CC8_BC2-SNF2-NRg-4",
"CC8_BC2-RPL25-NRg-1",
"CC8_BC2-NOP56-TRg-1",
"CC8_BC2-NOP56-TRg-2",
"CC8_BC2-TRS31-TRg-1",
"CC8_BC2-DBF4-TRg-2",
"CC8_BC2-DBF4-TRg-1",
"CC8_BC2-RPC19-TRg-4",
"CC8_BC2-RPC19-TRg-6",
"CC8_BC2-RPC19-TRg-3",
"CC8_BC2-ROK1-NRg-1",
"CC8_BC2-CDC33-TRg-4",
"CC8_BC2-DHR2-TRg-3",
"CC8_BC2-RRP42-NRg-5",
"CC8_BC2-CLF1-TRg-1",
"CC8_BC2-ERG11-NA-16",
"CC8_BC2-VAS1-NRg-4",
"CC8_BC2-PIK1-NRg-2",
"CC8_BC2-SAR1-NRg-7",
"CC8_BC2-SAR1-NRg-4",
"CC8_BC2-RPS3-TRg-1",
"CC8_BC2-YTM1-TRg-2",
"CC8_BC2-SUI3-NRg-5",
"CC8_BC2-SUI3-NRg-2",
"CC8_BC2-RRP7-TRg-4",
"CC8_BC2-RRP7-TRg-6",
"CC8_BC2-NIP7-TRg-2",
"CC8_BC2-MDM35-TRg-1",
"CC8_BC2-ALA1-NRg-1",
"CC8_BC2-DOA4-NRg-2",
"CC8_BC2-RPS13-NRg-1",
"CC8_BC2-YSF3-TRg-2",
"CC8_BC2-RPS2-NRg-11",
"CC8_BC2-SSL1-TRg-10",
"CC8_BC2-NIP7-TRg-1",
"CC8_BC2-LST8-NRg-1",
"CC8_BC2-TAF4-TRg-3",
"CC8_BC2-HAS1-TRg-2",
"CC8_BC2-GLC7-TRg-2",
"CC8_BC2-CDC45-NRg-1",
"CC8_BC2-SEC22-NRg-8",
"CC8_BC2-YOS1-TRg-2",
"CC8_BC2-RBA50-TRg-3",
"CC8_BC2-SPP41-NRg-2",
"CC8_BC2-PRP46-TRg-2",
"CC8_BC2-PGA2-NRg-1",
"CC8_BC2-CBF5-TRg-3",
"CC8_BC2-TCP1-NRg-3",
"CC8_BC2-TCP1-NRg-2",
"CC8_BC2-ERG26-NRg-2",
"CC8_BC2-ERG26-NRg-4",
"CC8_BC2-MES1-TRg-5",
"CC8_BC2-HTS1-TRg-2",
"CC8_BC2-SSS1-TRg-3",
"CC8_BC2-SSS1-TRg-2",
"CC8_BC2-SYS1-TRg-7",
"CC8_BC2-SYS1-TRg-2",
"CC8_BC2-SYS1-TRg-1",
"CC8_BC2-BFR2-TRg-1",
"CC8_BC2-EOS1-TRg-3",
"CC8_BC2-TAF4-NRg-1",
"CC8_BC2-ARL3-NRg-8",
"CC8_BC2-RPN5-NRg-1",
"CC8_BC2-TIM9-NRg-2",
"CC8_BC2-NUP57-NRg-3",
"CC8_BC2-VPS4-TRg-1",
"CC8_BC2-CDC3-TRg-4",
"CC8_BC2-BBP1-NRg-1",
"CC8_BC2-BBP1-NRg-2",
"CC8_BC2-USE1-NRg-3",
"CC8_BC2-CCT7-TRg-1",
"CC8_BC2-SAH1-TRg-3",
"CC8_BC2-CHS2-TRg-1",
"CC8_BC2-DPM1-TRg-2",
"CC8_BC2-BBP1-TRg-1",
"CC8_BC2-NRD1-TRg-4",
"CC8_BC2-RPB3-NRg-1",
"CC8_BC2-PHO85-NRg-6",
"CC8_BC2-SNF6-TRg-6",
"CC8_BC2-PRP38-NRg-2",
"CC8_BC2-OAR1-NRg-3",
"CC8_BC2-ROX3-NRg-1",
"CC8_BC2-YPP1-TRg-6",
"CC8_BC2-CBF2-NRg-8",
"CC8_BC2-SPT6-TRg-5",
"CC8_BC2-SEC10-NRg-1",
"CC8_BC2-NSL1-NRg-3",
"CC8_BC2-NRD1-NRg-8",
"CC8_BC2-RPB3-TRg-1",
"CC8_BC2-NRD1-NRg-4",
"CC8_BC2-RVB1-TRg-2",
"CC8_BC2-TIF5-NRg-8",
"CC8_BC2-EOS1-NRg-1",
"CC8_BC2-ERG25-NA-26",
"CC8_BC2-MSL5-NRg-4",
"CC8_BC2-SEC24-TRg-2",
"CC8_BC2-RPL30-NRg-5",
"CC8_BC2-SNU71-NRg-3",
"CC8_BC2-CDC33-NRg-1",
"CC8_BC2-RPN6-TRg-4",
"CC8_BC2-NAB2-TRg-4",
"CC8_BC2-NAB2-TRg-6",
"CC8_BC2-YTM1-NRg-1",
"CC8_BC2-OLE1-TRg-8",
"CC8_BC2-OLE1-TRg-1",
"CC8_BC2-UTP7-TRg-4",
"CC8_BC2-ACT1-NRg-6",
"CC8_BC2-RPL18A-NRg-3",
"CC8_BC2-BRX1-NRg-1",
"CC8_BC2-NAF1-TRg-8",
"CC8_BC2-NAF1-TRg-6",
"CC8_BC2-NAF1-TRg-4",
"CC8_BC2-CDC8-TRg-2",
"CC8_BC2-NSE4-TRg-1",
"CC8_BC2-PAB1-NRg-2",
"CC8_BC2-PRP43-TRg-4",
"CC8_BC2-SEC2-NRg-3",
"CC8_BC2-SEC2-NRg-6",
"CC8_BC2-MPP10-NRg-5",
"CC8_BC2-YDR355C-TRg-2",
"CC8_BC2-YLR339C-TRg-9",
"CC8_BC2-SNM1-TRg-2",
"CC8_BC2-ALR1-NRg-4",
"CC8_BC2-ALR1-NRg-1",
"CC8_BC2-ALR1-NRg-3",
"CC8_BC2-RPL10-TRg-1",
"CC8_BC2-RPL28-TRg-2",
"CC8_BC2-UTP25-TRg-1",
"CC8_BC2-POB3-TRg-1",
"CC8_BC2-POB3-TRg-3",
"CC8_BC2-POB3-TRg-2",
"CC8_BC2-MED11-TRg-1",
"CC8_BC2-ISA1-TRg-15",
"CC8_BC2-RRP1-NRg-1",
"CC8_BC2-MES1-NRg-1",
"CC8_BC2-SEC13-NRg-5",
"CC8_BC2-MCM2-NRg-2",
"CC8_BC2-ALA1-TRg-4",
"CC8_BC2-MTG2-TRg-5",
"CC8_BC2-TIF35-NRg-3",
"CC8_BC2-NSE1-TRg-3",
"CC8_BC2-NSE1-TRg-4",
"CC8_BC2-MOB2-NRg-6",
"CC8_BC2-VRG4-NRg-3",
"CC8_BC2-PRP9-TRg-3",
"CC8_BC2-HYM1-TRg-5",
"CC8_BC2-POP1-TRg-5",
"CC8_BC2-POP1-TRg-9",
"CC8_BC2-RPL17A-TRg-1",
"CC8_BC2-SLD2-TRg-1",
"CC8_BC2-CDC48-NRg-7",
"CC8_BC2-FHL1-NRg-2",
"CC8_BC2-BET3-NRg-7",
"CC8_BC2-MAK21-TRg-1",
"CC8_BC2-BRN1-TRg-4",
"CC8_BC2-FBA1-NRg-3",
"CC8_BC2-CDC42-TRg-6",
"CC8_BC2-CDC42-TRg-7",
"CC8_BC2-COG4-NRg-1",
"CC8_BC2-ATP3-NRg-3",
"CC8_BC2-ATP3-NRg-2",
"CC8_BC2-SMP3-TRg-5",
"CC8_BC2-CFT2-NRg-2",
"CC8_BC2-FAS2-TRg-5",
"CC8_BC2-DBP2-NRg-3",
"CC8_BC2-DBP2-NRg-2",
"CC8_BC2-MPS2-NRg-4",
"CC8_BC2-ARC35-TRg-2",
"CC8_BC2-ARC35-TRg-5",
"CC8_BC2-MRD1-TRg-1",
"CC8_BC2-RLP7-TRg-1",
"CC8_BC2-SPC34-TRg-1",
"CC8_BC2-CDC45-TRg-2",
"CC8_BC2-GCD6-TRg-3",
"CC8_BC2-GCD6-TRg-4",
"CC8_BC2-YPT6-NRg-2",
"CC8_BC2-RPS13-TRg-2",
"CC8_BC2-IPI3-TRg-3",
"CC8_BC2-TIF5-NRg-9",
"CC8_BC2-TIF5-NRg-7",
"CC8_BC2-TIF5-NRg-6",
"CC8_BC2-NAB3-TRg-3",
"CC8_BC2-GCD2-TRg-1",
"CC8_BC2-UBA1-TRg-2",
"CC8_BC2-SLD3-TRg-6",
"CC8_BC2-LCB1-TRg-5",
"CC8_BC2-TOA2-TRg-6",
"CC8_BC2-TOA2-TRg-1",
"CC8_BC2-TOA2-TRg-3",
"CC8_BC2-LSM2-TRg-1",
"CC8_BC2-YML6-TRg-13",
"CC8_BC2-YML6-TRg-12",
"CC8_BC2-UTP15-NRg-1",
"CC8_BC2-TIF6-NRg-8",
"CC8_BC2-SUP35-NRg-1",
"CC8_BC2-MPP10-NRg-1",
"CC8_BC2-SWI3-TRg-7",
"CC8_BC2-SSN3-NRg-2",
"CC8_BC2-SEC13-NRg-7",
"CC8_BC2-RPS15-NRg-3",
"CC8_BC2-RPL3-TRg-2",
"CC8_BC2-FBA1-NRg-2",
"CC8_BC2-FBA1-NRg-1",
"CC8_BC2-FBA1-NRg-5",
"CC8_BC2-DAM1-TRg-2",
"CC8_BC2-NHP2-TRg-2",
"CC8_BC2-HCA4-NRg-6",
"CC8_BC2-PRE3-TRg-4",
"CC8_BC2-DBP5-NRg-4",
"CC8_BC2-SPT6-NRg-4",
"CC8_BC2-SPT6-NRg-2",
"CC8_BC2-RPL18A-TRg-4",
"CC8_BC2-KSH1-TRg-1",
"CC8_BC2-KSH1-TRg-3",
"CC8_BC2-IPI3-NRg-1",
"CC8_BC2-PGA2-TRg-8",
"CC8_BC2-RPL18A-TRg-2",
"CC8_BC2-RPL33A-NRg-6",
"CC8_BC2-TAF12-NRg-2",
"CC8_BC2-USE1-TRg-5",
"CC8_BC2-YNL114C-TRg-1",
"CC8_BC2-SMC5-TRg-7",
"CC8_BC2-SMC5-TRg-6",
"CC8_BC2-RSC58-TRg-1",
"CC8_BC2-CTF13-TRg-2",
"CC8_BC2-NAB2-NRg-2",
"CC8_BC2-MCM7-TRg-4",
"CC8_BC2-BCP1-NRg-5",
"CC8_BC2-STU2-TRg-3",
"CC8_BC2-SEC21-NRg-6",
"CC8_BC2-SEC21-NRg-3",
"CC8_BC2-RPL1B-TRg-3",
"CC8_BC2-SEC20-NRg-2",
"CC8_BC2-VMA3-NRg-2",
"CC8_BC2-SEC23-NRg-5",
"CC8_BC2-CDC28-TRg-4",
"CC8_BC2-RPN12-NRg-11",
"CC8_BC2-PUP3-TRg-3",
"CC8_BC2-SEC31-TRg-2",
"CC8_BC2-SED5-TRg-6",
"CC8_BC2-SED5-TRg-5",
"CC8_BC2-RPL33A-TRg-1",
"CC8_BC2-RPL33A-TRg-2",
"CC8_BC2-MRPL11-TRg-2",
"CC8_BC2-RTP1-NRg-2",
"CC8_BC2-NUG1-TRg-2",
"CC8_BC2-VPH2-TRg-4",
"CC8_BC2-COP1-NRg-3",
"CC8_BC2-CRM1-NRg-1",
"CC8_BC2-RPL5-NRg-4",
"CC8_BC2-SNU13-NRg-4",
"CC8_BC2-PFS2-TRg-3",
"CC8_BC2-MPP10-TRg-2",
"CC8_BC2-TSR4-NRg-2",
"CC8_BC2-RSC2-TRg-1",
"CC8_BC2-SEC65-TRg-2",
"CC8_BC2-SMI1-NRg-1",
"CC8_BC2-RTT105-NRg-4",
"CC8_BC2-VMA5-TRg-3",
"CC8_BC2-VMA5-TRg-5",
"CC8_BC2-RRP1-TRg-3",
"CC8_BC2-CLC1-TRg-2",
"CC8_BC2-GCD6-NRg-1",
"CC8_BC2-GCD6-NRg-2",
"CC8_BC2-PXR1-TRg-1",
"CC8_BC2-CDC14-NRg-1",
"CC8_BC2-PCF11-TRg-6",
"CC8_BC2-PCF11-TRg-5",
"CC8_BC2-PCF11-TRg-4",
"CC8_BC2-SEC31-NRg-1",
"CC8_BC2-RRP5-NRg-1",
"CC8_BC2-PRE10-TRg-5",
"CC8_BC2-PRE10-TRg-1",
"CC8_BC2-RPS5-TRg-2",
"CC8_BC2-NSP1-TRg-4",
"CC8_BC2-PRP38-TRg-4",
"CC8_BC2-RCF1-NRg-5",
"CC8_BC2-RSC3-TRg-4",
"CC8_BC2-RSC3-TRg-5",
"CC8_BC2-RSC3-TRg-6",
"CC8_BC2-HTA1-NRg-12",
"CC8_BC2-HTA1-NRg-11",
"CC8_BC2-UTP23-TRg-2",
"CC8_BC2-GCD7-NRg-1",
"CC8_BC2-GCD7-NRg-2",
"CC8_BC2-GCD7-NRg-6",
"CC8_BC2-GAL11-NRg-2",
"CC8_BC2-GAL11-NRg-9",
"CC8_BC2-PHO4-TRg-5",
"CC8_BC2-SNP1-NRg-3",
"CC8_BC2-RPC37-TRg-5",
"CC8_BC2-CRM1-TRg-5",
"CC8_BC2-CRM1-TRg-2",
"CC8_BC2-ASK1-TRg-7",
"CC8_BC2-STU2-NRg-4",
"CC8_BC2-NEO1-NRg-3",
"CC8_BC2-GAL11-TRg-5",
"CC8_BC2-GAL11-TRg-7",
"CC8_BC2-SAM50-NRg-3",
"CC8_BC2-CSL4-TRg-2",
"CC8_BC2-CCT5-TRg-2",
"CC8_BC2-POL30-NRg-1",
"CC8_BC2-MED4-TRg-4",
"CC8_BC2-MED4-TRg-3",
"CC8_BC2-MED4-TRg-2",
"CC8_BC2-GDI1-TRg-4",
"CC8_BC2-GDI1-TRg-3",
"CC8_BC2-REB1-TRg-6",
"CC8_BC2-MRPL37-NRg-2",
"CC8_BC2-NOC3-TRg-3",
"CC8_BC2-SPC97-TRg-3",
"CC8_BC2-IPP1-TRg-3",
"CC8_BC2-IPP1-TRg-2",
"CC8_BC2-PTI1-TRg-3",
"CC8_BC2-PTI1-TRg-5",
"CC8_BC2-RFC5-NRg-1",
"CC8_BC2-CDC24-TRg-1",
"CC8_BC2-CDC24-TRg-3",
"CC8_BC2-CDC24-TRg-5",
"CC8_BC2-CDC24-TRg-6",
"CC8_BC2-UTP23-TRg-6",
"CC8_BC2-UTP23-TRg-4",
"CC8_BC2-UTP23-TRg-1",
"CC8_BC2-RHO3-NRg-4",
"CC8_BC2-TRS23-NRg-1",
"CC8_BC2-TRS23-NRg-3",
"CC8_BC2-RSP5-TRg-2",
"CC8_BC2-RSP5-TRg-1",
"CC8_BC2-SDA1-NRg-1",
"CC8_BC2-KAP95-TRg-8",
"CC8_BC2-ACO1-TRg-6",
"CC8_BC2-HTA1-NRg-3",
"CC8_BC2-HTA1-NRg-2",
"CC8_BC2-SPN1-TRg-1",
"CC8_BC2-MOT1-NRg-7",
"CC8_BC2-RPL17A-NRg-4",
"CC8_BC2-ADA2-TRg-4",
"CC8_BC2-SFH1-NRg-1",
"CC8_BC2-SPC97-NRg-5",
"CC8_BC2-PRP22-TRg-3",
"CC8_BC2-SEN15-TRg-2",
"CC8_BC2-RPL3-NRg-2",
"CC8_BC2-ISD11-NRg-2",
"CC8_BC2-HEM12-TRg-8",
"CC8_BC2-SEC10-TRg-1",
"CC8_BC2-HTB1-TRg-7",
"CC8_BC2-TTI2-TRg-1",
"CC8_BC2-ACP1-TRg-2",
"CC8_BC2-ACP1-TRg-4",
"CC8_BC2-GAL11-NRg-10",
"CC8_BC2-UTP22-TRg-2",
"CC8_BC2-MST1-NRg-5",
"CC8_BC2-RIB7-NRg-2",
"CC8_BC2-MCD1-TRg-6",
"CC8_BC2-MCD1-TRg-5",
"CC8_BC2-GPI8-NRg-2",
"CC8_BC2-THS1-TRg-2",
"CC8_BC2-RRP7-TRg-2",
"CC8_BC2-RRP7-TRg-5",
"CC8_BC2-SMX2-NRg-7",
"CC8_BC2-RRP45-TRg-5",
"CC8_BC2-RRP45-TRg-4",
"CC8_BC2-CNS1-TRg-2",
"CC8_BC2-FBP1-NRg-9",
"CC8_BC2-GCD11-NRg-1",
"CC8_BC2-RPL10-TRg-2",
"CC8_BC2-NUP192-TRg-4",
"CC8_BC2-NUP145-NRg-4",
"CC8_BC2-HEM12-TRg-6",
"CC8_BC2-PLC1-TRg-3",
"CC8_BC2-RPA43-TRg-1",
"CC8_BC2-RPB7-NRg-2",
"CC8_BC2-RPB7-NRg-3",
"CC8_BC2-NSL1-NRg-1",
"CC8_BC2-UTP6-TRg-3",
"CC8_BC2-UTP6-TRg-1",
"CC8_BC2-YJU2-TRg-5",
"CC8_BC2-FRS2-NRg-5",
"CC8_BC2-TIF35-NRg-2",
"CC8_BC2-GPI15-TRg-1",
"CC8_BC2-NOP1-NRg-5",
"CC8_BC2-GPI15-TRg-4",
"CC8_BC2-COG4-TRg-1",
"CC8_BC2-TFA1-TRg-1",
"CC8_BC2-RHO1-NRg-2",
"CC8_BC2-RHO1-NRg-1",
"CC8_BC2-CDC55-NRg-2",
"CC8_BC2-IDI1-NRg-7",
"CC8_BC2-RPL32-TRg-5",
"CC8_BC2-RPB5-TRg-4",
"CC8_BC2-DIP2-TRg-5",
"CC8_BC2-DIP2-TRg-1",
"CC8_BC2-RPC40-TRg-2",
"CC8_BC2-CDC6-TRg-5",
"CC8_BC2-CDC6-TRg-3",
"CC8_BC2-DAD2-TRg-2",
"CC8_BC2-RVS161-TRg-2",
"CC8_BC2-RVS161-TRg-1",
"CC8_BC2-SUP45-NRg-3",
"CC8_BC2-SRB6-NRg-5",
"CC8_BC2-RPC11-TRg-4",
"CC8_BC2-RKI1-TRg-8",
"CC8_BC2-NIP7-TRg-3",
"CC8_BC2-RPL33A-NRg-12",
"CC8_BC2-SAM50-TRg-4",
"CC8_BC2-NOP4-NRg-1",
"CC8_BC2-NOP4-NRg-3",
"CC8_BC2-SMX2-TRg-5",
"CC8_BC2-POL12-NRg-2",
"CC8_BC2-BMS1-NRg-2",
"CC8_BC2-RPA190-TRg-5",
"CC8_BC2-ALG14-NRg-4",
"CC8_BC2-ALG14-NRg-1",
"CC8_BC2-PRE5-NRg-1",
"CC8_BC2-BIG1-NRg-2",
"CC8_BC2-TFA2-TRg-4",
"CC8_BC2-IMP4-TRg-6",
"CC8_BC2-PAN1-NRg-1",
"CC8_BC2-UTP13-TRg-2",
"CC8_BC2-KAE1-NRg-3",
"CC8_BC2-ERG20-TRg-1",
"CC8_BC2-CDC20-TRg-6",
"CC8_BC2-PWP2-NRg-2",
"CC8_BC2-COG1-NRg-1",
"CC8_BC2-RPL1B-TRg-4",
"CC8_BC2-RPL1B-TRg-7",
"CC8_BC2-UTP20-TRg-3",
"CC8_BC2-UTP20-TRg-4",
"CC8_BC2-RPL25-TRg-4",
"CC8_BC2-RPL25-TRg-2",
"CC8_BC2-MCM7-NRg-1",
"CC8_BC2-MRP49-TRg-5",
"CC8_BC2-ERO1-NRg-3",
"CC8_BC2-UTP5-TRg-7",
"CC8_BC2-MCM4-NRg-1",
"CC8_BC2-PRE3-NRg-1",
"CC8_BC2-FCF1-NRg-1",
"CC8_BC2-CUS1-NRg-1",
"CC8_BC2-PSF1-TRg-2",
"CC8_BC2-BCP1-TRg-2",
"CC8_BC2-PAN1-TRg-1",
"CC8_BC2-PAN1-TRg-3",
"CC8_BC2-PAN1-TRg-4",
"CC8_BC2-VPS3-TRg-2",
"CC8_BC2-YIL060W-NRg-1",
"CC8_BC2-VPS53-NRg-1",
"CC8_BC2-CYR1-TRg-4",
"CC8_BC2-CYR1-TRg-7",
"CC8_BC2-MPS1-NRg-1",
"CC8_BC2-SRP1-TRg-5",
"CC8_BC2-SRP1-TRg-4",
"CC8_BC2-TAF12-TRg-2",
"CC8_BC2-TAF12-TRg-3",
"CC8_BC2-POP4-TRg-1",
"CC8_BC2-SPT16-TRg-1",
"CC8_BC2-NUP82-TRg-4",
"CC8_BC2-DML1-TRg-3",
"CC8_BC2-RPA43-NRg-3",
"CC8_BC2-STU2-NRg-3",
"CC8_BC2-POP4-NRg-4",
"CC8_BC2-MCD1-TRg-2",
"CC8_BC2-RPS3-NRg-4",
"CC8_BC2-PRP9-TRg-4",
"CC8_BC2-RPP1-NRg-2",
"CC8_BC2-MTR2-NRg-11",
"CC8_BC2-GCD11-TRg-1",
"CC8_BC2-RPF1-TRg-3",
"CC8_BC2-SUB2-NRg-4",
"CC8_BC2-GPI15-TRg-3",
"CC8_BC2-ERG9-TRg-6",
"CC8_BC2-RPT2-NRg-1",
"CC8_BC2-YOS1-NRg-3",
"CC8_BC2-SCM3-TRg-4",
"CC8_BC2-SCM3-TRg-6",
"CC8_BC2-RLP7-NRg-1",
"CC8_BC2-TFB2-NRg-4",
"CC8_BC2-IMP4-TRg-1",
"CC8_BC2-IMP4-TRg-3",
"CC8_BC2-PRE4-TRg-3",
"CC8_BC2-SUB2-TRg-3",
"CC8_BC2-RPP0-NRg-4",
"CC8_BC2-RPP0-NRg-3",
"CC8_BC2-TOM40-TRg-4",
"CC8_BC2-FUR1-NRg-12",
"CC8_BC2-TOM40-TRg-2",
"CC8_BC2-VMA11-NRg-4",
"CC8_BC2-PGS1-NRg-4",
"CC8_BC2-URB1-TRg-4",
"CC8_BC2-ARP4-TRg-3",
"CC8_BC2-RPT3-TRg-3",
"CC8_BC2-SUI3-TRg-3",
"CC8_BC2-RFC5-NRg-2",
"CC8_BC2-RRP14-TRg-2",
"CC8_BC2-SCC2-TRg-1",
"CC8_BC2-SSC1-TRg-3",
"CC8_BC2-RRP9-TRg-3",
"CC8_BC2-MOT1-NRg-9",
"CC8_BC2-RPL42A-NRg-2",
"CC8_BC2-SEC16-TRg-7",
"CC8_BC2-IMP4-NRg-2",
"CC8_BC2-YEF3-NRg-4",
"CC8_BC2-PUP1-TRg-1",
"CC8_BC2-UTP22-TRg-6",
"CC8_BC2-DBP2-NRg-4",
"CC8_BC2-PRE2-TRg-7",
"CC8_BC2-ATP16-TRg-6",
"CC8_BC2-UTP13-TRg-4",
"CC8_BC2-DOP1-NRg-4",
"CC8_BC2-TIM44-TRg-3",
"CC8_BC2-ATP16-TRg-2",
"CC8_BC2-ENP1-NRg-3",
"CC8_BC2-NAF1-TRg-3",
"CC8_BC2-COG4-TRg-2",
"CC8_BC2-SOG2-TRg-7",
"CC8_BC2-YDR341C-TRg-3",
"CC8_BC2-YMR290W-A-TRg-10",
"CC8_BC2-NUP192-NRg-9",
"CC8_BC2-RPS31-NRg-8",
"CC8_BC2-SPC97-NRg-6",
"CC8_BC2-EBP2-NRg-1",
"CC8_BC2-CDC48-TRg-5",
"CC8_BC2-RPT1-TRg-4",
"CC8_BC2-ULP1-NRg-2",
"CC8_BC2-RPN3-TRg-6",
"CC8_BC2-RPT1-TRg-5",
"CC8_BC2-KRE5-TRg-2",
"CC8_BC2-TBF1-NRg-8",
"CC8_BC2-UTP22-NRg-4",
"CC8_BC2-SSC1-NRg-4",
"CC8_BC2-REB1-TRg-4",
"CC8_BC2-CDC48-NRg-9",
"CC8_BC2-FAS2-TRg-8",
"CC8_BC2-TAO3-TRg-8",
"CC8_BC2-CKS1-TRg-5",
"CC8_BC2-YLR379W-TRg-7",
"CC8_BC2-TEN1-NRg-2",
"CC8_BC2-RPL42A-TRg-2",
"CC8_BC2-SEC27-TRg-4",
"CC8_BC2-TBF1-NRg-4",
"CC8_BC2-RPT1-NRg-6",
"CC8_BC2-COG1-TRg-3",
"CC8_BC2-SUI1-TRg-6",
"CC8_BC2-TIM23-TRg-6",
"CC8_BC2-CDC48-NRg-6",
"CC8_BC2-EPL1-TRg-5",
"CC8_BC2-RPT5-TRg-8",
"CC8_BC2-ATP16-NRg-4",
"CC8_BC2-RPN6-TRg-3",
"CC8_BC2-ERG9-NRg-6",
"CC8_BC2-SMX3-TRg-1",
"CC8_BC2-NCB2-NRg-3",
"CC8_BC2-SEC16-NRg-12",
"CC8_BC2-RPN6-TRg-2",
"CC8_BC2-REB1-NRg-4",
"CC8_BC2-ATP16-TRg-9",
"CC8_BC2-ERG9-NRg-7",
"CC16_BC2-RPL15A-NRg-4",
"CC16_BC2-RPL15A-NRg-5",
"CC16_BC2-KRE33-TRg-1",
"CC16_BC2-PMI40-NRg-1",
"CC16_BC2-NOP19-NRg-3",
"CC16_BC2-SRP14-NRg-4",
"CC16_BC2-SEC27-TRg-2",
"CC16_BC2-GPI14-TRg-3",
"CC16_BC2-PAH1-TRg-7",
"CC16_BC2-PAH1-TRg-6",
"CC16_BC2-PAH1-TRg-5",
"CC16_BC2-PAH1-TRg-3",
"CC16_BC2-COG3-TRg-1",
"CC16_BC2-HTS1-NRg-5",
"CC16_BC2-MSN5-TRg-7",
"CC16_BC2-ERG26-TRg-1",
"CC16_BC2-SMD2-TRg-5",
"CC16_BC2-SMD2-TRg-4",
"CC16_BC2-SMD2-TRg-1",
"CC16_BC2-PRE7-TRg-4",
"CC16_BC2-PRE7-TRg-7",
"CC16_BC2-SEC6-TRg-3",
"CC16_BC2-ESF2-NRg-1",
"CC16_BC2-ESF2-NRg-3",
"CC16_BC2-AFG2-TRg-2",
"CC16_BC2-RRP36-TRg-3",
"CC16_BC2-RRP36-TRg-5",
"CC16_BC2-GCR1-NRg-2",
"CC16_BC2-PRE4-NRg-4",
"CC16_BC2-PRE4-NRg-9",
"CC16_BC2-DSN1-NRg-2",
"CC16_BC2-GPI11-TRg-3",
"CC16_BC2-POP3-TRg-1",
"CC16_BC2-MNE1-TRg-5",
"CC16_BC2-RRP12-NRg-1",
"CC16_BC2-RSC6-TRg-2",
"CC16_BC2-CDC25-TRg-1",
"CC16_BC2-CDC25-TRg-9",
"CC16_BC2-YPP1-NRg-3",
"CC16_BC2-NFS1-NRg-9",
"CC16_BC2-NFS1-NRg-8",
"CC16_BC2-UBA2-TRg-1",
"CC16_BC2-ARP2-NRg-3",
"CC16_BC2-MAK16-TRg-1",
"CC16_BC2-CEP3-NRg-1",
"CC16_BC2-GUK1-TRg-5",
"CC16_BC2-GUK1-TRg-2",
"CC16_BC2-GPI12-NRg-6",
"CC16_BC2-RPS5-NRg-5",
"CC16_BC2-RPS5-NRg-2",
"CC16_BC2-RPC19-NRg-1",
"CC16_BC2-TIM54-TRg-1",
"CC16_BC2-TEN1-TRg-2",
"CC16_BC2-SAH1-NRg-4",
"CC16_BC2-SAH1-NRg-5",
"CC16_BC2-SAH1-NRg-3",
"CC16_BC2-ATP15-NRg-5",
"CC16_BC2-SCD5-TRg-5",
"CC16_BC2-ARB1-NRg-2",
"CC16_BC2-ARB1-NRg-4",
"CC16_BC2-PUP2-TRg-1",
"CC16_BC2-CCT8-TRg-2",
"CC16_BC2-MCM4-TRg-1",
"CC16_BC2-LSM4-TRg-1",
"CC16_BC2-NOP53-NRg-1",
"CC16_BC2-ATP3-TRg-4",
"CC16_BC2-AFG2-NRg-3",
"CC16_BC2-PRO3-NRg-3",
"CC16_BC2-NRD1-NRg-10",
"CC16_BC2-SEC61-TRg-2",
"CC16_BC2-RHO3-TRg-4",
"CC16_BC2-SNF2-TRg-6",
"CC16_BC2-SMD2-NRg-3",
"CC16_BC2-RSC4-TRg-2",
"CC16_BC2-RSC4-TRg-1",
"CC16_BC2-TIF34-TRg-2",
"CC16_BC2-BET1-NRg-1",
"CC16_BC2-CDC8-NRg-2",
"CC16_BC2-PRP42-TRg-2",
"CC16_BC2-RRB1-TRg-2",
"CC16_BC2-SPC24-TRg-1",
"CC16_BC2-ILS1-NRg-1",
"CC16_BC2-GFA1-TRg-2",
"CC16_BC2-SEC21-NRg-10",
"CC16_BC2-RPC10-NRg-1",
"CC16_BC2-RPB10-TRg-3",
"CC16_BC2-RPB10-TRg-2",
"CC16_BC2-YNL181W-TRg-1",
"CC16_BC2-RAD3-NRg-1",
"CC16_BC2-NOP10-TRg-1",
"CC16_BC2-BFR2-TRg-3",
"CC16_BC2-MCM2-TRg-6",
"CC16_BC2-MCM2-TRg-4",
"CC16_BC2-MPP10-TRg-1",
"CC16_BC2-RET2-TRg-4",
"CC16_BC2-RET2-TRg-1",
"CC16_BC2-RPS2-NRg-1",
"CC16_BC2-RPS2-NRg-2",
"CC16_BC2-ORC4-NRg-3",
"CC16_BC2-TIP20-TRg-7",
"CC16_BC2-SMT3-TRg-1",
"CC16_BC2-MSS18-NRg-6",
"CC16_BC2-YEF3-NRg-9",
"CC16_BC2-ASK1-NRg-1",
"CC16_BC2-SMC1-TRg-1",
"CC16_BC2-NIP1-NRg-1",
"CC16_BC2-RPP1-NRg-1",
"CC16_BC2-YDJ1-TRg-6",
"CC16_BC2-SUB2-NRg-1",
"CC16_BC2-TIM10-NRg-8",
"CC16_BC2-TIM10-NRg-4",
"CC16_BC2-TIM10-NRg-7",
"CC16_BC2-SKI6-TRg-4",
"CC16_BC2-TUB4-TRg-1",
"CC16_BC2-CDC37-NRg-2",
"CC16_BC2-ISD11-TRg-3",
"CC16_BC2-YOS1-TRg-4",
"CC16_BC2-SSC1-TRg-6",
"CC16_BC2-MTR3-TRg-5",
"CC16_BC2-MTR3-TRg-6",
"CC16_BC2-TFA1-TRg-2",
"CC16_BC2-CDC3-NRg-3",
"CC16_BC2-ERG25-TA-18",
"CC16_BC2-RPB11-TRg-4",
"CC16_BC2-RPB11-TRg-1",
"CC16_BC2-RPB11-TRg-2",
"CC16_BC2-DED1-TRg-3",
"CC16_BC2-DED1-TRg-1",
"CC16_BC2-DED1-TRg-6",
"CC16_BC2-DED1-TRg-4",
"CC16_BC2-RPL10-NRg-5",
"CC16_BC2-RPL10-NRg-4",
"CC16_BC2-EFB1-NRg-1",
"CC16_BC2-EFB1-NRg-5",
"CC16_BC2-EFB1-NRg-4",
"CC16_BC2-RPT3-NRg-1",
"CC16_BC2-SAC6-TRg-8",
"CC16_BC2-SAC6-TRg-4",
"CC16_BC2-SAC6-TRg-5",
"CC16_BC2-SAC6-TRg-3",
"CC16_BC2-DIM1-TRg-5",
"CC16_BC2-DIM1-TRg-7",
"CC16_BC2-RPC17-NRg-1",
"CC16_BC2-RPC17-NRg-2",
"CC16_BC2-YDR341C-TRg-1",
"CC16_BC2-RAP1-NRg-8",
"CC16_BC2-RAP1-NRg-5",
"CC16_BC2-RAP1-NRg-2",
"CC16_BC2-SEC26-NRg-3",
"CC16_BC2-SPP41-TRg-3",
"CC16_BC2-TAP42-NRg-1",
"CC16_BC2-PGA2-TRg-6",
"CC16_BC2-BRL1-TRg-1",
"CC16_BC2-FOL2-TRg-1",
"CC16_BC2-NAB3-NRg-5",
"CC16_BC2-SNF4-TRg-4",
"CC16_BC2-HRR25-TRg-2",
"CC16_BC2-TRS23-TRg-4",
"CC16_BC2-CTR86-TRg-4",
"CC16_BC2-RPB5-TRg-5",
"CC16_BC2-SPN1-NRg-2",
"CC16_BC2-SPN1-NRg-1",
"CC16_BC2-SEC61-NRg-1",
"CC16_BC2-SEC61-NRg-7",
"CC16_BC2-TUS1-TRg-3",
"CC16_BC2-OLE1-NRg-2",
"CC16_BC2-AFG2-TRg-1",
"CC16_BC2-TOA2-NRg-1",
"CC16_BC2-USO1-TRg-1",
"CC16_BC2-UTP22-NRg-2",
"CC16_BC2-RIB1-TRg-3",
"CC16_BC2-RIB1-TRg-7",
"CC16_BC2-RIB1-TRg-4",
"CC16_BC2-COG1-TRg-1",
"CC16_BC2-RPL32-NRg-2",
"CC16_BC2-GLC7-NRg-3",
"CC16_BC2-GLC7-NRg-4",
"CC16_BC2-HSF1-TRg-2",
"CC16_BC2-DAM1-NRg-5",
"CC16_BC2-SEC18-TRg-4",
"CC16_BC2-SEC18-TRg-5",
"CC16_BC2-PAB1-NRg-3",
"CC16_BC2-POP8-TRg-2",
"CC16_BC2-PAB1-NRg-4",
"CC16_BC2-BIG1-TRg-4",
"CC16_BC2-BIG1-TRg-5",
"CC16_BC2-BIG1-TRg-6",
"CC16_BC2-RPO41-NRg-1",
"CC16_BC2-RVB2-NRg-2",
"CC16_BC2-PET117-NRg-8",
"CC16_BC2-VPS45-NRg-9",
"CC16_BC2-YCG1-NRg-1",
"CC16_BC2-NOC4-NRg-1",
"CC16_BC2-NMD3-NRg-2",
"CC16_BC2-DRS1-TRg-2",
"CC16_BC2-HTB1-NRg-2",
"CC16_BC2-IPI1-TRg-2",
"CC16_BC2-SEC18-NRg-1",
"CC16_BC2-SEC18-NRg-2",
"CC16_BC2-JIP5-NRg-2",
"CC16_BC2-YPT1-TRg-3",
"CC16_BC2-YPT1-TRg-2",
"CC16_BC2-CLF1-NRg-2",
"CC16_BC2-SNF2-NRg-7",
"CC16_BC2-SNF2-NRg-4",
"CC16_BC2-RPL25-NRg-1",
"CC16_BC2-NOP56-TRg-1",
"CC16_BC2-NOP56-TRg-2",
"CC16_BC2-TRS31-TRg-1",
"CC16_BC2-DBF4-TRg-2",
"CC16_BC2-DBF4-TRg-1",
"CC16_BC2-RPC19-TRg-4",
"CC16_BC2-RPC19-TRg-6",
"CC16_BC2-RPC19-TRg-3",
"CC16_BC2-ROK1-NRg-1",
"CC16_BC2-CDC33-TRg-4",
"CC16_BC2-DHR2-TRg-3",
"CC16_BC2-RRP42-NRg-5",
"CC16_BC2-CLF1-TRg-1",
"CC16_BC2-ERG11-NA-16",
"CC16_BC2-VAS1-NRg-4",
"CC16_BC2-PIK1-NRg-2",
"CC16_BC2-SAR1-NRg-7",
"CC16_BC2-SAR1-NRg-4",
"CC16_BC2-RPS3-TRg-1",
"CC16_BC2-YTM1-TRg-2",
"CC16_BC2-SUI3-NRg-5",
"CC16_BC2-SUI3-NRg-2",
"CC16_BC2-RRP7-TRg-4",
"CC16_BC2-RRP7-TRg-6",
"CC16_BC2-NIP7-TRg-2",
"CC16_BC2-MDM35-TRg-1",
"CC16_BC2-ALA1-NRg-1",
"CC16_BC2-DOA4-NRg-2",
"CC16_BC2-RPS13-NRg-1",
"CC16_BC2-YSF3-TRg-2",
"CC16_BC2-RPS2-NRg-11",
"CC16_BC2-SSL1-TRg-10",
"CC16_BC2-NIP7-TRg-1",
"CC16_BC2-LST8-NRg-1",
"CC16_BC2-TAF4-TRg-3",
"CC16_BC2-HAS1-TRg-2",
"CC16_BC2-GLC7-TRg-2",
"CC16_BC2-CDC45-NRg-1",
"CC16_BC2-SEC22-NRg-8",
"CC16_BC2-YOS1-TRg-2",
"CC16_BC2-RBA50-TRg-3",
"CC16_BC2-SPP41-NRg-2",
"CC16_BC2-PRP46-TRg-2",
"CC16_BC2-PGA2-NRg-1",
"CC16_BC2-CBF5-TRg-3",
"CC16_BC2-TCP1-NRg-3",
"CC16_BC2-TCP1-NRg-2",
"CC16_BC2-ERG26-NRg-2",
"CC16_BC2-ERG26-NRg-4",
"CC16_BC2-MES1-TRg-5",
"CC16_BC2-HTS1-TRg-2",
"CC16_BC2-SSS1-TRg-3",
"CC16_BC2-SSS1-TRg-2",
"CC16_BC2-SYS1-TRg-7",
"CC16_BC2-SYS1-TRg-2",
"CC16_BC2-SYS1-TRg-1",
"CC16_BC2-BFR2-TRg-1",
"CC16_BC2-EOS1-TRg-3",
"CC16_BC2-TAF4-NRg-1",
"CC16_BC2-ARL3-NRg-8",
"CC16_BC2-RPN5-NRg-1",
"CC16_BC2-TIM9-NRg-2",
"CC16_BC2-NUP57-NRg-3",
"CC16_BC2-VPS4-TRg-1",
"CC16_BC2-CDC3-TRg-4",
"CC16_BC2-BBP1-NRg-1",
"CC16_BC2-BBP1-NRg-2",
"CC16_BC2-USE1-NRg-3",
"CC16_BC2-CCT7-TRg-1",
"CC16_BC2-SAH1-TRg-3",
"CC16_BC2-CHS2-TRg-1",
"CC16_BC2-DPM1-TRg-2",
"CC16_BC2-BBP1-TRg-1",
"CC16_BC2-NRD1-TRg-4",
"CC16_BC2-RPB3-NRg-1",
"CC16_BC2-PHO85-NRg-6",
"CC16_BC2-SNF6-TRg-6",
"CC16_BC2-PRP38-NRg-2",
"CC16_BC2-OAR1-NRg-3",
"CC16_BC2-ROX3-NRg-1",
"CC16_BC2-YPP1-TRg-6",
"CC16_BC2-CBF2-NRg-8",
"CC16_BC2-SPT6-TRg-5",
"CC16_BC2-SEC10-NRg-1",
"CC16_BC2-NSL1-NRg-3",
"CC16_BC2-NRD1-NRg-8",
"CC16_BC2-RPB3-TRg-1",
"CC16_BC2-NRD1-NRg-4",
"CC16_BC2-RVB1-TRg-2",
"CC16_BC2-TIF5-NRg-8",
"CC16_BC2-EOS1-NRg-1",
"CC16_BC2-ERG25-NA-26",
"CC16_BC2-MSL5-NRg-4",
"CC16_BC2-SEC24-TRg-2",
"CC16_BC2-RPL30-NRg-5",
"CC16_BC2-SNU71-NRg-3",
"CC16_BC2-CDC33-NRg-1",
"CC16_BC2-RPN6-TRg-4",
"CC16_BC2-NAB2-TRg-4",
"CC16_BC2-NAB2-TRg-6",
"CC16_BC2-YTM1-NRg-1",
"CC16_BC2-OLE1-TRg-8",
"CC16_BC2-OLE1-TRg-1",
"CC16_BC2-UTP7-TRg-4",
"CC16_BC2-ACT1-NRg-6",
"CC16_BC2-RPL18A-NRg-3",
"CC16_BC2-BRX1-NRg-1",
"CC16_BC2-NAF1-TRg-8",
"CC16_BC2-NAF1-TRg-6",
"CC16_BC2-NAF1-TRg-4",
"CC16_BC2-CDC8-TRg-2",
"CC16_BC2-NSE4-TRg-1",
"CC16_BC2-PAB1-NRg-2",
"CC16_BC2-PRP43-TRg-4",
"CC16_BC2-SEC2-NRg-3",
"CC16_BC2-SEC2-NRg-6",
"CC16_BC2-MPP10-NRg-5",
"CC16_BC2-YDR355C-TRg-2",
"CC16_BC2-YLR339C-TRg-9",
"CC16_BC2-SNM1-TRg-2",
"CC16_BC2-ALR1-NRg-4",
"CC16_BC2-ALR1-NRg-1",
"CC16_BC2-ALR1-NRg-3",
"CC16_BC2-RPL10-TRg-1",
"CC16_BC2-RPL28-TRg-2",
"CC16_BC2-UTP25-TRg-1",
"CC16_BC2-POB3-TRg-1",
"CC16_BC2-POB3-TRg-3",
"CC16_BC2-POB3-TRg-2",
"CC16_BC2-MED11-TRg-1",
"CC16_BC2-ISA1-TRg-15",
"CC16_BC2-RRP1-NRg-1",
"CC16_BC2-MES1-NRg-1",
"CC16_BC2-SEC13-NRg-5",
"CC16_BC2-MCM2-NRg-2",
"CC16_BC2-ALA1-TRg-4",
"CC16_BC2-MTG2-TRg-5",
"CC16_BC2-TIF35-NRg-3",
"CC16_BC2-NSE1-TRg-3",
"CC16_BC2-NSE1-TRg-4",
"CC16_BC2-MOB2-NRg-6",
"CC16_BC2-VRG4-NRg-3",
"CC16_BC2-PRP9-TRg-3",
"CC16_BC2-HYM1-TRg-5",
"CC16_BC2-POP1-TRg-5",
"CC16_BC2-POP1-TRg-9",
"CC16_BC2-RPL17A-TRg-1",
"CC16_BC2-SLD2-TRg-1",
"CC16_BC2-CDC48-NRg-7",
"CC16_BC2-FHL1-NRg-2",
"CC16_BC2-BET3-NRg-7",
"CC16_BC2-MAK21-TRg-1",
"CC16_BC2-BRN1-TRg-4",
"CC16_BC2-FBA1-NRg-3",
"CC16_BC2-CDC42-TRg-6",
"CC16_BC2-CDC42-TRg-7",
"CC16_BC2-COG4-NRg-1",
"CC16_BC2-ATP3-NRg-3",
"CC16_BC2-ATP3-NRg-2",
"CC16_BC2-SMP3-TRg-5",
"CC16_BC2-CFT2-NRg-2",
"CC16_BC2-FAS2-TRg-5",
"CC16_BC2-DBP2-NRg-3",
"CC16_BC2-DBP2-NRg-2",
"CC16_BC2-MPS2-NRg-4",
"CC16_BC2-ARC35-TRg-2",
"CC16_BC2-ARC35-TRg-5",
"CC16_BC2-MRD1-TRg-1",
"CC16_BC2-RLP7-TRg-1",
"CC16_BC2-SPC34-TRg-1",
"CC16_BC2-CDC45-TRg-2",
"CC16_BC2-GCD6-TRg-3",
"CC16_BC2-GCD6-TRg-4",
"CC16_BC2-YPT6-NRg-2",
"CC16_BC2-RPS13-TRg-2",
"CC16_BC2-IPI3-TRg-3",
"CC16_BC2-TIF5-NRg-9",
"CC16_BC2-TIF5-NRg-7",
"CC16_BC2-TIF5-NRg-6",
"CC16_BC2-NAB3-TRg-3",
"CC16_BC2-GCD2-TRg-1",
"CC16_BC2-UBA1-TRg-2",
"CC16_BC2-SLD3-TRg-6",
"CC16_BC2-LCB1-TRg-5",
"CC16_BC2-TOA2-TRg-6",
"CC16_BC2-TOA2-TRg-1",
"CC16_BC2-TOA2-TRg-3",
"CC16_BC2-LSM2-TRg-1",
"CC16_BC2-YML6-TRg-13",
"CC16_BC2-YML6-TRg-12",
"CC16_BC2-UTP15-NRg-1",
"CC16_BC2-TIF6-NRg-8",
"CC16_BC2-SUP35-NRg-1",
"CC16_BC2-MPP10-NRg-1",
"CC16_BC2-SWI3-TRg-7",
"CC16_BC2-SSN3-NRg-2",
"CC16_BC2-SEC13-NRg-7",
"CC16_BC2-RPS15-NRg-3",
"CC16_BC2-RPL3-TRg-2",
"CC16_BC2-FBA1-NRg-2",
"CC16_BC2-FBA1-NRg-1",
"CC16_BC2-FBA1-NRg-5",
"CC16_BC2-DAM1-TRg-2",
"CC16_BC2-NHP2-TRg-2",
"CC16_BC2-HCA4-NRg-6",
"CC16_BC2-PRE3-TRg-4",
"CC16_BC2-DBP5-NRg-4",
"CC16_BC2-SPT6-NRg-4",
"CC16_BC2-SPT6-NRg-2",
"CC16_BC2-RPL18A-TRg-4",
"CC16_BC2-KSH1-TRg-1",
"CC16_BC2-KSH1-TRg-3",
"CC16_BC2-IPI3-NRg-1",
"CC16_BC2-PGA2-TRg-8",
"CC16_BC2-RPL18A-TRg-2",
"CC16_BC2-RPL33A-NRg-6",
"CC16_BC2-TAF12-NRg-2",
"CC16_BC2-USE1-TRg-5",
"CC16_BC2-YNL114C-TRg-1",
"CC16_BC2-SMC5-TRg-7",
"CC16_BC2-SMC5-TRg-6",
"CC16_BC2-RSC58-TRg-1",
"CC16_BC2-CTF13-TRg-2",
"CC16_BC2-NAB2-NRg-2",
"CC16_BC2-MCM7-TRg-4",
"CC16_BC2-BCP1-NRg-5",
"CC16_BC2-STU2-TRg-3",
"CC16_BC2-SEC21-NRg-6",
"CC16_BC2-SEC21-NRg-3",
"CC16_BC2-RPL1B-TRg-3",
"CC16_BC2-SEC20-NRg-2",
"CC16_BC2-VMA3-NRg-2",
"CC16_BC2-SEC23-NRg-5",
"CC16_BC2-CDC28-TRg-4",
"CC16_BC2-RPN12-NRg-11",
"CC16_BC2-PUP3-TRg-3",
"CC16_BC2-SEC31-TRg-2",
"CC16_BC2-SED5-TRg-6",
"CC16_BC2-SED5-TRg-5",
"CC16_BC2-RPL33A-TRg-1",
"CC16_BC2-RPL33A-TRg-2",
"CC16_BC2-MRPL11-TRg-2",
"CC16_BC2-RTP1-NRg-2",
"CC16_BC2-NUG1-TRg-2",
"CC16_BC2-VPH2-TRg-4",
"CC16_BC2-COP1-NRg-3",
"CC16_BC2-CRM1-NRg-1",
"CC16_BC2-RPL5-NRg-4",
"CC16_BC2-SNU13-NRg-4",
"CC16_BC2-PFS2-TRg-3",
"CC16_BC2-MPP10-TRg-2",
"CC16_BC2-TSR4-NRg-2",
"CC16_BC2-RSC2-TRg-1",
"CC16_BC2-SEC65-TRg-2",
"CC16_BC2-SMI1-NRg-1",
"CC16_BC2-RTT105-NRg-4",
"CC16_BC2-VMA5-TRg-3",
"CC16_BC2-VMA5-TRg-5",
"CC16_BC2-RRP1-TRg-3",
"CC16_BC2-CLC1-TRg-2",
"CC16_BC2-GCD6-NRg-1",
"CC16_BC2-GCD6-NRg-2",
"CC16_BC2-PXR1-TRg-1",
"CC16_BC2-CDC14-NRg-1",
"CC16_BC2-PCF11-TRg-6",
"CC16_BC2-PCF11-TRg-5",
"CC16_BC2-PCF11-TRg-4",
"CC16_BC2-SEC31-NRg-1",
"CC16_BC2-RRP5-NRg-1",
"CC16_BC2-PRE10-TRg-5",
"CC16_BC2-PRE10-TRg-1",
"CC16_BC2-RPS5-TRg-2",
"CC16_BC2-NSP1-TRg-4",
"CC16_BC2-PRP38-TRg-4",
"CC16_BC2-RCF1-NRg-5",
"CC16_BC2-RSC3-TRg-4",
"CC16_BC2-RSC3-TRg-5",
"CC16_BC2-RSC3-TRg-6",
"CC16_BC2-HTA1-NRg-12",
"CC16_BC2-HTA1-NRg-11",
"CC16_BC2-UTP23-TRg-2",
"CC16_BC2-GCD7-NRg-1",
"CC16_BC2-GCD7-NRg-2",
"CC16_BC2-GCD7-NRg-6",
"CC16_BC2-GAL11-NRg-2",
"CC16_BC2-GAL11-NRg-9",
"CC16_BC2-PHO4-TRg-5",
"CC16_BC2-SNP1-NRg-3",
"CC16_BC2-RPC37-TRg-5",
"CC16_BC2-CRM1-TRg-5",
"CC16_BC2-CRM1-TRg-2",
"CC16_BC2-ASK1-TRg-7",
"CC16_BC2-STU2-NRg-4",
"CC16_BC2-NEO1-NRg-3",
"CC16_BC2-GAL11-TRg-5",
"CC16_BC2-GAL11-TRg-7",
"CC16_BC2-SAM50-NRg-3",
"CC16_BC2-CSL4-TRg-2",
"CC16_BC2-CCT5-TRg-2",
"CC16_BC2-POL30-NRg-1",
"CC16_BC2-MED4-TRg-4",
"CC16_BC2-MED4-TRg-3",
"CC16_BC2-MED4-TRg-2",
"CC16_BC2-GDI1-TRg-4",
"CC16_BC2-GDI1-TRg-3",
"CC16_BC2-REB1-TRg-6",
"CC16_BC2-MRPL37-NRg-2",
"CC16_BC2-NOC3-TRg-3",
"CC16_BC2-SPC97-TRg-3",
"CC16_BC2-IPP1-TRg-3",
"CC16_BC2-IPP1-TRg-2",
"CC16_BC2-PTI1-TRg-3",
"CC16_BC2-PTI1-TRg-5",
"CC16_BC2-RFC5-NRg-1",
"CC16_BC2-CDC24-TRg-1",
"CC16_BC2-CDC24-TRg-3",
"CC16_BC2-CDC24-TRg-5",
"CC16_BC2-CDC24-TRg-6",
"CC16_BC2-UTP23-TRg-6",
"CC16_BC2-UTP23-TRg-4",
"CC16_BC2-UTP23-TRg-1",
"CC16_BC2-RHO3-NRg-4",
"CC16_BC2-TRS23-NRg-1",
"CC16_BC2-TRS23-NRg-3",
"CC16_BC2-RSP5-TRg-2",
"CC16_BC2-RSP5-TRg-1",
"CC16_BC2-SDA1-NRg-1",
"CC16_BC2-KAP95-TRg-8",
"CC16_BC2-ACO1-TRg-6",
"CC16_BC2-HTA1-NRg-3",
"CC16_BC2-HTA1-NRg-2",
"CC16_BC2-SPN1-TRg-1",
"CC16_BC2-MOT1-NRg-7",
"CC16_BC2-RPL17A-NRg-4",
"CC16_BC2-ADA2-TRg-4",
"CC16_BC2-SFH1-NRg-1",
"CC16_BC2-SPC97-NRg-5",
"CC16_BC2-PRP22-TRg-3",
"CC16_BC2-SEN15-TRg-2",
"CC16_BC2-RPL3-NRg-2",
"CC16_BC2-ISD11-NRg-2",
"CC16_BC2-HEM12-TRg-8",
"CC16_BC2-SEC10-TRg-1",
"CC16_BC2-HTB1-TRg-7",
"CC16_BC2-TTI2-TRg-1",
"CC16_BC2-ACP1-TRg-2",
"CC16_BC2-ACP1-TRg-4",
"CC16_BC2-GAL11-NRg-10",
"CC16_BC2-UTP22-TRg-2",
"CC16_BC2-MST1-NRg-5",
"CC16_BC2-RIB7-NRg-2",
"CC16_BC2-MCD1-TRg-6",
"CC16_BC2-MCD1-TRg-5",
"CC16_BC2-GPI8-NRg-2",
"CC16_BC2-THS1-TRg-2",
"CC16_BC2-RRP7-TRg-2",
"CC16_BC2-RRP7-TRg-5",
"CC16_BC2-SMX2-NRg-7",
"CC16_BC2-RRP45-TRg-5",
"CC16_BC2-RRP45-TRg-4",
"CC16_BC2-CNS1-TRg-2",
"CC16_BC2-FBP1-NRg-9",
"CC16_BC2-GCD11-NRg-1",
"CC16_BC2-RPL10-TRg-2",
"CC16_BC2-NUP192-TRg-4",
"CC16_BC2-NUP145-NRg-4",
"CC16_BC2-HEM12-TRg-6",
"CC16_BC2-PLC1-TRg-3",
"CC16_BC2-RPA43-TRg-1",
"CC16_BC2-RPB7-NRg-2",
"CC16_BC2-RPB7-NRg-3",
"CC16_BC2-NSL1-NRg-1",
"CC16_BC2-UTP6-TRg-3",
"CC16_BC2-UTP6-TRg-1",
"CC16_BC2-YJU2-TRg-5",
"CC16_BC2-FRS2-NRg-5",
"CC16_BC2-TIF35-NRg-2",
"CC16_BC2-GPI15-TRg-1",
"CC16_BC2-NOP1-NRg-5",
"CC16_BC2-GPI15-TRg-4",
"CC16_BC2-COG4-TRg-1",
"CC16_BC2-TFA1-TRg-1",
"CC16_BC2-RHO1-NRg-2",
"CC16_BC2-RHO1-NRg-1",
"CC16_BC2-CDC55-NRg-2",
"CC16_BC2-IDI1-NRg-7",
"CC16_BC2-RPL32-TRg-5",
"CC16_BC2-RPB5-TRg-4",
"CC16_BC2-DIP2-TRg-5",
"CC16_BC2-DIP2-TRg-1",
"CC16_BC2-RPC40-TRg-2",
"CC16_BC2-CDC6-TRg-5",
"CC16_BC2-CDC6-TRg-3",
"CC16_BC2-DAD2-TRg-2",
"CC16_BC2-RVS161-TRg-2",
"CC16_BC2-RVS161-TRg-1",
"CC16_BC2-SUP45-NRg-3",
"CC16_BC2-SRB6-NRg-5",
"CC16_BC2-RPC11-TRg-4",
"CC16_BC2-RKI1-TRg-8",
"CC16_BC2-NIP7-TRg-3",
"CC16_BC2-RPL33A-NRg-12",
"CC16_BC2-SAM50-TRg-4",
"CC16_BC2-NOP4-NRg-1",
"CC16_BC2-NOP4-NRg-3",
"CC16_BC2-SMX2-TRg-5",
"CC16_BC2-POL12-NRg-2",
"CC16_BC2-BMS1-NRg-2",
"CC16_BC2-RPA190-TRg-5",
"CC16_BC2-ALG14-NRg-4",
"CC16_BC2-ALG14-NRg-1",
"CC16_BC2-PRE5-NRg-1",
"CC16_BC2-BIG1-NRg-2",
"CC16_BC2-TFA2-TRg-4",
"CC16_BC2-IMP4-TRg-6",
"CC16_BC2-PAN1-NRg-1",
"CC16_BC2-UTP13-TRg-2",
"CC16_BC2-KAE1-NRg-3",
"CC16_BC2-ERG20-TRg-1",
"CC16_BC2-CDC20-TRg-6",
"CC16_BC2-PWP2-NRg-2",
"CC16_BC2-COG1-NRg-1",
"CC16_BC2-RPL1B-TRg-4",
"CC16_BC2-RPL1B-TRg-7",
"CC16_BC2-UTP20-TRg-3",
"CC16_BC2-UTP20-TRg-4",
"CC16_BC2-RPL25-TRg-4",
"CC16_BC2-RPL25-TRg-2",
"CC16_BC2-MCM7-NRg-1",
"CC16_BC2-MRP49-TRg-5",
"CC16_BC2-ERO1-NRg-3",
"CC16_BC2-UTP5-TRg-7",
"CC16_BC2-MCM4-NRg-1",
"CC16_BC2-PRE3-NRg-1",
"CC16_BC2-FCF1-NRg-1",
"CC16_BC2-CUS1-NRg-1",
"CC16_BC2-PSF1-TRg-2",
"CC16_BC2-BCP1-TRg-2",
"CC16_BC2-PAN1-TRg-1",
"CC16_BC2-PAN1-TRg-3",
"CC16_BC2-PAN1-TRg-4",
"CC16_BC2-VPS3-TRg-2",
"CC16_BC2-YIL060W-NRg-1",
"CC16_BC2-VPS53-NRg-1",
"CC16_BC2-CYR1-TRg-4",
"CC16_BC2-CYR1-TRg-7",
"CC16_BC2-MPS1-NRg-1",
"CC16_BC2-SRP1-TRg-5",
"CC16_BC2-SRP1-TRg-4",
"CC16_BC2-TAF12-TRg-2",
"CC16_BC2-TAF12-TRg-3",
"CC16_BC2-POP4-TRg-1",
"CC16_BC2-SPT16-TRg-1",
"CC16_BC2-NUP82-TRg-4",
"CC16_BC2-DML1-TRg-3",
"CC16_BC2-RPA43-NRg-3",
"CC16_BC2-STU2-NRg-3",
"CC16_BC2-POP4-NRg-4",
"CC16_BC2-MCD1-TRg-2",
"CC16_BC2-RPS3-NRg-4",
"CC16_BC2-PRP9-TRg-4",
"CC16_BC2-RPP1-NRg-2",
"CC16_BC2-MTR2-NRg-11",
"CC16_BC2-GCD11-TRg-1",
"CC16_BC2-RPF1-TRg-3",
"CC16_BC2-SUB2-NRg-4",
"CC16_BC2-GPI15-TRg-3",
"CC16_BC2-ERG9-TRg-6",
"CC16_BC2-RPT2-NRg-1",
"CC16_BC2-YOS1-NRg-3",
"CC16_BC2-SCM3-TRg-4",
"CC16_BC2-SCM3-TRg-6",
"CC16_BC2-RLP7-NRg-1",
"CC16_BC2-TFB2-NRg-4",
"CC16_BC2-IMP4-TRg-1",
"CC16_BC2-IMP4-TRg-3",
"CC16_BC2-PRE4-TRg-3",
"CC16_BC2-SUB2-TRg-3",
"CC16_BC2-RPP0-NRg-4",
"CC16_BC2-RPP0-NRg-3",
"CC16_BC2-TOM40-TRg-4",
"CC16_BC2-FUR1-NRg-12",
"CC16_BC2-TOM40-TRg-2",
"CC16_BC2-VMA11-NRg-4",
"CC16_BC2-PGS1-NRg-4",
"CC16_BC2-URB1-TRg-4",
"CC16_BC2-ARP4-TRg-3",
"CC16_BC2-RPT3-TRg-3",
"CC16_BC2-SUI3-TRg-3",
"CC16_BC2-RFC5-NRg-2",
"CC16_BC2-RRP14-TRg-2",
"CC16_BC2-SCC2-TRg-1",
"CC16_BC2-SSC1-TRg-3",
"CC16_BC2-RRP9-TRg-3",
"CC16_BC2-MOT1-NRg-9",
"CC16_BC2-RPL42A-NRg-2",
"CC16_BC2-SEC16-TRg-7",
"CC16_BC2-IMP4-NRg-2",
"CC16_BC2-YEF3-NRg-4",
"CC16_BC2-PUP1-TRg-1",
"CC16_BC2-UTP22-TRg-6",
"CC16_BC2-DBP2-NRg-4",
"CC16_BC2-PRE2-TRg-7",
"CC16_BC2-ATP16-TRg-6",
"CC16_BC2-UTP13-TRg-4",
"CC16_BC2-DOP1-NRg-4",
"CC16_BC2-TIM44-TRg-3",
"CC16_BC2-ATP16-TRg-2",
"CC16_BC2-ENP1-NRg-3",
"CC16_BC2-NAF1-TRg-3",
"CC16_BC2-COG4-TRg-2",
"CC16_BC2-SOG2-TRg-7",
"CC16_BC2-YDR341C-TRg-3",
"CC16_BC2-YMR290W-A-TRg-10",
"CC16_BC2-NUP192-NRg-9",
"CC16_BC2-RPS31-NRg-8",
"CC16_BC2-SPC97-NRg-6",
"CC16_BC2-EBP2-NRg-1",
"CC16_BC2-CDC48-TRg-5",
"CC16_BC2-RPT1-TRg-4",
"CC16_BC2-ULP1-NRg-2",
"CC16_BC2-RPN3-TRg-6",
"CC16_BC2-RPT1-TRg-5",
"CC16_BC2-KRE5-TRg-2",
"CC16_BC2-TBF1-NRg-8",
"CC16_BC2-UTP22-NRg-4",
"CC16_BC2-SSC1-NRg-4",
"CC16_BC2-REB1-TRg-4",
"CC16_BC2-CDC48-NRg-9",
"CC16_BC2-FAS2-TRg-8",
"CC16_BC2-TAO3-TRg-8",
"CC16_BC2-CKS1-TRg-5",
"CC16_BC2-YLR379W-TRg-7",
"CC16_BC2-TEN1-NRg-2",
"CC16_BC2-RPL42A-TRg-2",
"CC16_BC2-SEC27-TRg-4",
"CC16_BC2-TBF1-NRg-4",
"CC16_BC2-RPT1-NRg-6",
"CC16_BC2-COG1-TRg-3",
"CC16_BC2-SUI1-TRg-6",
"CC16_BC2-TIM23-TRg-6",
"CC16_BC2-CDC48-NRg-6",
"CC16_BC2-EPL1-TRg-5",
"CC16_BC2-RPT5-TRg-8",
"CC16_BC2-ATP16-NRg-4",
"CC16_BC2-RPN6-TRg-3",
"CC16_BC2-ERG9-NRg-6",
"CC16_BC2-SMX3-TRg-1",
"CC16_BC2-NCB2-NRg-3",
"CC16_BC2-SEC16-NRg-12",
"CC16_BC2-RPN6-TRg-2",
"CC16_BC2-REB1-NRg-4",
"CC16_BC2-ATP16-TRg-9",
"CC16_BC2-ERG9-NRg-7",
"PRE7g7-RPL15A-NRg-4",
"PRE7g7-RPL15A-NRg-5",
"PRE7g7-KRE33-TRg-1",
"PRE7g7-PMI40-NRg-1",
"PRE7g7-NOP19-NRg-3",
"PRE7g7-SRP14-NRg-4",
"PRE7g7-SEC27-TRg-2",
"PRE7g7-GPI14-TRg-3",
"PRE7g7-PAH1-TRg-7",
"PRE7g7-PAH1-TRg-6",
"PRE7g7-PAH1-TRg-5",
"PRE7g7-PAH1-TRg-3",
"PRE7g7-COG3-TRg-1",
"PRE7g7-HTS1-NRg-5",
"PRE7g7-MSN5-TRg-7",
"PRE7g7-ERG26-TRg-1",
"PRE7g7-SMD2-TRg-5",
"PRE7g7-SMD2-TRg-4",
"PRE7g7-SMD2-TRg-1",
"PRE7g7-PRE7-TRg-4",
"PRE7g7-PRE7-TRg-7",
"PRE7g7-SEC6-TRg-3",
"PRE7g7-ESF2-NRg-1",
"PRE7g7-ESF2-NRg-3",
"PRE7g7-AFG2-TRg-2",
"PRE7g7-RRP36-TRg-3",
"PRE7g7-RRP36-TRg-5",
"PRE7g7-GCR1-NRg-2",
"PRE7g7-PRE4-NRg-4",
"PRE7g7-PRE4-NRg-9",
"PRE7g7-DSN1-NRg-2",
"PRE7g7-GPI11-TRg-3",
"PRE7g7-POP3-TRg-1",
"PRE7g7-MNE1-TRg-5",
"PRE7g7-RRP12-NRg-1",
"PRE7g7-RSC6-TRg-2",
"PRE7g7-CDC25-TRg-1",
"PRE7g7-CDC25-TRg-9",
"PRE7g7-YPP1-NRg-3",
"PRE7g7-NFS1-NRg-9",
"PRE7g7-NFS1-NRg-8",
"PRE7g7-UBA2-TRg-1",
"PRE7g7-ARP2-NRg-3",
"PRE7g7-MAK16-TRg-1",
"PRE7g7-CEP3-NRg-1",
"PRE7g7-GUK1-TRg-5",
"PRE7g7-GUK1-TRg-2",
"PRE7g7-GPI12-NRg-6",
"PRE7g7-RPS5-NRg-5",
"PRE7g7-RPS5-NRg-2",
"PRE7g7-RPC19-NRg-1",
"PRE7g7-TIM54-TRg-1",
"PRE7g7-TEN1-TRg-2",
"PRE7g7-SAH1-NRg-4",
"PRE7g7-SAH1-NRg-5",
"PRE7g7-SAH1-NRg-3",
"PRE7g7-ATP15-NRg-5",
"PRE7g7-SCD5-TRg-5",
"PRE7g7-ARB1-NRg-2",
"PRE7g7-ARB1-NRg-4",
"PRE7g7-PUP2-TRg-1",
"PRE7g7-CCT8-TRg-2",
"PRE7g7-MCM4-TRg-1",
"PRE7g7-LSM4-TRg-1",
"PRE7g7-NOP53-NRg-1",
"PRE7g7-ATP3-TRg-4",
"PRE7g7-AFG2-NRg-3",
"PRE7g7-PRO3-NRg-3",
"PRE7g7-NRD1-NRg-10",
"PRE7g7-SEC61-TRg-2",
"PRE7g7-RHO3-TRg-4",
"PRE7g7-SNF2-TRg-6",
"PRE7g7-SMD2-NRg-3",
"PRE7g7-RSC4-TRg-2",
"PRE7g7-RSC4-TRg-1",
"PRE7g7-TIF34-TRg-2",
"PRE7g7-BET1-NRg-1",
"PRE7g7-CDC8-NRg-2",
"PRE7g7-PRP42-TRg-2",
"PRE7g7-RRB1-TRg-2",
"PRE7g7-SPC24-TRg-1",
"PRE7g7-ILS1-NRg-1",
"PRE7g7-GFA1-TRg-2",
"PRE7g7-SEC21-NRg-10",
"PRE7g7-RPC10-NRg-1",
"PRE7g7-RPB10-TRg-3",
"PRE7g7-RPB10-TRg-2",
"PRE7g7-YNL181W-TRg-1",
"PRE7g7-RAD3-NRg-1",
"PRE7g7-NOP10-TRg-1",
"PRE7g7-BFR2-TRg-3",
"PRE7g7-MCM2-TRg-6",
"PRE7g7-MCM2-TRg-4",
"PRE7g7-MPP10-TRg-1",
"PRE7g7-RET2-TRg-4",
"PRE7g7-RET2-TRg-1",
"PRE7g7-RPS2-NRg-1",
"PRE7g7-RPS2-NRg-2",
"PRE7g7-ORC4-NRg-3",
"PRE7g7-TIP20-TRg-7",
"PRE7g7-SMT3-TRg-1",
"PRE7g7-MSS18-NRg-6",
"PRE7g7-YEF3-NRg-9",
"PRE7g7-ASK1-NRg-1",
"PRE7g7-SMC1-TRg-1",
"PRE7g7-NIP1-NRg-1",
"PRE7g7-RPP1-NRg-1",
"PRE7g7-YDJ1-TRg-6",
"PRE7g7-SUB2-NRg-1",
"PRE7g7-TIM10-NRg-8",
"PRE7g7-TIM10-NRg-4",
"PRE7g7-TIM10-NRg-7",
"PRE7g7-SKI6-TRg-4",
"PRE7g7-TUB4-TRg-1",
"PRE7g7-CDC37-NRg-2",
"PRE7g7-ISD11-TRg-3",
"PRE7g7-YOS1-TRg-4",
"PRE7g7-SSC1-TRg-6",
"PRE7g7-MTR3-TRg-5",
"PRE7g7-MTR3-TRg-6",
"PRE7g7-TFA1-TRg-2",
"PRE7g7-CDC3-NRg-3",
"PRE7g7-ERG25-TA-18",
"PRE7g7-RPB11-TRg-4",
"PRE7g7-RPB11-TRg-1",
"PRE7g7-RPB11-TRg-2",
"PRE7g7-DED1-TRg-3",
"PRE7g7-DED1-TRg-1",
"PRE7g7-DED1-TRg-6",
"PRE7g7-DED1-TRg-4",
"PRE7g7-RPL10-NRg-5",
"PRE7g7-RPL10-NRg-4",
"PRE7g7-EFB1-NRg-1",
"PRE7g7-EFB1-NRg-5",
"PRE7g7-EFB1-NRg-4",
"PRE7g7-RPT3-NRg-1",
"PRE7g7-SAC6-TRg-8",
"PRE7g7-SAC6-TRg-4",
"PRE7g7-SAC6-TRg-5",
"PRE7g7-SAC6-TRg-3",
"PRE7g7-DIM1-TRg-5",
"PRE7g7-DIM1-TRg-7",
"PRE7g7-RPC17-NRg-1",
"PRE7g7-RPC17-NRg-2",
"PRE7g7-YDR341C-TRg-1",
"PRE7g7-RAP1-NRg-8",
"PRE7g7-RAP1-NRg-5",
"PRE7g7-RAP1-NRg-2",
"PRE7g7-SEC26-NRg-3",
"PRE7g7-SPP41-TRg-3",
"PRE7g7-TAP42-NRg-1",
"PRE7g7-PGA2-TRg-6",
"PRE7g7-BRL1-TRg-1",
"PRE7g7-FOL2-TRg-1",
"PRE7g7-NAB3-NRg-5",
"PRE7g7-SNF4-TRg-4",
"PRE7g7-HRR25-TRg-2",
"PRE7g7-TRS23-TRg-4",
"PRE7g7-CTR86-TRg-4",
"PRE7g7-RPB5-TRg-5",
"PRE7g7-SPN1-NRg-2",
"PRE7g7-SPN1-NRg-1",
"PRE7g7-SEC61-NRg-1",
"PRE7g7-SEC61-NRg-7",
"PRE7g7-TUS1-TRg-3",
"PRE7g7-OLE1-NRg-2",
"PRE7g7-AFG2-TRg-1",
"PRE7g7-TOA2-NRg-1",
"PRE7g7-USO1-TRg-1",
"PRE7g7-UTP22-NRg-2",
"PRE7g7-RIB1-TRg-3",
"PRE7g7-RIB1-TRg-7",
"PRE7g7-RIB1-TRg-4",
"PRE7g7-COG1-TRg-1",
"PRE7g7-RPL32-NRg-2",
"PRE7g7-GLC7-NRg-3",
"PRE7g7-GLC7-NRg-4",
"PRE7g7-HSF1-TRg-2",
"PRE7g7-DAM1-NRg-5",
"PRE7g7-SEC18-TRg-4",
"PRE7g7-SEC18-TRg-5",
"PRE7g7-PAB1-NRg-3",
"PRE7g7-POP8-TRg-2",
"PRE7g7-PAB1-NRg-4",
"PRE7g7-BIG1-TRg-4",
"PRE7g7-BIG1-TRg-5",
"PRE7g7-BIG1-TRg-6",
"PRE7g7-RPO41-NRg-1",
"PRE7g7-RVB2-NRg-2",
"PRE7g7-PET117-NRg-8",
"PRE7g7-VPS45-NRg-9",
"PRE7g7-YCG1-NRg-1",
"PRE7g7-NOC4-NRg-1",
"PRE7g7-NMD3-NRg-2",
"PRE7g7-DRS1-TRg-2",
"PRE7g7-HTB1-NRg-2",
"PRE7g7-IPI1-TRg-2",
"PRE7g7-SEC18-NRg-1",
"PRE7g7-SEC18-NRg-2",
"PRE7g7-JIP5-NRg-2",
"PRE7g7-YPT1-TRg-3",
"PRE7g7-YPT1-TRg-2",
"PRE7g7-CLF1-NRg-2",
"PRE7g7-SNF2-NRg-7",
"PRE7g7-SNF2-NRg-4",
"PRE7g7-RPL25-NRg-1",
"PRE7g7-NOP56-TRg-1",
"PRE7g7-NOP56-TRg-2",
"PRE7g7-TRS31-TRg-1",
"PRE7g7-DBF4-TRg-2",
"PRE7g7-DBF4-TRg-1",
"PRE7g7-RPC19-TRg-4",
"PRE7g7-RPC19-TRg-6",
"PRE7g7-RPC19-TRg-3",
"PRE7g7-ROK1-NRg-1",
"PRE7g7-CDC33-TRg-4",
"PRE7g7-DHR2-TRg-3",
"PRE7g7-RRP42-NRg-5",
"PRE7g7-CLF1-TRg-1",
"PRE7g7-ERG11-NA-16",
"PRE7g7-VAS1-NRg-4",
"PRE7g7-PIK1-NRg-2",
"PRE7g7-SAR1-NRg-7",
"PRE7g7-SAR1-NRg-4",
"PRE7g7-RPS3-TRg-1",
"PRE7g7-YTM1-TRg-2",
"PRE7g7-SUI3-NRg-5",
"PRE7g7-SUI3-NRg-2",
"PRE7g7-RRP7-TRg-4",
"PRE7g7-RRP7-TRg-6",
"PRE7g7-NIP7-TRg-2",
"PRE7g7-MDM35-TRg-1",
"PRE7g7-ALA1-NRg-1",
"PRE7g7-DOA4-NRg-2",
"PRE7g7-RPS13-NRg-1",
"PRE7g7-YSF3-TRg-2",
"PRE7g7-RPS2-NRg-11",
"PRE7g7-SSL1-TRg-10",
"PRE7g7-NIP7-TRg-1",
"PRE7g7-LST8-NRg-1",
"PRE7g7-TAF4-TRg-3",
"PRE7g7-HAS1-TRg-2",
"PRE7g7-GLC7-TRg-2",
"PRE7g7-CDC45-NRg-1",
"PRE7g7-SEC22-NRg-8",
"PRE7g7-YOS1-TRg-2",
"PRE7g7-RBA50-TRg-3",
"PRE7g7-SPP41-NRg-2",
"PRE7g7-PRP46-TRg-2",
"PRE7g7-PGA2-NRg-1",
"PRE7g7-CBF5-TRg-3",
"PRE7g7-TCP1-NRg-3",
"PRE7g7-TCP1-NRg-2",
"PRE7g7-ERG26-NRg-2",
"PRE7g7-ERG26-NRg-4",
"PRE7g7-MES1-TRg-5",
"PRE7g7-HTS1-TRg-2",
"PRE7g7-SSS1-TRg-3",
"PRE7g7-SSS1-TRg-2",
"PRE7g7-SYS1-TRg-7",
"PRE7g7-SYS1-TRg-2",
"PRE7g7-SYS1-TRg-1",
"PRE7g7-BFR2-TRg-1",
"PRE7g7-EOS1-TRg-3",
"PRE7g7-TAF4-NRg-1",
"PRE7g7-ARL3-NRg-8",
"PRE7g7-RPN5-NRg-1",
"PRE7g7-TIM9-NRg-2",
"PRE7g7-NUP57-NRg-3",
"PRE7g7-VPS4-TRg-1",
"PRE7g7-CDC3-TRg-4",
"PRE7g7-BBP1-NRg-1",
"PRE7g7-BBP1-NRg-2",
"PRE7g7-USE1-NRg-3",
"PRE7g7-CCT7-TRg-1",
"PRE7g7-SAH1-TRg-3",
"PRE7g7-CHS2-TRg-1",
"PRE7g7-DPM1-TRg-2",
"PRE7g7-BBP1-TRg-1",
"PRE7g7-NRD1-TRg-4",
"PRE7g7-RPB3-NRg-1",
"PRE7g7-PHO85-NRg-6",
"PRE7g7-SNF6-TRg-6",
"PRE7g7-PRP38-NRg-2",
"PRE7g7-OAR1-NRg-3",
"PRE7g7-ROX3-NRg-1",
"PRE7g7-YPP1-TRg-6",
"PRE7g7-CBF2-NRg-8",
"PRE7g7-SPT6-TRg-5",
"PRE7g7-SEC10-NRg-1",
"PRE7g7-NSL1-NRg-3",
"PRE7g7-NRD1-NRg-8",
"PRE7g7-RPB3-TRg-1",
"PRE7g7-NRD1-NRg-4",
"PRE7g7-RVB1-TRg-2",
"PRE7g7-TIF5-NRg-8",
"PRE7g7-EOS1-NRg-1",
"PRE7g7-ERG25-NA-26",
"PRE7g7-MSL5-NRg-4",
"PRE7g7-SEC24-TRg-2",
"PRE7g7-RPL30-NRg-5",
"PRE7g7-SNU71-NRg-3",
"PRE7g7-CDC33-NRg-1",
"PRE7g7-RPN6-TRg-4",
"PRE7g7-NAB2-TRg-4",
"PRE7g7-NAB2-TRg-6",
"PRE7g7-YTM1-NRg-1",
"PRE7g7-OLE1-TRg-8",
"PRE7g7-OLE1-TRg-1",
"PRE7g7-UTP7-TRg-4",
"PRE7g7-ACT1-NRg-6",
"PRE7g7-RPL18A-NRg-3",
"PRE7g7-BRX1-NRg-1",
"PRE7g7-NAF1-TRg-8",
"PRE7g7-NAF1-TRg-6",
"PRE7g7-NAF1-TRg-4",
"PRE7g7-CDC8-TRg-2",
"PRE7g7-NSE4-TRg-1",
"PRE7g7-PAB1-NRg-2",
"PRE7g7-PRP43-TRg-4",
"PRE7g7-SEC2-NRg-3",
"PRE7g7-SEC2-NRg-6",
"PRE7g7-MPP10-NRg-5",
"PRE7g7-YDR355C-TRg-2",
"PRE7g7-YLR339C-TRg-9",
"PRE7g7-SNM1-TRg-2",
"PRE7g7-ALR1-NRg-4",
"PRE7g7-ALR1-NRg-1",
"PRE7g7-ALR1-NRg-3",
"PRE7g7-RPL10-TRg-1",
"PRE7g7-RPL28-TRg-2",
"PRE7g7-UTP25-TRg-1",
"PRE7g7-POB3-TRg-1",
"PRE7g7-POB3-TRg-3",
"PRE7g7-POB3-TRg-2",
"PRE7g7-MED11-TRg-1",
"PRE7g7-ISA1-TRg-15",
"PRE7g7-RRP1-NRg-1",
"PRE7g7-MES1-NRg-1",
"PRE7g7-SEC13-NRg-5",
"PRE7g7-MCM2-NRg-2",
"PRE7g7-ALA1-TRg-4",
"PRE7g7-MTG2-TRg-5",
"PRE7g7-TIF35-NRg-3",
"PRE7g7-NSE1-TRg-3",
"PRE7g7-NSE1-TRg-4",
"PRE7g7-MOB2-NRg-6",
"PRE7g7-VRG4-NRg-3",
"PRE7g7-PRP9-TRg-3",
"PRE7g7-HYM1-TRg-5",
"PRE7g7-POP1-TRg-5",
"PRE7g7-POP1-TRg-9",
"PRE7g7-RPL17A-TRg-1",
"PRE7g7-SLD2-TRg-1",
"PRE7g7-CDC48-NRg-7",
"PRE7g7-FHL1-NRg-2",
"PRE7g7-BET3-NRg-7",
"PRE7g7-MAK21-TRg-1",
"PRE7g7-BRN1-TRg-4",
"PRE7g7-FBA1-NRg-3",
"PRE7g7-CDC42-TRg-6",
"PRE7g7-CDC42-TRg-7",
"PRE7g7-COG4-NRg-1",
"PRE7g7-ATP3-NRg-3",
"PRE7g7-ATP3-NRg-2",
"PRE7g7-SMP3-TRg-5",
"PRE7g7-CFT2-NRg-2",
"PRE7g7-FAS2-TRg-5",
"PRE7g7-DBP2-NRg-3",
"PRE7g7-DBP2-NRg-2",
"PRE7g7-MPS2-NRg-4",
"PRE7g7-ARC35-TRg-2",
"PRE7g7-ARC35-TRg-5",
"PRE7g7-MRD1-TRg-1",
"PRE7g7-RLP7-TRg-1",
"PRE7g7-SPC34-TRg-1",
"PRE7g7-CDC45-TRg-2",
"PRE7g7-GCD6-TRg-3",
"PRE7g7-GCD6-TRg-4",
"PRE7g7-YPT6-NRg-2",
"PRE7g7-RPS13-TRg-2",
"PRE7g7-IPI3-TRg-3",
"PRE7g7-TIF5-NRg-9",
"PRE7g7-TIF5-NRg-7",
"PRE7g7-TIF5-NRg-6",
"PRE7g7-NAB3-TRg-3",
"PRE7g7-GCD2-TRg-1",
"PRE7g7-UBA1-TRg-2",
"PRE7g7-SLD3-TRg-6",
"PRE7g7-LCB1-TRg-5",
"PRE7g7-TOA2-TRg-6",
"PRE7g7-TOA2-TRg-1",
"PRE7g7-TOA2-TRg-3",
"PRE7g7-LSM2-TRg-1",
"PRE7g7-YML6-TRg-13",
"PRE7g7-YML6-TRg-12",
"PRE7g7-UTP15-NRg-1",
"PRE7g7-TIF6-NRg-8",
"PRE7g7-SUP35-NRg-1",
"PRE7g7-MPP10-NRg-1",
"PRE7g7-SWI3-TRg-7",
"PRE7g7-SSN3-NRg-2",
"PRE7g7-SEC13-NRg-7",
"PRE7g7-RPS15-NRg-3",
"PRE7g7-RPL3-TRg-2",
"PRE7g7-FBA1-NRg-2",
"PRE7g7-FBA1-NRg-1",
"PRE7g7-FBA1-NRg-5",
"PRE7g7-DAM1-TRg-2",
"PRE7g7-NHP2-TRg-2",
"PRE7g7-HCA4-NRg-6",
"PRE7g7-PRE3-TRg-4",
"PRE7g7-DBP5-NRg-4",
"PRE7g7-SPT6-NRg-4",
"PRE7g7-SPT6-NRg-2",
"PRE7g7-RPL18A-TRg-4",
"PRE7g7-KSH1-TRg-1",
"PRE7g7-KSH1-TRg-3",
"PRE7g7-IPI3-NRg-1",
"PRE7g7-PGA2-TRg-8",
"PRE7g7-RPL18A-TRg-2",
"PRE7g7-RPL33A-NRg-6",
"PRE7g7-TAF12-NRg-2",
"PRE7g7-USE1-TRg-5",
"PRE7g7-YNL114C-TRg-1",
"PRE7g7-SMC5-TRg-7",
"PRE7g7-SMC5-TRg-6",
"PRE7g7-RSC58-TRg-1",
"PRE7g7-CTF13-TRg-2",
"PRE7g7-NAB2-NRg-2",
"PRE7g7-MCM7-TRg-4",
"PRE7g7-BCP1-NRg-5",
"PRE7g7-STU2-TRg-3",
"PRE7g7-SEC21-NRg-6",
"PRE7g7-SEC21-NRg-3",
"PRE7g7-RPL1B-TRg-3",
"PRE7g7-SEC20-NRg-2",
"PRE7g7-VMA3-NRg-2",
"PRE7g7-SEC23-NRg-5",
"PRE7g7-CDC28-TRg-4",
"PRE7g7-RPN12-NRg-11",
"PRE7g7-PUP3-TRg-3",
"PRE7g7-SEC31-TRg-2",
"PRE7g7-SED5-TRg-6",
"PRE7g7-SED5-TRg-5",
"PRE7g7-RPL33A-TRg-1",
"PRE7g7-RPL33A-TRg-2",
"PRE7g7-MRPL11-TRg-2",
"PRE7g7-RTP1-NRg-2",
"PRE7g7-NUG1-TRg-2",
"PRE7g7-VPH2-TRg-4",
"PRE7g7-COP1-NRg-3",
"PRE7g7-CRM1-NRg-1",
"PRE7g7-RPL5-NRg-4",
"PRE7g7-SNU13-NRg-4",
"PRE7g7-PFS2-TRg-3",
"PRE7g7-MPP10-TRg-2",
"PRE7g7-TSR4-NRg-2",
"PRE7g7-RSC2-TRg-1",
"PRE7g7-SEC65-TRg-2",
"PRE7g7-SMI1-NRg-1",
"PRE7g7-RTT105-NRg-4",
"PRE7g7-VMA5-TRg-3",
"PRE7g7-VMA5-TRg-5",
"PRE7g7-RRP1-TRg-3",
"PRE7g7-CLC1-TRg-2",
"PRE7g7-GCD6-NRg-1",
"PRE7g7-GCD6-NRg-2",
"PRE7g7-PXR1-TRg-1",
"PRE7g7-CDC14-NRg-1",
"PRE7g7-PCF11-TRg-6",
"PRE7g7-PCF11-TRg-5",
"PRE7g7-PCF11-TRg-4",
"PRE7g7-SEC31-NRg-1",
"PRE7g7-RRP5-NRg-1",
"PRE7g7-PRE10-TRg-5",
"PRE7g7-PRE10-TRg-1",
"PRE7g7-RPS5-TRg-2",
"PRE7g7-NSP1-TRg-4",
"PRE7g7-PRP38-TRg-4",
"PRE7g7-RCF1-NRg-5",
"PRE7g7-RSC3-TRg-4",
"PRE7g7-RSC3-TRg-5",
"PRE7g7-RSC3-TRg-6",
"PRE7g7-HTA1-NRg-12",
"PRE7g7-HTA1-NRg-11",
"PRE7g7-UTP23-TRg-2",
"PRE7g7-GCD7-NRg-1",
"PRE7g7-GCD7-NRg-2",
"PRE7g7-GCD7-NRg-6",
"PRE7g7-GAL11-NRg-2",
"PRE7g7-GAL11-NRg-9",
"PRE7g7-PHO4-TRg-5",
"PRE7g7-SNP1-NRg-3",
"PRE7g7-RPC37-TRg-5",
"PRE7g7-CRM1-TRg-5",
"PRE7g7-CRM1-TRg-2",
"PRE7g7-ASK1-TRg-7",
"PRE7g7-STU2-NRg-4",
"PRE7g7-NEO1-NRg-3",
"PRE7g7-GAL11-TRg-5",
"PRE7g7-GAL11-TRg-7",
"PRE7g7-SAM50-NRg-3",
"PRE7g7-CSL4-TRg-2",
"PRE7g7-CCT5-TRg-2",
"PRE7g7-POL30-NRg-1",
"PRE7g7-MED4-TRg-4",
"PRE7g7-MED4-TRg-3",
"PRE7g7-MED4-TRg-2",
"PRE7g7-GDI1-TRg-4",
"PRE7g7-GDI1-TRg-3",
"PRE7g7-REB1-TRg-6",
"PRE7g7-MRPL37-NRg-2",
"PRE7g7-NOC3-TRg-3",
"PRE7g7-SPC97-TRg-3",
"PRE7g7-IPP1-TRg-3",
"PRE7g7-IPP1-TRg-2",
"PRE7g7-PTI1-TRg-3",
"PRE7g7-PTI1-TRg-5",
"PRE7g7-RFC5-NRg-1",
"PRE7g7-CDC24-TRg-1",
"PRE7g7-CDC24-TRg-3",
"PRE7g7-CDC24-TRg-5",
"PRE7g7-CDC24-TRg-6",
"PRE7g7-UTP23-TRg-6",
"PRE7g7-UTP23-TRg-4",
"PRE7g7-UTP23-TRg-1",
"PRE7g7-RHO3-NRg-4",
"PRE7g7-TRS23-NRg-1",
"PRE7g7-TRS23-NRg-3",
"PRE7g7-RSP5-TRg-2",
"PRE7g7-RSP5-TRg-1",
"PRE7g7-SDA1-NRg-1",
"PRE7g7-KAP95-TRg-8",
"PRE7g7-ACO1-TRg-6",
"PRE7g7-HTA1-NRg-3",
"PRE7g7-HTA1-NRg-2",
"PRE7g7-SPN1-TRg-1",
"PRE7g7-MOT1-NRg-7",
"PRE7g7-RPL17A-NRg-4",
"PRE7g7-ADA2-TRg-4",
"PRE7g7-SFH1-NRg-1",
"PRE7g7-SPC97-NRg-5",
"PRE7g7-PRP22-TRg-3",
"PRE7g7-SEN15-TRg-2",
"PRE7g7-RPL3-NRg-2",
"PRE7g7-ISD11-NRg-2",
"PRE7g7-HEM12-TRg-8",
"PRE7g7-SEC10-TRg-1",
"PRE7g7-HTB1-TRg-7",
"PRE7g7-TTI2-TRg-1",
"PRE7g7-ACP1-TRg-2",
"PRE7g7-ACP1-TRg-4",
"PRE7g7-GAL11-NRg-10",
"PRE7g7-UTP22-TRg-2",
"PRE7g7-MST1-NRg-5",
"PRE7g7-RIB7-NRg-2",
"PRE7g7-MCD1-TRg-6",
"PRE7g7-MCD1-TRg-5",
"PRE7g7-GPI8-NRg-2",
"PRE7g7-THS1-TRg-2",
"PRE7g7-RRP7-TRg-2",
"PRE7g7-RRP7-TRg-5",
"PRE7g7-SMX2-NRg-7",
"PRE7g7-RRP45-TRg-5",
"PRE7g7-RRP45-TRg-4",
"PRE7g7-CNS1-TRg-2",
"PRE7g7-FBP1-NRg-9",
"PRE7g7-GCD11-NRg-1",
"PRE7g7-RPL10-TRg-2",
"PRE7g7-NUP192-TRg-4",
"PRE7g7-NUP145-NRg-4",
"PRE7g7-HEM12-TRg-6",
"PRE7g7-PLC1-TRg-3",
"PRE7g7-RPA43-TRg-1",
"PRE7g7-RPB7-NRg-2",
"PRE7g7-RPB7-NRg-3",
"PRE7g7-NSL1-NRg-1",
"PRE7g7-UTP6-TRg-3",
"PRE7g7-UTP6-TRg-1",
"PRE7g7-YJU2-TRg-5",
"PRE7g7-FRS2-NRg-5",
"PRE7g7-TIF35-NRg-2",
"PRE7g7-GPI15-TRg-1",
"PRE7g7-NOP1-NRg-5",
"PRE7g7-GPI15-TRg-4",
"PRE7g7-COG4-TRg-1",
"PRE7g7-TFA1-TRg-1",
"PRE7g7-RHO1-NRg-2",
"PRE7g7-RHO1-NRg-1",
"PRE7g7-CDC55-NRg-2",
"PRE7g7-IDI1-NRg-7",
"PRE7g7-RPL32-TRg-5",
"PRE7g7-RPB5-TRg-4",
"PRE7g7-DIP2-TRg-5",
"PRE7g7-DIP2-TRg-1",
"PRE7g7-RPC40-TRg-2",
"PRE7g7-CDC6-TRg-5",
"PRE7g7-CDC6-TRg-3",
"PRE7g7-DAD2-TRg-2",
"PRE7g7-RVS161-TRg-2",
"PRE7g7-RVS161-TRg-1",
"PRE7g7-SUP45-NRg-3",
"PRE7g7-SRB6-NRg-5",
"PRE7g7-RPC11-TRg-4",
"PRE7g7-RKI1-TRg-8",
"PRE7g7-NIP7-TRg-3",
"PRE7g7-RPL33A-NRg-12",
"PRE7g7-SAM50-TRg-4",
"PRE7g7-NOP4-NRg-1",
"PRE7g7-NOP4-NRg-3",
"PRE7g7-SMX2-TRg-5",
"PRE7g7-POL12-NRg-2",
"PRE7g7-BMS1-NRg-2",
"PRE7g7-RPA190-TRg-5",
"PRE7g7-ALG14-NRg-4",
"PRE7g7-ALG14-NRg-1",
"PRE7g7-PRE5-NRg-1",
"PRE7g7-BIG1-NRg-2",
"PRE7g7-TFA2-TRg-4",
"PRE7g7-IMP4-TRg-6",
"PRE7g7-PAN1-NRg-1",
"PRE7g7-UTP13-TRg-2",
"PRE7g7-KAE1-NRg-3",
"PRE7g7-ERG20-TRg-1",
"PRE7g7-CDC20-TRg-6",
"PRE7g7-PWP2-NRg-2",
"PRE7g7-COG1-NRg-1",
"PRE7g7-RPL1B-TRg-4",
"PRE7g7-RPL1B-TRg-7",
"PRE7g7-UTP20-TRg-3",
"PRE7g7-UTP20-TRg-4",
"PRE7g7-RPL25-TRg-4",
"PRE7g7-RPL25-TRg-2",
"PRE7g7-MCM7-NRg-1",
"PRE7g7-MRP49-TRg-5",
"PRE7g7-ERO1-NRg-3",
"PRE7g7-UTP5-TRg-7",
"PRE7g7-MCM4-NRg-1",
"PRE7g7-PRE3-NRg-1",
"PRE7g7-FCF1-NRg-1",
"PRE7g7-CUS1-NRg-1",
"PRE7g7-PSF1-TRg-2",
"PRE7g7-BCP1-TRg-2",
"PRE7g7-PAN1-TRg-1",
"PRE7g7-PAN1-TRg-3",
"PRE7g7-PAN1-TRg-4",
"PRE7g7-VPS3-TRg-2",
"PRE7g7-YIL060W-NRg-1",
"PRE7g7-VPS53-NRg-1",
"PRE7g7-CYR1-TRg-4",
"PRE7g7-CYR1-TRg-7",
"PRE7g7-MPS1-NRg-1",
"PRE7g7-SRP1-TRg-5",
"PRE7g7-SRP1-TRg-4",
"PRE7g7-TAF12-TRg-2",
"PRE7g7-TAF12-TRg-3",
"PRE7g7-POP4-TRg-1",
"PRE7g7-SPT16-TRg-1",
"PRE7g7-NUP82-TRg-4",
"PRE7g7-DML1-TRg-3",
"PRE7g7-RPA43-NRg-3",
"PRE7g7-STU2-NRg-3",
"PRE7g7-POP4-NRg-4",
"PRE7g7-MCD1-TRg-2",
"PRE7g7-RPS3-NRg-4",
"PRE7g7-PRP9-TRg-4",
"PRE7g7-RPP1-NRg-2",
"PRE7g7-MTR2-NRg-11",
"PRE7g7-GCD11-TRg-1",
"PRE7g7-RPF1-TRg-3",
"PRE7g7-SUB2-NRg-4",
"PRE7g7-GPI15-TRg-3",
"PRE7g7-ERG9-TRg-6",
"PRE7g7-RPT2-NRg-1",
"PRE7g7-YOS1-NRg-3",
"PRE7g7-SCM3-TRg-4",
"PRE7g7-SCM3-TRg-6",
"PRE7g7-RLP7-NRg-1",
"PRE7g7-TFB2-NRg-4",
"PRE7g7-IMP4-TRg-1",
"PRE7g7-IMP4-TRg-3",
"PRE7g7-PRE4-TRg-3",
"PRE7g7-SUB2-TRg-3",
"PRE7g7-RPP0-NRg-4",
"PRE7g7-RPP0-NRg-3",
"PRE7g7-TOM40-TRg-4",
"PRE7g7-FUR1-NRg-12",
"PRE7g7-TOM40-TRg-2",
"PRE7g7-VMA11-NRg-4",
"PRE7g7-PGS1-NRg-4",
"PRE7g7-URB1-TRg-4",
"PRE7g7-ARP4-TRg-3",
"PRE7g7-RPT3-TRg-3",
"PRE7g7-SUI3-TRg-3",
"PRE7g7-RFC5-NRg-2",
"PRE7g7-RRP14-TRg-2",
"PRE7g7-SCC2-TRg-1",
"PRE7g7-SSC1-TRg-3",
"PRE7g7-RRP9-TRg-3",
"PRE7g7-MOT1-NRg-9",
"PRE7g7-RPL42A-NRg-2",
"PRE7g7-SEC16-TRg-7",
"PRE7g7-IMP4-NRg-2",
"PRE7g7-YEF3-NRg-4",
"PRE7g7-PUP1-TRg-1",
"PRE7g7-UTP22-TRg-6",
"PRE7g7-DBP2-NRg-4",
"PRE7g7-PRE2-TRg-7",
"PRE7g7-ATP16-TRg-6",
"PRE7g7-UTP13-TRg-4",
"PRE7g7-DOP1-NRg-4",
"PRE7g7-TIM44-TRg-3",
"PRE7g7-ATP16-TRg-2",
"PRE7g7-ENP1-NRg-3",
"PRE7g7-NAF1-TRg-3",
"PRE7g7-COG4-TRg-2",
"PRE7g7-SOG2-TRg-7",
"PRE7g7-YDR341C-TRg-3",
"PRE7g7-YMR290W-A-TRg-10",
"PRE7g7-NUP192-NRg-9",
"PRE7g7-RPS31-NRg-8",
"PRE7g7-SPC97-NRg-6",
"PRE7g7-EBP2-NRg-1",
"PRE7g7-CDC48-TRg-5",
"PRE7g7-RPT1-TRg-4",
"PRE7g7-ULP1-NRg-2",
"PRE7g7-RPN3-TRg-6",
"PRE7g7-RPT1-TRg-5",
"PRE7g7-KRE5-TRg-2",
"PRE7g7-TBF1-NRg-8",
"PRE7g7-UTP22-NRg-4",
"PRE7g7-SSC1-NRg-4",
"PRE7g7-REB1-TRg-4",
"PRE7g7-CDC48-NRg-9",
"PRE7g7-FAS2-TRg-8",
"PRE7g7-TAO3-TRg-8",
"PRE7g7-CKS1-TRg-5",
"PRE7g7-YLR379W-TRg-7",
"PRE7g7-TEN1-NRg-2",
"PRE7g7-RPL42A-TRg-2",
"PRE7g7-SEC27-TRg-4",
"PRE7g7-TBF1-NRg-4",
"PRE7g7-RPT1-NRg-6",
"PRE7g7-COG1-TRg-3",
"PRE7g7-SUI1-TRg-6",
"PRE7g7-TIM23-TRg-6",
"PRE7g7-CDC48-NRg-6",
"PRE7g7-EPL1-TRg-5",
"PRE7g7-RPT5-TRg-8",
"PRE7g7-ATP16-NRg-4",
"PRE7g7-RPN6-TRg-3",
"PRE7g7-ERG9-NRg-6",
"PRE7g7-SMX3-TRg-1",
"PRE7g7-NCB2-NRg-3",
"PRE7g7-SEC16-NRg-12",
"PRE7g7-RPN6-TRg-2",
"PRE7g7-REB1-NRg-4",
"PRE7g7-ATP16-TRg-9",
"PRE7g7-ERG9-NRg-7",
"PRE4g9-RPL15A-NRg-4",
"PRE4g9-RPL15A-NRg-5",
"PRE4g9-KRE33-TRg-1",
"PRE4g9-PMI40-NRg-1",
"PRE4g9-NOP19-NRg-3",
"PRE4g9-SRP14-NRg-4",
"PRE4g9-SEC27-TRg-2",
"PRE4g9-GPI14-TRg-3",
"PRE4g9-PAH1-TRg-7",
"PRE4g9-PAH1-TRg-6",
"PRE4g9-PAH1-TRg-5",
"PRE4g9-PAH1-TRg-3",
"PRE4g9-COG3-TRg-1",
"PRE4g9-HTS1-NRg-5",
"PRE4g9-MSN5-TRg-7",
"PRE4g9-ERG26-TRg-1",
"PRE4g9-SMD2-TRg-5",
"PRE4g9-SMD2-TRg-4",
"PRE4g9-SMD2-TRg-1",
"PRE4g9-PRE7-TRg-4",
"PRE4g9-PRE7-TRg-7",
"PRE4g9-SEC6-TRg-3",
"PRE4g9-ESF2-NRg-1",
"PRE4g9-ESF2-NRg-3",
"PRE4g9-AFG2-TRg-2",
"PRE4g9-RRP36-TRg-3",
"PRE4g9-RRP36-TRg-5",
"PRE4g9-GCR1-NRg-2",
"PRE4g9-PRE4-NRg-4",
"PRE4g9-PRE4-NRg-9",
"PRE4g9-DSN1-NRg-2",
"PRE4g9-GPI11-TRg-3",
"PRE4g9-POP3-TRg-1",
"PRE4g9-MNE1-TRg-5",
"PRE4g9-RRP12-NRg-1",
"PRE4g9-RSC6-TRg-2",
"PRE4g9-CDC25-TRg-1",
"PRE4g9-CDC25-TRg-9",
"PRE4g9-YPP1-NRg-3",
"PRE4g9-NFS1-NRg-9",
"PRE4g9-NFS1-NRg-8",
"PRE4g9-UBA2-TRg-1",
"PRE4g9-ARP2-NRg-3",
"PRE4g9-MAK16-TRg-1",
"PRE4g9-CEP3-NRg-1",
"PRE4g9-GUK1-TRg-5",
"PRE4g9-GUK1-TRg-2",
"PRE4g9-GPI12-NRg-6",
"PRE4g9-RPS5-NRg-5",
"PRE4g9-RPS5-NRg-2",
"PRE4g9-RPC19-NRg-1",
"PRE4g9-TIM54-TRg-1",
"PRE4g9-TEN1-TRg-2",
"PRE4g9-SAH1-NRg-4",
"PRE4g9-SAH1-NRg-5",
"PRE4g9-SAH1-NRg-3",
"PRE4g9-ATP15-NRg-5",
"PRE4g9-SCD5-TRg-5",
"PRE4g9-ARB1-NRg-2",
"PRE4g9-ARB1-NRg-4",
"PRE4g9-PUP2-TRg-1",
"PRE4g9-CCT8-TRg-2",
"PRE4g9-MCM4-TRg-1",
"PRE4g9-LSM4-TRg-1",
"PRE4g9-NOP53-NRg-1",
"PRE4g9-ATP3-TRg-4",
"PRE4g9-AFG2-NRg-3",
"PRE4g9-PRO3-NRg-3",
"PRE4g9-NRD1-NRg-10",
"PRE4g9-SEC61-TRg-2",
"PRE4g9-RHO3-TRg-4",
"PRE4g9-SNF2-TRg-6",
"PRE4g9-SMD2-NRg-3",
"PRE4g9-RSC4-TRg-2",
"PRE4g9-RSC4-TRg-1",
"PRE4g9-TIF34-TRg-2",
"PRE4g9-BET1-NRg-1",
"PRE4g9-CDC8-NRg-2",
"PRE4g9-PRP42-TRg-2",
"PRE4g9-RRB1-TRg-2",
"PRE4g9-SPC24-TRg-1",
"PRE4g9-ILS1-NRg-1",
"PRE4g9-GFA1-TRg-2",
"PRE4g9-SEC21-NRg-10",
"PRE4g9-RPC10-NRg-1",
"PRE4g9-RPB10-TRg-3",
"PRE4g9-RPB10-TRg-2",
"PRE4g9-YNL181W-TRg-1",
"PRE4g9-RAD3-NRg-1",
"PRE4g9-NOP10-TRg-1",
"PRE4g9-BFR2-TRg-3",
"PRE4g9-MCM2-TRg-6",
"PRE4g9-MCM2-TRg-4",
"PRE4g9-MPP10-TRg-1",
"PRE4g9-RET2-TRg-4",
"PRE4g9-RET2-TRg-1",
"PRE4g9-RPS2-NRg-1",
"PRE4g9-RPS2-NRg-2",
"PRE4g9-ORC4-NRg-3",
"PRE4g9-TIP20-TRg-7",
"PRE4g9-SMT3-TRg-1",
"PRE4g9-MSS18-NRg-6",
"PRE4g9-YEF3-NRg-9",
"PRE4g9-ASK1-NRg-1",
"PRE4g9-SMC1-TRg-1",
"PRE4g9-NIP1-NRg-1",
"PRE4g9-RPP1-NRg-1",
"PRE4g9-YDJ1-TRg-6",
"PRE4g9-SUB2-NRg-1",
"PRE4g9-TIM10-NRg-8",
"PRE4g9-TIM10-NRg-4",
"PRE4g9-TIM10-NRg-7",
"PRE4g9-SKI6-TRg-4",
"PRE4g9-TUB4-TRg-1",
"PRE4g9-CDC37-NRg-2",
"PRE4g9-ISD11-TRg-3",
"PRE4g9-YOS1-TRg-4",
"PRE4g9-SSC1-TRg-6",
"PRE4g9-MTR3-TRg-5",
"PRE4g9-MTR3-TRg-6",
"PRE4g9-TFA1-TRg-2",
"PRE4g9-CDC3-NRg-3",
"PRE4g9-ERG25-TA-18",
"PRE4g9-RPB11-TRg-4",
"PRE4g9-RPB11-TRg-1",
"PRE4g9-RPB11-TRg-2",
"PRE4g9-DED1-TRg-3",
"PRE4g9-DED1-TRg-1",
"PRE4g9-DED1-TRg-6",
"PRE4g9-DED1-TRg-4",
"PRE4g9-RPL10-NRg-5",
"PRE4g9-RPL10-NRg-4",
"PRE4g9-EFB1-NRg-1",
"PRE4g9-EFB1-NRg-5",
"PRE4g9-EFB1-NRg-4",
"PRE4g9-RPT3-NRg-1",
"PRE4g9-SAC6-TRg-8",
"PRE4g9-SAC6-TRg-4",
"PRE4g9-SAC6-TRg-5",
"PRE4g9-SAC6-TRg-3",
"PRE4g9-DIM1-TRg-5",
"PRE4g9-DIM1-TRg-7",
"PRE4g9-RPC17-NRg-1",
"PRE4g9-RPC17-NRg-2",
"PRE4g9-YDR341C-TRg-1",
"PRE4g9-RAP1-NRg-8",
"PRE4g9-RAP1-NRg-5",
"PRE4g9-RAP1-NRg-2",
"PRE4g9-SEC26-NRg-3",
"PRE4g9-SPP41-TRg-3",
"PRE4g9-TAP42-NRg-1",
"PRE4g9-PGA2-TRg-6",
"PRE4g9-BRL1-TRg-1",
"PRE4g9-FOL2-TRg-1",
"PRE4g9-NAB3-NRg-5",
"PRE4g9-SNF4-TRg-4",
"PRE4g9-HRR25-TRg-2",
"PRE4g9-TRS23-TRg-4",
"PRE4g9-CTR86-TRg-4",
"PRE4g9-RPB5-TRg-5",
"PRE4g9-SPN1-NRg-2",
"PRE4g9-SPN1-NRg-1",
"PRE4g9-SEC61-NRg-1",
"PRE4g9-SEC61-NRg-7",
"PRE4g9-TUS1-TRg-3",
"PRE4g9-OLE1-NRg-2",
"PRE4g9-AFG2-TRg-1",
"PRE4g9-TOA2-NRg-1",
"PRE4g9-USO1-TRg-1",
"PRE4g9-UTP22-NRg-2",
"PRE4g9-RIB1-TRg-3",
"PRE4g9-RIB1-TRg-7",
"PRE4g9-RIB1-TRg-4",
"PRE4g9-COG1-TRg-1",
"PRE4g9-RPL32-NRg-2",
"PRE4g9-GLC7-NRg-3",
"PRE4g9-GLC7-NRg-4",
"PRE4g9-HSF1-TRg-2",
"PRE4g9-DAM1-NRg-5",
"PRE4g9-SEC18-TRg-4",
"PRE4g9-SEC18-TRg-5",
"PRE4g9-PAB1-NRg-3",
"PRE4g9-POP8-TRg-2",
"PRE4g9-PAB1-NRg-4",
"PRE4g9-BIG1-TRg-4",
"PRE4g9-BIG1-TRg-5",
"PRE4g9-BIG1-TRg-6",
"PRE4g9-RPO41-NRg-1",
"PRE4g9-RVB2-NRg-2",
"PRE4g9-PET117-NRg-8",
"PRE4g9-VPS45-NRg-9",
"PRE4g9-YCG1-NRg-1",
"PRE4g9-NOC4-NRg-1",
"PRE4g9-NMD3-NRg-2",
"PRE4g9-DRS1-TRg-2",
"PRE4g9-HTB1-NRg-2",
"PRE4g9-IPI1-TRg-2",
"PRE4g9-SEC18-NRg-1",
"PRE4g9-SEC18-NRg-2",
"PRE4g9-JIP5-NRg-2",
"PRE4g9-YPT1-TRg-3",
"PRE4g9-YPT1-TRg-2",
"PRE4g9-CLF1-NRg-2",
"PRE4g9-SNF2-NRg-7",
"PRE4g9-SNF2-NRg-4",
"PRE4g9-RPL25-NRg-1",
"PRE4g9-NOP56-TRg-1",
"PRE4g9-NOP56-TRg-2",
"PRE4g9-TRS31-TRg-1",
"PRE4g9-DBF4-TRg-2",
"PRE4g9-DBF4-TRg-1",
"PRE4g9-RPC19-TRg-4",
"PRE4g9-RPC19-TRg-6",
"PRE4g9-RPC19-TRg-3",
"PRE4g9-ROK1-NRg-1",
"PRE4g9-CDC33-TRg-4",
"PRE4g9-DHR2-TRg-3",
"PRE4g9-RRP42-NRg-5",
"PRE4g9-CLF1-TRg-1",
"PRE4g9-ERG11-NA-16",
"PRE4g9-VAS1-NRg-4",
"PRE4g9-PIK1-NRg-2",
"PRE4g9-SAR1-NRg-7",
"PRE4g9-SAR1-NRg-4",
"PRE4g9-RPS3-TRg-1",
"PRE4g9-YTM1-TRg-2",
"PRE4g9-SUI3-NRg-5",
"PRE4g9-SUI3-NRg-2",
"PRE4g9-RRP7-TRg-4",
"PRE4g9-RRP7-TRg-6",
"PRE4g9-NIP7-TRg-2",
"PRE4g9-MDM35-TRg-1",
"PRE4g9-ALA1-NRg-1",
"PRE4g9-DOA4-NRg-2",
"PRE4g9-RPS13-NRg-1",
"PRE4g9-YSF3-TRg-2",
"PRE4g9-RPS2-NRg-11",
"PRE4g9-SSL1-TRg-10",
"PRE4g9-NIP7-TRg-1",
"PRE4g9-LST8-NRg-1",
"PRE4g9-TAF4-TRg-3",
"PRE4g9-HAS1-TRg-2",
"PRE4g9-GLC7-TRg-2",
"PRE4g9-CDC45-NRg-1",
"PRE4g9-SEC22-NRg-8",
"PRE4g9-YOS1-TRg-2",
"PRE4g9-RBA50-TRg-3",
"PRE4g9-SPP41-NRg-2",
"PRE4g9-PRP46-TRg-2",
"PRE4g9-PGA2-NRg-1",
"PRE4g9-CBF5-TRg-3",
"PRE4g9-TCP1-NRg-3",
"PRE4g9-TCP1-NRg-2",
"PRE4g9-ERG26-NRg-2",
"PRE4g9-ERG26-NRg-4",
"PRE4g9-MES1-TRg-5",
"PRE4g9-HTS1-TRg-2",
"PRE4g9-SSS1-TRg-3",
"PRE4g9-SSS1-TRg-2",
"PRE4g9-SYS1-TRg-7",
"PRE4g9-SYS1-TRg-2",
"PRE4g9-SYS1-TRg-1",
"PRE4g9-BFR2-TRg-1",
"PRE4g9-EOS1-TRg-3",
"PRE4g9-TAF4-NRg-1",
"PRE4g9-ARL3-NRg-8",
"PRE4g9-RPN5-NRg-1",
"PRE4g9-TIM9-NRg-2",
"PRE4g9-NUP57-NRg-3",
"PRE4g9-VPS4-TRg-1",
"PRE4g9-CDC3-TRg-4",
"PRE4g9-BBP1-NRg-1",
"PRE4g9-BBP1-NRg-2",
"PRE4g9-USE1-NRg-3",
"PRE4g9-CCT7-TRg-1",
"PRE4g9-SAH1-TRg-3",
"PRE4g9-CHS2-TRg-1",
"PRE4g9-DPM1-TRg-2",
"PRE4g9-BBP1-TRg-1",
"PRE4g9-NRD1-TRg-4",
"PRE4g9-RPB3-NRg-1",
"PRE4g9-PHO85-NRg-6",
"PRE4g9-SNF6-TRg-6",
"PRE4g9-PRP38-NRg-2",
"PRE4g9-OAR1-NRg-3",
"PRE4g9-ROX3-NRg-1",
"PRE4g9-YPP1-TRg-6",
"PRE4g9-CBF2-NRg-8",
"PRE4g9-SPT6-TRg-5",
"PRE4g9-SEC10-NRg-1",
"PRE4g9-NSL1-NRg-3",
"PRE4g9-NRD1-NRg-8",
"PRE4g9-RPB3-TRg-1",
"PRE4g9-NRD1-NRg-4",
"PRE4g9-RVB1-TRg-2",
"PRE4g9-TIF5-NRg-8",
"PRE4g9-EOS1-NRg-1",
"PRE4g9-ERG25-NA-26",
"PRE4g9-MSL5-NRg-4",
"PRE4g9-SEC24-TRg-2",
"PRE4g9-RPL30-NRg-5",
"PRE4g9-SNU71-NRg-3",
"PRE4g9-CDC33-NRg-1",
"PRE4g9-RPN6-TRg-4",
"PRE4g9-NAB2-TRg-4",
"PRE4g9-NAB2-TRg-6",
"PRE4g9-YTM1-NRg-1",
"PRE4g9-OLE1-TRg-8",
"PRE4g9-OLE1-TRg-1",
"PRE4g9-UTP7-TRg-4",
"PRE4g9-ACT1-NRg-6",
"PRE4g9-RPL18A-NRg-3",
"PRE4g9-BRX1-NRg-1",
"PRE4g9-NAF1-TRg-8",
"PRE4g9-NAF1-TRg-6",
"PRE4g9-NAF1-TRg-4",
"PRE4g9-CDC8-TRg-2",
"PRE4g9-NSE4-TRg-1",
"PRE4g9-PAB1-NRg-2",
"PRE4g9-PRP43-TRg-4",
"PRE4g9-SEC2-NRg-3",
"PRE4g9-SEC2-NRg-6",
"PRE4g9-MPP10-NRg-5",
"PRE4g9-YDR355C-TRg-2",
"PRE4g9-YLR339C-TRg-9",
"PRE4g9-SNM1-TRg-2",
"PRE4g9-ALR1-NRg-4",
"PRE4g9-ALR1-NRg-1",
"PRE4g9-ALR1-NRg-3",
"PRE4g9-RPL10-TRg-1",
"PRE4g9-RPL28-TRg-2",
"PRE4g9-UTP25-TRg-1",
"PRE4g9-POB3-TRg-1",
"PRE4g9-POB3-TRg-3",
"PRE4g9-POB3-TRg-2",
"PRE4g9-MED11-TRg-1",
"PRE4g9-ISA1-TRg-15",
"PRE4g9-RRP1-NRg-1",
"PRE4g9-MES1-NRg-1",
"PRE4g9-SEC13-NRg-5",
"PRE4g9-MCM2-NRg-2",
"PRE4g9-ALA1-TRg-4",
"PRE4g9-MTG2-TRg-5",
"PRE4g9-TIF35-NRg-3",
"PRE4g9-NSE1-TRg-3",
"PRE4g9-NSE1-TRg-4",
"PRE4g9-MOB2-NRg-6",
"PRE4g9-VRG4-NRg-3",
"PRE4g9-PRP9-TRg-3",
"PRE4g9-HYM1-TRg-5",
"PRE4g9-POP1-TRg-5",
"PRE4g9-POP1-TRg-9",
"PRE4g9-RPL17A-TRg-1",
"PRE4g9-SLD2-TRg-1",
"PRE4g9-CDC48-NRg-7",
"PRE4g9-FHL1-NRg-2",
"PRE4g9-BET3-NRg-7",
"PRE4g9-MAK21-TRg-1",
"PRE4g9-BRN1-TRg-4",
"PRE4g9-FBA1-NRg-3",
"PRE4g9-CDC42-TRg-6",
"PRE4g9-CDC42-TRg-7",
"PRE4g9-COG4-NRg-1",
"PRE4g9-ATP3-NRg-3",
"PRE4g9-ATP3-NRg-2",
"PRE4g9-SMP3-TRg-5",
"PRE4g9-CFT2-NRg-2",
"PRE4g9-FAS2-TRg-5",
"PRE4g9-DBP2-NRg-3",
"PRE4g9-DBP2-NRg-2",
"PRE4g9-MPS2-NRg-4",
"PRE4g9-ARC35-TRg-2",
"PRE4g9-ARC35-TRg-5",
"PRE4g9-MRD1-TRg-1",
"PRE4g9-RLP7-TRg-1",
"PRE4g9-SPC34-TRg-1",
"PRE4g9-CDC45-TRg-2",
"PRE4g9-GCD6-TRg-3",
"PRE4g9-GCD6-TRg-4",
"PRE4g9-YPT6-NRg-2",
"PRE4g9-RPS13-TRg-2",
"PRE4g9-IPI3-TRg-3",
"PRE4g9-TIF5-NRg-9",
"PRE4g9-TIF5-NRg-7",
"PRE4g9-TIF5-NRg-6",
"PRE4g9-NAB3-TRg-3",
"PRE4g9-GCD2-TRg-1",
"PRE4g9-UBA1-TRg-2",
"PRE4g9-SLD3-TRg-6",
"PRE4g9-LCB1-TRg-5",
"PRE4g9-TOA2-TRg-6",
"PRE4g9-TOA2-TRg-1",
"PRE4g9-TOA2-TRg-3",
"PRE4g9-LSM2-TRg-1",
"PRE4g9-YML6-TRg-13",
"PRE4g9-YML6-TRg-12",
"PRE4g9-UTP15-NRg-1",
"PRE4g9-TIF6-NRg-8",
"PRE4g9-SUP35-NRg-1",
"PRE4g9-MPP10-NRg-1",
"PRE4g9-SWI3-TRg-7",
"PRE4g9-SSN3-NRg-2",
"PRE4g9-SEC13-NRg-7",
"PRE4g9-RPS15-NRg-3",
"PRE4g9-RPL3-TRg-2",
"PRE4g9-FBA1-NRg-2",
"PRE4g9-FBA1-NRg-1",
"PRE4g9-FBA1-NRg-5",
"PRE4g9-DAM1-TRg-2",
"PRE4g9-NHP2-TRg-2",
"PRE4g9-HCA4-NRg-6",
"PRE4g9-PRE3-TRg-4",
"PRE4g9-DBP5-NRg-4",
"PRE4g9-SPT6-NRg-4",
"PRE4g9-SPT6-NRg-2",
"PRE4g9-RPL18A-TRg-4",
"PRE4g9-KSH1-TRg-1",
"PRE4g9-KSH1-TRg-3",
"PRE4g9-IPI3-NRg-1",
"PRE4g9-PGA2-TRg-8",
"PRE4g9-RPL18A-TRg-2",
"PRE4g9-RPL33A-NRg-6",
"PRE4g9-TAF12-NRg-2",
"PRE4g9-USE1-TRg-5",
"PRE4g9-YNL114C-TRg-1",
"PRE4g9-SMC5-TRg-7",
"PRE4g9-SMC5-TRg-6",
"PRE4g9-RSC58-TRg-1",
"PRE4g9-CTF13-TRg-2",
"PRE4g9-NAB2-NRg-2",
"PRE4g9-MCM7-TRg-4",
"PRE4g9-BCP1-NRg-5",
"PRE4g9-STU2-TRg-3",
"PRE4g9-SEC21-NRg-6",
"PRE4g9-SEC21-NRg-3",
"PRE4g9-RPL1B-TRg-3",
"PRE4g9-SEC20-NRg-2",
"PRE4g9-VMA3-NRg-2",
"PRE4g9-SEC23-NRg-5",
"PRE4g9-CDC28-TRg-4",
"PRE4g9-RPN12-NRg-11",
"PRE4g9-PUP3-TRg-3",
"PRE4g9-SEC31-TRg-2",
"PRE4g9-SED5-TRg-6",
"PRE4g9-SED5-TRg-5",
"PRE4g9-RPL33A-TRg-1",
"PRE4g9-RPL33A-TRg-2",
"PRE4g9-MRPL11-TRg-2",
"PRE4g9-RTP1-NRg-2",
"PRE4g9-NUG1-TRg-2",
"PRE4g9-VPH2-TRg-4",
"PRE4g9-COP1-NRg-3",
"PRE4g9-CRM1-NRg-1",
"PRE4g9-RPL5-NRg-4",
"PRE4g9-SNU13-NRg-4",
"PRE4g9-PFS2-TRg-3",
"PRE4g9-MPP10-TRg-2",
"PRE4g9-TSR4-NRg-2",
"PRE4g9-RSC2-TRg-1",
"PRE4g9-SEC65-TRg-2",
"PRE4g9-SMI1-NRg-1",
"PRE4g9-RTT105-NRg-4",
"PRE4g9-VMA5-TRg-3",
"PRE4g9-VMA5-TRg-5",
"PRE4g9-RRP1-TRg-3",
"PRE4g9-CLC1-TRg-2",
"PRE4g9-GCD6-NRg-1",
"PRE4g9-GCD6-NRg-2",
"PRE4g9-PXR1-TRg-1",
"PRE4g9-CDC14-NRg-1",
"PRE4g9-PCF11-TRg-6",
"PRE4g9-PCF11-TRg-5",
"PRE4g9-PCF11-TRg-4",
"PRE4g9-SEC31-NRg-1",
"PRE4g9-RRP5-NRg-1",
"PRE4g9-PRE10-TRg-5",
"PRE4g9-PRE10-TRg-1",
"PRE4g9-RPS5-TRg-2",
"PRE4g9-NSP1-TRg-4",
"PRE4g9-PRP38-TRg-4",
"PRE4g9-RCF1-NRg-5",
"PRE4g9-RSC3-TRg-4",
"PRE4g9-RSC3-TRg-5",
"PRE4g9-RSC3-TRg-6",
"PRE4g9-HTA1-NRg-12",
"PRE4g9-HTA1-NRg-11",
"PRE4g9-UTP23-TRg-2",
"PRE4g9-GCD7-NRg-1",
"PRE4g9-GCD7-NRg-2",
"PRE4g9-GCD7-NRg-6",
"PRE4g9-GAL11-NRg-2",
"PRE4g9-GAL11-NRg-9",
"PRE4g9-PHO4-TRg-5",
"PRE4g9-SNP1-NRg-3",
"PRE4g9-RPC37-TRg-5",
"PRE4g9-CRM1-TRg-5",
"PRE4g9-CRM1-TRg-2",
"PRE4g9-ASK1-TRg-7",
"PRE4g9-STU2-NRg-4",
"PRE4g9-NEO1-NRg-3",
"PRE4g9-GAL11-TRg-5",
"PRE4g9-GAL11-TRg-7",
"PRE4g9-SAM50-NRg-3",
"PRE4g9-CSL4-TRg-2",
"PRE4g9-CCT5-TRg-2",
"PRE4g9-POL30-NRg-1",
"PRE4g9-MED4-TRg-4",
"PRE4g9-MED4-TRg-3",
"PRE4g9-MED4-TRg-2",
"PRE4g9-GDI1-TRg-4",
"PRE4g9-GDI1-TRg-3",
"PRE4g9-REB1-TRg-6",
"PRE4g9-MRPL37-NRg-2",
"PRE4g9-NOC3-TRg-3",
"PRE4g9-SPC97-TRg-3",
"PRE4g9-IPP1-TRg-3",
"PRE4g9-IPP1-TRg-2",
"PRE4g9-PTI1-TRg-3",
"PRE4g9-PTI1-TRg-5",
"PRE4g9-RFC5-NRg-1",
"PRE4g9-CDC24-TRg-1",
"PRE4g9-CDC24-TRg-3",
"PRE4g9-CDC24-TRg-5",
"PRE4g9-CDC24-TRg-6",
"PRE4g9-UTP23-TRg-6",
"PRE4g9-UTP23-TRg-4",
"PRE4g9-UTP23-TRg-1",
"PRE4g9-RHO3-NRg-4",
"PRE4g9-TRS23-NRg-1",
"PRE4g9-TRS23-NRg-3",
"PRE4g9-RSP5-TRg-2",
"PRE4g9-RSP5-TRg-1",
"PRE4g9-SDA1-NRg-1",
"PRE4g9-KAP95-TRg-8",
"PRE4g9-ACO1-TRg-6",
"PRE4g9-HTA1-NRg-3",
"PRE4g9-HTA1-NRg-2",
"PRE4g9-SPN1-TRg-1",
"PRE4g9-MOT1-NRg-7",
"PRE4g9-RPL17A-NRg-4",
"PRE4g9-ADA2-TRg-4",
"PRE4g9-SFH1-NRg-1",
"PRE4g9-SPC97-NRg-5",
"PRE4g9-PRP22-TRg-3",
"PRE4g9-SEN15-TRg-2",
"PRE4g9-RPL3-NRg-2",
"PRE4g9-ISD11-NRg-2",
"PRE4g9-HEM12-TRg-8",
"PRE4g9-SEC10-TRg-1",
"PRE4g9-HTB1-TRg-7",
"PRE4g9-TTI2-TRg-1",
"PRE4g9-ACP1-TRg-2",
"PRE4g9-ACP1-TRg-4",
"PRE4g9-GAL11-NRg-10",
"PRE4g9-UTP22-TRg-2",
"PRE4g9-MST1-NRg-5",
"PRE4g9-RIB7-NRg-2",
"PRE4g9-MCD1-TRg-6",
"PRE4g9-MCD1-TRg-5",
"PRE4g9-GPI8-NRg-2",
"PRE4g9-THS1-TRg-2",
"PRE4g9-RRP7-TRg-2",
"PRE4g9-RRP7-TRg-5",
"PRE4g9-SMX2-NRg-7",
"PRE4g9-RRP45-TRg-5",
"PRE4g9-RRP45-TRg-4",
"PRE4g9-CNS1-TRg-2",
"PRE4g9-FBP1-NRg-9",
"PRE4g9-GCD11-NRg-1",
"PRE4g9-RPL10-TRg-2",
"PRE4g9-NUP192-TRg-4",
"PRE4g9-NUP145-NRg-4",
"PRE4g9-HEM12-TRg-6",
"PRE4g9-PLC1-TRg-3",
"PRE4g9-RPA43-TRg-1",
"PRE4g9-RPB7-NRg-2",
"PRE4g9-RPB7-NRg-3",
"PRE4g9-NSL1-NRg-1",
"PRE4g9-UTP6-TRg-3",
"PRE4g9-UTP6-TRg-1",
"PRE4g9-YJU2-TRg-5",
"PRE4g9-FRS2-NRg-5",
"PRE4g9-TIF35-NRg-2",
"PRE4g9-GPI15-TRg-1",
"PRE4g9-NOP1-NRg-5",
"PRE4g9-GPI15-TRg-4",
"PRE4g9-COG4-TRg-1",
"PRE4g9-TFA1-TRg-1",
"PRE4g9-RHO1-NRg-2",
"PRE4g9-RHO1-NRg-1",
"PRE4g9-CDC55-NRg-2",
"PRE4g9-IDI1-NRg-7",
"PRE4g9-RPL32-TRg-5",
"PRE4g9-RPB5-TRg-4",
"PRE4g9-DIP2-TRg-5",
"PRE4g9-DIP2-TRg-1",
"PRE4g9-RPC40-TRg-2",
"PRE4g9-CDC6-TRg-5",
"PRE4g9-CDC6-TRg-3",
"PRE4g9-DAD2-TRg-2",
"PRE4g9-RVS161-TRg-2",
"PRE4g9-RVS161-TRg-1",
"PRE4g9-SUP45-NRg-3",
"PRE4g9-SRB6-NRg-5",
"PRE4g9-RPC11-TRg-4",
"PRE4g9-RKI1-TRg-8",
"PRE4g9-NIP7-TRg-3",
"PRE4g9-RPL33A-NRg-12",
"PRE4g9-SAM50-TRg-4",
"PRE4g9-NOP4-NRg-1",
"PRE4g9-NOP4-NRg-3",
"PRE4g9-SMX2-TRg-5",
"PRE4g9-POL12-NRg-2",
"PRE4g9-BMS1-NRg-2",
"PRE4g9-RPA190-TRg-5",
"PRE4g9-ALG14-NRg-4",
"PRE4g9-ALG14-NRg-1",
"PRE4g9-PRE5-NRg-1",
"PRE4g9-BIG1-NRg-2",
"PRE4g9-TFA2-TRg-4",
"PRE4g9-IMP4-TRg-6",
"PRE4g9-PAN1-NRg-1",
"PRE4g9-UTP13-TRg-2",
"PRE4g9-KAE1-NRg-3",
"PRE4g9-ERG20-TRg-1",
"PRE4g9-CDC20-TRg-6",
"PRE4g9-PWP2-NRg-2",
"PRE4g9-COG1-NRg-1",
"PRE4g9-RPL1B-TRg-4",
"PRE4g9-RPL1B-TRg-7",
"PRE4g9-UTP20-TRg-3",
"PRE4g9-UTP20-TRg-4",
"PRE4g9-RPL25-TRg-4",
"PRE4g9-RPL25-TRg-2",
"PRE4g9-MCM7-NRg-1",
"PRE4g9-MRP49-TRg-5",
"PRE4g9-ERO1-NRg-3",
"PRE4g9-UTP5-TRg-7",
"PRE4g9-MCM4-NRg-1",
"PRE4g9-PRE3-NRg-1",
"PRE4g9-FCF1-NRg-1",
"PRE4g9-CUS1-NRg-1",
"PRE4g9-PSF1-TRg-2",
"PRE4g9-BCP1-TRg-2",
"PRE4g9-PAN1-TRg-1",
"PRE4g9-PAN1-TRg-3",
"PRE4g9-PAN1-TRg-4",
"PRE4g9-VPS3-TRg-2",
"PRE4g9-YIL060W-NRg-1",
"PRE4g9-VPS53-NRg-1",
"PRE4g9-CYR1-TRg-4",
"PRE4g9-CYR1-TRg-7",
"PRE4g9-MPS1-NRg-1",
"PRE4g9-SRP1-TRg-5",
"PRE4g9-SRP1-TRg-4",
"PRE4g9-TAF12-TRg-2",
"PRE4g9-TAF12-TRg-3",
"PRE4g9-POP4-TRg-1",
"PRE4g9-SPT16-TRg-1",
"PRE4g9-NUP82-TRg-4",
"PRE4g9-DML1-TRg-3",
"PRE4g9-RPA43-NRg-3",
"PRE4g9-STU2-NRg-3",
"PRE4g9-POP4-NRg-4",
"PRE4g9-MCD1-TRg-2",
"PRE4g9-RPS3-NRg-4",
"PRE4g9-PRP9-TRg-4",
"PRE4g9-RPP1-NRg-2",
"PRE4g9-MTR2-NRg-11",
"PRE4g9-GCD11-TRg-1",
"PRE4g9-RPF1-TRg-3",
"PRE4g9-SUB2-NRg-4",
"PRE4g9-GPI15-TRg-3",
"PRE4g9-ERG9-TRg-6",
"PRE4g9-RPT2-NRg-1",
"PRE4g9-YOS1-NRg-3",
"PRE4g9-SCM3-TRg-4",
"PRE4g9-SCM3-TRg-6",
"PRE4g9-RLP7-NRg-1",
"PRE4g9-TFB2-NRg-4",
"PRE4g9-IMP4-TRg-1",
"PRE4g9-IMP4-TRg-3",
"PRE4g9-PRE4-TRg-3",
"PRE4g9-SUB2-TRg-3",
"PRE4g9-RPP0-NRg-4",
"PRE4g9-RPP0-NRg-3",
"PRE4g9-TOM40-TRg-4",
"PRE4g9-FUR1-NRg-12",
"PRE4g9-TOM40-TRg-2",
"PRE4g9-VMA11-NRg-4",
"PRE4g9-PGS1-NRg-4",
"PRE4g9-URB1-TRg-4",
"PRE4g9-ARP4-TRg-3",
"PRE4g9-RPT3-TRg-3",
"PRE4g9-SUI3-TRg-3",
"PRE4g9-RFC5-NRg-2",
"PRE4g9-RRP14-TRg-2",
"PRE4g9-SCC2-TRg-1",
"PRE4g9-SSC1-TRg-3",
"PRE4g9-RRP9-TRg-3",
"PRE4g9-MOT1-NRg-9",
"PRE4g9-RPL42A-NRg-2",
"PRE4g9-SEC16-TRg-7",
"PRE4g9-IMP4-NRg-2",
"PRE4g9-YEF3-NRg-4",
"PRE4g9-PUP1-TRg-1",
"PRE4g9-UTP22-TRg-6",
"PRE4g9-DBP2-NRg-4",
"PRE4g9-PRE2-TRg-7",
"PRE4g9-ATP16-TRg-6",
"PRE4g9-UTP13-TRg-4",
"PRE4g9-DOP1-NRg-4",
"PRE4g9-TIM44-TRg-3",
"PRE4g9-ATP16-TRg-2",
"PRE4g9-ENP1-NRg-3",
"PRE4g9-NAF1-TRg-3",
"PRE4g9-COG4-TRg-2",
"PRE4g9-SOG2-TRg-7",
"PRE4g9-YDR341C-TRg-3",
"PRE4g9-YMR290W-A-TRg-10",
"PRE4g9-NUP192-NRg-9",
"PRE4g9-RPS31-NRg-8",
"PRE4g9-SPC97-NRg-6",
"PRE4g9-EBP2-NRg-1",
"PRE4g9-CDC48-TRg-5",
"PRE4g9-RPT1-TRg-4",
"PRE4g9-ULP1-NRg-2",
"PRE4g9-RPN3-TRg-6",
"PRE4g9-RPT1-TRg-5",
"PRE4g9-KRE5-TRg-2",
"PRE4g9-TBF1-NRg-8",
"PRE4g9-UTP22-NRg-4",
"PRE4g9-SSC1-NRg-4",
"PRE4g9-REB1-TRg-4",
"PRE4g9-CDC48-NRg-9",
"PRE4g9-FAS2-TRg-8",
"PRE4g9-TAO3-TRg-8",
"PRE4g9-CKS1-TRg-5",
"PRE4g9-YLR379W-TRg-7",
"PRE4g9-TEN1-NRg-2",
"PRE4g9-RPL42A-TRg-2",
"PRE4g9-SEC27-TRg-4",
"PRE4g9-TBF1-NRg-4",
"PRE4g9-RPT1-NRg-6",
"PRE4g9-COG1-TRg-3",
"PRE4g9-SUI1-TRg-6",
"PRE4g9-TIM23-TRg-6",
"PRE4g9-CDC48-NRg-6",
"PRE4g9-EPL1-TRg-5",
"PRE4g9-RPT5-TRg-8",
"PRE4g9-ATP16-NRg-4",
"PRE4g9-RPN6-TRg-3",
"PRE4g9-ERG9-NRg-6",
"PRE4g9-SMX3-TRg-1",
"PRE4g9-NCB2-NRg-3",
"PRE4g9-SEC16-NRg-12",
"PRE4g9-RPN6-TRg-2",
"PRE4g9-REB1-NRg-4",
"PRE4g9-ATP16-TRg-9",
"PRE4g9-ERG9-NRg-7",
"PRE4g3-RPL15A-NRg-4",
"PRE4g3-RPL15A-NRg-5",
"PRE4g3-KRE33-TRg-1",
"PRE4g3-PMI40-NRg-1",
"PRE4g3-NOP19-NRg-3",
"PRE4g3-SRP14-NRg-4",
"PRE4g3-SEC27-TRg-2",
"PRE4g3-GPI14-TRg-3",
"PRE4g3-PAH1-TRg-7",
"PRE4g3-PAH1-TRg-6",
"PRE4g3-PAH1-TRg-5",
"PRE4g3-PAH1-TRg-3",
"PRE4g3-COG3-TRg-1",
"PRE4g3-HTS1-NRg-5",
"PRE4g3-MSN5-TRg-7",
"PRE4g3-ERG26-TRg-1",
"PRE4g3-SMD2-TRg-5",
"PRE4g3-SMD2-TRg-4",
"PRE4g3-SMD2-TRg-1",
"PRE4g3-PRE7-TRg-4",
"PRE4g3-PRE7-TRg-7",
"PRE4g3-SEC6-TRg-3",
"PRE4g3-ESF2-NRg-1",
"PRE4g3-ESF2-NRg-3",
"PRE4g3-AFG2-TRg-2",
"PRE4g3-RRP36-TRg-3",
"PRE4g3-RRP36-TRg-5",
"PRE4g3-GCR1-NRg-2",
"PRE4g3-PRE4-NRg-4",
"PRE4g3-PRE4-NRg-9",
"PRE4g3-DSN1-NRg-2",
"PRE4g3-GPI11-TRg-3",
"PRE4g3-POP3-TRg-1",
"PRE4g3-MNE1-TRg-5",
"PRE4g3-RRP12-NRg-1",
"PRE4g3-RSC6-TRg-2",
"PRE4g3-CDC25-TRg-1",
"PRE4g3-CDC25-TRg-9",
"PRE4g3-YPP1-NRg-3",
"PRE4g3-NFS1-NRg-9",
"PRE4g3-NFS1-NRg-8",
"PRE4g3-UBA2-TRg-1",
"PRE4g3-ARP2-NRg-3",
"PRE4g3-MAK16-TRg-1",
"PRE4g3-CEP3-NRg-1",
"PRE4g3-GUK1-TRg-5",
"PRE4g3-GUK1-TRg-2",
"PRE4g3-GPI12-NRg-6",
"PRE4g3-RPS5-NRg-5",
"PRE4g3-RPS5-NRg-2",
"PRE4g3-RPC19-NRg-1",
"PRE4g3-TIM54-TRg-1",
"PRE4g3-TEN1-TRg-2",
"PRE4g3-SAH1-NRg-4",
"PRE4g3-SAH1-NRg-5",
"PRE4g3-SAH1-NRg-3",
"PRE4g3-ATP15-NRg-5",
"PRE4g3-SCD5-TRg-5",
"PRE4g3-ARB1-NRg-2",
"PRE4g3-ARB1-NRg-4",
"PRE4g3-PUP2-TRg-1",
"PRE4g3-CCT8-TRg-2",
"PRE4g3-MCM4-TRg-1",
"PRE4g3-LSM4-TRg-1",
"PRE4g3-NOP53-NRg-1",
"PRE4g3-ATP3-TRg-4",
"PRE4g3-AFG2-NRg-3",
"PRE4g3-PRO3-NRg-3",
"PRE4g3-NRD1-NRg-10",
"PRE4g3-SEC61-TRg-2",
"PRE4g3-RHO3-TRg-4",
"PRE4g3-SNF2-TRg-6",
"PRE4g3-SMD2-NRg-3",
"PRE4g3-RSC4-TRg-2",
"PRE4g3-RSC4-TRg-1",
"PRE4g3-TIF34-TRg-2",
"PRE4g3-BET1-NRg-1",
"PRE4g3-CDC8-NRg-2",
"PRE4g3-PRP42-TRg-2",
"PRE4g3-RRB1-TRg-2",
"PRE4g3-SPC24-TRg-1",
"PRE4g3-ILS1-NRg-1",
"PRE4g3-GFA1-TRg-2",
"PRE4g3-SEC21-NRg-10",
"PRE4g3-RPC10-NRg-1",
"PRE4g3-RPB10-TRg-3",
"PRE4g3-RPB10-TRg-2",
"PRE4g3-YNL181W-TRg-1",
"PRE4g3-RAD3-NRg-1",
"PRE4g3-NOP10-TRg-1",
"PRE4g3-BFR2-TRg-3",
"PRE4g3-MCM2-TRg-6",
"PRE4g3-MCM2-TRg-4",
"PRE4g3-MPP10-TRg-1",
"PRE4g3-RET2-TRg-4",
"PRE4g3-RET2-TRg-1",
"PRE4g3-RPS2-NRg-1",
"PRE4g3-RPS2-NRg-2",
"PRE4g3-ORC4-NRg-3",
"PRE4g3-TIP20-TRg-7",
"PRE4g3-SMT3-TRg-1",
"PRE4g3-MSS18-NRg-6",
"PRE4g3-YEF3-NRg-9",
"PRE4g3-ASK1-NRg-1",
"PRE4g3-SMC1-TRg-1",
"PRE4g3-NIP1-NRg-1",
"PRE4g3-RPP1-NRg-1",
"PRE4g3-YDJ1-TRg-6",
"PRE4g3-SUB2-NRg-1",
"PRE4g3-TIM10-NRg-8",
"PRE4g3-TIM10-NRg-4",
"PRE4g3-TIM10-NRg-7",
"PRE4g3-SKI6-TRg-4",
"PRE4g3-TUB4-TRg-1",
"PRE4g3-CDC37-NRg-2",
"PRE4g3-ISD11-TRg-3",
"PRE4g3-YOS1-TRg-4",
"PRE4g3-SSC1-TRg-6",
"PRE4g3-MTR3-TRg-5",
"PRE4g3-MTR3-TRg-6",
"PRE4g3-TFA1-TRg-2",
"PRE4g3-CDC3-NRg-3",
"PRE4g3-ERG25-TA-18",
"PRE4g3-RPB11-TRg-4",
"PRE4g3-RPB11-TRg-1",
"PRE4g3-RPB11-TRg-2",
"PRE4g3-DED1-TRg-3",
"PRE4g3-DED1-TRg-1",
"PRE4g3-DED1-TRg-6",
"PRE4g3-DED1-TRg-4",
"PRE4g3-RPL10-NRg-5",
"PRE4g3-RPL10-NRg-4",
"PRE4g3-EFB1-NRg-1",
"PRE4g3-EFB1-NRg-5",
"PRE4g3-EFB1-NRg-4",
"PRE4g3-RPT3-NRg-1",
"PRE4g3-SAC6-TRg-8",
"PRE4g3-SAC6-TRg-4",
"PRE4g3-SAC6-TRg-5",
"PRE4g3-SAC6-TRg-3",
"PRE4g3-DIM1-TRg-5",
"PRE4g3-DIM1-TRg-7",
"PRE4g3-RPC17-NRg-1",
"PRE4g3-RPC17-NRg-2",
"PRE4g3-YDR341C-TRg-1",
"PRE4g3-RAP1-NRg-8",
"PRE4g3-RAP1-NRg-5",
"PRE4g3-RAP1-NRg-2",
"PRE4g3-SEC26-NRg-3",
"PRE4g3-SPP41-TRg-3",
"PRE4g3-TAP42-NRg-1",
"PRE4g3-PGA2-TRg-6",
"PRE4g3-BRL1-TRg-1",
"PRE4g3-FOL2-TRg-1",
"PRE4g3-NAB3-NRg-5",
"PRE4g3-SNF4-TRg-4",
"PRE4g3-HRR25-TRg-2",
"PRE4g3-TRS23-TRg-4",
"PRE4g3-CTR86-TRg-4",
"PRE4g3-RPB5-TRg-5",
"PRE4g3-SPN1-NRg-2",
"PRE4g3-SPN1-NRg-1",
"PRE4g3-SEC61-NRg-1",
"PRE4g3-SEC61-NRg-7",
"PRE4g3-TUS1-TRg-3",
"PRE4g3-OLE1-NRg-2",
"PRE4g3-AFG2-TRg-1",
"PRE4g3-TOA2-NRg-1",
"PRE4g3-USO1-TRg-1",
"PRE4g3-UTP22-NRg-2",
"PRE4g3-RIB1-TRg-3",
"PRE4g3-RIB1-TRg-7",
"PRE4g3-RIB1-TRg-4",
"PRE4g3-COG1-TRg-1",
"PRE4g3-RPL32-NRg-2",
"PRE4g3-GLC7-NRg-3",
"PRE4g3-GLC7-NRg-4",
"PRE4g3-HSF1-TRg-2",
"PRE4g3-DAM1-NRg-5",
"PRE4g3-SEC18-TRg-4",
"PRE4g3-SEC18-TRg-5",
"PRE4g3-PAB1-NRg-3",
"PRE4g3-POP8-TRg-2",
"PRE4g3-PAB1-NRg-4",
"PRE4g3-BIG1-TRg-4",
"PRE4g3-BIG1-TRg-5",
"PRE4g3-BIG1-TRg-6",
"PRE4g3-RPO41-NRg-1",
"PRE4g3-RVB2-NRg-2",
"PRE4g3-PET117-NRg-8",
"PRE4g3-VPS45-NRg-9",
"PRE4g3-YCG1-NRg-1",
"PRE4g3-NOC4-NRg-1",
"PRE4g3-NMD3-NRg-2",
"PRE4g3-DRS1-TRg-2",
"PRE4g3-HTB1-NRg-2",
"PRE4g3-IPI1-TRg-2",
"PRE4g3-SEC18-NRg-1",
"PRE4g3-SEC18-NRg-2",
"PRE4g3-JIP5-NRg-2",
"PRE4g3-YPT1-TRg-3",
"PRE4g3-YPT1-TRg-2",
"PRE4g3-CLF1-NRg-2",
"PRE4g3-SNF2-NRg-7",
"PRE4g3-SNF2-NRg-4",
"PRE4g3-RPL25-NRg-1",
"PRE4g3-NOP56-TRg-1",
"PRE4g3-NOP56-TRg-2",
"PRE4g3-TRS31-TRg-1",
"PRE4g3-DBF4-TRg-2",
"PRE4g3-DBF4-TRg-1",
"PRE4g3-RPC19-TRg-4",
"PRE4g3-RPC19-TRg-6",
"PRE4g3-RPC19-TRg-3",
"PRE4g3-ROK1-NRg-1",
"PRE4g3-CDC33-TRg-4",
"PRE4g3-DHR2-TRg-3",
"PRE4g3-RRP42-NRg-5",
"PRE4g3-CLF1-TRg-1",
"PRE4g3-ERG11-NA-16",
"PRE4g3-VAS1-NRg-4",
"PRE4g3-PIK1-NRg-2",
"PRE4g3-SAR1-NRg-7",
"PRE4g3-SAR1-NRg-4",
"PRE4g3-RPS3-TRg-1",
"PRE4g3-YTM1-TRg-2",
"PRE4g3-SUI3-NRg-5",
"PRE4g3-SUI3-NRg-2",
"PRE4g3-RRP7-TRg-4",
"PRE4g3-RRP7-TRg-6",
"PRE4g3-NIP7-TRg-2",
"PRE4g3-MDM35-TRg-1",
"PRE4g3-ALA1-NRg-1",
"PRE4g3-DOA4-NRg-2",
"PRE4g3-RPS13-NRg-1",
"PRE4g3-YSF3-TRg-2",
"PRE4g3-RPS2-NRg-11",
"PRE4g3-SSL1-TRg-10",
"PRE4g3-NIP7-TRg-1",
"PRE4g3-LST8-NRg-1",
"PRE4g3-TAF4-TRg-3",
"PRE4g3-HAS1-TRg-2",
"PRE4g3-GLC7-TRg-2",
"PRE4g3-CDC45-NRg-1",
"PRE4g3-SEC22-NRg-8",
"PRE4g3-YOS1-TRg-2",
"PRE4g3-RBA50-TRg-3",
"PRE4g3-SPP41-NRg-2",
"PRE4g3-PRP46-TRg-2",
"PRE4g3-PGA2-NRg-1",
"PRE4g3-CBF5-TRg-3",
"PRE4g3-TCP1-NRg-3",
"PRE4g3-TCP1-NRg-2",
"PRE4g3-ERG26-NRg-2",
"PRE4g3-ERG26-NRg-4",
"PRE4g3-MES1-TRg-5",
"PRE4g3-HTS1-TRg-2",
"PRE4g3-SSS1-TRg-3",
"PRE4g3-SSS1-TRg-2",
"PRE4g3-SYS1-TRg-7",
"PRE4g3-SYS1-TRg-2",
"PRE4g3-SYS1-TRg-1",
"PRE4g3-BFR2-TRg-1",
"PRE4g3-EOS1-TRg-3",
"PRE4g3-TAF4-NRg-1",
"PRE4g3-ARL3-NRg-8",
"PRE4g3-RPN5-NRg-1",
"PRE4g3-TIM9-NRg-2",
"PRE4g3-NUP57-NRg-3",
"PRE4g3-VPS4-TRg-1",
"PRE4g3-CDC3-TRg-4",
"PRE4g3-BBP1-NRg-1",
"PRE4g3-BBP1-NRg-2",
"PRE4g3-USE1-NRg-3",
"PRE4g3-CCT7-TRg-1",
"PRE4g3-SAH1-TRg-3",
"PRE4g3-CHS2-TRg-1",
"PRE4g3-DPM1-TRg-2",
"PRE4g3-BBP1-TRg-1",
"PRE4g3-NRD1-TRg-4",
"PRE4g3-RPB3-NRg-1",
"PRE4g3-PHO85-NRg-6",
"PRE4g3-SNF6-TRg-6",
"PRE4g3-PRP38-NRg-2",
"PRE4g3-OAR1-NRg-3",
"PRE4g3-ROX3-NRg-1",
"PRE4g3-YPP1-TRg-6",
"PRE4g3-CBF2-NRg-8",
"PRE4g3-SPT6-TRg-5",
"PRE4g3-SEC10-NRg-1",
"PRE4g3-NSL1-NRg-3",
"PRE4g3-NRD1-NRg-8",
"PRE4g3-RPB3-TRg-1",
"PRE4g3-NRD1-NRg-4",
"PRE4g3-RVB1-TRg-2",
"PRE4g3-TIF5-NRg-8",
"PRE4g3-EOS1-NRg-1",
"PRE4g3-ERG25-NA-26",
"PRE4g3-MSL5-NRg-4",
"PRE4g3-SEC24-TRg-2",
"PRE4g3-RPL30-NRg-5",
"PRE4g3-SNU71-NRg-3",
"PRE4g3-CDC33-NRg-1",
"PRE4g3-RPN6-TRg-4",
"PRE4g3-NAB2-TRg-4",
"PRE4g3-NAB2-TRg-6",
"PRE4g3-YTM1-NRg-1",
"PRE4g3-OLE1-TRg-8",
"PRE4g3-OLE1-TRg-1",
"PRE4g3-UTP7-TRg-4",
"PRE4g3-ACT1-NRg-6",
"PRE4g3-RPL18A-NRg-3",
"PRE4g3-BRX1-NRg-1",
"PRE4g3-NAF1-TRg-8",
"PRE4g3-NAF1-TRg-6",
"PRE4g3-NAF1-TRg-4",
"PRE4g3-CDC8-TRg-2",
"PRE4g3-NSE4-TRg-1",
"PRE4g3-PAB1-NRg-2",
"PRE4g3-PRP43-TRg-4",
"PRE4g3-SEC2-NRg-3",
"PRE4g3-SEC2-NRg-6",
"PRE4g3-MPP10-NRg-5",
"PRE4g3-YDR355C-TRg-2",
"PRE4g3-YLR339C-TRg-9",
"PRE4g3-SNM1-TRg-2",
"PRE4g3-ALR1-NRg-4",
"PRE4g3-ALR1-NRg-1",
"PRE4g3-ALR1-NRg-3",
"PRE4g3-RPL10-TRg-1",
"PRE4g3-RPL28-TRg-2",
"PRE4g3-UTP25-TRg-1",
"PRE4g3-POB3-TRg-1",
"PRE4g3-POB3-TRg-3",
"PRE4g3-POB3-TRg-2",
"PRE4g3-MED11-TRg-1",
"PRE4g3-ISA1-TRg-15",
"PRE4g3-RRP1-NRg-1",
"PRE4g3-MES1-NRg-1",
"PRE4g3-SEC13-NRg-5",
"PRE4g3-MCM2-NRg-2",
"PRE4g3-ALA1-TRg-4",
"PRE4g3-MTG2-TRg-5",
"PRE4g3-TIF35-NRg-3",
"PRE4g3-NSE1-TRg-3",
"PRE4g3-NSE1-TRg-4",
"PRE4g3-MOB2-NRg-6",
"PRE4g3-VRG4-NRg-3",
"PRE4g3-PRP9-TRg-3",
"PRE4g3-HYM1-TRg-5",
"PRE4g3-POP1-TRg-5",
"PRE4g3-POP1-TRg-9",
"PRE4g3-RPL17A-TRg-1",
"PRE4g3-SLD2-TRg-1",
"PRE4g3-CDC48-NRg-7",
"PRE4g3-FHL1-NRg-2",
"PRE4g3-BET3-NRg-7",
"PRE4g3-MAK21-TRg-1",
"PRE4g3-BRN1-TRg-4",
"PRE4g3-FBA1-NRg-3",
"PRE4g3-CDC42-TRg-6",
"PRE4g3-CDC42-TRg-7",
"PRE4g3-COG4-NRg-1",
"PRE4g3-ATP3-NRg-3",
"PRE4g3-ATP3-NRg-2",
"PRE4g3-SMP3-TRg-5",
"PRE4g3-CFT2-NRg-2",
"PRE4g3-FAS2-TRg-5",
"PRE4g3-DBP2-NRg-3",
"PRE4g3-DBP2-NRg-2",
"PRE4g3-MPS2-NRg-4",
"PRE4g3-ARC35-TRg-2",
"PRE4g3-ARC35-TRg-5",
"PRE4g3-MRD1-TRg-1",
"PRE4g3-RLP7-TRg-1",
"PRE4g3-SPC34-TRg-1",
"PRE4g3-CDC45-TRg-2",
"PRE4g3-GCD6-TRg-3",
"PRE4g3-GCD6-TRg-4",
"PRE4g3-YPT6-NRg-2",
"PRE4g3-RPS13-TRg-2",
"PRE4g3-IPI3-TRg-3",
"PRE4g3-TIF5-NRg-9",
"PRE4g3-TIF5-NRg-7",
"PRE4g3-TIF5-NRg-6",
"PRE4g3-NAB3-TRg-3",
"PRE4g3-GCD2-TRg-1",
"PRE4g3-UBA1-TRg-2",
"PRE4g3-SLD3-TRg-6",
"PRE4g3-LCB1-TRg-5",
"PRE4g3-TOA2-TRg-6",
"PRE4g3-TOA2-TRg-1",
"PRE4g3-TOA2-TRg-3",
"PRE4g3-LSM2-TRg-1",
"PRE4g3-YML6-TRg-13",
"PRE4g3-YML6-TRg-12",
"PRE4g3-UTP15-NRg-1",
"PRE4g3-TIF6-NRg-8",
"PRE4g3-SUP35-NRg-1",
"PRE4g3-MPP10-NRg-1",
"PRE4g3-SWI3-TRg-7",
"PRE4g3-SSN3-NRg-2",
"PRE4g3-SEC13-NRg-7",
"PRE4g3-RPS15-NRg-3",
"PRE4g3-RPL3-TRg-2",
"PRE4g3-FBA1-NRg-2",
"PRE4g3-FBA1-NRg-1",
"PRE4g3-FBA1-NRg-5",
"PRE4g3-DAM1-TRg-2",
"PRE4g3-NHP2-TRg-2",
"PRE4g3-HCA4-NRg-6",
"PRE4g3-PRE3-TRg-4",
"PRE4g3-DBP5-NRg-4",
"PRE4g3-SPT6-NRg-4",
"PRE4g3-SPT6-NRg-2",
"PRE4g3-RPL18A-TRg-4",
"PRE4g3-KSH1-TRg-1",
"PRE4g3-KSH1-TRg-3",
"PRE4g3-IPI3-NRg-1",
"PRE4g3-PGA2-TRg-8",
"PRE4g3-RPL18A-TRg-2",
"PRE4g3-RPL33A-NRg-6",
"PRE4g3-TAF12-NRg-2",
"PRE4g3-USE1-TRg-5",
"PRE4g3-YNL114C-TRg-1",
"PRE4g3-SMC5-TRg-7",
"PRE4g3-SMC5-TRg-6",
"PRE4g3-RSC58-TRg-1",
"PRE4g3-CTF13-TRg-2",
"PRE4g3-NAB2-NRg-2",
"PRE4g3-MCM7-TRg-4",
"PRE4g3-BCP1-NRg-5",
"PRE4g3-STU2-TRg-3",
"PRE4g3-SEC21-NRg-6",
"PRE4g3-SEC21-NRg-3",
"PRE4g3-RPL1B-TRg-3",
"PRE4g3-SEC20-NRg-2",
"PRE4g3-VMA3-NRg-2",
"PRE4g3-SEC23-NRg-5",
"PRE4g3-CDC28-TRg-4",
"PRE4g3-RPN12-NRg-11",
"PRE4g3-PUP3-TRg-3",
"PRE4g3-SEC31-TRg-2",
"PRE4g3-SED5-TRg-6",
"PRE4g3-SED5-TRg-5",
"PRE4g3-RPL33A-TRg-1",
"PRE4g3-RPL33A-TRg-2",
"PRE4g3-MRPL11-TRg-2",
"PRE4g3-RTP1-NRg-2",
"PRE4g3-NUG1-TRg-2",
"PRE4g3-VPH2-TRg-4",
"PRE4g3-COP1-NRg-3",
"PRE4g3-CRM1-NRg-1",
"PRE4g3-RPL5-NRg-4",
"PRE4g3-SNU13-NRg-4",
"PRE4g3-PFS2-TRg-3",
"PRE4g3-MPP10-TRg-2",
"PRE4g3-TSR4-NRg-2",
"PRE4g3-RSC2-TRg-1",
"PRE4g3-SEC65-TRg-2",
"PRE4g3-SMI1-NRg-1",
"PRE4g3-RTT105-NRg-4",
"PRE4g3-VMA5-TRg-3",
"PRE4g3-VMA5-TRg-5",
"PRE4g3-RRP1-TRg-3",
"PRE4g3-CLC1-TRg-2",
"PRE4g3-GCD6-NRg-1",
"PRE4g3-GCD6-NRg-2",
"PRE4g3-PXR1-TRg-1",
"PRE4g3-CDC14-NRg-1",
"PRE4g3-PCF11-TRg-6",
"PRE4g3-PCF11-TRg-5",
"PRE4g3-PCF11-TRg-4",
"PRE4g3-SEC31-NRg-1",
"PRE4g3-RRP5-NRg-1",
"PRE4g3-PRE10-TRg-5",
"PRE4g3-PRE10-TRg-1",
"PRE4g3-RPS5-TRg-2",
"PRE4g3-NSP1-TRg-4",
"PRE4g3-PRP38-TRg-4",
"PRE4g3-RCF1-NRg-5",
"PRE4g3-RSC3-TRg-4",
"PRE4g3-RSC3-TRg-5",
"PRE4g3-RSC3-TRg-6",
"PRE4g3-HTA1-NRg-12",
"PRE4g3-HTA1-NRg-11",
"PRE4g3-UTP23-TRg-2",
"PRE4g3-GCD7-NRg-1",
"PRE4g3-GCD7-NRg-2",
"PRE4g3-GCD7-NRg-6",
"PRE4g3-GAL11-NRg-2",
"PRE4g3-GAL11-NRg-9",
"PRE4g3-PHO4-TRg-5",
"PRE4g3-SNP1-NRg-3",
"PRE4g3-RPC37-TRg-5",
"PRE4g3-CRM1-TRg-5",
"PRE4g3-CRM1-TRg-2",
"PRE4g3-ASK1-TRg-7",
"PRE4g3-STU2-NRg-4",
"PRE4g3-NEO1-NRg-3",
"PRE4g3-GAL11-TRg-5",
"PRE4g3-GAL11-TRg-7",
"PRE4g3-SAM50-NRg-3",
"PRE4g3-CSL4-TRg-2",
"PRE4g3-CCT5-TRg-2",
"PRE4g3-POL30-NRg-1",
"PRE4g3-MED4-TRg-4",
"PRE4g3-MED4-TRg-3",
"PRE4g3-MED4-TRg-2",
"PRE4g3-GDI1-TRg-4",
"PRE4g3-GDI1-TRg-3",
"PRE4g3-REB1-TRg-6",
"PRE4g3-MRPL37-NRg-2",
"PRE4g3-NOC3-TRg-3",
"PRE4g3-SPC97-TRg-3",
"PRE4g3-IPP1-TRg-3",
"PRE4g3-IPP1-TRg-2",
"PRE4g3-PTI1-TRg-3",
"PRE4g3-PTI1-TRg-5",
"PRE4g3-RFC5-NRg-1",
"PRE4g3-CDC24-TRg-1",
"PRE4g3-CDC24-TRg-3",
"PRE4g3-CDC24-TRg-5",
"PRE4g3-CDC24-TRg-6",
"PRE4g3-UTP23-TRg-6",
"PRE4g3-UTP23-TRg-4",
"PRE4g3-UTP23-TRg-1",
"PRE4g3-RHO3-NRg-4",
"PRE4g3-TRS23-NRg-1",
"PRE4g3-TRS23-NRg-3",
"PRE4g3-RSP5-TRg-2",
"PRE4g3-RSP5-TRg-1",
"PRE4g3-SDA1-NRg-1",
"PRE4g3-KAP95-TRg-8",
"PRE4g3-ACO1-TRg-6",
"PRE4g3-HTA1-NRg-3",
"PRE4g3-HTA1-NRg-2",
"PRE4g3-SPN1-TRg-1",
"PRE4g3-MOT1-NRg-7",
"PRE4g3-RPL17A-NRg-4",
"PRE4g3-ADA2-TRg-4",
"PRE4g3-SFH1-NRg-1",
"PRE4g3-SPC97-NRg-5",
"PRE4g3-PRP22-TRg-3",
"PRE4g3-SEN15-TRg-2",
"PRE4g3-RPL3-NRg-2",
"PRE4g3-ISD11-NRg-2",
"PRE4g3-HEM12-TRg-8",
"PRE4g3-SEC10-TRg-1",
"PRE4g3-HTB1-TRg-7",
"PRE4g3-TTI2-TRg-1",
"PRE4g3-ACP1-TRg-2",
"PRE4g3-ACP1-TRg-4",
"PRE4g3-GAL11-NRg-10",
"PRE4g3-UTP22-TRg-2",
"PRE4g3-MST1-NRg-5",
"PRE4g3-RIB7-NRg-2",
"PRE4g3-MCD1-TRg-6",
"PRE4g3-MCD1-TRg-5",
"PRE4g3-GPI8-NRg-2",
"PRE4g3-THS1-TRg-2",
"PRE4g3-RRP7-TRg-2",
"PRE4g3-RRP7-TRg-5",
"PRE4g3-SMX2-NRg-7",
"PRE4g3-RRP45-TRg-5",
"PRE4g3-RRP45-TRg-4",
"PRE4g3-CNS1-TRg-2",
"PRE4g3-FBP1-NRg-9",
"PRE4g3-GCD11-NRg-1",
"PRE4g3-RPL10-TRg-2",
"PRE4g3-NUP192-TRg-4",
"PRE4g3-NUP145-NRg-4",
"PRE4g3-HEM12-TRg-6",
"PRE4g3-PLC1-TRg-3",
"PRE4g3-RPA43-TRg-1",
"PRE4g3-RPB7-NRg-2",
"PRE4g3-RPB7-NRg-3",
"PRE4g3-NSL1-NRg-1",
"PRE4g3-UTP6-TRg-3",
"PRE4g3-UTP6-TRg-1",
"PRE4g3-YJU2-TRg-5",
"PRE4g3-FRS2-NRg-5",
"PRE4g3-TIF35-NRg-2",
"PRE4g3-GPI15-TRg-1",
"PRE4g3-NOP1-NRg-5",
"PRE4g3-GPI15-TRg-4",
"PRE4g3-COG4-TRg-1",
"PRE4g3-TFA1-TRg-1",
"PRE4g3-RHO1-NRg-2",
"PRE4g3-RHO1-NRg-1",
"PRE4g3-CDC55-NRg-2",
"PRE4g3-IDI1-NRg-7",
"PRE4g3-RPL32-TRg-5",
"PRE4g3-RPB5-TRg-4",
"PRE4g3-DIP2-TRg-5",
"PRE4g3-DIP2-TRg-1",
"PRE4g3-RPC40-TRg-2",
"PRE4g3-CDC6-TRg-5",
"PRE4g3-CDC6-TRg-3",
"PRE4g3-DAD2-TRg-2",
"PRE4g3-RVS161-TRg-2",
"PRE4g3-RVS161-TRg-1",
"PRE4g3-SUP45-NRg-3",
"PRE4g3-SRB6-NRg-5",
"PRE4g3-RPC11-TRg-4",
"PRE4g3-RKI1-TRg-8",
"PRE4g3-NIP7-TRg-3",
"PRE4g3-RPL33A-NRg-12",
"PRE4g3-SAM50-TRg-4",
"PRE4g3-NOP4-NRg-1",
"PRE4g3-NOP4-NRg-3",
"PRE4g3-SMX2-TRg-5",
"PRE4g3-POL12-NRg-2",
"PRE4g3-BMS1-NRg-2",
"PRE4g3-RPA190-TRg-5",
"PRE4g3-ALG14-NRg-4",
"PRE4g3-ALG14-NRg-1",
"PRE4g3-PRE5-NRg-1",
"PRE4g3-BIG1-NRg-2",
"PRE4g3-TFA2-TRg-4",
"PRE4g3-IMP4-TRg-6",
"PRE4g3-PAN1-NRg-1",
"PRE4g3-UTP13-TRg-2",
"PRE4g3-KAE1-NRg-3",
"PRE4g3-ERG20-TRg-1",
"PRE4g3-CDC20-TRg-6",
"PRE4g3-PWP2-NRg-2",
"PRE4g3-COG1-NRg-1",
"PRE4g3-RPL1B-TRg-4",
"PRE4g3-RPL1B-TRg-7",
"PRE4g3-UTP20-TRg-3",
"PRE4g3-UTP20-TRg-4",
"PRE4g3-RPL25-TRg-4",
"PRE4g3-RPL25-TRg-2",
"PRE4g3-MCM7-NRg-1",
"PRE4g3-MRP49-TRg-5",
"PRE4g3-ERO1-NRg-3",
"PRE4g3-UTP5-TRg-7",
"PRE4g3-MCM4-NRg-1",
"PRE4g3-PRE3-NRg-1",
"PRE4g3-FCF1-NRg-1",
"PRE4g3-CUS1-NRg-1",
"PRE4g3-PSF1-TRg-2",
"PRE4g3-BCP1-TRg-2",
"PRE4g3-PAN1-TRg-1",
"PRE4g3-PAN1-TRg-3",
"PRE4g3-PAN1-TRg-4",
"PRE4g3-VPS3-TRg-2",
"PRE4g3-YIL060W-NRg-1",
"PRE4g3-VPS53-NRg-1",
"PRE4g3-CYR1-TRg-4",
"PRE4g3-CYR1-TRg-7",
"PRE4g3-MPS1-NRg-1",
"PRE4g3-SRP1-TRg-5",
"PRE4g3-SRP1-TRg-4",
"PRE4g3-TAF12-TRg-2",
"PRE4g3-TAF12-TRg-3",
"PRE4g3-POP4-TRg-1",
"PRE4g3-SPT16-TRg-1",
"PRE4g3-NUP82-TRg-4",
"PRE4g3-DML1-TRg-3",
"PRE4g3-RPA43-NRg-3",
"PRE4g3-STU2-NRg-3",
"PRE4g3-POP4-NRg-4",
"PRE4g3-MCD1-TRg-2",
"PRE4g3-RPS3-NRg-4",
"PRE4g3-PRP9-TRg-4",
"PRE4g3-RPP1-NRg-2",
"PRE4g3-MTR2-NRg-11",
"PRE4g3-GCD11-TRg-1",
"PRE4g3-RPF1-TRg-3",
"PRE4g3-SUB2-NRg-4",
"PRE4g3-GPI15-TRg-3",
"PRE4g3-ERG9-TRg-6",
"PRE4g3-RPT2-NRg-1",
"PRE4g3-YOS1-NRg-3",
"PRE4g3-SCM3-TRg-4",
"PRE4g3-SCM3-TRg-6",
"PRE4g3-RLP7-NRg-1",
"PRE4g3-TFB2-NRg-4",
"PRE4g3-IMP4-TRg-1",
"PRE4g3-IMP4-TRg-3",
"PRE4g3-PRE4-TRg-3",
"PRE4g3-SUB2-TRg-3",
"PRE4g3-RPP0-NRg-4",
"PRE4g3-RPP0-NRg-3",
"PRE4g3-TOM40-TRg-4",
"PRE4g3-FUR1-NRg-12",
"PRE4g3-TOM40-TRg-2",
"PRE4g3-VMA11-NRg-4",
"PRE4g3-PGS1-NRg-4",
"PRE4g3-URB1-TRg-4",
"PRE4g3-ARP4-TRg-3",
"PRE4g3-RPT3-TRg-3",
"PRE4g3-SUI3-TRg-3",
"PRE4g3-RFC5-NRg-2",
"PRE4g3-RRP14-TRg-2",
"PRE4g3-SCC2-TRg-1",
"PRE4g3-SSC1-TRg-3",
"PRE4g3-RRP9-TRg-3",
"PRE4g3-MOT1-NRg-9",
"PRE4g3-RPL42A-NRg-2",
"PRE4g3-SEC16-TRg-7",
"PRE4g3-IMP4-NRg-2",
"PRE4g3-YEF3-NRg-4",
"PRE4g3-PUP1-TRg-1",
"PRE4g3-UTP22-TRg-6",
"PRE4g3-DBP2-NRg-4",
"PRE4g3-PRE2-TRg-7",
"PRE4g3-ATP16-TRg-6",
"PRE4g3-UTP13-TRg-4",
"PRE4g3-DOP1-NRg-4",
"PRE4g3-TIM44-TRg-3",
"PRE4g3-ATP16-TRg-2",
"PRE4g3-ENP1-NRg-3",
"PRE4g3-NAF1-TRg-3",
"PRE4g3-COG4-TRg-2",
"PRE4g3-SOG2-TRg-7",
"PRE4g3-YDR341C-TRg-3",
"PRE4g3-YMR290W-A-TRg-10",
"PRE4g3-NUP192-NRg-9",
"PRE4g3-RPS31-NRg-8",
"PRE4g3-SPC97-NRg-6",
"PRE4g3-EBP2-NRg-1",
"PRE4g3-CDC48-TRg-5",
"PRE4g3-RPT1-TRg-4",
"PRE4g3-ULP1-NRg-2",
"PRE4g3-RPN3-TRg-6",
"PRE4g3-RPT1-TRg-5",
"PRE4g3-KRE5-TRg-2",
"PRE4g3-TBF1-NRg-8",
"PRE4g3-UTP22-NRg-4",
"PRE4g3-SSC1-NRg-4",
"PRE4g3-REB1-TRg-4",
"PRE4g3-CDC48-NRg-9",
"PRE4g3-FAS2-TRg-8",
"PRE4g3-TAO3-TRg-8",
"PRE4g3-CKS1-TRg-5",
"PRE4g3-YLR379W-TRg-7",
"PRE4g3-TEN1-NRg-2",
"PRE4g3-RPL42A-TRg-2",
"PRE4g3-SEC27-TRg-4",
"PRE4g3-TBF1-NRg-4",
"PRE4g3-RPT1-NRg-6",
"PRE4g3-COG1-TRg-3",
"PRE4g3-SUI1-TRg-6",
"PRE4g3-TIM23-TRg-6",
"PRE4g3-CDC48-NRg-6",
"PRE4g3-EPL1-TRg-5",
"PRE4g3-RPT5-TRg-8",
"PRE4g3-ATP16-NRg-4",
"PRE4g3-RPN6-TRg-3",
"PRE4g3-ERG9-NRg-6",
"PRE4g3-SMX3-TRg-1",
"PRE4g3-NCB2-NRg-3",
"PRE4g3-SEC16-NRg-12",
"PRE4g3-RPN6-TRg-2",
"PRE4g3-REB1-NRg-4",
"PRE4g3-ATP16-TRg-9",
"PRE4g3-ERG9-NRg-7",
"RPN5g1-RPL15A-NRg-4",
"RPN5g1-RPL15A-NRg-5",
"RPN5g1-KRE33-TRg-1",
"RPN5g1-PMI40-NRg-1",
"RPN5g1-NOP19-NRg-3",
"RPN5g1-SRP14-NRg-4",
"RPN5g1-SEC27-TRg-2",
"RPN5g1-GPI14-TRg-3",
"RPN5g1-PAH1-TRg-7",
"RPN5g1-PAH1-TRg-6",
"RPN5g1-PAH1-TRg-5",
"RPN5g1-PAH1-TRg-3",
"RPN5g1-COG3-TRg-1",
"RPN5g1-HTS1-NRg-5",
"RPN5g1-MSN5-TRg-7",
"RPN5g1-ERG26-TRg-1",
"RPN5g1-SMD2-TRg-5",
"RPN5g1-SMD2-TRg-4",
"RPN5g1-SMD2-TRg-1",
"RPN5g1-PRE7-TRg-4",
"RPN5g1-PRE7-TRg-7",
"RPN5g1-SEC6-TRg-3",
"RPN5g1-ESF2-NRg-1",
"RPN5g1-ESF2-NRg-3",
"RPN5g1-AFG2-TRg-2",
"RPN5g1-RRP36-TRg-3",
"RPN5g1-RRP36-TRg-5",
"RPN5g1-GCR1-NRg-2",
"RPN5g1-PRE4-NRg-4",
"RPN5g1-PRE4-NRg-9",
"RPN5g1-DSN1-NRg-2",
"RPN5g1-GPI11-TRg-3",
"RPN5g1-POP3-TRg-1",
"RPN5g1-MNE1-TRg-5",
"RPN5g1-RRP12-NRg-1",
"RPN5g1-RSC6-TRg-2",
"RPN5g1-CDC25-TRg-1",
"RPN5g1-CDC25-TRg-9",
"RPN5g1-YPP1-NRg-3",
"RPN5g1-NFS1-NRg-9",
"RPN5g1-NFS1-NRg-8",
"RPN5g1-UBA2-TRg-1",
"RPN5g1-ARP2-NRg-3",
"RPN5g1-MAK16-TRg-1",
"RPN5g1-CEP3-NRg-1",
"RPN5g1-GUK1-TRg-5",
"RPN5g1-GUK1-TRg-2",
"RPN5g1-GPI12-NRg-6",
"RPN5g1-RPS5-NRg-5",
"RPN5g1-RPS5-NRg-2",
"RPN5g1-RPC19-NRg-1",
"RPN5g1-TIM54-TRg-1",
"RPN5g1-TEN1-TRg-2",
"RPN5g1-SAH1-NRg-4",
"RPN5g1-SAH1-NRg-5",
"RPN5g1-SAH1-NRg-3",
"RPN5g1-ATP15-NRg-5",
"RPN5g1-SCD5-TRg-5",
"RPN5g1-ARB1-NRg-2",
"RPN5g1-ARB1-NRg-4",
"RPN5g1-PUP2-TRg-1",
"RPN5g1-CCT8-TRg-2",
"RPN5g1-MCM4-TRg-1",
"RPN5g1-LSM4-TRg-1",
"RPN5g1-NOP53-NRg-1",
"RPN5g1-ATP3-TRg-4",
"RPN5g1-AFG2-NRg-3",
"RPN5g1-PRO3-NRg-3",
"RPN5g1-NRD1-NRg-10",
"RPN5g1-SEC61-TRg-2",
"RPN5g1-RHO3-TRg-4",
"RPN5g1-SNF2-TRg-6",
"RPN5g1-SMD2-NRg-3",
"RPN5g1-RSC4-TRg-2",
"RPN5g1-RSC4-TRg-1",
"RPN5g1-TIF34-TRg-2",
"RPN5g1-BET1-NRg-1",
"RPN5g1-CDC8-NRg-2",
"RPN5g1-PRP42-TRg-2",
"RPN5g1-RRB1-TRg-2",
"RPN5g1-SPC24-TRg-1",
"RPN5g1-ILS1-NRg-1",
"RPN5g1-GFA1-TRg-2",
"RPN5g1-SEC21-NRg-10",
"RPN5g1-RPC10-NRg-1",
"RPN5g1-RPB10-TRg-3",
"RPN5g1-RPB10-TRg-2",
"RPN5g1-YNL181W-TRg-1",
"RPN5g1-RAD3-NRg-1",
"RPN5g1-NOP10-TRg-1",
"RPN5g1-BFR2-TRg-3",
"RPN5g1-MCM2-TRg-6",
"RPN5g1-MCM2-TRg-4",
"RPN5g1-MPP10-TRg-1",
"RPN5g1-RET2-TRg-4",
"RPN5g1-RET2-TRg-1",
"RPN5g1-RPS2-NRg-1",
"RPN5g1-RPS2-NRg-2",
"RPN5g1-ORC4-NRg-3",
"RPN5g1-TIP20-TRg-7",
"RPN5g1-SMT3-TRg-1",
"RPN5g1-MSS18-NRg-6",
"RPN5g1-YEF3-NRg-9",
"RPN5g1-ASK1-NRg-1",
"RPN5g1-SMC1-TRg-1",
"RPN5g1-NIP1-NRg-1",
"RPN5g1-RPP1-NRg-1",
"RPN5g1-YDJ1-TRg-6",
"RPN5g1-SUB2-NRg-1",
"RPN5g1-TIM10-NRg-8",
"RPN5g1-TIM10-NRg-4",
"RPN5g1-TIM10-NRg-7",
"RPN5g1-SKI6-TRg-4",
"RPN5g1-TUB4-TRg-1",
"RPN5g1-CDC37-NRg-2",
"RPN5g1-ISD11-TRg-3",
"RPN5g1-YOS1-TRg-4",
"RPN5g1-SSC1-TRg-6",
"RPN5g1-MTR3-TRg-5",
"RPN5g1-MTR3-TRg-6",
"RPN5g1-TFA1-TRg-2",
"RPN5g1-CDC3-NRg-3",
"RPN5g1-ERG25-TA-18",
"RPN5g1-RPB11-TRg-4",
"RPN5g1-RPB11-TRg-1",
"RPN5g1-RPB11-TRg-2",
"RPN5g1-DED1-TRg-3",
"RPN5g1-DED1-TRg-1",
"RPN5g1-DED1-TRg-6",
"RPN5g1-DED1-TRg-4",
"RPN5g1-RPL10-NRg-5",
"RPN5g1-RPL10-NRg-4",
"RPN5g1-EFB1-NRg-1",
"RPN5g1-EFB1-NRg-5",
"RPN5g1-EFB1-NRg-4",
"RPN5g1-RPT3-NRg-1",
"RPN5g1-SAC6-TRg-8",
"RPN5g1-SAC6-TRg-4",
"RPN5g1-SAC6-TRg-5",
"RPN5g1-SAC6-TRg-3",
"RPN5g1-DIM1-TRg-5",
"RPN5g1-DIM1-TRg-7",
"RPN5g1-RPC17-NRg-1",
"RPN5g1-RPC17-NRg-2",
"RPN5g1-YDR341C-TRg-1",
"RPN5g1-RAP1-NRg-8",
"RPN5g1-RAP1-NRg-5",
"RPN5g1-RAP1-NRg-2",
"RPN5g1-SEC26-NRg-3",
"RPN5g1-SPP41-TRg-3",
"RPN5g1-TAP42-NRg-1",
"RPN5g1-PGA2-TRg-6",
"RPN5g1-BRL1-TRg-1",
"RPN5g1-FOL2-TRg-1",
"RPN5g1-NAB3-NRg-5",
"RPN5g1-SNF4-TRg-4",
"RPN5g1-HRR25-TRg-2",
"RPN5g1-TRS23-TRg-4",
"RPN5g1-CTR86-TRg-4",
"RPN5g1-RPB5-TRg-5",
"RPN5g1-SPN1-NRg-2",
"RPN5g1-SPN1-NRg-1",
"RPN5g1-SEC61-NRg-1",
"RPN5g1-SEC61-NRg-7",
"RPN5g1-TUS1-TRg-3",
"RPN5g1-OLE1-NRg-2",
"RPN5g1-AFG2-TRg-1",
"RPN5g1-TOA2-NRg-1",
"RPN5g1-USO1-TRg-1",
"RPN5g1-UTP22-NRg-2",
"RPN5g1-RIB1-TRg-3",
"RPN5g1-RIB1-TRg-7",
"RPN5g1-RIB1-TRg-4",
"RPN5g1-COG1-TRg-1",
"RPN5g1-RPL32-NRg-2",
"RPN5g1-GLC7-NRg-3",
"RPN5g1-GLC7-NRg-4",
"RPN5g1-HSF1-TRg-2",
"RPN5g1-DAM1-NRg-5",
"RPN5g1-SEC18-TRg-4",
"RPN5g1-SEC18-TRg-5",
"RPN5g1-PAB1-NRg-3",
"RPN5g1-POP8-TRg-2",
"RPN5g1-PAB1-NRg-4",
"RPN5g1-BIG1-TRg-4",
"RPN5g1-BIG1-TRg-5",
"RPN5g1-BIG1-TRg-6",
"RPN5g1-RPO41-NRg-1",
"RPN5g1-RVB2-NRg-2",
"RPN5g1-PET117-NRg-8",
"RPN5g1-VPS45-NRg-9",
"RPN5g1-YCG1-NRg-1",
"RPN5g1-NOC4-NRg-1",
"RPN5g1-NMD3-NRg-2",
"RPN5g1-DRS1-TRg-2",
"RPN5g1-HTB1-NRg-2",
"RPN5g1-IPI1-TRg-2",
"RPN5g1-SEC18-NRg-1",
"RPN5g1-SEC18-NRg-2",
"RPN5g1-JIP5-NRg-2",
"RPN5g1-YPT1-TRg-3",
"RPN5g1-YPT1-TRg-2",
"RPN5g1-CLF1-NRg-2",
"RPN5g1-SNF2-NRg-7",
"RPN5g1-SNF2-NRg-4",
"RPN5g1-RPL25-NRg-1",
"RPN5g1-NOP56-TRg-1",
"RPN5g1-NOP56-TRg-2",
"RPN5g1-TRS31-TRg-1",
"RPN5g1-DBF4-TRg-2",
"RPN5g1-DBF4-TRg-1",
"RPN5g1-RPC19-TRg-4",
"RPN5g1-RPC19-TRg-6",
"RPN5g1-RPC19-TRg-3",
"RPN5g1-ROK1-NRg-1",
"RPN5g1-CDC33-TRg-4",
"RPN5g1-DHR2-TRg-3",
"RPN5g1-RRP42-NRg-5",
"RPN5g1-CLF1-TRg-1",
"RPN5g1-ERG11-NA-16",
"RPN5g1-VAS1-NRg-4",
"RPN5g1-PIK1-NRg-2",
"RPN5g1-SAR1-NRg-7",
"RPN5g1-SAR1-NRg-4",
"RPN5g1-RPS3-TRg-1",
"RPN5g1-YTM1-TRg-2",
"RPN5g1-SUI3-NRg-5",
"RPN5g1-SUI3-NRg-2",
"RPN5g1-RRP7-TRg-4",
"RPN5g1-RRP7-TRg-6",
"RPN5g1-NIP7-TRg-2",
"RPN5g1-MDM35-TRg-1",
"RPN5g1-ALA1-NRg-1",
"RPN5g1-DOA4-NRg-2",
"RPN5g1-RPS13-NRg-1",
"RPN5g1-YSF3-TRg-2",
"RPN5g1-RPS2-NRg-11",
"RPN5g1-SSL1-TRg-10",
"RPN5g1-NIP7-TRg-1",
"RPN5g1-LST8-NRg-1",
"RPN5g1-TAF4-TRg-3",
"RPN5g1-HAS1-TRg-2",
"RPN5g1-GLC7-TRg-2",
"RPN5g1-CDC45-NRg-1",
"RPN5g1-SEC22-NRg-8",
"RPN5g1-YOS1-TRg-2",
"RPN5g1-RBA50-TRg-3",
"RPN5g1-SPP41-NRg-2",
"RPN5g1-PRP46-TRg-2",
"RPN5g1-PGA2-NRg-1",
"RPN5g1-CBF5-TRg-3",
"RPN5g1-TCP1-NRg-3",
"RPN5g1-TCP1-NRg-2",
"RPN5g1-ERG26-NRg-2",
"RPN5g1-ERG26-NRg-4",
"RPN5g1-MES1-TRg-5",
"RPN5g1-HTS1-TRg-2",
"RPN5g1-SSS1-TRg-3",
"RPN5g1-SSS1-TRg-2",
"RPN5g1-SYS1-TRg-7",
"RPN5g1-SYS1-TRg-2",
"RPN5g1-SYS1-TRg-1",
"RPN5g1-BFR2-TRg-1",
"RPN5g1-EOS1-TRg-3",
"RPN5g1-TAF4-NRg-1",
"RPN5g1-ARL3-NRg-8",
"RPN5g1-RPN5-NRg-1",
"RPN5g1-TIM9-NRg-2",
"RPN5g1-NUP57-NRg-3",
"RPN5g1-VPS4-TRg-1",
"RPN5g1-CDC3-TRg-4",
"RPN5g1-BBP1-NRg-1",
"RPN5g1-BBP1-NRg-2",
"RPN5g1-USE1-NRg-3",
"RPN5g1-CCT7-TRg-1",
"RPN5g1-SAH1-TRg-3",
"RPN5g1-CHS2-TRg-1",
"RPN5g1-DPM1-TRg-2",
"RPN5g1-BBP1-TRg-1",
"RPN5g1-NRD1-TRg-4",
"RPN5g1-RPB3-NRg-1",
"RPN5g1-PHO85-NRg-6",
"RPN5g1-SNF6-TRg-6",
"RPN5g1-PRP38-NRg-2",
"RPN5g1-OAR1-NRg-3",
"RPN5g1-ROX3-NRg-1",
"RPN5g1-YPP1-TRg-6",
"RPN5g1-CBF2-NRg-8",
"RPN5g1-SPT6-TRg-5",
"RPN5g1-SEC10-NRg-1",
"RPN5g1-NSL1-NRg-3",
"RPN5g1-NRD1-NRg-8",
"RPN5g1-RPB3-TRg-1",
"RPN5g1-NRD1-NRg-4",
"RPN5g1-RVB1-TRg-2",
"RPN5g1-TIF5-NRg-8",
"RPN5g1-EOS1-NRg-1",
"RPN5g1-ERG25-NA-26",
"RPN5g1-MSL5-NRg-4",
"RPN5g1-SEC24-TRg-2",
"RPN5g1-RPL30-NRg-5",
"RPN5g1-SNU71-NRg-3",
"RPN5g1-CDC33-NRg-1",
"RPN5g1-RPN6-TRg-4",
"RPN5g1-NAB2-TRg-4",
"RPN5g1-NAB2-TRg-6",
"RPN5g1-YTM1-NRg-1",
"RPN5g1-OLE1-TRg-8",
"RPN5g1-OLE1-TRg-1",
"RPN5g1-UTP7-TRg-4",
"RPN5g1-ACT1-NRg-6",
"RPN5g1-RPL18A-NRg-3",
"RPN5g1-BRX1-NRg-1",
"RPN5g1-NAF1-TRg-8",
"RPN5g1-NAF1-TRg-6",
"RPN5g1-NAF1-TRg-4",
"RPN5g1-CDC8-TRg-2",
"RPN5g1-NSE4-TRg-1",
"RPN5g1-PAB1-NRg-2",
"RPN5g1-PRP43-TRg-4",
"RPN5g1-SEC2-NRg-3",
"RPN5g1-SEC2-NRg-6",
"RPN5g1-MPP10-NRg-5",
"RPN5g1-YDR355C-TRg-2",
"RPN5g1-YLR339C-TRg-9",
"RPN5g1-SNM1-TRg-2",
"RPN5g1-ALR1-NRg-4",
"RPN5g1-ALR1-NRg-1",
"RPN5g1-ALR1-NRg-3",
"RPN5g1-RPL10-TRg-1",
"RPN5g1-RPL28-TRg-2",
"RPN5g1-UTP25-TRg-1",
"RPN5g1-POB3-TRg-1",
"RPN5g1-POB3-TRg-3",
"RPN5g1-POB3-TRg-2",
"RPN5g1-MED11-TRg-1",
"RPN5g1-ISA1-TRg-15",
"RPN5g1-RRP1-NRg-1",
"RPN5g1-MES1-NRg-1",
"RPN5g1-SEC13-NRg-5",
"RPN5g1-MCM2-NRg-2",
"RPN5g1-ALA1-TRg-4",
"RPN5g1-MTG2-TRg-5",
"RPN5g1-TIF35-NRg-3",
"RPN5g1-NSE1-TRg-3",
"RPN5g1-NSE1-TRg-4",
"RPN5g1-MOB2-NRg-6",
"RPN5g1-VRG4-NRg-3",
"RPN5g1-PRP9-TRg-3",
"RPN5g1-HYM1-TRg-5",
"RPN5g1-POP1-TRg-5",
"RPN5g1-POP1-TRg-9",
"RPN5g1-RPL17A-TRg-1",
"RPN5g1-SLD2-TRg-1",
"RPN5g1-CDC48-NRg-7",
"RPN5g1-FHL1-NRg-2",
"RPN5g1-BET3-NRg-7",
"RPN5g1-MAK21-TRg-1",
"RPN5g1-BRN1-TRg-4",
"RPN5g1-FBA1-NRg-3",
"RPN5g1-CDC42-TRg-6",
"RPN5g1-CDC42-TRg-7",
"RPN5g1-COG4-NRg-1",
"RPN5g1-ATP3-NRg-3",
"RPN5g1-ATP3-NRg-2",
"RPN5g1-SMP3-TRg-5",
"RPN5g1-CFT2-NRg-2",
"RPN5g1-FAS2-TRg-5",
"RPN5g1-DBP2-NRg-3",
"RPN5g1-DBP2-NRg-2",
"RPN5g1-MPS2-NRg-4",
"RPN5g1-ARC35-TRg-2",
"RPN5g1-ARC35-TRg-5",
"RPN5g1-MRD1-TRg-1",
"RPN5g1-RLP7-TRg-1",
"RPN5g1-SPC34-TRg-1",
"RPN5g1-CDC45-TRg-2",
"RPN5g1-GCD6-TRg-3",
"RPN5g1-GCD6-TRg-4",
"RPN5g1-YPT6-NRg-2",
"RPN5g1-RPS13-TRg-2",
"RPN5g1-IPI3-TRg-3",
"RPN5g1-TIF5-NRg-9",
"RPN5g1-TIF5-NRg-7",
"RPN5g1-TIF5-NRg-6",
"RPN5g1-NAB3-TRg-3",
"RPN5g1-GCD2-TRg-1",
"RPN5g1-UBA1-TRg-2",
"RPN5g1-SLD3-TRg-6",
"RPN5g1-LCB1-TRg-5",
"RPN5g1-TOA2-TRg-6",
"RPN5g1-TOA2-TRg-1",
"RPN5g1-TOA2-TRg-3",
"RPN5g1-LSM2-TRg-1",
"RPN5g1-YML6-TRg-13",
"RPN5g1-YML6-TRg-12",
"RPN5g1-UTP15-NRg-1",
"RPN5g1-TIF6-NRg-8",
"RPN5g1-SUP35-NRg-1",
"RPN5g1-MPP10-NRg-1",
"RPN5g1-SWI3-TRg-7",
"RPN5g1-SSN3-NRg-2",
"RPN5g1-SEC13-NRg-7",
"RPN5g1-RPS15-NRg-3",
"RPN5g1-RPL3-TRg-2",
"RPN5g1-FBA1-NRg-2",
"RPN5g1-FBA1-NRg-1",
"RPN5g1-FBA1-NRg-5",
"RPN5g1-DAM1-TRg-2",
"RPN5g1-NHP2-TRg-2",
"RPN5g1-HCA4-NRg-6",
"RPN5g1-PRE3-TRg-4",
"RPN5g1-DBP5-NRg-4",
"RPN5g1-SPT6-NRg-4",
"RPN5g1-SPT6-NRg-2",
"RPN5g1-RPL18A-TRg-4",
"RPN5g1-KSH1-TRg-1",
"RPN5g1-KSH1-TRg-3",
"RPN5g1-IPI3-NRg-1",
"RPN5g1-PGA2-TRg-8",
"RPN5g1-RPL18A-TRg-2",
"RPN5g1-RPL33A-NRg-6",
"RPN5g1-TAF12-NRg-2",
"RPN5g1-USE1-TRg-5",
"RPN5g1-YNL114C-TRg-1",
"RPN5g1-SMC5-TRg-7",
"RPN5g1-SMC5-TRg-6",
"RPN5g1-RSC58-TRg-1",
"RPN5g1-CTF13-TRg-2",
"RPN5g1-NAB2-NRg-2",
"RPN5g1-MCM7-TRg-4",
"RPN5g1-BCP1-NRg-5",
"RPN5g1-STU2-TRg-3",
"RPN5g1-SEC21-NRg-6",
"RPN5g1-SEC21-NRg-3",
"RPN5g1-RPL1B-TRg-3",
"RPN5g1-SEC20-NRg-2",
"RPN5g1-VMA3-NRg-2",
"RPN5g1-SEC23-NRg-5",
"RPN5g1-CDC28-TRg-4",
"RPN5g1-RPN12-NRg-11",
"RPN5g1-PUP3-TRg-3",
"RPN5g1-SEC31-TRg-2",
"RPN5g1-SED5-TRg-6",
"RPN5g1-SED5-TRg-5",
"RPN5g1-RPL33A-TRg-1",
"RPN5g1-RPL33A-TRg-2",
"RPN5g1-MRPL11-TRg-2",
"RPN5g1-RTP1-NRg-2",
"RPN5g1-NUG1-TRg-2",
"RPN5g1-VPH2-TRg-4",
"RPN5g1-COP1-NRg-3",
"RPN5g1-CRM1-NRg-1",
"RPN5g1-RPL5-NRg-4",
"RPN5g1-SNU13-NRg-4",
"RPN5g1-PFS2-TRg-3",
"RPN5g1-MPP10-TRg-2",
"RPN5g1-TSR4-NRg-2",
"RPN5g1-RSC2-TRg-1",
"RPN5g1-SEC65-TRg-2",
"RPN5g1-SMI1-NRg-1",
"RPN5g1-RTT105-NRg-4",
"RPN5g1-VMA5-TRg-3",
"RPN5g1-VMA5-TRg-5",
"RPN5g1-RRP1-TRg-3",
"RPN5g1-CLC1-TRg-2",
"RPN5g1-GCD6-NRg-1",
"RPN5g1-GCD6-NRg-2",
"RPN5g1-PXR1-TRg-1",
"RPN5g1-CDC14-NRg-1",
"RPN5g1-PCF11-TRg-6",
"RPN5g1-PCF11-TRg-5",
"RPN5g1-PCF11-TRg-4",
"RPN5g1-SEC31-NRg-1",
"RPN5g1-RRP5-NRg-1",
"RPN5g1-PRE10-TRg-5",
"RPN5g1-PRE10-TRg-1",
"RPN5g1-RPS5-TRg-2",
"RPN5g1-NSP1-TRg-4",
"RPN5g1-PRP38-TRg-4",
"RPN5g1-RCF1-NRg-5",
"RPN5g1-RSC3-TRg-4",
"RPN5g1-RSC3-TRg-5",
"RPN5g1-RSC3-TRg-6",
"RPN5g1-HTA1-NRg-12",
"RPN5g1-HTA1-NRg-11",
"RPN5g1-UTP23-TRg-2",
"RPN5g1-GCD7-NRg-1",
"RPN5g1-GCD7-NRg-2",
"RPN5g1-GCD7-NRg-6",
"RPN5g1-GAL11-NRg-2",
"RPN5g1-GAL11-NRg-9",
"RPN5g1-PHO4-TRg-5",
"RPN5g1-SNP1-NRg-3",
"RPN5g1-RPC37-TRg-5",
"RPN5g1-CRM1-TRg-5",
"RPN5g1-CRM1-TRg-2",
"RPN5g1-ASK1-TRg-7",
"RPN5g1-STU2-NRg-4",
"RPN5g1-NEO1-NRg-3",
"RPN5g1-GAL11-TRg-5",
"RPN5g1-GAL11-TRg-7",
"RPN5g1-SAM50-NRg-3",
"RPN5g1-CSL4-TRg-2",
"RPN5g1-CCT5-TRg-2",
"RPN5g1-POL30-NRg-1",
"RPN5g1-MED4-TRg-4",
"RPN5g1-MED4-TRg-3",
"RPN5g1-MED4-TRg-2",
"RPN5g1-GDI1-TRg-4",
"RPN5g1-GDI1-TRg-3",
"RPN5g1-REB1-TRg-6",
"RPN5g1-MRPL37-NRg-2",
"RPN5g1-NOC3-TRg-3",
"RPN5g1-SPC97-TRg-3",
"RPN5g1-IPP1-TRg-3",
"RPN5g1-IPP1-TRg-2",
"RPN5g1-PTI1-TRg-3",
"RPN5g1-PTI1-TRg-5",
"RPN5g1-RFC5-NRg-1",
"RPN5g1-CDC24-TRg-1",
"RPN5g1-CDC24-TRg-3",
"RPN5g1-CDC24-TRg-5",
"RPN5g1-CDC24-TRg-6",
"RPN5g1-UTP23-TRg-6",
"RPN5g1-UTP23-TRg-4",
"RPN5g1-UTP23-TRg-1",
"RPN5g1-RHO3-NRg-4",
"RPN5g1-TRS23-NRg-1",
"RPN5g1-TRS23-NRg-3",
"RPN5g1-RSP5-TRg-2",
"RPN5g1-RSP5-TRg-1",
"RPN5g1-SDA1-NRg-1",
"RPN5g1-KAP95-TRg-8",
"RPN5g1-ACO1-TRg-6",
"RPN5g1-HTA1-NRg-3",
"RPN5g1-HTA1-NRg-2",
"RPN5g1-SPN1-TRg-1",
"RPN5g1-MOT1-NRg-7",
"RPN5g1-RPL17A-NRg-4",
"RPN5g1-ADA2-TRg-4",
"RPN5g1-SFH1-NRg-1",
"RPN5g1-SPC97-NRg-5",
"RPN5g1-PRP22-TRg-3",
"RPN5g1-SEN15-TRg-2",
"RPN5g1-RPL3-NRg-2",
"RPN5g1-ISD11-NRg-2",
"RPN5g1-HEM12-TRg-8",
"RPN5g1-SEC10-TRg-1",
"RPN5g1-HTB1-TRg-7",
"RPN5g1-TTI2-TRg-1",
"RPN5g1-ACP1-TRg-2",
"RPN5g1-ACP1-TRg-4",
"RPN5g1-GAL11-NRg-10",
"RPN5g1-UTP22-TRg-2",
"RPN5g1-MST1-NRg-5",
"RPN5g1-RIB7-NRg-2",
"RPN5g1-MCD1-TRg-6",
"RPN5g1-MCD1-TRg-5",
"RPN5g1-GPI8-NRg-2",
"RPN5g1-THS1-TRg-2",
"RPN5g1-RRP7-TRg-2",
"RPN5g1-RRP7-TRg-5",
"RPN5g1-SMX2-NRg-7",
"RPN5g1-RRP45-TRg-5",
"RPN5g1-RRP45-TRg-4",
"RPN5g1-CNS1-TRg-2",
"RPN5g1-FBP1-NRg-9",
"RPN5g1-GCD11-NRg-1",
"RPN5g1-RPL10-TRg-2",
"RPN5g1-NUP192-TRg-4",
"RPN5g1-NUP145-NRg-4",
"RPN5g1-HEM12-TRg-6",
"RPN5g1-PLC1-TRg-3",
"RPN5g1-RPA43-TRg-1",
"RPN5g1-RPB7-NRg-2",
"RPN5g1-RPB7-NRg-3",
"RPN5g1-NSL1-NRg-1",
"RPN5g1-UTP6-TRg-3",
"RPN5g1-UTP6-TRg-1",
"RPN5g1-YJU2-TRg-5",
"RPN5g1-FRS2-NRg-5",
"RPN5g1-TIF35-NRg-2",
"RPN5g1-GPI15-TRg-1",
"RPN5g1-NOP1-NRg-5",
"RPN5g1-GPI15-TRg-4",
"RPN5g1-COG4-TRg-1",
"RPN5g1-TFA1-TRg-1",
"RPN5g1-RHO1-NRg-2",
"RPN5g1-RHO1-NRg-1",
"RPN5g1-CDC55-NRg-2",
"RPN5g1-IDI1-NRg-7",
"RPN5g1-RPL32-TRg-5",
"RPN5g1-RPB5-TRg-4",
"RPN5g1-DIP2-TRg-5",
"RPN5g1-DIP2-TRg-1",
"RPN5g1-RPC40-TRg-2",
"RPN5g1-CDC6-TRg-5",
"RPN5g1-CDC6-TRg-3",
"RPN5g1-DAD2-TRg-2",
"RPN5g1-RVS161-TRg-2",
"RPN5g1-RVS161-TRg-1",
"RPN5g1-SUP45-NRg-3",
"RPN5g1-SRB6-NRg-5",
"RPN5g1-RPC11-TRg-4",
"RPN5g1-RKI1-TRg-8",
"RPN5g1-NIP7-TRg-3",
"RPN5g1-RPL33A-NRg-12",
"RPN5g1-SAM50-TRg-4",
"RPN5g1-NOP4-NRg-1",
"RPN5g1-NOP4-NRg-3",
"RPN5g1-SMX2-TRg-5",
"RPN5g1-POL12-NRg-2",
"RPN5g1-BMS1-NRg-2",
"RPN5g1-RPA190-TRg-5",
"RPN5g1-ALG14-NRg-4",
"RPN5g1-ALG14-NRg-1",
"RPN5g1-PRE5-NRg-1",
"RPN5g1-BIG1-NRg-2",
"RPN5g1-TFA2-TRg-4",
"RPN5g1-IMP4-TRg-6",
"RPN5g1-PAN1-NRg-1",
"RPN5g1-UTP13-TRg-2",
"RPN5g1-KAE1-NRg-3",
"RPN5g1-ERG20-TRg-1",
"RPN5g1-CDC20-TRg-6",
"RPN5g1-PWP2-NRg-2",
"RPN5g1-COG1-NRg-1",
"RPN5g1-RPL1B-TRg-4",
"RPN5g1-RPL1B-TRg-7",
"RPN5g1-UTP20-TRg-3",
"RPN5g1-UTP20-TRg-4",
"RPN5g1-RPL25-TRg-4",
"RPN5g1-RPL25-TRg-2",
"RPN5g1-MCM7-NRg-1",
"RPN5g1-MRP49-TRg-5",
"RPN5g1-ERO1-NRg-3",
"RPN5g1-UTP5-TRg-7",
"RPN5g1-MCM4-NRg-1",
"RPN5g1-PRE3-NRg-1",
"RPN5g1-FCF1-NRg-1",
"RPN5g1-CUS1-NRg-1",
"RPN5g1-PSF1-TRg-2",
"RPN5g1-BCP1-TRg-2",
"RPN5g1-PAN1-TRg-1",
"RPN5g1-PAN1-TRg-3",
"RPN5g1-PAN1-TRg-4",
"RPN5g1-VPS3-TRg-2",
"RPN5g1-YIL060W-NRg-1",
"RPN5g1-VPS53-NRg-1",
"RPN5g1-CYR1-TRg-4",
"RPN5g1-CYR1-TRg-7",
"RPN5g1-MPS1-NRg-1",
"RPN5g1-SRP1-TRg-5",
"RPN5g1-SRP1-TRg-4",
"RPN5g1-TAF12-TRg-2",
"RPN5g1-TAF12-TRg-3",
"RPN5g1-POP4-TRg-1",
"RPN5g1-SPT16-TRg-1",
"RPN5g1-NUP82-TRg-4",
"RPN5g1-DML1-TRg-3",
"RPN5g1-RPA43-NRg-3",
"RPN5g1-STU2-NRg-3",
"RPN5g1-POP4-NRg-4",
"RPN5g1-MCD1-TRg-2",
"RPN5g1-RPS3-NRg-4",
"RPN5g1-PRP9-TRg-4",
"RPN5g1-RPP1-NRg-2",
"RPN5g1-MTR2-NRg-11",
"RPN5g1-GCD11-TRg-1",
"RPN5g1-RPF1-TRg-3",
"RPN5g1-SUB2-NRg-4",
"RPN5g1-GPI15-TRg-3",
"RPN5g1-ERG9-TRg-6",
"RPN5g1-RPT2-NRg-1",
"RPN5g1-YOS1-NRg-3",
"RPN5g1-SCM3-TRg-4",
"RPN5g1-SCM3-TRg-6",
"RPN5g1-RLP7-NRg-1",
"RPN5g1-TFB2-NRg-4",
"RPN5g1-IMP4-TRg-1",
"RPN5g1-IMP4-TRg-3",
"RPN5g1-PRE4-TRg-3",
"RPN5g1-SUB2-TRg-3",
"RPN5g1-RPP0-NRg-4",
"RPN5g1-RPP0-NRg-3",
"RPN5g1-TOM40-TRg-4",
"RPN5g1-FUR1-NRg-12",
"RPN5g1-TOM40-TRg-2",
"RPN5g1-VMA11-NRg-4",
"RPN5g1-PGS1-NRg-4",
"RPN5g1-URB1-TRg-4",
"RPN5g1-ARP4-TRg-3",
"RPN5g1-RPT3-TRg-3",
"RPN5g1-SUI3-TRg-3",
"RPN5g1-RFC5-NRg-2",
"RPN5g1-RRP14-TRg-2",
"RPN5g1-SCC2-TRg-1",
"RPN5g1-SSC1-TRg-3",
"RPN5g1-RRP9-TRg-3",
"RPN5g1-MOT1-NRg-9",
"RPN5g1-RPL42A-NRg-2",
"RPN5g1-SEC16-TRg-7",
"RPN5g1-IMP4-NRg-2",
"RPN5g1-YEF3-NRg-4",
"RPN5g1-PUP1-TRg-1",
"RPN5g1-UTP22-TRg-6",
"RPN5g1-DBP2-NRg-4",
"RPN5g1-PRE2-TRg-7",
"RPN5g1-ATP16-TRg-6",
"RPN5g1-UTP13-TRg-4",
"RPN5g1-DOP1-NRg-4",
"RPN5g1-TIM44-TRg-3",
"RPN5g1-ATP16-TRg-2",
"RPN5g1-ENP1-NRg-3",
"RPN5g1-NAF1-TRg-3",
"RPN5g1-COG4-TRg-2",
"RPN5g1-SOG2-TRg-7",
"RPN5g1-YDR341C-TRg-3",
"RPN5g1-YMR290W-A-TRg-10",
"RPN5g1-NUP192-NRg-9",
"RPN5g1-RPS31-NRg-8",
"RPN5g1-SPC97-NRg-6",
"RPN5g1-EBP2-NRg-1",
"RPN5g1-CDC48-TRg-5",
"RPN5g1-RPT1-TRg-4",
"RPN5g1-ULP1-NRg-2",
"RPN5g1-RPN3-TRg-6",
"RPN5g1-RPT1-TRg-5",
"RPN5g1-KRE5-TRg-2",
"RPN5g1-TBF1-NRg-8",
"RPN5g1-UTP22-NRg-4",
"RPN5g1-SSC1-NRg-4",
"RPN5g1-REB1-TRg-4",
"RPN5g1-CDC48-NRg-9",
"RPN5g1-FAS2-TRg-8",
"RPN5g1-TAO3-TRg-8",
"RPN5g1-CKS1-TRg-5",
"RPN5g1-YLR379W-TRg-7",
"RPN5g1-TEN1-NRg-2",
"RPN5g1-RPL42A-TRg-2",
"RPN5g1-SEC27-TRg-4",
"RPN5g1-TBF1-NRg-4",
"RPN5g1-RPT1-NRg-6",
"RPN5g1-COG1-TRg-3",
"RPN5g1-SUI1-TRg-6",
"RPN5g1-TIM23-TRg-6",
"RPN5g1-CDC48-NRg-6",
"RPN5g1-EPL1-TRg-5",
"RPN5g1-RPT5-TRg-8",
"RPN5g1-ATP16-NRg-4",
"RPN5g1-RPN6-TRg-3",
"RPN5g1-ERG9-NRg-6",
"RPN5g1-SMX3-TRg-1",
"RPN5g1-NCB2-NRg-3",
"RPN5g1-SEC16-NRg-12",
"RPN5g1-RPN6-TRg-2",
"RPN5g1-REB1-NRg-4",
"RPN5g1-ATP16-TRg-9",
"RPN5g1-ERG9-NRg-7",
"COG3g1-RPL15A-NRg-4",
"COG3g1-RPL15A-NRg-5",
"COG3g1-KRE33-TRg-1",
"COG3g1-PMI40-NRg-1",
"COG3g1-NOP19-NRg-3",
"COG3g1-SRP14-NRg-4",
"COG3g1-SEC27-TRg-2",
"COG3g1-GPI14-TRg-3",
"COG3g1-PAH1-TRg-7",
"COG3g1-PAH1-TRg-6",
"COG3g1-PAH1-TRg-5",
"COG3g1-PAH1-TRg-3",
"COG3g1-COG3-TRg-1",
"COG3g1-HTS1-NRg-5",
"COG3g1-MSN5-TRg-7",
"COG3g1-ERG26-TRg-1",
"COG3g1-SMD2-TRg-5",
"COG3g1-SMD2-TRg-4",
"COG3g1-SMD2-TRg-1",
"COG3g1-PRE7-TRg-4",
"COG3g1-PRE7-TRg-7",
"COG3g1-SEC6-TRg-3",
"COG3g1-ESF2-NRg-1",
"COG3g1-ESF2-NRg-3",
"COG3g1-AFG2-TRg-2",
"COG3g1-RRP36-TRg-3",
"COG3g1-RRP36-TRg-5",
"COG3g1-GCR1-NRg-2",
"COG3g1-PRE4-NRg-4",
"COG3g1-PRE4-NRg-9",
"COG3g1-DSN1-NRg-2",
"COG3g1-GPI11-TRg-3",
"COG3g1-POP3-TRg-1",
"COG3g1-MNE1-TRg-5",
"COG3g1-RRP12-NRg-1",
"COG3g1-RSC6-TRg-2",
"COG3g1-CDC25-TRg-1",
"COG3g1-CDC25-TRg-9",
"COG3g1-YPP1-NRg-3",
"COG3g1-NFS1-NRg-9",
"COG3g1-NFS1-NRg-8",
"COG3g1-UBA2-TRg-1",
"COG3g1-ARP2-NRg-3",
"COG3g1-MAK16-TRg-1",
"COG3g1-CEP3-NRg-1",
"COG3g1-GUK1-TRg-5",
"COG3g1-GUK1-TRg-2",
"COG3g1-GPI12-NRg-6",
"COG3g1-RPS5-NRg-5",
"COG3g1-RPS5-NRg-2",
"COG3g1-RPC19-NRg-1",
"COG3g1-TIM54-TRg-1",
"COG3g1-TEN1-TRg-2",
"COG3g1-SAH1-NRg-4",
"COG3g1-SAH1-NRg-5",
"COG3g1-SAH1-NRg-3",
"COG3g1-ATP15-NRg-5",
"COG3g1-SCD5-TRg-5",
"COG3g1-ARB1-NRg-2",
"COG3g1-ARB1-NRg-4",
"COG3g1-PUP2-TRg-1",
"COG3g1-CCT8-TRg-2",
"COG3g1-MCM4-TRg-1",
"COG3g1-LSM4-TRg-1",
"COG3g1-NOP53-NRg-1",
"COG3g1-ATP3-TRg-4",
"COG3g1-AFG2-NRg-3",
"COG3g1-PRO3-NRg-3",
"COG3g1-NRD1-NRg-10",
"COG3g1-SEC61-TRg-2",
"COG3g1-RHO3-TRg-4",
"COG3g1-SNF2-TRg-6",
"COG3g1-SMD2-NRg-3",
"COG3g1-RSC4-TRg-2",
"COG3g1-RSC4-TRg-1",
"COG3g1-TIF34-TRg-2",
"COG3g1-BET1-NRg-1",
"COG3g1-CDC8-NRg-2",
"COG3g1-PRP42-TRg-2",
"COG3g1-RRB1-TRg-2",
"COG3g1-SPC24-TRg-1",
"COG3g1-ILS1-NRg-1",
"COG3g1-GFA1-TRg-2",
"COG3g1-SEC21-NRg-10",
"COG3g1-RPC10-NRg-1",
"COG3g1-RPB10-TRg-3",
"COG3g1-RPB10-TRg-2",
"COG3g1-YNL181W-TRg-1",
"COG3g1-RAD3-NRg-1",
"COG3g1-NOP10-TRg-1",
"COG3g1-BFR2-TRg-3",
"COG3g1-MCM2-TRg-6",
"COG3g1-MCM2-TRg-4",
"COG3g1-MPP10-TRg-1",
"COG3g1-RET2-TRg-4",
"COG3g1-RET2-TRg-1",
"COG3g1-RPS2-NRg-1",
"COG3g1-RPS2-NRg-2",
"COG3g1-ORC4-NRg-3",
"COG3g1-TIP20-TRg-7",
"COG3g1-SMT3-TRg-1",
"COG3g1-MSS18-NRg-6",
"COG3g1-YEF3-NRg-9",
"COG3g1-ASK1-NRg-1",
"COG3g1-SMC1-TRg-1",
"COG3g1-NIP1-NRg-1",
"COG3g1-RPP1-NRg-1",
"COG3g1-YDJ1-TRg-6",
"COG3g1-SUB2-NRg-1",
"COG3g1-TIM10-NRg-8",
"COG3g1-TIM10-NRg-4",
"COG3g1-TIM10-NRg-7",
"COG3g1-SKI6-TRg-4",
"COG3g1-TUB4-TRg-1",
"COG3g1-CDC37-NRg-2",
"COG3g1-ISD11-TRg-3",
"COG3g1-YOS1-TRg-4",
"COG3g1-SSC1-TRg-6",
"COG3g1-MTR3-TRg-5",
"COG3g1-MTR3-TRg-6",
"COG3g1-TFA1-TRg-2",
"COG3g1-CDC3-NRg-3",
"COG3g1-ERG25-TA-18",
"COG3g1-RPB11-TRg-4",
"COG3g1-RPB11-TRg-1",
"COG3g1-RPB11-TRg-2",
"COG3g1-DED1-TRg-3",
"COG3g1-DED1-TRg-1",
"COG3g1-DED1-TRg-6",
"COG3g1-DED1-TRg-4",
"COG3g1-RPL10-NRg-5",
"COG3g1-RPL10-NRg-4",
"COG3g1-EFB1-NRg-1",
"COG3g1-EFB1-NRg-5",
"COG3g1-EFB1-NRg-4",
"COG3g1-RPT3-NRg-1",
"COG3g1-SAC6-TRg-8",
"COG3g1-SAC6-TRg-4",
"COG3g1-SAC6-TRg-5",
"COG3g1-SAC6-TRg-3",
"COG3g1-DIM1-TRg-5",
"COG3g1-DIM1-TRg-7",
"COG3g1-RPC17-NRg-1",
"COG3g1-RPC17-NRg-2",
"COG3g1-YDR341C-TRg-1",
"COG3g1-RAP1-NRg-8",
"COG3g1-RAP1-NRg-5",
"COG3g1-RAP1-NRg-2",
"COG3g1-SEC26-NRg-3",
"COG3g1-SPP41-TRg-3",
"COG3g1-TAP42-NRg-1",
"COG3g1-PGA2-TRg-6",
"COG3g1-BRL1-TRg-1",
"COG3g1-FOL2-TRg-1",
"COG3g1-NAB3-NRg-5",
"COG3g1-SNF4-TRg-4",
"COG3g1-HRR25-TRg-2",
"COG3g1-TRS23-TRg-4",
"COG3g1-CTR86-TRg-4",
"COG3g1-RPB5-TRg-5",
"COG3g1-SPN1-NRg-2",
"COG3g1-SPN1-NRg-1",
"COG3g1-SEC61-NRg-1",
"COG3g1-SEC61-NRg-7",
"COG3g1-TUS1-TRg-3",
"COG3g1-OLE1-NRg-2",
"COG3g1-AFG2-TRg-1",
"COG3g1-TOA2-NRg-1",
"COG3g1-USO1-TRg-1",
"COG3g1-UTP22-NRg-2",
"COG3g1-RIB1-TRg-3",
"COG3g1-RIB1-TRg-7",
"COG3g1-RIB1-TRg-4",
"COG3g1-COG1-TRg-1",
"COG3g1-RPL32-NRg-2",
"COG3g1-GLC7-NRg-3",
"COG3g1-GLC7-NRg-4",
"COG3g1-HSF1-TRg-2",
"COG3g1-DAM1-NRg-5",
"COG3g1-SEC18-TRg-4",
"COG3g1-SEC18-TRg-5",
"COG3g1-PAB1-NRg-3",
"COG3g1-POP8-TRg-2",
"COG3g1-PAB1-NRg-4",
"COG3g1-BIG1-TRg-4",
"COG3g1-BIG1-TRg-5",
"COG3g1-BIG1-TRg-6",
"COG3g1-RPO41-NRg-1",
"COG3g1-RVB2-NRg-2",
"COG3g1-PET117-NRg-8",
"COG3g1-VPS45-NRg-9",
"COG3g1-YCG1-NRg-1",
"COG3g1-NOC4-NRg-1",
"COG3g1-NMD3-NRg-2",
"COG3g1-DRS1-TRg-2",
"COG3g1-HTB1-NRg-2",
"COG3g1-IPI1-TRg-2",
"COG3g1-SEC18-NRg-1",
"COG3g1-SEC18-NRg-2",
"COG3g1-JIP5-NRg-2",
"COG3g1-YPT1-TRg-3",
"COG3g1-YPT1-TRg-2",
"COG3g1-CLF1-NRg-2",
"COG3g1-SNF2-NRg-7",
"COG3g1-SNF2-NRg-4",
"COG3g1-RPL25-NRg-1",
"COG3g1-NOP56-TRg-1",
"COG3g1-NOP56-TRg-2",
"COG3g1-TRS31-TRg-1",
"COG3g1-DBF4-TRg-2",
"COG3g1-DBF4-TRg-1",
"COG3g1-RPC19-TRg-4",
"COG3g1-RPC19-TRg-6",
"COG3g1-RPC19-TRg-3",
"COG3g1-ROK1-NRg-1",
"COG3g1-CDC33-TRg-4",
"COG3g1-DHR2-TRg-3",
"COG3g1-RRP42-NRg-5",
"COG3g1-CLF1-TRg-1",
"COG3g1-ERG11-NA-16",
"COG3g1-VAS1-NRg-4",
"COG3g1-PIK1-NRg-2",
"COG3g1-SAR1-NRg-7",
"COG3g1-SAR1-NRg-4",
"COG3g1-RPS3-TRg-1",
"COG3g1-YTM1-TRg-2",
"COG3g1-SUI3-NRg-5",
"COG3g1-SUI3-NRg-2",
"COG3g1-RRP7-TRg-4",
"COG3g1-RRP7-TRg-6",
"COG3g1-NIP7-TRg-2",
"COG3g1-MDM35-TRg-1",
"COG3g1-ALA1-NRg-1",
"COG3g1-DOA4-NRg-2",
"COG3g1-RPS13-NRg-1",
"COG3g1-YSF3-TRg-2",
"COG3g1-RPS2-NRg-11",
"COG3g1-SSL1-TRg-10",
"COG3g1-NIP7-TRg-1",
"COG3g1-LST8-NRg-1",
"COG3g1-TAF4-TRg-3",
"COG3g1-HAS1-TRg-2",
"COG3g1-GLC7-TRg-2",
"COG3g1-CDC45-NRg-1",
"COG3g1-SEC22-NRg-8",
"COG3g1-YOS1-TRg-2",
"COG3g1-RBA50-TRg-3",
"COG3g1-SPP41-NRg-2",
"COG3g1-PRP46-TRg-2",
"COG3g1-PGA2-NRg-1",
"COG3g1-CBF5-TRg-3",
"COG3g1-TCP1-NRg-3",
"COG3g1-TCP1-NRg-2",
"COG3g1-ERG26-NRg-2",
"COG3g1-ERG26-NRg-4",
"COG3g1-MES1-TRg-5",
"COG3g1-HTS1-TRg-2",
"COG3g1-SSS1-TRg-3",
"COG3g1-SSS1-TRg-2",
"COG3g1-SYS1-TRg-7",
"COG3g1-SYS1-TRg-2",
"COG3g1-SYS1-TRg-1",
"COG3g1-BFR2-TRg-1",
"COG3g1-EOS1-TRg-3",
"COG3g1-TAF4-NRg-1",
"COG3g1-ARL3-NRg-8",
"COG3g1-RPN5-NRg-1",
"COG3g1-TIM9-NRg-2",
"COG3g1-NUP57-NRg-3",
"COG3g1-VPS4-TRg-1",
"COG3g1-CDC3-TRg-4",
"COG3g1-BBP1-NRg-1",
"COG3g1-BBP1-NRg-2",
"COG3g1-USE1-NRg-3",
"COG3g1-CCT7-TRg-1",
"COG3g1-SAH1-TRg-3",
"COG3g1-CHS2-TRg-1",
"COG3g1-DPM1-TRg-2",
"COG3g1-BBP1-TRg-1",
"COG3g1-NRD1-TRg-4",
"COG3g1-RPB3-NRg-1",
"COG3g1-PHO85-NRg-6",
"COG3g1-SNF6-TRg-6",
"COG3g1-PRP38-NRg-2",
"COG3g1-OAR1-NRg-3",
"COG3g1-ROX3-NRg-1",
"COG3g1-YPP1-TRg-6",
"COG3g1-CBF2-NRg-8",
"COG3g1-SPT6-TRg-5",
"COG3g1-SEC10-NRg-1",
"COG3g1-NSL1-NRg-3",
"COG3g1-NRD1-NRg-8",
"COG3g1-RPB3-TRg-1",
"COG3g1-NRD1-NRg-4",
"COG3g1-RVB1-TRg-2",
"COG3g1-TIF5-NRg-8",
"COG3g1-EOS1-NRg-1",
"COG3g1-ERG25-NA-26",
"COG3g1-MSL5-NRg-4",
"COG3g1-SEC24-TRg-2",
"COG3g1-RPL30-NRg-5",
"COG3g1-SNU71-NRg-3",
"COG3g1-CDC33-NRg-1",
"COG3g1-RPN6-TRg-4",
"COG3g1-NAB2-TRg-4",
"COG3g1-NAB2-TRg-6",
"COG3g1-YTM1-NRg-1",
"COG3g1-OLE1-TRg-8",
"COG3g1-OLE1-TRg-1",
"COG3g1-UTP7-TRg-4",
"COG3g1-ACT1-NRg-6",
"COG3g1-RPL18A-NRg-3",
"COG3g1-BRX1-NRg-1",
"COG3g1-NAF1-TRg-8",
"COG3g1-NAF1-TRg-6",
"COG3g1-NAF1-TRg-4",
"COG3g1-CDC8-TRg-2",
"COG3g1-NSE4-TRg-1",
"COG3g1-PAB1-NRg-2",
"COG3g1-PRP43-TRg-4",
"COG3g1-SEC2-NRg-3",
"COG3g1-SEC2-NRg-6",
"COG3g1-MPP10-NRg-5",
"COG3g1-YDR355C-TRg-2",
"COG3g1-YLR339C-TRg-9",
"COG3g1-SNM1-TRg-2",
"COG3g1-ALR1-NRg-4",
"COG3g1-ALR1-NRg-1",
"COG3g1-ALR1-NRg-3",
"COG3g1-RPL10-TRg-1",
"COG3g1-RPL28-TRg-2",
"COG3g1-UTP25-TRg-1",
"COG3g1-POB3-TRg-1",
"COG3g1-POB3-TRg-3",
"COG3g1-POB3-TRg-2",
"COG3g1-MED11-TRg-1",
"COG3g1-ISA1-TRg-15",
"COG3g1-RRP1-NRg-1",
"COG3g1-MES1-NRg-1",
"COG3g1-SEC13-NRg-5",
"COG3g1-MCM2-NRg-2",
"COG3g1-ALA1-TRg-4",
"COG3g1-MTG2-TRg-5",
"COG3g1-TIF35-NRg-3",
"COG3g1-NSE1-TRg-3",
"COG3g1-NSE1-TRg-4",
"COG3g1-MOB2-NRg-6",
"COG3g1-VRG4-NRg-3",
"COG3g1-PRP9-TRg-3",
"COG3g1-HYM1-TRg-5",
"COG3g1-POP1-TRg-5",
"COG3g1-POP1-TRg-9",
"COG3g1-RPL17A-TRg-1",
"COG3g1-SLD2-TRg-1",
"COG3g1-CDC48-NRg-7",
"COG3g1-FHL1-NRg-2",
"COG3g1-BET3-NRg-7",
"COG3g1-MAK21-TRg-1",
"COG3g1-BRN1-TRg-4",
"COG3g1-FBA1-NRg-3",
"COG3g1-CDC42-TRg-6",
"COG3g1-CDC42-TRg-7",
"COG3g1-COG4-NRg-1",
"COG3g1-ATP3-NRg-3",
"COG3g1-ATP3-NRg-2",
"COG3g1-SMP3-TRg-5",
"COG3g1-CFT2-NRg-2",
"COG3g1-FAS2-TRg-5",
"COG3g1-DBP2-NRg-3",
"COG3g1-DBP2-NRg-2",
"COG3g1-MPS2-NRg-4",
"COG3g1-ARC35-TRg-2",
"COG3g1-ARC35-TRg-5",
"COG3g1-MRD1-TRg-1",
"COG3g1-RLP7-TRg-1",
"COG3g1-SPC34-TRg-1",
"COG3g1-CDC45-TRg-2",
"COG3g1-GCD6-TRg-3",
"COG3g1-GCD6-TRg-4",
"COG3g1-YPT6-NRg-2",
"COG3g1-RPS13-TRg-2",
"COG3g1-IPI3-TRg-3",
"COG3g1-TIF5-NRg-9",
"COG3g1-TIF5-NRg-7",
"COG3g1-TIF5-NRg-6",
"COG3g1-NAB3-TRg-3",
"COG3g1-GCD2-TRg-1",
"COG3g1-UBA1-TRg-2",
"COG3g1-SLD3-TRg-6",
"COG3g1-LCB1-TRg-5",
"COG3g1-TOA2-TRg-6",
"COG3g1-TOA2-TRg-1",
"COG3g1-TOA2-TRg-3",
"COG3g1-LSM2-TRg-1",
"COG3g1-YML6-TRg-13",
"COG3g1-YML6-TRg-12",
"COG3g1-UTP15-NRg-1",
"COG3g1-TIF6-NRg-8",
"COG3g1-SUP35-NRg-1",
"COG3g1-MPP10-NRg-1",
"COG3g1-SWI3-TRg-7",
"COG3g1-SSN3-NRg-2",
"COG3g1-SEC13-NRg-7",
"COG3g1-RPS15-NRg-3",
"COG3g1-RPL3-TRg-2",
"COG3g1-FBA1-NRg-2",
"COG3g1-FBA1-NRg-1",
"COG3g1-FBA1-NRg-5",
"COG3g1-DAM1-TRg-2",
"COG3g1-NHP2-TRg-2",
"COG3g1-HCA4-NRg-6",
"COG3g1-PRE3-TRg-4",
"COG3g1-DBP5-NRg-4",
"COG3g1-SPT6-NRg-4",
"COG3g1-SPT6-NRg-2",
"COG3g1-RPL18A-TRg-4",
"COG3g1-KSH1-TRg-1",
"COG3g1-KSH1-TRg-3",
"COG3g1-IPI3-NRg-1",
"COG3g1-PGA2-TRg-8",
"COG3g1-RPL18A-TRg-2",
"COG3g1-RPL33A-NRg-6",
"COG3g1-TAF12-NRg-2",
"COG3g1-USE1-TRg-5",
"COG3g1-YNL114C-TRg-1",
"COG3g1-SMC5-TRg-7",
"COG3g1-SMC5-TRg-6",
"COG3g1-RSC58-TRg-1",
"COG3g1-CTF13-TRg-2",
"COG3g1-NAB2-NRg-2",
"COG3g1-MCM7-TRg-4",
"COG3g1-BCP1-NRg-5",
"COG3g1-STU2-TRg-3",
"COG3g1-SEC21-NRg-6",
"COG3g1-SEC21-NRg-3",
"COG3g1-RPL1B-TRg-3",
"COG3g1-SEC20-NRg-2",
"COG3g1-VMA3-NRg-2",
"COG3g1-SEC23-NRg-5",
"COG3g1-CDC28-TRg-4",
"COG3g1-RPN12-NRg-11",
"COG3g1-PUP3-TRg-3",
"COG3g1-SEC31-TRg-2",
"COG3g1-SED5-TRg-6",
"COG3g1-SED5-TRg-5",
"COG3g1-RPL33A-TRg-1",
"COG3g1-RPL33A-TRg-2",
"COG3g1-MRPL11-TRg-2",
"COG3g1-RTP1-NRg-2",
"COG3g1-NUG1-TRg-2",
"COG3g1-VPH2-TRg-4",
"COG3g1-COP1-NRg-3",
"COG3g1-CRM1-NRg-1",
"COG3g1-RPL5-NRg-4",
"COG3g1-SNU13-NRg-4",
"COG3g1-PFS2-TRg-3",
"COG3g1-MPP10-TRg-2",
"COG3g1-TSR4-NRg-2",
"COG3g1-RSC2-TRg-1",
"COG3g1-SEC65-TRg-2",
"COG3g1-SMI1-NRg-1",
"COG3g1-RTT105-NRg-4",
"COG3g1-VMA5-TRg-3",
"COG3g1-VMA5-TRg-5",
"COG3g1-RRP1-TRg-3",
"COG3g1-CLC1-TRg-2",
"COG3g1-GCD6-NRg-1",
"COG3g1-GCD6-NRg-2",
"COG3g1-PXR1-TRg-1",
"COG3g1-CDC14-NRg-1",
"COG3g1-PCF11-TRg-6",
"COG3g1-PCF11-TRg-5",
"COG3g1-PCF11-TRg-4",
"COG3g1-SEC31-NRg-1",
"COG3g1-RRP5-NRg-1",
"COG3g1-PRE10-TRg-5",
"COG3g1-PRE10-TRg-1",
"COG3g1-RPS5-TRg-2",
"COG3g1-NSP1-TRg-4",
"COG3g1-PRP38-TRg-4",
"COG3g1-RCF1-NRg-5",
"COG3g1-RSC3-TRg-4",
"COG3g1-RSC3-TRg-5",
"COG3g1-RSC3-TRg-6",
"COG3g1-HTA1-NRg-12",
"COG3g1-HTA1-NRg-11",
"COG3g1-UTP23-TRg-2",
"COG3g1-GCD7-NRg-1",
"COG3g1-GCD7-NRg-2",
"COG3g1-GCD7-NRg-6",
"COG3g1-GAL11-NRg-2",
"COG3g1-GAL11-NRg-9",
"COG3g1-PHO4-TRg-5",
"COG3g1-SNP1-NRg-3",
"COG3g1-RPC37-TRg-5",
"COG3g1-CRM1-TRg-5",
"COG3g1-CRM1-TRg-2",
"COG3g1-ASK1-TRg-7",
"COG3g1-STU2-NRg-4",
"COG3g1-NEO1-NRg-3",
"COG3g1-GAL11-TRg-5",
"COG3g1-GAL11-TRg-7",
"COG3g1-SAM50-NRg-3",
"COG3g1-CSL4-TRg-2",
"COG3g1-CCT5-TRg-2",
"COG3g1-POL30-NRg-1",
"COG3g1-MED4-TRg-4",
"COG3g1-MED4-TRg-3",
"COG3g1-MED4-TRg-2",
"COG3g1-GDI1-TRg-4",
"COG3g1-GDI1-TRg-3",
"COG3g1-REB1-TRg-6",
"COG3g1-MRPL37-NRg-2",
"COG3g1-NOC3-TRg-3",
"COG3g1-SPC97-TRg-3",
"COG3g1-IPP1-TRg-3",
"COG3g1-IPP1-TRg-2",
"COG3g1-PTI1-TRg-3",
"COG3g1-PTI1-TRg-5",
"COG3g1-RFC5-NRg-1",
"COG3g1-CDC24-TRg-1",
"COG3g1-CDC24-TRg-3",
"COG3g1-CDC24-TRg-5",
"COG3g1-CDC24-TRg-6",
"COG3g1-UTP23-TRg-6",
"COG3g1-UTP23-TRg-4",
"COG3g1-UTP23-TRg-1",
"COG3g1-RHO3-NRg-4",
"COG3g1-TRS23-NRg-1",
"COG3g1-TRS23-NRg-3",
"COG3g1-RSP5-TRg-2",
"COG3g1-RSP5-TRg-1",
"COG3g1-SDA1-NRg-1",
"COG3g1-KAP95-TRg-8",
"COG3g1-ACO1-TRg-6",
"COG3g1-HTA1-NRg-3",
"COG3g1-HTA1-NRg-2",
"COG3g1-SPN1-TRg-1",
"COG3g1-MOT1-NRg-7",
"COG3g1-RPL17A-NRg-4",
"COG3g1-ADA2-TRg-4",
"COG3g1-SFH1-NRg-1",
"COG3g1-SPC97-NRg-5",
"COG3g1-PRP22-TRg-3",
"COG3g1-SEN15-TRg-2",
"COG3g1-RPL3-NRg-2",
"COG3g1-ISD11-NRg-2",
"COG3g1-HEM12-TRg-8",
"COG3g1-SEC10-TRg-1",
"COG3g1-HTB1-TRg-7",
"COG3g1-TTI2-TRg-1",
"COG3g1-ACP1-TRg-2",
"COG3g1-ACP1-TRg-4",
"COG3g1-GAL11-NRg-10",
"COG3g1-UTP22-TRg-2",
"COG3g1-MST1-NRg-5",
"COG3g1-RIB7-NRg-2",
"COG3g1-MCD1-TRg-6",
"COG3g1-MCD1-TRg-5",
"COG3g1-GPI8-NRg-2",
"COG3g1-THS1-TRg-2",
"COG3g1-RRP7-TRg-2",
"COG3g1-RRP7-TRg-5",
"COG3g1-SMX2-NRg-7",
"COG3g1-RRP45-TRg-5",
"COG3g1-RRP45-TRg-4",
"COG3g1-CNS1-TRg-2",
"COG3g1-FBP1-NRg-9",
"COG3g1-GCD11-NRg-1",
"COG3g1-RPL10-TRg-2",
"COG3g1-NUP192-TRg-4",
"COG3g1-NUP145-NRg-4",
"COG3g1-HEM12-TRg-6",
"COG3g1-PLC1-TRg-3",
"COG3g1-RPA43-TRg-1",
"COG3g1-RPB7-NRg-2",
"COG3g1-RPB7-NRg-3",
"COG3g1-NSL1-NRg-1",
"COG3g1-UTP6-TRg-3",
"COG3g1-UTP6-TRg-1",
"COG3g1-YJU2-TRg-5",
"COG3g1-FRS2-NRg-5",
"COG3g1-TIF35-NRg-2",
"COG3g1-GPI15-TRg-1",
"COG3g1-NOP1-NRg-5",
"COG3g1-GPI15-TRg-4",
"COG3g1-COG4-TRg-1",
"COG3g1-TFA1-TRg-1",
"COG3g1-RHO1-NRg-2",
"COG3g1-RHO1-NRg-1",
"COG3g1-CDC55-NRg-2",
"COG3g1-IDI1-NRg-7",
"COG3g1-RPL32-TRg-5",
"COG3g1-RPB5-TRg-4",
"COG3g1-DIP2-TRg-5",
"COG3g1-DIP2-TRg-1",
"COG3g1-RPC40-TRg-2",
"COG3g1-CDC6-TRg-5",
"COG3g1-CDC6-TRg-3",
"COG3g1-DAD2-TRg-2",
"COG3g1-RVS161-TRg-2",
"COG3g1-RVS161-TRg-1",
"COG3g1-SUP45-NRg-3",
"COG3g1-SRB6-NRg-5",
"COG3g1-RPC11-TRg-4",
"COG3g1-RKI1-TRg-8",
"COG3g1-NIP7-TRg-3",
"COG3g1-RPL33A-NRg-12",
"COG3g1-SAM50-TRg-4",
"COG3g1-NOP4-NRg-1",
"COG3g1-NOP4-NRg-3",
"COG3g1-SMX2-TRg-5",
"COG3g1-POL12-NRg-2",
"COG3g1-BMS1-NRg-2",
"COG3g1-RPA190-TRg-5",
"COG3g1-ALG14-NRg-4",
"COG3g1-ALG14-NRg-1",
"COG3g1-PRE5-NRg-1",
"COG3g1-BIG1-NRg-2",
"COG3g1-TFA2-TRg-4",
"COG3g1-IMP4-TRg-6",
"COG3g1-PAN1-NRg-1",
"COG3g1-UTP13-TRg-2",
"COG3g1-KAE1-NRg-3",
"COG3g1-ERG20-TRg-1",
"COG3g1-CDC20-TRg-6",
"COG3g1-PWP2-NRg-2",
"COG3g1-COG1-NRg-1",
"COG3g1-RPL1B-TRg-4",
"COG3g1-RPL1B-TRg-7",
"COG3g1-UTP20-TRg-3",
"COG3g1-UTP20-TRg-4",
"COG3g1-RPL25-TRg-4",
"COG3g1-RPL25-TRg-2",
"COG3g1-MCM7-NRg-1",
"COG3g1-MRP49-TRg-5",
"COG3g1-ERO1-NRg-3",
"COG3g1-UTP5-TRg-7",
"COG3g1-MCM4-NRg-1",
"COG3g1-PRE3-NRg-1",
"COG3g1-FCF1-NRg-1",
"COG3g1-CUS1-NRg-1",
"COG3g1-PSF1-TRg-2",
"COG3g1-BCP1-TRg-2",
"COG3g1-PAN1-TRg-1",
"COG3g1-PAN1-TRg-3",
"COG3g1-PAN1-TRg-4",
"COG3g1-VPS3-TRg-2",
"COG3g1-YIL060W-NRg-1",
"COG3g1-VPS53-NRg-1",
"COG3g1-CYR1-TRg-4",
"COG3g1-CYR1-TRg-7",
"COG3g1-MPS1-NRg-1",
"COG3g1-SRP1-TRg-5",
"COG3g1-SRP1-TRg-4",
"COG3g1-TAF12-TRg-2",
"COG3g1-TAF12-TRg-3",
"COG3g1-POP4-TRg-1",
"COG3g1-SPT16-TRg-1",
"COG3g1-NUP82-TRg-4",
"COG3g1-DML1-TRg-3",
"COG3g1-RPA43-NRg-3",
"COG3g1-STU2-NRg-3",
"COG3g1-POP4-NRg-4",
"COG3g1-MCD1-TRg-2",
"COG3g1-RPS3-NRg-4",
"COG3g1-PRP9-TRg-4",
"COG3g1-RPP1-NRg-2",
"COG3g1-MTR2-NRg-11",
"COG3g1-GCD11-TRg-1",
"COG3g1-RPF1-TRg-3",
"COG3g1-SUB2-NRg-4",
"COG3g1-GPI15-TRg-3",
"COG3g1-ERG9-TRg-6",
"COG3g1-RPT2-NRg-1",
"COG3g1-YOS1-NRg-3",
"COG3g1-SCM3-TRg-4",
"COG3g1-SCM3-TRg-6",
"COG3g1-RLP7-NRg-1",
"COG3g1-TFB2-NRg-4",
"COG3g1-IMP4-TRg-1",
"COG3g1-IMP4-TRg-3",
"COG3g1-PRE4-TRg-3",
"COG3g1-SUB2-TRg-3",
"COG3g1-RPP0-NRg-4",
"COG3g1-RPP0-NRg-3",
"COG3g1-TOM40-TRg-4",
"COG3g1-FUR1-NRg-12",
"COG3g1-TOM40-TRg-2",
"COG3g1-VMA11-NRg-4",
"COG3g1-PGS1-NRg-4",
"COG3g1-URB1-TRg-4",
"COG3g1-ARP4-TRg-3",
"COG3g1-RPT3-TRg-3",
"COG3g1-SUI3-TRg-3",
"COG3g1-RFC5-NRg-2",
"COG3g1-RRP14-TRg-2",
"COG3g1-SCC2-TRg-1",
"COG3g1-SSC1-TRg-3",
"COG3g1-RRP9-TRg-3",
"COG3g1-MOT1-NRg-9",
"COG3g1-RPL42A-NRg-2",
"COG3g1-SEC16-TRg-7",
"COG3g1-IMP4-NRg-2",
"COG3g1-YEF3-NRg-4",
"COG3g1-PUP1-TRg-1",
"COG3g1-UTP22-TRg-6",
"COG3g1-DBP2-NRg-4",
"COG3g1-PRE2-TRg-7",
"COG3g1-ATP16-TRg-6",
"COG3g1-UTP13-TRg-4",
"COG3g1-DOP1-NRg-4",
"COG3g1-TIM44-TRg-3",
"COG3g1-ATP16-TRg-2",
"COG3g1-ENP1-NRg-3",
"COG3g1-NAF1-TRg-3",
"COG3g1-COG4-TRg-2",
"COG3g1-SOG2-TRg-7",
"COG3g1-YDR341C-TRg-3",
"COG3g1-YMR290W-A-TRg-10",
"COG3g1-NUP192-NRg-9",
"COG3g1-RPS31-NRg-8",
"COG3g1-SPC97-NRg-6",
"COG3g1-EBP2-NRg-1",
"COG3g1-CDC48-TRg-5",
"COG3g1-RPT1-TRg-4",
"COG3g1-ULP1-NRg-2",
"COG3g1-RPN3-TRg-6",
"COG3g1-RPT1-TRg-5",
"COG3g1-KRE5-TRg-2",
"COG3g1-TBF1-NRg-8",
"COG3g1-UTP22-NRg-4",
"COG3g1-SSC1-NRg-4",
"COG3g1-REB1-TRg-4",
"COG3g1-CDC48-NRg-9",
"COG3g1-FAS2-TRg-8",
"COG3g1-TAO3-TRg-8",
"COG3g1-CKS1-TRg-5",
"COG3g1-YLR379W-TRg-7",
"COG3g1-TEN1-NRg-2",
"COG3g1-RPL42A-TRg-2",
"COG3g1-SEC27-TRg-4",
"COG3g1-TBF1-NRg-4",
"COG3g1-RPT1-NRg-6",
"COG3g1-COG1-TRg-3",
"COG3g1-SUI1-TRg-6",
"COG3g1-TIM23-TRg-6",
"COG3g1-CDC48-NRg-6",
"COG3g1-EPL1-TRg-5",
"COG3g1-RPT5-TRg-8",
"COG3g1-ATP16-NRg-4",
"COG3g1-RPN6-TRg-3",
"COG3g1-ERG9-NRg-6",
"COG3g1-SMX3-TRg-1",
"COG3g1-NCB2-NRg-3",
"COG3g1-SEC16-NRg-12",
"COG3g1-RPN6-TRg-2",
"COG3g1-REB1-NRg-4",
"COG3g1-ATP16-TRg-9",
"COG3g1-ERG9-NRg-7",
"SED5g5-RPL15A-NRg-4",
"SED5g5-RPL15A-NRg-5",
"SED5g5-KRE33-TRg-1",
"SED5g5-PMI40-NRg-1",
"SED5g5-NOP19-NRg-3",
"SED5g5-SRP14-NRg-4",
"SED5g5-SEC27-TRg-2",
"SED5g5-GPI14-TRg-3",
"SED5g5-PAH1-TRg-7",
"SED5g5-PAH1-TRg-6",
"SED5g5-PAH1-TRg-5",
"SED5g5-PAH1-TRg-3",
"SED5g5-COG3-TRg-1",
"SED5g5-HTS1-NRg-5",
"SED5g5-MSN5-TRg-7",
"SED5g5-ERG26-TRg-1",
"SED5g5-SMD2-TRg-5",
"SED5g5-SMD2-TRg-4",
"SED5g5-SMD2-TRg-1",
"SED5g5-PRE7-TRg-4",
"SED5g5-PRE7-TRg-7",
"SED5g5-SEC6-TRg-3",
"SED5g5-ESF2-NRg-1",
"SED5g5-ESF2-NRg-3",
"SED5g5-AFG2-TRg-2",
"SED5g5-RRP36-TRg-3",
"SED5g5-RRP36-TRg-5",
"SED5g5-GCR1-NRg-2",
"SED5g5-PRE4-NRg-4",
"SED5g5-PRE4-NRg-9",
"SED5g5-DSN1-NRg-2",
"SED5g5-GPI11-TRg-3",
"SED5g5-POP3-TRg-1",
"SED5g5-MNE1-TRg-5",
"SED5g5-RRP12-NRg-1",
"SED5g5-RSC6-TRg-2",
"SED5g5-CDC25-TRg-1",
"SED5g5-CDC25-TRg-9",
"SED5g5-YPP1-NRg-3",
"SED5g5-NFS1-NRg-9",
"SED5g5-NFS1-NRg-8",
"SED5g5-UBA2-TRg-1",
"SED5g5-ARP2-NRg-3",
"SED5g5-MAK16-TRg-1",
"SED5g5-CEP3-NRg-1",
"SED5g5-GUK1-TRg-5",
"SED5g5-GUK1-TRg-2",
"SED5g5-GPI12-NRg-6",
"SED5g5-RPS5-NRg-5",
"SED5g5-RPS5-NRg-2",
"SED5g5-RPC19-NRg-1",
"SED5g5-TIM54-TRg-1",
"SED5g5-TEN1-TRg-2",
"SED5g5-SAH1-NRg-4",
"SED5g5-SAH1-NRg-5",
"SED5g5-SAH1-NRg-3",
"SED5g5-ATP15-NRg-5",
"SED5g5-SCD5-TRg-5",
"SED5g5-ARB1-NRg-2",
"SED5g5-ARB1-NRg-4",
"SED5g5-PUP2-TRg-1",
"SED5g5-CCT8-TRg-2",
"SED5g5-MCM4-TRg-1",
"SED5g5-LSM4-TRg-1",
"SED5g5-NOP53-NRg-1",
"SED5g5-ATP3-TRg-4",
"SED5g5-AFG2-NRg-3",
"SED5g5-PRO3-NRg-3",
"SED5g5-NRD1-NRg-10",
"SED5g5-SEC61-TRg-2",
"SED5g5-RHO3-TRg-4",
"SED5g5-SNF2-TRg-6",
"SED5g5-SMD2-NRg-3",
"SED5g5-RSC4-TRg-2",
"SED5g5-RSC4-TRg-1",
"SED5g5-TIF34-TRg-2",
"SED5g5-BET1-NRg-1",
"SED5g5-CDC8-NRg-2",
"SED5g5-PRP42-TRg-2",
"SED5g5-RRB1-TRg-2",
"SED5g5-SPC24-TRg-1",
"SED5g5-ILS1-NRg-1",
"SED5g5-GFA1-TRg-2",
"SED5g5-SEC21-NRg-10",
"SED5g5-RPC10-NRg-1",
"SED5g5-RPB10-TRg-3",
"SED5g5-RPB10-TRg-2",
"SED5g5-YNL181W-TRg-1",
"SED5g5-RAD3-NRg-1",
"SED5g5-NOP10-TRg-1",
"SED5g5-BFR2-TRg-3",
"SED5g5-MCM2-TRg-6",
"SED5g5-MCM2-TRg-4",
"SED5g5-MPP10-TRg-1",
"SED5g5-RET2-TRg-4",
"SED5g5-RET2-TRg-1",
"SED5g5-RPS2-NRg-1",
"SED5g5-RPS2-NRg-2",
"SED5g5-ORC4-NRg-3",
"SED5g5-TIP20-TRg-7",
"SED5g5-SMT3-TRg-1",
"SED5g5-MSS18-NRg-6",
"SED5g5-YEF3-NRg-9",
"SED5g5-ASK1-NRg-1",
"SED5g5-SMC1-TRg-1",
"SED5g5-NIP1-NRg-1",
"SED5g5-RPP1-NRg-1",
"SED5g5-YDJ1-TRg-6",
"SED5g5-SUB2-NRg-1",
"SED5g5-TIM10-NRg-8",
"SED5g5-TIM10-NRg-4",
"SED5g5-TIM10-NRg-7",
"SED5g5-SKI6-TRg-4",
"SED5g5-TUB4-TRg-1",
"SED5g5-CDC37-NRg-2",
"SED5g5-ISD11-TRg-3",
"SED5g5-YOS1-TRg-4",
"SED5g5-SSC1-TRg-6",
"SED5g5-MTR3-TRg-5",
"SED5g5-MTR3-TRg-6",
"SED5g5-TFA1-TRg-2",
"SED5g5-CDC3-NRg-3",
"SED5g5-ERG25-TA-18",
"SED5g5-RPB11-TRg-4",
"SED5g5-RPB11-TRg-1",
"SED5g5-RPB11-TRg-2",
"SED5g5-DED1-TRg-3",
"SED5g5-DED1-TRg-1",
"SED5g5-DED1-TRg-6",
"SED5g5-DED1-TRg-4",
"SED5g5-RPL10-NRg-5",
"SED5g5-RPL10-NRg-4",
"SED5g5-EFB1-NRg-1",
"SED5g5-EFB1-NRg-5",
"SED5g5-EFB1-NRg-4",
"SED5g5-RPT3-NRg-1",
"SED5g5-SAC6-TRg-8",
"SED5g5-SAC6-TRg-4",
"SED5g5-SAC6-TRg-5",
"SED5g5-SAC6-TRg-3",
"SED5g5-DIM1-TRg-5",
"SED5g5-DIM1-TRg-7",
"SED5g5-RPC17-NRg-1",
"SED5g5-RPC17-NRg-2",
"SED5g5-YDR341C-TRg-1",
"SED5g5-RAP1-NRg-8",
"SED5g5-RAP1-NRg-5",
"SED5g5-RAP1-NRg-2",
"SED5g5-SEC26-NRg-3",
"SED5g5-SPP41-TRg-3",
"SED5g5-TAP42-NRg-1",
"SED5g5-PGA2-TRg-6",
"SED5g5-BRL1-TRg-1",
"SED5g5-FOL2-TRg-1",
"SED5g5-NAB3-NRg-5",
"SED5g5-SNF4-TRg-4",
"SED5g5-HRR25-TRg-2",
"SED5g5-TRS23-TRg-4",
"SED5g5-CTR86-TRg-4",
"SED5g5-RPB5-TRg-5",
"SED5g5-SPN1-NRg-2",
"SED5g5-SPN1-NRg-1",
"SED5g5-SEC61-NRg-1",
"SED5g5-SEC61-NRg-7",
"SED5g5-TUS1-TRg-3",
"SED5g5-OLE1-NRg-2",
"SED5g5-AFG2-TRg-1",
"SED5g5-TOA2-NRg-1",
"SED5g5-USO1-TRg-1",
"SED5g5-UTP22-NRg-2",
"SED5g5-RIB1-TRg-3",
"SED5g5-RIB1-TRg-7",
"SED5g5-RIB1-TRg-4",
"SED5g5-COG1-TRg-1",
"SED5g5-RPL32-NRg-2",
"SED5g5-GLC7-NRg-3",
"SED5g5-GLC7-NRg-4",
"SED5g5-HSF1-TRg-2",
"SED5g5-DAM1-NRg-5",
"SED5g5-SEC18-TRg-4",
"SED5g5-SEC18-TRg-5",
"SED5g5-PAB1-NRg-3",
"SED5g5-POP8-TRg-2",
"SED5g5-PAB1-NRg-4",
"SED5g5-BIG1-TRg-4",
"SED5g5-BIG1-TRg-5",
"SED5g5-BIG1-TRg-6",
"SED5g5-RPO41-NRg-1",
"SED5g5-RVB2-NRg-2",
"SED5g5-PET117-NRg-8",
"SED5g5-VPS45-NRg-9",
"SED5g5-YCG1-NRg-1",
"SED5g5-NOC4-NRg-1",
"SED5g5-NMD3-NRg-2",
"SED5g5-DRS1-TRg-2",
"SED5g5-HTB1-NRg-2",
"SED5g5-IPI1-TRg-2",
"SED5g5-SEC18-NRg-1",
"SED5g5-SEC18-NRg-2",
"SED5g5-JIP5-NRg-2",
"SED5g5-YPT1-TRg-3",
"SED5g5-YPT1-TRg-2",
"SED5g5-CLF1-NRg-2",
"SED5g5-SNF2-NRg-7",
"SED5g5-SNF2-NRg-4",
"SED5g5-RPL25-NRg-1",
"SED5g5-NOP56-TRg-1",
"SED5g5-NOP56-TRg-2",
"SED5g5-TRS31-TRg-1",
"SED5g5-DBF4-TRg-2",
"SED5g5-DBF4-TRg-1",
"SED5g5-RPC19-TRg-4",
"SED5g5-RPC19-TRg-6",
"SED5g5-RPC19-TRg-3",
"SED5g5-ROK1-NRg-1",
"SED5g5-CDC33-TRg-4",
"SED5g5-DHR2-TRg-3",
"SED5g5-RRP42-NRg-5",
"SED5g5-CLF1-TRg-1",
"SED5g5-ERG11-NA-16",
"SED5g5-VAS1-NRg-4",
"SED5g5-PIK1-NRg-2",
"SED5g5-SAR1-NRg-7",
"SED5g5-SAR1-NRg-4",
"SED5g5-RPS3-TRg-1",
"SED5g5-YTM1-TRg-2",
"SED5g5-SUI3-NRg-5",
"SED5g5-SUI3-NRg-2",
"SED5g5-RRP7-TRg-4",
"SED5g5-RRP7-TRg-6",
"SED5g5-NIP7-TRg-2",
"SED5g5-MDM35-TRg-1",
"SED5g5-ALA1-NRg-1",
"SED5g5-DOA4-NRg-2",
"SED5g5-RPS13-NRg-1",
"SED5g5-YSF3-TRg-2",
"SED5g5-RPS2-NRg-11",
"SED5g5-SSL1-TRg-10",
"SED5g5-NIP7-TRg-1",
"SED5g5-LST8-NRg-1",
"SED5g5-TAF4-TRg-3",
"SED5g5-HAS1-TRg-2",
"SED5g5-GLC7-TRg-2",
"SED5g5-CDC45-NRg-1",
"SED5g5-SEC22-NRg-8",
"SED5g5-YOS1-TRg-2",
"SED5g5-RBA50-TRg-3",
"SED5g5-SPP41-NRg-2",
"SED5g5-PRP46-TRg-2",
"SED5g5-PGA2-NRg-1",
"SED5g5-CBF5-TRg-3",
"SED5g5-TCP1-NRg-3",
"SED5g5-TCP1-NRg-2",
"SED5g5-ERG26-NRg-2",
"SED5g5-ERG26-NRg-4",
"SED5g5-MES1-TRg-5",
"SED5g5-HTS1-TRg-2",
"SED5g5-SSS1-TRg-3",
"SED5g5-SSS1-TRg-2",
"SED5g5-SYS1-TRg-7",
"SED5g5-SYS1-TRg-2",
"SED5g5-SYS1-TRg-1",
"SED5g5-BFR2-TRg-1",
"SED5g5-EOS1-TRg-3",
"SED5g5-TAF4-NRg-1",
"SED5g5-ARL3-NRg-8",
"SED5g5-RPN5-NRg-1",
"SED5g5-TIM9-NRg-2",
"SED5g5-NUP57-NRg-3",
"SED5g5-VPS4-TRg-1",
"SED5g5-CDC3-TRg-4",
"SED5g5-BBP1-NRg-1",
"SED5g5-BBP1-NRg-2",
"SED5g5-USE1-NRg-3",
"SED5g5-CCT7-TRg-1",
"SED5g5-SAH1-TRg-3",
"SED5g5-CHS2-TRg-1",
"SED5g5-DPM1-TRg-2",
"SED5g5-BBP1-TRg-1",
"SED5g5-NRD1-TRg-4",
"SED5g5-RPB3-NRg-1",
"SED5g5-PHO85-NRg-6",
"SED5g5-SNF6-TRg-6",
"SED5g5-PRP38-NRg-2",
"SED5g5-OAR1-NRg-3",
"SED5g5-ROX3-NRg-1",
"SED5g5-YPP1-TRg-6",
"SED5g5-CBF2-NRg-8",
"SED5g5-SPT6-TRg-5",
"SED5g5-SEC10-NRg-1",
"SED5g5-NSL1-NRg-3",
"SED5g5-NRD1-NRg-8",
"SED5g5-RPB3-TRg-1",
"SED5g5-NRD1-NRg-4",
"SED5g5-RVB1-TRg-2",
"SED5g5-TIF5-NRg-8",
"SED5g5-EOS1-NRg-1",
"SED5g5-ERG25-NA-26",
"SED5g5-MSL5-NRg-4",
"SED5g5-SEC24-TRg-2",
"SED5g5-RPL30-NRg-5",
"SED5g5-SNU71-NRg-3",
"SED5g5-CDC33-NRg-1",
"SED5g5-RPN6-TRg-4",
"SED5g5-NAB2-TRg-4",
"SED5g5-NAB2-TRg-6",
"SED5g5-YTM1-NRg-1",
"SED5g5-OLE1-TRg-8",
"SED5g5-OLE1-TRg-1",
"SED5g5-UTP7-TRg-4",
"SED5g5-ACT1-NRg-6",
"SED5g5-RPL18A-NRg-3",
"SED5g5-BRX1-NRg-1",
"SED5g5-NAF1-TRg-8",
"SED5g5-NAF1-TRg-6",
"SED5g5-NAF1-TRg-4",
"SED5g5-CDC8-TRg-2",
"SED5g5-NSE4-TRg-1",
"SED5g5-PAB1-NRg-2",
"SED5g5-PRP43-TRg-4",
"SED5g5-SEC2-NRg-3",
"SED5g5-SEC2-NRg-6",
"SED5g5-MPP10-NRg-5",
"SED5g5-YDR355C-TRg-2",
"SED5g5-YLR339C-TRg-9",
"SED5g5-SNM1-TRg-2",
"SED5g5-ALR1-NRg-4",
"SED5g5-ALR1-NRg-1",
"SED5g5-ALR1-NRg-3",
"SED5g5-RPL10-TRg-1",
"SED5g5-RPL28-TRg-2",
"SED5g5-UTP25-TRg-1",
"SED5g5-POB3-TRg-1",
"SED5g5-POB3-TRg-3",
"SED5g5-POB3-TRg-2",
"SED5g5-MED11-TRg-1",
"SED5g5-ISA1-TRg-15",
"SED5g5-RRP1-NRg-1",
"SED5g5-MES1-NRg-1",
"SED5g5-SEC13-NRg-5",
"SED5g5-MCM2-NRg-2",
"SED5g5-ALA1-TRg-4",
"SED5g5-MTG2-TRg-5",
"SED5g5-TIF35-NRg-3",
"SED5g5-NSE1-TRg-3",
"SED5g5-NSE1-TRg-4",
"SED5g5-MOB2-NRg-6",
"SED5g5-VRG4-NRg-3",
"SED5g5-PRP9-TRg-3",
"SED5g5-HYM1-TRg-5",
"SED5g5-POP1-TRg-5",
"SED5g5-POP1-TRg-9",
"SED5g5-RPL17A-TRg-1",
"SED5g5-SLD2-TRg-1",
"SED5g5-CDC48-NRg-7",
"SED5g5-FHL1-NRg-2",
"SED5g5-BET3-NRg-7",
"SED5g5-MAK21-TRg-1",
"SED5g5-BRN1-TRg-4",
"SED5g5-FBA1-NRg-3",
"SED5g5-CDC42-TRg-6",
"SED5g5-CDC42-TRg-7",
"SED5g5-COG4-NRg-1",
"SED5g5-ATP3-NRg-3",
"SED5g5-ATP3-NRg-2",
"SED5g5-SMP3-TRg-5",
"SED5g5-CFT2-NRg-2",
"SED5g5-FAS2-TRg-5",
"SED5g5-DBP2-NRg-3",
"SED5g5-DBP2-NRg-2",
"SED5g5-MPS2-NRg-4",
"SED5g5-ARC35-TRg-2",
"SED5g5-ARC35-TRg-5",
"SED5g5-MRD1-TRg-1",
"SED5g5-RLP7-TRg-1",
"SED5g5-SPC34-TRg-1",
"SED5g5-CDC45-TRg-2",
"SED5g5-GCD6-TRg-3",
"SED5g5-GCD6-TRg-4",
"SED5g5-YPT6-NRg-2",
"SED5g5-RPS13-TRg-2",
"SED5g5-IPI3-TRg-3",
"SED5g5-TIF5-NRg-9",
"SED5g5-TIF5-NRg-7",
"SED5g5-TIF5-NRg-6",
"SED5g5-NAB3-TRg-3",
"SED5g5-GCD2-TRg-1",
"SED5g5-UBA1-TRg-2",
"SED5g5-SLD3-TRg-6",
"SED5g5-LCB1-TRg-5",
"SED5g5-TOA2-TRg-6",
"SED5g5-TOA2-TRg-1",
"SED5g5-TOA2-TRg-3",
"SED5g5-LSM2-TRg-1",
"SED5g5-YML6-TRg-13",
"SED5g5-YML6-TRg-12",
"SED5g5-UTP15-NRg-1",
"SED5g5-TIF6-NRg-8",
"SED5g5-SUP35-NRg-1",
"SED5g5-MPP10-NRg-1",
"SED5g5-SWI3-TRg-7",
"SED5g5-SSN3-NRg-2",
"SED5g5-SEC13-NRg-7",
"SED5g5-RPS15-NRg-3",
"SED5g5-RPL3-TRg-2",
"SED5g5-FBA1-NRg-2",
"SED5g5-FBA1-NRg-1",
"SED5g5-FBA1-NRg-5",
"SED5g5-DAM1-TRg-2",
"SED5g5-NHP2-TRg-2",
"SED5g5-HCA4-NRg-6",
"SED5g5-PRE3-TRg-4",
"SED5g5-DBP5-NRg-4",
"SED5g5-SPT6-NRg-4",
"SED5g5-SPT6-NRg-2",
"SED5g5-RPL18A-TRg-4",
"SED5g5-KSH1-TRg-1",
"SED5g5-KSH1-TRg-3",
"SED5g5-IPI3-NRg-1",
"SED5g5-PGA2-TRg-8",
"SED5g5-RPL18A-TRg-2",
"SED5g5-RPL33A-NRg-6",
"SED5g5-TAF12-NRg-2",
"SED5g5-USE1-TRg-5",
"SED5g5-YNL114C-TRg-1",
"SED5g5-SMC5-TRg-7",
"SED5g5-SMC5-TRg-6",
"SED5g5-RSC58-TRg-1",
"SED5g5-CTF13-TRg-2",
"SED5g5-NAB2-NRg-2",
"SED5g5-MCM7-TRg-4",
"SED5g5-BCP1-NRg-5",
"SED5g5-STU2-TRg-3",
"SED5g5-SEC21-NRg-6",
"SED5g5-SEC21-NRg-3",
"SED5g5-RPL1B-TRg-3",
"SED5g5-SEC20-NRg-2",
"SED5g5-VMA3-NRg-2",
"SED5g5-SEC23-NRg-5",
"SED5g5-CDC28-TRg-4",
"SED5g5-RPN12-NRg-11",
"SED5g5-PUP3-TRg-3",
"SED5g5-SEC31-TRg-2",
"SED5g5-SED5-TRg-6",
"SED5g5-SED5-TRg-5",
"SED5g5-RPL33A-TRg-1",
"SED5g5-RPL33A-TRg-2",
"SED5g5-MRPL11-TRg-2",
"SED5g5-RTP1-NRg-2",
"SED5g5-NUG1-TRg-2",
"SED5g5-VPH2-TRg-4",
"SED5g5-COP1-NRg-3",
"SED5g5-CRM1-NRg-1",
"SED5g5-RPL5-NRg-4",
"SED5g5-SNU13-NRg-4",
"SED5g5-PFS2-TRg-3",
"SED5g5-MPP10-TRg-2",
"SED5g5-TSR4-NRg-2",
"SED5g5-RSC2-TRg-1",
"SED5g5-SEC65-TRg-2",
"SED5g5-SMI1-NRg-1",
"SED5g5-RTT105-NRg-4",
"SED5g5-VMA5-TRg-3",
"SED5g5-VMA5-TRg-5",
"SED5g5-RRP1-TRg-3",
"SED5g5-CLC1-TRg-2",
"SED5g5-GCD6-NRg-1",
"SED5g5-GCD6-NRg-2",
"SED5g5-PXR1-TRg-1",
"SED5g5-CDC14-NRg-1",
"SED5g5-PCF11-TRg-6",
"SED5g5-PCF11-TRg-5",
"SED5g5-PCF11-TRg-4",
"SED5g5-SEC31-NRg-1",
"SED5g5-RRP5-NRg-1",
"SED5g5-PRE10-TRg-5",
"SED5g5-PRE10-TRg-1",
"SED5g5-RPS5-TRg-2",
"SED5g5-NSP1-TRg-4",
"SED5g5-PRP38-TRg-4",
"SED5g5-RCF1-NRg-5",
"SED5g5-RSC3-TRg-4",
"SED5g5-RSC3-TRg-5",
"SED5g5-RSC3-TRg-6",
"SED5g5-HTA1-NRg-12",
"SED5g5-HTA1-NRg-11",
"SED5g5-UTP23-TRg-2",
"SED5g5-GCD7-NRg-1",
"SED5g5-GCD7-NRg-2",
"SED5g5-GCD7-NRg-6",
"SED5g5-GAL11-NRg-2",
"SED5g5-GAL11-NRg-9",
"SED5g5-PHO4-TRg-5",
"SED5g5-SNP1-NRg-3",
"SED5g5-RPC37-TRg-5",
"SED5g5-CRM1-TRg-5",
"SED5g5-CRM1-TRg-2",
"SED5g5-ASK1-TRg-7",
"SED5g5-STU2-NRg-4",
"SED5g5-NEO1-NRg-3",
"SED5g5-GAL11-TRg-5",
"SED5g5-GAL11-TRg-7",
"SED5g5-SAM50-NRg-3",
"SED5g5-CSL4-TRg-2",
"SED5g5-CCT5-TRg-2",
"SED5g5-POL30-NRg-1",
"SED5g5-MED4-TRg-4",
"SED5g5-MED4-TRg-3",
"SED5g5-MED4-TRg-2",
"SED5g5-GDI1-TRg-4",
"SED5g5-GDI1-TRg-3",
"SED5g5-REB1-TRg-6",
"SED5g5-MRPL37-NRg-2",
"SED5g5-NOC3-TRg-3",
"SED5g5-SPC97-TRg-3",
"SED5g5-IPP1-TRg-3",
"SED5g5-IPP1-TRg-2",
"SED5g5-PTI1-TRg-3",
"SED5g5-PTI1-TRg-5",
"SED5g5-RFC5-NRg-1",
"SED5g5-CDC24-TRg-1",
"SED5g5-CDC24-TRg-3",
"SED5g5-CDC24-TRg-5",
"SED5g5-CDC24-TRg-6",
"SED5g5-UTP23-TRg-6",
"SED5g5-UTP23-TRg-4",
"SED5g5-UTP23-TRg-1",
"SED5g5-RHO3-NRg-4",
"SED5g5-TRS23-NRg-1",
"SED5g5-TRS23-NRg-3",
"SED5g5-RSP5-TRg-2",
"SED5g5-RSP5-TRg-1",
"SED5g5-SDA1-NRg-1",
"SED5g5-KAP95-TRg-8",
"SED5g5-ACO1-TRg-6",
"SED5g5-HTA1-NRg-3",
"SED5g5-HTA1-NRg-2",
"SED5g5-SPN1-TRg-1",
"SED5g5-MOT1-NRg-7",
"SED5g5-RPL17A-NRg-4",
"SED5g5-ADA2-TRg-4",
"SED5g5-SFH1-NRg-1",
"SED5g5-SPC97-NRg-5",
"SED5g5-PRP22-TRg-3",
"SED5g5-SEN15-TRg-2",
"SED5g5-RPL3-NRg-2",
"SED5g5-ISD11-NRg-2",
"SED5g5-HEM12-TRg-8",
"SED5g5-SEC10-TRg-1",
"SED5g5-HTB1-TRg-7",
"SED5g5-TTI2-TRg-1",
"SED5g5-ACP1-TRg-2",
"SED5g5-ACP1-TRg-4",
"SED5g5-GAL11-NRg-10",
"SED5g5-UTP22-TRg-2",
"SED5g5-MST1-NRg-5",
"SED5g5-RIB7-NRg-2",
"SED5g5-MCD1-TRg-6",
"SED5g5-MCD1-TRg-5",
"SED5g5-GPI8-NRg-2",
"SED5g5-THS1-TRg-2",
"SED5g5-RRP7-TRg-2",
"SED5g5-RRP7-TRg-5",
"SED5g5-SMX2-NRg-7",
"SED5g5-RRP45-TRg-5",
"SED5g5-RRP45-TRg-4",
"SED5g5-CNS1-TRg-2",
"SED5g5-FBP1-NRg-9",
"SED5g5-GCD11-NRg-1",
"SED5g5-RPL10-TRg-2",
"SED5g5-NUP192-TRg-4",
"SED5g5-NUP145-NRg-4",
"SED5g5-HEM12-TRg-6",
"SED5g5-PLC1-TRg-3",
"SED5g5-RPA43-TRg-1",
"SED5g5-RPB7-NRg-2",
"SED5g5-RPB7-NRg-3",
"SED5g5-NSL1-NRg-1",
"SED5g5-UTP6-TRg-3",
"SED5g5-UTP6-TRg-1",
"SED5g5-YJU2-TRg-5",
"SED5g5-FRS2-NRg-5",
"SED5g5-TIF35-NRg-2",
"SED5g5-GPI15-TRg-1",
"SED5g5-NOP1-NRg-5",
"SED5g5-GPI15-TRg-4",
"SED5g5-COG4-TRg-1",
"SED5g5-TFA1-TRg-1",
"SED5g5-RHO1-NRg-2",
"SED5g5-RHO1-NRg-1",
"SED5g5-CDC55-NRg-2",
"SED5g5-IDI1-NRg-7",
"SED5g5-RPL32-TRg-5",
"SED5g5-RPB5-TRg-4",
"SED5g5-DIP2-TRg-5",
"SED5g5-DIP2-TRg-1",
"SED5g5-RPC40-TRg-2",
"SED5g5-CDC6-TRg-5",
"SED5g5-CDC6-TRg-3",
"SED5g5-DAD2-TRg-2",
"SED5g5-RVS161-TRg-2",
"SED5g5-RVS161-TRg-1",
"SED5g5-SUP45-NRg-3",
"SED5g5-SRB6-NRg-5",
"SED5g5-RPC11-TRg-4",
"SED5g5-RKI1-TRg-8",
"SED5g5-NIP7-TRg-3",
"SED5g5-RPL33A-NRg-12",
"SED5g5-SAM50-TRg-4",
"SED5g5-NOP4-NRg-1",
"SED5g5-NOP4-NRg-3",
"SED5g5-SMX2-TRg-5",
"SED5g5-POL12-NRg-2",
"SED5g5-BMS1-NRg-2",
"SED5g5-RPA190-TRg-5",
"SED5g5-ALG14-NRg-4",
"SED5g5-ALG14-NRg-1",
"SED5g5-PRE5-NRg-1",
"SED5g5-BIG1-NRg-2",
"SED5g5-TFA2-TRg-4",
"SED5g5-IMP4-TRg-6",
"SED5g5-PAN1-NRg-1",
"SED5g5-UTP13-TRg-2",
"SED5g5-KAE1-NRg-3",
"SED5g5-ERG20-TRg-1",
"SED5g5-CDC20-TRg-6",
"SED5g5-PWP2-NRg-2",
"SED5g5-COG1-NRg-1",
"SED5g5-RPL1B-TRg-4",
"SED5g5-RPL1B-TRg-7",
"SED5g5-UTP20-TRg-3",
"SED5g5-UTP20-TRg-4",
"SED5g5-RPL25-TRg-4",
"SED5g5-RPL25-TRg-2",
"SED5g5-MCM7-NRg-1",
"SED5g5-MRP49-TRg-5",
"SED5g5-ERO1-NRg-3",
"SED5g5-UTP5-TRg-7",
"SED5g5-MCM4-NRg-1",
"SED5g5-PRE3-NRg-1",
"SED5g5-FCF1-NRg-1",
"SED5g5-CUS1-NRg-1",
"SED5g5-PSF1-TRg-2",
"SED5g5-BCP1-TRg-2",
"SED5g5-PAN1-TRg-1",
"SED5g5-PAN1-TRg-3",
"SED5g5-PAN1-TRg-4",
"SED5g5-VPS3-TRg-2",
"SED5g5-YIL060W-NRg-1",
"SED5g5-VPS53-NRg-1",
"SED5g5-CYR1-TRg-4",
"SED5g5-CYR1-TRg-7",
"SED5g5-MPS1-NRg-1",
"SED5g5-SRP1-TRg-5",
"SED5g5-SRP1-TRg-4",
"SED5g5-TAF12-TRg-2",
"SED5g5-TAF12-TRg-3",
"SED5g5-POP4-TRg-1",
"SED5g5-SPT16-TRg-1",
"SED5g5-NUP82-TRg-4",
"SED5g5-DML1-TRg-3",
"SED5g5-RPA43-NRg-3",
"SED5g5-STU2-NRg-3",
"SED5g5-POP4-NRg-4",
"SED5g5-MCD1-TRg-2",
"SED5g5-RPS3-NRg-4",
"SED5g5-PRP9-TRg-4",
"SED5g5-RPP1-NRg-2",
"SED5g5-MTR2-NRg-11",
"SED5g5-GCD11-TRg-1",
"SED5g5-RPF1-TRg-3",
"SED5g5-SUB2-NRg-4",
"SED5g5-GPI15-TRg-3",
"SED5g5-ERG9-TRg-6",
"SED5g5-RPT2-NRg-1",
"SED5g5-YOS1-NRg-3",
"SED5g5-SCM3-TRg-4",
"SED5g5-SCM3-TRg-6",
"SED5g5-RLP7-NRg-1",
"SED5g5-TFB2-NRg-4",
"SED5g5-IMP4-TRg-1",
"SED5g5-IMP4-TRg-3",
"SED5g5-PRE4-TRg-3",
"SED5g5-SUB2-TRg-3",
"SED5g5-RPP0-NRg-4",
"SED5g5-RPP0-NRg-3",
"SED5g5-TOM40-TRg-4",
"SED5g5-FUR1-NRg-12",
"SED5g5-TOM40-TRg-2",
"SED5g5-VMA11-NRg-4",
"SED5g5-PGS1-NRg-4",
"SED5g5-URB1-TRg-4",
"SED5g5-ARP4-TRg-3",
"SED5g5-RPT3-TRg-3",
"SED5g5-SUI3-TRg-3",
"SED5g5-RFC5-NRg-2",
"SED5g5-RRP14-TRg-2",
"SED5g5-SCC2-TRg-1",
"SED5g5-SSC1-TRg-3",
"SED5g5-RRP9-TRg-3",
"SED5g5-MOT1-NRg-9",
"SED5g5-RPL42A-NRg-2",
"SED5g5-SEC16-TRg-7",
"SED5g5-IMP4-NRg-2",
"SED5g5-YEF3-NRg-4",
"SED5g5-PUP1-TRg-1",
"SED5g5-UTP22-TRg-6",
"SED5g5-DBP2-NRg-4",
"SED5g5-PRE2-TRg-7",
"SED5g5-ATP16-TRg-6",
"SED5g5-UTP13-TRg-4",
"SED5g5-DOP1-NRg-4",
"SED5g5-TIM44-TRg-3",
"SED5g5-ATP16-TRg-2",
"SED5g5-ENP1-NRg-3",
"SED5g5-NAF1-TRg-3",
"SED5g5-COG4-TRg-2",
"SED5g5-SOG2-TRg-7",
"SED5g5-YDR341C-TRg-3",
"SED5g5-YMR290W-A-TRg-10",
"SED5g5-NUP192-NRg-9",
"SED5g5-RPS31-NRg-8",
"SED5g5-SPC97-NRg-6",
"SED5g5-EBP2-NRg-1",
"SED5g5-CDC48-TRg-5",
"SED5g5-RPT1-TRg-4",
"SED5g5-ULP1-NRg-2",
"SED5g5-RPN3-TRg-6",
"SED5g5-RPT1-TRg-5",
"SED5g5-KRE5-TRg-2",
"SED5g5-TBF1-NRg-8",
"SED5g5-UTP22-NRg-4",
"SED5g5-SSC1-NRg-4",
"SED5g5-REB1-TRg-4",
"SED5g5-CDC48-NRg-9",
"SED5g5-FAS2-TRg-8",
"SED5g5-TAO3-TRg-8",
"SED5g5-CKS1-TRg-5",
"SED5g5-YLR379W-TRg-7",
"SED5g5-TEN1-NRg-2",
"SED5g5-RPL42A-TRg-2",
"SED5g5-SEC27-TRg-4",
"SED5g5-TBF1-NRg-4",
"SED5g5-RPT1-NRg-6",
"SED5g5-COG1-TRg-3",
"SED5g5-SUI1-TRg-6",
"SED5g5-TIM23-TRg-6",
"SED5g5-CDC48-NRg-6",
"SED5g5-EPL1-TRg-5",
"SED5g5-RPT5-TRg-8",
"SED5g5-ATP16-NRg-4",
"SED5g5-RPN6-TRg-3",
"SED5g5-ERG9-NRg-6",
"SED5g5-SMX3-TRg-1",
"SED5g5-NCB2-NRg-3",
"SED5g5-SEC16-NRg-12",
"SED5g5-RPN6-TRg-2",
"SED5g5-REB1-NRg-4",
"SED5g5-ATP16-TRg-9",
"SED5g5-ERG9-NRg-7",
"SEC22g1-RPL15A-NRg-4",
"SEC22g1-RPL15A-NRg-5",
"SEC22g1-KRE33-TRg-1",
"SEC22g1-PMI40-NRg-1",
"SEC22g1-NOP19-NRg-3",
"SEC22g1-SRP14-NRg-4",
"SEC22g1-SEC27-TRg-2",
"SEC22g1-GPI14-TRg-3",
"SEC22g1-PAH1-TRg-7",
"SEC22g1-PAH1-TRg-6",
"SEC22g1-PAH1-TRg-5",
"SEC22g1-PAH1-TRg-3",
"SEC22g1-COG3-TRg-1",
"SEC22g1-HTS1-NRg-5",
"SEC22g1-MSN5-TRg-7",
"SEC22g1-ERG26-TRg-1",
"SEC22g1-SMD2-TRg-5",
"SEC22g1-SMD2-TRg-4",
"SEC22g1-SMD2-TRg-1",
"SEC22g1-PRE7-TRg-4",
"SEC22g1-PRE7-TRg-7",
"SEC22g1-SEC6-TRg-3",
"SEC22g1-ESF2-NRg-1",
"SEC22g1-ESF2-NRg-3",
"SEC22g1-AFG2-TRg-2",
"SEC22g1-RRP36-TRg-3",
"SEC22g1-RRP36-TRg-5",
"SEC22g1-GCR1-NRg-2",
"SEC22g1-PRE4-NRg-4",
"SEC22g1-PRE4-NRg-9",
"SEC22g1-DSN1-NRg-2",
"SEC22g1-GPI11-TRg-3",
"SEC22g1-POP3-TRg-1",
"SEC22g1-MNE1-TRg-5",
"SEC22g1-RRP12-NRg-1",
"SEC22g1-RSC6-TRg-2",
"SEC22g1-CDC25-TRg-1",
"SEC22g1-CDC25-TRg-9",
"SEC22g1-YPP1-NRg-3",
"SEC22g1-NFS1-NRg-9",
"SEC22g1-NFS1-NRg-8",
"SEC22g1-UBA2-TRg-1",
"SEC22g1-ARP2-NRg-3",
"SEC22g1-MAK16-TRg-1",
"SEC22g1-CEP3-NRg-1",
"SEC22g1-GUK1-TRg-5",
"SEC22g1-GUK1-TRg-2",
"SEC22g1-GPI12-NRg-6",
"SEC22g1-RPS5-NRg-5",
"SEC22g1-RPS5-NRg-2",
"SEC22g1-RPC19-NRg-1",
"SEC22g1-TIM54-TRg-1",
"SEC22g1-TEN1-TRg-2",
"SEC22g1-SAH1-NRg-4",
"SEC22g1-SAH1-NRg-5",
"SEC22g1-SAH1-NRg-3",
"SEC22g1-ATP15-NRg-5",
"SEC22g1-SCD5-TRg-5",
"SEC22g1-ARB1-NRg-2",
"SEC22g1-ARB1-NRg-4",
"SEC22g1-PUP2-TRg-1",
"SEC22g1-CCT8-TRg-2",
"SEC22g1-MCM4-TRg-1",
"SEC22g1-LSM4-TRg-1",
"SEC22g1-NOP53-NRg-1",
"SEC22g1-ATP3-TRg-4",
"SEC22g1-AFG2-NRg-3",
"SEC22g1-PRO3-NRg-3",
"SEC22g1-NRD1-NRg-10",
"SEC22g1-SEC61-TRg-2",
"SEC22g1-RHO3-TRg-4",
"SEC22g1-SNF2-TRg-6",
"SEC22g1-SMD2-NRg-3",
"SEC22g1-RSC4-TRg-2",
"SEC22g1-RSC4-TRg-1",
"SEC22g1-TIF34-TRg-2",
"SEC22g1-BET1-NRg-1",
"SEC22g1-CDC8-NRg-2",
"SEC22g1-PRP42-TRg-2",
"SEC22g1-RRB1-TRg-2",
"SEC22g1-SPC24-TRg-1",
"SEC22g1-ILS1-NRg-1",
"SEC22g1-GFA1-TRg-2",
"SEC22g1-SEC21-NRg-10",
"SEC22g1-RPC10-NRg-1",
"SEC22g1-RPB10-TRg-3",
"SEC22g1-RPB10-TRg-2",
"SEC22g1-YNL181W-TRg-1",
"SEC22g1-RAD3-NRg-1",
"SEC22g1-NOP10-TRg-1",
"SEC22g1-BFR2-TRg-3",
"SEC22g1-MCM2-TRg-6",
"SEC22g1-MCM2-TRg-4",
"SEC22g1-MPP10-TRg-1",
"SEC22g1-RET2-TRg-4",
"SEC22g1-RET2-TRg-1",
"SEC22g1-RPS2-NRg-1",
"SEC22g1-RPS2-NRg-2",
"SEC22g1-ORC4-NRg-3",
"SEC22g1-TIP20-TRg-7",
"SEC22g1-SMT3-TRg-1",
"SEC22g1-MSS18-NRg-6",
"SEC22g1-YEF3-NRg-9",
"SEC22g1-ASK1-NRg-1",
"SEC22g1-SMC1-TRg-1",
"SEC22g1-NIP1-NRg-1",
"SEC22g1-RPP1-NRg-1",
"SEC22g1-YDJ1-TRg-6",
"SEC22g1-SUB2-NRg-1",
"SEC22g1-TIM10-NRg-8",
"SEC22g1-TIM10-NRg-4",
"SEC22g1-TIM10-NRg-7",
"SEC22g1-SKI6-TRg-4",
"SEC22g1-TUB4-TRg-1",
"SEC22g1-CDC37-NRg-2",
"SEC22g1-ISD11-TRg-3",
"SEC22g1-YOS1-TRg-4",
"SEC22g1-SSC1-TRg-6",
"SEC22g1-MTR3-TRg-5",
"SEC22g1-MTR3-TRg-6",
"SEC22g1-TFA1-TRg-2",
"SEC22g1-CDC3-NRg-3",
"SEC22g1-ERG25-TA-18",
"SEC22g1-RPB11-TRg-4",
"SEC22g1-RPB11-TRg-1",
"SEC22g1-RPB11-TRg-2",
"SEC22g1-DED1-TRg-3",
"SEC22g1-DED1-TRg-1",
"SEC22g1-DED1-TRg-6",
"SEC22g1-DED1-TRg-4",
"SEC22g1-RPL10-NRg-5",
"SEC22g1-RPL10-NRg-4",
"SEC22g1-EFB1-NRg-1",
"SEC22g1-EFB1-NRg-5",
"SEC22g1-EFB1-NRg-4",
"SEC22g1-RPT3-NRg-1",
"SEC22g1-SAC6-TRg-8",
"SEC22g1-SAC6-TRg-4",
"SEC22g1-SAC6-TRg-5",
"SEC22g1-SAC6-TRg-3",
"SEC22g1-DIM1-TRg-5",
"SEC22g1-DIM1-TRg-7",
"SEC22g1-RPC17-NRg-1",
"SEC22g1-RPC17-NRg-2",
"SEC22g1-YDR341C-TRg-1",
"SEC22g1-RAP1-NRg-8",
"SEC22g1-RAP1-NRg-5",
"SEC22g1-RAP1-NRg-2",
"SEC22g1-SEC26-NRg-3",
"SEC22g1-SPP41-TRg-3",
"SEC22g1-TAP42-NRg-1",
"SEC22g1-PGA2-TRg-6",
"SEC22g1-BRL1-TRg-1",
"SEC22g1-FOL2-TRg-1",
"SEC22g1-NAB3-NRg-5",
"SEC22g1-SNF4-TRg-4",
"SEC22g1-HRR25-TRg-2",
"SEC22g1-TRS23-TRg-4",
"SEC22g1-CTR86-TRg-4",
"SEC22g1-RPB5-TRg-5",
"SEC22g1-SPN1-NRg-2",
"SEC22g1-SPN1-NRg-1",
"SEC22g1-SEC61-NRg-1",
"SEC22g1-SEC61-NRg-7",
"SEC22g1-TUS1-TRg-3",
"SEC22g1-OLE1-NRg-2",
"SEC22g1-AFG2-TRg-1",
"SEC22g1-TOA2-NRg-1",
"SEC22g1-USO1-TRg-1",
"SEC22g1-UTP22-NRg-2",
"SEC22g1-RIB1-TRg-3",
"SEC22g1-RIB1-TRg-7",
"SEC22g1-RIB1-TRg-4",
"SEC22g1-COG1-TRg-1",
"SEC22g1-RPL32-NRg-2",
"SEC22g1-GLC7-NRg-3",
"SEC22g1-GLC7-NRg-4",
"SEC22g1-HSF1-TRg-2",
"SEC22g1-DAM1-NRg-5",
"SEC22g1-SEC18-TRg-4",
"SEC22g1-SEC18-TRg-5",
"SEC22g1-PAB1-NRg-3",
"SEC22g1-POP8-TRg-2",
"SEC22g1-PAB1-NRg-4",
"SEC22g1-BIG1-TRg-4",
"SEC22g1-BIG1-TRg-5",
"SEC22g1-BIG1-TRg-6",
"SEC22g1-RPO41-NRg-1",
"SEC22g1-RVB2-NRg-2",
"SEC22g1-PET117-NRg-8",
"SEC22g1-VPS45-NRg-9",
"SEC22g1-YCG1-NRg-1",
"SEC22g1-NOC4-NRg-1",
"SEC22g1-NMD3-NRg-2",
"SEC22g1-DRS1-TRg-2",
"SEC22g1-HTB1-NRg-2",
"SEC22g1-IPI1-TRg-2",
"SEC22g1-SEC18-NRg-1",
"SEC22g1-SEC18-NRg-2",
"SEC22g1-JIP5-NRg-2",
"SEC22g1-YPT1-TRg-3",
"SEC22g1-YPT1-TRg-2",
"SEC22g1-CLF1-NRg-2",
"SEC22g1-SNF2-NRg-7",
"SEC22g1-SNF2-NRg-4",
"SEC22g1-RPL25-NRg-1",
"SEC22g1-NOP56-TRg-1",
"SEC22g1-NOP56-TRg-2",
"SEC22g1-TRS31-TRg-1",
"SEC22g1-DBF4-TRg-2",
"SEC22g1-DBF4-TRg-1",
"SEC22g1-RPC19-TRg-4",
"SEC22g1-RPC19-TRg-6",
"SEC22g1-RPC19-TRg-3",
"SEC22g1-ROK1-NRg-1",
"SEC22g1-CDC33-TRg-4",
"SEC22g1-DHR2-TRg-3",
"SEC22g1-RRP42-NRg-5",
"SEC22g1-CLF1-TRg-1",
"SEC22g1-ERG11-NA-16",
"SEC22g1-VAS1-NRg-4",
"SEC22g1-PIK1-NRg-2",
"SEC22g1-SAR1-NRg-7",
"SEC22g1-SAR1-NRg-4",
"SEC22g1-RPS3-TRg-1",
"SEC22g1-YTM1-TRg-2",
"SEC22g1-SUI3-NRg-5",
"SEC22g1-SUI3-NRg-2",
"SEC22g1-RRP7-TRg-4",
"SEC22g1-RRP7-TRg-6",
"SEC22g1-NIP7-TRg-2",
"SEC22g1-MDM35-TRg-1",
"SEC22g1-ALA1-NRg-1",
"SEC22g1-DOA4-NRg-2",
"SEC22g1-RPS13-NRg-1",
"SEC22g1-YSF3-TRg-2",
"SEC22g1-RPS2-NRg-11",
"SEC22g1-SSL1-TRg-10",
"SEC22g1-NIP7-TRg-1",
"SEC22g1-LST8-NRg-1",
"SEC22g1-TAF4-TRg-3",
"SEC22g1-HAS1-TRg-2",
"SEC22g1-GLC7-TRg-2",
"SEC22g1-CDC45-NRg-1",
"SEC22g1-SEC22-NRg-8",
"SEC22g1-YOS1-TRg-2",
"SEC22g1-RBA50-TRg-3",
"SEC22g1-SPP41-NRg-2",
"SEC22g1-PRP46-TRg-2",
"SEC22g1-PGA2-NRg-1",
"SEC22g1-CBF5-TRg-3",
"SEC22g1-TCP1-NRg-3",
"SEC22g1-TCP1-NRg-2",
"SEC22g1-ERG26-NRg-2",
"SEC22g1-ERG26-NRg-4",
"SEC22g1-MES1-TRg-5",
"SEC22g1-HTS1-TRg-2",
"SEC22g1-SSS1-TRg-3",
"SEC22g1-SSS1-TRg-2",
"SEC22g1-SYS1-TRg-7",
"SEC22g1-SYS1-TRg-2",
"SEC22g1-SYS1-TRg-1",
"SEC22g1-BFR2-TRg-1",
"SEC22g1-EOS1-TRg-3",
"SEC22g1-TAF4-NRg-1",
"SEC22g1-ARL3-NRg-8",
"SEC22g1-RPN5-NRg-1",
"SEC22g1-TIM9-NRg-2",
"SEC22g1-NUP57-NRg-3",
"SEC22g1-VPS4-TRg-1",
"SEC22g1-CDC3-TRg-4",
"SEC22g1-BBP1-NRg-1",
"SEC22g1-BBP1-NRg-2",
"SEC22g1-USE1-NRg-3",
"SEC22g1-CCT7-TRg-1",
"SEC22g1-SAH1-TRg-3",
"SEC22g1-CHS2-TRg-1",
"SEC22g1-DPM1-TRg-2",
"SEC22g1-BBP1-TRg-1",
"SEC22g1-NRD1-TRg-4",
"SEC22g1-RPB3-NRg-1",
"SEC22g1-PHO85-NRg-6",
"SEC22g1-SNF6-TRg-6",
"SEC22g1-PRP38-NRg-2",
"SEC22g1-OAR1-NRg-3",
"SEC22g1-ROX3-NRg-1",
"SEC22g1-YPP1-TRg-6",
"SEC22g1-CBF2-NRg-8",
"SEC22g1-SPT6-TRg-5",
"SEC22g1-SEC10-NRg-1",
"SEC22g1-NSL1-NRg-3",
"SEC22g1-NRD1-NRg-8",
"SEC22g1-RPB3-TRg-1",
"SEC22g1-NRD1-NRg-4",
"SEC22g1-RVB1-TRg-2",
"SEC22g1-TIF5-NRg-8",
"SEC22g1-EOS1-NRg-1",
"SEC22g1-ERG25-NA-26",
"SEC22g1-MSL5-NRg-4",
"SEC22g1-SEC24-TRg-2",
"SEC22g1-RPL30-NRg-5",
"SEC22g1-SNU71-NRg-3",
"SEC22g1-CDC33-NRg-1",
"SEC22g1-RPN6-TRg-4",
"SEC22g1-NAB2-TRg-4",
"SEC22g1-NAB2-TRg-6",
"SEC22g1-YTM1-NRg-1",
"SEC22g1-OLE1-TRg-8",
"SEC22g1-OLE1-TRg-1",
"SEC22g1-UTP7-TRg-4",
"SEC22g1-ACT1-NRg-6",
"SEC22g1-RPL18A-NRg-3",
"SEC22g1-BRX1-NRg-1",
"SEC22g1-NAF1-TRg-8",
"SEC22g1-NAF1-TRg-6",
"SEC22g1-NAF1-TRg-4",
"SEC22g1-CDC8-TRg-2",
"SEC22g1-NSE4-TRg-1",
"SEC22g1-PAB1-NRg-2",
"SEC22g1-PRP43-TRg-4",
"SEC22g1-SEC2-NRg-3",
"SEC22g1-SEC2-NRg-6",
"SEC22g1-MPP10-NRg-5",
"SEC22g1-YDR355C-TRg-2",
"SEC22g1-YLR339C-TRg-9",
"SEC22g1-SNM1-TRg-2",
"SEC22g1-ALR1-NRg-4",
"SEC22g1-ALR1-NRg-1",
"SEC22g1-ALR1-NRg-3",
"SEC22g1-RPL10-TRg-1",
"SEC22g1-RPL28-TRg-2",
"SEC22g1-UTP25-TRg-1",
"SEC22g1-POB3-TRg-1",
"SEC22g1-POB3-TRg-3",
"SEC22g1-POB3-TRg-2",
"SEC22g1-MED11-TRg-1",
"SEC22g1-ISA1-TRg-15",
"SEC22g1-RRP1-NRg-1",
"SEC22g1-MES1-NRg-1",
"SEC22g1-SEC13-NRg-5",
"SEC22g1-MCM2-NRg-2",
"SEC22g1-ALA1-TRg-4",
"SEC22g1-MTG2-TRg-5",
"SEC22g1-TIF35-NRg-3",
"SEC22g1-NSE1-TRg-3",
"SEC22g1-NSE1-TRg-4",
"SEC22g1-MOB2-NRg-6",
"SEC22g1-VRG4-NRg-3",
"SEC22g1-PRP9-TRg-3",
"SEC22g1-HYM1-TRg-5",
"SEC22g1-POP1-TRg-5",
"SEC22g1-POP1-TRg-9",
"SEC22g1-RPL17A-TRg-1",
"SEC22g1-SLD2-TRg-1",
"SEC22g1-CDC48-NRg-7",
"SEC22g1-FHL1-NRg-2",
"SEC22g1-BET3-NRg-7",
"SEC22g1-MAK21-TRg-1",
"SEC22g1-BRN1-TRg-4",
"SEC22g1-FBA1-NRg-3",
"SEC22g1-CDC42-TRg-6",
"SEC22g1-CDC42-TRg-7",
"SEC22g1-COG4-NRg-1",
"SEC22g1-ATP3-NRg-3",
"SEC22g1-ATP3-NRg-2",
"SEC22g1-SMP3-TRg-5",
"SEC22g1-CFT2-NRg-2",
"SEC22g1-FAS2-TRg-5",
"SEC22g1-DBP2-NRg-3",
"SEC22g1-DBP2-NRg-2",
"SEC22g1-MPS2-NRg-4",
"SEC22g1-ARC35-TRg-2",
"SEC22g1-ARC35-TRg-5",
"SEC22g1-MRD1-TRg-1",
"SEC22g1-RLP7-TRg-1",
"SEC22g1-SPC34-TRg-1",
"SEC22g1-CDC45-TRg-2",
"SEC22g1-GCD6-TRg-3",
"SEC22g1-GCD6-TRg-4",
"SEC22g1-YPT6-NRg-2",
"SEC22g1-RPS13-TRg-2",
"SEC22g1-IPI3-TRg-3",
"SEC22g1-TIF5-NRg-9",
"SEC22g1-TIF5-NRg-7",
"SEC22g1-TIF5-NRg-6",
"SEC22g1-NAB3-TRg-3",
"SEC22g1-GCD2-TRg-1",
"SEC22g1-UBA1-TRg-2",
"SEC22g1-SLD3-TRg-6",
"SEC22g1-LCB1-TRg-5",
"SEC22g1-TOA2-TRg-6",
"SEC22g1-TOA2-TRg-1",
"SEC22g1-TOA2-TRg-3",
"SEC22g1-LSM2-TRg-1",
"SEC22g1-YML6-TRg-13",
"SEC22g1-YML6-TRg-12",
"SEC22g1-UTP15-NRg-1",
"SEC22g1-TIF6-NRg-8",
"SEC22g1-SUP35-NRg-1",
"SEC22g1-MPP10-NRg-1",
"SEC22g1-SWI3-TRg-7",
"SEC22g1-SSN3-NRg-2",
"SEC22g1-SEC13-NRg-7",
"SEC22g1-RPS15-NRg-3",
"SEC22g1-RPL3-TRg-2",
"SEC22g1-FBA1-NRg-2",
"SEC22g1-FBA1-NRg-1",
"SEC22g1-FBA1-NRg-5",
"SEC22g1-DAM1-TRg-2",
"SEC22g1-NHP2-TRg-2",
"SEC22g1-HCA4-NRg-6",
"SEC22g1-PRE3-TRg-4",
"SEC22g1-DBP5-NRg-4",
"SEC22g1-SPT6-NRg-4",
"SEC22g1-SPT6-NRg-2",
"SEC22g1-RPL18A-TRg-4",
"SEC22g1-KSH1-TRg-1",
"SEC22g1-KSH1-TRg-3",
"SEC22g1-IPI3-NRg-1",
"SEC22g1-PGA2-TRg-8",
"SEC22g1-RPL18A-TRg-2",
"SEC22g1-RPL33A-NRg-6",
"SEC22g1-TAF12-NRg-2",
"SEC22g1-USE1-TRg-5",
"SEC22g1-YNL114C-TRg-1",
"SEC22g1-SMC5-TRg-7",
"SEC22g1-SMC5-TRg-6",
"SEC22g1-RSC58-TRg-1",
"SEC22g1-CTF13-TRg-2",
"SEC22g1-NAB2-NRg-2",
"SEC22g1-MCM7-TRg-4",
"SEC22g1-BCP1-NRg-5",
"SEC22g1-STU2-TRg-3",
"SEC22g1-SEC21-NRg-6",
"SEC22g1-SEC21-NRg-3",
"SEC22g1-RPL1B-TRg-3",
"SEC22g1-SEC20-NRg-2",
"SEC22g1-VMA3-NRg-2",
"SEC22g1-SEC23-NRg-5",
"SEC22g1-CDC28-TRg-4",
"SEC22g1-RPN12-NRg-11",
"SEC22g1-PUP3-TRg-3",
"SEC22g1-SEC31-TRg-2",
"SEC22g1-SED5-TRg-6",
"SEC22g1-SED5-TRg-5",
"SEC22g1-RPL33A-TRg-1",
"SEC22g1-RPL33A-TRg-2",
"SEC22g1-MRPL11-TRg-2",
"SEC22g1-RTP1-NRg-2",
"SEC22g1-NUG1-TRg-2",
"SEC22g1-VPH2-TRg-4",
"SEC22g1-COP1-NRg-3",
"SEC22g1-CRM1-NRg-1",
"SEC22g1-RPL5-NRg-4",
"SEC22g1-SNU13-NRg-4",
"SEC22g1-PFS2-TRg-3",
"SEC22g1-MPP10-TRg-2",
"SEC22g1-TSR4-NRg-2",
"SEC22g1-RSC2-TRg-1",
"SEC22g1-SEC65-TRg-2",
"SEC22g1-SMI1-NRg-1",
"SEC22g1-RTT105-NRg-4",
"SEC22g1-VMA5-TRg-3",
"SEC22g1-VMA5-TRg-5",
"SEC22g1-RRP1-TRg-3",
"SEC22g1-CLC1-TRg-2",
"SEC22g1-GCD6-NRg-1",
"SEC22g1-GCD6-NRg-2",
"SEC22g1-PXR1-TRg-1",
"SEC22g1-CDC14-NRg-1",
"SEC22g1-PCF11-TRg-6",
"SEC22g1-PCF11-TRg-5",
"SEC22g1-PCF11-TRg-4",
"SEC22g1-SEC31-NRg-1",
"SEC22g1-RRP5-NRg-1",
"SEC22g1-PRE10-TRg-5",
"SEC22g1-PRE10-TRg-1",
"SEC22g1-RPS5-TRg-2",
"SEC22g1-NSP1-TRg-4",
"SEC22g1-PRP38-TRg-4",
"SEC22g1-RCF1-NRg-5",
"SEC22g1-RSC3-TRg-4",
"SEC22g1-RSC3-TRg-5",
"SEC22g1-RSC3-TRg-6",
"SEC22g1-HTA1-NRg-12",
"SEC22g1-HTA1-NRg-11",
"SEC22g1-UTP23-TRg-2",
"SEC22g1-GCD7-NRg-1",
"SEC22g1-GCD7-NRg-2",
"SEC22g1-GCD7-NRg-6",
"SEC22g1-GAL11-NRg-2",
"SEC22g1-GAL11-NRg-9",
"SEC22g1-PHO4-TRg-5",
"SEC22g1-SNP1-NRg-3",
"SEC22g1-RPC37-TRg-5",
"SEC22g1-CRM1-TRg-5",
"SEC22g1-CRM1-TRg-2",
"SEC22g1-ASK1-TRg-7",
"SEC22g1-STU2-NRg-4",
"SEC22g1-NEO1-NRg-3",
"SEC22g1-GAL11-TRg-5",
"SEC22g1-GAL11-TRg-7",
"SEC22g1-SAM50-NRg-3",
"SEC22g1-CSL4-TRg-2",
"SEC22g1-CCT5-TRg-2",
"SEC22g1-POL30-NRg-1",
"SEC22g1-MED4-TRg-4",
"SEC22g1-MED4-TRg-3",
"SEC22g1-MED4-TRg-2",
"SEC22g1-GDI1-TRg-4",
"SEC22g1-GDI1-TRg-3",
"SEC22g1-REB1-TRg-6",
"SEC22g1-MRPL37-NRg-2",
"SEC22g1-NOC3-TRg-3",
"SEC22g1-SPC97-TRg-3",
"SEC22g1-IPP1-TRg-3",
"SEC22g1-IPP1-TRg-2",
"SEC22g1-PTI1-TRg-3",
"SEC22g1-PTI1-TRg-5",
"SEC22g1-RFC5-NRg-1",
"SEC22g1-CDC24-TRg-1",
"SEC22g1-CDC24-TRg-3",
"SEC22g1-CDC24-TRg-5",
"SEC22g1-CDC24-TRg-6",
"SEC22g1-UTP23-TRg-6",
"SEC22g1-UTP23-TRg-4",
"SEC22g1-UTP23-TRg-1",
"SEC22g1-RHO3-NRg-4",
"SEC22g1-TRS23-NRg-1",
"SEC22g1-TRS23-NRg-3",
"SEC22g1-RSP5-TRg-2",
"SEC22g1-RSP5-TRg-1",
"SEC22g1-SDA1-NRg-1",
"SEC22g1-KAP95-TRg-8",
"SEC22g1-ACO1-TRg-6",
"SEC22g1-HTA1-NRg-3",
"SEC22g1-HTA1-NRg-2",
"SEC22g1-SPN1-TRg-1",
"SEC22g1-MOT1-NRg-7",
"SEC22g1-RPL17A-NRg-4",
"SEC22g1-ADA2-TRg-4",
"SEC22g1-SFH1-NRg-1",
"SEC22g1-SPC97-NRg-5",
"SEC22g1-PRP22-TRg-3",
"SEC22g1-SEN15-TRg-2",
"SEC22g1-RPL3-NRg-2",
"SEC22g1-ISD11-NRg-2",
"SEC22g1-HEM12-TRg-8",
"SEC22g1-SEC10-TRg-1",
"SEC22g1-HTB1-TRg-7",
"SEC22g1-TTI2-TRg-1",
"SEC22g1-ACP1-TRg-2",
"SEC22g1-ACP1-TRg-4",
"SEC22g1-GAL11-NRg-10",
"SEC22g1-UTP22-TRg-2",
"SEC22g1-MST1-NRg-5",
"SEC22g1-RIB7-NRg-2",
"SEC22g1-MCD1-TRg-6",
"SEC22g1-MCD1-TRg-5",
"SEC22g1-GPI8-NRg-2",
"SEC22g1-THS1-TRg-2",
"SEC22g1-RRP7-TRg-2",
"SEC22g1-RRP7-TRg-5",
"SEC22g1-SMX2-NRg-7",
"SEC22g1-RRP45-TRg-5",
"SEC22g1-RRP45-TRg-4",
"SEC22g1-CNS1-TRg-2",
"SEC22g1-FBP1-NRg-9",
"SEC22g1-GCD11-NRg-1",
"SEC22g1-RPL10-TRg-2",
"SEC22g1-NUP192-TRg-4",
"SEC22g1-NUP145-NRg-4",
"SEC22g1-HEM12-TRg-6",
"SEC22g1-PLC1-TRg-3",
"SEC22g1-RPA43-TRg-1",
"SEC22g1-RPB7-NRg-2",
"SEC22g1-RPB7-NRg-3",
"SEC22g1-NSL1-NRg-1",
"SEC22g1-UTP6-TRg-3",
"SEC22g1-UTP6-TRg-1",
"SEC22g1-YJU2-TRg-5",
"SEC22g1-FRS2-NRg-5",
"SEC22g1-TIF35-NRg-2",
"SEC22g1-GPI15-TRg-1",
"SEC22g1-NOP1-NRg-5",
"SEC22g1-GPI15-TRg-4",
"SEC22g1-COG4-TRg-1",
"SEC22g1-TFA1-TRg-1",
"SEC22g1-RHO1-NRg-2",
"SEC22g1-RHO1-NRg-1",
"SEC22g1-CDC55-NRg-2",
"SEC22g1-IDI1-NRg-7",
"SEC22g1-RPL32-TRg-5",
"SEC22g1-RPB5-TRg-4",
"SEC22g1-DIP2-TRg-5",
"SEC22g1-DIP2-TRg-1",
"SEC22g1-RPC40-TRg-2",
"SEC22g1-CDC6-TRg-5",
"SEC22g1-CDC6-TRg-3",
"SEC22g1-DAD2-TRg-2",
"SEC22g1-RVS161-TRg-2",
"SEC22g1-RVS161-TRg-1",
"SEC22g1-SUP45-NRg-3",
"SEC22g1-SRB6-NRg-5",
"SEC22g1-RPC11-TRg-4",
"SEC22g1-RKI1-TRg-8",
"SEC22g1-NIP7-TRg-3",
"SEC22g1-RPL33A-NRg-12",
"SEC22g1-SAM50-TRg-4",
"SEC22g1-NOP4-NRg-1",
"SEC22g1-NOP4-NRg-3",
"SEC22g1-SMX2-TRg-5",
"SEC22g1-POL12-NRg-2",
"SEC22g1-BMS1-NRg-2",
"SEC22g1-RPA190-TRg-5",
"SEC22g1-ALG14-NRg-4",
"SEC22g1-ALG14-NRg-1",
"SEC22g1-PRE5-NRg-1",
"SEC22g1-BIG1-NRg-2",
"SEC22g1-TFA2-TRg-4",
"SEC22g1-IMP4-TRg-6",
"SEC22g1-PAN1-NRg-1",
"SEC22g1-UTP13-TRg-2",
"SEC22g1-KAE1-NRg-3",
"SEC22g1-ERG20-TRg-1",
"SEC22g1-CDC20-TRg-6",
"SEC22g1-PWP2-NRg-2",
"SEC22g1-COG1-NRg-1",
"SEC22g1-RPL1B-TRg-4",
"SEC22g1-RPL1B-TRg-7",
"SEC22g1-UTP20-TRg-3",
"SEC22g1-UTP20-TRg-4",
"SEC22g1-RPL25-TRg-4",
"SEC22g1-RPL25-TRg-2",
"SEC22g1-MCM7-NRg-1",
"SEC22g1-MRP49-TRg-5",
"SEC22g1-ERO1-NRg-3",
"SEC22g1-UTP5-TRg-7",
"SEC22g1-MCM4-NRg-1",
"SEC22g1-PRE3-NRg-1",
"SEC22g1-FCF1-NRg-1",
"SEC22g1-CUS1-NRg-1",
"SEC22g1-PSF1-TRg-2",
"SEC22g1-BCP1-TRg-2",
"SEC22g1-PAN1-TRg-1",
"SEC22g1-PAN1-TRg-3",
"SEC22g1-PAN1-TRg-4",
"SEC22g1-VPS3-TRg-2",
"SEC22g1-YIL060W-NRg-1",
"SEC22g1-VPS53-NRg-1",
"SEC22g1-CYR1-TRg-4",
"SEC22g1-CYR1-TRg-7",
"SEC22g1-MPS1-NRg-1",
"SEC22g1-SRP1-TRg-5",
"SEC22g1-SRP1-TRg-4",
"SEC22g1-TAF12-TRg-2",
"SEC22g1-TAF12-TRg-3",
"SEC22g1-POP4-TRg-1",
"SEC22g1-SPT16-TRg-1",
"SEC22g1-NUP82-TRg-4",
"SEC22g1-DML1-TRg-3",
"SEC22g1-RPA43-NRg-3",
"SEC22g1-STU2-NRg-3",
"SEC22g1-POP4-NRg-4",
"SEC22g1-MCD1-TRg-2",
"SEC22g1-RPS3-NRg-4",
"SEC22g1-PRP9-TRg-4",
"SEC22g1-RPP1-NRg-2",
"SEC22g1-MTR2-NRg-11",
"SEC22g1-GCD11-TRg-1",
"SEC22g1-RPF1-TRg-3",
"SEC22g1-SUB2-NRg-4",
"SEC22g1-GPI15-TRg-3",
"SEC22g1-ERG9-TRg-6",
"SEC22g1-RPT2-NRg-1",
"SEC22g1-YOS1-NRg-3",
"SEC22g1-SCM3-TRg-4",
"SEC22g1-SCM3-TRg-6",
"SEC22g1-RLP7-NRg-1",
"SEC22g1-TFB2-NRg-4",
"SEC22g1-IMP4-TRg-1",
"SEC22g1-IMP4-TRg-3",
"SEC22g1-PRE4-TRg-3",
"SEC22g1-SUB2-TRg-3",
"SEC22g1-RPP0-NRg-4",
"SEC22g1-RPP0-NRg-3",
"SEC22g1-TOM40-TRg-4",
"SEC22g1-FUR1-NRg-12",
"SEC22g1-TOM40-TRg-2",
"SEC22g1-VMA11-NRg-4",
"SEC22g1-PGS1-NRg-4",
"SEC22g1-URB1-TRg-4",
"SEC22g1-ARP4-TRg-3",
"SEC22g1-RPT3-TRg-3",
"SEC22g1-SUI3-TRg-3",
"SEC22g1-RFC5-NRg-2",
"SEC22g1-RRP14-TRg-2",
"SEC22g1-SCC2-TRg-1",
"SEC22g1-SSC1-TRg-3",
"SEC22g1-RRP9-TRg-3",
"SEC22g1-MOT1-NRg-9",
"SEC22g1-RPL42A-NRg-2",
"SEC22g1-SEC16-TRg-7",
"SEC22g1-IMP4-NRg-2",
"SEC22g1-YEF3-NRg-4",
"SEC22g1-PUP1-TRg-1",
"SEC22g1-UTP22-TRg-6",
"SEC22g1-DBP2-NRg-4",
"SEC22g1-PRE2-TRg-7",
"SEC22g1-ATP16-TRg-6",
"SEC22g1-UTP13-TRg-4",
"SEC22g1-DOP1-NRg-4",
"SEC22g1-TIM44-TRg-3",
"SEC22g1-ATP16-TRg-2",
"SEC22g1-ENP1-NRg-3",
"SEC22g1-NAF1-TRg-3",
"SEC22g1-COG4-TRg-2",
"SEC22g1-SOG2-TRg-7",
"SEC22g1-YDR341C-TRg-3",
"SEC22g1-YMR290W-A-TRg-10",
"SEC22g1-NUP192-NRg-9",
"SEC22g1-RPS31-NRg-8",
"SEC22g1-SPC97-NRg-6",
"SEC22g1-EBP2-NRg-1",
"SEC22g1-CDC48-TRg-5",
"SEC22g1-RPT1-TRg-4",
"SEC22g1-ULP1-NRg-2",
"SEC22g1-RPN3-TRg-6",
"SEC22g1-RPT1-TRg-5",
"SEC22g1-KRE5-TRg-2",
"SEC22g1-TBF1-NRg-8",
"SEC22g1-UTP22-NRg-4",
"SEC22g1-SSC1-NRg-4",
"SEC22g1-REB1-TRg-4",
"SEC22g1-CDC48-NRg-9",
"SEC22g1-FAS2-TRg-8",
"SEC22g1-TAO3-TRg-8",
"SEC22g1-CKS1-TRg-5",
"SEC22g1-YLR379W-TRg-7",
"SEC22g1-TEN1-NRg-2",
"SEC22g1-RPL42A-TRg-2",
"SEC22g1-SEC27-TRg-4",
"SEC22g1-TBF1-NRg-4",
"SEC22g1-RPT1-NRg-6",
"SEC22g1-COG1-TRg-3",
"SEC22g1-SUI1-TRg-6",
"SEC22g1-TIM23-TRg-6",
"SEC22g1-CDC48-NRg-6",
"SEC22g1-EPL1-TRg-5",
"SEC22g1-RPT5-TRg-8",
"SEC22g1-ATP16-NRg-4",
"SEC22g1-RPN6-TRg-3",
"SEC22g1-ERG9-NRg-6",
"SEC22g1-SMX3-TRg-1",
"SEC22g1-NCB2-NRg-3",
"SEC22g1-SEC16-NRg-12",
"SEC22g1-RPN6-TRg-2",
"SEC22g1-REB1-NRg-4",
"SEC22g1-ATP16-TRg-9",
"SEC22g1-ERG9-NRg-7",
"SEC22g2-RPL15A-NRg-4",
"SEC22g2-RPL15A-NRg-5",
"SEC22g2-KRE33-TRg-1",
"SEC22g2-PMI40-NRg-1",
"SEC22g2-NOP19-NRg-3",
"SEC22g2-SRP14-NRg-4",
"SEC22g2-SEC27-TRg-2",
"SEC22g2-GPI14-TRg-3",
"SEC22g2-PAH1-TRg-7",
"SEC22g2-PAH1-TRg-6",
"SEC22g2-PAH1-TRg-5",
"SEC22g2-PAH1-TRg-3",
"SEC22g2-COG3-TRg-1",
"SEC22g2-HTS1-NRg-5",
"SEC22g2-MSN5-TRg-7",
"SEC22g2-ERG26-TRg-1",
"SEC22g2-SMD2-TRg-5",
"SEC22g2-SMD2-TRg-4",
"SEC22g2-SMD2-TRg-1",
"SEC22g2-PRE7-TRg-4",
"SEC22g2-PRE7-TRg-7",
"SEC22g2-SEC6-TRg-3",
"SEC22g2-ESF2-NRg-1",
"SEC22g2-ESF2-NRg-3",
"SEC22g2-AFG2-TRg-2",
"SEC22g2-RRP36-TRg-3",
"SEC22g2-RRP36-TRg-5",
"SEC22g2-GCR1-NRg-2",
"SEC22g2-PRE4-NRg-4",
"SEC22g2-PRE4-NRg-9",
"SEC22g2-DSN1-NRg-2",
"SEC22g2-GPI11-TRg-3",
"SEC22g2-POP3-TRg-1",
"SEC22g2-MNE1-TRg-5",
"SEC22g2-RRP12-NRg-1",
"SEC22g2-RSC6-TRg-2",
"SEC22g2-CDC25-TRg-1",
"SEC22g2-CDC25-TRg-9",
"SEC22g2-YPP1-NRg-3",
"SEC22g2-NFS1-NRg-9",
"SEC22g2-NFS1-NRg-8",
"SEC22g2-UBA2-TRg-1",
"SEC22g2-ARP2-NRg-3",
"SEC22g2-MAK16-TRg-1",
"SEC22g2-CEP3-NRg-1",
"SEC22g2-GUK1-TRg-5",
"SEC22g2-GUK1-TRg-2",
"SEC22g2-GPI12-NRg-6",
"SEC22g2-RPS5-NRg-5",
"SEC22g2-RPS5-NRg-2",
"SEC22g2-RPC19-NRg-1",
"SEC22g2-TIM54-TRg-1",
"SEC22g2-TEN1-TRg-2",
"SEC22g2-SAH1-NRg-4",
"SEC22g2-SAH1-NRg-5",
"SEC22g2-SAH1-NRg-3",
"SEC22g2-ATP15-NRg-5",
"SEC22g2-SCD5-TRg-5",
"SEC22g2-ARB1-NRg-2",
"SEC22g2-ARB1-NRg-4",
"SEC22g2-PUP2-TRg-1",
"SEC22g2-CCT8-TRg-2",
"SEC22g2-MCM4-TRg-1",
"SEC22g2-LSM4-TRg-1",
"SEC22g2-NOP53-NRg-1",
"SEC22g2-ATP3-TRg-4",
"SEC22g2-AFG2-NRg-3",
"SEC22g2-PRO3-NRg-3",
"SEC22g2-NRD1-NRg-10",
"SEC22g2-SEC61-TRg-2",
"SEC22g2-RHO3-TRg-4",
"SEC22g2-SNF2-TRg-6",
"SEC22g2-SMD2-NRg-3",
"SEC22g2-RSC4-TRg-2",
"SEC22g2-RSC4-TRg-1",
"SEC22g2-TIF34-TRg-2",
"SEC22g2-BET1-NRg-1",
"SEC22g2-CDC8-NRg-2",
"SEC22g2-PRP42-TRg-2",
"SEC22g2-RRB1-TRg-2",
"SEC22g2-SPC24-TRg-1",
"SEC22g2-ILS1-NRg-1",
"SEC22g2-GFA1-TRg-2",
"SEC22g2-SEC21-NRg-10",
"SEC22g2-RPC10-NRg-1",
"SEC22g2-RPB10-TRg-3",
"SEC22g2-RPB10-TRg-2",
"SEC22g2-YNL181W-TRg-1",
"SEC22g2-RAD3-NRg-1",
"SEC22g2-NOP10-TRg-1",
"SEC22g2-BFR2-TRg-3",
"SEC22g2-MCM2-TRg-6",
"SEC22g2-MCM2-TRg-4",
"SEC22g2-MPP10-TRg-1",
"SEC22g2-RET2-TRg-4",
"SEC22g2-RET2-TRg-1",
"SEC22g2-RPS2-NRg-1",
"SEC22g2-RPS2-NRg-2",
"SEC22g2-ORC4-NRg-3",
"SEC22g2-TIP20-TRg-7",
"SEC22g2-SMT3-TRg-1",
"SEC22g2-MSS18-NRg-6",
"SEC22g2-YEF3-NRg-9",
"SEC22g2-ASK1-NRg-1",
"SEC22g2-SMC1-TRg-1",
"SEC22g2-NIP1-NRg-1",
"SEC22g2-RPP1-NRg-1",
"SEC22g2-YDJ1-TRg-6",
"SEC22g2-SUB2-NRg-1",
"SEC22g2-TIM10-NRg-8",
"SEC22g2-TIM10-NRg-4",
"SEC22g2-TIM10-NRg-7",
"SEC22g2-SKI6-TRg-4",
"SEC22g2-TUB4-TRg-1",
"SEC22g2-CDC37-NRg-2",
"SEC22g2-ISD11-TRg-3",
"SEC22g2-YOS1-TRg-4",
"SEC22g2-SSC1-TRg-6",
"SEC22g2-MTR3-TRg-5",
"SEC22g2-MTR3-TRg-6",
"SEC22g2-TFA1-TRg-2",
"SEC22g2-CDC3-NRg-3",
"SEC22g2-ERG25-TA-18",
"SEC22g2-RPB11-TRg-4",
"SEC22g2-RPB11-TRg-1",
"SEC22g2-RPB11-TRg-2",
"SEC22g2-DED1-TRg-3",
"SEC22g2-DED1-TRg-1",
"SEC22g2-DED1-TRg-6",
"SEC22g2-DED1-TRg-4",
"SEC22g2-RPL10-NRg-5",
"SEC22g2-RPL10-NRg-4",
"SEC22g2-EFB1-NRg-1",
"SEC22g2-EFB1-NRg-5",
"SEC22g2-EFB1-NRg-4",
"SEC22g2-RPT3-NRg-1",
"SEC22g2-SAC6-TRg-8",
"SEC22g2-SAC6-TRg-4",
"SEC22g2-SAC6-TRg-5",
"SEC22g2-SAC6-TRg-3",
"SEC22g2-DIM1-TRg-5",
"SEC22g2-DIM1-TRg-7",
"SEC22g2-RPC17-NRg-1",
"SEC22g2-RPC17-NRg-2",
"SEC22g2-YDR341C-TRg-1",
"SEC22g2-RAP1-NRg-8",
"SEC22g2-RAP1-NRg-5",
"SEC22g2-RAP1-NRg-2",
"SEC22g2-SEC26-NRg-3",
"SEC22g2-SPP41-TRg-3",
"SEC22g2-TAP42-NRg-1",
"SEC22g2-PGA2-TRg-6",
"SEC22g2-BRL1-TRg-1",
"SEC22g2-FOL2-TRg-1",
"SEC22g2-NAB3-NRg-5",
"SEC22g2-SNF4-TRg-4",
"SEC22g2-HRR25-TRg-2",
"SEC22g2-TRS23-TRg-4",
"SEC22g2-CTR86-TRg-4",
"SEC22g2-RPB5-TRg-5",
"SEC22g2-SPN1-NRg-2",
"SEC22g2-SPN1-NRg-1",
"SEC22g2-SEC61-NRg-1",
"SEC22g2-SEC61-NRg-7",
"SEC22g2-TUS1-TRg-3",
"SEC22g2-OLE1-NRg-2",
"SEC22g2-AFG2-TRg-1",
"SEC22g2-TOA2-NRg-1",
"SEC22g2-USO1-TRg-1",
"SEC22g2-UTP22-NRg-2",
"SEC22g2-RIB1-TRg-3",
"SEC22g2-RIB1-TRg-7",
"SEC22g2-RIB1-TRg-4",
"SEC22g2-COG1-TRg-1",
"SEC22g2-RPL32-NRg-2",
"SEC22g2-GLC7-NRg-3",
"SEC22g2-GLC7-NRg-4",
"SEC22g2-HSF1-TRg-2",
"SEC22g2-DAM1-NRg-5",
"SEC22g2-SEC18-TRg-4",
"SEC22g2-SEC18-TRg-5",
"SEC22g2-PAB1-NRg-3",
"SEC22g2-POP8-TRg-2",
"SEC22g2-PAB1-NRg-4",
"SEC22g2-BIG1-TRg-4",
"SEC22g2-BIG1-TRg-5",
"SEC22g2-BIG1-TRg-6",
"SEC22g2-RPO41-NRg-1",
"SEC22g2-RVB2-NRg-2",
"SEC22g2-PET117-NRg-8",
"SEC22g2-VPS45-NRg-9",
"SEC22g2-YCG1-NRg-1",
"SEC22g2-NOC4-NRg-1",
"SEC22g2-NMD3-NRg-2",
"SEC22g2-DRS1-TRg-2",
"SEC22g2-HTB1-NRg-2",
"SEC22g2-IPI1-TRg-2",
"SEC22g2-SEC18-NRg-1",
"SEC22g2-SEC18-NRg-2",
"SEC22g2-JIP5-NRg-2",
"SEC22g2-YPT1-TRg-3",
"SEC22g2-YPT1-TRg-2",
"SEC22g2-CLF1-NRg-2",
"SEC22g2-SNF2-NRg-7",
"SEC22g2-SNF2-NRg-4",
"SEC22g2-RPL25-NRg-1",
"SEC22g2-NOP56-TRg-1",
"SEC22g2-NOP56-TRg-2",
"SEC22g2-TRS31-TRg-1",
"SEC22g2-DBF4-TRg-2",
"SEC22g2-DBF4-TRg-1",
"SEC22g2-RPC19-TRg-4",
"SEC22g2-RPC19-TRg-6",
"SEC22g2-RPC19-TRg-3",
"SEC22g2-ROK1-NRg-1",
"SEC22g2-CDC33-TRg-4",
"SEC22g2-DHR2-TRg-3",
"SEC22g2-RRP42-NRg-5",
"SEC22g2-CLF1-TRg-1",
"SEC22g2-ERG11-NA-16",
"SEC22g2-VAS1-NRg-4",
"SEC22g2-PIK1-NRg-2",
"SEC22g2-SAR1-NRg-7",
"SEC22g2-SAR1-NRg-4",
"SEC22g2-RPS3-TRg-1",
"SEC22g2-YTM1-TRg-2",
"SEC22g2-SUI3-NRg-5",
"SEC22g2-SUI3-NRg-2",
"SEC22g2-RRP7-TRg-4",
"SEC22g2-RRP7-TRg-6",
"SEC22g2-NIP7-TRg-2",
"SEC22g2-MDM35-TRg-1",
"SEC22g2-ALA1-NRg-1",
"SEC22g2-DOA4-NRg-2",
"SEC22g2-RPS13-NRg-1",
"SEC22g2-YSF3-TRg-2",
"SEC22g2-RPS2-NRg-11",
"SEC22g2-SSL1-TRg-10",
"SEC22g2-NIP7-TRg-1",
"SEC22g2-LST8-NRg-1",
"SEC22g2-TAF4-TRg-3",
"SEC22g2-HAS1-TRg-2",
"SEC22g2-GLC7-TRg-2",
"SEC22g2-CDC45-NRg-1",
"SEC22g2-SEC22-NRg-8",
"SEC22g2-YOS1-TRg-2",
"SEC22g2-RBA50-TRg-3",
"SEC22g2-SPP41-NRg-2",
"SEC22g2-PRP46-TRg-2",
"SEC22g2-PGA2-NRg-1",
"SEC22g2-CBF5-TRg-3",
"SEC22g2-TCP1-NRg-3",
"SEC22g2-TCP1-NRg-2",
"SEC22g2-ERG26-NRg-2",
"SEC22g2-ERG26-NRg-4",
"SEC22g2-MES1-TRg-5",
"SEC22g2-HTS1-TRg-2",
"SEC22g2-SSS1-TRg-3",
"SEC22g2-SSS1-TRg-2",
"SEC22g2-SYS1-TRg-7",
"SEC22g2-SYS1-TRg-2",
"SEC22g2-SYS1-TRg-1",
"SEC22g2-BFR2-TRg-1",
"SEC22g2-EOS1-TRg-3",
"SEC22g2-TAF4-NRg-1",
"SEC22g2-ARL3-NRg-8",
"SEC22g2-RPN5-NRg-1",
"SEC22g2-TIM9-NRg-2",
"SEC22g2-NUP57-NRg-3",
"SEC22g2-VPS4-TRg-1",
"SEC22g2-CDC3-TRg-4",
"SEC22g2-BBP1-NRg-1",
"SEC22g2-BBP1-NRg-2",
"SEC22g2-USE1-NRg-3",
"SEC22g2-CCT7-TRg-1",
"SEC22g2-SAH1-TRg-3",
"SEC22g2-CHS2-TRg-1",
"SEC22g2-DPM1-TRg-2",
"SEC22g2-BBP1-TRg-1",
"SEC22g2-NRD1-TRg-4",
"SEC22g2-RPB3-NRg-1",
"SEC22g2-PHO85-NRg-6",
"SEC22g2-SNF6-TRg-6",
"SEC22g2-PRP38-NRg-2",
"SEC22g2-OAR1-NRg-3",
"SEC22g2-ROX3-NRg-1",
"SEC22g2-YPP1-TRg-6",
"SEC22g2-CBF2-NRg-8",
"SEC22g2-SPT6-TRg-5",
"SEC22g2-SEC10-NRg-1",
"SEC22g2-NSL1-NRg-3",
"SEC22g2-NRD1-NRg-8",
"SEC22g2-RPB3-TRg-1",
"SEC22g2-NRD1-NRg-4",
"SEC22g2-RVB1-TRg-2",
"SEC22g2-TIF5-NRg-8",
"SEC22g2-EOS1-NRg-1",
"SEC22g2-ERG25-NA-26",
"SEC22g2-MSL5-NRg-4",
"SEC22g2-SEC24-TRg-2",
"SEC22g2-RPL30-NRg-5",
"SEC22g2-SNU71-NRg-3",
"SEC22g2-CDC33-NRg-1",
"SEC22g2-RPN6-TRg-4",
"SEC22g2-NAB2-TRg-4",
"SEC22g2-NAB2-TRg-6",
"SEC22g2-YTM1-NRg-1",
"SEC22g2-OLE1-TRg-8",
"SEC22g2-OLE1-TRg-1",
"SEC22g2-UTP7-TRg-4",
"SEC22g2-ACT1-NRg-6",
"SEC22g2-RPL18A-NRg-3",
"SEC22g2-BRX1-NRg-1",
"SEC22g2-NAF1-TRg-8",
"SEC22g2-NAF1-TRg-6",
"SEC22g2-NAF1-TRg-4",
"SEC22g2-CDC8-TRg-2",
"SEC22g2-NSE4-TRg-1",
"SEC22g2-PAB1-NRg-2",
"SEC22g2-PRP43-TRg-4",
"SEC22g2-SEC2-NRg-3",
"SEC22g2-SEC2-NRg-6",
"SEC22g2-MPP10-NRg-5",
"SEC22g2-YDR355C-TRg-2",
"SEC22g2-YLR339C-TRg-9",
"SEC22g2-SNM1-TRg-2",
"SEC22g2-ALR1-NRg-4",
"SEC22g2-ALR1-NRg-1",
"SEC22g2-ALR1-NRg-3",
"SEC22g2-RPL10-TRg-1",
"SEC22g2-RPL28-TRg-2",
"SEC22g2-UTP25-TRg-1",
"SEC22g2-POB3-TRg-1",
"SEC22g2-POB3-TRg-3",
"SEC22g2-POB3-TRg-2",
"SEC22g2-MED11-TRg-1",
"SEC22g2-ISA1-TRg-15",
"SEC22g2-RRP1-NRg-1",
"SEC22g2-MES1-NRg-1",
"SEC22g2-SEC13-NRg-5",
"SEC22g2-MCM2-NRg-2",
"SEC22g2-ALA1-TRg-4",
"SEC22g2-MTG2-TRg-5",
"SEC22g2-TIF35-NRg-3",
"SEC22g2-NSE1-TRg-3",
"SEC22g2-NSE1-TRg-4",
"SEC22g2-MOB2-NRg-6",
"SEC22g2-VRG4-NRg-3",
"SEC22g2-PRP9-TRg-3",
"SEC22g2-HYM1-TRg-5",
"SEC22g2-POP1-TRg-5",
"SEC22g2-POP1-TRg-9",
"SEC22g2-RPL17A-TRg-1",
"SEC22g2-SLD2-TRg-1",
"SEC22g2-CDC48-NRg-7",
"SEC22g2-FHL1-NRg-2",
"SEC22g2-BET3-NRg-7",
"SEC22g2-MAK21-TRg-1",
"SEC22g2-BRN1-TRg-4",
"SEC22g2-FBA1-NRg-3",
"SEC22g2-CDC42-TRg-6",
"SEC22g2-CDC42-TRg-7",
"SEC22g2-COG4-NRg-1",
"SEC22g2-ATP3-NRg-3",
"SEC22g2-ATP3-NRg-2",
"SEC22g2-SMP3-TRg-5",
"SEC22g2-CFT2-NRg-2",
"SEC22g2-FAS2-TRg-5",
"SEC22g2-DBP2-NRg-3",
"SEC22g2-DBP2-NRg-2",
"SEC22g2-MPS2-NRg-4",
"SEC22g2-ARC35-TRg-2",
"SEC22g2-ARC35-TRg-5",
"SEC22g2-MRD1-TRg-1",
"SEC22g2-RLP7-TRg-1",
"SEC22g2-SPC34-TRg-1",
"SEC22g2-CDC45-TRg-2",
"SEC22g2-GCD6-TRg-3",
"SEC22g2-GCD6-TRg-4",
"SEC22g2-YPT6-NRg-2",
"SEC22g2-RPS13-TRg-2",
"SEC22g2-IPI3-TRg-3",
"SEC22g2-TIF5-NRg-9",
"SEC22g2-TIF5-NRg-7",
"SEC22g2-TIF5-NRg-6",
"SEC22g2-NAB3-TRg-3",
"SEC22g2-GCD2-TRg-1",
"SEC22g2-UBA1-TRg-2",
"SEC22g2-SLD3-TRg-6",
"SEC22g2-LCB1-TRg-5",
"SEC22g2-TOA2-TRg-6",
"SEC22g2-TOA2-TRg-1",
"SEC22g2-TOA2-TRg-3",
"SEC22g2-LSM2-TRg-1",
"SEC22g2-YML6-TRg-13",
"SEC22g2-YML6-TRg-12",
"SEC22g2-UTP15-NRg-1",
"SEC22g2-TIF6-NRg-8",
"SEC22g2-SUP35-NRg-1",
"SEC22g2-MPP10-NRg-1",
"SEC22g2-SWI3-TRg-7",
"SEC22g2-SSN3-NRg-2",
"SEC22g2-SEC13-NRg-7",
"SEC22g2-RPS15-NRg-3",
"SEC22g2-RPL3-TRg-2",
"SEC22g2-FBA1-NRg-2",
"SEC22g2-FBA1-NRg-1",
"SEC22g2-FBA1-NRg-5",
"SEC22g2-DAM1-TRg-2",
"SEC22g2-NHP2-TRg-2",
"SEC22g2-HCA4-NRg-6",
"SEC22g2-PRE3-TRg-4",
"SEC22g2-DBP5-NRg-4",
"SEC22g2-SPT6-NRg-4",
"SEC22g2-SPT6-NRg-2",
"SEC22g2-RPL18A-TRg-4",
"SEC22g2-KSH1-TRg-1",
"SEC22g2-KSH1-TRg-3",
"SEC22g2-IPI3-NRg-1",
"SEC22g2-PGA2-TRg-8",
"SEC22g2-RPL18A-TRg-2",
"SEC22g2-RPL33A-NRg-6",
"SEC22g2-TAF12-NRg-2",
"SEC22g2-USE1-TRg-5",
"SEC22g2-YNL114C-TRg-1",
"SEC22g2-SMC5-TRg-7",
"SEC22g2-SMC5-TRg-6",
"SEC22g2-RSC58-TRg-1",
"SEC22g2-CTF13-TRg-2",
"SEC22g2-NAB2-NRg-2",
"SEC22g2-MCM7-TRg-4",
"SEC22g2-BCP1-NRg-5",
"SEC22g2-STU2-TRg-3",
"SEC22g2-SEC21-NRg-6",
"SEC22g2-SEC21-NRg-3",
"SEC22g2-RPL1B-TRg-3",
"SEC22g2-SEC20-NRg-2",
"SEC22g2-VMA3-NRg-2",
"SEC22g2-SEC23-NRg-5",
"SEC22g2-CDC28-TRg-4",
"SEC22g2-RPN12-NRg-11",
"SEC22g2-PUP3-TRg-3",
"SEC22g2-SEC31-TRg-2",
"SEC22g2-SED5-TRg-6",
"SEC22g2-SED5-TRg-5",
"SEC22g2-RPL33A-TRg-1",
"SEC22g2-RPL33A-TRg-2",
"SEC22g2-MRPL11-TRg-2",
"SEC22g2-RTP1-NRg-2",
"SEC22g2-NUG1-TRg-2",
"SEC22g2-VPH2-TRg-4",
"SEC22g2-COP1-NRg-3",
"SEC22g2-CRM1-NRg-1",
"SEC22g2-RPL5-NRg-4",
"SEC22g2-SNU13-NRg-4",
"SEC22g2-PFS2-TRg-3",
"SEC22g2-MPP10-TRg-2",
"SEC22g2-TSR4-NRg-2",
"SEC22g2-RSC2-TRg-1",
"SEC22g2-SEC65-TRg-2",
"SEC22g2-SMI1-NRg-1",
"SEC22g2-RTT105-NRg-4",
"SEC22g2-VMA5-TRg-3",
"SEC22g2-VMA5-TRg-5",
"SEC22g2-RRP1-TRg-3",
"SEC22g2-CLC1-TRg-2",
"SEC22g2-GCD6-NRg-1",
"SEC22g2-GCD6-NRg-2",
"SEC22g2-PXR1-TRg-1",
"SEC22g2-CDC14-NRg-1",
"SEC22g2-PCF11-TRg-6",
"SEC22g2-PCF11-TRg-5",
"SEC22g2-PCF11-TRg-4",
"SEC22g2-SEC31-NRg-1",
"SEC22g2-RRP5-NRg-1",
"SEC22g2-PRE10-TRg-5",
"SEC22g2-PRE10-TRg-1",
"SEC22g2-RPS5-TRg-2",
"SEC22g2-NSP1-TRg-4",
"SEC22g2-PRP38-TRg-4",
"SEC22g2-RCF1-NRg-5",
"SEC22g2-RSC3-TRg-4",
"SEC22g2-RSC3-TRg-5",
"SEC22g2-RSC3-TRg-6",
"SEC22g2-HTA1-NRg-12",
"SEC22g2-HTA1-NRg-11",
"SEC22g2-UTP23-TRg-2",
"SEC22g2-GCD7-NRg-1",
"SEC22g2-GCD7-NRg-2",
"SEC22g2-GCD7-NRg-6",
"SEC22g2-GAL11-NRg-2",
"SEC22g2-GAL11-NRg-9",
"SEC22g2-PHO4-TRg-5",
"SEC22g2-SNP1-NRg-3",
"SEC22g2-RPC37-TRg-5",
"SEC22g2-CRM1-TRg-5",
"SEC22g2-CRM1-TRg-2",
"SEC22g2-ASK1-TRg-7",
"SEC22g2-STU2-NRg-4",
"SEC22g2-NEO1-NRg-3",
"SEC22g2-GAL11-TRg-5",
"SEC22g2-GAL11-TRg-7",
"SEC22g2-SAM50-NRg-3",
"SEC22g2-CSL4-TRg-2",
"SEC22g2-CCT5-TRg-2",
"SEC22g2-POL30-NRg-1",
"SEC22g2-MED4-TRg-4",
"SEC22g2-MED4-TRg-3",
"SEC22g2-MED4-TRg-2",
"SEC22g2-GDI1-TRg-4",
"SEC22g2-GDI1-TRg-3",
"SEC22g2-REB1-TRg-6",
"SEC22g2-MRPL37-NRg-2",
"SEC22g2-NOC3-TRg-3",
"SEC22g2-SPC97-TRg-3",
"SEC22g2-IPP1-TRg-3",
"SEC22g2-IPP1-TRg-2",
"SEC22g2-PTI1-TRg-3",
"SEC22g2-PTI1-TRg-5",
"SEC22g2-RFC5-NRg-1",
"SEC22g2-CDC24-TRg-1",
"SEC22g2-CDC24-TRg-3",
"SEC22g2-CDC24-TRg-5",
"SEC22g2-CDC24-TRg-6",
"SEC22g2-UTP23-TRg-6",
"SEC22g2-UTP23-TRg-4",
"SEC22g2-UTP23-TRg-1",
"SEC22g2-RHO3-NRg-4",
"SEC22g2-TRS23-NRg-1",
"SEC22g2-TRS23-NRg-3",
"SEC22g2-RSP5-TRg-2",
"SEC22g2-RSP5-TRg-1",
"SEC22g2-SDA1-NRg-1",
"SEC22g2-KAP95-TRg-8",
"SEC22g2-ACO1-TRg-6",
"SEC22g2-HTA1-NRg-3",
"SEC22g2-HTA1-NRg-2",
"SEC22g2-SPN1-TRg-1",
"SEC22g2-MOT1-NRg-7",
"SEC22g2-RPL17A-NRg-4",
"SEC22g2-ADA2-TRg-4",
"SEC22g2-SFH1-NRg-1",
"SEC22g2-SPC97-NRg-5",
"SEC22g2-PRP22-TRg-3",
"SEC22g2-SEN15-TRg-2",
"SEC22g2-RPL3-NRg-2",
"SEC22g2-ISD11-NRg-2",
"SEC22g2-HEM12-TRg-8",
"SEC22g2-SEC10-TRg-1",
"SEC22g2-HTB1-TRg-7",
"SEC22g2-TTI2-TRg-1",
"SEC22g2-ACP1-TRg-2",
"SEC22g2-ACP1-TRg-4",
"SEC22g2-GAL11-NRg-10",
"SEC22g2-UTP22-TRg-2",
"SEC22g2-MST1-NRg-5",
"SEC22g2-RIB7-NRg-2",
"SEC22g2-MCD1-TRg-6",
"SEC22g2-MCD1-TRg-5",
"SEC22g2-GPI8-NRg-2",
"SEC22g2-THS1-TRg-2",
"SEC22g2-RRP7-TRg-2",
"SEC22g2-RRP7-TRg-5",
"SEC22g2-SMX2-NRg-7",
"SEC22g2-RRP45-TRg-5",
"SEC22g2-RRP45-TRg-4",
"SEC22g2-CNS1-TRg-2",
"SEC22g2-FBP1-NRg-9",
"SEC22g2-GCD11-NRg-1",
"SEC22g2-RPL10-TRg-2",
"SEC22g2-NUP192-TRg-4",
"SEC22g2-NUP145-NRg-4",
"SEC22g2-HEM12-TRg-6",
"SEC22g2-PLC1-TRg-3",
"SEC22g2-RPA43-TRg-1",
"SEC22g2-RPB7-NRg-2",
"SEC22g2-RPB7-NRg-3",
"SEC22g2-NSL1-NRg-1",
"SEC22g2-UTP6-TRg-3",
"SEC22g2-UTP6-TRg-1",
"SEC22g2-YJU2-TRg-5",
"SEC22g2-FRS2-NRg-5",
"SEC22g2-TIF35-NRg-2",
"SEC22g2-GPI15-TRg-1",
"SEC22g2-NOP1-NRg-5",
"SEC22g2-GPI15-TRg-4",
"SEC22g2-COG4-TRg-1",
"SEC22g2-TFA1-TRg-1",
"SEC22g2-RHO1-NRg-2",
"SEC22g2-RHO1-NRg-1",
"SEC22g2-CDC55-NRg-2",
"SEC22g2-IDI1-NRg-7",
"SEC22g2-RPL32-TRg-5",
"SEC22g2-RPB5-TRg-4",
"SEC22g2-DIP2-TRg-5",
"SEC22g2-DIP2-TRg-1",
"SEC22g2-RPC40-TRg-2",
"SEC22g2-CDC6-TRg-5",
"SEC22g2-CDC6-TRg-3",
"SEC22g2-DAD2-TRg-2",
"SEC22g2-RVS161-TRg-2",
"SEC22g2-RVS161-TRg-1",
"SEC22g2-SUP45-NRg-3",
"SEC22g2-SRB6-NRg-5",
"SEC22g2-RPC11-TRg-4",
"SEC22g2-RKI1-TRg-8",
"SEC22g2-NIP7-TRg-3",
"SEC22g2-RPL33A-NRg-12",
"SEC22g2-SAM50-TRg-4",
"SEC22g2-NOP4-NRg-1",
"SEC22g2-NOP4-NRg-3",
"SEC22g2-SMX2-TRg-5",
"SEC22g2-POL12-NRg-2",
"SEC22g2-BMS1-NRg-2",
"SEC22g2-RPA190-TRg-5",
"SEC22g2-ALG14-NRg-4",
"SEC22g2-ALG14-NRg-1",
"SEC22g2-PRE5-NRg-1",
"SEC22g2-BIG1-NRg-2",
"SEC22g2-TFA2-TRg-4",
"SEC22g2-IMP4-TRg-6",
"SEC22g2-PAN1-NRg-1",
"SEC22g2-UTP13-TRg-2",
"SEC22g2-KAE1-NRg-3",
"SEC22g2-ERG20-TRg-1",
"SEC22g2-CDC20-TRg-6",
"SEC22g2-PWP2-NRg-2",
"SEC22g2-COG1-NRg-1",
"SEC22g2-RPL1B-TRg-4",
"SEC22g2-RPL1B-TRg-7",
"SEC22g2-UTP20-TRg-3",
"SEC22g2-UTP20-TRg-4",
"SEC22g2-RPL25-TRg-4",
"SEC22g2-RPL25-TRg-2",
"SEC22g2-MCM7-NRg-1",
"SEC22g2-MRP49-TRg-5",
"SEC22g2-ERO1-NRg-3",
"SEC22g2-UTP5-TRg-7",
"SEC22g2-MCM4-NRg-1",
"SEC22g2-PRE3-NRg-1",
"SEC22g2-FCF1-NRg-1",
"SEC22g2-CUS1-NRg-1",
"SEC22g2-PSF1-TRg-2",
"SEC22g2-BCP1-TRg-2",
"SEC22g2-PAN1-TRg-1",
"SEC22g2-PAN1-TRg-3",
"SEC22g2-PAN1-TRg-4",
"SEC22g2-VPS3-TRg-2",
"SEC22g2-YIL060W-NRg-1",
"SEC22g2-VPS53-NRg-1",
"SEC22g2-CYR1-TRg-4",
"SEC22g2-CYR1-TRg-7",
"SEC22g2-MPS1-NRg-1",
"SEC22g2-SRP1-TRg-5",
"SEC22g2-SRP1-TRg-4",
"SEC22g2-TAF12-TRg-2",
"SEC22g2-TAF12-TRg-3",
"SEC22g2-POP4-TRg-1",
"SEC22g2-SPT16-TRg-1",
"SEC22g2-NUP82-TRg-4",
"SEC22g2-DML1-TRg-3",
"SEC22g2-RPA43-NRg-3",
"SEC22g2-STU2-NRg-3",
"SEC22g2-POP4-NRg-4",
"SEC22g2-MCD1-TRg-2",
"SEC22g2-RPS3-NRg-4",
"SEC22g2-PRP9-TRg-4",
"SEC22g2-RPP1-NRg-2",
"SEC22g2-MTR2-NRg-11",
"SEC22g2-GCD11-TRg-1",
"SEC22g2-RPF1-TRg-3",
"SEC22g2-SUB2-NRg-4",
"SEC22g2-GPI15-TRg-3",
"SEC22g2-ERG9-TRg-6",
"SEC22g2-RPT2-NRg-1",
"SEC22g2-YOS1-NRg-3",
"SEC22g2-SCM3-TRg-4",
"SEC22g2-SCM3-TRg-6",
"SEC22g2-RLP7-NRg-1",
"SEC22g2-TFB2-NRg-4",
"SEC22g2-IMP4-TRg-1",
"SEC22g2-IMP4-TRg-3",
"SEC22g2-PRE4-TRg-3",
"SEC22g2-SUB2-TRg-3",
"SEC22g2-RPP0-NRg-4",
"SEC22g2-RPP0-NRg-3",
"SEC22g2-TOM40-TRg-4",
"SEC22g2-FUR1-NRg-12",
"SEC22g2-TOM40-TRg-2",
"SEC22g2-VMA11-NRg-4",
"SEC22g2-PGS1-NRg-4",
"SEC22g2-URB1-TRg-4",
"SEC22g2-ARP4-TRg-3",
"SEC22g2-RPT3-TRg-3",
"SEC22g2-SUI3-TRg-3",
"SEC22g2-RFC5-NRg-2",
"SEC22g2-RRP14-TRg-2",
"SEC22g2-SCC2-TRg-1",
"SEC22g2-SSC1-TRg-3",
"SEC22g2-RRP9-TRg-3",
"SEC22g2-MOT1-NRg-9",
"SEC22g2-RPL42A-NRg-2",
"SEC22g2-SEC16-TRg-7",
"SEC22g2-IMP4-NRg-2",
"SEC22g2-YEF3-NRg-4",
"SEC22g2-PUP1-TRg-1",
"SEC22g2-UTP22-TRg-6",
"SEC22g2-DBP2-NRg-4",
"SEC22g2-PRE2-TRg-7",
"SEC22g2-ATP16-TRg-6",
"SEC22g2-UTP13-TRg-4",
"SEC22g2-DOP1-NRg-4",
"SEC22g2-TIM44-TRg-3",
"SEC22g2-ATP16-TRg-2",
"SEC22g2-ENP1-NRg-3",
"SEC22g2-NAF1-TRg-3",
"SEC22g2-COG4-TRg-2",
"SEC22g2-SOG2-TRg-7",
"SEC22g2-YDR341C-TRg-3",
"SEC22g2-YMR290W-A-TRg-10",
"SEC22g2-NUP192-NRg-9",
"SEC22g2-RPS31-NRg-8",
"SEC22g2-SPC97-NRg-6",
"SEC22g2-EBP2-NRg-1",
"SEC22g2-CDC48-TRg-5",
"SEC22g2-RPT1-TRg-4",
"SEC22g2-ULP1-NRg-2",
"SEC22g2-RPN3-TRg-6",
"SEC22g2-RPT1-TRg-5",
"SEC22g2-KRE5-TRg-2",
"SEC22g2-TBF1-NRg-8",
"SEC22g2-UTP22-NRg-4",
"SEC22g2-SSC1-NRg-4",
"SEC22g2-REB1-TRg-4",
"SEC22g2-CDC48-NRg-9",
"SEC22g2-FAS2-TRg-8",
"SEC22g2-TAO3-TRg-8",
"SEC22g2-CKS1-TRg-5",
"SEC22g2-YLR379W-TRg-7",
"SEC22g2-TEN1-NRg-2",
"SEC22g2-RPL42A-TRg-2",
"SEC22g2-SEC27-TRg-4",
"SEC22g2-TBF1-NRg-4",
"SEC22g2-RPT1-NRg-6",
"SEC22g2-COG1-TRg-3",
"SEC22g2-SUI1-TRg-6",
"SEC22g2-TIM23-TRg-6",
"SEC22g2-CDC48-NRg-6",
"SEC22g2-EPL1-TRg-5",
"SEC22g2-RPT5-TRg-8",
"SEC22g2-ATP16-NRg-4",
"SEC22g2-RPN6-TRg-3",
"SEC22g2-ERG9-NRg-6",
"SEC22g2-SMX3-TRg-1",
"SEC22g2-NCB2-NRg-3",
"SEC22g2-SEC16-NRg-12",
"SEC22g2-RPN6-TRg-2",
"SEC22g2-REB1-NRg-4",
"SEC22g2-ATP16-TRg-9",
"SEC22g2-ERG9-NRg-7",
"COG8g2-RPL15A-NRg-4",
"COG8g2-RPL15A-NRg-5",
"COG8g2-KRE33-TRg-1",
"COG8g2-PMI40-NRg-1",
"COG8g2-NOP19-NRg-3",
"COG8g2-SRP14-NRg-4",
"COG8g2-SEC27-TRg-2",
"COG8g2-GPI14-TRg-3",
"COG8g2-PAH1-TRg-7",
"COG8g2-PAH1-TRg-6",
"COG8g2-PAH1-TRg-5",
"COG8g2-PAH1-TRg-3",
"COG8g2-COG3-TRg-1",
"COG8g2-HTS1-NRg-5",
"COG8g2-MSN5-TRg-7",
"COG8g2-ERG26-TRg-1",
"COG8g2-SMD2-TRg-5",
"COG8g2-SMD2-TRg-4",
"COG8g2-SMD2-TRg-1",
"COG8g2-PRE7-TRg-4",
"COG8g2-PRE7-TRg-7",
"COG8g2-SEC6-TRg-3",
"COG8g2-ESF2-NRg-1",
"COG8g2-ESF2-NRg-3",
"COG8g2-AFG2-TRg-2",
"COG8g2-RRP36-TRg-3",
"COG8g2-RRP36-TRg-5",
"COG8g2-GCR1-NRg-2",
"COG8g2-PRE4-NRg-4",
"COG8g2-PRE4-NRg-9",
"COG8g2-DSN1-NRg-2",
"COG8g2-GPI11-TRg-3",
"COG8g2-POP3-TRg-1",
"COG8g2-MNE1-TRg-5",
"COG8g2-RRP12-NRg-1",
"COG8g2-RSC6-TRg-2",
"COG8g2-CDC25-TRg-1",
"COG8g2-CDC25-TRg-9",
"COG8g2-YPP1-NRg-3",
"COG8g2-NFS1-NRg-9",
"COG8g2-NFS1-NRg-8",
"COG8g2-UBA2-TRg-1",
"COG8g2-ARP2-NRg-3",
"COG8g2-MAK16-TRg-1",
"COG8g2-CEP3-NRg-1",
"COG8g2-GUK1-TRg-5",
"COG8g2-GUK1-TRg-2",
"COG8g2-GPI12-NRg-6",
"COG8g2-RPS5-NRg-5",
"COG8g2-RPS5-NRg-2",
"COG8g2-RPC19-NRg-1",
"COG8g2-TIM54-TRg-1",
"COG8g2-TEN1-TRg-2",
"COG8g2-SAH1-NRg-4",
"COG8g2-SAH1-NRg-5",
"COG8g2-SAH1-NRg-3",
"COG8g2-ATP15-NRg-5",
"COG8g2-SCD5-TRg-5",
"COG8g2-ARB1-NRg-2",
"COG8g2-ARB1-NRg-4",
"COG8g2-PUP2-TRg-1",
"COG8g2-CCT8-TRg-2",
"COG8g2-MCM4-TRg-1",
"COG8g2-LSM4-TRg-1",
"COG8g2-NOP53-NRg-1",
"COG8g2-ATP3-TRg-4",
"COG8g2-AFG2-NRg-3",
"COG8g2-PRO3-NRg-3",
"COG8g2-NRD1-NRg-10",
"COG8g2-SEC61-TRg-2",
"COG8g2-RHO3-TRg-4",
"COG8g2-SNF2-TRg-6",
"COG8g2-SMD2-NRg-3",
"COG8g2-RSC4-TRg-2",
"COG8g2-RSC4-TRg-1",
"COG8g2-TIF34-TRg-2",
"COG8g2-BET1-NRg-1",
"COG8g2-CDC8-NRg-2",
"COG8g2-PRP42-TRg-2",
"COG8g2-RRB1-TRg-2",
"COG8g2-SPC24-TRg-1",
"COG8g2-ILS1-NRg-1",
"COG8g2-GFA1-TRg-2",
"COG8g2-SEC21-NRg-10",
"COG8g2-RPC10-NRg-1",
"COG8g2-RPB10-TRg-3",
"COG8g2-RPB10-TRg-2",
"COG8g2-YNL181W-TRg-1",
"COG8g2-RAD3-NRg-1",
"COG8g2-NOP10-TRg-1",
"COG8g2-BFR2-TRg-3",
"COG8g2-MCM2-TRg-6",
"COG8g2-MCM2-TRg-4",
"COG8g2-MPP10-TRg-1",
"COG8g2-RET2-TRg-4",
"COG8g2-RET2-TRg-1",
"COG8g2-RPS2-NRg-1",
"COG8g2-RPS2-NRg-2",
"COG8g2-ORC4-NRg-3",
"COG8g2-TIP20-TRg-7",
"COG8g2-SMT3-TRg-1",
"COG8g2-MSS18-NRg-6",
"COG8g2-YEF3-NRg-9",
"COG8g2-ASK1-NRg-1",
"COG8g2-SMC1-TRg-1",
"COG8g2-NIP1-NRg-1",
"COG8g2-RPP1-NRg-1",
"COG8g2-YDJ1-TRg-6",
"COG8g2-SUB2-NRg-1",
"COG8g2-TIM10-NRg-8",
"COG8g2-TIM10-NRg-4",
"COG8g2-TIM10-NRg-7",
"COG8g2-SKI6-TRg-4",
"COG8g2-TUB4-TRg-1",
"COG8g2-CDC37-NRg-2",
"COG8g2-ISD11-TRg-3",
"COG8g2-YOS1-TRg-4",
"COG8g2-SSC1-TRg-6",
"COG8g2-MTR3-TRg-5",
"COG8g2-MTR3-TRg-6",
"COG8g2-TFA1-TRg-2",
"COG8g2-CDC3-NRg-3",
"COG8g2-ERG25-TA-18",
"COG8g2-RPB11-TRg-4",
"COG8g2-RPB11-TRg-1",
"COG8g2-RPB11-TRg-2",
"COG8g2-DED1-TRg-3",
"COG8g2-DED1-TRg-1",
"COG8g2-DED1-TRg-6",
"COG8g2-DED1-TRg-4",
"COG8g2-RPL10-NRg-5",
"COG8g2-RPL10-NRg-4",
"COG8g2-EFB1-NRg-1",
"COG8g2-EFB1-NRg-5",
"COG8g2-EFB1-NRg-4",
"COG8g2-RPT3-NRg-1",
"COG8g2-SAC6-TRg-8",
"COG8g2-SAC6-TRg-4",
"COG8g2-SAC6-TRg-5",
"COG8g2-SAC6-TRg-3",
"COG8g2-DIM1-TRg-5",
"COG8g2-DIM1-TRg-7",
"COG8g2-RPC17-NRg-1",
"COG8g2-RPC17-NRg-2",
"COG8g2-YDR341C-TRg-1",
"COG8g2-RAP1-NRg-8",
"COG8g2-RAP1-NRg-5",
"COG8g2-RAP1-NRg-2",
"COG8g2-SEC26-NRg-3",
"COG8g2-SPP41-TRg-3",
"COG8g2-TAP42-NRg-1",
"COG8g2-PGA2-TRg-6",
"COG8g2-BRL1-TRg-1",
"COG8g2-FOL2-TRg-1",
"COG8g2-NAB3-NRg-5",
"COG8g2-SNF4-TRg-4",
"COG8g2-HRR25-TRg-2",
"COG8g2-TRS23-TRg-4",
"COG8g2-CTR86-TRg-4",
"COG8g2-RPB5-TRg-5",
"COG8g2-SPN1-NRg-2",
"COG8g2-SPN1-NRg-1",
"COG8g2-SEC61-NRg-1",
"COG8g2-SEC61-NRg-7",
"COG8g2-TUS1-TRg-3",
"COG8g2-OLE1-NRg-2",
"COG8g2-AFG2-TRg-1",
"COG8g2-TOA2-NRg-1",
"COG8g2-USO1-TRg-1",
"COG8g2-UTP22-NRg-2",
"COG8g2-RIB1-TRg-3",
"COG8g2-RIB1-TRg-7",
"COG8g2-RIB1-TRg-4",
"COG8g2-COG1-TRg-1",
"COG8g2-RPL32-NRg-2",
"COG8g2-GLC7-NRg-3",
"COG8g2-GLC7-NRg-4",
"COG8g2-HSF1-TRg-2",
"COG8g2-DAM1-NRg-5",
"COG8g2-SEC18-TRg-4",
"COG8g2-SEC18-TRg-5",
"COG8g2-PAB1-NRg-3",
"COG8g2-POP8-TRg-2",
"COG8g2-PAB1-NRg-4",
"COG8g2-BIG1-TRg-4",
"COG8g2-BIG1-TRg-5",
"COG8g2-BIG1-TRg-6",
"COG8g2-RPO41-NRg-1",
"COG8g2-RVB2-NRg-2",
"COG8g2-PET117-NRg-8",
"COG8g2-VPS45-NRg-9",
"COG8g2-YCG1-NRg-1",
"COG8g2-NOC4-NRg-1",
"COG8g2-NMD3-NRg-2",
"COG8g2-DRS1-TRg-2",
"COG8g2-HTB1-NRg-2",
"COG8g2-IPI1-TRg-2",
"COG8g2-SEC18-NRg-1",
"COG8g2-SEC18-NRg-2",
"COG8g2-JIP5-NRg-2",
"COG8g2-YPT1-TRg-3",
"COG8g2-YPT1-TRg-2",
"COG8g2-CLF1-NRg-2",
"COG8g2-SNF2-NRg-7",
"COG8g2-SNF2-NRg-4",
"COG8g2-RPL25-NRg-1",
"COG8g2-NOP56-TRg-1",
"COG8g2-NOP56-TRg-2",
"COG8g2-TRS31-TRg-1",
"COG8g2-DBF4-TRg-2",
"COG8g2-DBF4-TRg-1",
"COG8g2-RPC19-TRg-4",
"COG8g2-RPC19-TRg-6",
"COG8g2-RPC19-TRg-3",
"COG8g2-ROK1-NRg-1",
"COG8g2-CDC33-TRg-4",
"COG8g2-DHR2-TRg-3",
"COG8g2-RRP42-NRg-5",
"COG8g2-CLF1-TRg-1",
"COG8g2-ERG11-NA-16",
"COG8g2-VAS1-NRg-4",
"COG8g2-PIK1-NRg-2",
"COG8g2-SAR1-NRg-7",
"COG8g2-SAR1-NRg-4",
"COG8g2-RPS3-TRg-1",
"COG8g2-YTM1-TRg-2",
"COG8g2-SUI3-NRg-5",
"COG8g2-SUI3-NRg-2",
"COG8g2-RRP7-TRg-4",
"COG8g2-RRP7-TRg-6",
"COG8g2-NIP7-TRg-2",
"COG8g2-MDM35-TRg-1",
"COG8g2-ALA1-NRg-1",
"COG8g2-DOA4-NRg-2",
"COG8g2-RPS13-NRg-1",
"COG8g2-YSF3-TRg-2",
"COG8g2-RPS2-NRg-11",
"COG8g2-SSL1-TRg-10",
"COG8g2-NIP7-TRg-1",
"COG8g2-LST8-NRg-1",
"COG8g2-TAF4-TRg-3",
"COG8g2-HAS1-TRg-2",
"COG8g2-GLC7-TRg-2",
"COG8g2-CDC45-NRg-1",
"COG8g2-SEC22-NRg-8",
"COG8g2-YOS1-TRg-2",
"COG8g2-RBA50-TRg-3",
"COG8g2-SPP41-NRg-2",
"COG8g2-PRP46-TRg-2",
"COG8g2-PGA2-NRg-1",
"COG8g2-CBF5-TRg-3",
"COG8g2-TCP1-NRg-3",
"COG8g2-TCP1-NRg-2",
"COG8g2-ERG26-NRg-2",
"COG8g2-ERG26-NRg-4",
"COG8g2-MES1-TRg-5",
"COG8g2-HTS1-TRg-2",
"COG8g2-SSS1-TRg-3",
"COG8g2-SSS1-TRg-2",
"COG8g2-SYS1-TRg-7",
"COG8g2-SYS1-TRg-2",
"COG8g2-SYS1-TRg-1",
"COG8g2-BFR2-TRg-1",
"COG8g2-EOS1-TRg-3",
"COG8g2-TAF4-NRg-1",
"COG8g2-ARL3-NRg-8",
"COG8g2-RPN5-NRg-1",
"COG8g2-TIM9-NRg-2",
"COG8g2-NUP57-NRg-3",
"COG8g2-VPS4-TRg-1",
"COG8g2-CDC3-TRg-4",
"COG8g2-BBP1-NRg-1",
"COG8g2-BBP1-NRg-2",
"COG8g2-USE1-NRg-3",
"COG8g2-CCT7-TRg-1",
"COG8g2-SAH1-TRg-3",
"COG8g2-CHS2-TRg-1",
"COG8g2-DPM1-TRg-2",
"COG8g2-BBP1-TRg-1",
"COG8g2-NRD1-TRg-4",
"COG8g2-RPB3-NRg-1",
"COG8g2-PHO85-NRg-6",
"COG8g2-SNF6-TRg-6",
"COG8g2-PRP38-NRg-2",
"COG8g2-OAR1-NRg-3",
"COG8g2-ROX3-NRg-1",
"COG8g2-YPP1-TRg-6",
"COG8g2-CBF2-NRg-8",
"COG8g2-SPT6-TRg-5",
"COG8g2-SEC10-NRg-1",
"COG8g2-NSL1-NRg-3",
"COG8g2-NRD1-NRg-8",
"COG8g2-RPB3-TRg-1",
"COG8g2-NRD1-NRg-4",
"COG8g2-RVB1-TRg-2",
"COG8g2-TIF5-NRg-8",
"COG8g2-EOS1-NRg-1",
"COG8g2-ERG25-NA-26",
"COG8g2-MSL5-NRg-4",
"COG8g2-SEC24-TRg-2",
"COG8g2-RPL30-NRg-5",
"COG8g2-SNU71-NRg-3",
"COG8g2-CDC33-NRg-1",
"COG8g2-RPN6-TRg-4",
"COG8g2-NAB2-TRg-4",
"COG8g2-NAB2-TRg-6",
"COG8g2-YTM1-NRg-1",
"COG8g2-OLE1-TRg-8",
"COG8g2-OLE1-TRg-1",
"COG8g2-UTP7-TRg-4",
"COG8g2-ACT1-NRg-6",
"COG8g2-RPL18A-NRg-3",
"COG8g2-BRX1-NRg-1",
"COG8g2-NAF1-TRg-8",
"COG8g2-NAF1-TRg-6",
"COG8g2-NAF1-TRg-4",
"COG8g2-CDC8-TRg-2",
"COG8g2-NSE4-TRg-1",
"COG8g2-PAB1-NRg-2",
"COG8g2-PRP43-TRg-4",
"COG8g2-SEC2-NRg-3",
"COG8g2-SEC2-NRg-6",
"COG8g2-MPP10-NRg-5",
"COG8g2-YDR355C-TRg-2",
"COG8g2-YLR339C-TRg-9",
"COG8g2-SNM1-TRg-2",
"COG8g2-ALR1-NRg-4",
"COG8g2-ALR1-NRg-1",
"COG8g2-ALR1-NRg-3",
"COG8g2-RPL10-TRg-1",
"COG8g2-RPL28-TRg-2",
"COG8g2-UTP25-TRg-1",
"COG8g2-POB3-TRg-1",
"COG8g2-POB3-TRg-3",
"COG8g2-POB3-TRg-2",
"COG8g2-MED11-TRg-1",
"COG8g2-ISA1-TRg-15",
"COG8g2-RRP1-NRg-1",
"COG8g2-MES1-NRg-1",
"COG8g2-SEC13-NRg-5",
"COG8g2-MCM2-NRg-2",
"COG8g2-ALA1-TRg-4",
"COG8g2-MTG2-TRg-5",
"COG8g2-TIF35-NRg-3",
"COG8g2-NSE1-TRg-3",
"COG8g2-NSE1-TRg-4",
"COG8g2-MOB2-NRg-6",
"COG8g2-VRG4-NRg-3",
"COG8g2-PRP9-TRg-3",
"COG8g2-HYM1-TRg-5",
"COG8g2-POP1-TRg-5",
"COG8g2-POP1-TRg-9",
"COG8g2-RPL17A-TRg-1",
"COG8g2-SLD2-TRg-1",
"COG8g2-CDC48-NRg-7",
"COG8g2-FHL1-NRg-2",
"COG8g2-BET3-NRg-7",
"COG8g2-MAK21-TRg-1",
"COG8g2-BRN1-TRg-4",
"COG8g2-FBA1-NRg-3",
"COG8g2-CDC42-TRg-6",
"COG8g2-CDC42-TRg-7",
"COG8g2-COG4-NRg-1",
"COG8g2-ATP3-NRg-3",
"COG8g2-ATP3-NRg-2",
"COG8g2-SMP3-TRg-5",
"COG8g2-CFT2-NRg-2",
"COG8g2-FAS2-TRg-5",
"COG8g2-DBP2-NRg-3",
"COG8g2-DBP2-NRg-2",
"COG8g2-MPS2-NRg-4",
"COG8g2-ARC35-TRg-2",
"COG8g2-ARC35-TRg-5",
"COG8g2-MRD1-TRg-1",
"COG8g2-RLP7-TRg-1",
"COG8g2-SPC34-TRg-1",
"COG8g2-CDC45-TRg-2",
"COG8g2-GCD6-TRg-3",
"COG8g2-GCD6-TRg-4",
"COG8g2-YPT6-NRg-2",
"COG8g2-RPS13-TRg-2",
"COG8g2-IPI3-TRg-3",
"COG8g2-TIF5-NRg-9",
"COG8g2-TIF5-NRg-7",
"COG8g2-TIF5-NRg-6",
"COG8g2-NAB3-TRg-3",
"COG8g2-GCD2-TRg-1",
"COG8g2-UBA1-TRg-2",
"COG8g2-SLD3-TRg-6",
"COG8g2-LCB1-TRg-5",
"COG8g2-TOA2-TRg-6",
"COG8g2-TOA2-TRg-1",
"COG8g2-TOA2-TRg-3",
"COG8g2-LSM2-TRg-1",
"COG8g2-YML6-TRg-13",
"COG8g2-YML6-TRg-12",
"COG8g2-UTP15-NRg-1",
"COG8g2-TIF6-NRg-8",
"COG8g2-SUP35-NRg-1",
"COG8g2-MPP10-NRg-1",
"COG8g2-SWI3-TRg-7",
"COG8g2-SSN3-NRg-2",
"COG8g2-SEC13-NRg-7",
"COG8g2-RPS15-NRg-3",
"COG8g2-RPL3-TRg-2",
"COG8g2-FBA1-NRg-2",
"COG8g2-FBA1-NRg-1",
"COG8g2-FBA1-NRg-5",
"COG8g2-DAM1-TRg-2",
"COG8g2-NHP2-TRg-2",
"COG8g2-HCA4-NRg-6",
"COG8g2-PRE3-TRg-4",
"COG8g2-DBP5-NRg-4",
"COG8g2-SPT6-NRg-4",
"COG8g2-SPT6-NRg-2",
"COG8g2-RPL18A-TRg-4",
"COG8g2-KSH1-TRg-1",
"COG8g2-KSH1-TRg-3",
"COG8g2-IPI3-NRg-1",
"COG8g2-PGA2-TRg-8",
"COG8g2-RPL18A-TRg-2",
"COG8g2-RPL33A-NRg-6",
"COG8g2-TAF12-NRg-2",
"COG8g2-USE1-TRg-5",
"COG8g2-YNL114C-TRg-1",
"COG8g2-SMC5-TRg-7",
"COG8g2-SMC5-TRg-6",
"COG8g2-RSC58-TRg-1",
"COG8g2-CTF13-TRg-2",
"COG8g2-NAB2-NRg-2",
"COG8g2-MCM7-TRg-4",
"COG8g2-BCP1-NRg-5",
"COG8g2-STU2-TRg-3",
"COG8g2-SEC21-NRg-6",
"COG8g2-SEC21-NRg-3",
"COG8g2-RPL1B-TRg-3",
"COG8g2-SEC20-NRg-2",
"COG8g2-VMA3-NRg-2",
"COG8g2-SEC23-NRg-5",
"COG8g2-CDC28-TRg-4",
"COG8g2-RPN12-NRg-11",
"COG8g2-PUP3-TRg-3",
"COG8g2-SEC31-TRg-2",
"COG8g2-SED5-TRg-6",
"COG8g2-SED5-TRg-5",
"COG8g2-RPL33A-TRg-1",
"COG8g2-RPL33A-TRg-2",
"COG8g2-MRPL11-TRg-2",
"COG8g2-RTP1-NRg-2",
"COG8g2-NUG1-TRg-2",
"COG8g2-VPH2-TRg-4",
"COG8g2-COP1-NRg-3",
"COG8g2-CRM1-NRg-1",
"COG8g2-RPL5-NRg-4",
"COG8g2-SNU13-NRg-4",
"COG8g2-PFS2-TRg-3",
"COG8g2-MPP10-TRg-2",
"COG8g2-TSR4-NRg-2",
"COG8g2-RSC2-TRg-1",
"COG8g2-SEC65-TRg-2",
"COG8g2-SMI1-NRg-1",
"COG8g2-RTT105-NRg-4",
"COG8g2-VMA5-TRg-3",
"COG8g2-VMA5-TRg-5",
"COG8g2-RRP1-TRg-3",
"COG8g2-CLC1-TRg-2",
"COG8g2-GCD6-NRg-1",
"COG8g2-GCD6-NRg-2",
"COG8g2-PXR1-TRg-1",
"COG8g2-CDC14-NRg-1",
"COG8g2-PCF11-TRg-6",
"COG8g2-PCF11-TRg-5",
"COG8g2-PCF11-TRg-4",
"COG8g2-SEC31-NRg-1",
"COG8g2-RRP5-NRg-1",
"COG8g2-PRE10-TRg-5",
"COG8g2-PRE10-TRg-1",
"COG8g2-RPS5-TRg-2",
"COG8g2-NSP1-TRg-4",
"COG8g2-PRP38-TRg-4",
"COG8g2-RCF1-NRg-5",
"COG8g2-RSC3-TRg-4",
"COG8g2-RSC3-TRg-5",
"COG8g2-RSC3-TRg-6",
"COG8g2-HTA1-NRg-12",
"COG8g2-HTA1-NRg-11",
"COG8g2-UTP23-TRg-2",
"COG8g2-GCD7-NRg-1",
"COG8g2-GCD7-NRg-2",
"COG8g2-GCD7-NRg-6",
"COG8g2-GAL11-NRg-2",
"COG8g2-GAL11-NRg-9",
"COG8g2-PHO4-TRg-5",
"COG8g2-SNP1-NRg-3",
"COG8g2-RPC37-TRg-5",
"COG8g2-CRM1-TRg-5",
"COG8g2-CRM1-TRg-2",
"COG8g2-ASK1-TRg-7",
"COG8g2-STU2-NRg-4",
"COG8g2-NEO1-NRg-3",
"COG8g2-GAL11-TRg-5",
"COG8g2-GAL11-TRg-7",
"COG8g2-SAM50-NRg-3",
"COG8g2-CSL4-TRg-2",
"COG8g2-CCT5-TRg-2",
"COG8g2-POL30-NRg-1",
"COG8g2-MED4-TRg-4",
"COG8g2-MED4-TRg-3",
"COG8g2-MED4-TRg-2",
"COG8g2-GDI1-TRg-4",
"COG8g2-GDI1-TRg-3",
"COG8g2-REB1-TRg-6",
"COG8g2-MRPL37-NRg-2",
"COG8g2-NOC3-TRg-3",
"COG8g2-SPC97-TRg-3",
"COG8g2-IPP1-TRg-3",
"COG8g2-IPP1-TRg-2",
"COG8g2-PTI1-TRg-3",
"COG8g2-PTI1-TRg-5",
"COG8g2-RFC5-NRg-1",
"COG8g2-CDC24-TRg-1",
"COG8g2-CDC24-TRg-3",
"COG8g2-CDC24-TRg-5",
"COG8g2-CDC24-TRg-6",
"COG8g2-UTP23-TRg-6",
"COG8g2-UTP23-TRg-4",
"COG8g2-UTP23-TRg-1",
"COG8g2-RHO3-NRg-4",
"COG8g2-TRS23-NRg-1",
"COG8g2-TRS23-NRg-3",
"COG8g2-RSP5-TRg-2",
"COG8g2-RSP5-TRg-1",
"COG8g2-SDA1-NRg-1",
"COG8g2-KAP95-TRg-8",
"COG8g2-ACO1-TRg-6",
"COG8g2-HTA1-NRg-3",
"COG8g2-HTA1-NRg-2",
"COG8g2-SPN1-TRg-1",
"COG8g2-MOT1-NRg-7",
"COG8g2-RPL17A-NRg-4",
"COG8g2-ADA2-TRg-4",
"COG8g2-SFH1-NRg-1",
"COG8g2-SPC97-NRg-5",
"COG8g2-PRP22-TRg-3",
"COG8g2-SEN15-TRg-2",
"COG8g2-RPL3-NRg-2",
"COG8g2-ISD11-NRg-2",
"COG8g2-HEM12-TRg-8",
"COG8g2-SEC10-TRg-1",
"COG8g2-HTB1-TRg-7",
"COG8g2-TTI2-TRg-1",
"COG8g2-ACP1-TRg-2",
"COG8g2-ACP1-TRg-4",
"COG8g2-GAL11-NRg-10",
"COG8g2-UTP22-TRg-2",
"COG8g2-MST1-NRg-5",
"COG8g2-RIB7-NRg-2",
"COG8g2-MCD1-TRg-6",
"COG8g2-MCD1-TRg-5",
"COG8g2-GPI8-NRg-2",
"COG8g2-THS1-TRg-2",
"COG8g2-RRP7-TRg-2",
"COG8g2-RRP7-TRg-5",
"COG8g2-SMX2-NRg-7",
"COG8g2-RRP45-TRg-5",
"COG8g2-RRP45-TRg-4",
"COG8g2-CNS1-TRg-2",
"COG8g2-FBP1-NRg-9",
"COG8g2-GCD11-NRg-1",
"COG8g2-RPL10-TRg-2",
"COG8g2-NUP192-TRg-4",
"COG8g2-NUP145-NRg-4",
"COG8g2-HEM12-TRg-6",
"COG8g2-PLC1-TRg-3",
"COG8g2-RPA43-TRg-1",
"COG8g2-RPB7-NRg-2",
"COG8g2-RPB7-NRg-3",
"COG8g2-NSL1-NRg-1",
"COG8g2-UTP6-TRg-3",
"COG8g2-UTP6-TRg-1",
"COG8g2-YJU2-TRg-5",
"COG8g2-FRS2-NRg-5",
"COG8g2-TIF35-NRg-2",
"COG8g2-GPI15-TRg-1",
"COG8g2-NOP1-NRg-5",
"COG8g2-GPI15-TRg-4",
"COG8g2-COG4-TRg-1",
"COG8g2-TFA1-TRg-1",
"COG8g2-RHO1-NRg-2",
"COG8g2-RHO1-NRg-1",
"COG8g2-CDC55-NRg-2",
"COG8g2-IDI1-NRg-7",
"COG8g2-RPL32-TRg-5",
"COG8g2-RPB5-TRg-4",
"COG8g2-DIP2-TRg-5",
"COG8g2-DIP2-TRg-1",
"COG8g2-RPC40-TRg-2",
"COG8g2-CDC6-TRg-5",
"COG8g2-CDC6-TRg-3",
"COG8g2-DAD2-TRg-2",
"COG8g2-RVS161-TRg-2",
"COG8g2-RVS161-TRg-1",
"COG8g2-SUP45-NRg-3",
"COG8g2-SRB6-NRg-5",
"COG8g2-RPC11-TRg-4",
"COG8g2-RKI1-TRg-8",
"COG8g2-NIP7-TRg-3",
"COG8g2-RPL33A-NRg-12",
"COG8g2-SAM50-TRg-4",
"COG8g2-NOP4-NRg-1",
"COG8g2-NOP4-NRg-3",
"COG8g2-SMX2-TRg-5",
"COG8g2-POL12-NRg-2",
"COG8g2-BMS1-NRg-2",
"COG8g2-RPA190-TRg-5",
"COG8g2-ALG14-NRg-4",
"COG8g2-ALG14-NRg-1",
"COG8g2-PRE5-NRg-1",
"COG8g2-BIG1-NRg-2",
"COG8g2-TFA2-TRg-4",
"COG8g2-IMP4-TRg-6",
"COG8g2-PAN1-NRg-1",
"COG8g2-UTP13-TRg-2",
"COG8g2-KAE1-NRg-3",
"COG8g2-ERG20-TRg-1",
"COG8g2-CDC20-TRg-6",
"COG8g2-PWP2-NRg-2",
"COG8g2-COG1-NRg-1",
"COG8g2-RPL1B-TRg-4",
"COG8g2-RPL1B-TRg-7",
"COG8g2-UTP20-TRg-3",
"COG8g2-UTP20-TRg-4",
"COG8g2-RPL25-TRg-4",
"COG8g2-RPL25-TRg-2",
"COG8g2-MCM7-NRg-1",
"COG8g2-MRP49-TRg-5",
"COG8g2-ERO1-NRg-3",
"COG8g2-UTP5-TRg-7",
"COG8g2-MCM4-NRg-1",
"COG8g2-PRE3-NRg-1",
"COG8g2-FCF1-NRg-1",
"COG8g2-CUS1-NRg-1",
"COG8g2-PSF1-TRg-2",
"COG8g2-BCP1-TRg-2",
"COG8g2-PAN1-TRg-1",
"COG8g2-PAN1-TRg-3",
"COG8g2-PAN1-TRg-4",
"COG8g2-VPS3-TRg-2",
"COG8g2-YIL060W-NRg-1",
"COG8g2-VPS53-NRg-1",
"COG8g2-CYR1-TRg-4",
"COG8g2-CYR1-TRg-7",
"COG8g2-MPS1-NRg-1",
"COG8g2-SRP1-TRg-5",
"COG8g2-SRP1-TRg-4",
"COG8g2-TAF12-TRg-2",
"COG8g2-TAF12-TRg-3",
"COG8g2-POP4-TRg-1",
"COG8g2-SPT16-TRg-1",
"COG8g2-NUP82-TRg-4",
"COG8g2-DML1-TRg-3",
"COG8g2-RPA43-NRg-3",
"COG8g2-STU2-NRg-3",
"COG8g2-POP4-NRg-4",
"COG8g2-MCD1-TRg-2",
"COG8g2-RPS3-NRg-4",
"COG8g2-PRP9-TRg-4",
"COG8g2-RPP1-NRg-2",
"COG8g2-MTR2-NRg-11",
"COG8g2-GCD11-TRg-1",
"COG8g2-RPF1-TRg-3",
"COG8g2-SUB2-NRg-4",
"COG8g2-GPI15-TRg-3",
"COG8g2-ERG9-TRg-6",
"COG8g2-RPT2-NRg-1",
"COG8g2-YOS1-NRg-3",
"COG8g2-SCM3-TRg-4",
"COG8g2-SCM3-TRg-6",
"COG8g2-RLP7-NRg-1",
"COG8g2-TFB2-NRg-4",
"COG8g2-IMP4-TRg-1",
"COG8g2-IMP4-TRg-3",
"COG8g2-PRE4-TRg-3",
"COG8g2-SUB2-TRg-3",
"COG8g2-RPP0-NRg-4",
"COG8g2-RPP0-NRg-3",
"COG8g2-TOM40-TRg-4",
"COG8g2-FUR1-NRg-12",
"COG8g2-TOM40-TRg-2",
"COG8g2-VMA11-NRg-4",
"COG8g2-PGS1-NRg-4",
"COG8g2-URB1-TRg-4",
"COG8g2-ARP4-TRg-3",
"COG8g2-RPT3-TRg-3",
"COG8g2-SUI3-TRg-3",
"COG8g2-RFC5-NRg-2",
"COG8g2-RRP14-TRg-2",
"COG8g2-SCC2-TRg-1",
"COG8g2-SSC1-TRg-3",
"COG8g2-RRP9-TRg-3",
"COG8g2-MOT1-NRg-9",
"COG8g2-RPL42A-NRg-2",
"COG8g2-SEC16-TRg-7",
"COG8g2-IMP4-NRg-2",
"COG8g2-YEF3-NRg-4",
"COG8g2-PUP1-TRg-1",
"COG8g2-UTP22-TRg-6",
"COG8g2-DBP2-NRg-4",
"COG8g2-PRE2-TRg-7",
"COG8g2-ATP16-TRg-6",
"COG8g2-UTP13-TRg-4",
"COG8g2-DOP1-NRg-4",
"COG8g2-TIM44-TRg-3",
"COG8g2-ATP16-TRg-2",
"COG8g2-ENP1-NRg-3",
"COG8g2-NAF1-TRg-3",
"COG8g2-COG4-TRg-2",
"COG8g2-SOG2-TRg-7",
"COG8g2-YDR341C-TRg-3",
"COG8g2-YMR290W-A-TRg-10",
"COG8g2-NUP192-NRg-9",
"COG8g2-RPS31-NRg-8",
"COG8g2-SPC97-NRg-6",
"COG8g2-EBP2-NRg-1",
"COG8g2-CDC48-TRg-5",
"COG8g2-RPT1-TRg-4",
"COG8g2-ULP1-NRg-2",
"COG8g2-RPN3-TRg-6",
"COG8g2-RPT1-TRg-5",
"COG8g2-KRE5-TRg-2",
"COG8g2-TBF1-NRg-8",
"COG8g2-UTP22-NRg-4",
"COG8g2-SSC1-NRg-4",
"COG8g2-REB1-TRg-4",
"COG8g2-CDC48-NRg-9",
"COG8g2-FAS2-TRg-8",
"COG8g2-TAO3-TRg-8",
"COG8g2-CKS1-TRg-5",
"COG8g2-YLR379W-TRg-7",
"COG8g2-TEN1-NRg-2",
"COG8g2-RPL42A-TRg-2",
"COG8g2-SEC27-TRg-4",
"COG8g2-TBF1-NRg-4",
"COG8g2-RPT1-NRg-6",
"COG8g2-COG1-TRg-3",
"COG8g2-SUI1-TRg-6",
"COG8g2-TIM23-TRg-6",
"COG8g2-CDC48-NRg-6",
"COG8g2-EPL1-TRg-5",
"COG8g2-RPT5-TRg-8",
"COG8g2-ATP16-NRg-4",
"COG8g2-RPN6-TRg-3",
"COG8g2-ERG9-NRg-6",
"COG8g2-SMX3-TRg-1",
"COG8g2-NCB2-NRg-3",
"COG8g2-SEC16-NRg-12",
"COG8g2-RPN6-TRg-2",
"COG8g2-REB1-NRg-4",
"COG8g2-ATP16-TRg-9",
"COG8g2-ERG9-NRg-7",
"GET2g2-RPL15A-NRg-4",
"GET2g2-RPL15A-NRg-5",
"GET2g2-KRE33-TRg-1",
"GET2g2-PMI40-NRg-1",
"GET2g2-NOP19-NRg-3",
"GET2g2-SRP14-NRg-4",
"GET2g2-SEC27-TRg-2",
"GET2g2-GPI14-TRg-3",
"GET2g2-PAH1-TRg-7",
"GET2g2-PAH1-TRg-6",
"GET2g2-PAH1-TRg-5",
"GET2g2-PAH1-TRg-3",
"GET2g2-COG3-TRg-1",
"GET2g2-HTS1-NRg-5",
"GET2g2-MSN5-TRg-7",
"GET2g2-ERG26-TRg-1",
"GET2g2-SMD2-TRg-5",
"GET2g2-SMD2-TRg-4",
"GET2g2-SMD2-TRg-1",
"GET2g2-PRE7-TRg-4",
"GET2g2-PRE7-TRg-7",
"GET2g2-SEC6-TRg-3",
"GET2g2-ESF2-NRg-1",
"GET2g2-ESF2-NRg-3",
"GET2g2-AFG2-TRg-2",
"GET2g2-RRP36-TRg-3",
"GET2g2-RRP36-TRg-5",
"GET2g2-GCR1-NRg-2",
"GET2g2-PRE4-NRg-4",
"GET2g2-PRE4-NRg-9",
"GET2g2-DSN1-NRg-2",
"GET2g2-GPI11-TRg-3",
"GET2g2-POP3-TRg-1",
"GET2g2-MNE1-TRg-5",
"GET2g2-RRP12-NRg-1",
"GET2g2-RSC6-TRg-2",
"GET2g2-CDC25-TRg-1",
"GET2g2-CDC25-TRg-9",
"GET2g2-YPP1-NRg-3",
"GET2g2-NFS1-NRg-9",
"GET2g2-NFS1-NRg-8",
"GET2g2-UBA2-TRg-1",
"GET2g2-ARP2-NRg-3",
"GET2g2-MAK16-TRg-1",
"GET2g2-CEP3-NRg-1",
"GET2g2-GUK1-TRg-5",
"GET2g2-GUK1-TRg-2",
"GET2g2-GPI12-NRg-6",
"GET2g2-RPS5-NRg-5",
"GET2g2-RPS5-NRg-2",
"GET2g2-RPC19-NRg-1",
"GET2g2-TIM54-TRg-1",
"GET2g2-TEN1-TRg-2",
"GET2g2-SAH1-NRg-4",
"GET2g2-SAH1-NRg-5",
"GET2g2-SAH1-NRg-3",
"GET2g2-ATP15-NRg-5",
"GET2g2-SCD5-TRg-5",
"GET2g2-ARB1-NRg-2",
"GET2g2-ARB1-NRg-4",
"GET2g2-PUP2-TRg-1",
"GET2g2-CCT8-TRg-2",
"GET2g2-MCM4-TRg-1",
"GET2g2-LSM4-TRg-1",
"GET2g2-NOP53-NRg-1",
"GET2g2-ATP3-TRg-4",
"GET2g2-AFG2-NRg-3",
"GET2g2-PRO3-NRg-3",
"GET2g2-NRD1-NRg-10",
"GET2g2-SEC61-TRg-2",
"GET2g2-RHO3-TRg-4",
"GET2g2-SNF2-TRg-6",
"GET2g2-SMD2-NRg-3",
"GET2g2-RSC4-TRg-2",
"GET2g2-RSC4-TRg-1",
"GET2g2-TIF34-TRg-2",
"GET2g2-BET1-NRg-1",
"GET2g2-CDC8-NRg-2",
"GET2g2-PRP42-TRg-2",
"GET2g2-RRB1-TRg-2",
"GET2g2-SPC24-TRg-1",
"GET2g2-ILS1-NRg-1",
"GET2g2-GFA1-TRg-2",
"GET2g2-SEC21-NRg-10",
"GET2g2-RPC10-NRg-1",
"GET2g2-RPB10-TRg-3",
"GET2g2-RPB10-TRg-2",
"GET2g2-YNL181W-TRg-1",
"GET2g2-RAD3-NRg-1",
"GET2g2-NOP10-TRg-1",
"GET2g2-BFR2-TRg-3",
"GET2g2-MCM2-TRg-6",
"GET2g2-MCM2-TRg-4",
"GET2g2-MPP10-TRg-1",
"GET2g2-RET2-TRg-4",
"GET2g2-RET2-TRg-1",
"GET2g2-RPS2-NRg-1",
"GET2g2-RPS2-NRg-2",
"GET2g2-ORC4-NRg-3",
"GET2g2-TIP20-TRg-7",
"GET2g2-SMT3-TRg-1",
"GET2g2-MSS18-NRg-6",
"GET2g2-YEF3-NRg-9",
"GET2g2-ASK1-NRg-1",
"GET2g2-SMC1-TRg-1",
"GET2g2-NIP1-NRg-1",
"GET2g2-RPP1-NRg-1",
"GET2g2-YDJ1-TRg-6",
"GET2g2-SUB2-NRg-1",
"GET2g2-TIM10-NRg-8",
"GET2g2-TIM10-NRg-4",
"GET2g2-TIM10-NRg-7",
"GET2g2-SKI6-TRg-4",
"GET2g2-TUB4-TRg-1",
"GET2g2-CDC37-NRg-2",
"GET2g2-ISD11-TRg-3",
"GET2g2-YOS1-TRg-4",
"GET2g2-SSC1-TRg-6",
"GET2g2-MTR3-TRg-5",
"GET2g2-MTR3-TRg-6",
"GET2g2-TFA1-TRg-2",
"GET2g2-CDC3-NRg-3",
"GET2g2-ERG25-TA-18",
"GET2g2-RPB11-TRg-4",
"GET2g2-RPB11-TRg-1",
"GET2g2-RPB11-TRg-2",
"GET2g2-DED1-TRg-3",
"GET2g2-DED1-TRg-1",
"GET2g2-DED1-TRg-6",
"GET2g2-DED1-TRg-4",
"GET2g2-RPL10-NRg-5",
"GET2g2-RPL10-NRg-4",
"GET2g2-EFB1-NRg-1",
"GET2g2-EFB1-NRg-5",
"GET2g2-EFB1-NRg-4",
"GET2g2-RPT3-NRg-1",
"GET2g2-SAC6-TRg-8",
"GET2g2-SAC6-TRg-4",
"GET2g2-SAC6-TRg-5",
"GET2g2-SAC6-TRg-3",
"GET2g2-DIM1-TRg-5",
"GET2g2-DIM1-TRg-7",
"GET2g2-RPC17-NRg-1",
"GET2g2-RPC17-NRg-2",
"GET2g2-YDR341C-TRg-1",
"GET2g2-RAP1-NRg-8",
"GET2g2-RAP1-NRg-5",
"GET2g2-RAP1-NRg-2",
"GET2g2-SEC26-NRg-3",
"GET2g2-SPP41-TRg-3",
"GET2g2-TAP42-NRg-1",
"GET2g2-PGA2-TRg-6",
"GET2g2-BRL1-TRg-1",
"GET2g2-FOL2-TRg-1",
"GET2g2-NAB3-NRg-5",
"GET2g2-SNF4-TRg-4",
"GET2g2-HRR25-TRg-2",
"GET2g2-TRS23-TRg-4",
"GET2g2-CTR86-TRg-4",
"GET2g2-RPB5-TRg-5",
"GET2g2-SPN1-NRg-2",
"GET2g2-SPN1-NRg-1",
"GET2g2-SEC61-NRg-1",
"GET2g2-SEC61-NRg-7",
"GET2g2-TUS1-TRg-3",
"GET2g2-OLE1-NRg-2",
"GET2g2-AFG2-TRg-1",
"GET2g2-TOA2-NRg-1",
"GET2g2-USO1-TRg-1",
"GET2g2-UTP22-NRg-2",
"GET2g2-RIB1-TRg-3",
"GET2g2-RIB1-TRg-7",
"GET2g2-RIB1-TRg-4",
"GET2g2-COG1-TRg-1",
"GET2g2-RPL32-NRg-2",
"GET2g2-GLC7-NRg-3",
"GET2g2-GLC7-NRg-4",
"GET2g2-HSF1-TRg-2",
"GET2g2-DAM1-NRg-5",
"GET2g2-SEC18-TRg-4",
"GET2g2-SEC18-TRg-5",
"GET2g2-PAB1-NRg-3",
"GET2g2-POP8-TRg-2",
"GET2g2-PAB1-NRg-4",
"GET2g2-BIG1-TRg-4",
"GET2g2-BIG1-TRg-5",
"GET2g2-BIG1-TRg-6",
"GET2g2-RPO41-NRg-1",
"GET2g2-RVB2-NRg-2",
"GET2g2-PET117-NRg-8",
"GET2g2-VPS45-NRg-9",
"GET2g2-YCG1-NRg-1",
"GET2g2-NOC4-NRg-1",
"GET2g2-NMD3-NRg-2",
"GET2g2-DRS1-TRg-2",
"GET2g2-HTB1-NRg-2",
"GET2g2-IPI1-TRg-2",
"GET2g2-SEC18-NRg-1",
"GET2g2-SEC18-NRg-2",
"GET2g2-JIP5-NRg-2",
"GET2g2-YPT1-TRg-3",
"GET2g2-YPT1-TRg-2",
"GET2g2-CLF1-NRg-2",
"GET2g2-SNF2-NRg-7",
"GET2g2-SNF2-NRg-4",
"GET2g2-RPL25-NRg-1",
"GET2g2-NOP56-TRg-1",
"GET2g2-NOP56-TRg-2",
"GET2g2-TRS31-TRg-1",
"GET2g2-DBF4-TRg-2",
"GET2g2-DBF4-TRg-1",
"GET2g2-RPC19-TRg-4",
"GET2g2-RPC19-TRg-6",
"GET2g2-RPC19-TRg-3",
"GET2g2-ROK1-NRg-1",
"GET2g2-CDC33-TRg-4",
"GET2g2-DHR2-TRg-3",
"GET2g2-RRP42-NRg-5",
"GET2g2-CLF1-TRg-1",
"GET2g2-ERG11-NA-16",
"GET2g2-VAS1-NRg-4",
"GET2g2-PIK1-NRg-2",
"GET2g2-SAR1-NRg-7",
"GET2g2-SAR1-NRg-4",
"GET2g2-RPS3-TRg-1",
"GET2g2-YTM1-TRg-2",
"GET2g2-SUI3-NRg-5",
"GET2g2-SUI3-NRg-2",
"GET2g2-RRP7-TRg-4",
"GET2g2-RRP7-TRg-6",
"GET2g2-NIP7-TRg-2",
"GET2g2-MDM35-TRg-1",
"GET2g2-ALA1-NRg-1",
"GET2g2-DOA4-NRg-2",
"GET2g2-RPS13-NRg-1",
"GET2g2-YSF3-TRg-2",
"GET2g2-RPS2-NRg-11",
"GET2g2-SSL1-TRg-10",
"GET2g2-NIP7-TRg-1",
"GET2g2-LST8-NRg-1",
"GET2g2-TAF4-TRg-3",
"GET2g2-HAS1-TRg-2",
"GET2g2-GLC7-TRg-2",
"GET2g2-CDC45-NRg-1",
"GET2g2-SEC22-NRg-8",
"GET2g2-YOS1-TRg-2",
"GET2g2-RBA50-TRg-3",
"GET2g2-SPP41-NRg-2",
"GET2g2-PRP46-TRg-2",
"GET2g2-PGA2-NRg-1",
"GET2g2-CBF5-TRg-3",
"GET2g2-TCP1-NRg-3",
"GET2g2-TCP1-NRg-2",
"GET2g2-ERG26-NRg-2",
"GET2g2-ERG26-NRg-4",
"GET2g2-MES1-TRg-5",
"GET2g2-HTS1-TRg-2",
"GET2g2-SSS1-TRg-3",
"GET2g2-SSS1-TRg-2",
"GET2g2-SYS1-TRg-7",
"GET2g2-SYS1-TRg-2",
"GET2g2-SYS1-TRg-1",
"GET2g2-BFR2-TRg-1",
"GET2g2-EOS1-TRg-3",
"GET2g2-TAF4-NRg-1",
"GET2g2-ARL3-NRg-8",
"GET2g2-RPN5-NRg-1",
"GET2g2-TIM9-NRg-2",
"GET2g2-NUP57-NRg-3",
"GET2g2-VPS4-TRg-1",
"GET2g2-CDC3-TRg-4",
"GET2g2-BBP1-NRg-1",
"GET2g2-BBP1-NRg-2",
"GET2g2-USE1-NRg-3",
"GET2g2-CCT7-TRg-1",
"GET2g2-SAH1-TRg-3",
"GET2g2-CHS2-TRg-1",
"GET2g2-DPM1-TRg-2",
"GET2g2-BBP1-TRg-1",
"GET2g2-NRD1-TRg-4",
"GET2g2-RPB3-NRg-1",
"GET2g2-PHO85-NRg-6",
"GET2g2-SNF6-TRg-6",
"GET2g2-PRP38-NRg-2",
"GET2g2-OAR1-NRg-3",
"GET2g2-ROX3-NRg-1",
"GET2g2-YPP1-TRg-6",
"GET2g2-CBF2-NRg-8",
"GET2g2-SPT6-TRg-5",
"GET2g2-SEC10-NRg-1",
"GET2g2-NSL1-NRg-3",
"GET2g2-NRD1-NRg-8",
"GET2g2-RPB3-TRg-1",
"GET2g2-NRD1-NRg-4",
"GET2g2-RVB1-TRg-2",
"GET2g2-TIF5-NRg-8",
"GET2g2-EOS1-NRg-1",
"GET2g2-ERG25-NA-26",
"GET2g2-MSL5-NRg-4",
"GET2g2-SEC24-TRg-2",
"GET2g2-RPL30-NRg-5",
"GET2g2-SNU71-NRg-3",
"GET2g2-CDC33-NRg-1",
"GET2g2-RPN6-TRg-4",
"GET2g2-NAB2-TRg-4",
"GET2g2-NAB2-TRg-6",
"GET2g2-YTM1-NRg-1",
"GET2g2-OLE1-TRg-8",
"GET2g2-OLE1-TRg-1",
"GET2g2-UTP7-TRg-4",
"GET2g2-ACT1-NRg-6",
"GET2g2-RPL18A-NRg-3",
"GET2g2-BRX1-NRg-1",
"GET2g2-NAF1-TRg-8",
"GET2g2-NAF1-TRg-6",
"GET2g2-NAF1-TRg-4",
"GET2g2-CDC8-TRg-2",
"GET2g2-NSE4-TRg-1",
"GET2g2-PAB1-NRg-2",
"GET2g2-PRP43-TRg-4",
"GET2g2-SEC2-NRg-3",
"GET2g2-SEC2-NRg-6",
"GET2g2-MPP10-NRg-5",
"GET2g2-YDR355C-TRg-2",
"GET2g2-YLR339C-TRg-9",
"GET2g2-SNM1-TRg-2",
"GET2g2-ALR1-NRg-4",
"GET2g2-ALR1-NRg-1",
"GET2g2-ALR1-NRg-3",
"GET2g2-RPL10-TRg-1",
"GET2g2-RPL28-TRg-2",
"GET2g2-UTP25-TRg-1",
"GET2g2-POB3-TRg-1",
"GET2g2-POB3-TRg-3",
"GET2g2-POB3-TRg-2",
"GET2g2-MED11-TRg-1",
"GET2g2-ISA1-TRg-15",
"GET2g2-RRP1-NRg-1",
"GET2g2-MES1-NRg-1",
"GET2g2-SEC13-NRg-5",
"GET2g2-MCM2-NRg-2",
"GET2g2-ALA1-TRg-4",
"GET2g2-MTG2-TRg-5",
"GET2g2-TIF35-NRg-3",
"GET2g2-NSE1-TRg-3",
"GET2g2-NSE1-TRg-4",
"GET2g2-MOB2-NRg-6",
"GET2g2-VRG4-NRg-3",
"GET2g2-PRP9-TRg-3",
"GET2g2-HYM1-TRg-5",
"GET2g2-POP1-TRg-5",
"GET2g2-POP1-TRg-9",
"GET2g2-RPL17A-TRg-1",
"GET2g2-SLD2-TRg-1",
"GET2g2-CDC48-NRg-7",
"GET2g2-FHL1-NRg-2",
"GET2g2-BET3-NRg-7",
"GET2g2-MAK21-TRg-1",
"GET2g2-BRN1-TRg-4",
"GET2g2-FBA1-NRg-3",
"GET2g2-CDC42-TRg-6",
"GET2g2-CDC42-TRg-7",
"GET2g2-COG4-NRg-1",
"GET2g2-ATP3-NRg-3",
"GET2g2-ATP3-NRg-2",
"GET2g2-SMP3-TRg-5",
"GET2g2-CFT2-NRg-2",
"GET2g2-FAS2-TRg-5",
"GET2g2-DBP2-NRg-3",
"GET2g2-DBP2-NRg-2",
"GET2g2-MPS2-NRg-4",
"GET2g2-ARC35-TRg-2",
"GET2g2-ARC35-TRg-5",
"GET2g2-MRD1-TRg-1",
"GET2g2-RLP7-TRg-1",
"GET2g2-SPC34-TRg-1",
"GET2g2-CDC45-TRg-2",
"GET2g2-GCD6-TRg-3",
"GET2g2-GCD6-TRg-4",
"GET2g2-YPT6-NRg-2",
"GET2g2-RPS13-TRg-2",
"GET2g2-IPI3-TRg-3",
"GET2g2-TIF5-NRg-9",
"GET2g2-TIF5-NRg-7",
"GET2g2-TIF5-NRg-6",
"GET2g2-NAB3-TRg-3",
"GET2g2-GCD2-TRg-1",
"GET2g2-UBA1-TRg-2",
"GET2g2-SLD3-TRg-6",
"GET2g2-LCB1-TRg-5",
"GET2g2-TOA2-TRg-6",
"GET2g2-TOA2-TRg-1",
"GET2g2-TOA2-TRg-3",
"GET2g2-LSM2-TRg-1",
"GET2g2-YML6-TRg-13",
"GET2g2-YML6-TRg-12",
"GET2g2-UTP15-NRg-1",
"GET2g2-TIF6-NRg-8",
"GET2g2-SUP35-NRg-1",
"GET2g2-MPP10-NRg-1",
"GET2g2-SWI3-TRg-7",
"GET2g2-SSN3-NRg-2",
"GET2g2-SEC13-NRg-7",
"GET2g2-RPS15-NRg-3",
"GET2g2-RPL3-TRg-2",
"GET2g2-FBA1-NRg-2",
"GET2g2-FBA1-NRg-1",
"GET2g2-FBA1-NRg-5",
"GET2g2-DAM1-TRg-2",
"GET2g2-NHP2-TRg-2",
"GET2g2-HCA4-NRg-6",
"GET2g2-PRE3-TRg-4",
"GET2g2-DBP5-NRg-4",
"GET2g2-SPT6-NRg-4",
"GET2g2-SPT6-NRg-2",
"GET2g2-RPL18A-TRg-4",
"GET2g2-KSH1-TRg-1",
"GET2g2-KSH1-TRg-3",
"GET2g2-IPI3-NRg-1",
"GET2g2-PGA2-TRg-8",
"GET2g2-RPL18A-TRg-2",
"GET2g2-RPL33A-NRg-6",
"GET2g2-TAF12-NRg-2",
"GET2g2-USE1-TRg-5",
"GET2g2-YNL114C-TRg-1",
"GET2g2-SMC5-TRg-7",
"GET2g2-SMC5-TRg-6",
"GET2g2-RSC58-TRg-1",
"GET2g2-CTF13-TRg-2",
"GET2g2-NAB2-NRg-2",
"GET2g2-MCM7-TRg-4",
"GET2g2-BCP1-NRg-5",
"GET2g2-STU2-TRg-3",
"GET2g2-SEC21-NRg-6",
"GET2g2-SEC21-NRg-3",
"GET2g2-RPL1B-TRg-3",
"GET2g2-SEC20-NRg-2",
"GET2g2-VMA3-NRg-2",
"GET2g2-SEC23-NRg-5",
"GET2g2-CDC28-TRg-4",
"GET2g2-RPN12-NRg-11",
"GET2g2-PUP3-TRg-3",
"GET2g2-SEC31-TRg-2",
"GET2g2-SED5-TRg-6",
"GET2g2-SED5-TRg-5",
"GET2g2-RPL33A-TRg-1",
"GET2g2-RPL33A-TRg-2",
"GET2g2-MRPL11-TRg-2",
"GET2g2-RTP1-NRg-2",
"GET2g2-NUG1-TRg-2",
"GET2g2-VPH2-TRg-4",
"GET2g2-COP1-NRg-3",
"GET2g2-CRM1-NRg-1",
"GET2g2-RPL5-NRg-4",
"GET2g2-SNU13-NRg-4",
"GET2g2-PFS2-TRg-3",
"GET2g2-MPP10-TRg-2",
"GET2g2-TSR4-NRg-2",
"GET2g2-RSC2-TRg-1",
"GET2g2-SEC65-TRg-2",
"GET2g2-SMI1-NRg-1",
"GET2g2-RTT105-NRg-4",
"GET2g2-VMA5-TRg-3",
"GET2g2-VMA5-TRg-5",
"GET2g2-RRP1-TRg-3",
"GET2g2-CLC1-TRg-2",
"GET2g2-GCD6-NRg-1",
"GET2g2-GCD6-NRg-2",
"GET2g2-PXR1-TRg-1",
"GET2g2-CDC14-NRg-1",
"GET2g2-PCF11-TRg-6",
"GET2g2-PCF11-TRg-5",
"GET2g2-PCF11-TRg-4",
"GET2g2-SEC31-NRg-1",
"GET2g2-RRP5-NRg-1",
"GET2g2-PRE10-TRg-5",
"GET2g2-PRE10-TRg-1",
"GET2g2-RPS5-TRg-2",
"GET2g2-NSP1-TRg-4",
"GET2g2-PRP38-TRg-4",
"GET2g2-RCF1-NRg-5",
"GET2g2-RSC3-TRg-4",
"GET2g2-RSC3-TRg-5",
"GET2g2-RSC3-TRg-6",
"GET2g2-HTA1-NRg-12",
"GET2g2-HTA1-NRg-11",
"GET2g2-UTP23-TRg-2",
"GET2g2-GCD7-NRg-1",
"GET2g2-GCD7-NRg-2",
"GET2g2-GCD7-NRg-6",
"GET2g2-GAL11-NRg-2",
"GET2g2-GAL11-NRg-9",
"GET2g2-PHO4-TRg-5",
"GET2g2-SNP1-NRg-3",
"GET2g2-RPC37-TRg-5",
"GET2g2-CRM1-TRg-5",
"GET2g2-CRM1-TRg-2",
"GET2g2-ASK1-TRg-7",
"GET2g2-STU2-NRg-4",
"GET2g2-NEO1-NRg-3",
"GET2g2-GAL11-TRg-5",
"GET2g2-GAL11-TRg-7",
"GET2g2-SAM50-NRg-3",
"GET2g2-CSL4-TRg-2",
"GET2g2-CCT5-TRg-2",
"GET2g2-POL30-NRg-1",
"GET2g2-MED4-TRg-4",
"GET2g2-MED4-TRg-3",
"GET2g2-MED4-TRg-2",
"GET2g2-GDI1-TRg-4",
"GET2g2-GDI1-TRg-3",
"GET2g2-REB1-TRg-6",
"GET2g2-MRPL37-NRg-2",
"GET2g2-NOC3-TRg-3",
"GET2g2-SPC97-TRg-3",
"GET2g2-IPP1-TRg-3",
"GET2g2-IPP1-TRg-2",
"GET2g2-PTI1-TRg-3",
"GET2g2-PTI1-TRg-5",
"GET2g2-RFC5-NRg-1",
"GET2g2-CDC24-TRg-1",
"GET2g2-CDC24-TRg-3",
"GET2g2-CDC24-TRg-5",
"GET2g2-CDC24-TRg-6",
"GET2g2-UTP23-TRg-6",
"GET2g2-UTP23-TRg-4",
"GET2g2-UTP23-TRg-1",
"GET2g2-RHO3-NRg-4",
"GET2g2-TRS23-NRg-1",
"GET2g2-TRS23-NRg-3",
"GET2g2-RSP5-TRg-2",
"GET2g2-RSP5-TRg-1",
"GET2g2-SDA1-NRg-1",
"GET2g2-KAP95-TRg-8",
"GET2g2-ACO1-TRg-6",
"GET2g2-HTA1-NRg-3",
"GET2g2-HTA1-NRg-2",
"GET2g2-SPN1-TRg-1",
"GET2g2-MOT1-NRg-7",
"GET2g2-RPL17A-NRg-4",
"GET2g2-ADA2-TRg-4",
"GET2g2-SFH1-NRg-1",
"GET2g2-SPC97-NRg-5",
"GET2g2-PRP22-TRg-3",
"GET2g2-SEN15-TRg-2",
"GET2g2-RPL3-NRg-2",
"GET2g2-ISD11-NRg-2",
"GET2g2-HEM12-TRg-8",
"GET2g2-SEC10-TRg-1",
"GET2g2-HTB1-TRg-7",
"GET2g2-TTI2-TRg-1",
"GET2g2-ACP1-TRg-2",
"GET2g2-ACP1-TRg-4",
"GET2g2-GAL11-NRg-10",
"GET2g2-UTP22-TRg-2",
"GET2g2-MST1-NRg-5",
"GET2g2-RIB7-NRg-2",
"GET2g2-MCD1-TRg-6",
"GET2g2-MCD1-TRg-5",
"GET2g2-GPI8-NRg-2",
"GET2g2-THS1-TRg-2",
"GET2g2-RRP7-TRg-2",
"GET2g2-RRP7-TRg-5",
"GET2g2-SMX2-NRg-7",
"GET2g2-RRP45-TRg-5",
"GET2g2-RRP45-TRg-4",
"GET2g2-CNS1-TRg-2",
"GET2g2-FBP1-NRg-9",
"GET2g2-GCD11-NRg-1",
"GET2g2-RPL10-TRg-2",
"GET2g2-NUP192-TRg-4",
"GET2g2-NUP145-NRg-4",
"GET2g2-HEM12-TRg-6",
"GET2g2-PLC1-TRg-3",
"GET2g2-RPA43-TRg-1",
"GET2g2-RPB7-NRg-2",
"GET2g2-RPB7-NRg-3",
"GET2g2-NSL1-NRg-1",
"GET2g2-UTP6-TRg-3",
"GET2g2-UTP6-TRg-1",
"GET2g2-YJU2-TRg-5",
"GET2g2-FRS2-NRg-5",
"GET2g2-TIF35-NRg-2",
"GET2g2-GPI15-TRg-1",
"GET2g2-NOP1-NRg-5",
"GET2g2-GPI15-TRg-4",
"GET2g2-COG4-TRg-1",
"GET2g2-TFA1-TRg-1",
"GET2g2-RHO1-NRg-2",
"GET2g2-RHO1-NRg-1",
"GET2g2-CDC55-NRg-2",
"GET2g2-IDI1-NRg-7",
"GET2g2-RPL32-TRg-5",
"GET2g2-RPB5-TRg-4",
"GET2g2-DIP2-TRg-5",
"GET2g2-DIP2-TRg-1",
"GET2g2-RPC40-TRg-2",
"GET2g2-CDC6-TRg-5",
"GET2g2-CDC6-TRg-3",
"GET2g2-DAD2-TRg-2",
"GET2g2-RVS161-TRg-2",
"GET2g2-RVS161-TRg-1",
"GET2g2-SUP45-NRg-3",
"GET2g2-SRB6-NRg-5",
"GET2g2-RPC11-TRg-4",
"GET2g2-RKI1-TRg-8",
"GET2g2-NIP7-TRg-3",
"GET2g2-RPL33A-NRg-12",
"GET2g2-SAM50-TRg-4",
"GET2g2-NOP4-NRg-1",
"GET2g2-NOP4-NRg-3",
"GET2g2-SMX2-TRg-5",
"GET2g2-POL12-NRg-2",
"GET2g2-BMS1-NRg-2",
"GET2g2-RPA190-TRg-5",
"GET2g2-ALG14-NRg-4",
"GET2g2-ALG14-NRg-1",
"GET2g2-PRE5-NRg-1",
"GET2g2-BIG1-NRg-2",
"GET2g2-TFA2-TRg-4",
"GET2g2-IMP4-TRg-6",
"GET2g2-PAN1-NRg-1",
"GET2g2-UTP13-TRg-2",
"GET2g2-KAE1-NRg-3",
"GET2g2-ERG20-TRg-1",
"GET2g2-CDC20-TRg-6",
"GET2g2-PWP2-NRg-2",
"GET2g2-COG1-NRg-1",
"GET2g2-RPL1B-TRg-4",
"GET2g2-RPL1B-TRg-7",
"GET2g2-UTP20-TRg-3",
"GET2g2-UTP20-TRg-4",
"GET2g2-RPL25-TRg-4",
"GET2g2-RPL25-TRg-2",
"GET2g2-MCM7-NRg-1",
"GET2g2-MRP49-TRg-5",
"GET2g2-ERO1-NRg-3",
"GET2g2-UTP5-TRg-7",
"GET2g2-MCM4-NRg-1",
"GET2g2-PRE3-NRg-1",
"GET2g2-FCF1-NRg-1",
"GET2g2-CUS1-NRg-1",
"GET2g2-PSF1-TRg-2",
"GET2g2-BCP1-TRg-2",
"GET2g2-PAN1-TRg-1",
"GET2g2-PAN1-TRg-3",
"GET2g2-PAN1-TRg-4",
"GET2g2-VPS3-TRg-2",
"GET2g2-YIL060W-NRg-1",
"GET2g2-VPS53-NRg-1",
"GET2g2-CYR1-TRg-4",
"GET2g2-CYR1-TRg-7",
"GET2g2-MPS1-NRg-1",
"GET2g2-SRP1-TRg-5",
"GET2g2-SRP1-TRg-4",
"GET2g2-TAF12-TRg-2",
"GET2g2-TAF12-TRg-3",
"GET2g2-POP4-TRg-1",
"GET2g2-SPT16-TRg-1",
"GET2g2-NUP82-TRg-4",
"GET2g2-DML1-TRg-3",
"GET2g2-RPA43-NRg-3",
"GET2g2-STU2-NRg-3",
"GET2g2-POP4-NRg-4",
"GET2g2-MCD1-TRg-2",
"GET2g2-RPS3-NRg-4",
"GET2g2-PRP9-TRg-4",
"GET2g2-RPP1-NRg-2",
"GET2g2-MTR2-NRg-11",
"GET2g2-GCD11-TRg-1",
"GET2g2-RPF1-TRg-3",
"GET2g2-SUB2-NRg-4",
"GET2g2-GPI15-TRg-3",
"GET2g2-ERG9-TRg-6",
"GET2g2-RPT2-NRg-1",
"GET2g2-YOS1-NRg-3",
"GET2g2-SCM3-TRg-4",
"GET2g2-SCM3-TRg-6",
"GET2g2-RLP7-NRg-1",
"GET2g2-TFB2-NRg-4",
"GET2g2-IMP4-TRg-1",
"GET2g2-IMP4-TRg-3",
"GET2g2-PRE4-TRg-3",
"GET2g2-SUB2-TRg-3",
"GET2g2-RPP0-NRg-4",
"GET2g2-RPP0-NRg-3",
"GET2g2-TOM40-TRg-4",
"GET2g2-FUR1-NRg-12",
"GET2g2-TOM40-TRg-2",
"GET2g2-VMA11-NRg-4",
"GET2g2-PGS1-NRg-4",
"GET2g2-URB1-TRg-4",
"GET2g2-ARP4-TRg-3",
"GET2g2-RPT3-TRg-3",
"GET2g2-SUI3-TRg-3",
"GET2g2-RFC5-NRg-2",
"GET2g2-RRP14-TRg-2",
"GET2g2-SCC2-TRg-1",
"GET2g2-SSC1-TRg-3",
"GET2g2-RRP9-TRg-3",
"GET2g2-MOT1-NRg-9",
"GET2g2-RPL42A-NRg-2",
"GET2g2-SEC16-TRg-7",
"GET2g2-IMP4-NRg-2",
"GET2g2-YEF3-NRg-4",
"GET2g2-PUP1-TRg-1",
"GET2g2-UTP22-TRg-6",
"GET2g2-DBP2-NRg-4",
"GET2g2-PRE2-TRg-7",
"GET2g2-ATP16-TRg-6",
"GET2g2-UTP13-TRg-4",
"GET2g2-DOP1-NRg-4",
"GET2g2-TIM44-TRg-3",
"GET2g2-ATP16-TRg-2",
"GET2g2-ENP1-NRg-3",
"GET2g2-NAF1-TRg-3",
"GET2g2-COG4-TRg-2",
"GET2g2-SOG2-TRg-7",
"GET2g2-YDR341C-TRg-3",
"GET2g2-YMR290W-A-TRg-10",
"GET2g2-NUP192-NRg-9",
"GET2g2-RPS31-NRg-8",
"GET2g2-SPC97-NRg-6",
"GET2g2-EBP2-NRg-1",
"GET2g2-CDC48-TRg-5",
"GET2g2-RPT1-TRg-4",
"GET2g2-ULP1-NRg-2",
"GET2g2-RPN3-TRg-6",
"GET2g2-RPT1-TRg-5",
"GET2g2-KRE5-TRg-2",
"GET2g2-TBF1-NRg-8",
"GET2g2-UTP22-NRg-4",
"GET2g2-SSC1-NRg-4",
"GET2g2-REB1-TRg-4",
"GET2g2-CDC48-NRg-9",
"GET2g2-FAS2-TRg-8",
"GET2g2-TAO3-TRg-8",
"GET2g2-CKS1-TRg-5",
"GET2g2-YLR379W-TRg-7",
"GET2g2-TEN1-NRg-2",
"GET2g2-RPL42A-TRg-2",
"GET2g2-SEC27-TRg-4",
"GET2g2-TBF1-NRg-4",
"GET2g2-RPT1-NRg-6",
"GET2g2-COG1-TRg-3",
"GET2g2-SUI1-TRg-6",
"GET2g2-TIM23-TRg-6",
"GET2g2-CDC48-NRg-6",
"GET2g2-EPL1-TRg-5",
"GET2g2-RPT5-TRg-8",
"GET2g2-ATP16-NRg-4",
"GET2g2-RPN6-TRg-3",
"GET2g2-ERG9-NRg-6",
"GET2g2-SMX3-TRg-1",
"GET2g2-NCB2-NRg-3",
"GET2g2-SEC16-NRg-12",
"GET2g2-RPN6-TRg-2",
"GET2g2-REB1-NRg-4",
"GET2g2-ATP16-TRg-9",
"GET2g2-ERG9-NRg-7",
"IMP4g6-RPL15A-NRg-4",
"IMP4g6-RPL15A-NRg-5",
"IMP4g6-KRE33-TRg-1",
"IMP4g6-PMI40-NRg-1",
"IMP4g6-NOP19-NRg-3",
"IMP4g6-SRP14-NRg-4",
"IMP4g6-SEC27-TRg-2",
"IMP4g6-GPI14-TRg-3",
"IMP4g6-PAH1-TRg-7",
"IMP4g6-PAH1-TRg-6",
"IMP4g6-PAH1-TRg-5",
"IMP4g6-PAH1-TRg-3",
"IMP4g6-COG3-TRg-1",
"IMP4g6-HTS1-NRg-5",
"IMP4g6-MSN5-TRg-7",
"IMP4g6-ERG26-TRg-1",
"IMP4g6-SMD2-TRg-5",
"IMP4g6-SMD2-TRg-4",
"IMP4g6-SMD2-TRg-1",
"IMP4g6-PRE7-TRg-4",
"IMP4g6-PRE7-TRg-7",
"IMP4g6-SEC6-TRg-3",
"IMP4g6-ESF2-NRg-1",
"IMP4g6-ESF2-NRg-3",
"IMP4g6-AFG2-TRg-2",
"IMP4g6-RRP36-TRg-3",
"IMP4g6-RRP36-TRg-5",
"IMP4g6-GCR1-NRg-2",
"IMP4g6-PRE4-NRg-4",
"IMP4g6-PRE4-NRg-9",
"IMP4g6-DSN1-NRg-2",
"IMP4g6-GPI11-TRg-3",
"IMP4g6-POP3-TRg-1",
"IMP4g6-MNE1-TRg-5",
"IMP4g6-RRP12-NRg-1",
"IMP4g6-RSC6-TRg-2",
"IMP4g6-CDC25-TRg-1",
"IMP4g6-CDC25-TRg-9",
"IMP4g6-YPP1-NRg-3",
"IMP4g6-NFS1-NRg-9",
"IMP4g6-NFS1-NRg-8",
"IMP4g6-UBA2-TRg-1",
"IMP4g6-ARP2-NRg-3",
"IMP4g6-MAK16-TRg-1",
"IMP4g6-CEP3-NRg-1",
"IMP4g6-GUK1-TRg-5",
"IMP4g6-GUK1-TRg-2",
"IMP4g6-GPI12-NRg-6",
"IMP4g6-RPS5-NRg-5",
"IMP4g6-RPS5-NRg-2",
"IMP4g6-RPC19-NRg-1",
"IMP4g6-TIM54-TRg-1",
"IMP4g6-TEN1-TRg-2",
"IMP4g6-SAH1-NRg-4",
"IMP4g6-SAH1-NRg-5",
"IMP4g6-SAH1-NRg-3",
"IMP4g6-ATP15-NRg-5",
"IMP4g6-SCD5-TRg-5",
"IMP4g6-ARB1-NRg-2",
"IMP4g6-ARB1-NRg-4",
"IMP4g6-PUP2-TRg-1",
"IMP4g6-CCT8-TRg-2",
"IMP4g6-MCM4-TRg-1",
"IMP4g6-LSM4-TRg-1",
"IMP4g6-NOP53-NRg-1",
"IMP4g6-ATP3-TRg-4",
"IMP4g6-AFG2-NRg-3",
"IMP4g6-PRO3-NRg-3",
"IMP4g6-NRD1-NRg-10",
"IMP4g6-SEC61-TRg-2",
"IMP4g6-RHO3-TRg-4",
"IMP4g6-SNF2-TRg-6",
"IMP4g6-SMD2-NRg-3",
"IMP4g6-RSC4-TRg-2",
"IMP4g6-RSC4-TRg-1",
"IMP4g6-TIF34-TRg-2",
"IMP4g6-BET1-NRg-1",
"IMP4g6-CDC8-NRg-2",
"IMP4g6-PRP42-TRg-2",
"IMP4g6-RRB1-TRg-2",
"IMP4g6-SPC24-TRg-1",
"IMP4g6-ILS1-NRg-1",
"IMP4g6-GFA1-TRg-2",
"IMP4g6-SEC21-NRg-10",
"IMP4g6-RPC10-NRg-1",
"IMP4g6-RPB10-TRg-3",
"IMP4g6-RPB10-TRg-2",
"IMP4g6-YNL181W-TRg-1",
"IMP4g6-RAD3-NRg-1",
"IMP4g6-NOP10-TRg-1",
"IMP4g6-BFR2-TRg-3",
"IMP4g6-MCM2-TRg-6",
"IMP4g6-MCM2-TRg-4",
"IMP4g6-MPP10-TRg-1",
"IMP4g6-RET2-TRg-4",
"IMP4g6-RET2-TRg-1",
"IMP4g6-RPS2-NRg-1",
"IMP4g6-RPS2-NRg-2",
"IMP4g6-ORC4-NRg-3",
"IMP4g6-TIP20-TRg-7",
"IMP4g6-SMT3-TRg-1",
"IMP4g6-MSS18-NRg-6",
"IMP4g6-YEF3-NRg-9",
"IMP4g6-ASK1-NRg-1",
"IMP4g6-SMC1-TRg-1",
"IMP4g6-NIP1-NRg-1",
"IMP4g6-RPP1-NRg-1",
"IMP4g6-YDJ1-TRg-6",
"IMP4g6-SUB2-NRg-1",
"IMP4g6-TIM10-NRg-8",
"IMP4g6-TIM10-NRg-4",
"IMP4g6-TIM10-NRg-7",
"IMP4g6-SKI6-TRg-4",
"IMP4g6-TUB4-TRg-1",
"IMP4g6-CDC37-NRg-2",
"IMP4g6-ISD11-TRg-3",
"IMP4g6-YOS1-TRg-4",
"IMP4g6-SSC1-TRg-6",
"IMP4g6-MTR3-TRg-5",
"IMP4g6-MTR3-TRg-6",
"IMP4g6-TFA1-TRg-2",
"IMP4g6-CDC3-NRg-3",
"IMP4g6-ERG25-TA-18",
"IMP4g6-RPB11-TRg-4",
"IMP4g6-RPB11-TRg-1",
"IMP4g6-RPB11-TRg-2",
"IMP4g6-DED1-TRg-3",
"IMP4g6-DED1-TRg-1",
"IMP4g6-DED1-TRg-6",
"IMP4g6-DED1-TRg-4",
"IMP4g6-RPL10-NRg-5",
"IMP4g6-RPL10-NRg-4",
"IMP4g6-EFB1-NRg-1",
"IMP4g6-EFB1-NRg-5",
"IMP4g6-EFB1-NRg-4",
"IMP4g6-RPT3-NRg-1",
"IMP4g6-SAC6-TRg-8",
"IMP4g6-SAC6-TRg-4",
"IMP4g6-SAC6-TRg-5",
"IMP4g6-SAC6-TRg-3",
"IMP4g6-DIM1-TRg-5",
"IMP4g6-DIM1-TRg-7",
"IMP4g6-RPC17-NRg-1",
"IMP4g6-RPC17-NRg-2",
"IMP4g6-YDR341C-TRg-1",
"IMP4g6-RAP1-NRg-8",
"IMP4g6-RAP1-NRg-5",
"IMP4g6-RAP1-NRg-2",
"IMP4g6-SEC26-NRg-3",
"IMP4g6-SPP41-TRg-3",
"IMP4g6-TAP42-NRg-1",
"IMP4g6-PGA2-TRg-6",
"IMP4g6-BRL1-TRg-1",
"IMP4g6-FOL2-TRg-1",
"IMP4g6-NAB3-NRg-5",
"IMP4g6-SNF4-TRg-4",
"IMP4g6-HRR25-TRg-2",
"IMP4g6-TRS23-TRg-4",
"IMP4g6-CTR86-TRg-4",
"IMP4g6-RPB5-TRg-5",
"IMP4g6-SPN1-NRg-2",
"IMP4g6-SPN1-NRg-1",
"IMP4g6-SEC61-NRg-1",
"IMP4g6-SEC61-NRg-7",
"IMP4g6-TUS1-TRg-3",
"IMP4g6-OLE1-NRg-2",
"IMP4g6-AFG2-TRg-1",
"IMP4g6-TOA2-NRg-1",
"IMP4g6-USO1-TRg-1",
"IMP4g6-UTP22-NRg-2",
"IMP4g6-RIB1-TRg-3",
"IMP4g6-RIB1-TRg-7",
"IMP4g6-RIB1-TRg-4",
"IMP4g6-COG1-TRg-1",
"IMP4g6-RPL32-NRg-2",
"IMP4g6-GLC7-NRg-3",
"IMP4g6-GLC7-NRg-4",
"IMP4g6-HSF1-TRg-2",
"IMP4g6-DAM1-NRg-5",
"IMP4g6-SEC18-TRg-4",
"IMP4g6-SEC18-TRg-5",
"IMP4g6-PAB1-NRg-3",
"IMP4g6-POP8-TRg-2",
"IMP4g6-PAB1-NRg-4",
"IMP4g6-BIG1-TRg-4",
"IMP4g6-BIG1-TRg-5",
"IMP4g6-BIG1-TRg-6",
"IMP4g6-RPO41-NRg-1",
"IMP4g6-RVB2-NRg-2",
"IMP4g6-PET117-NRg-8",
"IMP4g6-VPS45-NRg-9",
"IMP4g6-YCG1-NRg-1",
"IMP4g6-NOC4-NRg-1",
"IMP4g6-NMD3-NRg-2",
"IMP4g6-DRS1-TRg-2",
"IMP4g6-HTB1-NRg-2",
"IMP4g6-IPI1-TRg-2",
"IMP4g6-SEC18-NRg-1",
"IMP4g6-SEC18-NRg-2",
"IMP4g6-JIP5-NRg-2",
"IMP4g6-YPT1-TRg-3",
"IMP4g6-YPT1-TRg-2",
"IMP4g6-CLF1-NRg-2",
"IMP4g6-SNF2-NRg-7",
"IMP4g6-SNF2-NRg-4",
"IMP4g6-RPL25-NRg-1",
"IMP4g6-NOP56-TRg-1",
"IMP4g6-NOP56-TRg-2",
"IMP4g6-TRS31-TRg-1",
"IMP4g6-DBF4-TRg-2",
"IMP4g6-DBF4-TRg-1",
"IMP4g6-RPC19-TRg-4",
"IMP4g6-RPC19-TRg-6",
"IMP4g6-RPC19-TRg-3",
"IMP4g6-ROK1-NRg-1",
"IMP4g6-CDC33-TRg-4",
"IMP4g6-DHR2-TRg-3",
"IMP4g6-RRP42-NRg-5",
"IMP4g6-CLF1-TRg-1",
"IMP4g6-ERG11-NA-16",
"IMP4g6-VAS1-NRg-4",
"IMP4g6-PIK1-NRg-2",
"IMP4g6-SAR1-NRg-7",
"IMP4g6-SAR1-NRg-4",
"IMP4g6-RPS3-TRg-1",
"IMP4g6-YTM1-TRg-2",
"IMP4g6-SUI3-NRg-5",
"IMP4g6-SUI3-NRg-2",
"IMP4g6-RRP7-TRg-4",
"IMP4g6-RRP7-TRg-6",
"IMP4g6-NIP7-TRg-2",
"IMP4g6-MDM35-TRg-1",
"IMP4g6-ALA1-NRg-1",
"IMP4g6-DOA4-NRg-2",
"IMP4g6-RPS13-NRg-1",
"IMP4g6-YSF3-TRg-2",
"IMP4g6-RPS2-NRg-11",
"IMP4g6-SSL1-TRg-10",
"IMP4g6-NIP7-TRg-1",
"IMP4g6-LST8-NRg-1",
"IMP4g6-TAF4-TRg-3",
"IMP4g6-HAS1-TRg-2",
"IMP4g6-GLC7-TRg-2",
"IMP4g6-CDC45-NRg-1",
"IMP4g6-SEC22-NRg-8",
"IMP4g6-YOS1-TRg-2",
"IMP4g6-RBA50-TRg-3",
"IMP4g6-SPP41-NRg-2",
"IMP4g6-PRP46-TRg-2",
"IMP4g6-PGA2-NRg-1",
"IMP4g6-CBF5-TRg-3",
"IMP4g6-TCP1-NRg-3",
"IMP4g6-TCP1-NRg-2",
"IMP4g6-ERG26-NRg-2",
"IMP4g6-ERG26-NRg-4",
"IMP4g6-MES1-TRg-5",
"IMP4g6-HTS1-TRg-2",
"IMP4g6-SSS1-TRg-3",
"IMP4g6-SSS1-TRg-2",
"IMP4g6-SYS1-TRg-7",
"IMP4g6-SYS1-TRg-2",
"IMP4g6-SYS1-TRg-1",
"IMP4g6-BFR2-TRg-1",
"IMP4g6-EOS1-TRg-3",
"IMP4g6-TAF4-NRg-1",
"IMP4g6-ARL3-NRg-8",
"IMP4g6-RPN5-NRg-1",
"IMP4g6-TIM9-NRg-2",
"IMP4g6-NUP57-NRg-3",
"IMP4g6-VPS4-TRg-1",
"IMP4g6-CDC3-TRg-4",
"IMP4g6-BBP1-NRg-1",
"IMP4g6-BBP1-NRg-2",
"IMP4g6-USE1-NRg-3",
"IMP4g6-CCT7-TRg-1",
"IMP4g6-SAH1-TRg-3",
"IMP4g6-CHS2-TRg-1",
"IMP4g6-DPM1-TRg-2",
"IMP4g6-BBP1-TRg-1",
"IMP4g6-NRD1-TRg-4",
"IMP4g6-RPB3-NRg-1",
"IMP4g6-PHO85-NRg-6",
"IMP4g6-SNF6-TRg-6",
"IMP4g6-PRP38-NRg-2",
"IMP4g6-OAR1-NRg-3",
"IMP4g6-ROX3-NRg-1",
"IMP4g6-YPP1-TRg-6",
"IMP4g6-CBF2-NRg-8",
"IMP4g6-SPT6-TRg-5",
"IMP4g6-SEC10-NRg-1",
"IMP4g6-NSL1-NRg-3",
"IMP4g6-NRD1-NRg-8",
"IMP4g6-RPB3-TRg-1",
"IMP4g6-NRD1-NRg-4",
"IMP4g6-RVB1-TRg-2",
"IMP4g6-TIF5-NRg-8",
"IMP4g6-EOS1-NRg-1",
"IMP4g6-ERG25-NA-26",
"IMP4g6-MSL5-NRg-4",
"IMP4g6-SEC24-TRg-2",
"IMP4g6-RPL30-NRg-5",
"IMP4g6-SNU71-NRg-3",
"IMP4g6-CDC33-NRg-1",
"IMP4g6-RPN6-TRg-4",
"IMP4g6-NAB2-TRg-4",
"IMP4g6-NAB2-TRg-6",
"IMP4g6-YTM1-NRg-1",
"IMP4g6-OLE1-TRg-8",
"IMP4g6-OLE1-TRg-1",
"IMP4g6-UTP7-TRg-4",
"IMP4g6-ACT1-NRg-6",
"IMP4g6-RPL18A-NRg-3",
"IMP4g6-BRX1-NRg-1",
"IMP4g6-NAF1-TRg-8",
"IMP4g6-NAF1-TRg-6",
"IMP4g6-NAF1-TRg-4",
"IMP4g6-CDC8-TRg-2",
"IMP4g6-NSE4-TRg-1",
"IMP4g6-PAB1-NRg-2",
"IMP4g6-PRP43-TRg-4",
"IMP4g6-SEC2-NRg-3",
"IMP4g6-SEC2-NRg-6",
"IMP4g6-MPP10-NRg-5",
"IMP4g6-YDR355C-TRg-2",
"IMP4g6-YLR339C-TRg-9",
"IMP4g6-SNM1-TRg-2",
"IMP4g6-ALR1-NRg-4",
"IMP4g6-ALR1-NRg-1",
"IMP4g6-ALR1-NRg-3",
"IMP4g6-RPL10-TRg-1",
"IMP4g6-RPL28-TRg-2",
"IMP4g6-UTP25-TRg-1",
"IMP4g6-POB3-TRg-1",
"IMP4g6-POB3-TRg-3",
"IMP4g6-POB3-TRg-2",
"IMP4g6-MED11-TRg-1",
"IMP4g6-ISA1-TRg-15",
"IMP4g6-RRP1-NRg-1",
"IMP4g6-MES1-NRg-1",
"IMP4g6-SEC13-NRg-5",
"IMP4g6-MCM2-NRg-2",
"IMP4g6-ALA1-TRg-4",
"IMP4g6-MTG2-TRg-5",
"IMP4g6-TIF35-NRg-3",
"IMP4g6-NSE1-TRg-3",
"IMP4g6-NSE1-TRg-4",
"IMP4g6-MOB2-NRg-6",
"IMP4g6-VRG4-NRg-3",
"IMP4g6-PRP9-TRg-3",
"IMP4g6-HYM1-TRg-5",
"IMP4g6-POP1-TRg-5",
"IMP4g6-POP1-TRg-9",
"IMP4g6-RPL17A-TRg-1",
"IMP4g6-SLD2-TRg-1",
"IMP4g6-CDC48-NRg-7",
"IMP4g6-FHL1-NRg-2",
"IMP4g6-BET3-NRg-7",
"IMP4g6-MAK21-TRg-1",
"IMP4g6-BRN1-TRg-4",
"IMP4g6-FBA1-NRg-3",
"IMP4g6-CDC42-TRg-6",
"IMP4g6-CDC42-TRg-7",
"IMP4g6-COG4-NRg-1",
"IMP4g6-ATP3-NRg-3",
"IMP4g6-ATP3-NRg-2",
"IMP4g6-SMP3-TRg-5",
"IMP4g6-CFT2-NRg-2",
"IMP4g6-FAS2-TRg-5",
"IMP4g6-DBP2-NRg-3",
"IMP4g6-DBP2-NRg-2",
"IMP4g6-MPS2-NRg-4",
"IMP4g6-ARC35-TRg-2",
"IMP4g6-ARC35-TRg-5",
"IMP4g6-MRD1-TRg-1",
"IMP4g6-RLP7-TRg-1",
"IMP4g6-SPC34-TRg-1",
"IMP4g6-CDC45-TRg-2",
"IMP4g6-GCD6-TRg-3",
"IMP4g6-GCD6-TRg-4",
"IMP4g6-YPT6-NRg-2",
"IMP4g6-RPS13-TRg-2",
"IMP4g6-IPI3-TRg-3",
"IMP4g6-TIF5-NRg-9",
"IMP4g6-TIF5-NRg-7",
"IMP4g6-TIF5-NRg-6",
"IMP4g6-NAB3-TRg-3",
"IMP4g6-GCD2-TRg-1",
"IMP4g6-UBA1-TRg-2",
"IMP4g6-SLD3-TRg-6",
"IMP4g6-LCB1-TRg-5",
"IMP4g6-TOA2-TRg-6",
"IMP4g6-TOA2-TRg-1",
"IMP4g6-TOA2-TRg-3",
"IMP4g6-LSM2-TRg-1",
"IMP4g6-YML6-TRg-13",
"IMP4g6-YML6-TRg-12",
"IMP4g6-UTP15-NRg-1",
"IMP4g6-TIF6-NRg-8",
"IMP4g6-SUP35-NRg-1",
"IMP4g6-MPP10-NRg-1",
"IMP4g6-SWI3-TRg-7",
"IMP4g6-SSN3-NRg-2",
"IMP4g6-SEC13-NRg-7",
"IMP4g6-RPS15-NRg-3",
"IMP4g6-RPL3-TRg-2",
"IMP4g6-FBA1-NRg-2",
"IMP4g6-FBA1-NRg-1",
"IMP4g6-FBA1-NRg-5",
"IMP4g6-DAM1-TRg-2",
"IMP4g6-NHP2-TRg-2",
"IMP4g6-HCA4-NRg-6",
"IMP4g6-PRE3-TRg-4",
"IMP4g6-DBP5-NRg-4",
"IMP4g6-SPT6-NRg-4",
"IMP4g6-SPT6-NRg-2",
"IMP4g6-RPL18A-TRg-4",
"IMP4g6-KSH1-TRg-1",
"IMP4g6-KSH1-TRg-3",
"IMP4g6-IPI3-NRg-1",
"IMP4g6-PGA2-TRg-8",
"IMP4g6-RPL18A-TRg-2",
"IMP4g6-RPL33A-NRg-6",
"IMP4g6-TAF12-NRg-2",
"IMP4g6-USE1-TRg-5",
"IMP4g6-YNL114C-TRg-1",
"IMP4g6-SMC5-TRg-7",
"IMP4g6-SMC5-TRg-6",
"IMP4g6-RSC58-TRg-1",
"IMP4g6-CTF13-TRg-2",
"IMP4g6-NAB2-NRg-2",
"IMP4g6-MCM7-TRg-4",
"IMP4g6-BCP1-NRg-5",
"IMP4g6-STU2-TRg-3",
"IMP4g6-SEC21-NRg-6",
"IMP4g6-SEC21-NRg-3",
"IMP4g6-RPL1B-TRg-3",
"IMP4g6-SEC20-NRg-2",
"IMP4g6-VMA3-NRg-2",
"IMP4g6-SEC23-NRg-5",
"IMP4g6-CDC28-TRg-4",
"IMP4g6-RPN12-NRg-11",
"IMP4g6-PUP3-TRg-3",
"IMP4g6-SEC31-TRg-2",
"IMP4g6-SED5-TRg-6",
"IMP4g6-SED5-TRg-5",
"IMP4g6-RPL33A-TRg-1",
"IMP4g6-RPL33A-TRg-2",
"IMP4g6-MRPL11-TRg-2",
"IMP4g6-RTP1-NRg-2",
"IMP4g6-NUG1-TRg-2",
"IMP4g6-VPH2-TRg-4",
"IMP4g6-COP1-NRg-3",
"IMP4g6-CRM1-NRg-1",
"IMP4g6-RPL5-NRg-4",
"IMP4g6-SNU13-NRg-4",
"IMP4g6-PFS2-TRg-3",
"IMP4g6-MPP10-TRg-2",
"IMP4g6-TSR4-NRg-2",
"IMP4g6-RSC2-TRg-1",
"IMP4g6-SEC65-TRg-2",
"IMP4g6-SMI1-NRg-1",
"IMP4g6-RTT105-NRg-4",
"IMP4g6-VMA5-TRg-3",
"IMP4g6-VMA5-TRg-5",
"IMP4g6-RRP1-TRg-3",
"IMP4g6-CLC1-TRg-2",
"IMP4g6-GCD6-NRg-1",
"IMP4g6-GCD6-NRg-2",
"IMP4g6-PXR1-TRg-1",
"IMP4g6-CDC14-NRg-1",
"IMP4g6-PCF11-TRg-6",
"IMP4g6-PCF11-TRg-5",
"IMP4g6-PCF11-TRg-4",
"IMP4g6-SEC31-NRg-1",
"IMP4g6-RRP5-NRg-1",
"IMP4g6-PRE10-TRg-5",
"IMP4g6-PRE10-TRg-1",
"IMP4g6-RPS5-TRg-2",
"IMP4g6-NSP1-TRg-4",
"IMP4g6-PRP38-TRg-4",
"IMP4g6-RCF1-NRg-5",
"IMP4g6-RSC3-TRg-4",
"IMP4g6-RSC3-TRg-5",
"IMP4g6-RSC3-TRg-6",
"IMP4g6-HTA1-NRg-12",
"IMP4g6-HTA1-NRg-11",
"IMP4g6-UTP23-TRg-2",
"IMP4g6-GCD7-NRg-1",
"IMP4g6-GCD7-NRg-2",
"IMP4g6-GCD7-NRg-6",
"IMP4g6-GAL11-NRg-2",
"IMP4g6-GAL11-NRg-9",
"IMP4g6-PHO4-TRg-5",
"IMP4g6-SNP1-NRg-3",
"IMP4g6-RPC37-TRg-5",
"IMP4g6-CRM1-TRg-5",
"IMP4g6-CRM1-TRg-2",
"IMP4g6-ASK1-TRg-7",
"IMP4g6-STU2-NRg-4",
"IMP4g6-NEO1-NRg-3",
"IMP4g6-GAL11-TRg-5",
"IMP4g6-GAL11-TRg-7",
"IMP4g6-SAM50-NRg-3",
"IMP4g6-CSL4-TRg-2",
"IMP4g6-CCT5-TRg-2",
"IMP4g6-POL30-NRg-1",
"IMP4g6-MED4-TRg-4",
"IMP4g6-MED4-TRg-3",
"IMP4g6-MED4-TRg-2",
"IMP4g6-GDI1-TRg-4",
"IMP4g6-GDI1-TRg-3",
"IMP4g6-REB1-TRg-6",
"IMP4g6-MRPL37-NRg-2",
"IMP4g6-NOC3-TRg-3",
"IMP4g6-SPC97-TRg-3",
"IMP4g6-IPP1-TRg-3",
"IMP4g6-IPP1-TRg-2",
"IMP4g6-PTI1-TRg-3",
"IMP4g6-PTI1-TRg-5",
"IMP4g6-RFC5-NRg-1",
"IMP4g6-CDC24-TRg-1",
"IMP4g6-CDC24-TRg-3",
"IMP4g6-CDC24-TRg-5",
"IMP4g6-CDC24-TRg-6",
"IMP4g6-UTP23-TRg-6",
"IMP4g6-UTP23-TRg-4",
"IMP4g6-UTP23-TRg-1",
"IMP4g6-RHO3-NRg-4",
"IMP4g6-TRS23-NRg-1",
"IMP4g6-TRS23-NRg-3",
"IMP4g6-RSP5-TRg-2",
"IMP4g6-RSP5-TRg-1",
"IMP4g6-SDA1-NRg-1",
"IMP4g6-KAP95-TRg-8",
"IMP4g6-ACO1-TRg-6",
"IMP4g6-HTA1-NRg-3",
"IMP4g6-HTA1-NRg-2",
"IMP4g6-SPN1-TRg-1",
"IMP4g6-MOT1-NRg-7",
"IMP4g6-RPL17A-NRg-4",
"IMP4g6-ADA2-TRg-4",
"IMP4g6-SFH1-NRg-1",
"IMP4g6-SPC97-NRg-5",
"IMP4g6-PRP22-TRg-3",
"IMP4g6-SEN15-TRg-2",
"IMP4g6-RPL3-NRg-2",
"IMP4g6-ISD11-NRg-2",
"IMP4g6-HEM12-TRg-8",
"IMP4g6-SEC10-TRg-1",
"IMP4g6-HTB1-TRg-7",
"IMP4g6-TTI2-TRg-1",
"IMP4g6-ACP1-TRg-2",
"IMP4g6-ACP1-TRg-4",
"IMP4g6-GAL11-NRg-10",
"IMP4g6-UTP22-TRg-2",
"IMP4g6-MST1-NRg-5",
"IMP4g6-RIB7-NRg-2",
"IMP4g6-MCD1-TRg-6",
"IMP4g6-MCD1-TRg-5",
"IMP4g6-GPI8-NRg-2",
"IMP4g6-THS1-TRg-2",
"IMP4g6-RRP7-TRg-2",
"IMP4g6-RRP7-TRg-5",
"IMP4g6-SMX2-NRg-7",
"IMP4g6-RRP45-TRg-5",
"IMP4g6-RRP45-TRg-4",
"IMP4g6-CNS1-TRg-2",
"IMP4g6-FBP1-NRg-9",
"IMP4g6-GCD11-NRg-1",
"IMP4g6-RPL10-TRg-2",
"IMP4g6-NUP192-TRg-4",
"IMP4g6-NUP145-NRg-4",
"IMP4g6-HEM12-TRg-6",
"IMP4g6-PLC1-TRg-3",
"IMP4g6-RPA43-TRg-1",
"IMP4g6-RPB7-NRg-2",
"IMP4g6-RPB7-NRg-3",
"IMP4g6-NSL1-NRg-1",
"IMP4g6-UTP6-TRg-3",
"IMP4g6-UTP6-TRg-1",
"IMP4g6-YJU2-TRg-5",
"IMP4g6-FRS2-NRg-5",
"IMP4g6-TIF35-NRg-2",
"IMP4g6-GPI15-TRg-1",
"IMP4g6-NOP1-NRg-5",
"IMP4g6-GPI15-TRg-4",
"IMP4g6-COG4-TRg-1",
"IMP4g6-TFA1-TRg-1",
"IMP4g6-RHO1-NRg-2",
"IMP4g6-RHO1-NRg-1",
"IMP4g6-CDC55-NRg-2",
"IMP4g6-IDI1-NRg-7",
"IMP4g6-RPL32-TRg-5",
"IMP4g6-RPB5-TRg-4",
"IMP4g6-DIP2-TRg-5",
"IMP4g6-DIP2-TRg-1",
"IMP4g6-RPC40-TRg-2",
"IMP4g6-CDC6-TRg-5",
"IMP4g6-CDC6-TRg-3",
"IMP4g6-DAD2-TRg-2",
"IMP4g6-RVS161-TRg-2",
"IMP4g6-RVS161-TRg-1",
"IMP4g6-SUP45-NRg-3",
"IMP4g6-SRB6-NRg-5",
"IMP4g6-RPC11-TRg-4",
"IMP4g6-RKI1-TRg-8",
"IMP4g6-NIP7-TRg-3",
"IMP4g6-RPL33A-NRg-12",
"IMP4g6-SAM50-TRg-4",
"IMP4g6-NOP4-NRg-1",
"IMP4g6-NOP4-NRg-3",
"IMP4g6-SMX2-TRg-5",
"IMP4g6-POL12-NRg-2",
"IMP4g6-BMS1-NRg-2",
"IMP4g6-RPA190-TRg-5",
"IMP4g6-ALG14-NRg-4",
"IMP4g6-ALG14-NRg-1",
"IMP4g6-PRE5-NRg-1",
"IMP4g6-BIG1-NRg-2",
"IMP4g6-TFA2-TRg-4",
"IMP4g6-IMP4-TRg-6",
"IMP4g6-PAN1-NRg-1",
"IMP4g6-UTP13-TRg-2",
"IMP4g6-KAE1-NRg-3",
"IMP4g6-ERG20-TRg-1",
"IMP4g6-CDC20-TRg-6",
"IMP4g6-PWP2-NRg-2",
"IMP4g6-COG1-NRg-1",
"IMP4g6-RPL1B-TRg-4",
"IMP4g6-RPL1B-TRg-7",
"IMP4g6-UTP20-TRg-3",
"IMP4g6-UTP20-TRg-4",
"IMP4g6-RPL25-TRg-4",
"IMP4g6-RPL25-TRg-2",
"IMP4g6-MCM7-NRg-1",
"IMP4g6-MRP49-TRg-5",
"IMP4g6-ERO1-NRg-3",
"IMP4g6-UTP5-TRg-7",
"IMP4g6-MCM4-NRg-1",
"IMP4g6-PRE3-NRg-1",
"IMP4g6-FCF1-NRg-1",
"IMP4g6-CUS1-NRg-1",
"IMP4g6-PSF1-TRg-2",
"IMP4g6-BCP1-TRg-2",
"IMP4g6-PAN1-TRg-1",
"IMP4g6-PAN1-TRg-3",
"IMP4g6-PAN1-TRg-4",
"IMP4g6-VPS3-TRg-2",
"IMP4g6-YIL060W-NRg-1",
"IMP4g6-VPS53-NRg-1",
"IMP4g6-CYR1-TRg-4",
"IMP4g6-CYR1-TRg-7",
"IMP4g6-MPS1-NRg-1",
"IMP4g6-SRP1-TRg-5",
"IMP4g6-SRP1-TRg-4",
"IMP4g6-TAF12-TRg-2",
"IMP4g6-TAF12-TRg-3",
"IMP4g6-POP4-TRg-1",
"IMP4g6-SPT16-TRg-1",
"IMP4g6-NUP82-TRg-4",
"IMP4g6-DML1-TRg-3",
"IMP4g6-RPA43-NRg-3",
"IMP4g6-STU2-NRg-3",
"IMP4g6-POP4-NRg-4",
"IMP4g6-MCD1-TRg-2",
"IMP4g6-RPS3-NRg-4",
"IMP4g6-PRP9-TRg-4",
"IMP4g6-RPP1-NRg-2",
"IMP4g6-MTR2-NRg-11",
"IMP4g6-GCD11-TRg-1",
"IMP4g6-RPF1-TRg-3",
"IMP4g6-SUB2-NRg-4",
"IMP4g6-GPI15-TRg-3",
"IMP4g6-ERG9-TRg-6",
"IMP4g6-RPT2-NRg-1",
"IMP4g6-YOS1-NRg-3",
"IMP4g6-SCM3-TRg-4",
"IMP4g6-SCM3-TRg-6",
"IMP4g6-RLP7-NRg-1",
"IMP4g6-TFB2-NRg-4",
"IMP4g6-IMP4-TRg-1",
"IMP4g6-IMP4-TRg-3",
"IMP4g6-PRE4-TRg-3",
"IMP4g6-SUB2-TRg-3",
"IMP4g6-RPP0-NRg-4",
"IMP4g6-RPP0-NRg-3",
"IMP4g6-TOM40-TRg-4",
"IMP4g6-FUR1-NRg-12",
"IMP4g6-TOM40-TRg-2",
"IMP4g6-VMA11-NRg-4",
"IMP4g6-PGS1-NRg-4",
"IMP4g6-URB1-TRg-4",
"IMP4g6-ARP4-TRg-3",
"IMP4g6-RPT3-TRg-3",
"IMP4g6-SUI3-TRg-3",
"IMP4g6-RFC5-NRg-2",
"IMP4g6-RRP14-TRg-2",
"IMP4g6-SCC2-TRg-1",
"IMP4g6-SSC1-TRg-3",
"IMP4g6-RRP9-TRg-3",
"IMP4g6-MOT1-NRg-9",
"IMP4g6-RPL42A-NRg-2",
"IMP4g6-SEC16-TRg-7",
"IMP4g6-IMP4-NRg-2",
"IMP4g6-YEF3-NRg-4",
"IMP4g6-PUP1-TRg-1",
"IMP4g6-UTP22-TRg-6",
"IMP4g6-DBP2-NRg-4",
"IMP4g6-PRE2-TRg-7",
"IMP4g6-ATP16-TRg-6",
"IMP4g6-UTP13-TRg-4",
"IMP4g6-DOP1-NRg-4",
"IMP4g6-TIM44-TRg-3",
"IMP4g6-ATP16-TRg-2",
"IMP4g6-ENP1-NRg-3",
"IMP4g6-NAF1-TRg-3",
"IMP4g6-COG4-TRg-2",
"IMP4g6-SOG2-TRg-7",
"IMP4g6-YDR341C-TRg-3",
"IMP4g6-YMR290W-A-TRg-10",
"IMP4g6-NUP192-NRg-9",
"IMP4g6-RPS31-NRg-8",
"IMP4g6-SPC97-NRg-6",
"IMP4g6-EBP2-NRg-1",
"IMP4g6-CDC48-TRg-5",
"IMP4g6-RPT1-TRg-4",
"IMP4g6-ULP1-NRg-2",
"IMP4g6-RPN3-TRg-6",
"IMP4g6-RPT1-TRg-5",
"IMP4g6-KRE5-TRg-2",
"IMP4g6-TBF1-NRg-8",
"IMP4g6-UTP22-NRg-4",
"IMP4g6-SSC1-NRg-4",
"IMP4g6-REB1-TRg-4",
"IMP4g6-CDC48-NRg-9",
"IMP4g6-FAS2-TRg-8",
"IMP4g6-TAO3-TRg-8",
"IMP4g6-CKS1-TRg-5",
"IMP4g6-YLR379W-TRg-7",
"IMP4g6-TEN1-NRg-2",
"IMP4g6-RPL42A-TRg-2",
"IMP4g6-SEC27-TRg-4",
"IMP4g6-TBF1-NRg-4",
"IMP4g6-RPT1-NRg-6",
"IMP4g6-COG1-TRg-3",
"IMP4g6-SUI1-TRg-6",
"IMP4g6-TIM23-TRg-6",
"IMP4g6-CDC48-NRg-6",
"IMP4g6-EPL1-TRg-5",
"IMP4g6-RPT5-TRg-8",
"IMP4g6-ATP16-NRg-4",
"IMP4g6-RPN6-TRg-3",
"IMP4g6-ERG9-NRg-6",
"IMP4g6-SMX3-TRg-1",
"IMP4g6-NCB2-NRg-3",
"IMP4g6-SEC16-NRg-12",
"IMP4g6-RPN6-TRg-2",
"IMP4g6-REB1-NRg-4",
"IMP4g6-ATP16-TRg-9",
"IMP4g6-ERG9-NRg-7",
"DIP2g5-RPL15A-NRg-4",
"DIP2g5-RPL15A-NRg-5",
"DIP2g5-KRE33-TRg-1",
"DIP2g5-PMI40-NRg-1",
"DIP2g5-NOP19-NRg-3",
"DIP2g5-SRP14-NRg-4",
"DIP2g5-SEC27-TRg-2",
"DIP2g5-GPI14-TRg-3",
"DIP2g5-PAH1-TRg-7",
"DIP2g5-PAH1-TRg-6",
"DIP2g5-PAH1-TRg-5",
"DIP2g5-PAH1-TRg-3",
"DIP2g5-COG3-TRg-1",
"DIP2g5-HTS1-NRg-5",
"DIP2g5-MSN5-TRg-7",
"DIP2g5-ERG26-TRg-1",
"DIP2g5-SMD2-TRg-5",
"DIP2g5-SMD2-TRg-4",
"DIP2g5-SMD2-TRg-1",
"DIP2g5-PRE7-TRg-4",
"DIP2g5-PRE7-TRg-7",
"DIP2g5-SEC6-TRg-3",
"DIP2g5-ESF2-NRg-1",
"DIP2g5-ESF2-NRg-3",
"DIP2g5-AFG2-TRg-2",
"DIP2g5-RRP36-TRg-3",
"DIP2g5-RRP36-TRg-5",
"DIP2g5-GCR1-NRg-2",
"DIP2g5-PRE4-NRg-4",
"DIP2g5-PRE4-NRg-9",
"DIP2g5-DSN1-NRg-2",
"DIP2g5-GPI11-TRg-3",
"DIP2g5-POP3-TRg-1",
"DIP2g5-MNE1-TRg-5",
"DIP2g5-RRP12-NRg-1",
"DIP2g5-RSC6-TRg-2",
"DIP2g5-CDC25-TRg-1",
"DIP2g5-CDC25-TRg-9",
"DIP2g5-YPP1-NRg-3",
"DIP2g5-NFS1-NRg-9",
"DIP2g5-NFS1-NRg-8",
"DIP2g5-UBA2-TRg-1",
"DIP2g5-ARP2-NRg-3",
"DIP2g5-MAK16-TRg-1",
"DIP2g5-CEP3-NRg-1",
"DIP2g5-GUK1-TRg-5",
"DIP2g5-GUK1-TRg-2",
"DIP2g5-GPI12-NRg-6",
"DIP2g5-RPS5-NRg-5",
"DIP2g5-RPS5-NRg-2",
"DIP2g5-RPC19-NRg-1",
"DIP2g5-TIM54-TRg-1",
"DIP2g5-TEN1-TRg-2",
"DIP2g5-SAH1-NRg-4",
"DIP2g5-SAH1-NRg-5",
"DIP2g5-SAH1-NRg-3",
"DIP2g5-ATP15-NRg-5",
"DIP2g5-SCD5-TRg-5",
"DIP2g5-ARB1-NRg-2",
"DIP2g5-ARB1-NRg-4",
"DIP2g5-PUP2-TRg-1",
"DIP2g5-CCT8-TRg-2",
"DIP2g5-MCM4-TRg-1",
"DIP2g5-LSM4-TRg-1",
"DIP2g5-NOP53-NRg-1",
"DIP2g5-ATP3-TRg-4",
"DIP2g5-AFG2-NRg-3",
"DIP2g5-PRO3-NRg-3",
"DIP2g5-NRD1-NRg-10",
"DIP2g5-SEC61-TRg-2",
"DIP2g5-RHO3-TRg-4",
"DIP2g5-SNF2-TRg-6",
"DIP2g5-SMD2-NRg-3",
"DIP2g5-RSC4-TRg-2",
"DIP2g5-RSC4-TRg-1",
"DIP2g5-TIF34-TRg-2",
"DIP2g5-BET1-NRg-1",
"DIP2g5-CDC8-NRg-2",
"DIP2g5-PRP42-TRg-2",
"DIP2g5-RRB1-TRg-2",
"DIP2g5-SPC24-TRg-1",
"DIP2g5-ILS1-NRg-1",
"DIP2g5-GFA1-TRg-2",
"DIP2g5-SEC21-NRg-10",
"DIP2g5-RPC10-NRg-1",
"DIP2g5-RPB10-TRg-3",
"DIP2g5-RPB10-TRg-2",
"DIP2g5-YNL181W-TRg-1",
"DIP2g5-RAD3-NRg-1",
"DIP2g5-NOP10-TRg-1",
"DIP2g5-BFR2-TRg-3",
"DIP2g5-MCM2-TRg-6",
"DIP2g5-MCM2-TRg-4",
"DIP2g5-MPP10-TRg-1",
"DIP2g5-RET2-TRg-4",
"DIP2g5-RET2-TRg-1",
"DIP2g5-RPS2-NRg-1",
"DIP2g5-RPS2-NRg-2",
"DIP2g5-ORC4-NRg-3",
"DIP2g5-TIP20-TRg-7",
"DIP2g5-SMT3-TRg-1",
"DIP2g5-MSS18-NRg-6",
"DIP2g5-YEF3-NRg-9",
"DIP2g5-ASK1-NRg-1",
"DIP2g5-SMC1-TRg-1",
"DIP2g5-NIP1-NRg-1",
"DIP2g5-RPP1-NRg-1",
"DIP2g5-YDJ1-TRg-6",
"DIP2g5-SUB2-NRg-1",
"DIP2g5-TIM10-NRg-8",
"DIP2g5-TIM10-NRg-4",
"DIP2g5-TIM10-NRg-7",
"DIP2g5-SKI6-TRg-4",
"DIP2g5-TUB4-TRg-1",
"DIP2g5-CDC37-NRg-2",
"DIP2g5-ISD11-TRg-3",
"DIP2g5-YOS1-TRg-4",
"DIP2g5-SSC1-TRg-6",
"DIP2g5-MTR3-TRg-5",
"DIP2g5-MTR3-TRg-6",
"DIP2g5-TFA1-TRg-2",
"DIP2g5-CDC3-NRg-3",
"DIP2g5-ERG25-TA-18",
"DIP2g5-RPB11-TRg-4",
"DIP2g5-RPB11-TRg-1",
"DIP2g5-RPB11-TRg-2",
"DIP2g5-DED1-TRg-3",
"DIP2g5-DED1-TRg-1",
"DIP2g5-DED1-TRg-6",
"DIP2g5-DED1-TRg-4",
"DIP2g5-RPL10-NRg-5",
"DIP2g5-RPL10-NRg-4",
"DIP2g5-EFB1-NRg-1",
"DIP2g5-EFB1-NRg-5",
"DIP2g5-EFB1-NRg-4",
"DIP2g5-RPT3-NRg-1",
"DIP2g5-SAC6-TRg-8",
"DIP2g5-SAC6-TRg-4",
"DIP2g5-SAC6-TRg-5",
"DIP2g5-SAC6-TRg-3",
"DIP2g5-DIM1-TRg-5",
"DIP2g5-DIM1-TRg-7",
"DIP2g5-RPC17-NRg-1",
"DIP2g5-RPC17-NRg-2",
"DIP2g5-YDR341C-TRg-1",
"DIP2g5-RAP1-NRg-8",
"DIP2g5-RAP1-NRg-5",
"DIP2g5-RAP1-NRg-2",
"DIP2g5-SEC26-NRg-3",
"DIP2g5-SPP41-TRg-3",
"DIP2g5-TAP42-NRg-1",
"DIP2g5-PGA2-TRg-6",
"DIP2g5-BRL1-TRg-1",
"DIP2g5-FOL2-TRg-1",
"DIP2g5-NAB3-NRg-5",
"DIP2g5-SNF4-TRg-4",
"DIP2g5-HRR25-TRg-2",
"DIP2g5-TRS23-TRg-4",
"DIP2g5-CTR86-TRg-4",
"DIP2g5-RPB5-TRg-5",
"DIP2g5-SPN1-NRg-2",
"DIP2g5-SPN1-NRg-1",
"DIP2g5-SEC61-NRg-1",
"DIP2g5-SEC61-NRg-7",
"DIP2g5-TUS1-TRg-3",
"DIP2g5-OLE1-NRg-2",
"DIP2g5-AFG2-TRg-1",
"DIP2g5-TOA2-NRg-1",
"DIP2g5-USO1-TRg-1",
"DIP2g5-UTP22-NRg-2",
"DIP2g5-RIB1-TRg-3",
"DIP2g5-RIB1-TRg-7",
"DIP2g5-RIB1-TRg-4",
"DIP2g5-COG1-TRg-1",
"DIP2g5-RPL32-NRg-2",
"DIP2g5-GLC7-NRg-3",
"DIP2g5-GLC7-NRg-4",
"DIP2g5-HSF1-TRg-2",
"DIP2g5-DAM1-NRg-5",
"DIP2g5-SEC18-TRg-4",
"DIP2g5-SEC18-TRg-5",
"DIP2g5-PAB1-NRg-3",
"DIP2g5-POP8-TRg-2",
"DIP2g5-PAB1-NRg-4",
"DIP2g5-BIG1-TRg-4",
"DIP2g5-BIG1-TRg-5",
"DIP2g5-BIG1-TRg-6",
"DIP2g5-RPO41-NRg-1",
"DIP2g5-RVB2-NRg-2",
"DIP2g5-PET117-NRg-8",
"DIP2g5-VPS45-NRg-9",
"DIP2g5-YCG1-NRg-1",
"DIP2g5-NOC4-NRg-1",
"DIP2g5-NMD3-NRg-2",
"DIP2g5-DRS1-TRg-2",
"DIP2g5-HTB1-NRg-2",
"DIP2g5-IPI1-TRg-2",
"DIP2g5-SEC18-NRg-1",
"DIP2g5-SEC18-NRg-2",
"DIP2g5-JIP5-NRg-2",
"DIP2g5-YPT1-TRg-3",
"DIP2g5-YPT1-TRg-2",
"DIP2g5-CLF1-NRg-2",
"DIP2g5-SNF2-NRg-7",
"DIP2g5-SNF2-NRg-4",
"DIP2g5-RPL25-NRg-1",
"DIP2g5-NOP56-TRg-1",
"DIP2g5-NOP56-TRg-2",
"DIP2g5-TRS31-TRg-1",
"DIP2g5-DBF4-TRg-2",
"DIP2g5-DBF4-TRg-1",
"DIP2g5-RPC19-TRg-4",
"DIP2g5-RPC19-TRg-6",
"DIP2g5-RPC19-TRg-3",
"DIP2g5-ROK1-NRg-1",
"DIP2g5-CDC33-TRg-4",
"DIP2g5-DHR2-TRg-3",
"DIP2g5-RRP42-NRg-5",
"DIP2g5-CLF1-TRg-1",
"DIP2g5-ERG11-NA-16",
"DIP2g5-VAS1-NRg-4",
"DIP2g5-PIK1-NRg-2",
"DIP2g5-SAR1-NRg-7",
"DIP2g5-SAR1-NRg-4",
"DIP2g5-RPS3-TRg-1",
"DIP2g5-YTM1-TRg-2",
"DIP2g5-SUI3-NRg-5",
"DIP2g5-SUI3-NRg-2",
"DIP2g5-RRP7-TRg-4",
"DIP2g5-RRP7-TRg-6",
"DIP2g5-NIP7-TRg-2",
"DIP2g5-MDM35-TRg-1",
"DIP2g5-ALA1-NRg-1",
"DIP2g5-DOA4-NRg-2",
"DIP2g5-RPS13-NRg-1",
"DIP2g5-YSF3-TRg-2",
"DIP2g5-RPS2-NRg-11",
"DIP2g5-SSL1-TRg-10",
"DIP2g5-NIP7-TRg-1",
"DIP2g5-LST8-NRg-1",
"DIP2g5-TAF4-TRg-3",
"DIP2g5-HAS1-TRg-2",
"DIP2g5-GLC7-TRg-2",
"DIP2g5-CDC45-NRg-1",
"DIP2g5-SEC22-NRg-8",
"DIP2g5-YOS1-TRg-2",
"DIP2g5-RBA50-TRg-3",
"DIP2g5-SPP41-NRg-2",
"DIP2g5-PRP46-TRg-2",
"DIP2g5-PGA2-NRg-1",
"DIP2g5-CBF5-TRg-3",
"DIP2g5-TCP1-NRg-3",
"DIP2g5-TCP1-NRg-2",
"DIP2g5-ERG26-NRg-2",
"DIP2g5-ERG26-NRg-4",
"DIP2g5-MES1-TRg-5",
"DIP2g5-HTS1-TRg-2",
"DIP2g5-SSS1-TRg-3",
"DIP2g5-SSS1-TRg-2",
"DIP2g5-SYS1-TRg-7",
"DIP2g5-SYS1-TRg-2",
"DIP2g5-SYS1-TRg-1",
"DIP2g5-BFR2-TRg-1",
"DIP2g5-EOS1-TRg-3",
"DIP2g5-TAF4-NRg-1",
"DIP2g5-ARL3-NRg-8",
"DIP2g5-RPN5-NRg-1",
"DIP2g5-TIM9-NRg-2",
"DIP2g5-NUP57-NRg-3",
"DIP2g5-VPS4-TRg-1",
"DIP2g5-CDC3-TRg-4",
"DIP2g5-BBP1-NRg-1",
"DIP2g5-BBP1-NRg-2",
"DIP2g5-USE1-NRg-3",
"DIP2g5-CCT7-TRg-1",
"DIP2g5-SAH1-TRg-3",
"DIP2g5-CHS2-TRg-1",
"DIP2g5-DPM1-TRg-2",
"DIP2g5-BBP1-TRg-1",
"DIP2g5-NRD1-TRg-4",
"DIP2g5-RPB3-NRg-1",
"DIP2g5-PHO85-NRg-6",
"DIP2g5-SNF6-TRg-6",
"DIP2g5-PRP38-NRg-2",
"DIP2g5-OAR1-NRg-3",
"DIP2g5-ROX3-NRg-1",
"DIP2g5-YPP1-TRg-6",
"DIP2g5-CBF2-NRg-8",
"DIP2g5-SPT6-TRg-5",
"DIP2g5-SEC10-NRg-1",
"DIP2g5-NSL1-NRg-3",
"DIP2g5-NRD1-NRg-8",
"DIP2g5-RPB3-TRg-1",
"DIP2g5-NRD1-NRg-4",
"DIP2g5-RVB1-TRg-2",
"DIP2g5-TIF5-NRg-8",
"DIP2g5-EOS1-NRg-1",
"DIP2g5-ERG25-NA-26",
"DIP2g5-MSL5-NRg-4",
"DIP2g5-SEC24-TRg-2",
"DIP2g5-RPL30-NRg-5",
"DIP2g5-SNU71-NRg-3",
"DIP2g5-CDC33-NRg-1",
"DIP2g5-RPN6-TRg-4",
"DIP2g5-NAB2-TRg-4",
"DIP2g5-NAB2-TRg-6",
"DIP2g5-YTM1-NRg-1",
"DIP2g5-OLE1-TRg-8",
"DIP2g5-OLE1-TRg-1",
"DIP2g5-UTP7-TRg-4",
"DIP2g5-ACT1-NRg-6",
"DIP2g5-RPL18A-NRg-3",
"DIP2g5-BRX1-NRg-1",
"DIP2g5-NAF1-TRg-8",
"DIP2g5-NAF1-TRg-6",
"DIP2g5-NAF1-TRg-4",
"DIP2g5-CDC8-TRg-2",
"DIP2g5-NSE4-TRg-1",
"DIP2g5-PAB1-NRg-2",
"DIP2g5-PRP43-TRg-4",
"DIP2g5-SEC2-NRg-3",
"DIP2g5-SEC2-NRg-6",
"DIP2g5-MPP10-NRg-5",
"DIP2g5-YDR355C-TRg-2",
"DIP2g5-YLR339C-TRg-9",
"DIP2g5-SNM1-TRg-2",
"DIP2g5-ALR1-NRg-4",
"DIP2g5-ALR1-NRg-1",
"DIP2g5-ALR1-NRg-3",
"DIP2g5-RPL10-TRg-1",
"DIP2g5-RPL28-TRg-2",
"DIP2g5-UTP25-TRg-1",
"DIP2g5-POB3-TRg-1",
"DIP2g5-POB3-TRg-3",
"DIP2g5-POB3-TRg-2",
"DIP2g5-MED11-TRg-1",
"DIP2g5-ISA1-TRg-15",
"DIP2g5-RRP1-NRg-1",
"DIP2g5-MES1-NRg-1",
"DIP2g5-SEC13-NRg-5",
"DIP2g5-MCM2-NRg-2",
"DIP2g5-ALA1-TRg-4",
"DIP2g5-MTG2-TRg-5",
"DIP2g5-TIF35-NRg-3",
"DIP2g5-NSE1-TRg-3",
"DIP2g5-NSE1-TRg-4",
"DIP2g5-MOB2-NRg-6",
"DIP2g5-VRG4-NRg-3",
"DIP2g5-PRP9-TRg-3",
"DIP2g5-HYM1-TRg-5",
"DIP2g5-POP1-TRg-5",
"DIP2g5-POP1-TRg-9",
"DIP2g5-RPL17A-TRg-1",
"DIP2g5-SLD2-TRg-1",
"DIP2g5-CDC48-NRg-7",
"DIP2g5-FHL1-NRg-2",
"DIP2g5-BET3-NRg-7",
"DIP2g5-MAK21-TRg-1",
"DIP2g5-BRN1-TRg-4",
"DIP2g5-FBA1-NRg-3",
"DIP2g5-CDC42-TRg-6",
"DIP2g5-CDC42-TRg-7",
"DIP2g5-COG4-NRg-1",
"DIP2g5-ATP3-NRg-3",
"DIP2g5-ATP3-NRg-2",
"DIP2g5-SMP3-TRg-5",
"DIP2g5-CFT2-NRg-2",
"DIP2g5-FAS2-TRg-5",
"DIP2g5-DBP2-NRg-3",
"DIP2g5-DBP2-NRg-2",
"DIP2g5-MPS2-NRg-4",
"DIP2g5-ARC35-TRg-2",
"DIP2g5-ARC35-TRg-5",
"DIP2g5-MRD1-TRg-1",
"DIP2g5-RLP7-TRg-1",
"DIP2g5-SPC34-TRg-1",
"DIP2g5-CDC45-TRg-2",
"DIP2g5-GCD6-TRg-3",
"DIP2g5-GCD6-TRg-4",
"DIP2g5-YPT6-NRg-2",
"DIP2g5-RPS13-TRg-2",
"DIP2g5-IPI3-TRg-3",
"DIP2g5-TIF5-NRg-9",
"DIP2g5-TIF5-NRg-7",
"DIP2g5-TIF5-NRg-6",
"DIP2g5-NAB3-TRg-3",
"DIP2g5-GCD2-TRg-1",
"DIP2g5-UBA1-TRg-2",
"DIP2g5-SLD3-TRg-6",
"DIP2g5-LCB1-TRg-5",
"DIP2g5-TOA2-TRg-6",
"DIP2g5-TOA2-TRg-1",
"DIP2g5-TOA2-TRg-3",
"DIP2g5-LSM2-TRg-1",
"DIP2g5-YML6-TRg-13",
"DIP2g5-YML6-TRg-12",
"DIP2g5-UTP15-NRg-1",
"DIP2g5-TIF6-NRg-8",
"DIP2g5-SUP35-NRg-1",
"DIP2g5-MPP10-NRg-1",
"DIP2g5-SWI3-TRg-7",
"DIP2g5-SSN3-NRg-2",
"DIP2g5-SEC13-NRg-7",
"DIP2g5-RPS15-NRg-3",
"DIP2g5-RPL3-TRg-2",
"DIP2g5-FBA1-NRg-2",
"DIP2g5-FBA1-NRg-1",
"DIP2g5-FBA1-NRg-5",
"DIP2g5-DAM1-TRg-2",
"DIP2g5-NHP2-TRg-2",
"DIP2g5-HCA4-NRg-6",
"DIP2g5-PRE3-TRg-4",
"DIP2g5-DBP5-NRg-4",
"DIP2g5-SPT6-NRg-4",
"DIP2g5-SPT6-NRg-2",
"DIP2g5-RPL18A-TRg-4",
"DIP2g5-KSH1-TRg-1",
"DIP2g5-KSH1-TRg-3",
"DIP2g5-IPI3-NRg-1",
"DIP2g5-PGA2-TRg-8",
"DIP2g5-RPL18A-TRg-2",
"DIP2g5-RPL33A-NRg-6",
"DIP2g5-TAF12-NRg-2",
"DIP2g5-USE1-TRg-5",
"DIP2g5-YNL114C-TRg-1",
"DIP2g5-SMC5-TRg-7",
"DIP2g5-SMC5-TRg-6",
"DIP2g5-RSC58-TRg-1",
"DIP2g5-CTF13-TRg-2",
"DIP2g5-NAB2-NRg-2",
"DIP2g5-MCM7-TRg-4",
"DIP2g5-BCP1-NRg-5",
"DIP2g5-STU2-TRg-3",
"DIP2g5-SEC21-NRg-6",
"DIP2g5-SEC21-NRg-3",
"DIP2g5-RPL1B-TRg-3",
"DIP2g5-SEC20-NRg-2",
"DIP2g5-VMA3-NRg-2",
"DIP2g5-SEC23-NRg-5",
"DIP2g5-CDC28-TRg-4",
"DIP2g5-RPN12-NRg-11",
"DIP2g5-PUP3-TRg-3",
"DIP2g5-SEC31-TRg-2",
"DIP2g5-SED5-TRg-6",
"DIP2g5-SED5-TRg-5",
"DIP2g5-RPL33A-TRg-1",
"DIP2g5-RPL33A-TRg-2",
"DIP2g5-MRPL11-TRg-2",
"DIP2g5-RTP1-NRg-2",
"DIP2g5-NUG1-TRg-2",
"DIP2g5-VPH2-TRg-4",
"DIP2g5-COP1-NRg-3",
"DIP2g5-CRM1-NRg-1",
"DIP2g5-RPL5-NRg-4",
"DIP2g5-SNU13-NRg-4",
"DIP2g5-PFS2-TRg-3",
"DIP2g5-MPP10-TRg-2",
"DIP2g5-TSR4-NRg-2",
"DIP2g5-RSC2-TRg-1",
"DIP2g5-SEC65-TRg-2",
"DIP2g5-SMI1-NRg-1",
"DIP2g5-RTT105-NRg-4",
"DIP2g5-VMA5-TRg-3",
"DIP2g5-VMA5-TRg-5",
"DIP2g5-RRP1-TRg-3",
"DIP2g5-CLC1-TRg-2",
"DIP2g5-GCD6-NRg-1",
"DIP2g5-GCD6-NRg-2",
"DIP2g5-PXR1-TRg-1",
"DIP2g5-CDC14-NRg-1",
"DIP2g5-PCF11-TRg-6",
"DIP2g5-PCF11-TRg-5",
"DIP2g5-PCF11-TRg-4",
"DIP2g5-SEC31-NRg-1",
"DIP2g5-RRP5-NRg-1",
"DIP2g5-PRE10-TRg-5",
"DIP2g5-PRE10-TRg-1",
"DIP2g5-RPS5-TRg-2",
"DIP2g5-NSP1-TRg-4",
"DIP2g5-PRP38-TRg-4",
"DIP2g5-RCF1-NRg-5",
"DIP2g5-RSC3-TRg-4",
"DIP2g5-RSC3-TRg-5",
"DIP2g5-RSC3-TRg-6",
"DIP2g5-HTA1-NRg-12",
"DIP2g5-HTA1-NRg-11",
"DIP2g5-UTP23-TRg-2",
"DIP2g5-GCD7-NRg-1",
"DIP2g5-GCD7-NRg-2",
"DIP2g5-GCD7-NRg-6",
"DIP2g5-GAL11-NRg-2",
"DIP2g5-GAL11-NRg-9",
"DIP2g5-PHO4-TRg-5",
"DIP2g5-SNP1-NRg-3",
"DIP2g5-RPC37-TRg-5",
"DIP2g5-CRM1-TRg-5",
"DIP2g5-CRM1-TRg-2",
"DIP2g5-ASK1-TRg-7",
"DIP2g5-STU2-NRg-4",
"DIP2g5-NEO1-NRg-3",
"DIP2g5-GAL11-TRg-5",
"DIP2g5-GAL11-TRg-7",
"DIP2g5-SAM50-NRg-3",
"DIP2g5-CSL4-TRg-2",
"DIP2g5-CCT5-TRg-2",
"DIP2g5-POL30-NRg-1",
"DIP2g5-MED4-TRg-4",
"DIP2g5-MED4-TRg-3",
"DIP2g5-MED4-TRg-2",
"DIP2g5-GDI1-TRg-4",
"DIP2g5-GDI1-TRg-3",
"DIP2g5-REB1-TRg-6",
"DIP2g5-MRPL37-NRg-2",
"DIP2g5-NOC3-TRg-3",
"DIP2g5-SPC97-TRg-3",
"DIP2g5-IPP1-TRg-3",
"DIP2g5-IPP1-TRg-2",
"DIP2g5-PTI1-TRg-3",
"DIP2g5-PTI1-TRg-5",
"DIP2g5-RFC5-NRg-1",
"DIP2g5-CDC24-TRg-1",
"DIP2g5-CDC24-TRg-3",
"DIP2g5-CDC24-TRg-5",
"DIP2g5-CDC24-TRg-6",
"DIP2g5-UTP23-TRg-6",
"DIP2g5-UTP23-TRg-4",
"DIP2g5-UTP23-TRg-1",
"DIP2g5-RHO3-NRg-4",
"DIP2g5-TRS23-NRg-1",
"DIP2g5-TRS23-NRg-3",
"DIP2g5-RSP5-TRg-2",
"DIP2g5-RSP5-TRg-1",
"DIP2g5-SDA1-NRg-1",
"DIP2g5-KAP95-TRg-8",
"DIP2g5-ACO1-TRg-6",
"DIP2g5-HTA1-NRg-3",
"DIP2g5-HTA1-NRg-2",
"DIP2g5-SPN1-TRg-1",
"DIP2g5-MOT1-NRg-7",
"DIP2g5-RPL17A-NRg-4",
"DIP2g5-ADA2-TRg-4",
"DIP2g5-SFH1-NRg-1",
"DIP2g5-SPC97-NRg-5",
"DIP2g5-PRP22-TRg-3",
"DIP2g5-SEN15-TRg-2",
"DIP2g5-RPL3-NRg-2",
"DIP2g5-ISD11-NRg-2",
"DIP2g5-HEM12-TRg-8",
"DIP2g5-SEC10-TRg-1",
"DIP2g5-HTB1-TRg-7",
"DIP2g5-TTI2-TRg-1",
"DIP2g5-ACP1-TRg-2",
"DIP2g5-ACP1-TRg-4",
"DIP2g5-GAL11-NRg-10",
"DIP2g5-UTP22-TRg-2",
"DIP2g5-MST1-NRg-5",
"DIP2g5-RIB7-NRg-2",
"DIP2g5-MCD1-TRg-6",
"DIP2g5-MCD1-TRg-5",
"DIP2g5-GPI8-NRg-2",
"DIP2g5-THS1-TRg-2",
"DIP2g5-RRP7-TRg-2",
"DIP2g5-RRP7-TRg-5",
"DIP2g5-SMX2-NRg-7",
"DIP2g5-RRP45-TRg-5",
"DIP2g5-RRP45-TRg-4",
"DIP2g5-CNS1-TRg-2",
"DIP2g5-FBP1-NRg-9",
"DIP2g5-GCD11-NRg-1",
"DIP2g5-RPL10-TRg-2",
"DIP2g5-NUP192-TRg-4",
"DIP2g5-NUP145-NRg-4",
"DIP2g5-HEM12-TRg-6",
"DIP2g5-PLC1-TRg-3",
"DIP2g5-RPA43-TRg-1",
"DIP2g5-RPB7-NRg-2",
"DIP2g5-RPB7-NRg-3",
"DIP2g5-NSL1-NRg-1",
"DIP2g5-UTP6-TRg-3",
"DIP2g5-UTP6-TRg-1",
"DIP2g5-YJU2-TRg-5",
"DIP2g5-FRS2-NRg-5",
"DIP2g5-TIF35-NRg-2",
"DIP2g5-GPI15-TRg-1",
"DIP2g5-NOP1-NRg-5",
"DIP2g5-GPI15-TRg-4",
"DIP2g5-COG4-TRg-1",
"DIP2g5-TFA1-TRg-1",
"DIP2g5-RHO1-NRg-2",
"DIP2g5-RHO1-NRg-1",
"DIP2g5-CDC55-NRg-2",
"DIP2g5-IDI1-NRg-7",
"DIP2g5-RPL32-TRg-5",
"DIP2g5-RPB5-TRg-4",
"DIP2g5-DIP2-TRg-5",
"DIP2g5-DIP2-TRg-1",
"DIP2g5-RPC40-TRg-2",
"DIP2g5-CDC6-TRg-5",
"DIP2g5-CDC6-TRg-3",
"DIP2g5-DAD2-TRg-2",
"DIP2g5-RVS161-TRg-2",
"DIP2g5-RVS161-TRg-1",
"DIP2g5-SUP45-NRg-3",
"DIP2g5-SRB6-NRg-5",
"DIP2g5-RPC11-TRg-4",
"DIP2g5-RKI1-TRg-8",
"DIP2g5-NIP7-TRg-3",
"DIP2g5-RPL33A-NRg-12",
"DIP2g5-SAM50-TRg-4",
"DIP2g5-NOP4-NRg-1",
"DIP2g5-NOP4-NRg-3",
"DIP2g5-SMX2-TRg-5",
"DIP2g5-POL12-NRg-2",
"DIP2g5-BMS1-NRg-2",
"DIP2g5-RPA190-TRg-5",
"DIP2g5-ALG14-NRg-4",
"DIP2g5-ALG14-NRg-1",
"DIP2g5-PRE5-NRg-1",
"DIP2g5-BIG1-NRg-2",
"DIP2g5-TFA2-TRg-4",
"DIP2g5-IMP4-TRg-6",
"DIP2g5-PAN1-NRg-1",
"DIP2g5-UTP13-TRg-2",
"DIP2g5-KAE1-NRg-3",
"DIP2g5-ERG20-TRg-1",
"DIP2g5-CDC20-TRg-6",
"DIP2g5-PWP2-NRg-2",
"DIP2g5-COG1-NRg-1",
"DIP2g5-RPL1B-TRg-4",
"DIP2g5-RPL1B-TRg-7",
"DIP2g5-UTP20-TRg-3",
"DIP2g5-UTP20-TRg-4",
"DIP2g5-RPL25-TRg-4",
"DIP2g5-RPL25-TRg-2",
"DIP2g5-MCM7-NRg-1",
"DIP2g5-MRP49-TRg-5",
"DIP2g5-ERO1-NRg-3",
"DIP2g5-UTP5-TRg-7",
"DIP2g5-MCM4-NRg-1",
"DIP2g5-PRE3-NRg-1",
"DIP2g5-FCF1-NRg-1",
"DIP2g5-CUS1-NRg-1",
"DIP2g5-PSF1-TRg-2",
"DIP2g5-BCP1-TRg-2",
"DIP2g5-PAN1-TRg-1",
"DIP2g5-PAN1-TRg-3",
"DIP2g5-PAN1-TRg-4",
"DIP2g5-VPS3-TRg-2",
"DIP2g5-YIL060W-NRg-1",
"DIP2g5-VPS53-NRg-1",
"DIP2g5-CYR1-TRg-4",
"DIP2g5-CYR1-TRg-7",
"DIP2g5-MPS1-NRg-1",
"DIP2g5-SRP1-TRg-5",
"DIP2g5-SRP1-TRg-4",
"DIP2g5-TAF12-TRg-2",
"DIP2g5-TAF12-TRg-3",
"DIP2g5-POP4-TRg-1",
"DIP2g5-SPT16-TRg-1",
"DIP2g5-NUP82-TRg-4",
"DIP2g5-DML1-TRg-3",
"DIP2g5-RPA43-NRg-3",
"DIP2g5-STU2-NRg-3",
"DIP2g5-POP4-NRg-4",
"DIP2g5-MCD1-TRg-2",
"DIP2g5-RPS3-NRg-4",
"DIP2g5-PRP9-TRg-4",
"DIP2g5-RPP1-NRg-2",
"DIP2g5-MTR2-NRg-11",
"DIP2g5-GCD11-TRg-1",
"DIP2g5-RPF1-TRg-3",
"DIP2g5-SUB2-NRg-4",
"DIP2g5-GPI15-TRg-3",
"DIP2g5-ERG9-TRg-6",
"DIP2g5-RPT2-NRg-1",
"DIP2g5-YOS1-NRg-3",
"DIP2g5-SCM3-TRg-4",
"DIP2g5-SCM3-TRg-6",
"DIP2g5-RLP7-NRg-1",
"DIP2g5-TFB2-NRg-4",
"DIP2g5-IMP4-TRg-1",
"DIP2g5-IMP4-TRg-3",
"DIP2g5-PRE4-TRg-3",
"DIP2g5-SUB2-TRg-3",
"DIP2g5-RPP0-NRg-4",
"DIP2g5-RPP0-NRg-3",
"DIP2g5-TOM40-TRg-4",
"DIP2g5-FUR1-NRg-12",
"DIP2g5-TOM40-TRg-2",
"DIP2g5-VMA11-NRg-4",
"DIP2g5-PGS1-NRg-4",
"DIP2g5-URB1-TRg-4",
"DIP2g5-ARP4-TRg-3",
"DIP2g5-RPT3-TRg-3",
"DIP2g5-SUI3-TRg-3",
"DIP2g5-RFC5-NRg-2",
"DIP2g5-RRP14-TRg-2",
"DIP2g5-SCC2-TRg-1",
"DIP2g5-SSC1-TRg-3",
"DIP2g5-RRP9-TRg-3",
"DIP2g5-MOT1-NRg-9",
"DIP2g5-RPL42A-NRg-2",
"DIP2g5-SEC16-TRg-7",
"DIP2g5-IMP4-NRg-2",
"DIP2g5-YEF3-NRg-4",
"DIP2g5-PUP1-TRg-1",
"DIP2g5-UTP22-TRg-6",
"DIP2g5-DBP2-NRg-4",
"DIP2g5-PRE2-TRg-7",
"DIP2g5-ATP16-TRg-6",
"DIP2g5-UTP13-TRg-4",
"DIP2g5-DOP1-NRg-4",
"DIP2g5-TIM44-TRg-3",
"DIP2g5-ATP16-TRg-2",
"DIP2g5-ENP1-NRg-3",
"DIP2g5-NAF1-TRg-3",
"DIP2g5-COG4-TRg-2",
"DIP2g5-SOG2-TRg-7",
"DIP2g5-YDR341C-TRg-3",
"DIP2g5-YMR290W-A-TRg-10",
"DIP2g5-NUP192-NRg-9",
"DIP2g5-RPS31-NRg-8",
"DIP2g5-SPC97-NRg-6",
"DIP2g5-EBP2-NRg-1",
"DIP2g5-CDC48-TRg-5",
"DIP2g5-RPT1-TRg-4",
"DIP2g5-ULP1-NRg-2",
"DIP2g5-RPN3-TRg-6",
"DIP2g5-RPT1-TRg-5",
"DIP2g5-KRE5-TRg-2",
"DIP2g5-TBF1-NRg-8",
"DIP2g5-UTP22-NRg-4",
"DIP2g5-SSC1-NRg-4",
"DIP2g5-REB1-TRg-4",
"DIP2g5-CDC48-NRg-9",
"DIP2g5-FAS2-TRg-8",
"DIP2g5-TAO3-TRg-8",
"DIP2g5-CKS1-TRg-5",
"DIP2g5-YLR379W-TRg-7",
"DIP2g5-TEN1-NRg-2",
"DIP2g5-RPL42A-TRg-2",
"DIP2g5-SEC27-TRg-4",
"DIP2g5-TBF1-NRg-4",
"DIP2g5-RPT1-NRg-6",
"DIP2g5-COG1-TRg-3",
"DIP2g5-SUI1-TRg-6",
"DIP2g5-TIM23-TRg-6",
"DIP2g5-CDC48-NRg-6",
"DIP2g5-EPL1-TRg-5",
"DIP2g5-RPT5-TRg-8",
"DIP2g5-ATP16-NRg-4",
"DIP2g5-RPN6-TRg-3",
"DIP2g5-ERG9-NRg-6",
"DIP2g5-SMX3-TRg-1",
"DIP2g5-NCB2-NRg-3",
"DIP2g5-SEC16-NRg-12",
"DIP2g5-RPN6-TRg-2",
"DIP2g5-REB1-NRg-4",
"DIP2g5-ATP16-TRg-9",
"DIP2g5-ERG9-NRg-7",
"PWP2g2_BC1-RPL15A-NRg-4",
"PWP2g2_BC1-RPL15A-NRg-5",
"PWP2g2_BC1-KRE33-TRg-1",
"PWP2g2_BC1-PMI40-NRg-1",
"PWP2g2_BC1-NOP19-NRg-3",
"PWP2g2_BC1-SRP14-NRg-4",
"PWP2g2_BC1-SEC27-TRg-2",
"PWP2g2_BC1-GPI14-TRg-3",
"PWP2g2_BC1-PAH1-TRg-7",
"PWP2g2_BC1-PAH1-TRg-6",
"PWP2g2_BC1-PAH1-TRg-5",
"PWP2g2_BC1-PAH1-TRg-3",
"PWP2g2_BC1-COG3-TRg-1",
"PWP2g2_BC1-HTS1-NRg-5",
"PWP2g2_BC1-MSN5-TRg-7",
"PWP2g2_BC1-ERG26-TRg-1",
"PWP2g2_BC1-SMD2-TRg-5",
"PWP2g2_BC1-SMD2-TRg-4",
"PWP2g2_BC1-SMD2-TRg-1",
"PWP2g2_BC1-PRE7-TRg-4",
"PWP2g2_BC1-PRE7-TRg-7",
"PWP2g2_BC1-SEC6-TRg-3",
"PWP2g2_BC1-ESF2-NRg-1",
"PWP2g2_BC1-ESF2-NRg-3",
"PWP2g2_BC1-AFG2-TRg-2",
"PWP2g2_BC1-RRP36-TRg-3",
"PWP2g2_BC1-RRP36-TRg-5",
"PWP2g2_BC1-GCR1-NRg-2",
"PWP2g2_BC1-PRE4-NRg-4",
"PWP2g2_BC1-PRE4-NRg-9",
"PWP2g2_BC1-DSN1-NRg-2",
"PWP2g2_BC1-GPI11-TRg-3",
"PWP2g2_BC1-POP3-TRg-1",
"PWP2g2_BC1-MNE1-TRg-5",
"PWP2g2_BC1-RRP12-NRg-1",
"PWP2g2_BC1-RSC6-TRg-2",
"PWP2g2_BC1-CDC25-TRg-1",
"PWP2g2_BC1-CDC25-TRg-9",
"PWP2g2_BC1-YPP1-NRg-3",
"PWP2g2_BC1-NFS1-NRg-9",
"PWP2g2_BC1-NFS1-NRg-8",
"PWP2g2_BC1-UBA2-TRg-1",
"PWP2g2_BC1-ARP2-NRg-3",
"PWP2g2_BC1-MAK16-TRg-1",
"PWP2g2_BC1-CEP3-NRg-1",
"PWP2g2_BC1-GUK1-TRg-5",
"PWP2g2_BC1-GUK1-TRg-2",
"PWP2g2_BC1-GPI12-NRg-6",
"PWP2g2_BC1-RPS5-NRg-5",
"PWP2g2_BC1-RPS5-NRg-2",
"PWP2g2_BC1-RPC19-NRg-1",
"PWP2g2_BC1-TIM54-TRg-1",
"PWP2g2_BC1-TEN1-TRg-2",
"PWP2g2_BC1-SAH1-NRg-4",
"PWP2g2_BC1-SAH1-NRg-5",
"PWP2g2_BC1-SAH1-NRg-3",
"PWP2g2_BC1-ATP15-NRg-5",
"PWP2g2_BC1-SCD5-TRg-5",
"PWP2g2_BC1-ARB1-NRg-2",
"PWP2g2_BC1-ARB1-NRg-4",
"PWP2g2_BC1-PUP2-TRg-1",
"PWP2g2_BC1-CCT8-TRg-2",
"PWP2g2_BC1-MCM4-TRg-1",
"PWP2g2_BC1-LSM4-TRg-1",
"PWP2g2_BC1-NOP53-NRg-1",
"PWP2g2_BC1-ATP3-TRg-4",
"PWP2g2_BC1-AFG2-NRg-3",
"PWP2g2_BC1-PRO3-NRg-3",
"PWP2g2_BC1-NRD1-NRg-10",
"PWP2g2_BC1-SEC61-TRg-2",
"PWP2g2_BC1-RHO3-TRg-4",
"PWP2g2_BC1-SNF2-TRg-6",
"PWP2g2_BC1-SMD2-NRg-3",
"PWP2g2_BC1-RSC4-TRg-2",
"PWP2g2_BC1-RSC4-TRg-1",
"PWP2g2_BC1-TIF34-TRg-2",
"PWP2g2_BC1-BET1-NRg-1",
"PWP2g2_BC1-CDC8-NRg-2",
"PWP2g2_BC1-PRP42-TRg-2",
"PWP2g2_BC1-RRB1-TRg-2",
"PWP2g2_BC1-SPC24-TRg-1",
"PWP2g2_BC1-ILS1-NRg-1",
"PWP2g2_BC1-GFA1-TRg-2",
"PWP2g2_BC1-SEC21-NRg-10",
"PWP2g2_BC1-RPC10-NRg-1",
"PWP2g2_BC1-RPB10-TRg-3",
"PWP2g2_BC1-RPB10-TRg-2",
"PWP2g2_BC1-YNL181W-TRg-1",
"PWP2g2_BC1-RAD3-NRg-1",
"PWP2g2_BC1-NOP10-TRg-1",
"PWP2g2_BC1-BFR2-TRg-3",
"PWP2g2_BC1-MCM2-TRg-6",
"PWP2g2_BC1-MCM2-TRg-4",
"PWP2g2_BC1-MPP10-TRg-1",
"PWP2g2_BC1-RET2-TRg-4",
"PWP2g2_BC1-RET2-TRg-1",
"PWP2g2_BC1-RPS2-NRg-1",
"PWP2g2_BC1-RPS2-NRg-2",
"PWP2g2_BC1-ORC4-NRg-3",
"PWP2g2_BC1-TIP20-TRg-7",
"PWP2g2_BC1-SMT3-TRg-1",
"PWP2g2_BC1-MSS18-NRg-6",
"PWP2g2_BC1-YEF3-NRg-9",
"PWP2g2_BC1-ASK1-NRg-1",
"PWP2g2_BC1-SMC1-TRg-1",
"PWP2g2_BC1-NIP1-NRg-1",
"PWP2g2_BC1-RPP1-NRg-1",
"PWP2g2_BC1-YDJ1-TRg-6",
"PWP2g2_BC1-SUB2-NRg-1",
"PWP2g2_BC1-TIM10-NRg-8",
"PWP2g2_BC1-TIM10-NRg-4",
"PWP2g2_BC1-TIM10-NRg-7",
"PWP2g2_BC1-SKI6-TRg-4",
"PWP2g2_BC1-TUB4-TRg-1",
"PWP2g2_BC1-CDC37-NRg-2",
"PWP2g2_BC1-ISD11-TRg-3",
"PWP2g2_BC1-YOS1-TRg-4",
"PWP2g2_BC1-SSC1-TRg-6",
"PWP2g2_BC1-MTR3-TRg-5",
"PWP2g2_BC1-MTR3-TRg-6",
"PWP2g2_BC1-TFA1-TRg-2",
"PWP2g2_BC1-CDC3-NRg-3",
"PWP2g2_BC1-ERG25-TA-18",
"PWP2g2_BC1-RPB11-TRg-4",
"PWP2g2_BC1-RPB11-TRg-1",
"PWP2g2_BC1-RPB11-TRg-2",
"PWP2g2_BC1-DED1-TRg-3",
"PWP2g2_BC1-DED1-TRg-1",
"PWP2g2_BC1-DED1-TRg-6",
"PWP2g2_BC1-DED1-TRg-4",
"PWP2g2_BC1-RPL10-NRg-5",
"PWP2g2_BC1-RPL10-NRg-4",
"PWP2g2_BC1-EFB1-NRg-1",
"PWP2g2_BC1-EFB1-NRg-5",
"PWP2g2_BC1-EFB1-NRg-4",
"PWP2g2_BC1-RPT3-NRg-1",
"PWP2g2_BC1-SAC6-TRg-8",
"PWP2g2_BC1-SAC6-TRg-4",
"PWP2g2_BC1-SAC6-TRg-5",
"PWP2g2_BC1-SAC6-TRg-3",
"PWP2g2_BC1-DIM1-TRg-5",
"PWP2g2_BC1-DIM1-TRg-7",
"PWP2g2_BC1-RPC17-NRg-1",
"PWP2g2_BC1-RPC17-NRg-2",
"PWP2g2_BC1-YDR341C-TRg-1",
"PWP2g2_BC1-RAP1-NRg-8",
"PWP2g2_BC1-RAP1-NRg-5",
"PWP2g2_BC1-RAP1-NRg-2",
"PWP2g2_BC1-SEC26-NRg-3",
"PWP2g2_BC1-SPP41-TRg-3",
"PWP2g2_BC1-TAP42-NRg-1",
"PWP2g2_BC1-PGA2-TRg-6",
"PWP2g2_BC1-BRL1-TRg-1",
"PWP2g2_BC1-FOL2-TRg-1",
"PWP2g2_BC1-NAB3-NRg-5",
"PWP2g2_BC1-SNF4-TRg-4",
"PWP2g2_BC1-HRR25-TRg-2",
"PWP2g2_BC1-TRS23-TRg-4",
"PWP2g2_BC1-CTR86-TRg-4",
"PWP2g2_BC1-RPB5-TRg-5",
"PWP2g2_BC1-SPN1-NRg-2",
"PWP2g2_BC1-SPN1-NRg-1",
"PWP2g2_BC1-SEC61-NRg-1",
"PWP2g2_BC1-SEC61-NRg-7",
"PWP2g2_BC1-TUS1-TRg-3",
"PWP2g2_BC1-OLE1-NRg-2",
"PWP2g2_BC1-AFG2-TRg-1",
"PWP2g2_BC1-TOA2-NRg-1",
"PWP2g2_BC1-USO1-TRg-1",
"PWP2g2_BC1-UTP22-NRg-2",
"PWP2g2_BC1-RIB1-TRg-3",
"PWP2g2_BC1-RIB1-TRg-7",
"PWP2g2_BC1-RIB1-TRg-4",
"PWP2g2_BC1-COG1-TRg-1",
"PWP2g2_BC1-RPL32-NRg-2",
"PWP2g2_BC1-GLC7-NRg-3",
"PWP2g2_BC1-GLC7-NRg-4",
"PWP2g2_BC1-HSF1-TRg-2",
"PWP2g2_BC1-DAM1-NRg-5",
"PWP2g2_BC1-SEC18-TRg-4",
"PWP2g2_BC1-SEC18-TRg-5",
"PWP2g2_BC1-PAB1-NRg-3",
"PWP2g2_BC1-POP8-TRg-2",
"PWP2g2_BC1-PAB1-NRg-4",
"PWP2g2_BC1-BIG1-TRg-4",
"PWP2g2_BC1-BIG1-TRg-5",
"PWP2g2_BC1-BIG1-TRg-6",
"PWP2g2_BC1-RPO41-NRg-1",
"PWP2g2_BC1-RVB2-NRg-2",
"PWP2g2_BC1-PET117-NRg-8",
"PWP2g2_BC1-VPS45-NRg-9",
"PWP2g2_BC1-YCG1-NRg-1",
"PWP2g2_BC1-NOC4-NRg-1",
"PWP2g2_BC1-NMD3-NRg-2",
"PWP2g2_BC1-DRS1-TRg-2",
"PWP2g2_BC1-HTB1-NRg-2",
"PWP2g2_BC1-IPI1-TRg-2",
"PWP2g2_BC1-SEC18-NRg-1",
"PWP2g2_BC1-SEC18-NRg-2",
"PWP2g2_BC1-JIP5-NRg-2",
"PWP2g2_BC1-YPT1-TRg-3",
"PWP2g2_BC1-YPT1-TRg-2",
"PWP2g2_BC1-CLF1-NRg-2",
"PWP2g2_BC1-SNF2-NRg-7",
"PWP2g2_BC1-SNF2-NRg-4",
"PWP2g2_BC1-RPL25-NRg-1",
"PWP2g2_BC1-NOP56-TRg-1",
"PWP2g2_BC1-NOP56-TRg-2",
"PWP2g2_BC1-TRS31-TRg-1",
"PWP2g2_BC1-DBF4-TRg-2",
"PWP2g2_BC1-DBF4-TRg-1",
"PWP2g2_BC1-RPC19-TRg-4",
"PWP2g2_BC1-RPC19-TRg-6",
"PWP2g2_BC1-RPC19-TRg-3",
"PWP2g2_BC1-ROK1-NRg-1",
"PWP2g2_BC1-CDC33-TRg-4",
"PWP2g2_BC1-DHR2-TRg-3",
"PWP2g2_BC1-RRP42-NRg-5",
"PWP2g2_BC1-CLF1-TRg-1",
"PWP2g2_BC1-ERG11-NA-16",
"PWP2g2_BC1-VAS1-NRg-4",
"PWP2g2_BC1-PIK1-NRg-2",
"PWP2g2_BC1-SAR1-NRg-7",
"PWP2g2_BC1-SAR1-NRg-4",
"PWP2g2_BC1-RPS3-TRg-1",
"PWP2g2_BC1-YTM1-TRg-2",
"PWP2g2_BC1-SUI3-NRg-5",
"PWP2g2_BC1-SUI3-NRg-2",
"PWP2g2_BC1-RRP7-TRg-4",
"PWP2g2_BC1-RRP7-TRg-6",
"PWP2g2_BC1-NIP7-TRg-2",
"PWP2g2_BC1-MDM35-TRg-1",
"PWP2g2_BC1-ALA1-NRg-1",
"PWP2g2_BC1-DOA4-NRg-2",
"PWP2g2_BC1-RPS13-NRg-1",
"PWP2g2_BC1-YSF3-TRg-2",
"PWP2g2_BC1-RPS2-NRg-11",
"PWP2g2_BC1-SSL1-TRg-10",
"PWP2g2_BC1-NIP7-TRg-1",
"PWP2g2_BC1-LST8-NRg-1",
"PWP2g2_BC1-TAF4-TRg-3",
"PWP2g2_BC1-HAS1-TRg-2",
"PWP2g2_BC1-GLC7-TRg-2",
"PWP2g2_BC1-CDC45-NRg-1",
"PWP2g2_BC1-SEC22-NRg-8",
"PWP2g2_BC1-YOS1-TRg-2",
"PWP2g2_BC1-RBA50-TRg-3",
"PWP2g2_BC1-SPP41-NRg-2",
"PWP2g2_BC1-PRP46-TRg-2",
"PWP2g2_BC1-PGA2-NRg-1",
"PWP2g2_BC1-CBF5-TRg-3",
"PWP2g2_BC1-TCP1-NRg-3",
"PWP2g2_BC1-TCP1-NRg-2",
"PWP2g2_BC1-ERG26-NRg-2",
"PWP2g2_BC1-ERG26-NRg-4",
"PWP2g2_BC1-MES1-TRg-5",
"PWP2g2_BC1-HTS1-TRg-2",
"PWP2g2_BC1-SSS1-TRg-3",
"PWP2g2_BC1-SSS1-TRg-2",
"PWP2g2_BC1-SYS1-TRg-7",
"PWP2g2_BC1-SYS1-TRg-2",
"PWP2g2_BC1-SYS1-TRg-1",
"PWP2g2_BC1-BFR2-TRg-1",
"PWP2g2_BC1-EOS1-TRg-3",
"PWP2g2_BC1-TAF4-NRg-1",
"PWP2g2_BC1-ARL3-NRg-8",
"PWP2g2_BC1-RPN5-NRg-1",
"PWP2g2_BC1-TIM9-NRg-2",
"PWP2g2_BC1-NUP57-NRg-3",
"PWP2g2_BC1-VPS4-TRg-1",
"PWP2g2_BC1-CDC3-TRg-4",
"PWP2g2_BC1-BBP1-NRg-1",
"PWP2g2_BC1-BBP1-NRg-2",
"PWP2g2_BC1-USE1-NRg-3",
"PWP2g2_BC1-CCT7-TRg-1",
"PWP2g2_BC1-SAH1-TRg-3",
"PWP2g2_BC1-CHS2-TRg-1",
"PWP2g2_BC1-DPM1-TRg-2",
"PWP2g2_BC1-BBP1-TRg-1",
"PWP2g2_BC1-NRD1-TRg-4",
"PWP2g2_BC1-RPB3-NRg-1",
"PWP2g2_BC1-PHO85-NRg-6",
"PWP2g2_BC1-SNF6-TRg-6",
"PWP2g2_BC1-PRP38-NRg-2",
"PWP2g2_BC1-OAR1-NRg-3",
"PWP2g2_BC1-ROX3-NRg-1",
"PWP2g2_BC1-YPP1-TRg-6",
"PWP2g2_BC1-CBF2-NRg-8",
"PWP2g2_BC1-SPT6-TRg-5",
"PWP2g2_BC1-SEC10-NRg-1",
"PWP2g2_BC1-NSL1-NRg-3",
"PWP2g2_BC1-NRD1-NRg-8",
"PWP2g2_BC1-RPB3-TRg-1",
"PWP2g2_BC1-NRD1-NRg-4",
"PWP2g2_BC1-RVB1-TRg-2",
"PWP2g2_BC1-TIF5-NRg-8",
"PWP2g2_BC1-EOS1-NRg-1",
"PWP2g2_BC1-ERG25-NA-26",
"PWP2g2_BC1-MSL5-NRg-4",
"PWP2g2_BC1-SEC24-TRg-2",
"PWP2g2_BC1-RPL30-NRg-5",
"PWP2g2_BC1-SNU71-NRg-3",
"PWP2g2_BC1-CDC33-NRg-1",
"PWP2g2_BC1-RPN6-TRg-4",
"PWP2g2_BC1-NAB2-TRg-4",
"PWP2g2_BC1-NAB2-TRg-6",
"PWP2g2_BC1-YTM1-NRg-1",
"PWP2g2_BC1-OLE1-TRg-8",
"PWP2g2_BC1-OLE1-TRg-1",
"PWP2g2_BC1-UTP7-TRg-4",
"PWP2g2_BC1-ACT1-NRg-6",
"PWP2g2_BC1-RPL18A-NRg-3",
"PWP2g2_BC1-BRX1-NRg-1",
"PWP2g2_BC1-NAF1-TRg-8",
"PWP2g2_BC1-NAF1-TRg-6",
"PWP2g2_BC1-NAF1-TRg-4",
"PWP2g2_BC1-CDC8-TRg-2",
"PWP2g2_BC1-NSE4-TRg-1",
"PWP2g2_BC1-PAB1-NRg-2",
"PWP2g2_BC1-PRP43-TRg-4",
"PWP2g2_BC1-SEC2-NRg-3",
"PWP2g2_BC1-SEC2-NRg-6",
"PWP2g2_BC1-MPP10-NRg-5",
"PWP2g2_BC1-YDR355C-TRg-2",
"PWP2g2_BC1-YLR339C-TRg-9",
"PWP2g2_BC1-SNM1-TRg-2",
"PWP2g2_BC1-ALR1-NRg-4",
"PWP2g2_BC1-ALR1-NRg-1",
"PWP2g2_BC1-ALR1-NRg-3",
"PWP2g2_BC1-RPL10-TRg-1",
"PWP2g2_BC1-RPL28-TRg-2",
"PWP2g2_BC1-UTP25-TRg-1",
"PWP2g2_BC1-POB3-TRg-1",
"PWP2g2_BC1-POB3-TRg-3",
"PWP2g2_BC1-POB3-TRg-2",
"PWP2g2_BC1-MED11-TRg-1",
"PWP2g2_BC1-ISA1-TRg-15",
"PWP2g2_BC1-RRP1-NRg-1",
"PWP2g2_BC1-MES1-NRg-1",
"PWP2g2_BC1-SEC13-NRg-5",
"PWP2g2_BC1-MCM2-NRg-2",
"PWP2g2_BC1-ALA1-TRg-4",
"PWP2g2_BC1-MTG2-TRg-5",
"PWP2g2_BC1-TIF35-NRg-3",
"PWP2g2_BC1-NSE1-TRg-3",
"PWP2g2_BC1-NSE1-TRg-4",
"PWP2g2_BC1-MOB2-NRg-6",
"PWP2g2_BC1-VRG4-NRg-3",
"PWP2g2_BC1-PRP9-TRg-3",
"PWP2g2_BC1-HYM1-TRg-5",
"PWP2g2_BC1-POP1-TRg-5",
"PWP2g2_BC1-POP1-TRg-9",
"PWP2g2_BC1-RPL17A-TRg-1",
"PWP2g2_BC1-SLD2-TRg-1",
"PWP2g2_BC1-CDC48-NRg-7",
"PWP2g2_BC1-FHL1-NRg-2",
"PWP2g2_BC1-BET3-NRg-7",
"PWP2g2_BC1-MAK21-TRg-1",
"PWP2g2_BC1-BRN1-TRg-4",
"PWP2g2_BC1-FBA1-NRg-3",
"PWP2g2_BC1-CDC42-TRg-6",
"PWP2g2_BC1-CDC42-TRg-7",
"PWP2g2_BC1-COG4-NRg-1",
"PWP2g2_BC1-ATP3-NRg-3",
"PWP2g2_BC1-ATP3-NRg-2",
"PWP2g2_BC1-SMP3-TRg-5",
"PWP2g2_BC1-CFT2-NRg-2",
"PWP2g2_BC1-FAS2-TRg-5",
"PWP2g2_BC1-DBP2-NRg-3",
"PWP2g2_BC1-DBP2-NRg-2",
"PWP2g2_BC1-MPS2-NRg-4",
"PWP2g2_BC1-ARC35-TRg-2",
"PWP2g2_BC1-ARC35-TRg-5",
"PWP2g2_BC1-MRD1-TRg-1",
"PWP2g2_BC1-RLP7-TRg-1",
"PWP2g2_BC1-SPC34-TRg-1",
"PWP2g2_BC1-CDC45-TRg-2",
"PWP2g2_BC1-GCD6-TRg-3",
"PWP2g2_BC1-GCD6-TRg-4",
"PWP2g2_BC1-YPT6-NRg-2",
"PWP2g2_BC1-RPS13-TRg-2",
"PWP2g2_BC1-IPI3-TRg-3",
"PWP2g2_BC1-TIF5-NRg-9",
"PWP2g2_BC1-TIF5-NRg-7",
"PWP2g2_BC1-TIF5-NRg-6",
"PWP2g2_BC1-NAB3-TRg-3",
"PWP2g2_BC1-GCD2-TRg-1",
"PWP2g2_BC1-UBA1-TRg-2",
"PWP2g2_BC1-SLD3-TRg-6",
"PWP2g2_BC1-LCB1-TRg-5",
"PWP2g2_BC1-TOA2-TRg-6",
"PWP2g2_BC1-TOA2-TRg-1",
"PWP2g2_BC1-TOA2-TRg-3",
"PWP2g2_BC1-LSM2-TRg-1",
"PWP2g2_BC1-YML6-TRg-13",
"PWP2g2_BC1-YML6-TRg-12",
"PWP2g2_BC1-UTP15-NRg-1",
"PWP2g2_BC1-TIF6-NRg-8",
"PWP2g2_BC1-SUP35-NRg-1",
"PWP2g2_BC1-MPP10-NRg-1",
"PWP2g2_BC1-SWI3-TRg-7",
"PWP2g2_BC1-SSN3-NRg-2",
"PWP2g2_BC1-SEC13-NRg-7",
"PWP2g2_BC1-RPS15-NRg-3",
"PWP2g2_BC1-RPL3-TRg-2",
"PWP2g2_BC1-FBA1-NRg-2",
"PWP2g2_BC1-FBA1-NRg-1",
"PWP2g2_BC1-FBA1-NRg-5",
"PWP2g2_BC1-DAM1-TRg-2",
"PWP2g2_BC1-NHP2-TRg-2",
"PWP2g2_BC1-HCA4-NRg-6",
"PWP2g2_BC1-PRE3-TRg-4",
"PWP2g2_BC1-DBP5-NRg-4",
"PWP2g2_BC1-SPT6-NRg-4",
"PWP2g2_BC1-SPT6-NRg-2",
"PWP2g2_BC1-RPL18A-TRg-4",
"PWP2g2_BC1-KSH1-TRg-1",
"PWP2g2_BC1-KSH1-TRg-3",
"PWP2g2_BC1-IPI3-NRg-1",
"PWP2g2_BC1-PGA2-TRg-8",
"PWP2g2_BC1-RPL18A-TRg-2",
"PWP2g2_BC1-RPL33A-NRg-6",
"PWP2g2_BC1-TAF12-NRg-2",
"PWP2g2_BC1-USE1-TRg-5",
"PWP2g2_BC1-YNL114C-TRg-1",
"PWP2g2_BC1-SMC5-TRg-7",
"PWP2g2_BC1-SMC5-TRg-6",
"PWP2g2_BC1-RSC58-TRg-1",
"PWP2g2_BC1-CTF13-TRg-2",
"PWP2g2_BC1-NAB2-NRg-2",
"PWP2g2_BC1-MCM7-TRg-4",
"PWP2g2_BC1-BCP1-NRg-5",
"PWP2g2_BC1-STU2-TRg-3",
"PWP2g2_BC1-SEC21-NRg-6",
"PWP2g2_BC1-SEC21-NRg-3",
"PWP2g2_BC1-RPL1B-TRg-3",
"PWP2g2_BC1-SEC20-NRg-2",
"PWP2g2_BC1-VMA3-NRg-2",
"PWP2g2_BC1-SEC23-NRg-5",
"PWP2g2_BC1-CDC28-TRg-4",
"PWP2g2_BC1-RPN12-NRg-11",
"PWP2g2_BC1-PUP3-TRg-3",
"PWP2g2_BC1-SEC31-TRg-2",
"PWP2g2_BC1-SED5-TRg-6",
"PWP2g2_BC1-SED5-TRg-5",
"PWP2g2_BC1-RPL33A-TRg-1",
"PWP2g2_BC1-RPL33A-TRg-2",
"PWP2g2_BC1-MRPL11-TRg-2",
"PWP2g2_BC1-RTP1-NRg-2",
"PWP2g2_BC1-NUG1-TRg-2",
"PWP2g2_BC1-VPH2-TRg-4",
"PWP2g2_BC1-COP1-NRg-3",
"PWP2g2_BC1-CRM1-NRg-1",
"PWP2g2_BC1-RPL5-NRg-4",
"PWP2g2_BC1-SNU13-NRg-4",
"PWP2g2_BC1-PFS2-TRg-3",
"PWP2g2_BC1-MPP10-TRg-2",
"PWP2g2_BC1-TSR4-NRg-2",
"PWP2g2_BC1-RSC2-TRg-1",
"PWP2g2_BC1-SEC65-TRg-2",
"PWP2g2_BC1-SMI1-NRg-1",
"PWP2g2_BC1-RTT105-NRg-4",
"PWP2g2_BC1-VMA5-TRg-3",
"PWP2g2_BC1-VMA5-TRg-5",
"PWP2g2_BC1-RRP1-TRg-3",
"PWP2g2_BC1-CLC1-TRg-2",
"PWP2g2_BC1-GCD6-NRg-1",
"PWP2g2_BC1-GCD6-NRg-2",
"PWP2g2_BC1-PXR1-TRg-1",
"PWP2g2_BC1-CDC14-NRg-1",
"PWP2g2_BC1-PCF11-TRg-6",
"PWP2g2_BC1-PCF11-TRg-5",
"PWP2g2_BC1-PCF11-TRg-4",
"PWP2g2_BC1-SEC31-NRg-1",
"PWP2g2_BC1-RRP5-NRg-1",
"PWP2g2_BC1-PRE10-TRg-5",
"PWP2g2_BC1-PRE10-TRg-1",
"PWP2g2_BC1-RPS5-TRg-2",
"PWP2g2_BC1-NSP1-TRg-4",
"PWP2g2_BC1-PRP38-TRg-4",
"PWP2g2_BC1-RCF1-NRg-5",
"PWP2g2_BC1-RSC3-TRg-4",
"PWP2g2_BC1-RSC3-TRg-5",
"PWP2g2_BC1-RSC3-TRg-6",
"PWP2g2_BC1-HTA1-NRg-12",
"PWP2g2_BC1-HTA1-NRg-11",
"PWP2g2_BC1-UTP23-TRg-2",
"PWP2g2_BC1-GCD7-NRg-1",
"PWP2g2_BC1-GCD7-NRg-2",
"PWP2g2_BC1-GCD7-NRg-6",
"PWP2g2_BC1-GAL11-NRg-2",
"PWP2g2_BC1-GAL11-NRg-9",
"PWP2g2_BC1-PHO4-TRg-5",
"PWP2g2_BC1-SNP1-NRg-3",
"PWP2g2_BC1-RPC37-TRg-5",
"PWP2g2_BC1-CRM1-TRg-5",
"PWP2g2_BC1-CRM1-TRg-2",
"PWP2g2_BC1-ASK1-TRg-7",
"PWP2g2_BC1-STU2-NRg-4",
"PWP2g2_BC1-NEO1-NRg-3",
"PWP2g2_BC1-GAL11-TRg-5",
"PWP2g2_BC1-GAL11-TRg-7",
"PWP2g2_BC1-SAM50-NRg-3",
"PWP2g2_BC1-CSL4-TRg-2",
"PWP2g2_BC1-CCT5-TRg-2",
"PWP2g2_BC1-POL30-NRg-1",
"PWP2g2_BC1-MED4-TRg-4",
"PWP2g2_BC1-MED4-TRg-3",
"PWP2g2_BC1-MED4-TRg-2",
"PWP2g2_BC1-GDI1-TRg-4",
"PWP2g2_BC1-GDI1-TRg-3",
"PWP2g2_BC1-REB1-TRg-6",
"PWP2g2_BC1-MRPL37-NRg-2",
"PWP2g2_BC1-NOC3-TRg-3",
"PWP2g2_BC1-SPC97-TRg-3",
"PWP2g2_BC1-IPP1-TRg-3",
"PWP2g2_BC1-IPP1-TRg-2",
"PWP2g2_BC1-PTI1-TRg-3",
"PWP2g2_BC1-PTI1-TRg-5",
"PWP2g2_BC1-RFC5-NRg-1",
"PWP2g2_BC1-CDC24-TRg-1",
"PWP2g2_BC1-CDC24-TRg-3",
"PWP2g2_BC1-CDC24-TRg-5",
"PWP2g2_BC1-CDC24-TRg-6",
"PWP2g2_BC1-UTP23-TRg-6",
"PWP2g2_BC1-UTP23-TRg-4",
"PWP2g2_BC1-UTP23-TRg-1",
"PWP2g2_BC1-RHO3-NRg-4",
"PWP2g2_BC1-TRS23-NRg-1",
"PWP2g2_BC1-TRS23-NRg-3",
"PWP2g2_BC1-RSP5-TRg-2",
"PWP2g2_BC1-RSP5-TRg-1",
"PWP2g2_BC1-SDA1-NRg-1",
"PWP2g2_BC1-KAP95-TRg-8",
"PWP2g2_BC1-ACO1-TRg-6",
"PWP2g2_BC1-HTA1-NRg-3",
"PWP2g2_BC1-HTA1-NRg-2",
"PWP2g2_BC1-SPN1-TRg-1",
"PWP2g2_BC1-MOT1-NRg-7",
"PWP2g2_BC1-RPL17A-NRg-4",
"PWP2g2_BC1-ADA2-TRg-4",
"PWP2g2_BC1-SFH1-NRg-1",
"PWP2g2_BC1-SPC97-NRg-5",
"PWP2g2_BC1-PRP22-TRg-3",
"PWP2g2_BC1-SEN15-TRg-2",
"PWP2g2_BC1-RPL3-NRg-2",
"PWP2g2_BC1-ISD11-NRg-2",
"PWP2g2_BC1-HEM12-TRg-8",
"PWP2g2_BC1-SEC10-TRg-1",
"PWP2g2_BC1-HTB1-TRg-7",
"PWP2g2_BC1-TTI2-TRg-1",
"PWP2g2_BC1-ACP1-TRg-2",
"PWP2g2_BC1-ACP1-TRg-4",
"PWP2g2_BC1-GAL11-NRg-10",
"PWP2g2_BC1-UTP22-TRg-2",
"PWP2g2_BC1-MST1-NRg-5",
"PWP2g2_BC1-RIB7-NRg-2",
"PWP2g2_BC1-MCD1-TRg-6",
"PWP2g2_BC1-MCD1-TRg-5",
"PWP2g2_BC1-GPI8-NRg-2",
"PWP2g2_BC1-THS1-TRg-2",
"PWP2g2_BC1-RRP7-TRg-2",
"PWP2g2_BC1-RRP7-TRg-5",
"PWP2g2_BC1-SMX2-NRg-7",
"PWP2g2_BC1-RRP45-TRg-5",
"PWP2g2_BC1-RRP45-TRg-4",
"PWP2g2_BC1-CNS1-TRg-2",
"PWP2g2_BC1-FBP1-NRg-9",
"PWP2g2_BC1-GCD11-NRg-1",
"PWP2g2_BC1-RPL10-TRg-2",
"PWP2g2_BC1-NUP192-TRg-4",
"PWP2g2_BC1-NUP145-NRg-4",
"PWP2g2_BC1-HEM12-TRg-6",
"PWP2g2_BC1-PLC1-TRg-3",
"PWP2g2_BC1-RPA43-TRg-1",
"PWP2g2_BC1-RPB7-NRg-2",
"PWP2g2_BC1-RPB7-NRg-3",
"PWP2g2_BC1-NSL1-NRg-1",
"PWP2g2_BC1-UTP6-TRg-3",
"PWP2g2_BC1-UTP6-TRg-1",
"PWP2g2_BC1-YJU2-TRg-5",
"PWP2g2_BC1-FRS2-NRg-5",
"PWP2g2_BC1-TIF35-NRg-2",
"PWP2g2_BC1-GPI15-TRg-1",
"PWP2g2_BC1-NOP1-NRg-5",
"PWP2g2_BC1-GPI15-TRg-4",
"PWP2g2_BC1-COG4-TRg-1",
"PWP2g2_BC1-TFA1-TRg-1",
"PWP2g2_BC1-RHO1-NRg-2",
"PWP2g2_BC1-RHO1-NRg-1",
"PWP2g2_BC1-CDC55-NRg-2",
"PWP2g2_BC1-IDI1-NRg-7",
"PWP2g2_BC1-RPL32-TRg-5",
"PWP2g2_BC1-RPB5-TRg-4",
"PWP2g2_BC1-DIP2-TRg-5",
"PWP2g2_BC1-DIP2-TRg-1",
"PWP2g2_BC1-RPC40-TRg-2",
"PWP2g2_BC1-CDC6-TRg-5",
"PWP2g2_BC1-CDC6-TRg-3",
"PWP2g2_BC1-DAD2-TRg-2",
"PWP2g2_BC1-RVS161-TRg-2",
"PWP2g2_BC1-RVS161-TRg-1",
"PWP2g2_BC1-SUP45-NRg-3",
"PWP2g2_BC1-SRB6-NRg-5",
"PWP2g2_BC1-RPC11-TRg-4",
"PWP2g2_BC1-RKI1-TRg-8",
"PWP2g2_BC1-NIP7-TRg-3",
"PWP2g2_BC1-RPL33A-NRg-12",
"PWP2g2_BC1-SAM50-TRg-4",
"PWP2g2_BC1-NOP4-NRg-1",
"PWP2g2_BC1-NOP4-NRg-3",
"PWP2g2_BC1-SMX2-TRg-5",
"PWP2g2_BC1-POL12-NRg-2",
"PWP2g2_BC1-BMS1-NRg-2",
"PWP2g2_BC1-RPA190-TRg-5",
"PWP2g2_BC1-ALG14-NRg-4",
"PWP2g2_BC1-ALG14-NRg-1",
"PWP2g2_BC1-PRE5-NRg-1",
"PWP2g2_BC1-BIG1-NRg-2",
"PWP2g2_BC1-TFA2-TRg-4",
"PWP2g2_BC1-IMP4-TRg-6",
"PWP2g2_BC1-PAN1-NRg-1",
"PWP2g2_BC1-UTP13-TRg-2",
"PWP2g2_BC1-KAE1-NRg-3",
"PWP2g2_BC1-ERG20-TRg-1",
"PWP2g2_BC1-CDC20-TRg-6",
"PWP2g2_BC1-PWP2-NRg-2",
"PWP2g2_BC1-COG1-NRg-1",
"PWP2g2_BC1-RPL1B-TRg-4",
"PWP2g2_BC1-RPL1B-TRg-7",
"PWP2g2_BC1-UTP20-TRg-3",
"PWP2g2_BC1-UTP20-TRg-4",
"PWP2g2_BC1-RPL25-TRg-4",
"PWP2g2_BC1-RPL25-TRg-2",
"PWP2g2_BC1-MCM7-NRg-1",
"PWP2g2_BC1-MRP49-TRg-5",
"PWP2g2_BC1-ERO1-NRg-3",
"PWP2g2_BC1-UTP5-TRg-7",
"PWP2g2_BC1-MCM4-NRg-1",
"PWP2g2_BC1-PRE3-NRg-1",
"PWP2g2_BC1-FCF1-NRg-1",
"PWP2g2_BC1-CUS1-NRg-1",
"PWP2g2_BC1-PSF1-TRg-2",
"PWP2g2_BC1-BCP1-TRg-2",
"PWP2g2_BC1-PAN1-TRg-1",
"PWP2g2_BC1-PAN1-TRg-3",
"PWP2g2_BC1-PAN1-TRg-4",
"PWP2g2_BC1-VPS3-TRg-2",
"PWP2g2_BC1-YIL060W-NRg-1",
"PWP2g2_BC1-VPS53-NRg-1",
"PWP2g2_BC1-CYR1-TRg-4",
"PWP2g2_BC1-CYR1-TRg-7",
"PWP2g2_BC1-MPS1-NRg-1",
"PWP2g2_BC1-SRP1-TRg-5",
"PWP2g2_BC1-SRP1-TRg-4",
"PWP2g2_BC1-TAF12-TRg-2",
"PWP2g2_BC1-TAF12-TRg-3",
"PWP2g2_BC1-POP4-TRg-1",
"PWP2g2_BC1-SPT16-TRg-1",
"PWP2g2_BC1-NUP82-TRg-4",
"PWP2g2_BC1-DML1-TRg-3",
"PWP2g2_BC1-RPA43-NRg-3",
"PWP2g2_BC1-STU2-NRg-3",
"PWP2g2_BC1-POP4-NRg-4",
"PWP2g2_BC1-MCD1-TRg-2",
"PWP2g2_BC1-RPS3-NRg-4",
"PWP2g2_BC1-PRP9-TRg-4",
"PWP2g2_BC1-RPP1-NRg-2",
"PWP2g2_BC1-MTR2-NRg-11",
"PWP2g2_BC1-GCD11-TRg-1",
"PWP2g2_BC1-RPF1-TRg-3",
"PWP2g2_BC1-SUB2-NRg-4",
"PWP2g2_BC1-GPI15-TRg-3",
"PWP2g2_BC1-ERG9-TRg-6",
"PWP2g2_BC1-RPT2-NRg-1",
"PWP2g2_BC1-YOS1-NRg-3",
"PWP2g2_BC1-SCM3-TRg-4",
"PWP2g2_BC1-SCM3-TRg-6",
"PWP2g2_BC1-RLP7-NRg-1",
"PWP2g2_BC1-TFB2-NRg-4",
"PWP2g2_BC1-IMP4-TRg-1",
"PWP2g2_BC1-IMP4-TRg-3",
"PWP2g2_BC1-PRE4-TRg-3",
"PWP2g2_BC1-SUB2-TRg-3",
"PWP2g2_BC1-RPP0-NRg-4",
"PWP2g2_BC1-RPP0-NRg-3",
"PWP2g2_BC1-TOM40-TRg-4",
"PWP2g2_BC1-FUR1-NRg-12",
"PWP2g2_BC1-TOM40-TRg-2",
"PWP2g2_BC1-VMA11-NRg-4",
"PWP2g2_BC1-PGS1-NRg-4",
"PWP2g2_BC1-URB1-TRg-4",
"PWP2g2_BC1-ARP4-TRg-3",
"PWP2g2_BC1-RPT3-TRg-3",
"PWP2g2_BC1-SUI3-TRg-3",
"PWP2g2_BC1-RFC5-NRg-2",
"PWP2g2_BC1-RRP14-TRg-2",
"PWP2g2_BC1-SCC2-TRg-1",
"PWP2g2_BC1-SSC1-TRg-3",
"PWP2g2_BC1-RRP9-TRg-3",
"PWP2g2_BC1-MOT1-NRg-9",
"PWP2g2_BC1-RPL42A-NRg-2",
"PWP2g2_BC1-SEC16-TRg-7",
"PWP2g2_BC1-IMP4-NRg-2",
"PWP2g2_BC1-YEF3-NRg-4",
"PWP2g2_BC1-PUP1-TRg-1",
"PWP2g2_BC1-UTP22-TRg-6",
"PWP2g2_BC1-DBP2-NRg-4",
"PWP2g2_BC1-PRE2-TRg-7",
"PWP2g2_BC1-ATP16-TRg-6",
"PWP2g2_BC1-UTP13-TRg-4",
"PWP2g2_BC1-DOP1-NRg-4",
"PWP2g2_BC1-TIM44-TRg-3",
"PWP2g2_BC1-ATP16-TRg-2",
"PWP2g2_BC1-ENP1-NRg-3",
"PWP2g2_BC1-NAF1-TRg-3",
"PWP2g2_BC1-COG4-TRg-2",
"PWP2g2_BC1-SOG2-TRg-7",
"PWP2g2_BC1-YDR341C-TRg-3",
"PWP2g2_BC1-YMR290W-A-TRg-10",
"PWP2g2_BC1-NUP192-NRg-9",
"PWP2g2_BC1-RPS31-NRg-8",
"PWP2g2_BC1-SPC97-NRg-6",
"PWP2g2_BC1-EBP2-NRg-1",
"PWP2g2_BC1-CDC48-TRg-5",
"PWP2g2_BC1-RPT1-TRg-4",
"PWP2g2_BC1-ULP1-NRg-2",
"PWP2g2_BC1-RPN3-TRg-6",
"PWP2g2_BC1-RPT1-TRg-5",
"PWP2g2_BC1-KRE5-TRg-2",
"PWP2g2_BC1-TBF1-NRg-8",
"PWP2g2_BC1-UTP22-NRg-4",
"PWP2g2_BC1-SSC1-NRg-4",
"PWP2g2_BC1-REB1-TRg-4",
"PWP2g2_BC1-CDC48-NRg-9",
"PWP2g2_BC1-FAS2-TRg-8",
"PWP2g2_BC1-TAO3-TRg-8",
"PWP2g2_BC1-CKS1-TRg-5",
"PWP2g2_BC1-YLR379W-TRg-7",
"PWP2g2_BC1-TEN1-NRg-2",
"PWP2g2_BC1-RPL42A-TRg-2",
"PWP2g2_BC1-SEC27-TRg-4",
"PWP2g2_BC1-TBF1-NRg-4",
"PWP2g2_BC1-RPT1-NRg-6",
"PWP2g2_BC1-COG1-TRg-3",
"PWP2g2_BC1-SUI1-TRg-6",
"PWP2g2_BC1-TIM23-TRg-6",
"PWP2g2_BC1-CDC48-NRg-6",
"PWP2g2_BC1-EPL1-TRg-5",
"PWP2g2_BC1-RPT5-TRg-8",
"PWP2g2_BC1-ATP16-NRg-4",
"PWP2g2_BC1-RPN6-TRg-3",
"PWP2g2_BC1-ERG9-NRg-6",
"PWP2g2_BC1-SMX3-TRg-1",
"PWP2g2_BC1-NCB2-NRg-3",
"PWP2g2_BC1-SEC16-NRg-12",
"PWP2g2_BC1-RPN6-TRg-2",
"PWP2g2_BC1-REB1-NRg-4",
"PWP2g2_BC1-ATP16-TRg-9",
"PWP2g2_BC1-ERG9-NRg-7",
"PWP2g2_BC2-RPL15A-NRg-4",
"PWP2g2_BC2-RPL15A-NRg-5",
"PWP2g2_BC2-KRE33-TRg-1",
"PWP2g2_BC2-PMI40-NRg-1",
"PWP2g2_BC2-NOP19-NRg-3",
"PWP2g2_BC2-SRP14-NRg-4",
"PWP2g2_BC2-SEC27-TRg-2",
"PWP2g2_BC2-GPI14-TRg-3",
"PWP2g2_BC2-PAH1-TRg-7",
"PWP2g2_BC2-PAH1-TRg-6",
"PWP2g2_BC2-PAH1-TRg-5",
"PWP2g2_BC2-PAH1-TRg-3",
"PWP2g2_BC2-COG3-TRg-1",
"PWP2g2_BC2-HTS1-NRg-5",
"PWP2g2_BC2-MSN5-TRg-7",
"PWP2g2_BC2-ERG26-TRg-1",
"PWP2g2_BC2-SMD2-TRg-5",
"PWP2g2_BC2-SMD2-TRg-4",
"PWP2g2_BC2-SMD2-TRg-1",
"PWP2g2_BC2-PRE7-TRg-4",
"PWP2g2_BC2-PRE7-TRg-7",
"PWP2g2_BC2-SEC6-TRg-3",
"PWP2g2_BC2-ESF2-NRg-1",
"PWP2g2_BC2-ESF2-NRg-3",
"PWP2g2_BC2-AFG2-TRg-2",
"PWP2g2_BC2-RRP36-TRg-3",
"PWP2g2_BC2-RRP36-TRg-5",
"PWP2g2_BC2-GCR1-NRg-2",
"PWP2g2_BC2-PRE4-NRg-4",
"PWP2g2_BC2-PRE4-NRg-9",
"PWP2g2_BC2-DSN1-NRg-2",
"PWP2g2_BC2-GPI11-TRg-3",
"PWP2g2_BC2-POP3-TRg-1",
"PWP2g2_BC2-MNE1-TRg-5",
"PWP2g2_BC2-RRP12-NRg-1",
"PWP2g2_BC2-RSC6-TRg-2",
"PWP2g2_BC2-CDC25-TRg-1",
"PWP2g2_BC2-CDC25-TRg-9",
"PWP2g2_BC2-YPP1-NRg-3",
"PWP2g2_BC2-NFS1-NRg-9",
"PWP2g2_BC2-NFS1-NRg-8",
"PWP2g2_BC2-UBA2-TRg-1",
"PWP2g2_BC2-ARP2-NRg-3",
"PWP2g2_BC2-MAK16-TRg-1",
"PWP2g2_BC2-CEP3-NRg-1",
"PWP2g2_BC2-GUK1-TRg-5",
"PWP2g2_BC2-GUK1-TRg-2",
"PWP2g2_BC2-GPI12-NRg-6",
"PWP2g2_BC2-RPS5-NRg-5",
"PWP2g2_BC2-RPS5-NRg-2",
"PWP2g2_BC2-RPC19-NRg-1",
"PWP2g2_BC2-TIM54-TRg-1",
"PWP2g2_BC2-TEN1-TRg-2",
"PWP2g2_BC2-SAH1-NRg-4",
"PWP2g2_BC2-SAH1-NRg-5",
"PWP2g2_BC2-SAH1-NRg-3",
"PWP2g2_BC2-ATP15-NRg-5",
"PWP2g2_BC2-SCD5-TRg-5",
"PWP2g2_BC2-ARB1-NRg-2",
"PWP2g2_BC2-ARB1-NRg-4",
"PWP2g2_BC2-PUP2-TRg-1",
"PWP2g2_BC2-CCT8-TRg-2",
"PWP2g2_BC2-MCM4-TRg-1",
"PWP2g2_BC2-LSM4-TRg-1",
"PWP2g2_BC2-NOP53-NRg-1",
"PWP2g2_BC2-ATP3-TRg-4",
"PWP2g2_BC2-AFG2-NRg-3",
"PWP2g2_BC2-PRO3-NRg-3",
"PWP2g2_BC2-NRD1-NRg-10",
"PWP2g2_BC2-SEC61-TRg-2",
"PWP2g2_BC2-RHO3-TRg-4",
"PWP2g2_BC2-SNF2-TRg-6",
"PWP2g2_BC2-SMD2-NRg-3",
"PWP2g2_BC2-RSC4-TRg-2",
"PWP2g2_BC2-RSC4-TRg-1",
"PWP2g2_BC2-TIF34-TRg-2",
"PWP2g2_BC2-BET1-NRg-1",
"PWP2g2_BC2-CDC8-NRg-2",
"PWP2g2_BC2-PRP42-TRg-2",
"PWP2g2_BC2-RRB1-TRg-2",
"PWP2g2_BC2-SPC24-TRg-1",
"PWP2g2_BC2-ILS1-NRg-1",
"PWP2g2_BC2-GFA1-TRg-2",
"PWP2g2_BC2-SEC21-NRg-10",
"PWP2g2_BC2-RPC10-NRg-1",
"PWP2g2_BC2-RPB10-TRg-3",
"PWP2g2_BC2-RPB10-TRg-2",
"PWP2g2_BC2-YNL181W-TRg-1",
"PWP2g2_BC2-RAD3-NRg-1",
"PWP2g2_BC2-NOP10-TRg-1",
"PWP2g2_BC2-BFR2-TRg-3",
"PWP2g2_BC2-MCM2-TRg-6",
"PWP2g2_BC2-MCM2-TRg-4",
"PWP2g2_BC2-MPP10-TRg-1",
"PWP2g2_BC2-RET2-TRg-4",
"PWP2g2_BC2-RET2-TRg-1",
"PWP2g2_BC2-RPS2-NRg-1",
"PWP2g2_BC2-RPS2-NRg-2",
"PWP2g2_BC2-ORC4-NRg-3",
"PWP2g2_BC2-TIP20-TRg-7",
"PWP2g2_BC2-SMT3-TRg-1",
"PWP2g2_BC2-MSS18-NRg-6",
"PWP2g2_BC2-YEF3-NRg-9",
"PWP2g2_BC2-ASK1-NRg-1",
"PWP2g2_BC2-SMC1-TRg-1",
"PWP2g2_BC2-NIP1-NRg-1",
"PWP2g2_BC2-RPP1-NRg-1",
"PWP2g2_BC2-YDJ1-TRg-6",
"PWP2g2_BC2-SUB2-NRg-1",
"PWP2g2_BC2-TIM10-NRg-8",
"PWP2g2_BC2-TIM10-NRg-4",
"PWP2g2_BC2-TIM10-NRg-7",
"PWP2g2_BC2-SKI6-TRg-4",
"PWP2g2_BC2-TUB4-TRg-1",
"PWP2g2_BC2-CDC37-NRg-2",
"PWP2g2_BC2-ISD11-TRg-3",
"PWP2g2_BC2-YOS1-TRg-4",
"PWP2g2_BC2-SSC1-TRg-6",
"PWP2g2_BC2-MTR3-TRg-5",
"PWP2g2_BC2-MTR3-TRg-6",
"PWP2g2_BC2-TFA1-TRg-2",
"PWP2g2_BC2-CDC3-NRg-3",
"PWP2g2_BC2-ERG25-TA-18",
"PWP2g2_BC2-RPB11-TRg-4",
"PWP2g2_BC2-RPB11-TRg-1",
"PWP2g2_BC2-RPB11-TRg-2",
"PWP2g2_BC2-DED1-TRg-3",
"PWP2g2_BC2-DED1-TRg-1",
"PWP2g2_BC2-DED1-TRg-6",
"PWP2g2_BC2-DED1-TRg-4",
"PWP2g2_BC2-RPL10-NRg-5",
"PWP2g2_BC2-RPL10-NRg-4",
"PWP2g2_BC2-EFB1-NRg-1",
"PWP2g2_BC2-EFB1-NRg-5",
"PWP2g2_BC2-EFB1-NRg-4",
"PWP2g2_BC2-RPT3-NRg-1",
"PWP2g2_BC2-SAC6-TRg-8",
"PWP2g2_BC2-SAC6-TRg-4",
"PWP2g2_BC2-SAC6-TRg-5",
"PWP2g2_BC2-SAC6-TRg-3",
"PWP2g2_BC2-DIM1-TRg-5",
"PWP2g2_BC2-DIM1-TRg-7",
"PWP2g2_BC2-RPC17-NRg-1",
"PWP2g2_BC2-RPC17-NRg-2",
"PWP2g2_BC2-YDR341C-TRg-1",
"PWP2g2_BC2-RAP1-NRg-8",
"PWP2g2_BC2-RAP1-NRg-5",
"PWP2g2_BC2-RAP1-NRg-2",
"PWP2g2_BC2-SEC26-NRg-3",
"PWP2g2_BC2-SPP41-TRg-3",
"PWP2g2_BC2-TAP42-NRg-1",
"PWP2g2_BC2-PGA2-TRg-6",
"PWP2g2_BC2-BRL1-TRg-1",
"PWP2g2_BC2-FOL2-TRg-1",
"PWP2g2_BC2-NAB3-NRg-5",
"PWP2g2_BC2-SNF4-TRg-4",
"PWP2g2_BC2-HRR25-TRg-2",
"PWP2g2_BC2-TRS23-TRg-4",
"PWP2g2_BC2-CTR86-TRg-4",
"PWP2g2_BC2-RPB5-TRg-5",
"PWP2g2_BC2-SPN1-NRg-2",
"PWP2g2_BC2-SPN1-NRg-1",
"PWP2g2_BC2-SEC61-NRg-1",
"PWP2g2_BC2-SEC61-NRg-7",
"PWP2g2_BC2-TUS1-TRg-3",
"PWP2g2_BC2-OLE1-NRg-2",
"PWP2g2_BC2-AFG2-TRg-1",
"PWP2g2_BC2-TOA2-NRg-1",
"PWP2g2_BC2-USO1-TRg-1",
"PWP2g2_BC2-UTP22-NRg-2",
"PWP2g2_BC2-RIB1-TRg-3",
"PWP2g2_BC2-RIB1-TRg-7",
"PWP2g2_BC2-RIB1-TRg-4",
"PWP2g2_BC2-COG1-TRg-1",
"PWP2g2_BC2-RPL32-NRg-2",
"PWP2g2_BC2-GLC7-NRg-3",
"PWP2g2_BC2-GLC7-NRg-4",
"PWP2g2_BC2-HSF1-TRg-2",
"PWP2g2_BC2-DAM1-NRg-5",
"PWP2g2_BC2-SEC18-TRg-4",
"PWP2g2_BC2-SEC18-TRg-5",
"PWP2g2_BC2-PAB1-NRg-3",
"PWP2g2_BC2-POP8-TRg-2",
"PWP2g2_BC2-PAB1-NRg-4",
"PWP2g2_BC2-BIG1-TRg-4",
"PWP2g2_BC2-BIG1-TRg-5",
"PWP2g2_BC2-BIG1-TRg-6",
"PWP2g2_BC2-RPO41-NRg-1",
"PWP2g2_BC2-RVB2-NRg-2",
"PWP2g2_BC2-PET117-NRg-8",
"PWP2g2_BC2-VPS45-NRg-9",
"PWP2g2_BC2-YCG1-NRg-1",
"PWP2g2_BC2-NOC4-NRg-1",
"PWP2g2_BC2-NMD3-NRg-2",
"PWP2g2_BC2-DRS1-TRg-2",
"PWP2g2_BC2-HTB1-NRg-2",
"PWP2g2_BC2-IPI1-TRg-2",
"PWP2g2_BC2-SEC18-NRg-1",
"PWP2g2_BC2-SEC18-NRg-2",
"PWP2g2_BC2-JIP5-NRg-2",
"PWP2g2_BC2-YPT1-TRg-3",
"PWP2g2_BC2-YPT1-TRg-2",
"PWP2g2_BC2-CLF1-NRg-2",
"PWP2g2_BC2-SNF2-NRg-7",
"PWP2g2_BC2-SNF2-NRg-4",
"PWP2g2_BC2-RPL25-NRg-1",
"PWP2g2_BC2-NOP56-TRg-1",
"PWP2g2_BC2-NOP56-TRg-2",
"PWP2g2_BC2-TRS31-TRg-1",
"PWP2g2_BC2-DBF4-TRg-2",
"PWP2g2_BC2-DBF4-TRg-1",
"PWP2g2_BC2-RPC19-TRg-4",
"PWP2g2_BC2-RPC19-TRg-6",
"PWP2g2_BC2-RPC19-TRg-3",
"PWP2g2_BC2-ROK1-NRg-1",
"PWP2g2_BC2-CDC33-TRg-4",
"PWP2g2_BC2-DHR2-TRg-3",
"PWP2g2_BC2-RRP42-NRg-5",
"PWP2g2_BC2-CLF1-TRg-1",
"PWP2g2_BC2-ERG11-NA-16",
"PWP2g2_BC2-VAS1-NRg-4",
"PWP2g2_BC2-PIK1-NRg-2",
"PWP2g2_BC2-SAR1-NRg-7",
"PWP2g2_BC2-SAR1-NRg-4",
"PWP2g2_BC2-RPS3-TRg-1",
"PWP2g2_BC2-YTM1-TRg-2",
"PWP2g2_BC2-SUI3-NRg-5",
"PWP2g2_BC2-SUI3-NRg-2",
"PWP2g2_BC2-RRP7-TRg-4",
"PWP2g2_BC2-RRP7-TRg-6",
"PWP2g2_BC2-NIP7-TRg-2",
"PWP2g2_BC2-MDM35-TRg-1",
"PWP2g2_BC2-ALA1-NRg-1",
"PWP2g2_BC2-DOA4-NRg-2",
"PWP2g2_BC2-RPS13-NRg-1",
"PWP2g2_BC2-YSF3-TRg-2",
"PWP2g2_BC2-RPS2-NRg-11",
"PWP2g2_BC2-SSL1-TRg-10",
"PWP2g2_BC2-NIP7-TRg-1",
"PWP2g2_BC2-LST8-NRg-1",
"PWP2g2_BC2-TAF4-TRg-3",
"PWP2g2_BC2-HAS1-TRg-2",
"PWP2g2_BC2-GLC7-TRg-2",
"PWP2g2_BC2-CDC45-NRg-1",
"PWP2g2_BC2-SEC22-NRg-8",
"PWP2g2_BC2-YOS1-TRg-2",
"PWP2g2_BC2-RBA50-TRg-3",
"PWP2g2_BC2-SPP41-NRg-2",
"PWP2g2_BC2-PRP46-TRg-2",
"PWP2g2_BC2-PGA2-NRg-1",
"PWP2g2_BC2-CBF5-TRg-3",
"PWP2g2_BC2-TCP1-NRg-3",
"PWP2g2_BC2-TCP1-NRg-2",
"PWP2g2_BC2-ERG26-NRg-2",
"PWP2g2_BC2-ERG26-NRg-4",
"PWP2g2_BC2-MES1-TRg-5",
"PWP2g2_BC2-HTS1-TRg-2",
"PWP2g2_BC2-SSS1-TRg-3",
"PWP2g2_BC2-SSS1-TRg-2",
"PWP2g2_BC2-SYS1-TRg-7",
"PWP2g2_BC2-SYS1-TRg-2",
"PWP2g2_BC2-SYS1-TRg-1",
"PWP2g2_BC2-BFR2-TRg-1",
"PWP2g2_BC2-EOS1-TRg-3",
"PWP2g2_BC2-TAF4-NRg-1",
"PWP2g2_BC2-ARL3-NRg-8",
"PWP2g2_BC2-RPN5-NRg-1",
"PWP2g2_BC2-TIM9-NRg-2",
"PWP2g2_BC2-NUP57-NRg-3",
"PWP2g2_BC2-VPS4-TRg-1",
"PWP2g2_BC2-CDC3-TRg-4",
"PWP2g2_BC2-BBP1-NRg-1",
"PWP2g2_BC2-BBP1-NRg-2",
"PWP2g2_BC2-USE1-NRg-3",
"PWP2g2_BC2-CCT7-TRg-1",
"PWP2g2_BC2-SAH1-TRg-3",
"PWP2g2_BC2-CHS2-TRg-1",
"PWP2g2_BC2-DPM1-TRg-2",
"PWP2g2_BC2-BBP1-TRg-1",
"PWP2g2_BC2-NRD1-TRg-4",
"PWP2g2_BC2-RPB3-NRg-1",
"PWP2g2_BC2-PHO85-NRg-6",
"PWP2g2_BC2-SNF6-TRg-6",
"PWP2g2_BC2-PRP38-NRg-2",
"PWP2g2_BC2-OAR1-NRg-3",
"PWP2g2_BC2-ROX3-NRg-1",
"PWP2g2_BC2-YPP1-TRg-6",
"PWP2g2_BC2-CBF2-NRg-8",
"PWP2g2_BC2-SPT6-TRg-5",
"PWP2g2_BC2-SEC10-NRg-1",
"PWP2g2_BC2-NSL1-NRg-3",
"PWP2g2_BC2-NRD1-NRg-8",
"PWP2g2_BC2-RPB3-TRg-1",
"PWP2g2_BC2-NRD1-NRg-4",
"PWP2g2_BC2-RVB1-TRg-2",
"PWP2g2_BC2-TIF5-NRg-8",
"PWP2g2_BC2-EOS1-NRg-1",
"PWP2g2_BC2-ERG25-NA-26",
"PWP2g2_BC2-MSL5-NRg-4",
"PWP2g2_BC2-SEC24-TRg-2",
"PWP2g2_BC2-RPL30-NRg-5",
"PWP2g2_BC2-SNU71-NRg-3",
"PWP2g2_BC2-CDC33-NRg-1",
"PWP2g2_BC2-RPN6-TRg-4",
"PWP2g2_BC2-NAB2-TRg-4",
"PWP2g2_BC2-NAB2-TRg-6",
"PWP2g2_BC2-YTM1-NRg-1",
"PWP2g2_BC2-OLE1-TRg-8",
"PWP2g2_BC2-OLE1-TRg-1",
"PWP2g2_BC2-UTP7-TRg-4",
"PWP2g2_BC2-ACT1-NRg-6",
"PWP2g2_BC2-RPL18A-NRg-3",
"PWP2g2_BC2-BRX1-NRg-1",
"PWP2g2_BC2-NAF1-TRg-8",
"PWP2g2_BC2-NAF1-TRg-6",
"PWP2g2_BC2-NAF1-TRg-4",
"PWP2g2_BC2-CDC8-TRg-2",
"PWP2g2_BC2-NSE4-TRg-1",
"PWP2g2_BC2-PAB1-NRg-2",
"PWP2g2_BC2-PRP43-TRg-4",
"PWP2g2_BC2-SEC2-NRg-3",
"PWP2g2_BC2-SEC2-NRg-6",
"PWP2g2_BC2-MPP10-NRg-5",
"PWP2g2_BC2-YDR355C-TRg-2",
"PWP2g2_BC2-YLR339C-TRg-9",
"PWP2g2_BC2-SNM1-TRg-2",
"PWP2g2_BC2-ALR1-NRg-4",
"PWP2g2_BC2-ALR1-NRg-1",
"PWP2g2_BC2-ALR1-NRg-3",
"PWP2g2_BC2-RPL10-TRg-1",
"PWP2g2_BC2-RPL28-TRg-2",
"PWP2g2_BC2-UTP25-TRg-1",
"PWP2g2_BC2-POB3-TRg-1",
"PWP2g2_BC2-POB3-TRg-3",
"PWP2g2_BC2-POB3-TRg-2",
"PWP2g2_BC2-MED11-TRg-1",
"PWP2g2_BC2-ISA1-TRg-15",
"PWP2g2_BC2-RRP1-NRg-1",
"PWP2g2_BC2-MES1-NRg-1",
"PWP2g2_BC2-SEC13-NRg-5",
"PWP2g2_BC2-MCM2-NRg-2",
"PWP2g2_BC2-ALA1-TRg-4",
"PWP2g2_BC2-MTG2-TRg-5",
"PWP2g2_BC2-TIF35-NRg-3",
"PWP2g2_BC2-NSE1-TRg-3",
"PWP2g2_BC2-NSE1-TRg-4",
"PWP2g2_BC2-MOB2-NRg-6",
"PWP2g2_BC2-VRG4-NRg-3",
"PWP2g2_BC2-PRP9-TRg-3",
"PWP2g2_BC2-HYM1-TRg-5",
"PWP2g2_BC2-POP1-TRg-5",
"PWP2g2_BC2-POP1-TRg-9",
"PWP2g2_BC2-RPL17A-TRg-1",
"PWP2g2_BC2-SLD2-TRg-1",
"PWP2g2_BC2-CDC48-NRg-7",
"PWP2g2_BC2-FHL1-NRg-2",
"PWP2g2_BC2-BET3-NRg-7",
"PWP2g2_BC2-MAK21-TRg-1",
"PWP2g2_BC2-BRN1-TRg-4",
"PWP2g2_BC2-FBA1-NRg-3",
"PWP2g2_BC2-CDC42-TRg-6",
"PWP2g2_BC2-CDC42-TRg-7",
"PWP2g2_BC2-COG4-NRg-1",
"PWP2g2_BC2-ATP3-NRg-3",
"PWP2g2_BC2-ATP3-NRg-2",
"PWP2g2_BC2-SMP3-TRg-5",
"PWP2g2_BC2-CFT2-NRg-2",
"PWP2g2_BC2-FAS2-TRg-5",
"PWP2g2_BC2-DBP2-NRg-3",
"PWP2g2_BC2-DBP2-NRg-2",
"PWP2g2_BC2-MPS2-NRg-4",
"PWP2g2_BC2-ARC35-TRg-2",
"PWP2g2_BC2-ARC35-TRg-5",
"PWP2g2_BC2-MRD1-TRg-1",
"PWP2g2_BC2-RLP7-TRg-1",
"PWP2g2_BC2-SPC34-TRg-1",
"PWP2g2_BC2-CDC45-TRg-2",
"PWP2g2_BC2-GCD6-TRg-3",
"PWP2g2_BC2-GCD6-TRg-4",
"PWP2g2_BC2-YPT6-NRg-2",
"PWP2g2_BC2-RPS13-TRg-2",
"PWP2g2_BC2-IPI3-TRg-3",
"PWP2g2_BC2-TIF5-NRg-9",
"PWP2g2_BC2-TIF5-NRg-7",
"PWP2g2_BC2-TIF5-NRg-6",
"PWP2g2_BC2-NAB3-TRg-3",
"PWP2g2_BC2-GCD2-TRg-1",
"PWP2g2_BC2-UBA1-TRg-2",
"PWP2g2_BC2-SLD3-TRg-6",
"PWP2g2_BC2-LCB1-TRg-5",
"PWP2g2_BC2-TOA2-TRg-6",
"PWP2g2_BC2-TOA2-TRg-1",
"PWP2g2_BC2-TOA2-TRg-3",
"PWP2g2_BC2-LSM2-TRg-1",
"PWP2g2_BC2-YML6-TRg-13",
"PWP2g2_BC2-YML6-TRg-12",
"PWP2g2_BC2-UTP15-NRg-1",
"PWP2g2_BC2-TIF6-NRg-8",
"PWP2g2_BC2-SUP35-NRg-1",
"PWP2g2_BC2-MPP10-NRg-1",
"PWP2g2_BC2-SWI3-TRg-7",
"PWP2g2_BC2-SSN3-NRg-2",
"PWP2g2_BC2-SEC13-NRg-7",
"PWP2g2_BC2-RPS15-NRg-3",
"PWP2g2_BC2-RPL3-TRg-2",
"PWP2g2_BC2-FBA1-NRg-2",
"PWP2g2_BC2-FBA1-NRg-1",
"PWP2g2_BC2-FBA1-NRg-5",
"PWP2g2_BC2-DAM1-TRg-2",
"PWP2g2_BC2-NHP2-TRg-2",
"PWP2g2_BC2-HCA4-NRg-6",
"PWP2g2_BC2-PRE3-TRg-4",
"PWP2g2_BC2-DBP5-NRg-4",
"PWP2g2_BC2-SPT6-NRg-4",
"PWP2g2_BC2-SPT6-NRg-2",
"PWP2g2_BC2-RPL18A-TRg-4",
"PWP2g2_BC2-KSH1-TRg-1",
"PWP2g2_BC2-KSH1-TRg-3",
"PWP2g2_BC2-IPI3-NRg-1",
"PWP2g2_BC2-PGA2-TRg-8",
"PWP2g2_BC2-RPL18A-TRg-2",
"PWP2g2_BC2-RPL33A-NRg-6",
"PWP2g2_BC2-TAF12-NRg-2",
"PWP2g2_BC2-USE1-TRg-5",
"PWP2g2_BC2-YNL114C-TRg-1",
"PWP2g2_BC2-SMC5-TRg-7",
"PWP2g2_BC2-SMC5-TRg-6",
"PWP2g2_BC2-RSC58-TRg-1",
"PWP2g2_BC2-CTF13-TRg-2",
"PWP2g2_BC2-NAB2-NRg-2",
"PWP2g2_BC2-MCM7-TRg-4",
"PWP2g2_BC2-BCP1-NRg-5",
"PWP2g2_BC2-STU2-TRg-3",
"PWP2g2_BC2-SEC21-NRg-6",
"PWP2g2_BC2-SEC21-NRg-3",
"PWP2g2_BC2-RPL1B-TRg-3",
"PWP2g2_BC2-SEC20-NRg-2",
"PWP2g2_BC2-VMA3-NRg-2",
"PWP2g2_BC2-SEC23-NRg-5",
"PWP2g2_BC2-CDC28-TRg-4",
"PWP2g2_BC2-RPN12-NRg-11",
"PWP2g2_BC2-PUP3-TRg-3",
"PWP2g2_BC2-SEC31-TRg-2",
"PWP2g2_BC2-SED5-TRg-6",
"PWP2g2_BC2-SED5-TRg-5",
"PWP2g2_BC2-RPL33A-TRg-1",
"PWP2g2_BC2-RPL33A-TRg-2",
"PWP2g2_BC2-MRPL11-TRg-2",
"PWP2g2_BC2-RTP1-NRg-2",
"PWP2g2_BC2-NUG1-TRg-2",
"PWP2g2_BC2-VPH2-TRg-4",
"PWP2g2_BC2-COP1-NRg-3",
"PWP2g2_BC2-CRM1-NRg-1",
"PWP2g2_BC2-RPL5-NRg-4",
"PWP2g2_BC2-SNU13-NRg-4",
"PWP2g2_BC2-PFS2-TRg-3",
"PWP2g2_BC2-MPP10-TRg-2",
"PWP2g2_BC2-TSR4-NRg-2",
"PWP2g2_BC2-RSC2-TRg-1",
"PWP2g2_BC2-SEC65-TRg-2",
"PWP2g2_BC2-SMI1-NRg-1",
"PWP2g2_BC2-RTT105-NRg-4",
"PWP2g2_BC2-VMA5-TRg-3",
"PWP2g2_BC2-VMA5-TRg-5",
"PWP2g2_BC2-RRP1-TRg-3",
"PWP2g2_BC2-CLC1-TRg-2",
"PWP2g2_BC2-GCD6-NRg-1",
"PWP2g2_BC2-GCD6-NRg-2",
"PWP2g2_BC2-PXR1-TRg-1",
"PWP2g2_BC2-CDC14-NRg-1",
"PWP2g2_BC2-PCF11-TRg-6",
"PWP2g2_BC2-PCF11-TRg-5",
"PWP2g2_BC2-PCF11-TRg-4",
"PWP2g2_BC2-SEC31-NRg-1",
"PWP2g2_BC2-RRP5-NRg-1",
"PWP2g2_BC2-PRE10-TRg-5",
"PWP2g2_BC2-PRE10-TRg-1",
"PWP2g2_BC2-RPS5-TRg-2",
"PWP2g2_BC2-NSP1-TRg-4",
"PWP2g2_BC2-PRP38-TRg-4",
"PWP2g2_BC2-RCF1-NRg-5",
"PWP2g2_BC2-RSC3-TRg-4",
"PWP2g2_BC2-RSC3-TRg-5",
"PWP2g2_BC2-RSC3-TRg-6",
"PWP2g2_BC2-HTA1-NRg-12",
"PWP2g2_BC2-HTA1-NRg-11",
"PWP2g2_BC2-UTP23-TRg-2",
"PWP2g2_BC2-GCD7-NRg-1",
"PWP2g2_BC2-GCD7-NRg-2",
"PWP2g2_BC2-GCD7-NRg-6",
"PWP2g2_BC2-GAL11-NRg-2",
"PWP2g2_BC2-GAL11-NRg-9",
"PWP2g2_BC2-PHO4-TRg-5",
"PWP2g2_BC2-SNP1-NRg-3",
"PWP2g2_BC2-RPC37-TRg-5",
"PWP2g2_BC2-CRM1-TRg-5",
"PWP2g2_BC2-CRM1-TRg-2",
"PWP2g2_BC2-ASK1-TRg-7",
"PWP2g2_BC2-STU2-NRg-4",
"PWP2g2_BC2-NEO1-NRg-3",
"PWP2g2_BC2-GAL11-TRg-5",
"PWP2g2_BC2-GAL11-TRg-7",
"PWP2g2_BC2-SAM50-NRg-3",
"PWP2g2_BC2-CSL4-TRg-2",
"PWP2g2_BC2-CCT5-TRg-2",
"PWP2g2_BC2-POL30-NRg-1",
"PWP2g2_BC2-MED4-TRg-4",
"PWP2g2_BC2-MED4-TRg-3",
"PWP2g2_BC2-MED4-TRg-2",
"PWP2g2_BC2-GDI1-TRg-4",
"PWP2g2_BC2-GDI1-TRg-3",
"PWP2g2_BC2-REB1-TRg-6",
"PWP2g2_BC2-MRPL37-NRg-2",
"PWP2g2_BC2-NOC3-TRg-3",
"PWP2g2_BC2-SPC97-TRg-3",
"PWP2g2_BC2-IPP1-TRg-3",
"PWP2g2_BC2-IPP1-TRg-2",
"PWP2g2_BC2-PTI1-TRg-3",
"PWP2g2_BC2-PTI1-TRg-5",
"PWP2g2_BC2-RFC5-NRg-1",
"PWP2g2_BC2-CDC24-TRg-1",
"PWP2g2_BC2-CDC24-TRg-3",
"PWP2g2_BC2-CDC24-TRg-5",
"PWP2g2_BC2-CDC24-TRg-6",
"PWP2g2_BC2-UTP23-TRg-6",
"PWP2g2_BC2-UTP23-TRg-4",
"PWP2g2_BC2-UTP23-TRg-1",
"PWP2g2_BC2-RHO3-NRg-4",
"PWP2g2_BC2-TRS23-NRg-1",
"PWP2g2_BC2-TRS23-NRg-3",
"PWP2g2_BC2-RSP5-TRg-2",
"PWP2g2_BC2-RSP5-TRg-1",
"PWP2g2_BC2-SDA1-NRg-1",
"PWP2g2_BC2-KAP95-TRg-8",
"PWP2g2_BC2-ACO1-TRg-6",
"PWP2g2_BC2-HTA1-NRg-3",
"PWP2g2_BC2-HTA1-NRg-2",
"PWP2g2_BC2-SPN1-TRg-1",
"PWP2g2_BC2-MOT1-NRg-7",
"PWP2g2_BC2-RPL17A-NRg-4",
"PWP2g2_BC2-ADA2-TRg-4",
"PWP2g2_BC2-SFH1-NRg-1",
"PWP2g2_BC2-SPC97-NRg-5",
"PWP2g2_BC2-PRP22-TRg-3",
"PWP2g2_BC2-SEN15-TRg-2",
"PWP2g2_BC2-RPL3-NRg-2",
"PWP2g2_BC2-ISD11-NRg-2",
"PWP2g2_BC2-HEM12-TRg-8",
"PWP2g2_BC2-SEC10-TRg-1",
"PWP2g2_BC2-HTB1-TRg-7",
"PWP2g2_BC2-TTI2-TRg-1",
"PWP2g2_BC2-ACP1-TRg-2",
"PWP2g2_BC2-ACP1-TRg-4",
"PWP2g2_BC2-GAL11-NRg-10",
"PWP2g2_BC2-UTP22-TRg-2",
"PWP2g2_BC2-MST1-NRg-5",
"PWP2g2_BC2-RIB7-NRg-2",
"PWP2g2_BC2-MCD1-TRg-6",
"PWP2g2_BC2-MCD1-TRg-5",
"PWP2g2_BC2-GPI8-NRg-2",
"PWP2g2_BC2-THS1-TRg-2",
"PWP2g2_BC2-RRP7-TRg-2",
"PWP2g2_BC2-RRP7-TRg-5",
"PWP2g2_BC2-SMX2-NRg-7",
"PWP2g2_BC2-RRP45-TRg-5",
"PWP2g2_BC2-RRP45-TRg-4",
"PWP2g2_BC2-CNS1-TRg-2",
"PWP2g2_BC2-FBP1-NRg-9",
"PWP2g2_BC2-GCD11-NRg-1",
"PWP2g2_BC2-RPL10-TRg-2",
"PWP2g2_BC2-NUP192-TRg-4",
"PWP2g2_BC2-NUP145-NRg-4",
"PWP2g2_BC2-HEM12-TRg-6",
"PWP2g2_BC2-PLC1-TRg-3",
"PWP2g2_BC2-RPA43-TRg-1",
"PWP2g2_BC2-RPB7-NRg-2",
"PWP2g2_BC2-RPB7-NRg-3",
"PWP2g2_BC2-NSL1-NRg-1",
"PWP2g2_BC2-UTP6-TRg-3",
"PWP2g2_BC2-UTP6-TRg-1",
"PWP2g2_BC2-YJU2-TRg-5",
"PWP2g2_BC2-FRS2-NRg-5",
"PWP2g2_BC2-TIF35-NRg-2",
"PWP2g2_BC2-GPI15-TRg-1",
"PWP2g2_BC2-NOP1-NRg-5",
"PWP2g2_BC2-GPI15-TRg-4",
"PWP2g2_BC2-COG4-TRg-1",
"PWP2g2_BC2-TFA1-TRg-1",
"PWP2g2_BC2-RHO1-NRg-2",
"PWP2g2_BC2-RHO1-NRg-1",
"PWP2g2_BC2-CDC55-NRg-2",
"PWP2g2_BC2-IDI1-NRg-7",
"PWP2g2_BC2-RPL32-TRg-5",
"PWP2g2_BC2-RPB5-TRg-4",
"PWP2g2_BC2-DIP2-TRg-5",
"PWP2g2_BC2-DIP2-TRg-1",
"PWP2g2_BC2-RPC40-TRg-2",
"PWP2g2_BC2-CDC6-TRg-5",
"PWP2g2_BC2-CDC6-TRg-3",
"PWP2g2_BC2-DAD2-TRg-2",
"PWP2g2_BC2-RVS161-TRg-2",
"PWP2g2_BC2-RVS161-TRg-1",
"PWP2g2_BC2-SUP45-NRg-3",
"PWP2g2_BC2-SRB6-NRg-5",
"PWP2g2_BC2-RPC11-TRg-4",
"PWP2g2_BC2-RKI1-TRg-8",
"PWP2g2_BC2-NIP7-TRg-3",
"PWP2g2_BC2-RPL33A-NRg-12",
"PWP2g2_BC2-SAM50-TRg-4",
"PWP2g2_BC2-NOP4-NRg-1",
"PWP2g2_BC2-NOP4-NRg-3",
"PWP2g2_BC2-SMX2-TRg-5",
"PWP2g2_BC2-POL12-NRg-2",
"PWP2g2_BC2-BMS1-NRg-2",
"PWP2g2_BC2-RPA190-TRg-5",
"PWP2g2_BC2-ALG14-NRg-4",
"PWP2g2_BC2-ALG14-NRg-1",
"PWP2g2_BC2-PRE5-NRg-1",
"PWP2g2_BC2-BIG1-NRg-2",
"PWP2g2_BC2-TFA2-TRg-4",
"PWP2g2_BC2-IMP4-TRg-6",
"PWP2g2_BC2-PAN1-NRg-1",
"PWP2g2_BC2-UTP13-TRg-2",
"PWP2g2_BC2-KAE1-NRg-3",
"PWP2g2_BC2-ERG20-TRg-1",
"PWP2g2_BC2-CDC20-TRg-6",
"PWP2g2_BC2-PWP2-NRg-2",
"PWP2g2_BC2-COG1-NRg-1",
"PWP2g2_BC2-RPL1B-TRg-4",
"PWP2g2_BC2-RPL1B-TRg-7",
"PWP2g2_BC2-UTP20-TRg-3",
"PWP2g2_BC2-UTP20-TRg-4",
"PWP2g2_BC2-RPL25-TRg-4",
"PWP2g2_BC2-RPL25-TRg-2",
"PWP2g2_BC2-MCM7-NRg-1",
"PWP2g2_BC2-MRP49-TRg-5",
"PWP2g2_BC2-ERO1-NRg-3",
"PWP2g2_BC2-UTP5-TRg-7",
"PWP2g2_BC2-MCM4-NRg-1",
"PWP2g2_BC2-PRE3-NRg-1",
"PWP2g2_BC2-FCF1-NRg-1",
"PWP2g2_BC2-CUS1-NRg-1",
"PWP2g2_BC2-PSF1-TRg-2",
"PWP2g2_BC2-BCP1-TRg-2",
"PWP2g2_BC2-PAN1-TRg-1",
"PWP2g2_BC2-PAN1-TRg-3",
"PWP2g2_BC2-PAN1-TRg-4",
"PWP2g2_BC2-VPS3-TRg-2",
"PWP2g2_BC2-YIL060W-NRg-1",
"PWP2g2_BC2-VPS53-NRg-1",
"PWP2g2_BC2-CYR1-TRg-4",
"PWP2g2_BC2-CYR1-TRg-7",
"PWP2g2_BC2-MPS1-NRg-1",
"PWP2g2_BC2-SRP1-TRg-5",
"PWP2g2_BC2-SRP1-TRg-4",
"PWP2g2_BC2-TAF12-TRg-2",
"PWP2g2_BC2-TAF12-TRg-3",
"PWP2g2_BC2-POP4-TRg-1",
"PWP2g2_BC2-SPT16-TRg-1",
"PWP2g2_BC2-NUP82-TRg-4",
"PWP2g2_BC2-DML1-TRg-3",
"PWP2g2_BC2-RPA43-NRg-3",
"PWP2g2_BC2-STU2-NRg-3",
"PWP2g2_BC2-POP4-NRg-4",
"PWP2g2_BC2-MCD1-TRg-2",
"PWP2g2_BC2-RPS3-NRg-4",
"PWP2g2_BC2-PRP9-TRg-4",
"PWP2g2_BC2-RPP1-NRg-2",
"PWP2g2_BC2-MTR2-NRg-11",
"PWP2g2_BC2-GCD11-TRg-1",
"PWP2g2_BC2-RPF1-TRg-3",
"PWP2g2_BC2-SUB2-NRg-4",
"PWP2g2_BC2-GPI15-TRg-3",
"PWP2g2_BC2-ERG9-TRg-6",
"PWP2g2_BC2-RPT2-NRg-1",
"PWP2g2_BC2-YOS1-NRg-3",
"PWP2g2_BC2-SCM3-TRg-4",
"PWP2g2_BC2-SCM3-TRg-6",
"PWP2g2_BC2-RLP7-NRg-1",
"PWP2g2_BC2-TFB2-NRg-4",
"PWP2g2_BC2-IMP4-TRg-1",
"PWP2g2_BC2-IMP4-TRg-3",
"PWP2g2_BC2-PRE4-TRg-3",
"PWP2g2_BC2-SUB2-TRg-3",
"PWP2g2_BC2-RPP0-NRg-4",
"PWP2g2_BC2-RPP0-NRg-3",
"PWP2g2_BC2-TOM40-TRg-4",
"PWP2g2_BC2-FUR1-NRg-12",
"PWP2g2_BC2-TOM40-TRg-2",
"PWP2g2_BC2-VMA11-NRg-4",
"PWP2g2_BC2-PGS1-NRg-4",
"PWP2g2_BC2-URB1-TRg-4",
"PWP2g2_BC2-ARP4-TRg-3",
"PWP2g2_BC2-RPT3-TRg-3",
"PWP2g2_BC2-SUI3-TRg-3",
"PWP2g2_BC2-RFC5-NRg-2",
"PWP2g2_BC2-RRP14-TRg-2",
"PWP2g2_BC2-SCC2-TRg-1",
"PWP2g2_BC2-SSC1-TRg-3",
"PWP2g2_BC2-RRP9-TRg-3",
"PWP2g2_BC2-MOT1-NRg-9",
"PWP2g2_BC2-RPL42A-NRg-2",
"PWP2g2_BC2-SEC16-TRg-7",
"PWP2g2_BC2-IMP4-NRg-2",
"PWP2g2_BC2-YEF3-NRg-4",
"PWP2g2_BC2-PUP1-TRg-1",
"PWP2g2_BC2-UTP22-TRg-6",
"PWP2g2_BC2-DBP2-NRg-4",
"PWP2g2_BC2-PRE2-TRg-7",
"PWP2g2_BC2-ATP16-TRg-6",
"PWP2g2_BC2-UTP13-TRg-4",
"PWP2g2_BC2-DOP1-NRg-4",
"PWP2g2_BC2-TIM44-TRg-3",
"PWP2g2_BC2-ATP16-TRg-2",
"PWP2g2_BC2-ENP1-NRg-3",
"PWP2g2_BC2-NAF1-TRg-3",
"PWP2g2_BC2-COG4-TRg-2",
"PWP2g2_BC2-SOG2-TRg-7",
"PWP2g2_BC2-YDR341C-TRg-3",
"PWP2g2_BC2-YMR290W-A-TRg-10",
"PWP2g2_BC2-NUP192-NRg-9",
"PWP2g2_BC2-RPS31-NRg-8",
"PWP2g2_BC2-SPC97-NRg-6",
"PWP2g2_BC2-EBP2-NRg-1",
"PWP2g2_BC2-CDC48-TRg-5",
"PWP2g2_BC2-RPT1-TRg-4",
"PWP2g2_BC2-ULP1-NRg-2",
"PWP2g2_BC2-RPN3-TRg-6",
"PWP2g2_BC2-RPT1-TRg-5",
"PWP2g2_BC2-KRE5-TRg-2",
"PWP2g2_BC2-TBF1-NRg-8",
"PWP2g2_BC2-UTP22-NRg-4",
"PWP2g2_BC2-SSC1-NRg-4",
"PWP2g2_BC2-REB1-TRg-4",
"PWP2g2_BC2-CDC48-NRg-9",
"PWP2g2_BC2-FAS2-TRg-8",
"PWP2g2_BC2-TAO3-TRg-8",
"PWP2g2_BC2-CKS1-TRg-5",
"PWP2g2_BC2-YLR379W-TRg-7",
"PWP2g2_BC2-TEN1-NRg-2",
"PWP2g2_BC2-RPL42A-TRg-2",
"PWP2g2_BC2-SEC27-TRg-4",
"PWP2g2_BC2-TBF1-NRg-4",
"PWP2g2_BC2-RPT1-NRg-6",
"PWP2g2_BC2-COG1-TRg-3",
"PWP2g2_BC2-SUI1-TRg-6",
"PWP2g2_BC2-TIM23-TRg-6",
"PWP2g2_BC2-CDC48-NRg-6",
"PWP2g2_BC2-EPL1-TRg-5",
"PWP2g2_BC2-RPT5-TRg-8",
"PWP2g2_BC2-ATP16-NRg-4",
"PWP2g2_BC2-RPN6-TRg-3",
"PWP2g2_BC2-ERG9-NRg-6",
"PWP2g2_BC2-SMX3-TRg-1",
"PWP2g2_BC2-NCB2-NRg-3",
"PWP2g2_BC2-SEC16-NRg-12",
"PWP2g2_BC2-RPN6-TRg-2",
"PWP2g2_BC2-REB1-NRg-4",
"PWP2g2_BC2-ATP16-TRg-9",
"PWP2g2_BC2-ERG9-NRg-7",
"TIF6g8-RPL15A-NRg-4",
"TIF6g8-RPL15A-NRg-5",
"TIF6g8-KRE33-TRg-1",
"TIF6g8-PMI40-NRg-1",
"TIF6g8-NOP19-NRg-3",
"TIF6g8-SRP14-NRg-4",
"TIF6g8-SEC27-TRg-2",
"TIF6g8-GPI14-TRg-3",
"TIF6g8-PAH1-TRg-7",
"TIF6g8-PAH1-TRg-6",
"TIF6g8-PAH1-TRg-5",
"TIF6g8-PAH1-TRg-3",
"TIF6g8-COG3-TRg-1",
"TIF6g8-HTS1-NRg-5",
"TIF6g8-MSN5-TRg-7",
"TIF6g8-ERG26-TRg-1",
"TIF6g8-SMD2-TRg-5",
"TIF6g8-SMD2-TRg-4",
"TIF6g8-SMD2-TRg-1",
"TIF6g8-PRE7-TRg-4",
"TIF6g8-PRE7-TRg-7",
"TIF6g8-SEC6-TRg-3",
"TIF6g8-ESF2-NRg-1",
"TIF6g8-ESF2-NRg-3",
"TIF6g8-AFG2-TRg-2",
"TIF6g8-RRP36-TRg-3",
"TIF6g8-RRP36-TRg-5",
"TIF6g8-GCR1-NRg-2",
"TIF6g8-PRE4-NRg-4",
"TIF6g8-PRE4-NRg-9",
"TIF6g8-DSN1-NRg-2",
"TIF6g8-GPI11-TRg-3",
"TIF6g8-POP3-TRg-1",
"TIF6g8-MNE1-TRg-5",
"TIF6g8-RRP12-NRg-1",
"TIF6g8-RSC6-TRg-2",
"TIF6g8-CDC25-TRg-1",
"TIF6g8-CDC25-TRg-9",
"TIF6g8-YPP1-NRg-3",
"TIF6g8-NFS1-NRg-9",
"TIF6g8-NFS1-NRg-8",
"TIF6g8-UBA2-TRg-1",
"TIF6g8-ARP2-NRg-3",
"TIF6g8-MAK16-TRg-1",
"TIF6g8-CEP3-NRg-1",
"TIF6g8-GUK1-TRg-5",
"TIF6g8-GUK1-TRg-2",
"TIF6g8-GPI12-NRg-6",
"TIF6g8-RPS5-NRg-5",
"TIF6g8-RPS5-NRg-2",
"TIF6g8-RPC19-NRg-1",
"TIF6g8-TIM54-TRg-1",
"TIF6g8-TEN1-TRg-2",
"TIF6g8-SAH1-NRg-4",
"TIF6g8-SAH1-NRg-5",
"TIF6g8-SAH1-NRg-3",
"TIF6g8-ATP15-NRg-5",
"TIF6g8-SCD5-TRg-5",
"TIF6g8-ARB1-NRg-2",
"TIF6g8-ARB1-NRg-4",
"TIF6g8-PUP2-TRg-1",
"TIF6g8-CCT8-TRg-2",
"TIF6g8-MCM4-TRg-1",
"TIF6g8-LSM4-TRg-1",
"TIF6g8-NOP53-NRg-1",
"TIF6g8-ATP3-TRg-4",
"TIF6g8-AFG2-NRg-3",
"TIF6g8-PRO3-NRg-3",
"TIF6g8-NRD1-NRg-10",
"TIF6g8-SEC61-TRg-2",
"TIF6g8-RHO3-TRg-4",
"TIF6g8-SNF2-TRg-6",
"TIF6g8-SMD2-NRg-3",
"TIF6g8-RSC4-TRg-2",
"TIF6g8-RSC4-TRg-1",
"TIF6g8-TIF34-TRg-2",
"TIF6g8-BET1-NRg-1",
"TIF6g8-CDC8-NRg-2",
"TIF6g8-PRP42-TRg-2",
"TIF6g8-RRB1-TRg-2",
"TIF6g8-SPC24-TRg-1",
"TIF6g8-ILS1-NRg-1",
"TIF6g8-GFA1-TRg-2",
"TIF6g8-SEC21-NRg-10",
"TIF6g8-RPC10-NRg-1",
"TIF6g8-RPB10-TRg-3",
"TIF6g8-RPB10-TRg-2",
"TIF6g8-YNL181W-TRg-1",
"TIF6g8-RAD3-NRg-1",
"TIF6g8-NOP10-TRg-1",
"TIF6g8-BFR2-TRg-3",
"TIF6g8-MCM2-TRg-6",
"TIF6g8-MCM2-TRg-4",
"TIF6g8-MPP10-TRg-1",
"TIF6g8-RET2-TRg-4",
"TIF6g8-RET2-TRg-1",
"TIF6g8-RPS2-NRg-1",
"TIF6g8-RPS2-NRg-2",
"TIF6g8-ORC4-NRg-3",
"TIF6g8-TIP20-TRg-7",
"TIF6g8-SMT3-TRg-1",
"TIF6g8-MSS18-NRg-6",
"TIF6g8-YEF3-NRg-9",
"TIF6g8-ASK1-NRg-1",
"TIF6g8-SMC1-TRg-1",
"TIF6g8-NIP1-NRg-1",
"TIF6g8-RPP1-NRg-1",
"TIF6g8-YDJ1-TRg-6",
"TIF6g8-SUB2-NRg-1",
"TIF6g8-TIM10-NRg-8",
"TIF6g8-TIM10-NRg-4",
"TIF6g8-TIM10-NRg-7",
"TIF6g8-SKI6-TRg-4",
"TIF6g8-TUB4-TRg-1",
"TIF6g8-CDC37-NRg-2",
"TIF6g8-ISD11-TRg-3",
"TIF6g8-YOS1-TRg-4",
"TIF6g8-SSC1-TRg-6",
"TIF6g8-MTR3-TRg-5",
"TIF6g8-MTR3-TRg-6",
"TIF6g8-TFA1-TRg-2",
"TIF6g8-CDC3-NRg-3",
"TIF6g8-ERG25-TA-18",
"TIF6g8-RPB11-TRg-4",
"TIF6g8-RPB11-TRg-1",
"TIF6g8-RPB11-TRg-2",
"TIF6g8-DED1-TRg-3",
"TIF6g8-DED1-TRg-1",
"TIF6g8-DED1-TRg-6",
"TIF6g8-DED1-TRg-4",
"TIF6g8-RPL10-NRg-5",
"TIF6g8-RPL10-NRg-4",
"TIF6g8-EFB1-NRg-1",
"TIF6g8-EFB1-NRg-5",
"TIF6g8-EFB1-NRg-4",
"TIF6g8-RPT3-NRg-1",
"TIF6g8-SAC6-TRg-8",
"TIF6g8-SAC6-TRg-4",
"TIF6g8-SAC6-TRg-5",
"TIF6g8-SAC6-TRg-3",
"TIF6g8-DIM1-TRg-5",
"TIF6g8-DIM1-TRg-7",
"TIF6g8-RPC17-NRg-1",
"TIF6g8-RPC17-NRg-2",
"TIF6g8-YDR341C-TRg-1",
"TIF6g8-RAP1-NRg-8",
"TIF6g8-RAP1-NRg-5",
"TIF6g8-RAP1-NRg-2",
"TIF6g8-SEC26-NRg-3",
"TIF6g8-SPP41-TRg-3",
"TIF6g8-TAP42-NRg-1",
"TIF6g8-PGA2-TRg-6",
"TIF6g8-BRL1-TRg-1",
"TIF6g8-FOL2-TRg-1",
"TIF6g8-NAB3-NRg-5",
"TIF6g8-SNF4-TRg-4",
"TIF6g8-HRR25-TRg-2",
"TIF6g8-TRS23-TRg-4",
"TIF6g8-CTR86-TRg-4",
"TIF6g8-RPB5-TRg-5",
"TIF6g8-SPN1-NRg-2",
"TIF6g8-SPN1-NRg-1",
"TIF6g8-SEC61-NRg-1",
"TIF6g8-SEC61-NRg-7",
"TIF6g8-TUS1-TRg-3",
"TIF6g8-OLE1-NRg-2",
"TIF6g8-AFG2-TRg-1",
"TIF6g8-TOA2-NRg-1",
"TIF6g8-USO1-TRg-1",
"TIF6g8-UTP22-NRg-2",
"TIF6g8-RIB1-TRg-3",
"TIF6g8-RIB1-TRg-7",
"TIF6g8-RIB1-TRg-4",
"TIF6g8-COG1-TRg-1",
"TIF6g8-RPL32-NRg-2",
"TIF6g8-GLC7-NRg-3",
"TIF6g8-GLC7-NRg-4",
"TIF6g8-HSF1-TRg-2",
"TIF6g8-DAM1-NRg-5",
"TIF6g8-SEC18-TRg-4",
"TIF6g8-SEC18-TRg-5",
"TIF6g8-PAB1-NRg-3",
"TIF6g8-POP8-TRg-2",
"TIF6g8-PAB1-NRg-4",
"TIF6g8-BIG1-TRg-4",
"TIF6g8-BIG1-TRg-5",
"TIF6g8-BIG1-TRg-6",
"TIF6g8-RPO41-NRg-1",
"TIF6g8-RVB2-NRg-2",
"TIF6g8-PET117-NRg-8",
"TIF6g8-VPS45-NRg-9",
"TIF6g8-YCG1-NRg-1",
"TIF6g8-NOC4-NRg-1",
"TIF6g8-NMD3-NRg-2",
"TIF6g8-DRS1-TRg-2",
"TIF6g8-HTB1-NRg-2",
"TIF6g8-IPI1-TRg-2",
"TIF6g8-SEC18-NRg-1",
"TIF6g8-SEC18-NRg-2",
"TIF6g8-JIP5-NRg-2",
"TIF6g8-YPT1-TRg-3",
"TIF6g8-YPT1-TRg-2",
"TIF6g8-CLF1-NRg-2",
"TIF6g8-SNF2-NRg-7",
"TIF6g8-SNF2-NRg-4",
"TIF6g8-RPL25-NRg-1",
"TIF6g8-NOP56-TRg-1",
"TIF6g8-NOP56-TRg-2",
"TIF6g8-TRS31-TRg-1",
"TIF6g8-DBF4-TRg-2",
"TIF6g8-DBF4-TRg-1",
"TIF6g8-RPC19-TRg-4",
"TIF6g8-RPC19-TRg-6",
"TIF6g8-RPC19-TRg-3",
"TIF6g8-ROK1-NRg-1",
"TIF6g8-CDC33-TRg-4",
"TIF6g8-DHR2-TRg-3",
"TIF6g8-RRP42-NRg-5",
"TIF6g8-CLF1-TRg-1",
"TIF6g8-ERG11-NA-16",
"TIF6g8-VAS1-NRg-4",
"TIF6g8-PIK1-NRg-2",
"TIF6g8-SAR1-NRg-7",
"TIF6g8-SAR1-NRg-4",
"TIF6g8-RPS3-TRg-1",
"TIF6g8-YTM1-TRg-2",
"TIF6g8-SUI3-NRg-5",
"TIF6g8-SUI3-NRg-2",
"TIF6g8-RRP7-TRg-4",
"TIF6g8-RRP7-TRg-6",
"TIF6g8-NIP7-TRg-2",
"TIF6g8-MDM35-TRg-1",
"TIF6g8-ALA1-NRg-1",
"TIF6g8-DOA4-NRg-2",
"TIF6g8-RPS13-NRg-1",
"TIF6g8-YSF3-TRg-2",
"TIF6g8-RPS2-NRg-11",
"TIF6g8-SSL1-TRg-10",
"TIF6g8-NIP7-TRg-1",
"TIF6g8-LST8-NRg-1",
"TIF6g8-TAF4-TRg-3",
"TIF6g8-HAS1-TRg-2",
"TIF6g8-GLC7-TRg-2",
"TIF6g8-CDC45-NRg-1",
"TIF6g8-SEC22-NRg-8",
"TIF6g8-YOS1-TRg-2",
"TIF6g8-RBA50-TRg-3",
"TIF6g8-SPP41-NRg-2",
"TIF6g8-PRP46-TRg-2",
"TIF6g8-PGA2-NRg-1",
"TIF6g8-CBF5-TRg-3",
"TIF6g8-TCP1-NRg-3",
"TIF6g8-TCP1-NRg-2",
"TIF6g8-ERG26-NRg-2",
"TIF6g8-ERG26-NRg-4",
"TIF6g8-MES1-TRg-5",
"TIF6g8-HTS1-TRg-2",
"TIF6g8-SSS1-TRg-3",
"TIF6g8-SSS1-TRg-2",
"TIF6g8-SYS1-TRg-7",
"TIF6g8-SYS1-TRg-2",
"TIF6g8-SYS1-TRg-1",
"TIF6g8-BFR2-TRg-1",
"TIF6g8-EOS1-TRg-3",
"TIF6g8-TAF4-NRg-1",
"TIF6g8-ARL3-NRg-8",
"TIF6g8-RPN5-NRg-1",
"TIF6g8-TIM9-NRg-2",
"TIF6g8-NUP57-NRg-3",
"TIF6g8-VPS4-TRg-1",
"TIF6g8-CDC3-TRg-4",
"TIF6g8-BBP1-NRg-1",
"TIF6g8-BBP1-NRg-2",
"TIF6g8-USE1-NRg-3",
"TIF6g8-CCT7-TRg-1",
"TIF6g8-SAH1-TRg-3",
"TIF6g8-CHS2-TRg-1",
"TIF6g8-DPM1-TRg-2",
"TIF6g8-BBP1-TRg-1",
"TIF6g8-NRD1-TRg-4",
"TIF6g8-RPB3-NRg-1",
"TIF6g8-PHO85-NRg-6",
"TIF6g8-SNF6-TRg-6",
"TIF6g8-PRP38-NRg-2",
"TIF6g8-OAR1-NRg-3",
"TIF6g8-ROX3-NRg-1",
"TIF6g8-YPP1-TRg-6",
"TIF6g8-CBF2-NRg-8",
"TIF6g8-SPT6-TRg-5",
"TIF6g8-SEC10-NRg-1",
"TIF6g8-NSL1-NRg-3",
"TIF6g8-NRD1-NRg-8",
"TIF6g8-RPB3-TRg-1",
"TIF6g8-NRD1-NRg-4",
"TIF6g8-RVB1-TRg-2",
"TIF6g8-TIF5-NRg-8",
"TIF6g8-EOS1-NRg-1",
"TIF6g8-ERG25-NA-26",
"TIF6g8-MSL5-NRg-4",
"TIF6g8-SEC24-TRg-2",
"TIF6g8-RPL30-NRg-5",
"TIF6g8-SNU71-NRg-3",
"TIF6g8-CDC33-NRg-1",
"TIF6g8-RPN6-TRg-4",
"TIF6g8-NAB2-TRg-4",
"TIF6g8-NAB2-TRg-6",
"TIF6g8-YTM1-NRg-1",
"TIF6g8-OLE1-TRg-8",
"TIF6g8-OLE1-TRg-1",
"TIF6g8-UTP7-TRg-4",
"TIF6g8-ACT1-NRg-6",
"TIF6g8-RPL18A-NRg-3",
"TIF6g8-BRX1-NRg-1",
"TIF6g8-NAF1-TRg-8",
"TIF6g8-NAF1-TRg-6",
"TIF6g8-NAF1-TRg-4",
"TIF6g8-CDC8-TRg-2",
"TIF6g8-NSE4-TRg-1",
"TIF6g8-PAB1-NRg-2",
"TIF6g8-PRP43-TRg-4",
"TIF6g8-SEC2-NRg-3",
"TIF6g8-SEC2-NRg-6",
"TIF6g8-MPP10-NRg-5",
"TIF6g8-YDR355C-TRg-2",
"TIF6g8-YLR339C-TRg-9",
"TIF6g8-SNM1-TRg-2",
"TIF6g8-ALR1-NRg-4",
"TIF6g8-ALR1-NRg-1",
"TIF6g8-ALR1-NRg-3",
"TIF6g8-RPL10-TRg-1",
"TIF6g8-RPL28-TRg-2",
"TIF6g8-UTP25-TRg-1",
"TIF6g8-POB3-TRg-1",
"TIF6g8-POB3-TRg-3",
"TIF6g8-POB3-TRg-2",
"TIF6g8-MED11-TRg-1",
"TIF6g8-ISA1-TRg-15",
"TIF6g8-RRP1-NRg-1",
"TIF6g8-MES1-NRg-1",
"TIF6g8-SEC13-NRg-5",
"TIF6g8-MCM2-NRg-2",
"TIF6g8-ALA1-TRg-4",
"TIF6g8-MTG2-TRg-5",
"TIF6g8-TIF35-NRg-3",
"TIF6g8-NSE1-TRg-3",
"TIF6g8-NSE1-TRg-4",
"TIF6g8-MOB2-NRg-6",
"TIF6g8-VRG4-NRg-3",
"TIF6g8-PRP9-TRg-3",
"TIF6g8-HYM1-TRg-5",
"TIF6g8-POP1-TRg-5",
"TIF6g8-POP1-TRg-9",
"TIF6g8-RPL17A-TRg-1",
"TIF6g8-SLD2-TRg-1",
"TIF6g8-CDC48-NRg-7",
"TIF6g8-FHL1-NRg-2",
"TIF6g8-BET3-NRg-7",
"TIF6g8-MAK21-TRg-1",
"TIF6g8-BRN1-TRg-4",
"TIF6g8-FBA1-NRg-3",
"TIF6g8-CDC42-TRg-6",
"TIF6g8-CDC42-TRg-7",
"TIF6g8-COG4-NRg-1",
"TIF6g8-ATP3-NRg-3",
"TIF6g8-ATP3-NRg-2",
"TIF6g8-SMP3-TRg-5",
"TIF6g8-CFT2-NRg-2",
"TIF6g8-FAS2-TRg-5",
"TIF6g8-DBP2-NRg-3",
"TIF6g8-DBP2-NRg-2",
"TIF6g8-MPS2-NRg-4",
"TIF6g8-ARC35-TRg-2",
"TIF6g8-ARC35-TRg-5",
"TIF6g8-MRD1-TRg-1",
"TIF6g8-RLP7-TRg-1",
"TIF6g8-SPC34-TRg-1",
"TIF6g8-CDC45-TRg-2",
"TIF6g8-GCD6-TRg-3",
"TIF6g8-GCD6-TRg-4",
"TIF6g8-YPT6-NRg-2",
"TIF6g8-RPS13-TRg-2",
"TIF6g8-IPI3-TRg-3",
"TIF6g8-TIF5-NRg-9",
"TIF6g8-TIF5-NRg-7",
"TIF6g8-TIF5-NRg-6",
"TIF6g8-NAB3-TRg-3",
"TIF6g8-GCD2-TRg-1",
"TIF6g8-UBA1-TRg-2",
"TIF6g8-SLD3-TRg-6",
"TIF6g8-LCB1-TRg-5",
"TIF6g8-TOA2-TRg-6",
"TIF6g8-TOA2-TRg-1",
"TIF6g8-TOA2-TRg-3",
"TIF6g8-LSM2-TRg-1",
"TIF6g8-YML6-TRg-13",
"TIF6g8-YML6-TRg-12",
"TIF6g8-UTP15-NRg-1",
"TIF6g8-TIF6-NRg-8",
"TIF6g8-SUP35-NRg-1",
"TIF6g8-MPP10-NRg-1",
"TIF6g8-SWI3-TRg-7",
"TIF6g8-SSN3-NRg-2",
"TIF6g8-SEC13-NRg-7",
"TIF6g8-RPS15-NRg-3",
"TIF6g8-RPL3-TRg-2",
"TIF6g8-FBA1-NRg-2",
"TIF6g8-FBA1-NRg-1",
"TIF6g8-FBA1-NRg-5",
"TIF6g8-DAM1-TRg-2",
"TIF6g8-NHP2-TRg-2",
"TIF6g8-HCA4-NRg-6",
"TIF6g8-PRE3-TRg-4",
"TIF6g8-DBP5-NRg-4",
"TIF6g8-SPT6-NRg-4",
"TIF6g8-SPT6-NRg-2",
"TIF6g8-RPL18A-TRg-4",
"TIF6g8-KSH1-TRg-1",
"TIF6g8-KSH1-TRg-3",
"TIF6g8-IPI3-NRg-1",
"TIF6g8-PGA2-TRg-8",
"TIF6g8-RPL18A-TRg-2",
"TIF6g8-RPL33A-NRg-6",
"TIF6g8-TAF12-NRg-2",
"TIF6g8-USE1-TRg-5",
"TIF6g8-YNL114C-TRg-1",
"TIF6g8-SMC5-TRg-7",
"TIF6g8-SMC5-TRg-6",
"TIF6g8-RSC58-TRg-1",
"TIF6g8-CTF13-TRg-2",
"TIF6g8-NAB2-NRg-2",
"TIF6g8-MCM7-TRg-4",
"TIF6g8-BCP1-NRg-5",
"TIF6g8-STU2-TRg-3",
"TIF6g8-SEC21-NRg-6",
"TIF6g8-SEC21-NRg-3",
"TIF6g8-RPL1B-TRg-3",
"TIF6g8-SEC20-NRg-2",
"TIF6g8-VMA3-NRg-2",
"TIF6g8-SEC23-NRg-5",
"TIF6g8-CDC28-TRg-4",
"TIF6g8-RPN12-NRg-11",
"TIF6g8-PUP3-TRg-3",
"TIF6g8-SEC31-TRg-2",
"TIF6g8-SED5-TRg-6",
"TIF6g8-SED5-TRg-5",
"TIF6g8-RPL33A-TRg-1",
"TIF6g8-RPL33A-TRg-2",
"TIF6g8-MRPL11-TRg-2",
"TIF6g8-RTP1-NRg-2",
"TIF6g8-NUG1-TRg-2",
"TIF6g8-VPH2-TRg-4",
"TIF6g8-COP1-NRg-3",
"TIF6g8-CRM1-NRg-1",
"TIF6g8-RPL5-NRg-4",
"TIF6g8-SNU13-NRg-4",
"TIF6g8-PFS2-TRg-3",
"TIF6g8-MPP10-TRg-2",
"TIF6g8-TSR4-NRg-2",
"TIF6g8-RSC2-TRg-1",
"TIF6g8-SEC65-TRg-2",
"TIF6g8-SMI1-NRg-1",
"TIF6g8-RTT105-NRg-4",
"TIF6g8-VMA5-TRg-3",
"TIF6g8-VMA5-TRg-5",
"TIF6g8-RRP1-TRg-3",
"TIF6g8-CLC1-TRg-2",
"TIF6g8-GCD6-NRg-1",
"TIF6g8-GCD6-NRg-2",
"TIF6g8-PXR1-TRg-1",
"TIF6g8-CDC14-NRg-1",
"TIF6g8-PCF11-TRg-6",
"TIF6g8-PCF11-TRg-5",
"TIF6g8-PCF11-TRg-4",
"TIF6g8-SEC31-NRg-1",
"TIF6g8-RRP5-NRg-1",
"TIF6g8-PRE10-TRg-5",
"TIF6g8-PRE10-TRg-1",
"TIF6g8-RPS5-TRg-2",
"TIF6g8-NSP1-TRg-4",
"TIF6g8-PRP38-TRg-4",
"TIF6g8-RCF1-NRg-5",
"TIF6g8-RSC3-TRg-4",
"TIF6g8-RSC3-TRg-5",
"TIF6g8-RSC3-TRg-6",
"TIF6g8-HTA1-NRg-12",
"TIF6g8-HTA1-NRg-11",
"TIF6g8-UTP23-TRg-2",
"TIF6g8-GCD7-NRg-1",
"TIF6g8-GCD7-NRg-2",
"TIF6g8-GCD7-NRg-6",
"TIF6g8-GAL11-NRg-2",
"TIF6g8-GAL11-NRg-9",
"TIF6g8-PHO4-TRg-5",
"TIF6g8-SNP1-NRg-3",
"TIF6g8-RPC37-TRg-5",
"TIF6g8-CRM1-TRg-5",
"TIF6g8-CRM1-TRg-2",
"TIF6g8-ASK1-TRg-7",
"TIF6g8-STU2-NRg-4",
"TIF6g8-NEO1-NRg-3",
"TIF6g8-GAL11-TRg-5",
"TIF6g8-GAL11-TRg-7",
"TIF6g8-SAM50-NRg-3",
"TIF6g8-CSL4-TRg-2",
"TIF6g8-CCT5-TRg-2",
"TIF6g8-POL30-NRg-1",
"TIF6g8-MED4-TRg-4",
"TIF6g8-MED4-TRg-3",
"TIF6g8-MED4-TRg-2",
"TIF6g8-GDI1-TRg-4",
"TIF6g8-GDI1-TRg-3",
"TIF6g8-REB1-TRg-6",
"TIF6g8-MRPL37-NRg-2",
"TIF6g8-NOC3-TRg-3",
"TIF6g8-SPC97-TRg-3",
"TIF6g8-IPP1-TRg-3",
"TIF6g8-IPP1-TRg-2",
"TIF6g8-PTI1-TRg-3",
"TIF6g8-PTI1-TRg-5",
"TIF6g8-RFC5-NRg-1",
"TIF6g8-CDC24-TRg-1",
"TIF6g8-CDC24-TRg-3",
"TIF6g8-CDC24-TRg-5",
"TIF6g8-CDC24-TRg-6",
"TIF6g8-UTP23-TRg-6",
"TIF6g8-UTP23-TRg-4",
"TIF6g8-UTP23-TRg-1",
"TIF6g8-RHO3-NRg-4",
"TIF6g8-TRS23-NRg-1",
"TIF6g8-TRS23-NRg-3",
"TIF6g8-RSP5-TRg-2",
"TIF6g8-RSP5-TRg-1",
"TIF6g8-SDA1-NRg-1",
"TIF6g8-KAP95-TRg-8",
"TIF6g8-ACO1-TRg-6",
"TIF6g8-HTA1-NRg-3",
"TIF6g8-HTA1-NRg-2",
"TIF6g8-SPN1-TRg-1",
"TIF6g8-MOT1-NRg-7",
"TIF6g8-RPL17A-NRg-4",
"TIF6g8-ADA2-TRg-4",
"TIF6g8-SFH1-NRg-1",
"TIF6g8-SPC97-NRg-5",
"TIF6g8-PRP22-TRg-3",
"TIF6g8-SEN15-TRg-2",
"TIF6g8-RPL3-NRg-2",
"TIF6g8-ISD11-NRg-2",
"TIF6g8-HEM12-TRg-8",
"TIF6g8-SEC10-TRg-1",
"TIF6g8-HTB1-TRg-7",
"TIF6g8-TTI2-TRg-1",
"TIF6g8-ACP1-TRg-2",
"TIF6g8-ACP1-TRg-4",
"TIF6g8-GAL11-NRg-10",
"TIF6g8-UTP22-TRg-2",
"TIF6g8-MST1-NRg-5",
"TIF6g8-RIB7-NRg-2",
"TIF6g8-MCD1-TRg-6",
"TIF6g8-MCD1-TRg-5",
"TIF6g8-GPI8-NRg-2",
"TIF6g8-THS1-TRg-2",
"TIF6g8-RRP7-TRg-2",
"TIF6g8-RRP7-TRg-5",
"TIF6g8-SMX2-NRg-7",
"TIF6g8-RRP45-TRg-5",
"TIF6g8-RRP45-TRg-4",
"TIF6g8-CNS1-TRg-2",
"TIF6g8-FBP1-NRg-9",
"TIF6g8-GCD11-NRg-1",
"TIF6g8-RPL10-TRg-2",
"TIF6g8-NUP192-TRg-4",
"TIF6g8-NUP145-NRg-4",
"TIF6g8-HEM12-TRg-6",
"TIF6g8-PLC1-TRg-3",
"TIF6g8-RPA43-TRg-1",
"TIF6g8-RPB7-NRg-2",
"TIF6g8-RPB7-NRg-3",
"TIF6g8-NSL1-NRg-1",
"TIF6g8-UTP6-TRg-3",
"TIF6g8-UTP6-TRg-1",
"TIF6g8-YJU2-TRg-5",
"TIF6g8-FRS2-NRg-5",
"TIF6g8-TIF35-NRg-2",
"TIF6g8-GPI15-TRg-1",
"TIF6g8-NOP1-NRg-5",
"TIF6g8-GPI15-TRg-4",
"TIF6g8-COG4-TRg-1",
"TIF6g8-TFA1-TRg-1",
"TIF6g8-RHO1-NRg-2",
"TIF6g8-RHO1-NRg-1",
"TIF6g8-CDC55-NRg-2",
"TIF6g8-IDI1-NRg-7",
"TIF6g8-RPL32-TRg-5",
"TIF6g8-RPB5-TRg-4",
"TIF6g8-DIP2-TRg-5",
"TIF6g8-DIP2-TRg-1",
"TIF6g8-RPC40-TRg-2",
"TIF6g8-CDC6-TRg-5",
"TIF6g8-CDC6-TRg-3",
"TIF6g8-DAD2-TRg-2",
"TIF6g8-RVS161-TRg-2",
"TIF6g8-RVS161-TRg-1",
"TIF6g8-SUP45-NRg-3",
"TIF6g8-SRB6-NRg-5",
"TIF6g8-RPC11-TRg-4",
"TIF6g8-RKI1-TRg-8",
"TIF6g8-NIP7-TRg-3",
"TIF6g8-RPL33A-NRg-12",
"TIF6g8-SAM50-TRg-4",
"TIF6g8-NOP4-NRg-1",
"TIF6g8-NOP4-NRg-3",
"TIF6g8-SMX2-TRg-5",
"TIF6g8-POL12-NRg-2",
"TIF6g8-BMS1-NRg-2",
"TIF6g8-RPA190-TRg-5",
"TIF6g8-ALG14-NRg-4",
"TIF6g8-ALG14-NRg-1",
"TIF6g8-PRE5-NRg-1",
"TIF6g8-BIG1-NRg-2",
"TIF6g8-TFA2-TRg-4",
"TIF6g8-IMP4-TRg-6",
"TIF6g8-PAN1-NRg-1",
"TIF6g8-UTP13-TRg-2",
"TIF6g8-KAE1-NRg-3",
"TIF6g8-ERG20-TRg-1",
"TIF6g8-CDC20-TRg-6",
"TIF6g8-PWP2-NRg-2",
"TIF6g8-COG1-NRg-1",
"TIF6g8-RPL1B-TRg-4",
"TIF6g8-RPL1B-TRg-7",
"TIF6g8-UTP20-TRg-3",
"TIF6g8-UTP20-TRg-4",
"TIF6g8-RPL25-TRg-4",
"TIF6g8-RPL25-TRg-2",
"TIF6g8-MCM7-NRg-1",
"TIF6g8-MRP49-TRg-5",
"TIF6g8-ERO1-NRg-3",
"TIF6g8-UTP5-TRg-7",
"TIF6g8-MCM4-NRg-1",
"TIF6g8-PRE3-NRg-1",
"TIF6g8-FCF1-NRg-1",
"TIF6g8-CUS1-NRg-1",
"TIF6g8-PSF1-TRg-2",
"TIF6g8-BCP1-TRg-2",
"TIF6g8-PAN1-TRg-1",
"TIF6g8-PAN1-TRg-3",
"TIF6g8-PAN1-TRg-4",
"TIF6g8-VPS3-TRg-2",
"TIF6g8-YIL060W-NRg-1",
"TIF6g8-VPS53-NRg-1",
"TIF6g8-CYR1-TRg-4",
"TIF6g8-CYR1-TRg-7",
"TIF6g8-MPS1-NRg-1",
"TIF6g8-SRP1-TRg-5",
"TIF6g8-SRP1-TRg-4",
"TIF6g8-TAF12-TRg-2",
"TIF6g8-TAF12-TRg-3",
"TIF6g8-POP4-TRg-1",
"TIF6g8-SPT16-TRg-1",
"TIF6g8-NUP82-TRg-4",
"TIF6g8-DML1-TRg-3",
"TIF6g8-RPA43-NRg-3",
"TIF6g8-STU2-NRg-3",
"TIF6g8-POP4-NRg-4",
"TIF6g8-MCD1-TRg-2",
"TIF6g8-RPS3-NRg-4",
"TIF6g8-PRP9-TRg-4",
"TIF6g8-RPP1-NRg-2",
"TIF6g8-MTR2-NRg-11",
"TIF6g8-GCD11-TRg-1",
"TIF6g8-RPF1-TRg-3",
"TIF6g8-SUB2-NRg-4",
"TIF6g8-GPI15-TRg-3",
"TIF6g8-ERG9-TRg-6",
"TIF6g8-RPT2-NRg-1",
"TIF6g8-YOS1-NRg-3",
"TIF6g8-SCM3-TRg-4",
"TIF6g8-SCM3-TRg-6",
"TIF6g8-RLP7-NRg-1",
"TIF6g8-TFB2-NRg-4",
"TIF6g8-IMP4-TRg-1",
"TIF6g8-IMP4-TRg-3",
"TIF6g8-PRE4-TRg-3",
"TIF6g8-SUB2-TRg-3",
"TIF6g8-RPP0-NRg-4",
"TIF6g8-RPP0-NRg-3",
"TIF6g8-TOM40-TRg-4",
"TIF6g8-FUR1-NRg-12",
"TIF6g8-TOM40-TRg-2",
"TIF6g8-VMA11-NRg-4",
"TIF6g8-PGS1-NRg-4",
"TIF6g8-URB1-TRg-4",
"TIF6g8-ARP4-TRg-3",
"TIF6g8-RPT3-TRg-3",
"TIF6g8-SUI3-TRg-3",
"TIF6g8-RFC5-NRg-2",
"TIF6g8-RRP14-TRg-2",
"TIF6g8-SCC2-TRg-1",
"TIF6g8-SSC1-TRg-3",
"TIF6g8-RRP9-TRg-3",
"TIF6g8-MOT1-NRg-9",
"TIF6g8-RPL42A-NRg-2",
"TIF6g8-SEC16-TRg-7",
"TIF6g8-IMP4-NRg-2",
"TIF6g8-YEF3-NRg-4",
"TIF6g8-PUP1-TRg-1",
"TIF6g8-UTP22-TRg-6",
"TIF6g8-DBP2-NRg-4",
"TIF6g8-PRE2-TRg-7",
"TIF6g8-ATP16-TRg-6",
"TIF6g8-UTP13-TRg-4",
"TIF6g8-DOP1-NRg-4",
"TIF6g8-TIM44-TRg-3",
"TIF6g8-ATP16-TRg-2",
"TIF6g8-ENP1-NRg-3",
"TIF6g8-NAF1-TRg-3",
"TIF6g8-COG4-TRg-2",
"TIF6g8-SOG2-TRg-7",
"TIF6g8-YDR341C-TRg-3",
"TIF6g8-YMR290W-A-TRg-10",
"TIF6g8-NUP192-NRg-9",
"TIF6g8-RPS31-NRg-8",
"TIF6g8-SPC97-NRg-6",
"TIF6g8-EBP2-NRg-1",
"TIF6g8-CDC48-TRg-5",
"TIF6g8-RPT1-TRg-4",
"TIF6g8-ULP1-NRg-2",
"TIF6g8-RPN3-TRg-6",
"TIF6g8-RPT1-TRg-5",
"TIF6g8-KRE5-TRg-2",
"TIF6g8-TBF1-NRg-8",
"TIF6g8-UTP22-NRg-4",
"TIF6g8-SSC1-NRg-4",
"TIF6g8-REB1-TRg-4",
"TIF6g8-CDC48-NRg-9",
"TIF6g8-FAS2-TRg-8",
"TIF6g8-TAO3-TRg-8",
"TIF6g8-CKS1-TRg-5",
"TIF6g8-YLR379W-TRg-7",
"TIF6g8-TEN1-NRg-2",
"TIF6g8-RPL42A-TRg-2",
"TIF6g8-SEC27-TRg-4",
"TIF6g8-TBF1-NRg-4",
"TIF6g8-RPT1-NRg-6",
"TIF6g8-COG1-TRg-3",
"TIF6g8-SUI1-TRg-6",
"TIF6g8-TIM23-TRg-6",
"TIF6g8-CDC48-NRg-6",
"TIF6g8-EPL1-TRg-5",
"TIF6g8-RPT5-TRg-8",
"TIF6g8-ATP16-NRg-4",
"TIF6g8-RPN6-TRg-3",
"TIF6g8-ERG9-NRg-6",
"TIF6g8-SMX3-TRg-1",
"TIF6g8-NCB2-NRg-3",
"TIF6g8-SEC16-NRg-12",
"TIF6g8-RPN6-TRg-2",
"TIF6g8-REB1-NRg-4",
"TIF6g8-ATP16-TRg-9",
"TIF6g8-ERG9-NRg-7",
"RPF1g3-RPL15A-NRg-4",
"RPF1g3-RPL15A-NRg-5",
"RPF1g3-KRE33-TRg-1",
"RPF1g3-PMI40-NRg-1",
"RPF1g3-NOP19-NRg-3",
"RPF1g3-SRP14-NRg-4",
"RPF1g3-SEC27-TRg-2",
"RPF1g3-GPI14-TRg-3",
"RPF1g3-PAH1-TRg-7",
"RPF1g3-PAH1-TRg-6",
"RPF1g3-PAH1-TRg-5",
"RPF1g3-PAH1-TRg-3",
"RPF1g3-COG3-TRg-1",
"RPF1g3-HTS1-NRg-5",
"RPF1g3-MSN5-TRg-7",
"RPF1g3-ERG26-TRg-1",
"RPF1g3-SMD2-TRg-5",
"RPF1g3-SMD2-TRg-4",
"RPF1g3-SMD2-TRg-1",
"RPF1g3-PRE7-TRg-4",
"RPF1g3-PRE7-TRg-7",
"RPF1g3-SEC6-TRg-3",
"RPF1g3-ESF2-NRg-1",
"RPF1g3-ESF2-NRg-3",
"RPF1g3-AFG2-TRg-2",
"RPF1g3-RRP36-TRg-3",
"RPF1g3-RRP36-TRg-5",
"RPF1g3-GCR1-NRg-2",
"RPF1g3-PRE4-NRg-4",
"RPF1g3-PRE4-NRg-9",
"RPF1g3-DSN1-NRg-2",
"RPF1g3-GPI11-TRg-3",
"RPF1g3-POP3-TRg-1",
"RPF1g3-MNE1-TRg-5",
"RPF1g3-RRP12-NRg-1",
"RPF1g3-RSC6-TRg-2",
"RPF1g3-CDC25-TRg-1",
"RPF1g3-CDC25-TRg-9",
"RPF1g3-YPP1-NRg-3",
"RPF1g3-NFS1-NRg-9",
"RPF1g3-NFS1-NRg-8",
"RPF1g3-UBA2-TRg-1",
"RPF1g3-ARP2-NRg-3",
"RPF1g3-MAK16-TRg-1",
"RPF1g3-CEP3-NRg-1",
"RPF1g3-GUK1-TRg-5",
"RPF1g3-GUK1-TRg-2",
"RPF1g3-GPI12-NRg-6",
"RPF1g3-RPS5-NRg-5",
"RPF1g3-RPS5-NRg-2",
"RPF1g3-RPC19-NRg-1",
"RPF1g3-TIM54-TRg-1",
"RPF1g3-TEN1-TRg-2",
"RPF1g3-SAH1-NRg-4",
"RPF1g3-SAH1-NRg-5",
"RPF1g3-SAH1-NRg-3",
"RPF1g3-ATP15-NRg-5",
"RPF1g3-SCD5-TRg-5",
"RPF1g3-ARB1-NRg-2",
"RPF1g3-ARB1-NRg-4",
"RPF1g3-PUP2-TRg-1",
"RPF1g3-CCT8-TRg-2",
"RPF1g3-MCM4-TRg-1",
"RPF1g3-LSM4-TRg-1",
"RPF1g3-NOP53-NRg-1",
"RPF1g3-ATP3-TRg-4",
"RPF1g3-AFG2-NRg-3",
"RPF1g3-PRO3-NRg-3",
"RPF1g3-NRD1-NRg-10",
"RPF1g3-SEC61-TRg-2",
"RPF1g3-RHO3-TRg-4",
"RPF1g3-SNF2-TRg-6",
"RPF1g3-SMD2-NRg-3",
"RPF1g3-RSC4-TRg-2",
"RPF1g3-RSC4-TRg-1",
"RPF1g3-TIF34-TRg-2",
"RPF1g3-BET1-NRg-1",
"RPF1g3-CDC8-NRg-2",
"RPF1g3-PRP42-TRg-2",
"RPF1g3-RRB1-TRg-2",
"RPF1g3-SPC24-TRg-1",
"RPF1g3-ILS1-NRg-1",
"RPF1g3-GFA1-TRg-2",
"RPF1g3-SEC21-NRg-10",
"RPF1g3-RPC10-NRg-1",
"RPF1g3-RPB10-TRg-3",
"RPF1g3-RPB10-TRg-2",
"RPF1g3-YNL181W-TRg-1",
"RPF1g3-RAD3-NRg-1",
"RPF1g3-NOP10-TRg-1",
"RPF1g3-BFR2-TRg-3",
"RPF1g3-MCM2-TRg-6",
"RPF1g3-MCM2-TRg-4",
"RPF1g3-MPP10-TRg-1",
"RPF1g3-RET2-TRg-4",
"RPF1g3-RET2-TRg-1",
"RPF1g3-RPS2-NRg-1",
"RPF1g3-RPS2-NRg-2",
"RPF1g3-ORC4-NRg-3",
"RPF1g3-TIP20-TRg-7",
"RPF1g3-SMT3-TRg-1",
"RPF1g3-MSS18-NRg-6",
"RPF1g3-YEF3-NRg-9",
"RPF1g3-ASK1-NRg-1",
"RPF1g3-SMC1-TRg-1",
"RPF1g3-NIP1-NRg-1",
"RPF1g3-RPP1-NRg-1",
"RPF1g3-YDJ1-TRg-6",
"RPF1g3-SUB2-NRg-1",
"RPF1g3-TIM10-NRg-8",
"RPF1g3-TIM10-NRg-4",
"RPF1g3-TIM10-NRg-7",
"RPF1g3-SKI6-TRg-4",
"RPF1g3-TUB4-TRg-1",
"RPF1g3-CDC37-NRg-2",
"RPF1g3-ISD11-TRg-3",
"RPF1g3-YOS1-TRg-4",
"RPF1g3-SSC1-TRg-6",
"RPF1g3-MTR3-TRg-5",
"RPF1g3-MTR3-TRg-6",
"RPF1g3-TFA1-TRg-2",
"RPF1g3-CDC3-NRg-3",
"RPF1g3-ERG25-TA-18",
"RPF1g3-RPB11-TRg-4",
"RPF1g3-RPB11-TRg-1",
"RPF1g3-RPB11-TRg-2",
"RPF1g3-DED1-TRg-3",
"RPF1g3-DED1-TRg-1",
"RPF1g3-DED1-TRg-6",
"RPF1g3-DED1-TRg-4",
"RPF1g3-RPL10-NRg-5",
"RPF1g3-RPL10-NRg-4",
"RPF1g3-EFB1-NRg-1",
"RPF1g3-EFB1-NRg-5",
"RPF1g3-EFB1-NRg-4",
"RPF1g3-RPT3-NRg-1",
"RPF1g3-SAC6-TRg-8",
"RPF1g3-SAC6-TRg-4",
"RPF1g3-SAC6-TRg-5",
"RPF1g3-SAC6-TRg-3",
"RPF1g3-DIM1-TRg-5",
"RPF1g3-DIM1-TRg-7",
"RPF1g3-RPC17-NRg-1",
"RPF1g3-RPC17-NRg-2",
"RPF1g3-YDR341C-TRg-1",
"RPF1g3-RAP1-NRg-8",
"RPF1g3-RAP1-NRg-5",
"RPF1g3-RAP1-NRg-2",
"RPF1g3-SEC26-NRg-3",
"RPF1g3-SPP41-TRg-3",
"RPF1g3-TAP42-NRg-1",
"RPF1g3-PGA2-TRg-6",
"RPF1g3-BRL1-TRg-1",
"RPF1g3-FOL2-TRg-1",
"RPF1g3-NAB3-NRg-5",
"RPF1g3-SNF4-TRg-4",
"RPF1g3-HRR25-TRg-2",
"RPF1g3-TRS23-TRg-4",
"RPF1g3-CTR86-TRg-4",
"RPF1g3-RPB5-TRg-5",
"RPF1g3-SPN1-NRg-2",
"RPF1g3-SPN1-NRg-1",
"RPF1g3-SEC61-NRg-1",
"RPF1g3-SEC61-NRg-7",
"RPF1g3-TUS1-TRg-3",
"RPF1g3-OLE1-NRg-2",
"RPF1g3-AFG2-TRg-1",
"RPF1g3-TOA2-NRg-1",
"RPF1g3-USO1-TRg-1",
"RPF1g3-UTP22-NRg-2",
"RPF1g3-RIB1-TRg-3",
"RPF1g3-RIB1-TRg-7",
"RPF1g3-RIB1-TRg-4",
"RPF1g3-COG1-TRg-1",
"RPF1g3-RPL32-NRg-2",
"RPF1g3-GLC7-NRg-3",
"RPF1g3-GLC7-NRg-4",
"RPF1g3-HSF1-TRg-2",
"RPF1g3-DAM1-NRg-5",
"RPF1g3-SEC18-TRg-4",
"RPF1g3-SEC18-TRg-5",
"RPF1g3-PAB1-NRg-3",
"RPF1g3-POP8-TRg-2",
"RPF1g3-PAB1-NRg-4",
"RPF1g3-BIG1-TRg-4",
"RPF1g3-BIG1-TRg-5",
"RPF1g3-BIG1-TRg-6",
"RPF1g3-RPO41-NRg-1",
"RPF1g3-RVB2-NRg-2",
"RPF1g3-PET117-NRg-8",
"RPF1g3-VPS45-NRg-9",
"RPF1g3-YCG1-NRg-1",
"RPF1g3-NOC4-NRg-1",
"RPF1g3-NMD3-NRg-2",
"RPF1g3-DRS1-TRg-2",
"RPF1g3-HTB1-NRg-2",
"RPF1g3-IPI1-TRg-2",
"RPF1g3-SEC18-NRg-1",
"RPF1g3-SEC18-NRg-2",
"RPF1g3-JIP5-NRg-2",
"RPF1g3-YPT1-TRg-3",
"RPF1g3-YPT1-TRg-2",
"RPF1g3-CLF1-NRg-2",
"RPF1g3-SNF2-NRg-7",
"RPF1g3-SNF2-NRg-4",
"RPF1g3-RPL25-NRg-1",
"RPF1g3-NOP56-TRg-1",
"RPF1g3-NOP56-TRg-2",
"RPF1g3-TRS31-TRg-1",
"RPF1g3-DBF4-TRg-2",
"RPF1g3-DBF4-TRg-1",
"RPF1g3-RPC19-TRg-4",
"RPF1g3-RPC19-TRg-6",
"RPF1g3-RPC19-TRg-3",
"RPF1g3-ROK1-NRg-1",
"RPF1g3-CDC33-TRg-4",
"RPF1g3-DHR2-TRg-3",
"RPF1g3-RRP42-NRg-5",
"RPF1g3-CLF1-TRg-1",
"RPF1g3-ERG11-NA-16",
"RPF1g3-VAS1-NRg-4",
"RPF1g3-PIK1-NRg-2",
"RPF1g3-SAR1-NRg-7",
"RPF1g3-SAR1-NRg-4",
"RPF1g3-RPS3-TRg-1",
"RPF1g3-YTM1-TRg-2",
"RPF1g3-SUI3-NRg-5",
"RPF1g3-SUI3-NRg-2",
"RPF1g3-RRP7-TRg-4",
"RPF1g3-RRP7-TRg-6",
"RPF1g3-NIP7-TRg-2",
"RPF1g3-MDM35-TRg-1",
"RPF1g3-ALA1-NRg-1",
"RPF1g3-DOA4-NRg-2",
"RPF1g3-RPS13-NRg-1",
"RPF1g3-YSF3-TRg-2",
"RPF1g3-RPS2-NRg-11",
"RPF1g3-SSL1-TRg-10",
"RPF1g3-NIP7-TRg-1",
"RPF1g3-LST8-NRg-1",
"RPF1g3-TAF4-TRg-3",
"RPF1g3-HAS1-TRg-2",
"RPF1g3-GLC7-TRg-2",
"RPF1g3-CDC45-NRg-1",
"RPF1g3-SEC22-NRg-8",
"RPF1g3-YOS1-TRg-2",
"RPF1g3-RBA50-TRg-3",
"RPF1g3-SPP41-NRg-2",
"RPF1g3-PRP46-TRg-2",
"RPF1g3-PGA2-NRg-1",
"RPF1g3-CBF5-TRg-3",
"RPF1g3-TCP1-NRg-3",
"RPF1g3-TCP1-NRg-2",
"RPF1g3-ERG26-NRg-2",
"RPF1g3-ERG26-NRg-4",
"RPF1g3-MES1-TRg-5",
"RPF1g3-HTS1-TRg-2",
"RPF1g3-SSS1-TRg-3",
"RPF1g3-SSS1-TRg-2",
"RPF1g3-SYS1-TRg-7",
"RPF1g3-SYS1-TRg-2",
"RPF1g3-SYS1-TRg-1",
"RPF1g3-BFR2-TRg-1",
"RPF1g3-EOS1-TRg-3",
"RPF1g3-TAF4-NRg-1",
"RPF1g3-ARL3-NRg-8",
"RPF1g3-RPN5-NRg-1",
"RPF1g3-TIM9-NRg-2",
"RPF1g3-NUP57-NRg-3",
"RPF1g3-VPS4-TRg-1",
"RPF1g3-CDC3-TRg-4",
"RPF1g3-BBP1-NRg-1",
"RPF1g3-BBP1-NRg-2",
"RPF1g3-USE1-NRg-3",
"RPF1g3-CCT7-TRg-1",
"RPF1g3-SAH1-TRg-3",
"RPF1g3-CHS2-TRg-1",
"RPF1g3-DPM1-TRg-2",
"RPF1g3-BBP1-TRg-1",
"RPF1g3-NRD1-TRg-4",
"RPF1g3-RPB3-NRg-1",
"RPF1g3-PHO85-NRg-6",
"RPF1g3-SNF6-TRg-6",
"RPF1g3-PRP38-NRg-2",
"RPF1g3-OAR1-NRg-3",
"RPF1g3-ROX3-NRg-1",
"RPF1g3-YPP1-TRg-6",
"RPF1g3-CBF2-NRg-8",
"RPF1g3-SPT6-TRg-5",
"RPF1g3-SEC10-NRg-1",
"RPF1g3-NSL1-NRg-3",
"RPF1g3-NRD1-NRg-8",
"RPF1g3-RPB3-TRg-1",
"RPF1g3-NRD1-NRg-4",
"RPF1g3-RVB1-TRg-2",
"RPF1g3-TIF5-NRg-8",
"RPF1g3-EOS1-NRg-1",
"RPF1g3-ERG25-NA-26",
"RPF1g3-MSL5-NRg-4",
"RPF1g3-SEC24-TRg-2",
"RPF1g3-RPL30-NRg-5",
"RPF1g3-SNU71-NRg-3",
"RPF1g3-CDC33-NRg-1",
"RPF1g3-RPN6-TRg-4",
"RPF1g3-NAB2-TRg-4",
"RPF1g3-NAB2-TRg-6",
"RPF1g3-YTM1-NRg-1",
"RPF1g3-OLE1-TRg-8",
"RPF1g3-OLE1-TRg-1",
"RPF1g3-UTP7-TRg-4",
"RPF1g3-ACT1-NRg-6",
"RPF1g3-RPL18A-NRg-3",
"RPF1g3-BRX1-NRg-1",
"RPF1g3-NAF1-TRg-8",
"RPF1g3-NAF1-TRg-6",
"RPF1g3-NAF1-TRg-4",
"RPF1g3-CDC8-TRg-2",
"RPF1g3-NSE4-TRg-1",
"RPF1g3-PAB1-NRg-2",
"RPF1g3-PRP43-TRg-4",
"RPF1g3-SEC2-NRg-3",
"RPF1g3-SEC2-NRg-6",
"RPF1g3-MPP10-NRg-5",
"RPF1g3-YDR355C-TRg-2",
"RPF1g3-YLR339C-TRg-9",
"RPF1g3-SNM1-TRg-2",
"RPF1g3-ALR1-NRg-4",
"RPF1g3-ALR1-NRg-1",
"RPF1g3-ALR1-NRg-3",
"RPF1g3-RPL10-TRg-1",
"RPF1g3-RPL28-TRg-2",
"RPF1g3-UTP25-TRg-1",
"RPF1g3-POB3-TRg-1",
"RPF1g3-POB3-TRg-3",
"RPF1g3-POB3-TRg-2",
"RPF1g3-MED11-TRg-1",
"RPF1g3-ISA1-TRg-15",
"RPF1g3-RRP1-NRg-1",
"RPF1g3-MES1-NRg-1",
"RPF1g3-SEC13-NRg-5",
"RPF1g3-MCM2-NRg-2",
"RPF1g3-ALA1-TRg-4",
"RPF1g3-MTG2-TRg-5",
"RPF1g3-TIF35-NRg-3",
"RPF1g3-NSE1-TRg-3",
"RPF1g3-NSE1-TRg-4",
"RPF1g3-MOB2-NRg-6",
"RPF1g3-VRG4-NRg-3",
"RPF1g3-PRP9-TRg-3",
"RPF1g3-HYM1-TRg-5",
"RPF1g3-POP1-TRg-5",
"RPF1g3-POP1-TRg-9",
"RPF1g3-RPL17A-TRg-1",
"RPF1g3-SLD2-TRg-1",
"RPF1g3-CDC48-NRg-7",
"RPF1g3-FHL1-NRg-2",
"RPF1g3-BET3-NRg-7",
"RPF1g3-MAK21-TRg-1",
"RPF1g3-BRN1-TRg-4",
"RPF1g3-FBA1-NRg-3",
"RPF1g3-CDC42-TRg-6",
"RPF1g3-CDC42-TRg-7",
"RPF1g3-COG4-NRg-1",
"RPF1g3-ATP3-NRg-3",
"RPF1g3-ATP3-NRg-2",
"RPF1g3-SMP3-TRg-5",
"RPF1g3-CFT2-NRg-2",
"RPF1g3-FAS2-TRg-5",
"RPF1g3-DBP2-NRg-3",
"RPF1g3-DBP2-NRg-2",
"RPF1g3-MPS2-NRg-4",
"RPF1g3-ARC35-TRg-2",
"RPF1g3-ARC35-TRg-5",
"RPF1g3-MRD1-TRg-1",
"RPF1g3-RLP7-TRg-1",
"RPF1g3-SPC34-TRg-1",
"RPF1g3-CDC45-TRg-2",
"RPF1g3-GCD6-TRg-3",
"RPF1g3-GCD6-TRg-4",
"RPF1g3-YPT6-NRg-2",
"RPF1g3-RPS13-TRg-2",
"RPF1g3-IPI3-TRg-3",
"RPF1g3-TIF5-NRg-9",
"RPF1g3-TIF5-NRg-7",
"RPF1g3-TIF5-NRg-6",
"RPF1g3-NAB3-TRg-3",
"RPF1g3-GCD2-TRg-1",
"RPF1g3-UBA1-TRg-2",
"RPF1g3-SLD3-TRg-6",
"RPF1g3-LCB1-TRg-5",
"RPF1g3-TOA2-TRg-6",
"RPF1g3-TOA2-TRg-1",
"RPF1g3-TOA2-TRg-3",
"RPF1g3-LSM2-TRg-1",
"RPF1g3-YML6-TRg-13",
"RPF1g3-YML6-TRg-12",
"RPF1g3-UTP15-NRg-1",
"RPF1g3-TIF6-NRg-8",
"RPF1g3-SUP35-NRg-1",
"RPF1g3-MPP10-NRg-1",
"RPF1g3-SWI3-TRg-7",
"RPF1g3-SSN3-NRg-2",
"RPF1g3-SEC13-NRg-7",
"RPF1g3-RPS15-NRg-3",
"RPF1g3-RPL3-TRg-2",
"RPF1g3-FBA1-NRg-2",
"RPF1g3-FBA1-NRg-1",
"RPF1g3-FBA1-NRg-5",
"RPF1g3-DAM1-TRg-2",
"RPF1g3-NHP2-TRg-2",
"RPF1g3-HCA4-NRg-6",
"RPF1g3-PRE3-TRg-4",
"RPF1g3-DBP5-NRg-4",
"RPF1g3-SPT6-NRg-4",
"RPF1g3-SPT6-NRg-2",
"RPF1g3-RPL18A-TRg-4",
"RPF1g3-KSH1-TRg-1",
"RPF1g3-KSH1-TRg-3",
"RPF1g3-IPI3-NRg-1",
"RPF1g3-PGA2-TRg-8",
"RPF1g3-RPL18A-TRg-2",
"RPF1g3-RPL33A-NRg-6",
"RPF1g3-TAF12-NRg-2",
"RPF1g3-USE1-TRg-5",
"RPF1g3-YNL114C-TRg-1",
"RPF1g3-SMC5-TRg-7",
"RPF1g3-SMC5-TRg-6",
"RPF1g3-RSC58-TRg-1",
"RPF1g3-CTF13-TRg-2",
"RPF1g3-NAB2-NRg-2",
"RPF1g3-MCM7-TRg-4",
"RPF1g3-BCP1-NRg-5",
"RPF1g3-STU2-TRg-3",
"RPF1g3-SEC21-NRg-6",
"RPF1g3-SEC21-NRg-3",
"RPF1g3-RPL1B-TRg-3",
"RPF1g3-SEC20-NRg-2",
"RPF1g3-VMA3-NRg-2",
"RPF1g3-SEC23-NRg-5",
"RPF1g3-CDC28-TRg-4",
"RPF1g3-RPN12-NRg-11",
"RPF1g3-PUP3-TRg-3",
"RPF1g3-SEC31-TRg-2",
"RPF1g3-SED5-TRg-6",
"RPF1g3-SED5-TRg-5",
"RPF1g3-RPL33A-TRg-1",
"RPF1g3-RPL33A-TRg-2",
"RPF1g3-MRPL11-TRg-2",
"RPF1g3-RTP1-NRg-2",
"RPF1g3-NUG1-TRg-2",
"RPF1g3-VPH2-TRg-4",
"RPF1g3-COP1-NRg-3",
"RPF1g3-CRM1-NRg-1",
"RPF1g3-RPL5-NRg-4",
"RPF1g3-SNU13-NRg-4",
"RPF1g3-PFS2-TRg-3",
"RPF1g3-MPP10-TRg-2",
"RPF1g3-TSR4-NRg-2",
"RPF1g3-RSC2-TRg-1",
"RPF1g3-SEC65-TRg-2",
"RPF1g3-SMI1-NRg-1",
"RPF1g3-RTT105-NRg-4",
"RPF1g3-VMA5-TRg-3",
"RPF1g3-VMA5-TRg-5",
"RPF1g3-RRP1-TRg-3",
"RPF1g3-CLC1-TRg-2",
"RPF1g3-GCD6-NRg-1",
"RPF1g3-GCD6-NRg-2",
"RPF1g3-PXR1-TRg-1",
"RPF1g3-CDC14-NRg-1",
"RPF1g3-PCF11-TRg-6",
"RPF1g3-PCF11-TRg-5",
"RPF1g3-PCF11-TRg-4",
"RPF1g3-SEC31-NRg-1",
"RPF1g3-RRP5-NRg-1",
"RPF1g3-PRE10-TRg-5",
"RPF1g3-PRE10-TRg-1",
"RPF1g3-RPS5-TRg-2",
"RPF1g3-NSP1-TRg-4",
"RPF1g3-PRP38-TRg-4",
"RPF1g3-RCF1-NRg-5",
"RPF1g3-RSC3-TRg-4",
"RPF1g3-RSC3-TRg-5",
"RPF1g3-RSC3-TRg-6",
"RPF1g3-HTA1-NRg-12",
"RPF1g3-HTA1-NRg-11",
"RPF1g3-UTP23-TRg-2",
"RPF1g3-GCD7-NRg-1",
"RPF1g3-GCD7-NRg-2",
"RPF1g3-GCD7-NRg-6",
"RPF1g3-GAL11-NRg-2",
"RPF1g3-GAL11-NRg-9",
"RPF1g3-PHO4-TRg-5",
"RPF1g3-SNP1-NRg-3",
"RPF1g3-RPC37-TRg-5",
"RPF1g3-CRM1-TRg-5",
"RPF1g3-CRM1-TRg-2",
"RPF1g3-ASK1-TRg-7",
"RPF1g3-STU2-NRg-4",
"RPF1g3-NEO1-NRg-3",
"RPF1g3-GAL11-TRg-5",
"RPF1g3-GAL11-TRg-7",
"RPF1g3-SAM50-NRg-3",
"RPF1g3-CSL4-TRg-2",
"RPF1g3-CCT5-TRg-2",
"RPF1g3-POL30-NRg-1",
"RPF1g3-MED4-TRg-4",
"RPF1g3-MED4-TRg-3",
"RPF1g3-MED4-TRg-2",
"RPF1g3-GDI1-TRg-4",
"RPF1g3-GDI1-TRg-3",
"RPF1g3-REB1-TRg-6",
"RPF1g3-MRPL37-NRg-2",
"RPF1g3-NOC3-TRg-3",
"RPF1g3-SPC97-TRg-3",
"RPF1g3-IPP1-TRg-3",
"RPF1g3-IPP1-TRg-2",
"RPF1g3-PTI1-TRg-3",
"RPF1g3-PTI1-TRg-5",
"RPF1g3-RFC5-NRg-1",
"RPF1g3-CDC24-TRg-1",
"RPF1g3-CDC24-TRg-3",
"RPF1g3-CDC24-TRg-5",
"RPF1g3-CDC24-TRg-6",
"RPF1g3-UTP23-TRg-6",
"RPF1g3-UTP23-TRg-4",
"RPF1g3-UTP23-TRg-1",
"RPF1g3-RHO3-NRg-4",
"RPF1g3-TRS23-NRg-1",
"RPF1g3-TRS23-NRg-3",
"RPF1g3-RSP5-TRg-2",
"RPF1g3-RSP5-TRg-1",
"RPF1g3-SDA1-NRg-1",
"RPF1g3-KAP95-TRg-8",
"RPF1g3-ACO1-TRg-6",
"RPF1g3-HTA1-NRg-3",
"RPF1g3-HTA1-NRg-2",
"RPF1g3-SPN1-TRg-1",
"RPF1g3-MOT1-NRg-7",
"RPF1g3-RPL17A-NRg-4",
"RPF1g3-ADA2-TRg-4",
"RPF1g3-SFH1-NRg-1",
"RPF1g3-SPC97-NRg-5",
"RPF1g3-PRP22-TRg-3",
"RPF1g3-SEN15-TRg-2",
"RPF1g3-RPL3-NRg-2",
"RPF1g3-ISD11-NRg-2",
"RPF1g3-HEM12-TRg-8",
"RPF1g3-SEC10-TRg-1",
"RPF1g3-HTB1-TRg-7",
"RPF1g3-TTI2-TRg-1",
"RPF1g3-ACP1-TRg-2",
"RPF1g3-ACP1-TRg-4",
"RPF1g3-GAL11-NRg-10",
"RPF1g3-UTP22-TRg-2",
"RPF1g3-MST1-NRg-5",
"RPF1g3-RIB7-NRg-2",
"RPF1g3-MCD1-TRg-6",
"RPF1g3-MCD1-TRg-5",
"RPF1g3-GPI8-NRg-2",
"RPF1g3-THS1-TRg-2",
"RPF1g3-RRP7-TRg-2",
"RPF1g3-RRP7-TRg-5",
"RPF1g3-SMX2-NRg-7",
"RPF1g3-RRP45-TRg-5",
"RPF1g3-RRP45-TRg-4",
"RPF1g3-CNS1-TRg-2",
"RPF1g3-FBP1-NRg-9",
"RPF1g3-GCD11-NRg-1",
"RPF1g3-RPL10-TRg-2",
"RPF1g3-NUP192-TRg-4",
"RPF1g3-NUP145-NRg-4",
"RPF1g3-HEM12-TRg-6",
"RPF1g3-PLC1-TRg-3",
"RPF1g3-RPA43-TRg-1",
"RPF1g3-RPB7-NRg-2",
"RPF1g3-RPB7-NRg-3",
"RPF1g3-NSL1-NRg-1",
"RPF1g3-UTP6-TRg-3",
"RPF1g3-UTP6-TRg-1",
"RPF1g3-YJU2-TRg-5",
"RPF1g3-FRS2-NRg-5",
"RPF1g3-TIF35-NRg-2",
"RPF1g3-GPI15-TRg-1",
"RPF1g3-NOP1-NRg-5",
"RPF1g3-GPI15-TRg-4",
"RPF1g3-COG4-TRg-1",
"RPF1g3-TFA1-TRg-1",
"RPF1g3-RHO1-NRg-2",
"RPF1g3-RHO1-NRg-1",
"RPF1g3-CDC55-NRg-2",
"RPF1g3-IDI1-NRg-7",
"RPF1g3-RPL32-TRg-5",
"RPF1g3-RPB5-TRg-4",
"RPF1g3-DIP2-TRg-5",
"RPF1g3-DIP2-TRg-1",
"RPF1g3-RPC40-TRg-2",
"RPF1g3-CDC6-TRg-5",
"RPF1g3-CDC6-TRg-3",
"RPF1g3-DAD2-TRg-2",
"RPF1g3-RVS161-TRg-2",
"RPF1g3-RVS161-TRg-1",
"RPF1g3-SUP45-NRg-3",
"RPF1g3-SRB6-NRg-5",
"RPF1g3-RPC11-TRg-4",
"RPF1g3-RKI1-TRg-8",
"RPF1g3-NIP7-TRg-3",
"RPF1g3-RPL33A-NRg-12",
"RPF1g3-SAM50-TRg-4",
"RPF1g3-NOP4-NRg-1",
"RPF1g3-NOP4-NRg-3",
"RPF1g3-SMX2-TRg-5",
"RPF1g3-POL12-NRg-2",
"RPF1g3-BMS1-NRg-2",
"RPF1g3-RPA190-TRg-5",
"RPF1g3-ALG14-NRg-4",
"RPF1g3-ALG14-NRg-1",
"RPF1g3-PRE5-NRg-1",
"RPF1g3-BIG1-NRg-2",
"RPF1g3-TFA2-TRg-4",
"RPF1g3-IMP4-TRg-6",
"RPF1g3-PAN1-NRg-1",
"RPF1g3-UTP13-TRg-2",
"RPF1g3-KAE1-NRg-3",
"RPF1g3-ERG20-TRg-1",
"RPF1g3-CDC20-TRg-6",
"RPF1g3-PWP2-NRg-2",
"RPF1g3-COG1-NRg-1",
"RPF1g3-RPL1B-TRg-4",
"RPF1g3-RPL1B-TRg-7",
"RPF1g3-UTP20-TRg-3",
"RPF1g3-UTP20-TRg-4",
"RPF1g3-RPL25-TRg-4",
"RPF1g3-RPL25-TRg-2",
"RPF1g3-MCM7-NRg-1",
"RPF1g3-MRP49-TRg-5",
"RPF1g3-ERO1-NRg-3",
"RPF1g3-UTP5-TRg-7",
"RPF1g3-MCM4-NRg-1",
"RPF1g3-PRE3-NRg-1",
"RPF1g3-FCF1-NRg-1",
"RPF1g3-CUS1-NRg-1",
"RPF1g3-PSF1-TRg-2",
"RPF1g3-BCP1-TRg-2",
"RPF1g3-PAN1-TRg-1",
"RPF1g3-PAN1-TRg-3",
"RPF1g3-PAN1-TRg-4",
"RPF1g3-VPS3-TRg-2",
"RPF1g3-YIL060W-NRg-1",
"RPF1g3-VPS53-NRg-1",
"RPF1g3-CYR1-TRg-4",
"RPF1g3-CYR1-TRg-7",
"RPF1g3-MPS1-NRg-1",
"RPF1g3-SRP1-TRg-5",
"RPF1g3-SRP1-TRg-4",
"RPF1g3-TAF12-TRg-2",
"RPF1g3-TAF12-TRg-3",
"RPF1g3-POP4-TRg-1",
"RPF1g3-SPT16-TRg-1",
"RPF1g3-NUP82-TRg-4",
"RPF1g3-DML1-TRg-3",
"RPF1g3-RPA43-NRg-3",
"RPF1g3-STU2-NRg-3",
"RPF1g3-POP4-NRg-4",
"RPF1g3-MCD1-TRg-2",
"RPF1g3-RPS3-NRg-4",
"RPF1g3-PRP9-TRg-4",
"RPF1g3-RPP1-NRg-2",
"RPF1g3-MTR2-NRg-11",
"RPF1g3-GCD11-TRg-1",
"RPF1g3-RPF1-TRg-3",
"RPF1g3-SUB2-NRg-4",
"RPF1g3-GPI15-TRg-3",
"RPF1g3-ERG9-TRg-6",
"RPF1g3-RPT2-NRg-1",
"RPF1g3-YOS1-NRg-3",
"RPF1g3-SCM3-TRg-4",
"RPF1g3-SCM3-TRg-6",
"RPF1g3-RLP7-NRg-1",
"RPF1g3-TFB2-NRg-4",
"RPF1g3-IMP4-TRg-1",
"RPF1g3-IMP4-TRg-3",
"RPF1g3-PRE4-TRg-3",
"RPF1g3-SUB2-TRg-3",
"RPF1g3-RPP0-NRg-4",
"RPF1g3-RPP0-NRg-3",
"RPF1g3-TOM40-TRg-4",
"RPF1g3-FUR1-NRg-12",
"RPF1g3-TOM40-TRg-2",
"RPF1g3-VMA11-NRg-4",
"RPF1g3-PGS1-NRg-4",
"RPF1g3-URB1-TRg-4",
"RPF1g3-ARP4-TRg-3",
"RPF1g3-RPT3-TRg-3",
"RPF1g3-SUI3-TRg-3",
"RPF1g3-RFC5-NRg-2",
"RPF1g3-RRP14-TRg-2",
"RPF1g3-SCC2-TRg-1",
"RPF1g3-SSC1-TRg-3",
"RPF1g3-RRP9-TRg-3",
"RPF1g3-MOT1-NRg-9",
"RPF1g3-RPL42A-NRg-2",
"RPF1g3-SEC16-TRg-7",
"RPF1g3-IMP4-NRg-2",
"RPF1g3-YEF3-NRg-4",
"RPF1g3-PUP1-TRg-1",
"RPF1g3-UTP22-TRg-6",
"RPF1g3-DBP2-NRg-4",
"RPF1g3-PRE2-TRg-7",
"RPF1g3-ATP16-TRg-6",
"RPF1g3-UTP13-TRg-4",
"RPF1g3-DOP1-NRg-4",
"RPF1g3-TIM44-TRg-3",
"RPF1g3-ATP16-TRg-2",
"RPF1g3-ENP1-NRg-3",
"RPF1g3-NAF1-TRg-3",
"RPF1g3-COG4-TRg-2",
"RPF1g3-SOG2-TRg-7",
"RPF1g3-YDR341C-TRg-3",
"RPF1g3-YMR290W-A-TRg-10",
"RPF1g3-NUP192-NRg-9",
"RPF1g3-RPS31-NRg-8",
"RPF1g3-SPC97-NRg-6",
"RPF1g3-EBP2-NRg-1",
"RPF1g3-CDC48-TRg-5",
"RPF1g3-RPT1-TRg-4",
"RPF1g3-ULP1-NRg-2",
"RPF1g3-RPN3-TRg-6",
"RPF1g3-RPT1-TRg-5",
"RPF1g3-KRE5-TRg-2",
"RPF1g3-TBF1-NRg-8",
"RPF1g3-UTP22-NRg-4",
"RPF1g3-SSC1-NRg-4",
"RPF1g3-REB1-TRg-4",
"RPF1g3-CDC48-NRg-9",
"RPF1g3-FAS2-TRg-8",
"RPF1g3-TAO3-TRg-8",
"RPF1g3-CKS1-TRg-5",
"RPF1g3-YLR379W-TRg-7",
"RPF1g3-TEN1-NRg-2",
"RPF1g3-RPL42A-TRg-2",
"RPF1g3-SEC27-TRg-4",
"RPF1g3-TBF1-NRg-4",
"RPF1g3-RPT1-NRg-6",
"RPF1g3-COG1-TRg-3",
"RPF1g3-SUI1-TRg-6",
"RPF1g3-TIM23-TRg-6",
"RPF1g3-CDC48-NRg-6",
"RPF1g3-EPL1-TRg-5",
"RPF1g3-RPT5-TRg-8",
"RPF1g3-ATP16-NRg-4",
"RPF1g3-RPN6-TRg-3",
"RPF1g3-ERG9-NRg-6",
"RPF1g3-SMX3-TRg-1",
"RPF1g3-NCB2-NRg-3",
"RPF1g3-SEC16-NRg-12",
"RPF1g3-RPN6-TRg-2",
"RPF1g3-REB1-NRg-4",
"RPF1g3-ATP16-TRg-9",
"RPF1g3-ERG9-NRg-7",
"MAK16g1-RPL15A-NRg-4",
"MAK16g1-RPL15A-NRg-5",
"MAK16g1-KRE33-TRg-1",
"MAK16g1-PMI40-NRg-1",
"MAK16g1-NOP19-NRg-3",
"MAK16g1-SRP14-NRg-4",
"MAK16g1-SEC27-TRg-2",
"MAK16g1-GPI14-TRg-3",
"MAK16g1-PAH1-TRg-7",
"MAK16g1-PAH1-TRg-6",
"MAK16g1-PAH1-TRg-5",
"MAK16g1-PAH1-TRg-3",
"MAK16g1-COG3-TRg-1",
"MAK16g1-HTS1-NRg-5",
"MAK16g1-MSN5-TRg-7",
"MAK16g1-ERG26-TRg-1",
"MAK16g1-SMD2-TRg-5",
"MAK16g1-SMD2-TRg-4",
"MAK16g1-SMD2-TRg-1",
"MAK16g1-PRE7-TRg-4",
"MAK16g1-PRE7-TRg-7",
"MAK16g1-SEC6-TRg-3",
"MAK16g1-ESF2-NRg-1",
"MAK16g1-ESF2-NRg-3",
"MAK16g1-AFG2-TRg-2",
"MAK16g1-RRP36-TRg-3",
"MAK16g1-RRP36-TRg-5",
"MAK16g1-GCR1-NRg-2",
"MAK16g1-PRE4-NRg-4",
"MAK16g1-PRE4-NRg-9",
"MAK16g1-DSN1-NRg-2",
"MAK16g1-GPI11-TRg-3",
"MAK16g1-POP3-TRg-1",
"MAK16g1-MNE1-TRg-5",
"MAK16g1-RRP12-NRg-1",
"MAK16g1-RSC6-TRg-2",
"MAK16g1-CDC25-TRg-1",
"MAK16g1-CDC25-TRg-9",
"MAK16g1-YPP1-NRg-3",
"MAK16g1-NFS1-NRg-9",
"MAK16g1-NFS1-NRg-8",
"MAK16g1-UBA2-TRg-1",
"MAK16g1-ARP2-NRg-3",
"MAK16g1-MAK16-TRg-1",
"MAK16g1-CEP3-NRg-1",
"MAK16g1-GUK1-TRg-5",
"MAK16g1-GUK1-TRg-2",
"MAK16g1-GPI12-NRg-6",
"MAK16g1-RPS5-NRg-5",
"MAK16g1-RPS5-NRg-2",
"MAK16g1-RPC19-NRg-1",
"MAK16g1-TIM54-TRg-1",
"MAK16g1-TEN1-TRg-2",
"MAK16g1-SAH1-NRg-4",
"MAK16g1-SAH1-NRg-5",
"MAK16g1-SAH1-NRg-3",
"MAK16g1-ATP15-NRg-5",
"MAK16g1-SCD5-TRg-5",
"MAK16g1-ARB1-NRg-2",
"MAK16g1-ARB1-NRg-4",
"MAK16g1-PUP2-TRg-1",
"MAK16g1-CCT8-TRg-2",
"MAK16g1-MCM4-TRg-1",
"MAK16g1-LSM4-TRg-1",
"MAK16g1-NOP53-NRg-1",
"MAK16g1-ATP3-TRg-4",
"MAK16g1-AFG2-NRg-3",
"MAK16g1-PRO3-NRg-3",
"MAK16g1-NRD1-NRg-10",
"MAK16g1-SEC61-TRg-2",
"MAK16g1-RHO3-TRg-4",
"MAK16g1-SNF2-TRg-6",
"MAK16g1-SMD2-NRg-3",
"MAK16g1-RSC4-TRg-2",
"MAK16g1-RSC4-TRg-1",
"MAK16g1-TIF34-TRg-2",
"MAK16g1-BET1-NRg-1",
"MAK16g1-CDC8-NRg-2",
"MAK16g1-PRP42-TRg-2",
"MAK16g1-RRB1-TRg-2",
"MAK16g1-SPC24-TRg-1",
"MAK16g1-ILS1-NRg-1",
"MAK16g1-GFA1-TRg-2",
"MAK16g1-SEC21-NRg-10",
"MAK16g1-RPC10-NRg-1",
"MAK16g1-RPB10-TRg-3",
"MAK16g1-RPB10-TRg-2",
"MAK16g1-YNL181W-TRg-1",
"MAK16g1-RAD3-NRg-1",
"MAK16g1-NOP10-TRg-1",
"MAK16g1-BFR2-TRg-3",
"MAK16g1-MCM2-TRg-6",
"MAK16g1-MCM2-TRg-4",
"MAK16g1-MPP10-TRg-1",
"MAK16g1-RET2-TRg-4",
"MAK16g1-RET2-TRg-1",
"MAK16g1-RPS2-NRg-1",
"MAK16g1-RPS2-NRg-2",
"MAK16g1-ORC4-NRg-3",
"MAK16g1-TIP20-TRg-7",
"MAK16g1-SMT3-TRg-1",
"MAK16g1-MSS18-NRg-6",
"MAK16g1-YEF3-NRg-9",
"MAK16g1-ASK1-NRg-1",
"MAK16g1-SMC1-TRg-1",
"MAK16g1-NIP1-NRg-1",
"MAK16g1-RPP1-NRg-1",
"MAK16g1-YDJ1-TRg-6",
"MAK16g1-SUB2-NRg-1",
"MAK16g1-TIM10-NRg-8",
"MAK16g1-TIM10-NRg-4",
"MAK16g1-TIM10-NRg-7",
"MAK16g1-SKI6-TRg-4",
"MAK16g1-TUB4-TRg-1",
"MAK16g1-CDC37-NRg-2",
"MAK16g1-ISD11-TRg-3",
"MAK16g1-YOS1-TRg-4",
"MAK16g1-SSC1-TRg-6",
"MAK16g1-MTR3-TRg-5",
"MAK16g1-MTR3-TRg-6",
"MAK16g1-TFA1-TRg-2",
"MAK16g1-CDC3-NRg-3",
"MAK16g1-ERG25-TA-18",
"MAK16g1-RPB11-TRg-4",
"MAK16g1-RPB11-TRg-1",
"MAK16g1-RPB11-TRg-2",
"MAK16g1-DED1-TRg-3",
"MAK16g1-DED1-TRg-1",
"MAK16g1-DED1-TRg-6",
"MAK16g1-DED1-TRg-4",
"MAK16g1-RPL10-NRg-5",
"MAK16g1-RPL10-NRg-4",
"MAK16g1-EFB1-NRg-1",
"MAK16g1-EFB1-NRg-5",
"MAK16g1-EFB1-NRg-4",
"MAK16g1-RPT3-NRg-1",
"MAK16g1-SAC6-TRg-8",
"MAK16g1-SAC6-TRg-4",
"MAK16g1-SAC6-TRg-5",
"MAK16g1-SAC6-TRg-3",
"MAK16g1-DIM1-TRg-5",
"MAK16g1-DIM1-TRg-7",
"MAK16g1-RPC17-NRg-1",
"MAK16g1-RPC17-NRg-2",
"MAK16g1-YDR341C-TRg-1",
"MAK16g1-RAP1-NRg-8",
"MAK16g1-RAP1-NRg-5",
"MAK16g1-RAP1-NRg-2",
"MAK16g1-SEC26-NRg-3",
"MAK16g1-SPP41-TRg-3",
"MAK16g1-TAP42-NRg-1",
"MAK16g1-PGA2-TRg-6",
"MAK16g1-BRL1-TRg-1",
"MAK16g1-FOL2-TRg-1",
"MAK16g1-NAB3-NRg-5",
"MAK16g1-SNF4-TRg-4",
"MAK16g1-HRR25-TRg-2",
"MAK16g1-TRS23-TRg-4",
"MAK16g1-CTR86-TRg-4",
"MAK16g1-RPB5-TRg-5",
"MAK16g1-SPN1-NRg-2",
"MAK16g1-SPN1-NRg-1",
"MAK16g1-SEC61-NRg-1",
"MAK16g1-SEC61-NRg-7",
"MAK16g1-TUS1-TRg-3",
"MAK16g1-OLE1-NRg-2",
"MAK16g1-AFG2-TRg-1",
"MAK16g1-TOA2-NRg-1",
"MAK16g1-USO1-TRg-1",
"MAK16g1-UTP22-NRg-2",
"MAK16g1-RIB1-TRg-3",
"MAK16g1-RIB1-TRg-7",
"MAK16g1-RIB1-TRg-4",
"MAK16g1-COG1-TRg-1",
"MAK16g1-RPL32-NRg-2",
"MAK16g1-GLC7-NRg-3",
"MAK16g1-GLC7-NRg-4",
"MAK16g1-HSF1-TRg-2",
"MAK16g1-DAM1-NRg-5",
"MAK16g1-SEC18-TRg-4",
"MAK16g1-SEC18-TRg-5",
"MAK16g1-PAB1-NRg-3",
"MAK16g1-POP8-TRg-2",
"MAK16g1-PAB1-NRg-4",
"MAK16g1-BIG1-TRg-4",
"MAK16g1-BIG1-TRg-5",
"MAK16g1-BIG1-TRg-6",
"MAK16g1-RPO41-NRg-1",
"MAK16g1-RVB2-NRg-2",
"MAK16g1-PET117-NRg-8",
"MAK16g1-VPS45-NRg-9",
"MAK16g1-YCG1-NRg-1",
"MAK16g1-NOC4-NRg-1",
"MAK16g1-NMD3-NRg-2",
"MAK16g1-DRS1-TRg-2",
"MAK16g1-HTB1-NRg-2",
"MAK16g1-IPI1-TRg-2",
"MAK16g1-SEC18-NRg-1",
"MAK16g1-SEC18-NRg-2",
"MAK16g1-JIP5-NRg-2",
"MAK16g1-YPT1-TRg-3",
"MAK16g1-YPT1-TRg-2",
"MAK16g1-CLF1-NRg-2",
"MAK16g1-SNF2-NRg-7",
"MAK16g1-SNF2-NRg-4",
"MAK16g1-RPL25-NRg-1",
"MAK16g1-NOP56-TRg-1",
"MAK16g1-NOP56-TRg-2",
"MAK16g1-TRS31-TRg-1",
"MAK16g1-DBF4-TRg-2",
"MAK16g1-DBF4-TRg-1",
"MAK16g1-RPC19-TRg-4",
"MAK16g1-RPC19-TRg-6",
"MAK16g1-RPC19-TRg-3",
"MAK16g1-ROK1-NRg-1",
"MAK16g1-CDC33-TRg-4",
"MAK16g1-DHR2-TRg-3",
"MAK16g1-RRP42-NRg-5",
"MAK16g1-CLF1-TRg-1",
"MAK16g1-ERG11-NA-16",
"MAK16g1-VAS1-NRg-4",
"MAK16g1-PIK1-NRg-2",
"MAK16g1-SAR1-NRg-7",
"MAK16g1-SAR1-NRg-4",
"MAK16g1-RPS3-TRg-1",
"MAK16g1-YTM1-TRg-2",
"MAK16g1-SUI3-NRg-5",
"MAK16g1-SUI3-NRg-2",
"MAK16g1-RRP7-TRg-4",
"MAK16g1-RRP7-TRg-6",
"MAK16g1-NIP7-TRg-2",
"MAK16g1-MDM35-TRg-1",
"MAK16g1-ALA1-NRg-1",
"MAK16g1-DOA4-NRg-2",
"MAK16g1-RPS13-NRg-1",
"MAK16g1-YSF3-TRg-2",
"MAK16g1-RPS2-NRg-11",
"MAK16g1-SSL1-TRg-10",
"MAK16g1-NIP7-TRg-1",
"MAK16g1-LST8-NRg-1",
"MAK16g1-TAF4-TRg-3",
"MAK16g1-HAS1-TRg-2",
"MAK16g1-GLC7-TRg-2",
"MAK16g1-CDC45-NRg-1",
"MAK16g1-SEC22-NRg-8",
"MAK16g1-YOS1-TRg-2",
"MAK16g1-RBA50-TRg-3",
"MAK16g1-SPP41-NRg-2",
"MAK16g1-PRP46-TRg-2",
"MAK16g1-PGA2-NRg-1",
"MAK16g1-CBF5-TRg-3",
"MAK16g1-TCP1-NRg-3",
"MAK16g1-TCP1-NRg-2",
"MAK16g1-ERG26-NRg-2",
"MAK16g1-ERG26-NRg-4",
"MAK16g1-MES1-TRg-5",
"MAK16g1-HTS1-TRg-2",
"MAK16g1-SSS1-TRg-3",
"MAK16g1-SSS1-TRg-2",
"MAK16g1-SYS1-TRg-7",
"MAK16g1-SYS1-TRg-2",
"MAK16g1-SYS1-TRg-1",
"MAK16g1-BFR2-TRg-1",
"MAK16g1-EOS1-TRg-3",
"MAK16g1-TAF4-NRg-1",
"MAK16g1-ARL3-NRg-8",
"MAK16g1-RPN5-NRg-1",
"MAK16g1-TIM9-NRg-2",
"MAK16g1-NUP57-NRg-3",
"MAK16g1-VPS4-TRg-1",
"MAK16g1-CDC3-TRg-4",
"MAK16g1-BBP1-NRg-1",
"MAK16g1-BBP1-NRg-2",
"MAK16g1-USE1-NRg-3",
"MAK16g1-CCT7-TRg-1",
"MAK16g1-SAH1-TRg-3",
"MAK16g1-CHS2-TRg-1",
"MAK16g1-DPM1-TRg-2",
"MAK16g1-BBP1-TRg-1",
"MAK16g1-NRD1-TRg-4",
"MAK16g1-RPB3-NRg-1",
"MAK16g1-PHO85-NRg-6",
"MAK16g1-SNF6-TRg-6",
"MAK16g1-PRP38-NRg-2",
"MAK16g1-OAR1-NRg-3",
"MAK16g1-ROX3-NRg-1",
"MAK16g1-YPP1-TRg-6",
"MAK16g1-CBF2-NRg-8",
"MAK16g1-SPT6-TRg-5",
"MAK16g1-SEC10-NRg-1",
"MAK16g1-NSL1-NRg-3",
"MAK16g1-NRD1-NRg-8",
"MAK16g1-RPB3-TRg-1",
"MAK16g1-NRD1-NRg-4",
"MAK16g1-RVB1-TRg-2",
"MAK16g1-TIF5-NRg-8",
"MAK16g1-EOS1-NRg-1",
"MAK16g1-ERG25-NA-26",
"MAK16g1-MSL5-NRg-4",
"MAK16g1-SEC24-TRg-2",
"MAK16g1-RPL30-NRg-5",
"MAK16g1-SNU71-NRg-3",
"MAK16g1-CDC33-NRg-1",
"MAK16g1-RPN6-TRg-4",
"MAK16g1-NAB2-TRg-4",
"MAK16g1-NAB2-TRg-6",
"MAK16g1-YTM1-NRg-1",
"MAK16g1-OLE1-TRg-8",
"MAK16g1-OLE1-TRg-1",
"MAK16g1-UTP7-TRg-4",
"MAK16g1-ACT1-NRg-6",
"MAK16g1-RPL18A-NRg-3",
"MAK16g1-BRX1-NRg-1",
"MAK16g1-NAF1-TRg-8",
"MAK16g1-NAF1-TRg-6",
"MAK16g1-NAF1-TRg-4",
"MAK16g1-CDC8-TRg-2",
"MAK16g1-NSE4-TRg-1",
"MAK16g1-PAB1-NRg-2",
"MAK16g1-PRP43-TRg-4",
"MAK16g1-SEC2-NRg-3",
"MAK16g1-SEC2-NRg-6",
"MAK16g1-MPP10-NRg-5",
"MAK16g1-YDR355C-TRg-2",
"MAK16g1-YLR339C-TRg-9",
"MAK16g1-SNM1-TRg-2",
"MAK16g1-ALR1-NRg-4",
"MAK16g1-ALR1-NRg-1",
"MAK16g1-ALR1-NRg-3",
"MAK16g1-RPL10-TRg-1",
"MAK16g1-RPL28-TRg-2",
"MAK16g1-UTP25-TRg-1",
"MAK16g1-POB3-TRg-1",
"MAK16g1-POB3-TRg-3",
"MAK16g1-POB3-TRg-2",
"MAK16g1-MED11-TRg-1",
"MAK16g1-ISA1-TRg-15",
"MAK16g1-RRP1-NRg-1",
"MAK16g1-MES1-NRg-1",
"MAK16g1-SEC13-NRg-5",
"MAK16g1-MCM2-NRg-2",
"MAK16g1-ALA1-TRg-4",
"MAK16g1-MTG2-TRg-5",
"MAK16g1-TIF35-NRg-3",
"MAK16g1-NSE1-TRg-3",
"MAK16g1-NSE1-TRg-4",
"MAK16g1-MOB2-NRg-6",
"MAK16g1-VRG4-NRg-3",
"MAK16g1-PRP9-TRg-3",
"MAK16g1-HYM1-TRg-5",
"MAK16g1-POP1-TRg-5",
"MAK16g1-POP1-TRg-9",
"MAK16g1-RPL17A-TRg-1",
"MAK16g1-SLD2-TRg-1",
"MAK16g1-CDC48-NRg-7",
"MAK16g1-FHL1-NRg-2",
"MAK16g1-BET3-NRg-7",
"MAK16g1-MAK21-TRg-1",
"MAK16g1-BRN1-TRg-4",
"MAK16g1-FBA1-NRg-3",
"MAK16g1-CDC42-TRg-6",
"MAK16g1-CDC42-TRg-7",
"MAK16g1-COG4-NRg-1",
"MAK16g1-ATP3-NRg-3",
"MAK16g1-ATP3-NRg-2",
"MAK16g1-SMP3-TRg-5",
"MAK16g1-CFT2-NRg-2",
"MAK16g1-FAS2-TRg-5",
"MAK16g1-DBP2-NRg-3",
"MAK16g1-DBP2-NRg-2",
"MAK16g1-MPS2-NRg-4",
"MAK16g1-ARC35-TRg-2",
"MAK16g1-ARC35-TRg-5",
"MAK16g1-MRD1-TRg-1",
"MAK16g1-RLP7-TRg-1",
"MAK16g1-SPC34-TRg-1",
"MAK16g1-CDC45-TRg-2",
"MAK16g1-GCD6-TRg-3",
"MAK16g1-GCD6-TRg-4",
"MAK16g1-YPT6-NRg-2",
"MAK16g1-RPS13-TRg-2",
"MAK16g1-IPI3-TRg-3",
"MAK16g1-TIF5-NRg-9",
"MAK16g1-TIF5-NRg-7",
"MAK16g1-TIF5-NRg-6",
"MAK16g1-NAB3-TRg-3",
"MAK16g1-GCD2-TRg-1",
"MAK16g1-UBA1-TRg-2",
"MAK16g1-SLD3-TRg-6",
"MAK16g1-LCB1-TRg-5",
"MAK16g1-TOA2-TRg-6",
"MAK16g1-TOA2-TRg-1",
"MAK16g1-TOA2-TRg-3",
"MAK16g1-LSM2-TRg-1",
"MAK16g1-YML6-TRg-13",
"MAK16g1-YML6-TRg-12",
"MAK16g1-UTP15-NRg-1",
"MAK16g1-TIF6-NRg-8",
"MAK16g1-SUP35-NRg-1",
"MAK16g1-MPP10-NRg-1",
"MAK16g1-SWI3-TRg-7",
"MAK16g1-SSN3-NRg-2",
"MAK16g1-SEC13-NRg-7",
"MAK16g1-RPS15-NRg-3",
"MAK16g1-RPL3-TRg-2",
"MAK16g1-FBA1-NRg-2",
"MAK16g1-FBA1-NRg-1",
"MAK16g1-FBA1-NRg-5",
"MAK16g1-DAM1-TRg-2",
"MAK16g1-NHP2-TRg-2",
"MAK16g1-HCA4-NRg-6",
"MAK16g1-PRE3-TRg-4",
"MAK16g1-DBP5-NRg-4",
"MAK16g1-SPT6-NRg-4",
"MAK16g1-SPT6-NRg-2",
"MAK16g1-RPL18A-TRg-4",
"MAK16g1-KSH1-TRg-1",
"MAK16g1-KSH1-TRg-3",
"MAK16g1-IPI3-NRg-1",
"MAK16g1-PGA2-TRg-8",
"MAK16g1-RPL18A-TRg-2",
"MAK16g1-RPL33A-NRg-6",
"MAK16g1-TAF12-NRg-2",
"MAK16g1-USE1-TRg-5",
"MAK16g1-YNL114C-TRg-1",
"MAK16g1-SMC5-TRg-7",
"MAK16g1-SMC5-TRg-6",
"MAK16g1-RSC58-TRg-1",
"MAK16g1-CTF13-TRg-2",
"MAK16g1-NAB2-NRg-2",
"MAK16g1-MCM7-TRg-4",
"MAK16g1-BCP1-NRg-5",
"MAK16g1-STU2-TRg-3",
"MAK16g1-SEC21-NRg-6",
"MAK16g1-SEC21-NRg-3",
"MAK16g1-RPL1B-TRg-3",
"MAK16g1-SEC20-NRg-2",
"MAK16g1-VMA3-NRg-2",
"MAK16g1-SEC23-NRg-5",
"MAK16g1-CDC28-TRg-4",
"MAK16g1-RPN12-NRg-11",
"MAK16g1-PUP3-TRg-3",
"MAK16g1-SEC31-TRg-2",
"MAK16g1-SED5-TRg-6",
"MAK16g1-SED5-TRg-5",
"MAK16g1-RPL33A-TRg-1",
"MAK16g1-RPL33A-TRg-2",
"MAK16g1-MRPL11-TRg-2",
"MAK16g1-RTP1-NRg-2",
"MAK16g1-NUG1-TRg-2",
"MAK16g1-VPH2-TRg-4",
"MAK16g1-COP1-NRg-3",
"MAK16g1-CRM1-NRg-1",
"MAK16g1-RPL5-NRg-4",
"MAK16g1-SNU13-NRg-4",
"MAK16g1-PFS2-TRg-3",
"MAK16g1-MPP10-TRg-2",
"MAK16g1-TSR4-NRg-2",
"MAK16g1-RSC2-TRg-1",
"MAK16g1-SEC65-TRg-2",
"MAK16g1-SMI1-NRg-1",
"MAK16g1-RTT105-NRg-4",
"MAK16g1-VMA5-TRg-3",
"MAK16g1-VMA5-TRg-5",
"MAK16g1-RRP1-TRg-3",
"MAK16g1-CLC1-TRg-2",
"MAK16g1-GCD6-NRg-1",
"MAK16g1-GCD6-NRg-2",
"MAK16g1-PXR1-TRg-1",
"MAK16g1-CDC14-NRg-1",
"MAK16g1-PCF11-TRg-6",
"MAK16g1-PCF11-TRg-5",
"MAK16g1-PCF11-TRg-4",
"MAK16g1-SEC31-NRg-1",
"MAK16g1-RRP5-NRg-1",
"MAK16g1-PRE10-TRg-5",
"MAK16g1-PRE10-TRg-1",
"MAK16g1-RPS5-TRg-2",
"MAK16g1-NSP1-TRg-4",
"MAK16g1-PRP38-TRg-4",
"MAK16g1-RCF1-NRg-5",
"MAK16g1-RSC3-TRg-4",
"MAK16g1-RSC3-TRg-5",
"MAK16g1-RSC3-TRg-6",
"MAK16g1-HTA1-NRg-12",
"MAK16g1-HTA1-NRg-11",
"MAK16g1-UTP23-TRg-2",
"MAK16g1-GCD7-NRg-1",
"MAK16g1-GCD7-NRg-2",
"MAK16g1-GCD7-NRg-6",
"MAK16g1-GAL11-NRg-2",
"MAK16g1-GAL11-NRg-9",
"MAK16g1-PHO4-TRg-5",
"MAK16g1-SNP1-NRg-3",
"MAK16g1-RPC37-TRg-5",
"MAK16g1-CRM1-TRg-5",
"MAK16g1-CRM1-TRg-2",
"MAK16g1-ASK1-TRg-7",
"MAK16g1-STU2-NRg-4",
"MAK16g1-NEO1-NRg-3",
"MAK16g1-GAL11-TRg-5",
"MAK16g1-GAL11-TRg-7",
"MAK16g1-SAM50-NRg-3",
"MAK16g1-CSL4-TRg-2",
"MAK16g1-CCT5-TRg-2",
"MAK16g1-POL30-NRg-1",
"MAK16g1-MED4-TRg-4",
"MAK16g1-MED4-TRg-3",
"MAK16g1-MED4-TRg-2",
"MAK16g1-GDI1-TRg-4",
"MAK16g1-GDI1-TRg-3",
"MAK16g1-REB1-TRg-6",
"MAK16g1-MRPL37-NRg-2",
"MAK16g1-NOC3-TRg-3",
"MAK16g1-SPC97-TRg-3",
"MAK16g1-IPP1-TRg-3",
"MAK16g1-IPP1-TRg-2",
"MAK16g1-PTI1-TRg-3",
"MAK16g1-PTI1-TRg-5",
"MAK16g1-RFC5-NRg-1",
"MAK16g1-CDC24-TRg-1",
"MAK16g1-CDC24-TRg-3",
"MAK16g1-CDC24-TRg-5",
"MAK16g1-CDC24-TRg-6",
"MAK16g1-UTP23-TRg-6",
"MAK16g1-UTP23-TRg-4",
"MAK16g1-UTP23-TRg-1",
"MAK16g1-RHO3-NRg-4",
"MAK16g1-TRS23-NRg-1",
"MAK16g1-TRS23-NRg-3",
"MAK16g1-RSP5-TRg-2",
"MAK16g1-RSP5-TRg-1",
"MAK16g1-SDA1-NRg-1",
"MAK16g1-KAP95-TRg-8",
"MAK16g1-ACO1-TRg-6",
"MAK16g1-HTA1-NRg-3",
"MAK16g1-HTA1-NRg-2",
"MAK16g1-SPN1-TRg-1",
"MAK16g1-MOT1-NRg-7",
"MAK16g1-RPL17A-NRg-4",
"MAK16g1-ADA2-TRg-4",
"MAK16g1-SFH1-NRg-1",
"MAK16g1-SPC97-NRg-5",
"MAK16g1-PRP22-TRg-3",
"MAK16g1-SEN15-TRg-2",
"MAK16g1-RPL3-NRg-2",
"MAK16g1-ISD11-NRg-2",
"MAK16g1-HEM12-TRg-8",
"MAK16g1-SEC10-TRg-1",
"MAK16g1-HTB1-TRg-7",
"MAK16g1-TTI2-TRg-1",
"MAK16g1-ACP1-TRg-2",
"MAK16g1-ACP1-TRg-4",
"MAK16g1-GAL11-NRg-10",
"MAK16g1-UTP22-TRg-2",
"MAK16g1-MST1-NRg-5",
"MAK16g1-RIB7-NRg-2",
"MAK16g1-MCD1-TRg-6",
"MAK16g1-MCD1-TRg-5",
"MAK16g1-GPI8-NRg-2",
"MAK16g1-THS1-TRg-2",
"MAK16g1-RRP7-TRg-2",
"MAK16g1-RRP7-TRg-5",
"MAK16g1-SMX2-NRg-7",
"MAK16g1-RRP45-TRg-5",
"MAK16g1-RRP45-TRg-4",
"MAK16g1-CNS1-TRg-2",
"MAK16g1-FBP1-NRg-9",
"MAK16g1-GCD11-NRg-1",
"MAK16g1-RPL10-TRg-2",
"MAK16g1-NUP192-TRg-4",
"MAK16g1-NUP145-NRg-4",
"MAK16g1-HEM12-TRg-6",
"MAK16g1-PLC1-TRg-3",
"MAK16g1-RPA43-TRg-1",
"MAK16g1-RPB7-NRg-2",
"MAK16g1-RPB7-NRg-3",
"MAK16g1-NSL1-NRg-1",
"MAK16g1-UTP6-TRg-3",
"MAK16g1-UTP6-TRg-1",
"MAK16g1-YJU2-TRg-5",
"MAK16g1-FRS2-NRg-5",
"MAK16g1-TIF35-NRg-2",
"MAK16g1-GPI15-TRg-1",
"MAK16g1-NOP1-NRg-5",
"MAK16g1-GPI15-TRg-4",
"MAK16g1-COG4-TRg-1",
"MAK16g1-TFA1-TRg-1",
"MAK16g1-RHO1-NRg-2",
"MAK16g1-RHO1-NRg-1",
"MAK16g1-CDC55-NRg-2",
"MAK16g1-IDI1-NRg-7",
"MAK16g1-RPL32-TRg-5",
"MAK16g1-RPB5-TRg-4",
"MAK16g1-DIP2-TRg-5",
"MAK16g1-DIP2-TRg-1",
"MAK16g1-RPC40-TRg-2",
"MAK16g1-CDC6-TRg-5",
"MAK16g1-CDC6-TRg-3",
"MAK16g1-DAD2-TRg-2",
"MAK16g1-RVS161-TRg-2",
"MAK16g1-RVS161-TRg-1",
"MAK16g1-SUP45-NRg-3",
"MAK16g1-SRB6-NRg-5",
"MAK16g1-RPC11-TRg-4",
"MAK16g1-RKI1-TRg-8",
"MAK16g1-NIP7-TRg-3",
"MAK16g1-RPL33A-NRg-12",
"MAK16g1-SAM50-TRg-4",
"MAK16g1-NOP4-NRg-1",
"MAK16g1-NOP4-NRg-3",
"MAK16g1-SMX2-TRg-5",
"MAK16g1-POL12-NRg-2",
"MAK16g1-BMS1-NRg-2",
"MAK16g1-RPA190-TRg-5",
"MAK16g1-ALG14-NRg-4",
"MAK16g1-ALG14-NRg-1",
"MAK16g1-PRE5-NRg-1",
"MAK16g1-BIG1-NRg-2",
"MAK16g1-TFA2-TRg-4",
"MAK16g1-IMP4-TRg-6",
"MAK16g1-PAN1-NRg-1",
"MAK16g1-UTP13-TRg-2",
"MAK16g1-KAE1-NRg-3",
"MAK16g1-ERG20-TRg-1",
"MAK16g1-CDC20-TRg-6",
"MAK16g1-PWP2-NRg-2",
"MAK16g1-COG1-NRg-1",
"MAK16g1-RPL1B-TRg-4",
"MAK16g1-RPL1B-TRg-7",
"MAK16g1-UTP20-TRg-3",
"MAK16g1-UTP20-TRg-4",
"MAK16g1-RPL25-TRg-4",
"MAK16g1-RPL25-TRg-2",
"MAK16g1-MCM7-NRg-1",
"MAK16g1-MRP49-TRg-5",
"MAK16g1-ERO1-NRg-3",
"MAK16g1-UTP5-TRg-7",
"MAK16g1-MCM4-NRg-1",
"MAK16g1-PRE3-NRg-1",
"MAK16g1-FCF1-NRg-1",
"MAK16g1-CUS1-NRg-1",
"MAK16g1-PSF1-TRg-2",
"MAK16g1-BCP1-TRg-2",
"MAK16g1-PAN1-TRg-1",
"MAK16g1-PAN1-TRg-3",
"MAK16g1-PAN1-TRg-4",
"MAK16g1-VPS3-TRg-2",
"MAK16g1-YIL060W-NRg-1",
"MAK16g1-VPS53-NRg-1",
"MAK16g1-CYR1-TRg-4",
"MAK16g1-CYR1-TRg-7",
"MAK16g1-MPS1-NRg-1",
"MAK16g1-SRP1-TRg-5",
"MAK16g1-SRP1-TRg-4",
"MAK16g1-TAF12-TRg-2",
"MAK16g1-TAF12-TRg-3",
"MAK16g1-POP4-TRg-1",
"MAK16g1-SPT16-TRg-1",
"MAK16g1-NUP82-TRg-4",
"MAK16g1-DML1-TRg-3",
"MAK16g1-RPA43-NRg-3",
"MAK16g1-STU2-NRg-3",
"MAK16g1-POP4-NRg-4",
"MAK16g1-MCD1-TRg-2",
"MAK16g1-RPS3-NRg-4",
"MAK16g1-PRP9-TRg-4",
"MAK16g1-RPP1-NRg-2",
"MAK16g1-MTR2-NRg-11",
"MAK16g1-GCD11-TRg-1",
"MAK16g1-RPF1-TRg-3",
"MAK16g1-SUB2-NRg-4",
"MAK16g1-GPI15-TRg-3",
"MAK16g1-ERG9-TRg-6",
"MAK16g1-RPT2-NRg-1",
"MAK16g1-YOS1-NRg-3",
"MAK16g1-SCM3-TRg-4",
"MAK16g1-SCM3-TRg-6",
"MAK16g1-RLP7-NRg-1",
"MAK16g1-TFB2-NRg-4",
"MAK16g1-IMP4-TRg-1",
"MAK16g1-IMP4-TRg-3",
"MAK16g1-PRE4-TRg-3",
"MAK16g1-SUB2-TRg-3",
"MAK16g1-RPP0-NRg-4",
"MAK16g1-RPP0-NRg-3",
"MAK16g1-TOM40-TRg-4",
"MAK16g1-FUR1-NRg-12",
"MAK16g1-TOM40-TRg-2",
"MAK16g1-VMA11-NRg-4",
"MAK16g1-PGS1-NRg-4",
"MAK16g1-URB1-TRg-4",
"MAK16g1-ARP4-TRg-3",
"MAK16g1-RPT3-TRg-3",
"MAK16g1-SUI3-TRg-3",
"MAK16g1-RFC5-NRg-2",
"MAK16g1-RRP14-TRg-2",
"MAK16g1-SCC2-TRg-1",
"MAK16g1-SSC1-TRg-3",
"MAK16g1-RRP9-TRg-3",
"MAK16g1-MOT1-NRg-9",
"MAK16g1-RPL42A-NRg-2",
"MAK16g1-SEC16-TRg-7",
"MAK16g1-IMP4-NRg-2",
"MAK16g1-YEF3-NRg-4",
"MAK16g1-PUP1-TRg-1",
"MAK16g1-UTP22-TRg-6",
"MAK16g1-DBP2-NRg-4",
"MAK16g1-PRE2-TRg-7",
"MAK16g1-ATP16-TRg-6",
"MAK16g1-UTP13-TRg-4",
"MAK16g1-DOP1-NRg-4",
"MAK16g1-TIM44-TRg-3",
"MAK16g1-ATP16-TRg-2",
"MAK16g1-ENP1-NRg-3",
"MAK16g1-NAF1-TRg-3",
"MAK16g1-COG4-TRg-2",
"MAK16g1-SOG2-TRg-7",
"MAK16g1-YDR341C-TRg-3",
"MAK16g1-YMR290W-A-TRg-10",
"MAK16g1-NUP192-NRg-9",
"MAK16g1-RPS31-NRg-8",
"MAK16g1-SPC97-NRg-6",
"MAK16g1-EBP2-NRg-1",
"MAK16g1-CDC48-TRg-5",
"MAK16g1-RPT1-TRg-4",
"MAK16g1-ULP1-NRg-2",
"MAK16g1-RPN3-TRg-6",
"MAK16g1-RPT1-TRg-5",
"MAK16g1-KRE5-TRg-2",
"MAK16g1-TBF1-NRg-8",
"MAK16g1-UTP22-NRg-4",
"MAK16g1-SSC1-NRg-4",
"MAK16g1-REB1-TRg-4",
"MAK16g1-CDC48-NRg-9",
"MAK16g1-FAS2-TRg-8",
"MAK16g1-TAO3-TRg-8",
"MAK16g1-CKS1-TRg-5",
"MAK16g1-YLR379W-TRg-7",
"MAK16g1-TEN1-NRg-2",
"MAK16g1-RPL42A-TRg-2",
"MAK16g1-SEC27-TRg-4",
"MAK16g1-TBF1-NRg-4",
"MAK16g1-RPT1-NRg-6",
"MAK16g1-COG1-TRg-3",
"MAK16g1-SUI1-TRg-6",
"MAK16g1-TIM23-TRg-6",
"MAK16g1-CDC48-NRg-6",
"MAK16g1-EPL1-TRg-5",
"MAK16g1-RPT5-TRg-8",
"MAK16g1-ATP16-NRg-4",
"MAK16g1-RPN6-TRg-3",
"MAK16g1-ERG9-NRg-6",
"MAK16g1-SMX3-TRg-1",
"MAK16g1-NCB2-NRg-3",
"MAK16g1-SEC16-NRg-12",
"MAK16g1-RPN6-TRg-2",
"MAK16g1-REB1-NRg-4",
"MAK16g1-ATP16-TRg-9",
"MAK16g1-ERG9-NRg-7",
"YCR016Wg4-RPL15A-NRg-4",
"YCR016Wg4-RPL15A-NRg-5",
"YCR016Wg4-KRE33-TRg-1",
"YCR016Wg4-PMI40-NRg-1",
"YCR016Wg4-NOP19-NRg-3",
"YCR016Wg4-SRP14-NRg-4",
"YCR016Wg4-SEC27-TRg-2",
"YCR016Wg4-GPI14-TRg-3",
"YCR016Wg4-PAH1-TRg-7",
"YCR016Wg4-PAH1-TRg-6",
"YCR016Wg4-PAH1-TRg-5",
"YCR016Wg4-PAH1-TRg-3",
"YCR016Wg4-COG3-TRg-1",
"YCR016Wg4-HTS1-NRg-5",
"YCR016Wg4-MSN5-TRg-7",
"YCR016Wg4-ERG26-TRg-1",
"YCR016Wg4-SMD2-TRg-5",
"YCR016Wg4-SMD2-TRg-4",
"YCR016Wg4-SMD2-TRg-1",
"YCR016Wg4-PRE7-TRg-4",
"YCR016Wg4-PRE7-TRg-7",
"YCR016Wg4-SEC6-TRg-3",
"YCR016Wg4-ESF2-NRg-1",
"YCR016Wg4-ESF2-NRg-3",
"YCR016Wg4-AFG2-TRg-2",
"YCR016Wg4-RRP36-TRg-3",
"YCR016Wg4-RRP36-TRg-5",
"YCR016Wg4-GCR1-NRg-2",
"YCR016Wg4-PRE4-NRg-4",
"YCR016Wg4-PRE4-NRg-9",
"YCR016Wg4-DSN1-NRg-2",
"YCR016Wg4-GPI11-TRg-3",
"YCR016Wg4-POP3-TRg-1",
"YCR016Wg4-MNE1-TRg-5",
"YCR016Wg4-RRP12-NRg-1",
"YCR016Wg4-RSC6-TRg-2",
"YCR016Wg4-CDC25-TRg-1",
"YCR016Wg4-CDC25-TRg-9",
"YCR016Wg4-YPP1-NRg-3",
"YCR016Wg4-NFS1-NRg-9",
"YCR016Wg4-NFS1-NRg-8",
"YCR016Wg4-UBA2-TRg-1",
"YCR016Wg4-ARP2-NRg-3",
"YCR016Wg4-MAK16-TRg-1",
"YCR016Wg4-CEP3-NRg-1",
"YCR016Wg4-GUK1-TRg-5",
"YCR016Wg4-GUK1-TRg-2",
"YCR016Wg4-GPI12-NRg-6",
"YCR016Wg4-RPS5-NRg-5",
"YCR016Wg4-RPS5-NRg-2",
"YCR016Wg4-RPC19-NRg-1",
"YCR016Wg4-TIM54-TRg-1",
"YCR016Wg4-TEN1-TRg-2",
"YCR016Wg4-SAH1-NRg-4",
"YCR016Wg4-SAH1-NRg-5",
"YCR016Wg4-SAH1-NRg-3",
"YCR016Wg4-ATP15-NRg-5",
"YCR016Wg4-SCD5-TRg-5",
"YCR016Wg4-ARB1-NRg-2",
"YCR016Wg4-ARB1-NRg-4",
"YCR016Wg4-PUP2-TRg-1",
"YCR016Wg4-CCT8-TRg-2",
"YCR016Wg4-MCM4-TRg-1",
"YCR016Wg4-LSM4-TRg-1",
"YCR016Wg4-NOP53-NRg-1",
"YCR016Wg4-ATP3-TRg-4",
"YCR016Wg4-AFG2-NRg-3",
"YCR016Wg4-PRO3-NRg-3",
"YCR016Wg4-NRD1-NRg-10",
"YCR016Wg4-SEC61-TRg-2",
"YCR016Wg4-RHO3-TRg-4",
"YCR016Wg4-SNF2-TRg-6",
"YCR016Wg4-SMD2-NRg-3",
"YCR016Wg4-RSC4-TRg-2",
"YCR016Wg4-RSC4-TRg-1",
"YCR016Wg4-TIF34-TRg-2",
"YCR016Wg4-BET1-NRg-1",
"YCR016Wg4-CDC8-NRg-2",
"YCR016Wg4-PRP42-TRg-2",
"YCR016Wg4-RRB1-TRg-2",
"YCR016Wg4-SPC24-TRg-1",
"YCR016Wg4-ILS1-NRg-1",
"YCR016Wg4-GFA1-TRg-2",
"YCR016Wg4-SEC21-NRg-10",
"YCR016Wg4-RPC10-NRg-1",
"YCR016Wg4-RPB10-TRg-3",
"YCR016Wg4-RPB10-TRg-2",
"YCR016Wg4-YNL181W-TRg-1",
"YCR016Wg4-RAD3-NRg-1",
"YCR016Wg4-NOP10-TRg-1",
"YCR016Wg4-BFR2-TRg-3",
"YCR016Wg4-MCM2-TRg-6",
"YCR016Wg4-MCM2-TRg-4",
"YCR016Wg4-MPP10-TRg-1",
"YCR016Wg4-RET2-TRg-4",
"YCR016Wg4-RET2-TRg-1",
"YCR016Wg4-RPS2-NRg-1",
"YCR016Wg4-RPS2-NRg-2",
"YCR016Wg4-ORC4-NRg-3",
"YCR016Wg4-TIP20-TRg-7",
"YCR016Wg4-SMT3-TRg-1",
"YCR016Wg4-MSS18-NRg-6",
"YCR016Wg4-YEF3-NRg-9",
"YCR016Wg4-ASK1-NRg-1",
"YCR016Wg4-SMC1-TRg-1",
"YCR016Wg4-NIP1-NRg-1",
"YCR016Wg4-RPP1-NRg-1",
"YCR016Wg4-YDJ1-TRg-6",
"YCR016Wg4-SUB2-NRg-1",
"YCR016Wg4-TIM10-NRg-8",
"YCR016Wg4-TIM10-NRg-4",
"YCR016Wg4-TIM10-NRg-7",
"YCR016Wg4-SKI6-TRg-4",
"YCR016Wg4-TUB4-TRg-1",
"YCR016Wg4-CDC37-NRg-2",
"YCR016Wg4-ISD11-TRg-3",
"YCR016Wg4-YOS1-TRg-4",
"YCR016Wg4-SSC1-TRg-6",
"YCR016Wg4-MTR3-TRg-5",
"YCR016Wg4-MTR3-TRg-6",
"YCR016Wg4-TFA1-TRg-2",
"YCR016Wg4-CDC3-NRg-3",
"YCR016Wg4-ERG25-TA-18",
"YCR016Wg4-RPB11-TRg-4",
"YCR016Wg4-RPB11-TRg-1",
"YCR016Wg4-RPB11-TRg-2",
"YCR016Wg4-DED1-TRg-3",
"YCR016Wg4-DED1-TRg-1",
"YCR016Wg4-DED1-TRg-6",
"YCR016Wg4-DED1-TRg-4",
"YCR016Wg4-RPL10-NRg-5",
"YCR016Wg4-RPL10-NRg-4",
"YCR016Wg4-EFB1-NRg-1",
"YCR016Wg4-EFB1-NRg-5",
"YCR016Wg4-EFB1-NRg-4",
"YCR016Wg4-RPT3-NRg-1",
"YCR016Wg4-SAC6-TRg-8",
"YCR016Wg4-SAC6-TRg-4",
"YCR016Wg4-SAC6-TRg-5",
"YCR016Wg4-SAC6-TRg-3",
"YCR016Wg4-DIM1-TRg-5",
"YCR016Wg4-DIM1-TRg-7",
"YCR016Wg4-RPC17-NRg-1",
"YCR016Wg4-RPC17-NRg-2",
"YCR016Wg4-YDR341C-TRg-1",
"YCR016Wg4-RAP1-NRg-8",
"YCR016Wg4-RAP1-NRg-5",
"YCR016Wg4-RAP1-NRg-2",
"YCR016Wg4-SEC26-NRg-3",
"YCR016Wg4-SPP41-TRg-3",
"YCR016Wg4-TAP42-NRg-1",
"YCR016Wg4-PGA2-TRg-6",
"YCR016Wg4-BRL1-TRg-1",
"YCR016Wg4-FOL2-TRg-1",
"YCR016Wg4-NAB3-NRg-5",
"YCR016Wg4-SNF4-TRg-4",
"YCR016Wg4-HRR25-TRg-2",
"YCR016Wg4-TRS23-TRg-4",
"YCR016Wg4-CTR86-TRg-4",
"YCR016Wg4-RPB5-TRg-5",
"YCR016Wg4-SPN1-NRg-2",
"YCR016Wg4-SPN1-NRg-1",
"YCR016Wg4-SEC61-NRg-1",
"YCR016Wg4-SEC61-NRg-7",
"YCR016Wg4-TUS1-TRg-3",
"YCR016Wg4-OLE1-NRg-2",
"YCR016Wg4-AFG2-TRg-1",
"YCR016Wg4-TOA2-NRg-1",
"YCR016Wg4-USO1-TRg-1",
"YCR016Wg4-UTP22-NRg-2",
"YCR016Wg4-RIB1-TRg-3",
"YCR016Wg4-RIB1-TRg-7",
"YCR016Wg4-RIB1-TRg-4",
"YCR016Wg4-COG1-TRg-1",
"YCR016Wg4-RPL32-NRg-2",
"YCR016Wg4-GLC7-NRg-3",
"YCR016Wg4-GLC7-NRg-4",
"YCR016Wg4-HSF1-TRg-2",
"YCR016Wg4-DAM1-NRg-5",
"YCR016Wg4-SEC18-TRg-4",
"YCR016Wg4-SEC18-TRg-5",
"YCR016Wg4-PAB1-NRg-3",
"YCR016Wg4-POP8-TRg-2",
"YCR016Wg4-PAB1-NRg-4",
"YCR016Wg4-BIG1-TRg-4",
"YCR016Wg4-BIG1-TRg-5",
"YCR016Wg4-BIG1-TRg-6",
"YCR016Wg4-RPO41-NRg-1",
"YCR016Wg4-RVB2-NRg-2",
"YCR016Wg4-PET117-NRg-8",
"YCR016Wg4-VPS45-NRg-9",
"YCR016Wg4-YCG1-NRg-1",
"YCR016Wg4-NOC4-NRg-1",
"YCR016Wg4-NMD3-NRg-2",
"YCR016Wg4-DRS1-TRg-2",
"YCR016Wg4-HTB1-NRg-2",
"YCR016Wg4-IPI1-TRg-2",
"YCR016Wg4-SEC18-NRg-1",
"YCR016Wg4-SEC18-NRg-2",
"YCR016Wg4-JIP5-NRg-2",
"YCR016Wg4-YPT1-TRg-3",
"YCR016Wg4-YPT1-TRg-2",
"YCR016Wg4-CLF1-NRg-2",
"YCR016Wg4-SNF2-NRg-7",
"YCR016Wg4-SNF2-NRg-4",
"YCR016Wg4-RPL25-NRg-1",
"YCR016Wg4-NOP56-TRg-1",
"YCR016Wg4-NOP56-TRg-2",
"YCR016Wg4-TRS31-TRg-1",
"YCR016Wg4-DBF4-TRg-2",
"YCR016Wg4-DBF4-TRg-1",
"YCR016Wg4-RPC19-TRg-4",
"YCR016Wg4-RPC19-TRg-6",
"YCR016Wg4-RPC19-TRg-3",
"YCR016Wg4-ROK1-NRg-1",
"YCR016Wg4-CDC33-TRg-4",
"YCR016Wg4-DHR2-TRg-3",
"YCR016Wg4-RRP42-NRg-5",
"YCR016Wg4-CLF1-TRg-1",
"YCR016Wg4-ERG11-NA-16",
"YCR016Wg4-VAS1-NRg-4",
"YCR016Wg4-PIK1-NRg-2",
"YCR016Wg4-SAR1-NRg-7",
"YCR016Wg4-SAR1-NRg-4",
"YCR016Wg4-RPS3-TRg-1",
"YCR016Wg4-YTM1-TRg-2",
"YCR016Wg4-SUI3-NRg-5",
"YCR016Wg4-SUI3-NRg-2",
"YCR016Wg4-RRP7-TRg-4",
"YCR016Wg4-RRP7-TRg-6",
"YCR016Wg4-NIP7-TRg-2",
"YCR016Wg4-MDM35-TRg-1",
"YCR016Wg4-ALA1-NRg-1",
"YCR016Wg4-DOA4-NRg-2",
"YCR016Wg4-RPS13-NRg-1",
"YCR016Wg4-YSF3-TRg-2",
"YCR016Wg4-RPS2-NRg-11",
"YCR016Wg4-SSL1-TRg-10",
"YCR016Wg4-NIP7-TRg-1",
"YCR016Wg4-LST8-NRg-1",
"YCR016Wg4-TAF4-TRg-3",
"YCR016Wg4-HAS1-TRg-2",
"YCR016Wg4-GLC7-TRg-2",
"YCR016Wg4-CDC45-NRg-1",
"YCR016Wg4-SEC22-NRg-8",
"YCR016Wg4-YOS1-TRg-2",
"YCR016Wg4-RBA50-TRg-3",
"YCR016Wg4-SPP41-NRg-2",
"YCR016Wg4-PRP46-TRg-2",
"YCR016Wg4-PGA2-NRg-1",
"YCR016Wg4-CBF5-TRg-3",
"YCR016Wg4-TCP1-NRg-3",
"YCR016Wg4-TCP1-NRg-2",
"YCR016Wg4-ERG26-NRg-2",
"YCR016Wg4-ERG26-NRg-4",
"YCR016Wg4-MES1-TRg-5",
"YCR016Wg4-HTS1-TRg-2",
"YCR016Wg4-SSS1-TRg-3",
"YCR016Wg4-SSS1-TRg-2",
"YCR016Wg4-SYS1-TRg-7",
"YCR016Wg4-SYS1-TRg-2",
"YCR016Wg4-SYS1-TRg-1",
"YCR016Wg4-BFR2-TRg-1",
"YCR016Wg4-EOS1-TRg-3",
"YCR016Wg4-TAF4-NRg-1",
"YCR016Wg4-ARL3-NRg-8",
"YCR016Wg4-RPN5-NRg-1",
"YCR016Wg4-TIM9-NRg-2",
"YCR016Wg4-NUP57-NRg-3",
"YCR016Wg4-VPS4-TRg-1",
"YCR016Wg4-CDC3-TRg-4",
"YCR016Wg4-BBP1-NRg-1",
"YCR016Wg4-BBP1-NRg-2",
"YCR016Wg4-USE1-NRg-3",
"YCR016Wg4-CCT7-TRg-1",
"YCR016Wg4-SAH1-TRg-3",
"YCR016Wg4-CHS2-TRg-1",
"YCR016Wg4-DPM1-TRg-2",
"YCR016Wg4-BBP1-TRg-1",
"YCR016Wg4-NRD1-TRg-4",
"YCR016Wg4-RPB3-NRg-1",
"YCR016Wg4-PHO85-NRg-6",
"YCR016Wg4-SNF6-TRg-6",
"YCR016Wg4-PRP38-NRg-2",
"YCR016Wg4-OAR1-NRg-3",
"YCR016Wg4-ROX3-NRg-1",
"YCR016Wg4-YPP1-TRg-6",
"YCR016Wg4-CBF2-NRg-8",
"YCR016Wg4-SPT6-TRg-5",
"YCR016Wg4-SEC10-NRg-1",
"YCR016Wg4-NSL1-NRg-3",
"YCR016Wg4-NRD1-NRg-8",
"YCR016Wg4-RPB3-TRg-1",
"YCR016Wg4-NRD1-NRg-4",
"YCR016Wg4-RVB1-TRg-2",
"YCR016Wg4-TIF5-NRg-8",
"YCR016Wg4-EOS1-NRg-1",
"YCR016Wg4-ERG25-NA-26",
"YCR016Wg4-MSL5-NRg-4",
"YCR016Wg4-SEC24-TRg-2",
"YCR016Wg4-RPL30-NRg-5",
"YCR016Wg4-SNU71-NRg-3",
"YCR016Wg4-CDC33-NRg-1",
"YCR016Wg4-RPN6-TRg-4",
"YCR016Wg4-NAB2-TRg-4",
"YCR016Wg4-NAB2-TRg-6",
"YCR016Wg4-YTM1-NRg-1",
"YCR016Wg4-OLE1-TRg-8",
"YCR016Wg4-OLE1-TRg-1",
"YCR016Wg4-UTP7-TRg-4",
"YCR016Wg4-ACT1-NRg-6",
"YCR016Wg4-RPL18A-NRg-3",
"YCR016Wg4-BRX1-NRg-1",
"YCR016Wg4-NAF1-TRg-8",
"YCR016Wg4-NAF1-TRg-6",
"YCR016Wg4-NAF1-TRg-4",
"YCR016Wg4-CDC8-TRg-2",
"YCR016Wg4-NSE4-TRg-1",
"YCR016Wg4-PAB1-NRg-2",
"YCR016Wg4-PRP43-TRg-4",
"YCR016Wg4-SEC2-NRg-3",
"YCR016Wg4-SEC2-NRg-6",
"YCR016Wg4-MPP10-NRg-5",
"YCR016Wg4-YDR355C-TRg-2",
"YCR016Wg4-YLR339C-TRg-9",
"YCR016Wg4-SNM1-TRg-2",
"YCR016Wg4-ALR1-NRg-4",
"YCR016Wg4-ALR1-NRg-1",
"YCR016Wg4-ALR1-NRg-3",
"YCR016Wg4-RPL10-TRg-1",
"YCR016Wg4-RPL28-TRg-2",
"YCR016Wg4-UTP25-TRg-1",
"YCR016Wg4-POB3-TRg-1",
"YCR016Wg4-POB3-TRg-3",
"YCR016Wg4-POB3-TRg-2",
"YCR016Wg4-MED11-TRg-1",
"YCR016Wg4-ISA1-TRg-15",
"YCR016Wg4-RRP1-NRg-1",
"YCR016Wg4-MES1-NRg-1",
"YCR016Wg4-SEC13-NRg-5",
"YCR016Wg4-MCM2-NRg-2",
"YCR016Wg4-ALA1-TRg-4",
"YCR016Wg4-MTG2-TRg-5",
"YCR016Wg4-TIF35-NRg-3",
"YCR016Wg4-NSE1-TRg-3",
"YCR016Wg4-NSE1-TRg-4",
"YCR016Wg4-MOB2-NRg-6",
"YCR016Wg4-VRG4-NRg-3",
"YCR016Wg4-PRP9-TRg-3",
"YCR016Wg4-HYM1-TRg-5",
"YCR016Wg4-POP1-TRg-5",
"YCR016Wg4-POP1-TRg-9",
"YCR016Wg4-RPL17A-TRg-1",
"YCR016Wg4-SLD2-TRg-1",
"YCR016Wg4-CDC48-NRg-7",
"YCR016Wg4-FHL1-NRg-2",
"YCR016Wg4-BET3-NRg-7",
"YCR016Wg4-MAK21-TRg-1",
"YCR016Wg4-BRN1-TRg-4",
"YCR016Wg4-FBA1-NRg-3",
"YCR016Wg4-CDC42-TRg-6",
"YCR016Wg4-CDC42-TRg-7",
"YCR016Wg4-COG4-NRg-1",
"YCR016Wg4-ATP3-NRg-3",
"YCR016Wg4-ATP3-NRg-2",
"YCR016Wg4-SMP3-TRg-5",
"YCR016Wg4-CFT2-NRg-2",
"YCR016Wg4-FAS2-TRg-5",
"YCR016Wg4-DBP2-NRg-3",
"YCR016Wg4-DBP2-NRg-2",
"YCR016Wg4-MPS2-NRg-4",
"YCR016Wg4-ARC35-TRg-2",
"YCR016Wg4-ARC35-TRg-5",
"YCR016Wg4-MRD1-TRg-1",
"YCR016Wg4-RLP7-TRg-1",
"YCR016Wg4-SPC34-TRg-1",
"YCR016Wg4-CDC45-TRg-2",
"YCR016Wg4-GCD6-TRg-3",
"YCR016Wg4-GCD6-TRg-4",
"YCR016Wg4-YPT6-NRg-2",
"YCR016Wg4-RPS13-TRg-2",
"YCR016Wg4-IPI3-TRg-3",
"YCR016Wg4-TIF5-NRg-9",
"YCR016Wg4-TIF5-NRg-7",
"YCR016Wg4-TIF5-NRg-6",
"YCR016Wg4-NAB3-TRg-3",
"YCR016Wg4-GCD2-TRg-1",
"YCR016Wg4-UBA1-TRg-2",
"YCR016Wg4-SLD3-TRg-6",
"YCR016Wg4-LCB1-TRg-5",
"YCR016Wg4-TOA2-TRg-6",
"YCR016Wg4-TOA2-TRg-1",
"YCR016Wg4-TOA2-TRg-3",
"YCR016Wg4-LSM2-TRg-1",
"YCR016Wg4-YML6-TRg-13",
"YCR016Wg4-YML6-TRg-12",
"YCR016Wg4-UTP15-NRg-1",
"YCR016Wg4-TIF6-NRg-8",
"YCR016Wg4-SUP35-NRg-1",
"YCR016Wg4-MPP10-NRg-1",
"YCR016Wg4-SWI3-TRg-7",
"YCR016Wg4-SSN3-NRg-2",
"YCR016Wg4-SEC13-NRg-7",
"YCR016Wg4-RPS15-NRg-3",
"YCR016Wg4-RPL3-TRg-2",
"YCR016Wg4-FBA1-NRg-2",
"YCR016Wg4-FBA1-NRg-1",
"YCR016Wg4-FBA1-NRg-5",
"YCR016Wg4-DAM1-TRg-2",
"YCR016Wg4-NHP2-TRg-2",
"YCR016Wg4-HCA4-NRg-6",
"YCR016Wg4-PRE3-TRg-4",
"YCR016Wg4-DBP5-NRg-4",
"YCR016Wg4-SPT6-NRg-4",
"YCR016Wg4-SPT6-NRg-2",
"YCR016Wg4-RPL18A-TRg-4",
"YCR016Wg4-KSH1-TRg-1",
"YCR016Wg4-KSH1-TRg-3",
"YCR016Wg4-IPI3-NRg-1",
"YCR016Wg4-PGA2-TRg-8",
"YCR016Wg4-RPL18A-TRg-2",
"YCR016Wg4-RPL33A-NRg-6",
"YCR016Wg4-TAF12-NRg-2",
"YCR016Wg4-USE1-TRg-5",
"YCR016Wg4-YNL114C-TRg-1",
"YCR016Wg4-SMC5-TRg-7",
"YCR016Wg4-SMC5-TRg-6",
"YCR016Wg4-RSC58-TRg-1",
"YCR016Wg4-CTF13-TRg-2",
"YCR016Wg4-NAB2-NRg-2",
"YCR016Wg4-MCM7-TRg-4",
"YCR016Wg4-BCP1-NRg-5",
"YCR016Wg4-STU2-TRg-3",
"YCR016Wg4-SEC21-NRg-6",
"YCR016Wg4-SEC21-NRg-3",
"YCR016Wg4-RPL1B-TRg-3",
"YCR016Wg4-SEC20-NRg-2",
"YCR016Wg4-VMA3-NRg-2",
"YCR016Wg4-SEC23-NRg-5",
"YCR016Wg4-CDC28-TRg-4",
"YCR016Wg4-RPN12-NRg-11",
"YCR016Wg4-PUP3-TRg-3",
"YCR016Wg4-SEC31-TRg-2",
"YCR016Wg4-SED5-TRg-6",
"YCR016Wg4-SED5-TRg-5",
"YCR016Wg4-RPL33A-TRg-1",
"YCR016Wg4-RPL33A-TRg-2",
"YCR016Wg4-MRPL11-TRg-2",
"YCR016Wg4-RTP1-NRg-2",
"YCR016Wg4-NUG1-TRg-2",
"YCR016Wg4-VPH2-TRg-4",
"YCR016Wg4-COP1-NRg-3",
"YCR016Wg4-CRM1-NRg-1",
"YCR016Wg4-RPL5-NRg-4",
"YCR016Wg4-SNU13-NRg-4",
"YCR016Wg4-PFS2-TRg-3",
"YCR016Wg4-MPP10-TRg-2",
"YCR016Wg4-TSR4-NRg-2",
"YCR016Wg4-RSC2-TRg-1",
"YCR016Wg4-SEC65-TRg-2",
"YCR016Wg4-SMI1-NRg-1",
"YCR016Wg4-RTT105-NRg-4",
"YCR016Wg4-VMA5-TRg-3",
"YCR016Wg4-VMA5-TRg-5",
"YCR016Wg4-RRP1-TRg-3",
"YCR016Wg4-CLC1-TRg-2",
"YCR016Wg4-GCD6-NRg-1",
"YCR016Wg4-GCD6-NRg-2",
"YCR016Wg4-PXR1-TRg-1",
"YCR016Wg4-CDC14-NRg-1",
"YCR016Wg4-PCF11-TRg-6",
"YCR016Wg4-PCF11-TRg-5",
"YCR016Wg4-PCF11-TRg-4",
"YCR016Wg4-SEC31-NRg-1",
"YCR016Wg4-RRP5-NRg-1",
"YCR016Wg4-PRE10-TRg-5",
"YCR016Wg4-PRE10-TRg-1",
"YCR016Wg4-RPS5-TRg-2",
"YCR016Wg4-NSP1-TRg-4",
"YCR016Wg4-PRP38-TRg-4",
"YCR016Wg4-RCF1-NRg-5",
"YCR016Wg4-RSC3-TRg-4",
"YCR016Wg4-RSC3-TRg-5",
"YCR016Wg4-RSC3-TRg-6",
"YCR016Wg4-HTA1-NRg-12",
"YCR016Wg4-HTA1-NRg-11",
"YCR016Wg4-UTP23-TRg-2",
"YCR016Wg4-GCD7-NRg-1",
"YCR016Wg4-GCD7-NRg-2",
"YCR016Wg4-GCD7-NRg-6",
"YCR016Wg4-GAL11-NRg-2",
"YCR016Wg4-GAL11-NRg-9",
"YCR016Wg4-PHO4-TRg-5",
"YCR016Wg4-SNP1-NRg-3",
"YCR016Wg4-RPC37-TRg-5",
"YCR016Wg4-CRM1-TRg-5",
"YCR016Wg4-CRM1-TRg-2",
"YCR016Wg4-ASK1-TRg-7",
"YCR016Wg4-STU2-NRg-4",
"YCR016Wg4-NEO1-NRg-3",
"YCR016Wg4-GAL11-TRg-5",
"YCR016Wg4-GAL11-TRg-7",
"YCR016Wg4-SAM50-NRg-3",
"YCR016Wg4-CSL4-TRg-2",
"YCR016Wg4-CCT5-TRg-2",
"YCR016Wg4-POL30-NRg-1",
"YCR016Wg4-MED4-TRg-4",
"YCR016Wg4-MED4-TRg-3",
"YCR016Wg4-MED4-TRg-2",
"YCR016Wg4-GDI1-TRg-4",
"YCR016Wg4-GDI1-TRg-3",
"YCR016Wg4-REB1-TRg-6",
"YCR016Wg4-MRPL37-NRg-2",
"YCR016Wg4-NOC3-TRg-3",
"YCR016Wg4-SPC97-TRg-3",
"YCR016Wg4-IPP1-TRg-3",
"YCR016Wg4-IPP1-TRg-2",
"YCR016Wg4-PTI1-TRg-3",
"YCR016Wg4-PTI1-TRg-5",
"YCR016Wg4-RFC5-NRg-1",
"YCR016Wg4-CDC24-TRg-1",
"YCR016Wg4-CDC24-TRg-3",
"YCR016Wg4-CDC24-TRg-5",
"YCR016Wg4-CDC24-TRg-6",
"YCR016Wg4-UTP23-TRg-6",
"YCR016Wg4-UTP23-TRg-4",
"YCR016Wg4-UTP23-TRg-1",
"YCR016Wg4-RHO3-NRg-4",
"YCR016Wg4-TRS23-NRg-1",
"YCR016Wg4-TRS23-NRg-3",
"YCR016Wg4-RSP5-TRg-2",
"YCR016Wg4-RSP5-TRg-1",
"YCR016Wg4-SDA1-NRg-1",
"YCR016Wg4-KAP95-TRg-8",
"YCR016Wg4-ACO1-TRg-6",
"YCR016Wg4-HTA1-NRg-3",
"YCR016Wg4-HTA1-NRg-2",
"YCR016Wg4-SPN1-TRg-1",
"YCR016Wg4-MOT1-NRg-7",
"YCR016Wg4-RPL17A-NRg-4",
"YCR016Wg4-ADA2-TRg-4",
"YCR016Wg4-SFH1-NRg-1",
"YCR016Wg4-SPC97-NRg-5",
"YCR016Wg4-PRP22-TRg-3",
"YCR016Wg4-SEN15-TRg-2",
"YCR016Wg4-RPL3-NRg-2",
"YCR016Wg4-ISD11-NRg-2",
"YCR016Wg4-HEM12-TRg-8",
"YCR016Wg4-SEC10-TRg-1",
"YCR016Wg4-HTB1-TRg-7",
"YCR016Wg4-TTI2-TRg-1",
"YCR016Wg4-ACP1-TRg-2",
"YCR016Wg4-ACP1-TRg-4",
"YCR016Wg4-GAL11-NRg-10",
"YCR016Wg4-UTP22-TRg-2",
"YCR016Wg4-MST1-NRg-5",
"YCR016Wg4-RIB7-NRg-2",
"YCR016Wg4-MCD1-TRg-6",
"YCR016Wg4-MCD1-TRg-5",
"YCR016Wg4-GPI8-NRg-2",
"YCR016Wg4-THS1-TRg-2",
"YCR016Wg4-RRP7-TRg-2",
"YCR016Wg4-RRP7-TRg-5",
"YCR016Wg4-SMX2-NRg-7",
"YCR016Wg4-RRP45-TRg-5",
"YCR016Wg4-RRP45-TRg-4",
"YCR016Wg4-CNS1-TRg-2",
"YCR016Wg4-FBP1-NRg-9",
"YCR016Wg4-GCD11-NRg-1",
"YCR016Wg4-RPL10-TRg-2",
"YCR016Wg4-NUP192-TRg-4",
"YCR016Wg4-NUP145-NRg-4",
"YCR016Wg4-HEM12-TRg-6",
"YCR016Wg4-PLC1-TRg-3",
"YCR016Wg4-RPA43-TRg-1",
"YCR016Wg4-RPB7-NRg-2",
"YCR016Wg4-RPB7-NRg-3",
"YCR016Wg4-NSL1-NRg-1",
"YCR016Wg4-UTP6-TRg-3",
"YCR016Wg4-UTP6-TRg-1",
"YCR016Wg4-YJU2-TRg-5",
"YCR016Wg4-FRS2-NRg-5",
"YCR016Wg4-TIF35-NRg-2",
"YCR016Wg4-GPI15-TRg-1",
"YCR016Wg4-NOP1-NRg-5",
"YCR016Wg4-GPI15-TRg-4",
"YCR016Wg4-COG4-TRg-1",
"YCR016Wg4-TFA1-TRg-1",
"YCR016Wg4-RHO1-NRg-2",
"YCR016Wg4-RHO1-NRg-1",
"YCR016Wg4-CDC55-NRg-2",
"YCR016Wg4-IDI1-NRg-7",
"YCR016Wg4-RPL32-TRg-5",
"YCR016Wg4-RPB5-TRg-4",
"YCR016Wg4-DIP2-TRg-5",
"YCR016Wg4-DIP2-TRg-1",
"YCR016Wg4-RPC40-TRg-2",
"YCR016Wg4-CDC6-TRg-5",
"YCR016Wg4-CDC6-TRg-3",
"YCR016Wg4-DAD2-TRg-2",
"YCR016Wg4-RVS161-TRg-2",
"YCR016Wg4-RVS161-TRg-1",
"YCR016Wg4-SUP45-NRg-3",
"YCR016Wg4-SRB6-NRg-5",
"YCR016Wg4-RPC11-TRg-4",
"YCR016Wg4-RKI1-TRg-8",
"YCR016Wg4-NIP7-TRg-3",
"YCR016Wg4-RPL33A-NRg-12",
"YCR016Wg4-SAM50-TRg-4",
"YCR016Wg4-NOP4-NRg-1",
"YCR016Wg4-NOP4-NRg-3",
"YCR016Wg4-SMX2-TRg-5",
"YCR016Wg4-POL12-NRg-2",
"YCR016Wg4-BMS1-NRg-2",
"YCR016Wg4-RPA190-TRg-5",
"YCR016Wg4-ALG14-NRg-4",
"YCR016Wg4-ALG14-NRg-1",
"YCR016Wg4-PRE5-NRg-1",
"YCR016Wg4-BIG1-NRg-2",
"YCR016Wg4-TFA2-TRg-4",
"YCR016Wg4-IMP4-TRg-6",
"YCR016Wg4-PAN1-NRg-1",
"YCR016Wg4-UTP13-TRg-2",
"YCR016Wg4-KAE1-NRg-3",
"YCR016Wg4-ERG20-TRg-1",
"YCR016Wg4-CDC20-TRg-6",
"YCR016Wg4-PWP2-NRg-2",
"YCR016Wg4-COG1-NRg-1",
"YCR016Wg4-RPL1B-TRg-4",
"YCR016Wg4-RPL1B-TRg-7",
"YCR016Wg4-UTP20-TRg-3",
"YCR016Wg4-UTP20-TRg-4",
"YCR016Wg4-RPL25-TRg-4",
"YCR016Wg4-RPL25-TRg-2",
"YCR016Wg4-MCM7-NRg-1",
"YCR016Wg4-MRP49-TRg-5",
"YCR016Wg4-ERO1-NRg-3",
"YCR016Wg4-UTP5-TRg-7",
"YCR016Wg4-MCM4-NRg-1",
"YCR016Wg4-PRE3-NRg-1",
"YCR016Wg4-FCF1-NRg-1",
"YCR016Wg4-CUS1-NRg-1",
"YCR016Wg4-PSF1-TRg-2",
"YCR016Wg4-BCP1-TRg-2",
"YCR016Wg4-PAN1-TRg-1",
"YCR016Wg4-PAN1-TRg-3",
"YCR016Wg4-PAN1-TRg-4",
"YCR016Wg4-VPS3-TRg-2",
"YCR016Wg4-YIL060W-NRg-1",
"YCR016Wg4-VPS53-NRg-1",
"YCR016Wg4-CYR1-TRg-4",
"YCR016Wg4-CYR1-TRg-7",
"YCR016Wg4-MPS1-NRg-1",
"YCR016Wg4-SRP1-TRg-5",
"YCR016Wg4-SRP1-TRg-4",
"YCR016Wg4-TAF12-TRg-2",
"YCR016Wg4-TAF12-TRg-3",
"YCR016Wg4-POP4-TRg-1",
"YCR016Wg4-SPT16-TRg-1",
"YCR016Wg4-NUP82-TRg-4",
"YCR016Wg4-DML1-TRg-3",
"YCR016Wg4-RPA43-NRg-3",
"YCR016Wg4-STU2-NRg-3",
"YCR016Wg4-POP4-NRg-4",
"YCR016Wg4-MCD1-TRg-2",
"YCR016Wg4-RPS3-NRg-4",
"YCR016Wg4-PRP9-TRg-4",
"YCR016Wg4-RPP1-NRg-2",
"YCR016Wg4-MTR2-NRg-11",
"YCR016Wg4-GCD11-TRg-1",
"YCR016Wg4-RPF1-TRg-3",
"YCR016Wg4-SUB2-NRg-4",
"YCR016Wg4-GPI15-TRg-3",
"YCR016Wg4-ERG9-TRg-6",
"YCR016Wg4-RPT2-NRg-1",
"YCR016Wg4-YOS1-NRg-3",
"YCR016Wg4-SCM3-TRg-4",
"YCR016Wg4-SCM3-TRg-6",
"YCR016Wg4-RLP7-NRg-1",
"YCR016Wg4-TFB2-NRg-4",
"YCR016Wg4-IMP4-TRg-1",
"YCR016Wg4-IMP4-TRg-3",
"YCR016Wg4-PRE4-TRg-3",
"YCR016Wg4-SUB2-TRg-3",
"YCR016Wg4-RPP0-NRg-4",
"YCR016Wg4-RPP0-NRg-3",
"YCR016Wg4-TOM40-TRg-4",
"YCR016Wg4-FUR1-NRg-12",
"YCR016Wg4-TOM40-TRg-2",
"YCR016Wg4-VMA11-NRg-4",
"YCR016Wg4-PGS1-NRg-4",
"YCR016Wg4-URB1-TRg-4",
"YCR016Wg4-ARP4-TRg-3",
"YCR016Wg4-RPT3-TRg-3",
"YCR016Wg4-SUI3-TRg-3",
"YCR016Wg4-RFC5-NRg-2",
"YCR016Wg4-RRP14-TRg-2",
"YCR016Wg4-SCC2-TRg-1",
"YCR016Wg4-SSC1-TRg-3",
"YCR016Wg4-RRP9-TRg-3",
"YCR016Wg4-MOT1-NRg-9",
"YCR016Wg4-RPL42A-NRg-2",
"YCR016Wg4-SEC16-TRg-7",
"YCR016Wg4-IMP4-NRg-2",
"YCR016Wg4-YEF3-NRg-4",
"YCR016Wg4-PUP1-TRg-1",
"YCR016Wg4-UTP22-TRg-6",
"YCR016Wg4-DBP2-NRg-4",
"YCR016Wg4-PRE2-TRg-7",
"YCR016Wg4-ATP16-TRg-6",
"YCR016Wg4-UTP13-TRg-4",
"YCR016Wg4-DOP1-NRg-4",
"YCR016Wg4-TIM44-TRg-3",
"YCR016Wg4-ATP16-TRg-2",
"YCR016Wg4-ENP1-NRg-3",
"YCR016Wg4-NAF1-TRg-3",
"YCR016Wg4-COG4-TRg-2",
"YCR016Wg4-SOG2-TRg-7",
"YCR016Wg4-YDR341C-TRg-3",
"YCR016Wg4-YMR290W-A-TRg-10",
"YCR016Wg4-NUP192-NRg-9",
"YCR016Wg4-RPS31-NRg-8",
"YCR016Wg4-SPC97-NRg-6",
"YCR016Wg4-EBP2-NRg-1",
"YCR016Wg4-CDC48-TRg-5",
"YCR016Wg4-RPT1-TRg-4",
"YCR016Wg4-ULP1-NRg-2",
"YCR016Wg4-RPN3-TRg-6",
"YCR016Wg4-RPT1-TRg-5",
"YCR016Wg4-KRE5-TRg-2",
"YCR016Wg4-TBF1-NRg-8",
"YCR016Wg4-UTP22-NRg-4",
"YCR016Wg4-SSC1-NRg-4",
"YCR016Wg4-REB1-TRg-4",
"YCR016Wg4-CDC48-NRg-9",
"YCR016Wg4-FAS2-TRg-8",
"YCR016Wg4-TAO3-TRg-8",
"YCR016Wg4-CKS1-TRg-5",
"YCR016Wg4-YLR379W-TRg-7",
"YCR016Wg4-TEN1-NRg-2",
"YCR016Wg4-RPL42A-TRg-2",
"YCR016Wg4-SEC27-TRg-4",
"YCR016Wg4-TBF1-NRg-4",
"YCR016Wg4-RPT1-NRg-6",
"YCR016Wg4-COG1-TRg-3",
"YCR016Wg4-SUI1-TRg-6",
"YCR016Wg4-TIM23-TRg-6",
"YCR016Wg4-CDC48-NRg-6",
"YCR016Wg4-EPL1-TRg-5",
"YCR016Wg4-RPT5-TRg-8",
"YCR016Wg4-ATP16-NRg-4",
"YCR016Wg4-RPN6-TRg-3",
"YCR016Wg4-ERG9-NRg-6",
"YCR016Wg4-SMX3-TRg-1",
"YCR016Wg4-NCB2-NRg-3",
"YCR016Wg4-SEC16-NRg-12",
"YCR016Wg4-RPN6-TRg-2",
"YCR016Wg4-REB1-NRg-4",
"YCR016Wg4-ATP16-TRg-9",
"YCR016Wg4-ERG9-NRg-7",
"YLR050Cg1-RPL15A-NRg-4",
"YLR050Cg1-RPL15A-NRg-5",
"YLR050Cg1-KRE33-TRg-1",
"YLR050Cg1-PMI40-NRg-1",
"YLR050Cg1-NOP19-NRg-3",
"YLR050Cg1-SRP14-NRg-4",
"YLR050Cg1-SEC27-TRg-2",
"YLR050Cg1-GPI14-TRg-3",
"YLR050Cg1-PAH1-TRg-7",
"YLR050Cg1-PAH1-TRg-6",
"YLR050Cg1-PAH1-TRg-5",
"YLR050Cg1-PAH1-TRg-3",
"YLR050Cg1-COG3-TRg-1",
"YLR050Cg1-HTS1-NRg-5",
"YLR050Cg1-MSN5-TRg-7",
"YLR050Cg1-ERG26-TRg-1",
"YLR050Cg1-SMD2-TRg-5",
"YLR050Cg1-SMD2-TRg-4",
"YLR050Cg1-SMD2-TRg-1",
"YLR050Cg1-PRE7-TRg-4",
"YLR050Cg1-PRE7-TRg-7",
"YLR050Cg1-SEC6-TRg-3",
"YLR050Cg1-ESF2-NRg-1",
"YLR050Cg1-ESF2-NRg-3",
"YLR050Cg1-AFG2-TRg-2",
"YLR050Cg1-RRP36-TRg-3",
"YLR050Cg1-RRP36-TRg-5",
"YLR050Cg1-GCR1-NRg-2",
"YLR050Cg1-PRE4-NRg-4",
"YLR050Cg1-PRE4-NRg-9",
"YLR050Cg1-DSN1-NRg-2",
"YLR050Cg1-GPI11-TRg-3",
"YLR050Cg1-POP3-TRg-1",
"YLR050Cg1-MNE1-TRg-5",
"YLR050Cg1-RRP12-NRg-1",
"YLR050Cg1-RSC6-TRg-2",
"YLR050Cg1-CDC25-TRg-1",
"YLR050Cg1-CDC25-TRg-9",
"YLR050Cg1-YPP1-NRg-3",
"YLR050Cg1-NFS1-NRg-9",
"YLR050Cg1-NFS1-NRg-8",
"YLR050Cg1-UBA2-TRg-1",
"YLR050Cg1-ARP2-NRg-3",
"YLR050Cg1-MAK16-TRg-1",
"YLR050Cg1-CEP3-NRg-1",
"YLR050Cg1-GUK1-TRg-5",
"YLR050Cg1-GUK1-TRg-2",
"YLR050Cg1-GPI12-NRg-6",
"YLR050Cg1-RPS5-NRg-5",
"YLR050Cg1-RPS5-NRg-2",
"YLR050Cg1-RPC19-NRg-1",
"YLR050Cg1-TIM54-TRg-1",
"YLR050Cg1-TEN1-TRg-2",
"YLR050Cg1-SAH1-NRg-4",
"YLR050Cg1-SAH1-NRg-5",
"YLR050Cg1-SAH1-NRg-3",
"YLR050Cg1-ATP15-NRg-5",
"YLR050Cg1-SCD5-TRg-5",
"YLR050Cg1-ARB1-NRg-2",
"YLR050Cg1-ARB1-NRg-4",
"YLR050Cg1-PUP2-TRg-1",
"YLR050Cg1-CCT8-TRg-2",
"YLR050Cg1-MCM4-TRg-1",
"YLR050Cg1-LSM4-TRg-1",
"YLR050Cg1-NOP53-NRg-1",
"YLR050Cg1-ATP3-TRg-4",
"YLR050Cg1-AFG2-NRg-3",
"YLR050Cg1-PRO3-NRg-3",
"YLR050Cg1-NRD1-NRg-10",
"YLR050Cg1-SEC61-TRg-2",
"YLR050Cg1-RHO3-TRg-4",
"YLR050Cg1-SNF2-TRg-6",
"YLR050Cg1-SMD2-NRg-3",
"YLR050Cg1-RSC4-TRg-2",
"YLR050Cg1-RSC4-TRg-1",
"YLR050Cg1-TIF34-TRg-2",
"YLR050Cg1-BET1-NRg-1",
"YLR050Cg1-CDC8-NRg-2",
"YLR050Cg1-PRP42-TRg-2",
"YLR050Cg1-RRB1-TRg-2",
"YLR050Cg1-SPC24-TRg-1",
"YLR050Cg1-ILS1-NRg-1",
"YLR050Cg1-GFA1-TRg-2",
"YLR050Cg1-SEC21-NRg-10",
"YLR050Cg1-RPC10-NRg-1",
"YLR050Cg1-RPB10-TRg-3",
"YLR050Cg1-RPB10-TRg-2",
"YLR050Cg1-YNL181W-TRg-1",
"YLR050Cg1-RAD3-NRg-1",
"YLR050Cg1-NOP10-TRg-1",
"YLR050Cg1-BFR2-TRg-3",
"YLR050Cg1-MCM2-TRg-6",
"YLR050Cg1-MCM2-TRg-4",
"YLR050Cg1-MPP10-TRg-1",
"YLR050Cg1-RET2-TRg-4",
"YLR050Cg1-RET2-TRg-1",
"YLR050Cg1-RPS2-NRg-1",
"YLR050Cg1-RPS2-NRg-2",
"YLR050Cg1-ORC4-NRg-3",
"YLR050Cg1-TIP20-TRg-7",
"YLR050Cg1-SMT3-TRg-1",
"YLR050Cg1-MSS18-NRg-6",
"YLR050Cg1-YEF3-NRg-9",
"YLR050Cg1-ASK1-NRg-1",
"YLR050Cg1-SMC1-TRg-1",
"YLR050Cg1-NIP1-NRg-1",
"YLR050Cg1-RPP1-NRg-1",
"YLR050Cg1-YDJ1-TRg-6",
"YLR050Cg1-SUB2-NRg-1",
"YLR050Cg1-TIM10-NRg-8",
"YLR050Cg1-TIM10-NRg-4",
"YLR050Cg1-TIM10-NRg-7",
"YLR050Cg1-SKI6-TRg-4",
"YLR050Cg1-TUB4-TRg-1",
"YLR050Cg1-CDC37-NRg-2",
"YLR050Cg1-ISD11-TRg-3",
"YLR050Cg1-YOS1-TRg-4",
"YLR050Cg1-SSC1-TRg-6",
"YLR050Cg1-MTR3-TRg-5",
"YLR050Cg1-MTR3-TRg-6",
"YLR050Cg1-TFA1-TRg-2",
"YLR050Cg1-CDC3-NRg-3",
"YLR050Cg1-ERG25-TA-18",
"YLR050Cg1-RPB11-TRg-4",
"YLR050Cg1-RPB11-TRg-1",
"YLR050Cg1-RPB11-TRg-2",
"YLR050Cg1-DED1-TRg-3",
"YLR050Cg1-DED1-TRg-1",
"YLR050Cg1-DED1-TRg-6",
"YLR050Cg1-DED1-TRg-4",
"YLR050Cg1-RPL10-NRg-5",
"YLR050Cg1-RPL10-NRg-4",
"YLR050Cg1-EFB1-NRg-1",
"YLR050Cg1-EFB1-NRg-5",
"YLR050Cg1-EFB1-NRg-4",
"YLR050Cg1-RPT3-NRg-1",
"YLR050Cg1-SAC6-TRg-8",
"YLR050Cg1-SAC6-TRg-4",
"YLR050Cg1-SAC6-TRg-5",
"YLR050Cg1-SAC6-TRg-3",
"YLR050Cg1-DIM1-TRg-5",
"YLR050Cg1-DIM1-TRg-7",
"YLR050Cg1-RPC17-NRg-1",
"YLR050Cg1-RPC17-NRg-2",
"YLR050Cg1-YDR341C-TRg-1",
"YLR050Cg1-RAP1-NRg-8",
"YLR050Cg1-RAP1-NRg-5",
"YLR050Cg1-RAP1-NRg-2",
"YLR050Cg1-SEC26-NRg-3",
"YLR050Cg1-SPP41-TRg-3",
"YLR050Cg1-TAP42-NRg-1",
"YLR050Cg1-PGA2-TRg-6",
"YLR050Cg1-BRL1-TRg-1",
"YLR050Cg1-FOL2-TRg-1",
"YLR050Cg1-NAB3-NRg-5",
"YLR050Cg1-SNF4-TRg-4",
"YLR050Cg1-HRR25-TRg-2",
"YLR050Cg1-TRS23-TRg-4",
"YLR050Cg1-CTR86-TRg-4",
"YLR050Cg1-RPB5-TRg-5",
"YLR050Cg1-SPN1-NRg-2",
"YLR050Cg1-SPN1-NRg-1",
"YLR050Cg1-SEC61-NRg-1",
"YLR050Cg1-SEC61-NRg-7",
"YLR050Cg1-TUS1-TRg-3",
"YLR050Cg1-OLE1-NRg-2",
"YLR050Cg1-AFG2-TRg-1",
"YLR050Cg1-TOA2-NRg-1",
"YLR050Cg1-USO1-TRg-1",
"YLR050Cg1-UTP22-NRg-2",
"YLR050Cg1-RIB1-TRg-3",
"YLR050Cg1-RIB1-TRg-7",
"YLR050Cg1-RIB1-TRg-4",
"YLR050Cg1-COG1-TRg-1",
"YLR050Cg1-RPL32-NRg-2",
"YLR050Cg1-GLC7-NRg-3",
"YLR050Cg1-GLC7-NRg-4",
"YLR050Cg1-HSF1-TRg-2",
"YLR050Cg1-DAM1-NRg-5",
"YLR050Cg1-SEC18-TRg-4",
"YLR050Cg1-SEC18-TRg-5",
"YLR050Cg1-PAB1-NRg-3",
"YLR050Cg1-POP8-TRg-2",
"YLR050Cg1-PAB1-NRg-4",
"YLR050Cg1-BIG1-TRg-4",
"YLR050Cg1-BIG1-TRg-5",
"YLR050Cg1-BIG1-TRg-6",
"YLR050Cg1-RPO41-NRg-1",
"YLR050Cg1-RVB2-NRg-2",
"YLR050Cg1-PET117-NRg-8",
"YLR050Cg1-VPS45-NRg-9",
"YLR050Cg1-YCG1-NRg-1",
"YLR050Cg1-NOC4-NRg-1",
"YLR050Cg1-NMD3-NRg-2",
"YLR050Cg1-DRS1-TRg-2",
"YLR050Cg1-HTB1-NRg-2",
"YLR050Cg1-IPI1-TRg-2",
"YLR050Cg1-SEC18-NRg-1",
"YLR050Cg1-SEC18-NRg-2",
"YLR050Cg1-JIP5-NRg-2",
"YLR050Cg1-YPT1-TRg-3",
"YLR050Cg1-YPT1-TRg-2",
"YLR050Cg1-CLF1-NRg-2",
"YLR050Cg1-SNF2-NRg-7",
"YLR050Cg1-SNF2-NRg-4",
"YLR050Cg1-RPL25-NRg-1",
"YLR050Cg1-NOP56-TRg-1",
"YLR050Cg1-NOP56-TRg-2",
"YLR050Cg1-TRS31-TRg-1",
"YLR050Cg1-DBF4-TRg-2",
"YLR050Cg1-DBF4-TRg-1",
"YLR050Cg1-RPC19-TRg-4",
"YLR050Cg1-RPC19-TRg-6",
"YLR050Cg1-RPC19-TRg-3",
"YLR050Cg1-ROK1-NRg-1",
"YLR050Cg1-CDC33-TRg-4",
"YLR050Cg1-DHR2-TRg-3",
"YLR050Cg1-RRP42-NRg-5",
"YLR050Cg1-CLF1-TRg-1",
"YLR050Cg1-ERG11-NA-16",
"YLR050Cg1-VAS1-NRg-4",
"YLR050Cg1-PIK1-NRg-2",
"YLR050Cg1-SAR1-NRg-7",
"YLR050Cg1-SAR1-NRg-4",
"YLR050Cg1-RPS3-TRg-1",
"YLR050Cg1-YTM1-TRg-2",
"YLR050Cg1-SUI3-NRg-5",
"YLR050Cg1-SUI3-NRg-2",
"YLR050Cg1-RRP7-TRg-4",
"YLR050Cg1-RRP7-TRg-6",
"YLR050Cg1-NIP7-TRg-2",
"YLR050Cg1-MDM35-TRg-1",
"YLR050Cg1-ALA1-NRg-1",
"YLR050Cg1-DOA4-NRg-2",
"YLR050Cg1-RPS13-NRg-1",
"YLR050Cg1-YSF3-TRg-2",
"YLR050Cg1-RPS2-NRg-11",
"YLR050Cg1-SSL1-TRg-10",
"YLR050Cg1-NIP7-TRg-1",
"YLR050Cg1-LST8-NRg-1",
"YLR050Cg1-TAF4-TRg-3",
"YLR050Cg1-HAS1-TRg-2",
"YLR050Cg1-GLC7-TRg-2",
"YLR050Cg1-CDC45-NRg-1",
"YLR050Cg1-SEC22-NRg-8",
"YLR050Cg1-YOS1-TRg-2",
"YLR050Cg1-RBA50-TRg-3",
"YLR050Cg1-SPP41-NRg-2",
"YLR050Cg1-PRP46-TRg-2",
"YLR050Cg1-PGA2-NRg-1",
"YLR050Cg1-CBF5-TRg-3",
"YLR050Cg1-TCP1-NRg-3",
"YLR050Cg1-TCP1-NRg-2",
"YLR050Cg1-ERG26-NRg-2",
"YLR050Cg1-ERG26-NRg-4",
"YLR050Cg1-MES1-TRg-5",
"YLR050Cg1-HTS1-TRg-2",
"YLR050Cg1-SSS1-TRg-3",
"YLR050Cg1-SSS1-TRg-2",
"YLR050Cg1-SYS1-TRg-7",
"YLR050Cg1-SYS1-TRg-2",
"YLR050Cg1-SYS1-TRg-1",
"YLR050Cg1-BFR2-TRg-1",
"YLR050Cg1-EOS1-TRg-3",
"YLR050Cg1-TAF4-NRg-1",
"YLR050Cg1-ARL3-NRg-8",
"YLR050Cg1-RPN5-NRg-1",
"YLR050Cg1-TIM9-NRg-2",
"YLR050Cg1-NUP57-NRg-3",
"YLR050Cg1-VPS4-TRg-1",
"YLR050Cg1-CDC3-TRg-4",
"YLR050Cg1-BBP1-NRg-1",
"YLR050Cg1-BBP1-NRg-2",
"YLR050Cg1-USE1-NRg-3",
"YLR050Cg1-CCT7-TRg-1",
"YLR050Cg1-SAH1-TRg-3",
"YLR050Cg1-CHS2-TRg-1",
"YLR050Cg1-DPM1-TRg-2",
"YLR050Cg1-BBP1-TRg-1",
"YLR050Cg1-NRD1-TRg-4",
"YLR050Cg1-RPB3-NRg-1",
"YLR050Cg1-PHO85-NRg-6",
"YLR050Cg1-SNF6-TRg-6",
"YLR050Cg1-PRP38-NRg-2",
"YLR050Cg1-OAR1-NRg-3",
"YLR050Cg1-ROX3-NRg-1",
"YLR050Cg1-YPP1-TRg-6",
"YLR050Cg1-CBF2-NRg-8",
"YLR050Cg1-SPT6-TRg-5",
"YLR050Cg1-SEC10-NRg-1",
"YLR050Cg1-NSL1-NRg-3",
"YLR050Cg1-NRD1-NRg-8",
"YLR050Cg1-RPB3-TRg-1",
"YLR050Cg1-NRD1-NRg-4",
"YLR050Cg1-RVB1-TRg-2",
"YLR050Cg1-TIF5-NRg-8",
"YLR050Cg1-EOS1-NRg-1",
"YLR050Cg1-ERG25-NA-26",
"YLR050Cg1-MSL5-NRg-4",
"YLR050Cg1-SEC24-TRg-2",
"YLR050Cg1-RPL30-NRg-5",
"YLR050Cg1-SNU71-NRg-3",
"YLR050Cg1-CDC33-NRg-1",
"YLR050Cg1-RPN6-TRg-4",
"YLR050Cg1-NAB2-TRg-4",
"YLR050Cg1-NAB2-TRg-6",
"YLR050Cg1-YTM1-NRg-1",
"YLR050Cg1-OLE1-TRg-8",
"YLR050Cg1-OLE1-TRg-1",
"YLR050Cg1-UTP7-TRg-4",
"YLR050Cg1-ACT1-NRg-6",
"YLR050Cg1-RPL18A-NRg-3",
"YLR050Cg1-BRX1-NRg-1",
"YLR050Cg1-NAF1-TRg-8",
"YLR050Cg1-NAF1-TRg-6",
"YLR050Cg1-NAF1-TRg-4",
"YLR050Cg1-CDC8-TRg-2",
"YLR050Cg1-NSE4-TRg-1",
"YLR050Cg1-PAB1-NRg-2",
"YLR050Cg1-PRP43-TRg-4",
"YLR050Cg1-SEC2-NRg-3",
"YLR050Cg1-SEC2-NRg-6",
"YLR050Cg1-MPP10-NRg-5",
"YLR050Cg1-YDR355C-TRg-2",
"YLR050Cg1-YLR339C-TRg-9",
"YLR050Cg1-SNM1-TRg-2",
"YLR050Cg1-ALR1-NRg-4",
"YLR050Cg1-ALR1-NRg-1",
"YLR050Cg1-ALR1-NRg-3",
"YLR050Cg1-RPL10-TRg-1",
"YLR050Cg1-RPL28-TRg-2",
"YLR050Cg1-UTP25-TRg-1",
"YLR050Cg1-POB3-TRg-1",
"YLR050Cg1-POB3-TRg-3",
"YLR050Cg1-POB3-TRg-2",
"YLR050Cg1-MED11-TRg-1",
"YLR050Cg1-ISA1-TRg-15",
"YLR050Cg1-RRP1-NRg-1",
"YLR050Cg1-MES1-NRg-1",
"YLR050Cg1-SEC13-NRg-5",
"YLR050Cg1-MCM2-NRg-2",
"YLR050Cg1-ALA1-TRg-4",
"YLR050Cg1-MTG2-TRg-5",
"YLR050Cg1-TIF35-NRg-3",
"YLR050Cg1-NSE1-TRg-3",
"YLR050Cg1-NSE1-TRg-4",
"YLR050Cg1-MOB2-NRg-6",
"YLR050Cg1-VRG4-NRg-3",
"YLR050Cg1-PRP9-TRg-3",
"YLR050Cg1-HYM1-TRg-5",
"YLR050Cg1-POP1-TRg-5",
"YLR050Cg1-POP1-TRg-9",
"YLR050Cg1-RPL17A-TRg-1",
"YLR050Cg1-SLD2-TRg-1",
"YLR050Cg1-CDC48-NRg-7",
"YLR050Cg1-FHL1-NRg-2",
"YLR050Cg1-BET3-NRg-7",
"YLR050Cg1-MAK21-TRg-1",
"YLR050Cg1-BRN1-TRg-4",
"YLR050Cg1-FBA1-NRg-3",
"YLR050Cg1-CDC42-TRg-6",
"YLR050Cg1-CDC42-TRg-7",
"YLR050Cg1-COG4-NRg-1",
"YLR050Cg1-ATP3-NRg-3",
"YLR050Cg1-ATP3-NRg-2",
"YLR050Cg1-SMP3-TRg-5",
"YLR050Cg1-CFT2-NRg-2",
"YLR050Cg1-FAS2-TRg-5",
"YLR050Cg1-DBP2-NRg-3",
"YLR050Cg1-DBP2-NRg-2",
"YLR050Cg1-MPS2-NRg-4",
"YLR050Cg1-ARC35-TRg-2",
"YLR050Cg1-ARC35-TRg-5",
"YLR050Cg1-MRD1-TRg-1",
"YLR050Cg1-RLP7-TRg-1",
"YLR050Cg1-SPC34-TRg-1",
"YLR050Cg1-CDC45-TRg-2",
"YLR050Cg1-GCD6-TRg-3",
"YLR050Cg1-GCD6-TRg-4",
"YLR050Cg1-YPT6-NRg-2",
"YLR050Cg1-RPS13-TRg-2",
"YLR050Cg1-IPI3-TRg-3",
"YLR050Cg1-TIF5-NRg-9",
"YLR050Cg1-TIF5-NRg-7",
"YLR050Cg1-TIF5-NRg-6",
"YLR050Cg1-NAB3-TRg-3",
"YLR050Cg1-GCD2-TRg-1",
"YLR050Cg1-UBA1-TRg-2",
"YLR050Cg1-SLD3-TRg-6",
"YLR050Cg1-LCB1-TRg-5",
"YLR050Cg1-TOA2-TRg-6",
"YLR050Cg1-TOA2-TRg-1",
"YLR050Cg1-TOA2-TRg-3",
"YLR050Cg1-LSM2-TRg-1",
"YLR050Cg1-YML6-TRg-13",
"YLR050Cg1-YML6-TRg-12",
"YLR050Cg1-UTP15-NRg-1",
"YLR050Cg1-TIF6-NRg-8",
"YLR050Cg1-SUP35-NRg-1",
"YLR050Cg1-MPP10-NRg-1",
"YLR050Cg1-SWI3-TRg-7",
"YLR050Cg1-SSN3-NRg-2",
"YLR050Cg1-SEC13-NRg-7",
"YLR050Cg1-RPS15-NRg-3",
"YLR050Cg1-RPL3-TRg-2",
"YLR050Cg1-FBA1-NRg-2",
"YLR050Cg1-FBA1-NRg-1",
"YLR050Cg1-FBA1-NRg-5",
"YLR050Cg1-DAM1-TRg-2",
"YLR050Cg1-NHP2-TRg-2",
"YLR050Cg1-HCA4-NRg-6",
"YLR050Cg1-PRE3-TRg-4",
"YLR050Cg1-DBP5-NRg-4",
"YLR050Cg1-SPT6-NRg-4",
"YLR050Cg1-SPT6-NRg-2",
"YLR050Cg1-RPL18A-TRg-4",
"YLR050Cg1-KSH1-TRg-1",
"YLR050Cg1-KSH1-TRg-3",
"YLR050Cg1-IPI3-NRg-1",
"YLR050Cg1-PGA2-TRg-8",
"YLR050Cg1-RPL18A-TRg-2",
"YLR050Cg1-RPL33A-NRg-6",
"YLR050Cg1-TAF12-NRg-2",
"YLR050Cg1-USE1-TRg-5",
"YLR050Cg1-YNL114C-TRg-1",
"YLR050Cg1-SMC5-TRg-7",
"YLR050Cg1-SMC5-TRg-6",
"YLR050Cg1-RSC58-TRg-1",
"YLR050Cg1-CTF13-TRg-2",
"YLR050Cg1-NAB2-NRg-2",
"YLR050Cg1-MCM7-TRg-4",
"YLR050Cg1-BCP1-NRg-5",
"YLR050Cg1-STU2-TRg-3",
"YLR050Cg1-SEC21-NRg-6",
"YLR050Cg1-SEC21-NRg-3",
"YLR050Cg1-RPL1B-TRg-3",
"YLR050Cg1-SEC20-NRg-2",
"YLR050Cg1-VMA3-NRg-2",
"YLR050Cg1-SEC23-NRg-5",
"YLR050Cg1-CDC28-TRg-4",
"YLR050Cg1-RPN12-NRg-11",
"YLR050Cg1-PUP3-TRg-3",
"YLR050Cg1-SEC31-TRg-2",
"YLR050Cg1-SED5-TRg-6",
"YLR050Cg1-SED5-TRg-5",
"YLR050Cg1-RPL33A-TRg-1",
"YLR050Cg1-RPL33A-TRg-2",
"YLR050Cg1-MRPL11-TRg-2",
"YLR050Cg1-RTP1-NRg-2",
"YLR050Cg1-NUG1-TRg-2",
"YLR050Cg1-VPH2-TRg-4",
"YLR050Cg1-COP1-NRg-3",
"YLR050Cg1-CRM1-NRg-1",
"YLR050Cg1-RPL5-NRg-4",
"YLR050Cg1-SNU13-NRg-4",
"YLR050Cg1-PFS2-TRg-3",
"YLR050Cg1-MPP10-TRg-2",
"YLR050Cg1-TSR4-NRg-2",
"YLR050Cg1-RSC2-TRg-1",
"YLR050Cg1-SEC65-TRg-2",
"YLR050Cg1-SMI1-NRg-1",
"YLR050Cg1-RTT105-NRg-4",
"YLR050Cg1-VMA5-TRg-3",
"YLR050Cg1-VMA5-TRg-5",
"YLR050Cg1-RRP1-TRg-3",
"YLR050Cg1-CLC1-TRg-2",
"YLR050Cg1-GCD6-NRg-1",
"YLR050Cg1-GCD6-NRg-2",
"YLR050Cg1-PXR1-TRg-1",
"YLR050Cg1-CDC14-NRg-1",
"YLR050Cg1-PCF11-TRg-6",
"YLR050Cg1-PCF11-TRg-5",
"YLR050Cg1-PCF11-TRg-4",
"YLR050Cg1-SEC31-NRg-1",
"YLR050Cg1-RRP5-NRg-1",
"YLR050Cg1-PRE10-TRg-5",
"YLR050Cg1-PRE10-TRg-1",
"YLR050Cg1-RPS5-TRg-2",
"YLR050Cg1-NSP1-TRg-4",
"YLR050Cg1-PRP38-TRg-4",
"YLR050Cg1-RCF1-NRg-5",
"YLR050Cg1-RSC3-TRg-4",
"YLR050Cg1-RSC3-TRg-5",
"YLR050Cg1-RSC3-TRg-6",
"YLR050Cg1-HTA1-NRg-12",
"YLR050Cg1-HTA1-NRg-11",
"YLR050Cg1-UTP23-TRg-2",
"YLR050Cg1-GCD7-NRg-1",
"YLR050Cg1-GCD7-NRg-2",
"YLR050Cg1-GCD7-NRg-6",
"YLR050Cg1-GAL11-NRg-2",
"YLR050Cg1-GAL11-NRg-9",
"YLR050Cg1-PHO4-TRg-5",
"YLR050Cg1-SNP1-NRg-3",
"YLR050Cg1-RPC37-TRg-5",
"YLR050Cg1-CRM1-TRg-5",
"YLR050Cg1-CRM1-TRg-2",
"YLR050Cg1-ASK1-TRg-7",
"YLR050Cg1-STU2-NRg-4",
"YLR050Cg1-NEO1-NRg-3",
"YLR050Cg1-GAL11-TRg-5",
"YLR050Cg1-GAL11-TRg-7",
"YLR050Cg1-SAM50-NRg-3",
"YLR050Cg1-CSL4-TRg-2",
"YLR050Cg1-CCT5-TRg-2",
"YLR050Cg1-POL30-NRg-1",
"YLR050Cg1-MED4-TRg-4",
"YLR050Cg1-MED4-TRg-3",
"YLR050Cg1-MED4-TRg-2",
"YLR050Cg1-GDI1-TRg-4",
"YLR050Cg1-GDI1-TRg-3",
"YLR050Cg1-REB1-TRg-6",
"YLR050Cg1-MRPL37-NRg-2",
"YLR050Cg1-NOC3-TRg-3",
"YLR050Cg1-SPC97-TRg-3",
"YLR050Cg1-IPP1-TRg-3",
"YLR050Cg1-IPP1-TRg-2",
"YLR050Cg1-PTI1-TRg-3",
"YLR050Cg1-PTI1-TRg-5",
"YLR050Cg1-RFC5-NRg-1",
"YLR050Cg1-CDC24-TRg-1",
"YLR050Cg1-CDC24-TRg-3",
"YLR050Cg1-CDC24-TRg-5",
"YLR050Cg1-CDC24-TRg-6",
"YLR050Cg1-UTP23-TRg-6",
"YLR050Cg1-UTP23-TRg-4",
"YLR050Cg1-UTP23-TRg-1",
"YLR050Cg1-RHO3-NRg-4",
"YLR050Cg1-TRS23-NRg-1",
"YLR050Cg1-TRS23-NRg-3",
"YLR050Cg1-RSP5-TRg-2",
"YLR050Cg1-RSP5-TRg-1",
"YLR050Cg1-SDA1-NRg-1",
"YLR050Cg1-KAP95-TRg-8",
"YLR050Cg1-ACO1-TRg-6",
"YLR050Cg1-HTA1-NRg-3",
"YLR050Cg1-HTA1-NRg-2",
"YLR050Cg1-SPN1-TRg-1",
"YLR050Cg1-MOT1-NRg-7",
"YLR050Cg1-RPL17A-NRg-4",
"YLR050Cg1-ADA2-TRg-4",
"YLR050Cg1-SFH1-NRg-1",
"YLR050Cg1-SPC97-NRg-5",
"YLR050Cg1-PRP22-TRg-3",
"YLR050Cg1-SEN15-TRg-2",
"YLR050Cg1-RPL3-NRg-2",
"YLR050Cg1-ISD11-NRg-2",
"YLR050Cg1-HEM12-TRg-8",
"YLR050Cg1-SEC10-TRg-1",
"YLR050Cg1-HTB1-TRg-7",
"YLR050Cg1-TTI2-TRg-1",
"YLR050Cg1-ACP1-TRg-2",
"YLR050Cg1-ACP1-TRg-4",
"YLR050Cg1-GAL11-NRg-10",
"YLR050Cg1-UTP22-TRg-2",
"YLR050Cg1-MST1-NRg-5",
"YLR050Cg1-RIB7-NRg-2",
"YLR050Cg1-MCD1-TRg-6",
"YLR050Cg1-MCD1-TRg-5",
"YLR050Cg1-GPI8-NRg-2",
"YLR050Cg1-THS1-TRg-2",
"YLR050Cg1-RRP7-TRg-2",
"YLR050Cg1-RRP7-TRg-5",
"YLR050Cg1-SMX2-NRg-7",
"YLR050Cg1-RRP45-TRg-5",
"YLR050Cg1-RRP45-TRg-4",
"YLR050Cg1-CNS1-TRg-2",
"YLR050Cg1-FBP1-NRg-9",
"YLR050Cg1-GCD11-NRg-1",
"YLR050Cg1-RPL10-TRg-2",
"YLR050Cg1-NUP192-TRg-4",
"YLR050Cg1-NUP145-NRg-4",
"YLR050Cg1-HEM12-TRg-6",
"YLR050Cg1-PLC1-TRg-3",
"YLR050Cg1-RPA43-TRg-1",
"YLR050Cg1-RPB7-NRg-2",
"YLR050Cg1-RPB7-NRg-3",
"YLR050Cg1-NSL1-NRg-1",
"YLR050Cg1-UTP6-TRg-3",
"YLR050Cg1-UTP6-TRg-1",
"YLR050Cg1-YJU2-TRg-5",
"YLR050Cg1-FRS2-NRg-5",
"YLR050Cg1-TIF35-NRg-2",
"YLR050Cg1-GPI15-TRg-1",
"YLR050Cg1-NOP1-NRg-5",
"YLR050Cg1-GPI15-TRg-4",
"YLR050Cg1-COG4-TRg-1",
"YLR050Cg1-TFA1-TRg-1",
"YLR050Cg1-RHO1-NRg-2",
"YLR050Cg1-RHO1-NRg-1",
"YLR050Cg1-CDC55-NRg-2",
"YLR050Cg1-IDI1-NRg-7",
"YLR050Cg1-RPL32-TRg-5",
"YLR050Cg1-RPB5-TRg-4",
"YLR050Cg1-DIP2-TRg-5",
"YLR050Cg1-DIP2-TRg-1",
"YLR050Cg1-RPC40-TRg-2",
"YLR050Cg1-CDC6-TRg-5",
"YLR050Cg1-CDC6-TRg-3",
"YLR050Cg1-DAD2-TRg-2",
"YLR050Cg1-RVS161-TRg-2",
"YLR050Cg1-RVS161-TRg-1",
"YLR050Cg1-SUP45-NRg-3",
"YLR050Cg1-SRB6-NRg-5",
"YLR050Cg1-RPC11-TRg-4",
"YLR050Cg1-RKI1-TRg-8",
"YLR050Cg1-NIP7-TRg-3",
"YLR050Cg1-RPL33A-NRg-12",
"YLR050Cg1-SAM50-TRg-4",
"YLR050Cg1-NOP4-NRg-1",
"YLR050Cg1-NOP4-NRg-3",
"YLR050Cg1-SMX2-TRg-5",
"YLR050Cg1-POL12-NRg-2",
"YLR050Cg1-BMS1-NRg-2",
"YLR050Cg1-RPA190-TRg-5",
"YLR050Cg1-ALG14-NRg-4",
"YLR050Cg1-ALG14-NRg-1",
"YLR050Cg1-PRE5-NRg-1",
"YLR050Cg1-BIG1-NRg-2",
"YLR050Cg1-TFA2-TRg-4",
"YLR050Cg1-IMP4-TRg-6",
"YLR050Cg1-PAN1-NRg-1",
"YLR050Cg1-UTP13-TRg-2",
"YLR050Cg1-KAE1-NRg-3",
"YLR050Cg1-ERG20-TRg-1",
"YLR050Cg1-CDC20-TRg-6",
"YLR050Cg1-PWP2-NRg-2",
"YLR050Cg1-COG1-NRg-1",
"YLR050Cg1-RPL1B-TRg-4",
"YLR050Cg1-RPL1B-TRg-7",
"YLR050Cg1-UTP20-TRg-3",
"YLR050Cg1-UTP20-TRg-4",
"YLR050Cg1-RPL25-TRg-4",
"YLR050Cg1-RPL25-TRg-2",
"YLR050Cg1-MCM7-NRg-1",
"YLR050Cg1-MRP49-TRg-5",
"YLR050Cg1-ERO1-NRg-3",
"YLR050Cg1-UTP5-TRg-7",
"YLR050Cg1-MCM4-NRg-1",
"YLR050Cg1-PRE3-NRg-1",
"YLR050Cg1-FCF1-NRg-1",
"YLR050Cg1-CUS1-NRg-1",
"YLR050Cg1-PSF1-TRg-2",
"YLR050Cg1-BCP1-TRg-2",
"YLR050Cg1-PAN1-TRg-1",
"YLR050Cg1-PAN1-TRg-3",
"YLR050Cg1-PAN1-TRg-4",
"YLR050Cg1-VPS3-TRg-2",
"YLR050Cg1-YIL060W-NRg-1",
"YLR050Cg1-VPS53-NRg-1",
"YLR050Cg1-CYR1-TRg-4",
"YLR050Cg1-CYR1-TRg-7",
"YLR050Cg1-MPS1-NRg-1",
"YLR050Cg1-SRP1-TRg-5",
"YLR050Cg1-SRP1-TRg-4",
"YLR050Cg1-TAF12-TRg-2",
"YLR050Cg1-TAF12-TRg-3",
"YLR050Cg1-POP4-TRg-1",
"YLR050Cg1-SPT16-TRg-1",
"YLR050Cg1-NUP82-TRg-4",
"YLR050Cg1-DML1-TRg-3",
"YLR050Cg1-RPA43-NRg-3",
"YLR050Cg1-STU2-NRg-3",
"YLR050Cg1-POP4-NRg-4",
"YLR050Cg1-MCD1-TRg-2",
"YLR050Cg1-RPS3-NRg-4",
"YLR050Cg1-PRP9-TRg-4",
"YLR050Cg1-RPP1-NRg-2",
"YLR050Cg1-MTR2-NRg-11",
"YLR050Cg1-GCD11-TRg-1",
"YLR050Cg1-RPF1-TRg-3",
"YLR050Cg1-SUB2-NRg-4",
"YLR050Cg1-GPI15-TRg-3",
"YLR050Cg1-ERG9-TRg-6",
"YLR050Cg1-RPT2-NRg-1",
"YLR050Cg1-YOS1-NRg-3",
"YLR050Cg1-SCM3-TRg-4",
"YLR050Cg1-SCM3-TRg-6",
"YLR050Cg1-RLP7-NRg-1",
"YLR050Cg1-TFB2-NRg-4",
"YLR050Cg1-IMP4-TRg-1",
"YLR050Cg1-IMP4-TRg-3",
"YLR050Cg1-PRE4-TRg-3",
"YLR050Cg1-SUB2-TRg-3",
"YLR050Cg1-RPP0-NRg-4",
"YLR050Cg1-RPP0-NRg-3",
"YLR050Cg1-TOM40-TRg-4",
"YLR050Cg1-FUR1-NRg-12",
"YLR050Cg1-TOM40-TRg-2",
"YLR050Cg1-VMA11-NRg-4",
"YLR050Cg1-PGS1-NRg-4",
"YLR050Cg1-URB1-TRg-4",
"YLR050Cg1-ARP4-TRg-3",
"YLR050Cg1-RPT3-TRg-3",
"YLR050Cg1-SUI3-TRg-3",
"YLR050Cg1-RFC5-NRg-2",
"YLR050Cg1-RRP14-TRg-2",
"YLR050Cg1-SCC2-TRg-1",
"YLR050Cg1-SSC1-TRg-3",
"YLR050Cg1-RRP9-TRg-3",
"YLR050Cg1-MOT1-NRg-9",
"YLR050Cg1-RPL42A-NRg-2",
"YLR050Cg1-SEC16-TRg-7",
"YLR050Cg1-IMP4-NRg-2",
"YLR050Cg1-YEF3-NRg-4",
"YLR050Cg1-PUP1-TRg-1",
"YLR050Cg1-UTP22-TRg-6",
"YLR050Cg1-DBP2-NRg-4",
"YLR050Cg1-PRE2-TRg-7",
"YLR050Cg1-ATP16-TRg-6",
"YLR050Cg1-UTP13-TRg-4",
"YLR050Cg1-DOP1-NRg-4",
"YLR050Cg1-TIM44-TRg-3",
"YLR050Cg1-ATP16-TRg-2",
"YLR050Cg1-ENP1-NRg-3",
"YLR050Cg1-NAF1-TRg-3",
"YLR050Cg1-COG4-TRg-2",
"YLR050Cg1-SOG2-TRg-7",
"YLR050Cg1-YDR341C-TRg-3",
"YLR050Cg1-YMR290W-A-TRg-10",
"YLR050Cg1-NUP192-NRg-9",
"YLR050Cg1-RPS31-NRg-8",
"YLR050Cg1-SPC97-NRg-6",
"YLR050Cg1-EBP2-NRg-1",
"YLR050Cg1-CDC48-TRg-5",
"YLR050Cg1-RPT1-TRg-4",
"YLR050Cg1-ULP1-NRg-2",
"YLR050Cg1-RPN3-TRg-6",
"YLR050Cg1-RPT1-TRg-5",
"YLR050Cg1-KRE5-TRg-2",
"YLR050Cg1-TBF1-NRg-8",
"YLR050Cg1-UTP22-NRg-4",
"YLR050Cg1-SSC1-NRg-4",
"YLR050Cg1-REB1-TRg-4",
"YLR050Cg1-CDC48-NRg-9",
"YLR050Cg1-FAS2-TRg-8",
"YLR050Cg1-TAO3-TRg-8",
"YLR050Cg1-CKS1-TRg-5",
"YLR050Cg1-YLR379W-TRg-7",
"YLR050Cg1-TEN1-NRg-2",
"YLR050Cg1-RPL42A-TRg-2",
"YLR050Cg1-SEC27-TRg-4",
"YLR050Cg1-TBF1-NRg-4",
"YLR050Cg1-RPT1-NRg-6",
"YLR050Cg1-COG1-TRg-3",
"YLR050Cg1-SUI1-TRg-6",
"YLR050Cg1-TIM23-TRg-6",
"YLR050Cg1-CDC48-NRg-6",
"YLR050Cg1-EPL1-TRg-5",
"YLR050Cg1-RPT5-TRg-8",
"YLR050Cg1-ATP16-NRg-4",
"YLR050Cg1-RPN6-TRg-3",
"YLR050Cg1-ERG9-NRg-6",
"YLR050Cg1-SMX3-TRg-1",
"YLR050Cg1-NCB2-NRg-3",
"YLR050Cg1-SEC16-NRg-12",
"YLR050Cg1-RPN6-TRg-2",
"YLR050Cg1-REB1-NRg-4",
"YLR050Cg1-ATP16-TRg-9",
"YLR050Cg1-ERG9-NRg-7",
"SAP30g7-RPL15A-NRg-4",
"SAP30g7-RPL15A-NRg-5",
"SAP30g7-KRE33-TRg-1",
"SAP30g7-PMI40-NRg-1",
"SAP30g7-NOP19-NRg-3",
"SAP30g7-SRP14-NRg-4",
"SAP30g7-SEC27-TRg-2",
"SAP30g7-GPI14-TRg-3",
"SAP30g7-PAH1-TRg-7",
"SAP30g7-PAH1-TRg-6",
"SAP30g7-PAH1-TRg-5",
"SAP30g7-PAH1-TRg-3",
"SAP30g7-COG3-TRg-1",
"SAP30g7-HTS1-NRg-5",
"SAP30g7-MSN5-TRg-7",
"SAP30g7-ERG26-TRg-1",
"SAP30g7-SMD2-TRg-5",
"SAP30g7-SMD2-TRg-4",
"SAP30g7-SMD2-TRg-1",
"SAP30g7-PRE7-TRg-4",
"SAP30g7-PRE7-TRg-7",
"SAP30g7-SEC6-TRg-3",
"SAP30g7-ESF2-NRg-1",
"SAP30g7-ESF2-NRg-3",
"SAP30g7-AFG2-TRg-2",
"SAP30g7-RRP36-TRg-3",
"SAP30g7-RRP36-TRg-5",
"SAP30g7-GCR1-NRg-2",
"SAP30g7-PRE4-NRg-4",
"SAP30g7-PRE4-NRg-9",
"SAP30g7-DSN1-NRg-2",
"SAP30g7-GPI11-TRg-3",
"SAP30g7-POP3-TRg-1",
"SAP30g7-MNE1-TRg-5",
"SAP30g7-RRP12-NRg-1",
"SAP30g7-RSC6-TRg-2",
"SAP30g7-CDC25-TRg-1",
"SAP30g7-CDC25-TRg-9",
"SAP30g7-YPP1-NRg-3",
"SAP30g7-NFS1-NRg-9",
"SAP30g7-NFS1-NRg-8",
"SAP30g7-UBA2-TRg-1",
"SAP30g7-ARP2-NRg-3",
"SAP30g7-MAK16-TRg-1",
"SAP30g7-CEP3-NRg-1",
"SAP30g7-GUK1-TRg-5",
"SAP30g7-GUK1-TRg-2",
"SAP30g7-GPI12-NRg-6",
"SAP30g7-RPS5-NRg-5",
"SAP30g7-RPS5-NRg-2",
"SAP30g7-RPC19-NRg-1",
"SAP30g7-TIM54-TRg-1",
"SAP30g7-TEN1-TRg-2",
"SAP30g7-SAH1-NRg-4",
"SAP30g7-SAH1-NRg-5",
"SAP30g7-SAH1-NRg-3",
"SAP30g7-ATP15-NRg-5",
"SAP30g7-SCD5-TRg-5",
"SAP30g7-ARB1-NRg-2",
"SAP30g7-ARB1-NRg-4",
"SAP30g7-PUP2-TRg-1",
"SAP30g7-CCT8-TRg-2",
"SAP30g7-MCM4-TRg-1",
"SAP30g7-LSM4-TRg-1",
"SAP30g7-NOP53-NRg-1",
"SAP30g7-ATP3-TRg-4",
"SAP30g7-AFG2-NRg-3",
"SAP30g7-PRO3-NRg-3",
"SAP30g7-NRD1-NRg-10",
"SAP30g7-SEC61-TRg-2",
"SAP30g7-RHO3-TRg-4",
"SAP30g7-SNF2-TRg-6",
"SAP30g7-SMD2-NRg-3",
"SAP30g7-RSC4-TRg-2",
"SAP30g7-RSC4-TRg-1",
"SAP30g7-TIF34-TRg-2",
"SAP30g7-BET1-NRg-1",
"SAP30g7-CDC8-NRg-2",
"SAP30g7-PRP42-TRg-2",
"SAP30g7-RRB1-TRg-2",
"SAP30g7-SPC24-TRg-1",
"SAP30g7-ILS1-NRg-1",
"SAP30g7-GFA1-TRg-2",
"SAP30g7-SEC21-NRg-10",
"SAP30g7-RPC10-NRg-1",
"SAP30g7-RPB10-TRg-3",
"SAP30g7-RPB10-TRg-2",
"SAP30g7-YNL181W-TRg-1",
"SAP30g7-RAD3-NRg-1",
"SAP30g7-NOP10-TRg-1",
"SAP30g7-BFR2-TRg-3",
"SAP30g7-MCM2-TRg-6",
"SAP30g7-MCM2-TRg-4",
"SAP30g7-MPP10-TRg-1",
"SAP30g7-RET2-TRg-4",
"SAP30g7-RET2-TRg-1",
"SAP30g7-RPS2-NRg-1",
"SAP30g7-RPS2-NRg-2",
"SAP30g7-ORC4-NRg-3",
"SAP30g7-TIP20-TRg-7",
"SAP30g7-SMT3-TRg-1",
"SAP30g7-MSS18-NRg-6",
"SAP30g7-YEF3-NRg-9",
"SAP30g7-ASK1-NRg-1",
"SAP30g7-SMC1-TRg-1",
"SAP30g7-NIP1-NRg-1",
"SAP30g7-RPP1-NRg-1",
"SAP30g7-YDJ1-TRg-6",
"SAP30g7-SUB2-NRg-1",
"SAP30g7-TIM10-NRg-8",
"SAP30g7-TIM10-NRg-4",
"SAP30g7-TIM10-NRg-7",
"SAP30g7-SKI6-TRg-4",
"SAP30g7-TUB4-TRg-1",
"SAP30g7-CDC37-NRg-2",
"SAP30g7-ISD11-TRg-3",
"SAP30g7-YOS1-TRg-4",
"SAP30g7-SSC1-TRg-6",
"SAP30g7-MTR3-TRg-5",
"SAP30g7-MTR3-TRg-6",
"SAP30g7-TFA1-TRg-2",
"SAP30g7-CDC3-NRg-3",
"SAP30g7-ERG25-TA-18",
"SAP30g7-RPB11-TRg-4",
"SAP30g7-RPB11-TRg-1",
"SAP30g7-RPB11-TRg-2",
"SAP30g7-DED1-TRg-3",
"SAP30g7-DED1-TRg-1",
"SAP30g7-DED1-TRg-6",
"SAP30g7-DED1-TRg-4",
"SAP30g7-RPL10-NRg-5",
"SAP30g7-RPL10-NRg-4",
"SAP30g7-EFB1-NRg-1",
"SAP30g7-EFB1-NRg-5",
"SAP30g7-EFB1-NRg-4",
"SAP30g7-RPT3-NRg-1",
"SAP30g7-SAC6-TRg-8",
"SAP30g7-SAC6-TRg-4",
"SAP30g7-SAC6-TRg-5",
"SAP30g7-SAC6-TRg-3",
"SAP30g7-DIM1-TRg-5",
"SAP30g7-DIM1-TRg-7",
"SAP30g7-RPC17-NRg-1",
"SAP30g7-RPC17-NRg-2",
"SAP30g7-YDR341C-TRg-1",
"SAP30g7-RAP1-NRg-8",
"SAP30g7-RAP1-NRg-5",
"SAP30g7-RAP1-NRg-2",
"SAP30g7-SEC26-NRg-3",
"SAP30g7-SPP41-TRg-3",
"SAP30g7-TAP42-NRg-1",
"SAP30g7-PGA2-TRg-6",
"SAP30g7-BRL1-TRg-1",
"SAP30g7-FOL2-TRg-1",
"SAP30g7-NAB3-NRg-5",
"SAP30g7-SNF4-TRg-4",
"SAP30g7-HRR25-TRg-2",
"SAP30g7-TRS23-TRg-4",
"SAP30g7-CTR86-TRg-4",
"SAP30g7-RPB5-TRg-5",
"SAP30g7-SPN1-NRg-2",
"SAP30g7-SPN1-NRg-1",
"SAP30g7-SEC61-NRg-1",
"SAP30g7-SEC61-NRg-7",
"SAP30g7-TUS1-TRg-3",
"SAP30g7-OLE1-NRg-2",
"SAP30g7-AFG2-TRg-1",
"SAP30g7-TOA2-NRg-1",
"SAP30g7-USO1-TRg-1",
"SAP30g7-UTP22-NRg-2",
"SAP30g7-RIB1-TRg-3",
"SAP30g7-RIB1-TRg-7",
"SAP30g7-RIB1-TRg-4",
"SAP30g7-COG1-TRg-1",
"SAP30g7-RPL32-NRg-2",
"SAP30g7-GLC7-NRg-3",
"SAP30g7-GLC7-NRg-4",
"SAP30g7-HSF1-TRg-2",
"SAP30g7-DAM1-NRg-5",
"SAP30g7-SEC18-TRg-4",
"SAP30g7-SEC18-TRg-5",
"SAP30g7-PAB1-NRg-3",
"SAP30g7-POP8-TRg-2",
"SAP30g7-PAB1-NRg-4",
"SAP30g7-BIG1-TRg-4",
"SAP30g7-BIG1-TRg-5",
"SAP30g7-BIG1-TRg-6",
"SAP30g7-RPO41-NRg-1",
"SAP30g7-RVB2-NRg-2",
"SAP30g7-PET117-NRg-8",
"SAP30g7-VPS45-NRg-9",
"SAP30g7-YCG1-NRg-1",
"SAP30g7-NOC4-NRg-1",
"SAP30g7-NMD3-NRg-2",
"SAP30g7-DRS1-TRg-2",
"SAP30g7-HTB1-NRg-2",
"SAP30g7-IPI1-TRg-2",
"SAP30g7-SEC18-NRg-1",
"SAP30g7-SEC18-NRg-2",
"SAP30g7-JIP5-NRg-2",
"SAP30g7-YPT1-TRg-3",
"SAP30g7-YPT1-TRg-2",
"SAP30g7-CLF1-NRg-2",
"SAP30g7-SNF2-NRg-7",
"SAP30g7-SNF2-NRg-4",
"SAP30g7-RPL25-NRg-1",
"SAP30g7-NOP56-TRg-1",
"SAP30g7-NOP56-TRg-2",
"SAP30g7-TRS31-TRg-1",
"SAP30g7-DBF4-TRg-2",
"SAP30g7-DBF4-TRg-1",
"SAP30g7-RPC19-TRg-4",
"SAP30g7-RPC19-TRg-6",
"SAP30g7-RPC19-TRg-3",
"SAP30g7-ROK1-NRg-1",
"SAP30g7-CDC33-TRg-4",
"SAP30g7-DHR2-TRg-3",
"SAP30g7-RRP42-NRg-5",
"SAP30g7-CLF1-TRg-1",
"SAP30g7-ERG11-NA-16",
"SAP30g7-VAS1-NRg-4",
"SAP30g7-PIK1-NRg-2",
"SAP30g7-SAR1-NRg-7",
"SAP30g7-SAR1-NRg-4",
"SAP30g7-RPS3-TRg-1",
"SAP30g7-YTM1-TRg-2",
"SAP30g7-SUI3-NRg-5",
"SAP30g7-SUI3-NRg-2",
"SAP30g7-RRP7-TRg-4",
"SAP30g7-RRP7-TRg-6",
"SAP30g7-NIP7-TRg-2",
"SAP30g7-MDM35-TRg-1",
"SAP30g7-ALA1-NRg-1",
"SAP30g7-DOA4-NRg-2",
"SAP30g7-RPS13-NRg-1",
"SAP30g7-YSF3-TRg-2",
"SAP30g7-RPS2-NRg-11",
"SAP30g7-SSL1-TRg-10",
"SAP30g7-NIP7-TRg-1",
"SAP30g7-LST8-NRg-1",
"SAP30g7-TAF4-TRg-3",
"SAP30g7-HAS1-TRg-2",
"SAP30g7-GLC7-TRg-2",
"SAP30g7-CDC45-NRg-1",
"SAP30g7-SEC22-NRg-8",
"SAP30g7-YOS1-TRg-2",
"SAP30g7-RBA50-TRg-3",
"SAP30g7-SPP41-NRg-2",
"SAP30g7-PRP46-TRg-2",
"SAP30g7-PGA2-NRg-1",
"SAP30g7-CBF5-TRg-3",
"SAP30g7-TCP1-NRg-3",
"SAP30g7-TCP1-NRg-2",
"SAP30g7-ERG26-NRg-2",
"SAP30g7-ERG26-NRg-4",
"SAP30g7-MES1-TRg-5",
"SAP30g7-HTS1-TRg-2",
"SAP30g7-SSS1-TRg-3",
"SAP30g7-SSS1-TRg-2",
"SAP30g7-SYS1-TRg-7",
"SAP30g7-SYS1-TRg-2",
"SAP30g7-SYS1-TRg-1",
"SAP30g7-BFR2-TRg-1",
"SAP30g7-EOS1-TRg-3",
"SAP30g7-TAF4-NRg-1",
"SAP30g7-ARL3-NRg-8",
"SAP30g7-RPN5-NRg-1",
"SAP30g7-TIM9-NRg-2",
"SAP30g7-NUP57-NRg-3",
"SAP30g7-VPS4-TRg-1",
"SAP30g7-CDC3-TRg-4",
"SAP30g7-BBP1-NRg-1",
"SAP30g7-BBP1-NRg-2",
"SAP30g7-USE1-NRg-3",
"SAP30g7-CCT7-TRg-1",
"SAP30g7-SAH1-TRg-3",
"SAP30g7-CHS2-TRg-1",
"SAP30g7-DPM1-TRg-2",
"SAP30g7-BBP1-TRg-1",
"SAP30g7-NRD1-TRg-4",
"SAP30g7-RPB3-NRg-1",
"SAP30g7-PHO85-NRg-6",
"SAP30g7-SNF6-TRg-6",
"SAP30g7-PRP38-NRg-2",
"SAP30g7-OAR1-NRg-3",
"SAP30g7-ROX3-NRg-1",
"SAP30g7-YPP1-TRg-6",
"SAP30g7-CBF2-NRg-8",
"SAP30g7-SPT6-TRg-5",
"SAP30g7-SEC10-NRg-1",
"SAP30g7-NSL1-NRg-3",
"SAP30g7-NRD1-NRg-8",
"SAP30g7-RPB3-TRg-1",
"SAP30g7-NRD1-NRg-4",
"SAP30g7-RVB1-TRg-2",
"SAP30g7-TIF5-NRg-8",
"SAP30g7-EOS1-NRg-1",
"SAP30g7-ERG25-NA-26",
"SAP30g7-MSL5-NRg-4",
"SAP30g7-SEC24-TRg-2",
"SAP30g7-RPL30-NRg-5",
"SAP30g7-SNU71-NRg-3",
"SAP30g7-CDC33-NRg-1",
"SAP30g7-RPN6-TRg-4",
"SAP30g7-NAB2-TRg-4",
"SAP30g7-NAB2-TRg-6",
"SAP30g7-YTM1-NRg-1",
"SAP30g7-OLE1-TRg-8",
"SAP30g7-OLE1-TRg-1",
"SAP30g7-UTP7-TRg-4",
"SAP30g7-ACT1-NRg-6",
"SAP30g7-RPL18A-NRg-3",
"SAP30g7-BRX1-NRg-1",
"SAP30g7-NAF1-TRg-8",
"SAP30g7-NAF1-TRg-6",
"SAP30g7-NAF1-TRg-4",
"SAP30g7-CDC8-TRg-2",
"SAP30g7-NSE4-TRg-1",
"SAP30g7-PAB1-NRg-2",
"SAP30g7-PRP43-TRg-4",
"SAP30g7-SEC2-NRg-3",
"SAP30g7-SEC2-NRg-6",
"SAP30g7-MPP10-NRg-5",
"SAP30g7-YDR355C-TRg-2",
"SAP30g7-YLR339C-TRg-9",
"SAP30g7-SNM1-TRg-2",
"SAP30g7-ALR1-NRg-4",
"SAP30g7-ALR1-NRg-1",
"SAP30g7-ALR1-NRg-3",
"SAP30g7-RPL10-TRg-1",
"SAP30g7-RPL28-TRg-2",
"SAP30g7-UTP25-TRg-1",
"SAP30g7-POB3-TRg-1",
"SAP30g7-POB3-TRg-3",
"SAP30g7-POB3-TRg-2",
"SAP30g7-MED11-TRg-1",
"SAP30g7-ISA1-TRg-15",
"SAP30g7-RRP1-NRg-1",
"SAP30g7-MES1-NRg-1",
"SAP30g7-SEC13-NRg-5",
"SAP30g7-MCM2-NRg-2",
"SAP30g7-ALA1-TRg-4",
"SAP30g7-MTG2-TRg-5",
"SAP30g7-TIF35-NRg-3",
"SAP30g7-NSE1-TRg-3",
"SAP30g7-NSE1-TRg-4",
"SAP30g7-MOB2-NRg-6",
"SAP30g7-VRG4-NRg-3",
"SAP30g7-PRP9-TRg-3",
"SAP30g7-HYM1-TRg-5",
"SAP30g7-POP1-TRg-5",
"SAP30g7-POP1-TRg-9",
"SAP30g7-RPL17A-TRg-1",
"SAP30g7-SLD2-TRg-1",
"SAP30g7-CDC48-NRg-7",
"SAP30g7-FHL1-NRg-2",
"SAP30g7-BET3-NRg-7",
"SAP30g7-MAK21-TRg-1",
"SAP30g7-BRN1-TRg-4",
"SAP30g7-FBA1-NRg-3",
"SAP30g7-CDC42-TRg-6",
"SAP30g7-CDC42-TRg-7",
"SAP30g7-COG4-NRg-1",
"SAP30g7-ATP3-NRg-3",
"SAP30g7-ATP3-NRg-2",
"SAP30g7-SMP3-TRg-5",
"SAP30g7-CFT2-NRg-2",
"SAP30g7-FAS2-TRg-5",
"SAP30g7-DBP2-NRg-3",
"SAP30g7-DBP2-NRg-2",
"SAP30g7-MPS2-NRg-4",
"SAP30g7-ARC35-TRg-2",
"SAP30g7-ARC35-TRg-5",
"SAP30g7-MRD1-TRg-1",
"SAP30g7-RLP7-TRg-1",
"SAP30g7-SPC34-TRg-1",
"SAP30g7-CDC45-TRg-2",
"SAP30g7-GCD6-TRg-3",
"SAP30g7-GCD6-TRg-4",
"SAP30g7-YPT6-NRg-2",
"SAP30g7-RPS13-TRg-2",
"SAP30g7-IPI3-TRg-3",
"SAP30g7-TIF5-NRg-9",
"SAP30g7-TIF5-NRg-7",
"SAP30g7-TIF5-NRg-6",
"SAP30g7-NAB3-TRg-3",
"SAP30g7-GCD2-TRg-1",
"SAP30g7-UBA1-TRg-2",
"SAP30g7-SLD3-TRg-6",
"SAP30g7-LCB1-TRg-5",
"SAP30g7-TOA2-TRg-6",
"SAP30g7-TOA2-TRg-1",
"SAP30g7-TOA2-TRg-3",
"SAP30g7-LSM2-TRg-1",
"SAP30g7-YML6-TRg-13",
"SAP30g7-YML6-TRg-12",
"SAP30g7-UTP15-NRg-1",
"SAP30g7-TIF6-NRg-8",
"SAP30g7-SUP35-NRg-1",
"SAP30g7-MPP10-NRg-1",
"SAP30g7-SWI3-TRg-7",
"SAP30g7-SSN3-NRg-2",
"SAP30g7-SEC13-NRg-7",
"SAP30g7-RPS15-NRg-3",
"SAP30g7-RPL3-TRg-2",
"SAP30g7-FBA1-NRg-2",
"SAP30g7-FBA1-NRg-1",
"SAP30g7-FBA1-NRg-5",
"SAP30g7-DAM1-TRg-2",
"SAP30g7-NHP2-TRg-2",
"SAP30g7-HCA4-NRg-6",
"SAP30g7-PRE3-TRg-4",
"SAP30g7-DBP5-NRg-4",
"SAP30g7-SPT6-NRg-4",
"SAP30g7-SPT6-NRg-2",
"SAP30g7-RPL18A-TRg-4",
"SAP30g7-KSH1-TRg-1",
"SAP30g7-KSH1-TRg-3",
"SAP30g7-IPI3-NRg-1",
"SAP30g7-PGA2-TRg-8",
"SAP30g7-RPL18A-TRg-2",
"SAP30g7-RPL33A-NRg-6",
"SAP30g7-TAF12-NRg-2",
"SAP30g7-USE1-TRg-5",
"SAP30g7-YNL114C-TRg-1",
"SAP30g7-SMC5-TRg-7",
"SAP30g7-SMC5-TRg-6",
"SAP30g7-RSC58-TRg-1",
"SAP30g7-CTF13-TRg-2",
"SAP30g7-NAB2-NRg-2",
"SAP30g7-MCM7-TRg-4",
"SAP30g7-BCP1-NRg-5",
"SAP30g7-STU2-TRg-3",
"SAP30g7-SEC21-NRg-6",
"SAP30g7-SEC21-NRg-3",
"SAP30g7-RPL1B-TRg-3",
"SAP30g7-SEC20-NRg-2",
"SAP30g7-VMA3-NRg-2",
"SAP30g7-SEC23-NRg-5",
"SAP30g7-CDC28-TRg-4",
"SAP30g7-RPN12-NRg-11",
"SAP30g7-PUP3-TRg-3",
"SAP30g7-SEC31-TRg-2",
"SAP30g7-SED5-TRg-6",
"SAP30g7-SED5-TRg-5",
"SAP30g7-RPL33A-TRg-1",
"SAP30g7-RPL33A-TRg-2",
"SAP30g7-MRPL11-TRg-2",
"SAP30g7-RTP1-NRg-2",
"SAP30g7-NUG1-TRg-2",
"SAP30g7-VPH2-TRg-4",
"SAP30g7-COP1-NRg-3",
"SAP30g7-CRM1-NRg-1",
"SAP30g7-RPL5-NRg-4",
"SAP30g7-SNU13-NRg-4",
"SAP30g7-PFS2-TRg-3",
"SAP30g7-MPP10-TRg-2",
"SAP30g7-TSR4-NRg-2",
"SAP30g7-RSC2-TRg-1",
"SAP30g7-SEC65-TRg-2",
"SAP30g7-SMI1-NRg-1",
"SAP30g7-RTT105-NRg-4",
"SAP30g7-VMA5-TRg-3",
"SAP30g7-VMA5-TRg-5",
"SAP30g7-RRP1-TRg-3",
"SAP30g7-CLC1-TRg-2",
"SAP30g7-GCD6-NRg-1",
"SAP30g7-GCD6-NRg-2",
"SAP30g7-PXR1-TRg-1",
"SAP30g7-CDC14-NRg-1",
"SAP30g7-PCF11-TRg-6",
"SAP30g7-PCF11-TRg-5",
"SAP30g7-PCF11-TRg-4",
"SAP30g7-SEC31-NRg-1",
"SAP30g7-RRP5-NRg-1",
"SAP30g7-PRE10-TRg-5",
"SAP30g7-PRE10-TRg-1",
"SAP30g7-RPS5-TRg-2",
"SAP30g7-NSP1-TRg-4",
"SAP30g7-PRP38-TRg-4",
"SAP30g7-RCF1-NRg-5",
"SAP30g7-RSC3-TRg-4",
"SAP30g7-RSC3-TRg-5",
"SAP30g7-RSC3-TRg-6",
"SAP30g7-HTA1-NRg-12",
"SAP30g7-HTA1-NRg-11",
"SAP30g7-UTP23-TRg-2",
"SAP30g7-GCD7-NRg-1",
"SAP30g7-GCD7-NRg-2",
"SAP30g7-GCD7-NRg-6",
"SAP30g7-GAL11-NRg-2",
"SAP30g7-GAL11-NRg-9",
"SAP30g7-PHO4-TRg-5",
"SAP30g7-SNP1-NRg-3",
"SAP30g7-RPC37-TRg-5",
"SAP30g7-CRM1-TRg-5",
"SAP30g7-CRM1-TRg-2",
"SAP30g7-ASK1-TRg-7",
"SAP30g7-STU2-NRg-4",
"SAP30g7-NEO1-NRg-3",
"SAP30g7-GAL11-TRg-5",
"SAP30g7-GAL11-TRg-7",
"SAP30g7-SAM50-NRg-3",
"SAP30g7-CSL4-TRg-2",
"SAP30g7-CCT5-TRg-2",
"SAP30g7-POL30-NRg-1",
"SAP30g7-MED4-TRg-4",
"SAP30g7-MED4-TRg-3",
"SAP30g7-MED4-TRg-2",
"SAP30g7-GDI1-TRg-4",
"SAP30g7-GDI1-TRg-3",
"SAP30g7-REB1-TRg-6",
"SAP30g7-MRPL37-NRg-2",
"SAP30g7-NOC3-TRg-3",
"SAP30g7-SPC97-TRg-3",
"SAP30g7-IPP1-TRg-3",
"SAP30g7-IPP1-TRg-2",
"SAP30g7-PTI1-TRg-3",
"SAP30g7-PTI1-TRg-5",
"SAP30g7-RFC5-NRg-1",
"SAP30g7-CDC24-TRg-1",
"SAP30g7-CDC24-TRg-3",
"SAP30g7-CDC24-TRg-5",
"SAP30g7-CDC24-TRg-6",
"SAP30g7-UTP23-TRg-6",
"SAP30g7-UTP23-TRg-4",
"SAP30g7-UTP23-TRg-1",
"SAP30g7-RHO3-NRg-4",
"SAP30g7-TRS23-NRg-1",
"SAP30g7-TRS23-NRg-3",
"SAP30g7-RSP5-TRg-2",
"SAP30g7-RSP5-TRg-1",
"SAP30g7-SDA1-NRg-1",
"SAP30g7-KAP95-TRg-8",
"SAP30g7-ACO1-TRg-6",
"SAP30g7-HTA1-NRg-3",
"SAP30g7-HTA1-NRg-2",
"SAP30g7-SPN1-TRg-1",
"SAP30g7-MOT1-NRg-7",
"SAP30g7-RPL17A-NRg-4",
"SAP30g7-ADA2-TRg-4",
"SAP30g7-SFH1-NRg-1",
"SAP30g7-SPC97-NRg-5",
"SAP30g7-PRP22-TRg-3",
"SAP30g7-SEN15-TRg-2",
"SAP30g7-RPL3-NRg-2",
"SAP30g7-ISD11-NRg-2",
"SAP30g7-HEM12-TRg-8",
"SAP30g7-SEC10-TRg-1",
"SAP30g7-HTB1-TRg-7",
"SAP30g7-TTI2-TRg-1",
"SAP30g7-ACP1-TRg-2",
"SAP30g7-ACP1-TRg-4",
"SAP30g7-GAL11-NRg-10",
"SAP30g7-UTP22-TRg-2",
"SAP30g7-MST1-NRg-5",
"SAP30g7-RIB7-NRg-2",
"SAP30g7-MCD1-TRg-6",
"SAP30g7-MCD1-TRg-5",
"SAP30g7-GPI8-NRg-2",
"SAP30g7-THS1-TRg-2",
"SAP30g7-RRP7-TRg-2",
"SAP30g7-RRP7-TRg-5",
"SAP30g7-SMX2-NRg-7",
"SAP30g7-RRP45-TRg-5",
"SAP30g7-RRP45-TRg-4",
"SAP30g7-CNS1-TRg-2",
"SAP30g7-FBP1-NRg-9",
"SAP30g7-GCD11-NRg-1",
"SAP30g7-RPL10-TRg-2",
"SAP30g7-NUP192-TRg-4",
"SAP30g7-NUP145-NRg-4",
"SAP30g7-HEM12-TRg-6",
"SAP30g7-PLC1-TRg-3",
"SAP30g7-RPA43-TRg-1",
"SAP30g7-RPB7-NRg-2",
"SAP30g7-RPB7-NRg-3",
"SAP30g7-NSL1-NRg-1",
"SAP30g7-UTP6-TRg-3",
"SAP30g7-UTP6-TRg-1",
"SAP30g7-YJU2-TRg-5",
"SAP30g7-FRS2-NRg-5",
"SAP30g7-TIF35-NRg-2",
"SAP30g7-GPI15-TRg-1",
"SAP30g7-NOP1-NRg-5",
"SAP30g7-GPI15-TRg-4",
"SAP30g7-COG4-TRg-1",
"SAP30g7-TFA1-TRg-1",
"SAP30g7-RHO1-NRg-2",
"SAP30g7-RHO1-NRg-1",
"SAP30g7-CDC55-NRg-2",
"SAP30g7-IDI1-NRg-7",
"SAP30g7-RPL32-TRg-5",
"SAP30g7-RPB5-TRg-4",
"SAP30g7-DIP2-TRg-5",
"SAP30g7-DIP2-TRg-1",
"SAP30g7-RPC40-TRg-2",
"SAP30g7-CDC6-TRg-5",
"SAP30g7-CDC6-TRg-3",
"SAP30g7-DAD2-TRg-2",
"SAP30g7-RVS161-TRg-2",
"SAP30g7-RVS161-TRg-1",
"SAP30g7-SUP45-NRg-3",
"SAP30g7-SRB6-NRg-5",
"SAP30g7-RPC11-TRg-4",
"SAP30g7-RKI1-TRg-8",
"SAP30g7-NIP7-TRg-3",
"SAP30g7-RPL33A-NRg-12",
"SAP30g7-SAM50-TRg-4",
"SAP30g7-NOP4-NRg-1",
"SAP30g7-NOP4-NRg-3",
"SAP30g7-SMX2-TRg-5",
"SAP30g7-POL12-NRg-2",
"SAP30g7-BMS1-NRg-2",
"SAP30g7-RPA190-TRg-5",
"SAP30g7-ALG14-NRg-4",
"SAP30g7-ALG14-NRg-1",
"SAP30g7-PRE5-NRg-1",
"SAP30g7-BIG1-NRg-2",
"SAP30g7-TFA2-TRg-4",
"SAP30g7-IMP4-TRg-6",
"SAP30g7-PAN1-NRg-1",
"SAP30g7-UTP13-TRg-2",
"SAP30g7-KAE1-NRg-3",
"SAP30g7-ERG20-TRg-1",
"SAP30g7-CDC20-TRg-6",
"SAP30g7-PWP2-NRg-2",
"SAP30g7-COG1-NRg-1",
"SAP30g7-RPL1B-TRg-4",
"SAP30g7-RPL1B-TRg-7",
"SAP30g7-UTP20-TRg-3",
"SAP30g7-UTP20-TRg-4",
"SAP30g7-RPL25-TRg-4",
"SAP30g7-RPL25-TRg-2",
"SAP30g7-MCM7-NRg-1",
"SAP30g7-MRP49-TRg-5",
"SAP30g7-ERO1-NRg-3",
"SAP30g7-UTP5-TRg-7",
"SAP30g7-MCM4-NRg-1",
"SAP30g7-PRE3-NRg-1",
"SAP30g7-FCF1-NRg-1",
"SAP30g7-CUS1-NRg-1",
"SAP30g7-PSF1-TRg-2",
"SAP30g7-BCP1-TRg-2",
"SAP30g7-PAN1-TRg-1",
"SAP30g7-PAN1-TRg-3",
"SAP30g7-PAN1-TRg-4",
"SAP30g7-VPS3-TRg-2",
"SAP30g7-YIL060W-NRg-1",
"SAP30g7-VPS53-NRg-1",
"SAP30g7-CYR1-TRg-4",
"SAP30g7-CYR1-TRg-7",
"SAP30g7-MPS1-NRg-1",
"SAP30g7-SRP1-TRg-5",
"SAP30g7-SRP1-TRg-4",
"SAP30g7-TAF12-TRg-2",
"SAP30g7-TAF12-TRg-3",
"SAP30g7-POP4-TRg-1",
"SAP30g7-SPT16-TRg-1",
"SAP30g7-NUP82-TRg-4",
"SAP30g7-DML1-TRg-3",
"SAP30g7-RPA43-NRg-3",
"SAP30g7-STU2-NRg-3",
"SAP30g7-POP4-NRg-4",
"SAP30g7-MCD1-TRg-2",
"SAP30g7-RPS3-NRg-4",
"SAP30g7-PRP9-TRg-4",
"SAP30g7-RPP1-NRg-2",
"SAP30g7-MTR2-NRg-11",
"SAP30g7-GCD11-TRg-1",
"SAP30g7-RPF1-TRg-3",
"SAP30g7-SUB2-NRg-4",
"SAP30g7-GPI15-TRg-3",
"SAP30g7-ERG9-TRg-6",
"SAP30g7-RPT2-NRg-1",
"SAP30g7-YOS1-NRg-3",
"SAP30g7-SCM3-TRg-4",
"SAP30g7-SCM3-TRg-6",
"SAP30g7-RLP7-NRg-1",
"SAP30g7-TFB2-NRg-4",
"SAP30g7-IMP4-TRg-1",
"SAP30g7-IMP4-TRg-3",
"SAP30g7-PRE4-TRg-3",
"SAP30g7-SUB2-TRg-3",
"SAP30g7-RPP0-NRg-4",
"SAP30g7-RPP0-NRg-3",
"SAP30g7-TOM40-TRg-4",
"SAP30g7-FUR1-NRg-12",
"SAP30g7-TOM40-TRg-2",
"SAP30g7-VMA11-NRg-4",
"SAP30g7-PGS1-NRg-4",
"SAP30g7-URB1-TRg-4",
"SAP30g7-ARP4-TRg-3",
"SAP30g7-RPT3-TRg-3",
"SAP30g7-SUI3-TRg-3",
"SAP30g7-RFC5-NRg-2",
"SAP30g7-RRP14-TRg-2",
"SAP30g7-SCC2-TRg-1",
"SAP30g7-SSC1-TRg-3",
"SAP30g7-RRP9-TRg-3",
"SAP30g7-MOT1-NRg-9",
"SAP30g7-RPL42A-NRg-2",
"SAP30g7-SEC16-TRg-7",
"SAP30g7-IMP4-NRg-2",
"SAP30g7-YEF3-NRg-4",
"SAP30g7-PUP1-TRg-1",
"SAP30g7-UTP22-TRg-6",
"SAP30g7-DBP2-NRg-4",
"SAP30g7-PRE2-TRg-7",
"SAP30g7-ATP16-TRg-6",
"SAP30g7-UTP13-TRg-4",
"SAP30g7-DOP1-NRg-4",
"SAP30g7-TIM44-TRg-3",
"SAP30g7-ATP16-TRg-2",
"SAP30g7-ENP1-NRg-3",
"SAP30g7-NAF1-TRg-3",
"SAP30g7-COG4-TRg-2",
"SAP30g7-SOG2-TRg-7",
"SAP30g7-YDR341C-TRg-3",
"SAP30g7-YMR290W-A-TRg-10",
"SAP30g7-NUP192-NRg-9",
"SAP30g7-RPS31-NRg-8",
"SAP30g7-SPC97-NRg-6",
"SAP30g7-EBP2-NRg-1",
"SAP30g7-CDC48-TRg-5",
"SAP30g7-RPT1-TRg-4",
"SAP30g7-ULP1-NRg-2",
"SAP30g7-RPN3-TRg-6",
"SAP30g7-RPT1-TRg-5",
"SAP30g7-KRE5-TRg-2",
"SAP30g7-TBF1-NRg-8",
"SAP30g7-UTP22-NRg-4",
"SAP30g7-SSC1-NRg-4",
"SAP30g7-REB1-TRg-4",
"SAP30g7-CDC48-NRg-9",
"SAP30g7-FAS2-TRg-8",
"SAP30g7-TAO3-TRg-8",
"SAP30g7-CKS1-TRg-5",
"SAP30g7-YLR379W-TRg-7",
"SAP30g7-TEN1-NRg-2",
"SAP30g7-RPL42A-TRg-2",
"SAP30g7-SEC27-TRg-4",
"SAP30g7-TBF1-NRg-4",
"SAP30g7-RPT1-NRg-6",
"SAP30g7-COG1-TRg-3",
"SAP30g7-SUI1-TRg-6",
"SAP30g7-TIM23-TRg-6",
"SAP30g7-CDC48-NRg-6",
"SAP30g7-EPL1-TRg-5",
"SAP30g7-RPT5-TRg-8",
"SAP30g7-ATP16-NRg-4",
"SAP30g7-RPN6-TRg-3",
"SAP30g7-ERG9-NRg-6",
"SAP30g7-SMX3-TRg-1",
"SAP30g7-NCB2-NRg-3",
"SAP30g7-SEC16-NRg-12",
"SAP30g7-RPN6-TRg-2",
"SAP30g7-REB1-NRg-4",
"SAP30g7-ATP16-TRg-9",
"SAP30g7-ERG9-NRg-7",
"PRE7g7-CC3",
"PRE4g9-CC3",
"PRE4g3-CC3",
"RPN5g1-CC3",
"COG3g1-CC3",
"SED5g5-CC3",
"SEC22g1-CC3",
"SEC22g2-CC3",
"COG8g2-CC3",
"GET2g2-CC3",
"IMP4g6-CC3",
"DIP2g5-CC3",
"PWP2g2_BC1-CC3",
"PWP2g2_BC2-CC3",
"TIF6g8-CC3",
"RPF1g3-CC3",
"MAK16g1-CC3",
"YCR016Wg4-CC3",
"YLR050Cg1-CC3",
"SAP30g7-CC3",
"CC8-CC3",
"CC16-CC3",
"CC17-CC3",
"CC8_BC2-CC3",
"CC16_BC2-CC3",
"PRE7g7-CC33",
"PRE4g9-CC33",
"PRE4g3-CC33",
"RPN5g1-CC33",
"COG3g1-CC33",
"SED5g5-CC33",
"SEC22g1-CC33",
"SEC22g2-CC33",
"COG8g2-CC33",
"GET2g2-CC33",
"IMP4g6-CC33",
"DIP2g5-CC33",
"PWP2g2_BC1-CC33",
"PWP2g2_BC2-CC33",
"TIF6g8-CC33",
"RPF1g3-CC33",
"MAK16g1-CC33",
"YCR016Wg4-CC33",
"YLR050Cg1-CC33",
"SAP30g7-CC33",
"CC8-CC33",
"CC16-CC33",
"CC17-CC33",
"CC8_BC2-CC33",
"CC16_BC2-CC33"] #good for seqlib13


#make empty matrix to store count data that will be extracted from files with discarded reads
mat = [[0]*(len(col_names)+1) for i in range(0,(len(row_names)+1))]
index = 0
for name in col_names:
	index = index + 1
	mat[0][index] = name
	
index = 0
for name in row_names:
	index = index + 1
	mat[index][0] = name


#define primer sequences and regex
#currently allows 1 mismatch anywhere in primer plus an additional mismatch at the first position
primer1 = "GGGAGCTGCGATTGGCAG"
primer2 = "TTAGATCTGATATCGGTACC"
p1_regex = r'(?=(GGGAGCTGCGATTGGCAG|.GGAGCTGCGATTGGCAG|G.GAGCTGCGATTGGCAG|GG.AGCTGCGATTGGCAG|GGG.GCTGCGATTGGCAG|GGGA.CTGCGATTGGCAG|GGGAG.TGCGATTGGCAG|GGGAGC.GCGATTGGCAG|GGGAGCT.CGATTGGCAG|GGGAGCTG.GATTGGCAG|GGGAGCTGC.ATTGGCAG|GGGAGCTGCG.TTGGCAG|GGGAGCTGCGA.TGGCAG|GGGAGCTGCGAT.GGCAG|GGGAGCTGCGATT.GCAG|GGGAGCTGCGATTG.CAG|GGGAGCTGCGATTGG.AG|GGGAGCTGCGATTGGC.G|GGGAGCTGCGATTGGCA.|..GAGCTGCGATTGGCAG|.G.AGCTGCGATTGGCAG|.GG.GCTGCGATTGGCAG|.GGA.CTGCGATTGGCAG|.GGAG.TGCGATTGGCAG|.GGAGC.GCGATTGGCAG|.GGAGCT.CGATTGGCAG|.GGAGCTG.GATTGGCAG|.GGAGCTGC.ATTGGCAG|.GGAGCTGCG.TTGGCAG|.GGAGCTGCGA.TGGCAG|.GGAGCTGCGAT.GGCAG|.GGAGCTGCGATT.GCAG|.GGAGCTGCGATTG.CAG|.GGAGCTGCGATTGG.AG|.GGAGCTGCGATTGGC.G|.GGAGCTGCGATTGGCA.))'
p2_regex = r'(?=(TTAGATCTGATATCGGTACC|.TAGATCTGATATCGGTACC|T.AGATCTGATATCGGTACC|TT.GATCTGATATCGGTACC|TTA.ATCTGATATCGGTACC|TTAG.TCTGATATCGGTACC|TTAGA.CTGATATCGGTACC|TTAGAT.TGATATCGGTACC|TTAGATC.GATATCGGTACC|TTAGATCT.ATATCGGTACC|TTAGATCTG.TATCGGTACC|TTAGATCTGA.ATCGGTACC|TTAGATCTGAT.TCGGTACC|TTAGATCTGATA.CGGTACC|TTAGATCTGATAT.GGTACC|TTAGATCTGATATC.GTACC|TTAGATCTGATATCG.TACC|TTAGATCTGATATCGG.ACC|TTAGATCTGATATCGGT.CC|TTAGATCTGATATCGGTA.C|TTAGATCTGATATCGGTAC.|..AGATCTGATATCGGTACC|.T.GATCTGATATCGGTACC|.TA.ATCTGATATCGGTACC|.TAG.TCTGATATCGGTACC|.TAGA.CTGATATCGGTACC|.TAGAT.TGATATCGGTACC|.TAGATC.GATATCGGTACC|.TAGATCT.ATATCGGTACC|.TAGATCTG.TATCGGTACC|.TAGATCTGA.ATCGGTACC|.TAGATCTGAT.TCGGTACC|.TAGATCTGATA.CGGTACC|.TAGATCTGATAT.GGTACC|.TAGATCTGATATC.GTACC|.TAGATCTGATATCG.TACC|.TAGATCTGATATCGG.ACC|.TAGATCTGATATCGGT.CC|.TAGATCTGATATCGGTA.C|.TAGATCTGATATCGGTAC.))'

#function that takes key and dictionary and returns ID for respective key in given dictionary
#allows 1 mismatch anywhere
#returns -1 if no match
def get_id(key, dict):
	if key in dict:
		return dict[key]
	else:
		for i in range(0,len(key)):
			old_letter = key[i]
			for letter in ['A','C','G','T']:
				query = list(key)
				if old_letter == letter:
					continue
				else:
					query[i] = letter
					query = "".join(query)
					if query in dict:
						return dict[query]
	return -1

#function that takes file, parses and adds counts to matrix
#use on the files with reads thrown out w/out a perfectly matching multiplexing tag, BC or SDS
#input: file name
#output: none (it adds counts to matrix). it prints results to terminal window.
def parse_file(file_name):
	print file_name
	file = open(file_name,"r")
	
	#set up counters to keep track of recovery
	total = 0
	matched_tag = 0
	matched_bc = 0
	matched_sds = 0
	match_row = 0
	
	#loop through each line in file
	for line in file:
		total = total + 1
		line = line.strip().split("\t")
		
		#pass to function that adds to matrix
		#keep track of all counters
		matched_tag, matched_bc, matched_sds, match_row = add_to_matrix("".join(line[5:7]), line[7], line[8], matched_tag, matched_bc, matched_sds, match_row)
	
	#print out results
	print "Total reads parsed: "
	print total
	print "Total multiplexing tags matched: "
	print matched_tag
	print "Total BC sequences matched: "
	print matched_bc
	print "Total SDS matched: "
	print matched_sds
	print "Total counts added to matrix: "
	print match_row
	file.close()


#function that takes a sequence for multiplexing tags, BC and SDS and adds count to 
#matrix if match is found (allowing for mismatches)
#also keeps track of counters to see how many reads were retaines
#output: returns counters
def add_to_matrix(tag, BC, SDS, matched_tag, matched_bc, matched_sds, match_row):	
	#get multiplexing ID
	col_query = get_id(tag,tag_key)
	if col_query == -1:
		return (matched_tag, matched_bc, matched_sds, match_row)
	else:
		col_index = Col_key[col_query]
		matched_tag = matched_tag + 1

	#Get BC ID
	BC_query = get_id(BC,BC_key)
	if BC_query == -1:
		return (matched_tag, matched_bc, matched_sds, match_row)
	else:
		matched_bc = matched_bc+1

	#Get SDS ID
	SDS_query = get_id(SDS,SDS_key)
	if SDS_query == -1:
		return (matched_tag, matched_bc, matched_sds, match_row)
	else:
		matched_sds = matched_sds + 1

	#get row index and add count to matrix
	row_query = "-".join([BC_query,SDS_query])
	if row_query in Row_key:
		match_row = match_row + 1
		row_index = Row_key[row_query]
		mat[row_index][col_index] = mat[row_index][col_index] + 1

	return (matched_tag, matched_bc, matched_sds, match_row)


#loop through files containing reads without perfect match for BC
parse_file("non_matching_reads_tag.txt")
parse_file("non_matching_reads_BC.txt")
parse_file("non_matching_reads_SDS.txt")


#Now loop through files containing reads where one or both reads didn't have a perfect
#primer match
print "non_matching_reads_primer.txt"
phix = 0
new_p1_match = 0
new_p2_match = 0
total = 0

total = 0
matched_tag = 0
matched_bc = 0
matched_sds = 0
match_row = 0

file = open("non_matching_reads_primer.txt","r")
for line in file:
	total = total + 1
	line = line.strip().split("\t")

	#define read sequences
	line1 = line[1]
	line2 = line[2]
	
	#if both reads didn't have primer, continue
	if line[3] == '-1' and line[4] == '-1':
		phix = phix + 1
		continue
	
	#if read 1 didn't have perfect primer match, research allowing 1 or 2 mismatches
	if line[3] == '-1':
		index1 = re.search(p1_regex,line1)
		index2 = int(line[4])
		if not index1:
			continue	
		else:
			index1 = index1.start()
			new_p1_match = new_p1_match + 1
	
	#if read 2 didn't have perfect primer match, research allowing 1 or 2 mismatches
	if line[4] == '-1':
		index2 = re.search(p2_regex, line2)
		index1 = int(line[3])
		if not index2:
			continue
		else:
			new_p2_match = new_p2_match + 1
			index2 = index2.start()
	
	#assign tag, BC and SDS based on index of primers				
	tag = "".join([line1[0:index1],line2[0:index2]])
	BC = line2[(index2+20):(index2+20+26)]
	SDS = line1[(index1+18):(index1+18+20)]		
	
	#call function to add read to correct position in count matrix and keep track of 
	#counts of successful additions
	matched_tag, matched_bc, matched_sds, match_row = add_to_matrix(tag, BC, SDS, matched_tag, matched_bc, matched_sds, match_row)

	
#print total
print "Total reads parsed: "
print total
print "PhiX"
print phix
print "New reads with p1 match: "
print new_p1_match
print "New reads with p2 match: "
print new_p2_match
print "Total multiplexing tags matched: "
print matched_tag
print "Total BC sequences matched: "
print matched_bc
print "Total SDS matched: "
print matched_sds
print "Total counts added to matrix: "
print match_row
file.close()


matrix_out = open("recovered_counts.txt","w")

for row in mat:
	count = 0
	for item in row:
		count = count + 1
		if count == 1:
			matrix_out.write(str(item))
		else:
			matrix_out.write("\t"+str(item))
	matrix_out.write("\n")
		
	

