
library(dplyr)

# B1_S1 <- tbl_df(read.table('D:/Box Sync/Rhesus_Embryos/update_2017/Geoff_counts/rh150409-1-b1-B1_S1.q30.sort.bam.bin_4000_counts.txt',
#                            header=T))

samp <- tbl_df(read.table('D:/Box Sync/Rhesus_Embryos/Oocyte_CN/160405_Chavez_reSplit.Rh150116_2_D3_B1.counts',
                           header=T))
samp <- tbl_df(read.table('D:/Box Sync/Rhesus_Embryos/Oocyte_CN/rh150409-1-b1-B1_S1.counts', header=T))

samp

samp.chr3 <- samp %>% filter(chr=='chr3')
plot(samp.chr3$ratio)
plot(samp$ratio, ylim=c(0,2))
# plot(samp.chr3$ratio[40:80])
# which(samp.chr3$ratio < 0.8)
# Looks like bins 59-64

# Check other samples
counts <- list()
i <- 0
# Read in counts
for(f in list.files('D:/Box Sync/Rhesus_Embryos/Geoff_counts/')) {
  i <- i + 1
  counts[[i]] <- tbl_df(read.table(paste0('D:/Box Sync/Rhesus_Embryos/update_2017/Geoff_counts/', f),
                                   header=T))
}

# Plot chr3 ratios
for(i in 1:length(counts)) {
  chr3 <- counts[[i]] %>% filter(chr=='chr3') %>% select(ratio) %>% as.matrix
  plot(chr3)
  low[[i]] <- which(chr3 < 0.8)
  # print(low[[i]])
}
tab.low <- table(unlist(low))
barplot(tab.low)
bad.bins <- names(tab.low[tab.low > 20])

# Plot chr3 counts
for(i in 1:length(counts)) {
  chr3 <- counts[[i]] %>% filter(chr=='chr3') %>% select(count) %>% as.matrix
  plot(chr3)
  # low[[i]] <- which(chr3 < 0.8)
  # print(low[[i]])
}
tab.low <- table(unlist(low))
barplot(tab.low)
bad.bins <- names(tab.low[tab.low > 20])


filter(counts[[1]], chr=='chr3')[as.numeric(bad.bins),]

# Do the same for chrom 17:
low <- list()
for(i in 1:length(counts)) {
  chr17 <- counts[[i]] %>% filter(chr=='chr17') %>% select(ratio) %>% as.matrix
  plot(chr17)
  low[[i]] <- which(chr17 < 0.7)
  # print(low[[i]])
}
tab.low <- table(unlist(low))
barplot(tab.low)
bad.bins <- names(tab.low[tab.low > 20])

filter(counts[[1]], chr=='chr17')[as.numeric(bad.bins),]

# Look at the windows generated by Geoff
########################################
win2k <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/xx-bins_rheMac8_2000.txt', 
                    header=T)
win4k <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/xx-bins_8_4000.txt', 
                    header=T)

plot(win2k$count[win2k$chr=='chr3'])
plot(win2k$count[win2k$chr=='chr17'])

hist(win2k$count[win2k$chr=='chr3'])
hist(win2k$count[win2k$chr=='chr17'])


# Look at the new fixed windows generated 
########################################
win500.new <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/rheMac8/xx-euploid-1_all_merge_500.bins', 
                        header=T)
win1k.new <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/rheMac8/xx-euploid-1_all_merge_1000.bins', 
                        header=T)
win2k.new <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/rheMac8/xx-euploid-1_all_merge_2000.bins', 
                    header=T)
win4k.new <- read.table('D:/Box Sync/Rhesus_Embryos/update_2017/WINDOWS/rheMac8/xx-euploid-1_all_merge_4000.bins', 
                    header=T)

for(chr in as.vector(unique(win500.new$chr)))
  plot(win500.new$count[win500.new$chr==chr], main=chr)

for(chr in as.vector(unique(win2k.new$chr)))
  plot(win2k.new$count[win2k.new$chr==chr], main=chr)

plot(win2k.new$count[win2k.new$chr=='chr17'])

hist(win2k.new$count[win2k$chr=='chr3'])
hist(win2k.new$count[win2k$chr=='chr17'])

# Look counts for one single-ended sample
########################################

