#!/usr/bin/perl

###############################
#
# Copyright Stanford University 2015
# Author: John Bell
#
# this script extracts SNVs only from a vcf.  A single base 
# in REF and ALT fields is defined as an SNV.   Multiple alt 
# allele positions are ignored as they are such a small proportion 
# of the total.
#
# We do not bother validating whether the input file truly is 
# vcf format or not.
#
# Input:  a vcf file
# Output: a vcf file with no header containing only SNVs
#
################################

use strict;

my $usage = "usage: $0 <vcf file>";

die $usage unless -f $ARGV[0];
die $usage unless $ARGV[0] =~ /vcf\Z/;

while (<>) {

   my @b = split ' ', $_;
   if ($b[3] =~ /\A[A|C|G|T]\Z/ && $b[4] =~ /\A[A|C|G|T]\Z/) {
      print;
   }

}
