#!/usr/bin/perl

###############################
#
# Copyright Stanford University 2016
# Author: John Bell
#
# this script extracts chromosome-arm-wise t-test information 
# from a 2-sample output of the R scripts generated by 
# make_rscr_script.double.pl; it is entirely dependent on text of R 
# script 
# 
# INPUT:  text file of output of R script 
# OUTPUT: text file listing t-test p-values by chromosome arm & non-normal sample
#
################################

use strict;

die "need input file to get pvals" unless -f $ARGV[0];

open(F,$ARGV[0]) or die "need r file\n";

my @LN = <F>;

print "chr\tarm\tp-value\n";

my $ct = 0;
my $chrom = 0;
my $ppval = 0;
my $qpval = 0;

while($LN[$ct]) {

  if ($LN[$ct] =~ /_hap_raw <- subset\(r_table/) {
    ($chrom) = $LN[$ct] =~ /_hap_raw <- subset\(r_table,r_table\$chr == (\d+)/;
  }

  # for p-arm calls
  if ($LN[$ct] =~ /data:  tump_rat and normp_rat/) {
      ($ppval) = $LN[$ct+1] =~ /p-value [=|<] (\S+)/; 
      print "$chrom\tp\t$ppval\n";
  }

  # for q-arm calls
  if ($LN[$ct] =~ /data:  tumq_rat and normq_rat/) {
      ($qpval) = $LN[$ct+1] =~ /p-value [=|<] (\S+)/; 
      print "$chrom\tq\t$qpval\n";
  }

# quit implies at end of one chrom's (arm's) script's output
    if ($LN[$ct] =~ /quit\(\)/) {
    # reset to reduce possibility of error (b/c of reordering, chroms unprocessed
    #  because of no hap. blocks (LOH), etc.
	$chrom = $ppval = $qpval = 0;
    }
    $ct++;
}
