#!/usr/bin/perl

###############################
#
# Copyright Stanford University 2018
# Author: John Bell
#
# This script filters t-test output values from the output of 
# get_t_test_values.pl or get_t_test_values.pair.pl.  Its default 
# filter is .001, which is very close to .05/41 (or .05/39 for 
# that matter), where 41 (and 39) are the number of chromosome 
# arms found in pairs in a normal human female (and male) genome,
# respectively
# 
# INPUT:  text file of output of get_t_test_values.pl or get_t_test_values.pair.pl 
# OUTPUT: text file listing t-test p-values and chroms passing filter 
#
################################

use strict;
use Getopt::Long;

my $filt = 0;
&GetOptions("filter=f" => \$filt);

my $usage = "usage: $0 [--filt .001] file\n";
die $usage unless -f $ARGV[0];

$filt = .001 unless $filt > 0;

while(<>) {

   my @b = split ' ', $_;
   my $pval = $b[2];
   if ($pval <= $filt) { print; } 
   
}
