#!/usr/bin/env python3

###############################
#
# Copyright Stanford University 2016
# Author: John Bell
#
# This script reads a threshold file (chrom - beg pos - end pos - indicator) and
#   combines the contiguous regions with a positive indicator together
#
# INPUT: a threshold text file produced by an R script produced by make_rscr_script.*.py
# OUTPUT:  a 4-column text file listing contiguous regions passing the threshold test
# 
###############################

#--------------------------- I/O --------------------------------#

import sys

usage = 'usage: script <input file (threshold info output of aneuploid R script)>'

try:
   fobj1 = open(sys.argv[1])
   lines = fobj1.readlines() 
   fobj1.close()
   file_len = len(lines)
   file_len -= 1
except:   
   print(usage)
   sys.exit()

#--------------------------- end of I/O -------------------------#

#--------------------------- initializations --------------------#

# initialize variables
linect = 1
reg_beg = 0
reg_end = 0
live_case = 0

#-------------------------- end of initializations --------------#

#-------------------------- loop --------------------------------# 

while linect <= file_len:
   bits = lines[linect].split()
   chrom = int(bits[1])
   thisbeg  = int(bits[2])
   thisend  = int(bits[3])
   indic = int(bits[4])

   if live_case:
      if indic:
         reg_end = thisend
      else:
         print(chrom, reg_beg, reg_end, sep='\t')  
         live_case = 0
         reg_beg = 0
         reg_end = 0
   else:
      if indic:
         reg_beg = thisbeg
         reg_end = thisend
         live_case = 1
      else:
      # do nothing 
         dummy = 1
   linect = linect + 1

#-------------------------- end of loop -------------------------#

if live_case:
   print(chrom, reg_beg, reg_end, sep='\t')  
