#!/usr/bin/perl -w
use strict;
use File::Basename;

my @mgf = glob("data/colon/mgf/*.mgf");
my $wdir = "data/colon/";

foreach my $m (@mgf){
	print $m,"\n";
	my $name = basename($m);
	my $outdir = "paper/m2/";
	my $newmgf = $name;
	$name =~ s/.mgf$//;
	$newmgf =~ s/.mgf$/_format.mgf/;
	unless(-d $outdir){
		mkdir $outdir;
	}
	$outdir = $outdir . "$name/";
	unless(-d $outdir){
                mkdir $outdir;
        }
	$newmgf = $outdir . "/" . $newmgf;

	my $pbs = $outdir . "$name" . ".pbs";
	open O,">$pbs" or die "$pbs:$!\n";
	print O "#!/bin/bash\n";
	print O "#PBS -M bo.wen\@bcm.edu\n";
	print O "#PBS -m a\n";
	print O "#PBS -l nodes=1:ppn=8\n";
	print O "#PBS -l walltime=20:00:00\n";
	print O "#PBS -l vmem=30g\n";
	print O "#PBS -k oe\n";
	print O "#PBS -o $wdir/$outdir/$name.log\n";
	print O "#PBS -e $wdir/$outdir/$name.err_log\n\n";
	print O "module load java/1.8.0u121\n";
	my $sh = "java -Xmx20G -jar pepquery.jar -db $wdir/refseq_pro_nature2014.fasta -fixMod 6 -varMod 107 -tol 20 -itol 0.5 -ms $m -pep $wdir/saav_pep.txt -m 1 -o $wdir/$outdir -n 10000 -cpu 8 -minScore 12 -um ";
	print O "$sh\n";
	
	close O;
	system("qsub $pbs");
}
