# iPRG2015 FP simulation

#library(readr)
#library(ggplot2)
set.seed(2017)

runModel=function(x){
    t1 <- proc.time()
    system("Rscript generate_random_mutation_peptide.R")
    system("sh run_scoring_m2.sh")
    
    suppressPackageStartupMessages(library(dplyr))
    
    read.delim("out/scoring2/psm_rank.txt") -> a1
    
    if("n_ptm" %in% names(a1)){
       a1 %>% filter(rank==1,pvalue<=0.01,n_db==0,n_ptm==0) %>% select(peptide) %>% distinct() -> m1
    }else{
       a1 %>% filter(rank==1,pvalue<=0.01,n_db==0) %>% select(peptide) %>% distinct() -> m1
    }

    ## don't consider ptm
    m_noptm <- a1 %>% filter(rank==1,pvalue<=0.01,n_db==0) %>% select(peptide) %>% distinct()
    
    t2 <- proc.time()
    fp <- nrow(m1)/93
    fp_noptm <- nrow(m_noptm)/93
    tt <- t2-t1
    tt <- tt[3]
    cat("Finished:",x,"\t","Time needed:",tt*(93-x)/60.0,"\tFP=",fp,"\t",fp_noptm,"\n")
    return(c(fp,fp_noptm))
}

res <- lapply(1:100,runModel)
save(res,file="simulation_res_m2.rda")
write(res,file="simulation_res_m2.txt")

#write_tsv(m,path = "overlap.txt")
