

library(readr)
library(dplyr)
library(stringr)

dbs <- list.files(path = "project/pepquery/paper/data/iprg/random_point_mutation/db",pattern = ".fasta",include.dirs = TRUE,full.names = TRUE) 

for(db in dbs){
    f_name <- basename(db)
    f_name <- str_replace(f_name,pattern = ".fasta",replacement = "")
    outdir <- paste(dirname(dirname(db)),"/res/",f_name,sep = "",collapse = "")
    dir.create(outdir,showWarnings = FALSE,recursive = TRUE)
    out_tandem <- paste(outdir,"/tandem/",sep = "",collapse = "")
    out_myrimatch <- paste(outdir,"/myrimatch/",sep = "",collapse = "")
    out_both <- paste(outdir,"/both/",sep = "",collapse = "")	
    run_tandem <- paste("java -Xmx29G -jar pepquery.jar -db ",db," -fixMod 6 -varMod 107,142,143,15 -maxVar 3 -cpu 8 -fragmentMethod 1 -itol 0.02 -tol 10 -ms /home/bw10/project/pepquery/paper/data/iprg/random_point_mutation/JD_06232014_sample1-A_msms_sql.db -pep /home/bw10/project/pepquery/paper/data/iprg/random_point_mutation/peptide2sixprotein_onlypep.txt -m 1 -minScore 10 -n 10000 -um -o ",out_tandem,sep = "",collapse = "")
    run_myrimatch <- paste("java -Xmx29G -jar pepquery.jar -db ",db," -fixMod 6 -varMod 107,142,143,15 -maxVar 3 -cpu 8 -fragmentMethod 1 -itol 0.02 -tol 10 -ms /home/bw10/project/pepquery/paper/data/iprg/random_point_mutation/JD_06232014_sample1-A_msms_sql.db -pep /home/bw10/project/pepquery/paper/data/iprg/random_point_mutation/peptide2sixprotein_onlypep.txt -m 2 -minScore 10 -n 10000 -um -o ",out_myrimatch,sep = "",collapse = "")

    sh <- paste(outdir,"/",f_name,".sh",sep = "",collapse = "")
    cat("#!/bin/bash\n",file = sh)
    cat("#SBATCH --output=%A_%a.out\n",file = sh,append = TRUE)
    cat("#SBATCH --error=%A_%a.err\n",file = sh,append = TRUE)
    cat("#SBATCH --time=60:00:00\n",file = sh,append = TRUE)
    cat("#SBATCH --cpus-per-task=8\n",file = sh,append = TRUE)
    cat("#SBATCH --mem=29000\n",file = sh,append = TRUE)
    cat("#SBATCH --nodes=1\n",file = sh,append = TRUE)
    cat("#SBATCH --ntasks=1\n",file = sh,append = TRUE,sep = "")
    cat("set -e -x\n",file = sh,append = TRUE,sep = "")
    cat(run_tandem,"\n",file = sh,append = TRUE)
    cat(run_myrimatch,"\n",file = sh,append = TRUE)
    system(paste("sbatch ",sh,sep = "",collapse = ""))
    
}
