
library(dplyr)
library(stringr)
randomPointMutationPeptide=function(pep){
    aa20 = c("R","K","D","E","Q","N","H","S","T","Y","C","M","W","A","I","L","F","V","P","G")
    pos = sample(1:(nchar(pep)-1),size = 1,replace = FALSE)
    aa_v = str_split(pep,pattern = "")[[1]]
    aa_wild = aa_v[pos]
    aa_m = sample(aa20,size = 1,replace = FALSE)
    aa_v[pos] = aa_m
    pep_new = str_c(aa_v,sep = "",collapse = "")
    if(aa_m == aa_wild){
        randomPointMutationPeptide(pep)    
    }else if(aa_m == "I" && aa_wild == "L"){
        randomPointMutationPeptide(pep)   
    }else if(aa_m == "L" && aa_wild == "I"){
        randomPointMutationPeptide(pep)
    }else{
        return(pep_new)
    }
}

scan("peptide2sixprotein_onlypep.txt",what = "") -> pep
sapply(pep,randomPointMutationPeptide) %>% write(file = "point_mutate_peptide2sixprotein_onlypep.txt")
