package main.java.util;

import com.compomics.util.experiment.io.massspectrometry.MgfFileIterator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;

import com.google.common.primitives.Doubles;
import org.sqlite.SQLiteConfig;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.*;
import java.util.ArrayList;


public class createMGFdb {


    public static void main(String[] args) throws InterruptedException, SQLException, IOException {
        String msfile = args[0];
        String sqldbfile = args[1];


        run(msfile,sqldbfile,true);



    }

    public static void run(String msfile, String sqldbfile) throws IOException, InterruptedException, SQLException {

        File mgfFile = new File(msfile);
        ArrayList<File> msFiles = new ArrayList<>();
        if(mgfFile.isDirectory()) {
            for(File f: mgfFile.listFiles()){
                if(f.getName().toLowerCase().endsWith(".mgf") && f.isFile()){
                    msFiles.add(f);
                }
            }
        }else{
            msFiles.add(mgfFile);
        }

        SQLiteConfig config = new SQLiteConfig();
        config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);

        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + sqldbfile, config.toProperties());
        connection.setAutoCommit(false);
        Statement stmt = connection.createStatement();
        StringBuilder sqlBuilder = null;

        stmt.executeUpdate("drop table if exists msmsdb");

        // create table
        sqlBuilder = new StringBuilder();
        sqlBuilder.append("create table msmsdb ");
        sqlBuilder.append("(");
        sqlBuilder.append("id text").append(",");
        sqlBuilder.append("mz double").append(",");
        sqlBuilder.append("mass double").append(",");
        sqlBuilder.append("charge integer").append(",");
        sqlBuilder.append("fragment_ion_mz text").append(",");
        sqlBuilder.append("fragment_ion_int text").append(",");
        sqlBuilder.append("sample text").append(")");

        //System.out.println(sqlBuilder.toString());
        stmt.executeUpdate(sqlBuilder.toString());


        for(File F : msFiles){
            System.out.println("Read "+ F.getAbsolutePath());
            String sample = F.getName().replaceAll(".mgf$", "");
            MgfFileIterator mgfFileIterator = null;
            try {
                mgfFileIterator = new MgfFileIterator(F);
            } catch (IOException e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                System.exit(0);
            }


            int i = 0;
            MSnSpectrum spectrum;
            double mz;
            double mass;
            int charge;
            String fragment_ion_mz;
            String fragment_ion_int;
            while (mgfFileIterator.hasNext()) {

                i++;
                spectrum = mgfFileIterator.next();

                spectrum.setSpectrumTitle(String.valueOf(i));


                if (spectrum.getPrecursor().getPossibleCharges().isEmpty()) {


                } else {
                    mz = spectrum.getPrecursor().getMz();
                    charge = spectrum.getPrecursor().getPossibleCharges().get(0).value;
                    mass = spectrum.getPrecursor().getMass(charge);
                    fragment_ion_mz = Doubles.join(":", spectrum.getMzValuesAsArray());
                    fragment_ion_int = Doubles.join(":", spectrum.getIntensityValuesAsArray());

                    sqlBuilder = new StringBuilder();

                    sqlBuilder.append(" INSERT INTO msmsdb (id,mz,mass,charge,fragment_ion_mz,fragment_ion_int,sample) ");
                    sqlBuilder.append("VALUES (");
                    sqlBuilder.append(i).append(",");
                    sqlBuilder.append(mz).append(",");
                    sqlBuilder.append(mass).append(",");
                    sqlBuilder.append(charge).append(",");
                    sqlBuilder.append("'").append(fragment_ion_mz).append("'").append(",");
                    sqlBuilder.append("'").append(fragment_ion_int).append("'").append(",");
                    sqlBuilder.append("'").append(sample).append("'").append(" )");
                    stmt.executeUpdate(sqlBuilder.toString());

                }

            }
            connection.commit();

        }

        stmt.executeUpdate("create index mass_index on msmsdb (mass)");
        connection.commit();

        stmt.close();
        //pstmt.close();
        connection.close();

    }


    public static void run(String msfile, String sqldbfile, boolean writeOBJ) throws IOException, InterruptedException, SQLException {

        File mgfFile = new File(msfile);
        ArrayList<File> msFiles = new ArrayList<>();
        if(mgfFile.isDirectory()) {
            for(File f: mgfFile.listFiles()){
                if(f.getName().toLowerCase().endsWith(".mgf") && f.isFile()){
                    msFiles.add(f);
                }
            }
        }else{
            msFiles.add(mgfFile);
        }

        SQLiteConfig config = new SQLiteConfig();
        config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);

        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + sqldbfile, config.toProperties());
        connection.setAutoCommit(false);
        Statement stmt = connection.createStatement();
        StringBuilder sqlBuilder = null;

        stmt.executeUpdate("drop table if exists msmsdb");

        // create table
        sqlBuilder = new StringBuilder();
        sqlBuilder.append("create table msmsdb ");
        sqlBuilder.append("(");
        sqlBuilder.append("id text").append(",");
        sqlBuilder.append("mz double").append(",");
        sqlBuilder.append("mass double").append(",");
        sqlBuilder.append("charge integer").append(",");
        sqlBuilder.append("spectrum blob").append(",");
        sqlBuilder.append("sample text").append(")");

        //System.out.println(sqlBuilder.toString());
        stmt.executeUpdate(sqlBuilder.toString());

        String psql = "INSERT INTO msmsdb (id,mz,mass,charge,spectrum,sample) VALUES(?,?,?,?,?,?)";

        PreparedStatement pstmt = connection.prepareStatement(psql);


        for(File F : msFiles){
            System.out.println("Read "+ F.getAbsolutePath());
            String sample = F.getName().replaceAll(".mgf$", "");
            MgfFileIterator mgfFileIterator = null;
            try {
                mgfFileIterator = new MgfFileIterator(F);
            } catch (IOException e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                System.exit(0);
            }

            //stmt.close();

            int i = 0;
            MSnSpectrum spectrum;
            double mz;
            double mass;
            int charge;
            while (mgfFileIterator.hasNext()) {

                i++;
                spectrum = mgfFileIterator.next();

                spectrum.setSpectrumTitle(String.valueOf(i));

                if (spectrum.getPrecursor().getPossibleCharges().isEmpty()) {


                } else {
                    mz = spectrum.getPrecursor().getMz();
                    charge = spectrum.getPrecursor().getPossibleCharges().get(0).value;
                    mass = spectrum.getPrecursor().getMass(charge);

                    ByteArrayOutputStream bos = new ByteArrayOutputStream();

                    ObjectOutputStream oos = new ObjectOutputStream(bos);

                    oos.writeObject(spectrum);

                    pstmt.setString(1, String.valueOf(i)+":"+sample);
                    pstmt.setDouble(2,mz);
                    pstmt.setDouble(3,mass);
                    pstmt.setInt(4,charge);
                    pstmt.setBytes(5,bos.toByteArray());
                    pstmt.setString(6,sample);
                    pstmt.executeUpdate();

                }

                if( (i%10000)==0){
                    System.out.println("Finished:"+i);

                }

            }
            connection.commit();


        }

        pstmt.close();

        stmt.executeUpdate("create index mass_index on msmsdb (mass)");
        connection.commit();

        stmt.close();
        connection.close();

    }


}
