package main.java.util;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import java.io.*;

public class Cloger {
	public static Logger logger = Logger.getLogger(Cloger.class.getName());
	private static String logdir = "./logs";
	private static long start_time;
	
	public Cloger(){
		
	}
	
	public static void init() throws IOException{
		start_time = System.currentTimeMillis();
		
		File currentDir = new File(System.getProperty("user.dir")+"/logs");
		if(!currentDir.isDirectory()){
			currentDir.mkdirs();
		}
		logdir = currentDir.getAbsolutePath();
		
		config();
		
		
	}
	
	public static void config() throws IOException{

		String log4Properties = logdir + "/log4j.properties";
		BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(log4Properties)));
		
		InputStream is = Cloger.class.getResourceAsStream("/main/java/util/log4j.properties");
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		
		String line = "";
		while ((line = br.readLine()) != null) {
			bWriter.write(line+"\n");
		}
		br.close();

		bWriter.close();
		System.setProperty("LOGS_DIR", logdir);
		PropertyConfigurator.configure(log4Properties);
		
	}

	public static String getRunTime(){
		long ctime = System.currentTimeMillis();
		double t = 1.0*(ctime  - start_time)/1000.0/60.0;
		String out = String.format("%.2f",t);
		out = out + " min";
		return(out);
	}
}
