package main.java.pg;


import net.sf.jfasta.FASTAElement;
import net.sf.jfasta.FASTAFileReader;
import net.sf.jfasta.impl.FASTAElementIterator;
import net.sf.jfasta.impl.FASTAFileReaderImpl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * This class is used to handle target protein identification
 */
public class TargetProteinID {


    private String targetProteinSequence;
    private String targetProteinAcc;
    private String refdb;

    /**
     * In target protein identification mode, only identity the decoy version of selected protein.
     * This is used to evaluate the FDR for large scale target protein identification.
     */
    public boolean only_identity_decoy_version = false;



    public void prepareDB(String db, String accession, String outdir) throws IOException {
        //

        this.refdb = outdir + "/refdb.fasta";
        BufferedWriter dbWriter = new BufferedWriter(new FileWriter(new File(this.refdb)));
        this.targetProteinAcc = accession;


        File dbFile = new File(db);
        FASTAFileReader reader = new FASTAFileReaderImpl(dbFile);
        FASTAElementIterator it = reader.getIterator();
        int num = 0;
        while (it.hasNext()) {
            FASTAElement el = it.next();
            el.setLineLength(1);
            String headLine[] = el.getHeader().split("\\s+");
            String proID = headLine[0];
            String proSeq = el.getSequence().toUpperCase();
            if(proID.equals(accession)){
                if(this.only_identity_decoy_version){
                    // identity decoy protein
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(proSeq);
                    this.targetProteinSequence = stringBuilder.reverse().toString();

                    System.out.println("Try to identity decoy protein: ("+accession+") "+this.targetProteinSequence);
                    dbWriter.write(">"+el.getHeader()+"\n");
                    dbWriter.write(proSeq+"\n");

                }else {
                    // identity target protein
                    this.targetProteinSequence = proSeq;
                    System.out.println("Try to identity protein: ("+accession+") "+this.targetProteinSequence);
                }
            }else{
                dbWriter.write(">"+el.getHeader()+"\n");
                dbWriter.write(proSeq+"\n");
            }
            num++;
            // System.out.println(proID);
        }
        reader.close();
        dbWriter.close();

        System.out.println("Proteins: "+num);
    }

    public String getRefdb() {
        return refdb;
    }

    public String getTargetProteinSequence() {
        return targetProteinSequence;
    }

}
