package main.java.pg;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import main.java.OpenModificationSearch.ModificationDB;
import main.java.PSMMatch.JPeptide;
import main.java.PSMMatch.ScoreResult;
import org.apache.commons.lang3.StringUtils;


import java.util.ArrayList;

import static main.java.pg.PeptideSearchMT.scorePeptide2Spectrum;

/**
 * After scoring PSMs for target peptides, scoring PSMs from reference db and random peptides. (multiple treads)
 */
public final class SearchWorker implements Runnable {


    private PeptideInput peptideInput = null;
    private DatabaseInput databaseInput = null;

    private int index;

    public SearchWorker(PeptideInput pepInput, DatabaseInput dbInput, int ind){
        this.peptideInput = pepInput;
        this.databaseInput = dbInput;
        this.index = ind;
    }

    @Override
    public void run() {

        // peptide form without variable modification
        System.out.println(Thread.currentThread().getName()+" -> Start "+this.index+": "+peptideInput.jPeptide.peptide.getSequence()+" ...");
        for (int i=0;i < peptideInput.jPeptide.spectraIndexs.size();i++) {
            // MSnSpectrum spectrum = peptideInput.jPeptide.mSnSpectrums.get(i);
            MSnSpectrum spectrum = SpectraInput.spectraMap.get(peptideInput.jPeptide.spectraIndexs.get(i));
            ScoreResult scoreResult = peptideInput.jPeptide.scores.get(i);
            if(!peptideInput.jPeptide.valid.get(i)){
                continue;
            }

            String spectrumTitle = spectrum.getSpectrumTitle();


            int k = 0;
            ScoreResult tmpScoreResult;
            if(databaseInput.ms2peptide.containsKey(spectrumTitle)) {
                for (Peptide ePeptide : databaseInput.ms2peptide.get(spectrumTitle)) {
                    tmpScoreResult = scorePeptide2Spectrum(ePeptide, spectrum);
                    double tmpScore = tmpScoreResult.score;
                    //scoreList.add(tmpScore);
                    if (scoreResult.score <= tmpScore) {
                        scoreResult.nBetter++;

                        if (tmpScore >= 20) {
                            String dout = spectrum.getSpectrumTitle() + "\t" +
                                    ePeptide.getSequence() + "\t" +
                                    //ePeptide.getSequenceWithLowerCasePtms() + "\t" +
                                    ModificationDB.getModificationString(ePeptide) + "\t" +
                                    ePeptide.getMass() + "\t" +
                                    tmpScore;
                            this.peptideInput.addOutAdditionalLines(dout);

                        }
                    }


                    if(CParameter.scoreMethod == 0){
                        double tmpScore2 = tmpScoreResult.score2;
                        if (scoreResult.score2 <= tmpScore2) {
                            scoreResult.nBetter2++;
                        }
                    }

                    k++;
                    //System.out.println(tmpScore);
                }
            }
            //scoreList.add(scoreResult.score);

            double pvalue = 100;
            double pvalue2 = 100;
            int nRand = -1;
            int nRand2 = -1;

            ArrayList<Double> randomScoreList1 = new ArrayList<>(10000);
            ArrayList<Double> randomScoreList2 = new ArrayList<>(10000);

            if(scoreResult.nBetter==0 && scoreResult.nBetter2==0){
                peptideInput.setRandomPeptides(PeptideInput.generateRandomPeptidesFast(peptideInput.jPeptide.peptide,CParameter.nRandomPeptides,true));

                nRand = 0;
                nRand2 = 0;
                for (String randomPeptideSeq : peptideInput.randomPeptides) {
                    Peptide randomPeptide = PeptideInput.getModificationPeptide(peptideInput.jPeptide.peptide, randomPeptideSeq, CParameter.fixMods);
                    tmpScoreResult = scorePeptide2Spectrum(randomPeptide, spectrum);
                    double randomScore = tmpScoreResult.score;

                    randomScoreList1.add(randomScore);

                    if (randomScore >= scoreResult.score) {
                        nRand++;
                    }

                    if(CParameter.scoreMethod == 0){
                        double randomScore2 = tmpScoreResult.score2;
                        randomScoreList2.add(randomScore2);
                        if (randomScore2 >= scoreResult.score2) {
                            nRand2++;
                        }

                    }
                }
                pvalue = 1.0 * (nRand + 1) / (peptideInput.randomPeptides.size() + 1);

                if(CParameter.scoreMethod ==0){
                    pvalue2 = 1.0 * (nRand2 + 1) / (peptideInput.randomPeptides.size() + 1);
                }

            }

            int sumRand = -1;
            if(nRand != -1){
                sumRand = peptideInput.randomPeptides.size();
            }


            StringBuilder outBuilder = new StringBuilder();
            double tolPpm = (1.0e6) * (peptideInput.jPeptide.peptide.getMass() - spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value)) / peptideInput.jPeptide.peptide.getMass();

            if(CParameter.scoreMethod==0){
                pvalue = Math.max(pvalue,pvalue2);
            }

            int nBetter = Math.max(scoreResult.nBetter,scoreResult.nBetter2);

            outBuilder.append(peptideInput.jPeptide.peptide.getSequence())
                    .append("\t")
                    //.append(peptideInput.jPeptide.peptide.getSequenceWithLowerCasePtms())
                    .append(ModificationDB.getModificationString(peptideInput.jPeptide.peptide))
                    .append("\t")
                    .append(peptideInput.jPeptide.spectraIndexs.size())
                    .append("\t")
                    .append(spectrum.getSpectrumTitle())
                    .append("\t")
                    .append(spectrum.getPrecursor().getPossibleCharges().get(0).value)
                    .append("\t")
                    .append(spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value))
                    .append("\t")
                    .append(tolPpm)
                    .append("\t")
                    .append(peptideInput.jPeptide.peptide.getMass())
                    .append("\t")
                    .append(spectrum.getPrecursor().getMz())
                    .append("\t")
                    .append(scoreResult.score)
                    .append("\t")
                    .append(nBetter)
                    .append("\t")
                    .append(k)
                    .append("\t")
                    .append(nRand)
                    .append("\t")
                    .append(sumRand)
                    .append("\t")
                    .append(pvalue);

            if(PeptideSearchMT.useGPD){
                String randomScoreString1 = "-";
                if(randomScoreList1.size()>=1) {
                    randomScoreString1 = StringUtils.join(randomScoreList1,';');
                }

                String randomScoreString2 = "-";
                if(randomScoreList2.size()>=1){
                    randomScoreString2 = StringUtils.join(randomScoreList2,';');
                }

                outBuilder.append("\t").append(randomScoreString1).append("\t").append(randomScoreString2).append("\t").append(scoreResult.score).append("\t").append(scoreResult.score2);

            }

            this.peptideInput.addOutputLine(outBuilder.toString());

        }

        this.peptideInput.jPeptide.scores = null;


        // peptide form with variable modification
        for (JPeptide jPeptide : peptideInput.getPtmIsoforms()) {
            for (int i=0;i < jPeptide.spectraIndexs.size();i++) {
                MSnSpectrum spectrum = SpectraInput.spectraMap.get(jPeptide.spectraIndexs.get(i));
                ScoreResult scoreResult = jPeptide.scores.get(i);
                if(!jPeptide.valid.get(i)){
                    continue;
                }

                String spectrumTitle = spectrum.getSpectrumTitle();

                ScoreResult tmpScoreResult;
                int k = 0;
                if(databaseInput.ms2peptide.containsKey(spectrumTitle)) {
                    for (Peptide ePeptide : databaseInput.ms2peptide.get(spectrumTitle)) {
                        //scoreList[k] = scorePeptide2Spectrum(ePeptide,spectrum,itol).score;
                        tmpScoreResult = scorePeptide2Spectrum(ePeptide, spectrum);
                        double tmpScore = tmpScoreResult.score;
                        //scoreList.add(tmpScore);
                        if (scoreResult.score <= tmpScore) {
                            scoreResult.nBetter++;

                            if (tmpScore >= 20) {
                                String dout = spectrum.getSpectrumTitle() + "\t" +
                                        ePeptide.getSequence() + "\t" +
                                        //ePeptide.getSequenceWithLowerCasePtms() + "\t" +
                                        ModificationDB.getModificationString(ePeptide)+ "\t" +
                                        ePeptide.getMass() + "\t" +
                                        tmpScore;
                                this.peptideInput.addOutAdditionalLines(dout);

                            }
                        }

                        if(CParameter.scoreMethod == 0){
                            double tmpScore2 = tmpScoreResult.score2;
                            if (scoreResult.score2 <= tmpScore2) {
                                scoreResult.nBetter2++;
                            }
                        }

                        k++;
                    }
                }


                double pvalue = 100;
                double pvalue2 = 100;
                int nRand = -1;
                int nRand2 = -1;

                ArrayList<Double> randomScoreList1 = new ArrayList<>(10000);
                ArrayList<Double> randomScoreList2 = new ArrayList<>(10000);

                if(scoreResult.nBetter==0 && scoreResult.nBetter2==0){
                    nRand = 0;
                    nRand2 = 0;
                    if(peptideInput.randomPeptides.size()<=0){
                        peptideInput.setRandomPeptides(PeptideInput.generateRandomPeptidesFast(peptideInput.jPeptide.peptide,CParameter.nRandomPeptides,true));
                    }
                    for (String randomPeptideSeq : peptideInput.randomPeptides) {
                        Peptide randomPeptide = PeptideInput.getModificationPeptide(jPeptide.peptide, randomPeptideSeq, CParameter.fixMods);
                        tmpScoreResult = scorePeptide2Spectrum(randomPeptide, spectrum);
                        double randomScore = tmpScoreResult.score;

                        randomScoreList1.add(randomScore);

                        if (randomScore >= scoreResult.score) {
                            nRand++;
                        }

                        if(CParameter.scoreMethod == 0){
                            double randomScore2 = tmpScoreResult.score2;
                            randomScoreList2.add(randomScore2);
                            if (randomScore2 >= scoreResult.score2) {
                                nRand2++;
                            }

                        }

                    }
                    pvalue = 1.0 * (nRand + 1) / (peptideInput.randomPeptides.size() + 1);

                    if(CParameter.scoreMethod ==0){
                        pvalue2 = 1.0 * (nRand2 + 1) / (peptideInput.randomPeptides.size() + 1);
                    }


                }



                int sumRand = -1;
                if(nRand != -1){
                    sumRand = peptideInput.randomPeptides.size();
                }


                StringBuilder outBuilder = new StringBuilder();
                double tolPpm = (1.0e6) * (jPeptide.peptide.getMass() - spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value)) / jPeptide.peptide.getMass();

                if(CParameter.scoreMethod==0){
                    pvalue = Math.max(pvalue,pvalue2);
                }

                int nBetter = Math.max(scoreResult.nBetter,scoreResult.nBetter2);
                outBuilder.append(jPeptide.peptide.getSequence())
                        .append("\t")
                        //.append(jPeptide.peptide.getSequenceWithLowerCasePtms())
                        .append(ModificationDB.getModificationString(jPeptide.peptide))
                        .append("\t")
                        .append(jPeptide.spectraIndexs.size())
                        .append("\t")
                        .append(spectrum.getSpectrumTitle())
                        .append("\t")
                        .append(spectrum.getPrecursor().getPossibleCharges().get(0).value)
                        .append("\t")
                        .append(spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value))
                        .append("\t")
                        .append(tolPpm)
                        .append("\t")
                        .append(jPeptide.peptide.getMass())
                        .append("\t")
                        .append(spectrum.getPrecursor().getMz())
                        .append("\t")
                        .append(scoreResult.score)
                        .append("\t")
                        .append(nBetter)
                        .append("\t")
                        .append(k)
                        .append("\t")
                        .append(nRand)
                        .append("\t")
                        .append(sumRand)
                        .append("\t")
                        .append(pvalue);

                if(PeptideSearchMT.useGPD){
                    String randomScoreString1 = "-";
                    if(randomScoreList1.size()>=1) {
                        randomScoreString1 = StringUtils.join(randomScoreList1,';');
                    }

                    String randomScoreString2 = "-";
                    if(randomScoreList2.size()>=1){
                        randomScoreString2 = StringUtils.join(randomScoreList2,';');
                    }

                    outBuilder.append("\t").append(randomScoreString1).append("\t").append(randomScoreString2).append("\t").append(scoreResult.score).append("\t").append(scoreResult.score2);

                }

                //System.out.println(outBuilder.toString());
                this.peptideInput.addOutputLine(outBuilder.toString());


            }

            jPeptide.scores = null;

        }

        this.peptideInput.randomPeptides = null;

        System.out.println(Thread.currentThread().getName()+" -> Finished "+this.index+": "+peptideInput.jPeptide.peptide.getSequence()+" .");




    }
}
