package main.java.pg;

import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import main.java.PSMMatch.JPeptide;
import main.java.PSMMatch.ScoreResult;

import java.util.Iterator;

import static main.java.pg.PeptideSearchMT.scorePeptide2Spectrum;

/**
 * scoring PSM (multiple treads)
 */
public final class ScoreWorker implements  Runnable {

    private PeptideInput peptideInput = null;

    public ScoreWorker(PeptideInput pepInput){
        this.peptideInput = pepInput;
    }



    @Override
    public void run() {
        // the peptide form without variable modification
        Iterator<MSnSpectrum> im = peptideInput.jPeptide.mSnSpectrums.iterator();
        while(im.hasNext()){
            MSnSpectrum spectrum = im.next();
            ScoreResult scoreResult = scorePeptide2Spectrum(peptideInput.jPeptide.peptide,spectrum);

            if(scoreResult.score > CParameter.minScore){
                peptideInput.jPeptide.scores.add(scoreResult);
            }else{
                im.remove();
            }

        }

        // the peptide form with variable modification
        // save spectra
        for (JPeptide jPeptide : peptideInput.getPtmIsoforms()) {

            im = jPeptide.mSnSpectrums.iterator();
            while(im.hasNext()){
                MSnSpectrum spectrum = im.next();
                ScoreResult scoreResult = scorePeptide2Spectrum(jPeptide.peptide,spectrum);

                if(scoreResult.score > CParameter.minScore){
                    jPeptide.scores.add(scoreResult);
                }else{
                    im.remove();
                }

            }

        }

    }
}
