package main.java.pg;

import java.io.*;
import java.util.*;

/**
 * Sort PSM result table and add a column (rank)
 */
public class RankPSM {

    public double pvalue;
    public double score;

    public String line;

    public RankPSM(double p,double s, String l){
        this.pvalue = p;
        this.score = s;
        this.line = l;
    }

    public RankPSM(){

    }


    public  static String rankPSMs(String input) throws IOException {
        BufferedReader bReader = new BufferedReader(new FileReader(new File(input)));

        String head = bReader.readLine();
        head = head.trim();
        String h[] = head.split("\t");
        HashMap<String,Integer> hIndex = new HashMap<>();
        for(int i=0;i<h.length;i++){
            hIndex.put(h[i],i);
        }
        String line;

        HashMap<String,ArrayList<RankPSM>> psmMap = new HashMap<>();
        while((line = bReader.readLine())!=null){
            line = line.trim();
            String d[] = line.split("\t");

            double pvalue = Double.valueOf(d[hIndex.get("pvalue")]);
            double score = Double.valueOf(d[hIndex.get("score")]);
            String msID = d[hIndex.get("spectrum_title")];

            RankPSM rankPSM = new RankPSM(pvalue,score,line);
            if(psmMap.containsKey(msID)){
                psmMap.get(msID).add(rankPSM);
            }else{

                ArrayList<RankPSM> psms = new ArrayList<>();
                psms.add(rankPSM);
                psmMap.put(msID,psms);

            }
        }

        String out = input;
        if(out.endsWith(".txt")){
            out = out.replaceFirst(".txt$","_rank.txt");
        }else{
            out = out.concat("_rank.txt");
        }

        BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(out)));
        bWriter.write(head+"\trank\n");
        if(psmMap.size()>=1){
            for(String msID : psmMap.keySet()){
                ArrayList<RankPSM> psms = psmMap.get(msID);
                RankPSMCompare vc = new RankPSMCompare();
                Collections.sort(psms,vc);
                for(int i=0;i<psms.size();i++){
                    int rank = i+1;
                    bWriter.write(psms.get(i).line+"\t"+rank+"\n");
                }
            }
        }

        bWriter.close();
        bReader.close();
        return out;

    }

    /**
     * sort RankPSM: pvalue and score
     */
    public static class RankPSMCompare implements Comparator<RankPSM> {


        public int compare(RankPSM o1, RankPSM o2) {
            double v1 = o1.pvalue;
            double v2 = o2.pvalue;
            double s1 = o1.score;
            double s2 = o2.score;
            double r1 = v2 - v1;
            double r2 = s2 - s1;
            // pvalue
            if(r1 > 0){
                return -1;
            }else if(r1 == 0){
                // score
                if(r2 > 0){
                    return 1;
                }else if(r2==0){
                    return 0;
                }else{
                    return -1;
                }

            }else{
                return 1;
            }
        }

    }

    public static void main(String[] args) throws IOException {

        RankPSM.rankPSMs(args[0]);
    }

    public static void test(){
        ArrayList<RankPSM> psms = new ArrayList<>();
        RankPSM r1 = new RankPSM(0.001,12,"1");
        RankPSM r2 = new RankPSM(0.001,13,"2");
        RankPSM r3 = new RankPSM(0.001,14,"3");
        RankPSM r4 = new RankPSM(0.001,14,"4");
        RankPSM r5 = new RankPSM(0.002,10,"5");
        RankPSM r6 = new RankPSM(0.002,9,"6");
        RankPSM r7 = new RankPSM(0.006,8,"7");
        RankPSM r8 = new RankPSM(0.007,7,"8");
        RankPSM r9 = new RankPSM(0.008,6,"9");
        RankPSM r10 = new RankPSM(0.009,6,"10");
        RankPSM r11 = new RankPSM(0.01,5,"11");
        psms.add(r1);
        psms.add(r2);
        psms.add(r3);
        psms.add(r4);
        psms.add(r5);
        psms.add(r6);
        psms.add(r7);
        psms.add(r8);
        psms.add(r9);
        psms.add(r10);
        psms.add(r11);

        RankPSMCompare vc = new RankPSMCompare();
        Collections.sort(psms,vc);
        for(int i=0;i<psms.size();i++){
            int rank = i+1;
            System.out.println(rank+"\t"+psms.get(i).pvalue+"\t"+psms.get(i).score);
        }
    }


}
