package main.java.pg;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import main.java.OpenModificationSearch.ModificationDB;
import main.java.plot.PeakAnnotation;
import main.java.PSMMatch.JPeptide;
import main.java.PSMMatch.ScoreResult;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;

import static main.java.pg.PeptideSearchMT.scorePeptide2Spectrum;

/**
 * Scoring: single spectrum and single peptide.
 * Speed up the whole processing when taking as input of single peptide for identification.
 */
public class PsmScoringWorker implements  Runnable{

    private PeptideInput peptideInput = null;
    private int i=0;
    private DatabaseInput databaseInput = null;


    private String fixModOptionValue = null;
    private JPeptide jPeptide = null;

    public PsmScoringWorker (PeptideInput pi, DatabaseInput di, int index, JPeptide jPeptide){
        this.peptideInput = pi;
        this.databaseInput = di;
        this.i = index;
        this.jPeptide = jPeptide;

    }


    @Override
    public void run() {
        System.out.println(Thread.currentThread().getName()+" -> Start "+this.i+" ...");

        //MSnSpectrum spectrum = jPeptide.mSnSpectrums.get(i);
        MSnSpectrum spectrum = SpectraInput.spectraMap.get(jPeptide.spectraIndexs.get(i));
        ScoreResult scoreResult = jPeptide.scores.get(i);
        if(!jPeptide.valid.get(i)){
            System.out.println(Thread.currentThread().getName()+" -> End "+this.i+" ...");
            return;
        }

        //ScoreResult scoreResult = scorePeptide2Spectrum(peptideInput.jPeptide.peptide, spectrum, itol, method);
        //peptideInput.jPeptide.scores.add(scoreResult);

        String spectrumTitle = spectrum.getSpectrumTitle();

        // save peptide spectrum annotation data

        String psmMatch = PeakAnnotation.getPeakAnnotation(jPeptide.peptide,spectrum,true);
        if(psmMatch != null){
            peptideInput.addOutPeakAnnotations(psmMatch);
        }

        int k = 0;
        ScoreResult tmpScoreResult;

        // for a target PSM, score all reference peptides matched to the target spectrum.
        // For web version (single peptide searching), output the best match from reference database searching
        String bestRefPSM = "";
        double bestRefScore = 0;
        Peptide bestRefPeptide = new Peptide();

        if(databaseInput.ms2peptide.containsKey(spectrumTitle)) {
            for (Peptide ePeptide : databaseInput.ms2peptide.get(spectrumTitle)) {
                tmpScoreResult = scorePeptide2Spectrum(ePeptide, spectrum);
                double tmpScore = tmpScoreResult.score;

                // save the best matching from the reference database searching for the target spectrum
                if(bestRefScore < tmpScore){
                    bestRefScore = tmpScore;
                    bestRefPSM = spectrum.getSpectrumTitle() + "\t" +
                            ePeptide.getSequence() + "\t" +
                            ModificationDB.getModificationString(ePeptide) + "\t" +
                            ePeptide.getMass() + "\t" +
                            tmpScore;
                    bestRefPeptide = ePeptide;
                }

                // scoreList.add(tmpScore);
                if (scoreResult.score <= tmpScore) {
                    scoreResult.nBetter++;

                    // don't export data for matches with low score
                    if (tmpScore >= 20) {
                        String dout = spectrum.getSpectrumTitle() + "\t" +
                                ePeptide.getSequence() + "\t" +
                                ModificationDB.getModificationString(ePeptide) + "\t" +
                                ePeptide.getMass() + "\t" +
                                tmpScore;
                        this.peptideInput.addOutAdditionalLines(dout);

                    }
                }

                // If use two scoring algorithms in the same run.
                if(CParameter.scoreMethod == 0){
                    double tmpScore2 = tmpScoreResult.score2;
                    if (scoreResult.score2 <= tmpScore2) {
                        scoreResult.nBetter2++;
                    }
                }

                k++;

            }
        }

        // save the best matching from the reference database searching for the target spectrum
        if(bestRefScore > 0){
            if(!this.peptideInput.getOutAdditionalLines().contains(bestRefPSM)){
                this.peptideInput.addOutAdditionalLines(bestRefPSM);
            }

            // add PSM annotation
            String bestRef_psmMatch = PeakAnnotation.getPeakAnnotation(bestRefPeptide,spectrum,true);
            if(bestRef_psmMatch != null){
                peptideInput.addOutPeakAnnotations(bestRef_psmMatch);
            }
        }

        // will not calculate pvalue if find a better match from reference database.
        // for the first selected algorithm
        double pvalue = 100;
        // for the second selected algorithm
        double pvalue2 = 100;
        // for the first selected algorithm
        int nRand = -1;
        // for the second selected algorithm
        int nRand2 = -1;

        ArrayList<Double> randomScoreList1 = new ArrayList<>(10000);
        ArrayList<Double> randomScoreList2 = new ArrayList<>(10000);

        if(scoreResult.nBetter==0 && scoreResult.nBetter2==0){

            nRand = 0;

            nRand2 = 0;


            for (String randomPeptideSeq : peptideInput.randomPeptides) {
                Peptide randomPeptide = PeptideInput.getModificationPeptide(jPeptide.peptide, randomPeptideSeq, fixModOptionValue);
                tmpScoreResult = scorePeptide2Spectrum(randomPeptide, spectrum);
                double randomScore = tmpScoreResult.score;

                randomScoreList1.add(randomScore);

                if (randomScore >= scoreResult.score) {
                    nRand++;
                }


                // for the second selected algorithm
                if(CParameter.scoreMethod == 0){
                    double randomScore2 = tmpScoreResult.score2;
                    randomScoreList2.add(randomScore2);
                    if (randomScore2 >= scoreResult.score2) {
                        nRand2++;
                    }

                }

            }



            pvalue = 1.0 * (nRand + 1) / (peptideInput.randomPeptides.size() + 1);

            if(CParameter.scoreMethod ==0){
                pvalue2 = 1.0 * (nRand2 + 1) / (peptideInput.randomPeptides.size() + 1);
            }

        }


        int sumRand = -1;
        if(nRand != -1){
            sumRand = peptideInput.randomPeptides.size();
        }


        StringBuilder outBuilder = new StringBuilder();
        double tolPpm = (1.0e6) * (jPeptide.peptide.getMass() - spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value)) / jPeptide.peptide.getMass();

        if(CParameter.scoreMethod==0){
            pvalue = Math.max(pvalue,pvalue2);
        }

        int nBetter = Math.max(scoreResult.nBetter,scoreResult.nBetter2);

        outBuilder.append(jPeptide.peptide.getSequence())
                .append("\t")
                //.append(jPeptide.peptide.getSequenceWithLowerCasePtms())
                .append(ModificationDB.getModificationString(jPeptide.peptide))
                .append("\t")
                .append(jPeptide.spectraIndexs.size())
                .append("\t")
                .append(spectrum.getSpectrumTitle())
                .append("\t")
                .append(spectrum.getPrecursor().getPossibleCharges().get(0).value)
                .append("\t")
                .append(spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value))
                .append("\t")
                .append(tolPpm)
                .append("\t")
                .append(jPeptide.peptide.getMass())
                .append("\t")
                .append(spectrum.getPrecursor().getMz())
                .append("\t")
                .append(scoreResult.score)
                .append("\t")
                .append(nBetter)
                .append("\t")
                .append(k)
                .append("\t")
                .append(nRand)
                .append("\t")
                .append(sumRand)
                .append("\t")
                .append(pvalue);

        if(PeptideSearchMT.useGPD){
            String randomScoreString1 = "-";
            if(randomScoreList1.size()>=1) {
                randomScoreString1 = StringUtils.join(randomScoreList1,';');
            }

            String randomScoreString2 = "-";
            if(randomScoreList2.size()>=1){
                randomScoreString2 = StringUtils.join(randomScoreList2,';');
            }

            outBuilder.append("\t").append(randomScoreString1).append("\t").append(randomScoreString2).append("\t").append(scoreResult.score).append("\t").append(scoreResult.score2);

        }
        //System.out.println(outBuilder.toString());
        this.peptideInput.addOutputLine(outBuilder.toString());
        System.out.println(Thread.currentThread().getName()+" -> End "+this.i+" ...");

    }
}
