package main.java.pg;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;

import java.util.ArrayList;
import java.util.HashMap;


public final class ModificationGear {

    private static ModificationGear instance = null;

    private HashMap<Integer,String> id2ptmname = new HashMap<Integer, String>();


    private ModificationGear(){
        int i=0;
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> ptmNames = ptmFactory.getPTMs();
        for(String name : ptmNames){
            i++;
            id2ptmname.put(i,name);
        }
    }

    public static ModificationGear getInstance() {
        if (instance == null) {
            instance = new ModificationGear();
        }
        return instance;
    }

    public PTM getPTM(int index){
        PTMFactory ptmFactory = PTMFactory.getInstance();
        return(ptmFactory.getPTM(this.id2ptmname.get(index)));
    }


    public String getPTMname(int index){
        PTMFactory ptmFactory = PTMFactory.getInstance();
        return(this.id2ptmname.get(index));
    }

    /**
     * Get the ptms according to ptm index (1,2,3)
     * @param mod modification index, such as 1,2,3
     * @return
     */
    public ArrayList<PTM> getPTMs(String mod){
        ArrayList<PTM> ptms = new ArrayList<PTM>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        String[] d = mod.split(",");
        for(int i=0;i<d.length;i++){
            ptms.add(ptmFactory.getPTM(this.id2ptmname.get(Integer.valueOf(d[i]))));
        }
        return(ptms);
    }
}
