package main.java.pg;

import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Precursor;
import main.java.PSMMatch.JPeptide;
import main.java.PSMMatch.ScoreResult;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

import static main.java.pg.PeptideSearchMT.scorePeptide2Spectrum;

/**
 * Search a spectrum against peptides (peptide index). Get the matched peptides and score PSMs. Set a min score cutoff
 * for matching.
 */
public class FindCandidateSpectraAndScoreWorker implements  Runnable {


    public ConcurrentHashMap<Integer,ArrayList<JPeptide>> pIndex = new ConcurrentHashMap<>();
    public MSnSpectrum spectrum = new MSnSpectrum();


    public FindCandidateSpectraAndScoreWorker(ConcurrentHashMap<Integer,ArrayList<JPeptide>> pepIndex, MSnSpectrum msnspectrum){
        this.pIndex = pepIndex;
        this.spectrum = msnspectrum;

    }


    @Override
    public void run() {

        // System.out.println("Spectrum:"+spectrum.getSpectrumTitle());

        if(!spectrum.getPrecursor().getPossibleCharges().isEmpty()) {

            int charge = spectrum.getPrecursor().getPossibleCharges().get(0).value;
            double mass = spectrum.getPrecursor().getMass(charge);

            int va = (int) Math.round(mass*10.0);
            double peptideMass;
            double del;
            for(int i=(va-1);i<=(va+1);i++){
                if(pIndex.containsKey(i)){
                    for(JPeptide jPeptide: pIndex.get(i)){
                        peptideMass = jPeptide.peptide.getMass();
                        del = Math.abs(peptideMass - mass);
                        if (CParameter.tolu) {
                            del = (1.0e6) * 1.0 * del / peptideMass;
                        }
                        if (del <= CParameter.tol) {

                            ScoreResult scoreResult = scorePeptide2Spectrum(jPeptide.peptide,spectrum);

                            if(scoreResult.score > CParameter.minScore){

                                // make sure there is only one thread can access it
                                jPeptide.saveMatchedSpectrum(scoreResult,spectrum.getSpectrumTitle(),true);
                                //jPeptide.scores.add(scoreResult);
                                //jPeptide.spectraIndexs.add(spectrum.getSpectrumTitle());
                                //jPeptide.valid.add(true);
                                //jPeptide.mSnSpectrums.add(spectrum);
                            }
                        }
                    }
                }
            }



        }else{

            // if no charge state for this spectrum
            int charge = 2;

            // We need to change the precursor of this spectrum
            ArrayList<Charge> possibleCharges = new ArrayList<>();
            Charge C_charge = new Charge(Charge.PLUS,charge);
            possibleCharges.add(C_charge);
            Precursor precursor = new Precursor(0.0,spectrum.getPrecursor().getMz(),possibleCharges);
            spectrum.setPrecursor(precursor);

            double mass = spectrum.getPrecursor().getMass(charge);
            int va = (int) Math.round(mass*10.0);

            boolean find = false;

            for(int i=(va-1);i<=(va+1);i++){
                if(pIndex.containsKey(i)){
                    for(JPeptide jPeptide: pIndex.get(i)){
                        double peptideMass = jPeptide.peptide.getMass();
                        double del = Math.abs(peptideMass - mass);
                        if (CParameter.tolu) {
                            del = (1.0e6) * 1.0 * Math.abs(peptideMass - mass) / peptideMass;
                        }
                        if (del <= CParameter.tol) {

                            ScoreResult scoreResult = scorePeptide2Spectrum(jPeptide.peptide,spectrum);

                            if(scoreResult.score > CParameter.minScore){

                                // jPeptide.saveMatchedSpectrum(scoreResult,spectrum.getSpectrumTitle(),true);
                                jPeptide.saveMatchedSpectrum(scoreResult,spectrum.getSpectrumTitle(),charge,true);
                                //jPeptide.scores.add(scoreResult);
                                //jPeptide.spectraIndexs.add(spectrum.getSpectrumTitle());
                                //jPeptide.valid.add(true);
                                //jPeptide.mSnSpectrums.add(spectrum);
                                find = true;
                            }
                        }
                    }
                }
            }

            // If no result for charge state 2, will consider 3
            if(!find) {
                charge = 3;

                // We need to change the precursor of this spectrum
                possibleCharges = new ArrayList<>();
                C_charge = new Charge(Charge.PLUS,charge);
                possibleCharges.add(C_charge);
                precursor = new Precursor(0.0,spectrum.getPrecursor().getMz(),possibleCharges);
                spectrum.setPrecursor(precursor);


                mass = spectrum.getPrecursor().getMass(charge);
                va = (int) Math.round(mass * 10.0);

                for(int i=(va-1);i<=(va+1);i++){
                    if(pIndex.containsKey(i)){
                        for(JPeptide jPeptide: pIndex.get(i)){
                            double peptideMass = jPeptide.peptide.getMass();
                            double del = Math.abs(peptideMass - mass);
                            if (CParameter.tolu) {
                                del = (1.0e6) * 1.0 * Math.abs(peptideMass - mass) / peptideMass;
                            }
                            if (del <= CParameter.tol) {

                                ScoreResult scoreResult = scorePeptide2Spectrum(jPeptide.peptide,spectrum);

                                if(scoreResult.score > CParameter.minScore){

                                    // jPeptide.saveMatchedSpectrum(scoreResult,spectrum.getSpectrumTitle(),true);
                                    jPeptide.saveMatchedSpectrum(scoreResult,spectrum.getSpectrumTitle(),charge,true);
                                    //jPeptide.scores.add(scoreResult);
                                    //jPeptide.spectraIndexs.add(spectrum.getSpectrumTitle());
                                    //jPeptide.valid.add(true);
                                    //jPeptide.mSnSpectrums.add(spectrum);
                                }
                            }
                        }
                    }
                }

            }

        }

    }
}
