package main.java.pg;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class CreatePeptideInputWorker implements  Runnable {

    private String peptideSequence;

    public ConcurrentHashMap<String,PeptideInput> peptideInputConcurrentHashMap = new ConcurrentHashMap<>();

    public CreatePeptideInputWorker(String pep, ConcurrentHashMap<String,PeptideInput> pMap){
        this.peptideSequence = pep;
        this.peptideInputConcurrentHashMap = pMap;
    }

    @Override
    public void run() {
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<>();
        Peptide peptide = new Peptide(peptideSequence,modificationMatches);
        PeptideInput peptideInput = new PeptideInput(peptide);

        // Consider fixed modification

        try {
            peptideInput.addFixedModification(CParameter.fixMods);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        // Consider variable modification

        try {
            peptideInput.setPtmIsoforms(PeptideInput.calcPeptideIsoforms(peptideInput.jPeptide.peptide,ModificationGear.getInstance().getPTMs(CParameter.varMods),CParameter.maxVarMods));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        peptideInputConcurrentHashMap.put(peptideSequence,peptideInput);

    }
}
