package main.java.pg;


import org.apache.commons.lang3.StringUtils;



import java.util.ArrayList;

/**
 * Parameter class
 */
public class CParameter {

    public static double tol = 10;

    /**
     * true: ppm, false:da
     */
    public static boolean tolu = true;

    /**
     * tolerance for MS2, the unit is Da
     */
    public static double itol = 0.6;

    public static int minPeptideLength = 7;

    public static int maxPeptideLength = 45;

    public static double minPeptideMass = 500.0;

    public static double maxPeptideMass = 10000.0;

    /**
     * The maximum number of variable modifications
     */
    public static int maxVarMods = 3;

    /**
     * The maximum number of allowed missed cleavage sites
     */
    public static int maxMissedCleavages = 2;

    /**
     * options.addOption("e",true,"1:Trypsin (default), 2:Trypsin (no P rule), 3:Arg-C, 4:Arg-C (no P rule), 5:Arg-N, 6:Glu-C, 7:Lys-C");
     */
    public static int enzyme = 1;

    /**
     * The maximum number of random peptides for p-value calculation, default is 10000
     */
    public static int nRandomPeptides = 10000;


    /**
     * The min score
     */
    public static double minScore = 5.0;

    /**
     * The min number of peaks for an MS/MS spectrum
     */
    public static int minPeaks = 10;


    /**
     * 1: CID/HCD (default), 2: ETD
     */
    public static int fragmentMethod = 1;


    /**
     * When an MS/MS spectrum doesn't have precursor change information, the min charge state will be considered.
     */
    public static int minCharge = 2;
    /**
     * When an MS/MS spectrum doesn't have precursor change information, the max charge state will be considered.
     */
    public static int maxCharge = 3;


    /**
     * Scoring algorithm:
     * 1: Hyperscore
     * 2: MVH
     */
    public static int scoreMethod = 1;


    public static int cpu = 0;


    public static double intensityThreshold = 0.03;


    /**
     * Fixed modification
     */
    public static String fixMods = "6";

    /**
     * Variable modification
     */
    public static String varMods = "107";

    /**
     * This parameter is used to control whether add the AA substitution modifications when performing the modification
     * filtering. In default, it's false. But when performing missing protein identification, we can set it as true.
     */
    public static boolean addAAsubstitutionMods = false;

    /**
     * When perform unrestricted modification searching, how to filter the result.
     * When the value is true, then filtering is score(ptm) >= score(target peptide).
     * When the value is false, then filtering is score(ptm) > score(target peptide). This is the default value.
     * We recommend to set it as true when require very stringent filtering, for example performing missing protein
     * identification.
     */
    public static boolean unrestrictedSearchWithEqualAndBetterScore = false;


    public static void print(){

        System.out.println("#############################################");
        System.out.println("PepQuery parameter:");
        System.out.println("Fixed modification: "+fixMods+" = "+getModificationString(fixMods));
        System.out.println("Variable modification: "+varMods+" = "+getModificationString(varMods));
        System.out.println("Max allowed variable modification: "+maxVarMods);
        System.out.println("Add AA substitution: "+addAAsubstitutionMods);
        System.out.println("Enzyme: "+enzyme);
        System.out.println("maxMissedCleavages: "+maxMissedCleavages);
        System.out.println("Precursor mass tolerance: "+tol);
        String tol_unit;
        if(tolu){
            tol_unit = "ppm";
        }else{
            tol_unit = "Da";
        }

        System.out.println("Precursor ion mass tolerance unit: "+tol_unit);
        System.out.println("Fragment ion mass tolerance unit: "+itol);
        System.out.println("Scoring algorithm: "+scoreMethod);
        System.out.println("Min score: "+minScore);
        System.out.println("Min peaks: "+minPeaks);

        System.out.println("Min peptide length: "+minPeptideLength);
        System.out.println("Max peptide length: "+maxPeptideLength);

        System.out.println("Min peptide mass: "+minPeptideMass);
        System.out.println("Max peptide mass: "+maxPeptideMass);

        System.out.println("Random peptide number: "+nRandomPeptides);
        System.out.println("CPU: "+cpu);
        System.out.println("#############################################");



    }

    public static String getModificationString (String modValue){
        ModificationGear.getInstance();
        ArrayList<String> mods = new ArrayList<>();
        if(modValue != null && !modValue.isEmpty()){
            String fm[] = modValue.split(",");
            for(int i=0;i<fm.length;i++){
                String ptMname = ModificationGear.getInstance().getPTMname(Integer.valueOf(fm[i]));
                mods.add(ptMname);
            }
        }
        String res = "-";
        if(mods.size()>=1){
            res = StringUtils.join(mods,',');
        }
        return(res);

    }

}
