package main.java.PSMMatch;

import com.compomics.util.experiment.biology.Ion.IonType;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import main.java.pg.CParameter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;


public final class JPeptideSpectrumMatch {

	public static boolean outputDetail = false;

	private String SpectrumID;

	private int SpectrumIndex;

	private String pepSeq;

	private ArrayList<JModification> modificationList = new ArrayList<JModification>();
	
	private int rank;
	private int charge;
	private double calculatedMassToCharge;
	private double experimentalMassToCharge;
	private double evalue;
	private ArrayList<String> proteins = new ArrayList<String>();
	private boolean isDecoy=false;
	private double rt=-1.0;


	private double annotationLevel = 0.02;


	public JPeptideSpectrumMatch(){
		
	}


	public ArrayList<ModificationMatch> getModificationMatch() {
		ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
		PTMFactory ptmFactory = PTMFactory.getInstance();
		if (modificationList.size() >= 1) {
			for (int i = 0; i < modificationList.size(); i++) {
				JModification jModification = modificationList.get(i);
				double modMassDelta = Double.valueOf(String.format("%.4f", jModification.getModMassDelta()));
				String ptmName = "CMSPTM:" + jModification.getResidue() + ":" + modMassDelta;
				if (!ptmFactory.containsPTM(ptmName)) {
					ArrayList<String> residuesArray = new ArrayList<String>();
					residuesArray.add(jModification.getResidue());
					PTM ptm = null;
					if (jModification.getResidue().equalsIgnoreCase("N-term")) {
						ptm = new PTM(PTM.MODNP, ptmName, modMassDelta, new ArrayList<String>());
					} else if (jModification.getResidue().equalsIgnoreCase("C-term")) {
						ptm = new PTM(PTM.MODCP, ptmName, modMassDelta, new ArrayList<String>());
					} else {
						ptm = new PTM(PTM.MODAA, ptmName, modMassDelta, residuesArray);
					}
					ptmFactory.addUserPTM(ptm);
				}
				ModificationMatch mm = null;
				if (jModification.getResidue().equalsIgnoreCase("N-term")) {
					mm = new ModificationMatch(ptmName, true, 1);
				} else if (jModification.getResidue().equalsIgnoreCase("C-term")) {
					mm = new ModificationMatch(ptmName, true, this.getPepSeq().length());
				} else {
					mm = new ModificationMatch(ptmName, true, jModification.getModLocation());
				}

				modificationMatches.add(mm);
			}

		}
		return (modificationMatches);
	}
	

	public double getMass(){
		Peptide peptideTmp  = new Peptide( getPepSeq(),getModificationMatch());
		return peptideTmp.getMass();
	}

	
	public String getSpectrumID() {
		return SpectrumID;
	}


	public void setSpectrumID(String spectrumID) {
		SpectrumID = spectrumID;
	}


	public int getSpectrumIndex() {
		return SpectrumIndex;
	}



	public String getPepSeq() {
		return pepSeq;
	}


	public void setPepSeq(String pepSeq) {
		this.pepSeq = pepSeq;
	}



	public int getRank() {
		return rank;
	}


	public void setRank(int rank) {
		this.rank = rank;
	}


	public int getCharge() {
		return charge;
	}


	public void setCharge(int charge) {
		this.charge = charge;
	}


	public double getCalculatedMassToCharge() {
		return calculatedMassToCharge;
	}


	public void setCalculatedMassToCharge(double calculatedMassToCharge) {
		this.calculatedMassToCharge = calculatedMassToCharge;
	}


	public double getExperimentalMassToCharge() {
		return experimentalMassToCharge;
	}


	public void setExperimentalMassToCharge(double experimentalMassToCharge) {
		this.experimentalMassToCharge = experimentalMassToCharge;
	}


	public double getEvalue() {
		return evalue;
	}


	public void setEvalue(double evalue) {
		this.evalue = evalue;
	}

	public ArrayList<String> getProteins() {
		return proteins;
	}



	public boolean isDecoy() {
		return isDecoy;
	}

	public void setDecoy(boolean isDecoy) {
		this.isDecoy = isDecoy;
	}
	
	public int getLabel(){
		if(this.isDecoy){
			return -1;
		}else{
			return 1;
		}
	}
	

	public String getPeakAnnotation(MSnSpectrum spectrum, JSpectrum jSpectrum){
		jSpectrum.resetPeaks();
		Peptide objPeptide = new Peptide(this.getPepSeq(),this.getModificationMatch());
		PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();

		String spectrumKey = spectrum.getSpectrumKey();
		Charge objCharge = new Charge(Charge.PLUS, getCharge());
		PeptideAssumption peptideAssumption = new PeptideAssumption(objPeptide, 1, 1, objCharge, 1.0);
		SpecificAnnotationSettings specificAnnotationPreferences = new SpecificAnnotationSettings(spectrumKey, peptideAssumption);
		
		ArrayList<Integer> charges = new ArrayList<Integer>(4);
		int precursorCharge = peptideAssumption.getIdentificationCharge().value;
		if (precursorCharge == 1) {
			charges.add(precursorCharge);
		} else {
		    for (int c = 1; c < precursorCharge; c++) {
		    	charges.add(c);
		    }
		}
		specificAnnotationPreferences.setSelectedCharges(charges);

		specificAnnotationPreferences.addIonType(IonType.PEPTIDE_FRAGMENT_ION,PeptideFragmentIon.B_ION);
		specificAnnotationPreferences.addIonType(IonType.PEPTIDE_FRAGMENT_ION,PeptideFragmentIon.Y_ION);
		specificAnnotationPreferences.setFragmentIonAccuracy(CParameter.itol);
		specificAnnotationPreferences.setFragmentIonPpm(false);
		specificAnnotationPreferences.setNeutralLossesAuto(false);
		specificAnnotationPreferences.clearNeutralLosses();
		specificAnnotationPreferences.addNeutralLoss(NeutralLoss.H2O);
		specificAnnotationPreferences.addNeutralLoss(NeutralLoss.NH3);

		AnnotationSettings annotationSettings = new AnnotationSettings();
		annotationSettings.setTiesResolution(SpectrumAnnotator.TiesResolution.mostIntense);
		annotationSettings.setFragmentIonAccuracy(CParameter.itol);
		annotationSettings.setFragmentIonPpm(false);
		annotationSettings.setIntensityLimit(this.annotationLevel);
		ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationSettings, specificAnnotationPreferences, spectrum, objPeptide);

		StringBuilder mz_all = new StringBuilder();
		StringBuilder int_all = new StringBuilder();
		StringBuilder mz_match = new StringBuilder();
		StringBuilder int_match = new StringBuilder();
		StringBuilder m_label = new StringBuilder();

		HashMap<Double,Double> validPeakMz = new HashMap<Double, Double>();
		for(int i=0;i<jSpectrum.getPeaks().size();i++){
			JPeak jPeak = jSpectrum.getPeaks().get(i);
			validPeakMz.put(jPeak.getMz(),jPeak.getIntensity());
			if(i==0){
				mz_all.append(jPeak.getMz());
				int_all.append(jPeak.getIntensity());
			}else{
				mz_all.append(";"+jPeak.getMz());
				int_all.append(";"+jPeak.getIntensity());
			}
		}
		Iterator<IonMatch> pListIterator = matches.iterator();
		HashSet<Double> ionHitSet = new HashSet<Double>();
		while (pListIterator.hasNext()) {
			IonMatch ionMatch = pListIterator.next();
			if (!validPeakMz.containsKey(ionMatch.peak.mz) || ionHitSet.contains(ionMatch.peak.mz) || ionMatch.ion.getNeutralLosses().length>=2) {
				pListIterator.remove();
				
			}else{
				ionHitSet.add(ionMatch.peak.mz);
			}
		}

		
		
		for(int i=0;i<matches.size();i++){
			IonMatch ionMatch = matches.get(i);
			PeptideFragmentIon fragmentIon = ((PeptideFragmentIon) ionMatch.ion);
			String label = ionMatch.ion.getSubTypeAsString()+fragmentIon.getNumber()+ionMatch.ion.getNeutralLossesAsString()+ionMatch.charge.toString();
			if(i==0){
				mz_match.append(ionMatch.peak.mz);
				int_match.append(ionMatch.peak.intensity);
				m_label.append(label);
			}else{
				mz_match.append(";"+ionMatch.peak.mz);
				int_match.append(";"+ionMatch.peak.intensity);
				m_label.append(";"+label);
			}
			
		}

		//IonFactory.getInstance().getDefaultNeutralLosses().clear();

		StringBuilder outline = new StringBuilder();
		outline.append(this.getSpectrumID()).append("\t");
		outline.append(this.getCalculatedMassToCharge()).append("\t");
		outline.append(this.getExperimentalMassToCharge()).append("\t");
		outline.append(this.getCharge()).append("\t");
		outline.append(this.getPepSeq()).append("\t");
		outline.append(m_label).append("\t");
		outline.append(mz_match).append("\t");
		outline.append(int_match).append("\t");
		outline.append(mz_all).append("\t");
		outline.append(int_all);
		
		return(outline.toString());
	}

	public double getRt() {
		return rt;
	}
	public void setRt(double rt) {
		this.rt = rt;
	}


}
