package main.java.PSMMatch;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;


import java.util.ArrayList;
import java.util.HashMap;


public class JPeptide {

    public Peptide peptide;

    public ArrayList<MSnSpectrum> mSnSpectrums = new ArrayList<>(1);
    public ArrayList<String> spectraIndexs = new ArrayList<>(1);

    /**
     * Because sometimes there is no charge information for a spectrum in mgf file, here we need to save the charge
     * information when perform matching.
     */
    // public ArrayList<Integer> charges = new ArrayList<>(1);
    public HashMap<String,Integer> spectrumID2charge = new HashMap<>();

    public ArrayList<ScoreResult> scores = new ArrayList<>(1);

    // Whether the match is valid. If it's not valid, then it will not be used for downstream processing.
    public ArrayList<Boolean> valid = new ArrayList<>(1);

    public JPeptide(Peptide pep){
        this.peptide = pep;
    }


    public synchronized void saveMatchedSpectrum(ScoreResult scoreResult,String spectrumID, boolean isValid){
        this.scores.add(scoreResult);
        this.spectraIndexs.add(spectrumID);
        this.valid.add(isValid);
    }

    public synchronized void saveMatchedSpectrum(ScoreResult scoreResult,String spectrumID, int charge, boolean isValid){
        this.scores.add(scoreResult);
        this.spectraIndexs.add(spectrumID);
        spectrumID2charge.put(spectrumID,charge);
        this.valid.add(isValid);
    }
}
