package main.java.OpenModificationSearch;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import main.java.pg.CParameter;
import main.java.PSMMatch.ScoreResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

import static main.java.pg.PeptideSearchMT.scorePeptide2Spectrum;

public final class ModPepQueryAndScoringWorker implements Runnable{


    public static ArrayList<String> fixMods;
    // private int ind = 0;
    private long intValue;


    private MSnSpectrum spectrum = null;
    private HashMap<Long, PeptideIndex> peptideIndexMap = null;

    private ConcurrentHashMap<Long,ArrayList<ScoreResult>> res = null;
    private String targetPeptideSeq  = null;

    public ModPepQueryAndScoringWorker(long i, MSnSpectrum spectrumObj, HashMap<Long, PeptideIndex> peptideIndMap, ConcurrentHashMap<Long,ArrayList<ScoreResult>> resMap) {
        this.intValue = i;
        this.spectrum = spectrumObj;
        this.peptideIndexMap = peptideIndMap;
        this.res = resMap;
    }

    public ModPepQueryAndScoringWorker(long i, MSnSpectrum spectrumObj, HashMap<Long, PeptideIndex> peptideIndMap, ConcurrentHashMap<Long,ArrayList<ScoreResult>> resMap, String targetPepSeq) {
        this.intValue = i;
        this.spectrum = spectrumObj;
        this.peptideIndexMap = peptideIndMap;
        this.res = resMap;
        this.targetPeptideSeq = targetPepSeq;
    }

    @Override
    public void run() {

        // save the best match from modification searching
        // double bestPSMscore = 0.0;
        // Peptide bestPeptide = new Peptide();

        if(peptideIndexMap.containsKey(intValue)){
            ArrayList<String> peptideSequences = peptideIndexMap.get(intValue).peptideSequences;
            ArrayList<Double> peptideMasses = peptideIndexMap.get(intValue).peptideMasses;
            for(int k=0;k<peptideMasses.size();k++){

                if(this.targetPeptideSeq != null){
                    // calculate the similarity of the query peptide and target peptide.
                    if(!calcSimilarityOfPeptides(this.targetPeptideSeq, peptideSequences.get(k))){
                        continue;
                    }
                }

                ArrayList<ModificationMatch> modificationMatches = new ArrayList<>();
                Peptide peptide = new Peptide(peptideSequences.get(k), modificationMatches);
                ModificationDB.addFixedModification(fixMods,peptide);
                ArrayList<Peptide> modPeptides = ModificationDB.getCandidatePTMs(spectrum,peptide);
                for(Peptide pep: modPeptides){
                    ScoreResult scoreResult = scorePeptide2Spectrum(pep,spectrum);

                    // save the best match from modification searching
                    // if(bestPSMscore < scoreResult.score){
                    //    bestPSMscore = scoreResult.score;
                    //    bestPeptide = pep;
                    //}
                    if(scoreResult.score>= CParameter.minScore){
                        // Only output PSMs with score >= minScore
                        scoreResult.peptide = pep;
                        this.res.get(intValue).add(scoreResult);
                    }
                    //System.out.println(Thread.currentThread().getName()+"\t"+ind+"\t"+pep.getSequenceWithLowerCasePtms()+"\t"+pep.getMass()+"\t"+spectrum.getPrecursor().getMass(spectrum.getPrecursor().getPossibleCharges().get(0).value)+"\t"+scoreResult.score);

                }
            }
        }

    }


    public boolean calcSimilarityOfPeptides(String seq1, String seq2){
        String d1[] = seq1.split("");
        String d2[] = seq2.split("");
        HashSet<String> h1 = new HashSet<>();

        boolean yes = false;
        for(int i=0;i<(d1.length-2);i++){
            h1.add(d1[i]+d1[i+1]);
        }

        for(int i=0;i<(d2.length-2);i++){
            if(h1.contains(d2[i]+d2[i+1])){
                yes = true;
                break;
            }
        }

        return(yes);
    }



}


