package main.java.OpenModificationSearch;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.IteratorFactory;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideWithPosition;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.preferences.DigestionPreferences;
import main.java.pg.CParameter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final  class DigestProteinWorker implements Runnable{

    private ConcurrentHashMap<String,HashMap<String,Double>> pro2pep = null;
    private String proteinID;
    private String proteinSequence;
    private IteratorFactory iteratorModifications;
    private DigestionPreferences digestionPreferences;

    public DigestProteinWorker(String ID, String proSeq, ArrayList<String> fixedModifications, DigestionPreferences digestionPreferences, ConcurrentHashMap<String, HashMap<String, Double>> pro2pepMap){
        this.proteinID = ID;
        this.proteinSequence = proSeq;
        this.pro2pep = pro2pepMap;
        this.iteratorModifications = new IteratorFactory(fixedModifications);
        this.digestionPreferences = digestionPreferences;
    }

    @Override
    public void run() {

        proteinSequence = proteinSequence.toUpperCase();

        proteinSequence = proteinSequence.replaceAll("\\*", "");
        proteinSequence = proteinSequence.replaceAll("I", "L");


        HashMap<String,Double> pep2mass = new HashMap<>();

        //SequenceIterator sequenceIterator = iteratorModifications.getSequenceIterator(this.proteinSequence, digestionPreferences, 600.0, 5000.0);
        SequenceIterator sequenceIterator = iteratorModifications.getSequenceIterator(this.proteinSequence, digestionPreferences, CParameter.minPeptideMass, CParameter.maxPeptideMass);

        PeptideWithPosition peptideWithPosition;
        while ((peptideWithPosition = sequenceIterator.getNextPeptide()) != null) {

            Peptide peptide = peptideWithPosition.getPeptide();

            if (peptide.getSequence().length() >= CParameter.minPeptideLength && peptide.getSequence().length() <= CParameter.maxPeptideLength) {
                pep2mass.put(peptide.getSequence(), peptide.getMass());
            }

        }

        pro2pep.put(this.proteinID,pep2mass);

    }
}
