source("../dreg-train/dregpipe-fast.R");

source("dregpipe-param.R");

#load( "../dreg-train/dregpipe-fast-infp.rdata");


infp=get_informative_positions( file.bw.GM[1], file.bw.GM[2], depth= 0, step=50, use_ANDOR=TRUE, use_OR=FALSE )
infp <- infp[ infp[,1] != "chr22",];
infp_listx <- list()
infp_listx[[1]] <- list( plus=file.bw.GM[1], minus=file.bw.GM[2], infp=infp);

setwd("../dreg-train/")

load("../GM12878/GM12878.positive.bed.rdata");
GM.positive.bed <- positive_bed;
GM.positive.bed <- GM.positive.bed[ GM.positive.bed[,1]!="chr22", ]

load("../GM12878/GM12878.negative.bed.rdata");
GM.negative.bed <- negative_bed;
GM.negative.bed <- GM.negative.bed[ GM.negative.bed[,1]!="chr22", ]

g.neg.amp <- 32 #(3%)

library(Rgtsvm);
selectGPUdevice(1);

rM.fast <- dregpipe( gdm, 
   c(file.bw.GM[1] ), 
   c(file.bw.GM[2] ), 
   20000*5,  
   8000, 
   infp_listx,
   list(infp_listx[[1]]$infp ), 
   "dregf1-GM-100k-p3-G1-7-exl22",  
   "Train GM:100K-3%pos-exl22/Test G1-7",
   positive.bed = GM.positive.bed,
   negative.bed = GM.negative.bed)

setwd("../gr-review");

system("mail -s 'Check results' 'zw355@cornell.edu' <<EOF\n g.neg.amp <- 1.5 \nEOF")