source("../dreg-train/dregpipe-fast.R");

source("dregpipe-param.R");

load( "../dreg-train/dregpipe-fast-infp.rdata");

setwd("../dreg-train/")

load("k562.positive.bed.rdata");
k562.positive.bed <- positive_bed;
load("k562.negative.bed.rdata");
k562.negative.bed <- negative_bed;
rm(negative_bed);
rm(positive_bed);


g.neg.amp <- 32 #(3%)

r12358.fast <- dregpipe( gdm, 
   c(file.bw.G1[1], file.bw.G2[1], file.bw.G3[1], file.bw.G5[1], file.bw.G6[1]), 
   c(file.bw.G1[2], file.bw.G2[2], file.bw.G3[2], file.bw.G5[2], file.bw.G6[2]), 
   20000,  
   10000, 
   infp_list,
   list(infp_list[[1]]$infp,  infp_list[[2]]$infp ,infp_list[[3]]$infp, infp_list[[5]]$infp, infp_list[[6]]$infp), 
   "dregf1-G12356-20k-p3-G1-7",  
   "Train G12356:20K-3%pos/Test G1-7",
   positive.bed = list(k562.positive.bed, k562.positive.bed, k562.positive.bed, k562.positive.bed, k562.positive.bed),
   negative.bed = list(k562.negative.bed, k562.negative.bed, k562.negative.bed, k562.negative.bed, k562.negative.bed))

setwd("../gr-review");

system("mail -s 'Check results' 'zw355@cornell.edu' <<EOF\n g.neg.amp <- 1.5 \nEOF")