options("scipen"=100, "digits"=4)
library("tools")

bed_intersect <- function( refer_bed, score_bed ){
	file.refer <- tempfile(fileext=".bed");
	file.score <- tempfile(fileext=".bed");
	write.table( refer_bed[,c(1:3)], file=file.refer, quote=F, col.names=F, row.names=F, sep="\t");
	write.table( score_bed, file=file.score, quote=F, col.names=F, row.names=F, sep="\t");
	ret <- unique( read.table( pipe(paste("bedtools intersect -a ", file.score,  " -b ", file.refer, " -wa ", sep=" ")) ) );
	unlink(file.refer);
	unlink(file.score);
	return(ret);
}

get_score_dist <- function(peak_bed)
{
	pos_score <- bed_intersect(positive_bed, peak_bed );
	file.neg <- tempfile(fileext=".bed");
	write.table( negative_bed, file=file.neg, quote=F, col.names=F, row.names=F, sep="\t");
	nonneg_bed <- read.table( pipe(paste("bedtools complement -i ", file.neg, " -g ../k562/chrom_info_hg19.tab ") ) );
	nneg_score <- bed_intersect(nonneg_bed, peak_bed);
	idx.neg <- which( !( paste(peak_bed[,1],peak_bed[,2],peak_bed[,3], sep=":") %in% paste(nneg_score [,1], nneg_score [,2], nneg_score [,3], sep=":") ) )
	neg_score <- peak_bed[idx.neg,];
	return(list(pos=pos_score, neg=neg_score, nneg_=nneg_score));
}


file.black.bed <- "/fs/cbsudanko/storage/data/hg19/all/encode_blacklist/hg19.blacklist.bed";

K562_FDR_TPR<-function(file.bed.gz, file.grocap="../k562/hg19.k562.new_hmm2b.post2.bed", threshold=seq(0.05, 1.0, 0.01),skip=0, chr=NULL )
{
	options("scipen"=100, "digits"=4)

	file.nonneg = tempfile("tmp.DREG.nonneg", fileext=".bed" );
	system( paste("cat ../k562/wgEncodeOpenChromDnaseK562PkV2.narrowPeak ../k562/GSM646567_hg19_wgEncodeUwDgfK562Pk.narrowPeak.txt ../k562/GSM646567_hg19_wgEncodeUwDgfK562Pk.macs2.narrowPeak | awk -v OFS='\\t' '{print $1,$2,$3}' - > ", file.nonneg ), intern=TRUE );

if( file_ext(file.grocap) == "gz")
    nonneg_bed <- unique(read.table( pipe(paste("zcat ", file.grocap, "| cat ", file.nonneg,  " - | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 100 ", sep=" " ) ) )[,c(1:3)])
else
	nonneg_bed <- unique(read.table( pipe(paste("cat ", file.nonneg, file.grocap, " | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 100 ", sep=" " ) ) )[,c(1:3)]);
	nonneg_bed[,2] <- nonneg_bed[,2] - 100
	idx.mis <- which(nonneg_bed[,2]<0);
	if(length(idx.mis)>0) nonneg_bed[idx.mis,2] <- 0;
	nonneg_bed[,3] <- nonneg_bed[,3] + 100
	if(is.null(chr))
	   write.table( nonneg_bed, file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" )
	else   
	   write.table( nonneg_bed[as.character(nonneg_bed[,1])==chr, ], file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" );

	TP_bed0  <- unique(read.table(pipe(paste("bedtools intersect -a ../k562/wgEncodeOpenChromDnaseK562PkV2.narrowPeak -b ../k562/GSM646567_hg19_wgEncodeUwDgfK562Pk.narrowPeak.txt -wa")))[,c(1:3)]);
	TP_bed1  <- unique(read.table(pipe(paste("bedtools intersect -b ../k562/wgEncodeOpenChromDnaseK562PkV2.narrowPeak -a ../k562/GSM646567_hg19_wgEncodeUwDgfK562Pk.narrowPeak.txt -wa")))[,c(1:3)]);
	tmp.file2 <- tempfile(fileext = ".bed" );
	write.table(rbind(TP_bed0[,c(1:3)], TP_bed1[,c(1:3)]), file=tmp.file2, quote=F, row.names=F, col.names=F, sep="\t");
	positive_bed <- unique(read.table( pipe(paste("sort-bed ", tmp.file2," | bedtools merge -i - -d 100 ", sep="" ) ) ));

	write.table( positive_bed, file=tmp.file2, quote=F, row.name=F, col.names=F, sep="\t" );
	positive_bed  <- unique(read.table(pipe(paste("bedtools intersect -b ", file.grocap, " -a ", tmp.file2 ," -wa")))[,c(1:3)]);

	positive_bed[,2] <- positive_bed[,2] - 100
	idx.mis <- which(positive_bed[,2]<0);
	if(length(idx.mis)>0) positive_bed[idx.mis,2] <- 0;
	positive_bed[,3] <- positive_bed[,3] + 100
	file.pos<- tempfile("tmp.DREG.pos", fileext=".bed");

	if(is.null(chr))
   	    write.table( positive_bed, file=file.pos, quote=F, row.names=F, col.names=F, sep="\t")
	else   
	   write.table( positive_bed[as.character(positive_bed[,1])==chr, ], file=file.pos, quote=F, row.names=F, col.names=F, sep="\t");

	dREG_bed0 <- read.table( pipe(paste("bedtools subtract -A -a ", file.bed.gz, "-b", file.black.bed)));
	if(!is.null(chr))
	    dREG_bed0 <- dREG_bed0[as.character(dREG_bed0[,1])==chr, ];
	    
	FDRs <- TPRs <- count<- c();
	for(th in threshold)
	{
		file.dreg <- tempfile("tmp.DREG.bed", fileext=".bed");
		#dREG_bed <- dREG_bed0[dREG_bed0$V4>=th,]
		dREG_bed <- dREG_bed0
		write.table( dREG_bed,  file=file.dreg, quote=F, row.names=F, col.names=F, sep="\t");

		TP_bed <- unique(read.table(pipe(paste("bedtools intersect -a ", file.dreg, " -b ", file.nonneg, " -wa")))[,c(1,2,3)]);
		FDR <- 1 - NROW(TP_bed)/ NROW( dREG_bed );

		TP_bed  <- unique(read.table(pipe(paste("bedtools intersect -a ", file.pos, " -b ", file.dreg, " -wa")))[,c(1,2,3)]);
		TPR <- NROW(TP_bed)/ NROW( read.table(file.pos) );
		unlink(file.dreg);

		cat("Threshold=", th, "count=", NROW(TP_bed), "FDR=", FDR, "TPR=", TPR, "\n");
		count <- c(count, NROW(dREG_bed));
		FDRs <- c(FDRs, FDR);
		TPRs <- c(TPRs, TPR);
	}

	unlink(file.pos);
	unlink(tmp.file2);
	unlink(file.nonneg);

	data.frame(th=threshold, count=count, FDR=FDRs, TPR=TPRs, chr=chr);
}

GM12878_FDR_TPR<-function(file.bed.gz, file.grocap="../GM12878/hg19.gm12878.new_hmm2b.post2.bed", threshold=seq(0.05, 1.0, 0.01), skip=0, chr=NULL )
{
	options("scipen"=100, "digits"=4)

	file.nonneg = tempfile("tmp.DREG.nonneg", fileext=".bed" );
	system( paste("cat ../GM12878/uw.merge.peak.obs.bed ../GM12878/wgEncodeOpenChromDnaseGm12878Pk.narrowPeak | awk -v OFS='\\t' '{print $1,$2,$3}' - > ", file.nonneg ), intern=TRUE );

if( file_ext(file.grocap) == "gz")
    nonneg_bed <- unique(read.table( pipe(paste("zcat ", file.grocap, "| cat ", file.nonneg,  " - | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 100 ", sep=" " ) ) )[,c(1:3)])
else
	nonneg_bed <- unique(read.table( pipe(paste("cat ", file.nonneg, file.grocap, " | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 100 ", sep=" " ) ) )[,c(1:3)]);

	nonneg_bed[,2] <- nonneg_bed[,2] - 100
	idx.mis <- which(nonneg_bed[,2]<0);
	if(length(idx.mis)>0) nonneg_bed[idx.mis,2] <- 0;
	nonneg_bed[,3] <- nonneg_bed[,3] + 100
	
	if(is.null(chr))
  	   write.table( nonneg_bed, file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" )
  	else   
  	   write.table( nonneg_bed[as.character(nonneg_bed[,1])==chr, ], file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" )

	TP_bed0  <- unique(read.table(pipe(paste("bedtools intersect -a ../GM12878/uw.merge.peak.obs.bed -b ../GM12878/wgEncodeOpenChromDnaseGm12878Pk.narrowPeak -wa")))[,c(1:3)]);
	TP_bed1  <- unique(read.table(pipe(paste("bedtools intersect -b ../GM12878/uw.merge.peak.obs.bed -a ../GM12878/wgEncodeOpenChromDnaseGm12878Pk.narrowPeak -wa")))[,c(1:3)]);
	tmp.file2 <- tempfile(fileext = ".bed" );
	write.table(rbind(TP_bed0[,c(1:3)], TP_bed1[,c(1:3)]), file=tmp.file2, quote=F, row.names=F, col.names=F, sep="\t");
	positive_bed <- unique(read.table( pipe(paste("sort-bed ", tmp.file2," | bedtools merge -i - -d 100 ", sep="" ) ) ));

	write.table( positive_bed, file=tmp.file2, quote=F, row.name=F, col.names=F, sep="\t" );
	positive_bed  <- unique(read.table(pipe(paste("bedtools intersect -b ", file.grocap, " -a ", tmp.file2 ," -wa")))[,c(1:3)]);

	positive_bed[,2] <- positive_bed[,2] - 100
	idx.mis <- which(positive_bed[,2]<0);
	if(length(idx.mis)>0) positive_bed[idx.mis,2] <- 0; 
	positive_bed[,3] <- positive_bed[,3] + 100
	file.pos<- tempfile("tmp.DREG.pos", fileext=".bed");
	if(is.null(chr))
	    write.table( positive_bed, file=file.pos, quote=F, row.names=F, col.names=F, sep="\t")
    else
	    write.table( positive_bed[as.character(positive_bed[,1])==chr, ], file=file.pos, quote=F, row.names=F, col.names=F, sep="\t");
    
	#dREG_bed0 <- read.table(file.bed.gz, header=F, skip=skip);
	dREG_bed0 <- read.table( pipe(paste("bedtools subtract -A -a ", file.bed.gz, "-b", file.black.bed)));
	if (!is.null(chr))
	    dREG_bed0 <- dREG_bed0[as.character(dREG_bed0[,1])==chr, ];

	FDRs <- TPRs <- count<- c();
	for(th in threshold)
	{
		file.dreg <- tempfile("tmp.DREG.bed", fileext=".bed");
		#dREG_bed <- dREG_bed0[dREG_bed0$V4>=th,]
		dREG_bed <- dREG_bed0
		write.table( dREG_bed,  file=file.dreg, quote=F, row.names=F, col.names=F, sep="\t");

		TP_bed <- unique(read.table(pipe(paste("bedtools intersect -a ", file.dreg, " -b ", file.nonneg, " -wa")))[,c(1,2,3)]);
		FDR <- 1 - NROW(TP_bed)/ NROW( dREG_bed );

		TP_bed  <- unique(read.table(pipe(paste("bedtools intersect -a ", file.pos, " -b ", file.dreg, " -wa")))[,c(1,2,3)]);
		TPR <- NROW(TP_bed)/ NROW(  read.table(file.pos)  );
		unlink(file.dreg);

		#cat("Threshold=", th, "count"=,NROW(bed), "FDR=", FDR, "TPR=", TPR, "\n");
		count <- c(count, NROW(dREG_bed));
		FDRs <- c(FDRs, FDR);
		TPRs <- c(TPRs, TPR);
	}

	unlink(file.pos);
	unlink(tmp.file2);
	unlink(file.nonneg);

	data.frame(th=threshold, count=count, FDR=FDRs, TPR=TPRs, chr=chr);
}

COMMON_FDR_TPR<-function(file.bed.gz, file.dnase="", file.grocap="", threshold=seq(0.05, 1.0, 0.01), skip=0, chr=NULL )
{
	options("scipen"=100, "digits"=4)

if(file.dnase!="")
{
	file.nonneg = tempfile("tmp.DREG.nonneg", fileext=".bed" ); 
    if( file_ext(file.dnase) == "gz")
  	  system( paste("zcat ", file.dnase, " | awk -v OFS='\\t' '{print $1,$2,$3}' - > ", file.nonneg ), intern=TRUE )
   else
	  system( paste("cat ", file.dnase, " | awk -v OFS='\\t' '{print $1,$2,$3}' - > ", file.nonneg ), intern=TRUE );
}
else
	file.nonneg = "";

if( file_ext(file.grocap) == "gz")
    nonneg_bed <- unique(read.table( pipe(paste("zcat ", file.grocap, "| cat ", file.nonneg,  " - | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 1000 ", sep=" " ) ) )[,c(1:3)])
else
    nonneg_bed <- unique(read.table( pipe(paste("cat ", file.nonneg, file.grocap, " | sort-bed - | awk  -v OFS='\t' '{print $1, $2, $3}' - | bedtools merge -i - -d 1000 ", sep=" " ) ) )[,c(1:3)]);

	nonneg_bed[,2] <- nonneg_bed[,2] - 100
	idx.mis <- which(nonneg_bed[,2]<0);
	if(length(idx.mis)>0) nonneg_bed[idx.mis,2] <- 0;
	nonneg_bed[,3] <- nonneg_bed[,3] + 100
	if(is.null(chr))
  	    write.table( nonneg_bed, file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" )
    else
  	    write.table( nonneg_bed[as.character(nonneg_bed[,1])==chr, ], file=file.nonneg, quote=F, row.name=F, col.names=F, sep="\t" );
    
	positive_bed <- unique(read.table( pipe(paste("sort-bed ../HCT116/hg19.dNase.HCT116.broad.peak.bed | bedtools merge -i - -d 1000 ", sep="" ) ) ));
	tmp.file2 <- tempfile(fileext = ".bed" );
	write.table( positive_bed, file=tmp.file2, quote=F, row.name=F, col.names=F, sep="\t" );
	positive_bed  <- unique(read.table(pipe(paste("bedtools intersect -b ", file.grocap, " -a ", tmp.file2 ," -wa")))[,c(1:3)]);

	positive_bed[,2] <- positive_bed[,2] - 100
	idx.mis <- which(positive_bed[,2]<0);
	if(length(idx.mis)>0) positive_bed[idx.mis,2] <- 0;
	positive_bed[,3] <- positive_bed[,3] + 100
	file.pos<- tempfile("tmp.DREG.pos", fileext=".bed");
	if(is.null(chr))
  	    write.table( positive_bed, file=file.pos, quote=F, row.names=F, col.names=F, sep="\t")
  	else    
  	    write.table( positive_bed[as.character(positive_bed[,1])==chr,], file=file.pos, quote=F, row.names=F, col.names=F, sep="\t");
 
	#dREG_bed0 <- read.table(file.bed.gz, header=F, skip=skip);
	dREG_bed0 <- read.table( pipe(paste("bedtools subtract -A -a ", file.bed.gz, "-b", file.black.bed)));
	if (!is.null(chr))
	    dREG_bed0 <- dREG_bed0[ as.character(dREG_bed0[,1])==chr, ];

	FDRs <- TPRs <- count<- c();
	for(th in threshold)
	{
		file.dreg <- tempfile("tmp.DREG.bed", fileext=".bed");
		#dREG_bed <- dREG_bed0[dREG_bed0$V4>=th,]
		dREG_bed <- dREG_bed0
		write.table( dREG_bed,  file=file.dreg, quote=F, row.names=F, col.names=F, sep="\t");

		TP_bed <- unique(read.table(pipe(paste("bedtools intersect -a ", file.dreg, " -b ", file.nonneg, " -wa")))[,c(1,2,3)]);
		FDR <- 1 - NROW(TP_bed)/ NROW( dREG_bed );

		TP_bed  <- unique(read.table(pipe(paste("bedtools intersect -a ", file.pos, " -b ", file.dreg, " -wa")))[,c(1,2,3)]);
		TPR <- NROW(TP_bed)/ NROW(  read.table(file.pos)  );
		unlink(file.dreg);

		#cat("Threshold=", th, "count"=,NROW(bed), "FDR=", FDR, "TPR=", TPR, "\n");
		count <- c(count, NROW(dREG_bed));
		FDRs <- c(FDRs, FDR);
		TPRs <- c(TPRs, TPR);
	}

	unlink(file.pos);
	unlink(tmp.file2);
	if(file.nonneg!="") unlink(file.nonneg);

	data.frame(th=threshold, count=count, FDR=FDRs, TPR=TPRs, chr=chr);
}


if(0)
{
	r1 <- K562_FDR_TPR("~/temp/Gx/K562_unt.dreg.new2.score");
	r2 <- K562_FDR_TPR("~/temp/Gx/groseq.dreg.new2.score");
	r3 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_NoRNase.dreg.new2.score");
	r4 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_RNase.dreg.new2.score");
	r5 <- K562_FDR_TPR("~/temp/Gx/K562_FC_NHS_BRs.dreg.new2.score");
	r6 <- K562_FDR_TPR("~/temp/Gx/6045_rep1.dreg.new2.score");
	r7 <- K562_FDR_TPR("~/temp/Gx/6045_rep2.dreg.new2.score");


	pdf("dreg.peak.FDR.TPR.pdf");

	plot(NA, NA, type="l", ylim=c(0,1.0), xlim=c(0,1), main="dREG peak calling(FDR+TPR)", xlab="Threshold", ylab="FDR or TPR")
	lines(r1$th, r1$FDR, col=1);
	lines(r2$th, r2$FDR, col=2);
	lines(r3$th, r3$FDR, col=3);
	lines(r4$th, r4$FDR, col=4);
	lines(r5$th, r5$FDR, col=5);
	lines(r6$th, r6$FDR, col=6);
	lines(r7$th, r7$FDR, col=7);

	lines(r1$th, r1$TPR, col=1, lwd=2, lty="11");
	lines(r2$th, r2$TPR, col=2, lwd=2, lty="11");
	lines(r3$th, r3$TPR, col=3, lwd=2, lty="11");
	lines(r4$th, r4$TPR, col=4, lwd=2, lty="11");
	lines(r5$th, r5$TPR, col=5, lwd=2, lty="11");
	lines(r6$th, r6$TPR, col=6, lwd=2, lty="11");
	lines(r7$th, r7$TPR, col=7, lwd=2, lty="11");

	abline(h=0.15, col="black", lty="22");
	abline(h=0.10, col="black", lty="22");
	abline(h=0.05, col="black", lty="22");
	legend("topright", legend=paste("G",1:7, sep=""), text.col=1:7);

	plot(NA, NA, type="l", ylim=c(0,0.4), xlim=c(0,1), main="dREG peak calling(FDR)", xlab="Threshold", ylab="FDR")
	lines(r1$th, r1$FDR, col=1);
	lines(r2$th, r2$FDR, col=2);
	lines(r3$th, r3$FDR, col=3);
	lines(r4$th, r4$FDR, col=4);
	lines(r5$th, r5$FDR, col=5);
	lines(r6$th, r6$FDR, col=6);
	lines(r7$th, r7$FDR, col=7);
	abline(h=0.15, col="black", lty="22");
	abline(h=0.10, col="black", lty="22");
	abline(h=0.05, col="black", lty="22");
	legend("topright", legend=paste("G",1:7, sep=""), text.col=1:7);

	plot(NA, NA, type="l", ylim=c(0.2,1.0), xlim=c(0,1), main="dREG peak calling(TPR)", xlab="Threshold", ylab="TPR")
	lines(r1$th, r1$TPR, col=1);
	lines(r2$th, r2$TPR, col=2);
	lines(r3$th, r3$TPR, col=3);
	lines(r4$th, r4$TPR, col=4);
	lines(r5$th, r5$TPR, col=5);
	lines(r6$th, r6$TPR, col=6);
	lines(r7$th, r7$TPR, col=7);
	abline(h=0.85, col="black", lty="22");
	abline(h=0.80, col="black", lty="22");
	abline(h=0.75, col="black", lty="22");
	legend("topright", legend=paste("G",1:7, sep=""), text.col=1:7);
	dev.off();
}


if(0)
{
	rg1 <- K562_FDR_TPR("./G1.K562_unt.dreg.peak.bed", threshold=0.05)
	rg2 <- K562_FDR_TPR("./G2.groseq.dreg.peak.bed", threshold=0.05)
	rg3 <- K562_FDR_TPR("./G3.K562_Nuc_NoRNase.dreg.peak.bed", threshold=0.05)
	rg4 <- K562_FDR_TPR("./G4.K562_Nuc_RNase.dreg.peak.bed", threshold=0.05)
	rg5 <- K562_FDR_TPR("./G5.K562_FC_NHS_BRs.dreg.peak.bed", threshold=0.05)
	rg6 <- K562_FDR_TPR("./G6.6045_rep1.dreg.peak.bed", threshold=0.05)
	rg7 <- K562_FDR_TPR("./G7.6045_rep2.dreg.peak.bed", threshold=0.05)

	tb.dreg <- rbind(rg1,rg2,rg3,rg4,rg5,rg6,rg7);

	og1 <- K562_FDR_TPR("../new-model-201709/G1/out.dREG.peak.full.bed.gz", threshold=0.05)
	og2 <- K562_FDR_TPR("../new-model-201709/G2/out.dREG.peak.full.bed.gz", threshold=0.05)
	og3 <- K562_FDR_TPR("../new-model-201709/G3/out.dREG.peak.full.bed.gz", threshold=0.05)
	og4 <- K562_FDR_TPR("../new-model-201709/G4/out.dREG.peak.full.bed.gz", threshold=0.05)
	og5 <- K562_FDR_TPR("../new-model-201709/G5/out.dREG.peak.full.bed.gz", threshold=0.05)
	og6 <- K562_FDR_TPR("../new-model-201709/G6/out.dREG.peak.full.bed.gz", threshold=0.05)
	og7 <- K562_FDR_TPR("../new-model-201709/G7/out.dREG.peak.full.bed.gz", threshold=0.05)

	tb.hd2 <- rbind(og1,og2,og3,og4,og5,og6,og7);


	og1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.relaxed.bed.gz", threshold=0.05)
	og7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.relaxed.bed.gz", threshold=0.05)

	tb.hd <- rbind(og1,og2,og3,og4,og5,og6,og7);


	og1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.stringent.bed.gz", threshold=0.05)
	og7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.stringent.bed.gz", threshold=0.05)

	tb.hd2 <- rbind(og1,og2,og3,og4,og5,og6,og7);


	tf.r1 <- K562_FDR_TPR("~/temp/Gx/K562_unt.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r2 <- K562_FDR_TPR("~/temp/Gx/groseq.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r3 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_NoRNase.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r4 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_RNase.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r5 <- K562_FDR_TPR("~/temp/Gx/K562_FC_NHS_BRs.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r6 <- K562_FDR_TPR("~/temp/Gx/6045_rep1.Tfit.bidir.bed.gz", threshold=0.05)
	tf.r7 <- K562_FDR_TPR("~/temp/Gx/6045_rep2.Tfit.bidir.bed.gz", threshold=0.05)

	tb.tfit.b <- rbind(tf.r1,tf.r2,tf.r3,tf.r4,tf.r5,tf.r6,tf.r7);


	tf.d1 <- K562_FDR_TPR("~/temp/Gx/K562_unt.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d2 <- K562_FDR_TPR("~/temp/Gx/groseq.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d3 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_NoRNase.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d4 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_RNase.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d5 <- K562_FDR_TPR("~/temp/Gx/K562_FC_NHS_BRs.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d6 <- K562_FDR_TPR("~/temp/Gx/6045_rep1.Tfit.divergent.bed.gz", threshold=0.05)
	tf.d7 <- K562_FDR_TPR("~/temp/Gx/6045_rep2.Tfit.divergent.bed.gz", threshold=0.05)

	tb.tfit.d <- rbind(tf.d1,tf.d2,tf.d3,tf.d4,tf.d5,tf.d6,tf.d7);

	tb.grocap <-  cbind(tb.dreg[,-1], tb.hd[,-1], tb.tfit.b[,-1], tb.tfit.d[,-1]);
	colnames(tb.grocap) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.count", "hd.FDR", "hd.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	show(tb.grocap);

}


if(0)
{
	#file.grocap="../k562/hg19.k562.new_hmm2b.post2.bed";
	#file.grocap = "../GM12878/hg19.GM12878.grocap.pair.bed"
	file.grocap = "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz";
	file.grocap = "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz";

	tb <-read.table("../Tfit/gm12878_groseq-1_divergent_classifications.bed",skip=1);
	write.table(data.frame(tb[,c(1:3)], th=0.05), file="gm12878.tfit.divergent.bed", quote=F, row.names=F, col.names=F, sep="\t");
	tb <-read.table("../Tfit/gm12878_groseq-1_prelim_bidir_hits.bed",skip=1);
	write.table(data.frame(tb[,c(1:3)], th=0.05), file="gm12878.tfit.bidir.bed", quote=F, row.names=F, col.names=F, sep="\t");


	r8 <- GM12878_FDR_TPR("../new-model-201709/GM12878/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r81 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05);
	r82 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05);
	r.tfit.gm1 <- GM12878_FDR_TPR("gm12878.tfit.divergent.bed", file.grocap, threshold=0.05)
	r.tfit.gm2 <- GM12878_FDR_TPR("gm12878.tfit.bidir.bed", file.grocap, threshold=0.05)

	unlink(c("gm12878.tfit.divergent.bed","gm12878.tfit.bidir.bed"))

	file.grocap="../k562/hg19.k562.grocap.pair.bed"
	r.dreg1 <- K562_FDR_TPR("./G1.K562_unt.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg2 <- K562_FDR_TPR("./G2.groseq.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg3 <- K562_FDR_TPR("./G3.K562_Nuc_NoRNase.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg4 <- K562_FDR_TPR("./G4.K562_Nuc_RNase.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg5 <- K562_FDR_TPR("./G5.K562_FC_NHS_BRs.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg6 <- K562_FDR_TPR("./G6.6045_rep1.dreg.peak.bed", file.grocap, threshold=0.05)
	r.dreg7 <- K562_FDR_TPR("./G7.6045_rep2.dreg.peak.bed", file.grocap, threshold=0.05)

	tb.dreg <- rbind(r.dreg1,r.dreg2,r.dreg3,r.dreg4,r.dreg5,r.dreg6,r.dreg7)


	r.hd1 <- K562_FDR_TPR("../new-model-201709/G1/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../new-model-201709/G2/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../new-model-201709/G3/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../new-model-201709/G4/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../new-model-201709/G5/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../new-model-201709/G6/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../new-model-201709/G7/out.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)

	tb.hd <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);


	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)

	tb.hd <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);

	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)

	tb.hd2 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);


	file.grocap = "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz";
	r.tfit.b1 <- K562_FDR_TPR("~/temp/Gx/K562_unt.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b2 <- K562_FDR_TPR("~/temp/Gx/groseq.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b3 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_NoRNase.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b4 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_RNase.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b5 <- K562_FDR_TPR("~/temp/Gx/K562_FC_NHS_BRs.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b6 <- K562_FDR_TPR("~/temp/Gx/6045_rep1.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	r.tfit.b7 <- K562_FDR_TPR("~/temp/Gx/6045_rep2.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)

	tb.tfit.b <- rbind(r.tfit.b1, r.tfit.b2, r.tfit.b3, r.tfit.b4, r.tfit.b5, r.tfit.b6, r.tfit.b7);


	r.tfit.d1 <- K562_FDR_TPR("~/temp/Gx/K562_unt.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d2 <- K562_FDR_TPR("~/temp/Gx/groseq.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d3 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_NoRNase.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d4 <- K562_FDR_TPR("~/temp/Gx/K562_Nuc_RNase.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d5 <- K562_FDR_TPR("~/temp/Gx/K562_FC_NHS_BRs.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d6 <- K562_FDR_TPR("~/temp/Gx/6045_rep1.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	r.tfit.d7 <- K562_FDR_TPR("~/temp/Gx/6045_rep2.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)

	tb.tfit.d <- rbind(r.tfit.d1, r.tfit.d2, r.tfit.d3, r.tfit.d4, r.tfit.d5, r.tfit.d6, r.tfit.d7);

	tb.grocap.pair <-  cbind(tb.dreg[,-1], tb.hd[,-1], tb.tfit.b[,-1], tb.tfit.d[,-1]);
	colnames(tb.grocap.pair) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.count", "hd.FDR", "hd.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	show(tb.grocap.pair);
}


if(0)
{
	#2017/12/12

show_K562_gx<-function(file.grocap)
{
	r.hd1 <- K562_FDR_TPR("../new-model-201712/G1/G1.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../new-model-201712/G2/G2.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../new-model-201712/G3/G3.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../new-model-201712/G4/G4.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../new-model-201712/G5/G5.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../new-model-201712/G6/G6.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../new-model-201712/G7/G7.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd0 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);

	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);

	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	tb.hd2 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7);

	#r.tfit.b1 <- K562_FDR_TPR("../Tfit/K562_unt.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b2 <- K562_FDR_TPR("../Tfit/groseq.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b3 <- K562_FDR_TPR("../Tfit/K562_Nuc_NoRNase.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b4 <- K562_FDR_TPR("../Tfit/K562_Nuc_RNase.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b5 <- K562_FDR_TPR("../Tfit/K562_FC_NHS_BRs.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b6 <- K562_FDR_TPR("../Tfit/6045_rep1.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.b7 <- K562_FDR_TPR("../Tfit/6045_rep2.Tfit.bidir.bed.gz", file.grocap, threshold=0.05)
	#tb.tfit.b <- rbind(r.tfit.b1, r.tfit.b2, r.tfit.b3, r.tfit.b4, r.tfit.b5, r.tfit.b6, r.tfit.b7);

	#r.tfit.d1 <- K562_FDR_TPR("../Tfit/K562_unt.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d2 <- K562_FDR_TPR("../Tfit/groseq.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d3 <- K562_FDR_TPR("../Tfit/K562_Nuc_NoRNase.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d4 <- K562_FDR_TPR("../Tfit/K562_Nuc_RNase.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d5 <- K562_FDR_TPR("../Tfit/K562_FC_NHS_BRs.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d6 <- K562_FDR_TPR("../Tfit/6045_rep1.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#r.tfit.d7 <- K562_FDR_TPR("../Tfit/6045_rep2.Tfit.divergent.bed.gz", file.grocap, threshold=0.05)
	#tb.tfit.d <- rbind(r.tfit.d1, r.tfit.d2, r.tfit.d3, r.tfit.d4, r.tfit.d5, r.tfit.d6, r.tfit.d7);


	r.tfit.b1 <- K562_FDR_TPR("../Tfit/extend-bigwig/G1-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b2 <- K562_FDR_TPR("../Tfit/extend-bigwig/G2-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b3 <- K562_FDR_TPR("../Tfit/extend-bigwig/G3-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b4 <- K562_FDR_TPR("../Tfit/extend-bigwig/G4-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b5 <- K562_FDR_TPR("../Tfit/extend-bigwig/G5-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b6 <- K562_FDR_TPR("../Tfit/extend-bigwig/G6-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b7 <- K562_FDR_TPR("../Tfit/extend-bigwig/G7-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	tb.tfit.b <- rbind(r.tfit.b1, r.tfit.b2, r.tfit.b3, r.tfit.b4, r.tfit.b5, r.tfit.b6, r.tfit.b7);

	r.tfit.d1 <- K562_FDR_TPR("../Tfit/extend-bigwig/G1-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d2 <- K562_FDR_TPR("../Tfit/extend-bigwig/G2-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d3 <- K562_FDR_TPR("../Tfit/extend-bigwig/G3-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d4 <- K562_FDR_TPR("../Tfit/extend-bigwig/G4-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d5 <- K562_FDR_TPR("../Tfit/extend-bigwig/G5-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d6 <- K562_FDR_TPR("../Tfit/extend-bigwig/G6-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d7 <- K562_FDR_TPR("../Tfit/extend-bigwig/G7-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	tb.tfit.d <- rbind(r.tfit.d1, r.tfit.d2, r.tfit.d3, r.tfit.d4, r.tfit.d5, r.tfit.d6, r.tfit.d7);


	tb.k562 <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1], tb.tfit.b[,-1], tb.tfit.d[,-1]);
	colnames(tb.k562) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.relaxed", "hd.FDR", "hd.TPR", "hd1.stringent", "hd1.FDR", "hd1.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	 options(width=180);

	show(round(tb.k562,3));
	return(tb.k562);
}

	K562.r0 <- show_K562_gx("../k562/hg19.k562.new_hmm2b.post2.bed");
	K562.r1 <- show_K562_gx("../k562/hg19.k562.grocap.pair.bed")
	K562.r2 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz")
	K562.r3 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz")

show_GM12878_gx<-function(file.grocap)
{
	#tb <-read.table("../Tfit/gm12878_groseq-1_divergent_classifications.bed",skip=1);
	#write.table(data.frame(tb[,c(1:3)], th=0.05), file="gm12878.tfit.divergent.bed", quote=F, row.names=F, col.names=F, sep="\t");
	#tb <-read.table("../Tfit/gm12878_groseq-1_prelim_bidir_hits.bed",skip=1);
	#write.table(data.frame(tb[,c(1:3)], th=0.05), file="gm12878.tfit.bidir.bed", quote=F, row.names=F, col.names=F, sep="\t");
	#tb.hd3 <- GM12878_FDR_TPR("gm12878.tfit.divergent.bed", file.grocap, threshold=0.05)
	#tb.hd4 <- GM12878_FDR_TPR("gm12878.tfit.bidir.bed", file.grocap, threshold=0.05)
	#unlink(c("gm12878.tfit.divergent.bed","gm12878.tfit.bidir.bed"))

	tb.hd0 <- GM12878_FDR_TPR("../new-model-201712/GM/GM.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05);
	tb.hd2 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05);
	tb.hd3 <- GM12878_FDR_TPR("../Tfit/extend-bigwig/GM-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05,skip=15)
	tb.hd4 <- GM12878_FDR_TPR("../Tfit/extend-bigwig/GM-1_bidir_predictions.bed", file.grocap, threshold=0.05,skip=20)

	tb.gm <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1], tb.hd3[,-1], tb.hd4[,-1]);
	colnames(tb.gm) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.relaxed", "hd.FDR", "hd.TPR", "hd1.stringent", "hd1.FDR", "hd1.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	return(tb.gm)
}

	GM.r0 <- show_GM12878_gx("../GM12878/hg19.gm12878.new_hmm2b.post2.bed");
	GM.r1 <- show_GM12878_gx("../GM12878/hg19.GM12878.grocap.pair.bed")
	GM.r2 <- show_GM12878_gx("/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz")

}



if(0)
{
	# 2018/03/10 
	# 2018/10/10 add G8 and GH
	# 2018/11/01 add CD4, MCF7, HELA

show_K562_gx<-function(file.grocap)
{
	r.hd1 <- K562_FDR_TPR("../new-rf-201803/G1/G1.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../new-rf-201803/G2/G2.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../new-rf-201803/G3/G3.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../new-rf-201803/G4/G4.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../new-rf-201803/G5/G5.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../new-rf-201803/G6/G6.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../new-rf-201803/G7/G7.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd8 <- K562_FDR_TPR("../new-rf-201803/G8/G8.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd0 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	r.hd8 <- K562_FDR_TPR("../old-model/test-G8/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

	r.hd1 <- K562_FDR_TPR("../old-model/test-G1/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("../old-model/test-G2/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("../old-model/test-G3/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("../old-model/test-G4/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("../old-model/test-G5/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("../old-model/test-G6/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G7/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("../old-model/test-G8/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05)
	tb.hd2 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

	r.tfit.b1 <- K562_FDR_TPR("../Tfit/extend-bigwig/G1-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b2 <- K562_FDR_TPR("../Tfit/extend-bigwig/G2-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b3 <- K562_FDR_TPR("../Tfit/extend-bigwig/G3-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b4 <- K562_FDR_TPR("../Tfit/extend-bigwig/G4-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b5 <- K562_FDR_TPR("../Tfit/extend-bigwig/G5-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b6 <- K562_FDR_TPR("../Tfit/extend-bigwig/G6-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b7 <- K562_FDR_TPR("../Tfit/extend-bigwig/G7-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	r.tfit.b8 <- K562_FDR_TPR("../Tfit/extend-bigwig/G8-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05, skip=15)
	tb.tfit.b <- rbind(r.tfit.b1, r.tfit.b2, r.tfit.b3, r.tfit.b4, r.tfit.b5, r.tfit.b6, r.tfit.b7, r.tfit.b8);

	r.tfit.d1 <- K562_FDR_TPR("../Tfit/extend-bigwig/G1-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d2 <- K562_FDR_TPR("../Tfit/extend-bigwig/G2-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d3 <- K562_FDR_TPR("../Tfit/extend-bigwig/G3-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d4 <- K562_FDR_TPR("../Tfit/extend-bigwig/G4-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d5 <- K562_FDR_TPR("../Tfit/extend-bigwig/G5-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d6 <- K562_FDR_TPR("../Tfit/extend-bigwig/G6-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d7 <- K562_FDR_TPR("../Tfit/extend-bigwig/G7-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	r.tfit.d8 <- K562_FDR_TPR("../Tfit/extend-bigwig/G8-1_bidir_predictions.bed", file.grocap, threshold=0.05, skip=20)
	tb.tfit.d <- rbind(r.tfit.d1, r.tfit.d2, r.tfit.d3, r.tfit.d4, r.tfit.d5, r.tfit.d6, r.tfit.d7, r.tfit.d8);


	tb.k562 <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1], tb.tfit.b[,-1], tb.tfit.d[,-1]);
	colnames(tb.k562) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.relaxed", "hd.FDR", "hd.TPR", "hd1.stringent", "hd1.FDR", "hd1.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	 options(width=180);

	show(round(tb.k562,3));
	return(tb.k562);
}

	K562.r0 <- show_K562_gx("../k562/hg19.k562.new_hmm2b.post2.bed");
	K562.r1 <- show_K562_gx("../k562/hg19.k562.grocap.pair.bed")
	K562.r2 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz")
	K562.r3 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz")

show_GM12878_gx<-function(file.grocap)
{
	tb.hd0 <- GM12878_FDR_TPR("../new-rf-201803/GM/GM.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.relaxed.bed.gz", file.grocap, threshold=0.05);
	tb.hd2 <- GM12878_FDR_TPR("../old-model/test-GM12878/out.dREG.HD.stringent.bed.gz", file.grocap, threshold=0.05);
	tb.hd3 <- GM12878_FDR_TPR("../Tfit/extend-bigwig/GM-1_prelim_bidir_hits.bed", file.grocap, threshold=0.05,skip=15)
	tb.hd4 <- GM12878_FDR_TPR("../Tfit/extend-bigwig/GM-1_bidir_predictions.bed", file.grocap, threshold=0.05,skip=20)

	tb.gm <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1], tb.hd3[,-1], tb.hd4[,-1]);
	colnames(tb.gm) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.relaxed", "hd.FDR", "hd.TPR", "hd1.stringent", "hd1.FDR", "hd1.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	return(tb.gm)
}

	GM.r0 <- show_GM12878_gx("../GM12878/hg19.gm12878.new_hmm2b.post2.bed");
	GM.r1 <- show_GM12878_gx("../GM12878/hg19.GM12878.grocap.pair.bed")
	GM.r2 <- show_GM12878_gx("/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz")


show_GH116_gx<-function(file.grocap)
{
	tb.hd0 <- COMMON_FDR_TPR("../new-rf-201803/GH/GH.dREG.peak.full.bed.gz",     file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05)
	tb.hd1 <- COMMON_FDR_TPR("../old-model/test-GH/out.dREG.HD.relaxed.bed.gz",  file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05);
	tb.hd2 <- COMMON_FDR_TPR("../old-model/test-GH/out.dREG.HD.stringent.bed.gz",file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05);
	tb.hd3 <- COMMON_FDR_TPR("../Tfit/extend-bigwig/GH-1_prelim_bidir_hits.bed", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05,skip=15)
	tb.hd4 <- COMMON_FDR_TPR("../Tfit/extend-bigwig/GH-1_bidir_predictions.bed", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05,skip=20)

	tb.gm <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1], tb.hd3[,-1], tb.hd4[,-1]);
	colnames(tb.gm) <- c("dreg.count","dreg.FDR","dreg.TPR","hd.relaxed", "hd.FDR", "hd.TPR", "hd1.stringent", "hd1.FDR", "hd1.TPR", "bidir.count", "bidir.FDR", "bidir.TPR", "diverg.count","diverg.FDR", "diverg.TPR");

	return(tb.gm)
}

	GH.r2 <- show_GH116_gx("../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed")


show_CD4_gx<-function(file.refer)
{
	tb.hd0 <- COMMON_FDR_TPR("../new-rf-201803/CD4/CD4-U.dREG.peak.full.bed.gz", file.dnase="/fs/cbsudanko/storage/data/hg19/cd4/dnase/duke.cd4.merge.bed", file.grocap=file.refer, threshold=0.05)
	tb.cd4 <-  cbind(tb.hd0[,-1] );
	colnames(tb.cd4) <- c("dreg.count","dreg.FDR","dreg.TPR");
	return(tb.cd4)
}

	CD4.r2 <- show_CD4_gx("/fs/cbsudanko/storage/data/hg19/cd4/epiRoadmap_histone/H3K27ac_peaks.narrowPeak")

show_MCF7_gx<-function(file.refer)
{
    file.nonneg <- tempfile(fileext=".bed");
	system( paste("zcat /fs/cbsudanko/storage/data/hg19/mcf7/dnase/mcf7.peaks.bed.gz /fs/cbsudanko/storage/data/hg19/mcf7/dnase/wgEncodeOpenChromDnaseMcf7Pk.narrowPeak.gz /fs/cbsudanko/storage/data/hg19/mcf7/dgf/Mcf7Estctrl0h.peaks_peaks.narrowPeak.gz  /fs/cbsudanko/storage/data/hg19/mcf7/dgf/GSM1024784_hg19_wgEncodeUwDnaseMcf7Est100nm1hPkRep1.narrowPeak.gz | awk -v OFS='\\t' '{print $1,$2,$3}' -  > ", file.nonneg ), intern=TRUE );

	tb.hd0 <- COMMON_FDR_TPR("../new-rf-201803/MCF7/MCF7.unt.dREG.peak.full.bed.gz", file.dnase=file.nonneg, file.grocap=file.refer, threshold=0.05)
	tb.mcf7 <-  cbind(tb.hd0[,-1] );
	colnames(tb.mcf7) <- c("dreg.count","dreg.FDR","dreg.TPR");
	return(tb.mcf7)
}

	MCF7.r2 <- show_MCF7_gx("/fs/cbsudanko/storage/data/hg19/mcf7/histones/wgEncodeSydhHistoneMcf7H3k27acUcdPk.narrowPeak.gz")


show_HELA_gx<-function(file.refer)
{
	tb.hd0 <- COMMON_FDR_TPR("../new-rf-201803/HELA/HELA.groseq.dREG.peak.full.bed.gz", file.dnase="/fs/cbsudanko/storage/data/hg19/hela/dnase/uw.merge.narrowPeak.bed", file.grocap=file.refer, threshold=0.05)
	tb.hela <-  cbind(tb.hd0[,-1] );
	colnames(tb.hela) <- c("dreg.count","dreg.FDR","dreg.TPR");
	return(tb.hela)
}

	HELA.r2 <- show_HELA_gx("/fs/cbsudanko/storage/data/hg19/hela/histones/wgEncodeBroadHistoneHelas3H3k27acStdPk.broadPeak.gz")

}

 
if(0)
{
	# 2018/10/10 only test model trained by G1,2,3,5,8 and G1,2,3,5,M

show_K562_gx<-function(file.grocap)
{
	r.hd1 <- K562_FDR_TPR("pred-G8trained/G1.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("pred-G8trained/G2.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("pred-G8trained/G3.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("pred-G8trained/G4.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("pred-G8trained/G5.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("pred-G8trained/G6.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("pred-G8trained/G7.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd8 <- K562_FDR_TPR("pred-G8trained/G8.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd0 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

	r.hd1 <- K562_FDR_TPR("pred-GMtrained/G1.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd2 <- K562_FDR_TPR("pred-GMtrained/G2.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd3 <- K562_FDR_TPR("pred-GMtrained/G3.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd4 <- K562_FDR_TPR("pred-GMtrained/G4.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd5 <- K562_FDR_TPR("pred-GMtrained/G5.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd6 <- K562_FDR_TPR("pred-GMtrained/G6.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd7 <- K562_FDR_TPR("pred-GMtrained/G7.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	r.hd8 <- K562_FDR_TPR("pred-GMtrained/G8.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

    r.hd1[,1:4] <- NA;
    r.hd2 <- r.hd3 <- r.hd4<- r.hd5 <- r.hd6 <- r.hd7 <- r.hd1;
	r.hd8 <- K562_FDR_TPR("pred-G13567/G8.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd2 <- rbind(r.hd1, r.hd2, r.hd3, r.hd4, r.hd5, r.hd6, r.hd7, r.hd8);

	tb.k562 <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1] );
	colnames(tb.k562) <- c("dreg.count.G8","dreg.FDR.G8","dreg.TPR.G8", "dreg.count.GM","dreg.FDR.GM","dreg.TPR.GM", "dreg.count.G-2","dreg.FDR.G-2","dreg.TPR.G-2");

    options(width=180);

	show(round(tb.k562,3));
	return(tb.k562);
}

	K562.r0 <- show_K562_gx("../k562/hg19.k562.new_hmm2b.post2.bed");
	K562.r1 <- show_K562_gx("../k562/hg19.k562.grocap.pair.bed")
	K562.r2 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz")
	K562.r3 <- show_K562_gx("/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz")

show_GM12878_gx<-function(file.grocap)
{
	tb.hd0 <- GM12878_FDR_TPR("pred-G8trained/GM.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd1 <- GM12878_FDR_TPR("pred-GMtrained/GM.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)
	tb.hd2 <- GM12878_FDR_TPR("pred-G13567/GM.dREG.peak.full.bed.gz", file.grocap, threshold=0.05)

	tb.gm <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1] );
	colnames(tb.gm) <- c("dreg.count.G8","dreg.FDR.G8","dreg.TPR.G8","dreg.count.GM","dreg.FDR.GM","dreg.TPR.GM","dreg.count.G-2","dreg.FDR.G-2","dreg.TPR.G-2");

show(round(tb.gm,3));

	return(tb.gm)
}

	GM.r0 <- show_GM12878_gx("../GM12878/hg19.gm12878.new_hmm2b.post2.bed");
	GM.r1 <- show_GM12878_gx("../GM12878/hg19.GM12878.grocap.pair.bed")
	GM.r2 <- show_GM12878_gx("/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz")


show_GH116_gx<-function(file.grocap)
{
	tb.hd0 <- COMMON_FDR_TPR("pred-G8trained/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05)
	tb.hd1 <- COMMON_FDR_TPR("pred-GMtrained/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05)
	tb.hd2 <- COMMON_FDR_TPR("pred-G13567/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap=file.grocap, threshold=0.05)

	tb.gh <-  cbind(tb.hd0[,-1], tb.hd1[,-1], tb.hd2[,-1] );
	colnames(tb.gh) <- c("dreg.count.G8","dreg.FDR.G8","dreg.TPR.G8","dreg.count.GM","dreg.FDR.GM","dreg.TPR.GM","dreg.count.G-2","dreg.FDR.G-2","dreg.TPR.G-2");

show(round(tb.gh,3));

	return(tb.gh)
}
	GH.r0 <- show_GH116_gx("../HCT116/hg19.dNase.HCT116.narrow.peak.bed");
	GH.r2 <- show_GH116_gx("../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed")


show_HELA_gx<-function(file.grocap)
{
	tb.hd0 <- COMMON_FDR_TPR("mNET-seq/NET-seq.out.dREG.peak.full.bed.gz", file.dnase="/fs/cbsudanko/storage/data/hg19/hela/dnase/uw.merge.narrowPeak.bed", file.grocap=file.grocap, threshold=0.05)
	tb.hd1 <- COMMON_FDR_TPR("mNET-seq/mNETseq-Churchman.out.dREG.peak.full.bed.gz", file.dnase="/fs/cbsudanko/storage/data/hg19/hela/dnase/uw.merge.narrowPeak.bed", file.grocap=file.grocap, threshold=0.05)

	tb.gh <-  rbind(tb.hd0[,-1], tb.hd1[,-1] );
	colnames(tb.gh) <- c("dreg.count.CUR","dreg.FDR","dreg.TPR");
	rownames(tb.gh) <- c("NET-seq", "mNET-seq-churchman");

show(round(tb.gh,3));

	return(tb.gh)
}
	GHE.r2 <- show_HELA_gx("/fs/cbsudanko/storage/data/hg19/hela/histones/wgEncodeBroadHistoneHelas3H3k27acStdPk.broadPeak.gz")


	gr.11 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.new_hmm2b.post2.bed", threshold=0.05)
	gr.18 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.new_hmm2b.post2.bed", threshold=0.05)
	gr.21 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05)
	gr.28 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05)
	gr.31 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05)
	gr.38 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05)
	gr.41 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz", threshold=0.05)
	gr.48 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdPk.broadPeak.gz", threshold=0.05)
	gr.M1 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05)
	gr.M2 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05)
	gr.H1 <- COMMON_FDR_TPR( "pred-GMonly/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap="../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed", threshold=0.05)

}

if(0)
{

	# 2018/12/09 only test model on chr22

	GMmodel.1 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	GMmodel.2 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	GMmodel.3 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	GMmodel.4 <- K562_FDR_TPR(   "pred-GMonly/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	GMmodel.5 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	GMmodel.6 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")
	GMmodel.7 <- COMMON_FDR_TPR( "pred-GMonly/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap="../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed", threshold=0.05, chr="chr22")
   
    GM <- rbind(GMmodel.1, GMmodel.2, GMmodel.3, GMmodel.4, GMmodel.5, GMmodel.6, GMmodel.7)

	G8model.1 <- K562_FDR_TPR(   "pred-G8trained/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	G8model.2 <- K562_FDR_TPR(   "pred-G8trained/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	G8model.3 <- GM12878_FDR_TPR("pred-G8trained/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	G8model.4 <- K562_FDR_TPR(   "pred-G8trained/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	G8model.5 <- K562_FDR_TPR(   "pred-G8trained/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	G8model.6 <- GM12878_FDR_TPR("pred-G8trained/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")
	G8model.7 <- COMMON_FDR_TPR( "pred-G8trained/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap="../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed", threshold=0.05, chr="chr22")

    G8 <- rbind(G8model.1, G8model.2, G8model.3, G8model.4, G8model.5, G8model.6, G8model.7)

	Gmmodel.1 <- K562_FDR_TPR(   "pred-GMtrained/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmmodel.2 <- K562_FDR_TPR(   "pred-GMtrained/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmmodel.3 <- GM12878_FDR_TPR("pred-GMtrained/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmmodel.4 <- K562_FDR_TPR(   "pred-GMtrained/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	Gmmodel.5 <- K562_FDR_TPR(   "pred-GMtrained/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	Gmmodel.6 <- GM12878_FDR_TPR("pred-GMtrained/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")
	Gmmodel.7 <- COMMON_FDR_TPR( "pred-GMtrained/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap="../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed", threshold=0.05, chr="chr22")

    Gm <- rbind(Gmmodel.1, Gmmodel.2, Gmmodel.3, Gmmodel.4, Gmmodel.5, Gmmodel.6, Gmmodel.7)

	Gmodel.1 <- K562_FDR_TPR(   "../new-rf-201803/G1/G1.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmodel.2 <- K562_FDR_TPR(   "../new-rf-201803/G8/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmodel.3 <- GM12878_FDR_TPR("../new-rf-201803/GM/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmodel.4 <- K562_FDR_TPR(   "../new-rf-201803/G1/G1.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	Gmodel.5 <- K562_FDR_TPR(   "../new-rf-201803/G8/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	Gmodel.6 <- GM12878_FDR_TPR("../new-rf-201803/GM/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")
	Gmodel.7 <- COMMON_FDR_TPR( "../new-rf-201803/GH/GH.dREG.peak.full.bed.gz", file.dnase="../HCT116/hg19.dNase.HCT116.broad.peak.bed", file.grocap="../HCT116/hg19.H3K27ac.narrow.peak.ENCFF450AGJ.bed", threshold=0.05, chr="chr22")

    GC <- rbind(Gmodel.1, Gmodel.2, Gmodel.3, Gmodel.4, Gmodel.5, Gmodel.6, Gmodel.7)


    r <- data.frame( GC[,2:4], G8[,2:4], Gm[,2:4], GM[,2:4] )
    colnames(r) <- c("GC.count", "GC.FDR", "GC.TPR", "G8.count", "G8.FDR", "G8.TPR", "Gm.count", "Gm.FDR", "Gm.TPR", "GM.count", "GM.FDR", "GM.TPR");
    rownames(r) <- c("G1/GRO-cap", "G8/GRO-cap", "GM/GRO-cap", "G1/H3k27ac", "G8/H3k27ac", "GM/H3k27ac", "GH/H3k27ac");
      
    show(r)    
#           GC.count  GC.FDR GC.TPR G8.count  G8.FDR G8.TPR Gm.count  Gm.FDR Gm.TPR GM.count  GM.FDR GM.TPR
#G1/GRO-cap     1457 0.08922 0.9258     1439 0.08687 0.9231     1386 0.07071 0.9203     1431 0.09574 0.8874
#G8/GRO-cap      920 0.07391 0.7555      915 0.06776 0.7500      875 0.07429 0.7390      793 0.05927 0.6868
#GM/GRO-cap     1627 0.07560 0.9475     1624 0.07081 0.9528     1542 0.06031 0.9423     1537 0.06116 0.9449
#G1/H3k27ac     1457 0.07344 0.7013     1439 0.06949 0.7041     1386 0.05267 0.6913     1431 0.04612 0.6629
#G8/H3k27ac      920 0.06304 0.5690      915 0.05683 0.5633      875 0.05714 0.5519      793 0.02900 0.5036
#GM/H3k27ac     1627 0.04179 0.6837     1624 0.03818 0.6878     1542 0.02983 0.6596     1537 0.02212 0.6235
#GH/H3k27ac     1438 0.07650 0.8067     1408 0.07955 0.8067     1385 0.06498 0.8053     1379 0.03118 0.7687
    
}


if(1)
{

	# 2018/12/09 only test model on chr22

	GMmodel.1 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	GMmodel.3 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	GMmodel.4 <- K562_FDR_TPR(   "pred-GMonly/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	GMmodel.6 <- GM12878_FDR_TPR("pred-GMonly/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")

    GM <- rbind(GMmodel.1, GMmodel.3, GMmodel.4, GMmodel.6 )

	Gmodel.1 <- K562_FDR_TPR(   "../new-rf-201803/G8/G8.dREG.peak.full.bed.gz", "../k562/hg19.k562.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmodel.3 <- GM12878_FDR_TPR("../new-rf-201803/GM/GM.dREG.peak.full.bed.gz", "../GM12878/hg19.GM12878.grocap.pair.bed", threshold=0.05, chr="chr22")
	Gmodel.4 <- K562_FDR_TPR(   "../new-rf-201803/G8/G8.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/k562/histones/wgEncodeBroadHistoneK562H3k27acStdAln.bed.gz", threshold=0.05, chr="chr22")
	Gmodel.6 <- GM12878_FDR_TPR("../new-rf-201803/GM/GM.dREG.peak.full.bed.gz", "/fs/cbsudanko/storage/data/hg19/gm12878/histones/wgEncodeBroadHistoneGm12878H3k27acStdPk.broadPeak.gz", threshold=0.05, chr="chr22")

    GC <- rbind(Gmodel.1, Gmodel.3, Gmodel.4, Gmodel.6 )

    r <- data.frame( GC[,2:4], GM[,2:4] )
    colnames(r) <- c("GC.count", "GC.FDR", "GC.TPR", "GM.count", "GM.FDR", "GM.TPR");
    rownames(r) <- c("G8/GRO-cap", "GM/GRO-cap", "G8/H3k27ac", "GM/H3k27ac");
      
    show(r)    
#           GC.count  GC.FDR GC.TPR GM.count  GM.FDR GM.TPR
#G8/GRO-cap      920 0.07391 0.7555      793 0.05927 0.6868
#GM/GRO-cap     1627 0.07560 0.9475     1537 0.06116 0.9449
#G8/H3k27ac      920 0.06304 0.5690      793 0.02900 0.5036
#GM/H3k27ac     1627 0.04179 0.6837     1537 0.02212 0.6235

    
}