#palette <- c("black", "grey60", "black", "white", "grey", "blue")
# http://colorpalettes.net/color-palette-1795/
#palette <- c("black", "#aaacbd", "black", "white", "#d2d8e7", "blue")
# Pink FP palette
#palette <- c("#ff00ff", "#ffbebe",  "black", "white", "grey60", "blue")
# Megenta and darker FP palette
#palette <- c("#ff00ff", "#9294b5", "black", "white", "#d2d2d2", "blue")
# Less extreme magenta palette
palette <- c("#c677a4", "#9294b5", "black", "white", "#d2d2d2", "#0051ff")
# Add names just so I can remember--not used in code
names(palette) <- c("FN", "FP", "Missing (mutation)", "Missing (no mutation)", "N", "P")
pretty.error.mat <- function(error.mat, filename)
{
  y <- melt(cbind(data.frame(cell=rownames(error.mat)),error.mat), id.vars=c('cell'))
  # Make pdf, with height proportional to number of rows (mutations) and width proportional
  # to number of columns (cells) in the final plot. This means columns and rows respectively
  # of the error matri, since in the error matrix, cells are rows.
  # height = ncol/8 means you want 8 mutations in an inch
  # width = nrow/(8*3) means you want the width of each cell to be a third of its height
  pdf(filename, height=ncol(error.mat)/8, width=nrow(error.mat)/(8*3))
  # Plot. Small "size" parameter in geom_tile corresponds to large tiles (small gaps between tiles).
  # I don't know how that makes sense but that's how it works.
  tryCatch(plot(ggplot(y, aes(cell, variable)) + geom_tile(aes(fill=factor(value)),color='white',size=0.35) +
    scale_fill_manual(values=palette) +
    scale_x_discrete(limits=rownames(error.mat)) + scale_y_discrete(limits=colnames(error.mat)) +
    theme(axis.text.x = element_text(angle = 90, hjust = 1, size=3), axis.text.y = element_text(size=4)) +
    # Remove legend and axis text
    # (see http://www.cookbook-r.com/Graphs/Legends_(ggplot2)/#removing-the-legend
    #  and http://www.cookbook-r.com/Graphs/Axes_(ggplot2)/)
    guides(fill=FALSE) + theme(axis.title.x = element_blank(), axis.title.y = element_blank())),
    finally=dev.off())
}
pretty.error.mat.with.legend <- function(error.mat, filename)
{
  y <- melt(cbind(data.frame(cell=rownames(error.mat)),error.mat), id.vars=c('cell'))
  pdf(filename, height=ncol(error.mat)/8, width=nrow(error.mat)/(8*1.3))
  tryCatch(plot(ggplot(y, aes(cell, variable)) + geom_tile(aes(fill=factor(value)),color='white',size=0.7) +
    theme(legend.key = element_rect(colour = "black"), legend.key.size=unit(.20, 'in')) +
    scale_fill_manual(values=palette) +
    scale_x_discrete(limits=rownames(error.mat)) + scale_y_discrete(limits=colnames(error.mat)) +
    theme(axis.text.x = element_text(angle = 90, hjust = 1, size=4), axis.text.y = element_text(size=4)) +
    theme(axis.title.x = element_blank(), axis.title.y = element_blank())),
    #theme(legend.key = element_rect(colour = "black"), legend.key.size=unit(.25, 'in')),
    finally=dev.off())
}

co5.error.mat <- read.table("co5_error_mat.txt", sep='\t')
pretty.error.mat(co5.error.mat, "co5_pretty_error_mat_square.pdf")

co8.error.mat <- read.table("co8_error_mat.txt", sep='\t')
pretty.error.mat(co8.error.mat, "co8_pretty_error_mat_square.pdf")

pretty.error.mat.with.legend(co8.error.mat, "legend_square.pdf")