# Oneliner to retrieve script directory
# From stackoverflow question 59895, answer by tvlooy
DIR=`dirname "$(readlink -f "$0")"`
mkdir seg_data
mkdir seg_images
mkdir trees
for samplepath in `cat test_samples.txt`; do
    samplename=`basename $samplepath`
    ratiouberpath=$samplepath/uber-matrix/uber.gc.$samplename.ratio.txt
    binuberpath=$samplepath/uber-matrix/uber.$samplename.bin.txt
    Rscript $DIR/segment.R $ratiouberpath $binuberpath $samplename seg_data 5
    Rscript $DIR/remove_private_changepoints.R seg_data $samplename 3 .001 .2
    Rscript $DIR/numbered_segmentation_plots.R seg_data/$samplename.3ormore.rle.txt seg_data/$samplename.raw.txt seg_images
    Rscript $DIR/make_tree.R seg_data/$samplename.3ormore.long.txt trees $samplename
done
