infile <- commandArgs(trailingOnly=TRUE)[1]
outdir <- commandArgs(trailingOnly=TRUE)[2]
sample.name <- commandArgs(trailingOnly=TRUE)[3]

# Function to make a tree. Replace if we decide to do maximum parsimony or something.
library(ape)
make.tree <- function(long.seg.data)
{
  nj(dist(t(long.seg.data)))
}

long.seg.data <- read.table(infile, header=TRUE)
long.seg.data <- long.seg.data[,-(1:2)]
tree <- make.tree(long.seg.data)

# Write output
write.tree(tree, sprintf('%s/%s.tree', outdir, sample.name))
pdf(sprintf('%s/%s.tree.pdf', outdir, sample.name))
tryCatch(plot(tree, cex=.4), finally=dev.off())