/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class FeatureDatasetPointXML {
    private static final Logger log = LoggerFactory.getLogger(FeatureDatasetPointXML.class);
    private FeatureDatasetPoint fdp;
    private String path;

    public FeatureDatasetPointXML(FeatureDatasetPoint fdp, String path) {
        this.fdp = fdp;
        this.path = path;
    }

    public String getCapabilities() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.getCapabilitiesDocument());
    }

    public void getCapabilities(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.getCapabilitiesDocument(), os);
    }

    public Document makeStationCollectionDocument(LatLonRect bb, String[] names) throws IOException {
        List<FeatureCollection> list = this.fdp.getPointFeatureCollectionList();
        FeatureCollection fc = list.get(0);
        if (!(fc instanceof StationTimeSeriesFeatureCollection)) {
            throw new UnsupportedOperationException(fc.getClass().getName() + " not a StationTimeSeriesFeatureCollection");
        }
        StationTimeSeriesFeatureCollection sobs = (StationTimeSeriesFeatureCollection)fc;
        Element rootElem = new Element("stationCollection");
        Document doc = new Document(rootElem);
        List<Station> stations = bb != null ? sobs.getStations(bb) : (names != null ? sobs.getStations(Arrays.asList(names)) : sobs.getStations());
        for (Station s : stations) {
            Element sElem = new Element("station");
            sElem.setAttribute("name", s.getName());
            if (s.getWmoId() != null) {
                sElem.setAttribute("wmo_id", s.getWmoId());
            }
            if (s.getDescription() != null && s.getDescription().length() > 0) {
                sElem.addContent((Content)new Element("description").addContent(s.getDescription()));
            }
            sElem.addContent((Content)new Element("longitude").addContent(Double.toString(s.getLongitude())));
            sElem.addContent((Content)new Element("latitide").addContent(Double.toString(s.getLatitude())));
            if (!Double.isNaN(s.getAltitude())) {
                sElem.addContent((Content)new Element("altitude").addContent(Double.toString(s.getAltitude())));
            }
            rootElem.addContent((Content)sElem);
        }
        return doc;
    }

    public Document getCapabilitiesDocument() {
        CalendarDateRange dateRange;
        Element rootElem = new Element("capabilities");
        Document doc = new Document(rootElem);
        if (null != this.path) {
            rootElem.setAttribute("location", this.path);
            Element elem = new Element("featureDataset");
            elem.setAttribute("type", this.fdp.getFeatureType().toString().toLowerCase());
            elem.setAttribute("url", this.path + "/" + this.fdp.getFeatureType().toString().toLowerCase());
            rootElem.addContent((Content)elem);
        }
        List<VariableSimpleIF> vars = this.fdp.getDataVariables();
        Collections.sort(vars);
        for (VariableSimpleIF v : vars) {
            rootElem.addContent((Content)this.writeVariable(v));
        }
        LatLonRect bb = this.fdp.getBoundingBox();
        if (bb != null) {
            rootElem.addContent((Content)this.writeBoundingBox(bb));
        }
        if ((dateRange = this.fdp.getCalendarDateRange()) != null) {
            Element drElem = new Element("TimeSpan");
            drElem.addContent((Content)new Element("begin").addContent(dateRange.getStart().toString()));
            drElem.addContent((Content)new Element("end").addContent(dateRange.getEnd().toString()));
            if (dateRange.getResolution() != null) {
                drElem.addContent((Content)new Element("resolution").addContent(dateRange.getResolution().toString()));
            }
            rootElem.addContent((Content)drElem);
        }
        Element elem = new Element("AcceptList");
        elem.addContent((Content)new Element("accept").addContent("csv"));
        elem.addContent((Content)new Element("accept").addContent("xml"));
        elem.addContent((Content)new Element("accept").addContent("netcdf"));
        elem.addContent((Content)new Element("accept").addContent("ncstream"));
        rootElem.addContent((Content)elem);
        return doc;
    }

    private Element writeBoundingBox(LatLonRect bb) {
        Element bbElem = new Element("LatLonBox");
        bbElem.addContent((Content)new Element("west").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMin(), 6)));
        bbElem.addContent((Content)new Element("east").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMax(), 6)));
        bbElem.addContent((Content)new Element("south").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMin(), 6)));
        bbElem.addContent((Content)new Element("north").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMax(), 6)));
        return bbElem;
    }

    private Element writeVariable(VariableSimpleIF v) {
        Element varElem = new Element("variable");
        varElem.setAttribute("name", v.getShortName());
        DataType dt = v.getDataType();
        if (dt != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : v.getAttributes()) {
            varElem.addContent((Content)NcMLWriter.writeAttribute(att, "attribute", null));
        }
        return varElem;
    }

    public static LatLonRect getSpatialExtent(Document doc) throws IOException {
        Element root = doc.getRootElement();
        Element latlonBox = root.getChild("LatLonBox");
        if (latlonBox == null) {
            return null;
        }
        String westS = latlonBox.getChildText("west");
        String eastS = latlonBox.getChildText("east");
        String northS = latlonBox.getChildText("north");
        String southS = latlonBox.getChildText("south");
        if (westS == null || eastS == null || northS == null || southS == null) {
            return null;
        }
        try {
            double west = Double.parseDouble(westS);
            double east = Double.parseDouble(eastS);
            double south = Double.parseDouble(southS);
            double north = Double.parseDouble(northS);
            return new LatLonRect(new LatLonPointImpl(south, east), new LatLonPointImpl(north, west));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CalendarDateRange getTimeSpan(Document doc) throws IOException {
        Element root = doc.getRootElement();
        Element timeSpan = root.getChild("TimeSpan");
        if (timeSpan == null) {
            return null;
        }
        String beginS = timeSpan.getChildText("begin");
        String endS = timeSpan.getChildText("end");
        String resS = timeSpan.getChildText("resolution");
        if (beginS == null || endS == null) {
            return null;
        }
        try {
            Date start = CalendarDateFormatter.parseISODate(beginS);
            Date end = CalendarDateFormatter.parseISODate(endS);
            if (start == null || end == null) {
                return null;
            }
            DateRange dr = new DateRange(start, end);
            if (resS != null) {
                dr.setResolution(new TimeDuration(resS));
            }
            return CalendarDateRange.of(dr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<VariableSimpleIF> getDataVariables(Document doc) throws IOException {
        Element root = doc.getRootElement();
        ArrayList<VariableSimpleIF> dataVars = new ArrayList<VariableSimpleIF>();
        List varElems = root.getChildren("variable");
        for (Element varElem : varElems) {
            dataVars.add(new VariableSimple(varElem));
        }
        return dataVars;
    }

    public static void doOne(String location, String path, String result) throws IOException {
        FeatureDataset fd = FeatureDatasetFactoryManager.open(FeatureType.ANY_POINT, location, null, new Formatter(System.out));
        FeatureDatasetPointXML xml = new FeatureDatasetPointXML((FeatureDatasetPoint)fd, path);
        xml.getCapabilities(System.out);
        File f = new File(result);
        FileOutputStream fos = new FileOutputStream(f);
        xml.getCapabilities(fos);
        fos.close();
        System.out.printf("%s written%n", f.getPath());
    }

    public static void main(String[] args) throws IOException {
        FeatureDatasetPointXML.doOne("Q:/cdmUnitTest/ft/point/ship/nc/Surface_Buoy_20090920_0000.nc", "http://motherlode.ucar.edu:9080/thredds/cdmremote/idd/buoy/collection", "C:/tmp/pointCapabilities.xml");
    }

    private static class VariableSimple
    implements VariableSimpleIF {
        String name;
        String desc;
        String units;
        DataType dt;
        List<Attribute> atts;

        VariableSimple(Element velem) {
            this.name = velem.getAttributeValue("name");
            String type = velem.getAttributeValue("type");
            this.dt = DataType.getType(type);
            this.atts = new ArrayList<Attribute>();
            List attElems = velem.getChildren("attribute");
            for (Element attElem : attElems) {
                String attName = attElem.getAttributeValue("name");
                Array values = NcMLReader.readAttributeValues(attElem);
                this.atts.add(new Attribute(attName, values));
            }
            for (Attribute att : this.atts) {
                if (att.getShortName().equals("units")) {
                    this.units = att.getStringValue();
                }
                if (att.getShortName().equals("long_name")) {
                    this.desc = att.getStringValue();
                }
                if (this.desc == null && att.getShortName().equals("description")) {
                    this.desc = att.getStringValue();
                }
                if (this.desc != null || !att.getShortName().equals("standard_name")) continue;
                this.desc = att.getStringValue();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public int getRank() {
            return 0;
        }

        @Override
        public int[] getShape() {
            return new int[0];
        }

        @Override
        public List<Dimension> getDimensions() {
            return null;
        }

        @Override
        public DataType getDataType() {
            return this.dt;
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.atts;
        }

        @Override
        public Attribute findAttributeIgnoreCase(String name) {
            for (Attribute att : this.atts) {
                if (!att.getShortName().equalsIgnoreCase(name)) continue;
                return att;
            }
            return null;
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.name.compareTo(o.getShortName());
        }
    }
}

