/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsElectricPotential;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsElectricPotentialEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsElectricPotentialEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsElectricPotentialEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*YV\\s*", "YV");
        p.put("^\\s*ZV\\s*", "ZV");
        p.put("^\\s*EV\\s*", "EV");
        p.put("^\\s*PV\\s*", "PV");
        p.put("^\\s*TV\\s*", "TV");
        p.put("^\\s*GV\\s*", "GV");
        p.put("^\\s*MV\\s*", "MV");
        p.put("^\\s*kV\\s*", "kV");
        p.put("^\\s*hV\\s*", "hV");
        p.put("^\\s*daV\\s*", "daV");
        p.put("^\\s*V\\s*", "V");
        p.put("^\\s*dV\\s*", "dV");
        p.put("^\\s*cV\\s*", "cV");
        p.put("^\\s*mV\\s*", "mV");
        p.put("^\\s*\u00b5V\\s*", "\u00b5V");
        p.put("^\\s*nV\\s*", "nV");
        p.put("^\\s*pV\\s*", "pV");
        p.put("^\\s*fV\\s*", "fV");
        p.put("^\\s*aV\\s*", "aV");
        p.put("^\\s*zV\\s*", "zV");
        p.put("^\\s*yV\\s*", "yV");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsElectricPotential.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsElectricPotential", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(ElectricPotential inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<ElectricPotential> getBaseUnit(UnitsElectricPotential inModelUnit) {
        Unit<ElectricPotential> theResult = UNITS.VOLT;
        if (UnitsElectricPotential.YOTTAV.equals(inModelUnit)) {
            theResult = UNITS.YOTTAV;
        }
        if (UnitsElectricPotential.ZETTAV.equals(inModelUnit)) {
            theResult = UNITS.ZETTAV;
        }
        if (UnitsElectricPotential.EXAV.equals(inModelUnit)) {
            theResult = UNITS.EXAV;
        }
        if (UnitsElectricPotential.PETAV.equals(inModelUnit)) {
            theResult = UNITS.PETAV;
        }
        if (UnitsElectricPotential.TERAV.equals(inModelUnit)) {
            theResult = UNITS.TERAV;
        }
        if (UnitsElectricPotential.GIGAV.equals(inModelUnit)) {
            theResult = UNITS.GIGAV;
        }
        if (UnitsElectricPotential.MEGAV.equals(inModelUnit)) {
            theResult = UNITS.MEGAV;
        }
        if (UnitsElectricPotential.KV.equals(inModelUnit)) {
            theResult = UNITS.KV;
        }
        if (UnitsElectricPotential.HV.equals(inModelUnit)) {
            theResult = UNITS.HV;
        }
        if (UnitsElectricPotential.DAV.equals(inModelUnit)) {
            theResult = UNITS.DAV;
        }
        if (UnitsElectricPotential.V.equals(inModelUnit)) {
            theResult = UNITS.V;
        }
        if (UnitsElectricPotential.DV.equals(inModelUnit)) {
            theResult = UNITS.DV;
        }
        if (UnitsElectricPotential.CV.equals(inModelUnit)) {
            theResult = UNITS.CV;
        }
        if (UnitsElectricPotential.MV.equals(inModelUnit)) {
            theResult = UNITS.MV;
        }
        if (UnitsElectricPotential.MICROV.equals(inModelUnit)) {
            theResult = UNITS.MICROV;
        }
        if (UnitsElectricPotential.NV.equals(inModelUnit)) {
            theResult = UNITS.NV;
        }
        if (UnitsElectricPotential.PV.equals(inModelUnit)) {
            theResult = UNITS.PV;
        }
        if (UnitsElectricPotential.FV.equals(inModelUnit)) {
            theResult = UNITS.FV;
        }
        if (UnitsElectricPotential.AV.equals(inModelUnit)) {
            theResult = UNITS.AV;
        }
        if (UnitsElectricPotential.ZV.equals(inModelUnit)) {
            theResult = UNITS.ZV;
        }
        if (UnitsElectricPotential.YV.equals(inModelUnit)) {
            theResult = UNITS.YV;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> ElectricPotential getQuantity(T inValue, UnitsElectricPotential inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new ElectricPotential((Number)typedValue.getValue(), UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'ElectricPotential' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsElectricPotentialEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> ElectricPotential getQuantity(T inValue, UnitsElectricPotential inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new ElectricPotential(doubleValue, UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new ElectricPotential(intValue, UnitsElectricPotentialEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'ElectricPotential' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsElectricPotentialEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsElectricPotential.class;
    }
}

