/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Map;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsPressure;
import ome.xml.model.enums.UnitsTemperature;
import ome.xml.model.enums.handlers.UnitsPressureEnumHandler;
import ome.xml.model.enums.handlers.UnitsTemperatureEnumHandler;
import ome.xml.model.primitives.PercentFraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImagingEnvironment
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagingEnvironment.class);
    private PercentFraction co2Percent;
    private Temperature temperature;
    private Pressure airPressure;
    private PercentFraction humidity;
    private Map map;

    public ImagingEnvironment() {
    }

    public ImagingEnvironment(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ImagingEnvironment(ImagingEnvironment orig) {
        this.co2Percent = orig.co2Percent;
        this.temperature = orig.temperature;
        this.airPressure = orig.airPressure;
        this.humidity = orig.humidity;
        this.map = orig.map;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Map_nodeList;
        Double baseValue;
        Enum modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ImagingEnvironment".equals(tagName)) {
            LOGGER.debug("Expecting node name of ImagingEnvironment got {}", (Object)tagName);
        }
        if (element.hasAttribute("CO2Percent")) {
            this.setCO2Percent(PercentFraction.valueOf(element.getAttribute("CO2Percent")));
        }
        if (element.hasAttribute("Temperature")) {
            unitSymbol = element.getAttribute("TemperatureUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = ImagingEnvironment.getTemperatureUnitXsdDefault();
            }
            modelUnit = UnitsTemperature.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("Temperature"));
            if (baseValue != null) {
                this.setTemperature(UnitsTemperatureEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("AirPressure")) {
            unitSymbol = element.getAttribute("AirPressureUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = ImagingEnvironment.getAirPressureUnitXsdDefault();
            }
            modelUnit = UnitsPressure.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("AirPressure"));
            if (baseValue != null) {
                this.setAirPressure(UnitsPressureEnumHandler.getQuantity(baseValue, (UnitsPressure)modelUnit));
            }
        }
        if (element.hasAttribute("Humidity")) {
            this.setHumidity(PercentFraction.valueOf(element.getAttribute("Humidity")));
        }
        if ((Map_nodeList = ImagingEnvironment.getChildrenByTagName(element, "Map")).size() > 1) {
            throw new RuntimeException(String.format("Map node list size %d != 1", Map_nodeList.size()));
        }
        if (Map_nodeList.size() != 0) {
            this.setMap(new Map(Map_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public PercentFraction getCO2Percent() {
        return this.co2Percent;
    }

    public void setCO2Percent(PercentFraction co2Percent) {
        this.co2Percent = co2Percent;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    public Pressure getAirPressure() {
        return this.airPressure;
    }

    public void setAirPressure(Pressure airPressure) {
        this.airPressure = airPressure;
    }

    public static String getTemperatureUnitXsdDefault() {
        return "\u00b0C";
    }

    public PercentFraction getHumidity() {
        return this.humidity;
    }

    public void setHumidity(PercentFraction humidity) {
        this.humidity = humidity;
    }

    public static String getAirPressureUnitXsdDefault() {
        return "mbar";
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element ImagingEnvironment_element) {
        Enum enumUnits;
        if (ImagingEnvironment_element == null) {
            ImagingEnvironment_element = document.createElementNS(NAMESPACE, "ImagingEnvironment");
        }
        if (this.co2Percent != null) {
            ImagingEnvironment_element.setAttribute("CO2Percent", this.co2Percent.toString());
        }
        if (this.temperature != null) {
            if (this.temperature.value() != null) {
                ImagingEnvironment_element.setAttribute("Temperature", this.temperature.value().toString());
            }
            if (this.temperature.unit() != null) {
                try {
                    enumUnits = UnitsTemperature.fromString(this.temperature.unit().getSymbol());
                    ImagingEnvironment_element.setAttribute("TemperatureUnit", ((UnitsTemperature)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for ImagingEnvironment:TemperatureUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.airPressure != null) {
            if (this.airPressure.value() != null) {
                ImagingEnvironment_element.setAttribute("AirPressure", this.airPressure.value().toString());
            }
            if (this.airPressure.unit() != null) {
                try {
                    enumUnits = UnitsPressure.fromString(this.airPressure.unit().getSymbol());
                    ImagingEnvironment_element.setAttribute("AirPressureUnit", ((UnitsPressure)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for ImagingEnvironment:AirPressureUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.humidity != null) {
            ImagingEnvironment_element.setAttribute("Humidity", this.humidity.toString());
        }
        if (this.map != null) {
            ImagingEnvironment_element.appendChild(this.map.asXMLElement(document));
        }
        return super.asXMLElement(document, ImagingEnvironment_element);
    }
}

