/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import org.scijava.nativelib.NativeLibraryUtil;

public class SlideBook6Reader
extends FormatReader {
    public static final int SLD_MAGIC_BYTES_1_0 = 108;
    public static final int SLD_MAGIC_BYTES_1_1 = 256;
    public static final int SLD_MAGIC_BYTES_1_2 = 512;
    public static final int SLD_MAGIC_BYTES_2_0 = 501;
    public static final int SLD_MAGIC_BYTES_2_1 = 258;
    public static final long SLD_MAGIC_BYTES_3 = 4127260929L;
    private static final String URL_3I_SLD = "http://www.openmicroscopy.org/site/support/bio-formats/formats/3i-slidebook.html";
    private static final String NO_3I_MSG = "3i SlideBook SlideBook6Reader library not found. Please see http://www.openmicroscopy.org/site/support/bio-formats/formats/3i-slidebook.html for details.";
    private static final String GENERAL_3I_MSG = "3i SlideBook SlideBook6Reader library problem. Please see http://www.openmicroscopy.org/site/support/bio-formats/formats/3i-slidebook.html for details.";
    private static boolean initialized = false;
    private static boolean libraryFound = false;

    private static boolean isLibraryFound() {
        if (initialized) {
            return libraryFound;
        }
        try {
            NativeLibraryUtil.Architecture arch = NativeLibraryUtil.getArchitecture();
            if (arch != NativeLibraryUtil.Architecture.WINDOWS_64 && arch != NativeLibraryUtil.Architecture.WINDOWS_32) {
                throw new UnsatisfiedLinkError();
            }
            if (!libraryFound) {
                libraryFound = NativeLibraryUtil.loadNativeLibrary(SlideBook6Reader.class, "SlideBook6Reader");
            }
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.debug(NO_3I_MSG, e);
            libraryFound = false;
        }
        catch (SecurityException e) {
            LOGGER.warn("Insufficient permission to load native library", e);
            libraryFound = false;
        }
        initialized = true;
        return libraryFound;
    }

    public SlideBook6Reader() {
        super("SlideBook 6 SLD (native)", new String[]{"sld"});
        this.domains = new String[]{"Light Microscopy"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        stream.seek(4L);
        boolean littleEndian = stream.readString(2).equals("II");
        if (!FormatTools.validStream(stream, 8, littleEndian)) {
            return false;
        }
        short magicBytes1 = stream.readShort();
        short magicBytes2 = stream.readShort();
        boolean isMatch = !((magicBytes2 & 0xFF00) != 256 && (magicBytes2 & 0xFF00) != 512 || magicBytes1 != 108 && magicBytes1 != 501);
        return isMatch;
    }

    @Override
    public boolean isThisType(String file2, boolean open) {
        return super.isThisType(file2, open) && SlideBook6Reader.isLibraryFound();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = FormatTools.getZCTCoords(this, no);
        int bpc = FormatTools.getBytesPerPixel(this.getPixelType());
        byte[] b = new byte[FormatTools.getPlaneSize(this)];
        this.readImagePlaneBuf(b, this.getSeries(), 0, zct[2], zct[0], zct[1]);
        int pixel = bpc * this.getRGBChannelCount();
        int rowLen = w * pixel;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(b, pixel * ((row + y) * this.getSizeX() + x), buf, row * rowLen, rowLen);
        }
        if (this.isRGB()) {
            int bpp = this.getSizeC() * bpc;
            int line = w * bpp;
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    int base = row * line + col * bpp;
                    for (int bb = 0; bb < bpc; ++bb) {
                        byte blue = buf[base + bpc * (this.getSizeC() - 1) + bb];
                        buf[base + bpc * (this.getSizeC() - 1) + bb] = buf[base + bb];
                        buf[base + bb] = blue;
                    }
                }
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (initialized && SlideBook6Reader.isLibraryFound()) {
            this.closeFile();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            int capture;
            this.openFile(id);
            int numCaptures = this.getNumCaptures();
            int[] numPositions = new int[numCaptures];
            int[] numTimepoints = new int[numCaptures];
            int[] numZPlanes = new int[numCaptures];
            int[] numChannels = new int[numCaptures];
            for (capture = 0; capture < numCaptures; ++capture) {
                numPositions[capture] = this.getNumPositions(capture);
                numTimepoints[capture] = this.getNumTimepoints(capture) / numPositions[capture];
                numZPlanes[capture] = this.getNumZPlanes(capture);
                numChannels[capture] = this.getNumChannels(capture);
            }
            this.core.clear();
            for (capture = 0; capture < numCaptures; ++capture) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                this.setSeries(capture);
                ms.sizeX = this.getNumXColumns(capture);
                if (ms.sizeX % 2 != 0) {
                    ++ms.sizeX;
                }
                ms.sizeY = this.getNumYRows(capture);
                ms.sizeZ = numZPlanes[capture];
                ms.sizeT = numTimepoints[capture] * numPositions[capture];
                ms.sizeC = numChannels[capture];
                int bytes = this.getBytesPerPixel(capture);
                if (bytes % 3 == 0) {
                    ms.sizeC *= 3;
                    bytes /= 3;
                    ms.rgb = true;
                } else {
                    ms.rgb = false;
                }
                ms.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, true);
                ms.imageCount = ms.sizeZ * ms.sizeT;
                if (!ms.rgb) {
                    ms.imageCount *= ms.sizeC;
                }
                ms.interleaved = true;
                ms.littleEndian = true;
                ms.dimensionOrder = "XYCZT";
                ms.indexed = false;
                ms.falseColor = false;
            }
            this.setSeries(0);
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels(store, this, true);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                String instrumentID = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrumentID, 0);
                for (int capture2 = 0; capture2 < numCaptures; ++capture2) {
                    Length physicalSizeZ;
                    store.setImageInstrumentRef(instrumentID, capture2);
                    String imageName = this.getImageName(capture2);
                    store.setImageName(imageName, capture2);
                    String imageDescription = this.getImageComments(capture2);
                    store.setImageDescription(imageDescription, capture2);
                    double voxelsize = this.getVoxelSize(capture2);
                    Length physicalSizeX = FormatTools.getPhysicalSizeX(voxelsize);
                    Length physicalSizeY = FormatTools.getPhysicalSizeY(voxelsize);
                    if (physicalSizeX != null) {
                        store.setPixelsPhysicalSizeX(physicalSizeX, capture2);
                    }
                    if (physicalSizeY != null) {
                        store.setPixelsPhysicalSizeY(physicalSizeY, capture2);
                    }
                    double stepSize = 0.0;
                    if (numZPlanes[capture2] > 1) {
                        double plane0 = this.getZPosition(capture2, 0, 0);
                        double plane1 = this.getZPosition(capture2, 0, 1);
                        stepSize = Math.abs(plane1 - plane0);
                    }
                    if ((physicalSizeZ = FormatTools.getPhysicalSizeZ(stepSize)) != null) {
                        store.setPixelsPhysicalSizeZ(physicalSizeZ, capture2);
                    }
                    int imageIndex = 0;
                    for (int timepoint = 0; timepoint < numTimepoints[capture2]; ++timepoint) {
                        int deltaT = this.getElapsedTime(capture2, timepoint);
                        for (int position = 0; position < numPositions[capture2]; ++position) {
                            for (int zplane = 0; zplane < numZPlanes[capture2]; ++zplane) {
                                int channel = 0;
                                while (channel < numChannels[capture2]) {
                                    store.setPlaneDeltaT(new Time(deltaT, UNITS.MS), capture2, imageIndex);
                                    int expTime = this.getExposureTime(capture2, channel);
                                    store.setPlaneExposureTime(new Time(expTime, UNITS.MS), capture2, imageIndex);
                                    double numberX = this.getXPosition(capture2, position);
                                    Length positionX = new Length(numberX, UNITS.MICROM);
                                    store.setPlanePositionX(positionX, capture2, imageIndex);
                                    double numberY = this.getYPosition(capture2, position);
                                    Length positionY = new Length(numberY, UNITS.MICROM);
                                    store.setPlanePositionY(positionY, capture2, imageIndex);
                                    double positionZ = this.getZPosition(capture2, position, zplane);
                                    Length zPos = new Length(positionZ, UNITS.MICROM);
                                    store.setPlanePositionZ(zPos, capture2, imageIndex);
                                    ++channel;
                                    ++imageIndex;
                                }
                            }
                        }
                    }
                    for (int channel = 0; channel < numChannels[capture2]; ++channel) {
                        String theChannelName = this.getChannelName(capture2, channel);
                        store.setChannelName(theChannelName.trim(), capture2, channel);
                    }
                }
                int objectiveIndex = 0;
                for (int capture3 = 0; capture3 < numCaptures; ++capture3) {
                    String objectiveID = MetadataTools.createLSID("Objective", 0, objectiveIndex);
                    store.setObjectiveID(objectiveID, 0, objectiveIndex);
                    store.setObjectiveSettingsID(objectiveID, capture3);
                    String objective = this.getLensName(capture3);
                    if (objective != null) {
                        store.setObjectiveModel(objective, 0, objectiveIndex);
                    }
                    store.setObjectiveCorrection(this.getCorrection("Other"), 0, objectiveIndex);
                    store.setObjectiveImmersion(this.getImmersion("Other"), 0, objectiveIndex);
                    double magnification = this.getMagnification(capture3);
                    if (magnification > 0.0) {
                        store.setObjectiveNominalMagnification(magnification, 0, objectiveIndex);
                    }
                    ++objectiveIndex;
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new MissingLibraryException(GENERAL_3I_MSG, e);
        }
        catch (Exception e) {
            throw new MissingLibraryException(GENERAL_3I_MSG, e);
        }
    }

    public native boolean openFile(String var1);

    public native void closeFile();

    public native int getNumCaptures();

    public native int getNumPositions(int var1);

    public native int getNumTimepoints(int var1);

    public native int getNumChannels(int var1);

    public native int getNumXColumns(int var1);

    public native int getNumYRows(int var1);

    public native int getNumZPlanes(int var1);

    public native int getElapsedTime(int var1, int var2);

    public native int getExposureTime(int var1, int var2);

    public native float getVoxelSize(int var1);

    public native double getXPosition(int var1, int var2);

    public native double getYPosition(int var1, int var2);

    public native double getZPosition(int var1, int var2, int var3);

    public native int getMontageRow(int var1, int var2);

    public native int getMontageColumn(int var1, int var2);

    public native String getChannelName(int var1, int var2);

    public native String getLensName(int var1);

    public native double getMagnification(int var1);

    public native String getImageName(int var1);

    public native String getImageComments(int var1);

    public native int getBytesPerPixel(int var1);

    public native boolean readImagePlaneBuf(byte[] var1, int var2, int var3, int var4, int var5, int var6);
}

