/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackTools {
    private LogbackTools() {
    }

    public static synchronized boolean enableLogging(String level) {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = root.getLoggerContext();
        if (!root.iteratorForAppenders().hasNext()) {
            context.reset();
            PatternLayoutEncoder layout = new PatternLayoutEncoder();
            layout.setContext(context);
            layout.setPattern("%m%n");
            layout.start();
            ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
            appender.setContext(context);
            appender.setEncoder(layout);
            appender.start();
            root.addAppender((Appender<ILoggingEvent>)appender);
        } else {
            Appender<ILoggingEvent> defaultAppender = root.iteratorForAppenders().next();
            if (defaultAppender instanceof ConsoleAppender) {
                context.reset();
                PatternLayoutEncoder layout = new PatternLayoutEncoder();
                layout.setContext(context);
                layout.setPattern("%m%n");
                layout.start();
                defaultAppender.setContext(context);
                ((ConsoleAppender)defaultAppender).setEncoder(layout);
                defaultAppender.start();
                root.addAppender(defaultAppender);
            }
        }
        root.setLevel(Level.toLevel(level));
        return true;
    }

    public static synchronized void enableIJLogging(boolean debug, Appender<ILoggingEvent> appender) {
        try {
            Logger logger = LoggerFactory.getLogger("ROOT");
            if (!(logger instanceof ch.qos.logback.classic.Logger)) {
                return;
            }
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)logger;
            if (debug) {
                root.setLevel(Level.DEBUG);
            } else {
                root.setLevel(Level.INFO);
            }
            appender.setContext(root.getLoggerContext());
            root.addAppender(appender);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

