file.names <- dir("./", pattern = "counts.txt")
for(i in 1:length(file.names)){
p <- read.table(file.names[i],header=TRUE,sep = "\t", stringsAsFactor = FALSE)
q <- p[, c(1,7)]
if(i==1){
out <- q} else{
out <- merge(out, q, by = "Geneid")
}}
file.names
names(out)[2] <- paste("KO_NO_C1")
names(out)[3] <- paste("KO_NO_C3")
names(out)[4] <- paste("KO_VP_C1")
names(out)[5] <- paste("KO_VP_C3")
names(out)[6] <- paste("WT_NO_C11")
names(out)[7] <- paste("WT_NO_C12")
names(out)[8] <- paste("WT_VP_C11")
names(out)[9] <- paste("WT_VP_C12")
out <- unique(out)
write.table(out, "VP_Raw_counts.txt", sep = "\t", row.names = FALSE, quote = FALSE)
cts <- data.frame(out, row.names = 1)
cts <- round(cts)
suppressMessages(library(DESeq2))
files = c("KO_NO_C1", "KO_NO_C3", "KO_VP_C1", "KO_VP_C3", "WT_NO_C11", "WT_NO_C12", "WT_VP_C11", "WT_VP_C12")
condition = c("KO_NO_C", "KO_NO_C", "KO_VP_C", "KO_VP_C", "WT_NO_C1", "WT_NO_C1", "WT_VP_C1", "WT_VP_C1")
sampleTable <- data.frame(sampleName = files, condition = condition)
dds <- DESeqDataSetFromMatrix(countData = cts, colData = sampleTable, design = ~ condition)
dds <- DESeq(dds)
norm <- counts(dds, normalized = TRUE)
write.table(norm, "Normalized_counts.txt", sep = "\t", quote = FALSE)

ka <- norm[, c(1:4)]
ka <- round(ka)
file1 <- c("KO_NO_C1", "KO_NO_C3", "KO_VP_C1", "KO_VP_C3")
condition1 <- c("KO_NO_C", "KO_NO_C", "KO_VP_C", "KO_VP_C")
sampleTable <- data.frame(sampleName = file1, condition = condition1)
dds <- DESeqDataSetFromMatrix(countData = ka, colData = sampleTable, design = ~ condition)
sizeFactors(dds) = 1
dds$condition <- relevel(dds$condition, "KO_NO_C")
dds <- DESeq(dds)
res <- results(dds)
write.csv(res, "DESeq2_KO_VP_vs_NO.csv")
k <- read.csv("DESeq2_KO_VP_vs_NO.csv", stringsAsFactor = FALSE, row.names = 1)
kn <- merge(k, norm, by = "row.names")
kn <- unique(kn)
write.csv(kn, "DESeq2_KO_VP_vs_NO_norm_counts.csv")
b <- read.table("Normalized_counts_miR_above_10_reads_avg.txt", sep = "\t", stringsAsFactor = FALSE, header = TRUE)
b1 <- b$Row.names
b1 <- data.frame(b1)
names(b1)[1] <- paste("Row.names")
ab <- merge(kn, b1, by = "Row.names")
ab <- unique(ab)
ab$log_pval <- -log(ab$pvalue, 10)
ab$label <- ifelse((ab$log2FoldChange >= 0.5),"Up-regulated", ifelse((ab$log2FoldChange<=-0.5), "Down-regulated", "No-change"))
library(ggplot2)
write.csv(ab, "DESeq2_miRNAs_KO_VP_NO_above_avg_volcano.csv")
pdf ("DESeq2_miRNAs_KO_VP_NO_above_avg_volcano.pdf")
ggplot(ab, aes(x=log2FoldChange, y=log_pval)) + theme_bw() + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) + geom_point(aes(colour = label)) + scale_colour_manual(values = c("Up-regulated"= "blue", "Down-regulated"="red",  "No-change"= "black"))
dev.off()


wa <- norm[, c(5:8)]
wa <- round(wa)
file2 <- c("WT_NO_C11", "WT_NO_C12", "WT_VP_C11", "WT_VP_C12")
condition2 <- c("WT_NO_C1", "WT_NO_C1", "WT_VP_C1", "WT_VP_C1")
sampleTable <- data.frame(sampleName = file2, condition = condition2)
dds <- DESeqDataSetFromMatrix(countData = wa, colData = sampleTable, design = ~ condition)
sizeFactors(dds) = 1
dds$condition <- relevel(dds$condition, "WT_NO_C1")
dds <- DESeq(dds)
res <- results(dds)
write.csv(res, "DESeq2_WT_VP_vs_NO.csv")
k <- read.csv("DESeq2_WT_VP_vs_NO.csv", stringsAsFactor = FALSE, row.names = 1)
kn <- merge(k, norm, by = "row.names")
kn <- unique(kn)
write.csv(kn, "DESeq2_WT_VP_vs_NO_norm_counts.csv")
b <- read.table("Normalized_counts_miR_above_10_reads_avg.txt", sep = "\t", stringsAsFactor = FALSE, header = TRUE)
b1 <- b$Row.names
b1 <- data.frame(b1)
names(b1)[1] <- paste("Row.names")
ab <- merge(kn, b1, by = "Row.names")
ab <- unique(ab)
ab$log_pval <- -log(ab$pvalue, 10)
ab$label <- ifelse((ab$log2FoldChange >= 1),"Up-regulated", ifelse((ab$log2FoldChange<=-1), "Down-regulated", "No-change"))
library(ggplot2)
write.csv(ab, "DESeq2_miRNAs_WT_VP_NO_above_avg_volcano.csv")
pdf ("DESeq2_miRNAs_WT_VP_NO_above_avg_volcano.pdf")
ggplot(ab, aes(x=log2FoldChange, y=log_pval)) + theme_bw() + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) + geom_point(aes(colour = label)) + scale_colour_manual(values = c("Up-regulated"= "blue", "Down-regulated"="red",  "No-change"= "black"))
dev.off()

