a <- read.csv("DESeq2_WT_VP_vs_NO_padj005_protcod_norm_counts.csv", stringsAsFactor = FALSE)
a <- unique(a)
a$log_padj <- -log(a$padj, 10)
a$label <- ifelse(a$log2FoldChange >= 0.5,"Up-regulated", ifelse(a$log2FoldChange<=-0.5 , "Down-regulated", "No-change"))
write.csv(a, "test.csv")
library(ggplot2)
pdf ("DESeq2_WT_VP_NO_padj005_norm_counts_volcano.pdf")
ggplot(a, aes(x=log2FoldChange, y=log_padj)) + theme_bw() + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) + geom_point(aes(colour = label)) + scale_colour_manual(values = c("Up-regulated"= "blue", "Down-regulated"="red",  "No-change"= "black"))
dev.off()

a <- read.csv("DESeq2_KO_VP_vs_NO_padj005_protcod_norm_counts.csv", stringsAsFactor = FALSE)
a <- unique(a)
a$log_padj <- -log(a$padj, 10)
a$label <- ifelse(a$log2FoldChange >= 0.5,"Up-regulated", ifelse(a$log2FoldChange<=-0.5 , "Down-regulated", "No-change"))
library(ggplot2)
pdf ("DESeq2_KO_VP_NO_padj005_norm_counts_volcano.pdf")
ggplot(a, aes(x=log2FoldChange, y=log_padj)) + theme_bw() + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) + geom_point(aes(colour = label)) + scale_colour_manual(values = c("Up-regulated"= "blue", "Down-regulated"="red",  "No-change"= "black"))
dev.off()
