library(ggplot2)
library(splitstackshape)
m <- read.csv("Single_silenced_genes.csv", stringsAsFactor = FALSE)
m11 <- m$Genes
m11 <- data.frame(m11)
names(m11)[1] <- paste("NAME")
a <- read.table("T98_EZH2_HsAbcam1.b50.score.width.tss.pergene.EZrep.txt", sep = "\t", header = TRUE, stringsAsFactor = FALSE)
a <- read.table("T98_EZH2_HsAbcam1.b50.score.width.tss.pergene.EZrep.txt", sep = "\t", header = TRUE, stringsAsFactor = FALSE)
a <- cSplit(a, "NAME", sep = "_")
a <- data.frame(a)
a <- a[, -c(1, 202)]
names(a)[201] <- paste("NAME")
ma1 <- merge(a, m11, by = "NAME")
ma1 <- ma1[, -c(1,2)]
mat <- t(ma1)
h <- apply(as.matrix(mat), 1, function(x){mean(x)+c(-1.96,0,1.96)*sd(x)/sqrt(length(x))})
h <- data.frame(h)
ht <- t(h)
ht <- data.frame(ht)
names(ht)[1] <- paste("lower")
names(ht)[2] <- paste("mean")
names(ht)[3] <- paste("upper")
ht$type <- paste("Single_round")
ht$X <- 1:nrow(ht)
p <- ht
m <- read.csv("Double_silenced_genes.csv", stringsAsFactor = FALSE)
m11 <- m$Genes
m11 <- data.frame(m11)
names(m11)[1] <- paste("NAME")
ma1 <- merge(a, m11, by = "NAME")
ma1 <- ma1[, -c(1,2)]
mat <- t(ma1)
h <- apply(as.matrix(mat), 1, function(x){mean(x)+c(-1.96,0,1.96)*sd(x)/sqrt(length(x))})
h <- data.frame(h)
ht <- t(h)
ht <- data.frame(ht)
names(ht)[1] <- paste("lower")
names(ht)[2] <- paste("mean")
names(ht)[3] <- paste("upper")
ht$type <- paste("Double_round")
ht$X <- 1:nrow(ht)
q <- rbind(p, ht)
write.csv(q, "EZH2_ChIP_single_double_genes_avg_plot.csv")
pdf("EZH2_ChIP_single_double_genes_avg_plot.pdf")
p<-ggplot(data=q, aes(x=X, y=mean, colour = type)) + geom_line(size =1)
p + theme_bw() + geom_ribbon(aes(ymin=lower, ymax=upper, fill = type), linetype=0, alpha=0.5) + scale_color_manual(values=c("yellow3", "darkcyan")) + scale_fill_manual(values=c("yellow3", "darkcyan"))
dev.off()

m <- read.csv("Single_silenced_genes.csv", stringsAsFactor = FALSE)
m11 <- m$Genes
m11 <- data.frame(m11)
names(m11)[1] <- paste("NAME")
a <- read.table("T98_H3k27me3_HsCmb.b50.score.width.tss.pergene.EZrep.txt", sep = "\t", header = TRUE, stringsAsFactor = FALSE)
a <- cSplit(a, "NAME", sep = "_")
a <- data.frame(a)
a <- a[, -c(1, 202)]
names(a)[201] <- paste("NAME")
ma1 <- merge(a, m11, by = "NAME")
ma1 <- ma1[, -c(1,2)]
mat <- t(ma1)
h <- apply(as.matrix(mat), 1, function(x){mean(x)+c(-1.96,0,1.96)*sd(x)/sqrt(length(x))})
h <- data.frame(h)
ht <- t(h)
ht <- data.frame(ht)
names(ht)[1] <- paste("lower")
names(ht)[2] <- paste("mean")
names(ht)[3] <- paste("upper")
ht$type <- paste("Single_round")
ht$X <- 1:nrow(ht)
p <- ht
m <- read.csv("Double_silenced_genes.csv", stringsAsFactor = FALSE)
m11 <- m$Genes
m11 <- data.frame(m11)
names(m11)[1] <- paste("NAME")
ma1 <- merge(a, m11, by = "NAME")
ma1 <- ma1[, -c(1,2)]
mat <- t(ma1)
h <- apply(as.matrix(mat), 1, function(x){mean(x)+c(-1.96,0,1.96)*sd(x)/sqrt(length(x))})
h <- data.frame(h)
ht <- t(h)
ht <- data.frame(ht)
names(ht)[1] <- paste("lower")
names(ht)[2] <- paste("mean")
names(ht)[3] <- paste("upper")
ht$type <- paste("Double_round")
ht$X <- 1:nrow(ht)
q <- rbind(p, ht)
write.csv(q, "H3K27me3_ChIP_single_double_genes_avg_plot.csv")
pdf("H3K27me3_ChIP_single_double_genes_avg_plot.pdf")
p<-ggplot(data=q, aes(x=X, y=mean, colour = type)) + geom_line(size =1)
p + theme_bw() + geom_ribbon(aes(ymin=lower, ymax=upper, fill = type), linetype=0, alpha=0.5) + scale_color_manual(values=c("yellow3", "darkcyan")) + scale_fill_manual(values=c("yellow3", "darkcyan"))
dev.off()
