source_folder="L:/members/Schon/Writing/nanoPARE/data_generated/captype_metaplots/"

pdf('feature_locations_xrn4_noncapped.pdf')
par(mfrow=c(5,1),mar=c(0,2,0,1))

qcol = colorRampPalette(c('blue','gray','red'))(5)

for(qtile in 1:5){
# for(qtile in c(1)){
  nc_5 = as.numeric(scan(paste(source_folder,'metaplot.noncapped.5UTR.nc_Q',qtile,'.txt',sep=''),'character',comment.char = '#'))
  nc_C = as.numeric(scan(paste(source_folder,'metaplot.noncapped.CDS.nc_Q',qtile,'.txt',sep=''),'character',comment.char = '#'))
  nc_3 = as.numeric(scan(paste(source_folder,'metaplot.noncapped.3UTR.nc_Q',qtile,'.txt',sep=''),'character',comment.char = '#'))
  
  vertlines = cumsum(c(length(nc_5),length(nc_C),length(nc_3)))
  barplot(
    c(nc_5,nc_C,nc_3),
    space=0,col=qcol[qtile],
    ylim=c(0,80),border = NA,las=1,main=qtile
  )
  text(vertlines,rep(50,5),c(sum(nc_5),sum(nc_C),sum(nc_3)))
  abline(v=vertlines,h=0)
}
dev.off()

