uuN = read.table('../data_tables/untemplated_nucleotides.tsv',stringsAsFactors = F,row.names = 1,header = T)
uuN = uuN[,2:5]/uuN[,1]
colnames(uuN) = c('A','C','G','T')
# uuN = uuN[picked_rows,]
groups = list()
groups[['5ng']] = c('fb1_1to1','fb2_1to1','fb3_1to1')
groups[['5ng_xrn1']] = c('xrn1_fb_1','xrn1_fb_2','xrn1_fb_3')
groups[['5ng_xrn4']] = c('xrn4_M_1','xrn4_M_2','xrn4_M_3')
groups[['10ug']] = c('Col-10ug_1','Col-10ug_2','Col-10ug_3')
groups[['1ng']] = c('1ng_fb_1','1ng_fb_2','1ng_fb_3')
groups[['100pg']] = c('100pg_fb_1','100pg_fb_2','100pg_fb_3')
groups[['10pg']] = c('10pg_fb_1','10pg_fb_2','10pg_fb_3')

plotcolors=c(A='#00C800',C='#0064FF',G='#FF7F00',T='#C80000')
library(beeswarm)
pdf('untemp_freqs.pdf',useDingbats = F,width = 4,height = 3,pointsize = 8)
par(mfrow=c(1,length(names(groups))),mar=c(4,0,0,0),oma=c(0,4,2,2),lend='square',ljoin='mitre')
for(group in names(groups)){
  untemp_frequencies = list()
  for(n in c('A','C','G','T')){
    untemp_frequencies[[n]] = uuN[groups[[group]],n]
  }
  
  beeswarm(untemp_frequencies,col=plotcolors,pch=20,cex=1.5,ylim=c(0,.5),spacing = .5,las=1,axes=F,xlab=group)
  axis(1,1:4,c('A','C','G','T'))
  if(group == names(groups)[1]){
    axis(2,seq(0,.5,.1),las=1)
  }
  abline(h=0)
  abline(v=4.5,col='gray')
  par(mar=c(4,0,0,0))
}
dev.off()