data_directory = '../data_tables/'
fb_C_5 = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.capped.5UTR.fb.txt',sep=''),'character',comment.char = '#'))
fb_C_C = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.capped.CDS.fb.txt',sep=''),'character',comment.char = '#'))
fb_C_3 = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.capped.3UTR.fb.txt',sep=''),'character',comment.char = '#'))

fb_N_5 = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.noncapped.5UTR.fb.txt',sep=''),'character',comment.char = '#'))
fb_N_C = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.noncapped.CDS.fb.txt',sep=''),'character',comment.char = '#'))
fb_N_3 = as.numeric(scan(paste(data_directory,'captype_metaplots/metaplot.noncapped.3UTR.fb.txt',sep=''),'character',comment.char = '#'))

vertlines = cumsum(c(length(fb_C_5),length(fb_C_C),length(fb_C_3)))
pdf('FIG2E.feature_locations.pdf')

par(mfrow=c(2,1))
barplot(c(fb_C_5,fb_C_C,fb_C_3),space=0,col="#1C75BC",ylim=c(0,4000),border = NA,las=1,main='Capped (Xrn1-)')
text(vertlines,rep(1000,5),c(sum(fb_C_5),sum(fb_C_C),sum(fb_C_3)))
abline(v=vertlines,h=0)

barplot(c(fb_N_5,fb_N_C,fb_N_3),space=0,col="#F7941E",ylim=c(0,100),border = NA,las=1,main='Noncapped (Xrn1-)')
text(vertlines,rep(50,5),c(sum(fb_N_5),sum(fb_N_C),sum(fb_N_3)))
abline(v=vertlines,h=0)
dev.off()

