nanoPARE_colors = c(BODY='#808285',CAP='#1C75BC',UNCAP="#F7941E",DIGEST='',XRN4='')
decorator='W'
data_directory = '../data_tables/'

s = 'fb'

allbed = read.table(paste(data_directory,'fb.W.5P.bed',sep=''),stringsAsFactors = F)
rownames(allbed) = allbed[,4]
capped_bed = allbed[grep('\\.capped\\.',rownames(allbed),value = T),]
noncapped_bed = allbed[grep('\\.noncapped\\.',rownames(allbed),value = T),]

genes_with_capped = capped_bed[capped_bed[,9]%in%c('P','S','D','I'),7]
genes_with_noncapped = noncapped_bed[noncapped_bed[,9]%in%c('P','S','D','I'),7]

genes_with_capped_500 = unique(capped_bed[capped_bed[,9]%in%c('U','P','S','D','I'),7])
genes_with_noncapped_500 = unique(noncapped_bed[noncapped_bed[,9]%in%c('U','P','S','D','I'),7])

picked_names = c('protein_coding','other_rna','mirna','snorna','snrna','pre-trna','rrna')
all_genetypes = table(gene_types[,1])[picked_names]
capped_genetypes = table(gene_types[unique(genes_with_capped),1])[picked_names]
capped_genetypes_500 = table(gene_types[unique(genes_with_capped_500),1])[picked_names]
noncapped_genetypes = table(gene_types[unique(genes_with_noncapped),1])[picked_names]
noncapped_genetypes_500 = table(gene_types[unique(genes_with_noncapped_500),1])[picked_names]

barplotmat = rbind(capped_genetypes / all_genetypes, noncapped_genetypes / all_genetypes)
barplotmat500 = rbind(capped_genetypes_500 / all_genetypes, noncapped_genetypes_500 / all_genetypes)

pdf(paste('FIG2D.',s,'.features_by_gene_type.',decorator,'.pdf',sep=''),useDingbats = F)
par(mar=c(8,5,4,2))
barplot(
  barplotmat,
  beside = T,
  col=nanoPARE_colors[c('CAP','UNCAP')],
  ylim = c(0,1),
  border = NA,
  las=2,
  axes = F,
  main="Features by gene type",
  ylab="Percent with overlapping feature")

barplot(
  barplotmat500,
  beside = T,
  col=adjustcolor(nanoPARE_colors[c('CAP','UNCAP')],alpha.f = .25),
  ylim = c(0,1),
  border = NA,
  las=2,
  axes = F,
  main="Features by gene type",
  ylab="Percent with overlapping feature", add = T)
axis(2,seq(0,1,.2),seq(0,100,20),las=1)
abline(h=0)
dev.off()

